<?php

declare(strict_types=1);

/**
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 *
 * OpenSearch PHP client
 *
 * @link      https://github.com/opensearch-project/opensearch-php/
 * @copyright Copyright (c) Elasticsearch B.V (https://www.elastic.co)
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @license   https://www.gnu.org/licenses/lgpl-2.1.html GNU Lesser General Public License, Version 2.1
 *
 * Licensed to Elasticsearch B.V under one or more agreements.
 * Elasticsearch B.V licenses this file to you under the Apache 2.0 License or
 * the GNU Lesser General Public License, Version 2.1, at your option.
 * See the LICENSE file in the project root for more information.
 */

namespace OpenSearch\Namespaces;

use OpenSearch\Namespaces\AbstractNamespace;

/**
 * Class CatNamespace
 *
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class CatNamespace extends AbstractNamespace
{
    /**
     * Shows information about currently configured aliases to indices including filter and routing infos.
     *
     * $params['name']             = (array) A comma-separated list of aliases to retrieve. Supports wildcards (`*`).  To retrieve all aliases, omit this parameter or use `*` or `_all`.
     * $params['expand_wildcards'] = (any) Whether to expand wildcard expression to concrete indices that are open, closed or both.
     * $params['format']           = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']                = (array) Comma-separated list of column names to display.
     * $params['help']             = (boolean) Return help information. (Default = false)
     * $params['local']            = (boolean) Return local information, do not retrieve the state from cluster-manager node. (Default = false)
     * $params['s']                = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['v']                = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']           = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']            = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']      = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']           = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']      = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function aliases(array $params = [])
    {
        $name = $this->extractArgument($params, 'name');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Aliases');
        $endpoint->setParams($params);
        $endpoint->setName($name);

        return $this->performRequest($endpoint);
    }
    /**
     * Lists all active point-in-time segments.
     *
     * $params['bytes']       = (enum) The unit in which to display byte values. (Options = b,g,gb,k,kb,m,mb,p,pb,t,tb)
     * $params['format']      = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']           = (array) Comma-separated list of column names to display.
     * $params['help']        = (boolean) Return help information. (Default = false)
     * $params['s']           = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['v']           = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function allPitSegments(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\AllPitSegments');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Provides a snapshot of how many shards are allocated to each data node and how much disk space they are using.
     *
     * $params['node_id']                 = (array) Comma-separated list of node identifiers or names used to limit the returned information.
     * $params['bytes']                   = (enum) The unit used to display byte values. (Options = b,g,gb,k,kb,m,mb,p,pb,t,tb)
     * $params['cluster_manager_timeout'] = (string) Operation timeout for connection to cluster-manager node.
     * $params['format']                  = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']                       = (array) Comma-separated list of column names to display.
     * $params['help']                    = (boolean) Return help information. (Default = false)
     * $params['local']                   = (boolean) Return local information, do not retrieve the state from cluster-manager node. (Default = false)
     * $params['master_timeout']          = (string) Operation timeout for connection to master node.
     * $params['s']                       = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['v']                       = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']                   = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function allocation(array $params = [])
    {
        $node_id = $this->extractArgument($params, 'node_id');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Allocation');
        $endpoint->setParams($params);
        $endpoint->setNodeId($node_id);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns information about the cluster-manager node.
     *
     * $params['cluster_manager_timeout'] = (string) Operation timeout for connection to cluster-manager node.
     * $params['format']                  = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']                       = (array) Comma-separated list of column names to display.
     * $params['help']                    = (boolean) Return help information. (Default = false)
     * $params['local']                   = (boolean) Return local information, do not retrieve the state from cluster-manager node. (Default = false)
     * $params['master_timeout']          = (string) Operation timeout for connection to master node.
     * $params['s']                       = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['v']                       = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']                   = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function clusterManager(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\ClusterManager');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Provides quick access to the document count of the entire cluster, or individual indices.
     *
     * $params['index']       = (array) Comma-separated list of data streams, indices, and aliases used to limit the request. Supports wildcards (`*`). To target all data streams and indices, omit this parameter or use `*` or `_all`.
     * $params['format']      = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']           = (array) Comma-separated list of column names to display.
     * $params['help']        = (boolean) Return help information. (Default = false)
     * $params['s']           = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['v']           = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function count(array $params = [])
    {
        $index = $this->extractArgument($params, 'index');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Count');
        $endpoint->setParams($params);
        $endpoint->setIndex($index);

        return $this->performRequest($endpoint);
    }
    /**
     * Shows how much heap memory is currently being used by fielddata on every data node in the cluster.
     *
     * $params['fields']      = (array) Comma-separated list of fields used to limit returned information. To retrieve all fields, omit this parameter.
     * $params['bytes']       = (enum) The unit used to display byte values. (Options = b,g,gb,k,kb,m,mb,p,pb,t,tb)
     * $params['format']      = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']           = (array) Comma-separated list of column names to display.
     * $params['help']        = (boolean) Return help information. (Default = false)
     * $params['s']           = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['v']           = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function fielddata(array $params = [])
    {
        $fields = $this->extractArgument($params, 'fields');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Fielddata');
        $endpoint->setParams($params);
        $endpoint->setFields($fields);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns a concise representation of the cluster health.
     *
     * $params['format']      = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']           = (array) Comma-separated list of column names to display.
     * $params['help']        = (boolean) Return help information. (Default = false)
     * $params['s']           = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['time']        = (enum) The unit used to display time values. (Options = d,h,m,micros,ms,nanos,s)
     * $params['ts']          = (boolean) If true, returns `HH:MM:SS` and Unix epoch timestamps. (Default = true)
     * $params['v']           = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function health(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Health');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns help for the Cat APIs.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function help(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Help');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns information about indices: number of primaries and replicas, document counts, disk size, ...
     *
     * $params['index']                     = (array) Comma-separated list of data streams, indices, and aliases used to limit the request. Supports wildcards (`*`). To target all data streams and indices, omit this parameter or use `*` or `_all`.
     * $params['bytes']                     = (enum) The unit used to display byte values. (Options = b,g,gb,k,kb,m,mb,p,pb,t,tb)
     * $params['cluster_manager_timeout']   = (string) Operation timeout for connection to cluster-manager node.
     * $params['expand_wildcards']          = (any) The type of index that wildcard patterns can match.
     * $params['format']                    = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']                         = (array) Comma-separated list of column names to display.
     * $params['health']                    = (enum) The health status used to limit returned indices. By default, the response includes indices of any health status. (Options = green,red,yellow)
     * $params['help']                      = (boolean) Return help information. (Default = false)
     * $params['include_unloaded_segments'] = (boolean) If true, the response includes information from segments that are not loaded into memory. (Default = false)
     * $params['local']                     = (boolean) Return local information, do not retrieve the state from cluster-manager node. (Default = false)
     * $params['master_timeout']            = (string) Operation timeout for connection to master node.
     * $params['pri']                       = (boolean) If true, the response only includes information from primary shards. (Default = false)
     * $params['s']                         = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['time']                      = (enum) The unit used to display time values. (Options = d,h,m,micros,ms,nanos,s)
     * $params['v']                         = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']                    = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']                     = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']               = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']                    = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']               = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function indices(array $params = [])
    {
        $index = $this->extractArgument($params, 'index');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Indices');
        $endpoint->setParams($params);
        $endpoint->setIndex($index);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns information about the cluster-manager node.
     *
     * $params['cluster_manager_timeout'] = (string) Operation timeout for connection to cluster-manager node.
     * $params['format']                  = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']                       = (array) Comma-separated list of column names to display.
     * $params['help']                    = (boolean) Return help information. (Default = false)
     * $params['local']                   = (boolean) Return local information, do not retrieve the state from cluster-manager node. (Default = false)
     * $params['master_timeout']          = (string) Operation timeout for connection to master node.
     * $params['s']                       = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['v']                       = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']                   = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function master(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Master');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns information about custom node attributes.
     *
     * $params['cluster_manager_timeout'] = (string) Operation timeout for connection to cluster-manager node.
     * $params['format']                  = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']                       = (array) Comma-separated list of column names to display.
     * $params['help']                    = (boolean) Return help information. (Default = false)
     * $params['local']                   = (boolean) Return local information, do not retrieve the state from cluster-manager node. (Default = false)
     * $params['master_timeout']          = (string) Operation timeout for connection to master node.
     * $params['s']                       = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['v']                       = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']                   = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function nodeattrs(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\NodeAttrs');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns basic statistics about performance of cluster nodes.
     *
     * $params['bytes']                   = (enum) The unit used to display byte values. (Options = b,g,gb,k,kb,m,mb,p,pb,t,tb)
     * $params['cluster_manager_timeout'] = (string) Operation timeout for connection to cluster-manager node.
     * $params['format']                  = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['full_id']                 = (any) If `true`, return the full node ID. If `false`, return the shortened node ID. (Default = )
     * $params['h']                       = (array) Comma-separated list of column names to display.
     * $params['help']                    = (boolean) Return help information. (Default = false)
     * $params['local']                   = (boolean) Return local information, do not retrieve the state from cluster-manager node. (Default = false)
     * $params['master_timeout']          = (string) Operation timeout for connection to master node.
     * $params['s']                       = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['time']                    = (enum) The unit in which to display time values. (Options = d,h,m,micros,ms,nanos,s)
     * $params['v']                       = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']                   = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function nodes(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Nodes');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns a concise representation of the cluster pending tasks.
     *
     * $params['cluster_manager_timeout'] = (string) Operation timeout for connection to cluster-manager node.
     * $params['format']                  = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']                       = (array) Comma-separated list of column names to display.
     * $params['help']                    = (boolean) Return help information. (Default = false)
     * $params['local']                   = (boolean) Return local information, do not retrieve the state from cluster-manager node. (Default = false)
     * $params['master_timeout']          = (string) Operation timeout for connection to master node.
     * $params['s']                       = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['time']                    = (enum) The unit in which to display time values. (Options = d,h,m,micros,ms,nanos,s)
     * $params['v']                       = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']                   = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function pendingTasks(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\PendingTasks');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * List segments for one or several PITs.
     *
     * $params['bytes']       = (enum) The unit in which to display byte values. (Options = b,g,gb,k,kb,m,mb,p,pb,t,tb)
     * $params['format']      = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']           = (array) Comma-separated list of column names to display.
     * $params['help']        = (boolean) Return help information. (Default = false)
     * $params['s']           = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['v']           = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function pitSegments(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\PitSegments');
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns information about installed plugins across nodes node.
     *
     * $params['cluster_manager_timeout'] = (string) Operation timeout for connection to cluster-manager node.
     * $params['format']                  = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']                       = (array) Comma-separated list of column names to display.
     * $params['help']                    = (boolean) Return help information. (Default = false)
     * $params['local']                   = (boolean) Return local information, do not retrieve the state from cluster-manager node. (Default = false)
     * $params['master_timeout']          = (string) Operation timeout for connection to master node.
     * $params['s']                       = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['v']                       = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']                   = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function plugins(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Plugins');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns information about index shard recoveries, both on-going completed.
     *
     * $params['index']       = (array) A comma-separated list of data streams, indices, and aliases used to limit the request. Supports wildcards (`*`). To target all data streams and indices, omit this parameter or use `*` or `_all`.
     * $params['active_only'] = (boolean) If `true`, the response only includes ongoing shard recoveries. (Default = false)
     * $params['bytes']       = (enum) The unit used to display byte values. (Options = b,g,gb,k,kb,m,mb,p,pb,t,tb)
     * $params['detailed']    = (boolean) If `true`, the response includes detailed information about shard recoveries. (Default = false)
     * $params['format']      = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']           = (array) Comma-separated list of column names to display.
     * $params['help']        = (boolean) Return help information. (Default = false)
     * $params['s']           = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['time']        = (enum) The unit in which to display time values. (Options = d,h,m,micros,ms,nanos,s)
     * $params['v']           = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function recovery(array $params = [])
    {
        $index = $this->extractArgument($params, 'index');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Recovery');
        $endpoint->setParams($params);
        $endpoint->setIndex($index);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns information about snapshot repositories registered in the cluster.
     *
     * $params['cluster_manager_timeout'] = (string) Operation timeout for connection to cluster-manager node.
     * $params['format']                  = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']                       = (array) Comma-separated list of column names to display.
     * $params['help']                    = (boolean) Return help information. (Default = false)
     * $params['local']                   = (boolean) Return local information, do not retrieve the state from cluster-manager node. (Default = false)
     * $params['master_timeout']          = (string) Operation timeout for connection to master node.
     * $params['s']                       = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['v']                       = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']                   = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function repositories(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Repositories');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns information about both on-going and latest completed Segment Replication events.
     *
     * $params['index']              = (array) Comma-separated list or wildcard expression of index names to limit the returned information.
     * $params['active_only']        = (boolean) If `true`, the response only includes ongoing segment replication events. (Default = false)
     * $params['allow_no_indices']   = (boolean) Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes `_all` string or when no indices have been specified).
     * $params['bytes']              = (enum) The unit in which to display byte values. (Options = b,g,gb,k,kb,m,mb,p,pb,t,tb)
     * $params['completed_only']     = (boolean) If `true`, the response only includes latest completed segment replication events. (Default = false)
     * $params['detailed']           = (boolean) If `true`, the response includes detailed information about segment replications. (Default = false)
     * $params['expand_wildcards']   = (any) Whether to expand wildcard expression to concrete indices that are open, closed or both.
     * $params['format']             = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']                  = (array) Comma-separated list of column names to display.
     * $params['help']               = (boolean) Return help information. (Default = false)
     * $params['ignore_throttled']   = (boolean) Whether specified concrete, expanded or aliased indices should be ignored when throttled.
     * $params['ignore_unavailable'] = (boolean) Whether specified concrete indices should be ignored when unavailable (missing or closed).
     * $params['s']                  = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['shards']             = (array) Comma-separated list of shards to display.
     * $params['time']               = (enum) The unit in which to display time values. (Options = d,h,m,micros,ms,nanos,s)
     * $params['timeout']            = (string) Operation timeout.
     * $params['v']                  = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']             = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']              = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']        = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']             = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']        = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function segmentReplication(array $params = [])
    {
        $index = $this->extractArgument($params, 'index');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\SegmentReplication');
        $endpoint->setParams($params);
        $endpoint->setIndex($index);

        return $this->performRequest($endpoint);
    }
    /**
     * Provides low-level information about the segments in the shards of an index.
     *
     * $params['index']                   = (array) A comma-separated list of data streams, indices, and aliases used to limit the request. Supports wildcards (`*`). To target all data streams and indices, omit this parameter or use `*` or `_all`.
     * $params['bytes']                   = (enum) The unit used to display byte values. (Options = b,g,gb,k,kb,m,mb,p,pb,t,tb)
     * $params['cluster_manager_timeout'] = (string) Operation timeout for connection to cluster-manager node.
     * $params['format']                  = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']                       = (array) Comma-separated list of column names to display.
     * $params['help']                    = (boolean) Return help information. (Default = false)
     * $params['master_timeout']          = (string) Operation timeout for connection to master node.
     * $params['s']                       = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['v']                       = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']                   = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function segments(array $params = [])
    {
        $index = $this->extractArgument($params, 'index');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Segments');
        $endpoint->setParams($params);
        $endpoint->setIndex($index);

        return $this->performRequest($endpoint);
    }
    /**
     * Provides a detailed view of shard allocation on nodes.
     *
     * $params['index']                   = (array) A comma-separated list of data streams, indices, and aliases used to limit the request. Supports wildcards (`*`). To target all data streams and indices, omit this parameter or use `*` or `_all`.
     * $params['bytes']                   = (enum) The unit used to display byte values. (Options = b,g,gb,k,kb,m,mb,p,pb,t,tb)
     * $params['cluster_manager_timeout'] = (string) Operation timeout for connection to cluster-manager node.
     * $params['format']                  = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']                       = (array) Comma-separated list of column names to display.
     * $params['help']                    = (boolean) Return help information. (Default = false)
     * $params['local']                   = (boolean) Return local information, do not retrieve the state from cluster-manager node. (Default = false)
     * $params['master_timeout']          = (string) Operation timeout for connection to master node.
     * $params['s']                       = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['time']                    = (enum) The unit in which to display time values. (Options = d,h,m,micros,ms,nanos,s)
     * $params['v']                       = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']                   = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function shards(array $params = [])
    {
        $index = $this->extractArgument($params, 'index');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Shards');
        $endpoint->setParams($params);
        $endpoint->setIndex($index);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns all snapshots in a specific repository.
     *
     * $params['repository']              = (array) A comma-separated list of snapshot repositories used to limit the request. Accepts wildcard expressions. `_all` returns all repositories. If any repository fails during the request, OpenSearch returns an error.
     * $params['cluster_manager_timeout'] = (string) Operation timeout for connection to cluster-manager node.
     * $params['format']                  = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']                       = (array) Comma-separated list of column names to display.
     * $params['help']                    = (boolean) Return help information. (Default = false)
     * $params['ignore_unavailable']      = (boolean) If `true`, the response does not include information from unavailable snapshots. (Default = false)
     * $params['master_timeout']          = (string) Operation timeout for connection to master node.
     * $params['s']                       = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['time']                    = (enum) The unit in which to display time values. (Options = d,h,m,micros,ms,nanos,s)
     * $params['v']                       = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']                   = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function snapshots(array $params = [])
    {
        $repository = $this->extractArgument($params, 'repository');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Snapshots');
        $endpoint->setParams($params);
        $endpoint->setRepository($repository);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns information about the tasks currently executing on one or more nodes in the cluster.
     *
     * $params['actions']     = (array) The task action names, which are used to limit the response.
     * $params['detailed']    = (boolean) If `true`, the response includes detailed information about shard recoveries. (Default = false)
     * $params['format']      = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']           = (array) Comma-separated list of column names to display.
     * $params['help']        = (boolean) Return help information. (Default = false)
     * $params['s']           = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['time']        = (enum) The unit in which to display time values. (Options = d,h,m,micros,ms,nanos,s)
     * $params['v']           = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     * $params['node_id']     = (array) Comma-separated list of node IDs or names to limit the returned information; use `_local` to return information from the node you're connecting to, leave empty to get information from all nodes.
     * $params['parent_task'] = (string) The parent task identifier, which is used to limit the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function tasks(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Tasks');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns information about existing templates.
     *
     * $params['name']                    = (string) The name of the template to return. Accepts wildcard expressions. If omitted, all templates are returned.
     * $params['cluster_manager_timeout'] = (string) Operation timeout for connection to cluster-manager node.
     * $params['format']                  = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']                       = (array) Comma-separated list of column names to display.
     * $params['help']                    = (boolean) Return help information. (Default = false)
     * $params['local']                   = (boolean) Return local information, do not retrieve the state from cluster-manager node. (Default = false)
     * $params['master_timeout']          = (string) Operation timeout for connection to master node.
     * $params['s']                       = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['v']                       = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']                   = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function templates(array $params = [])
    {
        $name = $this->extractArgument($params, 'name');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\Templates');
        $endpoint->setParams($params);
        $endpoint->setName($name);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns cluster-wide thread pool statistics per node.By default the active, queue and rejected statistics are returned for all thread pools.
     *
     * $params['thread_pool_patterns']    = (array) A comma-separated list of thread pool names used to limit the request. Accepts wildcard expressions.
     * $params['cluster_manager_timeout'] = (string) Operation timeout for connection to cluster-manager node.
     * $params['format']                  = (string) A short version of the Accept header, e.g. json, yaml.
     * $params['h']                       = (array) Comma-separated list of column names to display.
     * $params['help']                    = (boolean) Return help information. (Default = false)
     * $params['local']                   = (boolean) Return local information, do not retrieve the state from cluster-manager node. (Default = false)
     * $params['master_timeout']          = (string) Operation timeout for connection to master node.
     * $params['s']                       = (array) Comma-separated list of column names or column aliases to sort by.
     * $params['size']                    = (integer) The multiplier in which to display values.
     * $params['v']                       = (boolean) Verbose mode. Display column headers. (Default = false)
     * $params['pretty']                  = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']                   = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']             = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']                  = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']             = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function threadPool(array $params = [])
    {
        $thread_pool_patterns = $this->extractArgument($params, 'thread_pool_patterns');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Cat\ThreadPool');
        $endpoint->setParams($params);
        $endpoint->setThreadPoolPatterns($thread_pool_patterns);

        return $this->performRequest($endpoint);
    }
}
