<?php

/**
 * This file is a part of horstoeko/zugferd.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\zugferd\codelists;

/**
 * Class representing the Allowance codes
 *
 * @category Zugferd
 * @package  Zugferd
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/zugferd
 */
class ZugferdAllowanceCodes
{
    /**
     * Bonus for works ahead of schedule
     */
    public const BONUS_FOR_WORKS_AHEAD_OF_SCHEDULE = "41";

    /**
     * Other bonus
     */
    public const OTHER_BONUS = "42";

    /**
     * Manufacturer’s consumer discount
     */
    public const MANUFACTURERS_CONSUMER_DISCOUNT = "60";

    /**
     * Due to military status
     */
    public const DUE_TO_MILITARY_STATUS = "62";

    /**
     * Due to work accident
     */
    public const DUE_TO_WORK_ACCIDENT = "63";

    /**
     * Special agreement
     */
    public const SPECIAL_AGREEMENT = "64";

    /**
     * Production error discount
     */
    public const PRODUCTION_ERROR_DISCOUNT = "65";

    /**
     * New outlet discount
     */
    public const NEW_OUTLET_DISCOUNT = "66";

    /**
     * Sample discount
     */
    public const SAMPLE_DISCOUNT = "67";

    /**
     * End-of-range discount
     */
    public const ENDOFRANGE_DISCOUNT = "68";

    /**
     * Incoterm discount
     */
    public const INCOTERM_DISCOUNT = "70";

    /**
     * Point of sales threshold allowance
     */
    public const POINT_OF_SALES_THRESHOLD_ALLOWANCE = "71";

    /**
     * Material surcharge/deduction
     */
    public const MATERIAL_SURCHARGE_DEDUCTION = "88";

    /**
     * Discount
     */
    public const DISCOUNT = "95";

    /**
     * Special rebate
     */
    public const SPECIAL_REBATE = "100";

    /**
     * Fixed long term
     */
    public const FIXED_LONG_TERM = "102";

    /**
     * Temporary
     */
    public const TEMPORARY = "103";

    /**
     * Standard
     */
    public const STANDARD = "104";

    /**
     * Yearly turnover
     */
    public const YEARLY_TURNOVER = "105";
}
