const s=`{% block sw_sales_channel_list %} <sw-page class="sw-sales-channel-list"> {% block sw_sales_channel_list_search_bar %} <template #search-bar> <sw-search-bar initial-search-type="sales_channel" :placeholder="$tc('sw-sales-channel.list.placeholderSearchBar')" :initial-search="term" @search="onSearch" /> </template> {% endblock %} {% block sw_sales_channel_list_smart_bar_header %} <template #smart-bar-header> {% block sw_sales_channel_list_smart_bar_header_title %} <h2> {% block sw_sales_channel_list_smart_bar_header_title_text %} {{ $tc('sw-sales-channel.list.title') }} {% endblock %} {% block sw_sales_channel_list_smart_bar_header_amount %} <span v-if="!isLoading" class="sw-page__smart-bar-amount" > ({{ total }}) </span> {% endblock %} </h2> {% endblock %} </template> {% endblock %} {% block sw_sales_channel_list_actions %} <template #smart-bar-actions> {% block sw_sales_channel_list_smart_bar_actions %} <mt-button v-tooltip.bottom="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('sales_channel.creator'), showOnDisabledElements: true }" :disabled="!acl.can('sales_channel.creator')" variant="primary" size="default" @click="onAddSalesChannel" > {{ $tc('sw-sales-channel.list.buttonAddSalesChannel') }} </mt-button> {% endblock %} </template> {% endblock %} {% block sw_sales_channel_list_content %} <template #content> <sw-card-view> {% block sw_sales_channel_list_content_card %} <mt-card v-if="entitySearchable && total > 0" position-identifier="sw-sales-channel-list" :title="$tc('sw-sales-channel.list.title')" :subtitle="$tc('sw-sales-channel.list.subTitle')" > {% block sw_sales_channel_list_grid %} <template #grid> <sw-entity-listing :is-loading="isLoading" identifier="sw-sales-channel-list" :columns="salesChannelColumns" :repository="salesChannelRepository" :items="salesChannels" :full-page="false" :show-selection="false" :sort-by="currentSortBy" :sort-direction="sortDirection" :plain-appearance="true" :show-settings="true" :allow-column-edit="true" > {% block sw_sales_channel_list_grid_column_name %} <template #column-name="{ item }"> <mt-icon :name="item.type.iconName" size="18px" /> <router-link :to="{ name: 'sw.sales.channel.detail', params: { id: item.id } }" >{{ item.translated.name || item.name }}</router-link> </template> {% endblock %} {% block sw_sales_channel_list_grid_column_status %} <template #column-status="{ item }"> <template v-if="item.maintenance"> <sw-status color="orange"> {{ $tc('sw-sales-channel.list.status.maintenance') }} </sw-status> </template> <template v-else-if="item.active"> <sw-status color="green"> {{ $tc('sw-sales-channel.list.status.online') }} </sw-status> </template> <template v-else> <sw-status color="gray"> {{ $tc('sw-sales-channel.list.status.offline') }} </sw-status> </template> </template> {% endblock %} {% block sw_sales_channel_list_grid_column_created_at %} <template #column-createdAt="{ item }"> <sw-time-ago :date="item.createdAt" /> </template> {% endblock %} {% block sw_sales_channel_list_grid_column_favorite %} <template #column-id="{ item }"> <mt-switch v-tooltip.right="{ message: $tc('sw-sales-channel.detail.favouriteLabel') }" class="favorite-switch" :disabled="!acl.can('user_config:create') || !acl.can('user_config:update')" :model-value="isFavorite(item.id)" @update:model-value="(isFavorite) => { salesChannelFavoritesService?.update(isFavorite, item.id) }" /> </template> {% endblock %} {% block sw_sales_channel_list_grid_actions %} <template #actions="{ item }"> {% block sw_sales_channel_list_grid_actions_item_detail %} <sw-context-menu-item :router-link="{ name: 'sw.sales.channel.detail', params: { id: item.id } }" > {{ $tc('sw-sales-channel.list.contextMenuEdit') }} </sw-context-menu-item> {% endblock %} {% block sw_sales_channel_list_grid_actions_item_open_storefront %} <sw-context-menu-item v-if="isStorefrontSalesChannel(item)" :disabled="!item.active || !checkForDomainLink(item)" @click.prevent="openStorefrontLink(item.domainLink)" > {{ $tc('sw-sales-channel.general.tooltipOpenStorefront') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} </sw-entity-listing> </template> {% endblock %} </mt-card> {% endblock %} {% block sw_sales_channel_list_empty_state %} <template v-if="!isLoading && !total"> <mt-empty-state v-if="isValidTerm(term)" :style="{ minHeight: '200px' }" :icon="$route.meta.$module.icon" :headline="$tc('sw-empty-state.messageNoResultTitle')" :link-text="$t('sw-empty-state.messageNoResultLink')" :link-href="$router.resolve({ name: 'sw.profile.index.searchPreferences' }).href" /> </template> {% endblock %} </sw-card-view> </template> {% endblock %} </sw-page> {% endblock %}`,{Mixin:l,Defaults:n}=Shopware,{Criteria:a}=Shopware.Data,i={template:s,inject:["repositoryFactory","acl","domainLinkService"],mixins:[l.getByName("listing")],data(){return{salesChannels:null,productsForSalesChannel:{},isLoading:!0,sortBy:"name",searchConfigEntity:"sales_channel",lastSortedColumn:null}},metaInfo(){return{title:this.$createTitle()}},computed:{salesChannelColumns(){const e=[{property:"name",dataIndex:"name",allowResize:!0,routerLink:"sw.sales.channel.detail",label:"sw-sales-channel.list.columnName",primary:!0},{property:"status",dataIndex:"status",allowResize:!0,sortable:!1,label:"sw-sales-channel.list.columnStatus"},{property:"id",dataIndex:"id",allowResize:!0,sortable:!1,label:"sw-sales-channel.list.columnFavourite",align:"center"},{property:"createdAt",dataIndex:"createdAt",allowResize:!0,label:"sw-sales-channel.list.columnCreatedAt"}];return e.splice(1,0,{property:"type.name",dataIndex:"type.name",allowResize:!0,label:"sw-sales-channel.list.columnType"}),e},salesChannelRepository(){return this.repositoryFactory.create("sales_channel")},salesChannelCriteria(){const e=new a(this.page,this.limit);return e.setTerm(this.term),e.addSorting(a.sort(this.sortBy,this.sortDirection,this.naturalSorting)),e.addAssociation("type"),e.addAssociation("domains"),e},salesChannelFavoritesService(){return Shopware.Service("salesChannelFavorites")},dateFilter(){return Shopware.Filter.getByName("date")}},methods:{onAddSalesChannel(){Shopware.Utils.EventBus.emit("sw-sales-channel-list-add-new-channel")},async getList(){this.isLoading=!0;const e=await this.addQueryScores(this.term,this.salesChannelCriteria);return this.entitySearchable?(this.freshSearchTerm&&e.resetSorting(),this.salesChannelRepository.search(e).then(t=>{this.salesChannels=t,this.total=t.total,this.isLoading=!1})):(this.isLoading=!1,this.total=0,!1)},checkForDomainLink(e){const t=this.domainLinkService.getDomainLink(e);return t===null?!1:(e.domainLink=t,!0)},openStorefrontLink(e){window.open(e,"_blank")},isFavorite(e){return this.salesChannelFavoritesService.isFavorite(e)},isStorefrontSalesChannel(e){return e.type.id===n.storefrontSalesChannelTypeId}}};export{i as default};
