const r=`{% block sw_media_quickinfo_usage %} <div class="sw-media-quickinfo-usage"> {% block sw_media_quickinfo_usage_loader %} <sw-loader v-if="isLoading" size="30px" class="sw-media-quickinfo-usage__loading-indicator" /> {% endblock %} {% block sw_media_quickinfo_usage_empty_state %} <mt-banner v-else-if="isNotUsed" class="sw-media-quickinfo-usage__info-not-used" variant="info" :title="$tc('sw-media.sidebar.usage.titleMediaNotUsed')" > {{ $tc('sw-media.sidebar.usage.labelMediaNotUsed') }} </mt-banner> {% endblock %} {% block sw_media_quickinfo_usage_list %} <ul v-else class="sw-media-quickinfo-usage__list" > {% block sw_media_quickinfo_usage_item %} <router-link v-for="usage in getUsages" :key="usage.link.id" :to="{ name: usage.link.name, params: { id: usage.link.id } }" :target="routerLinkTarget" > <li v-tooltip="{ showDelay: 300, hideDelay: 5, message: usage.tooltip }" class="sw-media-quickinfo-usage__item" > {% block sw_media_quickinfo_usage_item_icon %} <div class="sw-media-quickinfo-usage__label"> <mt-icon :name="usage.icon.name" :color="usage.icon.color" size="16px" /> </div> {% endblock %} {% block sw_media_quickinfo_usage_item_label %} <div class="sw-media-quickinfo-usage__label"> {{ usage.name }} </div> {% endblock %} </li> </router-link> {% endblock %} </ul> {% endblock %} </div> {% endblock %}`,{Application:d}=Shopware,c=Shopware.Utils.types,{Criteria:a}=Shopware.Data,l={template:r,inject:["repositoryFactory"],props:{item:{required:!0,type:Object,validator(e){return e.getEntityName()==="media"}},routerLinkTarget:{required:!1,type:String,default:""}},data(){return{products:[],categories:[],manufacturers:[],mailTemplates:[],documentBaseConfigs:[],avatarUsers:[],paymentMethods:[],shippingMethods:[],layouts:[],landingPages:[],isLoading:!1}},computed:{productRepository(){return this.repositoryFactory.create("product")},landingPageRepository(){return this.repositoryFactory.create("landing_page")},categoryRepository(){return this.repositoryFactory.create("category")},cmsPageRepository(){return this.repositoryFactory.create("cms_page")},moduleFactory(){return d.getContainer("factory").module},slotConfigCriteria(){const e=new a;return e.setLimit(5),e.addFilter(a.contains("slotConfig.*.media.value",this.item.id)),e.addFields("name"),e},cmsPageBlockConfigCriteria(){const e=new a;return e.setLimit(5),e.addFilter(a.equals("sections.blocks.slots.config.media.value",this.item.id)),e.addFields("name"),e},getUsages(){const e=[];return this.products.forEach(({product:t})=>{e.push(this.getProductUsage(t))}),this.categories.forEach(t=>{e.push(this.getCategoryUsage(t))}),this.manufacturers.forEach(t=>{e.push(this.getManufacturerUsage(t))}),this.mailTemplates.forEach(({mailTemplate:t})=>{e.some(o=>o.link.id===t.id)||e.push(this.getMailTemplateUsage(t))}),this.documentBaseConfigs.forEach(t=>{e.push(this.getDocumentBaseConfigUsage(t))}),this.paymentMethods.forEach(t=>{e.push(this.getPaymentMethodUsage(t))}),this.shippingMethods.forEach(t=>{e.push(this.getShippingMethodUsage(t))}),this.layouts.forEach(t=>{e.push(this.getLayoutUsage(t))}),c.isEmpty(this.avatarUsers)||this.avatarUsers.forEach(t=>{e.push(this.getAvatarUserUsage(t))}),this.landingPages.forEach(t=>{e.push(this.getLandingPageUsage(t))}),e},isNotUsed(){return this.getUsages.length===0}},watch:{item(){this.createdComponent()}},created(){this.createdComponent()},methods:{async createdComponent(){this.loadProductAssociations(),this.loadCategoryAssociations(),this.loadManufacturerAssociations(),this.loadMailTemplateAssociations(),this.loadDocumentBaseConfigAssociations(),this.loadAvatarUserAssociations(),this.loadPaymentMethodAssociations(),this.loadShippingMethodAssociations(),this.loadLayoutAssociations(),await this.loadSlotConfigAssociations()},async loadSlotConfigAssociations(){this.isLoading=!0;const[e,t,o,n]=await Promise.all([this.productRepository.search(this.slotConfigCriteria),this.landingPageRepository.search(this.slotConfigCriteria),this.categoryRepository.search(this.slotConfigCriteria),this.cmsPageRepository.search(this.cmsPageBlockConfigCriteria)]);e.forEach(s=>{this.products&&!this.products.some(i=>i.product.id===s.id)&&this.products.push({product:s})}),this.landingPages=t,o.forEach(s=>{this.categories&&!this.categories.some(i=>i.id===s.id)&&this.categories.push(s)}),n.forEach(s=>{this.layouts&&!this.layouts.some(i=>i.id===s.id)&&this.layouts.push(s)}),this.isLoading=!1},loadProductAssociations(){this.products=this.item.productMedia},loadCategoryAssociations(){this.categories=this.item.categories},loadManufacturerAssociations(){this.manufacturers=this.item.productManufacturers},loadMailTemplateAssociations(){this.mailTemplates=this.item.mailTemplateMedia},loadDocumentBaseConfigAssociations(){this.documentBaseConfigs=this.item.documentBaseConfigs},loadAvatarUserAssociations(){this.avatarUsers=this.item.avatarUsers},loadPaymentMethodAssociations(){this.paymentMethods=this.item.paymentMethods},loadShippingMethodAssociations(){this.shippingMethods=this.item.shippingMethods},loadLayoutAssociations(){this.layouts=[],this.item.cmsBlocks.forEach(e=>{this.isExistedCmsMedia(e.section.pageId)||this.layouts.push({id:e.section.pageId,name:e.section.page.translated.name})}),this.item.cmsSections.forEach(e=>{this.isExistedCmsMedia(e.pageId)||this.layouts.push({id:e.pageId,name:e.page.translated.name})}),this.item.cmsPages.forEach(e=>{this.isExistedCmsMedia(e.id)||this.layouts.push({id:e.id,name:e.translated.name})})},isExistedCmsMedia(e){return this.layouts.some(t=>t.id===e)},getProductUsage(e){return{name:e.translated.name,tooltip:this.$tc("sw-media.sidebar.usage.tooltipFoundInProducts"),link:{name:"sw.product.detail",id:e.id},icon:this.getIconForModule("sw-product")}},getCategoryUsage(e){return{name:e.translated.name,tooltip:this.$tc("sw-media.sidebar.usage.tooltipFoundInCategories"),link:{name:"sw.category.detail",id:e.id},icon:this.getIconForModule("sw-category")}},getManufacturerUsage(e){return{name:e.translated.name,tooltip:this.$tc("sw-media.sidebar.usage.tooltipFoundInManufacturers"),link:{name:"sw.manufacturer.detail",id:e.id},icon:this.getIconForModule("sw-manufacturer")}},getMailTemplateUsage(e){return{name:e.translated.description,tooltip:this.$tc("sw-media.sidebar.usage.tooltipFoundInMailTemplate"),link:{name:"sw.mail.template.detail",id:e.id},icon:this.getIconForModule("sw-mail-template")}},getDocumentBaseConfigUsage(e){return{name:e.name,tooltip:this.$tc("sw-media.sidebar.usage.tooltipFoundInDocument"),link:{name:"sw.settings.document.detail",id:e.id},icon:this.getIconForModule("sw-settings-document")}},getAvatarUserUsage(e){return{name:e.username,tooltip:this.$tc("sw-media.sidebar.usage.tooltipFoundInUser"),link:{name:"sw.users.permissions.user.detail",id:e.id},icon:this.getIconForModule("sw-users-permissions")}},getPaymentMethodUsage(e){return{name:e.translated.distinguishableName,tooltip:this.$tc("sw-media.sidebar.usage.tooltipFoundInPayment"),link:{name:"sw.settings.payment.detail",id:e.id},icon:this.getIconForModule("sw-settings-payment")}},getShippingMethodUsage(e){return{name:e.translated.name,tooltip:this.$tc("sw-media.sidebar.usage.tooltipFoundShipping"),link:{name:"sw.settings.shipping.detail",id:e.id},icon:this.getIconForModule("sw-settings-shipping")}},getLayoutUsage(e){return{name:e.name,tooltip:this.$tc("sw-media.sidebar.usage.tooltipFoundLayout"),link:{name:"sw.cms.detail",id:e.id},icon:this.getIconForModule("sw-cms")}},getLandingPageUsage(e){return{name:e.translated.name,tooltip:this.$tc("sw-media.sidebar.usage.tooltipFoundInLandingPages"),link:{name:"sw.category.landingPageDetail",id:e.id},icon:this.getIconForModule("sw-category")}},getIconForModule(e){const t=this.moduleFactory.getModuleRegistry().get(e);return{name:t.manifest.icon,color:t.manifest.color}}}};export{l as default};
