const r=`{% block sw_settings_tax_rule_modal %} <sw-modal :title="$tc('sw-settings-tax.taxRuleCard.labelCountryName')" class="sw-settings-tax-rule-modal__settings-modal" @modal-close="$emit('modal-close')" > {% block sw_settings_tax_rule_modal_form_first_row %} <sw-container columns="1fr 1fr" gap="0px 32px" > {% block sw_settings_tax_rule_modal_country_select %} <sw-entity-single-select v-model:value="taxRule.countryId" show-clearable-button required :label="$tc('sw-settings-tax.taxRuleCard.labelCountryName')" :help-text="$tc('sw-settings-tax.taxRuleCard.tooltipCountries')" :error="taxRuleCountryIdError" :criteria="countryCriteria" entity="country" /> {% endblock %} {% block sw_settings_tax_rule_modal_type_select %} <sw-entity-single-select v-model:value="taxRule.taxRuleTypeId" show-clearable-button required :label="$tc('sw-settings-tax.taxRuleCard.labelAppliesOn')" label-property="typeName" :error="taxRuleTaxRuleTypeIdError" :criteria="taxRuleTypeCriteria" entity="tax_rule_type" @update:value="changeRuleType" /> {% endblock %} </sw-container> {% endblock %} {% block sw_settings_tax_rule_modal_form_second_row %} <sw-container columns="1fr 1fr" gap="0 32px" > {% block sw_settings_tax_rule_modal_additional_component %} <component :is="additionalComponent" v-if="additionalComponent" :tax-rule="taxRule" /> {% endblock %} {% block sw_settings_tax_rule_modal_tax_rate %} <mt-number-field v-model="taxRule.taxRate" required :digits="3" :error="taxRuleTaxRateError" :label="$tc('sw-settings-tax.taxRuleCard.labelTaxRate')" > <template #suffix> <span> <span v-html="$sanitize($tc('sw-settings-tax.general.taxRateSymbol'))"></span> </span> </template> </mt-number-field> {% endblock %} {% block sw_settings_tax_rule_modal_tax_active_from %} <mt-datepicker v-model="taxRule.activeFrom" date-type="datetime" :error="taxRuleActiveFromError" :label="$tc('sw-settings-tax.taxRuleCard.labelActiveFrom')" :placeholder="$tc('sw-datepicker.datetime.placeholder')" /> {% endblock %} </sw-container> {% endblock %} {% block sw_settings_tax_rule_modal_form_footer %} <template #modal-footer> {% block sw_settings_tax_rule_modal_form_footer_cancel %} <mt-button size="small" variant="secondary" @click="$emit('modal-close')" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_settings_tax_rule_modal_form_footer_button_create %} <mt-button variant="primary" size="small" @click="onConfirm" > {{ $tc('sw-settings-tax.detail.buttonSave') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %}`,{Context:a}=Shopware,{Criteria:t}=Shopware.Data,{mapPropertyErrors:o}=Shopware.Component.getComponentHelper(),s={template:r,inject:["repositoryFactory"],emits:["modal-close"],props:{tax:{type:Object,required:!0},currentRule:{type:Object,required:!1,default:null}},data(){return{showModal:!1,taxRule:null,currentTaxRuleType:null}},computed:{taxRuleRepository(){return this.repositoryFactory.create("tax_rule")},taxRuleTypeRepository(){return this.repositoryFactory.create("tax_rule_type")},additionalComponent(){return this.currentTaxRuleType?`sw-settings-tax-rule-type-${this.currentTaxRuleType.technicalName.replace(/_/g,"-")}`:null},taxRuleTypeCriteria(){const e=new t(1,25);return e.addSorting(t.sort("position","ASC")),e},countryCriteria(){const e=new t(1,25);return e.addSorting(t.sort("name","ASC",!1)),e},...o("taxRule",["taxRuleTypeId","countryId","taxRate","activeFrom"])},created(){this.createdComponent()},methods:{changeRuleType(e){this.taxRuleTypeRepository.get(e,a.api).then(l=>{this.currentTaxRuleType=l})},createdComponent(){this.currentRule?(this.taxRule=this.currentRule,this.taxRule.taxRuleTypeId&&this.changeRuleType(this.taxRule.taxRuleTypeId)):(this.taxRule=this.taxRuleRepository.create(),this.taxRule.taxId=this.tax.id)},onConfirm(){this.taxRuleRepository.save(this.taxRule,a.api).then(()=>{this.isSaveSuccessful=!0,this.$emit("modal-close")}).catch(()=>{this.isLoading=!1})}}};export{s as default};
