const r=`{% block sw_customer_list %} <sw-page class="sw-customer-list"> {% block sw_customer_list_search_bar %} <template #search-bar> <sw-search-bar initial-search-type="customer" :initial-search="term" @search="onSearch" /> </template> {% endblock %} {% block sw_customer_list_smart_bar_header %} <template #smart-bar-header> {% block sw_customer_list_smart_bar_header_title %} <h2> {% block sw_customer_list_smart_bar_header_title_text %} {{ $tc('sw-customer.list.textCustomers') }} {% endblock %} {% block sw_customer_list_smart_bar_header_amount %} <span v-if="!isLoading" class="sw-page__smart-bar-amount" > ({{ total }}) </span> {% endblock %} </h2> {% endblock %} </template> {% endblock %} {% block sw_customer_list_smart_bar_actions %} <template #smart-bar-actions> {% block sw_customer_list_smart_bar_actions_add %} <mt-button v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('customer.creator'), showOnDisabledElements: true }" class="sw-customer-list__button-create" variant="primary" :disabled="!acl.can('customer.creator') || undefined" size="default" @click="$router.push({ name: 'sw.customer.create' })" > {{ $tc('sw-customer.list.buttonAddCustomer') }} </mt-button> {% endblock %} </template> {% endblock %} <template #language-switch> <sw-language-switch @on-change="onChangeLanguage" /> </template> <template #content> {% block sw_customer_list_content %} <div class="sw-customer-list__content"> {% block sw_customer_list_empty_state %} <mt-empty-state v-if="!isLoading && !total" class="mt-empty-state--center" :icon="$route.meta.$module.icon" :headline="filterCriteria.length || isValidTerm(term) ? $t('sw-empty-state.messageNoResultTitle') : $t('sw-customer.list.messageEmpty')" :description="filterCriteria.length || isValidTerm(term) ? $t('sw-empty-state.messageNoResultSubline') : $t($route.meta.$module.description)" :link-text="filterCriteria.length || isValidTerm(term) ? $t('sw-empty-state.messageNoResultLink') : ''" :link-href="filterCriteria.length || isValidTerm(term) ? $router.resolve({ name: 'sw.profile.index.searchPreferences' }).href : ''" /> {% endblock %} {% block sw_customer_list_grid %} <sw-entity-listing v-else-if="isLoading || (customers && entitySearchable)" ref="swCustomerGrid" class="sw-customer-list-grid" identifier="sw-customer-list" :items="customers" :columns="customerColumns" :repository="customerRepository" :sort-by="currentSortBy" :sort-direction="sortDirection" detail-route="sw.customer.detail" :show-selection="acl.can('customer.deleter')" :allow-inline-edit="acl.can('customer.editor') || undefined" :allow-bulk-edit="acl.can('customer.editor')" :is-loading="isLoading" :disable-data-fetching="true" @selection-change="updateSelection" @inline-edit-save="onInlineEditSave" @page-change="onPageChange" @column-sort="onSortColumn" @bulk-edit-modal-open="onBulkEditModalOpen" > {% block sw_customer_list_grid_columns %} {% block sw_product_list_grid_columns_name_preview %} <template #preview-firstName="{ item, compact }"> <sw-avatar :size="compact ? '32px' : '48px'" :source-context="item" :first-name="item.firstName" :last-name="item.lastName" /> </template> {% endblock %} {% block sw_customer_list_grid_columns_name %} <template #column-firstName="{ item, compact, isInlineEdit }"> {% block sw_customer_list_grid_inline_edit_name %} <template v-if="isInlineEdit"> {% block sw_customer_list_grid_inline_edit_first_name %} <mt-text-field v-model="item.firstName" name="sw-field--item-firstName" class="sw-customer-list__inline-edit-first-name" :size="compact ? 'small' : 'default'" /> {% endblock %} {% block sw_customer_list_grid_inline_edit_last_name %} <mt-text-field v-model="item.lastName" name="sw-field--item-lastName" class="sw-customer-list__inline-edit-last-name" :size="compact ? 'small' : 'default'" /> {% endblock %} </template> {% endblock %} {% block sw_customer_list_grid_columns_name_link %} <router-link v-else :to="{ name: 'sw.customer.detail', params: { id: item.id }, query: { edit: false } }" > {{ item.lastName }}, {{ item.firstName }} </router-link> {% endblock %} {% block sw_customer_list_grid_columns_name_guest_label %} <sw-label v-if="!isInlineEdit && item.guest" appearance="pill" size="small" class="sw-customer-list__metadata-customer-guest-label" > {{ $tc('sw-customer.list.columnNameGuestLabel') }} </sw-label> {% endblock %} <sw-label v-if="item.createdById" appearance="pill" size="small" class="sw-customer-list__created-by-admin-label" > {{ $tc('sw-customer.list.labelCreatedByAdmin') }} </sw-label> </template> {% endblock %} {% endblock %} {% block sw_customer_list_grid_columns_group %} <template #column-group="{ item, compact, isInlineEdit }"> <sw-label v-if="item.requestedGroup" class="sw-customer-list__requested-group-label" variant="warning" appearance="pill" > {{ $tc('sw-customer.list.columnGroupRequested') }} {{ item.requestedGroup.translated.name }} </sw-label> <sw-label v-else size="default" appearance="pill" > {{ item.group.translated.name }} </sw-label> </template> {% endblock %} {% block sw_product_list_grid_columns_email_preview %} <template #column-email="{ item }"> {{ emailIdnFilter(item.email) }} </template> {% endblock %} {% block sw_customer_list_grid_columns_boundSalesChannel %} <template #column-boundSalesChannelId="{ item }"> {{ item.boundSalesChannelId ? item.boundSalesChannel.translated.name : $tc('sw-customer.list.emptyBoundSalesChannel') }} </template> {% endblock %} {% block sw_customer_list_grid_columns_active %} <template #column-active="{ item, isInlineEdit }"> {% block sw_customer_list_grid_columns_active_inline_edit %} <template v-if="isInlineEdit"> <mt-checkbox v-model:checked="item.active" name="sw-field--item-active" /> </template> {% endblock %} {% block sw_customer_list_grid_columns_active_content %} <template v-else> <mt-icon v-if="item.active" name="regular-checkmark-xs" size="16px" class="is--active" /> <mt-icon v-else name="regular-times-s" size="16px" class="is--inactive" /> </template> {% endblock %} </template> {% endblock %} {% block sw_customer_list_grid_columns_createdAt %} <template #column-createdAt="{ item }"> <sw-time-ago :date="item.createdAt" /> </template> {% endblock %} {% block sw_customer_list_grid_columns_actions %} <template #actions="{ item }"> {% block sw_customer_list_grid_columns_actions_view %} <sw-context-menu-item class="sw-customer-list__view-action" :router-link="{ name: 'sw.customer.detail', params: { id: item.id }, query: { edit: false } }" > {{ $tc('sw-customer.list.contextMenuView') }} </sw-context-menu-item> {% endblock %} {% block sw_customer_list_grid_columns_actions_edit %} <sw-context-menu-item class="sw-customer-list__edit-action" :disabled="!acl.can('customer.editor') || undefined" :router-link="{ name: 'sw.customer.detail.base', params: { id: item.id }, query: { edit: true } }" > {{ $tc('sw-customer.list.contextMenuEdit') }} </sw-context-menu-item> {% endblock %} {% block sw_customer_list_grid_columns_actions_delete %} <sw-context-menu-item class="sw-customer-list__delete-action" variant="danger" :disabled="!acl.can('customer.deleter') || undefined" @click="onDelete(item.id)" > {{ $tc('sw-customer.list.contextMenuDelete') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} {% block sw_customer_list_grid_action_modals %} <template #action-modals="{ item }"> {% block sw_customer_list_delete_modal %} <sw-modal v-if="showDeleteModal === item.id" :title="$tc('global.default.warning')" variant="small" @modal-close="onCloseDeleteModal" > {% block sw_customer_list_delete_modal_confirm_delete_text %} <p class="sw-customer-list__confirm-delete-text"> {{ $tc('sw-customer.list.textDeleteConfirm', { name: \`\${item.firstName} \${item.lastName}\` }, 0) }} </p> {% endblock %} {% block sw_customer_list_delete_modal_footer %} <template #modal-footer> {% block sw_customer_list_delete_modal_cancel %} <mt-button size="small" variant="secondary" @click="onCloseDeleteModal" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_customer_list_delete_modal_confirm %} <mt-button variant="critical" size="small" @click="onConfirmDelete(item.id)" > {{ $tc('sw-customer.list.buttonDelete') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} </template> {% endblock %} <template #pagination> {% block sw_order_list_grid_pagination %} <sw-pagination :page="page" :limit="limit" :total="total" :total-visible="7" @page-change="onPageChange" /> {% endblock %} </template> {% block sw_customer_list_bulk_edit_modal %} <template #bulk-edit-modal="{ selection }" > <sw-bulk-edit-modal v-if="showBulkEditModal" ref="bulkEditModal" class="sw-customer-bulk-edit-modal" :selection="selection" :bulk-grid-edit-columns="customerColumns" @edit-items="onBulkEditItems" @modal-close="onBulkEditModalClose" > {% block sw_customer_list_bulk_edit_grid_columns_name %} <template #column-firstName="{ item }"> <router-link :to="{ name: 'sw.customer.detail', params: { id: item.id } }" target="_blank" rel="noreferrer noopener" > {{ item.lastName }}, {{ item.firstName }} </router-link> </template> {% endblock %} {% block sw_customer_list_bulk_edit_grid_columns_group %} <template #column-group="{ item }"> <sw-label v-if="item.requestedGroup" class="sw-customer-list__requested-group-label" variant="warning" appearance="pill" > {{ $tc('sw-customer.list.columnGroupRequested') }} {{ item.requestedGroup.translated.name }} </sw-label> <sw-label v-else size="default" appearance="pill" > {{ item.group.translated.name }} </sw-label> </template> {% endblock %} </sw-bulk-edit-modal> </template> {% endblock %} </sw-entity-listing> {% endblock %} </div> {% endblock %} </template> {% block sw_customer_list_sidebar %} <template #sidebar> <sw-sidebar class="sw-customer-list__sidebar"> {% block sw_customer_list_sidebar_refresh %} <sw-sidebar-item icon="regular-undo" :title="$tc('sw-customer.list.titleSidebarItemRefresh')" @click="onRefresh" /> {% endblock %} {% block sw_customer_list_sidebar_filter %} <sw-sidebar-filter-panel entity="customer" :store-key="storeKey" :filters="listFilters" :defaults="defaultFilters" :active-filter-number="activeFilterNumber" @criteria-changed="updateCriteria" /> {% endblock %} </sw-sidebar> </template> {% endblock %} </sw-page> {% endblock %}`,{Mixin:i}=Shopware,{Criteria:s}=Shopware.Data,a={template:r,inject:["repositoryFactory","acl","filterFactory"],mixins:[i.getByName("notification"),i.getByName("salutation"),i.getByName("listing")],data(){return{customers:null,sortBy:"createdAt",naturalSorting:!1,sortDirection:"DESC",isLoading:!1,showDeleteModal:!1,filterLoading:!1,availableAffiliateCodes:[],availableCampaignCodes:[],filterCriteria:[],defaultFilters:["customer-number-filter","affiliate-code-filter","campaign-code-filter","customer-group-request-filter","salutation-filter","account-status-filter","default-payment-method-filter","group-filter","billing-address-country-filter","shipping-address-country-filter","tags-filter"],storeKey:"grid.filter.customer",activeFilterNumber:0,searchConfigEntity:"customer",showBulkEditModal:!1}},metaInfo(){return{title:this.$createTitle()}},computed:{customerRepository(){return this.repositoryFactory.create("customer")},customerColumns(){return this.getCustomerColumns()},defaultCriteria(){const e=new s(this.page,this.limit);return this.naturalSorting=this.sortBy==="customerNumber",e.setTerm(this.term),this.sortBy.split(",").forEach(t=>{e.addSorting(s.sort(t,this.sortDirection,this.naturalSorting))}),e.addAssociation("defaultBillingAddress").addAssociation("group").addAssociation("requestedGroup").addAssociation("boundSalesChannel"),this.filterCriteria.forEach(t=>{e.addFilter(t)}),e},filterSelectCriteria(){const e=new s(1,1);return e.addFilter(s.not("AND",[s.equals("affiliateCode",null),s.equals("campaignCode",null)])),e.addAggregation(s.terms("affiliateCodes","affiliateCode",null,null,null)),e.addAggregation(s.terms("campaignCodes","campaignCode",null,null,null)),e},listFilterOptions(){return{"customer-number-filter":{property:"customerNumber",type:"string-filter",label:this.$tc("sw-customer.filter.customerNumber.label"),placeholder:this.$tc("sw-customer.filter.customerNumber.placeholder"),valueProperty:"key",labelProperty:"key",criteriaFilterType:"equals"},"affiliate-code-filter":{property:"affiliateCode",type:"string-filter",label:this.$tc("sw-customer.filter.affiliateCode.label"),placeholder:this.$tc("sw-customer.filter.affiliateCode.placeholder"),valueProperty:"key",labelProperty:"key"},"campaign-code-filter":{property:"campaignCode",type:"string-filter",label:this.$tc("sw-customer.filter.campaignCode.label"),placeholder:this.$tc("sw-customer.filter.campaignCode.placeholder"),valueProperty:"key",labelProperty:"key"},"customer-group-request-filter":{property:"requestedGroupId",type:"existence-filter",label:this.$tc("sw-customer.filter.customerGroupRequest.label"),placeholder:this.$tc("sw-customer.filter.customerGroupRequest.placeholder"),optionHasCriteria:this.$tc("sw-customer.filter.customerGroupRequest.textHasCriteria"),optionNoCriteria:this.$tc("sw-customer.filter.customerGroupRequest.textNoCriteria")},"salutation-filter":{property:"salutation",label:this.$tc("sw-customer.filter.salutation.label"),placeholder:this.$tc("sw-customer.filter.salutation.placeholder"),labelProperty:"displayName"},"account-status-filter":{property:"active",label:this.$tc("sw-customer.filter.status.label"),placeholder:this.$tc("sw-customer.filter.status.placeholder")},"group-filter":{property:"group",label:this.$tc("sw-customer.filter.customerGroup.label"),placeholder:this.$tc("sw-customer.filter.customerGroup.placeholder")},"billing-address-country-filter":{property:"defaultBillingAddress.country",label:this.$tc("sw-customer.filter.billingCountry.label"),placeholder:this.$tc("sw-customer.filter.billingCountry.placeholder")},"shipping-address-country-filter":{property:"defaultShippingAddress.country",label:this.$tc("sw-customer.filter.shippingCountry.label"),placeholder:this.$tc("sw-customer.filter.shippingCountry.placeholder")},"tags-filter":{property:"tags",label:this.$tc("sw-customer.filter.tags.label"),placeholder:this.$tc("sw-customer.filter.tags.placeholder")}}},listFilters(){return this.filterFactory.create("customer",this.listFilterOptions)},assetFilter(){return Shopware.Filter.getByName("asset")},emailIdnFilter(){return Shopware.Filter.getByName("decode-idn-email")}},watch:{defaultCriteria:{handler(){this.getList()},deep:!0}},created(){this.createdComponent()},methods:{createdComponent(){return Promise.resolve()},onInlineEditSave(e,t){e.then(()=>{this.createNotificationSuccess({message:this.$tc("sw-customer.detail.messageSaveSuccess",{name:this.salutation(t)},0)})}).catch(()=>{this.getList(),this.createNotificationError({message:this.$tc("sw-customer.detail.messageSaveError")})})},async getList(){this.isLoading=!0;const e=await Shopware.Service("filterService").mergeWithStoredFilters(this.storeKey,this.defaultCriteria),t=await this.addQueryScores(this.term,e);if(this.activeFilterNumber=e.filters.length,!this.entitySearchable){this.isLoading=!1,this.total=0;return}this.freshSearchTerm&&t.resetSorting();try{const l=await this.customerRepository.search(t);this.total=l.total,this.customers=l,this.isLoading=!1,this.selection={}}catch{this.isLoading=!1}},onDelete(e){this.showDeleteModal=e},onCloseDeleteModal(){this.showDeleteModal=!1},onConfirmDelete(e){return this.showDeleteModal=!1,this.customerRepository.delete(e).then(()=>{this.getList()})},async onChangeLanguage(){await this.createdComponent(),await this.getList()},getCustomerColumns(){return[{property:"firstName",dataIndex:"lastName,firstName",inlineEdit:"string",label:"sw-customer.list.columnName",routerLink:"sw.customer.detail",width:"250px",allowResize:!0,primary:!0,useCustomSort:!0},{property:"company",label:"sw-customer.list.columnCompany",allowResize:!0,visible:!1,useCustomSort:!0},{property:"defaultBillingAddress.street",label:"sw-customer.list.columnStreet",allowResize:!0,useCustomSort:!0},{property:"defaultBillingAddress.zipcode",label:"sw-customer.list.columnZip",align:"right",allowResize:!0,useCustomSort:!0},{property:"defaultBillingAddress.city",label:"sw-customer.list.columnCity",allowResize:!0,useCustomSort:!0},{property:"customerNumber",dataIndex:"customerNumber",naturalSorting:!0,label:"sw-customer.list.columnCustomerNumber",allowResize:!0,inlineEdit:"string",align:"right",useCustomSort:!0},{property:"group",dataIndex:"group",naturalSorting:!0,label:"sw-customer.list.columnGroup",allowResize:!0,inlineEdit:"string",align:"right",useCustomSort:!0},{property:"email",inlineEdit:"string",label:"sw-customer.list.columnEmail",allowResize:!0,useCustomSort:!0},{property:"affiliateCode",inlineEdit:"string",label:"sw-customer.list.columnAffiliateCode",allowResize:!0,visible:!1,useCustomSort:!0},{property:"campaignCode",inlineEdit:"string",label:"sw-customer.list.columnCampaignCode",allowResize:!0,visible:!1,useCustomSort:!0},{property:"boundSalesChannelId",label:"sw-customer.list.columnBoundSalesChannel",allowResize:!0,visible:!1,useCustomSort:!0},{property:"active",inlineEdit:"boolean",label:"sw-customer.list.columnActive",allowResize:!0,visible:!1,useCustomSort:!0},{property:"createdAt",label:"sw-customer.list.columnCreatedAt",allowResize:!0}]},loadFilterValues(){return this.filterLoading=!0,this.customerRepository.search(this.filterSelectCriteria).then(({aggregations:e})=>{var t,l;return this.availableAffiliateCodes=((t=e==null?void 0:e.affiliateCodes)==null?void 0:t.buckets)??[],this.availableCampaignCodes=((l=e==null?void 0:e.campaignCodes)==null?void 0:l.buckets)??[],this.filterLoading=!1,e}).catch(()=>{this.filterLoading=!1})},updateCriteria(e){this.page=1,this.filterCriteria=e},async onBulkEditItems(){await this.$nextTick(),this.$router.push({name:"sw.bulk.edit.customer"})},onBulkEditModalOpen(){this.showBulkEditModal=!0},onBulkEditModalClose(){this.showBulkEditModal=!1}}};export{a as default};
