<?php if ($apartment->type == Apartment::TYPE_RENT) : ?>
    <?php
    $reservedDays = Bookingcalendar::getReservedDays($apartment->id);
    Yii::app()->clientScript->registerScript('reservedDays', '
			var reservedDays = ' . $reservedDays . ';
			var extremeDays = ' . CJavaScript::encode(Bookingcalendar::$extremeDays) . ';
		', CClientScript::POS_END);

    Yii::app()->clientScript->registerScript('resize-booking', '
			setTimeout(function(){
				$(".ui-datepicker").width("");
			}, 0);
		', CClientScript::POS_READY);

    ?>
    <div class="calendar-inner">
        <span><strong><?php echo tt('Periods of free / reserved apartment', 'bookingcalendar'); ?></strong>:</span>
        <div id="booking_calendar">
            <?php
            $this->widget('application.modules.bookingcalendar.extensions.Calendar', array(
                'name' => 'bookingCalendarDate' . $apartment->id,
                'options' => array(
                    'numberOfMonths' => 3,
                    'showAnim' => 'fold',
                    'dateFormat' => 'yy-mm-dd',
                    'showCurrentAtPos' => 0,
                    'minDate' => 0,
                ),
                'htmlOptions' => array(
                    'data-apId' => $apartment->id,
                ),
                'flat' => true,
                'language' => Yii::app()->controller->datePickerLang,
                'showDayForId' => $apartment->id,
            ));
            ?>
        </div>
        <div class="calendarDescription">
            <div class="calendarDescriptionReserved"></div>
            <div class="calendarDescriptionText"> - <?php echo tt('Reserved', 'bookingcalendar'); ?></div>
            <div class="calendarDescriptionFree"></div>
            <div class="calendarDescriptionText"> - <?php echo tt('Free', 'bookingcalendar'); ?></div>
        </div>
    </div>
<?php endif; ?>