import { useState, useRef, useEffect } from '@wordpress/element';
import { RenderScreenIcons } from './screen-icon';

export const LabelControl = (props) =>{
	
	const { label, prop } = props;
	
	var hasScreen = prop?.screen;
	var hasUnit = prop?.units;
	var default_unit = 0;
	var tmp_val = prop['c']['val'];
	
	// Get unit from value
	if(hasUnit && !(pagelayer_empty(tmp_val))){
		for(var i in prop['units']){
			if(pagelayer_is_string(tmp_val) && tmp_val.search(prop['units'][i]) != -1){
				default_unit = i;
			}else if(typeof tmp_val === 'object' && tmp_val[0].search(prop['units'][i]) != -1 ){
				default_unit = i;
			}
		}
	}
	
	const [selectedUnit, setSelectedUnit] = useState(default_unit);
	
	const handleUnitChange = (index) => {
		setSelectedUnit(index);
		// Perform any actions based on the selected unit change
	};
	
	return (
		<div className="pagelayer-elp-label-div">
			<label className="pagelayer-elp-label">{label}</label>
				{hasScreen && <RenderScreenIcons {...props}/>}
				{hasUnit && <div className="pagelayer-elp-units">
					{prop.units.map((unit, index) => (
						<span
							key={index}
							onClick={() => handleUnitChange(index)}
							className={index == selectedUnit ? 'selected' : ''}
						>
							{unit}
						</span>
					))}
				</div> }
		</div>
	);	
}
