import { LabelControl } from './label';
import { pagelayer_link_font_family } from './typography';
const { pagelayer_fonts } = pagelayer_config;

export const FontFamilyControl = (props) =>{
	const { prop, value, setAttributes } = props;
	const { name } = prop['c'];
	
	var values = pagelayerParseTypo(value, false);

	// Convert the jQuery function to a React method
	const handleInputChange = (e) => {
		pagelayer_link_font_family(jQuery(e.target));
		setAttributes({ [name]: e.target.value });
	};

	const options = [];
	const createFontOption = (val, lang, type, setVal) => {
		const selected = val !== setVal ? '' : 'selected="selected"';
		const displayLang = lang || 'Default';
		return (
			<option
				className="pagelayer-elp-select-option"
				value={val}
				type={type}
				selected={selected}
			>
				{displayLang}
			</option>
		);
	};

	for(const y in pagelayer_fonts){
		if(y != 'default'){
			options.push(<optgroup label={pagelayerUcwords(y)} />);
		}

		for (const x in pagelayer_fonts[y]) {
			options.push(
				createFontOption(
					jQuery.isNumeric(x) ? pagelayer_fonts[y][x] : x,
					pagelayer_fonts[y][x],
					y,
					values[0]
				)
			);
		}
	}

	return (
		<div className="components-base-control pagelayer-base-control">
			<LabelControl {...props}/>
			<div class="pagelayer-elp-select-div pagelayer-elp-pos-rel">
				<select className="pagelayer-elp-select pagelayer-select" onChange={handleInputChange} name={prop.c['name']}>{options}</select>
			</div>
		</div>
	);
}

 