# -*- coding: utf-8 -*-
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
#

from clcommon.cpapi import (
    getCPName,
    PLESK_NAME,
    DIRECTADMIN_NAME,
    CPANEL_NAME
)

cp_name = getCPName()
if cp_name == CPANEL_NAME:
    from clcommon.public_hooks.bundle.cpanel import install_hooks, remove_hooks
elif cp_name == DIRECTADMIN_NAME:
    from clcommon.public_hooks.bundle.directadmin import install_hooks, remove_hooks
elif cp_name == PLESK_NAME:
    from clcommon.public_hooks.bundle.plesk import install_hooks, remove_hooks
else:
    # just do nothing on other
    # not supported control panels
    def install_hooks(): pass  # NOQA
    def remove_hooks(): pass  # NOQA
