#!/opt/cloudlinux/venv/bin/python3 -bb
# -*- coding: utf-8 -*-
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
#
"""
User PRE modification hook.
This script must be called BEFORE different user-related
changes in control panel. See --help and docs for detailed
description of actions and parameters.
"""
import argparse

from clcommon.public_hooks.lib import ModifyUserHook
from clcommon.public_hooks import setup_logger_and_sentry


if __name__ == '__main__':
    setup_logger_and_sentry()

    parser = argparse.ArgumentParser(description=__doc__)
    subparsers = parser.add_subparsers(dest='command')

    delete = subparsers.add_parser(
        'delete', help='call this command before user has been deleted')
    delete.add_argument('--username', '-u', required=True,
                        help='Name of a deleted account')

    args = parser.parse_args()

    listener = ModifyUserHook()
    if args.command == 'delete':
        listener.pre_delete_user(
            username=args.username)
    else:
        raise NotImplementedError
