#!/opt/cloudlinux/venv/bin/python3 -bb
# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
#
"""
User POST modification hook.
This script must be called AFTER different user-related
changes in control panel. See --help and docs for detailed
description of actions and parameters.
"""
import argparse

from clcommon.public_hooks.lib import ModifyUserHook
from clcommon.public_hooks import setup_logger_and_sentry


if __name__ == '__main__':
    setup_logger_and_sentry()

    parser = argparse.ArgumentParser(description=__doc__)
    subparsers = parser.add_subparsers(dest='command')

    create = subparsers.add_parser(
        'create', help='call this command when new system user has been created')
    create.add_argument('--username', '-u', required=True,
                        help='Name of a newly created account')
    create.add_argument('--owner', '-o', required=True,
                        help='User owner: admin or reseller name')

    modify = subparsers.add_parser(
        'modify', help='call this command when user account has been modifed')
    modify.add_argument('--username', '-u', required=True,
                        help='Name of the account')
    modify.add_argument('--new-username', required=False,
                        help='Username after rename')
    modify.add_argument('--new-owner', required=False,
                        help='Name of the new vendor of account. '
                             'Can be admin or reseller.')

    restore = subparsers.add_parser(
        'restore', help='call this command when user has been restored')
    restore.add_argument('--username', '-u', required=True,
                         help='Name of the account')

    delete = subparsers.add_parser(
        'delete', help='call this command when user has been deleted')
    delete.add_argument('--username', '-u', required=True,
                        help='Name of a deleted account')

    args = parser.parse_args()

    listener = ModifyUserHook()
    if args.command == 'create':
        listener.post_create_user(
            username=args.username,
            owner=args.owner)
    elif args.command == 'modify':
        listener.post_modify_user(
            username=args.username,
            new_name=args.new_username,
            new_owner=args.new_owner)
    elif args.command == 'restore':
        listener.post_restore_user(
            username=args.username)
    elif args.command == 'delete':
        listener.post_delete_user(
            username=args.username)
    else:
        raise NotImplementedError
