<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/OSL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)
 */

namespace PrestaShop\PrestaShop\Adapter\Cache\Clearer;

use Psr\Log\LoggerInterface;
use Throwable;

trait SafeLoggerTrait
{
    protected readonly LoggerInterface $logger;

    protected function logError(string $message): void
    {
        try {
            $this->logger->error($message);
        } catch (Throwable) {
            // Prevent the logger from raising an exception and breaking the cache clear
        }
    }

    protected function logWarning(string $message): void
    {
        try {
            $this->logger->warning($message);
        } catch (Throwable) {
            // Prevent the logger from raising an exception and breaking the cache clear
        }
    }

    protected function logInfo(string $message): void
    {
        try {
            $this->logger->info($message);
        } catch (Throwable) {
            // Prevent the logger from raising an exception and breaking the cache clear
        }
    }

    protected function logDebug(string $message): void
    {
        try {
            $this->logger->debug($message);
        } catch (Throwable) {
            // Prevent the logger from raising an exception and breaking the cache clear
        }
    }
}
