# Release 2024.4
Here you will find all the important new features and release notes of the Platform Version 2024.4 release.

## Most Important New Features

### OpenSearch and Elasticsearch support
Based on community feedback and recent changes in Elasticsearch's licensing policy, Platform Version 2024.4 will support
both Elasticsearch and OpenSearch. This ensures flexibility to choose the search engine that best fits your needs. While
we are committed to supporting both options for now, we will continue to monitor their development and licensing
policies. Depending on future changes, we may need to reevaluate and decide for one technology.

For more details see
- [Generic Data Index](https://docs.pimcore.com/platform/Generic_Data_Index/Configuration/Elasticsearch)
- [Datahub Simple Rest API](https://docs.pimcore.com/platform/Datahub_Simple_Rest/Configuration/Elasticsearch)
- [E-Commerce Framework](https://docs.pimcore.com/platform/Ecommerce_Framework/Index_Service/Product_Index_Configuration/Elastic_Search/)
- [Statistics Explorer](https://docs.pimcore.com/platform/Statistics_Explorer/Installation_and_Configuration/#setup-data-sources)

### Ecommerce framework OpenSearch support
In the light of OpenSearch and Elasticsearch support, we also expanded the Ecommerce Framework to support OpenSearch,
providing greater flexibility in choosing the search engine. 
For details see [Documentation](https://docs.pimcore.com/platform/Ecommerce_Framework/Index_Service/Product_Index_Configuration/Open_Search/).

### Quill as new default WYSIWYG editor
Due to changes in TinyMCE’s licensing model, we were required to find a new WYSIWYG editor. After careful research
we’ve chosen [Quill](https://quilljs.com/) as replacement.

Starting with Platform Version 2024.4, both TinyMCE and Quill will be supported, but TinyMCE will be
deprecated. From Platform Version 2025.1 onward, Quill will be the only supported WYSIWYG editor.

More Details see [Pimcore Quill Documentation](https://docs.pimcore.com/platform/Quill_WYSWIYG_Editor/).


### New simple rest adapter for headless documents in Datahub

The new REST endpoint in Pimcore Datahub provides external applications with straightforward access to headless document
data in JSON format. Unlike the more complex default GraphQL endpoint, this REST adapter provides simple REST queries
for the full content of headless documents. This simplifies data access and significantly reduces implementation efforts.

More details see [Headless Documents Documentation](https://docs.pimcore.com/platform/Headless_Documents/DataHub_Integration/).


### Symfony Flex Support
With Pimcore Version 2024.4 Pimcore allows developers to optionally use symfony/flex and so install third party
dependencies via flex.
This is done by adding a default ```symfony.lock``` to the skeleton that contains all the packages which are used by
stock Pimcore.
With that file in place it's safe to run ```composer require symfony/flex``` and you can easily install additional
bundles using Flex, e.g. composer ```require nelmio/api-doc-bundle```.


## Additional improvements and housekeeping
Alongside the new features, the following improvements and housekeeping have been implemented:

### Dependency Upgrades
We upgraded dependencies where possible without causing any backward compatibility (BC)
breaks and providing a solid foundation for LTS.

### Datahub and Adapters
- GraphQL
  - Performance optimized permission check to use an in-memory object in GraphQL endpoints
  - Disabling of language fallback
  - Added CsFeature title
  - Generate static typename for element metadata key value pairs
- Simple Rest API
  - Enhanced indexing performance in Simple Rest API
  - Added Support for Elasticsearch
- File Export
  - Added http header authentication in File Export pushes
  - Flysystem for storages support in File Export
- Webhooks 
  - Allow custom values in header for Webhooks
- Data Importer
  - Add SQL Data Source
  - Make `As Numeric` operator return nullable
  - Automatically set imported element userModification
  - CSV Data Source with skipFirstRow should use row headings rather than row index

### Pimcore Document Blocks - Prepare Twig 4 compatibility
For Twig 4 compatibility there are two new Twig extensions for creating Pimcore Document blocks:
`pimcoreblock` and `pimcoremanualblock`. These extensions use the Twig Node internally,
allowing Twig 4 support in the future and will replace the now deprecated `pimcore_block` implementation.

More Details see [Pimcore Documentation](https://docs.pimcore.com/platform/Pimcore/Documents/Editables/Block#basic-usage).

### Core Framework
- Added possibility to configure which metadata to be used as ```alt```, ```copyright```, ```title```
- Image processing: possibility to configure the image adapter
- Optimize Document Thumbnail generation
- Add checks for setting QuantityValue values and units
- Add more elements to html_sanitizer
- Added ```versionCount``` index to element and versions table
- Deprecate TinyMCE
- Add Deprecation to remove context from `ResolveUploadTargetEvent`


### Admin UI classic bundle
- Improved grid loading performance with multiple roles
- Added context for Blocks/bricks/fieldcollection for select and multiselect option provider
- Set default issuer to "Pimcore" instead of "Pimcore 2 Factor Authentication"

### Pimcore Copilot bundle
- Allow custom values in header for webhook action step.
- Deprecation of the internal Execution Engine - use the Generic Execution Engine instead. Details
  see the [migration guide](https://docs.pimcore.com/platform/Copilot/Upgrade_Notes/Migrate_From_JEE_To_GEE/).

### Generic Data Index
- Index default asset metadata
- Added support for Elasticsearch

### Asset Metadata Class Definitions
- Add field definition adapters for generic data index bundle

### Portal Engine
- Added Elasticsearch support via Generic Data Index
- Added Public Share permission on Data Pool level
- Use common adapter from Generic Data Index
- Added backticks to reserved keyword  ```groups```

### Direct Edit
- Also implement JWT in clientside
- Allow different JWT keys for publisher and subscriber

### OpenID Connect
- Replace abandoned JWT packages
- Upgrade web-token/jwt-signature* dependencies


## Upgrade Notes

Before updating, also have a look at the following upgrade notes if relevant to your system:
- [Core Framework](https://docs.pimcore.com/platform/Pimcore/Installation_and_Upgrade/Upgrade_Notes/#pimcore-1150)
- [Datahub File Export](https://docs.pimcore.com/platform/Datahub_File_Export/Installation/Upgrade#upgrade-to-220)
- [Data Importer](https://docs.pimcore.com/platform/Data_Importer/Upgrade)
- [Direct Edit](https://docs.pimcore.com/platform/Direct_Edit/Installation/Upgrade_notes#update-to-version-21)
- [Generic Data Index](https://docs.pimcore.com/platform/Generic_Data_Index/Installation/Upgrade#upgrade-to-130)
- [Headless Documents](https://docs.pimcore.com/platform/Headless_Documents/Installation/Upgrade#update-to-version-23)
- [OpenId Connect](https://docs.pimcore.com/platform/OpenID_Connect/Upgrade_Notes#120)
- [Portal Engine](https://docs.pimcore.com/platform/Portal_Engine/Installation/Upgrade#upgrade-to-420)
- [Translation Provider Interfaces](https://docs.pimcore.com/platform/Translation_Provider_Interfaces/Installation_and_Configuration/Upgrade#update-to-version-31)
- [Workflow Designer](https://docs.pimcore.com/platform/Worfklow_Designer/Upgrade#update-to-version-14)
