<?php
declare(strict_types=1);

/**
 * Pimcore
 *
 * This source file is available under two different licenses:
 * - GNU General Public License version 3 (GPLv3)
 * - Pimcore Commercial License (PCL)
 * Full copyright and license information is available in
 * LICENSE.md which is distributed with this source code.
 *
 *  @copyright  Copyright (c) Pimcore GmbH (http://www.pimcore.org)
 *  @license    http://www.pimcore.org/license     GPLv3 and PCL
 */

namespace Pimcore\Bundle\CoreBundle\DependencyInjection\Compiler;

use Pimcore\Routing\Loader\AnnotatedRouteControllerLoader;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Set annotation loader to our own implementation normalizing admin routes: converts the prefix
 * pimcore_pimcoreadmin_ to just pimcore_admin_
 *
 * @internal
 */
final class RoutingLoaderPass implements CompilerPassInterface
{
    /**
     * Replace Annotated Routing loader with your implementation to normalizes autogenerated admin routes
     */
    public function process(ContainerBuilder $container): void
    {
        if (!$container->hasDefinition('routing.loader.annotation')) {
            return;
        }

        $definition = $container->getDefinition('routing.loader.annotation');
        $definition->setClass(AnnotatedRouteControllerLoader::class);
    }
}
