import { RichText, InnerBlocks } from '@wordpress/blockEditor';

// Render block on editor
export const SaveBlocks = (props) => {
	
	const { pl_props, attributes } = props;
		
	// Check if innerBlocks exists
	if(props.innerBlocks && props.innerBlocks.length > 0) {
		return (
			<InnerBlocks.Content />
		);
	}
	
	// Is there an innerHTML ele
	if(pl_props && pl_props.innerHTML) {
		var inner = pl_props['innerHTML'];
		if(! pagelayer_empty(attributes[inner]) ){
			return <RichText.Content value={attributes[inner]} />;
		}
	}

	// Return null if pl_props is missing or has_group is false
	return null;
}