export const addDynamicStyles = () => {
	setTimeout( () => {
		const getAllIFrames = document.querySelectorAll('iframe[name="editor-canvas"]');
		if ( ! getAllIFrames?.length ) {
			return;
		}

		const cloneLinkTag = ( linkId ) => {
			const getTag = document.getElementById( linkId );
			return getTag ? getTag.cloneNode( true ) : false;
		}

		const cloneStyleTag = ( styleId ) => {
			const getStyleTag = document.getElementById( styleId );
			return getStyleTag ? getStyleTag.textContent : false;
		}

		for ( const iterateIFrames of getAllIFrames ) {
			const iframeDocument = iterateIFrames?.contentWindow.document || iterateIFrames?.contentDocument;
			
			if( ! iframeDocument?.head ){
				continue;
			}

			const copyLinkTag = ( tagId ) => {
				const isExistTag = iframeDocument.getElementById( tagId );
				if ( isExistTag ) return;
				
				const clonedTag = cloneLinkTag( tagId );
				if ( ! clonedTag ) return;
				
				iframeDocument.head.appendChild( clonedTag );
			}

			const copyStyleTag = ( tagId ) => {
				const clonedTag = cloneStyleTag( tagId );
				if ( ! clonedTag ) return;
				
				const isExistTag = iframeDocument.getElementById( tagId );
				if( ! isExistTag ){
					const node = document.createElement( 'style' )
					node.setAttribute( 'id', tagId );
					node.textContent = clonedTag;
					iframeDocument.head.appendChild( node )
				}else{
					isExistTag.textContent = clonedTag
				}
			}

			copyLinkTag( 'dashicons-css' );
			copyLinkTag( 'pagelayer-block-icon-css' );
			copyLinkTag( 'pagelayer-block-editor-css' );
			copyLinkTag( 'pagelayer-frontend-css' );
			copyLinkTag( 'mediaelement-css' );

			copyStyleTag( 'pagelayer-block-global-style' );
			copyStyleTag( 'pagelayer-global-styles' );
			
			jQuery(iframeDocument).off('click.pliframeclick').on('click.pliframeclick', '[pagelayer-id]', function(e){
				e.preventDefault(); // We also did this in the pagelayer editor
			});
		}
	} );
};
