import { __ } from '@wordpress/i18n';
import { ColorPicker, Popover  } from '@wordpress/components';
import { useState, useEffect, useRef } from '@wordpress/element';
import { LabelControl } from './label';

export const ColorControl = (props) => {
		
	const { prop, value, setAttributes } = props;
	const { name } = prop['c'];

	const onChange = (color = '') => {
		setAttributes({ [name]: color});
	}

	const handleGlobalColor = (item) => {
		setAttributes({ [name]: '$' + item });
	}
	
	return (
		<div className="components-base-control pagelayer-base-control">
			<LabelControl {...props}/>
			<ColorPickerControl 
				name={name} 
				value={value} 
				onChange = {onChange}  
				setAttributes={setAttributes} 
				type ={prop.type}
				handleClick ={handleGlobalColor}
			/>
		</div>
	);	
}

// Color picker 
export const ColorPickerControl = (props) => {
	const { name, value, onChange, setAttributes, type, handleClick, showRemoveIcon = true } = props;
	const [showPicker, setShowPicker] = useState(false);
	const holderDiv = useRef(null);
	const colorPickerRef = useRef(null);
	const colorPopoverRef = useRef(null);
	const globalRef = useRef(null);
	
	let val = value;
	var is_global = pagelayerIsGlobalColor(val);
	var global_active = '';

	// If global color exist
	if (!pagelayer_empty(is_global)) {
		val = pagelayer_global_colors[is_global]['value'];
		global_active = 'pagelayer-active-global';
	}

	useEffect(() => {
		const handleDocumentClick = (e) => {
			if (
				colorPickerRef.current &&
				colorPopoverRef.current &&
				!colorPickerRef.current.contains(e.target) &&
				!colorPopoverRef.current.contains(e.target)
			) {
				setShowPicker(false);
			}
			
			// Global color handler
			if (
				globalRef.current &&
				!globalRef.current.contains(e.target)
			) {
				jQuery(holderDiv.current).find('.pagelayer-global-color-list').slideUp();
			}
		};
		document.addEventListener('click', handleDocumentClick);

		return () => {
			document.removeEventListener('click', handleDocumentClick);
		};
	}, []);

	useEffect(() => {
		
		let list = jQuery(holderDiv.current).find('.pagelayer-global-color-list');
		jQuery(holderDiv.current).find('.pagelayer-elp-color-global').on('click', function (e) {
			e.stopPropagation();
			list.slideToggle();
			setShowPicker(false);
		});
		
		jQuery(holderDiv.current).find('.pagelayer-global-color-list-item').on('click', function (e) {
			list.slideUp();
		});
		
	}, [])

	const handleGlobalLink = (e) =>{
		e.stopPropagation();
		window.open(pagelayer_customizer_url + '&autofocus%5Bsection%5D=pagelayer_global_colors_sec', '_blank');
	}

	var blank = 'pagelayer-blank-preview';
	var preView = {};
	
	if(!pagelayer_empty(value)){
		blank = '';
		preView = { backgroundColor: is_global ? val : value };
	}

	const onRemoveColor = () => {
		setAttributes({ [name]: '' });
		setShowPicker(false);
	}

	return (
		<div className="pagelayer-elp-color-div-holder" ref={holderDiv}>
			<div className={`pagelayer-elp-color-global ${global_active}`}></div>
			<div className="pagelayer-elp-color-div" ref={colorPickerRef}>
				<div
					className={`pagelayer-elp-color-preview ${blank}`}
					onClick={() => setShowPicker(!showPicker)}
					style={preView}
				>
				</div>
				{ showRemoveIcon && <span
						className="pagelayer-elp-remove-color"
						onClick={() => { onRemoveColor() }}
					><i className="pli pli-cross" ></i></span>
				}
				{showPicker && <Popover ref={colorPopoverRef}>
					<ColorPicker
						color={value || ""}
						onChangeComplete={(val) => {
							if (val.rgb) {
								onChange(
									val.rgb.a != 1
										? "rgba(" +
												val.rgb.r +
												"," +
												val.rgb.g +
												"," +
												val.rgb.b +
												"," +
												val.rgb.a +
												")"
										: val.hex
								);
							}
						}}
						disableAlpha={false}
					/>
				</Popover> }
			</div>
			<div className="pagelayer-global-color-list" ref={globalRef}>
				<div className="pagelayer-global-setting-color">
					<b>{ __('Global Colors') }</b>
					<span className="pli pli-service" onClick={handleGlobalLink}></span>
				</div>
				{
					Object.keys(pagelayer_global_colors).map(items => {
						const color = pagelayer_global_colors[items];
						const activeClass = items === is_global ? 'pagelayer-global-selected' : '';
						return (
							<div
								key={items}
								className={`pagelayer-global-color-list-item ${activeClass}`}
								data-global-id={items}
								onClick={() =>handleClick(items)}
							>
								<span className="pagelayer-global-color-pre" style={{ background: color.value }}></span>
								<span className="pagelayer-global-color-title">{color.title}</span>
								<span className="pagelayer-global-color-code">{color.value}</span>
							</div>
						)
					})
				}
			</div>
		</div>
	);	
}
