import { useState, useEffect, useRef } from '@wordpress/element';
import { useBlockProps, RichText } from '@wordpress/block-editor';

export const RenderQuoteBlock = (props) =>{
	
	const { _props, pl_props, tag, data } = props;
	const { setAttributes } = _props;
	const { atts : attributes} = data;
	
	return (
		<>
			<div className={`pagelayer-quote-holder pagelayer-quote-${attributes?.quote_style}`}>
				{ attributes?.quotation_pos && (
					<i className={`fa fa-quote-left pagelayer-quotation-${attributes.quotation_pos}`}></i>
				)}
				<div className="pagelayer-quote-content">
					{ attributes?.double_indent && ( <i className="fa fa-quote-left"></i> )}
					<RichText
						key="editable"
						tagName="span"
						keepPlaceholderOnFocus
						placeholder={"Add Quote description..."}
						onChange={(value) => setAttributes({ quote_content: value })}
						value={attributes.quote_content}
					/>
					{ attributes?.double_indent && ( <i className="fa fa-quote-right"></i> )}
				</div>
				<div className="pagelayer-quote-cite">
					{ attributes?.cite_url ? (
						<a href={attributes.cite_url} className="pagelayer-link-sel" onClick={(event)=> event.preventDefault()}>
							<RichText
								key="editable"
								tagName="span"
								className="pagelayer-cite-holder"
								keepPlaceholderOnFocus
								placeholder={"Add Cite..."}
								onChange={(value) => setAttributes({ cite: value })}
								value={attributes.cite}
							/>
						</a>
					) : (
						<RichText
							key="editable"
							tagName="span"
							className="pagelayer-cite-holder"
							keepPlaceholderOnFocus
							placeholder={"Add Cite..."}
							onChange={(value) => setAttributes({ cite: value })}
							value={attributes.cite}
						/>
					)}
				</div>
			</div>
		</>
	);
}
