SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `ojs33022`
--
-- --------------------------------------------------------

--
-- Table structure for table `access_keys`
--

CREATE TABLE `access_keys` (
  `access_key_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context` varchar(40) NOT NULL,
  `key_hash` varchar(40) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  `expiry_date` datetime NOT NULL,
  PRIMARY KEY (`access_key_id`),
  KEY `access_keys_hash` (`key_hash`,`user_id`,`context`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcements`
--

CREATE TABLE `announcements` (
  `announcement_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` smallint(6) DEFAULT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `type_id` bigint(20) DEFAULT NULL,
  `date_expire` date DEFAULT NULL,
  `date_posted` datetime NOT NULL,
  PRIMARY KEY (`announcement_id`),
  KEY `announcements_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_settings`
--

CREATE TABLE `announcement_settings` (
  `announcement_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) DEFAULT NULL,
  UNIQUE KEY `announcement_settings_pkey` (`announcement_id`,`locale`,`setting_name`),
  KEY `announcement_settings_announcement_id` (`announcement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_types`
--

CREATE TABLE `announcement_types` (
  `type_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` smallint(6) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  PRIMARY KEY (`type_id`),
  KEY `announcement_types_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement_type_settings`
--

CREATE TABLE `announcement_type_settings` (
  `type_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `announcement_type_settings_pkey` (`type_id`,`locale`,`setting_name`),
  KEY `announcement_type_settings_type_id` (`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `authors`
--

CREATE TABLE `authors` (
  `author_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email` varchar(90) NOT NULL,
  `include_in_browse` smallint(6) NOT NULL DEFAULT '1',
  `publication_id` bigint(20) NOT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00',
  `user_group_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`author_id`),
  KEY `authors_publication_id` (`publication_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `author_settings`
--

CREATE TABLE `author_settings` (
  `author_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  UNIQUE KEY `author_settings_pkey` (`author_id`,`locale`,`setting_name`),
  KEY `author_settings_author_id` (`author_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `auth_sources`
--

CREATE TABLE `auth_sources` (
  `auth_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(60) NOT NULL,
  `plugin` varchar(32) NOT NULL,
  `auth_default` smallint(6) NOT NULL DEFAULT '0',
  `settings` text,
  PRIMARY KEY (`auth_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `category_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `context_id` bigint(20) NOT NULL,
  `parent_id` bigint(20) NOT NULL,
  `seq` bigint(20) DEFAULT NULL,
  `path` varchar(255) NOT NULL,
  `image` text,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `category_path` (`context_id`,`path`),
  KEY `category_context_id` (`context_id`,`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `category_settings`
--

CREATE TABLE `category_settings` (
  `category_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  UNIQUE KEY `category_settings_pkey` (`category_id`,`locale`,`setting_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `citations`
--

CREATE TABLE `citations` (
  `citation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `publication_id` bigint(20) NOT NULL DEFAULT '0',
  `raw_citation` text NOT NULL,
  `seq` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`citation_id`),
  UNIQUE KEY `citations_publication_seq` (`publication_id`,`seq`),
  KEY `citations_publication` (`publication_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `citation_settings`
--

CREATE TABLE `citation_settings` (
  `citation_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `citation_settings_pkey` (`citation_id`,`locale`,`setting_name`),
  KEY `citation_settings_citation_id` (`citation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `completed_payments`
--

CREATE TABLE `completed_payments` (
  `completed_payment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `payment_type` bigint(20) NOT NULL,
  `context_id` bigint(20) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `assoc_id` bigint(20) DEFAULT NULL,
  `amount` double(8,2) NOT NULL,
  `currency_code_alpha` varchar(3) DEFAULT NULL,
  `payment_method_plugin_name` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`completed_payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocabs`
--

CREATE TABLE `controlled_vocabs` (
  `controlled_vocab_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `symbolic` varchar(64) NOT NULL,
  `assoc_type` bigint(20) NOT NULL DEFAULT '0',
  `assoc_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`controlled_vocab_id`),
  UNIQUE KEY `controlled_vocab_symbolic` (`symbolic`,`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocab_entries`
--

CREATE TABLE `controlled_vocab_entries` (
  `controlled_vocab_entry_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `controlled_vocab_id` bigint(20) NOT NULL,
  `seq` double(8,2) DEFAULT NULL,
  PRIMARY KEY (`controlled_vocab_entry_id`),
  KEY `controlled_vocab_entries_cv_id` (`controlled_vocab_id`,`seq`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `controlled_vocab_entry_settings`
--

CREATE TABLE `controlled_vocab_entry_settings` (
  `controlled_vocab_entry_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL,
  UNIQUE KEY `c_v_e_s_pkey` (`controlled_vocab_entry_id`,`locale`,`setting_name`),
  KEY `c_v_e_s_entry_id` (`controlled_vocab_entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `custom_issue_orders`
--

CREATE TABLE `custom_issue_orders` (
  `issue_id` bigint(20) NOT NULL,
  `journal_id` bigint(20) NOT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00',
  UNIQUE KEY `custom_issue_orders_pkey` (`issue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `custom_section_orders`
--

CREATE TABLE `custom_section_orders` (
  `issue_id` bigint(20) NOT NULL,
  `section_id` bigint(20) NOT NULL,
  `seq` double(8,2) NOT NULL DEFAULT '0.00',
  UNIQUE KEY `custom_section_orders_pkey` (`issue_id`,`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `data_object_tombstones`
--

CREATE TABLE `data_object_tombstones` (
  `tombstone_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `data_object_id` bigint(20) NOT NULL,
  `date_deleted` datetime NOT NULL,
  `set_spec` varchar(255) NOT NULL,
  `set_name` varchar(255) NOT NULL,
  `oai_identifier` varchar(255) NOT NULL,
  PRIMARY KEY (`tombstone_id`),
  KEY `data_object_tombstones_data_object_id` (`data_object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `data_object_tombstone_oai_set_objects`
--

CREATE TABLE `data_object_tombstone_oai_set_objects` (
  `object_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tombstone_id` bigint(20) NOT NULL,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  PRIMARY KEY (`object_id`),
  KEY `data_object_tombstone_oai_set_objects_tombstone_id` (`tombstone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `data_object_tombstone_settings`
--

CREATE TABLE `data_object_tombstone_settings` (
  `tombstone_id` bigint(20) NOT NULL,
  `locale` varchar(14) NOT NULL DEFAULT '',
  `setting_name` varchar(255) NOT NULL,
  `setting_value` text,
  `setting_type` varchar(6) NOT NULL COMMENT '(bool|int|float|string|object)',
  UNIQUE KEY `data_object_tombstone_settings_pkey` (`tombstone_id`,`locale`,`setting_name`),
  KEY `data_object_tombstone_settings_tombstone_id` (`tombstone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `edit_decisions`
--

CREATE TABLE `edit_decisions` (
  `edit_decision_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `review_round_id` bigint(20) NOT NULL,
  `stage_id` bigint(20) DEFAULT NULL,
  `round` smallint(6) NOT NULL,
  `editor_id` bigint(20) NOT NULL,
  `decision` smallint(6) NOT NULL,
  `date_decided` datetime NOT NULL,
  PRIMARY KEY (`edit_decision_id`),
  KEY `edit_decisions_submission_id` (`submission_id`),
  KEY `edit_decisions_editor_id` (`editor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_log`
--

CREATE TABLE `email_log` (
  `log_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `assoc_type` bigint(20) NOT NULL,
  `assoc_id` bigint(20) NOT NULL,
  `sender_id` bigint(20) NOT NULL,
  `date_sent` datetime NOT NULL,
  `event_type` bigint(20) DEFAULT NULL,
  `from_address` varchar(255) DEFAULT NULL,
  `recipients` text,
  `cc_recipients` text,
  `bcc_recipients` text,
  `subject` varchar(255) DEFAULT NULL,
  `body` text,
  PRIMARY KEY (`log_id`),
  KEY `email_log_assoc` (`assoc_type`,`assoc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_log_users`
--

CREATE TABLE `email_log_users` (
  `email_log_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  UNIQUE KEY `email_log_user_id` (`email_log_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `email_templates`
--

CREATE TABLE `email_templates` (
  `email_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email_key` varchar(64) NOT NULL COMMENT 'Unique identifier for this email.',
  `context_id` bigint(20) NOT NULL,
  `enabled` smallint(6) NOT NULL DEFAULT '1',
  PRIMARY KEY (`email_id`),
  UNIQUE KEY `email_templates_email_key` (`email_key`,`context_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_templates_default`
--

CREATE TABLE `email_templates_default` (
  `email_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email_key` varchar(64) NOT NULL COMMENT 'Unique identifier for this email.',
  `can_disable` smallint(6) NOT NULL DEFAULT '0',
  `can_edit` smallint(6) NOT NULL DEFAULT '0',
  `from_role_id` bigint(20) DEFAULT NULL,
  `to_role_id` bigint(20) DEFAULT NULL,
  `stage_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`email_id`),
  KEY `email_templates_default_email_key` (`email_key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=59 ;

--
-- Dumping data for table `email_templates_default`
--

INSERT INTO `email_templates_default` VALUES
(1, 'NOTIFICATION', 0, 1, NULL, NULL, NULL),
(2, 'NOTIFICATION_CENTER_DEFAULT', 0, 1, NULL, NULL, NULL),
(3, 'PASSWORD_RESET_CONFIRM', 0, 1, NULL, NULL, NULL),
(4, 'USER_REGISTER', 0, 1, NULL, NULL, NULL),
(5, 'USER_VALIDATE', 0, 1, NULL, NULL, NULL),
(6, 'REVIEWER_REGISTER', 0, 1, NULL, NULL, NULL),
(7, 'PUBLISH_NOTIFY', 0, 1, NULL, NULL, NULL),
(8, 'LOCKSS_EXISTING_ARCHIVE', 0, 1, NULL, NULL, NULL),
(9, 'LOCKSS_NEW_ARCHIVE', 0, 1, NULL, NULL, NULL),
(10, 'SUBMISSION_ACK', 1, 1, NULL, 65536, 1),
(11, 'SUBMISSION_ACK_NOT_USER', 1, 1, NULL, 65536, 1),
(12, 'EDITOR_ASSIGN', 1, 1, 16, 16, 1),
(13, 'REVIEW_CANCEL', 1, 1, 16, 4096, 3),
(14, 'REVIEW_REINSTATE', 1, 1, 16, 4096, 3),
(15, 'REVIEW_REQUEST', 1, 1, 16, 4096, 3),
(16, 'REVIEW_REQUEST_SUBSEQUENT', 1, 1, 16, 4096, 3),
(17, 'REVIEW_REQUEST_ONECLICK', 1, 1, 16, 4096, 3),
(18, 'REVIEW_REQUEST_ONECLICK_SUBSEQUENT', 1, 1, 16, 4096, 3),
(19, 'REVIEW_REQUEST_ATTACHED', 0, 1, 16, 4096, 3),
(20, 'REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 0, 1, 16, 4096, 3),
(21, 'REVIEW_REQUEST_REMIND_AUTO', 0, 1, NULL, 4096, 3),
(22, 'REVIEW_REQUEST_REMIND_AUTO_ONECLICK', 0, 1, NULL, 4096, 3),
(23, 'REVIEW_CONFIRM', 1, 1, 4096, 16, 3),
(24, 'REVIEW_DECLINE', 1, 1, 4096, 16, 3),
(25, 'REVIEW_ACK', 1, 1, 16, 4096, 3),
(26, 'REVIEW_REMIND', 0, 1, 16, 4096, 3),
(27, 'REVIEW_REMIND_AUTO', 0, 1, NULL, 4096, 3),
(28, 'REVIEW_REMIND_ONECLICK', 0, 1, 16, 4096, 3),
(29, 'REVIEW_REMIND_AUTO_ONECLICK', 0, 1, NULL, 4096, 3),
(30, 'EDITOR_DECISION_ACCEPT', 0, 1, 16, 65536, 3),
(31, 'EDITOR_DECISION_SEND_TO_EXTERNAL', 0, 1, 16, 65536, 3),
(32, 'EDITOR_DECISION_SEND_TO_PRODUCTION', 0, 1, 16, 65536, 5),
(33, 'EDITOR_DECISION_REVISIONS', 0, 1, 16, 65536, 3),
(34, 'EDITOR_DECISION_RESUBMIT', 0, 1, 16, 65536, 3),
(35, 'EDITOR_DECISION_DECLINE', 0, 1, 16, 65536, 3),
(36, 'EDITOR_DECISION_INITIAL_DECLINE', 0, 1, 16, 65536, 1),
(37, 'EDITOR_RECOMMENDATION', 0, 1, 16, 16, 3),
(38, 'COPYEDIT_REQUEST', 1, 1, 16, 4097, 4),
(39, 'LAYOUT_REQUEST', 1, 1, 16, 4097, 5),
(40, 'LAYOUT_COMPLETE', 1, 1, 4097, 16, 5),
(41, 'EMAIL_LINK', 0, 1, 1048576, NULL, NULL),
(42, 'SUBSCRIPTION_NOTIFY', 0, 1, NULL, 1048576, NULL),
(43, 'OPEN_ACCESS_NOTIFY', 0, 1, NULL, 1048576, NULL),
(44, 'SUBSCRIPTION_BEFORE_EXPIRY', 0, 1, NULL, 1048576, NULL),
(45, 'SUBSCRIPTION_AFTER_EXPIRY', 0, 1, NULL, 1048576, NULL),
(46, 'SUBSCRIPTION_AFTER_EXPIRY_LAST', 0, 1, NULL, 1048576, NULL),
(47, 'SUBSCRIPTION_PURCHASE_INDL', 0, 1, NULL, 2097152, NULL),
(48, 'SUBSCRIPTION_PURCHASE_INSTL', 0, 1, NULL, 2097152, NULL),
(49, 'SUBSCRIPTION_RENEW_INDL', 0, 1, NULL, 2097152, NULL),
(50, 'SUBSCRIPTION_RENEW_INSTL', 0, 1, NULL, 2097152, NULL),
(51, 'CITATION_EDITOR_AUTHOR_QUERY', 0, 1, NULL, NULL, 4),
(52, 'REVISED_VERSION_NOTIFY', 0, 1, NULL, 16, 3),
(53, 'STATISTICS_REPORT_NOTIFICATION', 1, 1, 16, 17, NULL),
(54, 'ANNOUNCEMENT', 0, 1, 16, 1048576, NULL),
(55, 'ORCID_COLLECT_AUTHOR_ID', 0, 1, NULL, NULL, NULL),
(56, 'ORCID_REQUEST_AUTHOR_AUTHORIZATION', 0, 1, NULL, NULL, NULL),
(57, 'MANUAL_PAYMENT_NOTIFICATION', 0, 1, NULL, NULL, NULL),
(58, 'PAYPAL_INVESTIGATE_PAYMENT', 0, 1, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `email_templates_default_data`
--

CREATE TABLE `email_templates_default_data` (
  `email_key` varchar(64) NOT NULL COMMENT 'Unique identifier for this email.',
  `locale` varchar(14) NOT NULL DEFAULT 'en_US',
  `subject` varchar(120) NOT NULL,
  `body` text,
  `description` text,
  UNIQUE KEY `email_templates_default_data_pkey` (`email_key`,`locale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `email_templates_default_data`
--

INSERT INTO `email_templates_default_data` VALUES
('ANNOUNCEMENT', 'ar_IQ', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nقم بزيارة موقعنا للاطلاع على <a href="{$url}">الإعلان بشكله الكامل</a>.', 'هذه الرسالة تُرسل إلى المشتركين في الموقع عند إنشاء إعلان جديد.'),
('ANNOUNCEMENT', 'ca_ES', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nVisiteu el nostre lloc web per llegir <a href="{$url}">l''avís complet</a>.', 'Aquest correu electrònic s''envia quan es crea un avís nou.'),
('ANNOUNCEMENT', 'cs_CZ', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nNavštivte naši webovou stránku, pokud si chcete přečíst <a href="{$url}">plný text</a>.', 'Tento email je posílán, pokud je vytvořeno nové oznámení.'),
('ANNOUNCEMENT', 'da_DK', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nBesøg vores websted  <a href="{$url}">for at læse hele meddelelsen</a>.', 'Denne e-mail sendes, når der oprettes en ny meddelelse.'),
('ANNOUNCEMENT', 'de_DE', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nBesuchen Sie die Webseite um die <a href="{$url}">gesamte Ankündigung</a> zu lesen.', 'Diese E-Mail wird gesendet, wenn eine neue Ankündigung erstellt wird.'),
('ANNOUNCEMENT', 'el_GR', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nΕπισκεφθείτε τον ιστότοπό μας για να διαβάσετε την <a href="{$url}">πλήρη ανακοίνωση</a>.', 'Αυτό το email αποστέλλεται όταν δημιουργείται μια νέα ανακοίνωση.'),
('ANNOUNCEMENT', 'en_US', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nVisit our website to read the <a href="{$url}">full announcement</a>.', 'This email is sent when a new announcement is created.'),
('ANNOUNCEMENT', 'es_ES', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nVisite nuestro site para leer el <a href="{$url}">anuncio completo</a>.', 'Se mandará este email tras la creación de un nuevo anuncio.'),
('ANNOUNCEMENT', 'fi_FI', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nVerkkosivuillamme voit lukea <a href="{$url}">koko ilmoituksen</a>.', 'Tämä sähköpostiviesti lähetetään, kun uusi ilmoitus on luotu.'),
('ANNOUNCEMENT', 'fr_CA', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nVisiter notre site Web pour consulter <a href="{$url}">l''annonce complète</a>.', 'Ce courriel est envoyé lorsqu''une nouvelle annonce est créée.'),
('ANNOUNCEMENT', 'fr_FR', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nVisiter notre site pour consulter <a href="{$url}">l''annonce complète</a>.', 'Ce courriel est envoyé lorsqu''une nouvelle annonce est créée.'),
('ANNOUNCEMENT', 'gd_GB', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nTadhail air an làrach-lìn againn is leugh <a href="{$url}">am fios-naidheachd slàn</a>.', 'Thèid am post-d seo a chur nuair a chaidh fios-naidheachd ùr a chruthachadh.'),
('ANNOUNCEMENT', 'id_ID', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nKunjungi website kami untuk melihat <a href="{$url}">pengumuman selengkapnya</a>.', 'Surel ini dikirim ketika terdapat pengumuman baru.'),
('ANNOUNCEMENT', 'it_IT', '{$titolo}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nVisita il nostro sito per leggere la  <a href="{$url}">news completa</a>.', 'Questo messaggio è inviato quando viene creata una nuova news.'),
('ANNOUNCEMENT', 'ja_JP', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\n詳しいお知らせを読むためにウェブサイト<a href="{$url}">をご覧ください。</a>.', 'このメールは、新しいお知らせが作成された際に送信されます。'),
('ANNOUNCEMENT', 'mk_MK', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nПосетете ја нашата веб-страница за да го прочитате <a href="{$url}">целосното известување</a>.', 'Оваа е-пошта се испраќа кога ќе се креира ново соопштение.'),
('ANNOUNCEMENT', 'nb_NO', '{$title}', '<b> {$title} </b> <br />\n<br />\n{$summary} <br />\n<br />\nBesøk nettstedet vårt for å lese <a href="{$url}">hele kunngjøringen </a>.', 'Denne e-posten blir sendt når et nytt oppslag opprettes.'),
('ANNOUNCEMENT', 'nl_NL', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nBezoek onze website om de <a href="{$url}">volledige aankondiging</a> te lezen.', 'Deze e-mail wordt verzonden wanneer er een nieuwe aankondiging is gemaakt.'),
('ANNOUNCEMENT', 'pl_PL', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nOdwiedź naszą stronę i przeczytaj  <a href="{$url}">pełne ogłoszenie</a>.', 'Ten email jest wysyłany, kiedy pojawiło się nowe ogłoszenie.'),
('ANNOUNCEMENT', 'pt_BR', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nVisite nosso site para ler o <a href="{$url}"> comunicado completo </a>.', 'Este email é enviado quando um novo comunicado é criado.'),
('ANNOUNCEMENT', 'pt_PT', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nVisite o nosso site para ler a <a href="{$url}">notícia completa</a>.', 'Este email é enviado quando uma nova notícia é criada.'),
('ANNOUNCEMENT', 'ro_RO', '{$titlu}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nVizitați situl nostru pentru a citi anunțul <a href="{$url}"></a>.', 'Acest e-mail este trimis la crearea unui nou anunț.'),
('ANNOUNCEMENT', 'ru_RU', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nПосетите наш веб-сайт, чтобы прочитать <a href="{$url}">объявление полностью</a>.', 'Это письмо отправляется при создании нового объявления.'),
('ANNOUNCEMENT', 'sk_SK', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nNavštívte našu webovú stránku, ak si chcete prečítať<a href="{$url}">plný text</a>.', 'Tento email je posielaný, ak je vytvorené nové oznámenie.'),
('ANNOUNCEMENT', 'sl_SI', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nObiščite našo spletno stran, da vidite <a href="{$url}">celotno obvestilo</a>.', 'Email je poslan, ko je objavljeno novo obvestilo.'),
('ANNOUNCEMENT', 'sv_SE', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nBesök vår webbsida för att läsa <a href="{$url}">hela meddelandet</a>.', 'Detta e-post-meddelande skickas när ett nytt publicerat meddelande skapas.'),
('ANNOUNCEMENT', 'tr_TR', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nWeb sitesini ziyaret et ve <a href="{$url}">tüm duyuruyu</a> oku.', 'Bu e-posta, yeni bir duyuru oluşturulduğunda gönderilir.'),
('ANNOUNCEMENT', 'vi_VN', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\nGhé thăm trang web của chúng tôi để đọc <a href="{$url}">thông báo đầy đủ</a>.', 'Email này được gửi khi một thông báo mới được tạo.'),
('ANNOUNCEMENT', 'zh_CN', '{$title}', '<b>{$title}</b><br />\n<br />\n{$summary}<br />\n<br />\n访问我们的网站查看<a href="{$url}">公告全文</a>。.', '此邮件当公告发布时将会自动发送。'),
('CITATION_EDITOR_AUTHOR_QUERY', 'ar_IQ', 'تحرير إقتباس', '{$authorFirstName},<br />\n<br />\nلطفاً، هل بإمكانك التحقق من أو تزويدنا بالشكل الصحيح للاقتباس للمرجع المبين أدناه والمذكور في مؤلَّفك الموسوم {$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\nمع الشكر!<br />\n<br />\n{$userFirstName}<br />\nالمدقق، {$contextName}<br />\n', 'هذه الرسالة تسمح لمدققي المجلة بالمطالبة بمعلومات إضافية عن المراجع من المؤلفين.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'ca_ES', 'Edició de citacions', '{$authorFirstName},<br />\n<br />\nSeríeu tan amable de verificar o de proporcionar-nos la citació correcta de la següent referència inclosa en en el vostre article {$submissionTitle}?:<br />\n<br />\n{$rawCitation}<br />\n<br />\nGràcies!<br />\n<br />\n{$userFirstName}<br />\nCorrector/a, {$contextName}<br />\n', 'Aquest correu electrònic permet que els correctors/ores sol·licitin informació addicional sobre les referències als autors/ores.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'cs_CZ', 'Zpracování citací', 'Vážený(á) {$authorFirstName},<br />\n<br />\nMůžete, prosím, ověřit, nebo potvrdit správnou citaci pro následující referenci z vašeho článku {$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\nDěkuji!<br />\n<br />\n{$userFirstName}<br />\nRedaktor {$contextName}<br />\n', 'Tento e-mail umožňuje redaktorům vyžádat si další informace o referencích od autorů.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'da_DK', 'Referenceredigering', '{$authorFirstName},<br />\n<br />\nDu bedes verificere eller sende os de korrekte oplysninger i forbindelse med følgende reference i din artikel {$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\nPå forhånd tak!<br />\n<br />\n{$userFirstName}<br />\nManuskriptredaktør, {$contextName}<br />\n', 'Denne e-mail tillader manuskriptredaktører at anmode forfattere om yderligere oplysninger vedrørende referencer.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'de_DE', 'Zitationsbearbeitung', '{$authorFirstName},<br />\n<br />\nkönnten Sie uns bitte die korrekte Zitation für den folgenden Verweis aus Ihrem Artikel {$submissionTitle} bestätigen bzw. nachreichen:<br />\n<br />\n{$rawCitation}<br />\n<br />\nVielen Dank!<br />\n<br />\n{$userFirstName}<br />\nLektor/in, {$contextName}<br />\n', 'Diese E-Mail ermöglicht es Lektor/innen, zusätzliche Informationen über Verweise von Autor/innen anzufordern.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'el_GR', 'Επεξεργασία παραπομπής', '{$authorFirstName},<br />\n<br />\nΘα σας παρακαλούσαμε να επιβεβαιώσετε ή να μας παρέχετε τα ακριβή στοιχεία για την παρακάτω παραπομπή του άρθρου σας, {$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\nΣας ευχαριστούμε πολύ!<br />\n<br />\n{$userFirstName}<br />\nΕπιμελητής Κειμένου, {$contextName}<br />\n', 'Με το παρόν μήνυμα οι Επιμελητές Κειμένου ζητούν επιπρόσθετες πληροφορίες από τους Συγγραφείς σχετικά με τις παραπομπές.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'en_US', 'Citation Editing', '{$authorFirstName},<br />\n<br />\nCould you please verify or provide us with the proper citation for the following reference from your article, {$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\nThanks!<br />\n<br />\n{$userFirstName}<br />\nCopy-Editor, {$contextName}<br />\n', 'This email allows copyeditors to request additional information about references from authors.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'es_ES', 'Edición de citas', '{$authorFirstName},<br />\n<br />\nPor favor, ¿podría usted verificar o proporcionarnos la cita adecuada para la siguiente referencia de su artículo, {$submissionTitle}?:<br />\n<br />\n{$rawCitation}<br />\n<br />\n¡Gracias!<br />\n<br />\n{$userFirstName}<br />\nCorrector/a de estilo, {$contextName}<br />\n', 'Este correo electrónico permite a los correctores/as de estilo solicitar información adicional acerca de las referencias de los autores/as.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'eu_ES', 'Aipuak editatzea', '{$authorFirstName} jauna/andrea,<br />\n<br />\nMesedez, egiaztatu edo emango al zeniguke zure {$submissionTitle} artikuluan agertzen den aipu egokia honako erreferentzia honetarako?<br />\n<br />\n<br />\n{$rawCitation}<br />\n<br />\n<br />\nEskerrik asko!<br />\n<br />\n<br />\n{$userFirstName}<br />\nZuzentzailea, {$contextName}', 'Mezu elektroniko honekin zuzentzaileek erreferentziei buruzko informazio osagarria eskatzen diete egileei.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'fa_IR', 'ویرایش ارجاع', '{$authorFirstName},<br />\n<br />\nلطفا ارجاع صحیح برای رفرانس زیر از مقاله شما {$submissionTitle} را مشخص کنید و یا تایید نمائید:<br />\n<br />\n{$rawCitation}<br />\n<br />\nبت تشکر!<br />\n<br />\n{$userFirstName}<br />\nویراستار, {$contextName}', '##emails.citationEditorAuthorQuery.description##'),
('CITATION_EDITOR_AUTHOR_QUERY', 'fi_FI', 'Viittausten muokkaus', 'Hyvä {$authorFirstName},<br />\n<br />\nVoisitteko ystävällisesti vahvistaa seuraavan artikkelissanne {$submissionTitle} olevan lähdeviitteen tai antaa oikean viittauksen:<br />\n<br />\n{$rawCitation}<br />\n<br />\nKiitos!<br />\n<br />\n{$userFirstName}<br />\nTekninen toimittaja, {$contextName}<br />\n', 'This email allows copyeditors to request additional information about references from authors.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'fr_CA', 'Modification des références bibliographiques', '{$authorFirstName},<br />\n<br />\nPourriez-vous vérifier ou nous fournir la référence bibliographique complète pour la référence suivante, provenant de votre article « {$submissionTitle} »  :<br />\n<br />\n{$rawCitation}<br />\n<br />\nMerci!<br />\n<br />\n{$userFirstName}<br />\nRéviseur-e, revue {$contextName}<br />\n', 'Ce courriel permet aux réviseurs-es de demander des renseignements additionnels à propos des références bibliographiques citées par les auteurs-es.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'fr_FR', 'Modification des références', '{$authorFirstName},<br />\n<br />\nPourriez-vous vérifier ou nous fournir la référence bibliographique complète pour la référence suivante, provenant de votre article « {$submissionTitle} »  :<br />\n<br />\n{$rawCitation}<br />\n<br />\nMerci !<br />\n<br />\n{$userFirstName}<br />\nRéviseur/Réviseuse, revue {$contextName}<br />\n', 'Ce courriel permet au réviseurs et réviseuses de demander aux auteurs ou auteures des renseignements supplémentaires à propos des références bibliographiques.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'gd_GB', 'Deasachadh iomraidh', '{$authorFirstName},<br />\n<br />\nBhiomaid fada nad chomain nam b’ urrainn dhut an t-iomradh ceart a thoirt dhuinn airson an reifreans a leanas on artaigeal agad, {$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\nMòran taing!<br />\n<br />\n{$userFirstName}<br />\nGrinn-deasaiche, {$contextName}<br/>\n', 'Tha am post-d seo a’ toirt cothrom do ghrinn-deasaichean barrachd fiosrachaidh iarraidh o ùghdaran mu dhèidhinn reifreansan.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'hi_IN', 'प्रशस्ति संपादन', '{$authorFirstName},<br />\n<br />\nक्या आप कृपया अपने लेख, {$submissionTitle} से निम्न संदर्भ के लिए उचित उद्धरण के साथ हमें सत्यापित या प्रदान कर सकते हैं।:<br />\n<br />\n{$rawCitation}<br />\n<br />\nधन्यवाद!<br />\n<br />\n{$userFirstName}<br />\nकॉपी संपादक, {$contextName}<br />\n', 'यह ईमेल लेखकों से संदर्भों के बारे में अतिरिक्त जानकारी का अनुरोध करने के लिए प्रतिलिपिलेखकों को अनुमति देता है.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'hu_HU', 'Idézettség szerkesztés', 'Tisztelt {$authorFirstName}!<br />\n<br />\nKérjük, adja meg a megfelelő idézettség információt, vagy igazolja annak helyességét a(z) {$submissionTitle} cikkben szereplő hivatkozásához:<br />\n<br />\n{$rawCitation}<br />\n<br />\nKöszönettel,<br />\n{$userFirstName}<br />\nTechnikai szerkesztő, {$contextName}<br />\n', 'Ez az email lehetővé teszi, hogy a technikai szerkesztők további információkat kérjenek a szerzőktől.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'id_ID', 'Penyuntingan Sitiran', '{$authorFirstName},<br />\n<br />\nMohon verifikasi atau berikan sitasi yang benar untuk rujukan berikut dari artikel Anda, {$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\nTerimakasih!<br />\n<br />\n{$userFirstName}<br />\nCopy-Editor, {$contextName}<br />\n', 'Email ini memungkinkan copyeditor untuk meminta informasi tambahan tentang rujukan dari penulis.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'it_IT', 'Richiesta di verifica delle citazioni', 'Gentile {$authorFirstName},<br />\n<br />\nTi chiedo la cortesia di verificare la correttezza delle citazioni contenute nell''articolo  {$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\nGrazie,<br />\n<br />\n{$userFirstName}<br />\nCopy-Editor, {$contextName}<br />\n', 'Questo messaggio permette al copyeditor di chiedere a un autore ulteriori informazioni sulle citazioni bibliografiche.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'ja_JP', '引用の編集', '{$authorFirstName}様<br />\n<br />\nあなたの下記の論文に含まれる参考文献についてご確認いただき，正確な引用情報をご提供ください。<br />\n<br />\n {$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\nどうぞよろしくお願い致します。<br />\n<br />\n{$userFirstName}<br />\n『{$contextName}』コピーエディタ<br />\n', 'このメールでは、コピーエディターが著者に参考文献に関する追加情報を要求することができます。'),
('CITATION_EDITOR_AUTHOR_QUERY', 'ku_IQ', 'گۆڕانکاریی گوتراوەکان', '{$authorFirstName},<br />\n<br />\nئایا دەتوانیت پشتڕاستی بکەیتەوە یان زانیاری دەربارەی گوتراوەکانی ئەم سەرچاوەیە بخەیتە بەردەست؟ {$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\nسوپاس!<br />\n<br />\n{$userFirstName}<br />\nوردبین، {$contextName}<br />\n', 'ئەم ئیمەیڵە ڕێگا بە وردبینەکان دەدات کە داوای زانیاریی زیادە دەربارەی سەرچاوەکان لە توێژەران بکەن.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'mk_MK', 'Уредување на цитат', '{$authorFirstName},<br/>\n<br/>\nВе молам доколку можете да го потврдите или да обезбедите адекватен цитат за следната референца во вашиот труд, {$submissionTitle}:<br />\n<br/>\n{$rawCitation}<br/>\n<br/>\nБлагодарам!<br/>\n<br/>\n{$userFirstName}<br/>\nУредник, {$contextName}<br/>\n', 'Овој и-меил им овозможува на уредниците да побараат дополнителни информации за референци од авторите.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'nb_NO', 'Redigere referanser', '{$authorFirstName},<br />\n<br />\nKan du bekrefte at denne referansen fra artikkelen din, «{$submissionTitle}», er riktig? Hvis ikke, ber vi deg korrigere referansen.<br />\n<br />\n{$rawCitation}<br />\n<br />\nMange takk!<br />\n<br />\n{$userFirstName}<br />\nSpråkvasker {$contextName}<br />\n', 'Denne e-posten lar språkvaskere be forfattere bekrefte eller rette opp referanser.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'nl_NL', 'Citatie redactie', '{$authorFirstName},<br />\n<br />\nKunt u de juiste citatie van de volgende referentie uit uw artikel {$submissionTitle} verifiëren of verschaffen:<br />\n<br />\n{$rawCitation}<br />\n<br />\nDank!<br />\n<br />\n{$userFirstName}<br />\nTekstredacteur, {$contextName}<br />\n', 'Met deze e-mail kunnen tekstredacteurs auteurs vragen om bijkomende informatie te geven over de bronverwijzing van citaten in hun artikel.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'pl_PL', 'Redakcja bibliografii', 'Szanowna Pani/ Szanowny Panie,<br />\n<br />\nproszę o sprawdzenie lub uzupełnienie następujących opisów bibliograficznych w tekście "{$submissionTitle}":<br />\n<br />\n{$rawCitation}<br />\n<br />\nZ wyrazami szacunku,<br />\n<br />\n{$userFirstName}<br />\nKorektor, „{$contextName}”<br />\n', 'Wiadomość od korektora do autora, z prośbą o dodatkowe informacje na temat bibliografii.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'pt_BR', 'Edição de citação', '{$authorFirstName}, <br />\n<br />\nVocê poderia verificar ou fornecer a citação adequada para a seguinte referência do seu artigo, {$submitTitle}: <br />\n<br />\n{$rawCitation} <br />\n<br />\nObrigado! <br />\n<br />\n{$userFirstName} <br />\nEditor de Cópia, {$contextName} <br />\n', 'Solicitação ao autor de detalhes sobre referência, enviada pelo editor de texto.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'pt_PT', 'Edição da Citação', '{$authorFirstName},<br />\n<br />\nPor favor, verifique ou indique as citações adequadas para o seu artigo, {$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\nObrigado!<br />\n<br />\n{$userFirstName}<br />\nEditor de Texto, {$contextName}<br />\n', 'Este e-mail permite aos editores de texto que solicitem aos autores informação adicional sobre as referências.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'ro_RO', 'Editarea citării', '{$authorFirstName},<br />\n<br />\nVă rugăm să verificați sau să ne furnizați citarea corespunzătoare pentru următoarea referință din articolul dvs., {$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\nMulțumesc!<br />\n<br />\n{$userFirstName}<br />\nEditor de conținut, {$contextName}<br />\n', 'Acest e-mail permite editorilor de conținut să solicite informații suplimentare despre referințe de la autori.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'ru_RU', 'Редактирование библиографических ссылок', 'Здравствуйте, {$authorFirstName}!<br />\n<br />\nПожалуйста, проверьте или пришлите нам правильно оформленную библиографическую ссылку для следующей ссылки из Вашей статьи «{$submissionTitle}»:<br />\n<br />\n{$rawCitation}<br />\n<br />\nЗаранее благодарю Вас!<br />\n<br />\n{$userFirstName}<br />\nЛитературный редактор журнала «{$contextName}»<br />\n', 'Это письмо позволяет литературным редакторам запрашивать дополнительную информацию о ссылках у авторов.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'sk_SK', 'Spracovanie citácií', 'Vážený(á) {$authorFirstName},<br />\n<br />\nMôžete, prosím, overiť, alebo potvrdiť správnu citáciu pre nasledujúcu referenciu z vášho článku {$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\nĎakujem!<br />\n<br />\n{$userFirstName}<br />\nRedaktor {$contextName}<br />\n', 'Tento e-mail umožňuje redaktorom vyžiadať si ďalšie informácie o referenciách od autorov.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'sl_SI', 'Urejanje citiranja', '{$authorFirstName},<br />\n<br />\nAli lahko prosim preverite in nam sporočite pravilne citate za spodnjaj referencirano literaturo v vašem prispevku, {$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\nHvala lepa!<br />\n<br />\n{$userFirstName}<br />\nLektor, {$contextName}<br />\n', 'Ta email pošlje lektor avtorju s prošnjo za dodatne informacije o citiranih referencah.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'sv_SE', 'Referensredigering', '{$authorFirstName},<br />\n<br />\nVi skulle vara glada om du hade möjlighet att ge oss den korrekta citeringen för följande referens i din artikel {$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\nStort tack!<br />\n<br />\n{$userFirstName}<br />\nManusredaktör, {$contextName}<br />\n', 'Det här e-postmeddelandet kan användas om manusredaktörer behöver efterfråga mer information om referenser från författare.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'tr_TR', 'Atıf Düzenleme', 'Sayın {$authorFirstName},<br />\n<br />\n{$submissionTitle} başlıklı makale için aşağıdaki atıfın doğruluğunu ve son düzenlemelesini sağlayınız:<br />\n<br />\n{$rawCitation}<br />\n<br />\nTeşekkürler!<br />\n<br />\n{$userFirstName}<br />\nKopya Editör, {$contextName}\n', 'Bu e-posta, kopya düzenleme editörlerinin yazarlardan kaynakça hakkında ek bilgi istemesini sağlar.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'uk_UA', 'Редагування посилання', '{$authorFirstName},<br />\n<br />\nНе могли б Ви надати нам коректний бібліографічний запис для наступного посилання з Вашої статті &quot;{$submissionTitle}&quot;:<br />\n<br />\n{$rawCitation}<br />\n<br />\nДякую!<br />\n<br />\n{$userFirstName}<br />\nЛітературний редактор видання &quot;{$contextName}&quot;<br />\n', 'Цей лист дозволяє літературним редакторам уточнювати у авторів інформацію про пристатейну бібліографію.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'vi_VN', 'Chỉnh sửa trích dẫn', 'Kính gửi {$authorFirstName},<br />\n<br />\nBạn có thể vui lòng xác minh hoặc cung cấp cho chúng tôi trích dẫn thích hợp cho tham khảo sau từ bài viết của bạn,{$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\nTrân trọng<br />\n<br />\n{$userFirstName}<br />\nCopy-Editor, {$contextName}<br />\n', 'Email này cho phép các biên tập viên yêu cầu thông tin bổ sung về các tài liệu tham khảo từ các tác giả.'),
('CITATION_EDITOR_AUTHOR_QUERY', 'zh_CN', '引文编辑', '{$authorFirstName},<br />\n<br />\n对于下面的在您文章里列出的参考文献，请您验证并提供给我们正确的引用, {$submissionTitle}:<br />\n<br />\n{$rawCitation}<br />\n<br />\n谢谢!<br />\n<br />\n{$userFirstName}<br />\nCopy-Editor, {$contextName}', '本邮件允许文字编辑向作者要求参考文献的其他信息'),
('COPYEDIT_REQUEST', 'ar_IQ', 'إلتماس نسخة التدقيق', '{$participantName}:<br />\n<br />\nأود مطالبتك بتوفير نسخة مدققة من المؤلَّف الموسوم &quot;{$submissionTitle}&quot; والمرسل إلى {$contextName} عبر اتباع الخطوات الآتية:<br />\n1. أنقر على رابط طلب النشر أدناه.<br />\n2. إفتح أي ملفات متوافرة ضمن الملفات المسودة وأجر متطلبات التدقيق مضيفاً أي قرارات أو ملاحظات تتعلق بالتدقيق حسب الحاجة.<br />\n3. إحفظ الملفات المدققة، ثم إرفعها إلى لوحة المدققات.<br />\n4. أعلم المحرر بأن جميع الملفات صارت جاهزة، وأن بالإمكان الشروع بعملية الإنتاج.<br />\n<br />\nرابط {$contextName}: {$contextUrl}<br />\nرابط الطلب: {$submissionUrl}<br />\nاسم الدخول: {$participantUsername}', 'هذه الرسالة يعنونها محرر القسم إلى مدقق القسم مطالباً إياه بالشروع في عملية معالجة نسخة المؤلَّف قيد المعالجة، وهي توفر له معلومات عن طلب النشر وكيفية الوصول إليه ضمن موقع المجلة.'),
('COPYEDIT_REQUEST', 'bs_BA', 'Zamolba za lekturu', 'Poštovana/i {$participantName},<br />\n<br />\nželjeli bismo vas zamoliti da prihvatite lekturu rukopisa &quot;{$submissionTitle}&quot; za časopis {$contextName}. Prijavljeni rukopis, kao i upute za lektoriranje možete pronaći na mrežnim stranicama časopisa.<br />\n<br />\nURL rukopisa: {$submissionUrl}<br />\nKorisničko ime: {$participantUsername}<br />\n<br />\nU slučaju da trenutačno niste u mogućnosti preuzeti lekturu ili da imate bilo kakvih dodatnih pitanja, molimo vas da nam se obratite.<br />\n<br />\nSrdačno,', 'Ovim obrascem e-pošte urednik rubrike šalje lektoru zamolbu da započne s lekturom priloga. Poruka pruža osnovne informacije o prilogu i kako mu pristupiti.'),
('COPYEDIT_REQUEST', 'ca_ES', 'Sol·licitud de correcció', '{$participantName}:<br />\n<br />\nM''agradaria demanar-vos que us encarreguéssiu de la revisió de &quot;{$submissionTitle}&quot; per a {$contextName}. Per fer-ho , hauríeu de seguir els passos següents:<br />\n1. Feu clic a l''URL de la tramesa que trobareu al final d''aquest missatge.<br />\n2. Obriu tots els arxius disponibles a "Arxius esborrany" i feu la correcció afegint els comentaris que necessiteu a "Discussions de correcció".<br />\n3. Guardeu els arxius corregits i carregueu-los en el panell "Corregit".<br />\n4. Notifiqueu a l''editor/a que tots els arxius estan llestos i que el procés de producció pot començar.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nURL de la tramesa: {$submissionUrl}<br />\nNom d''usuari/ària: {$participantUsername}', 'Aquest missatge de correu electrònic té un editor de secció com a remitent i s''envia al possible corrector d''una tramesa per a sol·licitar-li que comenci el procés de correcció. Proporciona informació sobre la tramesa i com s''hi ha d''accedir.'),
('COPYEDIT_REQUEST', 'cs_CZ', 'Žádost o redigování příspěvku', '{$participantName}:<br />\n<br />\nChtěl bych vás požádat, abyste zredigoval článek &quot;{$submissionTitle}&quot; pro {$contextName} a postupujte přitom prosím podle následujících kroků:<br />\n1. Klikněte níže na URL příspěvku.<br />\n2. Otevřete libovolný soubor v sekci Soubory návrhů a proveďte redakční editaci, případě využijte diskusi pro editační fázi.<br />\n3.  Uložte zredigovaný soubor a nahrajte ho v editačním panelu.<br />\n4 . Upozorněte redaktora, že všechny soubory byly zeditovány a může začít produkční fáze.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nURL příspěvku: {$submissionUrl}<br />\nUživatelské jméno: {$participantUsername}', 'Tento email posílá editor sekce redaktorovi, aby ho požádal o zahájení procesu redigování. Obsahuje informace o příspěvku a jek se k němu dostat.'),
('COPYEDIT_REQUEST', 'da_DK', 'Forespørgsel om manuskriptredigering', '{$participantName}:<br />\n<br />\nJeg vil bede dig om at foretage manuskriptredigering af &quot;{$submissionTitle}&quot; til {$contextName} ved at følge disse trin. <br />\n1. Klik på manuskriptets URL-adresse nedenfor. <br />\n2. Åbn tilgængelig(e) fil(er) under ‘Filer til redigering’ og tilføj, om nødvendigt, et indlæg under ‘Drøftelser under manuskriptredigering’.<br />\n3. Gem manuskriptredigeret fil og upload den ud for ‘Manuskriptredigering’.<br />\n4. Giv redaktøren besked, når alle filer er færdigredigerede og klar til blive videresendt til ’Produktion’.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nSubmission URL: {$submissionUrl}<br />\nUsername: {$participantUsername}', 'Denne e-mail sendes af en sektionsredaktør til manuskriptredaktøren for et manuskript og beder vedkommende om at påbegynde manuskriptredigeringsprocessen. Den indeholder oplysninger om manuskriptet og om, hvordan der oprettes adgang til det.'),
('COPYEDIT_REQUEST', 'de_DE', 'Bitte um ein Lektorat', '{$participantName},<br />\n<br />\nich bitte Sie, das Manuskript &quot;{$submissionTitle}&quot; für {$contextName} zu lektorieren. Bitte gehen Sie dabei folgendermaßen vor:<br />\n1. Klicken Sie auf die unten stehende URL des Beitrags.<br />\n2. Öffnen Sie alle Dateien, die unter Entwurf für Lektorat verfügbar sind, und beginnen Sie Ihr Lektorat. Fügen Sie neue Diskussionen zum Lektorat nach Bedarf hinzu.<br />\n3. Sichern Sie die lektorierte(n) Dateien und laden Sie sie unter Lektoriert hoch.<br />\n4. Benachrichtigen Sie die/den Redakteur/in, dass alle Dateien fertig sind und dass der Herstellungsprozess beginnen kann.<br />\n<br />\nURL {$contextName}: {$contextUrl}<br />\nURL des Beitrags: {$submissionUrl}<br />\nBenutzer/innenname: {$participantUsername}', 'Diese E-Mail wird von der/dem Rubrikredakteur/in an die/den Lektor einer Einreichung gesendet, um diese/n zu bitten, mit dem Lektorat zu beginnen. Sie liefert Informationen über die Einreichung und darüber, wie auf sie zuzugreifen ist.'),
('COPYEDIT_REQUEST', 'el_GR', 'Αίτημα επιμέλειας κειμένου', '{$participantName}:<br />\n<br />\nΘα ήθελα να σας ζητήσω να αναλάβετε την επιμέλεια του κειμένου της υποβολής &quot;{$submissionTitle}&quot;, για το περιοδικό {$contextName}, ακολουθώντας τα παρακάτω βήματα.<br />\n1. Πατήστε στον σύνδεσμο της υποβολής, παρακάτω.<br />\n2. Ανοίξτε όλα τα διαθέσιμα αρχεία που υπάρχουν στο "Πρόχειρα Αρχεία" και κάντε την επιμέλεια κειμένου, προσθέτοντας σχόλια στη "Συζήτηση σχετικά με την Επιμέλεια", όπου χρειάζεται.<br />\n3. Αποθηκεύστε το επιμελημένο αρχείο(-α) και μεταφορτώστε το στον πίνακα των επιμελημένων αρχείων.<br />\n4. Ειδοποιήστε τον Επιμελητή ότι όλα τα αρχεία είναι έτοιμα και μπορεί να ξεκινήσει η διαδικασία παραγωγής.<br />\n<br />\nΣύνδεσμος περιοδικού {$contextName}: {$contextUrl}<br />\nΣύνδεσμος υποβολής: {$submissionUrl}<br />\nΌνομα Χρήστη: {$participantUsername}', 'Το παρόν μήνυμα αποστέλλεται από τον Επιμελητή Ενότητας στον Επιμελητή Κειμένου της υποβολής, για να ξεκινήσει η διαδικασία της επιμέλειας. Παρέχει πληροφορίες σχετικά με την υποβολή και τον τρόπο πρόσβασης σε αυτήν.'),
('COPYEDIT_REQUEST', 'en_US', 'Copyediting Request', '{$participantName}:<br />\n<br />\nI would ask that you undertake the copyediting of &quot;{$submissionTitle}&quot; for {$contextName} by following these steps.<br />\n1. Click on the Submission URL below.<br />\n2. Open any files available under Draft Files and do your copyediting, while adding any Copyediting Discussions as needed.<br />\n3. Save copyedited file(s), and upload to Copyedited panel.<br />\n4. Notify the Editor that all files have been prepared, and that the Production process may begin.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nSubmission URL: {$submissionUrl}<br />\nUsername: {$participantUsername}', 'This email is sent by a Section Editor to a submission''s Copyeditor to request that they begin the copyediting process. It provides information about the submission and how to access it.'),
('COPYEDIT_REQUEST', 'es_ES', 'Petición de corrección', '{$participantName}:<br />\n<br />\nMe gustaría pedirle que llevara a cabo la corrección de &quot;{$submissionTitle}&quot; para {$contextName}. Para hacerlo debería seguir los pasos siguientes:<br />\n1. Haga clic en la URL del envío que encontrará al final de este correo.<br />\n2. Abra todos los archivos disponibles en "Archivos borradores" y haga la corrección, añadiendo todos los comentarios que necesite en "Discusiones de corrección".<br />\n3. Guarde los archivos corregidos y cárguelos en el panel "Corregidos".<br />\n4. Notifique al editor/a que los archivos están listos y que el proceso de producción puede empezar.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nURL del envío: {$submissionUrl}<br />\nNombre de usuario/a: {$participantUsername}', 'Este correo es enviado por un/a Editor/a de Sección a un/a corrector/a de un envío para pedirles que comiencen un proceso de corrección. Le proporciona información sobre en el envío y cómo acceder a él.'),
('COPYEDIT_REQUEST', 'eu_ES', 'Zuzenketa egiteko eskaera', '{$participantName}:<br />\n<br />\n{$contextName} aldizkarirako &quot;{$submissionTitle}&quot; artikuluaren zuzenketa egitea eskatu nahi nizuke, urrats hauei jarraituz:<br />\n1. Egin klik behean, Artikuluaren URLan.<br />\n2. Sartu aldizkarian eta egin klik 1. urratsean agertzen den Fitxategian.<br />\n3. Irakurri Zuzenketak egiteko webgunean jarrita dauden instrukzioak.<br />\n4. Ireki deskargatutako fitxategia eta zuzendu, Egile-kontsultak gehituz behar izanez gero.<br />\n5. Gorde zuzendutako fitxategia, eta kargatu Zuzenketako 1. urratsean.<br />\n6. Bidali BUKATU duzula adierazteko mezua editoreari.<br />\n<br />\n{$contextName} aldizkariaren URLa: {$contextUrl}<br />\nArtikuluaren URLa: {$submissionUrl}<br />\nErabiltzaile-izena: {$participantUsername}', 'Mezu hau Ataleko editoreak Zuzentzaileari bidaltzen dio, artikuluaren zuzenketa-prozesua egin dezala eskatzeko. Artikuluari buruzko informazioa eta fitxategia hartzeko datuak ematen ditu.'),
('COPYEDIT_REQUEST', 'fa_IR', 'درخواست انجام امور ویراستاری', '{$participantName}:<br />\n<br />\nاز شما درخواست می شود که امور ویراستاری مقاله &quot;{$submissionTitle}&quot; مربوط به {$contextName} را برعهده بگیرید. شما می توانید فایل مربوطه به همراه مجموعه ای از دستورالعمل های نحوه ویراستاری مقاله را در وب سایت مجله دریافت کنید.<br />\n<br />\nچنانچه در حال حاضر قادر به انجام امور مذکور نیستید و یا سوالی در این زمینه دارید، لطفا با من تماس بگیرید. پیشاپیش از قبول انجام امور ویراستاری برای این مجله سپاسگزارم.', 'This email is sent by a Section Editor to a submission''s Copyeditor to request that they begin the copyediting process. It provides information about the submission and how to access it.'),
('COPYEDIT_REQUEST', 'fi_FI', 'Teknistä toimittamista pyydetään', 'Hyvä {$participantName},<br />\n<br />\nPyytäisin teitä toimittamaan teknisesti käsikirjoituksen &quot;{$submissionTitle}&quot; julkaisulle {$contextName}, seuraavia vaiheita noudattaen:<br />\n1. Klikatkaa alla olevaa käsikirjoituksen URL-osoitetta.<br />\n2. Avatkaa Luonnostiedostot-otsikon alla olevat tiedostot ja toimittakaa ne teknisesti. Voitte samalla lisätä tekniseen toimittamiseen liittyviä keskusteluja tarpeen mukaan.<br />\n3. Tallentakaa teknisesti toimitetut tiedostot ja ladatkaa ne Teknisesti toimitettu -paneeliin.<br />\n4. Ilmoittakaa toimittajalle, että kaikki tiedostot ovat valmiina, ja että tuotantoprosessi voidaan aloittaa.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nKäsikirjoituksen URL: {$submissionUrl}<br />\nKäyttäjätunnus: {$participantUsername}', 'This email is sent by a Section Editor to a submission''s Copyeditor to request that they begin the copyediting process. It provides information about the submission and how to access it.'),
('COPYEDIT_REQUEST', 'fr_CA', 'Demande de révision d''une soumission', '{$participantName},<br />\n<br />\nJ''aimerais que vous effectuiez la révision du manuscrit intitulé « {$submissionTitle} » pour la revue {$contextName} à l''aide des étapes suivantes.<br />\n1. Cliquer sur l''URL de la soumission ci-dessous.<br />\n2. Ouvrir le(s) fichier(s) disponible(s) sous Fichiers des ébauches finales et effectuer votre révision, tout en ajoutant des discussions sur la révision, le cas échéant.<br />\n3. Enregistrer le(s) fichier(s) révisé(s) et le(s) téléverser dans la section Version(s) révisée(s).<br />\n4. Informer le,la rédacteur-trice que tous les fichiers ont été révisés et que l''étape de production peut débuter.<br />\n<br />\nURL de la revue {$contextName} : {$contextUrl}<br />\nURL de la soumission : {$submissionUrl}<br />\nNom d''utilisateur-trice : {$participantUsername}', 'Ce courriel du, de la rédacteur-trice de rubrique à un-e réviseur-e lui demande de procéder à la révision. Il fournit les renseignements sur la soumission et comment accéder à celle-ci.'),
('COPYEDIT_REQUEST', 'fr_FR', 'Demande de révision d''une soumission', '{$participantName},<br />\n<br />\nJ''aimerais que vous effectuiez la révision du manuscrit intitulé « {$submissionTitle} » pour la revue {$contextName} à l''aide des étapes suivantes.<br />\n1. Cliquer sur l''URL de la soumission ci-dessous.<br />\n2. Ouvrir le(s) fichier(s) disponible(s) sous Fichiers des ébauches finales et effectuer votre révision, tout en ajoutant des discussions sur la révision, le cas échéant.<br />\n3. Enregistrer le(s) fichier(s) révisé(s) et le(s) téléverser dans la section Version(s) révisée(s).<br />\n4. Informer le rédacteur ou la rédactrice que tous les fichiers ont été révisés et que l''étape de production peut débuter.<br />\n<br />\nURL de la revue {$contextName} : {$contextUrl}<br />\nURL de la soumission : {$submissionUrl}<br />\nNom d''utilisateur-trice : {$participantUsername}', 'Ce courriel est envoyé par le Rédacteur de rubrique à un Réviseur, pour lui demander de commencer le processus de révision. Il fournit l''information sur la soumission et comment accéder à celle-ci.'),
('COPYEDIT_REQUEST', 'gd_GB', 'Iarrtas grinn-deasachaidh', '{$participantName}:<br />\n<br />\nBu toil leam iarraidh ort “{$submissionTitle}” airson {$contextName} a ghrinn-deasachadh a rèir nan ceuman a leanas.<br />\n1. Briog air URL an tagraidh gu h-ìosal.<br />\n2. Fosgail faidhle sam bith a tha sna “Dreachdan fhaidhlichean” is dèan grinn-deasachadh orra agus tòisich deasbadan grinn-deasachaidh ma bhios feum orra.<br />\n3. Sàbhail na faidhlichean a rinn thu grinn-deasachadh orra agus luchdaich suas iad chun na panail “Grinn-deasaichte”.<br />\n4. Cuir fios chun an deasaiche gun do dhèilig thu ris a h-uile faidhle agus gum faodar tòiseachadh air an t-saothrachadh.<br />\n<br />\nURL {$contextName}: {$contextUrl}<br />\nURL an tagraidh: {$submissionUrl}<br />\nAinm-cleachdaiche: {$participantUsername}', 'Thèid am post-d seo a chur grinn-deasaiche tagraidh le deasaiche earrainn airson iarraidh orra tòiseachadh air a’ ghrinn-deasachadh. Tha e a’ toirt seachad fiosrachadh mun tagradh agus mar a gheibhear cothrom air.'),
('COPYEDIT_REQUEST', 'hi_IN', 'प्रतिलिपि अनुरोध', '{$participantName}:<br />\n<br />\nI would ask that you undertake the copyediting of &quot;{$submissionTitle}&quot; for {$contextName} by following these steps.<br />\n1. नीचे दिए गए सबमिशन यूआरएल पर क्लिक करें.<br />\n2. ड्राफ्ट फ़ाइलों के तहत उपलब्ध किसी भी फाइल को खोलें और आवश्यकतानुसार अपनी कॉपी की गई चर्चाओं को जोड़ते हुए, अपनी प्रतिलिपि बनाएँ.<br />\n3. Save copyedited file(s), and upload to Copyedited panel.<br />\n4. संपादक को सूचित करें कि सभी फाइलें तैयार हो गई हैं, और यह कि उत्पादन प्रक्रिया शुरू हो सकती है.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nSubmission URL: {$submissionUrl}<br />\nUsername: {$participantUsername}', 'यह ईमेल एक सेक्शन एडिटर द्वारा सबमिशन की कॉपीडिटर को सबमिट करने के लिए भेजा जाता है ताकि वे कॉपीएडिटिंग  करने की प्रक्रिया शुरू कर सकें। यह सबमिशन और इसे एक्सेस करने के तरीके के बारे में जानकारी प्रदान करता है.'),
('COPYEDIT_REQUEST', 'hr_HR', 'Zamolba za lekturu', 'Poštovana/i {$participantName},<br />\n<br />\nželjeli bismo vas zamoliti da prihvatite lekturu rukopisa &quot;{$submissionTitle}&quot; za časopis {$contextName}. Prijavljeni rukopis, kao i upute za lektoriranje možete pronaći na mrežnim stranicama časopisa.<br />\n<br />\nURL rukopisa: {$submissionUrl}<br />\nKorisničko ime: {$participantUsername}<br />\n<br />\nU slučaju da trenutačno niste u mogućnosti preuzeti lekturu ili da imate bilo kakvih dodatnih pitanja, molimo vas da nam se obratite.<br />\n<br />\nSrdačno,', 'Ovim obrascem e-pošte urednik rubrike šalje lektoru zamolbu da započne s lekturom priloga. Poruka pruža osnovne informacije o prilogu i kako mu pristupiti.'),
('COPYEDIT_REQUEST', 'hu_HU', 'Technikai szerkesztés kérése', 'Tisztelt {$participantName}!<br />\n<br />\nKérjük, hogy végezze el a(z) &quot;{$submissionTitle}&quot; című cikk alábbi lépésekből álló technikai szerkesztési folyamatát a(z) {$contextName} folyóiratnál.<br />\n1. Kattintson a kézirat URL címére alább.<br />\n2. Nyissa meg a fájlt vagy fájlokat a Vázlatok között és végezze el a technikai szerkesztést. Ha szükséges, kezdeményezzen technikai szerkesztői párbeszédet.<br />\n3. Mentse el a szerkesztett fájl(okat), és töltse fel a Szerkesztett részhez.<br />\n4. Értesítse a Szerkesztőt, hogy elkészült minden fájllal és megkezdhető a megjelentetési fázis.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nKézirat URL címe: {$submissionUrl}<br />\nFelhasználónév: {$participantUsername}<br />\n<br />\nÜdvözlettel,<br />\n{$editorialContactSignature}', 'Ezt az emailt a Rovatszerkesztő küldi a kézirat technikai szerkesztőjének, hogy felkérje a technikai szerkesztés munkájára. A levél információkat tartalmaz a kézirattal, illetve elérésével kapcsolatban.'),
('COPYEDIT_REQUEST', 'id_ID', 'Permohonan Copyediting', '{$participantName}:<br />\n<br />\nKami meminta Anda melakukan copyediting terhadap &quot;{$submissionTitle}&quot; untuk {$contextName} mengikuti langkah-langkah berikut.<br />\n1. Klik URL Naskah di bawah.<br />\n2. Buka semua file yang ada di file Draft dan lakukan copyediting, tambahkan Diskusi Copyediting sesuai kebutuhan.<br />\n3. Simpan file yang telah di-copyedit, dan unggah ke panel Sudah Copyedit.<br />\n4. Beritahu Editor bahwa semua file telah siap, dan bahwa proses Produksi dapat dimulai.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nURL Naskah: {$submissionUrl}<br />\nNama pengguna: {$participantUsername}', 'Email ini dari Editor Bagian ke Copyeditor naskah agar memulai proses copyediting.  Email ini memuat informasi terkait penyerahan naskah dan bagaimana mengaksesnya.'),
('COPYEDIT_REQUEST', 'it_IT', 'Assegnazione di copyediting', '{$participantName}:<br />\n<br />\nTi chiedo di prendere in carico il copyediting del manoscritto &quot;{$submissionTitle}&quot; inviato alla testata {$contextName}.<br />\nIl documento si trova su sito web della rivista, insieme alle istruzioni per il copyediting.<br />\nSe non puoi prendere in carico il lavoro in questo periodo o hai qualche domanda, ti prego di contattarmi.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nURL Manoscritto: {$submissionUrl}<br />\nUsername: {$participantUsername}<br />', 'Questa email viene mandata dal section editor al copyeditor della submission per richiedere che comincino con il processo di copyedit. Questa fornisce informazioni sulla submission e su come accedervi.'),
('COPYEDIT_REQUEST', 'ja_JP', '原稿整理のお願い', '{$participantName}様:<br />\n<br />\n誌『{$contextName}』への投稿原稿「{$submissionTitle}」の原稿整理作業をお願いいたしたくメールを差し上げました。以下の手順に従って作業してください。<br />\n1. 下記の投稿URLをクリックしてください。<br />\n2. 「原稿ファイル」で利用可能なファイルを開き、必要に応じて「原稿整理 ディスカッション」を追加しながら、原稿整理作業を行います。<br />\n3. 整理したファイルを保存し、原稿整理 パネルにアップロードします。<br />\n4. 全てのファイルの準備が完了したことを編集者に通知し、制作プロセスの開始が可能になります。<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\n投稿URL: {$submissionUrl}<br />\nユーザー名: {$participantUsername}', 'このメールは、セクションエディタからコピーエディタに原稿整理作業を開始するよう依頼するものです。メールでは、投稿物に関する情報とアクセス方法を提供しています。');
INSERT INTO `email_templates_default_data` VALUES
('COPYEDIT_REQUEST', 'ku_IQ', 'داواکاریی وردبینیکردن', '{$participantName}:<br />\n<br />\nمن داوا لە بەڕێزتان دەکەم بە وردبینیکردنی&quot;{$submissionTitle}&quot; بۆ {$contextName} بە گوێرەی ئەم هەنگاوانە.<br />\n١. کلیک لەسەر ئەم توێژینەوە پێشکەشکراوەی خوارەوە بکە.<br />\n٢. هەمو فایلەکانی بکەوە و کاری وردبینییان بۆ بکە، هەر تێبینییەک پێویستە تکایە بینوسە.<br />\n٣. فایلە وردبینکراوەکان خەزن بکە و دوبارە باریان بکەوە.<br />\n٤. سەرنوسەر ئاگادار بکەوە لە تەواوبونی پرۆسەی وردبینی بۆ دەستپێکردنی پرۆسەی بڵاوکردنەوە.<br />\n<br />\n{$contextName} لینک: {$contextUrl}<br />\nلینکی توێژینەوەکە: {$submissionUrl}<br />\nناوی بەکارهێنەر: {$participantUsername}', 'ئەم ئیمەیڵە لە لایەن سەرنوسەری بەش بۆ وردبین دەنێردرێت بۆ ئاگادارکردنەوەیان لە دەستپێکردنی پرۆسەی وردبینی. ئەمە زانیاری دەربارەی توێژینەوەی پێشکەشکراو و چۆنییەتی دەستپێڕاگەیشتنی تێدایە.'),
('COPYEDIT_REQUEST', 'mk_MK', 'Барање за уредување', '{$participantName}:<br />\n<br />\nБи сакал да ве замолам да го превземете уредувањето на &quot;{$submissionTitle}&quot; за{$contextName} со тоа што ќе ги следите овие чекори.<br />\n1. Кликнете на URL-адресата на поднесокот подолу.<br />\n2. Отворете ги достапните датотеки под Датотеки за нацрт и извршете го вашето уредување, додека додавате Дискусии за уредување доколку се потребни.<br />\n3. Зачувајте ја уредената датотека(и), и прикачете ја на панелот Уредено.<br />\n4. Известете го уредникот дека сите датотеки се подготвени и дека процесот на обработка може да започне.<br />\n<br />\n{$contextName} URL-адреса: {$contextUrl}<br />\nURL-адреса на поднесокот: {$submissionUrl}<br />\nКорисничко име: {$participantUsername}', 'Овој и-меил е испратен од Секциски уредник до Уредник на поднесокот како барање да го започнат процесот на уредување. Обезбедува информации за поднесокот и како да се пристапи до истиот.'),
('COPYEDIT_REQUEST', 'nb_NO', 'Forespørsel om manuskriptredigering', '{$participantName}:<br />\n<br />\nTakk for at du har sagt deg villig til å bidra til arbeidet vårt. Innleveringen «{$submissionTitle}»; for {$contextName} er klar for redigering. Du finner innleveringen på tidsskriftets nettsted, sammen med vår «Instruks for språkvask.<br />\n<br />\n1. Klikk på innleveringens URL under<br />\n2. Åpne filer som er tilgjengelige under «Filer til språkvask». Legg til eventuelle kommentarer i diskusjonsfeltet.<br />\n3. Lagre de språkvaskede filene og last dem opp.<br />\n4. Informer redaktøren at alle filene har blitt bearbeidet og at produksjonen kan starte.<br/>\n<br />\n{$contextName} URL: {$submissionUrl}<br />\nBrukernavn: {$participantUsername}<br />', 'Denne e-posten sendes av en seksjonsredaktør til en språkvasker for å sette i gang arbeidet med språkvasken. E-posten gir informasjon om innleveringen, og om hvordan språkvaskeren får tilgang til den.'),
('COPYEDIT_REQUEST', 'nl_NL', 'Tekstredactie verzoek', '{$participantName}:<br />\n<br />\nIk wil u vragen om de teksredactie uit te voeren voor artikel &quot;{$submissionTitle}&quot; voor {$contextName} door deze stappen te volgen.<br />\n1. Klik op de inzendings-URL hieronder.<br />\n2. Log in bij het tijdschrift en klik op het bestand dat verschijnt bij Stap 1.<br />\n3. Raadpleeg de tekstredactie-instructies die op de webpagina staan.<br />\n4. Open het gedownloade bestand en doe de tekstredactie. Voeg auteursvragen toe waar nodig.<br />\n5. Bewaar het bewerkte bestand en laad het bij stap 1 van Tekstredactie.<br />\n6. Stuur de GEREED e-mail naar de redacteur.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nURL inzending: {$submissionUrl}<br />\nGerbruikersnaam: {$participantUsername}', 'Deze e-mail wordt door de sectieredacteur naar de tekstredacteur van een inzending gestuurd om te vragen het redactieproces te starten. Het bevat informatie over de inzending en hoe die te benaderen.'),
('COPYEDIT_REQUEST', 'pl_PL', 'Prośba do korektora', 'Szanowna Pani/ Szanowny Panie,<br />\n<br />\nproszę o wykonanie korekty tekstu &quot;{$submissionTitle}&quot;, zgłoszonego do czasopisma {$contextName}.\nProszę o postępowanie zgodnie z poniższymi krokami. <br />\n1. Kliknij na link do zgłoszonego tekstu znajdujący się poniżej.<br /> \n2. Pobierz pliki robocze i wykonaj korektę. Ustal zmiany z autorem używając narzędzi do dyskusji.<br />\n3. Zapisz poprawiony plik(i) i prześlij go do systemu.<br />\n4. Powiadom redaktora o ukończeniu korekty i przekazaniu tekstu do realizacji.<br />\n<br />\nWWW {$contextName}: {$contextUrl}<br />\nWWW tekstu: {$submissionUrl}<br />\nNazwa użytkownika: {$participantUsername}', 'Ta wiadomość jest wysyłana przez redaktora prowadzącego do korektora i zawiera prośbę o wykonanie korekty wraz z informacją o lokalizacji plików do korekty.'),
('COPYEDIT_REQUEST', 'pt_BR', 'Solicitação de edição de texto', '{$participantName}: <br />\n<br />\nPeço que você realize a revisão textual de &quot;{$submissionTitle}&quot; para {$contextName} seguindo estas etapas. <br />\n1. Clique no URL da Submissão abaixo. <br />\n2. Abra todos os arquivos disponíveis em "Arquivos de Versão Final" e faça sua revisão textual, adicionando quaisquer discussões em "Discussão da edição de texto" conforme necessário. <br />\n3. Salve os arquivos revisados e faça o carregamento no painel "Texto editado". <br />\n4. Notifique o Editor de que todos os arquivos foram preparados e que o processo de "Editoração" pode começar. <br />\n<br />\nURL de {$contextName}: {$contextUrl} <br />\nURL de Submissão: {$submitUrl} <br />\nNome de usuário: {$participantUsername}', 'Mensagem enviada pelo Editor de Seção solicitando a realização de uma tarefa de edição ao Editor de Texto, com informações sobre e como acessar o documento.'),
('COPYEDIT_REQUEST', 'pt_PT', 'Pedido de edição de texto', '{$participantName},<br />\n<br />\nSolicito a revisão do texto do manuscrito &quot;{$submissionTitle}&quot;, submetido à revista {$contextName}, conforme os seguintes passos:<br />\n1. Clique no URL da submissão, indicado mais adiante nesta mensagem.<br />\n2. Abra quaisquer ficheiros disponíveis nos Ficheiros de Rascunho e reveja o texto; pode adicionar Discussões de Edição de texto conforme for necessário.<br />\n3. Guarde o(s) ficheiro(s) revisto(s) e envie o ficheiro para o Painel de Edição de Texto.<br />\n4. Notifique o Editor que todos os ficheiros estão pronto, e o processo de Produção pode ser iniciado.<br />\n<br />\nURL da {$contextName}: {$contextUrl}<br />\nURL da Submissão: {$submissionUrl}<br />\nNome de utilizador: {$participantUsername}', 'Este e-mail é enviado pelo Editor de Secção a solicitar a realização de uma tarefa de edição ao Editor de Texto, com informações sobre e como aceder ao documento.'),
('COPYEDIT_REQUEST', 'ro_RO', 'Solicitare editare', '{$participantName}:<br />\n<br />\nVă rog să editați manuscrisul &quot;{$submissionTitle}&quot; pentru {$contextName} urmând pașii următori.<br />\n1. Click pe adresa manuscrisului de mai jos.<br />\n2. Deschideți orice fișiere disponibile în Schițe Fișiere și efectuați redactarea, adăugând în același timp orice discuții de redactare, după cum este necesar.<br />\n3. Salvați fișierele editate și încărcați-le în panoul Editare.<br />\n4. Notificați editorul că toate fișierele au fost pregătite și că procesul de producție poate începe.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nAdresă manuscris: {$submissionUrl}<br />\nNume de utilizator: {$participantUsername}', 'Acest e-mail este trimis de un editor de secțiune către redactorul unui manuscris pentru a solicita începerea procesului de redactare. Oferă informații despre manuscris și modul de accesare a acestuia.'),
('COPYEDIT_REQUEST', 'ru_RU', 'Запрос на литературное редактирование', 'Здравствуйте, {$participantName}!<br />\n<br />\nЯ хотел бы попросить Вас выполнить литературное редактирование материала «{$submissionTitle}» для журнала «{$contextName}», выполнив следующие шаги.<br />\n1. Щелкните на URL материала ниже.<br />\n2. Откройте все файлы, доступные в панели «Черновики», и выполните литературное редактирование, добавляя при необходимости Обсуждения литературного редактирования.<br />\n3. Сохраните отредактированные файлы и загрузите их в панель «Отредактированные».<br />\n4. Уведомите редактора о том, что все файлы были подготовлены и можно их запускать в производство.<br />\n<br />\nURL журнала «{$contextName}»: {$contextUrl}<br />\nURL материала: {$submissionUrl}<br />\nИмя пользователя: {$participantUsername}', 'Это письмо редактора раздела, отправляемое литературному редактору материала с запросом начала процесса литературного редактирования. В письме содержится информация о материале и о том, как получить к нему доступ.'),
('COPYEDIT_REQUEST', 'sk_SK', 'Žiadosť o redigovanie príspevku', '{$participantName}:<br />\n<br />\nChcel by som vás požiadať, aby ste zredigovali článok &quot;{$submissionTitle}&quot; pre {$contextName} a postupujte pritom prosím podľa nasledujúcich krokov:<br />\n1. Kliknite nižšie na URL príspevku.<br />\n2. Otvorte ľubovoľný súbor v sekcii Súbory návrhov a vykonajte redakčnú editáciu, prípadne využite diskusiu pre editačnú fázu.<br />\n3.  Uložte zredigovaný súbor a nahrajte ho v editačnom paneli.<br />\n4 . Upozornite redaktora, že všetky súbory boli zeditované a môže začať produkčná fáza.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nURL príspevku: {$submissionUrl}<br />\nPoužívateľské meno: {$participantUsername}', 'Tento email posiela editor sekcie redaktorovi, aby ho požiadal o začatie procesu redigovania. Obsahuje informácie o príspevku a ako sa k nemu dostať.'),
('COPYEDIT_REQUEST', 'sl_SI', 'Prošnja za lektoriranje', '{$participantName}:<br />\n<br />\nRad bi vas prosil, da opravite lektoriranje prispevka &quot;{$submissionTitle}&quot; za publikacijo {$contextName} po naslednjih korakih:<br />\n1. Kliknite na URL povezavo do prispevka spodaj.<br />\n2. Odprite vse datoteke, ki so na voljo pod Osnutki datotek in opravite lektroranje ter hkrati dodajte tudi razprave za lektoriranje, kot se vam zdi potrebno.<br />\n3. Shranite vse datoteke in jih naložite v razdelek z lektoriranimi datotekami.<br />\n4. Obvestite urednika, da so vse datoteke pripravljene in se lahko začne proces produkcije.<br />\n<br />\nPovezava do publikacije {$contextName}: {$contextUrl}<br />\nPovezava do prispevka: $submissionUrl}<br />\nUporabniško ime: {$participantUsername}', 'Ta email pošlje urednik rubrike lektorju prispevka s prošnjo za lektoriranje. Vsebuje kratka navodila za lektoranje in dostop do prispevka.'),
('COPYEDIT_REQUEST', 'sv_SE', 'Förfrågan om manusredigering', '{$participantName}:<br />\n<br />\nJag skulle vilja be dig om att genomföra manusredigering av &quot;{$submissionTitle}&quot; för {$contextName} genom att gå igenom följande steg:<br />\n1. Klicka på Bidragets URL nedan.<br />\n2. Öppna samtliga filer tillgängliga under Utkastfiler och manusredigera dem. Skriv i Manusredigeringsdiskussioner vid behov.<br />\n3. Spara manusredigerade filer och ladda upp under Manusredigerade-panelen.<br />\n4. Meddela Redaktören att samtliga filer har förberetts och att Produktionsprocessen kan påbörjas.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nBidragets URL: {$submissionUrl}<br />\nAnvändarnamn: {$participantUsername}', 'Det här e-postmeddelandet skickas från sektionsredaktören till ett bidrags manusredaktör för att be hen att påbörja manusredigeringsprocessen. Det innehåller information om bidraget och hur man får tillgång till det.'),
('COPYEDIT_REQUEST', 'tr_TR', 'Sayfa düzeni için rica', 'Sayın {$participantName},<br />\n<br />\n{$contextName} ileri sayılarında yayınlanmak üzere kabul edilen &quot;{$submissionTitle}&quot; başlıklı çalışmanın sayfa düzenini tamamlamanızı rica ederim. Dergi sitesinde yazıyı , sayfa düzeni konusundaki özel açıklamalar ile birlikte bulabilirsiniz. <br />\n<br />\nYazı ulaşım adresi: {$submissionUrl}<br />\nKullanıcı adı: {$participantUsername}<br />\n<br />\nLütfen eğer sayfa düzenini yapmanız konusunda bir sorun var ise bana bildiriniz.<br />\nDErgimizin kalitesini arttıran değerli katkılarınız için teşekkür ederiz.', 'Yayınlanması için karar verilen yazının sayfa düzeni için gönderilmesinde kullanılır.'),
('COPYEDIT_REQUEST', 'uk_UA', 'Запит на літературне редагування', '{$participantName}:<br />\n<br />\nЯ хотів би попросити Вас здійснити літературне редагування тексту &quot;{$submissionTitle}&quot; для видання &quot;{$contextName}&quot;, виконавши наступні кроки:<br />\n1. Натисніть на вказаній нижче адресі URL подання.<br />\n2. Увійдіть на сайт журналу та натисніть на посиланні &quot;Файл&quot; кроку 1.<br />\n3. Ознайомтеся з опублікованими на веб-сайті інструкціями з літературного редагування.<br />\n4. Відкрийте завантажений файл та відредагуйте його, додаючи у текст в разі потреби запити до автора.<br />\n5. Збережіть відредагований файл та вивантажте його на крок 1 літературного редагування.<br />\n6. Повідомте листом редактора про закінчення роботи.<br />\n<br />\nURL видання &quot;{$contextName}&quot;: <a href="{$contextUrl}">{$contextUrl}</a><br />\nURL подання: <a href="{$submissionUrl}">{$submissionUrl}</a><br />\nІм''я користувача: {$participantUsername}', 'Цим листом редактор розділу просить літературного редактора розпочати процес літературного редагування подання. У листі міститься інформація про подання та про те, як отримати доступ до нього.'),
('COPYEDIT_REQUEST', 'vi_VN', 'Yêu cầu biên tập bản thảo', 'Kính gửi {$participantName},<br />\n<br />\nTôi muốn yêu cầu bạn thực hiện việc biên tập bản thảo &quot;{$submissionTitle}&quot; cho {$contextName} bằng cách làm theo các bước sau.<br />\n1. Nhấp vào URL gửi dưới đây.<br />\n2. Mở bất kỳ tập tin có sẵn ở mục Nháp và biên tập bản thảo đó, đồng thời có thể thảo luận bất kỳ điều gì nếu cần thiết trong mục thảo luận bản thảo.<br />\n3. Lưu (các) tập tin đã biên tập bản thảo và tải lên.<br />\n4. Thông báo cho các biên tập viên mà tất cả các file đã được chuẩn bị, và rằng quá trình chế bản có thể bắt đầu.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nURL bài gửi: {$submissionUrl}<br />\nUsername: {$participantUsername}', 'Email này được gửi bởi một biên tập viên chuyên mục tới biên tập viên bản thảo rằng họ bắt đầu quá trình biên tập bản thảo. Nó cung cấp thông tin về bài gửi và làm thế nào để truy cập vào nó.'),
('COPYEDIT_REQUEST', 'zh_CN', '编辑要求', '{$participantName}您好：<br />\n<br />\n我想请您为《{$contextName}》担任稿件〈{$submissionTitle}〉的校样编辑。您可以在网站上找到这份稿件，以及校样编辑的工作指引。<br />\n<br />\n稿件网址：{$submissionUrl}"<br />\n用户名称：{$participantUsername}<br />\n<br />\n如果您目前无法进行这份工作，或者对这项工作有任何的疑问，请直接回信与我联络。非常感谢您同意为这份期刊进行这份重要的工作。', '这封电子邮件是由一位区段编辑寄发给稿件的校样编辑，请他们开始进行校样编辑的工作流程。邮件中含有关于稿件的信息以及如核取得稿件的指引.'),
('EDITOR_ASSIGN', 'ar_IQ', 'تعيين المحرر', '{$editorialContactName}:<br />\n<br />\nإن طلب النشر الموسوم &quot;{$submissionTitle},&quot; المقدم إلى {$contextName} قد تمت إحالته إليك لتقوم بإجراءات التحرير المتعلقة به بصفتك أحد أعضاء هيئة التحرير في هذا القسم من المجلة..<br />\n<br />\nرابط الطلب: {$submissionUrl}<br />\nاسم الدخول: {$editorUsername}<br />\n<br />\nشكراً لك.', 'هذه الرسالة تبلغ أحد المحررين في قسم ما من المجلة بإحالة مهمة تحرير أحد طلبات التقديم المرسلة إلى ذلك القسم من المجلة إليه، وتقدم له رابط الشروع بالتحرير عبر موقع المجلة.'),
('EDITOR_ASSIGN', 'bs_BA', 'Dodjela uredničkog zaduženja', '{$editorialContactName},<br />\n<br />\nu okviru raspodjele uredničkih zaduženja za časopis {$contextName} vama je dodijeljen zaprimljeni prilog &quot;{$submissionTitle}&quot; kako biste proveli postupak njegova uređivanja.<br />\n<br />\nURL priloga: {$submissionUrl}<br />\nKorisničko ime: {$editorUsername}<br />\n<br />\nUnaprijed hvala.', 'Ovim obrascem e-pošte glavni urednik obavještava urednika rubrike da mu je dodijeljen zadatak vođenja priloga kroz uređivački postupak. Obrazac pruža i osnovne informacije o prilogu.'),
('EDITOR_ASSIGN', 'ca_ES', 'Assignació editorial', 'Benvolgut/uda {$editorialContactName},<br />\n<br />\nUs ha estat assignada la tramesa &quot;{$submissionTitle}&quot; per a la revista {$contextName} perquè en superviseu el procés editorial en qualitat d''editor de secció.<br />\n<br />\nURL de la tramesa: {$submissionUrl}<br />\nNom d''usuari: {$editorUsername}<br />\n<br />\nMoltes gràcies.', 'Aquest missatge de correu electrònic notifica a l''editor de secció que l''editor li ha assignat la tasca de supervisar el procés editorial d''una tramesa. Proporciona informació sobre la tramesa i indica com s''ha d''accedir al lloc web de la revista.'),
('EDITOR_ASSIGN', 'cs_CZ', 'Editorský úkol', '{$editorialContactName}:<br />\n<br />\nByl Vám přidělen příspěvek &quot;{$submissionTitle}&quot; do {$contextName}, abyste s ním v roli editora sekce prošel redakčním zpracováním.<br />\n<br />\nURL příspěvku: {$submissionUrl}<br />\nUživatelské jméno: {$editorUsername}<br />\n<br />\nDěkujeme.', 'Tento email informuje editora sekce, že mu editor přidělil úkol dohlížet na příspěvek během redakčního zpracování. Obsahuje informace o příspěvku a přístupu na stránky časopisu.'),
('EDITOR_ASSIGN', 'da_DK', 'Redaktionel tildeling', '{$editorialContactName}:<br />\n<br />\nSom sektionsredaktør har du fået tildelt manuskriptet &quot;{$submissionTitle}&quot;, der er sendt til {$contextName}, og som du skal følge igennem den redaktionelle proces. <br />\n<br />\nManuskriptets URL-adresse: {$submissionUrl}<br />\nBrugernavn: {$editorUsername}<br />\n<br />\nTak.', 'Denne e-mail underretter en sektionsredaktør om, at redaktøren har tildelt vedkommende opgaven med at følge et manuskript igennem redigeringsprocessen. Den indeholder oplysninger om manuskriptet og om, hvordan der oprettes adgang til tidsskriftets websted.'),
('EDITOR_ASSIGN', 'de_DE', 'Zuweisung an Rubrikredakteur/in', '{$editorialContactName},<br />\n<br />\nder Beitrag &quot;{$submissionTitle}&quot; für {$contextName} wird Ihnen zur Durchführung des redaktionellen Prozesses in Ihrer Rolle als Rubrikredakteur/in zugewiesen.<br />\n<br />\nURL des Beitrags: {$submissionUrl}<br />\nBenutzer/innenname: {$editorUsername}<br />\n<br />\nVielen Dank.', 'Diese E-Mail benachrichtigt eine/n Rubrikredakteur/in, dass die Redakteurin/der Redakteur ihr/ihm die Aufgabe übertragen hat, eine Einreichung durch den Redaktionsprozess hindurch zu betreuen. Sie liefert Informationen zu der Einreichung und darüber, wie auf die Zeitschriftenseite zugegriffen werden kann.'),
('EDITOR_ASSIGN', 'el_GR', 'Ανάθεση επιμέλειας', '{$editorialContactName}:<br />\n<br />\nΣας έχει ανατεθεί η επιμέλεια της υποβολής &quot;{$submissionTitle},&quot; στο περιοδικό {$contextName}, στο πλαίσιο του ρόλου σας ως Επιμελητής Ενότητας.<br />\n<br />\nΣύνδεσμος υποβολής: {$submissionUrl}<br />\nΌνομα Χρήστη: {$editorUsername}<br />\n<br />\nΣας ευχαριστούμε.', 'Το παρόν μήνυμα ενημερώνει έναν Επιμελητή Ενότητας για την ανάθεση της επιμέλειας μιας υποβολής. Παρέχει πληροφορίες σχετικά με την υποβολή και τον τρόπο πρόσβασης στον ιστότοπο του περιοδικού.'),
('EDITOR_ASSIGN', 'en_US', 'Editorial Assignment', '{$editorialContactName}:<br />\n<br />\nThe submission, &quot;{$submissionTitle},&quot; to {$contextName} has been assigned to you to see through the editorial process in your role as Section Editor.<br />\n<br />\nSubmission URL: {$submissionUrl}<br />\nUsername: {$editorUsername}<br />\n<br />\nThank you.', 'This email notifies a Section Editor that the Editor has assigned them the task of overseeing a submission through the editing process. It provides information about the submission and how to access the journal site.'),
('EDITOR_ASSIGN', 'es_ES', 'Asignación editorial', '{$editorialContactName}:<br />\n<br />\nSe le ha asignado el envío, &quot;{$submissionTitle},&quot; a {$contextName} para que lo revise en el proceso editorial como Editor/a de Sección.<br />\n<br />\nURL del envío: {$submissionUrl}<br />\nUsuario/a: {$editorUsername}<br />\n<br />\nGracias.', 'Este correo notifica al / a la Editor/a de Sección de que les ha asignado la tarea de supervisar un envío a través del proceso editorial. Proporciona información sobre el envío y cómo acceder a la revista.'),
('EDITOR_ASSIGN', 'eu_ES', 'Editore-lana esleitzea', '{$editorialContactName}:<br />\n<br />\n{$contextName} aldizkariko “{$submissionTitle}” artikulua esleitu dizugu prozesu editorialean eraman dezazun, Ataleko editore gisa.<br />\n<br />\nArtikuluaren URLa: {$submissionUrl}<br />\nErabiltzaile-izena: {$editorUsername}<br />\n<br />\nEskerrik asko.', 'Mezu honek Ataleko editore bati jakinarazten dio Editoreak bidalketa baten edizio-prozesua gainbegiratzeko izendatu duela. Artikuluari buruzko informazioa eta aldizkariaren gunean sartzeko datuak ematen ditu.'),
('EDITOR_ASSIGN', 'fa_IR', 'تعیین کارشناس مسئول', '{$editorialContactName}:<br />\n<br />\nشما به عنوان کارشناس مسئول مقاله ضضض مربوط به {$contextName} انتخاب شده اید تا بر مراحل ویرایش آن نظارت داشته باشید.<br />\n<br />\nآدرس مقاله: {$submissionUrl}<br />\nنام کاربری: {$editorUsername}<br />\n<br />\nمتشکرم', 'This email notifies a Section Editor that the Editor has assigned them the task of overseeing a submission through the editing process. It provides information about the submission and how to access the journal site.'),
('EDITOR_ASSIGN', 'fi_FI', 'Toimituksellinen toimeksianto', 'Hyvä {$editorialContactName},<br />\n<br />\nKäsikirjoitus &quot;{$submissionTitle},&quot; julkaisuun {$contextName} on annettu toimitusprosessin ajaksi teidän vastuullenne osastotoimittajan roolissanne.<br />\n<br />\nKäsikirjoituksen URL: {$submissionUrl}<br />\nKäyttäjätunnus: {$editorUsername}<br />\n<br />\nYstävällisin terveisin.', 'This email notifies a Section Editor that the Editor has assigned them the task of overseeing a submission through the editing process. It provides information about the submission and how to access the journal site.'),
('EDITOR_ASSIGN', 'fr_CA', 'Assignation d''un-e rédacteur-trice', '{$editorialContactName},<br />\n<br />\nLa soumission intitulée « {$submissionTitle} » pour la revue {$contextName} vous a été attribuée. Vous êtes responsable, en tant que rédacteur-trice de rubrique, de la faire cheminer à travers le processus éditorial.<br />\n<br />\nURL de la soumission : {$submissionUrl}<br />\nNom d''utilisateur-trice : {$editorUsername}<br />\n<br />\nMerci.', 'Ce courriel avise un,une rédacteur-trice de rubrique que le,la rédacteur-trice lui a assigné la tâche de suivre une soumission durant le processus éditorial. Il fournit des renseignements sur la soumission, et comment accéder au site Web de la revue.'),
('EDITOR_ASSIGN', 'fr_FR', 'Assignation d''une soumission', '{$editorialContactName}:<br />\n<br />\nLa soumission intitulée « {$submissionTitle} » pour la revue {$contextName} vous a été attribuée. Vous êtes conséquemment responsable, en tant que Rédacteur de rubrique, de faire cheminer cet article à travers le processus d''évaluation.<br />\n<br />\nURL de la soumission : {$submissionUrl}<br />\nNom d''utilisateur : {$editorUsername}<br />\n<br />\nMerci.', 'Ce courriel avise un Rédacteur de rubrique que le Rédacteur lui a assigné la tâche de suivre une soumission durant le processus éditorial. Il fournit de l''information sur la soumission, et comment accéder au site Web de la revue.'),
('EDITOR_ASSIGN', 'gd_GB', 'Iomruineadh deasachaidh', '{$editorialContactName}:<br />\n<br />\nChaidh an tagradh “{$submissionTitle}” airson {$contextName} iomruineadh dhut airson a stiùireadh tron phròiseas deasachaidh ’s tu nad dheasaiche earrainn.<br />\n<br />\nURL an tagraidh: {$submissionUrl}<br />\nAinm-cleachdaiche: {$editorUsername}<br />\n<br />\nMòran taing.', 'Tha am post-d seo ag innse do dheasaiche earrainn gun tug deasaiche obair stiùireadh tagraidh tron phròiseas deasachaidh dhut. Tha e a’ toirt seachad fiosrachadh mun tagradh agus mar a gheibhear cothrom air làrach an iris-leabhair.'),
('EDITOR_ASSIGN', 'he_IL', 'הקצאת עריכה', '{editorialContactName$}:<br />\n<br />\nכתב יד {submissionTitle$} ל{contextName$} שויך אליך לטיפול בשלבי העריכה.<br />\n<br />\nאתר הגשה: {submissionUrl$}<br />\nשם משתמש: {editorUsername$}<br />\n<br />\nתודה.', 'דוא"ל זה מודיע לעורך מדורים כי העורך הקצה להם את המשימה לפקח על הגשה באמצעות תהליך העריכה. הוא מספק מידע על ההגשה וכיצד לגשת לאתר כתב העת.'),
('EDITOR_ASSIGN', 'hi_IN', 'संपादकीय असाइनमेंट', '{$editorialContactName}:<br />\n<br />\nप्रस्तुत, &quot;{$submissionTitle},&quot; to {$contextName} आपको सेक्शन एडिटर के रूप में अपनी भूमिका में संपादकीय प्रक्रिया के माध्यम से देखने का काम सौंपा गया है.<br />\n<br />\nSubmission URL: {$submissionUrl}<br />\nUsername: {$editorUsername}<br />\n<br />\nThank you.', 'यह ईमेल एक अनुभाग संपादक को सूचित करता है कि संपादक ने उन्हें संपादन प्रक्रिया के माध्यम से सबमिशन की देखरेख का काम सौंपा है। यह सबमिशन और जर्नल साइट को एक्सेस करने के तरीके के बारे में जानकारी प्रदान करता है.'),
('EDITOR_ASSIGN', 'hr_HR', 'Dodjela uredničkog zaduženja', '{$editorialContactName},<br />\n<br />\nu okviru raspodjele uredničkih zaduženja za časopis {$contextName} vama je dodijeljen zaprimljeni prilog &quot;{$submissionTitle}&quot; kako biste proveli postupak njegova uređivanja.<br />\n<br />\nURL priloga: {$submissionUrl}<br />\nKorisničko ime: {$editorUsername}<br />\n<br />\nUnaprijed hvala.', 'Ovim obrascem e-pošte glavni urednik obavještava urednika rubrike da mu je dodijeljen zadatak vođenja priloga kroz uređivački postupak. Obrazac pruža i osnovne informacije o prilogu.'),
('EDITOR_ASSIGN', 'hu_HU', 'Szerkesztői megbízás', 'Tisztelt {$editorialContactName}!<br />\n<br />\nA(z) {$contextName} folyóirathoz benyújtott &quot;{$submissionTitle},&quot; című kézirat Önhöz lett rendelve, hogy Rovatszerkesztőként kövesse végig a szerkesztési folyamatot.<br />\n<br />\nKézirat URL: {$submissionUrl}<br />\nFelhasználónév: {$editorUsername}<br />\n<br />\nKöszönettel,<br />\n{$editorialContactSignature}', 'Ez az email értesíti a Rovatszerkesztőt, hogy a Szerkesztő rászignálta a beküldött anyag nyomon követését valamint felügyeletét a teljes szerkesztési fázisban. Információt ad a kéziratról és arról, hogyan férhet hozzá a folyóirat oldalán.'),
('EDITOR_ASSIGN', 'id_ID', 'Penugasan Editorial', '{$editorialContactName}:<br />\n<br />\nNaskah, &quot;{$submissionTitle},&quot; di {$contextName} telah ditugaskan kepada Anda sebagai Editor Bagian untuk memastikan selesainya seluruh proses editorial.<br />\n<br />\nURL Naskah: {$submissionUrl}<br />\nNama pengguna: {$editorUsername}<br />\n<br />\nTerimakasih.', 'Email ini memberitahu Editor Bagian bahwa Editor telah memberikan tugas untuk mengawasi suatu naskah dalam menyelesaikan proses editorial. Email ini memberikan informasi mengenai naskah dan cara mengaksesnya di website jurnal.'),
('EDITOR_ASSIGN', 'it_IT', 'Assegnazione  della proposta', 'Gentile {$editorialContactName},<br />\n<br />\nLa submission, &quot;{$submissionTitle},&quot; a {$contextName} ti è stata assegnata come Section Editor.<br />\n<br />\nSubmission URL: {$submissionUrl}<br />\nUsername: {$editorUsername}<br />\n<br />\nGrazie.', 'Questa email notifica ai section editor che l''editor ha assegnato loro il compito di supervisionare una submission attraverso il processo editoriale. Questa fornisce informazioni sulla submission e su come accedere al sito del journal.'),
('EDITOR_ASSIGN', 'ja_JP', 'セクションエディタ任命のお知らせ', '{$editorialContactName}様<br />\n<br />\nこの度、雑誌『{$contextName}』への投稿論文「{$submissionTitle}」のセクションエディタとして、編集プロセス全般の管理をお願いすることになりました。<br />\n<br />\n投稿物のURL: {$submissionUrl}<br />\nユーザー名: {$editorUsername}<br />\n<br />\nよろしくお願いいたします。', 'このメールは、編集者からセクションエディタに投稿物の編集プロセスを監督する作業を任命したことを通知するものです。メールには投稿物に関する情報と雑誌サイトへのアクセス法を示しています。'),
('EDITOR_ASSIGN', 'ku_IQ', 'ئەرکدارکردنی سەرنوسەر', '{$editorialContactName}:<br />\n<br />\nپێشکەشکردنەکە, &quot;{$submissionTitle},&quot; بۆ{$contextName} تۆ دیاری کرایت وەک سەرنوسەری بەش بەمەبەستی تەواوکردنی کارەکانی هەڵسەنگاندنی ئەم توێژینەوەیە.<br />\n<br />\nلینکی پێشکەشکردن: {$submissionUrl}<br />\nناوی بەکارهێنەر: {$editorUsername}<br />\n<br />\nThank you.', 'ئەم ئیمەیڵە ئاگاداری سەرنوسەری بەش دەکات کە لەلایەن سەرنوسەرەوە ئەرکدار کراوە بە مەبەستی هەڵسەنگاندنی توێژینەوەی پێشکەشکراو. ئەمەش زانیاریی پێویستی دەربارەی پێشکەشکردنەکە و شێوازی بەکارهێنانی پەڕەی گۆڤاری تێدایە.'),
('EDITOR_ASSIGN', 'mk_MK', 'Уредувачко задолжение', '{$editorialContactName}:<br />\n<br />\nПоднесокот, &quot;{$submissionTitle},&quot; до {$contextName} ви е доделен за да го надгледувате низ процесот на уредување во вашата улога на Секциски уредник<br />\n<br />\nURL-адреса на поднесокот: {$submissionUrl}<br />\nКорисничко име: {$editorUsername}<br />\n<br />\nВи благодарам.', 'Овој и-меил го известува Секцискиот уредник дека уредникот му ја доделил задачата да го надгледува поднесокот низ процесот на уредување. Обезбедува информации за поднесокот и како да се пристапи до веб-страницата на списанието.'),
('EDITOR_ASSIGN', 'nb_NO', 'Redaksjonelt oppdrag', '{$editorialContactName}:<br />\n<br />\nSom seksjonsredaktør i {$contextName} er du herved oppnevnt til å lede det innsendte manuskriptet &quot;{$submissionTitle}&quot; gjennom den redaksjonelle prosessen.<br />\n<br />\nManuskript URL: {$submissionUrl}<br />\nBrukernavn: {$editorUsername}<br />\n<br />\nVennlig hilsen.', 'Denne e-posten varsler en Seksjonsredaktør om at Ansvarlig redaktør har oppnevnt vedkommende til å føre et innsendt manuskript gjennom den redaksjonelle prosessen. E-posten inneholder informasjon om det innsendte manuskriptet og om tilgang til tidsskriftets nettsted.'),
('EDITOR_ASSIGN', 'nl_NL', 'Redactietaak', '{$editorialContactName}:<br />\n<br />\nDe inzending &quot;{$submissionTitle}&quot; voor {$contextName} is aan u toegewezen om in uw rol als sectieredacteur door het redactieproces te leiden.<br />\n<br />\nURL inzending: {$submissionUrl}<br />\nGebruikersnaam: {$editorUsername}<br />\n<br />\nDank u.', 'Deze e-mail bericht een sectieredacteur dat de redacteur een inzending heeft toegewezen om door het redactieproces te leiden. Het geeft informatie over de inzending en hoe de tijdschrift-website te benaderen.'),
('EDITOR_ASSIGN', 'pl_PL', 'Przypisanie redaktora', 'Szanowna Pani/ Szanowny Panie,<br />\n<br />\ntekst "{$submissionTitle}" zgłoszony do czasopisma "{$contextName}", został przypisany do Pani/ Pana jako redaktora prowadzącego.<br />\n<br />\nWWW tekstu: {$submissionUrl}<br />\nNazwa użytkownika: {$editorUsername}<br />\n<br />\nZ wyrazami szacunku.', 'Powiadomienie wysyłane do redaktora prowadzącego (np. redaktora działu) o przypisaniu go do zgłoszenia.'),
('EDITOR_ASSIGN', 'pt_BR', 'Tarefa editorial', '{$editorialContactName}:<br />\n<br />\nA submissão, &quot;{$submissionTitle},&quot; ao periódico {$contextName} lhe foi designada para acompanhar o processo editorial em sua função como Editor de Seção.<br />\n<br />\nURL da Submissão: {$submissionUrl}<br />\nUsuário: {$editorUsername}<br />\n<br />\nObrigado.', 'Mensagem notifica o Editor de Seção que uma nova tarefa de acompanhamento de submissão lhe foi designada pelo Editor-Gerente. Oferece informações sobre a submissão e como acessar o sistema.'),
('EDITOR_ASSIGN', 'pt_PT', 'Tarefa editorial', '{$editorialContactName},<br />\n<br />\nA submissão &quot;{$submissionTitle}&quot; a {$contextName} foi-lhe atribuída para acompanhar o processo editorial, como parte das suas funções como Editor de Secção.<br />\n<br />\nURL da Submissão: {$submissionUrl}<br />\nNome de utilizador: {$editorUsername}<br />\n<br />\nAgradecendo desde já a sua atenção.', 'Este e-mail notifica o Editor de Secção de que uma nova tarefa editorial lhe foi designada pelo Editor. Fornece informações sobre a submissão e como aceder ao sistema.'),
('EDITOR_ASSIGN', 'ro_RO', 'Atribuire articol editorilor', '{$editorialContactName}:<br />\n<br />\nManuscrisul, &quot;{$submissionTitle},&quot; înregistrat la {$contextName} v-a fost atribuit pentru a coordona procesul editorial ca editor de secțiune.<br />\n<br />\nURL înregistrare manuscris: {$submissionUrl}<br />\nUtilizator: {$editorUsername}<br />\n<br />\nMulțumesc.', 'Acest e-mail anunță un editor de secțiune că editorul principal i-a atribuit sarcina de a supraveghea o înregistrare de manuscris prin procesul de editare. Oferă informații despre manuscris și cum poate fi accesat site-ul jurnalului.'),
('EDITOR_ASSIGN', 'ru_RU', 'Назначение редактором', 'Здравствуйте, {$editorialContactName}!<br />\n<br />\nВ соответствии с Вашей ролью редактора раздела Вам поручен контроль прохождения через редакционный процесс материала «{$submissionTitle}» в журнале «{$contextName}».<br />\n<br />\nURL материала: {$submissionUrl}<br />\nИмя пользователя: {$editorUsername}<br />\n<br />\nЗаранее благодарю.', 'Это письмо уведомляет редактора раздела о том, что редактор поручил ему контроль прохождения материала через редакционный процесс. В письме содержится информация о материале и о том, как войти на сайт журнала.'),
('EDITOR_ASSIGN', 'sk_SK', 'Editorská úloha', '{$editorialContactName}:<br />\n<br />\nBol Vám pridelený príspevok &quot;{$submissionTitle}&quot; do {$contextName}, aby ste s ním v úlohe editora sekcie prešiel redakčným spracovaním.<br />\n<br />\nURL príspevku: {$submissionUrl}<br />\nPoužívateľské meno: {$editorUsername}<br />\n<br />\nĎakujeme.', 'Tento email informuje editora sekcie, že mu editor pridelil úlohu dohliadať na príspevok počas redakčného spracovania. Obsahuje informácie o príspevku a prístupe na stránky časopisu.'),
('EDITOR_ASSIGN', 'sl_SI', 'Uredniška zadolžitev', '{$editorialContactName}:<br />\n<br />\nPrispevek, &quot;{$submissionTitle},&quot; v reviji {$contextName} vam je bil dodeljen, kot uredniku rubrike, da nadzorujete uredniški proces.<br />\n<br />\nURL povezava prispevka: {$submissionUrl}<br />\nUporabniško ime: {$editorUsername}<br />\n<br />\nHvala.', 'Email je obvestilo urendiku rubrike, da je zadolžen za vodenje prispevka skozi urendiški postopek. Vsebuje informacije o prispevku in dostopu do spletne strani revije.'),
('EDITOR_ASSIGN', 'sv_SE', 'Redaktionellt uppdrag', '{$editorialContactName}:<br />\n<br />\nSom sektionsredaktör hos {$contextName} har du fått i uppdrag att föra bidraget &quot;{$submissionTitle},&quot; genom den redaktionella processen.<br />\n<br />\nBidragets URL: {$submissionUrl}<br />\nAnvändarnamn: {$editorUsername}<br />\n<br />\nTack och med vänliga hälsningar.', 'Det här e-postmeddelandet meddelar en sektionsredaktör att redaktören utsett hen att ansvara för ett bidrag genom den redaktionella processen. Det innehåller även information om bidraget och hur man loggar in på tidskriftens webbplats.'),
('EDITOR_ASSIGN', 'tr_TR', 'Bölüm Editörü Ataması', 'Sayın {$editorialContactName},<br />\n<br />\n{$contextName} için gönderilen &quot;{$submissionTitle}&quot; başlıklı çalışma, Bölüm Editörü olarak değerlendirme süreçlerini takip etmeniz üzere size atanmıştır. <br />\n<br />\nBaşvuru Erişim Adresi: {$submissionUrl}<br />\nKullanıcı Adınız: {$editorUsername}<br />\n<br />\nTeşekkür ederiz.', 'Bu eposta, bir Bölüm Editörüne bir gönderinin yayınlanma sürecinde supervizörlük görevi verildiğini bildirir. Gönderi hakkındaki bilgileri ve dergi internet sitesine girişte gerekli olan bilgileri içerir.'),
('EDITOR_ASSIGN', 'uk_UA', 'Редакційне призначення', '{$editorialContactName}:<br />\n<br />\nЯк редактор розділу Ви були призначені керувати процесом редакційного опрацювання подання &quot;{$submissionTitle}&quot; до видання &quot;{$contextName}&quot;.  <br />\n<br />\nURL подання: {$submissionUrl}<br />\nІм''я користувача: {$editorUsername}<br />\n<br />\nДякую.', 'Цим листом редактор видання повідомляє редактора розділу про доручення йому нагляду за процесом редакційного опрацювання подання. У листі міститься інформація про подання та про те, як отримати доступ до сайту журналу.'),
('EDITOR_ASSIGN', 'vi_VN', 'Phân công biên tập', 'Kính gửi {$editorialContactName},<br />\n<br />\nBài gửi, &quot;{$submissionTitle},&quot; của {$contextName} đã được phân công cho bạn để xem qua quy trình biên tập với vai trò là Biên tập viên chuyên mục.<br />\n<br />\nURL bài gửi: {$submissionUrl}<br />\nUsername: {$editorUsername}<br />\n<br />\nTrân trọng.', 'Email này thông báo cho Biên tập viên chuyên mục rằng Biên tập viên đã giao cho họ nhiệm vụ giám sát việc gửi qua quá trình bình duyệt. Nó cung cấp thông tin về việc nộp và cách truy cập trang tạp chí.'),
('EDITOR_ASSIGN', 'zh_CN', '指派编辑任务', '{$editorialContactName}:<br />\n<br />\n我们已经将投稿到《{$contextName}》的稿件〈{$submissionTitle}〉指派给您进行编辑工作，请在您的「区段编辑」介面中进行编辑工作。<br />\n<br />\n稿件网址：{$submissionUrl}<br />\n用户名称：{$editorUsername}<br />\n<br />\n谢谢您。', '这封电子邮件通知一个区段编辑说，编辑已经指派他们透过编辑流程来审查一份稿件。邮件中含有关于稿件以及如何进入期刊网站的信息。'),
('EDITOR_DECISION_ACCEPT', 'ar_IQ', 'قرار هيئة التحرير', '{$authorName}:<br />\n<br />\nقد توصلنا إلى قرار بشأن طلبك للنشر في {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nقرارنا هو: قبول طلب النشر', 'هذه الرسالة يعنونها محرر القسم إلى طالب النشر يعلمه فيها بقبول هيئة التحرير لطلبه.'),
('EDITOR_DECISION_ACCEPT', 'ca_ES', 'Decisió de l''editor/a', '{$authorName}:<br />\n<br />\nHem arribat a una decisió respecte a la vostra tramesa per a {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa nostra decisió és: Acceptar la tramesa', 'Aquest correu electrònic de l''editor/a o de l''editor/a de secció s''adreça a un autor/a per notificar-li que s''ha pres la decisió final d''acceptar la seva tramesa.'),
('EDITOR_DECISION_ACCEPT', 'cs_CZ', 'Rozhodnutí editora', '{$authorName}:<br />\n<br />\nUčinili jsme rozhodnutí ohledně Vašeho příspěvku do {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNaše rozhodnutí je: přijmout příspěvek k publikaci', 'Tento e-mail od editora nebo editora sekce autorovi obsahuje informaci o konečném rozhodnutí o přijetí příspěvku.'),
('EDITOR_DECISION_ACCEPT', 'da_DK', 'Redaktørbeslutning', '{$authorName}:<br />\n<br />\nVi er nået frem til en afgørelse vedrørende dit bidrag til {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nVi har besluttet at: Acceptere manuskript', 'Denne e-mail fra redaktøren eller sektionsredaktøren til en forfatter er en meddelelse om den endelige afgørelse vedrørende deres bidrag.'),
('EDITOR_DECISION_ACCEPT', 'de_DE', 'Entscheidung der Redaktion', '{$authorName},<br />\n<br />\nwir sind zu einer Entscheidung in Bezug auf Ihre Einreichung für {$contextName}: &quot;{$submissionTitle}&quot; gekommen.<br />\n<br />\nUnsere Entscheidung lautet: Beitrag annehmen', 'Diese E-Mail von der/dem Redakteur/in oder Rubrikredakteur/in an eine/n Autor/in informiert diese/n über eine getroffene Entscheidung zu ihrer/seiner Einreichung.'),
('EDITOR_DECISION_ACCEPT', 'el_GR', 'Απόφαση Επιμελητή', '{$authorName}:<br />\n<br />\nΈχουμε καταλήξει σε μία απόφαση αναφορικά με την υποβολή σας &quot;{$submissionTitle}&quot;, στο περιοδικό {$contextName}.<br />\n<br />\nΗ απόφασή μας είναι: Αποδοχή της υποβολής', 'Το παρόν μήνυμα αποστέλλεται από τον Επιμελητή ή τον Επιμελητή Ενότητας στον Συγγραφέα, ως ενημέρωση για την τελική αποδοχή της υποβολής.'),
('EDITOR_DECISION_ACCEPT', 'en_US', 'Editor Decision', '{$authorName}:<br />\n<br />\nWe have reached a decision regarding your submission to {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOur decision is to: Accept Submission', 'This email from the Editor or Section Editor to an Author notifies them of a final "accept submission" decision regarding their submission.'),
('EDITOR_DECISION_ACCEPT', 'es_ES', 'Decisión del editor/a', '{$authorName}:<br />\n<br />\nHemos tomado una decisión sobre su envío en {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNuestra decisión es: Aceptar el envío', 'Este correo electrónico del editor/a o editor/a de sección para el autor/a le notifica que la decisión final es aceptar su envío .'),
('EDITOR_DECISION_ACCEPT', 'eu_ES', 'Editorearen erabakia', '{$authorName}:<br />\n<br />\nHartu dugu {$contextName} aldizkarira bidali zenuen &quot;{$submissionTitle}&quot; artikuluari buruzko erabakia.<br />\n<br />\nGure erabakia:', 'Mezu hau Editoreak edo Ataleko editoreak bidaltzen dio Egileari, artikuluari buruz hartu duen erabakia jakinarazteko.'),
('EDITOR_DECISION_ACCEPT', 'fa_IR', 'تصمیم دبیر', '{$authorName}:<br />\n<br />\nدر مورد مقاله ارسالی شما (&quot;{$submissionTitle}&quot;) در {$contextName} تصمصم نهایی اتخاذ شده است.<br />\n<br />\nتصمیم نهایی: پذیرش مقاله ارسالی', 'ایمیلی از طرف سردبیر یا دبیر بخش به نویسنده برای اطلاع از پذیرش مقاله'),
('EDITOR_DECISION_ACCEPT', 'fi_FI', 'Toimittajan päätös', 'Hyvä {$authorName},<br />\n<br />\nOlemme tehneet päätöksen julkaisuun {$contextName} lähettämäänne käsikirjoitusta &quot;{$submissionTitle}&quot; koskien<br />\n<br />\nPäätöksemme on: Käsikirjoitus on hyväksytty', 'This email from the Editor or Section Editor to an Author notifies them of a final "accept submission" decision regarding their submission.'),
('EDITOR_DECISION_ACCEPT', 'fr_CA', 'Décision du rédacteur', '{$authorName},<br />\n<br />\nNous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$contextName}.<br />\n<br />\nNotre décision est d''accepter votre soumission.', 'Ce courriel du,de la rédacteur-trice ou du,de la rédacteur-trice de rubrique à un-e auteur-e le,la notifie de la décision finale concernant sa soumission, soit d''accepter sa soumission.'),
('EDITOR_DECISION_ACCEPT', 'fr_FR', 'Décision du rédacteur', '{$authorName}:<br />\n<br />\nNous avons pris une décision concernant votre soumission à {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNotre décision est d''accepter votre soumission.', 'Cet courriel du rédacteur ou du chef de rubrique à un auteur les notifie d''une décision finale de «soumission acceptée» concernant leur soumission.'),
('EDITOR_DECISION_ACCEPT', 'gd_GB', 'Co-dhùnadh deasaiche', '{$authorName}:<br />\n<br />\nThàinig sinn gu co-dhùnadh a thaobh an tagraidh agad gu {$contextName}, “{$submissionTitle}”.<br />\n<br />\nCho-dhùin sinn Gabh ris an tagradh', 'Tha am post-d seo on deasaiche no o dheasaiche na h-earrainn gu ùghdar a’ leigeil fios thuca gum b’ e “gabhail ris” an co-dhùnadh deireannach mun tagradh aca.');
INSERT INTO `email_templates_default_data` VALUES
('EDITOR_DECISION_ACCEPT', 'he_IL', 'החלטת העורך', '{authorName$}: \n<br />\nהגענו להחלטה לגבי הגשה שלך ל{contextName$}: {$submissionTitle$}\n<br />\nהחלטה שלנו: קבל הגשה', '##emails.editorDecisionAccept.description##'),
('EDITOR_DECISION_ACCEPT', 'hi_IN', 'संपादक का निर्णय', '{$authorName}:<br />\n<br />\nहम आपके सबमिशन के बारे में निर्णय ले चुके हैं to {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nहमारा निर्णय है: सबमिशन को स्वीकार करना', 'एक लेखक के संपादक या अनुभाग संपादक का यह ईमेल उन्हें अंतिम रूप से "सबमिशन स्वीकार" करने का निर्णय देता है.'),
('EDITOR_DECISION_ACCEPT', 'hu_HU', 'Szerkesztői döntés', 'Tisztelt {$authorName}!<br />\n<br />\nÉrtesítjük, hogy a(z) {$contextName} folyóirathoz beküldött &quot;{$submissionTitle}&quot; című kézirata elfogadásra került.<br />\n<br />\nÜdvözlettel,<br />\n{$editorialContactSignature}<br />', 'Ezt az emailt a Szerkesztő vagy Rovatszerkesztő küldi a Szerzőnek jelezve, hogy a kézirattal kapcsolatos döntés "Kézirat elfogadva" megszületett.'),
('EDITOR_DECISION_ACCEPT', 'id_ID', 'Keputusan Editor', '{$authorName}:<br />\n<br />\nKami telah membuat keputusan terkait naskah yang Anda kirimkan ke {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nKeputusan kami adalah: Naskah Diterima', 'Email ini dari Editor atau Editor Bagian kepada Penulis memberitahukan keputusan final "Naskah Diterima".'),
('EDITOR_DECISION_ACCEPT', 'it_IT', 'Decisione dell''editor', '&lt;![CDATA[{$authorName}:<br />\n<br />\nAbbiamo raggiunto una decisione riguardo alla Sua submission a {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa decisione è di accettare la proposta', 'Questa mail è inviata dall''Editor o Section Editor ad un autore per avvisarlo che è stata presa la decisione finale di accettare il manoscritto per la pubblicazione.'),
('EDITOR_DECISION_ACCEPT', 'ja_JP', '編集者の判断', '{$authorName}様:<br />\n<br />\n下記の投稿について結論に達しましたので、連絡いたします。\n『{$contextName}』「{$submissionTitle}」<br />\n<br />\n結果は: 投稿の受理', '編集者またはセクションエディターから著者へのこのメールは、投稿に関する最終的な「投稿の受理」の決定を著者に通知するものです。'),
('EDITOR_DECISION_ACCEPT', 'ku_IQ', 'بڕیاری سەرنوسەر', '{$authorName}:<br />\n<br />\nئێمە لەبارەی پێشکەشکردنەکەت {$contextName}, &quot;{$submissionTitle}&quot; بڕیارمان دا.<br />\n<br />\nبڕیار: توێژینەوەکە قبوڵ کرا', 'ئەم ئیمەیڵە لە لایەن سەرنوسەر یان سەرنوسەری بەشەوەیە بۆ ئاگادارکردنەوەیان لە بڕیاری ''''قبوڵکردنی توێژینەوەکە''''.'),
('EDITOR_DECISION_ACCEPT', 'mk_MK', 'Одлука на уредникот', '{$authorName}:<br />\n<br />\nДонесовме одлука во однос на вашиот поднесок до {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nНашата одлука е: Прифати го поднесокот', 'Овој и-меил од Главен или Секциски уредник до Автор ги известува за конечната одлука „прифати поднесок“ за нивиот поднесок.'),
('EDITOR_DECISION_ACCEPT', 'nb_NO', 'Redaktørens beslutning', '{$authorName}:<br />\n<br />\nVi har tatt en beslutning angående innleveringen din, «{$submissionTitle}», som du sendte inn til {$contextName}. <br />\n<br />\nVår beslutning er å: Akseptere manuskriptet', 'Denne e-posten fra redaktør eller seksjonsredaktør til en forfatter, informerer om at manuskriptet ble akseptert.'),
('EDITOR_DECISION_ACCEPT', 'nl_NL', 'Redacteursbeslissing', '{$authorName}:<br />\n<br />\nWe hebben een beslissing genomen over uw inzending voor {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOnze beslissing is: Accepteer inzending', 'Deze e-mail van de redacteur of sectieredacteur brengt een auteur ervan op de hoogte dat een inzending wordt aanvaard.'),
('EDITOR_DECISION_ACCEPT', 'pl_PL', 'Decyzja redakcji', 'Szanowna Pani/ Szanowny Panie,<br />\n<br />\npodjęliśmy decyzję w sprawie tekstu &quot;{$submissionTitle}&quot;, zgłoszonego do czasopisma "{$contextName}".<br />\n<br />\nDecyzja redakcji: Akceptacja zgłoszonego tekstu', 'Ta wiadomość jest wysyłana od redaktora lub redaktora działu do autora. Zawiera powiadomienie o decyzji w sprawie zgłoszonego tekstu.'),
('EDITOR_DECISION_ACCEPT', 'pt_BR', 'Decisão editorial', '{$authorName}:<br />\n<br />\nNós chegamos a uma decisão referente a sua submissão para o periódico {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNossa decisão é de: Aceitar a Submissão', 'Esta é uma mensagem do Editor/Editor de Seção ao autor para notificá-lo da decisão editorial (final) tomada sobre a submissão.'),
('EDITOR_DECISION_ACCEPT', 'pt_PT', 'Decisão editorial', '{$authorName},<br />\n<br />\nFoi tomada uma decisão sobre o artigo submetido à revista {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nA decisão é: Aceitar Submissão', 'Esta é uma mensagem do Editor/Editor de Secção ao Autor para notificá-lo da decisão editorial final de "aceitar a submissão".'),
('EDITOR_DECISION_ACCEPT', 'ro_RO', 'Decizia Editorului', '{$authorName}:<br />\n<br />\nAm ajuns la o decizie cu privire la manuscrisul înregistrat de dumneavoastră {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nDecizia noastră este: Manuscris Acceptat', 'Acest e-mail este trimis de editor sau de editorul de secțiune, către un autor, pe care îl notifică cu privire la o decizie finală de „acceptare a manuscrisului”.'),
('EDITOR_DECISION_ACCEPT', 'ru_RU', 'Решение редакции', 'Здравствуйте, {$authorName}!<br />\n<br />\nМы приняли решение относительно Вашего материала «{$submissionTitle}», направленного в журнал «{$contextName}».<br />\n<br />\nНаше решение: Принять материал', 'Это письмо редактора или редактора раздела, отправляемое автору, чтобы уведомить его об окончательном решении «Принять материал» относительно присланного материала.'),
('EDITOR_DECISION_ACCEPT', 'sk_SK', 'Rozhodnutie editora', '{$authorName}:<br />\n<br />\nUrobili sme rozhodnutie ohľadom Vášho príspevku do {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNaše rozhodnutie je: prijať príspevok k publikácii', 'Tento e-mail od editora alebo editora sekcie autorovi obsahuje informáciu o konečnom rozhodnutí o prijatí príspevku.'),
('EDITOR_DECISION_ACCEPT', 'sl_SI', 'Uredniška odločitev', '{$authorName}:<br />\n<br />\nSprejeli smo odločitev glede vašega prispevka &quot;{$submissionTitle}&quot; za revijo {$contextName}.<br />\n<br />\nNaša odločitev je: Prispevek sprejet', 'Ta eamil pošlje urednik avtorju s končno odločitvijo, da je prispevek sprejet uza objavo.'),
('EDITOR_DECISION_ACCEPT', 'sv_SE', 'Redaktörsbeslut', '{$authorName}:<br />\n<br />\nVi har fattat ett beslut angående ditt bidrag till {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nVårt beslut är att: Acceptera bidraget', 'Det här e-postmeddelandet från redaktören eller sektionsredaktören till en författare meddelar att beslutet "Acceptera bidrag" fattats för hens bidrag.'),
('EDITOR_DECISION_ACCEPT', 'tr_TR', 'Editör Kararı', 'Sayın {$authorName},<br />\n<br />\n{$contextName} için gönderdiğiniz gönderdiğiniz &quot;{$submissionTitle}&quot; başlıklı çalışmanıza ilişkin değerlendirme süreci tamamlanmış ve bir karara varılmıştır.<br />\n<br />\nKararımız: Yayın Kabul', 'This email from the Editor or Section Editor to an Author notifies them of a final decision regarding their submission.'),
('EDITOR_DECISION_ACCEPT', 'uk_UA', 'Рішення редактора', 'Шановний|Шановна {$authorName}:<br />\n<br />\nМи прийняли рішення стосовно Вашого подання "{$submissionTitle}" до видання "{$contextName}".<br />\n<br />\nНаше рішення: Прийняти Подання', 'Цим листом редактор або редактор розділу повідомляє автору про прийняття остаточного рішення стосовно його подання.'),
('EDITOR_DECISION_ACCEPT', 'vi_VN', 'Quyết định của Ban biên tập', 'Kính gửi {$authorName},<br />\n<br />\nChúng tôi đã đạt được một quyết định liên quan đến việc bài gửi của bạn  {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nQuyết định của chúng tôi là: Chấp nhận cho đăng', 'Email này từ Biên tập viên hoặc Biên tập viên chuyên mục cho Tác giả thông báo cho họ về quyết định "chấp nhận cho đăng" cuối cùng liên quan đến bài gửi của họ.'),
('EDITOR_DECISION_ACCEPT', 'zh_CN', '编辑决定', '{$authorName}:<br />\n我们对于您在《{$contextName}》提交的〈{$submissionTitle}〉达成一项决定。<br />\n<br />\n我们的决定是：接收该稿件', '这封电子邮件是由编辑或者区段编辑发送给作者，通知他们关于他们稿件的最后决定。'),
('EDITOR_DECISION_DECLINE', 'ar_IQ', 'قرار هيئة التحرير', '{$authorName}:<br />\n<br />\nقد توصلنا إلى قرار بشأن طلبك للنشر في {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nقرارنا هو: الرفض', 'هذه الرسالة يعنونها محرر القسم إلى طالب النشر يعلمه فيها بالقرار النهائي لهيئة التحرير بشأن طلبه، ملخصه (رفض الطلب).'),
('EDITOR_DECISION_DECLINE', 'ca_ES', 'Decisió de l''editor/a', '{$authorName}:<br />\n<br />\nHem arribat a una decisió respecte a la vostra tramesa per a {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa nostra decisió és: Rebutjar la tramesa', 'Aquest correu electrònic de l''editor/a o de l''editor/a de secció s''adreça a un autor/a per notificar-li que s''ha pres la decisió final de rebutjar la seva tramesa.'),
('EDITOR_DECISION_DECLINE', 'cs_CZ', 'Rozhodnutí editora', '{$authorName}:<br />\n<br />\nUčinili jsme rozhodnutí ohledně Vašeho příspěvku do {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNaše rozhodnutí je: odmítnout příspěvek', 'Tento e-mail od editora nebo editora sekce informuje autora o konečném rozhodnutí o odmítnutí jeho příspěvku.'),
('EDITOR_DECISION_DECLINE', 'da_DK', 'Redaktørbeslutning', '{$authorName}:<br />\n<br />\nVi er nået frem til en afgørelse vedrørende dit bidrag til {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nVi har besluttet at: Afvise manuskript', 'Denne e-mail fra redaktøren eller sektionsredaktøren til en forfatter er en meddelelse om den endelige afgørelse vedrørende deres bidrag.'),
('EDITOR_DECISION_DECLINE', 'de_DE', 'Entscheidung der Redaktion', '{$authorName},<br />\n<br />\nwir sind zu einer Entscheidung in Bezug auf Ihre Einreichung für {$contextName}: &quot;{$submissionTitle}&quot; gekommen.<br />\n<br />\nUnsere Entscheidung lautet: Beitrag ablehnen', 'Diese E-Mail von der/dem Redakteur/in oder Rubrikredakteur/in an eine/n Autor/in informiert diese/n über eine getroffene Entscheidung zu ihrer/seiner Einreichung.'),
('EDITOR_DECISION_DECLINE', 'el_GR', 'Απόφαση Επιμελητή', '{$authorName}:<br />\n<br />\nΈχουμε καταλήξει σε μία απόφαση αναφορικά με την υποβολή σας &quot;{$submissionTitle}&quot; στο περιοδικό {$contextName}.<br />\n<br />\nΗ απόφασή μας είναι: Απόρριψη της Υποβολής', 'Το παρόν μήνυμα αποστέλλεται από τον Επιμελητή ή τον Επιμελητή Ενότητας στον Συγγραφέα, ως ενημέρωση για την απόρριψη της υποβολής.'),
('EDITOR_DECISION_DECLINE', 'en_US', 'Editor Decision', '{$authorName}:<br />\n<br />\nWe have reached a decision regarding your submission to {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOur decision is to: Decline Submission', 'This email from the Editor or Section Editor to an Author notifies them of a final "decline" decision regarding their submission.'),
('EDITOR_DECISION_DECLINE', 'es_ES', 'Decisión del editor/a', '{$authorName}:<br />\n<br />\nHemos tomado una decisión sobre su envío en {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNuestra decisión es: Rechazar el envío', 'Este correo electrónico del editor/a o editor/a de sección al autor/a le notifica sobre la decisión final de "rechazar" su envío.'),
('EDITOR_DECISION_DECLINE', 'eu_ES', 'Editorearen erabakia', '{$authorName}:<br />\n<br />\nHartu dugu {$contextName} aldizkarira bidali zenuen &quot;{$submissionTitle}&quot; artikuluari buruzko erabakia.<br />\n<br />\nGure erabakia:', 'Mezu hau Editoreak edo Ataleko editoreak bidaltzen dio Egileari, artikuluari buruz hartu duen erabakia jakinarazteko.'),
('EDITOR_DECISION_DECLINE', 'fa_IR', 'تصمیم دبیر', '{$authorName}:<br />\n<br />\nدر مورد مقاله ارسالی شما (&quot;{$submissionTitle}&quot;) در {$contextName} تصمصم نهایی اتخاذ شده است.<br />\n<br />\nتصمیم نهایی: عدم پذیرش مقاله ارسالی', 'ایمیلی از طرف سردبیر یا دبیر بخش به نویسنده برای اطلاع از عدم پدیرش پذیرش مقاله'),
('EDITOR_DECISION_DECLINE', 'fi_FI', 'Toimittajan päätös', 'Hyvä {$authorName},<br />\n<br />\nOlemme tehneet päätöksen julkaisuun {$contextName} lähettämäänne käsikirjoitusta &quot;{$submissionTitle}&quot; koskien.<br />\n<br />\nPäätöksemme on: Käsikirjoitus on hylätty', 'This email from the Editor or Section Editor to an Author notifies them of a final "decline" decision regarding their submission.'),
('EDITOR_DECISION_DECLINE', 'fr_CA', 'Décision du rédacteur', '{$authorName}:<br />\n<br />\nNous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$contextName}.<br />\n<br />\nNotre décision est de refuser votre soumission.', 'Ce courriel du,de la rédacteur-trice ou du,de la rédacteur-trice de rubrique à un-e auteur-e le,la notifie de la décision concernant sa soumission, soit de refuser la soumission.'),
('EDITOR_DECISION_DECLINE', 'fr_FR', 'Décision du rédacteur', '{$authorName},<br />\n<br />\nNous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$contextName}.<br />\n<br />\nNotre décision est de refuser votre soumission.', 'Cet courriel du rédacteur ou du chef de rubrique à un auteur les notifie d''une décision finale de «soumission refusée» concernant leur soumission.'),
('EDITOR_DECISION_DECLINE', 'gd_GB', 'Co-dhùnadh deasaiche', '{$authorName}:<br />\n<br />\nThàinig sinn gu co-dhùnadh a thaobh an tagraidh agad gu {$contextName}, “{$submissionTitle}”.<br />\n<br />\nCho-dhùin sinn an tagradh a dhiùltadh', 'Tha am post-d seo on deasaiche no o dheasaiche na h-earrainn gu ùghdar a’ leigeil fios thuca gum b’ e a dhiùltadh an co-dhùnadh deireannach mun tagradh aca.'),
('EDITOR_DECISION_DECLINE', 'hi_IN', 'संपादक का निर्णय', '{$authorName}:<br />\n<br />\nआपके द्वारा सबमिट किए जाने के संबंध में हम एक निर्णय पर पहुंच गए हैं {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nहमारा निर्णय है: सबमिशन को अस्वीकार करना', 'एक लेखक के संपादक या अनुभाग संपादक का यह ईमेल उन्हें उनके जमा करने के बारे में अंतिम "गिरावट" निर्णय के बारे में सूचित करता है.'),
('EDITOR_DECISION_DECLINE', 'hu_HU', 'Szerkesztői döntés', 'Tisztelt {$authorName}!<br />\n<br />\nÉrtesítjük, hogy a(z) {$contextName} folyóirathoz beküldött &quot;{$submissionTitle}&quot; című kézirata elutasításra került.<br />\n<br /> \nÜdvözlettel,<br />\n{$editorialContactSignature}<br />', 'Ez az email a Szerkesztőtől vagy a Rovatszerkesztőtől érkezik a Szerzőnek, hogy a cikkével kapcsolatos döntés az "Elutasítás".'),
('EDITOR_DECISION_DECLINE', 'id_ID', 'Keputusan Editor', '{$authorName}:<br />\n<br />\nKami telah membuat keputusan terkait naskah yang Anda kirimkan ke {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nKeputusan kami adalah: Naskah Ditolak', 'Email ini dari Editor atau Editor Bagian kepada Penulis memberitahukan keputusan final "Naskah Ditolak".'),
('EDITOR_DECISION_DECLINE', 'it_IT', 'Decisione dell''editor', '{$authorName}:<br />\n<br />\nAbbiamo raggiunto una decisione riguardo alla Sua submission a {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa decisione è di non accettare la proposta', 'Questa mail è inviata dall''editor o dall''editor di sezione all''autore per non accettare una proposta.'),
('EDITOR_DECISION_DECLINE', 'ja_JP', '編集者の判断', '{$authorName}様:<br />\n<br />\n下記の投稿について結論に達しましたので、連絡いたします。\n『{$contextName}』「{$submissionTitle}」<br />\n<br />\n結果は: 不採用', '編集者またはセクションエディターから著者へのこのメールは、投稿に関する最終的な「不採用」の決定を著者に通知するものです。'),
('EDITOR_DECISION_DECLINE', 'ku_IQ', 'بڕیاری سەرنوسەر', '{$authorName}:<br />\n<br />\nئێمە لەبارەی پێشکەشکردنەکەت {$contextName}, &quot;{$submissionTitle}&quot; بڕیارمان دا.<br />\n<br />\nبڕیار: توێژینەوەکە ڕەت کرایەوە', 'ئەم ئیمەیڵە لە لایەن سەرنوسەر یان سەرنوسەری بەشەوەیە بۆ ئاگادارکردنەوەیان لە بڕیاری ئەوەی کە ''''توێژینەوەکە ڕەت کرایەوە''''.'),
('EDITOR_DECISION_DECLINE', 'mk_MK', 'Одлука на уредникот', '{$authorName}:<br />\n<br />\nДонесовме одлука во врска со вашиот поднесок до {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nНашата одлука е: Одбиен поднесок', 'Овој и-меил од Главен или Секциски уредник до Автор ги известува за конечната одлука „одбиено“ во однос на нивниот поднесок.'),
('EDITOR_DECISION_DECLINE', 'nb_NO', 'Redaktørens beslutning', '{$authorName}:<br />\n<br />\nVi har tatt en beslutning angående innleveringen din, «{$submissionTitle}», som du sendte inn til {$contextName}. <br />\n<br />\nVår beslutning er: Manuskriptet avvises', 'Denne e-posten fra redaktør eller seksjonsredaktør til en forfatter, informerer om at innleveringen ble avvist.'),
('EDITOR_DECISION_DECLINE', 'nl_NL', 'Redacteursbeslissing', '{$authorName}:<br />\n<br />\nWe hebben een beslissing genomen over uw inzending voor {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOnze beslissing is: Weiger inzending', 'Deze e-mail van de redacteur of sectieredacteur brengt een auteur ervan op de hoogte dat een inzending wordt geweigerd.'),
('EDITOR_DECISION_DECLINE', 'pl_PL', 'Decyzja redakcji', 'Szanowna Pani/ Szanowny Panie,<br />\n<br />\npodjęliśmy decyzję w sprawie tekstu "{$submissionTitle}", zgłoszonego do czasopisma "{$contextName}".<br />\n<br />\nDecyzja redakcji: Odrzucenie zgłoszonego tekstu', 'Ta wiadomość jest wysyłana od redaktora lub redaktora działu do autora. Zawiera powiadomienie o odrzuceniu zgłoszonego tekstu.'),
('EDITOR_DECISION_DECLINE', 'pt_BR', 'Decisão editorial', '{$authorName}:<br />\n<br />\nNós chegamos a uma decisão referente a sua submissão para o periódico {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNossa decisão é de: Rejeitar a Submissão', 'Esta mensagem do Editor/Editor de Seção ao autor notifica sobre a decisão final tomada sobre a submissão.'),
('EDITOR_DECISION_DECLINE', 'pt_PT', 'Decisão editorial', '{$authorName}:<br />\n<br />\nFoi tomada uma decisão sobre o artigo submetido à revista {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nA decisão é: Rejeitar', 'Este e-mail enviado pelo Editor/Editor de Secção ao Autor notifica sobre a decisão final da submissão de rejeitar.'),
('EDITOR_DECISION_DECLINE', 'ro_RO', 'Decizia Editorului', '{$authorName}:<br />\n<br />\nAm ajuns la o decizie privind manuscrisul înregistrat de dumneavoastră {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nDecizia noastră este: Manuscrisul nu este acceptat', 'Acest e-mail este trimis de editor sau de editorul de secțiune, către un autor, pe care îl notifică cu privire la o decizie finală de „respingerea manuscrisului”.'),
('EDITOR_DECISION_DECLINE', 'ru_RU', 'Решение редакции', 'Здравствуйте, {$authorName}!<br />\n<br />\nМы приняли решение относительно Вашего материала «{$submissionTitle}», направленного в журнал «{$contextName}».<br />\n<br />\nНаше решение: Отклонить материал', 'Это письмо редактора или редактора раздела, отправляемое автору, чтобы уведомить его об окончательном решении «Отклонить материал» относительно присланного материала.'),
('EDITOR_DECISION_DECLINE', 'sk_SK', 'Rozhodnutie editora', '{$authorName}:<br />\n<br />\nUrobili sme rozhodnutie ohľadom Vášho príspevku do {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNaše rozhodnutie je: odmietnuť príspevok', 'Tento e-mail od editora alebo editora sekcie informuje autora o konečnom rozhodnutí o odmietnutí jeho príspevku.'),
('EDITOR_DECISION_DECLINE', 'sl_SI', 'Uredniška odločitev', '{$authorName}:<br />\n<br />\nSprejeli smo odločitev glede vašega prispevka &quot;{$submissionTitle}&quot; za revijo {$contextName}.<br />\n<br />\nNaša odločitev je: Prispevek se zavrne', 'Ta email pošlje urednik avtorju z obvestilom, da je objava prispevka zavrnjena.'),
('EDITOR_DECISION_DECLINE', 'sv_SE', 'Redaktörsbeslut', '{$authorName}:<br />\n<br />\nVi har fattat ett beslut angående ditt bidrag till {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nVårt beslut är att: Refusera bidrag', 'Det här e-postmeddelandet från redaktören eller sektionsredaktören till en författare meddelar att beslutet "Refusera bidrag" fattats för hens bidrag.'),
('EDITOR_DECISION_DECLINE', 'tr_TR', 'Editör Kararı', 'Sayın {$authorName},<br />\n<br />\n{$contextName} için gönderdiğiniz &quot;{$submissionTitle}&quot; başlıklı çalışmanız ile ilgili bir karara varılmıştır.<br />\n<br />\nKararımız: Makale Reddedildi', 'This email from the Editor or Section Editor to an Author notifies them of a final decision regarding their submission.'),
('EDITOR_DECISION_DECLINE', 'uk_UA', 'Рішення редактора', 'Шановний|Шановна {$authorName}:<br />\n<br />\nМи прийняли рішення стосовно Вашого подання "{$submissionTitle}" до видання "{$contextName}".<br />\n<br />\nНаше рішення: Відмовити у поданні', 'Цим листом редактор або редактор розділу повідомляє автору про прийняття остаточного рішення стосовно його подання.'),
('EDITOR_DECISION_DECLINE', 'vi_VN', 'Quyết định của Ban biên tập', 'Kính gửi {$authorName},<br />\n<br />\nChúng tôi đã đạt được một quyết định liên quan đến việc bài gửi của bạn {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nQuyết định của chúng tôi là: Từ chối', 'Email này từ Biên tập viên hoặc Biên tập viên chuyên mục cho Tác giả thông báo cho họ về quyết định "từ chối" cuối cùng liên quan đến bài gửi của họ.'),
('EDITOR_DECISION_DECLINE', 'zh_CN', '编辑决定', '{$authorName}:<br />\n<br />\n我们对于您在《{$contextName}》提交的〈{$submissionTitle}〉达成一项决定。<br />\n<br />\n我们的决定是：', '这封电子邮件是由编辑或者区段编辑发送给作者，通知他们关于他们稿件的最后决定。'),
('EDITOR_DECISION_INITIAL_DECLINE', 'ar_IQ', 'قرار المحرر', '\n			{$authorName}:<br />\n<br />\nلقد توصلنا إلى قرار بشأن طلبك للنشر في {$contextName}، &quot;{$submissionTitle}&quot;.<br />\n<br />\nإن قرارنا هو: رفض النشر', 'هذه الرسالة تعنون إلى المؤلف إذا رفض المحرر طلبه بشكل مبدئي قبل الدخول في مرحلة التحكيم'),
('EDITOR_DECISION_INITIAL_DECLINE', 'ca_ES', 'Decisió de l''editor/a', '\n			{$authorName}:<br />\n<br />\nHem arribat a una decisió respecte a la vostra tramesa per a {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa nostra decisió és: Rebutjar la tramesa', 'Aquest correu electrònic s''envia a l''autor/a si l''editor/a rebutja la tramesa inicialment, abans de la fase de revisió'),
('EDITOR_DECISION_INITIAL_DECLINE', 'cs_CZ', 'Rozhodnutí redaktora', '\n			{$authorName}:<br />\n<br />\nDosáhli jsme rozhodnutí ohledně vašeho příspěvku pro {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNaše rozhodnutí je: Odmítnout příspěvek', 'Tento e-mail se pošle autorovi, pokud redaktor odmítne příspěvek již před recenzním řízením'),
('EDITOR_DECISION_INITIAL_DECLINE', 'da_DK', 'Redaktørbeslutning', '\n			{$authorName}:<br />\n<br />\nVi er nået frem til en afgørelse vedrørende dit bidrag til {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nVi har besluttet at: Afvise manuskriptet', 'Denne e-mail sendes til forfatteren, hvis redaktøren afviser manuskriptet i indledningsfasen, før bedømmelsestrinnet'),
('EDITOR_DECISION_INITIAL_DECLINE', 'de_DE', 'Entscheidung der Redaktion', '\n			{$authorName}:<br />\n<br />\nWir sind zu einer Entscheidung hinsichtlich Ihrer Einreichung für {$contextName}, &quot;{$submissionTitle}&quot; gekommen.<br />\n<br />\nWir haben entschieden, Ihre Einreichung abzulehnen.', 'Diese E-Mail wird an die/den Autor/in gesendet, wenn die/der Redakteur/in die Einreichung bereits vor dem Begutachtungsprozess ablehnt.'),
('EDITOR_DECISION_INITIAL_DECLINE', 'el_GR', 'Απόφαση Επιμελητή', '\n			{$authorName}:<br />\n<br />\nΈχουμε λάβει μία απόφαση σχετικά με την υποβολή σας &quot;{$submissionTitle}&quot; στο περιοδικό {$contextName}.<br />\n<br />\nΗ απόφασή μας είναι: Απόρριψη υποβολής', 'Το παρόν μήνυμα αποστέλλεται στον Συγγραφέα, σε περίπτωση που ο Επιμελητής απορρίψει την υποβολή αρχικά, πριν το στάδιο της αξιολόγησης.'),
('EDITOR_DECISION_INITIAL_DECLINE', 'en_US', 'Editor Decision', '\n			{$authorName}:<br />\n<br />\nWe have reached a decision regarding your submission to {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOur decision is to: Decline Submission', 'This email is sent to the author if the editor declines their submission initially, before the review stage'),
('EDITOR_DECISION_INITIAL_DECLINE', 'es_ES', 'Decisión del editor/a', '\n			{$authorName}:<br />\n<br />\nHemos llegado a una decisión sobre su envío a {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNuestra decisión es: Rechazar el envío', 'Este correo electrónico se envía al autor/a si el editor/a rechaza su envío inicialmente, antes de la fase de revisión'),
('EDITOR_DECISION_INITIAL_DECLINE', 'fa_IR', 'تصمیم دبیر', '{$authorName}:<br />\n<br />\nدر مورد مقاله ارسالی شما (&quot;{$submissionTitle}&quot;) در {$contextName} تصمصم نهایی اتخاذ شده است.<br />\n<br />\nتصمیم نهایی: عدم پذیرش', 'این پیام زمان یارسال می شود که دبیر مقاله ارسالی را در اغاز رد می کند، بدون انکه وارد مرحله داوری شود'),
('EDITOR_DECISION_INITIAL_DECLINE', 'fi_FI', 'Toimittajan päätös', '\n			Hyvä {$authorName},<br />\n<br />\nOlemme tehneet päätöksen julkaisuun {$contextName} lähettämäänne käsikirjoitusta &quot;{$submissionTitle}&quot; koskien.<br />\n<br />\nPäätöksemme on: Käsikirjoitus on hylätty', 'This email is sent to the author if the editor declines their submission initially, before the review stage'),
('EDITOR_DECISION_INITIAL_DECLINE', 'fr_CA', 'Décision du rédacteur', '\n			{$authorName},<br />\n<br />\nNous avons pris une décision concernant votre soumission « {$submissionTitle} » à  la revue {$contextName}.<br />\n<br />\nNotre décision est de refuser votre soumission.', 'Cet courriel est envoyé à l''auteur-e si la soumission est refusée avant même l''étape d''évaluation'),
('EDITOR_DECISION_INITIAL_DECLINE', 'fr_FR', 'Décision éditoriale', '\n			{$authorName},<br />\n<br />\nNous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$contextName}.<br />\n<br />\nNotre décision est de refuser votre soumission', 'Ce mail est envoyé à l''auteur si le rédacteur refuse la soumission avant même de la faire évaluer'),
('EDITOR_DECISION_INITIAL_DECLINE', 'gd_GB', 'Co-dhùnadh deasaiche', '\n			{$authorName}:<br />\n<br />\nThàinig sinn gu co-dhùnadh a thaobh an tagraidh agad gu {$contextName}, “{$submissionTitle}”.<br />\n<br />\nCho-dhùin sinn an tagradh a dhiùltadh', 'Thèid am post-d seo a chur chun an ùghdair ma dhiùltas an deasaiche an tagradh aca sa chiad dol a-mach, ro ìre an lèirmheis'),
('EDITOR_DECISION_INITIAL_DECLINE', 'hi_IN', 'संपादक का निर्णय', '\n			{$authorName}:<br />\n<br />\n', 'यह ईमेल लेखक को भेजा जाता है अगर संपादक समीक्षा के चरण से पहले शुरू में अपने प्रस्तुतिकरण को कम कर देता है'),
('EDITOR_DECISION_INITIAL_DECLINE', 'hu_HU', 'Szerkesztői döntés', '\n			Tisztelt {$authorName}!<br />\n<br />\nÉrtesítjük, hogy a(z) {$contextName} folyóirathoz beküldött &quot;{$submissionTitle}&quot; című kézirata elutasításra került.<br />\n<br /> \nÜdvözlettel,<br />\n{$editorialContactSignature}<br />', 'Ez az e-mail a Szerzőnek lesz küldve akkor, amikor a Szerkesztő egyből visszautasítja a benyújtott kéziratot, még a lektorálási szakasz előtt.'),
('EDITOR_DECISION_INITIAL_DECLINE', 'id_ID', 'Keputusan Penyunting', '\n			{$authorName}:<br />\n<br />\nKami telah sampai pada keputusan mengenai naskah Anda {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nKeputusannya adalah: Menolak Naskah', 'Email ini dikirim kepada penulis jika naskah mereka ditolak oleh editor lebih awal, sebelum masuk ke tahap review'),
('EDITOR_DECISION_INITIAL_DECLINE', 'it_IT', 'Decisione dell''editor', '\n			Gentilissimo {$authorName}:<br />\n<br />\nAbbiamo preso una decisione in merito al suo manoscritto dal titolo &quot;{$submissionTitle}&quot; inviato a {$contextName} .<br />\n<br />\nCi rincresce informarla che non ci è possibile accettare il suo contributo', 'Questa mail viene mandata all''autore se la proposta subito non viene accettata dall''editor'),
('EDITOR_DECISION_INITIAL_DECLINE', 'ja_JP', '編集者の判断', '\n			{$authorName}様:<br />\n<br />\n下記の投稿について結論に達しましたので、連絡いたします。\n『{$contextName}』「{$submissionTitle}」<br />\n<br />\n結果は: 不採用', 'このメールは、査読段階に入る前に編集者が最初から投稿を断った場合、著者に送信されます。'),
('EDITOR_DECISION_INITIAL_DECLINE', 'ku_IQ', 'بڕیاری سەرنوسەر', '\n			{$authorName}:<br />\n<br />\nئێمە لەبارەی پێشکەشکردنەکەت {$contextName}, &quot;{$submissionTitle}&quot; بڕیارمان دا.<br />\n<br />\nبڕیار: توێژینەوەکە ڕەت کرایەوە', 'ئەم ئیمەیڵە بۆ توێژەر دەچێت کاتێک سەرنوسەر توێژینەوەکە پێش ناردنی بۆ هەڵسەنگێنەر ڕەت دەکاتەوە'),
('EDITOR_DECISION_INITIAL_DECLINE', 'mk_MK', 'Одлука на уредникот', '\n			{$authorName}:<br />\n<br />\nДонесовме одлука во однос на вашиот поднесок до {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nНашата одлука е: Одбиј го поднесок', 'Овој и-меил е испратен до авторот доколку уредникот го одбие нивниот поднесок на почетокот, пред да биде испратен на рецензија'),
('EDITOR_DECISION_INITIAL_DECLINE', 'nb_NO', 'Redaktørens beslutning', '\n			{$authorName}:<br />\n<br />\nVi har tatt en beslutning angående innleveringen din, «{$submissionTitle}», som du sendte inn til {$contextName}.<br />\n<br />\nVår beslutning er: Manuskriptet avvises', 'Denne e-posten sendes til forfatteren dersom redaktøren avviser innleveringen ved første lesing (før fagfellevurdering)'),
('EDITOR_DECISION_INITIAL_DECLINE', 'nl_NL', 'Redacteursbeslissing', '\n			{$authorName}:<br />\n<br />\nWe hebben een beslissing genomen over uw inzending voor {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOnze beslissing is: Weiger inzending', 'Deze e-mail wordt aan een auteur verzonden wanneer de redacteur de inzending weigert nog voor die aan een reviewer werd bezorgd'),
('EDITOR_DECISION_INITIAL_DECLINE', 'pl_PL', 'Decyzja redakcji', '\n			Szanowna Pani/ Szanowny Panie,<br />\n<br />\npodjęliśmy decyzję w sprawie tekstu  &quot;{$submissionTitle}&quot;, zgłoszonego do czasopisma "{$contextName}".<br />\n<br />\nDecyzja redakcji: Odrzucenie zgłoszonego tekstu', 'Ta wiadomość jest wysyłana od redaktora lub redaktora działu do autora. Zawiera powiadomienie o odrzuceniu zgłoszonego tekstu po ocenie wstępnej (przed procesem recenzji)'),
('EDITOR_DECISION_INITIAL_DECLINE', 'pt_BR', 'Decisão do Editor', '\n			{$authorName}: <br />\n<br />\nChegamos a uma decisão sobre sua submissão para {$ contextName}, &quot;{$submissionTitle}&quot;. <br />\n<br />\nNossa decisão é: Recusar Submissão', 'Este email será enviado ao autor se o editor recusar o envio inicialmente, antes da fase de revisão'),
('EDITOR_DECISION_INITIAL_DECLINE', 'pt_PT', 'Decisão Editorial', '\n			{$authorName}:<br />\n<br />\nEm relação à sua submissão à revista {$contextName}, &quot;{$submissionTitle}&quot; foi tomada uma decisão.<br />\n<br />\nA decisão é: Rejeitar a Submissão', 'Este e-mail é enviado ao autor se o editor decidir rejeitar a submissão numa fase inicial, antes do processo de revisão'),
('EDITOR_DECISION_INITIAL_DECLINE', 'ro_RO', 'Decizia editorului', '\n			{$authorName}:<br />\n<br />\nAm ajuns la o decizie privind manuscrisul înregistrat de dumneavoastră {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nDecizia noastră este: Manuscrisul nu este acceptat', 'Acest e-mail este trimis autorului în cazul în care editorul refuză manuscrisul inițial, înainte de etapa de revizuire'),
('EDITOR_DECISION_INITIAL_DECLINE', 'ru_RU', 'Решение редакции', '\n			Здравствуйте, {$authorName}!<br />\n<br />\nМы приняли решение относительно Вашего материала «{$submissionTitle}», направленного в журнал «{$contextName}».<br />\n<br />\nНаше решение: Отклонить материал', 'Это письмо отправляется автору, если редактор решает отклонить его материал на начальной стадии, до этапа рецензирования'),
('EDITOR_DECISION_INITIAL_DECLINE', 'sk_SK', 'Rozhodnutie redaktora', '\n			{$authorName}:<br />\n<br />\nDosiahli sme rozhodnutie ohľadom vášho príspevku pre {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNaše rozhodnutie je: Odmietnuť príspevok', 'Tento e-mail sa pošle autorovi, ak redaktor odmietne príspevok už pred recenzným riadením'),
('EDITOR_DECISION_INITIAL_DECLINE', 'sl_SI', 'Uredniška odločitev', '\n			{$authorName}:<br />\n<br />\nV uredništvu revije {$contextName} smo sprejeli odločitev glede vašega prispevka &quot;{$submissionTitle}&quot;.<br />\n<br />\nNaša odločitev je: Prispevek se zavrne', 'Email se pošlje avtorju, če se urednik odloči zavrniti prispevek še pred postopkom recenzije'),
('EDITOR_DECISION_INITIAL_DECLINE', 'sv_SE', 'Redaktörsbeslut', '\n			{$authorName}:<br />\n<br />\nVi har fattat ett beslut angående ditt bidrag till {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nVårt beslut är att: Refusera bidrag', 'Det här e-postmeddelandet skickas till författaren om redaktören refuserar bidraget direkt, innan granskningssteget'),
('EDITOR_DECISION_INITIAL_DECLINE', 'tr_TR', 'Editör Kararı', '\n			Sayın {$authorName},<br />\n<br />\n{$contextName} için gönderdiğiniz &quot;{$submissionTitle}&quot; başlıklı makaleniz ile ilgili bir karara varılmıştır.<br />\n<br />\nKararımız: Makale Reddedildi', 'Bu e-posta, editör bir makaleyi ön değerlendirme aşamasında hakem değerlendirme aşamasından önce reddettiğinde makalenin yazarına gönderilir.'),
('EDITOR_DECISION_INITIAL_DECLINE', 'vi_VN', 'Quyết định của ban biên tập', '\n			Kính gửi {$authorName},<br />\n<br />\nChúng tôi đã đạt được một quyết định liên quan đến bài gửi của bạn {$contextName}, &quot;{$submissionTitle}&quot;.<br />		\n<br />\nQuyết định của chúng tôi là: Từ chối', 'Email này được gửi cho tác giả nếu biên tập viên từ chối gửi ban đầu, trước giai đoạn xem xét'),
('EDITOR_DECISION_INITIAL_DECLINE', 'zh_CN', '总编决定', '\n			{$authorName}:<br />\n<br />\n我们对于稿件 {$contextName}, &quot;{$submissionTitle}&quot; 形成了一个最终共识。<br />\n<br />\n我们的决定是：拒绝稿件', '此邮件为编辑初审后拒绝稿件发给投稿人的提醒邮件'),
('EDITOR_DECISION_RESUBMIT', 'ar_IQ', 'قرار هيئة التحرير', '{$authorName}:<br />\n<br />\nقد توصلنا إلى قرار بشأن طلبك للنشر في {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nقرارنا هو: إعادة التقديم مجدداً', 'هذه الرسالة يعنونها محرر القسم إلى طالب النشر يعلمه فيها بالقرار النهائي لهيئة التحرير بشأن طلبه، ملخصه (إعادة تقديم طلب النشر).'),
('EDITOR_DECISION_RESUBMIT', 'ca_ES', 'Decisió de l''editor/a', '{$authorName}:<br />\n<br />\nHem arribat a una decisió respecte a la vostra tramesa pera a {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa nostra decisió és: Tornar a enviar a revisió', 'Aquest correu electrònic de l''editor/a o de l''editor/a de secció s''adreça a un autor/a per notificar-li que s''ha pres la decisió final de tornar a enviar a revisió la seva tramesa.'),
('EDITOR_DECISION_RESUBMIT', 'cs_CZ', 'Rozhodnutí editora', '{$authorName}:<br />\n<br />\nUčinili jsme rozhodnutí ohledně Vašeho příspěvku do {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNaše rozhodnutí je: znovu odeslat k recenzi', 'Tento e-mail od editora nebo editora sekce upozorňuje autora na konečné rozhodnutí „opětovné podání“.'),
('EDITOR_DECISION_RESUBMIT', 'da_DK', 'Redaktørbeslutning', '{$authorName}:<br />\n<br />\nVi er nået frem til en afgørelse vedrørende dit bidrag til {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nVi har besluttet følgende: Fremsend igen til bedømmelse', 'Denne e-mail fra redaktøren eller sektionsredaktøren til en forfatter er en meddelelse om den endelige afgørelse vedrørende deres bidrag.'),
('EDITOR_DECISION_RESUBMIT', 'de_DE', 'Entscheidung der Redaktion', '{$authorName},<br />\n<br />\nwir sind zu einer Entscheidung in Bezug auf Ihre Einreichung für {$contextName}: &quot;{$submissionTitle}&quot; gekommen.<br />\n<br />\nWir haben entschieden, dass Ihr Beitrag überarbeitet werden muss und dann erneut zum Begutachtung versendet wird.', 'Diese E-Mail von der/dem Redakteur/in oder Rubrikredakteur/in an eine/n Autor/in informiert diese/n über eine getroffene Entscheidung zu ihrer/seiner Einreichung.'),
('EDITOR_DECISION_RESUBMIT', 'el_GR', 'Απόφαση Επιμελητή', '{$authorName}:<br />\n<br />\nΈχουμε καταλήξει σε μία απόφαση αναφορικά με την υποβολή σας &quot;{$submissionTitle}&quot; στο περιοδικό {$contextName}.<br />\n<br />\nΗ απόφασή μας είναι: Επανυποβολή για αξιολόγηση', 'Το παρόν μήνυμα αποστέλλεται από τον Επιμελητή ή τον Επιμελητή Ενότητας στον Συγγραφέα, ως ενημέρωση ότι απαιτείται επανυποβολή για αξιολόγηση.'),
('EDITOR_DECISION_RESUBMIT', 'en_US', 'Editor Decision', '{$authorName}:<br />\n<br />\nWe have reached a decision regarding your submission to {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOur decision is to: Resubmit for Review', 'This email from the Editor or Section Editor to an Author notifies them of a final "resubmit" decision regarding their submission.'),
('EDITOR_DECISION_RESUBMIT', 'es_ES', 'Decisión del editor/a', '{$authorName}:<br />\n<br />\nHemos tomado una decisión sobre su envío en {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNuestra decisión es: Volver a enviar a revisión', 'Este correo electrónico del editor/a o editor/a de sección al autor/a le notifica sobre la decisión final de volver a revisar su envío.'),
('EDITOR_DECISION_RESUBMIT', 'eu_ES', 'Editorearen erabakia', '{$authorName}:<br />\n<br />\nHartu dugu {$contextName} aldizkarira bidali zenuen &quot;{$submissionTitle}&quot; artikuluari buruzko erabakia.<br />\n<br />\nGure erabakia:', 'Mezu hau Editoreak edo Ataleko editoreak bidaltzen dio Egileari, artikuluari buruz hartu duen erabakia jakinarazteko.'),
('EDITOR_DECISION_RESUBMIT', 'fa_IR', 'تصمیم دبیر', '{$authorName}:<br />\n<br />\nدر مورد مقاله ارسالی شما (&quot;{$submissionTitle}&quot;) در {$contextName} تصمصم نهایی اتخاذ شده است.<br />\n<br />\nتصمیم نهایی: ارسال دوباره برای داوری', 'ایمیلی از طرف سردبیر یا دبیر بخش به نویسنده برای اطلاع از ارسال دوباره مقاله برای داوری'),
('EDITOR_DECISION_RESUBMIT', 'fi_FI', 'Toimittajan päätös', 'Hyvä {$authorName},<br />\n<br />\nOlemme tehneet päätöksen julkaisuun {$contextName} lähettämäänne käsikirjoitusta &quot;{$submissionTitle}&quot; koskien.<br />\n<br />\nPäätöksemme on: Lähetettävä uudelleen arvioitavaksi', 'This email from the Editor or Section Editor to an Author notifies them of a final "resubmit" decision regarding their submission.'),
('EDITOR_DECISION_RESUBMIT', 'fr_CA', 'Décision du rédacteur', '{$authorName},<br />\n<br />\nNous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$contextName}.<br />\n<br />\nNotre décision est de vous demander d''apporter des révisions à votre soumission et de la soumettre à nouveau.', 'Ce courriel du,de la rédacteur-trice ou du,de la rédacteur-trice de rubrique un-e auteur-e le,la notifie de la décision finale concernant sa soumission, soit de demander d''y apporter des révisions et la soumettre à nouveau.'),
('EDITOR_DECISION_RESUBMIT', 'fr_FR', 'Décision du rédacteur', '{$authorName},<br />\n<br />\nNous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$contextName}.<br />\n<br />\nNotre décision est de vous demander d''apporter des révisions à votre soumission et de la soumettre à nouveau.', 'Cet courriel du rédacteur ou du chef de rubrique à un auteur les notifie d''une décision finale de «soumission à redéposer» concernant leur soumission.'),
('EDITOR_DECISION_RESUBMIT', 'gd_GB', 'Co-dhùnadh deasaiche', '{$authorName}:<br />\n<br />\nThàinig sinn gu co-dhùnadh a thaobh an tagraidh agad gu {$contextName}, “{$submissionTitle}”.<br />\n<br />\nCho-dhùin sinn Cuir a chùm lèirmheis às ùr', 'Tha am post-d seo on deasaiche no o dheasaiche na h-earrainn gu ùghdar a’ leigeil fios thuca gum b’ e a ath-thagradh an co-dhùnadh deireannach mun tagradh aca.'),
('EDITOR_DECISION_RESUBMIT', 'hi_IN', 'संपादक का निर्णय', '{$authorName}:<br />\n<br />\nआपके द्वारा सबमिट किए जाने के संबंध में हम एक निर्णय पर पहुंच गए हैं {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nहमारा निर्णय है: समीक्षा के लिए पुन: सबमिट करें', 'लेखक के संपादक या अनुभाग संपादक का यह ईमेल उन्हें उनके जमा करने के बारे में अंतिम "पुनर्निमित" निर्णय के बारे में सूचित करता है.'),
('EDITOR_DECISION_RESUBMIT', 'hu_HU', 'Szerkesztői döntés', 'Tisztelt {$authorName}!<br />\n<br />\nÉrtesítjük, hogy a(z) {$contextName} folyóirathoz beküldött &quot;{$submissionTitle}&quot; című cikkének új változatát szükséges benyújtani szakmai lektorálásra.<br />\n<br /> \nÜdvözlettel,<br />\n{$editorialContactSignature}<br />', 'Ez az email a Szerkesztőtől vagy a Rovatszerkesztőtől érkezik a Szerzőnek, hogy a cikkével kapcsolatos döntés az "Újrabenyújtás".'),
('EDITOR_DECISION_RESUBMIT', 'id_ID', 'Keputusan Editor', '{$authorName}:<br />\n<br />\nKami telah membuat keputusan terkait naskah yang Anda kirimkan ke {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nKeputusan kami adalah: Kirim Ulang untuk Review', 'Email ini dari Editor atau Editor Bagian kepada Penulis memberitahukan bahwa Penulis perlu mengirim ulang naskahnya.'),
('EDITOR_DECISION_RESUBMIT', 'it_IT', 'Decisione dell''editor', '{$authorName}:<br />\n<br />\nAbbiamo raggiunto una decisione riguardo alla Sua submission a {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa decisione è: mandarla di nuovo in revisione', 'Messaggio dell''editor all''autore per informarlo della decisione conclusiva sulla proposta inviata.'),
('EDITOR_DECISION_RESUBMIT', 'ja_JP', '編集者の判断', '{$authorName}様:<br />\n<br />\n下記の投稿について結論に達しましたので、連絡いたします。\n『{$contextName}』「{$submissionTitle}」<br />\n<br />\n結果は: 査読に再投稿', '編集者またはセクションエディターから著者へのこのメールは、投稿に関する最終的な「再投稿」の決定を著者に通知するものです。'),
('EDITOR_DECISION_RESUBMIT', 'ku_IQ', 'بڕیاری سەرنوسەر', '{$authorName}:<br />\n<br />\nئێمە لەبارەی پێشکەشکردنەکەت {$contextName}, &quot;{$submissionTitle}&quot; بڕیارمان دا.<br />\n<br />\nبڕیار: دوبارە توێژینەوەکەت پێشکەش بکەوە بۆ هەڵسەنگاندن', 'ئەم ئیمەیڵە لە لایەن سەرنوسەر یان سەرنوسەری بەشەوەیە بۆ ئاگادارکردنەوەیان لە بڕیاری ئەوەی کە ''''دوبارە توێژینەوەکەت پێشکەش بکەوە بۆ هەڵسەنگاندن''''.');
INSERT INTO `email_templates_default_data` VALUES
('EDITOR_DECISION_RESUBMIT', 'mk_MK', 'Одлука на уредникот', '{$authorName}:<br />\n<br />\nДонесовме одлука во врска со вашиот поднесок до {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nНашата одлука е: Поднеси повторно за рецензија', 'Овој и-меил од Главен или Секциски уредник до Автор ги известува за конечната одлука „повторно поднеси“ во однос на нивниот поднесок.'),
('EDITOR_DECISION_RESUBMIT', 'nb_NO', 'Redaktørens beslutning', '{$authorName}:<br />\n<br />\nVi har tatt en beslutning angående innleveringen din «{$submissionTitle}», som du sendte inn til {$contextName}. <br />\n<br />\nVår beslutning er: Lever inn til ny fagfellevurdering', 'Denne e-posten fra redaktør eller seksjonsredaktør til en forfatter, informerer om at innleveringen må leveres inn til ny fagfellevurdering.'),
('EDITOR_DECISION_RESUBMIT', 'nl_NL', 'Redacteursbeslissing', '{$authorName}:<br />\n<br />\nWe hebben een beslissing genomen over uw inzending voorv{$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOnze beslissing is: Opnieuw indienen voor review', 'Deze e-mail van de redacteur of sectieredacteur brengt een auteur ervan op de hoogte dat een inzending opnieuw moet worden ingediend voor review.'),
('EDITOR_DECISION_RESUBMIT', 'pl_PL', 'Decyzja redakcji', 'Szanowna Pani/ Szanowny Panie,<br />\n<br />\npodjęliśmy decyzję w sprawie tekstu „{$submissionTitle}”, zgłoszonego do czasopisma "{$contextName}".<br />\n<br />\nDecyzja redakcji: Wymagane poprawki i ponowna recenzja', 'Ta wiadomość jest wysyłana od redaktora lub redaktora działu do autora. Zawiera decyzję o "Wymaganych poprawkach i ponownej recenzji" (gruntowne poprawki) zgłoszonego tekstu.'),
('EDITOR_DECISION_RESUBMIT', 'pt_BR', 'Decisão editorial', '{$authorName}:<br />\n<br />\nNós chegamos a uma decisão referente a sua submissão para o periódico {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNossa decisão é de: Ressubmeter para Avaliação', 'Esta mensagem do Editor/Editor de Seção ao autor notifica sobre a decisão editorial final tomada sobre a submissão.'),
('EDITOR_DECISION_RESUBMIT', 'pt_PT', 'Decisão editorial', '{$authorName}:<br />\n<br />\nFoi tomada uma decisão sobre o artigo enviado à revista {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nA decisão é: Submeter Novamente Para Revisão', 'Esta mensagem enviada pelo Editor/Editor de Secção ao Autor notifica sobre a decisão editorial final de Submeter novamente para revisão.'),
('EDITOR_DECISION_RESUBMIT', 'ro_RO', 'Decizia Editorului', '{$authorName}:<br />\n<br />\nAm ajuns la o decizie cu privire la manuscrisul înregistrat de dumneavoastră {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nDecizia noastră este: Reînregistrare pentru revizie', 'Acest e-mail este trimis de editor sau de editorul de secțiune, către un autor, pe care îl notifică cu privire la o decizie finală de „reînregistrare a manuscrisului”.'),
('EDITOR_DECISION_RESUBMIT', 'ru_RU', 'Решение редакции', 'Здравствуйте, {$authorName}!<br />\n<br />\nМы приняли решение относительно Вашего материала «{$submissionTitle}», направленного в журнал «{$contextName}».<br />\n<br />\nНаше решение: Отправить на рецензирование повторно', 'Это письмо редактора или редактора раздела, отправляемое автору, чтобы уведомить его об окончательном решении «Отправить на рецензирование повторно» относительно присланного материала.'),
('EDITOR_DECISION_RESUBMIT', 'sk_SK', 'Rozhodnutie editora', '{$authorName}:<br />\n<br />\nUrobili sme rozhodnutie ohľadom Vášho príspevku do {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNaše rozhodnutie je: znova odoslať k recenzii', 'Tento e-mail od editora alebo editora sekcie upozorňuje autora na konečné rozhodnutie "opätovné podanie".'),
('EDITOR_DECISION_RESUBMIT', 'sl_SI', 'Uredniška odločitev', '{$authorName}:<br />\n<br />\nSprejeli smo odločitev glede vašega prispevka &quot;{$submissionTitle}&quot; za revijo {$contextName}.<br />\n<br />\nNaša odločitev je: Potreben je ponoven krog recenzije', 'Ta email pošlje urednik avtorju z obvestilom, da je potrebna ponovna recenzija prispevka.'),
('EDITOR_DECISION_RESUBMIT', 'sv_SE', 'Redaktörsbeslut', '{$authorName}:<br />\n<br />\nVi har fattat ett beslut angående ditt bidrag till {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nVårt beslut är att: Skicka in igen för ny granskning', 'Det här e-postmeddelandet från redaktören eller sektionsredaktören till en författare meddelar att beslutet "Skicka in igen för ny granskning" fattats för hens bidrag.'),
('EDITOR_DECISION_RESUBMIT', 'tr_TR', 'Editör Kararı', 'Sayın {$authorName},<br />\n<br />\n{$contextName} için gönderdiğiniz &quot;{$submissionTitle}&quot; başlıklı çalışmanız ile ilgili bir karara varılmıştır.<br />\n<br />\nKararımız: Hakem Değerlendirmesi İçin Tekrar Gönder', 'Bu e-posta, Editörden veya Bölüm Editörü''nden bir yazara makalesi ile ilgili "değerlendirme için yeniden gönder" şeklindeki nihai kararı bildirmek için gönderilir.'),
('EDITOR_DECISION_RESUBMIT', 'uk_UA', 'Рішення редактора', 'Шановний|Шановна {$authorName}:<br />\n<br />\nМи прийняли рішення стосовно Вашого подання"{$submissionTitle}" до видання "{$contextName}".<br />\n<br />\nНаше рішення: Відправити на повторне рецензування', 'Цим листом редактор або редактор розділу повідомляє автору про прийняття остаточного рішення стосовно його подання.'),
('EDITOR_DECISION_RESUBMIT', 'vi_VN', 'Quyết định của Ban biên tập', 'Kính gửi {$authorName},<br />\n<br />\nChúng tôi đã đạt được một quyết định liên quan đến việc bài gửi của bạn {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nQuyết định của chúng tôi là: Gửi lại để xem xét', 'Email này từ Biên tập viên hoặc Biên tập viên chuyên mục cho Tác giả thông báo cho họ về quyết định "gửi lại" cuối cùng liên quan đến bài gửi của họ.'),
('EDITOR_DECISION_RESUBMIT', 'zh_CN', '编辑决定', '{$authorName}:<br />\n<br />\n我们对于您在《{$contextName}》提交的〈{$submissionTitle}〉达成一项决定。<br />\n<br />\n我们的决定是：', '这封电子邮件是由编辑或者区段编辑发送给作者，通知他们关于他们稿件的最后决定。'),
('EDITOR_DECISION_REVISIONS', 'ar_IQ', 'قرار هيئة التحرير', '{$authorName}:<br />\n<br />\nقد توصلنا إلى قرار بشأن طلبك للنشر في {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nقرارنا هو: بعض التنقيحات مطلوبة', 'هذه الرسالة يعنونها محرر القسم إلى طالب النشر يعلمه فيها بالقرار النهائي لهيئة التحرير بأن مؤلفه بحاجة إلى بعض التنقيحات.'),
('EDITOR_DECISION_REVISIONS', 'ca_ES', 'Decisió de l''editor/a', '{$authorName}:<br />\n<br />\nHem arribat a una decisió respecte a la vostra tramesa per a {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa nostra decisió és: Necessita revisions', 'Aquest correu electrònic de l''editor/a o de l''editor/a de secció s''adreça a un autor/a per notificar-li que la decisió final és que la seva tramesa necessita revisions.'),
('EDITOR_DECISION_REVISIONS', 'cs_CZ', 'Rozhodnutí editora', '{$authorName}:<br />\n<br />\nUčinili jsme rozhodnutí ohledně Vašeho příspěvku do {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNaše rozhodnutí je: požadujeme přepracování', 'Tento e-mail od editora nebo editora sekce upozorňuje autora o rozhodnutí „požadujeme recenzi“.'),
('EDITOR_DECISION_REVISIONS', 'da_DK', 'Redaktørbeslutning', '{$authorName}:<br />\n<br />\nVi er nået frem til en afgørelse vedrørende dit bidrag til {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nVi har besluttet følgende: Rettelser er påkrævet', 'Denne e-mail fra redaktøren eller sektionsredaktøren til en forfatter er en meddelelse om den endelige afgørelse vedrørende deres bidrag.'),
('EDITOR_DECISION_REVISIONS', 'de_DE', 'Entscheidung der Redaktion', '{$authorName},<br />\n<br />\nwir sind zu einer Entscheidung in Bezug auf Ihren Beitrag für {$contextName}: &quot;{$submissionTitle}&quot; gekommen.<br />\n<br />\nWir haben entschieden, dass Ihr Beitrag überarbeitet werden muss.', 'Diese E-Mail von der/dem Redakteur/in oder Rubrikredakteur/in an eine/n Autor/in informiert diese/n über eine getroffene Entscheidung zu ihrer/seiner Einreichung.'),
('EDITOR_DECISION_REVISIONS', 'el_GR', 'Απόφαση Επιμελητή', '{$authorName}:<br />\n<br />\nΈχουμε καταλήξει σε μία απόφαση αναφορικά με την υποβολή σας &quot;{$submissionTitle}&quot;, στο περιοδικό {$contextName}.<br />\n<br />\nΗ απόφασή μας είναι: Απαιτούνται αναθεωρήσεις', 'Το παρόν μήνυμα αποστέλλεται από τον Επιμελητή ή τον Επιμελητή Ενότητας στον Συγγραφέα, ως ενημέρωση ότι απαιτούνται αναθεωρήσεις στην υποβολή.'),
('EDITOR_DECISION_REVISIONS', 'en_US', 'Editor Decision', '{$authorName}:<br />\n<br />\nWe have reached a decision regarding your submission to {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOur decision is: Revisions Required', 'This email from the Editor or Section Editor to an Author notifies them of a final "revisions required" decision regarding their submission.'),
('EDITOR_DECISION_REVISIONS', 'es_ES', 'Decisión del editor/a', '{$authorName}:<br />\n<br />\nHemos tomado una decisión sobre su envío en {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNuestra decisión es: Necesita revisiones', 'Este correo electrónico del editor/a o editor/a de sección al autor/a le notifica que la decisión final respecto a su envío es que "necesita revisiones".'),
('EDITOR_DECISION_REVISIONS', 'eu_ES', 'Editorearen erabakia', '{$authorName}:<br />\n<br />\nHartu dugu {$contextName} aldizkarira bidali zenuen &quot;{$submissionTitle}&quot; artikuluari buruzko erabakia.<br />\n<br />\nGure erabakia:', 'Mezu hau Editoreak edo Ataleko editoreak bidaltzen dio Egileari, artikuluari buruz hartu duen erabakia jakinarazteko.'),
('EDITOR_DECISION_REVISIONS', 'fa_IR', 'تصمیم دبیر', '{$authorName}:<br />\n<br />\nدر مورد مقاله ارسالی شما (&quot;{$submissionTitle}&quot;) در {$contextName} تصمصم نهایی اتخاذ شده است.<br />\n<br />\nتصمیم : مقاله ارسالی نیاز به انجام اصلاحات دارد', 'ایمیلی از طرف سردبیر یا دبیر بخش به نویسنده برای اطلاع ازنیازمندی مقاله به اعمال مجموعه ای از اصلاحات'),
('EDITOR_DECISION_REVISIONS', 'fi_FI', 'Toimittajan päätös', 'Hyvä {$authorName},<br />\n<br />\nOlemme tehneet päätöksen julkaisuun {$contextName} lähettämäänne käsikirjoitusta &quot;{$submissionTitle}&quot; koskien.<br />\n<br />\nPäätöksemme on: Vaatii korjauksia', 'This email from the Editor or Section Editor to an Author notifies them of a final "revisions required" decision regarding their submission.'),
('EDITOR_DECISION_REVISIONS', 'fr_CA', 'Décision du rédacteur', '{$authorName},<br />\n<br />\nNous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$contextName}.<br />\n<br />\nNotre décision est de vous demander d''apporter des révisions à votre soumission.', 'Ce courriel du,de la rédacteur-trice ou du,de la rédacteur-trice de rubrique à un-e auteur-e le,la notifie de la décision finale concernant sa soumission, soit de demander d''y apporter des révisions.'),
('EDITOR_DECISION_REVISIONS', 'fr_FR', 'Décision du rédacteur', '{$authorName},<br />\n<br />\nNous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$contextName}.<br />\n<br />\nNotre décision est de vous demander une nouvelle version de votre soumission.', 'Cet courriel du rédacteur ou du chef de rubrique à un auteur les notifie d''une décision finale de «révision requise» concernant leur soumission.'),
('EDITOR_DECISION_REVISIONS', 'gd_GB', 'Co-dhùnadh deasaiche', '{$authorName}:<br />\n<br />\nThàinig sinn gu co-dhùnadh a thaobh an tagraidh agad gu {$contextName}, “{$submissionTitle}”.<br />\n<br />\nCho-dhùin sinn na leanas: Tha feum air ath-dheasachadh', 'Tha am post-d seo on deasaiche no o dheasaiche na h-earrainn gu ùghdar a’ leigeil fios thuca gum b’ e “feum air ath-dheasachadh” an co-dhùnadh deireannach mun tagradh aca.'),
('EDITOR_DECISION_REVISIONS', 'hi_IN', 'संपादक का निर्णय', '{$authorName}:<br />\n<br />\nआपके द्वारा सबमिट किए जाने के संबंध में हम एक निर्णय पर पहुंच गए हैं {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOur decision is: Revisions Required', 'लेखक के संपादक या अनुभाग संपादक का यह ईमेल उन्हें अंतिम रूप देने के बारे में सूचित करता है, जो उनके प्रस्तुतिकरण के संबंध में आवश्यक "संशोधन” है.'),
('EDITOR_DECISION_REVISIONS', 'hu_HU', 'Szerkesztői döntés', 'Tisztelt {$authorName}!<br />\n<br />\nÉrtesítjük, hogy a(z) {$contextName} folyóirathoz beküldött &quot;{$submissionTitle}&quot; című cikkének átdolgozása szükséges.<br />\n<br /> \nÜdvözlettel,<br />\n{$editorialContactSignature}<br />', 'Ez az email a Szerkesztőtől vagy a Rovatszerkesztőtől érkezik a Szerzőnek, hogy a cikkével kapcsolatos döntés az "Átdolgozás szükséges".'),
('EDITOR_DECISION_REVISIONS', 'id_ID', 'Keputusan Editor', '{$authorName}:<br />\n<br />\nKami telah membuat keputusan terkait naskah yang Anda kirimkan ke {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nKeputusan kami adalah: Perlu Revisi', 'Email ini dari Editor atau Editor Bagian kepada Penulis memberitahukan keputusan final "Perlu Revisi".'),
('EDITOR_DECISION_REVISIONS', 'it_IT', 'Decisione dell''editor', '&lt;![CDATA[{$authorName}:<br />\n<br />\nAbbiamo raggiunto una decisione sulla Sua proposta a {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa nostra decisione: è necessaria ciclo di peer-review', 'Questa mail è inviata dall''Editor o dal Section Editor  all''autore quando il manoscritto deve essere revisionato dopo la revisione.'),
('EDITOR_DECISION_REVISIONS', 'ja_JP', '編集者の判断', '{$authorName}様:<br />\n<br />\n下記の投稿について結論に達しましたので、連絡いたします。\n『{$contextName}』「{$submissionTitle}」<br />\n<br />\n結果は: 改訂を要求', '編集者またはセクションエディターから著者へのこのメールは、投稿に関する最終的な「改訂を要求」の決定を著者に通知するものです。'),
('EDITOR_DECISION_REVISIONS', 'ku_IQ', 'بڕیاری سەرنوسەر', '{$authorName}:<br />\n<br />\nئێمە لەبارەی پێشکەشکردنەکەت {$contextName}, &quot;{$submissionTitle}&quot; بڕیارمان دا.<br />\n<br />\nبڕیار: توێژینەوەکە پێویستی بە پێداچونەوە هەیە', 'ئەم ئیمەیڵە لە لایەن سەرنوسەر یان سەرنوسەری بەشەوەیە بۆ ئاگادارکردنەوەیان لە بڕیاری ئەوەی کە ''''توێژینەوەکەیان پێویستی بە پێداچونەوە هەیە''''.'),
('EDITOR_DECISION_REVISIONS', 'mk_MK', 'Одлука на уредникот', '{$authorName}:<br />\n<br />\nДонесовме одлука во врска со вашето поднесување до {$textName}, &quot;{$missionTitle}&quot;.<br />\n<br />\nНашата одлука е: Потребни се ревизии', 'Овој и-меил од Главен или Секциски уредник до Автор ги известува за конечната одлука „потребни се исправки“ во однос на нивниот поднесок.'),
('EDITOR_DECISION_REVISIONS', 'nb_NO', 'Redaktørens beslutning', '{$authorName}:<br />\n<br />\nVi har tatt en beslutning angående innleveringen din, «{$submissionTitle}», som du sendte inn til {$contextName}.<br />\n<br />\nVår beslutning er: Omarbeiding kreves', 'Denne e-posten fra redaktør eller seksjonsredaktør til en forfatter, informerer om at innleveringen må omarbeides.'),
('EDITOR_DECISION_REVISIONS', 'nl_NL', 'Redacteursbeslissing', '{$authorName}:<br />\n<br />\nWe hebben een beslissing genomen over uw inzending voor {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOnze beslissing is: Revisies benodigd', 'Deze e-mail van de redacteur of sectieredacteur brengt een auteur ervan op de hoogte dat bijkomende revisies worden verwacht voor een inzending.'),
('EDITOR_DECISION_REVISIONS', 'pl_PL', 'Decyzja redakcji', 'Szanowna Pani/ Szanowny Panie,<br />\n<br />\npodjęliśmy decyzję w sprawie tekstu "{$submissionTitle}", zgłoszonego do czasopisma "{$contextName}".<br />\n<br />\nDecyzja redakcji: Wymagane poprawki', 'Ta wiadomość jest wysyłana od redaktora lub redaktora działu do autora. Zawiera decyzję o "Wymaganych poprawkach" (drobne poprawki) zgłoszonego tekstu.'),
('EDITOR_DECISION_REVISIONS', 'pt_BR', 'Decisão editorial', '{$authorName}:<br />\n<br />\nNós chegamos a uma decisão referente a sua submissão para o periódico {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNossa decisão é de: Revisões Requeridas', 'Esta mensagem é enviada pelo Editor ou Editor de Seção ao autor, notificando-o da decisão final de "<strong>Revisões Requeridas</strong>" tomada sobre a sua submissão.'),
('EDITOR_DECISION_REVISIONS', 'pt_PT', 'Decisão editorial', '{$authorName}:<br />\n<br />\nFoi tomada uma decisão sobre o artigo submetido à {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nA decisão é: Revisões Requeridas', 'Esta mensagem é enviada pelo do Editor/Editor de Secção ao autor, notificando-o da decisão final de Revisões Requeridas.'),
('EDITOR_DECISION_REVISIONS', 'ro_RO', 'Decizia Editorului', '{$authorName}:<br />\n<br />\nAm ajuns la o decizie cu privire la manuscrisul înregistrat de dumneavoastră {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nDecizia noastră este: Este necesară revizuirea manuscrisului', 'Acest e-mail este trimis de editor sau de editorul de secțiune, către un autor, pe care îl notifică cu privire la o decizie finală de „revizuire a manuscrisului”.'),
('EDITOR_DECISION_REVISIONS', 'ru_RU', 'Решение редакции', 'Здравствуйте, {$authorName}!<br />\n<br />\nМы приняли решение относительно Вашего материала «{$submissionTitle}», направленного в журнал «{$contextName}».<br />\n<br />\nНаше решение: Требуется корректировка', 'Это письмо редактора или редактора раздела, отправляемое автору, чтобы уведомить его об окончательном решении «Требуется корректировка» относительно присланного материала.'),
('EDITOR_DECISION_REVISIONS', 'sk_SK', 'Rozhodnutie editora', '{$authorName}:<br />\n<br />\nUrobili sme rozhodnutie ohľadom Vášho príspevku do {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNaše rozhodnutie je: požadujeme prepracovanie', 'Tento e-mail od editora alebo editora sekcie upozorňuje autora o rozhodnutí "požadujeme recenziu".'),
('EDITOR_DECISION_REVISIONS', 'sl_SI', 'Uredniška odločitev', '{$authorName}:<br />\n<br />\nSprejeli smo odločitev glede vašega prispevka &quot;{$submissionTitle}&quot; za revijo {$contextName}.<br />\n<br />\nNaša odločitev je: Potrebni so popravki', 'Ta email pošlje urednik avtorju z obvestilom, da so potrebne določene spremembe prispevka.'),
('EDITOR_DECISION_REVISIONS', 'sv_SE', 'Redaktörsbeslut', '{$authorName}:<br />\n<br />\nVi har fattat ett beslut angående ditt bidrag till {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nVårt beslut är att: Bearbetning krävs', 'Det här e-postmeddelandet från redaktören eller sektionsredaktören till en författare meddelar att beslutet "Bearbetning krävs" fattats för hens bidrag.'),
('EDITOR_DECISION_REVISIONS', 'tr_TR', 'Editör Kararı', '{$authorName}:<br />\n<br />\n{$contextName} için gönderdiğiniz &quot;{$submissionTitle}&quot; başlıklı çalışmanıza ilişkin değerlendirme süreci sonucu bir karara varılmıştır.<br />\n<br />\nKararımız: Düzeltme Gerekli', 'This email from the Editor or Section Editor to an Author notifies them of a final decision regarding their submission.'),
('EDITOR_DECISION_REVISIONS', 'uk_UA', 'Рішення редактора', 'Шановний|Шановна {$authorName}:<br />\n<br />\nМи прийняли рішення стосовно Вашого подання "{$submissionTitle}" до видання "{$contextName}".<br />\n<br />\nНаше рішення: Необхідні Виправлення', 'Цим листом редактор або редактор розділу повідомляє автору про прийняття остаточного рішення стосовно його подання.'),
('EDITOR_DECISION_REVISIONS', 'vi_VN', 'Quyết định của Ban biên tập', 'Kính gửi {$authorName},<br />\n<br />\nChúng tôi đã đạt được một quyết định liên quan đến việc bài gửi của bạn {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nQuyết định của chúng tôi là: Yêu cầu sửa chữa', 'Email này từ Biên tập viên hoặc Biên tập viên chuyên mục cho Tác giả thông báo cho họ về quyết định "yêu cầu sửa chữa" cuối cùng liên quan đến bài gửi của họ.'),
('EDITOR_DECISION_REVISIONS', 'zh_CN', '编辑决定', '{$authorName}:<br />\n<br />\n我们对于您在《{$contextName}》提交的〈{$submissionTitle}〉达成一项决定。<br />\n<br />\n我们的决定是：', '这封电子邮件是由编辑或者区段编辑发送给作者，通知他们关于他们稿件的最后决定。'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'ar_IQ', 'قرار هيئة التحرير', '{$authorName}:<br />\n<br />\nقد توصلنا إلى قرار بشأن طلبك للنشر في {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nقرارنا هو: إرسال طلبك إلى التحكيم<br />\n<br />\nرابط الطلب: {$submissionUrl}', 'هذه الرسالة يعنونها محرر القسم إلى طالب النشر يعلمه فيها بقرار هيئة التحرير بأن طلبه قد أرسل إلى محكم خارجي.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'ca_ES', 'Decisió de l''editor/a', '{$authorName}:<br />\n<br />\nHem arribat a una decisió respecte a la seva tramesa per a {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa nostra decisió és: Enviar a revisió<br />\n<br />\nURL de la tramesa: {$submissionUrl}', 'Aquest correu electrònic de l''editor/a o de l''editor/a de secció s''adreça a un autor/a per notificar-li que la seva tramesa s''envia a una revisió externa.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'cs_CZ', 'Rozhodnutí editora', 'Vážený(á) {$authorName}:<br />\n<br />\nDosáhli jsme rozhodnutí, které se týká vašeho příspěvku do {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNaše rozhodnutí je: odeslat k recenzi<br />\n<br />\nWebová adresa příspěvku: {$submissionUrl}', 'Tento email od editora nebo editora sekce autorovi sděluje, že jejich příspěvek je odesílán k externí recenzi.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'da_DK', 'Redaktørbeslutning', '{$authorName}:<br />\n<br />\nVi er nået frem til en afgørelse vedrørende dit bidrag til {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nVi har besluttet følgende: Fremsendes til bedømmelse<br />\n<br />\nSubmission URL: {$submissionUrl}', 'Denne e-mail fra redaktøren eller sektionsredaktøren til forfatteren meddeler at indsendelsen videresendes til ekstern bedømmelse.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'de_DE', 'Entscheidung der Redaktion', '{$authorName}:<br />\n<br />\nWir sind zu einer Entscheidung hinsichtlich Ihrer Einreichung für {$contextName}, &quot;{$submissionTitle}&quot; gekommen.<br />\n<br />\nWir haben entschieden, ein Gutachten anzufordern.<br />\n<br />\nURL des Beitrags: {$submissionUrl}', 'Diese E-Mail von Redakteur/in oder Rubrikredakteur/in benachrichtigt die/den Autor/in darüber, dass ein externes Gutachten angefordert wird.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'el_GR', 'Απόφαση Επιμελητή', '{$authorName}:<br />\n<br />\nΈχουμε καταλήξει σε μία απόφαση αναφορικά με την υποβολή σας &quot;{$submissionTitle}&quot;, στο περιοδικό {$contextName}.<br />\n<br />\nΗ απόφασή μας είναι: Αποστολή προς Αξιολόγηση<br />\n<br />\nΣύνδεσμος υποβολής: {$submissionUrl}', 'Το παρόν μήνυμα αποστέλλεται από τον Επιμελητή ή τον Επιμελητή Ενότητας στον Συγγραφέα, ως ενημέρωση ότι η υποβολή προωθείται προς εξωτερική αξιολόγηση.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'en_US', 'Editor Decision', '{$authorName}:<br />\n<br />\nWe have reached a decision regarding your submission to {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOur decision is to: Send to Review<br />\n<br />\nSubmission URL: {$submissionUrl}', 'This email from the Editor or Section Editor to an Author notifies them that their submission is being sent to an external review.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'es_ES', 'Decisión del editor/a', '{$authorName}:<br />\n<br />\nHemos llegado a una decisión respecto a su envío {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNuestra decisión es: Enviar a revisión<br />\n<br />\nEnlace: {$submissionUrl}', 'Este correo electrónico del editor/a, o del editor/a de sección, notifica al autor/a que su envío se traslada a un revisor/a externo.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'fa_IR', 'تصمیم دبیر', '{$authorName}:<br />\n<br />\nدر مورد مقاله ارسالی شما (&quot;{$submissionTitle}&quot;) در {$contextName} تصمصم نهایی اتخاذ شده است.<br />\n<br />\nتصمیم : ارسال به داور خارجی<br />\n<br />\nمشاهده وضعیت مقاله ارسالی: {$submissionUrl}', 'ایمیلی از طرف سردبیر یا دبیر بخش به نویسنده برای اطلاع از ارسال مقاله برای داوری توسط یک داور خارجی'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'fi_FI', 'Toimittajan päätös', 'Hyvä {$authorName},<br />\n<br />\nOlemme tehneet päätöksen julkaisuun {$contextName} lähettämäänne käsikirjoitusta &quot;{$submissionTitle}&quot; koskien.<br />\n<br />\nPäätöksemme on: Lähetetään arvioitavaksi<br />\n<br />\nKäsikirjoituksen URL: {$submissionUrl}', 'This email from the Editor or Section Editor to an Author notifies them that their submission is being sent to an external review.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'fr_CA', 'Décision du rédacteur', '{$authorName},<br />\n<br />\nNous avons pris une décision concernant votre soumission « {$submissionTitle} » à la revue {$contextName}.<br />\n<br />\nNotre décision est d''envoyer votre soumission en évaluation.<br />\n<br />\nURL de la soumission : {$submissionUrl}', 'Ce courriel du,de la rédacteur-trice ou du,de la rédacteur-trice de rubrique à un-e auteur-e le,la notifie de la décision concernant sa soumission, soit d''envoyer sa soumission en évaluation externe.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'fr_FR', 'Décision du rédacteur', '{$authorName}:<br />\n<br />\nNous avons pris une décision concernant votre soumission à {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNotre décision est d''envoyer votre soumission en évaluation<br />\n<br />\nURL de la soummission : {$submissionUrl}', 'Cet courriel du rédacteur ou du chef de rubrique à un auteur les notifie que leur soumission a été envoyé à une source externe pour son évaluation.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'gd_GB', 'Co-dhùnadh deasaiche', '{$authorName}:<br />\n<br />\nThàinig sinn gu co-dhùnadh a thaobh an tagraidh agad gu {$contextName}, “{$submissionTitle}”.<br />\n<br />\nCho-dhùin sinn Cuir airson lèirmheas<br />\n<br />\nURL an tagraidh: {$submissionUrl}', 'Tha am post-d seo on deasaiche no o dheasaiche na h-earrainn gu ùghdar a’ leigeil fios thuca gun deach an tagradh aca a chur airson lèirmheas air an taobh a-muigh.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'hi_IN', 'संपादक का निर्णय', '{$authorName}:<br />\n<br />\nहम आपके सबमिशन के बारे में निर्णय ले चुके हैं to {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOur decision is to: Send to Review<br />\n<br />\nSubmission URL: {$submissionUrl}', 'एक लेखक के संपादक या अनुभाग संपादक का यह ईमेल उन्हें सूचित करता है कि उनका प्रस्तुतिकरण बाहरी समीक्षा के लिए भेजा जा रहा है.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'hu_HU', 'Szerkesztői döntés', 'Tisztelt {$authorName}!<br />\n<br />\nÉrtesítjük, hogy a(z) {$contextName} folyóirathoz beküldött &quot;{$submissionTitle}&quot; című cikkét szakmai lektorálásra elküldtük.<br />\n<br />\nA cikk URL: {$submissionUrl}<br />\n<br />\nÜdvözlettel,<br />\n{$editorialContactSignature}<br />', 'Ez az email a Szerkesztőtől vagy a Rovatszerkesztőtől érkezik a Szerzőnek, hogy a cikkét a szerkesztőség külső szakmai lektorálásra küldte.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'id_ID', 'Keputusan Editor', '{$authorName}:<br />\n<br />\nKami telah membuat keputusan terkait naskah yang Anda kirimkan ke {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nKeputusan kami adalah: Dikirimkan ke Reviewer Eksternal<br />\n<br />\nURL Naskah: {$submissionUrl}', 'Email ini dari Editor atau Editor Bagian kepada Penulis memberitahukan bahwa naskah dikirimkan ke reviewer eksternal.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'it_IT', 'Decisione dell''editor', 'Gentilissimo {$authorName}:<br />\n<br />\nAbbiamo preso una decisione circa la tua proposta a {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nLa nostra decisione: invio a un revisore esterno<br />\n<br />\nSubmission URL: {$submissionUrl}', 'Questa mail è inviata dall''Editor o dal Section Editor all''autore quando il manoscritto viene assegnato ad un revisore.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'ja_JP', '編集者の判断', '{$authorName}様:<br />\n<br />\n下記の投稿について結論に達しましたので、連絡いたします。\n『{$contextName}』「{$submissionTitle}」<br />\n<br />\n結果は: 査読に回す<br />\n<br />\n投稿物のURL: {$submissionUrl}', '編集者またはセクションエディターから著者へのこのメールは、投稿が外部査読に回されることを著者に通知します。'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'ku_IQ', 'بڕیاری سەرنوسەر', '{$authorName}:<br />\n<br />\nئێمە بڕیارمان دەربارەی توێژینەوەکەتان دا {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nبڕیار: ناردنی توێژینەوەکە بۆ هەڵسەنگاندن<br />\n<br />\nلینکی توێژینەوەکە: {$submissionUrl}', 'ئەم ئیمەیڵە لە لایەن سەرنوسەر یان سەرنوسەری بەشەوە بۆ توێژەرە بە مەبەستی ئاگادارکردنەوەیان لە ئەوەی کە توێژینەوەکەیان بۆ هەڵسەنگێنەری دەرەکی دەنێردرێت.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'mk_MK', 'Одлука на уредникот', '{$authorName}:<br />\n<br />\nДонесовме одлука во однос на вашиот поднесок до {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nНашата одлука е: Испрати за корекција<br />\n<br />\nURL-адреса на поднесокот: {$submissionUrl}', 'Овој и-меил од Главен или Секциски уредник до Автор ги известува дека нивниот поднесок се испраќа за надворешна рецензија.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'nb_NO', 'Redaktørens beslutning', '{$authorName}:<br />\n<br />\nVi har tatt en beslutning angående innleveringen din, «{$submissionTitle}», som du sendte inn til {$contextName}. <br />\n<br />\nVår beslutning er: Sendes til fagfellevurdering<br />\n<br />\nInnleveringens URL: {$submissionUrl}', 'Denne e-posten fra redaktør eller seksjonsredaktør til en forfatter, informerer om at innleveringen vil bli sendt til fagfellevurdering.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'nl_NL', 'Redacteursbeslissing', '{$authorName}:<br />\n<br />\nWe hebben een beslissing genomen over uw inzending voor {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nOnze belissing is: Doorsturen aan reviewer<br />\n<br />\nURL inzending: {$submissionUrl}', 'Deze e-mail van de redacteur of sectieredacteur brengt een auteur ervan op de hoogte dat een inzending wordt doorgestuurd aan een reviewer.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'pl_PL', 'Decyzja redakcji', 'Szanowna Pani/ Szanowny Panie,<br />\n<br />\npodjęllśmy decyzję w sprawie tekstu "{$submissionTitle}" zgłoszonego do czasopisma "{$contextName}".<br />\n<br />\nDecyzja redaktora: Przesłane do recenzji<br />\n<br />\nWWW tekstu: {$submissionUrl}', 'Ta wiadomość jest wysyłana od redaktora lub redaktora działu do autora. Zawiera decyzję o przesłaniu zgłoszonego tekstu do recenzji.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'pt_BR', 'Decisão do Editor', '{$authorName}:<br />\n<br />\nNós chegamos a uma decisão referente a sua submissão para o periódico {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNossa decisão é de: Enviar para avaliação<br />\n<br />\nURL da submissão: {$submissionUrl}', 'Este e-mail enviado pelo Editor ou Editor de Seção para um autor serve para notificar o mesmo de que sua submissão foi enviada para avaliadores externos.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'pt_PT', 'Decisão editorial', '{$authorName}:<br />\n<br />\nFoi tomada uma decisão sobre o artigo submetido a {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nA decisão é: Enviar para Revisão<br />\n<br />\nURL da submissão: {$submissionUrl}', 'Este email é enviado pelo Editor/Editor de Secção ao Autor serve para o notificar que a submissão foi enviada para uma revisão externa.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'ro_RO', 'Decizia Editorului', '{$authorName}:<br />\n<br />\nAm ajuns la o decizie cu privire la manuscrisul înregistrat de dumneavoastră {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nDecizia noastă este: De trimis spre revizuire<br />\n<br />\nURL manuscris: {$submissionUrl}', 'Acest e-mail este trimis de editor sau de editorul de secțiune către un autor, pe care îl notifică cu privire la trimiterea manuscrisului la revizori.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'ru_RU', 'Решение редакции', 'Здравствуйте, {$authorName}!<br />\n<br />\nМы приняли решение относительно Вашего материала «{$submissionTitle}», направленного в журнал «{$contextName}».<br />\n<br />\nНаше решение: Отправить на рецензирование<br />\n<br />\nURL материала: {$submissionUrl}', 'Это письмо редактора или редактора раздела, отправляемое автору, чтобы уведомить его об отправке материала на внешнее рецензирование.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'sk_SK', 'Rozhodnutie editora', 'Vážený(á) {$authorName}:<br />\n<br />\nDosiahli sme rozhodnutie, ktoré sa týka vášho príspevku do {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nNaše rozhodnutie je: odoslať k recenzii<br />\n<br />\nWebová adresa príspevku: {$submissionUrl}', 'Tento email od editora alebo editora sekcie autorovi oznamuje, že ich príspevok je odosielaný k externej recenzii.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'sl_SI', 'Uredniška odločitev', '{$authorName}:<br />\n<br />\nSprejeli smo odločitev glede vašega prispevka &quot;{$submissionTitle}&quot; za revijo {$contextName}.<br />\n<br />\nNaša odločitev je: Prispevek se pošlje v recenzijo<br />\n<br />\nURL povezava do prispevka: {$submissionUrl}', 'Ta email pošlje urednik avtorju z obvestilom, da je šel prispevek v recenzijo.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'sv_SE', 'Redaktörsbeslut', '{$authorName}:<br />\n<br />\nVi har fattat ett beslut angående ditt bidrag till {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nVårt beslut är att: Skicka till granskning<br />\n<br />\nBidragets URL: {$submissionUrl}', 'Det här e-postmeddelandet från redaktören eller sektionsredaktören till en författare meddelar att hens bidrag skickas till extern granskning.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'tr_TR', 'Editör Kararı', '{$authorName}:<br />\n<br />\n{$contextName}, &quot;{$submissionTitle}&quot; adresine yaptığınız gönderi için bir karara varılmıştır.<br />\n<br />\nKarar: Hakeme Gönderilmesi Uygundur<br />\n<br />\nSubmission URL: {$submissionUrl}', 'Editörden veya Bölüm Editörden bir Yazar''a gönderilen bu e-posta, gönderinin harici bir hakeme gönderildiğini bildirir.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'uk_UA', 'Рішення Редакції', '{$authorName}:<br />\n<br />\nМи прийняли рішення щодо вашого Подання до {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nНаше рішення: Відправити на Рецензування<br />\n<br />\nURL Подання: {$submissionUrl}', 'Це лист редактора чи редактора розділу до автора, з повідомленням про те, що подання відправлено на зовнішнє рецензування.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'vi_VN', 'Quyết định của Ban biên tập', 'Kính gửi {$authorName},<br />\n<br />\nChúng tôi đã đạt được một quyết định liên quan đến việc bài gửi của bạn {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\nQuyết định của chúng tôi là: Gửi lại để xem xét<br />\n<br />\nURL bài gửi: {$submissionUrl}', 'Email này từ Biên tập viên hoặc Biên tập chuyên mục cho Tác giả thông báo cho họ rằng bài gửi của họ đang được gửi đi đánh giá bên ngoài.'),
('EDITOR_DECISION_SEND_TO_EXTERNAL', 'zh_CN', '编辑决策', '{$authorName}:<br />\n<br />\n我们已经收到您的稿件： {$contextName}, &quot;{$submissionTitle}&quot;.<br />\n<br />\n我们决定：将您的稿件送去评审<br />\n<br />\n稿件的地址：{$submissionUrl}', '此邮件为总编或者栏目编辑发给投稿人告知稿件送审的提醒邮件。'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'ar_IQ', 'قرار هيئة التحرير', '{$authorName}:<br />\n<br />\nإن متعلقات تحرير مؤلَّفك الموسوم &quot;{$submissionTitle},&quot; قد اكتملت. نحن الآن نرسله إلى مرحلة الإنتاج.<br />\n<br />\nرابط الطلب: {$submissionUrl}', 'هذه الرسالة يعنونها مدير التحرير أو محرر القسم إلى المؤلف لإبلاغه بأن عمله قد تم إرساله إلى مرحلة الإنتاج.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'ca_ES', 'Decisió de l''editor/a', '{$authorName}:<br />\n<br />\nL''edició de la vostra tramesa, &quot;{$submissionTitle},&quot; s''ha completat. Ja està llesta per enviar-la a producció.<br />\n<br />\nURL de la tramesa: {$submissionUrl}', 'Aquest correu electrònic de l''editor/a o de l''editor/a de secció s''adreça a un autor/a per notificar-li que la seva tramesa s''envia a producció.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'cs_CZ', 'Rozhodnutí editora', '{$authorName}:<br />\n<br />\nEditace vašeho příspěvku, &quot;{$submissionTitle},&quot; je hotová.  Posíláme ho nyní do produkční fáze.<br />\n<br />\nWebová adresa příspěvku: {$submissionUrl}', 'Tento e-mail od editora nebo editora sekce autorovi oznamuje, že jejich podání je odesláno do produkční fáze.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'da_DK', 'Redaktørbeslutning', '{$authorName}:<br />\n<br />\nVi har færdiggjort redigeringen af din indsendelse, &quot;{$submissionTitle}.  Den vil nu blive sendt til publicering.<br />\n<br />\nSubmission URL: {$submissionUrl}', 'Denne e-mail fra redaktøren eller sektionsredaktøren til forfatteren meddeler at indsendelsen nu sendes til publicering.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'de_DE', 'Entscheidung der Redaktion', '{$authorName}:<br />\n<br />\nDas Lektorat Ihrer Einreichung &quot;{$submissionTitle}&quot; ist beendet. Wir leiten den Beitrag jetzt zur Herstellung weiter.<br />\n<br />\nURL des Beitrags: {$submissionUrl}', 'Diese E-Mail von Redakteur/in oder Rubrikredakteur/in informiert die/den Autor/in darüber, dass deren Beitrag in die Herstellung weitergeleitet worden ist.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'el_GR', 'Απόφαση Επιμελητή', '{$authorName}:<br />\n<br />\nΗ επιμέλεια της υποβολής σας &quot;{$submissionTitle},&quot; ολοκληρώθηκε. Τα αρχεία της υποβολής προωθούνται στο στάδιο παραγωγής.<br />\n<br />\nΣύνδεσμος υποβολής: {$submissionUrl}', 'Το παρόν μήνυμα αποστέλλεται από τον Επιμελητή ή τον Επιμελητή Ενότητας στον Συγγραφέα, ως ενημέρωση ότι η υποβολή προωθείται στην παραγωγή.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'en_US', 'Editor Decision', '{$authorName}:<br />\n<br />\nThe editing of your submission, &quot;{$submissionTitle},&quot; is complete.  We are now sending it to production.<br />\n<br />\nSubmission URL: {$submissionUrl}', 'This email from the Editor or Section Editor to an Author notifies them that their submission is being sent to production.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'es_ES', 'Decisión del editor/a', '{$authorName}:<br />\n<br />\nLa edición de su envío, &quot;{$submissionTitle},&quot; se ha completado. Ahora lo enviaremos a producción.<br />\n<br />\nSubmission URL: {$submissionUrl}', 'Este correo electrónico del editor/a, o del editor/a de sección, notifica al autor/a que su envío se traslada a producción.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'fa_IR', 'تصمیم دبیر', '{$authorName}:<br />\n<br />\n روند داوری مقاله ارسالی شما (&quot;{$submissionTitle}&quot;)  تکمیل شده و به واحد انتشار ارسال شده است.<br />\n<br />\nمشاهده وضعیت مقاله ارسالی: {$submissionUrl}', 'ایمیلی از طرف سردبیر یا دبیر بخش به نویسنده برای اطلاع از ارسال مقاله برای چاپ'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'fi_FI', 'Toimittajan päätös', 'Hyvä {$authorName},<br />\n<br />\nKäsikirjoituksenne &quot;{$submissionTitle},&quot; on nyt toimitettu ja lähetämme sen tuotantoon.<br />\n<br />\nKäsikirjoituksen URL: {$submissionUrl}', 'This email from the Editor or Section Editor to an Author notifies them that their submission is being sent to production.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'fr_CA', 'Décision du rédacteur', '{$authorName},<br />\n<br />\nL''édition de votre soumission « {$submissionTitle} » est complétée. Nous l''envoyons maintenant en production.<br />\n<br />\nURL de la soumission : {$submissionUrl}', 'Ce courriel du,de la rédacteur-trice ou du,de la rédacteur-trice de rubrique à un-e auteur-e le,la notifie de la décision concernant sa soumission, soit d''envoyer sa soumission en production.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'fr_FR', 'Décision du rédacteur', '{$authorName},<br />\n<br />\nL''édition de votre soumission « {$submissionTitle} » est terminée. Nous l''envoyons maintenant en production.<br />\n<br />\nURL de la soumission : {$submissionUrl}', 'Ce courriel du rédacteur, de la rédactrice, du rédacteur de rubrique ou de la rédactrice de rubrique à un auteur ou une auteure l''informe que sa soumission est envoyée en production.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'gd_GB', 'Co-dhùnadh deasaiche', '{$authorName}:<br />\n<br />\nTha obair deasachaidh an tagraidh agad, “{$submissionTitle},” deiseil.  Tha sinn ga chur chun an sgioba saothrachaidh an-dràsta.<br />\n<br />\nURL an tagraidh: {$submissionUrl}', 'Tha am post-d seo on deasaiche no o dheasaiche na h-earrainn gu ùghdar a’ leigeil fios thuca gun deach an tagradh aca a chur chun an sgioba saothrachaidh.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'hi_IN', 'संपादक का निर्णय', '{$authorName}:<br />\n<br />\nआपके सबमिशन का संपादन, &quot;{$submissionTitle},&quot; पूरा है। अब हम इसे उत्पादन के लिए भेज रहे हैं.<br />\n<br />\nSubmission URL: {$submissionUrl}', 'एक लेखक के संपादक या अनुभाग संपादक का यह ईमेल उन्हें सूचित करता है कि उनका सबमिशन उत्पादन के लिए भेजा जा रहा है.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'hu_HU', 'Szerkesztői döntés', 'Tisztelt {$authorName}!<br />\n<br />\nA(z) &quot;{$submissionTitle},&quot; című kéziratának lektorálása befejeződött, megjelentetésre küldjük.<br />\n<br />\nA kézirat URL címe: {$submissionUrl}<br />\n<br />\nÜdvözlettel,<br />\n{$editorialContactSignature}<br />', 'Ez az email a Szerkesztőtől vagy a Rovatszerkesztőtől érkezik a Szerzőnek, hogy a cikkét a szerkesztőség megjelentetésre továbbította.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'id_ID', 'Keputusan Editor', '{$authorName}:<br />\n<br />\nProses editing naskah Anda, &quot;{$submissionTitle},&quot; telah selesai.  Kami sekarang mengirimkannya ke produksi.<br />\n<br />\nURL Naskah: {$submissionUrl}', 'Email ini dari Editor atau Editor Bagian kepada Penulis memberitahukan bahwa naskah dikirim ke produksi.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'it_IT', 'Decisione dell''editor', 'Gentilissimo {$authorName}:<br />\n<br />\nLa lavorazione editoriale della sua proposta, &quot;{$submissionTitle},&quot; è completa.  Ora viene preparata per l''uscita sulla rivista.<br />\n<br />\nURL proposta: {$submissionUrl}', 'Questa mail è inviata dall''editor o dall''editor di sezione all''autore quando una proposta è stata sistemata dal punto di vista editoriale.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'ja_JP', '編集者の判断', '{$authorName}様:<br />\n<br />\n投稿「{$submissionTitle}」の編集が完了しました。 これから制作プロセスに入ります。<br />\n<br />\n投稿物のURL: {$submissionUrl}', '編集者やセクションエディターから著者へのこのメールは、投稿が制作プロセスに入ることを通知します。');
INSERT INTO `email_templates_default_data` VALUES
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'ku_IQ', 'بڕیاری سەرنوسەر', '{$authorName}:<br />\n<br />\nئێمە لە ئێستادا توێژینەوەی &quot;{$submissionTitle},&quot; دەنێرین بۆ بڵاوکردنەوە.<br />\n<br />\nلینکی پێشکەشکردنی توێژینەوەکە: {$submissionUrl}', 'ئەم ئیمەیڵە لە سەرنوسەر یان سەرنوسەری بەشەوە بۆ توێژەرە بۆ ئاگادارکردنەوەیان لەوەی کە توێژینەوەکەیان دەنێردرێت بۆ بڵاوکردنەوە.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'mk_MK', 'Одлука на уредникот', '{$authorName}:<br />\n<br />\nУредувањето на вашиот поднесок, &quot;{$submissionTitle},&quot; е завршено. Сега го испраќаме на обработка.<br />\n<br />\nURL-адреса на поднесокот: {$submissionUrl}', 'Овој и-меил од Главен или Секциски уредник до Автор ги известува дека нивниот поднесок се испраќа за обработка.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'nb_NO', 'Redaktørens beslutning', '{$authorName}:<br />\n<br />\nRedigeringen av «{$submissionTitle}» er ferdigstilt. Vi sender den videre til produksjon.<br />\n<br />\nInnleveringens URL: {$submissionUrl}', 'Denne e-posten fra redaktør eller seksjonsredaktør til en forfatter, informerer om at innleveringen sendes til produksjon.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'nl_NL', 'Redacteursbeslissing', '{$authorName}:<br />\n<br />\nDe redactie van uw inzending, &quot;{$submissionTitle},&quot; is afgerond. We geven uw inzending nu in productie.<br />\n<br />\nURL inzending: {$submissionUrl}', 'Deze e-mail van de redacteur of sectieredacteur brengt een auteur ervan op de hoogte dat een inzending in productie wordt gegeven.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'pl_PL', 'Decyzja redakcji', 'Szanowna Pani/ Szanowny Panie {$authorName}<br />\n<br />\nkorekta tekstu "{$submissionTitle}". Tekst został przekazany do składu.<br />\n<br />\nWWW tekstu: {$submissionUrl}', 'Ta wiadomość jest wysyłana od redaktora lub redaktora działu do autora. Zawiera powiadomienie o ukończeniu korekty i przekazaniu tekstu do etapu realizacji.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'pt_BR', 'Decisão do Editor', '{$authorName}:<br />\n<br />\nA edição de texto da sua submissão, &quot;{$submissionTitle},&quot; está completa. Agora ela está sendo enviada para  editoração.<br />\n<br />\nURL da submissão: {$submissionUrl}', 'Este e-mail do Editor ou Editor de Seção para um Autor notifica-os de que seus envios estão sendo enviados para produção.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'pt_PT', 'Decisão editorial', '{$authorName}:<br />\n<br />\nA edição da sua submissão, &quot;{$submissionTitle},&quot; está concluída.  O artigo foi enviado para a produção.<br />\n<br />\nURL da submissão : {$submissionUrl}', 'Este e-mail é enviado pelo Editor/Editor de Secção ao Autor a notificá-lo que a sua submissão foi enviada para produção.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'ro_RO', 'Decizia Editorului', '{$authorName}:<br />\n<br />\nEditarea manuscrisului dumneavoastră &quot;{$submissionTitle},&quot; este finalizată.  Acesta va fi trimis către producție.<br />\n<br />\nURL manuscris: {$submissionUrl}', 'Acest e-mail este trimis de editor sau de editorul de secțiune către un autor pentru a-l notifica că manuscrisul va fi trimis pentru producție.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'ru_RU', 'Решение редакции', 'Здравствуйте, {$authorName}!<br />\n<br />\nРедактирование Вашего материала «{$submissionTitle}» завершено. Теперь мы запускаем его в производство.<br />\n<br />\nURL материала: {$submissionUrl}', 'Это письмо редактора или редактора раздела, отправляемое автору, чтобы уведомить его о запуске материала в производство.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'sk_SK', 'Rozhodnutie editora', '{$authorName}:<br />\n<br />\nEditácia vášho príspevku, &quot;{$submissionTitle},&quot; je hotová.  Posielame ho teraz do produkčnej fáze.<br />\n<br />\nWebová adresa príspevku: {$submissionUrl}', 'Tento e-mail od editora alebo editora sekcie autorovi oznamuje, že ich podanie je odoslané do produkčnej fázy.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'sl_SI', 'Uredniška odločitev', '{$authorName}:<br />\n<br />\nUrejanje vašega prispevka, &quot;{$submissionTitle},&quot; je končano. Prispevek bom poslali v produkcijo.<br />\n<br />\nURL povezava do prispevka: {$submissionUrl}', 'Ta email pošlje urednik avtorju z obvestilom, da je šel prispevek v produkcijo.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'sv_SE', 'Redaktörsbeslut', '{$authorName}:<br />\n<br />\nRedigeringen av ditt bidrag &quot;{$submissionTitle}&quot; är färdig. Vi skickar det nu vidare till produktion.<br />\n<br />\nBidragets URL: {$submissionUrl}', 'Det här e-postmeddelandet från redaktören eller sektionsredaktören till en författare meddelar att hens bidrag sänds vidare till produktion.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'tr_TR', 'Editör Kararı', '{$authorName}:<br />\n<br />\n\n&quot;{$submissionTitle},&quot; adlı gönderinizin düzenlemesi tamamlandı. Makalenizi basım aşamasına gönderiyoruz.<br />\n<br />\nGönderi URL''si: {$submissionUrl}', 'Editörden veya Bölüm Editörden Yazar''a gönderilen bu e-posta, makalelerin basım aşamasına gönderildiklerini bildirir.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'uk_UA', 'Рішення Редакції', '{$authorName}:<br />\n<br />\nРедагування вашого подання &quot;{$submissionTitle},&quot; завершено. Ми надсилаємо його на публікацію.<br />\n<br />\nURL Подання: {$submissionUrl}', 'Це лист редактора чи редактора розділу, яке повідомляє Автора про запуск його матеріалу у Виробництво.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'vi_VN', 'Quyết định của Ban biên tập', 'Kính gửi {$authorName},<br />\n<br />\nQuá trình biên tập bản thảo của bạn, &quot;{$submissionTitle},&quot; đã hoàn thành. Chúng tôi đã chuyển nó sang giai đoạn chế bản.<br />\n<br />\nURL bài gửi: {$submissionUrl}', 'Email này từ Biên tập viên hoặc Biên tập chuyên mục cho Tác giả thông báo cho họ rằng bài gửi của họ đang được gửi đến giai đoạn chế bản.'),
('EDITOR_DECISION_SEND_TO_PRODUCTION', 'zh_CN', '总编决定', '{$authorName}:<br />\n<br />\n您的稿件 &quot;{$submissionTitle}&quot; 修改结束。我们将要安排出版。<br />\n<br />\n稿件地址： {$submissionUrl}', '此邮件是总编或者栏目编辑发现给投稿人告知稿件安排出版的提醒邮件。'),
('EDITOR_RECOMMENDATION', 'ar_IQ', 'توصيات المحرر', '{$editors}:<br />\n<br />\nإن التوصيات المتعلقة بطلب النشر في {$contextName}، &quot;{$submissionTitle}&quot; هي: {$recommendation}', 'هذه الرسالة يعنونها المحرر المشارك في تقديم التوصيات أو محرر القسم إلى جهة التحرير المعنية باتخاذ القرار لإشعارها بالتوصية النهائية الخاصة بطلب نشر مقدم إلى المجلة.'),
('EDITOR_RECOMMENDATION', 'ca_ES', 'Recomanació de l''editor/a', '{$editors}:<br />\n<br />\nLa recomanació respecte a la tramesa {$contextName}, &quot;{$submissionTitle}&quot; és: {$recommendation}', 'Aquest correu electrònic de l''editor/a o de l''editor/a de secció que fan recomanacions per als editors/ores o editors/ores de secció que prenen decisions els notifica que s''ha fet una recomanació final sobre la tramesa.'),
('EDITOR_RECOMMENDATION', 'cs_CZ', 'Doporučení redaktora', '{$editors}:<br />\n<br />\nDoporučení k příspěvku {$contextName}, &quot;{$submissionTitle}&quot; je: {$recommendation}', 'Tento e-mail je od redaktora nebo redaktora sekce pro odpovědného redaktora nebo pro redaktory sekcí - informuje o konečném doporučení ohledně příspěvku.'),
('EDITOR_RECOMMENDATION', 'da_DK', 'Redaktøranbefaling', '{$editors}:<br />\n<br />\nAnbefalingen med hensyn til {$contextName}, &quot;{$submissionTitle}&quot; er: {$recommendation}', 'Denne e-mail fra den rådgivende redaktør eller sektionsredaktør til de beslutningstagende redaktører eller sektionsredaktører videregiver en endelig anbefaling vedrørende indsendelsen.'),
('EDITOR_RECOMMENDATION', 'de_DE', 'Entscheidung der Redaktion', '{$editors}:<br />\n<br />\nDie Empfehlung hinsichtlich der Einreichung für {$contextName}, &quot;{$submissionTitle}&quot; ist: {$recommendation}', 'Diese E-Mail von der/dem vorschlagenen Redakteur/in oder Rubrikenredakteur/in an die/den Entscheidungen treffenden Redakteur/in oder Rubrikenredakteur/in informiert diese/n über die endgültige Empfehlung zur vorliegenden Einreichung.'),
('EDITOR_RECOMMENDATION', 'el_GR', 'Σύσταση Επιμελητή', '{$editors}:<br />\n<br />\nΗ σύσταση αναφορικά με την υποβολή &quot;{$submissionTitle}&quot;, στο περιοδικό {$contextName}, είναι: {$recommendation}', 'Το παρόν μήνυμα αποστέλλεται από τον συστήνοντα Επιμελητή (ή Επιμελητή Ενότητας) στους Επιμελητές (ή Επιμελητές Ενότητας) που έχουν την εποπτεία μιας υποβολής, γνωστοποιώντας την τελική σύσταση σχετικά με την υποβολή.'),
('EDITOR_RECOMMENDATION', 'en_US', 'Editor Recommendation', '{$editors}:<br />\n<br />\nThe recommendation regarding the submission to {$contextName}, &quot;{$submissionTitle}&quot; is: {$recommendation}', 'This email from the recommending Editor or Section Editor to the decision making Editors or Section Editors notifies them of a final recommendation regarding the submission.'),
('EDITOR_RECOMMENDATION', 'es_ES', 'Recomendación del editor/a', '{$editors}:<br />\n<br />\nLa recomendación respecto al envío a {$contextName}, &quot;{$submissionTitle}&quot; es: {$recommendation}', 'Este correo electrónico del editor/a o editor/a de sección que aconseja para los editores/as o editores/as de sección que toman las decisiones les notifica sobre la recomendación final respecto al envío.'),
('EDITOR_RECOMMENDATION', 'fa_IR', 'توصیه دبیر', '{$editors}:<br />\n<br />\nتوصیه اینجانب در مورد مقاله ارسالی (&quot;{$submissionTitle}&quot;) در {$contextName} ، {$recommendation} می باشد.', 'ایمیلی از طرف دبیر یا دبیر بخش به دبیر نهایی تصمیم گیرنده برای اطلاع از توصیه برای مقاله ارسالی'),
('EDITOR_RECOMMENDATION', 'fi_FI', 'Toimittajan suositus', '{$editors}:<br />\n<br />\nJulkaisun {$contextName} käsikirjoitusta &quot;{$submissionTitle}&quot; koskeva suositus on: {$recommendation}', 'This email from the recommending Editor or Section Editor to the decision making Editors or Section Editors notifies them of a final recommendation regarding the submission.'),
('EDITOR_RECOMMENDATION', 'fr_CA', 'Recommandation du rédacteur', '{$editors},<br />\n<br />\nLa recommandation concernant la soumission « {$submissionTitle} » à la revue {$contextName} est de : {$recommendation}', 'Ce courriel envoyé par le,la rédacteur-trice ou le,la rédacteur-trice de rubrique en charge de la recommandation au,à la rédacteur-trice ou au,à la rédacteur-trice de rubrique en charge de la prise de décisions l''informe d''une recommandation finale concernant la soumission.'),
('EDITOR_RECOMMENDATION', 'fr_FR', 'Recommandation éditoriale', '{$editors},<br />\n<br />\nLa recommandation concernant la soumission « {$submissionTitle} » à la revue {$contextName} est de {$recommendation}', 'Ce courriel du rédacteur en chef ou du rédacteur en chef de la section à l''intention des rédacteurs en chef décideurs ou des rédacteurs en chef de la section les avise d''une recommandation finale concernant la soumission.'),
('EDITOR_RECOMMENDATION', 'gd_GB', 'Moladh an deasaiche', '{$editors}:<br />\n<br />\n’S e seo an co-dhùnadh a thaobh an tagraidh gu {$contextName}, “{$submissionTitle}”: {$recommendation}', 'Tha am post-d seo on deasaiche a mhol e no o dheasaiche na h-earrainn chun nan deasaichean co-dhùnaidh no deasaichean earrainn a’ leigeil fios thuca mun mholadh deireannach a thaobh an tagraidh.'),
('EDITOR_RECOMMENDATION', 'hi_IN', 'संपादक की सिफारिश', '{$editors}:<br />\n<br />\nको प्रस्तुत करने के संबंध में सिफारिश {$contextName}, &quot;{$submissionTitle}&quot; is: {$recommendation}', 'एडिटिंग या सेक्शन एडिटर्स की सिफारिश करने वाले एडिटर या सेक्शन एडिटर की सिफारिश से यह ईमेल उन्हें सबमिट करने से संबंधित अंतिम सिफारिश के बारे में सूचित करता है।.'),
('EDITOR_RECOMMENDATION', 'hu_HU', 'Szerkesztői javaslat', 'Tisztelt {$editors}!<br />\n<br />\nA(z) {$contextName} folyóirathoz beküldött &quot;{$submissionTitle}&quot; című cikkel kapcsolatban javaslatunk: {$recommendation}<br />   \n<br />\nÜdvözlettel,<br />  \n{$editorialContactSignature}<br />', 'Ez az e-mail az ajánlatot tevő Szerkesztőtől vagy Rovatszerkesztőtől megy a döntést meghozó Szerkesztőkhöz vagy Rovatszerkesztőkhöz, értesítve őket a  kézirattal kapcsolatos végső javaslatról.'),
('EDITOR_RECOMMENDATION', 'id_ID', 'Rekomendasi Penyunting', '{$editors}:<br />\n<br />\nRekomendasi berkaitan dengan  naskah {$contextName}, &quot;{$submissionTitle}&quot; adalah: {$recommendation}', 'Email ini berasal dari Editor atau Editor Bagian kepada Editor pengambilan keputusan atau Editor Bagian memberi tahu mereka tentang rekomendasi akhir mengenai naskah tersebut.'),
('EDITOR_RECOMMENDATION', 'it_IT', 'Raccomandazione dell''editor', '{$editors}:<br />\n<br />\nLa raccomandazione riguardo la proposta &quot;{$submissionTitle}&quot;, giunta per  {$contextName}, è: {$recommendation}', 'Mail che l''editor invia al responsabile contenente la raccomandazione su cosa fare di una certa proposta.'),
('EDITOR_RECOMMENDATION', 'ja_JP', '編集推薦', '{$editors}:<br />\n<br />\n『$contextName}』への投稿「{$submissionTitle}」に関する推薦は {$recommendation} です。', '推薦編集者またはセクションエディターから意思決定を行う編集者またはセクションエディターへのこのメールは、投稿に関する最終的な推薦を通知します。'),
('EDITOR_RECOMMENDATION', 'ku_IQ', 'پێشنیازەکانی سەرنوسەر', '{$editors}:<br />\n<br />\nپێشنیازەکان دەربارەی {$contextName}, &quot;{$submissionTitle}&quot; ئەمانەن: {$recommendation}', 'ئەم ئیمەیڵە لە لایەن یەکێک لە سەرونسەرانەوەیە بۆ سەرنوسەری بڕیاردەر بۆ ئەوەی لە کۆتا پێشنیازەکان دەربارەی توێژینەوەی پێشکەشکراو ئاگادار بکرێتەوە.'),
('EDITOR_RECOMMENDATION', 'mk_MK', 'Препорака на уредникот', '{$уредници}: <br/>\n<br/>\nПрепораката во врска со поднесувањето до {$textName}, &quot;{$missionTitle}&quot; е: {$recommendation}', 'Овој и-меил од Главен или Секциски уредник кој препорачува до Главен или Секциски уредник кој носи одлука ги известува за конечната препорака во однос на поднесокот.'),
('EDITOR_RECOMMENDATION', 'nb_NO', 'Redaktørens anbefaling', '{$editors}:<br />\n<br />\nMin anbefaling for innleveringen &quot;{$submissionTitle}&quot; til {$contextName}, er: {$recommendation}', 'Denne e-posten fra rådgivende redaktører eller seksjonsredaktører til besluttende redaktørerer eller seksjonsredaktørerer informerer om en endelig anbefaling angående innleveringen.'),
('EDITOR_RECOMMENDATION', 'nl_NL', 'Redacteursaanbeveling', '{$editors}:<br />\n<br />\nDe aanbeveling voor de inzending voor {$contextName}, &quot;{$submissionTitle}&quot; is: {$recommendation}', 'Deze e-mail van de aanbevelende redacteur of sectieredacteur brengt de beslissende redacteurs of sectieredacteurs op de hoogte van een aanbeveling over de inzending.'),
('EDITOR_RECOMMENDATION', 'pl_PL', 'Rekomendacja redaktora', '{$editors}:<br />\n<br />\nprzesyłam rekomendację w sprawie tekstu "{$submissionTitle}", zgłoszonego do czasopisma "{$contextName}": {$recommendation}', 'Ta wiadomość jest wysyłana od redaktora przypisanego do tekstu do redaktora czasopisma. Zawiera powiadomienie o rekomendacji w sprawie tekstu.'),
('EDITOR_RECOMMENDATION', 'pt_BR', 'Recomendação do Editor', '{$editors}:<br />\n<br />\nA recomendação referente à submissão para o periódico {$contextName}, &quot;{$submissionTitle}&quot; é: {$recommendation}', 'Este e-mail do Editor que recomenda ou do Editor de Seção para os Editores que tomam decisões ou Editores de Seção notifica-os de uma recomendação final sobre a submissão.'),
('EDITOR_RECOMMENDATION', 'pt_PT', 'Recomendação Editorial', '{$editors}:<br />\n<br />\nA recomendação relativamente à submissão para  {$contextName}, &quot;{$submissionTitle}&quot; é: {$recommendation}', 'Este e-mail é enviado pelo Editor ou Editor de Secção ao Editor que emite a decisão editorial a notificar da recomendação final relativa à submissão.'),
('EDITOR_RECOMMENDATION', 'ro_RO', 'Recomandarea editorului', '{$editors}:<br />\n<br />\nRecomandarea noastră cu privire la manuscrisul {$contextName}, &quot;{$submissionTitle}&quot; este: {$recommendation}', 'Acest e-mail de la editorul care recomandă sau de la editorul de secțiune către editorii care iau decizii sau editorii de secțiuni, îi notifică pe aceștia cu privire la recomandarea finală privind manuscrisul.'),
('EDITOR_RECOMMENDATION', 'ru_RU', 'Рекомендация редактора', 'Здравствуйте, {$editors}!<br />\n<br />\nПо материалу «{$submissionTitle}», отправленному в «{$contextName}», могу рекомендовать следующее: {$recommendation}', 'Это письмо рекомендующего редактора или редактора раздела редакторам или редакторам раздела, принимающим решение, чтобы уведомить их об итоговой рекомендации относительного присланного материала.'),
('EDITOR_RECOMMENDATION', 'sk_SK', 'Odporúčania redaktora', '{$editors}:<br />\n<br />\nOdporúčania k príspevku {$contextName}, &quot;{$submissionTitle}&quot; je: {$recommendation}', 'Tento e-mail je od editora alebo redaktora sekcie pre zodpovedného redaktora alebo pre redaktorov sekcií - informuje o konečnom odporúčaní príspevku.'),
('EDITOR_RECOMMENDATION', 'sl_SI', 'Uredniško priporočilo', '{$editors}:<br />\n<br />\nMoje priporočilo glede prispevka &quot;{$submissionTitle}&quot; v reviji {$contextName}, je: {$recommendation}', 'Email pošlje urednik (rubrike), ki lahko odda le priporočilo, in z njim obvesti uredništvo o svojem priporočilu glede prispevka.'),
('EDITOR_RECOMMENDATION', 'sv_SE', 'Redaktörsrekommendation', '{$editors}:<br />\n<br />\nRekommendationen angående bidraget &quot;{$submissionTitle}&quot; till {$contextName} är: {$recommendation}', 'Det här e-postmeddelandet från den rekommenderande redaktören eller sektionsredaktören till ansvariga redaktörer eller sektionsredaktörer meddelar dem en slutgiltig rekommendation för bidraget.'),
('EDITOR_RECOMMENDATION', 'tr_TR', 'Editör Tavsiyesi', '{$editors}:<br />\n<br />\n{$contextName}, &quot;{$submissionTitle}&quot; adlı gönderi ile ilgili öneri: {$recommendation}', 'Düzenleyici Editörden veya Bölüm Editörden, karar veren editörleri veya Bölüm Editörleri''ne gönderilen bu e-postalar, onlara gönderiyle ilgili nihai bir öneriyi bildirir.'),
('EDITOR_RECOMMENDATION', 'uk_UA', 'Рекомендації Редактора', '{$editors}:<br />\n<br />\nЩодо подання {$submissionTitle}, надісланому до {$contextName}, можу рекомендувати наступне: {$recommendation}', '##emails.editorRecommendation.description##'),
('EDITOR_RECOMMENDATION', 'vi_VN', 'Khuyến nghị của biên tập viên', 'Kính gửi {$editors},<br />\n<br />\nThe recommendation regarding the submission to {$contextName}, &quot;{$submissionTitle}&quot; is: {$recommendation}', 'Email này từ Biên tập viên hoặc Biên tập viên chuyên mục tới các Biên tập viên hoặc Biên tập viên chuyên mục thông báo cho họ quyết định về khuyến nghị cuối cùng liên quan đến bài gửi.'),
('EDITOR_RECOMMENDATION', 'zh_CN', '总编建议', '{$editors}:<br />\n<br />\n关于稿件 {$contextName}, &quot;{$submissionTitle}&quot; 的建议是： {$recommendation}', '此邮件为总编或者栏目编辑发给编辑或者栏目编辑的关于他们对于稿件的去留建议的提醒邮件。'),
('EMAIL_LINK', 'ar_IQ', 'مقالة قد تكون مهمة', 'لقد وجدت أن المقالة العلمية الموسومة &quot;{$submissionTitle}&quot; قد تحوز على إهتمامك، وهي من تأليف {$authorName} ومنشورة في المجلد {$volume}، العدد {$number} لسنة ({$year}) من {$contextName} على الرابط &quot;{$articleUrl}&quot;.', 'قالب هذه الرسالة نموذج لما يرسله قارئ مسجل في موقع المجلة إلى أحد معارفه ملفتاً نظره إلى مقالة علمية أو بحث. تلك الخاصية متوافرة عبر أدوات القراءة وينبغي تفعيلها من قبل مدير موقع المجلة في صفحة إدارة أدوات القراءة.'),
('EMAIL_LINK', 'bs_BA', 'Potencijalno zanimljiv članak', 'Skrećem vam pozornost na članak &quot;{$submissionTitle}&quot; autora {$authorName} koji je objavljen u godištu {$volume}, broju {$number} ({$year}) časopisa {$contextName}, a može se naći na &quot;{$articleUrl}&quot;.', 'Ovaj obrazac e-pošte omogućuje registriranom čitatelju da šalje informaciju o članku nekome tko je zainteresiran. Ovaj je obrazac dostupan putem alata za čitanje i njegovu upotrebu mora aktivirati glavni urednik unutar postavki alata za čitanje među postavkama časopisa.'),
('EMAIL_LINK', 'ca_ES', 'Article que us pot interessar', 'Considero que us pot interessar llegir l''article &quot;{$submissionTitle}&quot; de {$authorName} publicat en el volum {$volume}, número {$number} ({$year}) de {$contextName}. El podeu consultar a &quot;{$articleUrl}&quot;.', 'Aquesta plantilla de missatge de correu electrònic ofereix als lectors registrats l''oportunitat d''enviar informació sobre un article a algú que hi pugui estar interessat. Aquesta plantilla està disponible a les eines de lectura si l''administrador de la revista l''ha habilitada a la pàgina d''administració d''aquestes eines.'),
('EMAIL_LINK', 'cs_CZ', 'Zajímavý článek', 'Myslím, že by Vás mohl zajímat článek &quot;{$submissionTitle}&quot; autora {$authorName} vydaný ve Vol {$volume}, No {$number} ({$year}) časopisu {$contextName} na adrese &quot;{$articleUrl}&quot;.', 'Tato emailová šablona umožňuje registrovanému čtenáři poslat informaci o článku někomu, koho by mohl zajímat. Je dostupná přes Nástroje pro čtení a musí být povolena manažerem časopisu na stránce Správa nástrojů pro čtení.'),
('EMAIL_LINK', 'da_DK', 'Artikel, der muligvis har din interesse', 'Jeg tænkte, at du måske ville være interesseret i at læse &quot;{$submissionTitle}&quot; af {$authorName}, der er publiceret i Årg. {$volume}, Nr. {$number} ({$year}) i {$contextName} på &quot;{$articleUrl}&quot;.', 'Denne e-mail-skabelon giver en registreret læser mulighed for at sende oplysninger om en artikel til en person, der muligvis er interesseret. Den er tilgængelig via læseværktøjerne og skal aktiveres af tidsskriftschefen på siden Administration af læseværktøjer.'),
('EMAIL_LINK', 'de_DE', 'Möglicherweise interessierender Artikel', 'Ich dachte, Sie würden sich vielleicht für den Beitrag &quot;{$submissionTitle}&quot; von {$authorName}, veröffentlicht in Band {$volume}, Nummer {$number} ({$year}) von {$contextName} unter &quot;{$articleUrl}&quot;, interessieren.', 'Diese E-Mail-Vorlage gibt einer registrierten Leserin/einem registrierten Leser die Möglichkeit, Informationen über einen Artikel an jemanden zu senden, die/der sich eventuell dafür interessiert. Sie ist über die Lesewerkzeuge erreichbar und muss von der/dem Zeitschriftenverwalter/in in den Einstellungen der Lesewerkzeuge aktiviert werden.'),
('EMAIL_LINK', 'el_GR', 'Ενδιαφέρον άρθρο', 'Πιθανόν να σας ενδιαφέρει το άρθρο &quot;{$submissionTitle}&quot; του/των {$authorName} που δημοσιεύτηκε στον τόμο {$volume}, τεύχος {$number} ({$year}) του περιοδικού {$contextName} και είναι προσβάσιμο στον σύνδεσμο &quot;{$articleUrl}&quot;.', 'Το παρόν πρότυπο ηλεκτρονικού μηνύματος παρέχει στους εγγεγραμμένους αναγνώστες τη δυνατότητα να ενημερώσουν σχετικά με ένα άρθρο κάποιον που μπορεί να ενδιαφέρεται για το περιεχόμενό του. Διατίθεται μέσω των Εργαλείων Ανάγνωσης και πρέπει να ενεργοποιηθεί από τον Διαχειριστή του Περιοδικού στη σελίδα Διαχείρισης Εργαλείων Ανάγνωσης.'),
('EMAIL_LINK', 'en_US', 'Article of Possible Interest', 'Thought you might be interested in seeing &quot;{$submissionTitle}&quot; by {$authorName} published in Vol {$volume}, No {$number} ({$year}) of {$contextName} at &quot;{$articleUrl}&quot;.', 'This email template provides a registered reader with the opportunity to send information about an article to somebody who may be interested. It is available via the Reading Tools and must be enabled by the Journal Manager in the Reading Tools Administration page.'),
('EMAIL_LINK', 'es_ES', 'Artículo interesante', 'He pensado que le podría interesar ver el artículo &quot;{$submissionTitle}&quot; de {$authorName}, publicado en el vol. {$volume}, nº {$number} ({$year}) de {$contextName} en &quot;{$articleUrl}&quot;.', 'Esta plantilla de correo proporciona a un/a lector/a registrado/a la oportunidad de enviar información sobre un artículo a alguien a quien le podría interesar. Está disponible a través de las Herramientas de Lectura y debe ser activado por el/la Gestor/a de la Revista en las Administración de Herramientas de Lectura.'),
('EMAIL_LINK', 'eu_ES', 'Interesgarria izan litekeen artikulu bat', 'Artikulu hau zuretzat interesgarria izango dela uste dut:<br />\nTitulua: {$submissionTitle}<br />\nEgilea: {$authorName}<br />\nAldizkaria: {$contextName} bol: {$volume} zk: {$number} ({$year})<br />\nURLa: {$articleUrl}', 'Mezu-txantiloi hau irakurle erregistratuek erabil dezakete beste norbaiti artikulu bati buruzko informazioa bidaltzeko, interesatuko zaiolakoan. Irakurtzeko tresnen bidez eskuratzen da txantiloi hau, eta Aldizkariaren kudeatzaileak gaitu behar du Irakurtzeko tresnen administrazio-orrian.'),
('EMAIL_LINK', 'fa_IR', 'شاید مایل به دیدن این مقاله باشید', 'به نظر می رسد که شما مایل به ملاحظه مقاله {$authorName}تحت عنوان &quot;{$submissionTitle}&quot; باشید. این مقاله در شماره &amp;lt;{$volume}&amp;gt; جلد &amp;lt;$number&amp;gt; سال &amp;lt;{$year}&amp;gt; {$contextName} به چاپ رسیده است.<br />\n<br />\nآدرس مقاله:<br />\n<a href="{$articleUrl}">{$articleUrl}</a>', 'This email template provides a registered reader with the opportunity to send information about an article to somebody who may be interested. It is available via the Reading Tools and must be enabled by the Journal Manager in the Reading Tools Administration page.'),
('EMAIL_LINK', 'fi_FI', 'Mahdollisesti kiinnostava artikkeli', 'Ajattelin, että sinua saattaisi kiinnostaa artikkeli "{$submissionTitle}", jonka on kirjoittanut {$authorName}. Artikkeli on ilmestynyt julkaisussa {$contextName} Vol {$volume} Nro. {$number} ({$year}) ja löytyy osoitteesta "<a href="{$articleUrl}">{$articleUrl}</a>".', 'This email template provides a registered reader with the opportunity to send information about an article to somebody who may be interested. It is available via the Reading Tools and must be enabled by the Journal Manager in the Reading Tools Administration page.'),
('EMAIL_LINK', 'fr_CA', 'Article potentiellement intéressant', 'Je pense que l''article suivant pourrait vous intéresser : « {$submissionTitle} » par {$authorName}, publié dans le volume {$volume}, numéro {$number} de ({$year}) de la revue {$contextName}, à l''adresse suivante : {$articleUrl}.', 'Ce modèle de courriel fournit à un,une lecteur-trice inscrit-e l''occasion d''envoyer de l''information à quelqu''un qui peut être intéressé par un article en particulier. Il est disponible via Outils de lecture et doit être activé par le,la directeur-trice de la revue à la page Gestion des outils de lecture.'),
('EMAIL_LINK', 'fr_FR', 'Article potentiellement intéressant', 'Je pense que l''article suivant pourrait vous intéresser : « {$submissionTitle} » par {$authorName}, publié dans le volume {$volume}, numéro {$number} de ({$year}) de la revue {$contextName}. Vous le trouverez à l''adresse suivante : {$articleUrl}.', 'Ce courriel type donne à un lecteur inscrit l''occasion d''envoyer de l''information à quelqu''un qui peut être intéressé par un article en particulier. Il est disponible via Outils de lecture et doit être activé par le Directeur de la revue à la page Gestion des outils de lecture.'),
('EMAIL_LINK', 'gd_GB', 'Artaigeal sam bi ùidh ma dh’fhaoidte', 'Shaoil leam gum biodh ùigh agad ann an “{$submissionTitle}” le {$authorName} a chaidh fhoillseachadh ann an leabhar {$volume}, àireamh {$number} ({$year}) de {$contextName} aig “{$articleUrl}”.', 'Tha an teamplaid puist-d seo a’ toirt cothrom do leughadair clàraichte fiosrachadh mu dhèidhinn artaigil a chur do chuideigin aig am bi ùidh ann ma dh’fhaoidte. Tha e ri fhaighinn slighe nan innealan leughaidh agus feumaidh manaidsearan an iris-leabhair a chur an comas air duilleag rianachd nan innealan leughaidh.'),
('EMAIL_LINK', 'hi_IN', 'संभावित ब्याज का आलेख', 'सोचा कि आपको देखने में दिलचस्पी हो सकती है &quot;{$submissionTitle}&quot; by {$authorName} published in Vol {$volume}, No {$number} ({$year}) of {$contextName} at &quot;{$articleUrl}&quot;.', 'यह ईमेल टेम्प्लेट एक पंजीकृत पाठक को एक लेख के बारे में जानकारी भेजने का अवसर प्रदान करता है, जिसे कोई दिलचस्पी हो। यह रीडिंग टूल्स के माध्यम से उपलब्ध है और जर्नल मैनेजर द्वारा रीडिंग टूल्स एडमिनिस्ट्रेशन पेज में सक्षम होना चाहिए.'),
('EMAIL_LINK', 'hr_HR', 'Potencijalno zanimljiv članak', 'Skrećem vam pozornost na članak &quot;{$submissionTitle}&quot; autora {$authorName} koji je objavljen u godištu {$volume}, broju {$number} ({$year}) časopisa {$contextName}, a može se naći na &quot;{$articleUrl}&quot;.', 'Ovaj obrazac e-pošte omogućuje registriranom čitatelju da šalje informaciju o članku nekome tko je zainteresiran. Ovaj je obrazac dostupan putem alata za čitanje i njegovu upotrebu mora aktivirati glavni urednik unutar postavki alata za čitanje među postavkama časopisa.'),
('EMAIL_LINK', 'hu_HU', 'Cikkajánló', 'Engedje meg, hogy figyelmébe ajánljuk {$authorName} ({$year}): &quot;{$submissionTitle}&quot; cikkét, mely a(z) {$contextName} című folyóirat {$volume} kötetének {$number} számában jelent meg. Elérhető a &quot;{$articleUrl}&quot; címen.', 'Ez az email sablon a regisztrált olvasóknak kínál lehetőséget arra, hogy ajánlhassák másoknak az érdekesnek talált cikkeket. Ez az Olvasói eszközöknél érhető el és a Folyóirat menedzser engedélyezheti az Olvasói eszközök adminisztrációs oldalán.'),
('EMAIL_LINK', 'id_ID', 'Artikel Menarik', 'Anda mungkin tertarik dengan &quot;{$submissionTitle}&quot; oleh {$authorName} diterbitkan di Vol {$volume}, No {$number} ({$year}) {$contextName} yang tersedia di &quot;{$articleUrl}&quot;.', 'Template email ini memungkinkan pembaca terdaftar mengirimkan informasi tentang suatu artikel kepada seseorang yang mungkin akan tertarik. Email ini tersedia di Alat Baca dan harus diaktifkan oleh Manajer Jurnal di halaman Administrasi Alat Baca.'),
('EMAIL_LINK', 'it_IT', 'Ti suggerisco la lettura di un articolo', 'Penso che potrebbe interessarti la lettura di:<br />\n &quot;{$submissionTitle}&quot; di {$authorName}<br />\npubblicato in {$contextName}, Vol. {$volume}, N. {$number} ({$year}) e disponibile all''indirizzo &quot;{$articleUrl}&quot;.', 'Questo modello  email fornisce ad un utente registrato l''opprtunità di inviare informazioni su un articolo a qualcuno che potrebbe essere interessato. E'' disponibile via utility di lettura e e deve essere abilitata dall''amministratore della rivista nella pagina di amministrazione delle utility di lettura.'),
('EMAIL_LINK', 'ja_JP', '論文の紹介', '{$contextName}の第{$volume}巻{$number}号（{$year}）で公開された{$authorName}による「{$submissionTitle}」を見て興味を持つかもしれないと思いました。この論文のURL: {$articleUrl}。', 'このメールテンプレートは、登録ユーザーに、興味を持ちそうな研究者に論文を紹介する機会を提供するものです。このメールは、読書ツールから利用することができますが、あらかじめ雑誌管理者が読書ツール管理ページで有効にしておく必要があります。'),
('EMAIL_LINK', 'ku_IQ', 'توێژینەوەی پەیوەندیدار', 'من وا بیر دەکەمەوە کە ئارەزوی بینینی &quot;{$submissionTitle}&quot; بۆ {$authorName} بکەن کە لە وەرزی {$volume}, ژمارەی{$number} ({$year}) لە {$contextName} لە &quot;{$articleUrl}&quot;. بڵاو دەکرێتەوە.', 'ئەم ئیمەیڵە قاڵبی خوێنەرێکی تۆمارکراوی تێدایە کە دەرفەتی ئەوەی پێدراوە توێژینەوەیەک بۆ کەسێکی دیکەی خوێنەر بنێرێت. ئەمە لە کەرەستەکانی خوێندنەوە بەردەستە و دەبێت لە لایەن بەڕێوەبەری گۆڤارەوە چالاک بکرێت.'),
('EMAIL_LINK', 'mk_MK', 'Текст од можен интерес', 'Мислевте дека можеби сте заинтересирани да го видите &quot; {$missionTitle}&quot; од {$authorName} објавено во Vol. {$volume}, бр. {$number} ({$year}) од {$textName} на &quot;{$articleUrl}&quot;.', 'Овој и-меил шаблон му ја обезбедува на регистриран корисник можноста да испрати информации за текст до некој кој би го интересирал истиот. Достапен е преку Алатки за читање и мора да биде овозможен од страна на Раководител на списание на страната Администрација на алатки за читање.'),
('EMAIL_LINK', 'nb_NO', 'En interessant artikkel', 'Jeg tenkte du kanskje kan være interessert i å lese artikkelen «{$submissionTitle}». Den er skrevet av {$authorName} og publisert i årgang {$volume}, utgave {$number} ({$year}) av {$contextName}, og er tilgjengelig på: «{$articleUrl}».', 'Denne e-postmalen gir en registrert bruker muligheten til å sende informasjon om en artikkel til potenisielt interesserte. Den er tilgjengelig via «Leseverktøy», og må være slått på av redaksjonslederen fra administrasjonssiden for leseverktøy.'),
('EMAIL_LINK', 'nl_NL', 'Mogelijk interessant artikel', 'Ik denk dat u mogelijk geïnteresseerd bent in &quot;{$submissionTitle}&quot; door {$authorName} gepubliceerd in Vol {$volume}, No {$number} ({$year}) van {$contextName} op &quot;{$articleUrl}&quot;.', 'Deze e-mail sjabloon geeft een lezer de mogelijkheid om informatie over een artikel naar iemand te sturen die daar mogelijk in geïnteresseerd is. Het is beschikbaar via de leesgereedschappen en moet ingeschakeld worden door de tijdschriftbeheerder (leesgereedschappen beheer pagina).'),
('EMAIL_LINK', 'pl_PL', 'Ciekawy artykuł', 'Na stronie czasopisma "{$contextName}" dostępny jest artykuł "{$submissionTitle}", który – jak sądzę – może Cię zainteresować:\n\nAutor: {$authorName} \nTytuł: "{$submissionTitle}" \nRok: {$year} \nTom(nr): {$volume}({$number})\nWWW: {$articleUrl}\n\nPozdrawiam', 'Wiadomość wysyłana przez zalogowanego na stronie czasopisma czytelnika, która zawiera zachętę do zapoznania się z treścią artykułu wraz z linkiem do tekstu.'),
('EMAIL_LINK', 'pt_BR', 'Artigo interessante para sua leitura', 'Acredito ser de seu interesse o artigo "{$submissionTitle}", de {$authorName}, publicado na revista {$contextName}, V. {$volume}, n. {$number}, Ano {$year}, disponível em "{$articleUrl}".', 'Mensagem enviada por um leitor a um colega, sobre um artigo considerado de seu interesse, com link para acesso e informações sobre a revista e a edição onde o documento foi publicado.'),
('EMAIL_LINK', 'pt_PT', 'Artigo interessante para a sua leitura', 'Acredito que lhe irá interessar o artigo &quot;{$submissionTitle}&quot;, de {$authorName}, publicado na revista {$contextName}, V. {$volume}, N. {$number}, Ano {$year}, disponível em &quot;<a href="{$articleUrl}">{$articleUrl}</a>&quot;.', 'Este e-mail é enviado por um leitor a um colega, sobre um artigo considerado de seu interesse, com link para acesso e informações sobre a revista e a edição onde o documento foi publicado. Está disponível através das Ferramentas de Leitura e deve ser ativado na página de configuração das Ferramentas de Leitura.'),
('EMAIL_LINK', 'ro_RO', 'Posibil, articol de interes', 'M-am gândit că ați putea fi interesat să citiți &quot;{$submissionTitle}&quot; de {$authorName} publicat în Vol {$volume}, Nr {$number} ({$year}) în {$contextName}, &quot;{$articleUrl}&quot;.', 'Acest șablon de e-mail oferă unui cititor înregistrat posibilitatea de a trimite informații despre un articol cuiva care ar putea fi interesat. Este disponibil prin intermediul instrumentelor de citire și trebuie activat de către Managerul jurnalului în pagina de administrare a instrumentelor de citire.'),
('EMAIL_LINK', 'ru_RU', 'Эта статья будет Вам интересна', 'Полагаем, что Вам будет интересно посмотреть материал «{$submissionTitle}» (авторы: {$authorName}), опубликованную в Томе {$volume}, № {$number} ({$year}) журнала «{$contextName}» по адресу &quot;{$articleUrl}&quot;.', 'Этот шаблон письма позволяет зарегистрированному читателю возможность отправить информацию о статье тому, кому она может быть интересна. Возможность доступна через «Инструменты читателя» и должна быть включена управляющим журнала на странице «Инструменты читателя: Администрирование».'),
('EMAIL_LINK', 'sk_SK', 'Zaujímavý článok', 'Myslím, že by Vás mohol zaujímať článok &quot;{$submissionTitle}&quot; autora {$authorName} vydaný v Vol {$volume}, No {$number} ({$year}) časopisu {$contextName} na adrese &quot;{$articleUrl}&quot;.', 'Táto emailová šablóna umožňuje registrovanému čitateľovi poslať informáciu o článku niekomu, koho by mohol zaujímať. Je dostupná cez Nástroje pre čítanie a musí byť povolená manažérom časopisu na stránke Správa nástrojov pre čítanie.'),
('EMAIL_LINK', 'sl_SI', 'Zanimiv prispevek', 'Zdelo se mi je, da vas morda zanima prispevek &quot;{$submissionTitle}&quot; avtorja {$authorName} objavljen v zvezku {$volume}, številka {$number} ({$year}) publikacije {$contextName} na voljo na URL povezavi &quot;<a href="{$articleUrl}">{$articleUrl}</a>&quot;.', 'Ta email pošlje registrirani bralec, kadar želi nekoga obvestiti o zanimivem prispevku. Email vsebuje nekaj informacij o prispevku in povezavo do prispevka. Ta funkcionalnost mora biti posebej vkljkučena med Orodji za branje in jo mora vključiti Administrator publikacije na strani z  nastavitvami za Orodja za branje.'),
('EMAIL_LINK', 'sv_SE', 'Artikel som kan vara av intresse för dig', 'Tänkte att du skulle kunna vara intresserad av artikeln &quot;{$submissionTitle}&quot; av {$authorName}, publicerad i vol. {$volume}, nr. {$number} ({$year}) av {$contextName} på &quot;{$articleUrl}&quot;.', 'Den här e-postmallen ger en registrerad läsare möjligheten att skicka information om en artikel till någon annan som hen tror kan vara intresserad. Den är tillgänglig via Läsverktyg och måste vara aktiverat av tidskriftsansvarig på administrationssidan för Läsverktyg.'),
('EMAIL_LINK', 'tr_TR', 'İlginizi çekebilecek bir makale', '<br />\n			{$contextName} {$volume}. cilt {$number}. sayısında ({$year}) {$authorName} tarafından yazılan <br />\n			&quot;{$submissionTitle}&quot; başlıklı bir makale yayınlamış.<br />\n			Bu çalışmanın ilgini çekeceğini umuyorum.', 'Okuyucuların, meslekdaşlarına ilgi çekici makaleleri haber vermeleri için hazır şablon mesaj. Dergi yöneticisi tarafında "Okuma Araçları" sayfasında bu özellik etkinleştirilince hizmete sunulur.'),
('EMAIL_LINK', 'uk_UA', 'Цікава стаття', 'Думаю, Вас може зацікавити стаття &quot;{$submissionTitle}&quot; автора {$authorName}, опублікована у Т. {$volume}, № {$number} видання &quot;{$contextName}&quot; за {$year} рік і доступна за адресою <a href="{$articleUrl}">{$articleUrl}</a>.', 'Цей шаблон листа надає зареєстрованому читачу можливість надсилати інформацію про статтю будь-яким зацікавленим особам. Ця функціональність доступна засобами панелі "Інструментарій читання"; менеджер журналу повинен дозволити цей інструмент на сторінці "Налаштування інструментів читання".'),
('EMAIL_LINK', 'vi_VN', 'Bài báo quan tâm', 'Tôi nghĩ rằng bạn có thể quan tâm &quot;{$submissionTitle}&quot; bởi {$authorName} xuất bản trong Vol {$volume}, No {$number} ({$year}) của {$contextName} tại &quot;{$articleUrl}&quot;.', 'Mẫu email này cung cấp cho người đọc đã đăng ký cơ hội gửi thông tin về một bài viết cho ai đó có thể quan tâm. Nó có sẵn thông qua Công cụ đọc và phải được Quản lý tạp chí kích hoạt trong trang Quản trị công cụ đọc.'),
('EMAIL_LINK', 'zh_CN', '您可能会感兴趣的期刊文章', '我想您会有兴趣想看看{$authorName}所写的〈{$submissionTitle}〉，刊行在《{$contextName}》 ，第{$volume}册，第{$number}期 ({$year}) 。网址为： &quot;{$articleUrl}&quot;.', '这份电子邮件样版让一个注册的读者有机会将有关一篇文章的相关信息寄给可能会感兴趣的人。这可以透过「阅读工具」进行，并且一定要由期刊管理员在「阅读工具管理」页面中启用这项功能。'),
('LAYOUT_COMPLETE', 'ar_IQ', 'التصميم الطباعي إكتمل', '{$editorialContactName}:<br />\n<br />\nالألواح الطباعية قد إكتمل تحضيرها للمؤلَّف الموسوم &quot;{$submissionTitle},&quot; والمرسل إلى {$contextName} وصارت جاهزة للمراجعة.<br />\n<br />\nإن كانت لديكم أي استفسارات، لطفاً، إتصلوا بي.<br />\n<br />\n{$participantName}', 'هذه الرسالة يعنونها المصمم الطباعي إلى محرر القسم يعلمه فيها بأن مهمة التحضير الطباعي لمؤلَّف معين قد إكتملت.'),
('LAYOUT_COMPLETE', 'bs_BA', 'Napravljen prijelom', 'Poštovana/i {$editorialContactName},<br />\n<br />\nprijelom priloga &quot;{$submissionTitle}&quot; za časopis {$contextName} je završen te spreman za korekturu.<br />\nU slučaju da imate bilo kakvih pitanja molim vas da mi se obratite.<br />\n<br />\nSrdačno,<br />\n{$participantName}<br />\n', 'Ova e-pošta urednika prijeloma uredniku rubrike obaviještava da je proces prijeloma završen.'),
('LAYOUT_COMPLETE', 'ca_ES', 'Galerades completades', 'Benvolgut/uda {$editorialContactName},<br />\n<br />\nJa he preparat les galerades del manuscrit &quot;{$submissionTitle}&quot; per a {$contextName}. Així, doncs, ja estan a punt per a entrar en el procés de correcció de proves.<br />\n<br />\nSi teniu qualsevol consulta, no dubteu a fer-me-la arribar.<br />\n<br />\n{$participantName}', 'Aquest missatge té el maquetista com a remitent i s''envia a l''editor de secció per a notificar-li que s''ha completat el procés de maquetació.'),
('LAYOUT_COMPLETE', 'cs_CZ', 'Sazebnice dokončeny', '{$editorialContactName}:<br />\n<br />\nNyní jsou vytvořeny sazebnicové verze souborů pro příspěvek &quot;{$submissionTitle}&quot; pro {$contextName} a jsou připraveny pro korektury.<br />\n<br />\nPokud máte nějaké otázky, kontaktujte mě prosím.<br />\n<br />\n{$participantName}', 'Tento email posílá typograf editorovi sekce, aby mu oznámil, že byl dokončen proces grafických úprav.'),
('LAYOUT_COMPLETE', 'da_DK', 'Publiceringsversion færdiggjort', '{$editorialContactName}:<br />\n<br />\nDer er nu indsat en publiceringsklar fil til manuskriptet &quot;{$submissionTitle}&quot; til {$contextName}, og den er klar til korrekturlæsning. <br />\n<br />\nHvis du har spørgsmål, er du velkommen til at kontakte mig.<br />\n<br />\n{$participantName}', 'Denne e-mail fra layoutredaktøren til sektionsredaktøren underretter sektionsredaktøren om, at layoutprocessen er fuldført.'),
('LAYOUT_COMPLETE', 'de_DE', 'Fahnen fertigestellt', '{$editorialContactName},<br />\n<br />\ndie Fahnen für das Manuskript &quot;{$submissionTitle}&quot; für {$contextName} sind fertig und stehen zum Korrekturlektorat bereit.<br />\n<br />\nFalls Sie Fragen haben, können Sie sich gerne an mich wenden.<br />\n<br />\n{$participantName}', 'Diese E-Mail von der/dem Layouter/in an die/den Rubrikredakteur/in benachrichtigt diese/n, dass der Layoutprozess abgeschlossen worden ist.'),
('LAYOUT_COMPLETE', 'el_GR', 'Ολοκλήρωση δημιουργίας τυπογραφικών δοκιμίων', '{$editorialContactName}:<br />\n<br />\nΤα τυπογραφικά δοκίμια της υποβολής &quot;{$submissionTitle},&quot; για το {$contextName} είναι έτοιμα για διορθώσεις.<br />\n<br />\nΕάν έχετε απορίες, παρακαλούμε επικοινωνήστε μαζί μας.<br />\n<br />\n{$participantName}', 'Το παρόν μήνυμα αποστέλλεται από τον Επιμελητή Σελιδοποίησης προς τον Επιμελητή Ενότητας, ως ενημέρωση για την ολοκλήρωση της διαδικασίας σελιδοποίησης.'),
('LAYOUT_COMPLETE', 'en_US', 'Galleys Complete', '{$editorialContactName}:<br />\n<br />\nGalleys have now been prepared for the manuscript, &quot;{$submissionTitle},&quot; for {$contextName} and are ready for proofreading.<br />\n<br />\nIf you have any questions, please contact me.<br />\n<br />\n{$participantName}', 'This email from the Layout Editor to the Section Editor notifies them that the layout process has been completed.');
INSERT INTO `email_templates_default_data` VALUES
('LAYOUT_COMPLETE', 'es_ES', 'Galeradas completadas', '{$editorialContactName}:<br />\n<br />\nYa han sido preparadas las galeradas para el manuscrito &quot;{$submissionTitle},&quot; para {$contextName} y están listas para corregir.<br />\n<br />\nSi tiene cualquier pregunta, no dude en contactar con nosotros/as.<br />\n<br />\n{$participantName}', 'Este correo electrónico es enviado por el/la Editor/a de Maquetación al / a la Editor/a de Sección notificándole que el proceso de maquetación ha finalizado.'),
('LAYOUT_COMPLETE', 'eu_ES', 'Galeradak eginda', '{$editorialContactName}:<br />\n<br />\n{$contextName} aldizkarirako &quot;{$submissionTitle}&quot; eskuizkribuaren galeradak eginda daude, proba-zuzenketa hasteko prest.<br />\n<br />\nGalderaren bat baduzu, jar zaitez harremanetan nirekin, mesedez.<br />\n<br />\n{$participantName}', 'Mezu hau Maketatzaileak Ataleko editoreari bidaltzen dio, maketazioa eginda dagoela jakinarazteko.'),
('LAYOUT_COMPLETE', 'fa_IR', 'نسخه های پیش از چاپ کامل شده است', '{$editorialContactName}:<br />\n<br />\nنسخه های پیش از چاپ مقاله ضضض مربوط به {$contextName} حاضر شده و آماده بررسی نهایی می باشد.<br />\nلطفا چنانچه سوالی دارید، با من تماس بگیرید.<br />\n<br />\n<br />\n{$participantName}', 'This email from the Layout Editor to the Section Editor notifies them that the layout process has been completed.'),
('LAYOUT_COMPLETE', 'fi_FI', 'Julkaistavat tiedostot valmiita', 'Hyvä {$editorialContactName},<br />\n<br />\nJulkaisuun {$contextName} liittyvän käsikirjoituksen &quot;{$submissionTitle}&quot; julkaistavat tiedostot on nyt taitettu ja ne ovat valmiit oikolukua varten.<br />\n<br />\nMikäli teillä on kysyttävää, otattehan minuun yhteyttä.<br />\n<br />\n{$participantName}', 'This email from the Layout Editor to the Section Editor notifies them that the layout process has been completed.'),
('LAYOUT_COMPLETE', 'fr_CA', 'Mise en page des épreuves terminée', '{$editorialContactName},<br />\n<br />\nLes épreuves du manuscrit intitulé « {$submissionTitle} » pour la revue {$contextName} sont maintenant prêtes pour la relecture.<br />\n<br />\nSi vous avez des questions, n''hésitez pas à communiquer avec moi.<br />\n<br />\n{$participantName}', 'Ce courriel du,de la responsable de la mise en page au,à la rédacteur-trice de rubrique l''avise que l''étape de mise en page est complétée.'),
('LAYOUT_COMPLETE', 'fr_FR', 'Mise en page des épreuves terminée', '{$editorialContactName}:<br />\n<br />\nLes épreuves du manuscrit intitulé « {$submissionTitle} » pour {$contextName} sont maintenant prêtes pour la révision.<br />\n<br />\nSi vous avez des questions, n''hésitez pas à communiquer avec moi.<br />\n<br />\n{$participantName}', 'Ce courriel du Responsable de la mise en page au Rédacteur de rubrique l''avise que le processus de la mise en page est terminé.'),
('LAYOUT_COMPLETE', 'gd_GB', 'Tha na mòr-dhuilleagan deiseil', '{$editorialContactName}:<br />\n<br />\nChaidh na mòr-dhuilleagan a dheasachadh airson na sgrìobhainn a-nis, “{$submissionTitle},” airson {$contextName} agus tha iad deiseil airson dearbh-leughadh.<br />\n<br />\nMa tha ceist sam bith agad, cuir fios thugam.<br />\n<br />\n{$participantName}', 'Tha am post-d seo o dheasaiche na co-dhealbhachd do dheasaiche na h-earrainn ag innse dhaibh gun deach obair na co-dhealbhachd a choileanadh.'),
('LAYOUT_COMPLETE', 'hi_IN', 'गैलीज़ पूर्ण', '{$editorialContactName}:<br />\n<br />\nपांडुलिपि के लिए अब गैलीज़  तैयार की गई हैं, &quot;{$submissionTitle},&quot; for {$contextName} and are ready for proofreading.<br />\n<br />\nयदि आपके पास किसी तरह का प्रश्न है, तो कृपया मुझ से सम्पर्क करें.<br />\n<br />\n{$participantName}', 'लेआउट संपादक से अनुभाग संपादक का यह ईमेल उन्हें सूचित करता है कि लेआउट प्रक्रिया पूरी हो गई है.'),
('LAYOUT_COMPLETE', 'hr_HR', 'Napravljen prijelom', 'Poštovana/i {$editorialContactName},<br />\n<br />\nprijelom priloga &quot;{$submissionTitle}&quot; za časopis {$contextName} je završen te spreman za korekturu.<br />\nU slučaju da imate bilo kakvih pitanja molim vas da mi se obratite.<br />\n<br />\nSrdačno,<br />\n{$participantName}<br />\n', 'Ova e-pošta urednika prijeloma uredniku rubrike obaviještava da je proces prijeloma završen.'),
('LAYOUT_COMPLETE', 'hu_HU', 'A tördelt változat elkészült', 'Tisztelt {$editorialContactName}!<br />\n<br />\nA(z) &quot;{$submissionTitle},&quot; című kézirat tördelt változata elkészült a(z) {$contextName} folyóiratnál, és készen áll a korrektúrázásra.<br />\n<br />\nHa kérdése merül fel, kérem, keressen meg.<br />\n<br />\nÜdvözlettel,<br />\n{$participantName}', 'Ezt az emailt a Tördelőszerkesztő küldi a Rovatszerkesztőnek, értesítve, hogy a tördelési munka befejeződött.'),
('LAYOUT_COMPLETE', 'id_ID', 'Galley Selesai', '{$editorialContactName}:<br />\n<br />\nGalley telah dipersiapkan bagi naskah, &quot;{$submissionTitle},&quot; di {$contextName} dan siap untuk proofreading.<br />\n<br />\nJika ada pertanyaan, silakan hubungi kami.<br />\n<br />\n{$participantName}', 'Email from the Layout Editor kepada Editor Bagian memberitahukan bahwa proses layout telah selesai.'),
('LAYOUT_COMPLETE', 'it_IT', 'Bozze pronte', '{$editorialContactName}:<br />\n<br />\nSono pronte le bozze dell''articolo, &quot;{$submissionTitle}&quot; per {$contextName}, a disposizione per i correttori di bozze.<br />\n<br />\nPer qualsiasi domanda, si prega di contattarmi.<br />\n<br />\n{$participantName}', 'Questa email dal layout editor al section editor notifica che il processo di layout è stato completato.'),
('LAYOUT_COMPLETE', 'ja_JP', 'ゲラ作成の完了', '{$editorialContactName}様:<br />\n<br />\n雑誌『{$contextName}』への投稿原稿「{$submissionTitle}」のゲラを作成し、校正作業の準備ができたことをご報告いたします。<br />\n<br />\n何かご不明な点がございましたら、ご連絡ください。よろしくお願いいたします。<br />\n<br />\n{$participantName}', 'このメールは、レイアウトエディタからセクションエディタにレイアウト処理が終了したことを通知するものです。'),
('LAYOUT_COMPLETE', 'ku_IQ', 'تابلۆسازی تەواوە', '{$editorialContactName}:<br />\n<br />\nتابلۆ بۆ ڕەشنوسی توێژینەوەی &quot;{$submissionTitle},&quot; ئامادە کراوە بۆ{$contextName} و ئامادەیە بۆ وردبینیکردن<br />\n<br />\nئەگەر هەر پرسیارێکت هەیە، تکایە پەیوەندیم پێوە بکە.<br />\n<br />\n{$participantName}', 'ئەم ئیمەیڵە لە نەخشەسازەوە بۆ سەرنوسەرە بۆ ئاگادارکردنەوەیان لە تەواوبونی کاری نەخشەسازی.'),
('LAYOUT_COMPLETE', 'mk_MK', 'Отисоците се завршени', '{$editorialContactName}:<br />\n<br />\nПодготвени се отисоците за трудот, &quot;{$submissionTitle},&quot; за {$contextName} и се спремни за лекторирање.<br />\n<br />\nДоколку имате дополнителни прашања, ве молам да ме контактирате.<br />\n<br />\n{$participantName}', 'Овој и-меил од Уредник за распоред до Секциски уредник ги известува дека процесот на рапоредување е завршен.'),
('LAYOUT_COMPLETE', 'nb_NO', 'Oppsett ferdigstilt', '{$editorialContactName}:<br />\n<br />\nEt publiseringsklart oppsett av manuskriptet «{$submissionTitle}» er nå ferdig for {$contextName}, og klart for korrekturlesing.<br />\n<br />\nTa kontakt om du har noen spørsmål.<br />\n<br />\n{$participantName}', 'Denne e-posten fra layoutredaktøren til seksjonsredaktøren varsler om at oppsettet er ferdigstilt.'),
('LAYOUT_COMPLETE', 'nl_NL', 'Proeven gereed', '{$editorialContactName}:<br />\n<br />\nDe proeven voor manuscript &quot;{$submissionTitle}&quot; voor {$contextName} zijn gereed voor proeflezen.<br />\n<br />\nNeemt u alstublieft contact met me op als u vragen heeft.<br />\n<br />\n{$participantName}', 'Deze e-mail van de opmaakredacteur aan de sectieredacteur bericht dat het opmaakproces is voltooid.'),
('LAYOUT_COMPLETE', 'pl_PL', 'Ukończony skład', 'Szanowna Pani/ Szanowny Panie {$editorialContactName},<br />\n<br />\nukończyłem/am pracę nad składem tekstu &quot;{$submissionTitle},&quot; tekst jest gotowy do ostatniego sczytania. <br />\n<br />\nW razie dodatkowych pytań proszę o kontakt.<br />\n<br />\n{$participantName}', 'Wiadomość jest wysyłana przez składacza do redaktora prowadzącego. Zawiera informację o ukończeniu składu.'),
('LAYOUT_COMPLETE', 'pt_BR', 'Composições concluídas', '{$editorialContactName}: <br />\n<br />\nAs provas topográficas já foram preparadas para o manuscrito &quot;{$submissionTitle} &quot; para {$contextName} e estão prontas para a revisão.<br />\n<br />\nSe você tiver alguma dúvida, favor entrar em contato comigo. <br />\n<br />\n{$participantName}', 'Mensagem enviada pelo Editor de Layout ao Editor de Seção, informando sobre a conclusão das composições.'),
('LAYOUT_COMPLETE', 'pt_PT', 'Composições concluídas', '{$editorialContactName},<br />\n<br />\nAs composições do manuscrito &quot;{$submissionTitle}&quot;, submetido à revista {$contextName}, estão prontas para leitura de provas.<br />\n<br />\nEm caso de dúvidas, entre em contacto.<br />\n<br />\n{$participantName}', 'Este e-mail é enviado pelo Editor de Layout ao Editor de Secção, informando sobre a conclusão das composições.'),
('LAYOUT_COMPLETE', 'ro_RO', 'Galerie completă', '{$editorialContactName}:<br />\n<br />\nGaleriile sunt pregătite pentru acest manuscris, &quot;{$submissionTitle},&quot; pentru {$contextName} și sunt gata pentru corectură.<br />\n<br />\nDacă aveți întrebări, vă rog să mă contactați.<br />\n<br />\n{$participantName}', 'Acest e-mail de la Editorul de Layout către Editorul de Secțiuni îl notifică că procesul de layout a fost finalizat.'),
('LAYOUT_COMPLETE', 'ru_RU', 'Гранки сделаны', 'Здравствуйте, {$editorialContactName}!<br />\n<br />\nГранки для материала «{$submissionTitle}» в журнал «{$contextName}» уже готовы, можно начинать корректуру.<br />\n<br />\nЕсли у Вас есть какие-либо вопросы, пожалуйста, свяжитесь со мной.<br />\n<br />\n{$participantName}', 'Это письмо верстальщика, отправляемое редактору раздела с уведомлением о том, что верстка завершена.'),
('LAYOUT_COMPLETE', 'sk_SK', 'Sadzobnice dokončené', '{$editorialContactName}:<br />\n<br />\nTeraz sú vytvorené sadzobnicové verzie súborov pre príspevok &quot;{$submissionTitle}&quot; pre {$contextName} a sú pripravené pre korektúry.<br />\n<br />\nAk máte nejaké otázky, kontaktujte ma prosím.<br />\n<br />\n{$participantName}', 'Tento email posiela typograf editorovi sekcie, aby mu oznámil, že bol dokončený proces grafických úprav.'),
('LAYOUT_COMPLETE', 'sl_SI', 'Prelom končan', '{$editorialContactName}:<br />\n<br />\nPrelom za prispevka, &quot;{$submissionTitle},&quot; za publikacijo {$contextName} je končan in pripravljen za korekturo.<br />\n<br />\nČe imate kakšna vprašanja, se prosim obrnite name.<br />\n<br />\n{$participantName}', 'Ta email pošlje grafični urednik uredniku prispevka z obvestilom, da je prelom prispevka končan.'),
('LAYOUT_COMPLETE', 'sv_SE', 'Publiceringsversioner klara', '{$editorialContactName}:<br />\n<br />\nPubliceringsversioner har nu färdigställts för manuskriptet &quot;{$submissionTitle}&quot; hos {$contextName}. Dessa är nu redo för korrekturläsning.<br />\n<br />\nVänligen kontakta mig om du har några frågor.<br />\n<br />\n{$participantName}', 'Det här e-postmeddelandet från layoutredaktören till sektionsredaktören för att meddela hen att layoutprocessen färdig.'),
('LAYOUT_COMPLETE', 'tr_TR', 'Prova dizgi tamamlandı', 'Sayın {$editorialContactName},<br />\n<br />\n{$contextName} için &quot;{$submissionTitle}&quot; başlıklı çalışmanın prova dizgisi gözden geçirme için hazırdır.<br />\n<br />\nSorunuz olur ise bana yazabilirsiniz.<br />\n<br />\n{$participantName}', 'Editöre prova dizginin tamamlandığını bildirir.'),
('LAYOUT_COMPLETE', 'uk_UA', 'Верстка завершена', '{$editorialContactName}:<br />\n<br />\nГранки рукопису &quot;{$submissionTitle}&quot; для видання &quot;{$contextName}&quot; створені і подання готове до процесу коректури. <br />\n<br />\nБудь ласка, повідомте мені, якщо Ви маєте додаткові запитання.<br />\n<br />\n{$participantName}', 'Цим листом редактор верстки повідомляє редактора розділу про закінчення процесу верстки.'),
('LAYOUT_COMPLETE', 'vi_VN', 'Hoàn thành bản in', 'Kính gửi {$editorialContactName},<br />\n<br />\nBản in hiện đã được chuẩn bị cho bản thảo, &quot;{$submissionTitle},&quot; của {$contextName} và sẵn sàng cho hiệu đính.<br />\n<br />\nNếu bạn có bất kỳ câu hỏi nào, xin vui lòng liên hệ với chúng tôi.<br />\n<br />\n{$participantName}', 'Email này từ Biên tập viên trình bày cho Biên tập viên chuyên mục thông báo rằng quá trình dàn trang đã được hoàn thành.'),
('LAYOUT_COMPLETE', 'zh_CN', '已完成制版', '{$editorialContactName}:<br />\n<br />\n目前已经为投稿《{$contextName}》的稿件〈{$submissionTitle}〉完成制版工作，可以进行校对工作了。<br />\n<br />\n如果您有任何问题，请与我们联络。<br />\n<br />\n{$participantName}', '这封电子邮件是由版面编辑寄发给区段编辑，通知他们排版流程已经完成。'),
('LAYOUT_REQUEST', 'ar_IQ', 'إلتماس التنضيد الطباعي', '{$participantName}:<br />\n<br />\nإن المؤلَّف الموسوم &quot;{$submissionTitle}&quot; والمرسل إلى {$contextName} يحتاج الآن إلى تهيئة إخراجه الطباعي عبر اتباع الخطوات الآتية:<br />\n1. أنقر على رابط طلب النشر أدناه.<br />\n2. أدخل إلى موقع المجلة واستعمل النسخة المحضرة للمعالجة الطباعية لصناعة اللوح الطباعي المتوافق مع معايير المجلة.<br />\n3. إرفع هذه الألواح إلى قسم ملفات الألواح.<br />\n4. أبلغ المحرر مستعملاً محاورات الإنتاج بأن الألواح الطباعية مرفوعة وجاهزة.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nرابط الطلب: {$submissionUrl}<br />\nاسم الدخول: {$participantUsername}<br />\n<br />\nلو تعذر عليك تولي هذه المهمة حالياً أو كان لديك أية أسئلة، لطفاً لا تترد في مراسلتي. نشكر لك مساهمتك في هذه المجلة.', 'هذه الرسالة يعنونها محرر القسم إلى المصمم الطباعي معلماً إياه بتعيينه لمهمة التصميم الطباعي لمؤلَّفٍ معين، وهي توفر له رابط الوصول إلى الملف المعني في موقع المجلة.'),
('LAYOUT_REQUEST', 'bs_BA', 'Zamolba za prijelom', 'Poštovana/i {$participantName},<br />\n<br />\nmolim vas da pripremite prijelom priloga &quot;{$submissionTitle}&quot; za časopis {$contextName}.<br />\n<br />\nURL rukopisa: {$submissionUrl}<br />\nKorisničko ime: {$participantUsername}<br />\n<br />\nU slučaju da trenutačno niste u mogućnosti preuzeti ovu obavezu ili ako imate bilo kakvih dodatnih pitanja, molim vas da mi se obratite.<br />\n<br />\nSrdačno,', 'Ovim obrascem e-pošte urednik rubrike obavještava grafičkog urednika da mu je dodijeljen zadatak  izrade prijeloma priloga.'),
('LAYOUT_REQUEST', 'ca_ES', 'Sol·licitud de galerades', '{$participantName}:<br />\n<br />\nUs demanem que us encarregueu de preparar les galerades de la tramesa &quot;{$submissionTitle}&quot; per a {$contextName} seguint els passos següents:<br />\n1. Feu clic a l''URL de la tramesa que trobareu més avall en aquest missatge.<br />\n2. Inicieu la sessió a la revista i utilitzeu els arxius llestos per a producció per crear les galerades d''acord amb els estàndards de la revista.<br />\n3. Carregueu les galerades en la secció d''arxius de galerada.<br />\n4. Notifiqueu a l''editor/a a través de les discussions de producció que les galerades ja estan preparades i carregades.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nURL de la tramesa: {$submissionUrl}<br />\nNom d''ausuari/ària: {$participantUsername}<br />\n<br />\nSi no esteu disponible per dur a terme aquesta tasca o si teniu cap pregunta, no dubteu a contactar-me. Gràcies per la vostra contribució a aquesta revista.', 'Aquest missatge de correu electrònic té l''editor de secció com a remitent i s''envia al maquetador per a notificar-li que ha estat assignat per a encarregar-se de la maquetació d''una tramesa. Proporciona informació sobre la tramesa i com s''hi ha d''accedir.'),
('LAYOUT_REQUEST', 'cs_CZ', 'Žádost o sazebnice', '{$participantName}:<br />\n<br />\nPříspěvek &quot;{$submissionTitle}&quot; pro {$contextName} je nyní třeba připravit do sazenicového formátu podle následujících instrukcí.<br />\n1. Klikněte níže na URL příspěvku.<br />\n2. Přihlaste se do časopisu a pro vytvoření sazebnice podle standardů časopisu použijte verzi souboru pro grafické úpravy.<br />\n3. Nahrajte upravené soubory do sekce Soubory sazebnic.<br />\n4. Upozorněteč redaktora pomocí diskuse v produkční fázi, že sazebnice jsou hotové.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nURL příspěvku: {$submissionUrl}<br />\nUživatelské jméno: {$participantUsername}<br />\n<br />\nPokud nyní nemůžete tento úkol provést nebo máte nějaké dotazy, kontaktujte mě prosím. Děkujeme za Vaši pomoc našemu časopisu.', 'Tento email posílá editor sekce typografovi, aby mu oznámil, že mu byl přidělen úkol provést typografické úpravy příspěvku. Obsahuje informace o příspěvku a přístupu k němu.'),
('LAYOUT_REQUEST', 'da_DK', 'Forespørgsel om publiceringsversion', '{$participantName}:<br />\n<br />\nIndsendelsen &quot;{$submissionTitle}&quot; til {$contextName} skal nu gøres publiceringsklar ved at følge disse trin.<br />\n1. Klik på manuskriptets URL-adresse nedenfor.<br />\n2. Hent filerne placeret under ‘Produktionsklare filer’ og formater dem til publiceringsklare filer i overensstemmelse med tidsskriftets krav.<br />\n3. Upload de publiceringsklare filer via linket ‘Tilføj publiceringsversion’.<br />\n4. Giv redaktøren besked når publiceringsversionen er klar via linket ‘Tilføj indlæg’ under ‘Drøftelser under produktion’.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nSubmission URL: {$submissionUrl}<br />\nUsername: {$participantUsername}<br />\n<br />\nHvis du ikke er i stand til at påtage dig dette arbejde på nuværende tidspunkt eller har spørgsmål, bedes du kontakte mig. Tak for dit bidrag til dette tidsskrift.', 'Denne e-mail fra sektionsredaktøren til layoutredaktøren underretter layoutredaktøren om, at han/hun har fået til opgave at foretage layoutredigering af et manuskript. Den indeholder oplysninger om manuskriptet og om, hvordan der oprettes adgang til det.'),
('LAYOUT_REQUEST', 'de_DE', 'Bitte um Layout', '{$participantName},<br />\n<br />\nich bitte Sie um das Layout der Fahnen für das Manuskript &quot;{$submissionTitle}&quot; für {$contextName}. Bitte gehen Sie folgendermaßen vor:<br />\n<br />\n1. Klicken Sie auf die unten stehende URL des Beitrags.<br />\n2. Loggen Sie sich bei der Zeitschrift ein und verwenden Sie die Datei der Layout-Fassung, um die Fahne entsprechend den Vorgaben der Zeitschrift zu erstellen.<br />\n3. Schicken Sie die ABGESCHLOSSEN-E-Mail an die Redaktion.<br />\n<br />\nURL {$contextName}: {$contextUrl}<br />\nURL des Beitrags: {$submissionUrl}<br />\nBenutzer/innenname: {$participantUsername}<br />\n<br />\nFalls Sie zur Zeit nicht in der Lage sein sollten, die Arbeit zu übernehmen, oder Fragen haben, geben Sie mir bitte Bescheid. Vielen Dank für Ihre Unterstützung dieser Zeitschrift.', 'Diese E-Mail von der/dem Rubrikredakteur/in an die/den Layouter/in benachrichtigt diese/n, dass ihr/ihm die Aufgabe zugewiesen wird, einen Beitrag zu layouten. Sie liefert Informationen über den Beitrag und darüber, wie auf ihn zugegriffen werden kann.'),
('LAYOUT_REQUEST', 'el_GR', 'Αίτημα σελιδοποίησης', '{$participantName}:<br />\n<br />\nΓια την υποβολή &quot;{$submissionTitle}&quot; στο περιοδικό {$contextName} χρειάζεται να δημιουργηθούν τα τυπογραφικά δοκίμια, ακολουθώντας τα παρακάτω βήματα.<br />\n1. Πατήστε στο σύνδεσμο της υποβολής, παρακάτω.<br />\n2. Συνδεθείτε στο περιοδικό και χρησιμοποιήστε τα αρχεία που είναι "Έτοιμα για Παραγωγή", για τη δημιουργία των τυπογραφικών δοκιμίων, σύμφωνα με τα πρότυπα του περιοδικού.<br />\n3. Μεταφορτώστε τα τυπογραφικά δοκίμια στην ενότητα "Αρχεία Τυπογραφικών Δοκιμίων".<br />\n4. Ειδοποιήστε τον Επιμελητή, χρησιμοποιώντας τη "Συζήτηση σχετικά με την Παραγωγή", ότι τα τυπογραφικά δοκίμια είναι έτοιμα και αναρτημένα.<br />\n<br />\nΣύνδεσμος περιοδικού {$contextName}: {$contextUrl}<br />\nΣύνδεσμος υποβολής: {$submissionUrl}<br />\nΌνομα χρήστη: {$participantUsername}<br />\n<br />\nΕάν δεν μπορείτε να αναλάβετε τη συγκεκριμένη εργασία αυτή τη στιγμή ή έχετε απορίες, παρακαλούμε επικοινωνήστε μαζί μας. Ευχαριστούμε για τη συμβολή σας στην έκδοση του περιοδικού.', 'Το παρόν μήνυμα αποστέλλεται από τον Επιμελητή Ενότητας στον Επιμελητή Σελιδοποίησης ως ανάθεση της επιμέλειας σελιδοποίησης μίας υποβολής. Παρέχει πληροφορίες σχετικά με την υποβολή και τον τρόπο πρόσβασης σε αυτήν.'),
('LAYOUT_REQUEST', 'en_US', 'Request Galleys', '{$participantName}:<br />\n<br />\nThe submission &quot;{$submissionTitle}&quot; to {$contextName} now needs galleys laid out by following these steps.<br />\n1. Click on the Submission URL below.<br />\n2. Log into the journal and use the Production Ready files to create the galleys according to the journal''s standards.<br />\n3. Upload the galleys to the Galley Files section.<br />\n4. Notify the Editor using Production Discussions that the galleys are uploaded and ready.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nSubmission URL: {$submissionUrl}<br />\nUsername: {$participantUsername}<br />\n<br />\nIf you are unable to undertake this work at this time or have any questions, please contact me. Thank you for your contribution to this journal.', 'This email from the Section Editor to the Layout Editor notifies them that they have been assigned the task of performing layout editing on a submission. It provides information about the submission and how to access it.'),
('LAYOUT_REQUEST', 'es_ES', 'Solicitud de galeradas', '{$participantName}:<br />\n<br />\n\nEl envío &quot;{$submissionTitle}&quot; a {$contextName} ahora necesita que prepare las galeradas siguiendo los siguientes pasos.<br />\n1. Haga click en la URL del envío que hay a continuación.<br />\n2. Entre a la revista con su usuario y utilice los ficheros preparados para publicación para crear las galeradas de acuerdo a los estándares de la revista.<br />\n3. Suba las galeradas a la sección de ficheros de galerada.<br />\n4. Notifique al Editor de que las galeradas están subidas y listas.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nURL de envío: {$submissionUrl}<br />\nUsuario: {$participantUsername}<br />\n<br />\nSi no puede llevar a cabo este trabajo en este momento o tiene cualquier pregunta, póngase en contacto con nosotros/as. Gracias por su contribución a la revista.', 'Este correo electrónico es enviado por el/ la Editor/a de Sección al / a la Editor/a de Maquetación notificándole que se les ha asignado la tarea de editar la maquetación de un envío. Le proporciona información sobre el envío y cómo acceder a él.'),
('LAYOUT_REQUEST', 'eu_ES', 'Galeradak eskatzea', '{$participantName}:<br />\n<br />\n{$contextName} aldizkarirako &quot;{$submissionTitle}&quot; artikuluaren galeradak egin behar dira orain, urrats hauei jarraituz:<br />\n1. Egin klik behean, Artikuluaren URLan.<br />\n2. Sartu aldizkarian eta erabili Maketazio-bertsioko fitxategia, aldizkariaren arauen araberako galeradak prestatzeko.<br />\n3. Bidali BUKATU duzula adierazteko mezua editoreari.<br />\n<br />\n{$contextName} aldizkariaren URLa: {$contextUrl}<br />\nArtikuluaren URLa: {$submissionUrl}<br />\nErabiltzaile-izena: {$participantUsername}<br />\n<br />\nOrain ezin badiozu lan honi heldu, edo galderaren bat egin nahi badiguzu, jar zaitez harremanetan nirekin, mesedez. Eskerrik asko aldizkariari egiten diozun ekarpenagatik.', 'Mezu hau Ataleko editoreak Maketatzaileari bidaltzen dio, artikuluaren maketazioa egin dezala eskatzeko. Artikuluari buruzko informazioa eta fitxategia hartzeko datuak ematen ditu.'),
('LAYOUT_REQUEST', 'fa_IR', 'نسخه های پیش از چاپ مورد نیاز است', '{$participantName}:<br />\n<br />\nاز شما درخواست می شود که نسخه های پیش از چاپ مقاله &quot;{$submissionTitle}&quot; مربوط به {$contextName} را آماده نمایید.<br />\n<br />\nآدرس مقاله: <a href="{$submissionUrl}">{$submissionUrl}</a><br />\nنام کاربری: {$participantUsername}<br />\n<br />\nچنانچه در حال حاضر قادر به انجام این امور نیستید و یا سوالی در این رابطه دارید با من تماس بگیرید. پیشاپیش از همکاری شما با این مجله سپاسگزارم.', 'This email from the Section Editor to the Layout Editor notifies them that they have been assigned the task of performing layout editing on a submission. It provides information about the submission and how to access it.'),
('LAYOUT_REQUEST', 'fi_FI', 'Julkaistavia tiedostoja pyydetään', 'Hyvä {$participantName},<br />\n<br />\nJulkaisuun {$contextName} liittyvä käsikirjoitus &quot;{$submissionTitle}&quot; tulee nyt taittaa julkaistaviksi tiedostoiksi, seuraavia vaiheita noudattaen:<br />\n1. Klikatkaa alla olevaa käsikirjoituksen URL-osoitetta.<br />\n2. Kirjautukaa julkaisuun ja käyttäkää tuotantovalmiita tiedostoja laatiaksenne julkaistavat tiedostot julkaisun standardien mukaisesti.<br />\n3. Ladatkaa valmiit tiedostot Julkaistavat tiedostot -osioon.<br />\n4. Ilmoittakaa toimittajalle Tuotantoon liittyvien keskustelujen kautta, että julkaistavat tiedostot ovat valmiit ja ne on ladattu.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nKäsikirjoituksen URL: {$submissionUrl}<br />\nKäyttäjätunnus: {$participantUsername}<br />\n<br />\nMikäli ette voi ryhtyä tähän tehtävään juuri nyt, tai  jos teillä on kysyttävää, otattehan minuun yhteyttä. Kiitos panoksestanne tämän julkaisun hyväksi.', 'This email from the Section Editor to the Layout Editor notifies them that they have been assigned the task of performing layout editing on a submission. It provides information about the submission and how to access it.'),
('LAYOUT_REQUEST', 'fr_CA', 'Demande de mise en page des épreuves', '{$participantName},<br />\n<br />\nJ''aimerais que vous prépariez les épreuves du manuscrit intitulé « {$submissionTitle} » pour la revue {$contextName} à l''aide des étapes suivantes.<br />\n1. Cliquer sur l''URL de la soumission ci-dessous.<br />\n2. Se connecter au site Web de la revue et utiliser les fichiers disponibles sous Fichiers prêts pour la production pour créer les épreuves en fonction des normes de la revue.<br />\n3. Téléverser les épreuves dans la section Épreuves.<br />\n4. Informer le,la rédacteur-trice, via une discussion sur la production, que les épreuves ont été téléversées et qu''elles sont prêtes.<br />\n<br />\nURL de la revue {$contextName} : {$contextUrl}<br />\nURL du manuscrit : {$submissionUrl}<br />\nNom d''utilisateur-trice : {$participantUsername}<br />\n<br />\nSi vous ne pouvez pas effectuer ce travail pour le moment ou si vous avez des questions, veuillez communiquer avec moi. Je vous remercie de votre collaboration.', 'Ce courriel du,de la rédacteur-trice de rubrique au, à la responsable de la mise en page l''avise qu''il ou elle a été assigné-e à la réalisation de la mise en page de la soumission. Il fournit les renseignements sur la soumission et comment accéder à celle-ci.'),
('LAYOUT_REQUEST', 'fr_FR', 'Demande de mise en page des épreuves', '{$participantName},<br />\n<br />\nJ''aimerais que vous prépariez les épreuves du manuscrit intitulé « {$submissionTitle} » pour la revue {$contextName} à l''aide des étapes suivantes.<br />\n1. Cliquer sur l''URL de la soumission ci-dessous.<br />\n2. Se connecter au site Web de la revue et utiliser les fichiers disponibles sous Fichiers prêts pour la production pour créer les épreuves en fonction des normes de la revue.<br />\n3. Téléverser les épreuves dans la section Épreuves.<br />\n4. Informer le rédacteur ou la rédactrice, via une discussion sur la production, que les épreuves ont été téléversées et qu''elles sont prêtes.<br />\n<br />\nURL de la revue {$contextName} : {$contextUrl}<br />\nURL du manuscrit : {$submissionUrl}<br />\nNom d''utilisateur-trice : {$participantUsername}<br />\n<br />\nSi vous ne pouvez pas effectuer ce travail pour le moment ou si vous avez des questions, veuillez communiquer avec moi. Je vous remercie de votre collaboration.', 'Ce courriel envoyé par le Rédacteur de rubrique au Responsable de la mise en page, avise ce dernier qu''il a été assigné à la tâche de faire la mise en page de la soumission. Il fournit de l''information sur la soumission et comment y accéder.'),
('LAYOUT_REQUEST', 'gd_GB', 'Iarr na mòr-dhuilleagan', '{$participantName}:<br />\n<br />\nTha an tagradh “{$submissionTitle}” airson {$contextName} feumach air obair co-dhealbhachd air na mòr-dhuilleagan a rèir nan ceuman a leanas.<br />\n1. Briog air URL an tagraidh gu h-ìosal.<br />\n2. Clàraich a-steach dhan iris-leabhar agus cleachd na faidhlichean a tha deiseil airson saothrachadh airson mòr-dhuilleagan a chruthachadh a rèir riaghailtean an iris-leabhair.<br />\n3. Luchdaich na mòr-dhuilleagan suas gu earrann faidhlichean nam mòr-dhuilleag.<br />\n4. Cuir fios chun an deasaiche gun deach na mhòr-dhuilleaganan a luchdadh suas is deiseil slighe nan deasbadan saothrachaidh.<br />\n<br />\nURL {$contextName}: {$contextUrl}<br />\nURL an tagraidh: {$submissionUrl}<br />\nAinm-cleachdaiche: {$participantUsername}<br />\n<br />\nMur urrainn dhut an obair seo a dhèanamh an-dràsta fhèin no ma tha ceist sam bith agad, cuir fios thugam. Mòran taing airson taic a chumail ris an iris-leabhar seo.', 'Tha am post-d seo o dheasaiche na h-earrainn gu deasaiche na co-dhealbhachd ag innse gun deach obair deasachadh na co-dhealbhachd iomruineadh dhaibh ann an tagradh foillseachaidh. Tha e a’ toirt seachad fiosrachadh mun tagradh agus mar a gheibhear cothrom air.'),
('LAYOUT_REQUEST', 'hi_IN', 'अनुरोध गैलीज़', '{$participantName}:<br />\n<br />\nThe submission &quot;{$submissionTitle}&quot; to {$contextName} अब इन चरणों का पालन करके गैलियों की जरूरत है.<br />\n1. नीचे दिए गए सबमिशन यूआरएल पर क्लिक करें.<br />\n2. जर्नल में लॉग इन करें और जर्नल के मानकों के अनुसार गैलिलियों को बनाने के लिए प्रोडक्शन रेडी फाइलों का उपयोग करें.<br />\n3. गैलीज़ को गैली फ़ाइल्स अनुभाग में अपलोड करें.<br />\n4. प्रोडक्शन डिस्कशन का उपयोग करके संपादक को सूचित करें कि गैलिसियां अपलोड और तैयार हैं.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nSubmission URL: {$submissionUrl}<br />\nUsername: {$participantUsername}<br />\n<br />\nयदि आप इस समय यह कार्य करने में असमर्थ हैं या कोई प्रश्न हैं, तो कृपया मुझसे संपर्क करें। इस जर्नल में आपके योगदान के लिए धन्यवाद.', 'अनुभाग संपादक से लेआउट संपादक का यह ईमेल उन्हें सूचित करता है कि उन्हें एक सबमिशन पर लेआउट एडिटिंग का कार्य सौंपा गया है। यह सबमिशन और इसे एक्सेस करने के तरीके के बारे में जानकारी प्रदान करता है.'),
('LAYOUT_REQUEST', 'hr_HR', 'Zamolba za prijelom', 'Poštovana/i {$participantName},<br />\n<br />\nmolim vas da pripremite prijelom priloga &quot;{$submissionTitle}&quot; za časopis {$contextName}.<br />\n<br />\nURL rukopisa: {$submissionUrl}<br />\nKorisničko ime: {$participantUsername}<br />\n<br />\nU slučaju da trenutačno niste u mogućnosti preuzeti ovu obavezu ili ako imate bilo kakvih dodatnih pitanja, molim vas da mi se obratite.<br />\n<br />\nSrdačno,', 'Ovim obrascem e-pošte urednik rubrike obavještava grafičkog urednika da mu je dodijeljen zadatak  izrade prijeloma priloga.'),
('LAYOUT_REQUEST', 'hu_HU', 'Tördelés kérése', 'Tisztelt {$participantName}!<br />\n<br />\nA(z) {$contextName} folyóirat &quot;{$submissionTitle}&quot; című kézirata tördelési munkára vár, mely a következő lépésekkel végezhető el.<br />\n1. Kattintson a kézirat URL címére alább.<br />\n2. Lépjen be a folyóirathoz és használja a megjelentetésre kész fájlokat a folyóirat szabályai szerinti tördelés elkészítéséhez.<br />\n3. Töltse fel a megjelentetési formátumokat a Tördelési szakaszhoz.<br />\n4. Értesítse a Szerkesztőt, hogy kész a tördelés, ehhez használja a Megjelentetési párbeszéd funkciót.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nKézirat URL címe: {$submissionLayoutUrl}<br />\nFelhasználói név: {$participantUsername}<br />\n<br />\nHa kérdése merülne fel, kérem keressen meg. Köszönöm a folyóiratnál végzett munkáját.<br />\n<br />\nÜdvözlettel,<br />\n{$editorialContactSignature}', 'Ez az email a Rovatszerkesztőtől érkezik a Tördelőszerkesztőnek, jelezve, hogy a cikk tördelési munkájára őt jelölték ki. A levél információkat tartalmaz a kézirat elérésével kapcsolatban.'),
('LAYOUT_REQUEST', 'id_ID', 'Permohonan Galley', '{$participantName}:<br />\n<br />\nNaskah &quot;{$submissionTitle}&quot; di {$contextName} memerlukan pembuatan galley dengan mengikuti langkah-langkah berikut.<br />\n1. Klik URL Naskah di bawah.<br />\n2. Login ke jurnal dan gunakan file Siap Produksi untuk membuat galley sesuai standar jurnal.<br />\n3. Unggah galley ke bagian File Galley.<br />\n4. Beritahu Editor menggunakan Diskusi Produksi bahwa galley telah diunggah dan siap digunakan.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nURL Naskah: {$submissionUrl}<br />\nNama pengguna: {$participantUsername}<br />\n<br />\nJika Anda tidak dapat melakukan tugas ini saat ini atau mempunyai pertanyaan, silakan hubungi kami.  Terimakasih atas kontribusi Anda ke jurnal ini.', 'Email dari Editor Bagian kepada Layout Editor memberitahukan bahwa mereka telah ditugaskan untuk melakukan layout editing terhadap suatu naskah.  Email ini memuat informasi terkait penyerahan naskah dan bagaimana mengaksesnya.'),
('LAYOUT_REQUEST', 'it_IT', 'Richiesta preparazione delle bozze', '{$participantName}:<br />\n<br />\nVorrei chiederti di preparare le bozze per il manoscritto &quot;{$submissionTitle}&quot; per {$contextName}.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nURL manoscritto: {$submissionUrl}<br />\nUsername: {$participantUsername}<br />\n<br />\nSe non puoi prendere in carico il lavoro in questo periodo o hai qualche domanda, ti prego di contattarmi. \n<br />\nGrazie per la tua collaborazione.', 'Questa email dal section editor al layout editor notifica che è stato assegnato loro il compito di curare il layout di una submission. Questa fornisce informazioni sulla submission e su come accedervi.'),
('LAYOUT_REQUEST', 'ja_JP', 'ゲラ作成のお願い', '{$participantName}:<br />\n<br />\n雑誌『{$contextName}』への投稿原稿「{$submissionTitle}」のゲラの作成をお願いいたしたくメールを差し上げました。下記の手順に従って作成してください。<br />\n1. 下記の投稿URLをクリックしてください。<br />\n2. 雑誌サイトにログインし、「制作準備完了ファイル」を使用して、雑誌の基準に従ってゲラを作成します。<br />\n3. 「ゲラファイル」セクションにゲラをアップロードしてください。<br />\n4. 「制作ディスカッション」を使用して、編集者にゲラがアップロードされ、準備ができたことを通知します。<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\n投稿URL: {$submissionUrl}<br />\nユーザー名: {$participantUsername}<br />\n<br />\n今回、この作業を引き受けていただけない場合、あるいは、何かご不明な点がございましたら、ご連絡ください。この作業を引き受けていただくよう、よろしくお願いいたします。', 'このメールは、セクションエディタからレイアウトエディタに投稿物に対するレイアウト作業を任命したことを通知するものです。メールでは、投稿物に関する情報とアクセス方法を提供しています。'),
('LAYOUT_REQUEST', 'ku_IQ', 'داواکاریی تابلۆسازی', '{$participantName}:<br />\n<br />\nتوێژینەوەی &quot;{$submissionTitle}&quot; بۆ {$contextName} پێویستی بە تابلۆی تایبەتە بەم ڕێگایانەی خوارەوە.<br />\n١. کلیک لەسەر لینکی توێژینەوەی پێشکەشکراو لە خوارەوە بکە.<br />\n٢. داخلی پەڕەی گۆڤار بکە و کار لەسەر ئەو فایلانە بکە کە ئامادە کراون بۆ بڵاوکردنەوە بە گوێرەی ستانداردەکانی گۆڤار.<br />\n٣. تابلۆکان بۆ بەشی فایلەکانی تابلۆ بار بکە.<br />\n٤. سەرنوسەر لە ئامادەبونی تابلۆی کۆتایی ئاگادار بکەوە.<br />\n<br />\n{$contextName} لینک: {$contextUrl}<br />\nلینکی توێژینەوەی پێشکەشکراو: {$submissionUrl}<br />\nناوی بەکارهێنەر: {$participantUsername}<br />\n<br />\nئەگەر تۆ لە ئێستادا ناتوانیت ئەم ئەرکە لە ئەستۆ بگریت، تکایە ئاگادارمان بکەوە. سوپاس بۆ هاوکاریتان.', 'ئەم ئیمەیڵە لە سەرنوسەری بەشەوە بۆ نەخشەسازە بۆ ئاگادارکردنەوەیان لە ئەرکدارکردنیان بۆ نەخشەسازیکردنی پێشکەشکراوەکە. زانیاری دەربارەی توێژینەوەی پێشکەشكراو و چۆنییەتی دەستپێڕاگەیشتنی تێدایە.'),
('LAYOUT_REQUEST', 'mk_MK', 'Барање за Отисок на труд', '{$participantName}:<br />\n<br />\nПоднесокот &quot;{$submissionTitle}&quot; до {$contextName} има потреба од отисоци поставени според следниве чекори.<br />\n1.  Кликнете на URL-адресата на поднесокот подолу.<br />\n2. Најавете се на списанието и искористете ги датотеките Спремни за обработка за да ги создадете отисоците во склоп на стандардите на списанието.<br />\n3. Прикачете ги отисоците во секцијата Отисоци на труд.<br />\n4. Известете го уредникот со помош на Дискусија за обработка дека отисоците се готови и прикачени.<br />\n<br />\n{$contextName} URL-адреса: {$contextUrl}<br />\nURL-адреса на поднесокот: {$submissionUrl}<br />\nКорисничко име: {$participantUsername}<br />\n<br />\nДоколку не можете да во моментов да ја превземете оваа работа или имате било какви прашања, ве молам да ме контактирате.  Ви бладариме за вашиот придонес кон ова списание.', 'Овој и-меил од Секциски уредник до Уредник за распоред ги известува дека им е доделена задачата да извршат уредување на рапоредот на поднесокот. Обезбедува информации за поднесокот и како да се пристапи до истиот.'),
('LAYOUT_REQUEST', 'nb_NO', 'Forespørsel om oppsett', '{$participantName}:<br />\n<br />\nTakk at du bidrar til arbeidet med <i>{$contextName}</i>. Innleveringen «{$submissionTitle}» skal nå gjøres klar for publisering.<br />\n<br />\n1. Klikk på innleveringens URL: {$submissionLayoutUrl}<br />\n2. Logg deg inn på tidsskriftet og bruk de produksjonsklare filene for å lage et oppsett som følger tidsskriftets retningslinjer.<br />\n3. Last opp oppsettet til seksjonen for oppsettfiler.<br />\n4. Gi beskjed til redaktøren om at oppsettet er lastet opp og klart via produksjonsdiskusjonen.<br />\n\n{$contextName}: {$contextUrl}<br />\nInnleveringens: {$submissionLayoutUrl}<br />\nBrukernavn: {$participantUsername}<br />\n<br />\nTa kontakt dersom du ikke har anledning til å utføre dette arbeidet, eller hvis du har spørsmål.', 'Denne e-posten fra seksjonsredaktøren til layoutredaktøren bestiller oppsett for en innlevering. E-posten gir informasjon om innleveringen, og om tilgang til den.'),
('LAYOUT_REQUEST', 'nl_NL', 'Verzoek aanmaken proeven', '{$participantName}:<br />\n<br />\nDe proeven van inzending &quot;{$submissionTitle}&quot; bij {$contextName} kunnen aangemaakt worden door de volgende stappen te doorlopen.<br />\n1. Klik op de inzendings-URL hieronder.<br />\n2. Log in bij het tijdschrift en gebruik het Layout versie bestand om de proeven aan te maken conform de regels van het tijdschrift.<br />\n3. Stuur de GEREED e-mail naar de redacteur.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nURL inzending: {$submissionUrl}<br />\nGebruikersnaam: {$participantUsername}<br />\n<br />\nAls u op dit moment niet in staat bent om dit werk te doen of als u vragen heeft, neem dan contact met me op.', 'Deze e-mail van de sectieredacteur aan de opmaakredacteur meldt de toekenning van de taak om de opmaak van een inzending uit te voeren. Het bevat informatie over de inzending en hoe die te benaderen.'),
('LAYOUT_REQUEST', 'pl_PL', 'Prośba o wykonanie składu', '{$participantName}:<br />\n<br />\nproszę o wykonanie składu tekstu &quot;{$submissionTitle}&quot; przeznaczonego do opublikowania w czasopiśmie {$contextName}. Proszę o postępowanie zgodnie z poniższymi krokami: <br />\n1. Zaloguj się na stronie czasopisma i kliknij poniższy link.<br />\n2. Pobierz plik w wersji gotowej do produkcji.<br />\n3. Wykonaj skład i prześlij gotowy do opublikowania plik do systemu.<br />\n4. Powiadom redaktora o ukończeniu składu.<br />\n<br />\nAdres WWW czasopisma {$contextName}: {$contextUrl}<br />\nAdres WWW tekstu: {$submissionUrl}<br />\nNazwa użytkownika: {$participantUsername}<br />\n<br />\nJeśli nie możesz podjąć się tego zadania lub masz jakiekolwiek pytania, proszę, skontaktuj się ze mną. Dziękujemy za Twój wkład w pracę czasopisma.', 'Wiadomość jest wysyłana przez redaktora prowadzącego do składacza. Zawiera prośbę o wykonanie składu tekstu.'),
('LAYOUT_REQUEST', 'pt_BR', 'Solicitação de composições', '{$participantName}:<br />\n<br />\nA submissão &quot;{$submissionTitle}&quot; para {$contextName} de provas tipográficas, conforme as seguintes etapas. <br />\n1. Clique na URL de Submissão abaixo. <br />\n2. Faça login no periódico e use os arquivos Prontos para Produção para criar as provas de acordo com os padrões do periódico. <br />\n3. Carregue as provas na seção Arquivos de Prova. <br />\n4. Notifique o Editor, usando as Discussões de Produção, informando de que as provas estão carregadas e prontas. <br />\n<br />\nURL de {$contextName}: {$contextUrl} <br />\nURL da submissão: {$submitUrl} <br />\nNome de usuário: {$participantUsername} <br />\n<br />\nSe você não conseguir realizar esse trabalho no momento ou tiver alguma dúvida, entre em contato comigo. Obrigado por sua contribuição para este periódico.', 'Mensagem enviada pelo Editor de Seção ao Editor de Layout, solicitando que sejam preparadas as Composições do texto final, com informações de acesso.'),
('LAYOUT_REQUEST', 'pt_PT', 'Pedido de composições finais', '{$participantName},<br />\n<br />\nSolicito a preparação dos ficheiros finais de publicação da submissão &quot;{$submissionTitle}&quot;, à {$contextName}, conforme as seguintes instruções:<br />\n1. Clique no URL da submissão, indicado mais adiante nesta mensagem.<br />\n2. Aceda ao sistema e use os ficheiros Prontos para Produção para produzir os ficheiros de publicação, de acordo com os padrões da revista.<br />\n3. Envie para o sistema os ficheiros prontos para publicação.<br />\n4. Notifique o Editor através das Discussões de Produção que os ficheiros estão prontos.<br />\n<br />\nURL da revista {$contextName}: {$contextUrl}<br />\nURL da Submissão:  {$submissionUrl}<br />\nNome de utilizador: {$participantUsername}<br />\n<br />\nCaso não esteja disponível para assumir esta responsabilidade no momento, ou em caso de dúvidas, entre em contacto connosco.', 'Este e-mail é enviado pelo Editor de Secção ao Editor de Layout, solicitando que sejam preparadas os Ficheiros de Publicação do texto final, com informações de acesso.'),
('LAYOUT_REQUEST', 'ro_RO', 'Solicitare galerii', '{$participantName}:<br />\n<br />\nManuscrisul &quot;{$submissionTitle}&quot; către {$contextName} va avea constituită galeria urmând pașii următori<br />\n1. Click pe adresa manuscrisului de mai jos.<br />\n2. Conectați-vă la jurnal și utilizați fișierele Gata de Producție pentru a crea galeria în conformitate cu standardele jurnalului.<br />\n3. Încărcați materialele în secțiunea Fișiere galerie.<br />\n4. Notificați editorul folosind Discuțiile despre Producție, că galeriile sunt încărcate și sunt pregătite.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nAdresa manuscris: {$submissionUrl}<br />\nNume utilizator: {$participantUsername}<br />\n<br />\nDacă nu puteți întreprinde această solicitare în acest moment sau aveți întrebări, vă rugăm să mă contactați. Vă mulțumim pentru contribuția dvs. la acest jurnal.', 'Acest e-mail de la Editorul de secțiuni către Editorul de aspect, notifică că i s-a atribuit sarcina de a efectua editarea aspectului manuscrisului. Oferă informații despre manuscris și modul de accesare a acestuia.');
INSERT INTO `email_templates_default_data` VALUES
('LAYOUT_REQUEST', 'ru_RU', 'Запрос на верстку', 'Здравствуйте, {$participantName}!<br />\n<br />\nНеобходимо сверстать гранки материала «{$submissionTitle}» для журнала «{$contextName}», выполнив следующие шаги.<br />\n1. Щелкните на URL материала ниже.<br />\n2. Войдите в журнал и используйте файлы из панели «Готовые для производства» для подготовки гранок в в соответствии со стандартами журнала.<br />\n3. Загрузите файлы гранок в панели «Гранки».<br />\n4. Уведомите редактора с помощью Обсуждений производства, что гранки загружены и готовы.<br />\n<br />\nURL журнала «{$contextName}»: {$contextUrl}<br />\nURL материала: {$submissionUrl}<br />\nИмя пользователя: {$participantUsername}<br />\n<br />\nЕсли Вы не можете выполнить эту работу сейчас или у Вас есть какие-либо вопросы, пожалуйста, свяжитесь со мной. Спасибо за Ваш вклад в наш журнал.', 'Это письмо редактора раздела, отправляемое верстальщику с уведомлением о том, что ему поручено выполнить верстку материала. В письме содержится информация о материале и о том, как получить к нему доступ.'),
('LAYOUT_REQUEST', 'sk_SK', 'Žiadosť o sadzobnice', '{$participantName}:<br />\n<br />\nPríspevok &quot;{$submissionTitle}&quot; pre {$contextName} je teraz treba pripraviť do sadzobnicového formátu podľa nasledujúcich inštrukcií.<br />\n1. Kliknite nižšie na URL príspevku.<br />\n2. Prihláste sa do časopisu a pre vytvorenie sadzobnice podľa štandardov časopisu použite verziu súboru pre grafické úpravy.<br />\n3. Nahrajte upravené súbory do sekcie Súbory sadzobníc<br />\n4. Upozornite redaktora pomocou diskusie v produkčnej fáze, že sadzobnice sú hotové.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nURL príspevku: {$submissionUrl}<br />\nUžívateľské meno: {$participantUsername}<br />\n<br />\nAk teraz nemôžete túto úlohu vykonať alebo máte nejaké otázky, kontaktujte ma prosím. Ďakujeme za Vašu pomoc nášmu časopisu.', 'Tento email posiela editor sekcie typografovi, aby mu oznámil, že mu bola pridelená úloha vykonať typografické úpravy príspevku. Obsahuje informácie o príspevku a prístupe k nemu.'),
('LAYOUT_REQUEST', 'sl_SI', 'Prošnja za prelom', '{$participantName}:<br />\n<br />\nPrispevek &quot;{$submissionTitle}&quot; za publikacijo {$contextName} potrebuje prelom, ki se naredi po spodnjih korakih.<br />\n1. Kliknite na URL povezavo prispevka spodaj.<br />\n2. Prijavite se v publikacijo in uporabite datoteko, ki so pripravljene za produkcijo, da pripravite prelom po standardih publikacije.<br />\n3. Naložite datoteke v razdelek s prelomi.<br />\n4. Obvestite urednika preko razprave za produkcijo, da so prelomi pripravljeni in naloženi.<br />\n<br />\nPovezava do publikacije{$contextName}: {$contextUrl}<br />\nPovezava do prispevka: {$submissionUrl}<br />\nUporabniško ime: {$participantUsername}<br />\n<br />\nČe v tem trenutku ne morete opraviti tega dela ali imate kakšno vprašanje, se prosim obrnite name. Hvala za vaš trud za to publikacijo.', 'Ta email pošlje urednik rubrike grafičnemu uredniku prispevka s prošnjo za pripravo preloma prispevka. Vsebuje kratka navodila za prirpavo preloma in dostop do prispevka.'),
('LAYOUT_REQUEST', 'sv_SE', 'Förfrågan om publiceringsversion', '{$participantName}:<br />\n<br />\nBidraget &quot;{$submissionTitle}&quot; till {$contextName} behöver nu få publiceringsversioner skapade genom att följa nedanstående steg:<br />\n1. Klicka på Bidragets URL nedan.<br />\n2. Logga in på tidskriften och använd filerna under Filer redo för produktion för att skapa publiceringsversioner enligt tidskriftens standarder.<br />\n3. Ladda upp publiceringsversionerna till sektionen Filer för publiceringsversion.<br />\n4. Meddela Redaktören, genom att använda Produktionsdiskussioner, att publiceringsversionerna är uppladdade och klara.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nBidragets URL: {$submissionUrl}<br />\nAnvändarnamn: {$participantUsername}<br />\n<br />\nOm du för tillfället inte har möjlighet att genomföra det här arbetet, eller om du har frågor, vänligen kontakta mig. Tack för ditt arbete med tidskriften.', 'Det här e-postmeddelandet från sektionsredaktören till layoutredaktören för att meddela att hen har blivit tilldelad uppgiften att vara layoutredaktör för ett bidrag. Det innehåller information om bidraget och hur man får tillgång till det.'),
('LAYOUT_REQUEST', 'tr_TR', 'Dizgi Provası Ricası', '{$participantName}:<br />\n<br />\n{$contextName} için &quot;{$submissionTitle}&quot; başlıklı çalışmanın mizanpajının tamamlanarak, prova dizginin tarafımıza gönderilmesi için rica ederiz.<br />\n<br />\nProva dizgi kopya bağlantısı: {$submissionUrl}<br />\nKullanıcı adı: {$participantUsername}<br />\n<br />\nİşin gerçekleştirilmesi ile ilgili bir soru / sorularınızı yazabilirsiniz.<br />\nKatkılarınız için teşekkür ederiz.', 'Son sayfa düzeni kopyasının mizanpajının gönderilmesinde kullanılan mesaj.'),
('LAYOUT_REQUEST', 'uk_UA', 'Запит на верстку', '{$participantName}:<br />\n<br />\nПодання &quot;{$submissionTitle}&quot; до видання &quot;{$contextName}&quot; потребує створення верстки. Для цього потрібно виконати наступні дії:<br />\n1. Натисніть на вказаній нижче адресі URL подання.<br />\n2. Увійдіть на сайт журналу та зробіть гранки з файлу версії для верстки, керуючись стандартами журналу.<br />\n3. Натисніть на зображення поштового конверту під заголовком &quot;закінчення&quot;, щоб надіслати лист редактору.<br />\n<br />\nURL видання &quot;{$contextName}&quot;: <a href="{$contextUrl}">{$contextUrl}</a><br />\nURL подання:  <a href="{$submissionUrl}">{$submissionUrl}</a><br />\nІм''я користувача: {$participantUsername}<br />\n<br />\nЯкщо зараз Ви не маєте можливості виконати цю роботу або маєте додаткові запитання, будь ласка, повідомте мені. Дякую за працю для нашого журналу.', 'Цим листом редактор розділу просить редактора верстки розпочати процес верстки подання. У листі міститься інформація про подання та про те, як отримати доступ до нього.'),
('LAYOUT_REQUEST', 'vi_VN', 'Yêu cầu bản in', 'Kính gửi {$participantName},<br />\n<br />\nBài gửi &quot;{$submissionTitle}&quot; đến {$contextName} bây giờ cần bản in bằng cách làm theo các bước sau.<br />\n1. Nhấp vào URL gửi dưới đây.<br />\n2. Đăng nhập vào tạp chí và sử dụng các tập tin sẵn sàng chế bản để tạo ra các bản in theo tiêu chuẩn của tạp chí.<br />\n3. Tải các bản in thử vào tập tin Bản in<br />\n4. Thông báo cho Biên tập viên bằng mục thảo luận khi chế bản rằng các bản in được tải lên và sẵn sàng.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\nURL bài gửi: {$submissionUrl}<br />\nUsername: {$participantUsername}<br />\n<br />\nNếu bạn không thể thực hiện công việc này vào lúc này hoặc có bất kỳ câu hỏi nào, xin vui lòng liên hệ với tôi. Cảm ơn bạn đã đóng góp cho tạp chí này.', 'Email này từ Biên tập viên chuyên mục gửi tới Biên tập viên trình bày thông báo cho họ rằng họ đã được giao nhiệm vụ thực hiện chỉnh sửa bố cục của bài gửi. Nó cung cấp thông tin về bài gửi và làm thế nào để truy cập vào nó.'),
('LAYOUT_REQUEST', 'zh_CN', '请进行排版工作', '{$participantName}:<br />\n<br />\n投递到 {$contextName}的稿件 &quot;{$submissionTitle}&quot; 现在按照如下步骤进行排版：<br />\n1. 点击下面的投稿URL.<br />\n2. 登录到期刊，并且使用排版版本文件根据期刊标准来创建样稿.<br />\n3. 发送完成稿件给编辑.<br />\n<br />\n{$contextName} URL: {$contextUrl}<br />\n稿件URL: {$submissionUrl}<br />\n用户名: {$participantUsername}<br />\n<br />\n如果您这次不能完成这项工作或者有任何质询，请联系我们，感谢您对本刊的贡献.', '这封电子邮件是由区段编辑寄发给版面编辑，通知他们要进行一份稿件的版面编辑工作。邮件中含有稿件的信息以及如何取得稿件的指引。'),
('LOCKSS_EXISTING_ARCHIVE', 'ar_IQ', 'طلب أرشفة لمجلة {$contextName}', 'عزيزنا [أمين مكتبة الجامعة]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;، هي مجلة علمية فيها أحد أعضاء مؤسستك، والمدعو [اسم العضو]، يعمل بصفة [صفة العضو]. وهذه المجلة تتطلع إلى تأسيس أرشيف متوافق مع نوع LOCKSS (Lots of Copies Keep Stuff Safe) مع هذه المكتبة وغيرها من مكتبات الجامعات الأخرى.<br />\n<br />\n[وصف موجز للمجلة]<br />\n<br />\nوالرابط الخاص ببيان الناشر المتعلق بأرشيف LOCKSS لمجلتنا هو: {$contextUrl}/gateway/lockss<br />\n<br />\nنحن نتفهم أنك مشترك سابقاً في LOCKSS. إن كان بإمكاننا تزويدك بأي بيانات وصفية إضافية لغرض تسجيل مجلتنا في نسختك من LOCKSS، فإننا سنكون سعداء بتوفيرها لك.<br />\n<br />\nشكراً لك.<br />\n{$principalContactSignature}', 'هذه الرسالة تطلب من القيِّم على أرشيف LOCKSS ليأخذ بنظر الإعتبار إضافة هذه المجلة إلى أرشيفه. إنها تزوده برابط بيان الناشر المتعلق بأرشيف LOCKSS الخاص بالمجلة.'),
('LOCKSS_EXISTING_ARCHIVE', 'bs_BA', 'Zamolba za arhiviranje časopisa {$contextName}', 'Poštovani [Knjižničar ustanove],<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; je časopis s kojim zaposlenik vašeg fakulteta [ime zaposlenika] surađuje kao [titula]. Časopis pokušava, u ovoj i drugim knjižnicama u sustavu znanosti i visokog obrazovanja, uspostaviti arhivu u skladu s LOCKSS sustavom (Lots of Copies Keep Stuff Safe).<br />\n<br />\n[Kratki opis časopisa]<br />\n<br />\nAdresa LOCKSS izdavače izjave za naš časopis je: {$articleUrl}/gateway/lockss<br />\n<br />\nPrema našim spoznajama, vi već sudjelujete u sustavu LOCKSS. Vrlo rado ćemo vam pružiti bilo kakve dodatne metapodatke koji bi mogli biti potrebni u svrhu prijave našeg časopisa unutar vaše verzije LOCKSS sustava.<br />\n<br />\nUnaprijed hvala,<br />\n{$principalContactSignature}', 'Ovaj obrazac e-pošte skreće pozornost osobe nadležne za LOCKSS arhivu da razmotri uključenje ovog časopisa u svoju arhivu. E-pošta šalje i URL poveznicu ka izjavi izdavača ovog časopisa o korištenju LOCKSS sustava.'),
('LOCKSS_EXISTING_ARCHIVE', 'ca_ES', 'Sol·licitud d''arxivament per a {$contextName}', 'Benvolgut/uda [University Librarian],<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, és una revista en la qual participa un membre de la vostra facultat o universitat, [nom del membre], en qualitat de [nom del rol]. Des d''aquesta revista estem intentant establir un arxiu amb la vostra biblioteca universitària i d''altres que s''ajusti a les preceptives de LOCKSS (Lots of Copies Keep Stuff Safe).<br />\n<br />\n[Descripció breu de la revista]<br />\n<br />\nL''URL del manifest editorial LOCKSS de la nostra revista és: {$contextUrl}/gateway/lockss<br />\n<br />\nSegons la informació de què disposem, la vostra biblioteca ja participa en la iniciativa LOCKSS. Per tant, no dubteu a sol·licitar-nos totes les metadades addicionals que necessiteu per registrar aquesta revista a la vostra versió de LOCKSS.<br />\n<br />\nGràcies,<br />\n{$principalContactSignature}', 'Aquest missatge de correu electrònic sol·licita al conservador de l''arxiu LOCKSS la inclusió d''aquesta revista en el seu arxiu. Inclou l''URL del LOCKSS Publisher Manifest per a la revista.'),
('LOCKSS_EXISTING_ARCHIVE', 'cs_CZ', 'Žádost o archivaci pro {$contextName}', 'Vážený [univerzitní knihovník]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; je časopis, ve kterém pracovník Vaší univerzity [jméno pracovníka] zastává pozici [název pozice]. Tento časopis má zájem vybudovat archiv kopatibilní s programem LOCKSS (Lots of Copies Keep Stuff Safe) společně s touto knihovnou a dalšími univerzitními knihovnami.<br />\n<br />\n[Krátký popis časopisu]<br />\n<br />\nURL k Prohlášení LOCKSS vydavatele pro náš časopis je: {$contextUrl}/gateway/lockss<br />\n<br />\nChápeme, že jste již zapojeni do LOCKSS. Pokud můžeme poskytnout jakákoliv dodatečná metadata pro účely zaregistrování našeho časopisu do Vaší verze LOCKSS, velice rádi Vám je dodáme.<br />\n<br />\nDěkujeme,<br />\n{$principalContactSignature}', 'Tento email žádá vlastníka LOCKSS archivu, aby zvážil zařazení tohoto časopisu do svého archivu. Obsauje URL k Prohlášení LOCKSS vydavatele časopisu.'),
('LOCKSS_EXISTING_ARCHIVE', 'da_DK', 'Forespørgsel om arkivering af {$contextName}', 'Kære [universitetsbibliotekar]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; er et tidsskrift, hvor et medlem af dit fakultet, [navn på medlem], fungerer som [stillingsbetegnelse]. Tidsskriftet forsøger at etablere et LOCKSS-kompatibelt (Lots of Copies Keep Stuff Safe) arkiv med dette og andre universitetsbiblioteker.<br />\n<br />\n[Kort beskrivelse af tidsskrift]<br />\n<br />\nURL-adressen til LOCKSS Publisher Manifest for vores tidsskrift er: {$contextUrl}/gateway/lockss<br />\n<br />\nVi er klar over, at du allerede deltager i LOCKSS. Hvis vi kan stå til rådighed med yderligere metadata med henblik på at få vores tidsskrift registreret med din version af LOCKSS, gør vi gerne dette.<br />\n<br />\nTak.<br />\n{$principalContactSignature}', 'Denne e-mail anmoder den ansvarlige for et LOCKSS-arkiv om at overveje at inkludere dette tidsskrift i deres arkiv. Den indeholder URL-adressen til tidsskriftets LOCKSS Publisher Manifest.'),
('LOCKSS_EXISTING_ARCHIVE', 'de_DE', 'Bitte um Archivierung von {$contextName}', 'Sehr geehrte/r [Bibliotheksleiter/in],<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; ist eine Zeitschrift, an der ein Mitglied Ihrer Universität, [Name], als [Mitarbeiterfunktion] mitarbeitet. Die Zeitschrift beabsichtigt, mit Ihrer und anderen Universitätsbibliotheken ein mit LOCKSS (Lots of Copies Keep Stuff Safe) kompatibles Archiv aufzubauen.<br />\n<br />\n[Kurze Beschreibung der Zeitschrift]<br />\n<br />\nDie Webadresse der LOCKSS-Erklärung für unsere Zeitschrift ist: {$contextUrl}/gateway/lockss<br />\n<br />\nWir gehen von der Annahme aus, dass Sie bereits an LOCKSS beteiligt sind. Falls weitere Metadaten zur Aufnahme unserer Zeitschrift in Ihre Version von LOCKSS gebraucht werden, stellen wir sie Ihnen gern zur Verfügung.<br />\n<br />\nVielen Dank,<br />\n{$principalContactSignature}', 'Diese E-Mail bittet die/den Verwalter/in eines LOCKSS-Archivs zu überlegen, diese Zeitschrift in ihr/sein Archiv aufzunehmen. Sie liefert die URL zur LOCKSS-Erklärung der Herausgeber/innen der Zeitschrift.'),
('LOCKSS_EXISTING_ARCHIVE', 'el_GR', 'Αίτημα αρχειοθέτησης για το περιοδικό {$contextName}', 'Αγαπητέ/ή [Όνομα Υπευθύνου Πανεπιστημιακής Βιβλιοθήκης]<br />\n<br />\nΤο {$contextName} &amp;lt;{$contextUrl}&amp;gt; είναι ένα περιοδικό στο οποίο ένα μέλος της σχολής σας, ο/η [όνομα μέλους], συνεισφέρει ως [τίτλος θέσης]. Το περιοδικό επιχειρεί να δημιουργήσει ένα αρχείο συμβατό με το πρόγραμμα LOCKSS (Lots of Copies Keep Stuff Safe).<br />\n<br />\n[Σύντομη περιγραφή του περιοδικού]<br />\n<br />\nΗ διεύθυνση URL που περιέχει τη Διακήρυξη του Εκδότη για το LOCKSS, είναι: {$contextUrl}/gateway/lockss<br />\n<br />\nΕξ όσων γνωρίζουμε, συμμετέχετε ήδη στο LOCKSS. Αν μπορούμε να σας παρέχουμε οποιαδήποτε επιπρόσθετα μεταδεδομένα για να καταχωρήσετε το περιοδικό μας στην εγκατάσταση LOCKSS που διαχειρίζεστε, θα χαρούμε να το κάνουμε.<br />\n<br />\nΣας ευχαριστούμε,<br />\n{$principalContactSignature}', 'Το παρόν μήνυμα ζητά από τον διαχειριστή ενός αρχείου LOCKSS να συμπεριλάβει το περιοδικό στο αρχείο του. Παρέχει τη διεύθυνση URL του περιοδικού με τη Διακήρυξη του Εκδότη για το LOCKSS.'),
('LOCKSS_EXISTING_ARCHIVE', 'en_US', 'Archiving Request for {$contextName}', 'Dear [University Librarian]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, is a journal for which a member of your faculty, [name of member], serves as a [title of position]. The journal is seeking to establish a LOCKSS (Lots of Copies Keep Stuff Safe) compliant archive with this and other university libraries.<br />\n<br />\n[Brief description of journal]<br />\n<br />\nThe URL to the LOCKSS Publisher Manifest for our journal is: {$contextUrl}/gateway/lockss<br />\n<br />\nWe understand that you are already participating in LOCKSS. If we can provide any additional metadata for purposes of registering our journal with your version of LOCKSS, we would be happy to provide it.<br />\n<br />\nThank you,<br />\n{$principalContactSignature}', 'This email requests the keeper of a LOCKSS archive to consider including this journal in their archive. It provides the URL to the journal''s LOCKSS Publisher Manifest.'),
('LOCKSS_EXISTING_ARCHIVE', 'es_ES', 'Petición de archivado para {$contextName}', 'Estimado/a [Bibliotecaria/o Universitaria/o]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, es una revista en la que un miembro de su Facultad/Universidad, [nombre de la persona], colabora como [cargo que desempeña]. La revista está intentando crear un archivo LOCKSS (Lots of Copies Keep Stuff Safe) con esta y otras bibliotecas universitarias.<br />\n<br />\n[Breve descripción de la revista]<br />\n<br />\nLa URL para el Manifiesto Editorial LOCKSS para nuestra revista es: {$contextUrl}/gateway/lockss<br />\n<br />\nEntendemos que ya está participando en LOCKSS. Si podemos proporcionarle metadatos adicionales para registrar nuestra revista con su versión de LOCKSS, estaremos encantados/as de hacerlo.<br />\n<br />\nGracias,<br />\n{$principalContactSignature}', 'Este correo solicita al / a la administrador/a de un archivo LOCKSS que tenga en cuenta esta revista para incluirla en su archivo. Proporciona la URL del Manifiesto Editorial LOCKSS de la revista.'),
('LOCKSS_EXISTING_ARCHIVE', 'eu_ES', '{$contextName} aldizkaria artxiboan gehitzeko eskaera', '[Unibertsitateko liburuzain] estimatua<br />\n<br />\n{$contextName} aldizkaria &amp;lt;{$contextUrl}&amp;gt; aurkeztera gatozkizu. Aldizkariaren [kargua] zuen fakultateko [izena] da.  LOCKSS (Lots of Copies Keep Stuff Safe) konplitzen duen artxibo bat ezarri nahian gabiltza zuen unibertsitateko eta beste batzuetako liburutegiekin.<br />\n<br />\n[Aldizkariaren azalpen laburra]<br />\n<br />\nHau da gure aldizkariaren LOCKSS Publisher Manifest URLa: {$contextUrl}/gateway/lockss<br />\n<br />\nJakin dugunez, LOCKSSen partaide zarete dagoeneko. Gure aldizkaria zuen LOCKSS bertsioan erregistratzeko metadatu gehigarriak eskaintzerik izango bagenu, gustu handiz egingo genuke.<br />\n<br />\nEskerrik asko,<br />\n{$principalContactSignature}', 'Mezu honek LOCKSS artxiboa mantentzen duenari eskatzen dio aldizkari hau ere sar dezala artxiboan. Aldizkariaren LOCKSS Publisher Manifest URLa ematen du.'),
('LOCKSS_EXISTING_ARCHIVE', 'fa_IR', 'تقاضای آزشیو برای {$contextName}', 'مسئول محترم کتابخانه<br />\n<br />\nمجله {$contextName} &amp;lt;<a href="{$contextUrl}">{$contextUrl}</a>&amp;gt;, مجله ای است که یکی از اعضای آن مؤسسه  (بنام فلان) در آن عضو میباشد. این مجله متقاضی آرشیو شدن محتوایش در یک سایت LOCKSS میباشد. خواهشمند است مساعدت فرموده و این مجله را در سیستم خود آرشیو کنید.rsity libraries.<br />\n<br />\n[توضیح مختصری از مجله]<br />\n<br />\nآدرس وبی برای مانیفست ناشری LOCKSS مجله ما بقرار زیر است:<br />\n<a href="{$contextUrl}">{$contextUrl}</a>/gateway/lockss<br />\n<br />\nاز آنجائیکه شما عضو شبکه LOCKSS هستید خواهشمند است مساعدت فرموده و ما را در آرشیو خود ذخیره فرمائید.<br />\nبا تشکر<br />\n{$principalContactSignature}', 'This email requests the keeper of a LOCKSS archive to consider including this journal in their archive. It provides the URL to the journal''s LOCKSS Publisher Manifest.'),
('LOCKSS_EXISTING_ARCHIVE', 'fi_FI', 'Julkaisun {$contextName} arkistointipyyntö', 'Hyvä [yliopistokirjaston kirjastonhoitajan nimi],<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; on julkaisu, jossa yliopistonne henkilökunnan jäsen, [jäsenen nimi], toimii [toimen nimi, esim.”toimittajana”]. Julkaisun pyrkimyksenä on perustaa LOCKSS:ia (Lots of Copies Keep Stuff Safe) noudattava arkisto tämän ja muiden yliopistojen kirjastojen kanssa.<br />\n<br />\n[Lyhyt kuvaus julkaisusta]<br />\n<br />\nJulkaisumme LOCKSS Publisher Manifest -sivun URL-osoite on: {$contextUrl}/gateway/lockss<br />\n<br />\nKäsittääksemme kirjastonne osallistuu jo LOCKSS:iin. Mikäli tarvitsette lisää metatietoja julkaisumme rekisteröimiseksi LOCKSS-versioonne, annamme mielellämme lisätietoja.<br />\n<br />\nYstävällisin terveisin,<br />\n{$principalContactSignature}', 'This email requests the keeper of a LOCKSS archive to consider including this journal in their archive. It provides the URL to the journal''s LOCKSS Publisher Manifest.'),
('LOCKSS_EXISTING_ARCHIVE', 'fr_CA', 'Demande d''archivage pour la revue {$contextName}', 'Cher,Chère [Bibliothécaire universitaire],<br />\n<br />\n{$contextName} &lt;{$contextUrl}&gt; est une revue pour laquelle un membre de votre faculté, [nom du membre], agit à titre de [titre de la position occupée]. La revue désire mettre en place un système d''archivage conforme LOCKSS (Lots of Copies Keep Stuff Safe - Plusieurs exemplaires assurent la sécurité) avec votre bibliothèque ainsi que celles d''autres universités.<br />\n<br />\n[Brève description de la revue]<br />\n<br />\nL''adresse URL pour le LOCKSS Publisher Manifest pour notre revue est : {$contextUrl}/gateway/lockss<br />\n<br />\nNous croyons savoir que vous participez déjà à LOCKSS. Si nous pouvons vous fournir des métadonnées supplémentaires afin d''inscrire notre revue avec votre version de LOCKSS, il nous fera plaisir de vous les fournir.<br />\n<br />\nMerci,<br />\n{$principalContactSignature}', 'Ce courriel demande à un-e conservateur,trice d''archives LOCKSS d''envisager d''inclure cette revue dans leur archive. Il fournit l''adresse URL du LOCKSS Publisher Manifest de la revue.'),
('LOCKSS_EXISTING_ARCHIVE', 'fr_FR', 'Demande d''archivage pour {$contextName}', 'Cher, chère [Bibliothécaire universitaire]<br />\n<br />\n{$contextName} &lt;{$contextUrl}&gt; est une revue pour laquelle un membre de votre faculté, [nom du membre], agit à titre de [titre de la position occupée]. La revue désire mettre en place un système d''archivage conforme LOCKSS (Lots of Copies Keep Stuff Safe - Plusieurs exemplaires qui assurent la sécurité) avec votre bibliothèque universitaire ainsi que celles d''autres universités.<br />\n<br />\n[Brève description de la revue]<br />\n<br />\nL''adresse URL pour le LOCKSS Publisher Manifest pour notre revue est : {$contextUrl}/gateway/lockss<br />\n<br />\nNous savons que vous participez déjà à LOCKSS. Si nous pouvons vous fournir des métadonnées supplémentaires afin d''inscrire notre revue avec votre version de LOCKSS, nous nous ferons un plaisir de vous les fournir.<br />\n<br />\nMerci,<br />\n{$principalContactSignature}', 'Ce courriel demande à un conservateur d''archives LOCKSS d''envisager d''inclure cette revue dans leurs archives. Il fournit l''adresse URL du LOCKSS Publisher Manifest de la revue.'),
('LOCKSS_EXISTING_ARCHIVE', 'gd_GB', 'Iarrtas tasglannachadh airson {$contextName}', '[Ainm an leabhar-lannaiche] a charaid,<br />\n<br />\n’S e iris-leabhar a tha ann an {$contextName} &amp;lt;{$contextUrl}&amp;gt; agus tha ball dhen roinn agad, [ainm a’ bhuill] na [ainm an dreuchd] ann. Tha an t-iris-leabhar seo airson tasg-lann a rèir LOCKSS (Lots of Copies Keep Stuff Safe) a stèidheachadh eadar an leabhar-lann seo agus leabhar-lannan oilthighean eile.<br />\n<br />\n[Tuairisgeul goirid air an iris-leabhar]<br />\n<br />\n’S e na leanas an URL gu manifest fhoillsichearan LOCKSS an iris-leabhair againn: {$contextUrl}/gateway/lockss<br />\n<br />\nTha coltas gu bheil sibh a’ gabhail pàirt ann an LOCKSS mar-thà. Ma tha barrachd meata-dàta a dhìth airson an t-iris-leabhar againn a chlàradh aig an tionndadh agaibhse de LOCKSS, bhiomaid ro thoilichte sin a thoirt dhuibh.<br />\n<br />\nMòran taing,<br />\n{$principalContactSignature}', 'Tha am post-d seo a’ faighneachd de neach-glèidhidh tasg-lann LOCKSS am b’ urrainn dhaibh an t-iris-leabhar seo a ghabhail a-staigh san tasg-lann aca. Tha URL gu manifest fhoillsichearan LOCKSS an iris-leabhair na bhroinn.'),
('LOCKSS_EXISTING_ARCHIVE', 'he_IL', 'בקשת ארכיון עבור {contextName$}', 'לכבוד [ספרן אוניברסיטאי]<br />\n<br />\n{contextName$} הוא כתב עת שעבורו חבר הפקולטה שלך, [שם החבר], משמש כ [תואר תפקיד]. היומן מבקש להקים ארכיון תואם LOCKSS עתכם ועם וספריות אוניברסיטאיות אחרות.<br />\n<br />\n[תיאור קצר של כתב העת]<br />\n<br />\nכתובת האתר ל-LOCKSS לכתב עת שלנו היא: {contextUrl} / gateway / lockss$ <br />\n<br />\nאנו מבינים שאתה כבר משתתף ב- LOCKSS. אם נוכל לספק מטא-נתונים נוספים למטרות רישום כתב העת שלנו בגירסת LOCKSS שלך, נשמח לספק אותה.<br />\n<br />\nבתודה,<br />\n{principalContactSignature$}', 'הודעת דוא"ל זו מבקשת משומר ארכיב LOCKSS לשקול לכלול את כתב העת הזה בארכיון שלו. הוא מספק את כתובת האתר למניפסט המו"ל של LOCKSS.'),
('LOCKSS_EXISTING_ARCHIVE', 'hi_IN', 'के लिए अनुरोध प्राप्त करना {$contextName}', 'Dear [University Librarian]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, एक जर्नल है जिसके लिए आपके संकाय का एक सदस्य, [सदस्य का नाम], [स्थिति का शीर्षक] के रूप में कार्य करता है। जर्नल इस और अन्य विश्वविद्यालय पुस्तकालयों के साथ एक LOCKSS (लोट्स ऑफ कपीज कीप स्टफ सेफ) स्थापित करने की मांग कर रहा है।<br />\n<br />\n[जर्नल का संक्षिप्त विवरण]<br />\n<br />\nहमारी जर्नल के लिए LOCKSS प्रकाशक घोषणापत्र का URL है:{$contextUrl}/gateway/lockss<br />\n<br />\nहम समझते हैं कि आप पहले से ही LOCKSS में भाग ले रहे हैं। यदि हम LOCKSS के अपने संस्करण के साथ हमारी जर्नल को पंजीकृत करने के प्रयोजनों के लिए कोई अतिरिक्त मेटाडेटा प्रदान कर सकते हैं, तो हमें यह प्रदान करके खुशी होगी.<br />\n<br />\nThank you,<br />\n{$principalContactSignature}', 'यह ईमेल LOCKSS संग्रह के रक्षक को इस जर्नल में उनके संग्रह में शामिल करने पर विचार करने का अनुरोध करता है। यह जर्नल के LOCKSS प्रकाशक घोषणापत्र को URL प्रदान करता है.'),
('LOCKSS_EXISTING_ARCHIVE', 'hr_HR', 'Zamolba za arhiviranje časopisa {$contextName}', 'Poštovani [Knjižničar ustanove],<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; je časopis s kojim zaposlenik vašeg fakulteta [ime zaposlenika] surađuje kao [titula]. Časopis pokušava, u ovoj i drugim knjižnicama u sustavu znanosti i visokog obrazovanja, uspostaviti arhivu u skladu s LOCKSS sustavom (Lots of Copies Keep Stuff Safe).<br />\n<br />\n[Kratki opis časopisa]<br />\n<br />\nAdresa LOCKSS izdavače izjave za naš časopis je: {$articleUrl}/gateway/lockss<br />\n<br />\nPrema našim spoznajama, vi već sudjelujete u sustavu LOCKSS. Vrlo rado ćemo vam pružiti bilo kakve dodatne metapodatke koji bi mogli biti potrebni u svrhu prijave našeg časopisa unutar vaše verzije LOCKSS sustava.<br />\n<br />\nUnaprijed hvala,<br />\n{$principalContactSignature}', 'Ovaj obrazac e-pošte skreće pozornost osobe nadležne za LOCKSS arhivu da razmotri uključenje ovog časopisa u svoju arhivu. E-pošta šalje i URL poveznicu ka izjavi izdavača ovog časopisa o korištenju LOCKSS sustava.'),
('LOCKSS_EXISTING_ARCHIVE', 'hu_HU', 'Folyóirat archiválásának kérése a(z) {$contextName} számára', 'Tisztelt Repozitórium üzemeltető!<br />\n<br />\nAz Önök intézményének munkatársa, [tag neve] a(z) {$contextName} &amp;lt;{$contextUrl}&amp;gt;, folyóiratnál [betöltött pozíció] pozíciót tölt be. A folyóirat egy LOCKSS (Lots of Copies Keep Stuff Safe) kompatibilis archívumot kíván létrehozni, az Önök könyvtárával és más könyvtárakkal is együttműködve.<br />\n<br />\n[A folyóirat rövid leírása]<br />\n<br />\nA folyóiratunk LOCKSS Publisher Manifest weboldalának URL címe:  {$contextUrl}/gateway/lockss<br />\n<br />\nMegértjük, ha korábban már csatlakozott a LOCKSS-hoz. Ha bármilyen további adattal tudunk szolgálni, hogy folyóiratunkat integrálják az Önök LOCKSS rendszerébe, örömmel válaszolunk kérdéseikre.<br />\n<br />\nKöszönettel,<br />\n{$principalContactSignature}', 'Ez az email a LOCKSS archívum üzemeltetőjét kéri, hogy fontolja meg a folyóirat bevonását az archívumába. Megadja az URL-jét a folyóirat LOCKSS Publisher Manifest oldalának.'),
('LOCKSS_EXISTING_ARCHIVE', 'id_ID', 'Permohonan Pengarsipan untuk {$contextName}', 'Yang terhormat [Pustakawan Universitas]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, merupakan jurnal yang salah satu anggota fakultas Anda, [name of member], menjadi [title of position]. Jurnal ini hendak membuat arsip sesuai LOCKSS (Lots of Copies Keep Stuff Safe) di perpustakaan Anda dan perpustakaan universitas lainnya.<br />\n<br />\n[Deskripsi singkat jurnal]<br />\n<br />\nURL Publisher Manifest LOCKSS jurnal kami adalah: {$contextUrl}/gateway/lockss<br />\n<br />\nKami memahami bahwa Anda telah bergabung dengan LOCKSS. Jika kami perlu memberikan metadata tambahan untuk mendaftarkan jurnal kami di versi LOCKSS Anda, dengan senang hati kami akan memberikannya.<br />\n<br />\nTerimakasih,<br />\n{$principalContactSignature}', 'Email ini meminta penjaga arsip LOCKSS untuk mempertimbangkan memasukkan jurnal ini ke dalam arsip mereka. Email ini memberikan URL Publisher Manifest LOCKSS jurnal.'),
('LOCKSS_EXISTING_ARCHIVE', 'it_IT', 'Richiesta di archiviazione per {$contextName}', 'Caro [Bibliotecario dell''Universita'']<br />\n<br />\n{$contextName} &lt;{$contextUrl}&gt; è una testata con la quale un vostro membro  [nome del membro], collabora come [posizione]  sta cercando di instaurare un archivio condiviso LOCKSS (Lots of Copies Keep Stuff Safe) con questa e altre biblioteche universitarie.<br />\n<br />\n[Breve descrizione del journal]<br />\n<br />\nLa URL al manifesto di pubblicazione del LOCKSS  per il nostro journal &amp;#x00E8;: {$contextUrl}/gateway/lockss<br />\n<br />\nComprendiamo che state gi&amp;#x00E0; partecipando al LOCKSS. Se possiamo fornire qualsiasi metadato aggiuntivo per scopi di registrazione al nostro journal con la vostra versione del LOCKSS, saremo felici di fornirvelo.<br />\n<br />\nGrazie,<br />\n{$principalContactSignature}', 'Questa email richiede al controllore di un archivio LOCKSS di considerare di includere questo journal nei loro archivi. Questa fornisce una URL al LOCKSS Publisher Manifest del journal.'),
('LOCKSS_EXISTING_ARCHIVE', 'ja_JP', '『{$contextName}』保存のお願い', '大学図書館長] 御中<br />\n<br />\n本誌『{$contextName} 』&amp;lt;{$contextUrl}&amp;gt;は、貴学の教官 [教官名]殿に[役職名]をお願いしているものです。本誌は、貴館およびその他の大学図書館との間でLOCKSS（Lots of Copies Keep Stuff Safe）準拠のアーカイブを構築したいと考えております。<br />\n<br />\n[雑誌の簡単な説明]<br />\n<br />\n本誌のLOCKSS出版者宣言書のURLは {$contextUrl}/gateway/lockss です。<br />\n<br />\n貴館は既にLOCKSSに参加していると伺っております。私たちの雑誌を貴館のLOCKSSに登録するためにメタデータを提供できるなら、喜んで提供したいと考えております。\n<br />\n<br />\nよろしくご検討くださるよう、お願いいたします。<br />\n{$principalContactSignature}', 'このメールは、LOCKSSアーカイブの管理者にこの雑誌をアーカイブに追加することを検討してもらうことを依頼するものです。メールでは、雑誌のLOCKSS出版者宣言書のURLを提供します。'),
('LOCKSS_EXISTING_ARCHIVE', 'ku_IQ', 'ئه‌رشیفكردنی داواكاری بۆ ناوی ده‌ق', 'بەڕێزان [ئەندامانی کتێبخانەی زانکۆ]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; گۆڤارێکی فاکەڵتییەکەتانە، [ناوی ئەندام]، وەک [ناسناوی زانکۆیی]خزمەت دەکات. گۆڤارەکەمان بە LOCKSS  بۆ ئەرشیفکردنەوە سەرقاڵە لەگەڵ ئەندامانی کتێبخانەکانی زانکۆکانی دیکە.<br />\n<br />\n[کورتەیەک دەربارەی گۆڤار] <br />\n<br />\n لینکی LOCKSSی تایبەت بە گۆڤارەکەمان : {$contextUrl}/gateway/lockss<br />\n<br />\nئێمە لەوە تێدەگەین کە ئێوە بەشدارن لە سیستەمی LOCKSS. ئەگەر تۆ دەتوانین هەر زانیارییەکی ناسێنەر بۆ تۆمارکردنی گۆڤارمان لە LOCKSS بخەیتە ڕو، ئێمە سوپاسگوزار دەبین.<br />\n<br />\nسوپاس بۆ هاوکاریتان،<br />\n{$principalContactSignature}', 'ئەم ئیمەیڵە داواکاریی بەئەرشیفکردنی گۆڤار لە سیستەمی ئەرشیفی LOCKSSی تێدایە. لینکی LOCKSSی گۆڤار خراوەتە ڕو.'),
('LOCKSS_EXISTING_ARCHIVE', 'mk_MK', 'Барање за архивирање за {$contextName}', 'Почитуван/а [University Librarian]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, е списание за кое член од вашиот факултет, [name of member], работи како [title of position]. Списанието сака да воспостави архива согласна со LOCKSS (Lots of Copies Keep Stuff Safe) заедно со оваа и останати универзитетски библиотеки.<br />\n<br />\n[Brief description of journal]<br />\n<br />\nURL-адресата за LOCKSS изјавата за објавување на нашето списание е: {$contextUrl}/gateway/lockss<br />\n<br />\nСпоред нашето разбирање вие веќе учествувате во LOCKSS. Доколку ви се потребни дополнителни метаподатоци со цел да го регистрираме нашето списание на вашата верзија на LOCKSS, би биле среќни да ви ги доставиме.<br />\n<br />\nВи благодарам,<br />\n{$principalContactSignature}', 'Овој и-меил бара чуварот на LOCKSS архива да го земе во предвид вклучувањето на ова списание во нивната архива. Ја обезбедува URL-адресата до издавачкиот манифест LOCKSS на списанието.'),
('LOCKSS_EXISTING_ARCHIVE', 'nb_NO', 'Anmodning om arkivering av {$contextName}', 'Kjære [universitetsbibliotekar]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; er et tidsskrift der en av deres faglige ansatte, [oppgi medlemsnavn], har påtatt seg å være [oppgi rolletittel]. Tidsskriftet ønsker å etablere et LOCKSS (Lots of Copies Keep Stuff Safe) arkiv, i samarbeid med flere universitetsbibliotek.<br />\n<br />\n[Gi en kort beskrivelse av tidsskriftet]<br />\n<br />\nURL til det LOCKSS Publisher Manifest som gjelder for tidsskriftet vårt er: {$contextUrl}/gateway/lockss<br />\n<br />\nVi forstår det slik at biblioteket deres allerede deltar i et LOCKSS-samarbeid. Hvis det er behov for det, bidrar vi gjerne med ytterligere nødvendige metadata for å få registrert tidsskriftet vårt med deres versjon av LOCKSS.<br />\n<br />\nVennlig hilsen,<br />\n{$principalContactSignature}', 'Denne e-posten ber ansvarshavende bibliotekar ved et LOCKSS arkiv om å vurdere å innlemme tidsskriftet i deres arkiv. E-posten oppgir URL-lenken til tidsskriftets LOCKSS Publisher Manifest.'),
('LOCKSS_EXISTING_ARCHIVE', 'nl_NL', 'Verzoek tot archivering voor {$contextName}', 'Beste [Universiteitsbibliothecaris]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; is een tijdschrift waarvoor een lid van uw faculteit, [naam van het lid], fungeert als [titel van de positie]. Het tijdschrift streeft naar het starten van een LOCKSS (Lots of Copies Keep Stuff Safe) archief met deze en andere universiteitsbibliotheken.<br />\n<br />\n[Korte beschrijving van het tijdschrift]<br />\n<br />\nDe URL van het LOCKSS Publisher Manifest van ons tijdschrift is: {$contextUrl}/gateway/lockss<br />\n<br />\nWe begrijpen dat u al deelneemt in LOCKSS. Als we additionele metadata kunnen leveren om ons tijdschrift bij uw versie van LOCKSS te registreren, zullen we die met alle genoegen leveren.<br />\n<br />\nDank u,<br />\n{$principalContactSignature}', 'Deze e-mail vraagt aan de houder van een LOCKSS archief om dit tijdschrift op te nemen in het archief. De URL naar het LOCKS manifest van het tijdschrift wordt meegestuurd.'),
('LOCKSS_EXISTING_ARCHIVE', 'pl_PL', 'Prośba o archiwizowanie czasopisma "{$contextName}"', 'Szanowna Pani/ Szanowny Panie,<br />\n<br />\nprosimy o zarejestrowanie naszego czasopisma "{$contextName}" w Państwa archiwum LOCKSS. <br />\n<br />\nWWW czasopisma: {$contextUrl}\n\n[Krótki opis czasopisma]<br />\n<br />\nDokumentacja LOCKSS wydawcy naszego czasopisma jest dostępna na stronie: {$contextUrl}/gateway/lockss<br />\n<br />\nZ naszej wiedzy wynika, że jesteście Państwo członkiem LOCKSS. Z przyjemnością dostarczymy dodatkowych metadanych potrzebnych do rejestracji naszego czasopisma w używanej przez Państwa wersji LOCKSS, jeżeli zgodzą się Państwo na zarejestrowanie naszego czasopisma.<br />\n<br />\nZ wyrazami szacunku,<br />\n{$principalContactSignature}', 'Wiadomość z prośbą do opiekuna archiwum LOCKSS o uwzględnienie czasopisma w tym archiwum. Zawiera adres strony internetowej czasopisma oraz dokumentacji LOCKSS wydawcy.'),
('LOCKSS_EXISTING_ARCHIVE', 'pt_BR', 'Solicitação para Arquivamento de {$contextName}', 'Prezado(a) [bibliotecário(a) da universidade]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, é um periódico para o qual um membro de sua instituição, [nome do membro], serve como [título da posição]. O periódico está buscando estabelecer um arquivo compatível com LOCKSS (Lots of Copies Keep Stuff Safe) com esta e outras bibliotecas universitárias.<br />\n<br />\n[Breve descrição do periódico]<br />\n<br />\nA URL do Manifesto do Publicador LOCKSS para nosso periódico é: {$contextUrl}/gateway/lockss<br />\n<br />\nEntendemos que você já está participando do LOCKSS. Se pudermos fornecer metadados adicionais para registrar nosso periódico com sua versão do LOCKSS, teremos prazer em fornecê-los.<br />\n<br />\nAtenciosamente,<br />\n{$principalContactSignature}', 'Esta mensagem solicita ao mantenedor de um repositório LOCKSS que considere incluir este periódico em seu acervo, informando a URL para o Manifesto LOCKSS da editora.'),
('LOCKSS_EXISTING_ARCHIVE', 'pt_PT', 'Pedido para adicionar para arquivo a revista {$contextName}', 'Cara(o) [Bibliotecária(o) da Universidade]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, é uma revista na qual um docente da sua instituição, [nome da pessoa], possui o papel editorial de [título da função editorial]. Esta revista deseja obter arquivo através do LOCKSS (Lots of Copies Keep Stuff Safe - Muitas Cópias Mantém as Coisas Seguras) compatível com esta e outras bibliotecas de instituições de ensino superior.<br />\n<br />\n[Breve descrição da revista]<br />\n<br />\nO URL do Manifesto LOCKSS da Editora da nossa revista é: {$contextUrl}/gateway/lockss<br />\n<br />\nConsta do nosso registo que esta biblioteca faz parte do sistema LOCKSS. Estamos à disposição caso necessite de metadados adicionais para o registo da revista na sua versão do LOCKSS, os quais serão fornecidos o mais rápido possível.<br />\n<br />\nAgradecendo desde já a sua atenção,<br />\n{$principalContactSignature}', 'Este e-mail solicita ao administrador de um arquivo LOCKSS que considere armazenar a revista no seu arquivo, fornecendo o URL para o Manifesto LOCKSS da Editora da revista.'),
('LOCKSS_EXISTING_ARCHIVE', 'ro_RO', 'Cerere de arhivare pentru {$contextName}', 'Stimate(ă) [University Librarian]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, este o revistă științifică la care un membru al facultății tale, [name of member], contribuie ca și [title of position]. Jurnalul încearcă să stabilească o arhivă conformă cu LOCKSS (Lots of Copies Keep Stuff Safe) cu această bibliotecă și cu alte biblioteci universitare.<br />\n<br />\n[Brief description of journal]<br />\n<br />\nAdresa URL a Declarației LOCKSS Publisher pentru jurnalul nostru este: {$contextUrl}/gateway/lockss<br />\n<br />\nÎnțelegem că participați deja la LOCKSS. Dacă putem furniza orice metadate suplimentare în scopul înregistrării jurnalului nostru în versiunea dvs. LOCKSS, am fi bucuroși să vă furnizăm acest lucru.<br />\n<br />\nMulțumim frumos,<br />\n{$principalContactSignature}', 'Acest e-mail solicită deținătorului unei arhive LOCKSS să ia în considerare includerea revistei în arhiva lor. Emailul furnizează adresa URL a Declarației LOCKSS Publisher.'),
('LOCKSS_EXISTING_ARCHIVE', 'ru_RU', 'Запрос на архивацию для журнала «{$contextName}»', 'Уважаемый [библиотекарь университета]!<br />\n<br />\n«{$contextName}» &amp;lt;{$contextUrl}&amp;gt; — журнал, в котором сотрудник Вашего университета, [имя сотрудника], занимает должность [название должности]. Наш журнал хотел бы создать LOCKSS(Lots of Copies Keep Stuff Safe)-совместимый архив с библиотеками Вашего и других университетов.<br />\n<br />\n[Краткое описание журнала]<br />\n<br />\nURL манифеста издателя LOCKSS для нашего журнала: {$contextUrl}/gateway/lockss<br />\n<br />\nМы знаем, что Вы уже участвуете в LOCKSS. Если мы можем предоставить любые дополнительные метаданные для регистрации нашего журнала в Вашей версии LOCKSS, мы будем рады это сделать.<br />\n<br />\nС уважением,<br />\n{$principalContactSignature}', 'Это письмо является обращением к владельцу LOCKSS архива с просьбой рассмотреть возможность включения этого журнала в их архив. В письме сообщается адрес (URL) манифеста издателя LOCKSS для этого журнала.'),
('LOCKSS_EXISTING_ARCHIVE', 'sk_SK', 'Žiadosť o archiváciu pre {$contextName}', 'Vážený [univerzitný knihovník]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; je časopis, v ktorom pracovník Vašej univerzity [meno pracovníka] zastáva pozíciu [názov pozície]. Tento časopis má záujem vybudovať archív kompatibilný s programom LOCKSS (Lots of Copies Keep Stuff Safe) spoločne s touto knižnicou a ďalšími univerzitnými knižnicami.<br />\n<br />\n[Krátky popis časopisu]<br />\n<br />\nURL k Prehlásení LOCKSS vydavateľa pre náš časopis je: {$contextUrl}/gateway/lockss<br />\n<br />\nChápeme, že ste už zapojení do LOCKSS. Ak môžeme poskytnúť akékoľvek dodatočné metadáta na účely zaregistrovania nášho časopisu do Vašej verzie LOCKSS, veľmi radi Vám ich dodáme.<br />\n<br />\nĎakujeme,<br />\n{$principalContactSignature}', 'Tento email žiada vlastníka LOCKSS archívu, aby zvážil zaradenie tohto časopisu do svojho archívu. Obsahuje URL k Vyhláseniu LOCKSS vydavateľa časopisu.'),
('LOCKSS_EXISTING_ARCHIVE', 'sl_SI', 'Prošnja za arhiviranje revije {$contextName}', 'Dear [University Librarian]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, is a journal for which a member of your faculty, [name of member], serves as a [title of position]. The journal is seeking to establish a LOCKSS (Lots of Copies Keep Stuff Safe) compliant archive with this and other university libraries.<br />\n<br />\n[Brief description of journal]<br />\n<br />\nThe URL to the LOCKSS Publisher Manifest for our journal is: {$contextUrl}/gateway/lockss<br />\n<br />\nWe understand that you are already participating in LOCKSS. If we can provide any additional metadata for purposes of registering our journal with your version of LOCKSS, we would be happy to provide it.<br />\n<br />\nThank you,<br />\n{$principalContactSignature}', 'Email se pošlje skrbniku LOCKSS arhiva s prošnjo za vključitev te revije v njihov arhiv. Podaja tudi URL do LOCKSS izdajateljskega manifesta revije.'),
('LOCKSS_EXISTING_ARCHIVE', 'sv_SE', 'Förfrågan om arkivering för {$contextName}', 'Hej [universitetsbibliotekarie]!<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; är en tidskrift där en medarbetare på ditt lärosäte, [namn på medarbetaren], bistår som [namn på position]. Tidskriften vill etablera ett LOCKSS-kompatibelt (Lots of Copies Keep Stuff Safe) arkiv vid det här och andra universitetsbibliotek.<br />\n<br />\n[Kortfattad beskrivning av tidskriften]<br />\n<br />\nURL:en till LOCKSS Publisher Manifest för vår tidskrift är: {$contextUrl}/gateway/lockss<br />\n<br />\nVi har förstått att ni redan deltar i LOCKSS. Vi bistår gärna med ytterligare metadata som eventuellt behövs för att registrera vår tidskrift i er LOCKSS-version.<br />\n<br />\nTack och med vänliga hälsningar,<br />\n{$principalContactSignature}', 'Det här e-postmeddelandet är en förfrågan till den som administrerar ett LOCKSS-arkiv att överväga inkludering av den här tidskriften i deras arkiv. Meddelandet innehåller URL:en till tidskriftens LOCKSS Publisher Manifest.');
INSERT INTO `email_templates_default_data` VALUES
('LOCKSS_EXISTING_ARCHIVE', 'tr_TR', '{$contextName} arşivleme talebi', 'Sayın [University Librarian]<br />\n<br />\n{$contextName} &lt;{$contextUrl}&gt; dergisi için fakültenizin üyesi [name of member] [title of position] görevini üstlenmiştir. Dergi bu ve diğer üniversite kütüphaneleri ile LOCKSS (Lots of Copies Keep Stuff Safe – çok sayıda kopya güvenliğini koruma) uyumlu arşiv oluşturmayı hedeflemektedir. <br />\n<br />\n[Brief description of journal]<br />\n<br />\nDergimizin LOCKSS yayınevi bildirgesi internet adresi: {$contextUrl}/gateway/lockss<br />\n<br />\nLOCKSS sistemini kullandığınızı tespit etmiş bulunuyoruz. Dergimizin sizin kullandığınız LOCKSS sürümüne kaydedilebilmesi için gerekli her türlü meta veriyi sağlamaktan mutluluk duyarız.<br />\n<br />\nTeşekkür ederiz,<br />\n{$principalContactSignature}', 'Bu e-posta LOCKSS arşiv yöneticisine bu dergiyi arşivlerine ekleme olanağını hatırlatmayı amaçlar ve derginin LOCKSS yayımcı bildirgesi internet adresini içermektedir.'),
('LOCKSS_EXISTING_ARCHIVE', 'uk_UA', 'Запит на архівування видання {$contextName}', 'Шановний [Бібліотекар Університету]<br />\n<br />\n{$contextName} &amp;lt;<a href="{$contextUrl}">{$contextUrl}</a>&amp;gt; - це журнал, для якого Ваш співробітник [Ім''я співробітника] виконує роль [посада у редакційному штаті]. Наш журнал прагне мати архів, сумісний з LOCKSS (Lots of Copies Keep Stuff Safe) у Вашій бібліотеці та бібліотеках інших університетів.<br />\n<br />\n[Короткий опис журналу]<br />\n<br />\nURL-адреса маніфесту видавця LOCKSS для нашого журналу:  {$contextUrl}/gateway/lockss<br />\n<br />\nМи знаємо, що Ваша бібліотека вже бере участь у проекті LOCKSS. Якщо для реєстрації нашого журналу з Вашою версією LOCKSS потрібні певні додаткові метадані, ми будемо раді надати Вам їх.<br />\n<br />\nДякую,<br />\n{$principalContactSignature}', 'Цей лист надсилається утримувачу архіву LOCKSS як пропозиція щодо включення цього журналу до існуючого архіву. У листі міститься URL-адреса на прийнятий журналом маніфест видавця LOCKSS.'),
('LOCKSS_EXISTING_ARCHIVE', 'vi_VN', 'Yêu cầu lưu trữ cho {$contextName}', 'Kính gửi [University Librarian]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, là một tạp chí mà một thành viên của khoa của bạn, [name of member], phục vụ như một [title of position]. Tạp chí đang tìm cách thiết lập một kho lưu trữ tuân thủ LOCKSS (Lots of Copies Keep Stuff Safe) với thư viện này và các thư viện đại học khác.<br />\n<br />\n[Brief description of journal]<br />\n<br />\nURL tới LOCKSS Publisher Manifest cho tạp chí của chúng tôi là: {$contextUrl}/gateway/lockss<br />\n<br />\nChúng tôi hiểu rằng bạn đã tham gia LOCKSS. Nếu chúng tôi có thể cung cấp bất kỳ siêu dữ liệu bổ sung nào cho mục đích đăng ký tạp chí của chúng tôi với phiên bản LOCKSS của bạn, chúng tôi sẽ vui lòng cung cấp nó.<br />\n<br />\nTrân trọng,<br />\n{$principalContactSignature}', 'Email này yêu cầu người quản lý kho lưu trữ LOCKSS xem xét đưa tạp chí này vào kho lưu trữ của họ. Nó cung cấp URL tới LOCKSS Publisher Manifest của tạp chí.'),
('LOCKSS_EXISTING_ARCHIVE', 'zh_CN', '请存档《{$contextName}》', 'Dear [University Librarian]<br />\n<br />\n《{$contextName}》 &amp;lt;{$contextUrl}&amp;gt;是一份适合贵单位教职员的期刊：[成员名称]，[职称]。这份期刊正试着与这个图书馆与其他大学图书馆，共同建立一个符合洛克斯存档计划(LOCKSS; Lots of Copies Keep Stuff Safe)的检藏资料库。<br />\n<br />\n[期刊的简介]<br />\n<br />\n我们这份期刊在「洛克斯出版品一览」的网址是：{$contextUrl}/gateway/lockss<br />\n<br />\n我们了解贵单位已经参与洛克斯计划。我们非常乐意提供任何额外的后设资料，以在贵单位的洛克斯版本中进行注册。<br />\n<br />\n谢谢您<br />\n{$principalContactSignature}', '这封电子邮件要求一个洛克斯存档的维护者考虑将这份期刊纳入其存档库中。邮件中提供了链接到 「洛克斯出版品一览」的网址。'),
('LOCKSS_NEW_ARCHIVE', 'ar_IQ', 'إلتماس أرشفة لمجلة {$contextName}', 'عزيزنا [أمين مكتبة الجامعة<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;، هي مجلة علمية فيها أحد أعضاء مؤسستك، والمدعو [اسم العضو]، يعمل بصفة [صفة العضو]. وهذه المجلة تتطلع إلى تأسيس أرشيف متوافق مع نوع LOCKSS (Lots of Copies Keep Stuff Safe) مع هذه المكتبة وغيرها من مكتبات الجامعات الأخرى.<br />\n<br />\n[وصف موجز للمجلة]<br />\n<br />\nإن برنامج LOCKSS &amp;lt;http://lockss.org/&amp;gt; باعتباره أحد الحقوق العالمية للمكتبات والناشرين، هو مثال عملي على مخازن الأرشفة والحفظ المتوزع. المزيد من التفاصيل تتوضح أدناه. هذا البرنامج، الذي يمكن تشغيله على حاسوب شخصي عادي، مجاني، وبالإمكان تفعيله بسهولة على الشبكة العنكبوتية، ولا يتطلب إلا القليل من إجراءات الصيانة والمتابعة.<br />\n<br />\nللمساعدة على أرشفة مجلتنا، ندعوك لتكون أحد أعضاء مجتمع LOCKSS، للتمكن من جمع وحفظ العناوين المقدمة من قبل مؤسستك التعليمية ومن قبل الدارسين عبر العالم. للقيام بذلك، حرض أحداً من منتسبيك لزيارة موقع LOCKSS لتحصل على معلومات عن كيفية عمل هذا النظام. أنا أتطلع شوقاً لأتعرف إمكانيتك على توفير هذا النوع من الدعم لتساعد المجلة على أرشفة محتوياتها.<br />\n<br />\nشكراً لك.<br />\n{$principalContactSignature}', 'هذه الرسالة تشجع متلقيها على المبادرة إلى اعتماد العمل بنظام LOCKSS وتضمين هذه المجلة في الأرشيف الخاص به. إنها تتضمن معلومات عن تمهيد نظام LOCKSS وكيفية المشاركة فيه.'),
('LOCKSS_NEW_ARCHIVE', 'bs_BA', 'Zamolba za arhiviranje časopisa {$contextName}', 'Poštovani [Knjižničar ustanove],<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; časopis je s kojim zaposlenik vašeg fakulteta [ime zaposlenika] surađuje kao [titula]. Časopis pokušava, u ovoj i drugim knjižnicama u sustavu znanosti i visokog obrazovanja, uspostaviti arhivu u skladu s LOCKSS sustavom (Lots of Copies Keep Stuff Safe).<br />\n<br />\n[Kratki opis časopisa]<br />\n<br />\nMeđunarodna bibliotekarska/izdavačka inicijativa Program LOCKSS &amp;lt;http://lockss.org/&amp;gt; predstavlja funkcionalni primjer distribuiranog repozitorija namijenjenog čuvanju i arhiviranju sadržaja. Dodatne informacije možete pročitati u nastavku teksta. Potreban software koji se može koristiti i na običnom osobnom računalu je besplatan; sustav se vrlo jednostavno postavlja on-line te zahtijeva vrlo malo kontinuiranog održavanja.<br />\n<br />\nKako biste doprinijeli arhiviranju našeg časopisa, pozivamo vas da postanete član LOCKSS zajednice čime biste pripomogli u sakupljanju i očuvanju naslova koje izdaje vaš fakultet i drugi znanstvenici diljem svijeta. Želite li se uključiti, molimo vas da jedan/a od vaših djelatnika/ca posjeti stranicu LOCKSS-a kako bi dobio/la informacije o funkcioniranju sustava. Nadamo se da ćete nas uskoro kontaktirati u vezi s izvedivošću pružanja ovakve podrške arhiviranju časopisa.<br />\n<br />\nUnaprijed hvala,<br />\n{$principalContactSignature}', 'Ovaj obrazac e-pošte potiče primatelja na sudjelovanje u LOCKSS inicijativi i uvrštenje ovog časopisa u arhivu. Obrazac pruža osnovne informacije o LOCKSS inicijativi i načinima uključivanja.'),
('LOCKSS_NEW_ARCHIVE', 'ca_ES', 'Sol·licitud d''arxivament per a {$contextName}', 'Benvolgut/uda [bibliotecari/ària universitari],<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, és una revista en què un membre de la vostra facultat o universitat, [nom del membre], participa en qualitat de [nom del rol]. Des d''aquesta revista estem intentant establir un arxiu amb la vostra biblioteca universitària i d''altres que s''ajusti a les preceptives de LOCKSS (Lots of Copies Keep Stuff Safe).<br />\n<br />\n[Descripció breu de la revista]<br />\n<br />\nEl programa LOCKSS &amp;lt;http://lockss.org/&amp;gt;, una iniciativa internacional d''enllaç entre biblioteques i entitats publicadores, és un viu exemple de conservació distribuïda i repositori d''arxivament. Es tracta d''una aplicació gratuïta, executable en qualsevol ordinador personal, que podeu gestionar fàcilment i per a la qual es requereix un manteniment mínim.<br />\n<br />\nPer contribuir a l''arxivament d''aquesta revista, us convido a ser membre de la comunitat LOCKSS i a col·laborar en la recopilació i conservació de títols elaborats a la vostra facultat o universitat i en altres entitats acadèmiques de l''àmbit internacional. Per fer-ho, us recomano que algun membre del vostre personal visiti el lloc web de LOCKSS per obtenir informació sobre el funcionament d''aquest sistema. Confio rebre ben aviat la vostra acceptació per col·laborar en l''arxivament d’aquesta revista.<br />\n<br />\nThank you,<br />\n{$principalContactSignature}', 'Aquest missatge de correu electrònic convida el destinatari a participar en la iniciativa LOCKSS i a incloure aquesta revista en el seu arxiu. Proporciona informació sobre la iniciativa LOCKSS i com s''hi ha de participar.'),
('LOCKSS_NEW_ARCHIVE', 'cs_CZ', 'Žádost o archivaci pro {$contextName}', 'Vážený [univerzitní knihovník]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; je časopis, ve kterém pracovník Vaší univerzity [jméno pracovníka] zastává pozici [název pozice]. Tento časopis má zájem vybudovat archiv kopatibilní s programem LOCKSS (Lots of Copies Keep Stuff Safe) společně s touto knihovnou a dalšími univerzitními knihovnami.<br />\n<br />\n[Krátký popis časopisu]<br />\n<br />\nProgram LOCKSS &amp;lt;http://lockss.org/&amp;gt;, mezinárodní iniciativa knihoven/vydavatelů, je fungujícím příkladem archivačního úložiště s distribuovanou ochranou. Další detaily viz níže. Software, který funguje na pěžném osobním počítači, je zdarma; systém je snadno převoditelný on-line; je vyžadováno velmi málo následné údržby.<br />\n<br />\nZ důvodu pomoci při archivování našeho časopisu Vás zveme, abyste se stal členem LOCKSS komunity a pomáhal tak shromažďovat a zachovávat práci produkovanou pracovníky Vaší univerzity i dalších vědeckých pracovníků z celého světa. Abyste tak mohl učinit, pověřte prosím někoho z Vašich pracovníků, ať navštíví stránky LOCKSS, kde najde informace, jak tento systém pracuje. Těším se, že se mě budete infomovat o možnostech poskytnutí archivační podpory tonuto časopisu.<br />\n<br />\nDěkujeme,<br />\n{$principalContactSignature}', 'Tento email pobízí příjemce, aby se zapojil do LOCKSS iniciativy a zahrnul tento časopis do archivu. Obsahuje informace o LOCKSS iniciativě a způsobu, jak se do ní zapojit.'),
('LOCKSS_NEW_ARCHIVE', 'da_DK', 'Forespørgsel om arkivering af {$contextName}', 'Kære [universitetsbibliotekar]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; er et tidsskrift, hvor et medlem af dit fakultet, [navn på medlem], fungerer som [stillingsbetegnelse]. Tidsskriftet forsøger at etablere et LOCKSS-kompatibelt (Lots of Copies Keep Stuff Safe) arkiv med dette og andre universitetsbiblioteker.<br />\n<br />\n[Kort beskrivelse af tidsskrift]<br />\n<br />\nLOCKSS-programmet &amp;lt;http://lockss.org/&amp;gt;, der er et internationalt biblioteks-/forlagsinitiativ, er et velfungerende eksempel på et distribueret bevarings- og arkiveringslager. Der findes flere oplysninger nedenfor. Softwaren, som kører på almindelige pc''er, er gratis. Det er nemt at få systemet til at køre online, og den løbende vedligeholdelse af systemet er meget begrænset.<br />\n<br />\nMed henblik på at få hjælp til arkivering af vores tidsskrift inviterer vi dig til at blive medlem af LOCKSS-programmet, hvor du skal hjælpe med at indsamle og bevare titler, der er produceret af dit fakultet og af andre videnskabsmænd rundt om i verden. Det gør du ved at få en af dine medarbejdere til at besøge LOCKSS-webstedet, hvor der findes oplysninger om, hvordan systemet fungerer. Jeg ser frem til at høre, om du har mulighed for at yde denne arkiveringssupport for dette tidsskrift.<br />\n<br />\nTak.<br />\n{$principalContactSignature}', 'Denne e-mail opfordrer modtageren til at deltage i LOCKSS-initiativet og inkludere dette tidsskrift i arkivet. Den indeholder oplysninger om LOCKSS-initiativet og om måder, hvorpå du kan deltage.'),
('LOCKSS_NEW_ARCHIVE', 'de_DE', 'Bitte um Archivierung von {$contextName}', 'Sehr geehrte/r [Bibliotheksleiter/in],<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; ist eine Zeitschrift, an der ein Mitglied Ihrer Universität, [Name], als [Mitarbeiterfunktion] mitarbeitet. Die Zeitschrift beabsichtigt, mit Ihrer und anderen Universitätsbibliotheken ein mit LOCKSS (Lots of Copies Keep Stuff Safe) kompatibles Archiv aufzubauen.<br />\n<br />\n[Kurze Beschreibung der Zeitschrift]<br />\n<br />\nDas LOCKSS-Programm &amp;lt;http://lockss.stanford.edu/&amp;gt;, eine internationale Initiative von Bibliotheken und Verlagen, ist ein funktionierendes verteiltes System zur Erhaltung und zur Archivierung; nähere Einzelheiten finden Sie weiter unten. Die auf jedem gewöhnlichen Rechner laufende Software ist frei; das System lässt sich leicht online bringen; es braucht wenig Wartung.<br />\n<br />\nFalls Sie sich an der Archivierung unserer Zeitschrift beteiligen möchten, laden wir Sie ein, Mitglied der LOCKSS-Community zu werden und mitzuhelfen, Texte aus Ihrer Einrichtung und von Wissenschaftler/innen aus der ganzen Welt zu sammeln und zu erhalten. Dazu sollte sich jemand aus Ihrer Einrichtung auf der Webseite von LOCKSS darüber informieren, wie dieses System funktioniert. Wir freuen uns darauf, von Ihnen zu hören, um die Möglichkeit Ihre Unterstützung bei der Archivierung dieser Zeitschrift und erwarten gern Ihre Antwort zur konkreten Vorgehensweise.<br />\n<br />\nVielen Dank,<br />\n{$principalContactSignature}', 'Diese E-Mail ermuntert die Empfängerin/den Empfänger, an der LOCKSS-Initiative teilzunehmen und diese Zeitschrift in das Archiv aufzunehmen. Sie liefert Informationen über die LOCKSS-Initiative und über Wege, daran teilzunehmen.'),
('LOCKSS_NEW_ARCHIVE', 'el_GR', 'Αίτημα αρχειοθέτησης για το περιοδικό {$contextName}', 'Αγαπητέ/ή [Όνομα Υπευθύνου Πανεπιστημιακής Βιβλιοθήκης]<br />\n<br />\nΤο {$contextName} &amp;lt;{$contextUrl}&amp;gt; είναι ένα περιοδικό στο οποίο ένα μέλος της Σχολής σας, ο/η [όνομα μέλους], συνεισφέρει ως [τίτλος θέσης]. Το περιοδικό επιχειρεί να δημιουργήσει ένα αρχείο συμβατό με το πρόγραμμα LOCKSS (Lots of Copies Keep Stuff Safe).<br />\n<br />\n[Σύντομη περιγραφή του περιοδικού]<br />\n<br />\nΤο πρόγραμμα LOCKSS, &amp;lt;http://lockss.org/&amp;gt;, μία διεθνής πρωτοβουλία βιβλιοθηκών/εκδοτών, αποτελεί υπόδειγμα ενός κατανεμημένου συστήματος διαφύλαξης και αρχειοθέτησης περιεχομένου (περαιτέρω στοιχεία παρατίθενται παρακάτω). Το λογισμικό είναι συμβατό με προσωπικούς υπολογιστές, παρέχεται δωρεάν, το σύστημα συνδέεται εύκολα στο διαδίκτυο και δεν απαιτείται διαρκής συντήρηση.<br />\n<br />\nΓια να βοηθήσετε στην αρχειοθέτηση του περιοδικού μας, σας προσκαλούμε να γίνετε μέλος της κοινότητας LOCKSS, για να συνεισφέρετε στη συλλογή και διαφύλαξη τίτλων που εκδίδονται από τη Σχολή σας και από άλλους μελετητές διεθνώς. Για να γίνει αυτό, παρακαλούμε επισκεφθείτε τον ιστότοπο του LOCKSS για πληροφορίες σχετικά με τη λειτουργία του συστήματος. Ελπίζουμε να έχουμε σύντομα νέα σας, σχετικά με τη δυνατότητα παροχής υποστήριξης στην αρχειοθέτηση του περιοδικού μας.<br />\n<br />\nΣας ευχαριστούμε,<br />\n{$principalContactSignature}', 'Το παρόν μήνυμα ενημερώνει σχετικά με την πρωτοβουλία LOCKSS και προτρέπει τους παραλήπτες να συμμετάσχουν σε αυτή, συμπεριλαμβάνοντας το περιοδικό στο αρχείο που θα δημιουργήσουν.'),
('LOCKSS_NEW_ARCHIVE', 'en_US', 'Archiving Request for {$contextName}', 'Dear [University Librarian]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, is a journal for which a member of your faculty, [name of member] serves as a [title of position]. The journal is seeking to establish a LOCKSS (Lots of Copies Keep Stuff Safe) compliant archive with this and other university libraries.<br />\n<br />\n[Brief description of journal]<br />\n<br />\nThe LOCKSS Program &amp;lt;http://lockss.org/&amp;gt;, an international library/publisher initiative, is a working example of a distributed preservation and archiving repository, additional details are below. The software, which runs on an ordinary personal computer is free; the system is easily brought on-line; very little ongoing maintenance is required.<br />\n<br />\nTo assist in the archiving of our journal, we invite you to become a member of the LOCKSS community, to help collect and preserve titles produced by your faculty and by other scholars worldwide. To do so, please have someone on your staff visit the LOCKSS site for information on how this system operates. I look forward to hearing from you on the feasibility of providing this archiving support for this journal.<br />\n<br />\nThank you,<br />\n{$principalContactSignature}', 'This email encourages the recipient to participate in the LOCKSS initiative and include this journal in the archive. It provides information about the LOCKSS initiative and ways to become involved.'),
('LOCKSS_NEW_ARCHIVE', 'es_ES', 'Petición de archivado para {$contextName}', 'Estimado/a [Bibliotecario/a Universitario/a]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, es una revista en la que un miembro de su Facultad/Universidad, [nombre de la persona], colabora como [cargo que desempeña]. La revista está intentando crear un archivo LOCKSS (Lots of Copies Keep Stuff Safe) con esta y otras bibliotecas universitarias.<br />\n<br />\n[Breve descripción de la revista]<br />\n<br />\nEl programa LOCKSS &amp;lt;http://lockss.org/&amp;gt;, una iniciativa internacional de bibliotecas y editoriales, es un ejemplo vivo de un repositorio de preservación y archivo distribuido, a continuación le mostramos más detalles. El software, que funciona en ordenadores personales normales es gratuito; el sistema se conecta fácilmente; necesitando muy poco mantenimiento.<br />\n<br />\nPara contribuir al archivado de nuestra revista, le invitamos a convertirse en miembro de la comunidad LOCKSS, y así ayudar a recopilar y preservar títulos producidos en nuestra facultad y por otras entidades académicas de todo el mundo. Para hacerlo le rogamos que alguna persona de su biblioteca visite el sitio de LOCKSS para saber cómo funciona este sistema. Espero recibir pronto noticias suyas en el sentido de que proporcionará el apoyo para poder archivar esta revista.<br />\n<br />\nGracias,<br />\n{$principalContactSignature}', 'Este correo solicita al / a la destinatario/a participar en la iniciativa LOCKSS e incluir esta revista en el archivo. Le proporciona información sobre la iniciativa LOCKSS y cómo participar.'),
('LOCKSS_NEW_ARCHIVE', 'eu_ES', '{$contextName} aldizkaria artxiboan gehitzeko eskaera', '[Unibertsitateko liburuzain] estimatua<br />\n<br />\n{$contextName} aldizkaria &amp;lt;{$contextUrl}&amp;gt; aurkeztera gatozkizu. Aldizkariaren [kargua] zuen fakultateko [izena] da. LOCKSS (Lots of Copies Keep Stuff Safe) konplitzen duen artxibo bat ezarri nahian gabiltza zuen unibertsitateko eta beste batzuetako liburutegiekin.<br />\n<br />\n[Aldizkariaren azalpen laburra]<br />\n<br />\nLOCKSS programa &amp;lt;http://lockss.org/&amp;gt;, nazioarteko liburutegi/argitaratzaile ekimena, dokumentuak banatuta gordetzeko eta artxibatzeko gordailu egoki baten adibide bikaina da, behean ematen dira xehetasun gehiago. Softwarea ordenagailu pertsonal batean ere erabiltzeko modukoa da, eta doakoa; sistema erraz jartzen da Interneten; oso mantentze-lan gutxi eskatzen du.<br />\n<br />\nGure aldizkaria artxibatzen laguntzeko, LOCKSS komunitateko kide egiteko gonbita luzatzen dizugu, zuen fakultatean eta munduko beste hainbatetan ekoitzitako tituluak kontserbatzeko. Horretarako, zuen pertsonaleko norbaitek LOCKSS guneko informazioa aztertzea komeniko litzateke, sistemak nola funtzionatzen duen ikusteko. Aldizkari hau artxibatzeko euskarria eskaintzearen bideragarritasuna aztertuko duzuelakoan, zuen berrien zain geratzen gara.<br />\n<br />\nEskerrik asko,<br />\n{$principalContactSignature}', 'Mezu honek hartzailea animatzen du LOCKSS ekimenean parte hartzera eta aldizkaria artxiboan sartzera. LOCKSS ekimenari eta atxikitzeko moduei buruzko informazioa ematen du.'),
('LOCKSS_NEW_ARCHIVE', 'fa_IR', 'درخواست بایگانی کردن {$contextName}:', 'مسئول محترم کتابخانه دانشگاه:<br />\n{$contextName} &amp;lt;<a href="{$contextUrl}">{$contextUrl}</a>&amp;gt; ، عضو دانشکده شما می باشد &amp;lt;[name of member]&amp;gt;. این مجله خواستار ایجاد سیستم بایگانی LOCKSS با آن کتابخانه و کتابخانه های دیگر دانشگاهها می باشد.<br />\n<br /><br />\n<br />\nبرنامه LOCKSS تحت آدرس http://lockss.org که یک ابتکار بین المللی مربوط به ناشر/کتابخانه می باشد. این نرم افزار رایگان، حتی توسط یک رایانه شخصی نیز اجرا می گردد. کل سامانه آن لاین شده است و به نگهداری مختصری نیازمند است.<br />\nجهت کمک در بایگانی مجله ما، از شما دعوت می کنیم که عضو انجمن LOCKSS شوید تا به شما در جمع آوری و نگهداری عناوین تهیه شده توسط سازمان خود و دیگر پژوهشگران جهان، کمک کند. برای این کار، لطفا از وب سایت LOCKSS بازدید کنید تا اطلاعاتی درباره نحوه عملکرد این سامانه دراختیار شما قرار گیرد. منتظر اعلام خبر از شما راجع به امکان تهیه چنین سامانه ای برای این مجله هستم.<br />\n<br />\n<br />\nباتشکر<br />\n{$principalContactSignature}', 'This email encourages the recipient to participate in the LOCKSS initiative and include this journal in the archive. It provides information about the LOCKSS initiative and ways to become involved.'),
('LOCKSS_NEW_ARCHIVE', 'fi_FI', 'Julkaisun {$contextName} arkistointipyyntö', 'Hyvä [yliopistokirjaston kirjastonhoitajan nimi],<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; on julkaisu, jossa yliopistonne henkilökunnan jäsen, [jäsenen nimi] toimii [toimen nimi, esim. “toimittajana”]. Julkaisun pyrkimyksenä on perustaa LOCKSS:ia (Lots of Copies Keep Stuff Safe) noudattava arkisto tämän ja muiden yliopistojen kirjastojen kanssa.<br />\n<br />\n[Lyhyt kuvaus julkaisusta]<br />\n<br />\nLOCKSS-ohjelma &amp;lt;http://lockss.org/&amp;gt;, kansainvälinen kirjasto-/julkaisijahanke, on toimiva esimerkki hajautettuun säilytykseen ja arkistointiin perustuvasta tietovarastosta (lisätietoja alla). Ohjelma toimii tavallisella kotitietokoneella ja on ilmainen. Järjestelmä on helposti hankittavissa verkosta ja se vaatii hyvin vähän ylläpitotoimenpiteitä.<br />\n<br />\nJotta voisitte auttaa julkaisumme arkistoinnissa, sekä auttaa keräämään ja tallentamaan yliopistonne henkilökunnan sekä muiden tutkijoiden julkaisuja, pyydämme teitä liittymään LOCKSS-yhteisön jäseneksi. Toimiaksenne näin, jonkun henkilökunnan jäsenistä tulisi tutustua tämän järjestelmän toimintaan LOCKSS:in sivustolla. Odotan yhteydenottoanne julkaisumme arkistoinnin toteutettavuutta koskien.<br />\n<br />\nYstävällisin terveisin,<br />\n{$principalContactSignature}', 'This email encourages the recipient to participate in the LOCKSS initiative and include this journal in the archive. It provides information about the LOCKSS initiative and ways to become involved.'),
('LOCKSS_NEW_ARCHIVE', 'fr_CA', 'Demande d''archivage pour la revue {$contextName}', 'Cher,Chère [Bibliothécaire universitaire],<br />\n<br />\n{$contextName} &lt;{$contextUrl}&gt;, est une revue pour laquelle un membre de votre faculté, [nom du membre], agit à titre de [titre de la fonction occupée]. La revue désire mettre en place un système d''archivage conforme LOCKSS (Lots of Copies Keep Stuff Safe) avec votre bibliothèque et celles d''autres universités.<br />\n<br />\n[Brève description de la revue]<br />\n<br />\nLe programme LOCKSS &lt;http://lockss.org/&gt;, une initiative de bibliothécaires et d''éditeurs internationaux, est une belle démonstration d''un dépôt d''archives assurant la préservation des documents. Voir les détails ci-dessous. Le logiciel est gratuit et fonctionne sur tout ordinateur personnel. Il est facile de le mettre en ligne et ne requiert que très peu de maintenance.<br />\n<br />\nPour nous aider dans le processus d''archivage de notre revue, nous vous invitons à devenir membre de la communauté LOCKSS, pour aider à recueillir et préserver des titres produits par votre faculté et par d''autres chercheurs à travers le monde. Pour ce faire, veuillez demander à quelqu''un de votre personnel de visiter le site Internet de LOCKSS pour voir les informations sur le fonctionnement du système. Nous attendons de vos nouvelles sur la faisabilité, pour vous, de fournir un support d''archivage pour cette revue.<br />\n<br />\nMerci,<br />\n{$principalContactSignature}', 'Ce courriel encourage le ou la destinaire à participer à l''initiative LOCKSS et à inclure cette revue dans leur archives. Il fournit de l''information au sujet de LOCKSS et des façons de s''impliquer dans le projet.'),
('LOCKSS_NEW_ARCHIVE', 'fr_FR', 'Demande d''archivage pour {$contextName}', 'Cher,Chère [Bibliothécaire universitaire],<br />\n<br />\n{$contextName} &lt;{$contextUrl}&gt;, est une revue pour laquelle un membre de votre faculté, [nom du membre], agit à titre de [titre de la fonction occupée]. La revue désire mettre en place un système d''archivage conforme LOCKSS (Lots of Copies Keep Stuff Safe) avec votre bibliothèque et celles d''autres universités.<br />\n<br />\n[Brève description de la revue]<br />\n<br />\nLe programme LOCKSS &lt;http://lockss.org/&gt;, une initiative de bibliothécaires et d''éditeurs internationaux, est une belle démonstration d''un dépôt d''archives assurant la préservation des documents. Voir les détails ci-dessous. Le logiciel est gratuit et fonctionne sur tout ordinateur personnel. Il est facile de le mettre en ligne et ne requiert que très peu de maintenance.<br />\n<br />\nPour nous aider dans le processus d''archivage de notre revue, nous vous invitons à devenir membre de la communauté LOCKSS, pour aider à recueillir et préserver des titres produits par votre faculté et par d''autres chercheurs à travers le monde. Pour ce faire, veuillez demander à quelqu''un de votre personnel de visiter le site Internet de LOCKSS pour voir les informations sur le fonctionnement du système. Nous attendons de vos nouvelles sur la faisabilité, pour vous, de fournir un support d''archivage pour cette revue.<br />\n<br />\nMerci,<br />\n{$principalContactSignature}', 'Ce courriel encourage le destinaire à participer à l''initiative LOCKSS et à inclure cette revue dans leur archives. Il fournit de l''information au sujet de LOCKSS et des façons de s''impliquer dans le projet.'),
('LOCKSS_NEW_ARCHIVE', 'gd_GB', 'Iarrtas tasglannachadh airson {$contextName}', '[Ainm an leabhar-lannaiche] a charaid,<br />\n<br />\n’S e iris-leabhar a tha ann an {$contextName} &amp;lt;{$contextUrl}&amp;gt; agus tha ball dhen roinn agad, [ainm a’ bhuill] na [ainm an dreuchd] ann. Tha an t-iris-leabhar seo airson tasg-lann a rèir LOCKSS (Lots of Copies Keep Stuff Safe) a stèidheachadh eadar an leabhar-lann seo agus leabhar-lannan oilthighean eile.<br />\n<br />\n[Tuairisgeul goirid air an iris-leabhar]<br />\n<br />\nTha prògram LOCKSS &amp;lt;http://lockss.org/&amp;gt;, iomairt leabhar-lannan/fhoillsichearan eadar-nàiseanta, na eisimpleir de thasg-lann glèidhidh sgaoilte ’s gheibh thu barrachd fiosrachaidh mu dhèidhinn gu h-ìosal. Tha am bathar-bog a ruitheas air coimpiutair pearsanta àbhaisteach an-asgaidh agus tha e furasta an siostam a chur gu dol agus chan eil feum air cus obair-ghlèidhidh.<br />\n<br />\nAirson taic a chumail ri tasglannachadh an iris-leabhair againn, bu toil leinn cuireadh a thoirt dhut gu coimhearsnachd LOCKSS airson tiotalan a chruthaicheas an roinn agadsa agus sgoilearan eile air feadh an t-saoghail a chruinneachadh is a ghlèidheadh. Airson pàirt a ghabhail, iarr air cuideigin dhen luchd-obrach agad tadhal air làrach LOCKSS a dh’fhiosrachadh mar a dh’obraicheas an siostam seo. Tha mi an dòchas gun urrainn dhuibh taic a chumail ri tasglannachadh an iris-leabhair seo agus gun cluinn mi uaibh a dh’aithghearr.<br />\n<br />\nMòran taing,<br />\n{$principalContactSignature}', 'Tha am post-d seo a’ toirt brosnachadh dhan neach a gheibh e pàirt a ghabhail san iomairt agus an t-iris-leabhar seo a ghabhail a-staigh san tasg-lann. Tha e a’ toirt seachad fiosrachadh mun iomairt LOCKSS agus ag innse mar as urrainnear pàirt a ghabhail ann.'),
('LOCKSS_NEW_ARCHIVE', 'he_IL', 'בקשת ארכיון עבור {contextName$}', 'לכבוד [ספרן אוניברסיטאי],<br />\n<br />\n{contextName$} הוא כתב עת שעבורו חבר הפקולטה שלך, [שם החבר] משמש כ [תואר תפקיד]. כתב העת מבקש להקים ארכיון תואם LOCKSS (הרבה עותקים שומרים על בטיחות) עם זה וספריות אוניברסיטאיות אחרות.<br />\n<br />\n[תיאור קצר של כתב העת]<br />\n<br />\nהתוכנית, שהוא יוזמה בינלאומית של ספרנים ומו"לים,  הוא דוגמא עובדת למאגר שימור וארכיון מבוזר, פרטים נוספים להלן. התוכנה הפועלת על מחשב אישי רגיל הינה בחינם; עולה אונליין בקלות; ואין צורך לתחזוקה שוטפת.<br />\n<br />\nכדי לסייע בארכיון כתב העת שלנו, אנו מזמינים אותך להיות חבר בקהילת LOCKSS, לעזור לאסוף ולשמר כותרות שהופקו על ידי הפקולטה שלך ועל ידי חוקרים אחרים ברחבי העולם. לשם כך, אנא בקש ממישהו מהצוות שלך לגלוש לאתר LOCKSS למידע על אופן פעולתה של מערכת זו. אני מצפה לשמוע מכם על אפשרות תמיכת ארכיון בכתב עת זה.<br />\n<br />\nבתודה,<br />\n{principalContactSignature$}', 'דוא"ל זה מעודד את המקבל להשתתף ביוזמת LOCKSS ולכלול את כתב העת הזה בארכיון. הוא מספק מידע על יוזמת LOCKSS ועל דרכים להיות מעורבים.'),
('LOCKSS_NEW_ARCHIVE', 'hi_IN', 'के लिए अनुरोध प्राप्त करना {$contextName}', 'प्रिय [विश्वविद्यालय पुस्तकालय]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, एक ऐसी जर्नल है जिसके लिए आपके संकाय का एक सदस्य, [सदस्य का नाम] [स्थिति का शीर्षक] के रूप में कार्य करता है। जर्नल इस और अन्य विश्वविद्यालय पुस्तकालयों के साथ एक LOCKSS (बहुत सारी सामग्री सुरक्षित रखें) को सुरक्षित रखने की मांग कर रहा है.<br />\n<br />\n[Brief description of journal]<br />\n<br />\nThe LOCKSS Program &amp;lt;http://lockss.org/&amp;gt;, एक अंतरराष्ट्रीय पुस्तकालय / प्रकाशक पहल, एक वितरित संरक्षण और संग्रह भंडार का एक कार्य उदाहरण है, अतिरिक्त विवरण नीचे हैं। सॉफ्टवेयर, जो एक साधारण व्यक्तिगत कंप्यूटर पर चलता है, मुफ्त है; प्रणाली को आसानी से ऑन-लाइन लाया जाता है; बहुत कम चल रहे रखरखाव की आवश्यकता है.<br />\n<br />\nहमारी जर्नल के संग्रह में सहायता करने के लिए, हम आपको अपने संकाय द्वारा और दुनिया भर के अन्य विद्वानों द्वारा उत्पादित शीर्षकों को इकट्ठा करने और संरक्षित करने में मदद करने के लिए, LOCKSS समुदाय का सदस्य बनने के लिए आमंत्रित करते हैं। ऐसा करने के लिए, कृपया यह जानने के लिए कि यह सिस्टम कैसे संचालित होता है, जानकारी के लिए कृपया अपने कर्मचारियों पर किसी LOCKSS साइट पर जाएं। मैं इस जर्नल के लिए इस संग्रह का समर्थन प्रदान करने की व्यवहार्यता पर आपकी ओर से सुनने के लिए उत्सुक हूं.<br />\n<br />\nThank you,<br />\n{$principalContactSignature}', 'यह ईमेल प्राप्तकर्ता को LOCKSS पहल में भाग लेने और संग्रह में इस जर्नल को शामिल करने के लिए प्रोत्साहित करता है। यह LOCKSS पहल और शामिल होने के तरीकों के बारे में जानकारी प्रदान करता है.'),
('LOCKSS_NEW_ARCHIVE', 'hr_HR', 'Zamolba za arhiviranje časopisa {$contextName}', 'Poštovani [Knjižničar ustanove],<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; časopis je s kojim zaposlenik vašeg fakulteta [ime zaposlenika] surađuje kao [titula]. Časopis pokušava, u ovoj i drugim knjižnicama u sustavu znanosti i visokog obrazovanja, uspostaviti arhivu u skladu s LOCKSS sustavom (Lots of Copies Keep Stuff Safe).<br />\n<br />\n[Kratki opis časopisa]<br />\n<br />\nMeđunarodna bibliotekarska/izdavačka inicijativa Program LOCKSS &amp;lt;http://lockss.org/&amp;gt; predstavlja funkcionalni primjer distribuiranog repozitorija namijenjenog čuvanju i arhiviranju sadržaja. Dodatne informacije možete pročitati u nastavku teksta. Potreban software koji se može koristiti i na običnom osobnom računalu je besplatan; sustav se vrlo jednostavno postavlja on-line te zahtijeva vrlo malo kontinuiranog održavanja.<br />\n<br />\nKako biste doprinijeli arhiviranju našeg časopisa, pozivamo vas da postanete član LOCKSS zajednice čime biste pripomogli u sakupljanju i očuvanju naslova koje izdaje vaš fakultet i drugi znanstvenici diljem svijeta. Želite li se uključiti, molimo vas da jedan/a od vaših djelatnika/ca posjeti stranicu LOCKSS-a kako bi dobio/la informacije o funkcioniranju sustava. Nadamo se da ćete nas uskoro kontaktirati u vezi s izvedivošću pružanja ovakve podrške arhiviranju časopisa.<br />\n<br />\nUnaprijed hvala,<br />\n{$principalContactSignature}', 'Ovaj obrazac e-pošte potiče primatelja na sudjelovanje u LOCKSS inicijativi i uvrštenje ovog časopisa u arhivu. Obrazac pruža osnovne informacije o LOCKSS inicijativi i načinima uključivanja.'),
('LOCKSS_NEW_ARCHIVE', 'hu_HU', 'Archiválás kérése a(z) {$contextName} folyóirat számára', 'Tisztelt Repozitórium üzemeltető!<br />\n<br />\nAz Önök intézményének munkatársa, [tag neve] a {$contextName} &amp;lt;{$contextUrl}&amp;gt;, folyóiratnál [betöltött pozíció] pozíciót tölt be. A folyóirat egy LOCKSS (Lots of Copies Keep Stuff Safe) kompatibilis archívumot kíván létrehozni, az Önök könyvtárával és más könyvtárakkal is együttműködve.<br />\n<br />\n[A folyóirat rövid leírása]<br />\n<br />\nA LOCKSS Program &amp;lt;http://lockss.org/&amp;gt;, egy nemzetközi könyvtár/kiadói kezdeményezés, mely működő példája az osztott megőrzést és archiválást biztosító repozitóriumoknak. Az egyszerű, mindennapi személyi számítógépen futó szoftver ingyenes; a rendszer könnyen online üzembe helyezhető, kevés karbantartást igényel.<br />\n<br />\nAnnak érdekében, hogy segítse a folyóirat archiválását, kérjük legyen tagja a LOCKSS közösségnek, és segítsen összegyűjteni, megőrizni az intézményben készült tudományos műveket és másokat is világszerte. További információért, a rendszer működésének további ismertetéséért keresse fel a LOCKSS oldalát. Várjuk visszajelzését a közös munkával és a folyóirat archiválásával kapcsolatban. <br />\n<br />\nKöszönettel,<br />\n{$principalContactSignature}', 'Ez az email arra bátorítja a címzettet, hogy vegyen részt a LOCKSS kezdeményezésben és vonja be folyóiratát az archivumba. Információt nyújt a LOCKSS kezdeményezésről és a kapcsolódási lehetőségekről.'),
('LOCKSS_NEW_ARCHIVE', 'id_ID', 'Permohonan Pengarsipan untuk {$contextName}', 'Yang terhormat [University Librarian]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, merupakan jurnal yang salah satu anggota fakultas Anda, [name of member], menjadi [title of position]. Jurnal ini hendak membuat arsip sesuai LOCKSS (Lots of Copies Keep Stuff Safe) di perpustakaan Anda dan perpustakaan universitas lainnya.<br />\n<br />\n[Deskripsi singkat jurnal]<br />\n<br />\nProgram LOCKSS &amp;lt;http://lockss.org/&amp;gt;, suatu gerakan perpustakaan/penerbit internasional, merupakan contoh nyata penyimpanan dan pengarsipan terdistribusi, detail tambahan dapat dilihat di bawah. Piranti lunak ini, yang berjalan di komputer biasa, merupakan piranti lunak yang gratis; sistemnya mudah di-online-kan; tidak membutuhkan banyak perawatan.<br />\n<br />\nUntuk membantu mengarsipkan jurnal kami, kami mengundang Anda untuk menjadi anggota komunitas LOCKSS, guna membantu mengumpulkan dan menyimpan judul-judul karya anggota fakultas Anda dan ilmuwan lainnya di seluruh dunia. Jika berkenan, silakan mengunjungi website LOCKSS untuk informasi mengenai bagaimana cara kerja sistem ini. Kami berharap Anda berkenan mendukung pengarsipan jurnal ini.<br />\n<br />\nTerimakasih,<br />\n{$principalContactSignature}', 'Email ini mendorong penerima untuk berpartisipasi di gerakan LOCKSS dan memasukkan jurnal ini dalam arsip. Email ini memberikan informasi tentang gerakan LOCKSS dan cara untuk bergabung.'),
('LOCKSS_NEW_ARCHIVE', 'it_IT', 'Archiviare richiesta per {$contextName}', 'Cara [biblioteca universitaria]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, &amp;amp;#x00E8; un journal per cui un membro della vostra facolt&amp;amp;#x00E0;, [nome del membro], presta servizio come [posizione]. Il journal sta cercando di instaurare un archivio condiviso LOCKSS (Lots of Copies Keep Stuff Safe) con questa e altre biblioteche universitarie.<br />\n<br />\n[Breve descrizione del journal]<br />\n<br />\nIl programma LOCKSS &amp;lt;http://lockss.org/&amp;gt;, una iniziativa biblioteca/editore, &amp;amp;#x00E8; un esempio funzionante di un deposito distribuito di preservazione e archiviazione, dettagli aggiuntivi sono di sotto. Il software, che funziona su personal computer ordinario &amp;amp;#x00E8; libero; il sistema &amp;amp;#x00E8; portato facilmente on-line; la manutenzione continua &amp;amp;#x00E8; pochissima.<br />\n<br />\nPer assistere nell''archiviazione del nostro journal, vi invitiamo a diventare membri della comunit&amp;amp;#x00E0; LOCKSS, per aiutare a collezionare e preservare titoli prodotti dalla vostra facolt&amp;amp;#x00E0; e di altri studiosi a livello mondiale. Per fare questo, si prega di avere qualcuno nel vostro staff che visiti il sito LOCKSS per informazioni su come il sistema opera. Aspetto con impazienza di sentire a voi la possibilit&amp;amp;#x00E0; di fornire questo supporto di archiviazione per questo journal.<br />\n<br />\nGrazie,<br />\n{$principalContactSignature}', 'Questa email incoraggia il destinatario a partecipare all''iniziativa LOCKSS e a includere questo journal nell''archivio. Questa fornisce informazioni sull''iniziativa LOCKSS e sui modi per farne parte.'),
('LOCKSS_NEW_ARCHIVE', 'ja_JP', '『{$contextName}』保存のお願い', '[大学図書館長] 御中<br />\n<br />\n本誌『{$contextName}』 &amp;lt;{$contextUrl}&amp;gt;は、貴学の教官 [教官名]殿に[役職名]をお願いしているものです。本誌は、貴館およびその他の大学図書館との間でLOCKSS（Lots of Copies Keep Stuff Safe）準拠のアーカイブを構築したいと考えております。<br />\n<br />\n[雑誌の簡単な説明]<br />\n<br />\n図書館と出版者による国際的なイニシアティブであるLOCKSS Program &amp;lt;http://lockss.org/&amp;gt;は、分散型保存の運用例としてリポジトリのアーカイブを行うものです。詳細について、以下でご説明します。普通のパソコンで利用できる無料のソフトウェアが存在します。このシステムは容易にオンライン化することができ、保守作業もほとんど必要としません。<br />\n<br />\n私たちの雑誌のアーカイブを支援するために、貴館がLOCKSSコミュニティの一員となり、貴学の教官や世界中の研究者が作成する論文の収集･保存にご協力いただけるようお願いする次第です。そのために、貴館の職員にLOCKSSのサイトにアクセスして、このシステムの運用方法に関する情報を調査するようお願いいたします。貴学が、本誌のためにこのアーカイブサポートを提供していただけるという良い知らせを期待しております。\n<br />\n<br />\nよろしくご検討くださるよう、お願いいたします。<br />\n{$principalContactSignature}', 'このメールは、受信者がLOCKSSイニシアティブに参加し、この雑誌をアーカイブに追加することを薦めるものです。メールでは、LOCKSSイニシアティブに関する情報と参加方法を提供します。'),
('LOCKSS_NEW_ARCHIVE', 'ku_IQ', 'داواکاری بۆ ئەرشیفکردنی {$contextName}', 'بەڕێزان [ئەندامانی کتێبخانەی زانکۆ]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; گۆڤارێکی فاکەڵتییەکەتانە، [ناوی ئەندام]، وەک [ناسناوی زانکۆیی]خزمەت دەکات. گۆڤارەکەمان بە LOCKSS  بۆ ئەرشیفکردنەوە سەرقاڵە لەگەڵ ئەندامانی کتێبخانەکانی زانکۆکانی دیکە.<br />\n<br />\n[کورتەیەک دەربارەی گۆڤار] <br />\n<br />\nپڕۆگرامی LOCKSS &amp;lt;http://lockss.org/&amp;gt;,  پڕۆگرامێکی نێودەوڵەتیی تایبەت بە کتێبخانە و بڵاوکراوەکانە کە لەبواری ئەرشیفکردندا کار دەکات و زانیارییە پێویستییەکان لە خوارەوە بەردەستن. پڕۆگرامەکە لەسەر کۆمپیتەری ئاسایی و بە شێوەی خۆڕایی بەردەستە. سیستەمەکە بە ئاسانی دەخرێتە سەر تۆڕی ئەنتەرنێت و تەنیا کەمێک کارکردن لەسەری داواکراوە.<br />\n<br />\nبۆ هاوکاریکردنی ئەرشیفکردنی گۆڤارەکەمان، ئێمە بەڕێزتان بانگێشت دەکەین تا ببنە ئەندامێکی LOCKSS . بۆ ئەوەی هاوکارمان بن لە کۆکردنەوەی ناونیشان و کارەکانی ئەندامانی فاکەڵتیی خۆتان و تەواوی توێژەرانی جیهان. بۆ ئەمە تکایە کەسێک دیاری بکەن بۆ سەردانیکردنی پەڕەی LOCKSS  بۆ وەرگرتنی زانیاری لەسەر شێوازی کارکردنی سیستەمەکە. ئێمە چاوەڕوانی هەوڵ و هیممەتی ئێوەین.<br /> \n<br />\nسوپاس بۆ هاوکاریتان،<br />\n{$principalContactSignature}', 'ئەم ئیمەیڵە ئێوەی بەڕێز هان دەدات بۆ ئەوەی بەشداری لە سیستەمی LOCKSSدا بکەن و ئەم گۆڤارە بنێرن بۆ سیستەمەکە. زانیاریی تایبەت بە LOCKSS و شێوازی سودمەندبون لێی هاوپێچ کراوە.');
INSERT INTO `email_templates_default_data` VALUES
('LOCKSS_NEW_ARCHIVE', 'mk_MK', 'Барање за архивирање за {$contextName}', 'Почитуван/а [University Librarian]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, е списание за кое што член на вашиот факултет, [name of member] работи како [title of position]. Списанието бара да воспостави архива согласно со LOCKSS (Lots of Copies Keep Stuff Safe) програмата со оваа и останати универзитетски библиотеки.<br />\n<br />\n[Brief description of journal]<br />\n<br />\nLOCKSS програмата &amp;lt;http://lockss.org/&amp;gt;, интернационална библиотека/издавачка иницијатива, е пример за дистрибуирано складиште за зачувување и архивирање, дополнителните детали се подолу. Софтверот, кој што работи на персонален компјутер, е бесплатен; системот може лесно да се купи онлајн; потербно е многу малку тековно одржување.<br />\n<br />\nЗа да учествувате во архивирање на ова списание, ве каниме да станете член на LOCKSS заедницата, да помогнете со собирање и сочувување на наслови направени од страна на вашиот факултет и остнати научници низ целиот свет. За таа цел, ве молиме да испратите некој од вашите вработени да ја посетат страницата на LOCKSS за информации за тоа како работи овој систем. Со нетрпение очекувам да слушнам од вас за можноста за обезбедување на оваа поддршка за архивирање на ова списание.<br />\n<br />\nВи благодарам,<br />\n{$principalContactSignature}', 'Овој и-меил ги охрабрува примателите да учествуваат во LOCKSS иницијативата и да го вклучат ова списание во архивата. Им обезбедува информации за LOCKSS иницијативата и начин како да се приклучат.'),
('LOCKSS_NEW_ARCHIVE', 'nb_NO', 'Forespørsel om arkivering av {$contextName}', 'Kjære [oppgi universitetsbibliotekar]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, er et tidsskrift der en av deres fagansatte, [oppgi medlemsnavn], har påtatt seg å være [oppgi rolletittel]. Tidsskriftet ønsker å etablere et LOCKSS (Lots of Copies Keep Stuff Safe) arkiv, i samarbeid med flere universitetsbibliotek.<br />\n<br />\n[Gi en kort beskrivelse av tidsskriftet]<br />\n<br />\nLOCKSS programmet &amp;lt;http://lockss.org/&amp;gt; er et internasjonalt initiativ for bibliotek og utgivere. LOCKSS er et system for distribuert lagring og arkivering av digitalt innhold (for mer informasjon: se nedenfor). Programvaren kan kjøres fra en vanlig pc, og er gratis. Det er enkelt å få systemet på nett, og det krever ikke mye løpende vedlikehold.<br />\n<br />\nDet er i vår interesse at tidsskriftet vårt blir arkivert og distribuert ved hjelp av LOCKSS. Derfor oppfordrer vi dere til å bli med i LOCKSS samarbeidet, for å samle og bevare digitale publikasjoner laget av deres egne og andre forskere over hele verden. Vennligst besøk LOCKSS eget nettsted for mer informasjon om systemet. Vi ser fram til å høre fra dere, om det kan la seg gjøre for dere å yte denne typen arkivstøtte for tidsskriftet vårt.<br />\n<br />\nVennlig hilsen,<br />\n{$principalContactSignature}', 'Denne e-posten oppfordrer mottakeren til å delta i LOCKSS-initiativet og å innlemme tidsskriftet i sitt arkiv. E-posten gir informasjon om LOCKSS-initiativet og om hvordan man kan delta.'),
('LOCKSS_NEW_ARCHIVE', 'nl_NL', 'Verzoek voor archivering van {$contextName}', 'Beste [Universiteitsbibliothecaris]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, is een tijdschrift waarbij een lid van uw faculteit, [naam van het lid] fungeert als [totel van de positie]. Het tijdschrift streeft naar een LOCKSS (Lots of Copies Keep Stuff Safe) archief met deze en andere universiteitsbibliotheken.<br />\n<br />\n[Korte beschrijving van het tijdschrift]<br />\n<br />\nHet LOCKSS programma &amp;lt;http://lockss.org/&amp;gt;, een internationaal bibliotheek/uitgever initiatief is een operationeel voorbeeld van een gedistribueerd archief voor bescherming en archivering, zie de additionele details hieronder. De software, die op een gewone personal computer draait, is gratis. Het systeem is eenvoudig online te brengen en vraagt weinig onderhoud .<br />\n<br />\nOm ons te helpen met het archiveren van ons tijdschrift, nodigen we u uit om lid te worden van de LOCKSS gemeenschap om te helpen met het verzamelen en archiveren van titel die geproduceerd worden door uw stafleden en andere internationale wetenschappers. Om mee te doen kun u iemand van uw staf de LOCKSS site laten bezoeken voor informatie over hoe dit systeem werkt. Ik kijk uit naar uw reactie over de haalbaarheid voor het leveren van deze archiefdienst voor dit tijdschrift.<br />\n<br />\nDank u,<br />\n{$principalContactSignature}', 'Deze e-mail moedigt de ontvanger aan om deel te nemen in het LOCKSS initiatief en dit tijdschrift in het archief op te nemen. Informatie over het LOCKSS initiatief en manieren om daarbij betrokken te raken worden meegeleverd.'),
('LOCKSS_NEW_ARCHIVE', 'pl_PL', 'Prośba o archiwizowanie czasopisma "{$contextName}"', 'Szanowny [Bibliotekarz uniwersytecki]<br />\n<br />\n{$contextName} &amp;To;{$contextUrl}&amp;gt;, jest czasopismo dla każdego z członków Twojego wydziału, [nazwa użytkownika] pracuje jako [tytuł stanowiska]. Czasopismo dąży do stworzenia  wspólnego archiwum LOCKSS  (Lots of Copies Keep Stuff Safe) z tą biblioteką uniwersytecką i innymi.<br />\n<br />\n[Krótki opis czasopisma]<br />\n<br />\nProgram LOCKSS&amp;to;http://lockss.org/&amp;gt;,  międzynarodowa biblioteka/ inicjatywa publikacyjna, która jest żywym przykładem rozpowszechnionej ochrony i  archiwum, dodatkowe szczegóły znajdują się poniżej. Oprogramowanie na zwykłym osobistym komputerze jest za darmo, system łatwo ściągnąć online, najmniejsza bieżąca forma wsparcia jest wymagana.<br />\n<br />\nAby uczestniczyć  a procesie archiwizacji naszego czasopisma, zachęcamy Cię do zostania członkiem społeczności LOCKSS, aby pomagać zbierać o chronić tytuły stworzone przez Twój wydział i innych naukowców na całym  świecie. Aby to uczynić, prosimy, abyś odwiedził stronę LOCKSS, gdzie znajdziesz informację, jak działa ten system.  Z niecierpliwością czekam na Twoją odpowiedź, czy możesz wykazać się taką formą wsparcia systemu archiwizacji dla tego czasopisma. <br />\n<br />\nZ poważaniem,<br />\n{$principalContactSignature}', 'Ta wiadomość zachęca odbiorcę do udziału w inicjatywie LOCKSS i włączenie tego czasopisma do archiwum. Zawiera informację o inicjatywie LOCKSS oraz sposobu dołączenia do niej.'),
('LOCKSS_NEW_ARCHIVE', 'pt_BR', 'Solicitação de inclusão da revista {$contextName} em seu arquivo', 'Prezado(a) [Bibliotecário(a) da Universidade]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, é um periódico no qual um membro de sua instituição, [nome do membro], serve como [título da posição]. O periódico está buscando estabelecer um acervo compatível com o LOCKSS (Lots of Copies Keep Stuff Safe) com esta e outras bibliotecas universitárias.<br />\n<br />\n[Breve descrição do periódico]<br />\n<br />\nO Programa LOCKSS &amp;lt;http://lockss.org/&amp;gt;, uma iniciativa internacional entre bibliotecas e editoras, é um exemplo prático de um repositório de preservação e arquivamento distribuído, conforme detalhes adicionais abaixo. O software, que roda em um computador pessoal comum, é gratuito; o sistema é facilmente colocado online; e pouca manutenção é necessária.<br /> \n<br />\nPara ajudar no arquivamento de nosso periódico, convidamos você a se tornar um membro da comunidade LOCKSS, para ajudar a coletar e preservar títulos produzidos por seu corpo docente e por outros acadêmicos no mundo todo. Para fazer isso, peça a alguém da sua equipe que visite o site da LOCKSS para obter informações sobre como este sistema opera. Agradeço seu retorno a respeito da viabilidade de fornecer esse suporte de arquivamento para este periódico. <br />\n<br />\nAtenciosamente,<br />\n{$principalContactSignature}', 'Mensagem convida o destinatário a participar da iniciativa LOCKSS e incluir a revista no seu repositório. O e-mail oferece informações iniciais e sobre como participar na iniciativa LOCKSS e formas de se envolver.'),
('LOCKSS_NEW_ARCHIVE', 'pt_PT', 'Pedido de inclusão para arquivo da revista {$contextName}', 'Caro(a) [Bibliotecária(o) da Universidade]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; é uma revista na qual um membro da sua instituição, [nome da pessoa], possui o papel editorial de [título da função editorial]. Esta revista deseja obter arquivo através de LOCKSS (Lots of Copies Keep Stuff Safe - Muitas Cópias Mantém as Coisas Seguras) compatível com esta e outras bibliotecas de instituições de ensino superior.<br />\n<br />\n[Breve descrição da revista]<br />\n<br />\nO sistema LOCKSS &amp;lt;http://lockss.org/&amp;gt;, uma iniciativa internacional de bibliotecas/editoras, é um exemplo funcional de um repositório digital de preservação e arquivo distribuído. O software, que corre num computador pessoal comum, é gratuito; o sistema permite a sua implementação e disponibilização online de forma rápida, e a sua manutenção é mínima.<br />\n<br />\nPara auxiliar no arquivo da nossa revista, convidamos a sua biblioteca a tornar-se membro da comunidade LOCKSS, e ajudar a recolher e preservar títulos produzidos mundialmente. Para isso, visite o site do LOCKSS para saber como funciona o sistema e como fazer parte da comunidade.<br />\n<br />\nAgradecendo desde já a sua atenção,<br />\n{$principalContactSignature}', 'Este e-mail encoraja o destinatário a participar da iniciativa LOCKSS e incluir esta revista no seu repositório, oferecendo informações iniciais e sobre como participar na iniciativa LOCKSS.'),
('LOCKSS_NEW_ARCHIVE', 'ro_RO', 'Cerere de arhivare pentru {$contextName}', 'Stimate(ă) [University Librarian]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, este o revistă științifică la care un membru al facultății tale, [name of member] contribuie ca și [title of position]. Jurnalul încearcă să stabilească o arhivă conformă cu LOCKSS (Lots of Copies Keep Stuff Safe) cu această bibliotecă și cu alte biblioteci universitare.<br />\n<br />\n[Brief description of journal]<br />\n<br />\nProgramul LOCKSS  &amp;lt;http://lockss.org/&amp;gt;, este o inițiativă internațională a bibliotecii și editorilor. Acesta este un exemplu de lucru al unui depozit de conservare și arhivare distribuit (mai multe detalii sunt mai jos). Programul, care rulează pe un computer personal obișnuit este gratuit; acest sistem este ușor adus on-line; întreținerea acestuia este continuă cu resurse foarte reduse.<br />\n<br />\nPentru a ajuta la arhivarea jurnalului nostru, vă invităm să deveniți membru al comunității LOCKSS, contribuind astfel la colectarea și păstrarea titlurilor produse de facultatea dvs. și de alți cercetători din întreaga lume. Pentru a face acest lucru, vă rugăm să delegai pe cineva din personalul dvs. să viziteze site-ul LOCKSS în vederea informării despre cum funcționează acest sistem. Așteptăm cu nerăbdare să vă spuneți părerea despre fezabilitatea acestui suport de arhivare pentru această revistă.<br />\n<br />\nMulțumesc,<br />\n{$principalContactSignature}', 'Acest e-mail încurajează destinatarul să participe la inițiativa LOCKSS și să includă acest jurnal în arhivă. Oferă informații despre inițiativa LOCKSS și modalități de implicare.'),
('LOCKSS_NEW_ARCHIVE', 'ru_RU', 'Запрос на архивацию для журнала «{$contextName}»', 'Уважаемый [библиотекарь университета]!<br />\n<br />\n«{$contextName}» &amp;lt;{$contextUrl}&amp;gt; — журнал, в котором сотрудник Вашего университета, [имя сотрудника], занимает должность [название должности]. Наш журнал хотел бы создать LOCKSS(Lots of Copies Keep Stuff Safe)-совместимый архив с библиотеками Вашего и других университетов.<br />\n<br />\n[Краткое описание журнала]<br />\n<br />\nПрограмма LOCKSS &amp;lt;http://lockss.org/&amp;gt; — международная инициатива библиотек и издателей, работающий пример распределенного архивного хранилища (подробности об этом ниже). Программное обеспечение, запускаемое на обычном персональном компьютере, является бесплатным; система легко подключается к сети Интернет; практически не требует усилий под поддержанию в рабочем состоянии.<br />\n<br />\nЧтобы помочь в архивации нашего журнала, мы приглашаем Вас стать членом сообщества LOCKSS, чтобы помочь собирать и сохранять статьи, созданные сотрудниками Вашего университета и другими учеными по всему миру. Чтобы сделать это, пожалуйста, поручите кому-то из Вашего персонала зайти на сайт LOCKSS, чтобы узнать информацию о том, как работает эта система. Жду Вашего ответа о возможности предоставить эту архивную поддержку для нашего журнала.<br />\n<br />\nС уважением,<br />\n{$principalContactSignature}', 'Это письмо предлагает получателю принять участие в инициативе LOCKSS и включить этот журнал в архив. В письме содержится информация об инициативе LOCKSS initiative и способах к ней присоединиться.'),
('LOCKSS_NEW_ARCHIVE', 'sk_SK', 'Žiadosť o archiváciu pre {$contextName}', 'Vážený [univerzitní knihovník]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; je časopis, v ktorom pracovník Vašej univerzity [meno pracovníka] zastáva pozíciu [názov pozície]. Tento časopis má záujem vybudovať archív kompatibilný s programom LOCKSS (Lots of Copies Keep Stuff Safe) spoločne s touto knižnicou a ďalšími univerzitnými knižnicami.<br />\n<br />\n[Krátky popis časopisu]<br />\n<br />\nProgram LOCKSS &amp;lt;http://lockss.org/&amp;gt;, medzinárodná iniciatíva knižníc/vydavateľov, je fungujúcim príkladom archivačného úložiska s distribuovanou ochranou. Ďalšie detaily viď nižšie. Softvér, ktorý funguje na bežnom osobnom počítači, je zadarmo; systém je ľahko prevoditeľný on-line; je vyžadované veľmi málo následnej údržby.<br />\n<br />\nZ dôvodu pomoci pri archivovaní nášho časopisu Vás pozývame, aby ste sa stal členom LOCKSS komunity a pomáhal tak zhromažďovať a zachovávať prácu produkovanú pracovníkmi Vašej univerzity i ďalších vedeckých pracovníkov z celého sveta. Aby ste tak mohli urobiť, poverte prosím niekoho z Vašich pracovníkov, nech navštívi stránky LOCKSS, kde nájde informácie, ako tento systém pracuje. Teším sa, že ma budete informovať o možnostiach poskytnutia archivačnej podpory časopisu.<br />\n<br />\nĎakujeme,<br />\n{$principalContactSignature}', 'Tento email nabáda príjemcu, aby sa zapojil do LOCKSS iniciatívy a zahrnul tento časopis do archívu. Obsahuje informácie o LOCKSS iniciatíve a spôsobu, ako sa do nej zapojiť.'),
('LOCKSS_NEW_ARCHIVE', 'sl_SI', 'Prošnja za arhiviranje revije {$contextName}', 'Dear [University Librarian]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, is a journal for which a member of your faculty, [name of member] serves as a [title of position]. The journal is seeking to establish a LOCKSS (Lots of Copies Keep Stuff Safe) compliant archive with this and other university libraries.<br />\n<br />\n[Brief description of journal]<br />\n<br />\nThe LOCKSS Program &amp;lt;http://lockss.org/&amp;gt;, an international library/publisher initiative, is a working example of a distributed preservation and archiving repository, additional details are below. The software, which runs on an ordinary personal computer is free; the system is easily brought on-line; very little ongoing maintenance is required.<br />\n<br />\nTo assist in the archiving of our journal, we invite you to become a member of the LOCKSS community, to help collect and preserve titles produced by your faculty and by other scholars worldwide. To do so, please have someone on your staff visit the LOCKSS site for information on how this system operates. I look forward to hearing from you on the feasibility of providing this archiving support for this journal.<br />\n<br />\nThank you,<br />\n{$principalContactSignature}', 'Email vsebuje prošnjo za naslovnika, da se vključi v LOCKSS iniciativo in za vključitev te revije v njihov arhiv. Vsebuje tudi informaciej o LOCKKS iniciativi in načinu vključitve v iniciativo.'),
('LOCKSS_NEW_ARCHIVE', 'sv_SE', 'Förfrågan om arkivering för {$contextName}', 'Hej [universitetsbibliotekarie]!<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; är en tidskrift där en medarbetare på ditt lärosäte, [namn på medarbetaren], bistår som [namn på position]. Tidskriften vill etablera ett LOCKSS-kompatibelt (Lots of Copies Keep Stuff Safe) arkiv vid det här och andra universitetsbibliotek.<br />\n<br />\n[Kortfattad beskrivning av tidskriften]<br />\n<br />\nLOCKSS-samarbetet &amp;lt;http://lockss.org/&amp;gt;, ett internationellt biblioteks- och utgivarinitiativ, är ett exempel på ett distribuerat arkiv för bevarande (se nedan för ytterligare information). Mjukvaran är gratis och kan köras på en vanlig dator. Systemet hämtas från nätet och kräver väldigt litet kontinuerligt underhåll.<br />\n<br />\nDet skulle vara till stor hjälp för oss i sökandet efter bevarandelösningar för vår tidskrift om ni ville överväga att bli medlemmar i LOCKSS-gemenskapen och på det sättet hjälpa till att samla och bevara titlar producerade vid lärosätet och av andra forskare runt om i världen. Om ni vill gå vidare med detta, vänligen se LOCKSS webbplats för mer information om hur systemet fungerar. Jag ser fram emot att höra från er angående möjligheterna för er att stödja arkiveringen av vår tidskrift genom detta.<br />\n<br />\nTack och med vänliga hälsningar,<br />\n{$principalContactSignature}', 'Det här e-postmeddelandet rekommenderar mottagaren att delta i LOCKSS-initiativet och att inkludera tidskriften i arkivet. Meddelandet innehåller även generell information om LOCKSS och hur man gör för att delta.'),
('LOCKSS_NEW_ARCHIVE', 'tr_TR', '{$contextName} dergisi arşivleme talebi', 'Sayın [University Librarian]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt; dergisi için fakültenizin üyesi [name of member] [title of position] görevini üstlenmiştir. Dergi bu ve diğer üniversite kütüphaneleri ile LOCKSS (Lots of Copies Keep Stuff Safe – çok sayıda kopya güvenliğini koruma) uyumlu arşiv oluşturmayı hedeflemektedir. <br />\n<br />\n<br />\n[Brief description of journal]<br />\n<br />\nLOCKSS programı &amp;lt;http://lockss.org/&amp;gt;, uluslararası bir kütüphane/yayımcı organizasyonu olup bir arşivin yaygın ve güvenilir olarak kullanılmasını sağlayan etkin bir örnektir. Diğer detaylar aşağıda belirtilmiştir. Standart kişisel bilgisayarlarda kullanılabilen yazılım ücretsizdir, sistem kolaylıkla aktif olabilmekte ve çok az bakım gerektirmektedir. <br />\n<br />\nDerginizin arşivlenebilmesi için sizi LOCKSS topluluğunun üyesi olmaya davet ediyoruz. Böylelikle gerek fakültenizden gerek dünya çapında diğer araştırma birimlerinden çalışmaları toplayabilir ve güvenle saklayabilirsiniz. Bu amaçla bir çalışanınızı görevlendirerek LOCKSS sitesini ziyaret etmesini ve sistem çalışması ile ilgili bilgileri edinmesini sağlayınız. Sizden bu derginin arşiv desteğinin fizibilitesi ile ilgili haber bekliyor olacağım.<br />\n<br />\nTeşekkür ederim<br />\n{$principalContactSignature}', 'Bu e-posta alıcının dergisini LOCKSS arşiv sistemine dahil etmeye yönelik önerme içermektedir. LOCKSS çalşıma biçimi ve katılımcı olma ile ilgili bilgiler sağlamaktadır.'),
('LOCKSS_NEW_ARCHIVE', 'uk_UA', 'Запит на архівування видання {$contextName}', 'Шановний [Бібліотекар Університету]<br />\n<br />\n{$contextName} &amp;lt;<a href="{$contextUrl}">{$contextUrl}</a>&amp;gt; - це журнал, для якого Ваш співробітник [Ім''я співробітника] виконує роль [посада у редакційному штаті]. Наш журнал прагне мати архів, сумісний з LOCKSS (Lots of Copies Keep Stuff Safe) у Вашій бібліотеці та бібліотеках інших університетів.<br />\n<br />\n[Короткий опис журналу]<br />\n<br />\nПрограма LOCKSS &amp;lt;http://lockss.org/&amp;gt; - це міжнародна ініціатива бібліотек та видавців, яка є прикладом працездатної моделі розподіленого архівного збереження цифрового змісту. Необхідне програмне забезпечення є безкоштовним, воно працює на звичайному персональному комп''ютері; систему дуже легко розгорнути в режимі онлайн; вона потребує мінімальної підтримки та супроводу.<br />\n<br />\nЩоб допомогти архівувати наш журнал, ми запрошуємо Вас стати членом спільноти LOCKSS та приєднатись до ініціативи збирання та збереження наукового змісту, виробленого співробітниками Вашої установи та вченими з усього світу. Для цього, дайте доручення одному з Ваших співробітників, завітати на веб-сайт LOCKSS та отримати інформацію про те, як функціонує система. Я з нетерпінням чекаю Вашої відповіді щодо можливості надання допомоги у питаннях архівування нашого журналу.<br />\n<br />\nДякую,<br />\n{$principalContactSignature}', 'Цей лист надсилається як пропозиція приєднання адресата до ініціативи LOCKSS та включення цього журналу до архіву. В ньому міститься інформація про ініціативу LOCKSS та шляхи приєднання до неї.'),
('LOCKSS_NEW_ARCHIVE', 'vi_VN', 'Yêu cầu lưu trữ cho {$contextName}', 'Kính gửi [University Librarian]<br />\n<br />\n{$contextName} &amp;lt;{$contextUrl}&amp;gt;, là một tạp chí mà một thành viên của khoa của bạn, [name of member] như một [title of position]. Tạp chí đang tìm cách thiết lập một kho lưu trữ tuân thủ LOCKSS (Lots of Copies Keep Stuff Safe) với thư viện này và các thư viện đại học khác.<br />\n<br />\n[Brief description of journal]<br />\n<br />\nChương trình LOCKSS &amp;lt;http://lockss.org/&amp;gt;, một sáng kiến thư viện/nhà xuất bản quốc tế, là một ví dụ hoạt động của kho lưu trữ và lưu trữ phân tán, chi tiết bổ sung dưới đây. Phần mềm chạy trên máy tính cá nhân thông thường là miễn phí; hệ thống dễ dàng được đưa lên mạng; rất ít yêu cầu bảo trì liên tục.<br />\n<br />\nĐể hỗ trợ lưu trữ tạp chí của chúng tôi, chúng tôi mời bạn trở thành thành viên của cộng đồng LOCKSS, để giúp thu thập và lưu trữ các nghiên cứu do giảng viên của bạn và các học giả khác trên toàn thế giới tạo nên. Để làm như vậy, vui lòng truy cập trang web LOCKSS để biết thông tin về cách hệ thống này hoạt động. Tôi mong muốn được lắng nghe từ bạn về tính khả thi của việc cung cấp hỗ trợ lưu trữ cho tạp chí này.<br />\n<br />\nTrân trọng,<br />\n{$principalContactSignature}', 'Email này khuyến khích người nhận tham gia sáng kiến LOCKSS và đưa tạp chí này vào kho lưu trữ. Nó cung cấp thông tin về sáng kiến LOCKSS và các cách để tham gia.'),
('LOCKSS_NEW_ARCHIVE', 'zh_CN', '请存档《{$contextName}》', '亲爱的[大学图书馆]：<br />\n<br />\n《{$contextName}》 &amp;lt;{$contextUrl}&amp;gt;是一份适合贵单位一位教职员的期刊：[成员名称]，[职称]。这份期刊正试着与这个图书馆与其他大学图书馆，共同建立一个符合洛克斯存档计划(LOCKSS; Lots of Copies Keep Stuff Safe)的检藏资料库。<br />\n<br />\n[期刊的简介]<br />\n<br />\n洛克斯计划&amp;lt;http://lockss.stanford.edu/&amp;gt;是一个国际图书馆＼出版商发起的计划，是一个流通性保存与存档库的典范，详情如后。这份软体在个人电脑上运作实是免费的；这个系统很容易放置到网络上；而且只需要很少的维护工作。<br />\n<br />\n为了协助存档我们的期刊，我们邀请贵单位加入成为一个洛克斯社群的成员，有助于搜集和保存由贵单位的教职员以及世界各地学者所生产的作品。要做到这一点，请贵单位的一位工作人员访问洛克斯网站，以取得此系统如何运作的进一步信息。我们期盼贵单位能够实现这个职员存档本期刊的工作。<br />\n<br />\n谢谢您<br />\n{$principalContactSignature}', '这封电子邮件鼓励收件人成为洛克斯计划成员，并收录本期刊进入存档。邮件提供了关于洛克斯计划的信息以及如何加入的办法。'),
('MANUAL_PAYMENT_NOTIFICATION', 'ar_IQ', 'إشعار الدفع اليدوي', 'عملية دفع يدوي بحاجة إلى معالجتها تخص المجلة {$contextName} والمستخدم {$userFullName} (اسم المستخدم &quot;{$userName}&quot;).<br />\n<br />\nالفقرة التي في النية دفع المال لها هي &quot;{$itemName}&quot;.<br />\nالكلفة هي {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nتم إنشاء رسالة البريد الالكتروني هذه من قبل إضافة الدفع المالي اليدوي لنظام المجلات المفتوحة.', 'قالب هذه الرسالة يستعمل لإشعار رئيس تحرير المجلة أو مدير تحريرها بحدوث مطالبة لدفع المال يدوياً في المجلة.'),
('MANUAL_PAYMENT_NOTIFICATION', 'ca_ES', 'Notificació de pagament manual', 'Es necessari processar un pagament manual per a la revista {$contextName} i l''usuari/ària {$userFullName} (username &quot;{$userName}&quot;).<br />\n<br />\nL''element pel qual s''ha de pagar és &quot;{$itemName}&quot;.<br />\nEl cost és {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nAquest correu electrònic ha estat generat pel mòdul de pagament manual d''Open Journal Systems.', 'Aquesta plantilla de correu electrònic s''utilitza per notificar l''administrador/a de la revista que s''ha sol·licitat un pagament manual.'),
('MANUAL_PAYMENT_NOTIFICATION', 'cs_CZ', 'Oznámení o manuální platbě', 'Je třeba zpracovat manuální platbu pro časopis {$contextName} a uživatele {$userFullName} (uživatelské jméno &quot;{$userName}&quot;).<br />\n<br />\nPoložka, za kterou je placeno &quot;{$itemName}&quot;.<br />\nCena je {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nTento email byl vygenerován OJS pluginem Manuální platby.', 'Tato e-mailová šablona slouží k upozornění kontaktu manažera časopisu, že byla požadována manuální platba.'),
('MANUAL_PAYMENT_NOTIFICATION', 'da_DK', 'Meddelelse om manuel betaling', 'Der skal gennemføres en manuel betaling for tidsskriftet {$contextName} og brugeren {$userFullName} (username &quot;{$userName}&quot;).<br /></br>\n</br>\nBetalingen vedrører &quot;{$itemName}&quot;.<br />\nPrisen er {$itemCost} ({$itemCurrencyCode}).</br>\n</br>\nDenne e-mail blev genereret af Open Journal Systems'' plugin for manuelle betalinger.', 'Denne e-mail bruges til at meddele en af tidsskriftschefens kontakter, at der skal foretage en manuel betaling.'),
('MANUAL_PAYMENT_NOTIFICATION', 'de_DE', 'Benachrichtigung über manuelle Zahlung', 'Eine manuelle Zahlung ist für die Zeitschrift {$contextName} und den/die Benutzer/in {$userFullName} (Benutzer/innen-Name &quot;{$userName}&quot;) angekündigt worden.<br />\n<br />\nGezahlt werden soll für &quot;{$itemName}&quot;.<br />\nDie Kosten betragen {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nDiese E-Mail wurde vom OJS-Plugin Manuelle Gebührenzahlung erzeugt.', 'Diese E-Mail-Vorlage wird genutzt, um eine/n Zeitschriftenverwalter/in darüber zu benachrichtigen, dass eine manuelle Zahlung beantragt worden ist.'),
('MANUAL_PAYMENT_NOTIFICATION', 'el_GR', 'Μη αυτόματη ειδοποίηση πληρωμής', 'Πρέπει να διεκπεραιωθεί μια μη αυτόματη πληρωμή για το περιοδικό {$contextName} και ο χρήστης {$userFullName} (username &quot;{$userName}&quot;).<br />\n<br />\n Το αντικείμενο για το οποίο πληρώνεται είναι &quot;{$itemName}&quot;.<br />\n Το κόστος είναι {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\n Αυτό το μήνυμα ηλεκτρονικού ταχυδρομείου δημιουργήθηκε από την προσθήκη Open Journal Systems'' Manual Payment.', 'Αυτό το πρότυπο ηλεκτρονικού ταχυδρομείου χρησιμοποιείται για να ειδοποιήσει μια επαφή διαχειριστή περιοδικού ότι ζητήθηκε μη αυτόματη πληρωμή.'),
('MANUAL_PAYMENT_NOTIFICATION', 'en_US', 'Manual Payment Notification', 'A manual payment needs to be processed for the journal {$contextName} and the user {$userFullName} (username &quot;{$userName}&quot;).<br />\n<br />\nThe item being paid for is &quot;{$itemName}&quot;.<br />\nThe cost is {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nThis email was generated by Open Journal Systems'' Manual Payment plugin.', 'This email template is used to notify a journal manager contact that a manual payment was requested.'),
('MANUAL_PAYMENT_NOTIFICATION', 'es_ES', 'Notificación de pago manual', 'Un pago manual necesita ser procesado para la revista  {$contextName} y el usuario {$userFullName} (username &quot;{$userName}&quot;).<br />\n<br />\nEl ítem pagado es &quot;{$itemName}&quot;.<br />\nEl precio es {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nEste correo ha sido generado por el módulo de Pago Manual de Open Journal Systems.', 'Este correo electrónico se usa para notificar al gestor/a de la revista de que se ha solicitado un pago manual.'),
('MANUAL_PAYMENT_NOTIFICATION', 'eu_ES', 'Eskuzko ordainketaren jakinarazpena', '{$userFullName} erabiltzaileak (&quot;{$userName}&quot; erab.-iz.) {$contextName} aldizkarirako egindako eskuzko ordainketa bat prozesatu beharrean dago.<br />\n<br />\nOrdaindu beharreko lana &quot;{$itemName}&quot; da.<br />\nKostua : {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nMezu hau Open Journal Systems-en Eskuzko ordainketen pluginak sortu du.', 'Mezu-txantiloi hau aldizkariaren kudeatzaileari eskuzko ordainketa bat eskatu dela jakinarazteko erabiltzen da.'),
('MANUAL_PAYMENT_NOTIFICATION', 'fa_IR', 'اطلاع رسانی پرداخت دستی', 'یک پرداخت دستی قرار است برای مجله {$contextName} از طرف کاربر {$userFullName} (username &quot;{$userName}&quot;) صورت گیرد.<br />\n<br />\nمورد خرید &quot;{$itemName}&quot;.<br />\nقیمت {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nاین ایمیل توسط افزونه پرداخت دستی سیستم های مجله آزاد ایجاد شده است.', '##emails.manualPaymentNotification.description##'),
('MANUAL_PAYMENT_NOTIFICATION', 'fi_FI', 'Ilmoitus manuaalisesta maksusta', 'Käyttäjän {$userFullName} (käyttäjätunnus &quot;{$userName}&quot;) tekemä, julkaisuun {$contextName} kohdistuva manuaalinen maksu on käsiteltävä.<br />\n<br />\nMaksettava kohde on &quot;{$itemName}&quot;.<br />\nHinta: {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nTämä sähköposti on Open Journal Systemsin Manuaalinen maksu -lisäosan luoma.', 'Tällä sähköpostipohjalla tiedotetaan julkaisun hallinnoijaa, että tilaajalta on pyydetty manuaalista maksua.'),
('MANUAL_PAYMENT_NOTIFICATION', 'fr_CA', 'Avis de paiement manuel', 'Un paiement manuel doit être traité pour la revue {$contextName} et l''utilisateur {$userFullName} (nom d''utilisateur &quot;{$userName}&quot;).<br />\n<br />\nL''élément facturé est &quot;{$itemName}&quot;.<br />\nLe coût est de {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nCe courriel a été généré par le plugiciel de paiement manuel du Open Journal Systems.', 'Ce modèle de courriel est utilisé pour aviser un directeur de revue que le paiement manuel a été demandé.'),
('MANUAL_PAYMENT_NOTIFICATION', 'fr_FR', 'Notification de paiement manuel', 'Un paiement manuel doit être traité pour la revue {$contextName} et l''utilisateur ou utilisatrice {$userFullName} (nom d''utilisateur ou d''utilisatrice &quot;{$userName}&quot;).<br />\n<br />\nL''élément facturé est &quot;{$itemName}&quot;.<br />\nLe coût est de {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nCe courriel a été généré par le module de paiement manuel d''Open Journal Systems.', 'Ce modèle de courriel est utilisé pour notifier un directeur ou une directrice de revue qu''un paiement manuel a été demandé.'),
('MANUAL_PAYMENT_NOTIFICATION', 'id_ID', 'Pemberitahuan Pembayaran Manual', 'Pembayaran manual harus diproses untuk jurnal {$contextName} dan pengguna {$userFullName} (username &quot;{$userName}&quot;).<br />\n<br />\nItem yang akan dibayar adalah &quot;{$itemName}&quot;.<br />\nBiayanya {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nSurat elektronik ini dibuat oleh plugin Pembayaran Manual OJS.', 'Email ini digunakan untuk memberitahukan kontak manajer jurnal bahwa pembayaran manual dibutuhkan.'),
('MANUAL_PAYMENT_NOTIFICATION', 'it_IT', 'Notifica di pagamento manuale', 'Bisogna registrare un pagamento offline per  {$contextName}, utente {$userFullName} (username &quot;{$userName}&quot;).<br />\n<br />\nIl pagamento riguarda &quot;{$itemName}&quot;.<br />\nIl costo è {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nQuesta email è generata automaticamente da Open Journal Systems'' Manual Payment plugin.', 'Questo template viene usato per notificare a journal manager che un pagamento manuale è stato richiesto.'),
('MANUAL_PAYMENT_NOTIFICATION', 'mk_MK', 'Известување за рачно плаќање', 'Треба да се обработи рачно плаќање за списанието {$contextName} и за корисникот {$userFullName} (корисничко име &quot;{$userName}&quot;). <br />\n<br />\nПредметот за кој се плаќа е &quot;{$itemName}&quot;. <br />\nЦената е {$itemCost} ({$itemCurrencyCode}). <br />\n<br />\nОваа е-пошта е генерирана од приклучокот за рачно плаќање на Open Journal Systems.', 'Овој образец за е-пошта се користи за да го извести контактот на менаџерот за списанија дека е побарано рачно плаќање.'),
('MANUAL_PAYMENT_NOTIFICATION', 'nb_NO', 'Beskjed om manuell betaling', 'Det må utføres en manuell betaling for tidsskriftet {$contextName} og brukeren {$userFullName} (brukernavn &quot; {$userName} &quot;).  <br />\n<br />\nBetalingen er for &quot; {$itemName} &quot;. <br />\nPrisen er {$itemCost} ({$itemCurrencyCode}). <br />\n<br />\nDette er en automatisk generert e-post fra Open Journal Systems sitt manuelle betalings-programtillegg.', 'Denne e-posten brukes til å meddele en abbonementskontakt om en forespørsel om en manuell betaling.'),
('MANUAL_PAYMENT_NOTIFICATION', 'nl_NL', 'Bericht van handmatige betaling', 'Er moet een handmatige betaling verwerkt worden voor tijdschrift {$contextName} en gebruiker {$userFullName} (gebruikersnaam &quot;{$userName}&quot;).<br />\n<br />\nEr wordt betaald voor &quot;{$itemName}&quot;.<br />\nDe prijs is {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nDeze e-mail is gegenereerd door de Handmatige betalingen plugin van Open Journal Systems.', 'Dit e-mail sjabloon wordt gebruikt om een tijdschriftbeheerder te verwittigen dat een handmatige betaling werd aangevraagd.'),
('MANUAL_PAYMENT_NOTIFICATION', 'pl_PL', 'Manualne powiadomienie o płatności', 'Płatność manualna musi być przeprowadzona dla czasopisma {$contextName} i użytkownika  {$userFullName} (username &quot;{$userName}&quot;).<br />\n<br />\nOpłacana pozycja to: &quot;{$itemName}&quot;.<br />\nKoszt: {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nTen email został wysłany automatycznie przez wtyczkę manualnej płatności Open Journal System.', 'Ten szablon wiadomości jest wykorzystywany do powiadomienia administratora czasopisma, że została przesłana manualna prośba o płatność.'),
('MANUAL_PAYMENT_NOTIFICATION', 'pt_BR', 'Notificação de pagamento manual', 'É necessário realizar o processamento de um pagamento manual de assinatura da revista {$contextName}, pelo usuário {$userFullName} (login &quot;{$userName}&quot;).<br />\n<br />\nO item adquirido é &quot;{$itemName}&quot;.<br />\nValor em ({$itemCurrencyCode}): {$itemCost}<br />\n<br />\nEsta é uma mensagem automática da ferramenta de Pagamento manual do Open Journal Systems.', 'Mensagem automática notificando editor-gerente que um pagamento manual foi realizado e exige processamento.'),
('MANUAL_PAYMENT_NOTIFICATION', 'pt_PT', 'Notificação de pagamento manual', 'É necessário realizar o processamento de um pagamento manual de assinatura da revista {$contextName} do utilizador {$userFullName} (username &quot;{$userName}&quot;).<br />\n<br />\nO item adquirido é &quot;{$itemName}&quot;.<br />\nO custo é {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nEsta mensagem foi gerada pelo Plugin de Pagamento Manual do OJS.', 'Este e-mail notifica o editor-gestor que um pagamento manual foi realizado e exige processamento.'),
('MANUAL_PAYMENT_NOTIFICATION', 'ru_RU', 'Уведомление о платеже', 'Необходимо вручную обработать платеж для журнала «{$contextName}» и пользователя {$userFullName} (имя пользователя «{$userName}»).<br />\n<br />\nОплата вносится за «{$itemName}».<br />\nСумма {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nЭто письмо сгенерировано модулем «Ввод оплаты вручную» системы Open Journal Systems.', 'Этот шаблон письма используется для уведомления управляющего журналом о том, что был запрошен ввод оплаты вручную.'),
('MANUAL_PAYMENT_NOTIFICATION', 'sk_SK', 'Oznámenie o manuálnej platbe', 'Je potrebné spracova manuálnu platbu pre časopis {$contextName} a užívateľa {$userFullName} (užívateľské meno &quot;{$userName}&quot;).<br />\n<br />\nPoložka, za ktorú je platené &quot;{$itemName}&quot;.<br />\nCena je {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nTento email bol vygenerovaný OJS pluginom Manuálne platby.', 'Táto e-mailová šablóna slúži k upozorneniu kontaktu manažéra časopisu, že bola požadovaná manuálna platba.'),
('MANUAL_PAYMENT_NOTIFICATION', 'sl_SI', 'Manual Payment Notification', 'A manual payment needs to be processed for the journal {$contextName} and the user {$userFullName} (username &quot;{$userName}&quot;).<br />\n<br />\nThe item being paid for is &quot;{$itemName}&quot;.<br />\nThe cost is {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nThis email was generated by Open Journal Systems'' Manual Payment plugin.', 'This email template is used to notify a journal manager contact that a manual payment was requested.'),
('MANUAL_PAYMENT_NOTIFICATION', 'tr_TR', 'Manuel Ödeme Bildirimi', '{$contextName} için {$userFullName} (username &quot;{$userName}&quot;) tarafından manuel ödeme yapılması gerekmektedir.<br />\n<br />\nÖdenen oge &quot;{$itemName}&quot;.<br />\nMaliyeti {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nBu e-posta Open Journal Systems''ın Manuel Ödeme eklentisi tarafından oluşturuldu.', 'Bu e-posta şablonu, dergi yöneticisine manuel ödeme talep edildiğini bildirmek için kullanılır.'),
('MANUAL_PAYMENT_NOTIFICATION', 'uk_UA', 'Інформування про платіж', 'На рахунок журналу {$contextName} користувачем {$userFullName} (username &quot;{$userName}&quot;) повинен бути перерахований платіж.<br />\n<br />\nЦе плата за &quot;{$itemName}&quot;.<br />\nСума платежу {$itemCost} ({$itemCurrencyCode}).<br />\n<br />\nЦей лист був створений модулем ручних платежів системи Open Journal Systems.', 'Цей шаблон листа використовується для інформування менеджера журнала про запит на здійснення ручного платежу.'),
('MANUAL_PAYMENT_NOTIFICATION', 'zh_CN', '人工支付通知', '人工支付需要被{$contextName}期刊的{$userFullName}来处理（用户名&quot;{$userName}&quot;）。<br />\n<br />\n被支付的项目：&quot;{$itemName}&quot;。<br />\n费用：{$itemCost} ({$itemCurrencyCode})。<br />\n<br />\n此邮件是由开放期刊系统的人工支付插件生成的。', '这封电子邮件用来通知期刊管理员去处理一个人工支付请求。'),
('NOTIFICATION', 'ar_IQ', 'إشعار جديد من {$siteTitle}', 'لديك إشعار جديد من {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nالرابط: {$url}<br />\n<br />\n{$principalContactSignature}', 'رسالة البريد الالكتروني هذه مرسلة إلى المستخدمين المسجلين الذين اختاروا استلام إشعار من هذا النوع عبر البريد الالكتروني.'),
('NOTIFICATION', 'bs_BA', 'Nova obavijest od {$siteTitle}', 'Imate novu obavijest od {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'E-mail je poslan registrovanom korisniku koji je odabrao ovaj način obavijesti putem mail-a.'),
('NOTIFICATION', 'ca_ES', 'Notificació nova de {$siteTitle}', 'Teniu una notificació nova de {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nEnllaç: {$url}<br />\n<br />\n{$principalContactSignature}', 'El correu electrònic s''envia a usuaris/àries registrats que hagin seleccionat rebre aquest tipus de notificació.'),
('NOTIFICATION', 'cs_CZ', 'Nové oznámení od {$siteTitle}', 'Máte nové oznámení od {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nOdkaz: {$url}<br />\n<br />\n{$principalContactSignature}', 'E-mail se odešle registrovaným uživatelům, kteří mají povolený příjem tohoto typu oznámení.'),
('NOTIFICATION', 'da_DK', 'Ny meddelelse fra {$siteTitle}', 'Du har modtaget en ny meddelelse fra {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'Denne e-mail er blevet sendt til registrerede brugere, som har valgt at få tilsendt denne type meddelelser.'),
('NOTIFICATION', 'de_DE', 'Neue Benachrichtigung von {$siteTitle}', 'Sie haben eine neue Benachrichtigung von {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'Diese E-Mail wird an angemeldete Benutzer/innen geschickt, die sich für diese Art der Benachrichtigung angemeldet haben.'),
('NOTIFICATION', 'el_GR', 'Νέα ειδοποίηση από το {$siteTitle}', 'Έχετε μία νέα ειδοποίηση από το {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nΣύνδεσμος: {$url}<br />\n<br />\n{$principalContactSignature}', 'Το παρόν μήνυμα αποστέλλεται στους εγγεγραμμένους Χρήστες που έχουν επιλέξει να λαμβάνουν ειδοποιήσεις αυτού του τύπου.'),
('NOTIFICATION', 'en_US', 'New notification from {$siteTitle}', 'You have a new notification from {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'The email is sent to registered users that have selected to have this type of notification emailed to them.'),
('NOTIFICATION', 'es_ES', 'Nueva notificación desde {$siteTitle}', 'Tiene una nueva notificación desde {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nEnlace: {$url}<br />\n<br />\n{$principalContactSignature}', 'El correo electrónico se envía a usuarios/as registrados que hayan seleccionado recibir este tipo de notificación.'),
('NOTIFICATION', 'eu_ES', '{$siteTitle} gunearen jakinarazpen berria', '{$siteTitle} gunearen jakinarazpen berri bat daukazu:<br />\n<br />\n{$notificationContents}<br />\n<br />\nEsteka: {$url}<br />\n<br />\n{$principalContactSignature}', 'Mezu hau mota honetako jakinarazpena jasotzea hautatu duten erabiltzaile erregistratuei bidaltzen zaie.'),
('NOTIFICATION', 'fa_IR', 'فرم اطلاع رسانی جدید {$siteTitle}', 'شما یک فرم اطلاع رسانی جدید از {$siteTitle} دارید<br />\n<br />\nلینک: {$url}<br />\n<br />\n{$principalContactSignature}', '##emails.notification.description##'),
('NOTIFICATION', 'fi_FI', 'Uusi ilmoitus sivustolta {$siteTitle}', 'Teille on uusi ilmoitus sivustolta {$siteTitle}:<br/>\n<br />\n{$notificationContents}<br />\n<br />\nLinkki: {$url}<br />\n<br />\n{$principalContactSignature}', 'Tämä viesti lähetetään niille rekisteröityneille käyttäjille, jotka ovat ilmoittaneet haluavansa tällaisia ilmoituksia.'),
('NOTIFICATION', 'fr_CA', 'Nouvel avis de {$siteTitle}', 'Vous avez un nouvel avis de {$siteTitle} :<br />\n<br />\n{$notificationContents}<br />\n<br />\nLien : {$url}<br />\n<br />\n{$principalContactSignature}', 'Ce courriel est envoyé aux utilisateurs-trices inscrits-es qui ont choisi de recevoir par courriel ce type d''avis.'),
('NOTIFICATION', 'fr_FR', 'Nouvel avis de {$siteTitle}', 'Vous avez un nouvel avis de {$siteTitle} :<br />\n<br />\n{$notificationContents}<br />\n<br />\nLien : {$url}<br />\n<br />\n{$principalContactSignature}', 'Ce courriel est envoyé aux utilisateurs inscrits qui ont choisi de recevoir par courriel ce type d''avis.'),
('NOTIFICATION', 'gd_GB', 'Brath ùr o {$siteTitle}', 'Tha bhrath ùr agad o {siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nCeangal: {$url}<br />\n<br />\n{$principalContactSignature}', 'Thèid am post-d seo a chur gu cleachdaichean clàraichte a dh’iarr a leithid seo de bhrath air a’ phost-d.'),
('NOTIFICATION', 'he_IL', 'הודעה חדשה מאת {siteTitle$}', 'יש לך הודעה חדשה מאת {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'הדוא"ל נשלח למשתמשים רשומים שבחרו לשלוח אליהם הודעה מסוג זה.');
INSERT INTO `email_templates_default_data` VALUES
('NOTIFICATION', 'hi_IN', 'से नई अधिसूचना {$siteTitle}', 'आपके पास एक नई सूचना है {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'ईमेल उन पंजीकृत उपयोगकर्ताओं को भेजा जाता है जिन्होंने इस प्रकार की अधिसूचना को ईमेल करने के लिए चुना है.'),
('NOTIFICATION', 'hr_HR', 'Nova obavijest od časopisa {$siteTitle}', 'Imate novu obavijest od časopisa {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nPoveznica: {$url}<br />\n<br />\n{$principalContactSignature}', 'Ova e-pošta šalje se registriranim korisnicima koji su odabrali primati ovu vrstu obavijesti.'),
('NOTIFICATION', 'hu_HU', 'Új értesítés a(z) {$siteTitle} oldaltól', 'Önnek új értesítése van a(z) {$siteTitle} oldaltól:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'Az email azoknak a regisztrált felhasználóknak lett kiküldve, akik korábban jelezték, hogy ebben a témában kérnek értesítést.'),
('NOTIFICATION', 'id_ID', 'Notifikasi baru dari {$siteTitle}', 'Anda memperoleh satu notifikasi baru dari {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nTautan: {$url}<br />\n<br />\n{$principalContactSignature}', 'Email ini dikirimkan ke pengguna terdaftar yang memilih untuk memperoleh jenis notifikasi ini dikirimkan melalui email.'),
('NOTIFICATION', 'it_IT', 'Nuova notifica da {$siteTitle}', 'Hai ricevuto una nuova notifica da  {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'Questa mail è inviata agli utenti registrati che hanno chiesto di ricevere questo tipo di notifiche.'),
('NOTIFICATION', 'ja_JP', '{$siteTitle}からの新しいお知らせ', '{$siteTitle}からの新しいお知らせです。<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'このメールは新規に登録された査読者に送付され、ユーザー名とパスワードが通知されます。'),
('NOTIFICATION', 'ko_KR', '{$siteTitle}로 부터 새 공지', '{$siteTitle}로 부터 새 공지가 있습니다:<br />\n<br />\n{$notificationContents}<br />\n<br />\n링크: {$url}<br />\n<br />\n{$principalContactSignature}', '##emails.notification.description##'),
('NOTIFICATION', 'ku_IQ', 'ئاگادارکردنەی نوێ لە {$siteTitle}', 'تۆ ئاگادارکردنەوی نوێت هەیە لە {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'ئەم ئيمەيلە، بۆ ئەو بەكارهێنەرانە دەنێردرێت كە ويستوويانە ئاگاداركردنەوەكانيان لە رێگەى ئيمەيلەوە بۆ بچێت.'),
('NOTIFICATION', 'mk_MK', 'Ново известување од {$siteTitle}', 'Имате ново известување од {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nЛинк: {$url}<br />\n<br />\n{$principalContactSignature}', 'Овој и-маил е испратен до регистрирани корисници кои посочиле дека сакаат да добијат известувања од овој тип на и-меил.'),
('NOTIFICATION', 'nb_NO', 'Nytt varsel fra {$siteTitle}', 'Du har fått et nytt varsel fra {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLenke: {$url}<br />\n<br />\n{$principalContactSignature}', 'Denne e-posten sendes til registrerte brukere som har valgt å få tilsendt slike varslinger.'),
('NOTIFICATION', 'nl_NL', 'Nieuw bericht van {$siteTitle}', 'U heeft een nieuw bericht van {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'Deze e-mail wordt gestuurd naar een geregistreerde gebruiker die zich heeft ingeschreven voor dit type van berichten.'),
('NOTIFICATION', 'pl_PL', 'Nowe powiadomienie ze strony czasopisma {$siteTitle}', 'Na stronie czasopisma {$siteTitle}:<br />\n<br /> \noczekuje nowe powiadomienie {$notificationContents}<br />\n<br />\nWWW: {$url}<br />\n<br />\nZ wyrazami szacunku, \n{$principalContactSignature}', 'Wiadomość jest przesyłana do zarejestrowanych użytkowników, którzy zadeklarowali chęć otrzymywania tego typu powiadomień.'),
('NOTIFICATION', 'pt_BR', 'Nova notificação de {$siteTitle}', 'Você tem uma nova notificação de {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'Esta mensagem é enviada a usuários cadastrados que escolheram habilitar este tipo de notificação via email.'),
('NOTIFICATION', 'pt_PT', 'Nova notificação de {$siteTitle}', 'Você possui uma nova notificação de {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'Esta mensagem é enviada a utilizadores registados que escolheram ativar este tipo de notificação via email.'),
('NOTIFICATION', 'ro_RO', 'Notificare nouă din partea {$siteTitle}', 'Ați primit o notificare nouă de la {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'Acest email este trimis utilizatorilor înregistrați care au selectat să primească prin e-mail acest tip de notificare.'),
('NOTIFICATION', 'ru_RU', 'Новое уведомление с сайта «{$siteTitle}»', 'Вы получили новое уведомление с сайта «{$siteTitle}»:<br />\n<br />\n{$notificationContents}<br />\n<br />\nСсылка: {$url}<br />\n<br />\n{$principalContactSignature}', 'Это письмо отправляется зарегистрированным пользователям, которые указали, что данный тип уведомления отправляется им электронной почтой.'),
('NOTIFICATION', 'sk_SK', 'Nové oznámenie od {$siteTitle}', 'Máte nové oznámenie od {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nOdkaz: {$url}<br />\n<br />\n{$principalContactSignature}', 'Email sa odošle zaregistrovaným používateľom, ktorí majú povolený príjem tohto typu oznámenia.'),
('NOTIFICATION', 'sl_SI', 'Novo obvestilo od {$siteTitle}', 'Imate novo obvestilo od {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nPovezava: {$url}<br />\n<br />\n{$principalContactSignature}', 'Email dobijo registrirani uporabniki, ki so naročeni na ta tip obvestil.'),
('NOTIFICATION', 'sr_RS@cyrillic', 'Imate poruku od {$siteTitle}', 'Imate poruku od {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'Ova poruka je poslata registrovanim korisnicima koji su obeležili da žele da primaju poruke putem imejla.'),
('NOTIFICATION', 'sr_RS@latin', 'Imate poruku od {$siteTitle}', 'Imate poruku od {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'Ova poruka je poslata registrovanim korisnicima koji su obeležili da žele da primaju poruke putem imejla.'),
('NOTIFICATION', 'sv_SE', 'Ny avisering från {$siteTitle}', 'Du har en ny avisering från {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLänk: {$url}<br />\n<br />\n{$principalContactSignature}', 'Det här e-postmeddelandet skickas till registrerade användare som har valt att få den här typen av aviseringar skickade till sig via e-post.'),
('NOTIFICATION', 'tr_TR', '{$siteTitle} Yeni Bildirim', '{$siteTitle} adlı sisteden yeni bir bildiriminiz var:<br />\n<br />\n{$notificationContents}<br />\n<br />\nBağlantı: {$url}<br />\n<br />\n{$principalContactSignature}', 'Bu e-posta, bu tür bildirimlerin e-postayla gönderilmesini seçmiş olan kayıtlı kullanıcılara gönderilir.'),
('NOTIFICATION', 'uk_UA', 'Нове повідомлення від сайту {$siteTitle}', 'Ви маєте нове повідомлення від сайту {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nПосилання: {$url}<br />\n<br />\n{$principalContactSignature}', 'Цей лист надсилається зареєстрованому користувачу, який обрав опцію отримання повідомлень цього типу електронною поштою.'),
('NOTIFICATION', 'vi_VN', 'Thông báo mới từ {$siteTitle}', 'Bạn có một thông báo mới từ {$siteTitle}:<br />\n<br />\n{$notificationContents}<br />\n<br />\nLink: {$url}<br />\n<br />\n{$principalContactSignature}', 'Email được gửi đến người dùng đã đăng ký đã chọn để gửi kiểu thông báo này qua email cho họ.'),
('NOTIFICATION', 'zh_CN', '来自{$siteTitle}的新通知', '您有一条来自{$siteTitle}的新通知:<br />\n<br />\n{$notificationContents}<br />\n<br />\n链接: {$url}<br />\n<br />\n{$principalContactSignature}', '这封电子邮件是发送给需要这种类型通知的注册用户。'),
('NOTIFICATION_CENTER_DEFAULT', 'ar_IQ', 'رسالة تتعلق بالمجلة {$contextName}', 'لطفاً أكتب رسالتك هنا.', 'هذه الرسالة الإفتراضية (الخالية) التي يستعملها منشئ الرسائل في مركز إشعارات النظام.'),
('NOTIFICATION_CENTER_DEFAULT', 'ca_ES', 'Missatge sobre {$contextName}', 'Introduïu el vostre missatge.', 'Missatge (en blanc) predeterminat utilitzat en el Notification Center Message Listbuilder.'),
('NOTIFICATION_CENTER_DEFAULT', 'cs_CZ', 'Zpráva týkající se {$contextName}', 'Vložte, prosím, vaši zprávu.', 'Výchozí (prázdná) zpráva použitá v nástroji List Builder Message Center Message Builder.'),
('NOTIFICATION_CENTER_DEFAULT', 'da_DK', 'Besked omhandlende {$contextName}', 'Skriv venligst din besked.', 'Standardmeddelelsen (tom), der blev brugt i Notification Center Message Listbuilder.'),
('NOTIFICATION_CENTER_DEFAULT', 'de_DE', 'Eine Nachricht bezüglich {$contextName}', 'Bitte geben Sie Ihre Nachricht ein.', 'Die (leere) Standardnachricht, die in der Nachrichtenliste des Benachrichtigungscenters angezeigt wird.'),
('NOTIFICATION_CENTER_DEFAULT', 'el_GR', 'Ένα μήνυμα σχετικά με το περιοδικό {$contextName}', 'Παρακαλούμε εισάγετε το μήνυμά σας.', 'Το προεπιλεγμένο (κενό) μήνυμα που χρησιμοποιείται στον Κατάλογο Μηνυμάτων του Κέντρου Ειδοποιήσεων.'),
('NOTIFICATION_CENTER_DEFAULT', 'en_US', 'A message regarding {$contextName}', 'Please enter your message.', 'The default (blank) message used in the Notification Center Message Listbuilder.'),
('NOTIFICATION_CENTER_DEFAULT', 'es_ES', 'Mensaje sobre {$contextName}', 'Introduzca su mensaje.', 'Mensaje (en blanco) por defecto usado en el Notification Center Message Listbuilder.'),
('NOTIFICATION_CENTER_DEFAULT', 'fa_IR', 'پیامی برای {$contextName}', 'لطفاً پیام خود را وارد کنید', 'پیام خالی که در قسمت اطلاع رسانی استفاده می شود'),
('NOTIFICATION_CENTER_DEFAULT', 'fi_FI', 'Viesti julkaisua {$contextName} koskien', 'Kirjoita viesti.', 'The default (blank) message used in the Notification Center Message Listbuilder.'),
('NOTIFICATION_CENTER_DEFAULT', 'fr_CA', 'Un message à propos de la revue {$contextName}', 'Prière de saisir votre message.', 'Message blanc par défaut utilisé pour concevoir d''autres messages.'),
('NOTIFICATION_CENTER_DEFAULT', 'fr_FR', 'Un message à propos de {$contextName}', 'Veuillez saisir votre message.', 'Message blanc par défaut utilisé pour concevoir d''autres messages.'),
('NOTIFICATION_CENTER_DEFAULT', 'gd_GB', 'Teachdaireachd a thaobh {$contextName}', 'Cuir a-steach do theachdaireachd.', 'An teachdaireachd (bhàn) bhunaiteach a thèid a chleachdadh ann an togalaiche liostaichean theachdaireachdan aig ionad nam brathan.'),
('NOTIFICATION_CENTER_DEFAULT', 'hi_IN', '{$contextName} के बारे में एक संदेश', 'कृपया अपना संदेश लिखें.', 'सूचना केंद्र मैसेज लिस्टबिल्डर में प्रयुक्त डिफ़ॉल्ट (रिक्त) संदेश.'),
('NOTIFICATION_CENTER_DEFAULT', 'hu_HU', 'Üzenet a(z) {$contextName} folyóirattól', 'Kérjük, adja meg itt üzenete tartalmát.', 'Alapértelmezett (üres) üzenet sablon.'),
('NOTIFICATION_CENTER_DEFAULT', 'id_ID', 'Pesan terkait {$contextName}', 'Silakan tuliskan pesan Anda.', 'Pesan default (kosong) yang digunakan di Pengelola Pesan Pusat Notifikasi.'),
('NOTIFICATION_CENTER_DEFAULT', 'it_IT', 'Un messaggio da  {$contextName}', 'Inserisci  qui il testo del tuo messaggio.', 'Questo messaggio vuoto è usato dal sistema centralizzato di messaggistica via lista.'),
('NOTIFICATION_CENTER_DEFAULT', 'ja_JP', '{$contextName}に関するメッセージ', 'メッセージを入力してください。', '通知センター メッセージ リストビルダで使用されるデフォルトの (空白の) メッセージです。'),
('NOTIFICATION_CENTER_DEFAULT', 'ku_IQ', 'نامەی پەیوەندیدار بە  {$contextName}', 'تکایە نامەکەت بنوسە.', 'ئەمە نامەیەکی بەتاڵە لە لایەن سەنتەری نامەکان بۆ ئاگادارکردنەوەی سیستەمەکە بەکار دێت.'),
('NOTIFICATION_CENTER_DEFAULT', 'mk_MK', 'Порака во врска со {$contextName}', 'Ве молиме да ја внесете вашата порака.', 'Стандардната (blank) порака користена во Изградувачот на пораки во Центарот за известувања.'),
('NOTIFICATION_CENTER_DEFAULT', 'nb_NO', 'En beskjed angående {$contextName}', 'Skriv inn beskjeden din her.', 'Denne blanke standardbeskjeden blir brukt der du lager liste over varslinger.'),
('NOTIFICATION_CENTER_DEFAULT', 'nl_NL', 'Een bericht over {$contextName}', 'Voeg hier uw boodschap in.', 'De standaard (lege) berichttekst die wordt gebruikt in het Notification Center Message Listbuilder.'),
('NOTIFICATION_CENTER_DEFAULT', 'pl_PL', 'Wiadomość do czasopisma "{$contextName}"', 'Proszę o wpisanie wiadomości.', 'Typowe (puste) pole wiadomości.'),
('NOTIFICATION_CENTER_DEFAULT', 'pt_BR', 'Uma mensagem sobre {$contextName}', 'Insira a sua mensagem por gentileza.', 'A mensagem padrão (em branco) usada no Criador de lista de mensagens do Notification Center.'),
('NOTIFICATION_CENTER_DEFAULT', 'pt_PT', 'Uma mensagem relativa {$contextName}', 'Escreva a sua mensagem.', 'A mensagem padrão (em branco) usada no Construtor de Listas de Mensagens do Centro de Notificações.'),
('NOTIFICATION_CENTER_DEFAULT', 'ro_RO', 'Un mesaj cu privire la {$contextName}', 'Vă rugăm să introduceți mesajul dvs.', 'Mesajul implicit (necompletat) utilizat în Generatorul de liste de mesaje al Centrului de notificări.'),
('NOTIFICATION_CENTER_DEFAULT', 'ru_RU', 'Сообщение о журнале «{$contextName}»', 'Пожалуйста, введите свое сообщение.', 'Сообщение по умолчанию (пустое) используется в редакторе списка сообщений Центра уведомлений.'),
('NOTIFICATION_CENTER_DEFAULT', 'sk_SK', 'Správa týkajúca sa {$contextName}', 'Vložte, prosím, vašu správu.', 'Predvolená (prázdna) správa použitá v nástroji List Builder Message Center Message Builder.'),
('NOTIFICATION_CENTER_DEFAULT', 'sl_SI', 'Sporočilo v zvezi s publikacijo {$contextName}', 'Prosimo, vnesite vaše sporočilo.', 'Privzeto (prazno) sporočilo, ki se uporablja v centru za obvestila.'),
('NOTIFICATION_CENTER_DEFAULT', 'sv_SE', 'Ett meddelande angående {$contextName}', 'Skriv in ditt meddelande.', 'Defaultmeddelande (tomt) att använda i Notification Center Message Listbuilder.'),
('NOTIFICATION_CENTER_DEFAULT', 'tr_TR', '{$contextName} ile ilgili bir mesaj', 'Lütfen mesajınızı giriniz.', 'Bildirim Merkezi Mesaj Listesi Oluşturucusunda kullanılan varsayılan (boş) mesaj.'),
('NOTIFICATION_CENTER_DEFAULT', 'vi_VN', 'Một thông báo liên quan đến {$contextName}', 'Vui lòng nhập tin nhắn của bạn.', 'Thông báo (trống) mặc định được sử dụng trong Trình tạo danh sách thông báo của Trung tâm thông báo.'),
('NOTIFICATION_CENTER_DEFAULT', 'zh_CN', '关于{$contextName} 的信息', '请输入您的信息。', '信息提醒中心生成默认信息（通常会是空白）。'),
('OPEN_ACCESS_NOTIFY', 'ar_IQ', 'صدور عدد مجاني الآن', 'قراءنا:<br />\n<br />\n{$contextName} قد أصدرت تواً عدداً مجانياً. نحن ندعوك لمراجعة جدول المحتويات هنا، ومن ثم زيارة موقعنا ({$contextUrl}) لتطلع على المواضيع والفقرات التي تحوز على إهتمامك.<br />\n<br />\nنشكر لكم إهتمامكم الدائم بنتاجاتنا؛<br />\n{$editorialContactSignature}', 'هذه الرسالة تُعلم قارئاً مسجلاً بأن مدير المجلة قد أنشأ له اشتراكاً، وهي تتضمن رابط المجلة مع تعليمات الوصول إليها.'),
('OPEN_ACCESS_NOTIFY', 'bs_BA', 'Broj dostupan pod uvjetima otvorenog pristupa', 'Ovaj broj časopisa {$contextName} od sada je u cijelosti dostupan svim čitateljima pod uvjetima otvorenog pristupa. Pozivamo vas da pregledate kazalo sadržaja i potom posjetite našu mrežnu stranicu ({$contextUrl}) gdje možete bez ograničenja pregledati sve članke i priloge koji vas zanimaju.<br />\n<br />\nHvala vam na zanimanju za naš rad,<br />\n{$editorialContactSignature}', 'Ovaj obrazac e-pošte šalje se registriranim čitateljima koji su zatražili primanje obavijesti e-poštom kada broj časopisa postane dostupan pod uvjetima otvorenog pristupa.'),
('OPEN_ACCESS_NOTIFY', 'ca_ES', 'Ara el número és d''accés obert', 'Benvolguts lectors/ores,<br />\n<br />\n{$contextName} acaba de publicar en format d''accés obert el número següent. Us convidem a consultar-ne el sumari adjunt i a visitar el nostre lloc web ({$contextUrl}) per accedir als articles i elements que us interessin<br />\n<br />\nUs agraïm l''interès en la nostra revista.<br />\n{$editorialContactSignature}', 'Aquest missatge de correu electrònic s''envia als lectors que han sol·licitat rebre una notificació per correu electrònic quan es publiqui un número en format d''accés obert.'),
('OPEN_ACCESS_NOTIFY', 'cs_CZ', 'Nyní otevřen přístup k číslu', 'Čtenáři:<br />\n<br />\nČasopis {$contextName} povolil otevřený přístup k následujícímu číslu. Zveme vás k prohlédnutí obsahu časopisu a návštěvě našich stránek ({$contextUrl}).<br />\n<br />\nDěkujeme za Vás pokračující zájem o naši práci<br />\n{$editorialContactSignature}', 'Tento email je posílán čtenářům, kteří požádali o zasílání upozornění na přechod čísla časopisu do otevřeného přístupu.'),
('OPEN_ACCESS_NOTIFY', 'da_DK', 'Udgave nu i Open Access-format', 'Læsere:<br />\n<br />\n{$contextName} har netop udgivet følgende udgave i et Open Access-format. Vi inviterer dig til at gennemse indholdsfortegnelsen her og derefter besøge vores websted ({$contextUrl}), hvor du kan gennemse artikler og elementer, der har din interesse.<br />\n<br />\nTak for din fortsatte interesse i vores arbejde.<br />\n{$editorialContactSignature}', 'Denne e-mail sendes til registrerede læsere, der har anmodet om at modtage en e-mail-meddelelse, når en udgave udgives i et Open Access-format.'),
('OPEN_ACCESS_NOTIFY', 'de_DE', 'Ausgabe jetzt im Open Access', 'Liebe Leser/innen,<br />\n<br />\n{$contextName} hat soeben die nächste Ausgabe frei zugänglich gemacht. Wir laden Sie ein, sich hier das Inhaltsverzeichnis und auf unserer Webseite ({$contextUrl}) die Sie interessierenden Beiträge anzusehen.<br />\n<br />\nWir danken für Ihr Interesse an unserer Arbeit,<br />\n{$editorialContactSignature}', 'Diese E-Mail wird an registrierte Leser/innen gesendet, die darum gebeten haben, informiert zu werden, wenn eine Ausgabe frei verfügbar wird.'),
('OPEN_ACCESS_NOTIFY', 'el_GR', 'Τεύχος διαθέσιμο με ανοικτή πρόσβαση', 'Readers:<br />\n<br />\nΤο περιοδικό {$contextName} διαθέτει πλέον με ανοικτή πρόσβαση το ακόλουθο τεύχος. Σας προσκαλούμε να επισκεφθείτε τον ιστότοπό μας ({$contextUrl}) για να βρείτε ενδιαφέροντα άρθρα και τεκμήρια.<br />\n<br />\nΣας ευχαριστούμε για το συνεχές ενδιαφέρον που επιδεικνύετε για την εργασία μας<br />\n{$editorialContactSignature}', 'Το παρόν μήνυμα αποστέλλεται σε εγγεγραμμένους αναγνώστες που έχουν αιτηθεί να λαμβάνουν ενημερώσεις όταν κάποιο τεύχος διατίθεται με ανοικτή πρόσβαση.'),
('OPEN_ACCESS_NOTIFY', 'en_US', 'Issue Now Open Access', 'Readers:<br />\n<br />\n{$contextName} has just made available in an open access format the following issue. We invite you to review the Table of Contents here and then visit our web site ({$contextUrl}) to review articles and items of interest.<br />\n<br />\nThanks for the continuing interest in our work,<br />\n{$editorialContactSignature}', 'This email is sent to registered readers who have requested to receive a notification email when an issue becomes open access.'),
('OPEN_ACCESS_NOTIFY', 'es_ES', 'Ahora el número es de acceso libre', 'Lectores:<br />\n<br />\n	{$contextName} acaba de hacer disponible de forma acceso libre el siguiente número. Los invitamos a revisar la Tabla de Contenido aquí y después visite nuestra página Web  ({$contextUrl}) para consultar los artículos que sean de su interés.<br />\n<br />\n	Gracias por mantener el interés en nuestro trabajo,<br />\n	{$editorialContactSignature}', 'Este correo electrónico se envía a los lectores/as registrados que han pedido recibir notificaciones por email cuando un número se vuelve de acceso libre.'),
('OPEN_ACCESS_NOTIFY', 'eu_ES', 'Zenbakia sarrera librekoa da orain', 'Irakurle:<br />\n<br />\n{$contextName} aldizkariak sarrera libreko egin du ondoren zehazten dugun zenbakia. Honekin batera bidaltzen dizugun Aurkibidea aztertzera eta gure webgunean ({$contextUrl}) artikuluak irakurtzera gonbidatzen zaitugu.<br />\n<br />\nEskerrik asko gure lana interesez jarraitzeagatik,<br />\n{$editorialContactSignature}', 'Mezu hau bidaltzen zaie zenbakia sarrera libreko egiten denean jakinarazpena jaso nahi dutela esan duten erabiltzaile erregistratuei.'),
('OPEN_ACCESS_NOTIFY', 'fa_IR', 'اکنون مجله قابل دسترس است', 'خوانندگان گرامی:<br />\n<br />\n{$contextName}، شماره جاری خود را بصورت دسترسی آزاد (Open Access) در اختیار خوانندگان قرار داده است. از شما دعوت میگردد که پس از ملاحظه فهرست مقالات در ذیل این نامه، به منظور بررسی مقالات و موضوع های مورد علاقه، از وب سایت مجله دیدن فرمایید.<br />\n<br />\nاز توجه همیشگی شما نسبت به این مجله متشکریم.<br />\n<br />\nآدرس وب سایت مجله: <a href="{$contextUrl}">{$contextUrl}</a><br />\n<br />\n{$editorialContactSignature}', 'This email is sent to registered readers who have requested to receive a notification email when an issue becomes open access.'),
('OPEN_ACCESS_NOTIFY', 'fi_FI', 'Numero nyt avoimesti saatavilla', 'Hyvä lukija,<br />\n<br />\nJulkaisun {$contextName} alla oleva numero on nyt avoimesti saatavilla. Voitte tutustua sisällysluetteloon tässä ja sen jälkeen tutustua artikkeleihin ja muihin kiinnostaviin kohteisiin verkkosivustollamme ({$contextUrl}).<br />\n<br />\nKiitos mielenkiinnostanne työtämme kohtaan,<br />\n{$editorialContactSignature}', 'This email is sent to registered readers who have requested to receive a notification email when an issue becomes open access.'),
('OPEN_ACCESS_NOTIFY', 'fr_CA', 'Le numéro est maintenant en libre accès', 'Chers lecteurs et lectrices,<br />\n<br />\nLa revue {$contextName} vient de rendre disponible en libre accès le numéro suivant. Nous vous invitons à lire ici le sommaire puis visiter notre site Web ({$contextUrl}) pour lire les articles et autres textes qui pourraient vous intéresser.<br />\n<br />\nMerci de votre intérêt continu pour notre travail.<br />\n{$editorialContactSignature}', 'Ce courriel est envoyé aux lecteurs-trices inscrits-es qui ont demandé à recevoir un avis par courriel quand un numéro devient disponible en libre accès.'),
('OPEN_ACCESS_NOTIFY', 'fr_FR', 'Le numéro est maintenant à accès libre', 'Chers lecteurs et lectrices :<br />\n<br />\n{$contextName} vient de rendre disponible en format libre accès le numéro suivant. Nous vous invitons à lire la table des matières ici puis visiter notre site Web ({$contextUrl}) pour lire les articles et autres textes qui pourraient vous intéresser.<br />\n<br />\nMerci de votre intérêt continu pour notre travail,<br />\n{$editorialContactSignature}', 'Nous envoyons ce courriel aux lecteurs inscrits qui ont demandé à recevoir un avis par courriel quand un numéro devient disponible à accès libre.'),
('OPEN_ACCESS_NOTIFY', 'gd_GB', 'Tha inntrigeadh fosgailte dhan iris a-nis', 'Leughadairean:<br />\n<br />\nTha {$contextName} dìreach air an iris a leanas a chur ri làimh gu saor. Tha sinn a’ cur fàilte ort sùil a thoirt air a’ chlàr-innse an-seo agus a thadhal air an làrach-lìn againn ({$contextUrl}) an uairsin airson sùil a thoirt air artaigealan is rudan eile a dh’fhaodadh a bhith inntinneach dhut.<br />\n<br />\nMòran taing airson sìor ùidh a nochdadh nar n-obair,<br />\n{$editorialContactSignature}', 'Thèid am post-d seo a chur gu leughadairean clàraichte a dh’iarr brath air a’ phost-d nuair a bhios iris ri fhaighinn gu saor.'),
('OPEN_ACCESS_NOTIFY', 'hi_IN', 'अंक अब ओपन एक्सेस', 'Readers:<br />\n<br />\n{$contextName} निम्नलिखित मुद्दे पर सिर्फ एक ओपन एक्सेस फॉर्मेट में उपलब्ध कराया गया है। हम आपको यहां सामग्री की तालिका की समीक्षा करने के लिए आमंत्रित करते हैं और फिर लेख और रुचि की वस्तुओं की समीक्षा करने के लिए हमारी वेब साइट ({$contextUrl}) पर जाएं।.<br />\n<br />\nहमारे काम में निरंतर रुचि के लिए धन्यवाद,<br />\n{$editorialContactSignature}', 'यह ईमेल उन पंजीकृत पाठकों को भेजा जाता है, जिन्होंने किसी अंक पर खुली पहुंच बनने पर अधिसूचना ईमेल प्राप्त करने का अनुरोध किया है.'),
('OPEN_ACCESS_NOTIFY', 'hr_HR', 'Broj dostupan pod uvjetima otvorenog pristupa', 'Ovaj broj časopisa {$contextName} od sada je u cijelosti dostupan svim čitateljima pod uvjetima otvorenog pristupa. Pozivamo vas da pregledate kazalo sadržaja i potom posjetite našu mrežnu stranicu ({$contextUrl}) gdje možete bez ograničenja pregledati sve članke i priloge koji vas zanimaju.<br />\n<br />\nHvala vam na zanimanju za naš rad,<br />\n{$editorialContactSignature}', 'Ovaj obrazac e-pošte šalje se registriranim čitateljima koji su zatražili primanje obavijesti e-poštom kada broj časopisa postane dostupan pod uvjetima otvorenog pristupa.'),
('OPEN_ACCESS_NOTIFY', 'hu_HU', 'Új folyóiratszám szabadon hozzáférhető', 'Tisztelt Olvasó!<br />\n<br />\nA(z) {$contextName} folyóirat nemrég új számot tett szabadon hozzáférhetővé, melyet a következő linken tekinthet meg: {$contextUrl}<br />\n<br />\nÜdvözlettel,<br />\n{$editorialContactSignature}', 'Ez az email azoknak a regisztrált olvasóknak szól, akik értesítést kértek korábban a nyilvánossá tett számokról.'),
('OPEN_ACCESS_NOTIFY', 'id_ID', 'Terbitan Sudah Open Access', 'Readers:<br />\n<br />\n{$contextName} telah menjadikan terbitan berikut Open Access. Kami mengundang Anda untuk menelaah Daftar Isi berikut dan mengunjungi website kami ({$contextUrl}) untuk membaca artikel dan item yang Anda minati.<br />\n<br />\nTerimakasih atas perhatiannya,<br />\n{$editorialContactSignature}', 'Email ini dikirimkan ke pembaca terdaftar yang meminta untuk dikirimkan email pemberitahuan saat suatu terbitan menjadi Open Access.'),
('OPEN_ACCESS_NOTIFY', 'it_IT', 'Nuovo fascicolo disponibile ad accesso aperto', 'Gentile lettore,<br />\n<br />\n{$contextName} ha appena reso disponibile in modalità open access una nuova uscita. Ti invitiamo dunque a visitare il sito web ({$contextUrl}) per trovare articoli e altre risorse di tuo interesse.<br />\n<br />\nGrazie per il tuo interesse per la nostra testata<br />\n{$editorialContactSignature}', 'Questa email viene inviata ai lettori registrati che hanno chiesto di ricevere un''email di notifica in caso di uscite ad accesso aperto.'),
('OPEN_ACCESS_NOTIFY', 'ja_JP', 'オープンアクセスのお知らせ', '読者各位:<br />\n<br />\nいつもご利用ありがとうございます。<br />\n<br />\n雑誌『{$contextName}』の以下の巻号がオープンアクセスにより利用できるようになりましたのでご案内いたします。雑誌のWebサイト({$contextUrl})にアクセスし、目次をチェックし興味のある論文や記事をご利用ください。<br />\n<br />\nよろしくお願いいたします。<br />\n{$editorialContactSignature}', 'このメールは、巻号がオープンアクセスになった時に通知を受け取るよう登録している読者に送信されるものです。'),
('OPEN_ACCESS_NOTIFY', 'ku_IQ', 'ئەم ژمارەیە لە ئێستادا بەردەستە', 'Readers:<br />\n<br />\n{$contextName} ژمارەی داهاتوی خۆی بە شێوەی کراوە دەخاتە بەردەست. ئێمە تۆ بانگێشت دەکەین بۆ هەڵسەنگاندن بە لیستی ناوەرۆکدا، تکایە سەردانی ئەم پەڕەیە بکە ({$contextUrl}) بۆ هەڵسەنگاندنی توێژینەوە و بابەتەکانی پسپۆڕیی خۆت.<br />\n<br />\nسوپاس بۆ هاوکاریت، <br />\n{$editorialContactSignature}', 'ئەم ئیمەیڵە بۆ بەکارهێنەرە تۆمارکراوەکان دەچێت کە خۆیان داوایان کردووە لە ژمارە نوێکانی گۆڤار ئاگادار بکرێنەوە.'),
('OPEN_ACCESS_NOTIFY', 'mk_MK', 'Изданието е сега со отворен пристап', 'Читатели:<br />\n<br />\n{$contextName} штотуку го направи достапно следното издание со отворен пристап. Ве покануваме да ја прегледате тука содржината и потоа да ја посетите нашата веб-страница ({$contextUrl}) да прегледате трудови и предмети од интерес.<br />\n<br />\nВи благодариме за непрекинатиот интерес за нашата работа,<br />\n{$editorialContactSignature}', 'Овој и-меил е испратен до регистрирани корисници кои имаат побарано да добијат известување по и-меил кога некое издание ќе има отворен пристап.'),
('OPEN_ACCESS_NOTIFY', 'nb_NO', 'Ny utgave er åpent tilgjengelig', 'Til våre lesere:<br />\n<br />\n{$contextName} har nå gjort følgende utgave åpent tilgjengelig. Innholdsfortegnelsen er vedlagt. Vi inviterer deg til å besøk nettstedet vårt ({$contextUrl}) for å se nærmere på innhold som kan være av interesse.<br />\n<br />\nTakk for at du viser interesse for arbeidet vårt.<br />\n{$editorialContactSignature}', 'Denne e-posten sendes til registrerte lesere som har bedt om å bli varslet når utgivelser blir åpent tilgjengelig.'),
('OPEN_ACCESS_NOTIFY', 'nl_NL', 'Nummer nu Open Access', 'Lezers:<br />\n<br />\n{$contextName} heeft het volgende nummer in open access beschikbaar gesteld. We nodigen u uit om de inhoudsopgave te bekijken en onze website te bezoeken ({$contextUrl}) voor de items en artikels die u interesseren.<br />\n<br />\nBedankt voor de interesse in ons werk,<br />\n{$editorialContactSignature}', 'Deze e-mail wordt verstuurd naar geregistreerde gebruikers die aangegeven hebben een e-mail te willen ontvangen als een nummer open access wordt.'),
('OPEN_ACCESS_NOTIFY', 'pl_PL', 'Numer czasopisma teraz w otwartym dostępie', 'Szanowni Państwo,<br />\n<br />\nna stronie czasopisma "{$contextName}" został udostępniony w sposób otwarty jeden z numerów czasopisma. Zachęcamy do zapoznania się ze spisem treści zamieszczonym w wiadomości oraz odwiedzenia naszej strony <br />\n<br />\nDziękujemy za zainteresowanie naszym czasopismem, <br />\n{$editorialContactSignature}', 'Wiadomość wysyłana do zarejestrowanych użytkowników, którzy zadeklarowali chęć otrzymywania powiadomień o nowych numerach w otwartym dostępie.'),
('OPEN_ACCESS_NOTIFY', 'pt_BR', 'Nova edição de Acesso Livre', 'Leitores: <br />\n<br />\n{$contextName} acabou de disponibilizar em um formato de acesso aberto a seguinte edição. Convidamos você a verificar o sumário abaixo e, em seguida, visitar nosso site ({$contextUrl}) para conferir os artigos e itens de interesse. <br />\n<br />\nObrigado pelo interesse em nosso trabalho, <br />\n{$editorialContactSignature}', 'Esta mensagem é enviada a leitores cadastrados que solicitam o recebimento do sumário de uma nova edição de Acesso Livre.'),
('OPEN_ACCESS_NOTIFY', 'pt_PT', 'Nova edição de Acesso Aberto', 'Caros leitores,<br />\n<br />\nA {$contextName} acaba de disponibilizar em Acesso Aberto uma nova edição. Convidamo-lo a consultar o Sumário e aceder à revista ({$contextUrl}), para ler os artigos disponíveis e outros itens do seu interesse.<br />\n<br />\nAgradecemos o interesse pelas nossas publicações,<br />\n{$editorialContactSignature}', 'Esta mensagem é enviada a leitores registados que solicitam a receção de notificações da publicação de novas edições em Acesso Aberto.'),
('OPEN_ACCESS_NOTIFY', 'ro_RO', 'Acest număr poate fi accesat liber', 'Dragi cititori:<br />\n<br />\n{$contextName} tocmai a pus la dispoziție într-un format de acces deschis următorul număr. Vă invităm să consultați cuprinsul aici și apoi să vizitați site-ul nostru web ({$contextUrl}) pentru a revizui articole și pentru a citi articole de interes.<br />\n<br />\nVă mulțumim pentru interesul continuu pentru revista noastră,<br />\n{$editorialContactSignature}', 'Acest e-mail este trimis cititorilor înregistrați care au solicitat să primească un e-mail de notificare atunci când număr devine cu acces deschis.'),
('OPEN_ACCESS_NOTIFY', 'ru_RU', 'Выпуск уже в открытом доступе', 'Уважаемые читатели!<br />\n<br />\nЖурнал «{$contextName}» только что предоставил открытый доступ к следующему выпуску. Мы предлагаем вам ознакомиться здесь с содержанием выпуска, а затем посетить наш веб-сайт ({$contextUrl}), чтобы прочитать статьи и сообщения на интересующие вас темы.<br />\n<br />\nБлагодарю вас за постоянный интерес к нашей работе,<br />\n{$editorialContactSignature}', 'Это письмо отправляется тем зарегистрированным читателям, которые подписались на получение уведомлений на электронную почту о том, что номер появился в открытом доступе.'),
('OPEN_ACCESS_NOTIFY', 'sk_SK', 'Teraz otvorený prístup k číslu', 'Čitatelia:<br />\n<br />\nČasopis {$contextName} povolil otvorený prístup k nasledujúcemu číslu. Pozývame vás na prehliadnutie obsahu časopisu a návštevu našich stránok ({$contextUrl}).<br />\n<br />\nĎakujeme za Váš pokračujúci záujem o našu prácu<br />\n{$editorialContactSignature}', 'Tento email je posielaný čitateľom, ktorí požiadali o zasielanie upozornení na prechod čísla časopisu do otvoreného prístupu.'),
('OPEN_ACCESS_NOTIFY', 'sl_SI', 'Issue Now Open Access', 'Readers:<br />\n<br />\n{$contextName} has just made available in an open access format the following issue. We invite you to review the Table of Contents here and then visit our web site ({$contextUrl}) to review articles and items of interest.<br />\n<br />\nThanks for the continuing interest in our work,<br />\n{$editorialContactSignature}', 'This email is sent to registered readers who have requested to receive a notification email when an issue becomes open access.'),
('OPEN_ACCESS_NOTIFY', 'sv_SE', 'Nummer nu tillgängligt som open access', 'Läsare:<br />\n<br />\n{$contextName} har nyligen gjort ett nytt nummer tillgängligt som open access. Se innehållsförteckningen här och klicka dig sedan in på vår webbplats {$contextUrl}) för att ta del av material av intresse.<br />\n<br />\nTack för fortsatt visat intresse för vårt arbete!<br />\n{$editorialContactSignature}', 'Det här e-postmeddelandet skickas till registrerade läsare som har begärt att meddelas om och när ett nummer görs tillgängligt som open access.'),
('OPEN_ACCESS_NOTIFY', 'tr_TR', 'Sayı Açık Erişime Açıldı', 'Sayın Okuyucu,<br />\n<br />\n{$contextName} aşağıdaki sayıyı açık erişime açmıştır. Sizi sayının içindekiler bölümünü incelemeye ve dilediğiniz yazıları okumak üzere web sitemize davet ediyoruz ({$contextUrl}).<br />\n<br />\nÇalışmalarımıza süren ilginiz için teşekkür ederiz,<br />\n{$editorialContactSignature}', 'Bu mesaj sayı açık erişime açıldığında haberdar olmak isteyen okuyuculara gönderilir.'),
('OPEN_ACCESS_NOTIFY', 'uk_UA', 'Випуск з''явився у відритому доступі', 'Читачі:<br />\n<br />\nВидання &quot;{$contextName}&quot; відкрило доступ до наступного випуску. Запрошуємо переглянути сторінку змісту випуску, а потім відвідати наш веб-сайт (<a href="{$contextUrl}">{$contextUrl}</a>), щоб переглянути статті та інші матеріали, що можуть Вас зацікавити.<br />\n<br />\nДякуємо, що продовжуєте цікавитись нашою роботою,<br />\n{$editorialContactSignature}', 'Цей лист надсилається зареєстрованим читачам, які виявили бажання отримувати поштові повідомлення про появу випусків у відкритому доступі.'),
('OPEN_ACCESS_NOTIFY', 'vi_VN', 'Truy cập mở', 'Kính gửi  Độc giả,<br />\n<br />\n{$contextName} vừa có sẵn một số cho phép truy cập mở. Chúng tôi kính mời bạn tham khảo mục lục tại đây và sau đó truy cập trang web của chúng tôi ({$contextUrl}) để xem chi tiết các bài viết mà bạn quan tâm.<br />\n<br />\nCám ơn sự quan tâm của bạn với các ấn phẩm của chúng tôi,<br />\n{$editorialContactSignature}', 'Email này được gửi đến những độc giả đã đăng ký, những người đã yêu cầu nhận email thông báo khi một số cho truy cập mở.'),
('OPEN_ACCESS_NOTIFY', 'zh_CN', '本期内容已经开放访问', '亲爱的读者您好：<br />\n<br />\n《{$contextName}》已经以开放访问的格式公开本期期刊内容。我们邀请您浏览这里所附的目录，并且接着访问我们的网站 ({$contextUrl}) ，阅读文章以及您感兴趣的项目。<br />\n<br />\n感谢您持续地关注本期刊<br />\n<br />\n{$editorialContactSignature}', '这封电子邮件是寄发给要求在一期期刊变成公开格式时收到一份通知电子邮件的已注册读者。'),
('ORCID_COLLECT_AUTHOR_ID', 'ar_IQ', 'تقديم ORCID', '>عزيزنا {$authorName}،<br/>\n<br/>\nلقد تم إدراجك بمثابة مؤلف مشارك في عمل مقدم إلى {$contextName}.<br/>\nلتأكيد مصادقتك، لطفاً، أضف رمزك التعريفي في ORCID إلى طلب التقديم هذا عبر زيارة الرابط أدناه.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>إفتح حساباً أو ضع رمزك في ORCID</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">المزيد مع المعلومات عن ORCID في {$contextName}</a><br/>\n<br/>\nإذا كانت لديك أي استفسارات، رجاءً، لا تتردد في مراسلتي.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'قالب الرسالة هذا يستعمل لجمع الرموز التعريفية في ORCID من المؤلفين المشاركين.'),
('ORCID_COLLECT_AUTHOR_ID', 'ca_ES', 'ORCID de tramesa', 'Benvolgut/da {$authorName},<br/>\n<br/>\nUs han afegit com a autor/a d''un article per a {$contextName}.<br/>\nPer confirmar la vostra autoria, afegiu el vostre iD ORCID a aquesta tramesa a través de l''enllaç que apareix a continuació.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registrar o connectar el vostre iD ORCID</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Més informació sobre ORCID a {$contextName}</a><br/>\n<br/>\nSi teniu qualsevol pregunta no dubteu a contactar-me.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Aquesta plantilla de correu electrònic s''utilitza per recopilar els identificadors ORCID dels autors/es.'),
('ORCID_COLLECT_AUTHOR_ID', 'cs_CZ', 'ORCID ID příspěvku', 'Vážený (á) {$authorName},<br/>\n<br/>\nByl jste uveden(a) jako autor manuskriptu příspěvku do {$contextName}.<br/>\nPro potvrzení vašeho autorství přidejte, prosím, pomocí níže uvedeného odkazu, k tomuto příspěvku vaše ORCID iD.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Zaregistrujte či připojte vaše ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Více informací o ORCID najdete na {$contextName}</a><br/>\n<br/>\nPokud máte jakékoliv dotazy, kontaktujte nás, prosím.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Tato šablona emailu slouží k shromažďování ORCID ID od spoluautorů.'),
('ORCID_COLLECT_AUTHOR_ID', 'da_DK', 'Indsendelse ORCID', 'Kære {$authorName},<br/>\n<br/>\nDu står opført som medforfatter til manuskriptet "{$submissionTitle}" i {$contextName}.<br/>\n<br/>\nFor at bekræfte forfatterskabet bedes du tilføje din ORCID id til denne indsendelse ved at gå til det fremlagte link nedenfor.<br/>\n<br/>\n{$authorOrcidUrl}<br/>\n<br/>\nHar du spørgsmål bedes du kontakte mig.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Denne e-mail bruges til at indsamle ORCID id fra medforfattere.'),
('ORCID_COLLECT_AUTHOR_ID', 'de_DE', 'ORCID Zugriff erbeten', 'Liebe/r {$authorName},<br/>\n<br/>\nSie sind als Autor/in eines eingereichten Beitrags bei der Zeitschrift {$contextName} benannt worden.<br/>\n<br/>\nUm Ihre Autor/innenschaft zu bestätigen, geben Sie bitte Ihre ORCID iD für diese Einreichung an, indem Sie den unten angegebenen Link aufrufen.<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>ORCID iD registrieren oder ihre verbinden</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Mehr Informationen zu ORCID bei {$contextName}</a><br/>\n<br/>\nWenn Sie Fragen dazu haben, melden Sie sich bitte bei mir.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Diese E-Mail-Vorlage wird verwendet, um die ORCID-iDs von Co-Autor/innen einzuholen.'),
('ORCID_COLLECT_AUTHOR_ID', 'el_GR', 'Υποβολή ORCID', 'Αγαπητέ/η {$authorName},\n\nΈχετε καταχωρηθεί ως ένας/μια από τους συγγραφείς στην υποβολή "{$submissionTitle}" στο "{$contextName}".\n\nΠαρακαλούμε συμπληρώστε το ORCID iD σας στα στοιχεία της υποβολής, επιλέγοντας τον ακόλουθο σύνδεσμο:\n\n{$authorOrcidUrl}\n\nΠαρακαλώ επικοινωνήστε μαζί μας εάν χρειάζεστε πρόσθετες διευκρινίσεις.\n\n{$editorialContactSignature}\n\n\n', 'Αυτό το μήνυμα χρησιμοποιείται για τη συλλογή του ORCID iD των συγγραφέων.'),
('ORCID_COLLECT_AUTHOR_ID', 'en_US', 'Submission ORCID', 'Dear {$authorName},<br/>\n<br/>\nYou have been listed as an author on a manuscript submission to {$contextName}.<br/>\nTo confirm your authorship, please add your ORCID id to this submission by visiting the link provided below.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or connect your ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">More information about ORCID at {$contextName}</a><br/>\n<br/>\nIf you have any questions, please contact me.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'This email template is used to collect the ORCID id''s from authors.'),
('ORCID_COLLECT_AUTHOR_ID', 'es_ES', 'ORCID de envío', 'Estimado/a {$authorName},\n<br/>\nSe le ha añadido como coautor/a de un artículo para {$contextName}. <br/>\nPara confirmar su autoría, añada su identificador ORCID a este envío mediante el siguiente enlace.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registrar o conectar su identificador ORCID</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Puede encontrar más información sobre ORCID en {$contextName}</a><br/>\n<br/>\nSi tiene cualquier pregunta no dude en contactarme.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Esta plantilla de correo electrónico se utiliza para recopilar los identificadores ORCID de los autores/as.'),
('ORCID_COLLECT_AUTHOR_ID', 'fi_FI', 'Käsikirjoituksen ORCID-tunnisteet', 'Arvoisa {$authorName},<br/>\n<br/>\nTeidät mainitaan yhtenä kirjoittajana käsikirjoituksessa "{$submissionTitle}", joka on lähetetty julkaisuun {$contextName}.<br/>\n<br/>\nVarmistaaksesi tekijyytesi, ole hyvä ja lisää ORCID-tunnisteesi käsikirjoitukseen vierailemalla alla olevassa linkissä ja seuraamalla ohjeita.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Rekisteröi tai yhdistä ORCID</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Lisätietoja ORCID-tunnisteista julkaisussa {$contextName}</a><br/>\n<br/>\nMikäli teillä on jotain kysymyksiä, olkaa yhteydessä.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Tätä sähköpostipohjaa käytetään kirjoittajien ORCID-tunnisteiden keräämiseen.');
INSERT INTO `email_templates_default_data` VALUES
('ORCID_COLLECT_AUTHOR_ID', 'fr_CA', 'Soumission ORCID', '{$authorName},<br/>\n<br/>\nVous avez été inscrit ou inscrite en tant qu''auteur ou auteure pour un manuscrit soumis à {$contextName}.<br/>\nPour confirmer votre statut d''auteur ou d''auteure, veuillez ajouter votre identifiant ORCID à cette soumission en cliquant sur le lien ci-dessous.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="icône identifiant ORCID" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Se connecter avec votre identifiant ORCID ou s''inscrire</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Plus de renseignements sur votre identifiant ORCID dans {$contextName}</a><br/>\n<br/>\nSi vous avez des questions, veuillez communiquer avec nous.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Ce modèle de courriel est utilisé pour récupérer les identifiants ORCID des auteurs-es.'),
('ORCID_COLLECT_AUTHOR_ID', 'fr_FR', 'Soumission ORCID', '{$authorName},<br/>\n<br/>\nVous avez été inscrit ou inscrite en tant qu''auteur ou autrice pour un manuscrit soumis à {$contextName}.<br/>\nPour confirmer votre statut d''auteur ou d''autrice, veuillez ajouter votre identifiant ORCID à cette soumission en cliquant sur le lien ci-dessous.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https ://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="icône identifiant ORCID" style="display : block ; margin : 0 .5em 0 0 ; padding : 0 ; float : left ;"/>Créez ou connectez-vous avec votre identifiant ORCID</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Plus de renseignements sur votre identifiant ORCID dans {$contextName}</a><br/>\n<br/>\nSi vous avez des questions, n''hésitez pas à nous contacter.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Ce modèle de courriel est utilisé pour récupérer les identifiants ORCID des auteurs et autrices.'),
('ORCID_COLLECT_AUTHOR_ID', 'hu_HU', 'ORCID azonosító hozzárendelés', 'Tisztelt {$authorName}!<br/>\n<br/>\nÖn a(z) {$contextName} folyóirathoz beküldött kézirat szerzőjeként lett megjelölve.<br/>\nKérjük, erősítse meg szerzői státuszát az ORCID azonosítójának hozzárendelésével, melyet a következő címen tehet meg.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Regisztrálás vagy ORCID iD összekapcsolása</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">További információk az ORCID-ról a(z) {$contextName} folyóiratnál</a><br/>\n<br/>\nHa kérdése merül fel, kérem vegye fel a kapcsolatot szerkesztőségünkkel.<br/>\n<br/>\nÜdvözlettel,<br/>\n{$principalContactSignature}<br/>\n', 'Ezzel az email sablonnal az ORCID azonosítókat kérjük be a Szerzőktől.'),
('ORCID_COLLECT_AUTHOR_ID', 'id_ID', 'ORCID Naskah', 'Yang Kami Hormati {$authorName},<br/>\n<br/>\nAnda telah terdaftar sebagai penulis naskah{$contextName}.<br/>\nUntuk mengonfirmasi kepenulisan tersebut, tambahkanlah id ORCID Anda pada naskah tersebut dengan membuka tautan berikut ini.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register atau hubungkan iD ORCID Anda</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Informasi selengkapnya tentang ORCID pada {$contextName}</a><br/>\n<br/>\nBila ada pertanyaan, silakan hubungi kami.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Template surel ini digunakan untuk mengumpulkan id ORCID penulis.'),
('ORCID_COLLECT_AUTHOR_ID', 'it_IT', 'Le chiediamo di inserire l''ORCID', 'Gentile {$authorName},<br/>\n<br/>\nLei è stato indicato come co-autore di un manoscritto sottoposto per la pubblicazione a {$contextName}.<br/>\nPer confermare la sua responsabilità come autore, le chiediamo di aggiungere il suo ORCID iD alla sottomissione, utilizzando il link sottostante. <br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or connect your ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Maggiori informazioni in merito ad ORCID sono disponibili a {$contextName}</a><br/>\n<br/>\nPer qualsiasi ulteriore chiarimento, la prego di contattarmi.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Questa mail è utilizzata per ottenere  l''ORCID dai coautori.'),
('ORCID_COLLECT_AUTHOR_ID', 'ku_IQ', 'پێشکەشکردن بۆ ORCID', 'بەڕێز{$authorName},<br/>\n<br/>\nتۆ وەک نوسەری ئەم توێژینەوەیە دیاری کراویت: {$contextName}.<br/>\nبۆ قبوڵکردنی خاوەندارییەکەتم، تکایە ئەژماری ORCIDیەکەت زیاد بکە. <br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>ئەژمارەک دروست بکە یان داخلی ئەژمارەکەت ببە ئەگەر هەتە  ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">زانیاریی زیاتر دەربارەی ORCID {$contextName}</a><br/>\n<br/>\nبۆ هەر پرسیارێک تکایە پەیوەندیمان پێوە بکە.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'تێمپلەیتی ئەم ئیمەیڵە بۆ کۆکردنەوەی ئەژماری ORCIDی توێژەرانە.'),
('ORCID_COLLECT_AUTHOR_ID', 'mk_MK', 'Испраќање на ORCID', 'Почитуван {$authorName},<br/>\n<br/>\nВие сте наведени како автор на поднесен ракопис до {$contextName}.<br/>\nЗа да го потврдите вашето авторство, додадете го вашиот ID на ORCID на овој поднесок со посета на врската дадена подолу. <br/>\n<br/>\n<a href="{$authorOrcidUrl}"> <img id = "orcid-id-logo" src = "https://orcid.org/sites/default/files/images/orcid_16x16.png" width = ''16 '' height = ''16 ''alt = "ORCID iD icon" style = "display: block; margin: 0 .5em 0 0; padding: 0; float: left;" /> Регистрирај се или поврзете го вашиот ORCID iD </a> <br />\n<br/>\n<br>\n<a href="{$orcidAboutUrl}"> Повеќе информации за ORCID на {$textName} </a> <br/>\n<br/>\nАко имате какви било прашања, контактирајте ме. <br/>\n<br/>\n{$principalContactSignature} <br/>\n', 'Овој образец за е-пошта се користи за собирање на ID-на ORCID од автори.'),
('ORCID_COLLECT_AUTHOR_ID', 'nb_NO', 'ORCID for innlevering', 'Kjære {$authorName}, <br />\n<br />\nDu er oppført som forfatter på en manusinnlevering til {$contextName}. <br />\nFor å bekrefte forfatterskapet ditt, vennligst legg til ORCID-ID-en din i denne innleveringen ved å gå til lenken nedenfor. <br />\n<br />\n<a href="{$authorOrcidUrl}"> <img id = "orcid-id-logo" src = "https://orcid.org/sites/default/files/images/orcid_16x16.png" width = ''16 '' height = ''16 ''alt = "ORCID iD icon" style = "display: block; margin: 0 .5em 0 0; padding: 0; float: left;" /> Registrer eller koble ORCID iD </a> <br />\n<br />\n<br />\n<a href="{$orcidAboutUrl}"> Mer informasjon om ORCID på {$contextName} </a> <br />\n<br />\nTa gjerne kontakt hvis du har spørsmål. <br />\n<br />\n{$principalContactSignature} <br />\n', 'Denne e-posten brukes til å samle inn ORCID fra forfattere.'),
('ORCID_COLLECT_AUTHOR_ID', 'nl_NL', 'ORCID van uw inzending', 'Beste {$authorName},<br/>\n<br/>\nU bent auteur van een inzending voor {$contextName}.<br/> \nWilt u bevestigen dat u co-auteur bent door uw ORCID id toe te voegen via volgende link?<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registreer of koppel uw ORCID ID</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Meer informatie over ORCID op {$contextName}</a><br/>\n<br/>\nNeemt u alstublieft contact op als u vragen heeft.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Deze e-mail wordt verstuurd om de ORCID ID''s van auteurs te verzamelen.'),
('ORCID_COLLECT_AUTHOR_ID', 'pl_PL', 'Autoryzacja ORCID w tekście naukowym', 'Drogi/a {$authorName},<br/>\n<br/>\nW czasopiśmie {$contextName} zostałeś/aś oznaczona jako autor/współautor. Aby potwierdzić ten fakt i połączyć tekst z Twoim kontem ORCID, proszę odwiedzić link zamieszczony poniżej.\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Zarejestruj się lub połącz tekst ze swoim kontem ORCID</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Więcej o ORCID w {$contextName}</a><br/>\n<br/>\nW razie dodatkowych pytań proszę o kontakt:<br/>\n<br/>\n{$principalContactSignature}\n', 'Mail jest używany do poinformowania autorów o konieczności autoryzacji ORCID.'),
('ORCID_COLLECT_AUTHOR_ID', 'pt_BR', 'ORCID da submissão', 'Prezado(a) {$authorName},<br>\n<br>\nVocê foi listada(o) como um coautor(a) em uma submissão de manuscrito "{$submissionTitle}" para {$contextName}.<br/>\nPara confirmar sua autoria, por favor adicione sua id ORCID a esta submissão, visitando o link fornecido abaixo.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registre ou conecte seu ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Mais informações sobre o ORCID em {$contextName}</a><br/>\n<br/>\nSe você tiver quaisquer dúvidas, por favor entre em contato comigo.<br/>\n<br/>\n{$editorialContactSignature}<br/>\n', 'Este modelo de e-mail é utilizado para coletar os id ORCID dos coautores.'),
('ORCID_COLLECT_AUTHOR_ID', 'pt_PT', 'Submissão ao ORCID', 'Caro(a) {$authorName},<br/>\n<br/>\nO seu nome foi indicado como autor de um manuscrito submetido à revista {$contextName}. <br/>\n<br/>\nPara confirmar a sua autoria, por favor adicione o seu identificador ORCID à submissão visitando a página indicada abaixo.<br/>\n<br/>\n\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registe ou entre no seu ORCID</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Mais informação sobre o ORCID em {$contextName}</a><br/>\n<br/>\nNão hesite em contactar-nos para qualquer  questão.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Este e-mail é usado para recolher os identificadores ORCID dos autores.'),
('ORCID_COLLECT_AUTHOR_ID', 'ru_RU', 'ORCID материала', '{$authorName}!<br/>\n<br/>\nВы были указаны как автор материала, отправленного в «{$contextName}».<br/>\nЧтобы подтвердить свое авторство, пожалуйста, добавьте свой идентификатор ORCID к этому материалу, перейдя по приведенной ниже ссылке.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Создать или подключить ваш ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Дополнительная информация об ORCID в «{$contextName}»</a><br/>\n<br/>\nЕсли у Вас есть какие-либо вопросы, пожалуйста, свяжитесь со мной.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Этот шаблон письма используется для сбора идентификаторов ORCID с авторов.'),
('ORCID_COLLECT_AUTHOR_ID', 'sl_SI', 'ORCID prispevka', 'Spoštovani {$authorName},<br/>\n<br/>\nNavedeni ste bili kot soavtor rokopisa prispevka za revijo{$contextName}.<br/>\nDa potrdite avtorstvo, vas prosimo, da dodate vaš ORCID iD v prispevek s klikom na spodnjo povezavo.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registracija ali povezava z vašim ORCID iD</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Več o ORCID pri reviji {$contextName}</a><br/>\n<br/>\nČe imate kakršnakoli vprašanje, me prosim kontaktirajte.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Email se uporablja za zbiranje ORCID iD-jev soavtorjev.'),
('ORCID_COLLECT_AUTHOR_ID', 'sv_SE', 'ORCID för bidrag', 'Hej {$authorName}!\n\nDu är listad som medförfattare till bidraget "{$submissionTitle}" till {$contextName}. \n\nFör att bekräfta ditt författarskap, lägg till ditt ORCID-iD genom att följa länken nedan.\n\n{$authorOrcidUrl}\n\nKontakta gärna mig om du har några frågor.', 'Den här e-postmallen används för att samla in ORCID-iD:n från medförfattare.'),
('ORCID_COLLECT_AUTHOR_ID', 'tr_TR', 'ORCID Gönderisi', 'Sayın {$authorName},\n{$contextName} adlı dergiye sunulan "{$submissionTitle}" adlı makale için ortak yazar olarak yazıldınız.\nYazarlığınızı onaylamak için lütfen aşağıdaki bağlantıyı ziyaret ederek ORCID kimliğinizi dergimize ekleyiniz.\n{$authorOrcidUrl}\nHerhangi bir sorunuz olması halinde, lütfen bize yazınız.\n', 'Bu e-posta şablonu ORCID kimliklerini ortak yazarlardan istemek için kullanılır.'),
('ORCID_COLLECT_AUTHOR_ID', 'uk_UA', 'ORCID подання', 'Шановний|Шановна {$authorName},\n<br/>\nВи були зазначені як автор рукопису, надісланого в {$contextName}. <br/>\nЩоб підтвердити своє авторство, додайте свій ідентифікатор ORCID до цього подання, відвідавши посилання, вказане нижче.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Зареєструватися або увійти з ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Більше інформації про ORCID тут {$contextName}</a><br/>\n<br/>\nЯкщо ви маєте запитання, напишіть мені.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Цей шаблон електронного листа використовується для збору ідентифікаторів ORCID з співавторів.'),
('ORCID_COLLECT_AUTHOR_ID', 'vi_VN', 'Gửi ORCID', 'Kính gửi {$authorName},<br/>\n<br/>\nBạn đã được liệt kê như là một tác giả trên một bản thảo để {$contextName}.<br/>\nĐể xác nhận quyền tác giả của bạn, vui lòng thêm id ORCID của bạn vào bài đăng này bằng cách truy cập liên kết được cung cấp bên dưới.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or connect your ORCID iD</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Thông tin thêm về ORCID tại {$contextName}</a><br/>\n<br/>\nNếu bạn có bất kỳ câu hỏi, xin vui lòng liên hệ với tôi.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Mẫu email này được sử dụng để thu thập id ORCID từ các tác giả.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'ar_IQ', 'إلتماس الوصو إلى حساب ORCID', 'عزيزنا {$authorName}،<br>\n<br>\nلقد تم إدراجك بمثابة مؤلف مشارك في العمل الموسوم "{$submissionTitle}" والمقدم إلى {$contextName}.\n<br>\n<br>\nنلتمس منح الموافقة على إضافة رمزك في ORCID إلى طلب التقديم هذا وكذلك إضافة هذا الطلب إلى ملفك الشخصي في ORCID عند النشر.<br>\nقم بزيارة الرابط الرسمي لموقع ORCID، وسجل دخولك فيه ثم أجرِ ما يلزم لتفويضنا عبر اتباع التعليمات الآتية:<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="إيقونة رمز ORCID" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>إفتح حساباً أو ضع رمزك في ORCID</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">المزيد مع المعلومات عن ORCID في {$contextName}</a><br/>\n<br>\nإذا كانت لديك أي استفسارات، رجاءً، لا تتردد في مراسلتي.<br>\n<br>\n{$principalContactSignature}<br>\n', 'قالب الرسالة هذا يستعمل لمطالبة المؤلفين المشاركين بالسماح لنا في الوصول إلى رموزهم التعريفية في ORCID.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'ca_ES', 'Sol·licitant accés de registre ORCID', 'Benvolgut/da {$authorName},<br>\n<br>\nUs han afegit com a autor/a de l''article "{$submissionTitle}" per a {$contextName}.\n<br>\n<br>\nUs demanem que ens permeteu afegir el vostre iD ORCID a aquesta tramesa i també afegir l''esmentada tramesa al vostre perfil ORCID en la publicació.<br>\nVisiteu l''enllaç del lloc web oficial d''ORCID, inicieu la sessió amb el vostre perfil i autoritzeu l''accés seguint les instruccions següents.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registrar o connectar el vostre iD ORCID</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Mes informació sobre ORCID a {$contextName}</a><br/>\n<br>\nSi teniu qualsevol pregunta no dubteu a contactar-me.<br>\n<br>\n{$principalContactSignature}<br>\n', 'Aquesta plantilla de correu electrònic s''utilitza per demanar accés de registre ORCID als autors/es.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'cs_CZ', 'Požadavek na přístup k záznamu ORCID', 'Vážený(á) {$authorName},<br>\n<br>\nByl(a) jste uveden(a) jako autor manuskriptu příspěvku "{$submissionTitle}" to {$contextName}.\n<br>\n<br>\nDovolte nám, prosím, přidat vaše ORCID ID k tomuto příspěvku a také přidat tento příspěvek do vašeho ORCID publikačnímu profilu.<br>\nNavštivte, prosím, odkaz na oficiální webovou stránku ORCID, přihlaste se a a povolte přístup našeho časopisu dle následujících pokynů.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registrujte se či připojte své ORCID ID</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Více informací o  ORCID najdete na {$contextName}</a><br/>\n<br>\nPokud máte jakékoliv dotazy, kontaktujte nás, prosím.<br>\n<br>\n{$principalContactSignature}<br>\n', 'Tato šablona emailů je používána, pokud od autorů chceme umožnění přístupu k záznamům ORCID.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'da_DK', 'Anmoder om adgang til ORCID-post', 'Kære {$authorName}<br>\n<br>\nDu er blevet opført som forfatter på manuskriptindsendelsen"{$submissionTitle}" til {$contextName}.\n<br>\n<br>\nTillad os at tilføje dit ORCID-id til denne indsendelse og også at tilføje indsendelsen til din ORCID-profil i forbindelse med publicering.<br>\nBesøg linket til det officielle ORCID-websted, log ind med din profil og tillad adgangen ved at følge instruktionerne.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or Connect your ORCID iD</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">More about ORCID at {$contextName}</a><br/>\n<br>\nHvis du har spørgsmål, så kontakt mig.<br>\n<br>\n{$principalContactSignature}<br>\n', 'Denne e-mail-skabelon bruges til at anmode om ORCID-adgang fra forfattere.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'de_DE', 'ORCID Zugriff erbeten', 'Liebe/r {$authorName},<br>\n<br>\nSie sind als Autor/in des eingereichten Beitrags "{$submissionTitle}" bei der Zeitschrift {$contextName} benannt worden.<br>\n<br>\nBitte gestatten Sie uns Ihre ORCID-ID, falls vorhanden, zu diesem Beitrag hinzuzufügen, sowie ihr ORCID Profil bei Veröffentlichung des Beitrags zu aktualisieren.<br>\nDazu folgen Sie dem unten stehenden Link zur offiziellen ORCID-Seite, melden sich mit ihren Daten an und authorisieren Sie den Zugriff, indem\nSie den Anweisungen auf der Seite folgen.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>ORCID iD registrieren oder ihre verbinden</a><br/>\n<br/>\n<br>\n<a href="{$orcidAboutUrl}">Mehr Informationen zu ORCID bei {$contextName}</a>.\n<br>\nWenn Sie Fragen dazu haben, melden Sie sich bitte.<br>\n<br>\n{$principalContactSignature}<br>\n', 'Diese E-Mail-Vorlage wird verwendet, um die Authorisierung für ORCID Profil Zugriff von Autor/innen einzuholen.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'el_GR', 'Αίτημα πρόσβασης στο ORCID σας', 'Αγαπητέ/η {$authorName},<br>\n<br>\nΈχετε καταχωρηθεί ως συγγραφέας στην υποβολή "{$submissionTitle}" στο "{$contextName}".\n<br>\n<br>\nΠαρακαλούμε επιτρέψτε μας να προσθέσουμε το ORCID id σας στην υποβολή, καθώς και να καταχωρήσουμε την υποβολή στο ORCID προφίλ σας κατά τη δημοσίευσή της.<br>\nΕπιλέξτε τον σύνδεσμο προς τον ιστότοπο του ORCID, εισέλθετε στον λογαριασμό σας και ενεργοποιήστε τη δυνατότητα πρόσβασης ακολουθώντας τις σχετικές οδηγίες.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or Connect your ORCID iD</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Περισσότερες πληροφορίες για το ORCID στο {$contextName}</a><br/>\n<br>\nΠαρακαλώ επικοινωνήστε μαζί μας εάν χρειάζεστε πρόσθετες διευκρινίσεις.<br>\n<br>\n{$principalContactSignature}<br>\n', 'Αυτό το μήνυμα χρησιμοποιείται ως αίτημα πρόσβασης στο μητρώο ORCID των συγγραφέων.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'en_US', 'Requesting ORCID record access', 'Dear {$authorName},<br>\n<br>\nYou have been listed as an author on the manuscript submission "{$submissionTitle}" to {$contextName}.\n<br>\n<br>\nPlease allow us to add your ORCID id to this submission and also to add the submission to your ORCID profile on publication.<br>\nVisit the link to the official ORCID website, login with your profile and authorize the access by following the instructions.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register or Connect your ORCID iD</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">More about ORCID at {$contextName}</a><br/>\n<br>\nIf you have any questions, please contact me.<br>\n<br>\n{$principalContactSignature}<br>\n', 'This email template is used to request ORCID record access from authors.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'es_ES', 'Solicitando acceso de registro ORCID', 'Estimado/a {$authorName},<br>\n<br>\nUsted ha sido incluido como autor en la presentación del manuscrito "{$submissionTitle}" a {$contextName}.\n<br>\n<br>\nPermítanos agregar su identificación ORCID a este envío y también agregar el mismo a su perfil ORCID en la publicación.<br>\nVisite el enlace al sitio web oficial de ORCID, inicie sesión con su perfil y autorice el acceso siguiendo las instrucciones.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registre o conecte su ORCID iD</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Más acerca de ORCID en{$contextName}</a><br/>\n<br>\nSi tiene alguna pregunta, por favor póngase en contacto conmigo.<br>\n<br>\n{$principalContactSignature}<br>\n', 'Esta plantilla de correo electrónico se utiliza para solicitar acceso de registro ORCID a los autores/as.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'fi_FI', 'ORCID-pääsyn pyyntö', 'Dear {$authorName},<br>\n<br/>\nTeidät mainitaan yhtenä kirjoittajana käsikirjoituksessa "{$submissionTitle}", joka on lähetetty julkaisuun {$contextName}.<br/>\n<br/>\nVarmistaaksesi tekijyytesi, ole hyvä ja lisää ORCID-tunnisteesi käsikirjoitukseen vierailemalla alla olevassa linkissä ja seuraamalla ohjeita. Artikkelin julkaisun jälkeen sitä koskevat tiedot voidaan liittää ORCID-tiliisi, jos olet antanut siihen luvan.<br/>\n<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Rekisteröi tai yhdistä ORCID</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Lisätietoja ORCID-tunnisteista julkaisussa {$contextName}</a><br/>\n<br/>\nMikäli teillä on jotain kysymyksiä, olkaa yhteydessä.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Tätä sähköpostipohjaa käytetään ORCID-pääsyn pyytämiseen muilta kirjoittajilta.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'fr_CA', 'Demande d''accès au dossier ORCID', '{$authorName},<br/>\n<br/>\nVous avez été inscrit ou inscrite en tant qu''auteur ou auteure pour le manuscrit « {$submissionTitle} » soumis à {$contextName}.\n<br/>\n<br/>\nVeuillez nous autoriser à ajouter votre identifiant ORCID à cette soumission et à ajouter également la soumission à votre dossier ORCID suite à sa publication.\n<br/>\nSuivre le lien vers le site officiel ORCID, vous connecter avec votre profil et autoriser l''accès en suivant les instructions.<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="icône identifiant ORCID" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Se connecter avec votre identifiant ORCID ou s''inscrire</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Plus de renseignements sur votre identifiant ORCID dans {$contextName}</a><br/>\n<br/>\nSi vous avez des questions, veuillez communiquer avec nous.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Ce modèle de courriel est utilisé pour demander aux auteurs-es l''accès à leur dossier ORCID.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'fr_FR', 'Demande d''accès au dossier ORCID', '{$authorName},<br/>\n<br/>\nVous avez été inscrit ou inscrite en tant qu''auteur ou autrice pour le manuscrit « {$submissionTitle} » soumis à {$contextName}.\n<br/>\n<br/>\nVeuillez nous autoriser à ajouter votre identifiant ORCID à cette soumission et à ajouter également la soumission à votre dossier ORCID suite à sa publication.\n<br/>\nSuivez le lien vers le site officiel d''ORCID, connectez-vous avec votre profil et autorisez l''accès en suivant les instructions.<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="icône identifiant ORCID" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Créez ou connectez-vous avec votre identifiant ORCID</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Plus de renseignements sur votre identifiant ORCID dans {$contextName}</a><br/>\n<br/>\nSi vous avez des questions,N''hésitez pas à nous contacter.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Ce modèle de courriel est utilisé pour demander l''accès au dossier ORCID des auteurs et autrices.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'hu_HU', 'Hozzáférési kérés ORCID rekordhoz', 'Tisztelt {$authorName}!<br>\n<br>\nÖnt a(z) {$contextName} folyóirathoz beküldött "{$submissionTitle}" című kézirat szerzőjeként jelölték meg.\n<br>\n<br>\nKérjük közreműködését, hogy a kézirathoz hozzárendelhessük ORCID azonosítóját, illetve beküldését hozzáadjuk ORCID pofiljának publikációs listájához.<br>\nEhhez keresse fel a lenti link segítségével az ORCID hivatalos weboldalát, lépjen be és hagyja jóvá a kérést.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Regisztrálás vagy ORCID iD csatlakoztatása</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">További információk az ORCID-ról a(z) {$contextName} folyóiratnál</a><br/>\n<br>\nHa kérdése merül fel, kérem vegye fel a kapcsolatot szerkesztőségünkkel.<br>\n<br>\nÜdvözlettel,<br>\n{$principalContactSignature}<br>\n', 'Ezt az email sablont arra használjuk, hogy Szerzőktől kérjünk ORCID rekord hozzáférést.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'id_ID', 'Meminta akses rekaman ORCID', 'Yang Kami Hormati {$authorName},<br>\n<br>\nAnda telah terdaftar sebagai penulis naskah "{$submissionTitle}" pada {$contextName}.\n<br>\n<br>\nIjinkanlah kami menambahkan id ORCID Anda pada naskah ini serta menambahkan naskah pada profil ORCID Anda pada terbitan.<br>\nBuka tautan web ORCID, login dan beri akses sesuai petunjuk berikut.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Register atau hubungkan iD ORCID Anda</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">nformasi selengkapnya tentang ORCID pada {$contextName}</a><br/>\n<br>\nBila ada pertanyaan, silakan hubungi kami.<br>\n<br>\n{$principalContactSignature}<br/>\n', 'Template surel ini digunakan untuk meminta akses rekaman ORCID penulis.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'it_IT', 'Richiesta di accesso al record ORCID', 'Gentile {$authorName},<br>\n<br>\nIl suo nominativo è stato aggiunto come autore nel manoscritto "{$submissionTitle}" sottoposto per la pubblicazione a {$contextName}.\n<br>\n<br>\nLe chiediamo il permesso di aggiungere il suo ORCID a questa sottomissione e di poter aggiungere questa sottomissione al suo profilo ORCID<br>\nLe chiediamo di andare al suo profilo ufficiale ORCID e di autorizzare l''accesso seguendo le  indicazioni che verranno fornite. <br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Collega il tuo ORCID iD o registrati adesso </a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Maggiori informazioni su ORCID sono disponibili a questo indirizzo: {$contextName}</a><br/>\n<br>\nSe ha qualsiasi domanda o dubbio, la prego di contattarmi.<br>\n<br>\n{$principalContactSignature}<br>\n', 'Questa mail è utilizzata per richiedere agli autori accesso al proprio ORCID iD.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'ku_IQ', 'داواکردنی تۆماری ORCID', 'بەڕێز {$authorName},<br>\n<br>\nتۆ وەک نوسەری ئەم توێژینەوەیە دیاری کراویت "{$submissionTitle}" to {$contextName}.\n<br>\n<br>\nتکایە ڕێگەمان پێ بدە بە زیادکردنی هەژماری ORCIDیەکەت. <br>\nسەردانی وێبسایتی فەرمیی ORCID بکە و داخل ببە و ڕێپێدان بە گوێرەی ڕێنماییەکان بدە.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>هەژمارێکی ORCID دروست بکە، یان ئەگەر هەتە هەژمارەکەت بکەوە.</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">زانیاریی زیاتر دەربارەی ORCID  لە {$contextName}</a><br/>\n<br>\nبۆ هەر پرسیارێک، تکایە پەیوەندیم پێوە بکە.<br>\n<br>\n{$principalContactSignature}<br>\n', 'قاڵبی ئەم ئیمەیڵە بۆ ڕێگەپێدانی گرێدانی ORCID بەکار دێت لە لایەن توێژەرانەوە.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'mk_MK', 'Барање пристап до запис ORCID', 'Почитуван {$authorName}, <br>\n<br>\nВие сте наведени како автор на поднесувањето на ракописот „{$submissionTitle}“ до {$contextName}.\n<br>\n<br>\nВе молиме, дозволете ни да го додадеме вашиот ID на ORCID на овој поднесок и да го додадеме поднесувањето на вашиот ORCID профил на објавувањето. <br>\nПосетете ја врската до официјалната веб-страница на ORCID, најавете се со вашиот профил и овластете го пристапот следејќи ги упатствата. <br>\n<a href="{$authorOrcidUrl}"> <img id = "orcid-id-logo" src = "https://orcid.org/sites/default/files/images/orcid_16x16.png" width = ''16 '' height = ''16 ''alt = "ORCID iD icon" style = "display: block; margin: 0 .5em 0 0; padding: 0; float: left;" /> Регистрирај се или Поврзи го ORCID iD </a> <br />\n<br>\n<br>\n<a href="{$orcidAboutUrl}"> Повеќе за ORCID на {$textName} </a> <br/>\n<br>\nАко имате какви било прашања, контактирајте ме. <br>\n<br>\n{$principalContactSignature} <br>\n', 'Овој образец за е-пошта се користи за да се побара пристап до записот ORCID од авторите.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'nb_NO', 'Forespørsel om tilgang til ORCID', 'Kjære {$authorName}, <br />\n<br />\nDu er oppført som forfatter på manusinnleveringen "{$submissionTitle}" til {$contextName}. <br />\nFor å bekrefte forfatterskapet ditt, vennligst legg til ORCID-ID-en din i denne innleveringen ved å gå til lenken nedenfor. <br />\n<br />\n<a href="{$authorOrcidUrl}"> <img id = "orcid-id-logo" src = "https://orcid.org/sites/default/files/images/orcid_16x16.png" width = ''16 '' height = ''16 ''alt = "ORCID iD icon" style = "display: block; margin: 0 .5em 0 0; padding: 0; float: left;" /> Registrer eller koble ORCID iD </a> <br />\n<br />\n<br />\n<a href="{$orcidAboutUrl}"> Mer informasjon om ORCID på {$contextName} </a> <br />\n<br />\nTa gjerne kontakt hvis du har spørsmål. <br />\n<br />\n{$principalContactSignature} <br />\n', 'Denne e-postmalen brukes til å spørre om ORCID-tilgang fra forfattere.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'nl_NL', 'Toegangsverzoek tot uw ORCID profiel', 'Beste {$authorName},<br/>\n<br/>\nU bent auteur van het manuscript "{$submissionTitle}" dat werd ingediend voor {$contextName}.\n<br/>\n<br/>\nWilt u uw toestemming geven om uw ORCID ID toe te voegen aan deze inzending en de inzending toe te voegen aan uw ORCID profiel bij publicatie?<br/>\nKlik op de link naar de officiële ORCID website, meld u aan met uw gebruikersprofiel en authoriseer de toegang door de instructies te volgen.<br/>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registreer of koppel uw ORCID ID</a><br/>\n<br/>\n<br/>\n<a href="{$orcidAboutUrl}">Meer informatie over ORCID op {$contextName}</a><br/>\n<br>\nNeemt u alstublieft contact op als u vragen heeft.<br/>\n<br/>\n{$principalContactSignature}<br/>\n', 'Deze e-mail wordt verstuurd om toegang te vragen aan auteurs tot hun ORCID profiel.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'pl_PL', 'Prośba do autora o dostęp do profilu ORCID', 'Drogi/a {$authorName},<br>\n<br>\nZostałeś/aś oznaczona/y jako autor/współautor tekstu naukowego "{$articleTitle}" w {$contextName}.\n<br>\n<br>\nJako redakcja czasopsima zwracamy się w związku z tym prośbą o dopisanie Twojego ORCID ID do tego artykułu i jednocześnie chcemy dodać go do Twojej listy opublikowanych prac w ORCID.<br>\nZaloguj się proszę w czasopiśmie używając swoich danych ORCID co sprawi, że autoryzacja pracy bedzie możliwa. Odwiedź strone projektu ORCID aby zapoznać się ze szczegółową instrukcją na ten temat.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Zarejestruj sie w ORCID lub autoryzuj swój tekst</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Więcej o ORCID w {$contextName}</a><br/>\n<br>\nW razie dalszych pytań prosimy o kontakt.<br>\n<br>\n{$principalContactSignature}\n', 'Mail jest wykorzystywany w przypadku prośby o dostęp czasopisma do profilu ORCID autora.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'pt_BR', 'Solicitando acesso ao registro ORCID', 'Prezado(a) {$authorName}, <br>\n<br>\nVocê foi listado como autor na submissão do manuscrito "{$submissionTitle}" to {$contextName}.\n<br>\n<br>\nPermita-nos adicionar seu ID do ORCID a essa submissão e também adicioná-lo ao seu perfil do ORCID na publicação. <br>\nVisite o link para o site oficial do ORCID, faça o login com seu perfil e autorize o acesso seguindo as instruções. <br>\n<a href="{$authorOrcidUrl}"> <img id ="orcid-id-logo" src = "https://orcid.org/sites/default/files/images/orcid_16x16.png" width = ''16 '' height = ''16 '' alt = "Ícone ORCID iD" style = "display: block; margin: 0 .5em 0 0; padding: 0; float: left;" /> Registre ou conecte seu ORCID ID </a> <br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}"> Mais sobre o ORCID em {$contextName} </a> <br/>\n<br>\nSe você tiver alguma dúvida, entre em contato comigo. <br>\n<br>\n{$principalContactSignature} <br>\n', 'Este modelo de e-mail é usado para solicitar o acesso ao registro ORCID dos autores.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'pt_PT', 'Pedido de Associação de Identificador ORCID', 'Caro(a) {$authorName},<br>\n<br>\nFoi adicionado como autor do manuscrito da submissão "{$submissionTitle}" feita a {$contextName}.\n<br>\n<br>\nPor favor, conceda-nos permissão para adicionar o seu ORCID a esta submissão e também para adicionar a submissão ao seu perfil do ORCID como publicação. <br>\nConsulte o site oficial do ORCID, entre na sua conta e autorize o acesso seguindo as instruções que lhe fornecemos.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registar ou Entrar no seu ORCID iD</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Saiba mais sobre o ORCID em {$contextName}</a><br/>\n<br>\nSe tiver alguma questão adicional, entre em contacto connosco.<br>\n<br>\n{$principalContactSignature}<br>\n', 'Este template de email é utilizado para solicitar o acesso ao ORCID dos autores.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'ru_RU', 'Запрос доступа к записи ORCID', '{$authorName}!<br>\n<br>\nВы были указаны как автор материала «{$submissionTitle}», отправленного в «{$contextName}».\n<br>\n<br>\nПожалуйста, дайте нам возможность добавить ваш ORCID id к этому материалу, а также добавить материал в ваш профиль ORCID после публикации.<br>\nПерейдите по ссылке на официальном вебсайте ORCID, войдите в систему с вашей учетной записью и авторизуйте доступ, следуя инструкциям.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Создать или подключить ваш ORCID iD</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Подробнее об ORCID в «{$contextName}»</a><br/>\n<br>\nЕсли у Вас есть какие-либо вопросы, пожалуйста, свяжитесь со мной.<br>\n<br>\n{$principalContactSignature}<br>\n', 'Этот шаблон письма используется для запроса доступа к записи ORCID у авторов.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'sl_SI', 'Prošnja za dostop do ORCID zapisa', 'Spoštovani {$authorName},<br>\n<br>\nNašteti ste bili kot (so)avtor rokopisa prispevka "{$submissionTitle}" pri reviji {$contextName}.\n<br>\n<br>\nProsimo vas za dovoljenje, da dodamo vaš ORCID iD k temu prispevku in hkrati dodamo ta prispevek k vašem ORCID profilu pri reviji.<br>\nKliknite na povezavo na uradno ORCID stran, prijavite se z vašim profilom in avtorizirajte dostop po navodilih.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Registriraj ali poveži vaš ORCID iD</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Več o ORCID pri reviji {$contextName}</a><br/>\n<br>\nČe imate kakršnakoli vprašanje, me prosim kontaktirajte.<br/>\n<br>\n{$principalContactSignature}<br>\n', 'Email vsebuje prošnjo za dostop do ORCID zapisov avtorjev.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'tr_TR', 'ORCID kayıt erişimi', 'Sayın {$authorName},<br>\n<br>\n{$contextName} için gönderilen "{$submissionTitle}" başlıklı makalenin yazar listesinde yer alıyorsunuz.\n<br>\n<br>\nLütfen ORCID''nizi kullanmamıza izin veriniz.<br>\nORCID sayfasını ziyaret ederek giriş yapınız ve profil kısmından izin veren talimatları takip ediniz.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>ORCID iD için kayıt ol veya bağlan</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">ORCID hakkında daha fazla {$contextName}</a><br/>\n<br>\nHerhangi bir sorun yaşarsanız, benimle iletişim kurabilirsiniz.<br>\n<br>\n{$principalContactSignature}<br>\n', 'Bu e-posta şablonu yazarlardan ORCID kaydı erişimi istemek için kullanılır.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'uk_UA', 'Запит доступу до запису ORCID', 'Шановний|Шановна {$authorName},<br>\n<br>\nВи були зазначені як автор подання "{$submissionTitle}" до журналу {$contextName}.\n<br>\n<br>\nБудь-ласка, дозвольте нам додати ваш ORCID до цього подання а також додати подання до вашого профілю ORCID  після публікації.<br>\nВідвідайте офіційний сайт ORCID, авторизуйтеся з вашим профілем і надайте дозвіл за наступною інструкцією.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Зареєструватися або авторизуватися з ORCID iD</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Більше про ORCID за посиланням {$contextName}</a><br/>\n<br>\nЯкщо у вас виникнуть запитання, напишіть мені.<br>\n<br>\n{$principalContactSignature}<br>\n', 'Цей шаблон листа використовується для запита доступу у авторів до запису ORCID.'),
('ORCID_REQUEST_AUTHOR_AUTHORIZATION', 'vi_VN', 'Yêu cầu truy cập bản ghi ORCID', 'Kính gửi {$authorName},<br>\n<br>\nBạn đã được liệt kê như là một tác giả của bản thảo "{$submissionTitle}" to {$contextName}.\n<br>\n<br>\nVui lòng cho phép chúng tôi thêm id ORCID của bạn vào bài đăng này và cũng để thêm bài đăng vào hồ sơ ORCID của bạn trên xuất bản.<br>\nTruy cập liên kết đến trang web ORCID chính thức, đăng nhập với hồ sơ của bạn và cho phép truy cập bằng cách làm theo các hướng dẫn.<br>\n<a href="{$authorOrcidUrl}"><img id="orcid-id-logo" src="https://orcid.org/sites/default/files/images/orcid_16x16.png" width=''16'' height=''16'' alt="ORCID iD icon" style="display: block; margin: 0 .5em 0 0; padding: 0; float: left;"/>Đăng ký hoặc kết nối ORCID iD của bạn</a><br/>\n<br>\n<br>\n<a href="{$orcidAboutUrl}">Tìm hiểu thêm về ORCID tại {$contextName}</a><br/>\n<br>\nNếu bạn có bất kỳ câu hỏi, xin vui lòng liên hệ với tôi.<br>\n<br>\n{$principalContactSignature}<br>\n', 'Mẫu email này được sử dụng để yêu cầu quyền truy cập bản ghi ORCID từ các tác giả.'),
('PASSWORD_RESET_CONFIRM', 'ar_IQ', 'تأكيد إعادة تعيين كلمة المرور', 'لقد تلقينا طلباً لإعادة تعيين كلمة مرورك في الموقع {$siteTitle}.<br />\n<br />\nإن لم تكن أنت شخصياً من أرسل هذا الطلب، لطفاً تجاهل هذه الرسالة لتحتفظ بكلمة مرورك إلى الموقع دون تغيير. لو أردت إعادة تعيين كلمة مرورك، أنقر الرابط أدناه.<br />\n<br />\nأعد تعيين كلمة مروري: {$url}<br />\n<br />\n{$principalContactSignature}', 'هذه الرسالة معنونة إلى المستخدمين المسجلين الذي أبلغوا عن فقدانهم لكلمات مرورهم إلى الموقع، أو الذين تعذر عليهم الولوج لأي سبب آخر. سيحصل هؤلاء على رابط يمكنهم عند النقر عليه إعادة تعيين كلمات مرورهم.'),
('PASSWORD_RESET_CONFIRM', 'bs_BA', 'Potvrda o promjeni lozinke', 'Zaprimili smo vaš zahtjev za promjenu lozinke za mrežnu stranicu {$siteTitle}.<br />\n<br />\nU slučaju da takav zahtjev niste poslali, molimo vas da ignorirate ovu e-poštu i vaša će lozinka ostati nepromijenjena. U slučaju da želite promijeniti lozinku, molimo vas da kliknete na dolje priloženu poveznicu.<br />\n<br />\nPromjena lozinke: {$url}<br />\n<br />\n{$principalContactSignature}', 'Ovaj obrazac e-pošte šalje se registriranim korisnicima kada informiraju sustav da su zaboravili svoju lozinku ili da se ne mogu prijaviti u sustav. U poruci se nalazi URL koji mogu slijediti kao bi postavili svoju novu lozinku.');
INSERT INTO `email_templates_default_data` VALUES
('PASSWORD_RESET_CONFIRM', 'ca_ES', 'Confirmació per a la reinicialització de la contrasenya', 'Hem rebut una sol·licitud per a reinicialitzar la vostra contrasenya per al lloc web {$siteTitle}.<br />\n<br />\nSi no sou l''autor d''aquesta sol·licitud, ignoreu aquest missatge de correu electrònic i no es canviarà la vostra contrasenya. Si voleu reinicialitzar la contrasenya, feu clic a l''URL següent.<br />\n<br />\nReinicialització de la meva contrasenya: {$url}<br />\n<br />\n{$principalContactSignature}', 'Aquest missatge de correu electrònic s''envia a un usuari registrat si ha indicat que no recorda la seva contrasenya o que no pot iniciar la sessió. Inclou un URL per a la reinicialització de la contrasenya.'),
('PASSWORD_RESET_CONFIRM', 'cs_CZ', 'Potvrzení o resetování hesla', 'Obdrželi jsme žádost o resetování Vašeho hesla pro stránku {$siteTitle}.<br />\n<br />\nPokud jste tuto žádost neodeslal, ignorujte prosím tento email a Vaše heslo nebude změněno. Pokud chcete své heslo resetovat, klikněte na URL adresu níže.<br />\n<br />\nResetovat moje heslo: {$url}<br />\n<br />\n{$principalContactSignature}', 'Tento email je zasílán registrovanému uživateli, když uvede, že zapomněl své heslo nebo se nemůže přihlásit. Obsahuje adresu URL, kterou může následovat a resetovat své heslo.'),
('PASSWORD_RESET_CONFIRM', 'da_DK', 'Bekræftelse af nulstilling af adgangskode', 'Vi har modtaget en forespørgsel om at nulstille din adgangskode til webstedet {$siteTitle}.<br />\n<br />\nHvis du ikke selv har sendt denne forespørgsel, skal du ignorere denne e-mail, og din adgangskode vil ikke blive ændret. Klik på nedenstående URL-adresse, hvis adgangskoden skal ændres.<br />\n<br />\nNulstil min adgangskode: {$url}<br />\n<br />\n{$principalContactSignature}', 'Denne e-mail sendes til registrerede brugere, når de angiver, at de har glemt deres adgangskode eller ikke kan logge på. Den indeholder en URL-adresse, de kan følge for at nulstille deres adgangskode.'),
('PASSWORD_RESET_CONFIRM', 'de_DE', 'Reset-Bestätigung für Ihr Passwort', 'Wir wurden aufgefordert, Ihr Passwort für die Webseite {$siteTitle} neu zu setzen.<br />\n<br />\nFalls die Aufforderung nicht von Ihnen stammt, ignorieren Sie bitte diese E-Mail, und Ihr Passwort bleibt unverändert. Falls Sie Ihr Passwort neu setzen möchten, klicken Sie bitte auf die folgende URL:<br />\n<br />\nMein Passwort neu setzen: {$url}<br />\n<br />\n{$principalContactSignature}', 'Diese E-Mail wird an registrierte Benutzer/innen der Benachrichtigungs-Mailingliste gesendet, die angegeben haben, dass sie ihr Passwort vergessen haben oder sich nicht einloggen können. Sie liefert eine URL, der die Benutzer/innen folgen können, um ihr Passwort zurückzusetzen.'),
('PASSWORD_RESET_CONFIRM', 'el_GR', 'Επιβεβαίωση αλλαγής κωδικού πρόσβασης', 'Έχουμε λάβει ένα αίτημα για αλλαγή του κωδικού πρόσβασής σας για τον ιστότοπο {$siteTitle}.<br />\n<br />\nΕάν δεν κάνατε εσείς το εν λόγω αίτημα, παρακαλούμε αγνοήστε το μήνυμα αυτό και ο κωδικός πρόσβασής σας δε θα αλλάξει. Εάν επιθυμείτε να αλλάξετε τον κωδικό πρόσβασής σας, ακολουθήστε τον παρακάτω σύνδεσμο.<br />\n<br />\nΑλλαγή του κωδικού πρόσβασής μου: {$url}<br />\n<br />\n{$principalContactSignature}', 'Το παρόν μήνυμα αποστέλλεται στους εγγεγραμμένους Χρήστες που δηλώνουν ότι έχουν ξεχάσει τον κωδικό πρόσβασής τους ή αδυνατούν να συνδεθούν. Παρέχει έναν σύνδεσμο όπου μπορούν να αλλάξουν τον κωδικό πρόσβασής τους.'),
('PASSWORD_RESET_CONFIRM', 'en_US', 'Password Reset Confirmation', 'We have received a request to reset your password for the {$siteTitle} web site.<br />\n<br />\nIf you did not make this request, please ignore this email and your password will not be changed. If you wish to reset your password, click on the below URL.<br />\n<br />\nReset my password: {$url}<br />\n<br />\n{$principalContactSignature}', 'This email is sent to a registered user when they indicate that they have forgotten their password or are unable to login. It provides a URL they can follow to reset their password.'),
('PASSWORD_RESET_CONFIRM', 'es_ES', 'Confirmación de cambio de contraseña', 'Hemos recibido una petición para cambiar su contraseña en {$siteTitle}.<br />\n<br />\nSi no hizo usted esta petición ignore este correo-e y su contraseña no cambiará. Si desea cambiar su contraseña pinche en el enlace que le mostramos a continuación.<br />\n<br />\nCambiar mi contraseña: {$url}<br />\n<br />\n{$principalContactSignature}', 'Este correo se envía a un/a usuario/a registrado/a cuando indican que han olvidado su contraseña o que no se pueden identificar. Proporciona una URL para que cambien su contraseña.'),
('PASSWORD_RESET_CONFIRM', 'eu_ES', 'Pasahitza berrezartzeko berrespena', '{$siteTitle} webgunean sartzeko daukazun pasahitza berrezartzeko eskaera jaso dugu.<br />\n<br />\nEskaera ez bada zuk egindakoa, ez jaramonik egin mezu honi, eta zure pasahitza ez da aldatuko. Pasahitza berrezartzea nahi baduzu, egin klik beheko URLan.<br />\n<br />\nBerrezarri nire pasahitza: {$url}<br />\n<br />\n{$principalContactSignature}', 'Pasahitza ahaztu duten erabiltzaile erregistratuei edo webgunean sartu ezinda dabiltzanei bidaltzen zaie mezu hau. Pasahitza berrezartzeko URL bat ematen du.'),
('PASSWORD_RESET_CONFIRM', 'fa_IR', 'تائیدیه دوباره تنظیم کردن رمزعبور', 'درخواستی مبنی بر تنظیم دوباره رمزعبور شما مربوط به وب سایت &amp;lt;$siteTitle&amp;gt; به ما رسیده است.<br />\n<br />\nلطفا چنانچه شما این درخواست را نفرستاده اید، به این ایمیل توجهی نکنید، در این صورت رمز عبور شما تغییری نخواهد کرد. اگر مایل به تنظیم دوباره رمزعبور خود هستید، برروی پیوند زیر کلیک نمائید.<br />\n<br />\nتنظیم مجدد رمز عبور: {$url}<br />\n<br />\n{$principalContactSignature}', 'This email is sent to a registered user when they indicate that they have forgotten their password or are unable to login. It provides a URL they can follow to reset their password.'),
('PASSWORD_RESET_CONFIRM', 'fi_FI', 'Vahvista salasanan vaihtaminen', 'Olemme vastaanottaneet pyynnön vaihtaa salasananne sivustolle {$siteTitle}.<br />\n<br />\nJos ette tehnyt tätä pyyntöä, voitte jättää tämän sähköpostin huomiotta. Jos haluatte vaihtaa salasanan, klikatkaa alla olevaa linkkiä.<br />\n<br />\nVaihda salasana: {$url}<br />\n<br />\n{$principalContactSignature}', 'Tämä sähköpostiviesti lähetetään rekisteröityneelle käyttäjälle, joka ilmoittaa unohtaneensa salasanansa tai joka ei pysty kirjautumaan. Viesti sisältää ULR:n, jonka kautta salasana voidaan vaihtaa.'),
('PASSWORD_RESET_CONFIRM', 'fr_CA', 'Confirmation de la réinitialisation du mot de passe', 'Nous avons reçu une demande concernant la réinitialisation de votre mot de passe pour le site Web {$siteTitle}.<br />\n<br />\nSi vous n''avez pas fait cette demande, veuillez ne pas tenir compte du présent message, votre mot de passe restera le même. Si vous souhaitez réinitialiser votre mot de passe, cliquer sur l''URL ci-dessous.<br />\n<br />\nRéinitialisation de mon mot de passe : {$url}<br />\n<br />\n{$principalContactSignature}', 'Ce courriel est envoyé à l''utilisateur-trice inscrit-e qui nous signale avoir oublié son mot de passe ou qui est incapable d''ouvrir une session. Il fournit le lien URL à cliquer pour pouvoir réinitialiser son mot de passe.'),
('PASSWORD_RESET_CONFIRM', 'fr_FR', 'Confirmation de la réinitialisation du mot de passe', 'Nous avons reçu une demande concernant la réinitialisation de votre mot de passe pour le site Web {$siteTitle}.<br />\n<br />\nSi vous n''avez pas fait cette demande, veuillez ne pas tenir compte du présent message, votre mot de passe restera le même. Si vous voulez réinitialiser votre mot de passe, cliquer sur l''URL et un nouveau mot de passe vous sera envoyé par courriel sous peu.<br />\n<br />\nRéinitialisation du mot de passe : {$url}<br />\n<br />\n{$principalContactSignature}', 'Ce courriel est envoyé aux utilisateurs qui nous signalent avoir oublié leur mot de passe ou qui sont incapables d''ouvrir une session. Il fournit le lien URL pour réinitialiser leur mot de passe.'),
('PASSWORD_RESET_CONFIRM', 'gd_GB', 'Dearbhadh ath-shuidheachadh an fhacail-fhaire', 'Fhuair sinn iarrtas am facal-faire agad airson na làraich-lìn {$siteTitle} ath-shuidheachadh.<br />\n<br />\nMur an do dh’iarr thusa seo, leig seachad am post-d agus agus cha tèid am facal-faire agad atharrachadh. Ma tha thu airson am facal-faire agad ath-shuidheachadh, briog air an URL gu h-ìosal.<br />\n<br />\nAth-shuidhich am facal-faire agam: {$url}<br />\n<br />\n{$principalContactSignature}', 'Thèid am post-d seo a chur gu cleachdaiche clàraichte nuair a bhios iad air innse gun do dhìochuimhnich iad am facal-faire aca no nach urrainn dhaibh clàradh a-steach. Tha e a’ toirt URL dhaibh far an urrainn dhaibh am facal-faire aca ath-shuidheachadh.'),
('PASSWORD_RESET_CONFIRM', 'he_IL', 'אישור איפוס סיסמה', 'קיבלנו בקשתך לשנות סיסמה לאתר  {siteTitle$} \n<br />\n<br />\nאם לא הגשת בקשה זו, אנא התעלם מאימייל זה והסיסמה שלך לא תשתנה. אם ברצונך לאפס את הסיסמה שלך, לחץ על כתובת האתר הבאה.<br />\n<br />\nאיפוס סיסמה: {url$}\n<br />\n{principalContactSignature$}', 'דוא"ל זה נשלח למשתמש רשום כאשר הוא מציין ששכח את סיסמתו או שאינו יכול להתחבר. היא מספקת כתובת URL כדי לאפס את הסיסמה שלהם.'),
('PASSWORD_RESET_CONFIRM', 'hi_IN', 'पासवर्ड रीसेट पुष्टि', 'हमें {$ siteTitle} वेब साइट के लिए आपका पासवर्ड रीसेट करने का अनुरोध मिला है.<br />\n<br />\nयदि आपने यह अनुरोध नहीं किया है, तो कृपया इस ईमेल को अनदेखा करें और आपका पासवर्ड परिवर्तित नहीं किया जाएगा। यदि आप अपना पासवर्ड रीसेट करना चाहते हैं, तो नीचे दिए गए URL पर क्लिक करें.<br />\n<br />\nReset my password: {$url}<br />\n<br />\n{$principalContactSignature}', 'यह ईमेल एक पंजीकृत उपयोगकर्ता को भेजा जाता है जब वे इंगित करते हैं कि वे अपना पासवर्ड भूल गए हैं या लॉगिन करने में असमर्थ हैं। यह एक URL प्रदान करता है जिसका वे अपना पासवर्ड रीसेट करने के लिए अनुसरण कर सकते हैं.'),
('PASSWORD_RESET_CONFIRM', 'hr_HR', 'Potvrda o promjeni lozinke', 'Zaprimili smo vaš zahtjev za promjenu lozinke za mrežnu stranicu {$siteTitle}.<br />\n<br />\nU slučaju da takav zahtjev niste poslali, molimo vas da ignorirate ovu e-poštu i vaša će lozinka ostati nepromijenjena. U slučaju da želite promijeniti lozinku, molimo vas da kliknete na dolje priloženu poveznicu.<br />\n<br />\nPromjena lozinke: {$url}<br />\n<br />\n{$principalContactSignature}', 'Ovaj obrazac e-pošte šalje se registriranim korisnicima kada informiraju sustav da su zaboravili svoju lozinku ili da se ne mogu prijaviti u sustav. U poruci se nalazi URL koji mogu slijediti kao bi postavili svoju novu lozinku.'),
('PASSWORD_RESET_CONFIRM', 'hu_HU', 'Jelszó visszaállítás megerősítése', 'Megkaptuk jelszavának visszaállítási kérését a(z) {$siteTitle} oldalhoz.<br />\n<br />\nAmennyiben nem Ön kezdeményezte, úgy hagyja figyelmen kívül értesítő levelünket és jelszava nem módosul. Ha szeretné visszaállítani jelszavát, kattintson az alábbi linkre.<br />\n<br />\nJelszavam visszaállítása: {$url}<br />\n<br />\n{$principalContactSignature}', 'Ez a levél egy regisztrált felhasználónak kerül kiküldésre, amikor jelzi, hogy elfelejtette a jelszavát, és nem tud bejelentkezni. Tartalmaz egy linket, amire kattintva visszaállítható a jelszava.'),
('PASSWORD_RESET_CONFIRM', 'id_ID', 'Konfirmasi Reset Sandi', 'Kami menerima permintaan reset sandi untuk akun Anda di website {$siteTitle}.<br />\n<br />\nJika Anda tidak merasa mengajukan permintaan ini, abaikan pesan ini dan sandi Anda tidak akan diubah.  Jika Anda memang ingin melakukan reset sandi, klik tautan berikut ini.<br />\n<br />\nReset sandi saya: {$url}<br />\n<br />\n{$principalContactSignature}', 'Email ini dikirimkan ke pengguna terdaftar ketika lupa sandi atau tidak dapat login. Email ini memberikan URL untuk melakukan reset sandi.'),
('PASSWORD_RESET_CONFIRM', 'it_IT', 'Conferma di modifica password', 'Abbiamo ricevuto la richiesta di modificare la tua password per {$siteTitle}.<br />\n<br />\nSe non hai fatto questa richiesta, ignora questo messaggio e la password non sarà modificata.<br />\nSe invece hai fatto tu la richiesta e desideri generare una nuova password, clicca sul link qui sotto.<br />\n<br />\nReset password: {$url}<br />\n<br />\n{$principalContactSignature}', 'Questa email viene mandata ad un utente registrato quando questi indica che ha dimenticato la sua password o non riesce a fare il log in. Fornisce una URL per il reset della password.'),
('PASSWORD_RESET_CONFIRM', 'ja_JP', 'パスワードリセットの確認', '{$siteTitle}のWebサイトにログインするパスワードのリセット依頼を受け取りました。<br />\n<br />\nリセット依頼をした覚えがない場合は、申し訳ありませんが、このメールを無理し、パスワードは変更しないでください。パスワードのリセットを希望される場合は、下のURLをクリックしてください。<br />\n<br />\nパスワードのリセット: {$url}<br />\n<br />\nよろしくお願いいたします。<br />\n<br />\n{$principalContactSignature}', 'このメールは、登録ユーザーからパスワードを忘れた、または、ログインできない旨の連絡を受けた場合に、登録ユーザーに送信されるものです。このメールではパスワードをリセットするためのURLを提供します。'),
('PASSWORD_RESET_CONFIRM', 'ku_IQ', 'دڵنیابوونەوەی لە دانانەوەی وشەى نهێنى', '{$siteTitle} داواكاريتان بۆ گۆڕينى وشەى نهێنيمان  پێگەيشت.<br />\n<br />\nئەگەر ئەم داواكارييە بەبێ ئاگادارى ئێوە نێردراوە، ئەم پەيامە بە هەند وەرمەگرن؛ دەتوانن وشە نهێنييە كۆنەكەتان بەكار بهێنن. ئەگەر دەتانەوێت تێپەڕەوشەتان بگۆڕن تكايە كرتە لەسەر بەستەرەكەى خوارەوە بكەن.\n<br />\n<br />\nبۆ گۆڕينى وشەى نهێنى: {$url}<br />\n<br />\n{$principalContactSignature}', 'ئەم ئيمەيلە، بۆ ئاگاداركردنەوەى ئەو بەكارهێنەرە تۆماركراوە دەنێردرێت كە وشەى نهێنييان \nبيرچووە  و/يان نەيانتوانيوە بێنە ناو سستەمەوە. بۆ سفركردنەوەى وشەى نهێنيتان بەدواى بەستەرە بكەوە كە لەم ئيمەيلەدايە.'),
('PASSWORD_RESET_CONFIRM', 'mk_MK', 'Потврда за ресетирање на лозинката', 'Добивме барање за ресетирање на вашата лозинка за {$siteTitle} веб-страницата.<br />\n<br />\nДоколку вие не го направивте ова барање, ве молиме да го игнорирате овој и-меил и вашата лозинка ќе остане непроменета. Доколку сакате да ја ресетирате вашата лозинка, притиснете на URL-адресата подолу.<br />\n<br />\nРесетирај ја мојата лозинка: {$url}<br />\n<br />\n{$principalContactSignature}', 'Овој и-меил е испратен до регистрираните корисници кои посочиле дека ја заборавиле нивната лозинка и не можат да се најават. Им обезбедува URL-адреса на која можат да ја ресетираат својата лозинка.'),
('PASSWORD_RESET_CONFIRM', 'nb_NO', 'Bekreftelse på fornying av passord', 'Vi har mottatt en forespørsel om å tilbakestille passordet ditt til nettstedet {$siteTitle}.<br />\n<br />\nHvis du ikke har sendt oss en slik forespørsel og ikke vil endre passordet ditt, kan du ignorere denne e-posten. Hvis du ønsker nytt passord, klikk på lenken nedenfor.<br />\n<br />\nForny passordet: {$url}<br />\n<br />\n{$principalContactSignature}', 'Denne e-posten sendes til registrerte brukere når de melder fra om at de har glemt passordet sitt, eller at de ikke klarer å logge inn. Den gir en URL-lenke brukeren kan følge for å fornye passordet sitt.'),
('PASSWORD_RESET_CONFIRM', 'nl_NL', 'Bevestiging wachtwoord herstellen', 'We hebben een verzoek van u ontvangen om uw wachtwoord voor de website {$siteTitle} te herstellen.<br />\n<br />\nAls u dat verzoek niet gedaan hebt, negeer dan deze e-mail en uw wachtwoord wordt niet veranderd. Als u uw wachtwoord wilt herstellen , klik dan op de url hieronder.<br />\n<br />\nHerstel mijn wachtwoord: {$url}<br />\n<br />\n{$principalContactSignature}', 'Deze e-mail wordt gestuurd naar een geregistreerde gebruiker die heeft aangegeven zijn wachtwoord vergeten te zijn of niet in te kunnen loggen. Het bevat een URL die ze kunnen volgen om hun wachtwoord te herstellen.'),
('PASSWORD_RESET_CONFIRM', 'pl_PL', 'Potwierdzenie resetowania hasła', 'Otrzymaliśmy prośbę o zresetowanie Twojego hasła na stronie {$siteTitle} <br />\n<br />\nJeśli nie wysyłałeś takiej prośby, prosimy, zignoruj tę wiadomość i Twoje hasło nie zostanie zmienione. Jeśli chcesz zresetować hasło, kliknij w poniższy URL.\n<br />\n<br />\nZresetuj hasło: {$url}<br />\n<br />\n{$principalContactSignature}', 'Wiadomość jest przesyłana do zarejestrowanych użytkowników w celu potwierdzenia zresetowania hasła. Załączony jest link do strony resetowania hasła.'),
('PASSWORD_RESET_CONFIRM', 'pt_BR', 'Confirmação de Redefinição de Senha', 'Recebemos uma solicitação para redefinir sua senha para o site {$siteTitle}.<br />\n<br />\nSe você não fez essa solicitação, favor ignorar este e-mail e sua senha não será alterada. Se você deseja redefinir sua senha, clique na URL abaixo.<br />\n<br />\nRedefinir minha senha: {$url}<br />\n<br />\n{$principalContactSignature}', 'Esta mensagem é enviada a um usuário cadastrado quando o mesmo indica que tenha esquecido sua senha ou não consiga efetuar login. Um link é fornecido que permite ao usuário redefinir sua senha.'),
('PASSWORD_RESET_CONFIRM', 'pt_PT', 'Confirmar atualização de senha', 'Recebemos um pedido para atualizar a sua senha de acesso à revista {$siteTitle}.<br />\n<br />\nCaso não tenha feito este pedido, ignore este e-mail e a sua senha não será alterada. Se deseja atualizar a sua senha, clique no seguinte link.<br/>\n<br />\nAtualizar senha: {$url}<br />\n<br />\n{$principalContactSignature}', 'Este e-mail é enviado ao utilizador registado quando o mesmo solicita a atualização da senha, quando esqueceu a senha ou encontra problemas para aceder à revista. O link fornecido permite ao utilizador concluir a atualização da senha.'),
('PASSWORD_RESET_CONFIRM', 'ro_RO', 'Confirmare resetare parolă', 'Am primit o solicitare de resetare a parolei pentru {$siteTitle} web site.<br />\n<br />\nDacă nu ați făcut această solicitare, ignorați acest e-mail și parola dvs. nu va fi modificată. Dacă doriți să vă resetați parola, faceți clic pe adresa URL de mai jos.<br />\n<br />\nResetează parola: {$url}<br />\n<br />\n{$principalContactSignature}', 'Acest e-mail este trimis unui utilizator înregistrat atunci când indică faptul că și-a uitat parola sau nu se poate autentifica. Oferă o adresă URL pe care o poate urma pentru a-și reseta parola.'),
('PASSWORD_RESET_CONFIRM', 'ru_RU', 'Подтверждение сброса пароля', 'Мы получили запрос на сброс Вашего пароля на сайте «{$siteTitle}».<br />\n<br />\nЕсли Вы не отправляли этот запрос, пожалуйста, проигнорируйте это письмо и Ваш пароль не будет изменен. Если Вы хотите сбросить свой пароль, то щелкните по ссылке ниже.<br />\n<br />\nСбросить мой пароль: {$url}<br />\n<br />\n{$principalContactSignature}', 'Это письмо отправляется зарегистрированному пользователю, когда он сообщает, что забыл пароль или не может войти на сайт. В письме содержится ссылка (URL), перейдя по которой пользователь сможет сбросить свой пароль.'),
('PASSWORD_RESET_CONFIRM', 'sk_SK', 'Potvrdenie o resetovaní hesla', 'Dostali sme žiadosť o resetovanie Vášho hesla pre stránku {$siteTitle}.<br />\n<br />\nAk ste túto žiadosť neodoslali, ignorujte prosím tento email a Vaše heslo nebude zmenené. Ak chcete svoje heslo resetovať, kliknite na URL adresu nižšie.<br />\n<br />\nResetovať moje heslo: {$url}<br />\n<br />\n{$principalContactSignature}', 'Tento email je odoslaný zaregistrovanému používateľovi, keď uvedie, že zabudol svoje heslo alebo sa nemôže prihlásiť. Obsahuje adresu URL, ktorú môže navštíviť a obnoviť si svoje heslo.'),
('PASSWORD_RESET_CONFIRM', 'sl_SI', 'Potrditev ponastavitve gesla', 'Oddano je bila zahteva za ponastavitev gesla za {$siteTitle}.<br />\n<br />\nČe zahteve niste oddali, prosimo ignoriranje email in geslo bo ostlao nespremenjeno. Če želite ponastaviti geslo, kliknite na spodnjo povezavo.<br />\n<br />\nPonastavi moje geslo: {$url}<br />\n<br />\n{$principalContactSignature}', 'Email se pošlje uporabniku, ko pozabi geslo za prijavo in odda zahtevo za ponastavitev gesla. V emailu se nahaja povezava, ki jo mora uporabnik klikniti za ponastavitev gesla.'),
('PASSWORD_RESET_CONFIRM', 'sv_SE', 'Bekräfta återställning av lösenord', 'Vi har mottagit en begäran om att återställa ditt lösenord för webbplatsen {$siteTitle}.<br />\n<br />\nOm det inte var du som skickade begäran, vänligen bortse från det här e-postmeddelandet så kommer ditt lösenord fortsätta vara samma som förut. Om du vill återställa ditt lösenord, klicka på URL:en nedan.<br />\n<br />\nÅterställ mitt lösenord: {$url}<br />\n<br />\n{$principalContactSignature}', 'Det här meddelandet skickas till registrerade användare som meddelar att de har glömt sitt lösenord eller inte kan logga in. E-postmeddelandet innehåller en URL som leder till återställning av lösenordet.'),
('PASSWORD_RESET_CONFIRM', 'tr_TR', 'Şifre Değiştirme Onayı', '{$siteTitle} sitesindeki şifrenizi değiştirme talebinizi aldık.<br />\n<br />\nBu istek sizin dışınızda oluştu ise, lütfen bu mesajı dikkate almayınız; eski şifrenizi kullanabilirsiniz. Eğer şifrenizi değiştirmek istiyorsanız aşağıdaki bağlantıyı tıklayınız.\n<br />\n<br />\nŞifre değiştirmek için: {$url}<br />\n<br />\n{$principalContactSignature}', 'Bu e-posta, şifrelerini unuttuğunu  ve/veya giriş yapamadıklarını bildiren kayıtlı kullanıcılara gönderilmektedir. Şifrelerini sıfırlamak için izleyebilecekleri bir URL bağlantısı içerir.'),
('PASSWORD_RESET_CONFIRM', 'uk_UA', 'Підтвердження скидання пароля', 'Ми отримали запит на скидання Вашого пароля для веб-сайту {$siteTitle}.<br />\n<br />\nЯкщо Ви не робили цього запиту, будь ласка, проігноруйте цей лист і Ваш пароль не буде змінений. Якщо Ви бажаєте скинути свій пароль, натисніть на посиланні нижче.<br />\n<br />\nСкинути мій пароль: {$url}<br />\n<br />\n{$principalContactSignature}', 'Цей лист надсилається зареєстрованому користувачу, який вказав, що забув свій пароль і не може увійти до системи. У листі міститься URL, натиснувши на який користувач може скинути свій пароль.'),
('PASSWORD_RESET_CONFIRM', 'vi_VN', 'Xác nhận đặt lại mật khẩu', 'Chúng tôi đã nhận được yêu cầu đặt lại mật khẩu của bạn cho {$siteTitle}.<br />\n<br />\nNếu bạn không thực hiện yêu cầu này, vui lòng bỏ qua email này và mật khẩu của bạn sẽ không bị thay đổi. Nếu bạn muốn đặt lại mật khẩu của mình, nhấp vào URL bên dưới.<br />\n<br />\nĐặt lại mật khẩu của tôi: {$url}<br />\n<br />\n{$principalContactSignature}', 'Email này được gửi đến người dùng đã đăng ký khi họ cho biết rằng họ đã quên mật khẩu hoặc không thể đăng nhập. Nó cung cấp một URL mà họ có thể theo dõi để đặt lại mật khẩu của họ.'),
('PASSWORD_RESET_CONFIRM', 'zh_CN', '密码重置确认', '我们收到您的请求，将重新设定您在{$siteTitle}网站的密码。<br />\n<br />\n如果您没有提出这个请求，请忽略这封电子邮件，同时您的密码将会保持不变。如果您希望要重置您的密码，请按下面的链接。<br />\n<br />\n重置我的密码： {$url}<br />\n<br />\n{$principalContactSignature}', '当注册用户忘记他们的密码或者无法登入的时候，这封电子邮件会寄给他们。信中会提供一个网址让它们能够登入并重置他们的密码。'),
('PAYPAL_INVESTIGATE_PAYMENT', 'ar_IQ', 'نشاط غير عادي من PayPal', 'نظام المجلات المفتوحة قد تعرض إلى نشاط غير عادي يتعلق بآلية دعم المدفوعات عبر PayPal يخص المجلة {$contextName}. هذا النشاط قد يستدعي المزيد من التحقيق بشأنه ولو يدوياً.<br />\n                       <br />\nهذه الرسالة أنشأتها إضافة PayPal لنظام المجلات المفتوحة.<br />\n<br />\nمعلومات الطرح الكامل للطلب:<br />\n{$postInfo}<br />\n<br />\nمعلومات إضافية (لو توفرت):<br />\n{$additionalInfo}<br />\n<br />\nمتغيرات الملقم:<br />\n{$serverVars}<br />\n', 'قالب الرسالة الالكترونية هذا يستعمل لإشعار عنوان الاتصال الرئيسي في المجلة بحدوث نشاط مريب من قبل إضافة PayPal مما قد يستدعي الالتفات إليه أو التحقيق بشأنه.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'ca_ES', 'Activitat inusual de PayPal', 'Open Journal Systems ha detectat una activitat inusual en relació amb el suport de pagament per PayPal de la revista {$contextName}. Aquesta activitat podria requerir una investigació més detallada o una intervenció manual.<br />\n                       <br />\nAquest correu electrònic ha estat generat pel mòdul de PayPal d''Open Journal Systems.<br />\n<br />\nInformació d''enviament completa per a la sol·licitud:<br />\n{$postInfo}<br />\n<br />\nInformació addicional (si es subministra):<br />\n{$additionalInfo}<br />\n<br />\nVariables de servidor:<br />\n{$serverVars}<br />\n', 'Aquesta plantilla de correu electrònic s''utilitza per notificar el contacte principal de la revista que el mòdul de Paypal ha detectat una activitat sospitosa o una activitat que requereix una intervenció manual.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'cs_CZ', 'Neobvyklá PayPal aktivita', 'OJS zaznamenal neobvyklou aktivitu v souvislosti s podporou plateb přes PayPal pro časopis {$contextName}. Tato aktivita může vyžadovat další kontrolu nebo ruční zásah.<br />\n                       <br />\nTento email byl vygenerován OJS pluginem pro PayPal.<br />\n<br />\nKompletní informace k požadavku:<br />\n{$postInfo}<br />\n<br />\nDoplňkové informace (pokud byly uvedeny):<br />\n{$additionalInfo}<br />\n<br />\nProměnné serveru:<br />\n{$serverVars}<br />\n', 'Tato e-mailová šablona slouží k upozornění primárního kontaktu časopisu, že se zásuvný modul PayPal setkal s podezřelou aktivitou nebo činností vyžadující ruční zásah.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'da_DK', 'Usædvanlig PayPal-aktivitet', 'Open Journal Systems er stødt på en usædvanlig aktivitet i forbindelse med PayPal-betalingsunderstøttelsen til tidsskriftet {$contextName}. Denne aktivitet kan kræve yderligere undersøgelse eller manuel indgriben.<br />\n                       <br />\nDenne e-mail blev genereret af Open Journal Systems ''PayPal-plug-in<br />\n<br />\nUdførlig information:<br />\n{$postInfo}<br />\n<br />\nYderligere information (hvis leveret):<br />\n{$additionalInfo}<br />\n<br />\nServer vars:<br />\n{$serverVars}<br />\n', 'Denne e-mail-skabelon bruges til at underrette et tidsskrifts primære kontaktperson om, at mistænkelig aktivitet eller aktivitet, der kræver manuel indblanding, tilstødte PayPal-plug-in''en.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'de_DE', 'Ungewöhnliche PayPal-Aktivität', 'Open Journal Systems hat eine ungewöhnliche Aktivität in Bezug auf die Unterstützung  von PayPal-Zahlungen für die Zeitschrift {$contextName} festgestellt. Diese Aktivität könnte eine nähere Untersuchung oder ein Eingreifen erfordern.<br />\n<br />\nDiese E-Mail wurde durch das Open Journal Systems-Plugin PayPal-Gebührenzahlung erzeugt.<br />\n<br />\nVolle Informationen zu dieser Anfrage:<br />\n{$postInfo}<br />\n<br />\nZusätzliche Informationen (soweit angegeben):<br />\n{$additionalInfo}<br />\n<br />\nServer vars:<br />\n{$serverVars}<br />\n', 'Diese E-Mail-Vorlage wird genutzt, um den primären Zeitschriftenkontakt darüber zu benachrichtigen, dass verdächtige Aktivitäten durch das PayPal-PlugIn entdeckt worden sind.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'el_GR', 'Ασυνήθιστη δραστηριότητα PayPal', 'Η Open Journal Systems αντιμετώπισε ασυνήθιστη δραστηριότητα που σχετίζεται με την υποστήριξη πληρωμών PayPal για το περιοδικό {$contextName}. Αυτή η δραστηριότητα μπορεί να χρειαστεί περαιτέρω διερεύνηση ή χειρωνακτική παρέμβαση.<br />\n<br />\nΑυτό το μήνυμα ηλεκτρονικού ταχυδρομείου δημιουργήθηκε από την προσθήκη PayPal της Open Journal Systems.<br />\n<br />\n Πλήρεις πληροφορίες ανάρτησης για το αίτημα:<br />\n{$postInfo}<br />\n<br />\n Πρόσθετες πληροφορίες (εφόσον παρέχονται):<br />\n{$additionalInfo}<br />\n<br />\nServer vars:<br />\n{$serverVars}<br />\n', 'Αυτό το πρότυπο ηλεκτρονικού ταχυδρομείου χρησιμοποιείται για να ειδοποιήσει την κύρια επαφή ενός περιοδικού ότι η προσθήκη PayPal αντιμετώπισε ύποπτη δραστηριότητα ή δραστηριότητα που απαιτεί μη αυτόματη παρέμβαση.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'en_US', 'Unusual PayPal Activity', 'Open Journal Systems has encountered unusual activity relating to PayPal payment support for the journal {$contextName}. This activity may need further investigation or manual intervention.<br />\n                       <br />\nThis email was generated by Open Journal Systems'' PayPal plugin.<br />\n<br />\nFull post information for the request:<br />\n{$postInfo}<br />\n<br />\nAdditional information (if supplied):<br />\n{$additionalInfo}<br />\n<br />\nServer vars:<br />\n{$serverVars}<br />\n', 'This email template is used to notify a journal''s primary contact that suspicious activity or activity requiring manual intervention was encountered by the PayPal plugin.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'es_ES', 'Actividad inusual de PayPal', 'Open Journal Systems ha detectado una actividad inusual relacionada con el soporte de pago por PayPal de la revista {$contextName}. Esta actividad podría requerir una investigación más detallada o una intervención manual<br />\n                       <br />\nEste correo electrónico ha sido generado por el módulo de PayPal de Open Journal Systems.<br />\n<br />\nInformación completa de envío para la solicitud:<br />\n{$postInfo}<br />\n<br />\nInformación adicional (si se proporciona):<br />\n{$additionalInfo}<br />\n<br />\nVariables de servidor:<br />\n{$serverVars}<br />\n', 'Esta plantilla de correo es usada para notificar al contacto principal de la revista de que el plugin de PayPal ha detectado actividad sospechosa o actividad que requiere de intervención manual.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'eu_ES', 'Ezohiko PayPal jarduera', 'Open Journal Systems-ek ezohiko jarduera sumatu du {$contextName} aldizkariaren PayPal ordainketa-zerbitzuan. Jarduera hori gehiago ikertu beharko da edo eskuz parte hartu beharko da.<br />\n                       <br />\nMezu hau Open Journal Systems-en PayPal pluginak sortu du.<br />\n<br />\nEskaeraren informazio osoa:<br />\n{$postInfo}<br />\n<br />\nInformazio osagarria (eman badute):<br />\n{$additionalInfo}<br />\n<br />\nZerbitzari-aldagaiak:<br />\n{$serverVars}', 'Mezu-txantiloi hau erabiltzen da aldizkariko kontaktu nagusiari jakinarazteko PayPal pluginak jarduera susmagarria edo eskuz parte hartzea eskatzen duena topatu duela.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'fa_IR', 'فعالیت غیر عدی PayPal', 'سیستم های مجله آزاد فعالیتی غیر عادی مربوط به قسمت پرداخت PayPal برای {$contextName} را کشف کرده است.<br />\nاین فعالیت ممکن است بررسی بیشتر شما را ایجاب کند.<br />\n					   <br />\nاین ایمیل توسط افزونه PayPal سیستم های مجله آزاد تولید شده است.<br />\n<br />\nاطلاعات کامل پست برای درخواست:<br />\n{$postInfo}<br />\n<br />\nاطلاعات اضافی در صورت وجود:<br />\n{$additionalInfo}<br />\n<br />\nمتغییرهای سرور<br />\n{$serverVars}', '##emails.paypalInvestigatePayment.description##'),
('PAYPAL_INVESTIGATE_PAYMENT', 'fi_FI', 'Epätavallinen PayPal-toiminta', 'Open Journal Systems on havainnut epätavallista toimintaa julkaisun {$contextName} PayPal-maksujen tukeen liittyen. Tämä toiminta saattaa vaatia lisätutkimista tai manuaalista asiaan puuttumista.<br />\n                       <br />\nTämä sähköposti on Open Journal Systemsin PayPal-lisäosan luoma.<br />\n<br />\nPyynnön täydet lähetystiedot :<br />\n{$postInfo}<br />\n<br />\nLisätiedot (mikäli annettu):<br />\n{$additionalInfo}<br />\n<br />\nPalvelimen muuttujat:<br />\n{$serverVars}<br />\n', 'Tällä sähköpostipohjalla ilmoitetaan lehden yhteyshenkilölle, että PayPal-lisäosa on havainnut epäilyttäviä toimenpiteitä tai vaatii käsin tehtäviä korjauksia.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'fr_CA', 'Activité inhabituelle de PayPal', 'L''Open Journal Systems a remarqué une activité inhabituelle concernant la prise en charge du paiement PayPal pour la revue {$contextName}. Cette activité pourrait nécessiter une attention particulière ou une intervention manuelle.<br />\n                       <br />\nCe courriel a été généré par le plugiciel PayPal du Open Journal Systems.<br />\n<br />\nInformation complète de la demande :<br />\n{$postInfo}<br />\n<br />\nInformation supplémentaire (si fournie) :<br />\n{$additionalInfo}<br />\n<br />\nVariables serveur :<br />\n{$serverVars}<br />\n', 'Ce modèle de courriel est utilisé pour aviser un contact principal d''une revue qu''une activité inhabituelle ou requérant une intervention manuelle a été remarquée par le plugiciel PayPal.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'fr_FR', 'Activité PayPal inhabituelle', 'Open Journal Systems a remarqué une activité inhabituelle concernant le support de paiement PayPal pour la revue {$contextName}. Cette activité peut nécessiter une enquête plus approfondie ou une intervention manuelle.<br />\n                       <br />\nCe courriel a été généré par le module PayPal d''Open Journal Systems.<br />\n<br />\nInformation complète de la demande :<br />\n{$postInfo}<br />\n<br />\nInformation supplémentaire (si fournie) :<br />\n{$additionalInfo}<br />\n<br />\nVariables serveur :<br />\n{$serverVars}<br />\n', 'Ce modèle de courriel est utilisé pour notifier un contact principal d''une revue qu''une activité suspecte ou une activité requérant une intervention manuelle a été rencontrée par le module PayPal.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'id_ID', 'Kegiatan pembayaran paypal yang tidak biasa', 'Open Journal System telah menemukan kegiatan yang tidak biasa yang terkait dengan bantuan pembayaran paypal untuk jurnal {$contextName}. Kegiatan ini mungkin memerlukan investigasi lebih lanjut atau intervensi manual.<br />\n                       <br />\nSurel ini dibuat oleh plugin PayPal pada OJS.<br />\n<br />\nInformasi posting penuh untuk permohonan:<br />\n{$postInfo}<br />\n<br />\nInformasi tambahan (jika tersedia):<br />\n{$additionalInfo}<br />\n<br />\nServer vars:<br />\n{$serverVars}<br />\n', 'Email ini digunakan untuk memberitahukan narahubung utama jurnal bahwa plugin PayPal menemukan kegiatan mencurigakan atau kegiatan yang membutuhkan intervensi manual.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'it_IT', 'Attività PayPal sospetta', 'Open Journal Systems ha riscontrato un''attivtà sospetta sul conto PayPal della rivista {$contextName}. Ciò può richiedere ulteriori indagini o un intervento manuale.<br />\n<br />\nQuesta email è stata generata da Open Journal Systems'' PayPal plugin<br />\n<br />\nTutte le informazioni sulla richiesta:<br />\n{$postInfo}<br />\n<br />\nInformazioni aggiuntive (se disponibili):<br />\n{$additionalInfo}<br />\n<br />\nServer vars:<br />\n{$serverVars}<br />\n', 'Questa mail viene inviata dal plugin paypal al gestore di un journal quanto si notano delle attività sospette o c''è bisogno di un intervento manuale.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'mk_MK', 'Невообичаена активност на PayPal', 'Отворен весник системи наиде на необична активност во врска со плаќањето за поддршка на PayPal за списанието {$contextName}. На оваа активност можеби ќе треба дополнително испитување или рачна интервенција. <br />\n                       <br />\nОваа е-пошта е генерирана од приклучокот PayPal на Open Journal Systems. <br />\n<br />\nЦелосни информации за објавата за барањето: <br />\n{$postInfo} <br />\n<br />\nДополнителни информации (доколку се доставени): <br />\n{$additionalInfo} <br />\n<br />\nВарс на серверот: <br />\n{$serverVars} <br />\n', 'Овој образец за е-пошта се користи за да го извести примарниот контакт на журнал дека приклучокот PayPal се соочил со сомнителна активност или активност што бара рачна интервенција.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'nb_NO', 'Mistenkelig PayPal-aktivitet', 'Open Journal Systems har støtt på mistenkelig aktivitet i forbindelse med PayPal-betalingsstøtten til tidsskriftet {$contextName}. Denne aktiviteten kan kreve nærmere undersøkelse eller manuell inngripen.<br />\n                       <br />\nDenne e-posten er automatisk generert av Open Journal Systems  sitt PayPal-programtillegg<br />\n<br />\nUtfyllende informasjon:<br />\n{$postInfo}<br />\n<br />\nYtterligere informasjon (hvis levert):<br />\n{$additionalInfo}<br />\n<br />\nServer vars:<br />\n{$serverVars}<br />\n', 'Denne e-postmalen brukes til å meddele tidsskriftets primærkontakt om at mistenkelig aktivitet, eller aktivitet som krever manuell inngripen har blitt oppdaget av PayPal-programtillegget.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'nl_NL', 'Ongebruikelijke PayPal activiteit', 'Open Journal Systems heeft ongebruikelijke activiteit geconstateerd met betrekking tot de PayPal betalingsondersteuning van het tijdschrift {$contextName}. Deze activiteit vraagt om verder onderzoek of handmatige interventie.<br />\n                       <br />\nDeze e-mail is gegenereerd door de PayPal plugin van Open Journal Systems.<br />\n<br />\nVolledige berichtinformatie voor het verzoek:<br />\n{$postInfo}<br />\n<br />\nAdditionele informatie (indien opgegeven):<br />\n{$additionalInfo}<br />\n<br />\nServer variabelen:<br />\n{$serverVars} <br />\n', 'Dit e-mail sjabloon wordt gebruikt om de eerste contactpersoon van een tijdschrift te verwittigen dat de PayPal plugin ongebruikelijke activiteit werd geconstateerd, die handmatige interventie vereist.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'pl_PL', 'Nietypowe działanie PayPal', 'Open Journal System napotkał się na niespotykaną aktywność w odniesieniu do płatności PayPal dla czasopisma {$contextName}. Ta aktywność może wymagać dalszego prześledzenia lub interwencji manualnej.<br />\n                       <br />\nTen email został wysłany automatycznie przez wtyczkę PayPal Open Journal Systems.<br />\n<br />\nPełna informacja o żądaniu:<br />\n{$postInfo}<br />\n<br />\nDodatkowe informacje (jeśli dostarczono):<br />\n{$additionalInfo}<br />\n<br />\nVars serweru:<br />\n{$serverVars}<br />\n', 'Ten wzór emaila służy do powiadomienia pierwszego kontaktu czasopisma, że zauważono podejrzaną działalność we wtyczce PayPal, która wymaga manualnej interwencji.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'pt_BR', 'Atividade incomum na conta PayPal', 'O sistema encontrou atividade incomum relacionada ao suporte a pagamentos via PayPal da revista {$contextName}. Esta atividade pode exigir investigação mais profunda ou intervenção manual.<br />\n                       <br />\nEsta é uma mensagem automática da ferramenta de Pagamento via PayPal do Open Journal Systems.<br />\n<br />\nInformações detalhadas da notificação:<br />\n{$postInfo}<br />\n<br />\nInformações adicionais (caso informado):<br />\n{$additionalInfo}<br />\n<br />\nVariáveis do servidor:<br />\n{$serverVars}<br />\n', 'Esta mensagem notifica o contato principal da revista sobre atividades suspeitas, ou atividades que exijam intervenção manual, detectadas pelo Plugin de Pagamento via PayPal.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'pt_PT', 'Atividade incomum na conta PayPal', 'O sistema OJS encontrou atividade incomum relacionada ao suporte a pagamentos via PayPal, para a revista {$contextName}. Esta atividade pode exigir investigação mais profunda ou intervenção manual.<br />\n                       <br />\nEsta mensagem foi gerada pelo Plugin PayPal do OJS.<br />\n<br />\nInformações detalhadas da notificação:<br />\n{$postInfo}<br />\n<br />\nInformações adicionais (se disponível):<br />\n{$additionalInfo}<br />\n<br />\nVariáveis do Servidor:<br />\n{$serverVars}<br />\n', 'Este e-mail notifica o contacto principal da revista sobre atividades suspeitas, ou atividades que exijam intervenção manual, detetadas pelo Plugin de Pagamento via PayPal.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'ru_RU', 'Необычная активность PayPal', 'Система Open Journal Systems обнаружила необычную активность, связанную с поддержкой платежей через PayPal для журнала «{$contextName}». Эта активность может требовать дополнительного изучения или вмешательства в ручном режиме.<br />\n                       <br />\nЭто письмо было сгенерировано модулем «Платежи через PayPal» системы Open Journal Systems.<br />\n<br />\nПолная информация для запроса:<br />\n{$postInfo}<br />\n<br />\nДополнительная информация (если есть):<br />\n{$additionalInfo}<br />\n<br />\nПеременные сервера:<br />\n{$serverVars}<br />\n', 'Этот шаблон письма используется для уведомления контактного лица редакции о том, что была зарегистрирована подозрительная активность или активность, требующая вмешательства в ручном режиме, вызванная модулем «Платежи через PayPal».'),
('PAYPAL_INVESTIGATE_PAYMENT', 'sk_SK', 'Neobvyklá PayPal aktivita', 'OJS zaznamenal neobvyklú aktivitu v súvislosti s podporou plateb cez PayPal pre časopis {$contextName}. Táto aktivita môže vyžadovať ďalšiu kontrolu alebo ručný zásah.<br />\n                       <br />\nTento email bol vygenerovaný OJS pluginom pre PayPal.<br />\n<br />\nKompletné informácie k požiadavku:<br />\n{$postInfo}<br />\n<br />\nDoplnkové informácie (ak boli uvedené):<br />\n{$additionalInfo}<br />\n<br />\nPremenné serveru:<br />\n{$serverVars}<br />\n', 'Táto e-mailová šablóna slúži k upozorneniu primárneho kontaktu časopisu, že sa zásuvný modul PayPal stretol s podozrivou aktivitou alebo činnosťou vyžadujúcou manuálny zásah.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'sl_SI', 'Unusual PayPal Activity', 'Open Journal Systems has encountered unusual activity relating to PayPal payment support for the journal {$contextName}. This activity may need further investigation or manual intervention.<br />\n                       <br />\nThis email was generated by Open Journal Systems'' PayPal plugin.<br />\n<br />\nFull post information for the request:<br />\n{$postInfo}<br />\n<br />\nAdditional information (if supplied):<br />\n{$additionalInfo}<br />\n<br />\nServer vars:<br />\n{$serverVars}<br />\n', 'This email template is used to notify a journal''s primary contact that suspicious activity or activity requiring manual intervention was encountered by the PayPal plugin.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'uk_UA', 'Незвичайна активність PayPal', 'Система Open Journal Systems помітила незвичайну активність у функціонуванні модуля платежів PayPal журналу {$contextName}. Може знадобитись подальше вивчення цього питання або ручне втручання.<br />\n                       <br />\nЦей лист створений модулем PayPal системи Open Journal Systems.<br />\n<br />\nПовна інформація про запит:<br />\n{$postInfo}<br />\n<br />\nДодаткова інформація (якщо наявна):<br />\n{$additionalInfo}<br />\n<br />\nДані сервера:<br />\n{$serverVars}<br />\n', 'Цей шаблон листа використовується для інформування основної контактної особи журналу про виявлення модулем PayPal підозрілої активності або активності, що потребує ручного втручання.'),
('PAYPAL_INVESTIGATE_PAYMENT', 'zh_CN', '不正常的PayPal活动', '开放期刊系统在使用PayPal支付期刊 {$contextName} 时遇到了不可预知错误，需要进一步调查或者人工干预。<br />\n<br />\n此电子邮件是由开放期刊系统的PayPal插件自动生成的。<br />\n<br />\n当时发送的全部请求信息如下：<br />\n{$postInfo}<br />\n<br />\n附加信息（如果提供）：<br />\n{$additionalInfo}<br />\n<br />\n服务器信息：<br />\n{$serverVars}<br />\n', '这封电子邮件模板用于通知期刊主要联系人，PayPal插件碰到可疑活动或者活动需要人工支持。');
INSERT INTO `email_templates_default_data` VALUES
('PUBLISH_NOTIFY', 'ar_IQ', 'صدر عدد جديد من المجلة', 'القراء الأعزة:<br />\n<br />\n{$contextName} أصدرت تواً عددها الأخير في موقعها {$contextUrl}. نحن ندعوكم إلى الاطلاع على جدول محتويات العدد، ومن ثم زيارة موقعنا لمتابعة المقالات العلمية التي تحوز على اهتمامكم.<br />\n<br />\nنشكر لكم إهتمامكم الدائم بنتاجاتنا؛<br />\n{$editorialContactSignature}', 'هذه الرسالة معنونة إلى القراء المسجلين عبر خدمة "إشعار القراء" الموجود رابطها في صفحة المحرر الرئيسية. هذه الخدمة تُعلم القراء بصدور العدد الجديد من المجلة وتدعوهم إلى زيارة موقعها على الرابط المرسل لهم.'),
('PUBLISH_NOTIFY', 'bs_BA', 'Objavljen novi broj', 'Poštovani čitatelji,<br />\n<br />\nupravo je objavljen novi broj časopisa {$contextName} koji je dostupan na adresi {$contextUrl}. Pozivamo vas da pregledate sadržaj broja i posjetite našu mrežnu stranicu kako bi pročitali vama zanimljive članke i druge priloge.<br />\n<br />\nHvala vam na interesu za naš rad,<br />\n{$editorialContactSignature}', 'Ovaj obrazac e-pošte šalje se registriranim čitateljima kroz opciju "Obavijesti korisnika" na početnom urednikovom izborniku. Čitatelji se njome obavještavaju o izlasku novog broja časopisa i pozivaju se da posjete stranice časopisa na priloženom URL-u.'),
('PUBLISH_NOTIFY', 'ca_ES', 'Nou número publicat', 'Benvolguts/des lectors/ores,<br />\n<br />\n{$contextName} acaba de publicar el seu darrer número a {$contextUrl}. Us convidem a consultar-ne el sumari i a visitar el nostre lloc web per accedir als articles i documents que us puguin interessar.<br />\n<br />\nUs agraïm l''interès per la nostra revista,<br />\n{$editorialContactSignature}', 'Aquest missatge de correu electrònic s''envia als lectors registrats mitjançant l''enllaç Notifica als usuaris que hi ha a la pàgina inicial de l''usuari per a l''editor. Notifica als lectors la publicació d''un número nou i els convida a entrar a la revista mitjançant l''enllaç proporcionat.'),
('PUBLISH_NOTIFY', 'cs_CZ', 'Vydání nového čísla', 'Čtenáři:<br />\n<br />\n{$contextName} zrovna vydává své poslední číslo na {$contextUrl}. Zveme Vás zde ke shlédnutí obsahu a poté návštěvě našich stránek se všemi články.<br />\n<br />\nDěkujeme za Váš dlouhodobý zájem o naši práci,<br />\n{$editorialContactSignature}', 'Tento email je zasílán registrovaným čtenářům prostřednictvím odkazu "Informovat uživatele" z domácí stránky editora. Informuje čtenáře o novém čísle a zve je k návštěvě časopisu přes poskytnutou URL adresu.'),
('PUBLISH_NOTIFY', 'da_DK', 'Nyt nummer er blevet publiceret', 'Læsere:<br />\n<br />\n{$contextName} har lige publiceret det seneste nummer på {$contextUrl}. Vi inviterer dig til at gennemse indholdsfortegnelsen her og derefter besøge vores websted, hvor du kan gennemse artikler og materiale, der har din interesse.<br />\n<br />\nTak for din fortsatte interesse i vores arbejde.<br />\n{$editorialContactSignature}', 'Denne e-mail sendes til registrerede læsere via linket "Underret brugere" på redaktørens brugerstartside. Den underretter læsere om en ny udgave og inviterer dem til at besøge tidsskriftet på en angiven URL-adresse.'),
('PUBLISH_NOTIFY', 'de_DE', 'Neue Ausgabe erschienen', 'Liebe Leserinnen und Leser,<br />\n<br />\n{$contextName} hat soeben die neueste Ausgabe unter {$contextUrl} veröffentlicht. Wir laden Sie ein, hier das Inhaltsverzeichnis zu lesen und sich dann auf unserer Webseite die Sie interessierenden Beiträge anzusehen.<br />\n<br />\nDanke für das andauernde Interesse an unserer Arbeit,<br />\n{$editorialContactSignature}', 'Diese E-Mail wird an registrierte Benutzer/innen mittels des "Benutzer/innen benachrichtigen"-Links auf der persönlichen Startseite einer Redakteurin/eines Redakteurs gesendet. Sie benachrichtigt Benutzer/innen über eine neue Ausgabe und lädt sie ein, die Zeitschrift unter einer angegebenen URL aufzusuchen.'),
('PUBLISH_NOTIFY', 'el_GR', 'Έκδοση νέου τεύχους', 'Αναγνώστες:<br />\n<br />\nΤο περιοδικό {$contextName} μόλις δημοσίευσε το τελευταίο του τεύχος στον σύνδεσμο {$contextUrl}. Σας προσκαλούμε να δείτε τον πίνακα περιεχομένων και κατόπιν να επισκεφθείτε τον ιστότοπό μας, για να δείτε και άλλα ενδιαφέροντα άρθρα.<br />\n<br />\nΣας ευχαριστούμε για το ενδιαφέρον σας σχετικά με τις εκδόσεις μας,<br />\n{$editorialContactSignature}', 'Το παρόν μήνυμα αποστέλλεται στους Αναγνώστες, μέσω του συνδέσμου "Ενημέρωση Χρηστών" στην αρχική σελίδα του Επιμελητή του περιοδικού. Ενημερώνει σχετικά με τη δημοσίευση νέων τευχών και προσκαλεί τους Αναγνώστες να επισκεφθούν τον ιστότοπο του περιοδικού.'),
('PUBLISH_NOTIFY', 'en_US', 'New Issue Published', 'Readers:<br />\n<br />\n{$contextName} has just published its latest issue at {$contextUrl}. We invite you to review the Table of Contents here and then visit our web site to review articles and items of interest.<br />\n<br />\nThanks for the continuing interest in our work,<br />\n{$editorialContactSignature}', 'This email is sent to registered readers via the "Notify Users" link in the Editor''s User Home. It notifies readers of a new issue and invites them to visit the journal at a supplied URL.'),
('PUBLISH_NOTIFY', 'es_ES', 'Nuevo número publicado', 'Estimados/as lectores/as:<br />\n<br />\n{$contextName} acaba de publicar su último número en {$contextUrl}. A continuación le mostramos la tabla de contenidos, después puede visitar nuestro sitio web para consultar los artículos que sean de su interés.<br />\n<br />\nGracias por mantener el interés en nuestro trabajo,<br />\n{$editorialContactSignature}', 'Este correo se envía a lectores/as registrados/as a través del enlace "Notificar a usuarios/as" en la página principal de los editores/as. Notifica a los/as lectores/as de la aparición de un nuevo número y les invita a visitar la revista en la URL proporcionada.'),
('PUBLISH_NOTIFY', 'eu_ES', 'Zenbaki berria argitaratu da', 'Irakurle:<br />\n<br />\n{$contextName} aldizkariak zenbaki berri bat argitaratu du {$contextUrl} webgunean. Honekin batera bidaltzen dizugun Aurkibidea aztertzera eta gure webgunean artikuluak irakurtzera gonbidatzen zaitugu.<br />\n<br />\nEskerrik asko gure lana interesez jarraitzeagatik,<br />\n{$editorialContactSignature}', 'Mezu hau erabiltzaile erregistratuei bidaltzen zaie, Editorearen hasierako orriko "Jakinarazi erabiltzaileei" estekaren bidez. Zenbaki berria atera dela jakinarazten die irakurleei, eta URLa ematen die aldizkaria bisita dezaten.'),
('PUBLISH_NOTIFY', 'fa_IR', 'شماره جدید چاپ شد', 'خوانندگان گرامی:<br />\n<br />\n{$contextName}، آخرین شماره خود را به نشانی &amp;lt;<a href="{$contextUrl}">{$contextUrl}</a>&amp;gt; چاپ کرده است. از شما دعوت میشود که پس از ملاحظه فهرست عناوین از وب سایت مجله حاوی مقاله ها و موضوع های مورد علاقه بازدید کنید.<br />\n<br />\nاز توجه همیشگی مستمر شما نسبت به این مجله متشکریم.<br />\n{$editorialContactSignature}', 'This email is sent to registered readers via the "Notify Users" link in the Editor''s User Home. It notifies readers of a new issue and invites them to visit the journal at a supplied URL.'),
('PUBLISH_NOTIFY', 'fi_FI', 'Uusi numero julkaistu', 'Hyvä lukija,<br />\n<br />\n{$contextName} on juuri julkaissut uusimman numeronsa osoitteessa {$contextUrl}. Voitte tutustua sisällysluetteloon tässä ja sen jälkeen tutustua artikkeleihin ja muihin kiinnostaviin kohteisiin verkkosivustollamme.<br />\n<br />\nKiitos mielenkiinnostanne työtämme kohtaan.<br />\n{$editorialContactSignature}', 'This email is sent to registered readers via the "Notify Users" link in the Editor''s User Home. It notifies readers of a new issue and invites them to visit the journal at a supplied URL.'),
('PUBLISH_NOTIFY', 'fr_CA', 'Parution du dernier numéro', 'Lecteurs-trices,<br />\n<br />\nLe plus récent numéro de la revue {$contextName} vient d''être publié à l''adresse suivante : {$contextUrl}. Nous vous invitons à consulter le sommaire, puis à visiter notre site Web pour y lire les articles qui vous intéressent.<br />\n<br />\nNous vous remercions de l''intérêt que vous portez à notre revue,<br />\n{$editorialContactSignature}', 'Ce courriel est envoyé à tous et toutes les lecteurs-trices inscrits-es, via le lien « Aviser les utilisateurs-trices » sur la page d''accueil du,de la rédacteur-trice. Il avise les lecteurs-trices qu''un nouveau numéro est publié et les invite à visiter la revue en cliquant sur l''URL fourni.'),
('PUBLISH_NOTIFY', 'fr_FR', 'Parution du dernier numéro', 'Lecteurs:<br />\n<br />\nLe plus récent numéro de {$contextName} vient d''être publié à l''adresse suivante : {$contextUrl}. Nous vous invitons à consulter la table des matières, puis à visiter notre site Web pour y lire les articles qui vous intéressent.<br />\n<br />\nNous vous remercions de l''intérêt que vous portez à notre revue,<br />\n{$editorialContactSignature}', 'Ce courriel est envoyé à tous les lecteurs inscrits, via le lien « Aviser les utilisateurs » sur la page d''accueil du rédacteur. Il avise les lecteurs qu''un nouveau numéro est publié et les invite à visiter la revue en cliquant sur le URL fourni.'),
('PUBLISH_NOTIFY', 'gd_GB', 'Iris ùr air fhoillseachadh', 'Leughadairean:<br />\n<br />\nTha {$contextName} dìreach air iris ùr fhoillseachadh aig {$contextUrl}. Tha sinn a’ cur fàilte ort sùil a thoirt air a’ chlàr-innse an-seo agus a thadhal air an làrach-lìn againn an uairsin airson sùil a thoirt air artaigealan is rudan eile a dh’fhaodadh a bhith inntinneach dhut.<br />\n<br />\nMòran taing airson sìor ùidh a nochdadh nar n-obair,<br />\n{$editorialContactSignature}', 'Thèid am post-d seo a chur gu leughadairean clàraichte slighe a’ cheangail “Cuir brath chun an luchd-chleachdaidh” ann an dachaigh cleachdaiche an deasaiche. Tha e ag innse dhan luchd-leughaidh gu bheil iris ùr ann agus a’ toirt cuireadh dhaibh a thadhal air an iris-leabhar slighe URL a tha na bhroinn.'),
('PUBLISH_NOTIFY', 'he_IL', 'גיליון חדש פורסם', 'קוראים: <br />\n<br />\n{contextName$} פרסם זה עתה את הגיליון החדש ב- {contextUrl$}. אנו מזמינים אתכם לסקור את תוכן העניינים כאן ואז לבקר באתר האינטרנט שלנו כדי לסקור מאמרים ופריטים מעניינים. <br />\n<br />\nתודה על ההתעניינות המתמשכת בעבודה שלנו, <br />\n{editorialContactSignature$}', 'דוא"ל זה נשלח לקוראים הרשומים באמצעות הקישור "הודע למשתמשים" באזור של העורך. זה מודיע לקוראים על גיליון חדש ומזמין אותם לבקר בכתב העת בכתובת URL שסופקה.'),
('PUBLISH_NOTIFY', 'hi_IN', 'नया अंक प्रकाशित', 'Readers:<br />\n<br />\n{$contextName} ने अभी हाल ही में  {$contextUrl} पर अपना नवीनतम अंक प्रकाशित किया है। हम आपको यहां सामग्री की समीक्षा करने के लिए आमंत्रित करते हैं और फिर लेख और रुचि की वस्तुओं की समीक्षा करने के लिए हमारी वेब साइट पर जाते हैं.<br />\n<br />\nहमारे काम में निरंतर रुचि के लिए धन्यवाद,<br />\n{$editorialContactSignature}', 'यह ईमेल पंजीकृत पाठकों को संपादक के उपयोगकर्ता के घर में "उपयोगकर्ता सूचित करें" लिंक के माध्यम से भेजा जाता है। यह एक नए मुद्दे के पाठकों को सूचित करता है और उन्हें एक आपूर्ति किए गए URL पर जर्नल देखने के लिए आमंत्रित करता है.'),
('PUBLISH_NOTIFY', 'hr_HR', 'Objavljen novi broj', 'Poštovani čitatelji,<br />\n<br />\nupravo je objavljen novi broj časopisa {$contextName} koji je dostupan na adresi {$contextUrl}. Pozivamo vas da pregledate sadržaj broja i posjetite našu mrežnu stranicu kako bi pročitali vama zanimljive članke i druge priloge.<br />\n<br />\nHvala vam na interesu za naš rad,<br />\n{$editorialContactSignature}', 'Ovaj obrazac e-pošte šalje se registriranim čitateljima kroz opciju "Obavijesti korisnika" na početnom urednikovom izborniku. Čitatelji se njome obavještavaju o izlasku novog broja časopisa i pozivaju se da posjete stranice časopisa na priloženom URL-u.'),
('PUBLISH_NOTIFY', 'hu_HU', 'Új folyóiratszám jelent meg', 'Kedves Olvasók!<br />\n<br />\nMegjelent a(z) {$contextName} folyóirat legújabb online száma, mely elérhető a {$contextUrl} címen. Tekintse át tartalomjegyzékünket, keresse fel oldalunkat érdeklődési körének megfelelő cikkeink megtekintéséhez.<br />\n<br />\nKöszönjük, hogy érdeklődik folyóiratunk iránt,<br />\n{$editorialContactSignature}', 'Ez az email a regisztrált felhasználóknak kerül kiküldésre, a "Felhasználók értesítése" linken keresztül a Szerkesztői főoldalról. Az új számokról értesíti a felhasználókat, és arra invitálja, hogy a kapott URL-en keressék fel az online folyóiratot.'),
('PUBLISH_NOTIFY', 'id_ID', 'Terbitan Baru', 'Readers:<br />\n<br />\n{$contextName} baru saja menerbitkan terbitan terbarunya di {$contextUrl}. Kami mengundang Anda untuk membaca Daftar Isi dan selanjutnya mengunjungi website kami untuk membaca artikel yang Anda minati.<br />\n<br />\nTerimakasih atas perhatian Anda,<br />\n{$editorialContactSignature}', 'Email ini dikirimkan ke pembaca terdaftar melalui tautan "Beritahu Pengguna" di Beranda Pengguna Editor. Email ini memberitahu pembaca tentang terbitan baru dan mengundang pembaca untuk mengunjungi jurnal melalui URL yang diberikan.'),
('PUBLISH_NOTIFY', 'it_IT', 'Pubblicato un nuovo fascicolo', 'Gentile lettore,<br />\n<br />\nAll''indirizzo {$contextUrl} è appena stato pubblicato un nuovo numero di {$contextName}.<br />\n<br />\nGrazie per l''interesse dimostratoci,<br />\n{$editorialContactSignature}', 'Questa email viene mandata ai lettori registrsati tramite il link "Notifica Utenti" nella home utente del curatore. Questa informa i lettori di una nuova uscita e li invita a visitare il journal alla URL fornita.'),
('PUBLISH_NOTIFY', 'ja_JP', '最新号の発行案内', '読者各位:<br />\n<br />\nいつもご利用ありがとうございます。<br />\n<br />\n雑誌『{$contextName} 』は、今日、最新号を発行しました。目次を送付いたしますので、興味のある論文や記事について、実際に雑誌のWebサイトにアクセスしてチェックしていただくようご案内いたします。雑誌WebサイトのURLは、{$contextUrl}です。<br />\n<br />\n引き続きよろしくお願いいたします。<br />\n{$editorialContactSignature}', 'このメールは、編集者のユーザーページにある「利用者への通知」リンクにより、登録ユーザーに送信されるものです。このメールは、最新号の発行を読者に通知し、URLを示して雑誌にアクセスするよう案内します。'),
('PUBLISH_NOTIFY', 'ku_IQ', 'ئەژمارێکی نوێ بڵاو کرایەوە', 'خوێنەران:<br />\n<br />\n{$contextName} دواهەمین ژمارەی خۆی لە {$contextUrl} بڵاو کردەوە. ئێمە بەڕێزتان بانگێشتی بینینی ناوەرۆکی توێژینەوەکانمان دەکەین و ئێوە دەتوانن سەردانی پەڕەی سەرەکیی گۆڤار بکەن بۆ خوێندنەوەی تەواوی توێژینەوەکان.<br />\n<br />\nسوپاس بۆ گرنگیدان بە کارەکانمان،<br />\n{$editorialContactSignature}', 'ئەم ئیمەیڵە بۆ خوێنەرە تۆمارکراوەکان نێردراوە لە ڕێگای لینکی ''''ئاگادارکردنەوەی بەکارهێنەران''''ەوە. ئەمە خوێنەران لە ژمارەی نوێی گۆڤار ئاگادار دەکاتەوە و بانگێشتی سەردانیکردنی پەڕەی سەرەکییان دەکات لە ڕێگای لینکی گۆڤارەوە.'),
('PUBLISH_NOTIFY', 'mk_MK', 'Објавено е ново издание', 'Читатели:<br />\n<br />\n{$contextName} само што го објави најновото издание на {$contextUrl}.Ве покануваме тука да ја прегледате содржината и потоа да ја посетите нашата веб-страница за да ги прегледате трудовите и елементите кои би ве интересирале.<br />\n<br />\nВи благодариме за непрекината заинтересираност за нашата работа,<br />\n{$editorialContactSignature}', 'Овој и-меил е испратен до регистрирани читатели преку линкот „Извести корисници“ на насловната страница на уредниците. Ги известува читателите за новообјавено издание и ги поканува да го посетат списанието преку добавеното URL.'),
('PUBLISH_NOTIFY', 'nb_NO', 'Ny utgave publisert', 'Til våre lesere:<br />\n<br />\n{$contextName} har nettopp publisert en ny utgave på {$contextUrl}. Her kan du lese innholdsfortegnelsen, før du går videre til nettstedet for å se nærmere på innholdet.<br />\n<br />\nTakk for interessen du viser for arbeidet vårt.<br />\n{$editorialContactSignature}', 'Denne e-posten sendes til registrerte brukere som har bedt om slikt varsel, via «Varsle brukere»-lenken på redaktørens brukerside. På denne måten får registrerte brukere varsel om den nye utgivelsen og inviteres til å besøke nettstedet via en vedlagt URL-lenke.'),
('PUBLISH_NOTIFY', 'nl_NL', 'Nieuw nummer gepubliceerd', 'Lezers:<br />\n<br />\n{$contextName} heeft zijn nieuwste nummer gepubliceerd op {$contextUrl}. We nodigen u uit om de inhoudsopgave te bekijken en de website te bezoeken voor het bekijken van de artikels en andere interessante items.<br />\n<br />\nDank voor uw interesse in ons werk,<br />\n{$editorialContactSignature}', 'Deze e-mail wordt verstuurd naar de geregistreerde gebruikers via de "Bericht gebruikers" link op de gebruikerspagina van de redacteur. Het stelt lezers op de hoogte van het verschijnen van een nieuw nummer en nodigt ze uit om het tijdschrift te bezoeken via de bijgevoegde URL.'),
('PUBLISH_NOTIFY', 'pl_PL', 'Nowy numer czasopisma', 'Szanowni Państwo, <br />\n<br />\nukazał się nowy numer czasopisma {$contextName}. Zachęcamy do zapoznania się z jego treścią, a także z innymi pozycjami godnymi zainteresowania, które znajdziecie na naszej stronie.<br />\n<br />\nDziękujemy za zainteresowanie działalnością czasopisma,<br />\n{$editorialContactSignature}', 'Wiadomość jest wysyłana do zarejestrowanych czytelników. Zawiera informację o nowym numerze czasopisma.'),
('PUBLISH_NOTIFY', 'pt_BR', 'Nova Edição Publicada', 'Caros leitores:<br />\n<br />\n{$contextName} acaba de publicar sua edição mais recente em {$contextUrl}. Convidamos a consultar o sumário abaixo e, em seguida, visitar o site para verificar os artigos e itens de interesse.<br />\n<br />\nAgradecemos pelo interesse em nosso trabalho,<br />\n{$editorialContactSignature}', 'Esta mensagem é enviada para leitores cadastrados através do link "notificação de usuários" na página do Editor. Ela avisa os leitores a respeito de uma nova edição e os convida a acessar o periódico através da URL informada.'),
('PUBLISH_NOTIFY', 'pt_PT', 'Nova edição publicada', 'Caros leitores,<br />\n<br />\nA {$contextName} acaba de publicar o seu número mais recente, disponível em {$contextUrl}. Convidamo-lo a consultar o sumário e aceder à revista para visualizar os artigos.<br />\n<br />\nAgradecemos o seu interesse pelas nossas publicações,<br />\n{$editorialContactSignature}', 'Este e-mail é enviado a leitores registados através do botão "Notificar utilizadores" na página do Editor. Notifica os leitores da publicação de um novo número e convida-os a aceder à revista, através do URL fornecido.'),
('PUBLISH_NOTIFY', 'ro_RO', 'Un nou număr a fost publicat', 'Dragi cititori:<br />\n<br />\n{$contextName} tocmai a publicat ultimul său număr {$contextUrl}. Vă invităm să consultați aici cuprinsul și apoi să vizitați site-ul nostru web pentru a citi articole de interes.<br />\n<br />\nVă mulțumim pentru interesul continuu manifestat față de activitatea noastră,<br />\n{$editorialContactSignature}', 'Acest e-mail este trimis cititorilor înregistrați prin linkul „Notificare utilizatori” din Pagina de pornire a editorului. Acesta notifică cititorii despre o publicarea unui nou număr și îi invită să viziteze jurnalul la o adresă URL furnizată.'),
('PUBLISH_NOTIFY', 'ru_RU', 'Опубликован новый выпуск', 'Уважаемые читатели!<br />\n<br />\nЖурнал «{$contextName}» только что опубликовал свой последний выпуск на сайте {$contextUrl}. Мы предлагаем вам ознакомиться здесь с содержанием выпуска, а затем посетить наш веб-сайт, чтобы прочитать статьи и сообщения на интересующие вас темы.<br />\n<br />\nБлагодарю вас за постоянный интерес к нашей работе,<br />\n{$editorialContactSignature}', 'Это письмо отправляется зарегистрированным читателям по ссылке «Уведомить пользователей» на главной странице редактора. Оно сообшает читателям о выходе нового выпуска и приглашает их посетить сайт журнала по указанному адресу (URL).'),
('PUBLISH_NOTIFY', 'sk_SK', 'Vydanie nového čísla', 'Čitatelia:<br />\n<br />\n{$contextName} zrovna vydáva svoje posledné číslo na {$contextUrl}. Pozývame Vás tu na pozeranie obsahu a potom návštevu našich stránok so všetkými článkami.<br />\n<br />\nĎakujeme za Váš dlhodobý záujem o našu prácu,<br />\n{$editorialContactSignature}', 'Tento email je odosielaný zaregistrovaným čitateľom prostredníctvom odkazu "Informovať používateľa" z domácej stránky editora. Informuje čitateľov o novom čísle a pozýva ich k návšteve časopisu cez poskytnutú URL adresu.'),
('PUBLISH_NOTIFY', 'sl_SI', 'Izid nove številke', 'Sptoštovani!<br />\n<br />\nIzšla je nova številka revije {$contextName} do katere lahko dostopate preko povezave $contextUrl}. Vabimo vas, da pogledate kazalo vsebine in obiščete spletno stran, da preberete članke in ostale stvari, ki vas zanimajo.<br />\n<br />\nHvala za zanimanje za naše delo,<br />\n{$editorialContactSignature}', 'Email se pošlje vsem registriranim bralcem preko urednikove funkcionalnosti "Obvesti uporabnike". Email obvesti bralce o novi številki in jih povabi k obisku revije preko spletne povezave.'),
('PUBLISH_NOTIFY', 'sv_SE', 'Nytt nummer publicerat', 'Till registrerade läsare:<br />\n<br />\n{$contextName} publicerade precis ett nytt nummer på {$contextUrl}. Här bifogas numrets innehållsförteckning. Klicka dig vidare till vår webbplats för att läsa de artiklar och texter som kan vara av intresse.<br />\n<br />\nTack för visat intresse för vårt arbete,<br />\n{$editorialContactSignature}', 'Det här e-postmeddelandet skickas till registrerade läsare via "Meddela användare"-länken under redaktörens användarprofil. Det innehåller information om att det publicerats ett nytt nummer och välkomnar dem genom en länk att besöka tidskriften.'),
('PUBLISH_NOTIFY', 'tr_TR', 'Yeni Sayı Yayınlandı', 'Sayın Okuyucumuz,<br />\n<br />\n{$contextName} dergisinin yeni saysını yayınladı. Yeni sayıya {$contextUrl} adresinden ulaşabilirsiniz.<br />\nSizi dergimizin içindekiler sayfasını incelemeye, beğendiğiniz makaleleri okumaya ve değerli görüşlerinizi paylaşmaya davet ediyoruz.<br />\n<br />\nDergimize gösterdiğiniz ilgi için teşekkür ederiz.<br />\n{$editorialContactSignature}', 'Bu e-posta “Bana Haber Ver” seçeneğini işaretlemiş okuyuculara yeni sayıyı haber vermek ve son sayının adresini vererek okumaya çağrı için kullanılır.'),
('PUBLISH_NOTIFY', 'uk_UA', 'Опубліковано новий випуск', 'Шановні читачі!<br />\n<br />\nНовий випуск видання {$contextName} був щойно опублікований за адресою {$contextUrl}. Запрошуємо переглянути зміст випуску, щоб потім зайти на наш веб-сайт та ознайомитись зі статтями та іншими цікавими Вам матеріалами.<br />\n<br />\nДякуємо, що продовжуєте цікавитись нашою роботою,<br />\n{$editorialContactSignature}', 'Цей лист надсилається зареєстрованим читачам засобами посилання "Сповістити користувачів" у теці редактора. Лист інформує читачів про вихід нового випуску видання та запрошує їх відвідати сайт журналу, скориставшись відповідним URL-посиланням.'),
('PUBLISH_NOTIFY', 'vi_VN', 'Số mới được xuất bản', 'Kính gửi quý độc giả:<br />\n<br />\n{$contextName} vừa xuất bản số mới nhất tại {$contextUrl}. Chúng tôi kính mời độc đọc tham khảo Mục lục tại đây và sau đó truy cập trang web của chúng tôi để xem chi tiết các bài viết và các bài bạn quan tâm.<br />\n<br />\nTrân trọng cảm ơn  và mong tiếp tục nhận được sự quan tâm của quý độc giả với các ấn phẩm của chúng tôi,<br />\n{$editorialContactSignature}', 'Email này được gửi đến những người đọc đã đăng ký thông qua liên kết "Thông báo cho người dùng" trong Trang chủ của người dùng. Nó thông báo cho độc giả về một số mới và mời họ ghé thăm tạp chí tại một URL được cung cấp.'),
('PUBLISH_NOTIFY', 'zh_CN', '新一期期刊已出版', '亲爱的读者您好：<br />\n<br />\n《{$contextName}》已经出版了最新一期的期刊，请见{$contextUrl}。我们诚挚地邀请您阅览这里的目录，并接着访问我们的网站以阅读各种文章以及有趣的项目。<br />\n<br />\n感谢您持续地关注我们的作品，<br />\n{$editorialContactSignature}', '这封电子邮件是透过编辑的「用户首页」页面中的「通知用户」链接，寄发给注册用户。此邮件通知读者有新一期的内容并邀请他们以内附的网址查看期刊。'),
('REVIEWER_REGISTER', 'ar_IQ', 'التسجيل بصفة محكم في {$contextName}', 'في ضوء ما هو معروف عنك من خبرة، سنحت لنا الظروف بتسجيل اسمك ضمن قاعدة بياناتنا للمحكمين في موقع {$contextName}.  هذا الأمر لا يترتب عليه أي مستوى من الإلتزام من جهتك، بل ببساطة، يمكننا من التواصل معك بشأن إحتمالية تحكيم بعض طلبات النشر التي ترد مجلتنا. فيما لو تمت دعوتك مستقبلاً لغرض التحكيم، ستكون لك فرصة الاطلاع على عنوان المؤلَّف وملخصه (دون معرفة أي شيء يتعلق بالمؤلف نفسه)، وستكون صاحب الرأي بشأن الموافقة على تلك الدعوة أو الاعتذار عنها. فضلاً عن ذلك، بإمكانك دوماً المطالبة برفع اسمك من قائمة المحكمين المعتمدين لدى مجلتنا.<br />\n<br />\nنحن نزودك باسم الدخول وكلمة المرور الخاصين بك، واللذين يتيحان لك القيام بكل الفعاليات المتعلقة بعملك ضمن موقعنا. فقد ترغب، على سبيل المثال، بتحديث بيانات ملفك الشخصي وتضمين المجالات العلمية التي يهمك التحكيم فيها.<br />\n<br />\nاسم الدخول: {$username}<br />\nكلمة المرور: {$password}<br />\n<br />\nشكراً لك.<br />\n{$principalContactSignature}', 'هذه الرسالة معنونة إلى المحكمين المسجلين حديثاً للترحيب بهم في موقعنا ولتزويدهم بأسماء الدخول وكلمات المرور الخاصين بهم.'),
('REVIEWER_REGISTER', 'bs_BA', 'Registrirani ste kao recenzent časopisa {$contextName}', 'Imajući u vidu vaše područje ekspertize, odlučili smo registrirati vas u bazu recenzenata časopisa {$contextName}. Ovo vas ne obvezuje ni na koji način, već samo omogućava uredništvu da vas kontaktira sa informacijama o prilozima koje biste potencijalno mogli recenzirati. Po zaprimljenom pozivu za recenziju, bit ćete u mogućnosti pregledati naslov i sažetak konkretnog rada čiju recenziju predlažemo, te ćete uvijek biti u mogućnosti prihvatiti ili odbiti rencenzijsko zaduženje. Također, u bilo kojem trenutku možete zatražiti da uklonimo vaše ime iz baze recenzenata i zatvorimo vaš korisnički račun.<br />\n<br />\nOvdje vam prilažemo vaše korisničko ime i lozinku, koja vam je potrebna za rad sa časopisom kroz naš sustav za elektroničko uređivanje. U njemu možete i dopuniti svoje korisničke detalje (npr. recenzentske interese).<br />\n<br />\nKorisničko ime: {$username}<br />\nLozinka: {$password}<br />\n<br />\nSrdačno,<br />\n{$principalContactSignature}', 'Ova se poruka šalje recenzentima koje registriraju urednici. Njome se novoregistriranom recenzentu želi dobrodošlica te pružaju informacije o korisničkom imenu i lozinki.'),
('REVIEWER_REGISTER', 'ca_ES', 'Registre com a revisor a {$contextName}', 'Després d''avaluar el vostre perfil, ens hem pres la llibertat de registrar el vostre nom a la base de dades de revisors per a {$contextName}. El fet de pertànyer a aquesta base de dades no suposa cap compromís per part vostra i, d''altra banda, ens permet fer-vos arribar propostes de revisions. Quan rebeu una proposta de revisió d''un document tindreu l''oportunitat de consultar-ne el títol i el resum, i tant podreu acceptar com rebutjar la invitació. En qualsevol moment podeu sol·licitar que se suprimeixi el vostre nom d''aquesta llista de revisors.<br />\n<br />\nA continuació trobareu el vostre nom d''usuari i la vostra contrasenya. Necessitareu aquestes dades per a entrar al lloc web de la revista i treballar-hi. És possible que, per exemple, vulgueu actualitzar el vostre perfil i incloure-hi els vostres interessos de revisió.<br />\n<br />\nNom d''usuari: {$username}<br />\nContrasenya: {$password}<br />\n<br />\nMoltes gràcies,<br />\n{$principalContactSignature}', 'Aquest missatge de correu electrònic s''envia a un revisor que s''acaba de registrar per a donar-li la benvinguda al sistema i fer-li arribar el seu nom d''usuari i la seva contrasenya.'),
('REVIEWER_REGISTER', 'cs_CZ', 'Zaregistrování na pozici recenzenta pro {$contextName}', 'S ohledem na Vaši odbornost jsme si Vás dovolili zaregistrovat do databáze recenzentů pro časopis {$contextName}. To Vás nezavazuje k žádné odpovědnosti, pouze nám to umožní Vás rychle kontaktovat s příspěvkem, který byste mohl případně recenzovat. Pokud Vás přizveme ke zpracování recenze, budete mít příležitost vidět název a abstrakt daného příspěvku a vždy budete v pozici, kdy můžete rozhodnout, zda přizvání přijmete nebo odmítnete. Můžete také kdykoliv požádat o odstranění Vašeho jména ze seznamu recenzentů.<br />\n<br />\nPřidělili jsme Vám uživatelské jméno a heslo, které budete používat na internetových stránkách časopisu. Možná budete chtít například upravit svůj profil nebo rozsah zájmu o zpracování recenzí.<br />\n<br />\nUživatelské jméno: {$username}<br />\nHeslo: {$password}<br />\n<br />\nDěkujeme,<br />\n{$principalContactSignature}', 'Tento email je zaslán nově registrovanému recenzentovi jako přivítání do systému a poskytne mu doklad o jeho uživatelském jménu a heslu.'),
('REVIEWER_REGISTER', 'da_DK', 'Registrering som bedømmer hos {$contextName}', 'På baggrund af din ekspertise har vi taget den frihed at registrere dit navn i bedømmerdatabasen for {$contextName}. Dette stiller ikke krav om nogen form for engagement fra din side, men gør det blot muligt for os at kontakte dig med hensyn til en eventuelt bedømmelse af et manuskript. Hvis du inviteres til at foretage en bedømmelse, vil du have mulighed for at se titlen på og et resumé af det pågældende manuskript, og du vil altid kunne acceptere eller afvise invitationen. Du kan til enhver tid også bede om at få dit navn fjernet fra listen over bedømmere.<br />\n<br />\nVi giver dig et brugernavn og en adgangskode, der skal bruges i forbindelse med alle interaktioner med tidsskriftet via tidsskriftets webside. Du kan f.eks. bede om at få opdateret din profil, herunder dine bedømmelsesinteresser.<br />\n<br />\nBrugernavn: {$username}<br />\nAdgangskode: {$password}<br />\n<br />\nTak. <br />\n{$principalContactSignature}', 'Denne e-mail sendes til netop registrerede bedømmere for at byde dem velkommen til systemet og for at oplyse dem om deres brugernavn og adgangskode.'),
('REVIEWER_REGISTER', 'de_DE', 'Registrierung als Gutachter/in bei {$contextName}', 'Angesichts Ihrer Erfahrung haben wir uns erlaubt, Ihren Namen der Gutachter/innendatenbank von {$contextName} hinzuzufügen. Dies verpflichtet Sie in keiner Weise, ermöglicht uns aber, Sie um mögliche Gutachten für eine Einreichung zu bitten. Wenn Sie zu einem Gutachten eingeladen werden, werden Sie Titel und Abstract des Beitrags sehen können und werden stets selber entscheiden können, ob Sie der Einladung folgen oder nicht. Sie können zu jedem Zeitpunkt Ihren Namen von der Gutachter/innenliste entfernen lassen.<br />\n<br />\nWir senden Ihnen einen Benutzer/innennamen und ein Passwort, die sie in allen Schritten der Zusammenarbeit mit der Zeitschrift über deren Website benötigen. Vielleicht möchten Sie z.B. Ihr Profil inkl. Ihrer Begutachtungsinteressen aktualisieren.<br />\n<br />\nUsername: {$username}<br />\nPassword: {$password}<br />\n<br />\nVielen Dank,<br />\n{$principalContactSignature}', 'Diese E-Mail wird an neu registrierte Gutachter/innen gesendet, um sie beim System willkommen zu heißen und ihnen Benutzer/innennamen und Passwort zu bestätigen.'),
('REVIEWER_REGISTER', 'el_GR', 'Εγγραφή ως Αξιολογητής στο περιοδικό {$contextName}', 'Λαμβάνονας υπόψη τα επιστημονικά σας ενδιαφέροντα, πήραμε την πρωτοβουλία να εντάξουμε το όνομά σας στη βάση των Αξιολογητών για το περιοδικό {$contextName}. Το γεγονός αυτό δε συνεπάγεται κάποια δέσμευση από μέρους σας, απλώς μας προσφέρει τη δυνατότητα να απευθυνθούμε σε εσάς για την αξιολόγηση μίας υποβολής. Μόλις προσκληθείτε για αξιολόγηση, θα έχετε την ευκαιρία να δείτε τον τίτλο και την περίληψη του εν λόγω άρθρου, έχοντας τη δυνατότητα να αποδεχθείτε ή να απορρίψετε την πρόσκληση. Μπορείτε επίσης, ανά πάσα στιγμή, να ζητήσετε να διαγραφείτε από τον κατάλογο των Αξιολογητών.<br />\n<br />\nΣας παρέχουμε το όνομα Χρήστη και τον κωδικό πρόσβασης στον ιστότοπο του περιοδικού σε περίπτωση που επιθυμείτε, για παράδειγμα, να ενημερώσετε το προφίλ σας, συμπληρώνοντας τα ερευνητικά σας ενδιαφέροντα για τη διεξαγωγή αξιολογήσεων.<br />\n<br />\nΌνομα χρήστη: {$username}<br />\nΚωδικός πρόσβασης: {$password}<br />\n<br />\nΣας ευχαριστούμε,<br />\n{$principalContactSignature}', 'Το παρόν μήνυμα καλωσορίσματος αποστέλλεται στους νέους Αξιολογητές. Περιέχει το όνομα Χρήστη και τον κωδικό πρόσβασής τους στον ιστότοπο.'),
('REVIEWER_REGISTER', 'en_US', 'Registration as Reviewer with {$contextName}', 'In light of your expertise, we have taken the liberty of registering your name in the reviewer database for {$contextName}. This does not entail any form of commitment on your part, but simply enables us to approach you with a submission to possibly review. On being invited to review, you will have an opportunity to see the title and abstract of the paper in question, and you''ll always be in a position to accept or decline the invitation. You can also ask at any point to have your name removed from this reviewer list.<br />\n<br />\nWe are providing you with a username and password, which is used in all interactions with the journal through its website. You may wish, for example, to update your profile, including your reviewing interests.<br />\n<br />\nUsername: {$username}<br />\nPassword: {$password}<br />\n<br />\nThank you,<br />\n{$principalContactSignature}', 'This email is sent to a newly registered reviewer to welcome them to the system and provide them with a record of their username and password.'),
('REVIEWER_REGISTER', 'es_ES', 'Revisor para {$contextName}', 'A la vista de su trayectoria profesional, su nombre ha sido propuesto para figurar como revisor potencial en el sistema de gestión electrónica de artículos de la revista {$contextName}, sin que ello implique ningún compromiso por su parte y pudiendo dejar de formar parte de esta lista cuando lo desee. Únicamente nos posibilita poder enviarle artículos para una eventual revisión por su parte. En caso de estar conforme con actuar como revisor para la revista, podrá recibir solicitudes de revisión de artículos, y aceptar o rechazar dichas solicitudes en su momento.<br />\n<br />\nA continuación le enviamos un nombre de usuario/a y contraseña con los que podrá acceder al sistema de gestión de envíos de la revista, donde además podrá indicarnos los temas que le son de interés como revisor.<br />\n<br />\nUsername: {$username}<br />\nPassword: {$password}<br />\n<br />\nAgradecidos por su atención, reciba un cordial saludo,<br />\n{$principalContactSignature}', 'Este email se envía a los nuevos revisores para darles la bienvenida al sistema y proporcionarles sus datos de acceso.'),
('REVIEWER_REGISTER', 'eu_ES', '{$contextName} aldizkarian Ebaluatzaile gisa erregistratzea', '{$contextName} aldizkarian lantzen dugun jakintza-arloan aditua zarenez, zure izena ebaluatzaileen datu-basean erregistratzeko atrebentzia izan dugu. Horrek ez zaitu ezertara konprometitzen, baina zuregana jotzeko aukera emango digu bidalketaren baten ebaluazioa egiteko prest egongo zinatekeen galdetzeko. Ebaluazioa egiteko gonbitarekin batera, artikuluaren edo paperaren titulua eta laburpena bidaliko dizkizugu, eta beti izango duzu gonbita onartzeko edo ez onartzeko aukera. Edozein unetan eska dezakezu zure izena ebaluatzaileen zerrendatik kentzeko.<br />\n<br />\nErabiltzaile-izena eta pasahitza eman dizkizugu, aldizkariaren webgunean sartzeko eta gurekin elkarlanean aritzeko. Beharbada zure profila aldatu ahal izango duzu, ebaluazioak egiteko interesak barne.<br />\n<br />\nErabiltzaile-izena: {$username}<br />\nPasahitza: {$password}<br />\n<br />\nEskerrik asko,<br />\n{$principalContactSignature}', 'Ebaluatzaile erregistratu berriei bidaltzen zaie mezu hau, sistemarako ongietorria emateko eta erabiltzaile-izena eta pasahitza jakinarazteko.'),
('REVIEWER_REGISTER', 'fa_IR', 'ثبت نام به عنوان کارشناس {$contextName}', 'با توجه با تجارب جنابعالی, {$contextName} فرصت را مغتنم شمرده و نام شما را در زمره کارشناسان مجله ثبت کرده است. لازم به تذکر است که صرف این عمل هیچگونه مسئولیت و تعهدی را متوجه جنابعالی نمی سازد و فقط ما را قادر می سازد تا جهت ارسال مقاله برای کارشناسی احتمالی توسط جنابعالی براحتی با شما تماس بگیریم. هنگامی که از شما برای انجام کارشناسی یک مقاله دعوت به عمل می آید شما مختار خواهید بود که پس از دیدن عنوان و چکیده مقاله دعوت را بپذیرید یا از انجام کارشناسی خودداری کنید. بعلاوه در هر زمان که اراده کنید میتوانید از ما بخواهید تا نام شما را از لیست کارشناسان مجله حذف کنیم.<br />\n<br />\nنام کاربری و رمز عبور شما برای سایت مجله که جهت انجام تمام امورات آنلاین با این مجله لازم است در زیر آمده است.<br />\n<br />\nنام کاربری: {$username}<br />\nرمز عبور: {$password}<br />\n<br />\nبا تشکر,<br />\n{$principalContactSignature}', 'This email is sent to a newly registered reviewer to welcome them to the system and provide them with a record of their username and password.'),
('REVIEWER_REGISTER', 'fi_FI', 'Rekisteröinti arvioijaksi julkaisuun {$contextName}', 'Asiantuntemuksenne perusteella olemme ottaneet vapauden rekisteröidä teidät julkaisun {$contextName} arvioijatietokantaan. Tämä ei velvoita teitä mihinkään, mutta antaa meille mahdollisuuden ottaa teihin yhteyttä mahdollisen käsikirjoituksen arvioinnin tiimoilta. Arviointikutsun yhteydessä näette arvioitavan työn otsikon ja tiivistelmän, ja voitte aina joko hyväksyä kutsun tai kieltäytyä siitä. Voitte myös missä tahansa vaiheessa pyytää, että nimenne poistetaan tältä arvioijalistalta.<br />\n<br />\nAnnamme teille käyttäjätunnuksen ja salasanan, joita käytetään kaikkeen vuorovaikutukseen julkaisun kanssa sen verkkosivuston kautta. Haluatte ehkä esimerkiksi päivittää profiilinne ja teitä kiinnostavat arviointiaiheet.<br />\n<br />\nKäyttäjätunnus: {$username}<br />\nSalasana: {$password}<br />\n<br />\nYstävällisin terveisin,<br />\n{$principalContactSignature}', 'This email is sent to a newly registered reviewer to welcome them to the system and provide them with a record of their username and password.'),
('REVIEWER_REGISTER', 'fr_CA', 'Inscription en tant qu''évaluateur-trice pour la revue {$contextName}', 'Compte tenu de votre expertise, nous avons pris l''initiative d''inscrire votre nom dans la base de données des évaluateurs-trices de la revue {$contextName}. Cela ne vous engage d''aucune façon, mais nous permet simplement de solliciter vos services pour l''évaluation d''une soumission. Si vous êtes invité-e à effectuer une évaluation, vous recevrez le titre et le résumé de l''article en question, et serez toujours libre d''accepter ou de refuser une telle invitation. À tout moment, il vous est également possible de demander à ce que votre nom soit retiré de la liste des évaluateurs-trices.<br />\n<br />\nNous vous acheminons un nom d''utilisateur-trice et un mot de passe, car tous deux sont requis pour tout échange avec la revue via son site Web. Vous pouvez, par exemple, si vous le souhaitez, effectuer la mise à jour de votre profil, y compris vos domaines d''intérêt en matière d''évaluation.<br />\n<br />\nNom d''utilisateur-trice : {$username}<br />\nMot de passe : {$password}<br />\n<br />\nMerci,<br />\n{$principalContactSignature}', 'Ce courriel est envoyé à un,une évaluateur-trice nouvellement inscrit-e, afin de lui souhaiter la bienvenue dans le système et l''informer de son nom d''utilisateur-trice et de son mot de passe.'),
('REVIEWER_REGISTER', 'fr_FR', 'Inscription en tant que rapporteur de {$contextName}', 'Compte tenu de votre expertise, nous avons pris l''initiative d''inscrire votre nom dans la base de données des rapporteurs de {$contextName}. Cela ne vous engage d''aucune façon, mais nous permet simplement de solliciter vos services pour l''évaluation d''une soumission. Si vous êtes invité à effectuer une évaluation, vous recevrez le titre et le résumé de l''article en question, et serez toujours libre d''accepter ou de refuser une telle invitation. À tout moment, il vous est également possible de demander à ce que votre nom soit retiré de la liste des rapporteurs.<br />\n<br />\nNous vous acheminons un nom d''utilisateur et un mot de passe, car tous deux sont requis pour tout échange avec la revue, par l''intermédiaire de ce site Web. Vous pouvez, par exemple, si vous le souhaitez, effectuer la mise à jour de votre profil, y compris vos intérêts en matière d''évaluation.<br />\n<br />\nNom d''utilisateur : {$username}<br />\nMot de passe : {$password}<br />\n<br />\nMerci,<br />\n{$principalContactSignature}', 'Ce courriel est envoyé à un rapporteur nouvellement inscrit, afin de l''accueillir dans le système et lui offrir un enregistrement de son nom d''utilisateur et mot de passe.'),
('REVIEWER_REGISTER', 'gd_GB', 'Clàradh mar lèirmheasaiche aig {$contextName}', 'Leis na tha de dh’eòlas agad, bha sinn cho dàna ’s gun do chlàraich sinn d’ ainm ann an stòr-dàta nan lèirmheasaichean airson {$contextName}. Chan eil dleastanas sam bith ag èirigh riut ri linn sin, cha dèan e ach cothrom a thoirt dhuinne faighneachd dhìot am biodh ùidh agad ann an lèirmheas tagraidh. Ma gheibh thu cuireadh, chì thu tiotal is geàrr-chunntas a’ phàipeir agus is urrainn dhut gabhail ris no a dhiùltadh mar a thogras tu. ’S urrainn dhut iarraidh oirnn uair sam bith d’ ainm a thoirt air falbh o liosta nan lèirmheasaichean cuideachd.<br />\n<br />\nTha sinn a’ toirt dhut ainm-cleachdaiche agus facal-faire a dh’fheumas tu airson eadar-ghabhail a dhèanamh leis an iris-leabhar air an làrach-lìn aca. Dh’fhaoidte gum b’ fheàirrde dhut a’ phròifil agad ùrachadh agus innse dè na cuspairean sa bheil ùidh agad a thaobh lèirmheasan mar eisimpleir.<br />\n<br />\nAinm-cleachdaiche: {$username}<br />\nFacal-faire: {$password}<br />\n<br />\nMòran taing,<br />\n{$principalContactSignature}', 'Thèid am post-d seo a chur gu lèirmheasaiche a tha air ùr-chlàradh agus a’ cur fàilte dhan t-siostam orra agus a’ thoirt dhaibh clàr dhen ainm-chleachdaiche is facal-faire aca.');
INSERT INTO `email_templates_default_data` VALUES
('REVIEWER_REGISTER', 'he_IL', 'הרשמה כסוקר עם {contextName$}', 'לאור המומחיות שלך, רשמנו את שמך במאגר הסוקרים עבור {contextName$}. זה לא כרוך בשום צורה של התחייבות מצידך, אלא פשוט מאפשר לנו לפנות אליך עם הגשה שתוכל לבדוק. לאחר שתוזמן לבדיקה, תהיה לך הזדמנות לראות את הכותרת והתקציר של המאמר המדובר, ותמיד תהיה לך האופציה לקבל את ההזמנה או לדחות אותה. אתה יכול גם לבקש בכל נקודה להסיר את שמך מרשימת הסוקרים הזו. <br />\n<br />אנו מספקים לך שם משתמש וסיסמא, המשמשים בכל האינטראקציות עם כתב העת דרך אתר האינטרנט שלו. ייתכן שתרצה, למשל, לעדכן את הפרופיל שלך, כולל תחומי העניין שלך בביקורת. <br />\n<br />\nשם משתמש: {username}$ <br/>\nסיסמא: {סיסמא$} <br />\n<br />\nתודה לך, <br />\n{principalContactSignature$}', 'דוא"ל זה נשלח למבקר שנרשם לאחרונה כדי לקבל אותו במערכת ולספק להם רשומה של שם המשתמש והסיסמה שלהם.'),
('REVIEWER_REGISTER', 'hi_IN', '{$contextName}के साथ समीक्षक के रूप में पंजीकरण', 'आपकी विशेषज्ञता के प्रकाश में, हमने {$contextName} के लिए समीक्षक डेटाबेस में आपका नाम दर्ज करने की स्वतंत्रता ले ली है। यह आपकी ओर से किसी भी प्रकार की प्रतिबद्धता को पूरा नहीं करता है, लेकिन संभवतया समीक्षा के लिए प्रस्तुत करने के लिए बस हमें आपसे संपर्क करने में सक्षम बनाता है। समीक्षा के लिए आमंत्रित किए जाने पर, आपके पास प्रश्न में कागज का शीर्षक और सार देखने का अवसर होगा, और आप हमेशा आमंत्रण को स्वीकार या अस्वीकार करने की स्थिति में होंगे। आप किसी भी बिंदु पर इस समीक्षक सूची से अपना नाम हटाने के लिए कह सकते हैं.<br />\n<br />\nहम आपको एक उपयोगकर्ता नाम और पासवर्ड प्रदान कर रहे हैं, जो अपनी वेबसाइट के माध्यम से जर्नल के साथ सभी बातचीत में उपयोग किया जाता है। उदाहरण के लिए, आप अपनी समीक्षा हितों सहित अपनी प्रोफ़ाइल को अपडेट कर सकते हैं.<br />\n<br />\nUsername: {$username}<br />\nPassword: {$password}<br />\n<br />\nThank you,<br />\n{$principalContactSignature}', 'यह ईमेल एक नए पंजीकृत समीक्षक को सिस्टम में उनका स्वागत करने और उनके उपयोगकर्ता नाम और पासवर्ड के रिकॉर्ड के साथ प्रदान करने के लिए भेजा जाता है.'),
('REVIEWER_REGISTER', 'hr_HR', 'Registrirani ste kao recenzent časopisa {$contextName}', 'Imajući u vidu vaše područje ekspertize, odlučili smo registrirati vas u bazu recenzenata časopisa {$contextName}. Ovo vas ne obvezuje ni na koji način, već samo omogućava uredništvu da vas kontaktira sa informacijama o prilozima koje biste potencijalno mogli recenzirati. Po zaprimljenom pozivu za recenziju, bit ćete u mogućnosti pregledati naslov i sažetak konkretnog rada čiju recenziju predlažemo, te ćete uvijek biti u mogućnosti prihvatiti ili odbiti rencenzijsko zaduženje. Također, u bilo kojem trenutku možete zatražiti da uklonimo vaše ime iz baze recenzenata i zatvorimo vaš korisnički račun.<br />\n<br />\nOvdje vam prilažemo vaše korisničko ime i lozinku, koja vam je potrebna za rad sa časopisom kroz naš sustav za elektroničko uređivanje. U njemu možete i dopuniti svoje korisničke detalje (npr. recenzentske interese).<br />\n<br />\nKorisničko ime: {$username}<br />\nLozinka: {$password}<br />\n<br />\nSrdačno,<br />\n{$principalContactSignature}', 'Ova se poruka šalje recenzentima koje registriraju urednici. Njome se novoregistriranom recenzentu želi dobrodošlica te pružaju informacije o korisničkom imenu i lozinki.'),
('REVIEWER_REGISTER', 'hu_HU', 'Regisztráció szakmai lektorként a(z) {$contextName} folyóirathoz', 'Tisztelt Szakértő!<br />\n<br />\nEzúton értesítjük, hogy a(z) {$contextName} folyóirat regisztrálta szakmai lektorként, mert a jövőben szeretnénk lektorálási kéréssel fordulni Önhöz, amennyiben szakértelmének megfelelő kézirat érkezik. \nHa lektori felkérést kap, lehetősége lesz megnézni a kérdéses cikk címét és absztraktját, majd elfogadhatja vagy elutasíthatja a felkérést. Bármikor kérheti, hogy távolítsuk el a szakmai lektorok listájáról.<br />\n<br />\nLétrehoztuk felhasználónevét és jelszavát, mellyel beléphet a folyóirat weboldalára. <br />\n<br />\nFelhasználónév: {$username}<br />\nJelszó: {$password}<br />\n<br />\nBelépést követően frissítheti profilját, beleértve a megadott szakterületeket is.<br />\n<br />\nÜdvözlettel,<br />\n{$principalContactSignature}', 'Ez az email az újonnan regisztrált lektoroknak kerül kiküldésre, köszöntésként és a felhasználónevük, jelszavuk elküldéséhez.'),
('REVIEWER_REGISTER', 'id_ID', 'Registrasi sebagai Reviewer di {$contextName}', 'Dengan mempertimbangkan keahlian Anda, kami memasukkan nama Anda dalam database reviewer di {$contextName}. Hal ini tidak bersifat mengikat, hanya sekedar memudahkan kami untuk mengundang Anda untuk melakukan review terhadap suatu naskah. Ketika memperoleh undangan untuk melakukan review suatu naskah, Anda dapat melihat judul dan abstrak naskah tersebut, dan Anda berhak menentukan apakah akan menerima atau menolak undangan tersebut. Anda juga dapat meminta dihapus dari daftar reviewer kapan saja Anda menghendaki.<br />\n<br />\nKami menyertakan nama pengguna dan sandi Anda, yang digunakan dalam semua interaksi dengan jurnal melalui website. Anda dapat melakukan update profil, termasuk minat review Anda.<br />\n<br />\nNama pengguna: {$username}<br />\nSandi: {$password}<br />\n<br />\nTerimakasih,<br />\n{$principalContactSignature}', 'Email ini dikirimkan ke reviewer baru untuk menyambut dan memberikan informasi nama pengguna dan sandi.'),
('REVIEWER_REGISTER', 'it_IT', 'Registrazione come revisore per {$contextName}', 'Alla luce delle tue competenze, ci siamo presi la libertà di registrare il tuo nome nella banca dati dei revisori per {$contextName}.<br />\n<br />\nQuesto non implica nessun tipo di impegno da parte tua, ma semplicemente  ci permette di contattarti per proporti la revisione di manoscritti sottoposti per la  pubblicazione per la questa testata.<br />\n<br />\nQuando ti inviteremo ad una revisione, riceverai il titolo e l''abstracts del manoscritto ed avrai l''opportunità di  accettare o rifiutare l''invito. Puoi anche chiedere in qualsiasi momento di far rimuovere il tuo nome dall''elenco dei revisori.<br />\n<br />\nDi seguito il tuo nome utente e password, che vengono usate per tutte le interazioni con la rivista attraverso il suo sito web.<br />\nSe hai modo, ti suggeriamo di  verificare le informazioni inserite e di completare il tuo profilo, inclusi i tuoi interessi di revisione.<br />\n<br />\nNome utente: {$username}<br />\nPassword: {$password}<br />\n<br />\nCon i più cordiali saluti,<br />\n{$principalContactSignature}', 'Questa email viene inviata ad un nuovo revisore quando viene registrato per la prima volta, inviandogli username e password.'),
('REVIEWER_REGISTER', 'ja_JP', 'ユーザー名『{$contextName}』で査読者として登録されました', '突然のメールをお許しください。<br />\n<br />\n貴殿の専門性に鑑み、失礼ですが私どもの雑誌『{$contextName}』の査読者データベースにあなたの名前を登録させていただきました。これによりあなたに何らかの義務が発生することはありません。ただ、できたら査読をお願いできるようにしておきたかっただけです。査読をお願いする場合は、対象となる論文のタイトルと要旨を見る機会を持っていただきます。もちろん、査読の依頼に応じるか否かの判断は常に貴殿に委ねられます。また、任意の時点で、この査読者リストから貴殿の名前を削除することもできます。<br />\n<br />\n以下に、貴殿のユーザー名とパスワードをご報告いたします。これを使用することにより、雑誌のWebサイトであらゆる処理（例えば、査読対象分野の変更など、貴殿のプロフィールの更新）を行うことができます。<br />\n<br />\nユーザー名: {$username}<br />\nパスワード: {$password}<br />\n<br />\nご協力よろしくお願いいたします。<br />\n{$principalContactSignature}', 'このメールは新規に登録された査読者に送付され、ユーザー名とパスワードが通知されます。'),
('REVIEWER_REGISTER', 'ku_IQ', 'تۆماركردن وه‌كو پێداچوونه‌وه‌ له‌گه‌ڵ  ناوی ده‌ق', 'لە ژێر ڕۆشنایی شارەزایی ئێوەدا، ئێمە ناوی تۆمان وەک هەڵسەنگێنەر تۆمار کردووە لە داتابەیسی {$contextName}.ئەمەش مانای دەستپێکردنی هیچ کارێک لە لایەن بەڕێزتانەوە ناگەیەنێت، بەڵام هەلێک بە ئێمە دەبەخشێت بۆ ئەوەی ناوتان لە لامان هەبێت لە ئەگەری بابەتێکی پەیوەندیدار بە ئێوە. لە کاتی بانگێشتکردنتان بۆ هەڵسەنگاندمن، ئێوە ناونیشان و کورتەی توێژینەوەکە دەبینن و هەمیشە دەتوانن ئەرکەکە قبوڵ یان ڕەت بکەنەوە. لە هەر کاتێکدا ئەگەر بتانەوێت، دەتوانن داوای سڕینەوەی ناوەکەتان لە سیستەمەکەماندا بکەن. <br />\n<br />\nئێمە ناوی بەکارهێنەر و وشەی تێپەڕتان بۆ دەنێرین، کە بەکار دێت بۆ کارکردن لەسەر پەڕەی گۆڤارەکەی ئێمە. تۆ هەمو کات دەتوانیت زانیارییەکانت نوێ بکەیتەوە. <br />\n<br />\nناوی بەکارهێنەر: {$username}<br />\nوشەی نهێنیی بەکارهێنەر: {$password}<br />\n<br />\nسوپاس بۆ هاوکاریتان<br />\n{$principalContactSignature}', 'ئەم ئیمەیڵە بۆ هەڵسەنگێنەرێکی نوێ نێردراوە بۆ بەخێرهێنانیان بۆ سیستەمەکە و دابینکردنی ناوی بەکارهێنەر و وشەی نهێنییەکەیان.'),
('REVIEWER_REGISTER', 'mk_MK', 'Регистрација како рецензент со {$contextName}', 'Со оглед на вашето познавање, си земавме за слобода да го регистрираме вашето име во датабазата со рецензенти на {$contextName}. Ова не наметнува никаква обврска од ваша страна, но едноставно ни овозможува да ви пријдеме со поднесок кој би можеле да го рецензирате. Откако ќе ја добиете поканата за рецензирање, ќе имате можност да ги прегледате насловот и апстрактот на трудот, и во секое време ќе можете да ја прифатите или одбиете поканата. Воедно, во кој било момент можете да побарате да го отстраниме вашето име од оваа листа на рецензенти.<br />\n<br />\nВи обезбедивме корисничко име и лозинка, кои се користат при секоја интеракција со списанието преку веб-страницата. Доколку сакате можете, на пример, да го ажурирате вашиот профил, вклучувајќи ги и областите за кои сте заинтересирани за рецензија.<br />\n<br />\nКорисничко име: {$username}<br />\nЛозинка: {$password}<br />\n<br />\nВи благодарам,<br />\n{$principalContactSignature}', 'Овој и-меил е испратен до новорегистрирани корисници со цел да ги воведе во системот и да им обезбеди запис за нивното корисничко име и лозинка.'),
('REVIEWER_REGISTER', 'nb_NO', 'Registrering som fagfelle hos {$contextName}', 'På grunn av ditt faglige omdømme, har vi tillatt oss å registrere navnet ditt i databasen over potensielle fagfeller for {$contextName}. Dette innebærer ingen form for forpliktelse fra din side, men gir oss en mulighet til å henvende oss til deg hvis vi mottar manuskript innen ditt fagfelt. Dersom du får en forespørsel om å fagfellevurdere et manuskript, vil du få mulighet til å se tittel og sammendrag for det aktuelle manuskriptet. Du vil alltid stå fritt til å akseptere eller avslå oppdraget. Du kan dessuten når som helst be om at navnet ditt blir fjernet fra listen vår over potensielle fagfeller.<br />\n<br />\nHer får du brukernavn og et passord til nettstedet vårt som kan brukes til alt arbeid med {$contextName}. Der kan du også endre profilen din, for eksempel institusjonstilhørighet og faglige interesser.<br />\n<br />\nBrukernavn: {$username}<br />\nPassord: {$password}<br />\n<br />\nPå forhånd takk.<br />\n{$principalContactSignature}', 'Denne e-posten sendes til nyregistrerte fagfeller for å ønske dem velkommen til systemet og tildele dem brukernavn og passord.'),
('REVIEWER_REGISTER', 'nl_NL', 'Registratie als Reviewer bij {$contextName}', 'Met het oog op uw expertise hebben wij de vrijheid genomen om uw naam op te nemen in de lijst met reviewers van {$contextName}. Dit verplicht u tot niets maar geeft ons de mogelijkheid u te benaderen met het verzoek eventueel een inzending te reviewen. Bij de uitnodiging krijgt u de gelegenheid de titel en samenvatting van het stuk in kwestie te bekijken. U kunt de uitnodiging te allen tijde accepteren of weigeren. U kunt ook altijd vragen om uw naam van deze lijst te laten verwijderen.<br />\n<br />\nWe geven u een gebruikersnaam en wachtwoord, die gebruikt worden voor alle interacties met de website van het tijdschrift. Zo kunt u bijvoorbeeld uw profiel bijwerken, waaronder uw review-interesses.<br />\n<br />\nGebruikersnaam: {$username}<br />\nWachtwoord: {$password}<br />\n<br />\nDank u,<br />\n{$principalContactSignature}', 'Deze e-mail wordt naar iedere nieuwe reviewer gestuurd om ze welkom te heten bij het systeem en ze van een kopie van hun gebruikersnaam en wachtwoord te voorzien.'),
('REVIEWER_REGISTER', 'pl_PL', 'Rejestracja recenzenta na stronie czasopisma {$contextName}', 'Dodaliśmy Panią/ Pana do bazy recenzentów czasopisma "{$contextName}". Dane w bazie uzupełnione są o zainteresowania naukowe zadeklarowane w procesie rejestracji. Rejestracja nie zobowiązuje do żadnych działań. Baza recenzentów wykorzystywana jest przez redakcję czasopisma do wysyłania zapytań dotyczących możliwości wykonania recenzji. Do zapytania załączany jest tytuł i abstrakt tekstu. Recenzent może przyjąć lub odrzucić prośbę redakcji. W każdym momencie może Pani/ Pan usunąć swoje dane z bazy recenzentów.<br />\n<br />\nPoniżej podajemy dane do logowania, niezbędne do pracy na stronie czasopisma. Po zalogowaniu się możliwa jest aktualizacja profilu, w tym zmiana wprowadzonych "zainteresowań naukowych". <br />\n<br />\nNazwa użytkownika: {$username} <br />\nHasło: {$password} <br />\n<br />\nZ wyrazami szacunku, <br />\n{$principalContactSignature}', 'Wiadomość jest wysyłana do nowych recenzentów, celem powitania ich i przesłania danych do logowania.'),
('REVIEWER_REGISTER', 'pt_BR', 'Cadastrado como Avaliador em {$contextName}', 'Devido à sua experiência, tomamos a liberdade de cadastrar seu nome no banco de dados de avaliadores para {$contextName}. Isso não implica qualquer forma de compromisso de sua parte, mas simplesmente nos permite lhe contatar com uma submissão para uma possível avaliação. Ao ser convidado(a) a avaliar, você terá a oportunidade de ver o título e o resumo do artigo em questão e poderá sempre aceitar ou recusar o convite. Você também pode pedir a qualquer momento para remover seu nome desta lista de avaliadores.<br />\n<br />\nEstamos fornecendo a você um nome de usuário e senha, que são usados em todas as interações com o periódico por meio de seu site. Você pode, por exemplo, atualizar seu perfil, incluindo seus interesses de avaliação.<br />\n<br />\nUsuário: {$username}<br />\nSenha: {$password}<br />\n<br />\nAtenciosamente,<br />\n{$principalContactSignature}', 'Esta mensagem é enviada a um avaliador recém-cadastrado para dar-lhe as boas-vindas e deixar registrado o seu nome de login e senha.'),
('REVIEWER_REGISTER', 'pt_PT', 'Registo como Revisor na revista {$contextName}', 'Tendo em consideração o conhecimento excecional na sua área de investigação/intervenção, tomamos a liberdade de registá-lo na base de dados de revisores da nossa revista, {$contextName}. Esta ação não implica nenhum compromisso da sua parte, mas simplesmente nos permite abordá-lo para uma possível revisão de uma submissão. Ao ser convidado para efetuar uma revisão, terá acesso ao título e resumo do artigo em questão, e pode sempre aceitar ou recusar o convite. A qualquer momento pode pedir-nos para remover o seu nome da lista de revisores.<br /><br />\nOs seus dados de acesso, nome de utilizador e senha, utilizados para interagir com o website desta revista, estão incluídos nesta mensagem. Pode por exemplo atualizar o seu perfil, incluindo os seus interesses de revisão.<br />\n<br />\nNome de utilizador: {$username}<br />\nSenha: {$password}<br />\n<br />\nAgradecendo desde já a atenção dispensada,<br />\n{$principalContactSignature}', 'Mensagem de boas-vindas enviada a novo revisor registado no sistema, com nome de utilizador e senha para acesso.'),
('REVIEWER_REGISTER', 'ro_RO', 'Înregistrarea ca evaluator pentru {$contextName}', 'Având în vedere expertiza dvs., ne-am luat libertatea de a vă înregistra numele în baza de date pentru recenzori {$contextName}. Acest lucru nu implică nicio formă de angajament din partea dvs., ci ne permite pur și simplu să vă abordăm cu o rugăminte pentru examina un manuscris. După ce sunteți invitați să revizuiți, veți avea ocazia să vedeți titlul și rezumatul lucrării în cauză și veți fi întotdeauna în măsură să acceptați sau să refuzați invitația. De asemenea, puteți cere în orice moment să vă fie eliminat numele din această listă.<br />\n<br />\nVă oferim un nume de utilizator și o parolă, care este utilizată în toate interacțiunile cu jurnalul prin intermediul site-ului său web. Poate doriți, de exemplu, să vă actualizați profilul, inclusiv interesele dvs. de examinare.<br />\n<br />\nNume de utilizator: {$username}<br />\nParolă: {$password}<br />\n<br />\nMulțumesc,<br />\n{$principalContactSignature}', 'Acest e-mail este trimis unui revizor înregistrat pentru a-i ura bun venit în sistem și pentru a-i furniza o înregistrare a numelui de utilizator și a parolei.'),
('REVIEWER_REGISTER', 'ru_RU', 'Регистрация в качестве рецензента в журнале «{$contextName}»', 'Принимая во внимание Ваш опыт, мы взяли на себя смелость зарегистрировать Вас в базе данных потенциальных рецензентов для журнала «{$contextName}». Это не налагает на Вас никаких обязательств, а просто позволяет нам обращаться к Вам при поступлении в наш журнал материалов, рецензентом которых Вы могли бы стать. Получив предложение дать рецензию, Вы сможете увидеть название и аннотацию рукописи в запросе, и у Вас всегда будет возможность принять или отклонить это предложение. Вы также, в любой момент, можете попросить, чтобы мы удалили Ваше имя из этого списка рецензентов.<br />\n<br />\nМы высылаем Вам имя пользователя и пароль, которые используются при любом взаимодействии с нашим журналом через веб-сайт. Например, Вы можете откорректировать свои данные в профиле пользователя, указав интересующую Вас как рецензента тематику.<br />\n<br />\nИмя пользователя: {$username}<br />\nПароль: {$password}<br />\n<br />\nС уважением,<br />\n{$principalContactSignature}', 'Это письмо отправляется вновь зарегистрированному рецензенту, приветствуя его в системе и сообщая ему имя пользователя и пароль для доступа к сайту.'),
('REVIEWER_REGISTER', 'sk_SK', 'Zaregistrovaný na pozícii recenzenta pre {$contextName}', 'S ohľadom na Vašu odbornosť sme si Vás dovolili zaregistrovať do databázy recenzentov pre časopis {$contextName}. To Vás nezaväzuje k žiadnej zodpovednosti, len nám to umožní Vás rýchlo kontaktovať s príspevkom, ktorý by ste mohli prípadne recenzovať. Pokiaľ Vás prizveme na spracovanie recenzie, budete mať príležitosť vidieť názov a abstrakt daného príspevku a vždy budete v pozícii, kedy môžete rozhodnúť, či prizvanie prijmete alebo odmietnete. Môžete tiež kedykoľvek požiadať o odstránenie Vášho mena zo zoznamu recenzentov.<br />\n<br />\nPridelili sme Vám používateľské meno a heslo, ktoré budete používať na internetových stránkach časopisu. Možno budete chcieť napríklad upraviť svoj profil alebo rozsah záujmu o spracovanie recenzií.<br />\n<br />\nPoužívateľské meno: {$username}<br />\nHeslo: {$password}<br />\n<br />\nĎakujeme,<br />\n{$principalContactSignature}', 'Tento email je zaslaný novo zaregistrovanému recenzentovi ako privítanie do systému a poskytne mu informáciu o jeho používateľskom mene a hesle.'),
('REVIEWER_REGISTER', 'sl_SI', 'Registracija kot recenzent pri reviji {$contextName}', 'V luči vašega znanja smo si dovolili registrirati vaše ime v bazo recenzentov za revijo {$contextName}. To ne pomeni nobene obveze z vaše strani in nam le omogoča, da vas lahko povabimo k recenziji prispevkov. Ko boste povabljeni k recenziji, boste lahko videli naslov in povzetek prispevka in se boste lahko odločili ali sodelujete v recenziji ali ne. Kadarkoli lahko zahtevate, da vas odstranimo iz seznama recenzentov.<br />\n<br />\nPošiljamo vam uporabniško ime in geslo, ki ju potrebujete za vso interakcijo s revijo preko spleta. Če želite lahko posodobite vaš račun, vključno z recenzentskimi interesi.<br />\n<br />\nUporabniško ime: {$username}<br />\nGeslo: {$password}<br />\n<br />\nLepa hvala,<br />\n{$principalContactSignature}', 'Email se pošlje novo registriranim recenzentom kot dobrodošlica, skupaj z uporabniškim imenom in geslom za dostop do spletišča revije.'),
('REVIEWER_REGISTER', 'sv_SE', 'Registrering som granskare hos {$contextName}', 'Baserat på den ämnesexpertis du besitter har vi tagit oss friheten att registrera ditt namn i granskardatabasen hos {$contextName}. Detta innebär inga förplikelser från din sida utan innebär endast att vi har möjlighet att höra av oss till dig med ett potentiellt granskningsuppdrag. I samband med inbjudan till granskning kommer du att kunna se titel och abstract för artikeln i fråga och du har alltid möjlighet att antingen acceptera eller avböja inbjudan. Du kan även när som helst be om att få ditt namn bortplockat från listan över granskare.<br />\n<br />\nHär förser vi dig med användarnamn och lösenord, som används i all interaktion med tidskriften via webbplatsen. Till exempel kan du logga in och uppdatera din profil och ange intresseområden för granskning.<br />\n<br />\nAnvändarnamn: {$username}<br />\nLösenord: {$password}<br />\n<br />\nVänligen,<br />\n{$principalContactSignature}', 'Det här e-postmeddelandet skickas till nyregistrerade granskare för välkomna dem till systemet och förse dem med dokumentation på deras användarnamn och lösenord.'),
('REVIEWER_REGISTER', 'tr_TR', '{$ContextName} ile Hakem Olarak Kayıt', 'Uzmanlık alanınız ışığında, adınızı  {$contextName} için hakem veri tabanına kaydettik. Bu sizi herhangi bir katkı yapma zorunluluğu altına sokmaz; ancak değerlendirilmek üzere size bir başvuru göndermemizi sağlar. Değerlendirmesi istenecek makalenin başlığını ve özetini görme olanağı sağlar. Daveti kabul etmek veya reddetmek sizin tasarrufunuzdadır. Ayrıca, dilediğiniz zaman adınızın değerlendirme listesinden kaldırılmasını isteyebilirsiniz.<br />\n<br />\nWeb sitesi üzerinden, dergi ile ilgili tüm işlemler için kullanılan bir kullanıcı adı ve şifre sunuyoruz. Örneğin, bu şifre ile ilgi alanlarınızı ve profilinizi güncelleyebilirsiniz.<br />\n<br />\nKullanıcı adı: {$username}<br />\nŞifre: {$password}<br />\n<br />\nSaygılarımızla,<br />\n{$principalContactSignature}', 'Bu e-posta, yeni kayıt olan bir hakeme, sisteme hoş geldiniz mesajı ile birlikte kullanıcı adı ve şifresini iletmek için gönderilir.'),
('REVIEWER_REGISTER', 'uk_UA', 'Реєстрація рецензента видання {$contextName}', 'З огляду на Ваш досвід, ми взяли на себе сміливість внести Ваше ім''я до бази даних рецензентів видання {$contextName}. Це не передбачає жодних зобов''язань з Вашого боку, а лише дозволяє нам розглядати Вас як можливого рецензента рукописів, що подаються до нашого журналу. Під час запрошень на проведення рецензування, Ви матимете можливість бачити назву та анотацію рукопису, про який йтиме мова, і, розглянувши цю інформацію, Ви завжди зможете прийняти або відхилити запрошення. Крім того, в будь-який час Ви можете вимагати видалення свого імені з цього списку рецензентів.<br />\n<br />\nМи надаємо Вам ім''я користувача та пароль, які будуть необхідні Вам упродовж усієї подальшої роботи з журналом через його веб-сайт. Серед іншого, Ви можете оновити свій профіль та вказати власні наукові інтереси.<br />\n<br />\nІм''я користувача: {$username}<br />\nПароль: {$password}<br />\n<br />\nДякую,<br />\n{$principalContactSignature}', 'Цей лист надсилається новому зареєстрованому рецензенту для того, щоб повідомити йому про реєстрацію та надіслати його ім''я користувача та пароль.'),
('REVIEWER_REGISTER', 'vi_VN', 'Đăng ký làm Người phản biện cho {$contextName}', 'Dựa theo chuyên môn của bạn, chúng tôi đã tự đăng ký tên của bạn trong cơ sở dữ liệu của người phản biện cho {$contextName}. Điều này không đòi hỏi bất kỳ hình thức cam kết nào từ phía bạn, mà chỉ cho phép chúng tôi tiếp cận bạn với một bài gửi để bạn có thể nhận xét. Khi được mời nhận xét, bạn sẽ có thể xem tiêu đề và tóm tắt của bài báo đang đề cập và bạn sẽ có thể chấp nhận hoặc từ chối lời mời. Bạn cũng có thể yêu cầu bất cứ lúc nào để xóa tên của bạn khỏi danh sách phản biện.<br />\n<br />\nChúng tôi đang cung cấp cho bạn username và mật khẩu, được sử dụng trong tất cả các tương tác với tạp chí thông qua trang web. Bạn có thể muốn, ví dụ, để cập nhật hồ sơ của bạn, bao gồm cả lĩnh vực mà bạn đang quan tâm.<br />\n<br />\nUsername: {$username}<br />\nPassword: {$password}<br />\n<br />\nTrân trọng,<br />\n{$principalContactSignature}', 'Email này được gửi đến một người phản biện mới đăng ký để chào đón họ vào hệ thống và cung cấp cho họ một username và mật khẩu của họ.'),
('REVIEWER_REGISTER', 'zh_CN', '在《{$contextName}》注册为审稿人', '基于您的经验, 我们已经注册您的名字到期刊《{$contextName}》的审稿人数据库. 这并不意味着您那方面的任何形式的承诺，只代表我们可以通知您相关投稿的审阅. 在被邀请审稿时，您可以看到稿件的标题和摘要，您可以作出是否对稿件进行审阅的决定。您也可以在任何时候请求从审稿人列表中移除您的名字.<br />\n<br />\n我们将提供给您用户名和密码，用于您所有在本期刊网站的活动。例如，您可以更新您的账户信息，或者更改您的审稿方向.<br />\n<br />\n用户名： {$username}<br />\n密码： {$password}<br />\n<br />\n谢谢您，<br />\n{$principalContactSignature}', '这封电子邮件发送给新注册的审稿人，欢迎他们的加入并提供关于他们的用户名和密码的记录。'),
('REVIEW_ACK', 'ar_IQ', 'إشعار تحكيم المؤلَّف', '{$reviewerName}:<br />\n<br />\nنشكر إكمالك لتحكيم المؤلَّف الموسوم &quot;{$submissionTitle},&quot; والمرسل إلى {$contextName}. إننا نقدر لك مشاركتك في ترصين الأعمال التي تنشرها مجلتنا.', 'هذه الرسالة يصدرها محرر القسم لتأكيد استلامه لتقييمات وملاحظات المحكم الكاملة، وليشكره على مساهمته في عملية التحكيم.'),
('REVIEW_ACK', 'bs_BA', 'Zaprimljena recenzija članka', 'Poštovana/i {$reviewerName},<br />\n<br />\nhvala vam što ste izradili recenziju članka &quot;{$submissionTitle}&quot; za časopis {$contextName}. Cijenimo vaš doprinos kvaliteti radova objavljenih u našem časopisu.<br />\n<br />\nSrdačno,', 'Ovim obrascem e-pošte  urednik rubrike potvrđuje recenzentu primitak završene recenzije.'),
('REVIEW_ACK', 'ca_ES', 'Justificant de recepció de la revisió de l''article', 'Benvolgut/uda {$reviewerName},<br />\n<br />\nUs agraïm que hàgiu revisat la tramesa &quot;{$submissionTitle}&quot; per a {$contextName}. Valorem la vostra contribució a la qualitat de les obres que publiquem.', 'Aquest missatge de correu electrònic té un editor de secció com a remitent i s''envia al revisor per a confirmar-li la recepció d''una revisió completada i agrair-li la seva contribució.'),
('REVIEW_ACK', 'cs_CZ', 'Poděkování za zpracování recenze článku', '{$reviewerName}:<br />\n<br />\nDěkujeme za dokončení recenze příspěvku &quot;{$submissionTitle}&quot; pro {$contextName}. Vážíme si Vaší práce vedoucí ke zkvalitnění článků, které publikujeme.', 'Tento email posílá editor sekce, aby potvrdil přijetí zpracované recenze a poděkoval recenzentovi za jeho práci.'),
('REVIEW_ACK', 'da_DK', 'Bekræftelse af bedømmelse af artikel', '{$reviewerName}:<br />\n<br />\nTak, fordi du har fuldført bedømmelsen af manuskriptet &quot;{$submissionTitle}&quot; til {$contextName}. Vi påskønner dit bidrag til kvaliteten af de artikler, vi publicerer.', 'Denne e-mail sendes af sektionsredaktøren for at bekræfte modtagelsen af en fuldført bedømmelse og takker bedømmeren for sit bidrag.'),
('REVIEW_ACK', 'de_DE', 'Eingangsbestätigung für ein Gutachten', '{$reviewerName},<br />\n<br />\nvielen Dank für Ihr Gutachten zum Beitrag &quot;{$submissionTitle}&quot; für {$contextName}. Ihre Stellungnahme ist eine wichtige Unterstützung für unsere Bemühungen um die Qualität der von uns veröffentlichten Arbeiten.', 'Diese E-Mail wird von eine/r Rubrikredakteur/in gesendet, um den Empfang eines abgeschlossenen Gutachtens zu bestätigen und um der Gutachterin/dem Gutachter für die Mitwirkung zu danken.'),
('REVIEW_ACK', 'el_GR', 'Επιβεβαίωση υποβολής αξιολόγησης', '{$reviewerName}:<br />\n<br />\nΣας ευχαριστούμε που ολοκληρώσατε την αξιολόγηση της υποβολής &quot;{$submissionTitle},&quot; για το περιοδικό {$contextName} και για τη συμβολή σας στην ποιότητα του περιεχομένου που δημοσιεύουμε.', 'Το παρόν μήνυμα αποστέλλεται από τον Επιμελητή Ενότητας στον Αξιολογητή, ως επιβεβαίωση τη λήψης της ολοκληρωμένης αξιολόγησης.'),
('REVIEW_ACK', 'en_US', 'Article Review Acknowledgement', '{$reviewerName}:<br />\n<br />\nThank you for completing the review of the submission, &quot;{$submissionTitle},&quot; for {$contextName}. We appreciate your contribution to the quality of the work that we publish.', 'This email is sent by a Section Editor to confirm receipt of a completed review and thank the reviewer for their contributions.'),
('REVIEW_ACK', 'es_ES', 'Acuse de recibo de revisión de artículo', '{$reviewerName}:<br />\n<br />\nGracias por completar la revisión del envío &quot;{$submissionTitle},&quot; para {$contextName}. Apreciamos su contribución a la calidad de los trabajos que publicamos.', 'Este correo enviado por el/la Editor/a de Sección para confirmar la recepción de una revisión completada y agradecer al / a la revisor/a su contribución.'),
('REVIEW_ACK', 'eu_ES', 'Artikuluaren ebaluazioaren hartu-agiria', '{$reviewerName}:<br />\n<br />\nEskerrik asko {$contextName} aldizkarirako &quot;{$submissionTitle}&quot; artikuluaren ebaluazioa egiteagatik. Zinez estimatzen dugu argitaratzen ditugun lanen kalitatea hobetzeko egiten diguzun ekarpena.', 'Mezu hau Ataleko editoreak Ebaluatzaileari bidaltzen dio, ebaluazio-txostena jaso duela esateko eta eskerrak emateko.'),
('REVIEW_ACK', 'fa_IR', 'قدردانی بخاطر بررسی مقاله', '{$reviewerName}:<br />\n<br />\nبرای بررسی مقاله ارسالی &quot;{$submissionTitle}&quot;مربوط به {$contextName}، از شما سپاسگزاریم. مساعدت شما را که باعث ارتقاء سطح کیفی مقاله ای که چاپ شد، ارج می نهیم.', 'This email is sent by a Section Editor to confirm receipt of a completed review and thank the reviewer for their contributions.'),
('REVIEW_ACK', 'fi_FI', 'Artikkelin arviointi vastaanotettu', 'Hyvä {$reviewerName},<br />\n<br />\nKiitos käsikirjoituksen &quot;{$submissionTitle}&quot; arvioimisesta julkaisulle {$contextName}. Arvostamme panostanne julkaisemamme työn laadun hyväksi.', 'This email is sent by a Section Editor to confirm receipt of a completed review and thank the reviewer for their contributions.'),
('REVIEW_ACK', 'fr_CA', 'Accusé de réception de l''évaluation d''une soumission', '{$reviewerName},<br />\n<br />\nNous vous remercions d''avoir évalué la soumission intitulée « {$submissionTitle} » pour la revue {$contextName}. Nous vous sommes reconnaissants de votre contribution à la qualité des travaux que nous publions.', 'Ce courriel est envoyé par le,la rédacteur-trice de rubrique, pour accuser réception d''une évaluation terminée et remercier l''évaluateur-trice de sa contribution.'),
('REVIEW_ACK', 'fr_FR', 'Accusé de réception de l''évaluation d''une soumission', '{$reviewerName}:<br />\n<br />\nNous vous remercions d''avoir évalué la soumission intitulée « {$submissionTitle} » pour {$contextName}. Nous vous sommes reconnaissants de votre contribution à la qualité des travaux que nous publions.', 'Ce courriel est envoyé par le Rédacteur de rubrique, pour accuser réception d''une évaluation terminée et remercier le rapporteur de sa contribution.'),
('REVIEW_ACK', 'gd_GB', 'Freagairt mu lèirmheas artaigil', '{$reviewerName}:<br />\n<br />\nMòran taing airson an lèirmheas air an tagradh “{$submissionTitle},” airson {$contextName} a choileanadh. Tha sinn fada nad chomain airson na h-obrach a nì thu airson na dh’fhoillsicheas sinn a chumail aig ìre àrd.', 'Thèid am post-d seo a chur le deasaiche earrainn a dhearbhadh gun d’fhuair iad lèirmheas a chaidh a choileanadh agus airson taing a thoirt dhan lèirmheasaiche airson an cuid com-pàirteachais.'),
('REVIEW_ACK', 'he_IL', 'אישור סקירת מאמר', '{reviewerName$}:\n\n<br />\n\nתודה על חוות דעתך על ההגשה "{submissionTitle$} ל{contextName$}. אנו מעריכים את תרומתך לאיכות העבודה שאנו מפרסמים.', 'דוא"ל זה נשלח על ידי עורך מדור כדי לאשר את קבלת חוות הדעת ולהודות לסוקר על התרומות שלהם.'),
('REVIEW_ACK', 'hi_IN', 'लेख समीक्षा आभार', '{$reviewerName}:<br />\n<br />\nसबमिशन की समीक्षा को पूरा करने के लिए धन्यवाद, &quot;{$submissionTitle},&quot; for {$contextName}. हम आपके द्वारा प्रकाशित किए जाने वाले कार्य की गुणवत्ता में आपके योगदान की सराहना करते हैं.', 'यह ईमेल एक अनुभाग संपादक द्वारा एक पूर्ण समीक्षा की प्राप्ति की पुष्टि करने के लिए भेजा जाता है और समीक्षक को उनके योगदान के लिए धन्यवाद देता है.'),
('REVIEW_ACK', 'hr_HR', 'Zaprimljena recenzija članka', 'Poštovana/i {$reviewerName},<br />\n<br />\nhvala vam što ste izradili recenziju članka &quot;{$submissionTitle}&quot; za časopis {$contextName}. Cijenimo vaš doprinos kvaliteti radova objavljenih u našem časopisu.<br />\n<br />\nSrdačno,', 'Ovim obrascem e-pošte  urednik rubrike potvrđuje recenzentu primitak završene recenzije.'),
('REVIEW_ACK', 'hu_HU', 'Szakmai lektorálás elfogadása', 'Tisztelt {$reviewerName}!<br />\n<br />\nKöszönjük, hogy elkészítette a(z) {$contextName} folyóirathoz beküldött &quot;{$submissionTitle},&quot; című kézirat szakmai bírálatát.<br />\n<br />\nÜdvözlettel,<br />\n{$editorialContactSignature}', 'Ezt az emailt a Rovatszerkesztő küldi válaszul a kész szakértői véleményre és megköszöni a Szakmai Lektornak az együttműködést.'),
('REVIEW_ACK', 'id_ID', 'Ucapan Terimakasih atas Review Artikel', '{$reviewerName}:<br />\n<br />\nTerimakasih telah menyelesaikan review terhadap naskah, &quot;{$submissionTitle},&quot; untuk {$contextName}. Kami sangat menghargai kontribusi Anda terhadap kualitas karya yang kami publikasikan.', 'Email ini dikirimkan Editor Bagian untuk mengkonfirmasi penerimaan review dan mengucapkan terimakasih atas kontribusinya.'),
('REVIEW_ACK', 'it_IT', 'Ringraziamenti per la revisione', 'Gentile {$reviewerName}:<br />\n<br />\nGrazie per aver completato la revisione del manoscritto &quot;{$submissionTitle},&quot; per {$contextName}. Apprezziamo il tuo contributo nel mantenere alta la qualità della rivista.', 'Questa email viene inviata dal section editor per confermare la ricezione di una revisione completata e per ringraziare i revisori per i loro contributi.'),
('REVIEW_ACK', 'ja_JP', '論文査読のお礼', '{$reviewerName}様:<br />\n<br />\n雑誌『{$contextName}』への投稿原稿「{$submissionTitle}」の査読をしていただき、ありがとうございました。本誌が発行する論文の品質向上に対する貴殿の貢献に対し感謝いたします。', 'このメールは、セクションエディタから査読者に査読が完了したことを確認し、その貢献に感謝するものです。'),
('REVIEW_ACK', 'ku_IQ', 'زانیارییەکانی هەڵسەنگاندنی توێژینەوە', '{$reviewerName}:<br />\n<br />\nسوپاس بۆ تەواوکردنی هەڵسەنگاندنی, &quot;{$submissionTitle},&quot; بۆ {$contextName}. ئێمە سوپاسی ماندوبونی ئێوە دەکەین بۆ پێشخستنی ئەو بابەتانەی کە ئێمە بڵاویان دەکەینەوە.', 'ئەم ئیمەیڵە لە لایەن سەرنوسەری بەشەوە بۆ هەڵسەنگێنەر نێردراوە بۆ سوپاسکردنیان و هاوکارییان لە هەڵسەنگاندنی توێژینەوەیەکدا.'),
('REVIEW_ACK', 'mk_MK', 'Потврда за рецензија на наслов', '{$reviewerName}:<br />\n<br />\nВи благодариме што ја завршивте рецензијата на поднесокот, &quot;{$submissionTitle},&quot; за {$contextName}. Го цениме вашиот придонес кон квалитетот на трудовите кои ги објавуваме.', 'Овој и-меил е испратен од Секциски уредник за да потврди дека изработената рецензија е примена и да се му заблагодари на рецензентот за неговиот придонес.'),
('REVIEW_ACK', 'nb_NO', 'Bekreftelse på fullført fagfellevurdering', '{$reviewerName}:<br />\n<br />\nTakk for at du har fullført vurderingen av manuskriptet «{$submissionTitle}» for {$contextName}. Vi setter stor pris på at du bidrar til å sikre den faglige kvaliteten på artiklene vi publiserer.', 'Denne e-posten sendes av en seksjonsredaktør for å bekrefte at fagfellevurderingen er mottatt, og takke fagfellen for innsatsen.'),
('REVIEW_ACK', 'nl_NL', 'Artikel review bevestiging', '{$reviewerName}:<br />\n<br />\nDank u voor uw review van de inzending &quot;{$submissionTitle}&quot; voor {$contextName}. We waarderen uw bijdrage aan de kwaliteit van het werk dat wij publiceren.', 'Deze e-mail wordt door de sectieredacteur verstuurd om de ontvangst van een review te bevestigen en de reviewer te bedanken voor zijn bijdrage.'),
('REVIEW_ACK', 'pl_PL', 'Podziękowanie za wykonanie recenzji', 'Szanowna Pani/ Szanowny Panie,<br />\n<br />\ndziękujemy za wykonanie recenzji tekstu &quot;"{$submissionTitle}"&quot;, zgłoszonego do czasopisma "{$contextName}". Doceniamy Pani/ Pana wkład w budowanie jakości naszego czasopisma.\nZ wyrazami szacunku.', 'Ta wiadomość jest przesyłana przez redaktora prowadzącego do recenzenta. Zawiera potwierdzenie otrzymania recenzji i podziękowanie za wykonaną pracę.'),
('REVIEW_ACK', 'pt_BR', 'Agradecimento pela avaliação', '{$reviewerName}:<br />\n<br />\nAgradeço por enviar o parecer da submissão &quot;{$submissionTitle},&quot; para o periódico {$contextName}. Nós apreciamos sua contribuição para manter a qualidade dos trabalhos que publicamos.', 'Mensagem enviada pelo Editor de Seção ao Avaliador para confirmar recebimento e agradecer o avaliador pela conclusão da avaliação.'),
('REVIEW_ACK', 'pt_PT', 'Agradecimento pela revisão', '{$reviewerName}:<br />\n<br />\nAgradecemos ter concluído a revisão da submissão &quot;{$submissionTitle}&quot; à revista {$contextName}. A sua contribuição é fundamental para a qualidade dos trabalhos publicados.', 'Este e-mail é enviado pelo Editor de Secção ao Revisor para confirmar a receção e agradecer ao revisor pela conclusão da revisão.'),
('REVIEW_ACK', 'ro_RO', 'Recunoaștere revizuire articol', '{$reviewerName}:<br />\n<br />\nVă mulțumim pentru finalizarea reviziei manuscrisului, &quot;{$submissionTitle},&quot; pentru {$contextName}. Apreciem contribuția dvs. semnificativă la calitatea revistei pe care o publicăm.', 'Acest e-mail este trimis de un editor de secțiune pentru a confirma primirea unei evaluări finalizate și pentru a mulțumi revizorului pentru contribuția sa.'),
('REVIEW_ACK', 'ru_RU', 'Подтверждение получения рецензии', 'Здравствуйте, {$reviewerName}!<br />\n<br />\nБлагодарю Вас за рецензию на материал «{$submissionTitle}» для журнала «{$contextName}». Мы ценим Ваш вклад в качество работы, которую мы публикуем.', 'Это письмо отправляется редактором раздела в качестве подтверждения получения рецензии на статью и благодарности рецензенту за его вклад.'),
('REVIEW_ACK', 'sk_SK', 'Poďakovanie za spracovanie recenzie článku', '{$reviewerName}:<br />\n<br />\nDakujeme za dokončenie recenzie príspevku &quot;{$submissionTitle}&quot; pre {$contextName}. Vážime si Vašej práce vedúcej k skvalitneniu článkov, ktoré publikujeme.', 'Tento email posiela editor sekcie, aby potvrdil prijatie spracovanej recenzie a poďakoval recenzentovi za jeho prácu.'),
('REVIEW_ACK', 'sl_SI', 'Zahvala za recenzijo prispevka', '{$reviewerName}:<br />\n<br />\nHvala za dokončanje recenzije prispevka, &quot;{$submissionTitle},&quot; za revijo {$contextName}. Zahvaljujemo se za vaš prispevek k kvaliteti del, ki jih objavljamo.', 'Ta email pošlje uredenik rubrike recenzentu kot potrditev opravljene recenzije in zahvala zanjo.'),
('REVIEW_ACK', 'sv_SE', 'Bekräftelse på granskning av artikel', '{$reviewerName}:<br />\n<br />\nTack för att du genomfört granskningen av bidraget &quot;{$submissionTitle}&quot; för {$contextName}. Vi uppskattar ditt arbete din roll i att bibehålla tidskriftens kvalitet.', 'Det här e-postmeddelandet skickas från en sektionsredaktör för att bekräfta att en färdig granskning inkommit och för att tacka granskaren för utfört arbete.'),
('REVIEW_ACK', 'tr_TR', 'Değerlendirme İçin Teşekkür', 'Sayın {$reviewerName},<br />\n<br />\n{$contextName} adlı dergide yayınlanması için değerlendirilmek üzere gönderilen &quot;{$submissionTitle}&quot; başlıklı çalışmanın değerlendirme işlemini tamamladığınız için teşekkür ederiz. Yayınımıza yaptığınız katkıyı takdirle anıyoruz.', 'Bu elektronik posta gözden geçirme işlemi bitirilen makalenin alındığını haber vermek ve gözden geçirmeyi yapan kişiye katkılarından dolayı teşekkür etmek için Bölüm Editörü tarafından gönderilmiştir.'),
('REVIEW_ACK', 'uk_UA', 'Подяка за рецензування статті', '{$reviewerName}:<br />\n<br />\nДякую за закінчення рецензування подання &quot;{$submissionTitle}&quot; для видання &quot;{$contextName}&quot;. Ми цінуємо Ваш внесок у контроль якості роботи, поданої нам для публікації.', 'Цим листом редактор розділу підтверджує отримання готової рецензії та дякує рецензенту за його внесок.'),
('REVIEW_ACK', 'vi_VN', 'Lời cảm ơn về việc đánh giá bài báo', 'Kính gửi {$reviewerName},<br />\n<br />\nCảm ơn bạn đã hoàn thành việc đánh giá bài gửi, &quot;{$submissionTitle},&quot; cho {$contextName}. Chúng tôi đánh giá cao sự đóng góp của bạn cho chất lượng ấn phẩm mà chúng tôi xuất bản.', 'Email này được gửi bởi một Biên tập viên chuyên mục để xác nhận đã nhận được bản đánh giá và cảm ơn người phản biện về những đóng góp của họ.');
INSERT INTO `email_templates_default_data` VALUES
('REVIEW_ACK', 'zh_CN', '文章审查感谢函', '{$reviewerName}:<br />\n<br />\n感谢您为《{$contextName}》完成了稿件〈{$submissionTitle}〉的审查工作。我们非常感激您对我们出版文章之品质的重要贡献。', '这封电子邮件是由一位区段编辑发出，确认收到已完成审查工作的回条，并感谢审查人之贡献。'),
('REVIEW_CANCEL', 'ar_IQ', 'إلغاء إلتماس التحكيم', '{$reviewerName}:<br />\n<br />\nحالياً، قررنا إلغاء إلتماسنا لكم بتحكيم المؤلَّف الموسوم &quot;{$submissionTitle},&quot; والمرسل إلى {$contextName}. نحن نعتذر عن أي إزعاج قد يسببه ذلك لحضرتكم، ونأمل التواصل معكم مستقبلاً فيما يتعلق بتحكيم طلبات النشر المرسلة إلى هذه المجلة العلمية.<br />\n<br />\nإن كانت لديكم أي استفسارات، لطفاً، إتصلوا بي.', 'هذه الرسالة يعنونها محرر القسم إلى المحكم الذي بحيازته طلب تقديم قيد المعالجة لإبلاغه بانتفاء الحاجة إلى تقييمه.'),
('REVIEW_CANCEL', 'bs_BA', 'Povlačenje zamolbe za recenziju', 'Poštovana/i {$reviewerName},<br />\n<br />\ns obzirom na okolnosti, odlučili smo povući zamolbu da izvršite recenziju članka &quot;{$submissionTitle}&quot; za časopis {$contextName}. Nadamo se da ćemo vam se u budućnosti ponovno moći obratiti da vašom recenzijom pridonesete ovom časopisu.<br />\n<br />\nSrdačno.', 'Ovim obrascem e-pošte urednik rubrike recenzenta obavještava o povlačenju zahtjeva za izradu recenzije za koju je prethodno recenzent bio zadužen ili koja je recenzentu bila ponuđena.'),
('REVIEW_CANCEL', 'ca_ES', 'Sol·licitud de revisió cancel·lada', 'Benvolgut/uda {$reviewerName},<br />\n<br />\nHem decidit cancel·lar la nostra sol·licitud perquè reviseu la tramesa &quot;{$submissionTitle}&quot; per a {$contextName}. Lamentem les molèsties que us pugui causar aquesta decisió i confiem tornar a sol·licitar els vostres serveis de revisió per a aquesta revista en el futur.<br />\n<br />\nSi teniu qualsevol consulta, no dubteu a fer-me-la arribar.', 'Aquest missatge de correu electrònic té com a remitent l''editor de secció i s''envia a un revisor que estigui revisant una tramesa per a notificar-li que aquesta tasca ha estat cancel·lada.'),
('REVIEW_CANCEL', 'cs_CZ', 'Žádost o zrušení recenze', '{$reviewerName}:<br />\n<br />\nV tomto bodě jsme se rozhodli odvolat naši žádost, abyste pro nás zpracoval recenzi příspěvku &quot;{$submissionTitle}&quot; pro {$contextName}. Omlouváme se za veškeré nepříjemnosti, které by Vám to mohlo způsobit, a doufáme, že Vás budeme moci oslovit ohledně recenzních řízení tohoto časopisu v budoucnu.<br />\n<br />\nV případě, že budete mít jakékoliv dotazy, mě prosím kontaktujte.', 'Tento email zasílá editor sekce recenzentovi, který má rozpracovanou recenzi, aby mu oznámil, že požadavek na zpracování recenze byl zrušen.'),
('REVIEW_CANCEL', 'da_DK', 'Annullering af forespørgsel om bedømmelse', '{$reviewerName}:<br />\n<br />\nPå nuværende tidspunkt har vi valgt at annullere vores forespørgsel til dig om at bedømme manuskriptet &quot;{$submissionTitle}&quot; til {$contextName}. Vi beklager den ulejlighed, dette eventuelt måtte forårsage, og vi håber, at vi må henvende os til dig i fremtiden og bede om din assistance i forbindelse med dette tidsskrifts bedømmelsesproces.<br />\n<br />\nHvis du har spørgsmål, er du velkommen til at kontakte mig.', 'Denne e-mail sendes af sektionsredaktøren til en bedømmer, som er ved at bedømme et manuskript, og underretter vedkommende om, at bedømmelsen er blevet annulleret.'),
('REVIEW_CANCEL', 'de_DE', 'Rücknahme einer Bitte um ein Gutachten', '{$reviewerName},<br />\n<br />\nwir haben uns entschieden, unsere Anfrage nach einem Gutachten für den Beitrag &quot;{$submissionTitle}&quot; für {$contextName} zurückzuziehen. Verzeihen Sie bitte die Ihnen dadurch evtl. entstandenen Unannehmlichkeiten. Wir hoffen, dass wir weiterhin auf Ihre Hilfe als Gutachter/in für die Zeitschrift zählen können.<br />\n<br />\nFalls Sie Fragen haben, können Sie sich gerne an mich wenden.', 'Diese E-Mail wird von der/dem Rubrikredakteur/in an eine/n Gutachter/in gesendet, die an einem Gutachten arbeiten, um sie darüber zu informieren, dass das Gutachten abgesagt worden ist.'),
('REVIEW_CANCEL', 'el_GR', 'Ακύρωση αιτήματος για αξιολόγηση', '{$reviewerName}:<br />\n<br />\nΘα θέλαμε να σας ενημερώσουμε ότι η συντακτική ομάδα αποφάσισε την ακύρωση του αιτήματος για την αξιολόγηση της εργασίας &quot;{$submissionTitle},&quot; για το περιοδικό {$contextName}. Σας ζητούμε συγγνώμη για την ενδεχόμενη αναστάτωση και ελπίζουμε σε μελλοντική μας συνεργασία για την αξιολόγηση εργασιών στο περιοδικό.<br />\n<br />\nΓια οποιαδήποτε διευκρίνιση, παρακαλούμε επικοινωνήστε μαζί μας.', 'Το παρόν μήνυμα αποστέλλεται από τον Επιμελητή Ενότητας σε έναν Αξιολογητή ο οποίος έχει αναλάβει την αξιολόγηση μίας υποβολής, για να του γνωστοποιήσει την ακύρωση της εν λόγω αξιολόγησης.'),
('REVIEW_CANCEL', 'en_US', 'Request for Review Cancelled', '{$reviewerName}:<br />\n<br />\nWe have decided at this point to cancel our request for you to review the submission, &quot;{$submissionTitle},&quot; for {$contextName}. We apologize for any inconvenience this may cause you and hope that we will be able to call on you to assist with this journal''s review process in the future.<br />\n<br />\nIf you have any questions, please contact me.', 'This email is sent by the Section Editor to a Reviewer who has a submission review in progress to notify them that the review has been cancelled.'),
('REVIEW_CANCEL', 'es_ES', 'Petición de revisión cancelada', '{$reviewerName}:<br />\n<br />\nHemos decidido cancelar nuestra petición para que revisara el envío &quot;{$submissionTitle},&quot; para {$contextName}. Lamentamos las molestias que hayamos podido causarle y esperamos poder volver a contactar con usted en el futuro para que nos ayude en el proceso de revisión.<br />\n<br />\nSi tiene cualquier pregunta, no dude en contactar con nosotros/as.', 'Este correo del / de la Editor/a de Sección a un/a Revisor/a que tiene la revisión de un envío en progreso para notificarles que la revisión se ha cancelado.'),
('REVIEW_CANCEL', 'eu_ES', 'Ebaluazio-eskaera bertan behera uztea', '{$reviewerName}:<br />\n<br />\n{$contextName} aldizkarirako {$submissionTitle} artikulua ebaluatzeko egin genizun eskaera bertan behera uztea erabaki dugu. Sentitzen dugu eta barkamena eskatzen dizugu erabaki honek sor ditzakeen endredoengatik, eta espero dugu aurrerantzean ere gure aldizkariko ebaluatzaileen artean izango zaitugula.<br />\n<br />\nGalderaren bat baduzu, jar zaitez harremanetan nirekin, mesedez.', 'Mezu hau Ataleko editoreak Ebaluatzaileari bidaltzen dio artikulu baten ebaluazioa egiten hasita dagoenean, ebaluazioa bertan behera utzi dela jakinarazteko.'),
('REVIEW_CANCEL', 'fa_IR', 'درخواست لغو کارشناسی', '{$reviewerName}:<br />\n<br />\nدر این مرحله تصمیم بر آن شده که درخواست کارشناسی مقاله ضضض مربوط به {$contextName} که به شما محول شده بود، لغو گردد. پیشاپیش از بابت ایجاد هرگونه مشکلی از شما عذرخواهی کرده و امیدواریم که در آینده بتوانیم طی مرحله کارشناسی با شما همکاری داشته باشیم.<br />\n<br />\nلطفا چنانچه در این رابطه سوالی دارید، با من تماس بگیرید.', 'This email is sent by the Section Editor to a Reviewer who has a submission review in progress to notify them that the review has been cancelled.'),
('REVIEW_CANCEL', 'fi_FI', 'Arviointipyynnön peruminen', 'Hyvä {$reviewerName},<br />\n<br />\nOlemme tässä vaiheessa päättäneet perua pyyntömme käsikirjoituksen &quot;{$submissionTitle}&quot; arvioinnista julkaisulle {$contextName}. Pahoittelemme tästä teille mahdollisesti aiheutuvia haittoja, ja toivomme, että voimme tulevaisuudessa pyytää teitä avustamaan julkaisumme arviointiprosessissa.<br />\n<br />\nMikäli teillä on kysyttävää, otattehan yhteyttä minuun.', 'This email is sent by the Section Editor to a Reviewer who has a submission review in progress to notify them that the review has been cancelled.'),
('REVIEW_CANCEL', 'fr_CA', 'Annulation de la demande d''évaluation', '{$reviewerName},<br />\n<br />\nNous avons décidé d''annuler notre demande concernant l''évaluation du manuscrit intitulé « {$submissionTitle} » pour la revue {$contextName}. Nous sommes désolés des inconvénients que cela pourrait vous causer et espérons que nous pourrons de nouveau faire appel à vous pour contribuer au processus de révision par les pairs de cette revue dans le futur.<br />\n<br />\nSi vous avez des questions, n''hésitez pas à communiquer avec nous.', 'Ce courriel est envoyé par le,la rédacteur-trice de rubrique à un,une évaluateur-trice qui a une évaluation en cours, pour l''aviser que celle-ci a été annulée.'),
('REVIEW_CANCEL', 'fr_FR', 'Annulation de la demande d''évaluation', '{$reviewerName}:<br />\n<br />\nNous avons décidé d''annuler notre demande concernant l''évaluation du manuscrit intitulé « {$submissionTitle} » pour {$contextName}. Nous sommes désolés des inconvénients que cela pourrait vous causer et nous espérons que nous pourrons compter sur votre collaboration pour un autre projet.<br />\n<br />\nSi vous avez des questions, n''hésitez pas à communiquer avec nous.', 'Ce courriel est envoyé par le Rédacteur de rubrique à un Rapporteur qui a une évaluation en cours, pour l''aviser que celle-ci a été annulée.'),
('REVIEW_CANCEL', 'gd_GB', 'Iarrtas airson lèirmheas air a chur gu neoini', '{$reviewerName}:<br />\n<br />\nCho-dhùin sinn an lèirmheas air an tagradh “{$submissionTitle},” airson {$contextName}, a dh’iarr sinn ort a chur gu neoini. Tha sinn duilich ma chuireas seo fo mhì-ghoireas thu idir agus tha sinn an dòchas gum bi thu deònach fhathast taic a chumail ri obair lèirmheis airson an iris-leabhair seo san àm ri teachd.<br />\n<br />\nMa tha ceist sam bith agad, cuir fios thugam.', 'Thèid am post-d seo a chur gu lèirmheasaiche a tha ag obair air lèirmheas tagraidh le deasaiche earrainn a dh’innse dhaibh gun deach an lèirmheas a chur gu neoini.'),
('REVIEW_CANCEL', 'he_IL', 'ביטול בקשה לסקירה', '{reviewerName$}:\n<br />\nהחלטנו בשלב זה לבטל את בקשתנו שתבדוק את ההגשה "{submissionTitle$}" ל{contextName$}. אנו מתנצלים על אי הנוחות שעלולה לגרום לך ומקווים שנוכל לבקש ממך לסייע בתהליך הסקירה של כתב עת זה בעתיד.<br />\n<br />\nאם יש לך שאלות, אנא צור איתי קשר.', 'דוא"ל זה נשלח על ידי עורך המדור לסוקר שעבר בדיקת הגשה כדי להודיע להם כי הביקורת בוטלה.'),
('REVIEW_CANCEL', 'hi_IN', 'समीक्षा रद्द करने का अनुरोध', '{$reviewerName}:<br />\n<br />\nहमने इस बिंदु पर निर्णय लिया है कि आप सबमिशन की समीक्षा करने के लिए हमारा अनुरोध रद्द कर दें, &quot;{$submissionTitle},&quot; for {$contextName}. हम आपसे किसी भी असुविधा के लिए क्षमा चाहते हैं और यह आशा करते हैं कि हम भविष्य में इस पत्रिका की समीक्षा प्रक्रिया में सहायता करने के लिए आपको कॉल कर सकेंगे।.<br />\n<br />\nयदि आपके पास किसी तरह का प्रश्न है, तो कृपया मुझ से सम्पर्क करें.', 'यह ईमेल अनुभाग संपादक द्वारा एक समीक्षक को भेजा जाता है, जिनके पास प्रगति की समीक्षा समीक्षा है ताकि उन्हें सूचित किया जा सके कि समीक्षा रद्द कर दी गई है.'),
('REVIEW_CANCEL', 'hr_HR', 'Povlačenje zamolbe za recenziju', 'Poštovana/i {$reviewerName},<br />\n<br />\ns obzirom na okolnosti, odlučili smo povući zamolbu da izvršite recenziju članka &quot;{$submissionTitle}&quot; za časopis {$contextName}. Nadamo se da ćemo vam se u budućnosti ponovno moći obratiti da vašom recenzijom pridonesete ovom časopisu.<br />\n<br />\nSrdačno.', 'Ovim obrascem e-pošte urednik rubrike recenzenta obavještava o povlačenju zahtjeva za izradu recenzije za koju je prethodno recenzent bio zadužen ili koja je recenzentu bila ponuđena.'),
('REVIEW_CANCEL', 'hu_HU', 'Lektori felkérés visszavonása', 'Tisztelt {$reviewerName}!<br />\n<br />\nEzúton visszavonjuk felkérésünket a(z) {$contextName} folyóirathoz beküldött &quot;{$submissionTitle},&quot; című kézirat cikk lektorálására. Elnézést kérünk az esetleges kellemetlenségért és bízunk benne, hogy a folyóirat lektorálási feladatai kapcsán még dolgozhatunk együtt.<br />\n<br />\nÜdvözlettel,<br />\n{$editorialContactSignature}', 'Ez az emailt a Rovatszerkesztő küldi a Lektornak, akihez lektorálás lett rendelve, jelezve neki, hogy a feladatot mégsem kell végrehajtania.'),
('REVIEW_CANCEL', 'id_ID', 'Permohonan Review Dibatalkan', '{$reviewerName}:<br />\n<br />\nKami memutuskan untuk membatalkan permohonan review kami kepada Anda untuk naskah, &quot;{$submissionTitle},&quot; di {$contextName}. Kami mohon maaf sebesar-besarnya untuk ketidaknyamanan ini dan kami harap di masa mendatang Anda dapat membantu proses review di jurnal ini.<br />\n<br />\nJika ada pertanyaan, silakan hubungi kami.', 'Email ini dikirimkan Editor Bagian kepada Reviewer yang sedang melakukan review untuk memberitahukan pembatalan review.'),
('REVIEW_CANCEL', 'it_IT', 'Cancellazione richiesta di revisione', 'Gentile {$reviewerName}:<br />\n<br />\nAbbiamo deciso di cancellare la nostra richiesta di revisione della proposta, &quot;{$submissionTitle},&quot; per {$contextName}.<br />\n<br />\nCi scusiamo per qualsiasi disturbo possiamo aver causato speriamo di poter contare su di te in una prossima occasione.<br />\n<br />\nSe hai qualsiasi richiesta, ti prego di contattarmi.', 'Questa email viene inviata dal section editor al revisore che ha una  revisione di una proposta in corso per fargli sapere che la revisione è stata cancellata.'),
('REVIEW_CANCEL', 'ja_JP', '査読依頼取消のお願い', '{$reviewerName} 様:<br />\n<br />\n以前お願いしておりました、雑誌『{$contextName}』への投稿物「{$submissionTitle}」の査読の件ですが、誠に勝手ながら事情により取り消させていただくことになりました。ご迷惑をおかけして、誠に申し訳ありませんでした。今後また査読をお願いすることがあろうかと思いますが、その節はよろしくお願いいたします。<br />\n<br />\n何かご不明な点がございましたら、ご連絡ください。<br />\n<br />\nよろしくお願いいたします。', 'このメールは、セクションエディタから査読者に既に開始している査読が取りやめになったことを通知するものです。'),
('REVIEW_CANCEL', 'ku_IQ', 'داواکاریی هەڵسەنگاندنی توێژینەوە هەڵوەشێندرایەوە', '{$reviewerName}:<br />\n<br />\nئێمە بڕیاری کشانەوەی داواکاریی خۆمانمان دا بۆ ئەوەی بەڕێزتان هەڵسەنگاندن بۆ ئەم توێژینەوەیە بکەن &quot;{$submissionTitle},&quot; بۆ {$contextName}. ئێمە داوای لێبوردن دەکەین بۆ هەر لەیەکتر تێنەگەیشتنێک لە نێوان ئێوە و گۆڤاردا. بە هیوای ئەوەی کە لە داهاتودا دەرفەتی کارکردنی بەیەکەوەمان بۆ بڕەخسێت.<br />\n<br />\nئەگەر هەر پرسیارێکتان هەیە، تکایە پەیوەندیم پێوە بکەن.', 'ئەم ئیمەیڵە لە لایەن سەرنوسەری بەشەوە بۆ هەڵسەنگێنەر نێردراوە کە لە کاتی هەڵسەنگاندندا بووە بە مەبەستی ئاگادارکردنەوەیان لەوەی کە هەڵسەنگاندنەکە هەڵوەشێندراوەتەوە.'),
('REVIEW_CANCEL', 'mk_MK', 'Барањето за рецензија е откажано', '{$reviewerName}:<br />\n<br />\nОдлучивме во овој момент да го откажеме нашето барање да го рецензирате поднесокот, &quot;{$submissionTitle},&quot; за {$contextName}. Се извинуваме за непријатностите кои ова би можело да ви ги предизвика и се надеваме дека ќе можеме повторно да ве повикаме да помогнете во процесот на рецензија на ова списание во иднина.<br />\n<br />\nДоколку имате дополнителни прашања, ве молам да не контактирате.', 'Овој и-меил е испратен од Секциски уредник до Рецензент кој има рецензија во тек за да ги извести дека рецензијата е откажана.'),
('REVIEW_CANCEL', 'nb_NO', 'Annulering av forespørsel om fagfellevurdering', '{$reviewerName}:<br />\n<br />\nVi har dessverre bestemt oss for å annulere vår forespørsel om fagfellevurdering av innleveringen «{$submissionTitle}», som vi tidligere har bedt deg om å påta deg for {$contextName}. Vi beklager bryderiet, men håper at vi fortsatt kan be deg om å vurdere manuskript for oss i fremtiden.<br />\n<br />\nTa kontakt med meg hvis du har spørsmål.', 'I denne e-posten fra seksjonsredaktøren til en fagfelle, annuleres en fagfellevurdering som tidligere er bestilt.'),
('REVIEW_CANCEL', 'nl_NL', 'Reviewverzoek ingetrokken', '{$reviewerName}:<br />\n<br />\nWe hebben besloten om ons verzoek aan u om de inzending &quot;{$submissionTitle}&quot; voor {$contextName}in te trekken. We verontschuldigen ons voor enig ongemak dat we daarmee veroorzaken en hopen dat we u in de toekomst mogen vragen om een bijdrage aan het reviewproces van dit tijdschrift.<br />\n<br />\nAls u nog vragen heeft, kunt u contact met mij opnemen.', 'Deze e-mail wordt door de sectieredacteur verstuurd naar een reviewer die een inzending aan het reviewen is om die op de hoogte te stellen dat de review is afgeblazen.'),
('REVIEW_CANCEL', 'pl_PL', 'Anulowanie prośby o wykonanie recenzji', 'Szanowna Pani/ Szanowny Panie,<br />\n<br />\nbardzo nam przykro, ale zostaliśmy zmuszeni do anulowania naszej prośby o wykonanie recenzji tekstu &quot;{$submissionTitle}&quot;, zgłoszonego do czasopisma {$contextName}. Przepraszamy za wszelkie niedogodności z tym związane. Mamy nadzieję na dalszą współpracę.<br />\n<br />\nW razie dodatkowych pytań proszę o kontakt.', 'Wiadomość wysyłana przez redaktora prowadzącego do recenzenta. Zawiera informacje o anulowaniu prośby o wykonanie recenzji.'),
('REVIEW_CANCEL', 'pt_BR', 'Cancelamento de solicitação de avaliação', '{$reviewerName}:<br />\n<br />\nNós decidimos cancelar o pedido de avaliação da submissão, &quot;{$submissionTitle},&quot; para o periódico {$contextName}. Nós pedimos desculpas por qualquer inconveniência que isso lhe causou e esperamos poder contar com sua assistência no processo de avaliação por pares deste periódico no futuro.<br />\n<br />\nSe tiver alguma dúvida, por gentileza, entre em contato comigo.', 'Mensagem enviada pelo Editor de Seção com um processo de avaliação em andamento, notificando que o processo em questão foi cancelado.'),
('REVIEW_CANCEL', 'pt_PT', 'Pedido de revisão cancelado', '{$reviewerName}:<br />\n<br />\nFoi cancelado o pedido de revisão da submissão &quot;{$submissionTitle}&quot; a {$contextName}. Lamentamos qualquer inconveniente causado e esperamos poder contar com a sua colaboração numa oportunidade futura.<br />\n<br />\nEm caso de dúvidas, entre em contacto connosco.', 'Este e-mail é enviado pelo Editor de Secção com um processo de revisão em andamento, notificando que a revisão foi cancelada.'),
('REVIEW_CANCEL', 'ro_RO', 'Cerere de revizuire anulată', '{$reviewerName}:<br />\n<br />\nAm decis, în acest moment, să anulăm cererea noastră către dumneavoastră, de a revizui trimiterea, &quot;{$submissionTitle},&quot; for {$contextName}. Ne cerem scuze pentru eventualele neplăceri provocate și sperăm că vom putea să vă solicităm pentru a vă ajuta cu procesul de revizuire al revistei în viitor.<br />\n<br />\nDacă aveți întrebări, vă rugăm să ne contactați.', 'Acest e-mail este trimis de către editorul de secțiuni unui revizor care are în revizuire un manuscris pentru a-l anunța că revizuirea a fost anulată.'),
('REVIEW_CANCEL', 'ru_RU', 'Запрос на рецензирование отменен', 'Здравствуйте, {$reviewerName}!<br />\n<br />\nНа данный момент мы решили отменить наш запрос на рецензирование Вами материала «{$submissionTitle}» для журнала «{$contextName}». Мы приносим свои извинения за причиненное Вам беспокойство и надеемся, что в будущем мы сможем к Вам обратиться за помощью в рецензировании материалов для нашего журнала.<br />\n<br />\nЕсли у Вас есть вопросы, пожалуйста, свяжитесь со мной.', 'Это письмо редактора раздела, отправляемое рецензенту, который начал рецензировать материал, с уведомлением о том, что рецензирование отменено.'),
('REVIEW_CANCEL', 'sk_SK', 'Žiadosť o zrušenie recenzie', '{$reviewerName}:<br />\n<br />\nV tomto bode sme sa rozhodli odvolať našu žiadosť, aby ste pre nás spracoval recenziu príspevku &quot;{$submissionTitle}&quot; pre {$contextName}. Ospravedlňujeme sa za všetky nepríjemnosti, ktoré by Vám to mohlo spôsobiť, a dúfame, že Vás budeme môcť osloviť ohľadom recenzného riadenia tohto časopisu v budúcnosti.<br />\n<br />\nV prípade, že budete mať akékoľvek otázky, prosím kontaktujte ma.', 'Tento email zasiela editor sekcie recenzentovi, ktorý má rozpracovanú recenziu, aby mu oznámil, že požiadavka na spracovanie recenzie bola zrušená.'),
('REVIEW_CANCEL', 'sl_SI', 'Prošnja za preklic recenzije', '{$reviewerName}:<br />\n<br />\nOdločili smo se, da prekličemo našo prošnjo za vašo recenzijo prispevka, &quot;{$submissionTitle},&quot; za publikacjo {$contextName}. Opravičujemo se vam za vse nevšečnosti, ki vam jih to lahko povzroči in upamo, da se lahko še obrnemo na vas pri uredniškem procesu revije tudi v prihodnje.<br />\n<br />\nČe imate kakršnokoli vprašanje, se prosim obrnite name.', 'Ta email pošlje urednik rubrike recenzentu, ki je bil zaprošen za opravljanje recenzije, in ga obvesti, da je je bilo opravljanje recenzije preklicano.'),
('REVIEW_CANCEL', 'sv_SE', 'Förfrågan om granskning återkallad', '{$reviewerName}:<br />\n<br />\nVi har beslutat att återkalla vår förfrågan till dig om att granska bidraget &quot;{$submissionTitle},&quot; för {$contextName}. Vi ber om ursäkt för besväret och hoppas att vi även i framtiden kan fråga dig om granskningsuppdrag för tidskriftens räkning.<br />\n<br />\nOm du har några frågor, vänligen kontakta mig.', 'Det här e-postmeddelandet skickas från sektionsredaktören till en granskare med en pågående granskning av ett bidrag, för att meddela hen att granskningen blivit återkallad.'),
('REVIEW_CANCEL', 'tr_TR', 'Değerlendirmenin iptalini rica ederiz', 'Sayın {$reviewerName},<br />\n<br />\n{$contextName} için yayınlanmak üzere gönderilen &quot;{$submissionTitle}&quot; başlıklı makalenin değerlendirmesini sizden talep etmiştik. Ancak gelinen noktada değerlendirmeye gerek kalmamıştır. Şu ana dek size verdiğimiz zahmetlerden dolayı teşekkür ederiz.', 'Değerlendirme süreci sona ermeden editörün değerlendirmeyi iptal için hakeme gönderdiği mesaj.'),
('REVIEW_CANCEL', 'uk_UA', 'Запит на рецензування скасвано', '{$reviewerName}:<br />\n<br />\nНаразі Ми вирішили скасувати наш запит на рецензування подання &quot;{$submissionTitle}&quot; для видання &quot;{$contextName}&quot;. Вибачаємося за всі створені незручності та сподіваємось, що у майбутньому ми зможемо звертатися до Вас за допомогою у рецензуванні статей для цього журналу.<br />\n<br />\nЯкщо Ви маєте додаткові запитання, будь ласка, повідомте мені про це.', 'Цим листом редактор розділу повідомляє рецензенту, який працює над поданням, про припинення рецензування.'),
('REVIEW_CANCEL', 'vi_VN', 'Hủy yêu cầu đánh giá bài báo', 'Kính gửi {$reviewerName},<br />\n<br />\nTại thời điểm này, chúng tôi đã quyết định hủy yêu cầu của chúng tôi để bạn đánh giá bài gửi, &quot;{$submissionTitle},&quot; cho {$contextName}. Chúng tôi xin lỗi vì bất kỳ sự bất tiện nào mà điều này có thể gây ra cho bạn và hy vọng rằng chúng tôi sẽ có thể nhờ bạn hỗ trợ quá trình đánh giá của tạp chí trong tương lai.<br />\n<br />\nNếu bạn có bất kỳ câu hỏi nào, xin vui lòng liên hệ với chúng tôi.', 'Email này được gửi bởi Biên tập viên chuyên mục tới một phản biện người đang trong quá trình đánh giá để thông báo cho họ rằng việc đánh giá đã bị hủy.'),
('REVIEW_CANCEL', 'zh_CN', '请取消审查工作', '{$reviewerName}:<br />\n<br />\n出于种种考量，我们目前已经取消了邀请您进行投稿《{$contextName}》之稿件〈{$submissionTitle}〉的审查工作。造成您的不便，我们感到十分抱歉，同时我们希望在未来仍能够请您协助审查这份期刊的稿件。<br />\n<br />\n如果您有任何问题，请与我们联络。', '这封电子邮件是由区段编辑寄给已经在进行审稿工作的审查人，通知他们说审查工作已经被取消了。'),
('REVIEW_CONFIRM', 'ar_IQ', 'قادر على التحكيم', 'أعزائي المحررون:<br />\n<br />\nأنا متمكن وراغب بتحكيم المؤلَّف الموسوم &quot;{$submissionTitle},&quot; والمرسل إلى {$contextName}. أشكر لكم إعتمادكم عليَّ، وأخطط لإنجاز التحكيم المطلوب حتى يوم استيجابه مني في {$reviewDueDate} إن لم يكن قبله.<br />\n<br />\n{$reviewerName}', 'هذه الرسالة يعنونها المحكم إلى محرر القسم استجابة لالتماس سابق أرسله له الأخير. المحكم يبلغ المحرر بقبوله للتحكيم المذكور خلال مدة الاستيجاب المطلوبة منه.'),
('REVIEW_CONFIRM', 'bs_BA', 'U mogućnosti sam izvršiti recenziju', 'Poštovana/i {$editorialContactName},<br />\n<br />\nu mogućnosti sam izvršiti recenziju članka &quot;{$submissionTitle}&quot; za časopis {$contextName}. Recenziju namjeravam izvršiti  unutar dogovorenog vremenskog roka, {$reviewDueDate}.<br />\n<br />\nSrdačno,<br />\n{$reviewerName}', 'Ovim obrascem e-pošte recenzent potvrđuje uredniku rubrike da prihvaća zahtjev za recenzijom.'),
('REVIEW_CONFIRM', 'ca_ES', 'Accepto la revisió', 'Benvolgut/uda {$editorialContactName},<br />\n<br />\nAccepto revisar la tramesa &quot;{$submissionTitle}&quot; per a {$contextName}, i us agraeixo que m''hàgiu tingut en compte per a aquesta tasca. La meva intenció és tenir-la acabada per a la data de venciment prevista ({$reviewDueDate}), o abans si és possible.<br />\n<br />\n{$reviewerName}', 'Aquest missatge de correu electrònic té un revisor com a remitent i s''envia a l''editor de secció en resposta a una sol·licitud de revisió per a notificar-li que ha acceptat encarregar-se d''aquesta tasca i que la trametrà abans de la data indicada.'),
('REVIEW_CONFIRM', 'cs_CZ', 'Mohu zpracovat recenzi', 'Editoři:<br />\n<br />\nMohu a jsem ochotný zpracovat recenzi příspěvku &quot;{$submissionTitle}&quot; pro {$contextName}. Děkuji, že jste mě oslovili. Plánuji dokončit zpracování recenze ve stanoveném termínu {$reviewDueDate}, případně dříve.<br />\n<br />\n{$reviewerName}', 'Tento email posílá recenzent editorovi sekce v odpovědi na žádost o zpracování recenze, aby mu oznámil, že žádost přijal a zpracuje recenzi ve stanoveném termínu.'),
('REVIEW_CONFIRM', 'da_DK', 'Kan foretage bedømmelse', 'Redaktører:<br />\n<br />\nJeg kan og er villig til at bedømme manuskriptet &quot;{$submissionTitle}&quot; til {$contextName}. Tak, fordi du tænkte på mig, og jeg planlægger at være færdig med bedømmelsen senest på forfaldsdatoen, {$reviewDueDate}, hvis ikke før.<br />\n<br />\n{$reviewerName}', 'Denne e-mail sendes af en bedømmer til sektionsredaktøren som svar på en bedømmelsesforespørgsel og underretter sektionsredaktøren om, at bedømmelsesforespørgslen er blevet accepteret, og at bedømmelsen vil være fuldført til den angivne dato.'),
('REVIEW_CONFIRM', 'de_DE', 'Einwilligung in die Begutachtung', 'Sehr geehrte Redaktion,<br />\n<br />\nich bin in der Lage und auch gern bereit, den Beitrag &quot;{$submissionTitle}&quot; für {$contextName} zu begutachten. Vielen Dank für Ihr Vertrauen; ich werde das Gutachten spätestens bis zum {$reviewDueDate} einreichen, wenn möglich auch früher.<br />\n<br />\n{$reviewerName}', 'Diese E-Mail wird von einer Gutachterin/einem Gutachter an die/den Rubrikredakteur/in als Antwort auf eine Begutachtungsanfrage gesendet, um die/den Rubrikredakteur/in darüber zu informieren, dass die Begutachtung übernommen wird und bis zu dem angegebenen Datum abgeschlossen sein wird.'),
('REVIEW_CONFIRM', 'el_GR', 'Αποδοχή αιτήματος αξιολόγησης', 'Editors:<br />\n<br />\nΘα ήθελα να σας ενημερώσω ότι μπορώ να αναλάβω την αξιολόγηση της εργασίας &quot;{$submissionTitle},&quot; για το περιοδικό {$contextName}. Σας ευχαριστώ για την εμπιστοσύνη σας και σκοπεύω να έχω την αξιολόγηση έτοιμη μέχρι τη λήξη της προθεσμίας, στις {$reviewDueDate}, αν όχι νωρίτερα.<br />\n<br />\n{$reviewerName}', 'Το παρόν μήνυμα αποστέλλεται από τον Αξιολογητή στον Επιμελητή Ενότητας σε απάντηση του αιτήματος αξιολόγησης. Ενημερώνει για την αποδοχή του αιτήματος και την ολοκλήρωση της αξιολόγησης μέχρι τη λήξη της προθεσμίας.'),
('REVIEW_CONFIRM', 'en_US', 'Able to Review', 'Editors:<br />\n<br />\nI am able and willing to review the submission, &quot;{$submissionTitle},&quot; for {$contextName}. Thank you for thinking of me, and I plan to have the review completed by its due date, {$reviewDueDate}, if not before.<br />\n<br />\n{$reviewerName}', 'This email is sent by a Reviewer to the Section Editor in response to a review request to notify the Section Editor that the review request has been accepted and will be completed by the specified date.'),
('REVIEW_CONFIRM', 'es_ES', 'Acepto la revisión', 'Editores/as:<br />\n<br />\nTengo la capacidad y deseo revisar el envío &quot;{$submissionTitle},&quot; para {$contextName}. Gracias por acordarse de mí, es mi intención tener la revisión completa en el plazo indicado: {$reviewDueDate}, a ser posible antes.<br />\n<br />\n{$reviewerName}', 'Este correo es enviado por un/a revisor/a al / a la Editor/a de Sección en respuesta a una petición de revisión para notificarle que ha aceptado la petición y que será completada antes de la fecha especificada.'),
('REVIEW_CONFIRM', 'eu_ES', 'Ebaluazioa egiteko prest', '{$editorialContactName}:<br />\n<br />\n{$contextName} aldizkarirako &quot;{$submissionTitle}&quot; artikulua ebaluatzeko aukera aztertu dut, eta prest nago lan hori egiteko. Eskerrik asko nigan pentsatzeagatik; nire txostena garaiz jasoko duzue, mugaegunerako ({$reviewDueDate}) eginda egongo da, lehenago ez bada.<br />\n<br />\n{$reviewerName}', 'Mezu hau Ebaluatzaileak Ataleko editoreari bidaltzen dio, ebaluazioa egiteko eskaera onartzen duela eta lana garaiz bukatuko duela esateko.'),
('REVIEW_CONFIRM', 'fa_IR', 'داوری را قبول می کنم', 'دبیر محترم:<br />\n<br />\nاینجانب داوری مقاله ارسالی &quot;{$submissionTitle}&quot;مربوط به {$contextName} را قبول می نمایم. از توجه شما متشکرم و بررسی آنرا در موعد مقرر ( {$reviewDueDate}) انجام خواهد داد.<br />\n<br />\n{$reviewerName}', 'ایمیلی از طرف داور به سردبیر یا دبیر بخشبرای اطلاع از پذیرش انجام داوری'),
('REVIEW_CONFIRM', 'fi_FI', 'Arvioinnin hyväksyminen', 'Hyvät toimittajat,<br />\n<br />\nOlen halukas arvioimaan käsikirjoituksen &quot;{$submissionTitle}&quot; julkaisulle {$contextName}. Kiitos, että pyysitte minua tähän tehtävään. Suoritan arvioinnin viimeistään sen määräaikaan {$reviewDueDate} mennessä.<br />\n<br />\n{$reviewerName}', 'This email is sent by a Reviewer to the Section Editor in response to a review request to notify the Section Editor that the review request has been accepted and will be completed by the specified date.'),
('REVIEW_CONFIRM', 'fr_CA', 'Acceptation d''évaluation', 'Rédacteurs-trices,<br />\n<br />\nJe suis en mesure d''évaluer la soumission intitulée « {$submissionTitle} » pour la revue {$contextName}. Je vous remercie d''avoir pensé à moi. Je devrais être en mesure de compléter l''évaluation pour la date du {$reviewDueDate}, voire avant.<br />\n<br />\n{$reviewerName}', 'Ce courriel est envoyé par l''évaluateur-trice au,à la rédacteur-trice de rubrique en réponse à une demande d''évaluation, pour l''aviser que la demande a été acceptée et que l''évaluation sera complétée au plus tard à la date spécifiée.'),
('REVIEW_CONFIRM', 'fr_FR', 'Acceptation d''évaluation', 'Rédacteurs, rédactrices,<br />\n<br/>\nJe suis en mesure d''évaluer la soumission intitulée « {$submissionTitle} » pour la revue {$contextName}. Je vous remercie d''avoir pensé à moi. Je devrais être en mesure de compléter l''évaluation pour la date du {$reviewDueDate}, voire avant.<br />\n<br />\n{$reviewerName}', 'Ce courriel est envoyé par le rapporteur au rédacteur de rubrique en réponse à une demande d''évaluation, pour aviser ce dernier que la demande a été acceptée et que l''évaluation sera complétée au plus tard à la date spécifiée.'),
('REVIEW_CONFIRM', 'gd_GB', 'Bidh e comasach lèirmheas a dhèanamh air', 'Deasaichean:<br />\n<br />\nTha mi deiseil is deònach lèirmheas a dhèanamh air an tagradh “{$submissionTitle},” airson {$contextName}. Mòran taing airson an cothrom seo a thoirt dhomh agus tha mi an dòchas an lèirmheas a choileanadh ron {$reviewDueDate}.<br />\n<br />\n{$reviewerName}', 'Thèid am post-d seo a chur gu deasaiche earrainn le lèirmheasaiche mar fhreagairt air iarrtas airson fios a leigeil gu deasaiche na h-earrainn gun deach gabhail ris an iarrtas agus gun tèid a choileanadh ron cheann-là a chaidh a shònrachadh.'),
('REVIEW_CONFIRM', 'he_IL', 'יכול לבדוק', 'לעורכים:<br />\n<br />\nאני מסכים לבדוק ההגשה "{submissionTitle$}" ל{contextName$}. תודה שפניתם אלי ואני מתכנן להחזיר את חוות הדעת עד {reviewDueDate$}, אם לא לפני.<br />\n<br />\n{reviewerName$}', 'דוא"ל זה נשלח על ידי בודק לעורך המדור בתגובה לבקשת סקירה כדי להודיע לעורך המדור כי בקשת הביקורת התקבלה ותושלם עד לתאריך שצוין.'),
('REVIEW_CONFIRM', 'hi_IN', 'समीक्षा करने में सक्षम', 'Editors:<br />\n<br />\nमैं सबमिशन की समीक्षा करने में सक्षम और तैयार हूं, &quot;{$submissionTitle},&quot; for {$contextName}. मेरे बारे में सोचने के लिए धन्यवाद, और मेरी योजना इसकी नियत तारीख, {$ reviewDueDate} से पूरी होने की है, अगर पहले नहीं.<br />\n<br />\n{$reviewerName}', 'यह ईमेल अनुभाग संपादक को समीक्षक द्वारा समीक्षा संपादक के अनुरोध के जवाब में भेजा जाता है कि समीक्षा अनुरोध स्वीकार कर लिया गया है और निर्दिष्ट तिथि तक पूरा हो जाएगा।.'),
('REVIEW_CONFIRM', 'hr_HR', 'U mogućnosti sam izvršiti recenziju', 'Poštovana/i {$editorialContactName},<br />\n<br />\nu mogućnosti sam izvršiti recenziju članka &quot;{$submissionTitle}&quot; za časopis {$contextName}. Recenziju namjeravam izvršiti  unutar dogovorenog vremenskog roka, {$reviewDueDate}.<br />\n<br />\nSrdačno,<br />\n{$reviewerName}', 'Ovim obrascem e-pošte recenzent potvrđuje uredniku rubrike da prihvaća zahtjev za recenzijom.'),
('REVIEW_CONFIRM', 'hu_HU', 'Lektori felkérés elfogadása', 'Tisztelt Szerkesztők!<br />\n<br />\nVállalom a(z) {$contextName} folyóirathoz beküldött &quot;{$submissionTitle},&quot; című kézirat lektorálását. Köszönöm a felkérést, a bírálatot a megadott határidőig ({$reviewDueDate}) elvégzem.<br />\n<br />\nÜdvözlettel,<br />\n{$reviewerName}', 'Ezt az emailt a Szakmai Lektor küldi a Rovatszerkesztőnek a lektori felkérésre válaszolva és jelezve, hogy a szakmai lektorálási munkát elvállalja és a megadott határidőig elvégzi.'),
('REVIEW_CONFIRM', 'id_ID', 'Dapat Melakukan Review', 'Editor:<br />\n<br />\nSaya dapat dan bersedia melakukan review terhadap naskah, &quot;{$submissionTitle},&quot; untuk {$contextName}. Terimakasih telah mempercayakan kepada saya, dan saya berencana untuk menyelesaikan review ini sesuai tenggat, {$reviewDueDate}, atau sebelumnya.<br />\n<br />\n{$reviewerName}', 'Email ini dikirimkan Reviewer kepada Editor Bagian sebagai respon terhadap permohonan review untuk memberitahu Editor Bagian bahwa permohonan review diterima dan akan diselesaikan pada tanggal yang ditetapkan.'),
('REVIEW_CONFIRM', 'it_IT', 'Accettazione incarico di revisione', 'Gentile Editor,<br />\n<br />\nAccetto l''incarico di revisionare &quot;{$submissionTitle},&quot; per {$contextName}.<br />\nPenso di completare la revisione per la data che mi avete comunicato, {$reviewDueDate}, se non prima.<br />\n<br />\n{$reviewerName}', 'Questa email viene mandata dal revisore  al section editor in risposta a una richiesta di revisione per far sapere a quest''ultimo che la richiesta è stata accettata e sarà completata alla data specificata.'),
('REVIEW_CONFIRM', 'ja_JP', '査読依頼の受諾', '編集部 御中:<br />\n<br />\n雑誌『{$contextName}』への投稿物「{$submissionTitle}」の査読の件ですが、喜んでやらせていただきます。査読者に選んでいただき、ありがとうございました。ご指定の査読期限、{$reviewDueDate}までには査読を終わらせるつもりです。<br />\n<br />\nよろしくお願いします。<br />\n{$reviewerName}', 'このメールは、査読者からセクションエディタに査読依頼を受諾し、指定された期日までに査読を終了させる意思を伝えるものです。'),
('REVIEW_CONFIRM', 'ku_IQ', 'توانای هەڵسەنگاندن هەیە', 'بەڕێزان، سەرنوسەران:<br />\n<br />\nمن لە توانام دایە و حەزدەکەم هەڵسەنگاندن بۆ توێژینەوەی&quot;{$submissionTitle},&quot; بکەم بۆ{$contextName}. سوپاس بۆ بیرکردنەوە لە من و من لە پلانم دایە کە هەڵسەنگاندنەکە هەتا{$reviewDueDate} تەواو بکەم، ئەگەر پێشتر نەبێت.<br />\n<br />\n{$reviewerName}', 'ئەم ئیمەیڵە لە لایەن هەڵسەنگێنەرەوە بۆ سەرنوسەری بەش نێردراوە لە وەڵامی سەرنوسەردا بۆ ئاگادارکردنەوەیان لە قبوڵکردنی هەڵسەنگاندنەکە و تەواوکردنی لە کاتی دیاریکراودا.'),
('REVIEW_CONFIRM', 'mk_MK', 'Може да рецензира', 'Уредници:<br />\n<br />\nЈас сум во состојба и подготвен да го рецензирам поднесокот, &quot;{$submissionTitle},&quot; за {$contextName}. Ви благодарам што помисливте на мене, и планирам да ја завршам рецензијата до крајниот датум, {$reviewDueDate}, ако не и порано.<br />\n<br />\n{$reviewerName}', 'Овој и-меил е испратен од Рецензент до Секциски уредник како одговор на барањето за рецензија со цел да до извести секцискиот уредник дека барањето за рецензија е прифатено и ќе биде извршено до посочениот датум.'),
('REVIEW_CONFIRM', 'nb_NO', 'Aksepter forespørsel om fagfellevurdering', 'Redaktorer:<br />\n<br />\nTakk for forespørselen om å vurdere innleveringen &quot;{$submissionTitle},&quot; for {$contextName}. Jeg har tid og anledning til å vurdere manuskriptet, og tar sikte på å ferdigstille vurderingen innen {$reviewDueDate}, om ikke før.<br />\n<br />\n{$reviewerName}', 'Denne e-posten sendes fra en fagfelle til seksjonsredaktøren som svar på «Forespørsel om fagfellevurdering» for å varsle seksjonsredaktøren om at forespørselen er mottatt og akseptert, og at fagfellevurderingen vil bli ferdigstilt innen angitt frist.'),
('REVIEW_CONFIRM', 'nl_NL', 'Review mogelijk', '{$editorialContactName}:<br />\n<br />\nIk ben bereid en in staat om een review te doen van de inzending &quot;{$submissionTitle}&quot; voor {$contextName}. Dank u dat u aan mij gedacht heeft. Ik verwacht de review gereed te hebben op of voor de afloopdatum, {$reviewDueDate}.<br />\n<br />\n{$reviewerName}', 'Deze e-mail wordt door een reviewer naar de sectieredacteur gestuurd als reactie op een review-verzoek dat geaccepteerd is en zal worden voltooid voor de gevraagde datum.'),
('REVIEW_CONFIRM', 'pl_PL', 'Zgoda na wykonanie recenzji', 'Szanowni Państwo,<br />\n<br />\nzgadzam się na wykonanie recenzji tekstu "{$submissionTitle}", zgłoszonego do czasopisma "{$contextName}". Recenzja będzie gotowa do dnia {$reviewDueDate}.<br />\n<br />\nZ wyrazami szacunku,\n{$reviewerName}', 'Wiadomość wysyłana przez recenzenta do redaktora prowadzącego. Zawiera akceptację prośby o wykonanie recenzji.'),
('REVIEW_CONFIRM', 'pt_BR', 'Disponível para realizar avaliação', 'Prezados editores, <br />\n<br />\nEu tenho disponibilidade para dar um parecer para a submissão, &quot;{$submissionTitle},&quot; para o periódico {$contextName}. Agradeço por lembrar de mim, e pretendo enviar o parecer até {$reviewDueDate}, se não antes.<br />\n<br />\nAtenciosamente,\n<br />\n{$reviewerName}', 'Mensagem enviada pelo Avaliador ao Editor de Seção, em resposta à solicitação de avaliação, para notificar disponibilidade para realizar a tarefa e de que a mesma será concluída no prazo especificado.'),
('REVIEW_CONFIRM', 'pt_PT', 'Disponível para realizar a revisão', 'Cara(o) Editor:<br />\n<br />\nEstou disponível e interessado em rever a submissão &quot;{$submissionTitle}&quot; a {$contextName}. Agradeço a consideração e estimo concluir a revisão até à data definida, {$reviewDueDate}, ou antes do prazo.<br />\n<br />\n{$reviewerName}', 'Este e-mail é enviado pelo Revisor ao Editor de Secção, em resposta ao pedido de revisão, para notificar a disponibilidade para realizar a tarefa e de que a mesma será concluída no prazo especificado.'),
('REVIEW_CONFIRM', 'ro_RO', 'Bun de revizuit', 'Editorilor:<br />\n<br />\nSunt dispus să revizuiesc manuscrisul, &quot;{$submissionTitle},&quot; pentru {$contextName}. Vă mulțumesc că v-ați gândit la mine și intenționez să finalizez examinarea până la data scadenței, {$reviewDueDate}, dacă nu, chiar mai repede.<br />\n<br />\n{$reviewerName}', 'Acest e-mail este trimis de către un revizor, editorului de secțiune ca răspuns la o cerere de revizuire pentru a notifica editorul de secțiune că cererea de revizuire a fost acceptată și va fi finalizată până la data specificată.'),
('REVIEW_CONFIRM', 'ru_RU', 'Согласен дать рецензию', 'Уважаемые редакторы!<br />\n<br />\nЯ готов дать рецензию на материал «{$submissionTitle}» для журнала «{$contextName}». Благодарю Вас, что обратились ко мне; я планирую завершить рецензирование к указанному сроку, {$reviewDueDate}, а возможно и раньше.<br />\n<br />\n{$reviewerName}', 'Это письмо рецензента, отправляемое редактору раздела, в ответ на запрос на рецензирование статьи, чтобы уведомить редактора раздела о том, что запрос на рецензирование принят и рецензия будет предоставлена к указанной дате.'),
('REVIEW_CONFIRM', 'sk_SK', 'Môžem spracovať recenziu', 'Editori:<br />\n<br />\nMôžem a som ochotný spracovať recenziu príspevku &quot;{$submissionTitle}&quot; pre {$contextName}. Dakujem, že ste ma oslovili. Plánujem dokončiť spracovanie recenzie v stanovenom termíne {$reviewDueDate}, prípadne skôr.<br />\n<br />\n{$reviewerName}', 'Tento email posiela recenzent editorovi sekcie v odpovedi na žiadosť o spracovaní recenzie, aby mu oznámil, že žiadosť prijal a spracuje recenziu v stanovenom termíne.'),
('REVIEW_CONFIRM', 'sl_SI', 'Potrditev recenzije', 'Editors:<br />\n<br />\nPripravljen sem opraviti recenzijo prispevka, &quot;{$submissionTitle},&quot; za revijo {$contextName}. Hvala za povabilo. Sporočam vam, da nameravam recenzijo dokončati do predvidenega datuma, {$reviewDueDate}, če ne prej.<br />\n<br />\n{$reviewerName}', 'Ta email pošlje recenzent uredniku rubrike kot odgovor na prošnjo za opravljanje recnezije in ga obvešča, da je sprejel recenzijo in jo namerava opraviti do predvidenega datuma.'),
('REVIEW_CONFIRM', 'sv_SE', 'Accepterar granskningsuppdrag', 'Redaktörer:<br />\n<br />\nJag har möjlighet och åtar mig gärna uppdraget att granska bidraget &quot;{$submissionTitle}&quot; för {$contextName}. Tack för att ni tänkte på mig. Jag kommer att ha granskningen färdig till deadline {$reviewDueDate}, om inte förr.<br />\n<br />\n{$reviewerName}', 'Det här e-postmeddelandet skickas från en granskare till sektionsredaktören som svar på en förfrågan om granskning för att meddela sektionsredaktören att granskaren accepterar förfrågan om granskning och att hen kommer att färdigställa denna till angiven deadline.');
INSERT INTO `email_templates_default_data` VALUES
('REVIEW_CONFIRM', 'tr_TR', 'Değerlendirmeyi Yapacağım', 'Sayın {$editorialContactName},<br />\n<br />\n{$contextName} adlı dergide yayımlanması için değerlendirilmek üzere gönderilen &quot;{$submissionTitle}&quot; başlıklı makalenin değerlendirme talebini kabul ediyorum. Değerlendirme raporunu en geç {$reviewDueDate} tarihine kadar göndereceğim.<br />\n<br />\nÇalışmayı değerlendirmek üzere tarafıma gönderdiğiniz için teşekkür ederim.<br />\n<br />\n{$reviewerName}', 'Bu e-posta, Değerlendirme talebinin kabul edildiğini ve belirtilen tarihe kadar tamamlanacağını Bölüm Editörüne bildirmek üzere yanıt olarak Hakem tarafından gönderilir.'),
('REVIEW_CONFIRM', 'uk_UA', 'Погоджуюсь здійснити рецензування', '{$editorialContactName}:<br />\n<br />\nЯ маю можливість та бажання працювати над рецензією подання &quot;{$submissionTitle}&quot; для видання &quot;{$contextName}&quot;. Дякую за довіру. Я планую закінчити роботу над рецензією не пізніше {$reviewDueDate}.<br />\n<br />\n{$reviewerName}', 'Цим листом рецензент повідомляє редактору розділу у відповідь на його запит, що він береться працювати над рецензією та здатний завершити цю роботу до вказаної дати.'),
('REVIEW_CONFIRM', 'vi_VN', 'Đồng ý đánh giá', 'Kính gửi Biên tập viên,<br />\n<br />\nTôi có thể và sẵn sàng đánh giá bài gửi, &quot;{$submissionTitle},&quot; cho {$contextName}. Cảm ơn bạn đã nghĩ đến tôi và tôi dự định hoàn thành bản đánh giá trước ngày {$reviewDueDate}.<br />\n<br />\n{$reviewerName}', 'Email này được gửi bởi một phản biện cho Biên tập viên chuyên mục để phản hồi với yêu cầu đánh giá cũng để thông báo cho Biên tập viên chuyên mục rằng yêu cầu xem xét lại đã được chấp nhận và sẽ được hoàn thành vào ngày cụ thể.'),
('REVIEW_CONFIRM', 'zh_CN', '可以进行审查工作', '{$editorialContactName}:<br />\n<br />\n我可以并且愿意为《{$contextName}》审查稿件〈{$submissionTitle}〉。谢谢您考虑我当审查人，而我计划在审查截止日{$reviewDueDate}前完成审查。<br />\n<br />\n{$reviewerName}', '这封电子邮件是由一位审查人寄给区段编辑，回复一份审查邀请，并通知区段编辑说已经接受审查邀请而且会在特定的日期之前完成工作。'),
('REVIEW_DECLINE', 'ar_IQ', 'غير قادر على التحكيم', 'أعزائي المحررون:<br />\n<br />\nأخشى أنني حالياً غير متفرغ لتحكيم المؤلَّف الموسوم &quot;{$submissionTitle},&quot; والمرسل إلى {$contextName}. أشكر لكم إعتمادكم عليَّ وأرجو التواصل معي في وقت آخر.<br />\n<br />\n{$reviewerName}', 'هذه الرسالة يعنونها المحكم إلى محرر القسم استجابة لالتماس سابق أرسله له الأخير. المحكم يعتذر فيها عن قبول التحكيم للمؤلَّف المذكور.'),
('REVIEW_DECLINE', 'bs_BA', 'Nisam u mogućnosti izvršiti recenziju', 'Poštovana/i {$editorialContactName},<br />\n<br />\nnažalost, u ovom trenutku nisam u mogućnosti izvršiti recenziju članka &quot;{$submissionTitle}&quot; za časopis {$contextName}. Hvala vam što ste me predložili za recenzenta, i molim vas da mi se svakako ponovno obratite u budućnosti.<br />\n<br />\nSrdačno,<br />\n{$reviewerName}', 'Ovim obrascem e-pošte recenzent odgovara uredniku rubrike da ne prihvaća zahtjev za recenzijom.'),
('REVIEW_DECLINE', 'ca_ES', 'Rebutjo la revisió', 'Benvolgut/uda {$editorialContactName},<br />\n<br />\nLamento comunicar-vos que en aquesta ocasió no em podré encarregar de la revisió de la tramesa &quot;{$submissionTitle}&quot; per a {$contextName}. Us agraeixo que m''hàgiu tingut en compte i confio que ens tornem a posar en contacte en una altra ocasió.<br />\n<br />\n{$reviewerName}', 'Aquest missatge de correu electrònic té un revisor com a remitent i s''envia a l''editor de secció en resposta a una sol·licitud de revisió per a notificar-li que rebutja encarregar-se d''aquesta tasca.'),
('REVIEW_DECLINE', 'cs_CZ', 'Nemohu zpracovat recenzi', 'Editoři:<br />\n<br />\nObávám se, že tentokrát nejsem schopen zpracovat recenzi příspěvku &quot;{$submissionTitle}&quot; pro {$contextName}. Děkuji, že jste mě oslovili a neváhejte mě jindy opět kontaktovat.<br />\n<br />\n{$reviewerName}', 'Tento email posílá recenzent editorovi sekce v odpovědi na žádost o zpracování recenze, aby mu oznámil, že recenzi nemůže zpracovat.'),
('REVIEW_DECLINE', 'da_DK', 'Kan ikke foretage bedømmelse', 'Redaktører:<br />\n<br />\nJeg beklager, at jeg på nuværende tidspunkt ikke kan bedømme manuskriptet &quot;{$submissionTitle}&quot; til {$contextName}. Tak, fordi du tænkte på mig, og du er altid velkommen til at kontakte mig en anden gang.<br />\n<br />\n{$reviewerName}', 'Denne e-mail sendes af en bedømmer til sektionsredaktøren som svar på en bedømmelsesforespørgsel og underretter sektionsredaktøren om, at bedømmelsesforespørgslen er blevet afvist.'),
('REVIEW_DECLINE', 'de_DE', 'Ablehnung der Bitte um ein Gutachten', 'Sehr geehrte Redaktion,<br />\n<br />\nleider kann ich gegenwärtig die Begutachtung des Beitrags &quot;{$submissionTitle}&quot; für {$contextName} nicht übernehmen. Ich danke für Ihr Vertrauen. Bei anderer Gelegenheit können Sie sich gerne wieder an mich wenden.<br />\n<br />\n{$reviewerName}', 'Diese E-Mail wird von einer Gutachterin/einem Gutachter an die/den Rubrikredakteur/in als Antwort auf eine Begutachtungsanfrage gesendet, um darüber zu informieren, dass die Anfrage abgelehnt wird.'),
('REVIEW_DECLINE', 'el_GR', 'Μη δυνατότητα πραγματοποίησης αξιολόγησης', 'Editors:<br />\n<br />\nΔυστυχώς την τρέχουσα περίοδο δεν δύναμαι να αναλάβω την αξιολόγηση της υποβολής &quot;{$submissionTitle},&quot; για το περιοδικό {$contextName}. Σας ευχαριστώ για την εμπιστοσύνη σας και μη διστάσετε στο μέλλον να επικοινωνήσετε ξανά μαζί μου.<br />\n<br />\n{$reviewerName}', 'Το παρόν μήνυμα αποστέλλεται από τον Αξιολογητή στον Επιμελητή Ενότητας, ως ενημέρωση ότι το αίτημα αξιολόγησης δεν έγινε δεκτό.'),
('REVIEW_DECLINE', 'en_US', 'Unable to Review', 'Editors:<br />\n<br />\nI am afraid that at this time I am unable to review the submission, &quot;{$submissionTitle},&quot; for {$contextName}. Thank you for thinking of me, and another time feel free to call on me.<br />\n<br />\n{$reviewerName}', 'This email is sent by a Reviewer to the Section Editor in response to a review request to notify the Section Editor that the review request has been declined.'),
('REVIEW_DECLINE', 'es_ES', 'Rechazo la revisión', 'Editores/as:<br />\n<br />\nMe temo que en este momento no voy a poder revisar el envío &quot;{$submissionTitle},&quot; para {$contextName}. Gracias por pensar en mí, espero que vuelvan a contar conmigo en futuras ocasiones.<br />\n<br />\n{$reviewerName}', 'Este correo es enviado por un/a revisor/a al / a la Editor/a de Sección en respuesta a una petición de revisión para notificarle que rechaza la petición de revisión.'),
('REVIEW_DECLINE', 'eu_ES', 'Ebaluazioa egin ezina', '{$editorialContactName}:<br />\n<br />\nSentitzen dut, baina oraingoan ezingo dut egin {$contextName} aldizkarirako &quot;{$submissionTitle}&quot; artikuluaren ebaluazioa. Eskerrik asko nigan pentsatzeagatik, eta espero dut hurrengo batean ere niregana joko duzuela.<br />\n<br />\n{$reviewerName}', 'Mezu hau Ebaluatzaileak Ataleko editoreari bidaltzen dio, ebaluazioa egiteko eskaerari erantzunez, ezin duela egin esateko.'),
('REVIEW_DECLINE', 'fa_IR', 'قادر به داوری نمی باشم', 'دبیر محترم:<br />\n<br />\nمتاسفانه در حال حاضر قادر به داوری مقاله ارسالی &quot;{$submissionTitle}&quot;مربوط به {$contextName} نیستم.<br />\nاز توجه شما متشکرم . در دفعات بعدی آماده همکاری با این مجله هستم.<br />\n<br />\n{$reviewerName}', 'ایمیلی از طرف داور به سردبیر یا دبیر بخش برای اطلاع از عدم پذیرش انجام داوری'),
('REVIEW_DECLINE', 'fi_FI', 'Arviointipyynnön hylkääminen', 'Hyvät toimittajat,<br />\n<br />\nEn valitettavasti voi tällä kertaa suorittaa käsikirjoituksen &quot;{$submissionTitle}&quot; arviointia julkaisulle {$contextName}. Kiitos, että pyysitte minua tähän tehtävään. Toivon, että otatte vastaisuudessakin minuun yhteyttä arviointeja koskien.<br />\n<br />\n{$reviewerName}', 'This email is sent by a Reviewer to the Section Editor in response to a review request to notify the Section Editor that the review request has been declined.'),
('REVIEW_DECLINE', 'fr_CA', 'Refus d''évaluation', 'Rédacteurs-trices,<br />\n<br />\nPour le moment, il m''est impossible d''évaluer la soumission intitulée « {$submissionTitle} » pour la revue {$contextName}. Je vous remercie d''avoir pensé à moi. N''hésitez pas à communiquer avec moi pour un autre projet.<br />\n<br />\n{$reviewerName}', 'Ce courriel est envoyé par l''évaluateur-trice au,à la rédacteur-trice de rubrique en réponse à la demande d''évaluation, pour l''aviser qu''il ou elle ne peut effectuer l''évaluation.'),
('REVIEW_DECLINE', 'fr_FR', 'Refus d''évaluation', 'Rédacteurs :<br />\n<br />\nPour le moment, il m''est impossible d''évaluer la soumission intitulée « {$submissionTitle} » pour {$contextName}. Je vous remercie d''avoir pensé à moi. N''hésitez pas à communiquer avec moi pour un autre projet.<br />\n<br />\n{$reviewerName}', 'Ce courriel est envoyé par le rapporteur au rédacteur de rubrique en réponse à la demande d''évaluation, pour aviser ce dernier qu''il ne peut effectuer l''évaluation.'),
('REVIEW_DECLINE', 'gd_GB', 'Cha bhi e comasach lèirmheas a dhèanamh air', 'Deasaichean:<br />\n<br />\nTha eagal orm nach urrainn dhomh lèirmheas a dhèanamh air an tagradh “{$submissionTitle},” airson {$contextName} aig an àm seo. Mòran taing airson an cothrom seo a thoirt dhomh agus tha fàilte romhaibh a leithid iarraidh orm uair sam bith.<br />\n<br />\n{$reviewerName}', 'Thèid am post-d seo a chur gu deasaiche earrainn le lèirmheasaiche mar fhreagairt air iarrtas airson fios a leigeil gu deasaiche na h-earrainn gun deach an t-iarrtas a dhiùltadh.'),
('REVIEW_DECLINE', 'he_IL', 'אינו יכול לבדוק', 'לעורכים:<br />\n<br />\nלצערי בשלב זה איני יכול לסקור את ההגשה "{submissionTitle$} ל{contextName$}. תודה שחשבתם עלי, ולא להסס לבקש שוב.<br />\n<br />\n{reviewerName$}', 'דוא"ל זה נשלח על ידי בודק לעורך המדור בתגובה לבקשת סקירה כדי להודיע לעורך המדור כי בקשת הביקורת נדחתה.'),
('REVIEW_DECLINE', 'hi_IN', 'समीक्षा करने में असमर्थ', 'Editors:<br />\n<br />\nमुझे डर है कि इस समय मैं सबमिशन की समीक्षा करने में असमर्थ हूं, &quot;{$submissionTitle},&quot; for {$contextName}. मुझे सोचने के लिए धन्यवाद, और एक और समय मुझे कॉल करने के लिए स्वतंत्र महसूस हो रहा है.<br />\n<br />\n{$reviewerName}', 'यह ईमेल समीक्षक द्वारा संपादक को खंड संपादक को सूचित करने के लिए समीक्षा अनुरोध के जवाब में भेजा जाता है कि समीक्षा अनुरोध अस्वीकार कर दिया गया है.'),
('REVIEW_DECLINE', 'hr_HR', 'Nisam u mogućnosti izvršiti recenziju', 'Poštovana/i {$editorialContactName},<br />\n<br />\nnažalost, u ovom trenutku nisam u mogućnosti izvršiti recenziju članka &quot;{$submissionTitle}&quot; za časopis {$contextName}. Hvala vam što ste me predložili za recenzenta, i molim vas da mi se svakako ponovno obratite u budućnosti.<br />\n<br />\nSrdačno,<br />\n{$reviewerName}', 'Ovim obrascem e-pošte recenzent odgovara uredniku rubrike da ne prihvaća zahtjev za recenzijom.'),
('REVIEW_DECLINE', 'hu_HU', 'Lektorálási felkérés elutasítása', 'Tisztelt Szerkesztők!<br />\n<br />\nSajnálom, de nem tudom elvállalni a(z) {$contextName} folyóirathoz beküldött &quot;{$submissionTitle},&quot; című kézirat lektorálását.  Köszönöm a megtisztelő felkérést, kérem keressenek más alkalommal.<br />\n<br />\nÜdvözlettel,<br />\n{$reviewerName}', 'Ezt az emailt a Szakmai Lektor küldi a Rovatszerkesztőnek a lektori felkérésre válaszolva és jelezve, hogy a lektorálási munkát nem tudja elvállalni.'),
('REVIEW_DECLINE', 'id_ID', 'Tidak Dapat Melakukan Review', 'Editor:<br />\n<br />\nMohon maaf saat ini saya tidak dapat melakukan review terhadap naskah, &quot;{$submissionTitle},&quot; untuk {$contextName}. Terimakasih telah mempercayakann kepada saya, dan lain waktu silakan menghubungi saya lagi.<br />\n<br />\n{$reviewerName}', 'Email ini dikirimkan Reviewer kepada Editor Bagian sebagai respon terhadap permohonan review untuk memberitahu Editor Bagian bahwa permohonan review ditolak.'),
('REVIEW_DECLINE', 'it_IT', 'Rifiuto incarico di revisione', 'Egregia redazione:<br />\n<br />\nSono spiacente di non poter revisionare la proposta, &quot;{$submissionTitle},&quot; per {$contextName}. Spero che ci siano future occasioni di collaborazione.<br />\n<br />\n{$reviewerName}', 'Questa email viene mandata dal revisore al section editor in risposta a una richiesta di revisione per far sapere a quest''ultimo che la richiesta è stata declinata.'),
('REVIEW_DECLINE', 'ja_JP', '査読依頼の謝絶', '編集部 御中:<br />\n<br />\n申し訳ありませんが、今回は、雑誌『{$contextName}』への投稿原稿「{$submissionTitle}」の査読をお受けすることはできません。査読者に選んでいただきありがとうございました。また、機会がございましたら、ご連絡ください。<br />\n<br />\nよろしくお願いいたします。<br />\n{$reviewerName}', 'このメールは、査読者からセクションエディタに査読依頼を受けることができない旨を通知するものです。'),
('REVIEW_DECLINE', 'ku_IQ', 'هەڵسەنگاندنەکە ناتوانم', 'بەڕێزان، سەرنوسەران:<br />\n<br />\nببورن کە ناتوانم هەڵسەنگاندن بۆ توێژینەوەی &quot;{$submissionTitle},&quot; بۆ {$contextName} بکەم. سوپاس بۆ هەڵبژاردنی من و هیوادارم لە کاتێکی دیکەدا کاری پێکەوییمان هەبێت. <br />\n<br />\n{$reviewerName}', 'ئەم ئیمەیڵە لە لایەن هەڵسەنگێنەرەوە بۆ سەرنوسەری بەش نێردراوە بۆ ئاگادارکردنەوەیان لە ڕەتکردنەوەی هەڵسەنگاندنەکە.'),
('REVIEW_DECLINE', 'mk_MK', 'Не може да рецензира', 'Уредници:<br />\n<br />\nЗа жал, во моментов не сум во состојба да го рецензирам поднесокот, &quot;{$submissionTitle},&quot; за {$contextName}. Ви благодарам што помисливте на мене, слободно побарајте ме следниот пат.<br />\n<br />\n{$reviewerName}', 'Овој и-меил е испратен од Рецензент до Секциски уредник како одговор на барањето за рецензија со цел да го извести секцискиот уредник дека барањето за рецензија е одбиено.'),
('REVIEW_DECLINE', 'nb_NO', 'Avslå forespørsel om fagfellevurdering', '{$editorialContactName}:<br />\n<br />\nJeg kan dessverre ikke påta meg oppdraget med å vurdere innleveringen «{$submissionTitle}» for {$contextName}. Jeg takker for forespørselen. Ta kontakt ved en senere anledning.<br />\n<br />\n{$reviewerName}', 'Denne e-posten sendes av en fagfelle til seksjonsredaktøren som svar på en forespørsel om fagfellevurdering, for å varsle redaktøren om at oppdraget er avslått.'),
('REVIEW_DECLINE', 'nl_NL', 'Review niet mogelijk', '{$editorialContactName}:<br />\n<br />\nIk ben bang dat ik op dit moment niet in staat ben om een review te doen van inzending &quot;{$submissionTitle}&quot; voor {$contextName}. Dank u dat u aan mij gedacht heeft en voel u vrij om op een ander moment een beroep op mij te doen.<br />\n<br />\n{$reviewerName}', 'Deze e-mail wordt door de reviewer verstuurd naar de sectieredacteur als reactie op een reviewverzoek om te laten weten dat het verzoek wordt afgewezen.'),
('REVIEW_DECLINE', 'pl_PL', 'Odrzucenie prośby o wykonanie recenzji', 'Szanowni Państwo,<br />\n<br />\nobawiam się, że w podanym czasie nie zdołam wykonać recenzji tekstu "{$submissionTitle}", zgłoszonego do czasopisma "{$contextName}".<br />\n<br />\nZ wyrazami szacunku, \n{$reviewerName}', 'Wiadomość wysyłana przez recenzenta do redaktora prowadzącego. Zawiera odrzucenie prośby o wykonanie recenzji.'),
('REVIEW_DECLINE', 'pt_BR', 'Indisponível para realizar avaliação', 'Editores(as):<br />\n<br />\nTemo não poder dar um parecer à submissão &quot;{$submissionTitle},&quot; para o periódico {$contextName} no momento. Agradeço por lembrar de mim, e fiquem à vontade para me convidar novamente em um outro momento.<br />\n<br />\n{$reviewerName}', 'Mensagem enviada pelo Avaliador ao Editor de Seção, em resposta à solicitação de avaliação, para notificar sua NÃO disponibilidade para realizar a tarefa, rejeitando a solicitação.'),
('REVIEW_DECLINE', 'pt_PT', 'Indisponível para realizar a revisão', 'Cara(o) Editor:<br />\n<br />\nLamento informar que não estou disponível de momento para realizar a revisão da sumissão &quot;{$submissionTitle}&quot; à revista {$contextName}. Agradeço a consideração e espero poder ser convidado e estar disponível noutra oportunidade.<br />\n<br />\n{$reviewerName}', 'Este e-mail é enviado pelo Revisor ao Editor de Secção, em resposta ao pedido de revisão, para notificar da sua inisponibilidade para realizar a tarefa, rejeitando a revisão.'),
('REVIEW_DECLINE', 'ro_RO', 'Nu poate fi revizuit', 'Editori:<br />\n<br />\nMi-e teamă că în acest moment nu sunt în măsură să revizuiesc manuscrisul, &quot;{$submissionTitle},&quot; for {$contextName}. Vă mulțumesc că v-ați gândit la mine și, altădată, nu ezitați să apelați din nou.<br />\n<br />\n{$reviewerName}', 'Acest e-mail este trimis de un revizor, editorului de secțiune ca răspuns la o cerere de revizuire pentru a notifica editorul de secțiune că cererea de revizuire a fost respinsă.'),
('REVIEW_DECLINE', 'ru_RU', 'Не могу дать рецензию', 'Уважаемые редакторы!<br />\n<br />\nБоюсь, что в данный момент я не могу дать рецензию на материал «{$submissionTitle}» для журнала «{$contextName}». Благодарю вас, что обратились ко мне, в другой раз также не стесняйтесь, обращайтесь ко мне.<br />\n<br />\n{$reviewerName}', 'Это письмо рецензента, отправляемое редактору раздела, в ответ на запрос на рецензирование статьи, чтобы уведомить редактора раздела о том, что запрос на рецензирование отклонен.'),
('REVIEW_DECLINE', 'sk_SK', 'Nemôžem spracovať recenziu', 'Editori:<br />\n<br />\nObávam sa, že tentoraz nie som schopný spracovať recenziu príspevku &quot;{$submissionTitle}&quot; pre {$contextName}. Ďakujem, že ste ma oslovili a neváhajte ma inokedy opäť kontaktovať.<br />\n<br />\n{$reviewerName}', 'Tento email posiela recenzent editorovi sekcie v odpovedi na žiadosť o spracovaní recenzie, aby mu oznámil, že recenziu nemôže spracovať.'),
('REVIEW_DECLINE', 'sl_SI', 'Ne morem opraviti recenzije', 'Editors:<br />\n<br />\nŽal mi je, vendar v tem trenutku ne morem opraviti recenzije prispevka, &quot;{$submissionTitle},&quot; za revijo {$contextName}. Hvala za povabilo in upam, da me boste še povabili k sodelovanju.<br />\n<br />\n{$reviewerName}', 'Ta email pošlje recenzent urendiku rubrike kot odgovor na prošnjo za recenzijo v primeru, ko obvešča urednika rubrike, da recenzijo zavrne.'),
('REVIEW_DECLINE', 'sv_SE', 'Tackar nej till granskningsuppdrag', 'Redaktörer:<br />\n<br />\nTyvärr har jag inte möjlighet i nuläget att granska bidraget &quot;{$submissionTitle}&quot; för {$contextName}. Tack för att ni tänkte på mig och hör gärna av er en annan gång.<br />\n<br />\n{$reviewerName}', 'Det här e-postmeddelandet skickas från en granskare till sektionsredaktören som svar på en förfrågan om granskning för att meddela sektionsredaktören att granskaren tackar nej till granskningsuppdraget.'),
('REVIEW_DECLINE', 'tr_TR', 'Değerlendirmeyeceğim', 'Sayın {$editorialContactName},<br />\n<br />\n{$contextName} adlı dergide yayımlanması için değerlendirilmek üzere gönderilen &quot;{$submissionTitle}&quot; başlıklı makaleyi şu anda değerlendiremeyeceğim. Beni düşündüğünüz için teşekkür ederim. Başka bir çalışmanın değerlendirmesinde katkı sunmaya çalışacağım.<br />\n<br />\n{$reviewerName}', 'Bu elektronik posta gözden geçirme talebine cevap olarak, gözden geçirmenin red edildiğini bildirmek amacıyla Bölüm Editörüne gözden geçirmeyi yapan kişi tarafından gönderilir.'),
('REVIEW_DECLINE', 'uk_UA', 'Неможливо здійснити рецензування', '{$editorialContactName}:<br />\n<br />\nБоюся, що зараз я не маю можливості рецензувати подання &quot;{$submissionTitle}&quot; для видання &quot;{$contextName}&quot;. Дякую за довіру, звертайтеся до мене у майбутньому.<br />\n<br />\n{$reviewerName}', 'Цим листом рецензент повідомляє редактору розділу у відповідь на його запит, що відмовляється рецензувати.'),
('REVIEW_DECLINE', 'vi_VN', 'Không thể nhận đánh giá', 'Kính gửi biên tập viên,<br />\n<br />\nTôi e rằng tại thời điểm này tôi không thể đánh giá bài gửi, &quot;{$submissionTitle},&quot; cho {$contextName}. Cảm ơn bạn đã nghĩ đến  tôi, và bạn có thể liên hệ với tôi vào thời điểm khác.<br />\n<br />\n{$reviewerName}', 'Email này được gửi bởi Người phản biện đến Biên tập viên chuyên mục để phản hồi về yêu cầu đánh giá cũng để thông báo cho Biên tập viên chuyên mục biết rằng yêu cầu đánh giá đã bị từ chối.'),
('REVIEW_DECLINE', 'zh_CN', '无法进行审查工作', '{$editorialContactName}:<br />\n<br />\n我恐怕在这个时候无法为《{$contextName}》进行稿件〈{$submissionTitle}〉的审查工作。谢谢您考虑我担任审查人，有机会我仍乐意接受审查工作。<br />\n<br />\n{$reviewerName}', '这封电子邮件是由一位审查人寄给区段编辑以回复一份审查邀请，并通知区段编辑要婉谢审查邀请。'),
('REVIEW_REINSTATE', 'ar_IQ', 'إعادة التماس التحكيم', '{$reviewerName}:<br />\n<br />\nنرغب بإعادة التماسنا لحضرتكم لتحكيم المؤَّلف الموسوم &quot;{$submissionTitle},&quot; والمرسل إلى {$contextName}. نأمل أن تكونوا قادرين على إبداء العون بشأن عملية التحكيم في هذه المجلة.<br />\n<br />\nإن كانت لديكم أي استفسارات، لطفاً، إتصلوا بي.', 'هذه الرسالة يعنونها محرر القسم إلى المحكم الذي بحيازته طلب تقديم قيد المعالجة لإبلاغه بأن التماس التحكيم الملغى قد تمت العودة إليه.'),
('REVIEW_REINSTATE', 'ca_ES', 'Sol·licitud de revisió restaurada', '{$reviewerName}:<br />\n<br />\nEns agradaria restaurar la sol·licitud que us vam fer per revisar la tramesa, &quot;{$submissionTitle},&quot; per a {$contextName}. Esperem que estigueu disponible i ens ajudeu en aquest proces de revisió de la revista.<br />\n<br />\nSi teniu qualsevol pregunta no dubteu a contactar-me.', 'Aquest correu electrònic de l''editor/a de secció s''adreça a un revisor/a que té una revisió en curs per notificar-li que una revisió cancel·lada ha estat restaurada.'),
('REVIEW_REINSTATE', 'cs_CZ', 'Žádost o recenzi byla obnovena', '{$reviewerName}:<br />\n<br />\nRádi bychom obnovili naši žádost o kontrolu příspěvku &quot;{$submissionTitle},&quot; pro {$contextName}. Doufáme, že budete moci pomoci s procesem recenzí tohoto časopisu. <br />\n<br />\nPokud máte nějaké dotazy, kontaktujte mě.', 'Tento e-mail je odeslán editorem sekce recenzentovi, který právě provádí recenzi příspěvku, aby mu oznámil, že zrušená recenze byla obnovena.'),
('REVIEW_REINSTATE', 'da_DK', 'Anmodning om bedømmelse genindsat', '{$reviewerName}:<br />\n<br />\nVi vil gerne på ny anmode om, at du foretager en bedømmelse af indsendelsen, &quot;{$submissionTitle},&quot; for {$contextName}. Vi håber, at du vil kunne være behjælpelig med at gennemføre dette tidsskrifts bedømmelsesforløb.<br />\n<br />\nDu bedes kontakte mig, hvis du har spørgsmål.', 'Denne e-mail er afsendt af sektionsredaktøren til en bedømmer, som er i gang med en bedømmelse for at underrette vedkommende om, at en annulleret bedømmelse er blevet genindsat.'),
('REVIEW_REINSTATE', 'de_DE', 'Anfrage nach einem Gutachten wiederhergestellt.', '{$reviewerName},<br />\n<br />\nWir möchten unsere Anfrage nach einem Gutachten für den Beitrag &quot;{$submissionTitle},&quot;, welcher bei {$contextName} eingereicht wurde, erneuern. Wir hoffen, dass Sie uns im Begutachtunsprozess dieser Zeitschrift unterstützen können.<br />\n<br />\nWenn Sie Fragen haben, können Sie sich gern an mich wenden.', 'Diese E-Mail wird von der/dem Rubrikredakteur/in an eine/n Gutachter/in gesendet, die an einem Gutachten arbeiten, um sie darüber zu informieren, dass die zurüchgezogene Anfrage nach einem Gutachten hiermit erneuert wird.'),
('REVIEW_REINSTATE', 'el_GR', 'Επαναφορά Αιτήματος για Αξιολόγηση', '{$reviewerName}:<br />\n<br />\nΘα θέλαμε να επαναφέρουμε το αίτημά μας για να ελέγξετε την υποβολή, &quot;{$submissionTitle},&quot; στο {$contextName}. Ελπίζουμε να μπορέσετε να βοηθήσετε στη διαδικασία αξιολόγησης αυτού του περιοδικού.<br />\n<br />\nΑν έχετε απορίες, επικοινωνήστε μαζί μου.', 'Το συγκεκριμένο email αποστέλλεται από τον Επιμελητή Ενότητας σε Αξιολογητή ο οποίος έχει αναλάβει την αξιολόγηση μιας υποβολής και του γνωστοποιηθεί η ακύρωση της εν λόγω αξιολόγησης.'),
('REVIEW_REINSTATE', 'en_US', 'Request for Review Reinstated', '{$reviewerName}:<br />\n<br />\nWe would like to reinstate our request for you to review the submission, &quot;{$submissionTitle},&quot; for {$contextName}. We hope that you will be able to assist with this journal''s review process.<br />\n<br />\nIf you have any questions, please contact me.', 'This email is sent by the Section Editor to a Reviewer who has a submission review in progress to notify them that a cancelled review has been reinstated.'),
('REVIEW_REINSTATE', 'es_ES', 'Solicitud de revisión restablecida', '{$reviewerName}:<br />\n<br />\nNos gustaría restablecer la solicitud que le hicimos para revisar el envío &quot;{$submissionTitle},&quot; para {$contextName}. Esperamos que nos pueda ayudar en este proceso de revisión de la revista.<br />\n<br />\nSi tiene cualquier pregunta no dude en contactarme.', 'Este correo electrónico lo envía el editor/a de sección a un revisor/a con alguna revisión en curso para notificarle que una revisión cancelada ha sido restablecida.'),
('REVIEW_REINSTATE', 'fi_FI', 'Arviointipyyntö uusittu', 'palautapalauta{$reviewerName}:<br />\n<br />\nHaluaisimme uusia käsikirjoitusta  &quot;{$submissionTitle},&quot; koskevan arviointipyyntömme julkaisussa {$contextName}. \nToivomme, että pystytte ottamaan arvioinnin vastaan.<br />\n<br />\nMikäli teillä on kysymyksiä, olkaa yhteydessä.', 'Tämä on toimittajan arvioijalle lähettämä sähköposti, jolla peruttu arviointipyyntö uusitaan.'),
('REVIEW_REINSTATE', 'fr_CA', 'Réintégration de la demande d''évaluation', '{$reviewerName},<br />\n<br />\nNous souhaitons rétablir notre demande d''évaluation de la soumission, « {$ submissionTitle} » pour  la revue {$ contextName}. Nous espérons que vous pourrez contribuer au processus d''évaluation de cette revue.<br />\n<br />\nSi vous avez des questions, n''hésitez pas à communiquer avec moi.', 'Ce courriel est envoyé par le,la rédacteur-trice de rubrique à un,une évaluateur-trice qui a une évaluation en cours, pour l''aviser que la demande préalablement annulée a été rétablie.'),
('REVIEW_REINSTATE', 'fr_FR', 'Réintégration de la demande d''évaluation', '{$reviewerName},<br />\n<br />\nNous souhaitons vous demander à nouveau d''évaluer la soumission, « {$ submissionTitle} » pour la revue {$ contextName}. Nous espérons que vous pourrez contribuer au processus d''évaluation de cette revue.<br />\n<br />\nSi vous avez des questions, n''hésitez pas à me contacter.', 'Ce courriel est envoyé par le rédacteur ou la rédactrice de la rubrique à un évaluateur ou une évaluatrice qui a une évaluation en cours pour l''informer que la demande préalablement annulée à été rétablie.'),
('REVIEW_REINSTATE', 'gd_GB', 'Iarrtas airson lèirmheas air a chur beò às ùr', '{$reviewerName}:<br />\n<br />\nBu toil leinn an lèirmheas air an tagradh “{$submissionTitle},” airson {$contextName}, a dh’iarr sinn ort a chur beò a-rithist. Tha sinn an dòchas gun urrainn dhut ar cuideachdadh leis an lèirmheas airson an iris-leabhair.<br />\n<br />\nMa tha ceist sam bith agad, cuir fios thugam.', 'Thèid am post-d seo a chur gu lèirmheasaiche a tha ag obair air lèirmheas tagraidh le deasaiche earrainn a dh’innse dhaibh gun deach lèirmheas a chaidh a chur gu neoini a chur beò a-rithist.'),
('REVIEW_REINSTATE', 'he_IL', 'בקשה לבדיקה חודשה', '{reviewerName$}:\nברצוננו להחזיר את בקשתנו שתבדוק את ההגשה "{submissionTitle$}" ל{contextName$}. אנו מקווים כי תוכלו לסייע בתהליך הסקירה של כתב העת הזה<br />\n<br />\nאם יש לך שאלות, אנא צור איתי קשר.', 'דוא"ל זה נשלח על ידי עורך המדור לסוקר שעבר בדיקת הגשה כדי להודיע להם כי הוחזרה ביקורת שבוטלה.'),
('REVIEW_REINSTATE', 'hi_IN', 'पुनर्स्थापना के लिए अनुरोध', '{$reviewerName}:<br />\n<br />\nहम आपके द्वारा प्रस्तुत समीक्षा की समीक्षा करने के लिए आपके अनुरोध को पुनः स्थापित करना चाहेंगे, &quot;{$submissionTitle},&quot; for {$contextName}. हमें उम्मीद है कि आप इस पत्रिका की समीक्षा प्रक्रिया में सहायता कर पाएंगे.<br />\n<br />\nयदि आपके पास किसी तरह का प्रश्न है, तो कृपया मुझ से सम्पर्क करें।', 'यह ईमेल सेक्शन एडिटर द्वारा एक समीक्षक को भेजा जाता है, जिसके पास प्रगति की समीक्षा में यह सूचित करने के लिए कि रद्द की गई समीक्षा को फिर से बहाल कर दिया गया है.'),
('REVIEW_REINSTATE', 'hu_HU', 'Ismételt felkérés lektorálásra', 'Tisztelt {$reviewerName}!<br />\n<br />\nEzúton szeretnénk ismételten felkérni a(z) {$contextName} &quot;{$submissionTitle},&quot; című cikkének szakmai lektorálására. <br />\n<br />\nFelmerülő kérdés esetén, kérem, keressen.', 'Ezt az  emailt a Rovatvezető küldi a Szerkesztőnek, aki egy cikk szakmai lektorálásán dolgozik és tájékoztatja, hogy a megszakított lektorálási kérésre most ismételten felkéri.'),
('REVIEW_REINSTATE', 'id_ID', 'Meminta Pemulihan Review', '{$reviewerName}:<br />\n<br />\nKami ingin memulihkan permintaan kami kepada Anda untuk mereview naskah, &quot;{$submissionTitle},&quot; untuk {$contextName}. Kami berharap Anda dapat membantu proses review jurnal kami.<br />\n<br />\nJika ada pertanyaan, silakan hubungi saya.', 'Email ini dikirim oleh Editor Bagian kepada Mitra Bestari yang sedang mereview naskah untuk memberi tahu bahwa ulasan mereka yang dibatalkan telah dipulihkan.'),
('REVIEW_REINSTATE', 'it_IT', 'Invito alla revisione ripristinato', '{$reviewerName}:<br />\n<br />\nE'' stato ripristinato l''invito alla revisione per il manoscritto &quot;{$submissionTitle},&quot; per la testata {$contextName}.  Ci auguriamo che le sia possibile contribuire a questo ciclo di revisione e rimaniamo a sua disposizione per qualsiasi chiarimento.', 'Questa mail è inviata dal Section Editor al revisore con una revisione in corso per avvisarlo che l''invito alla revisione cancellato è stato ripristinato.'),
('REVIEW_REINSTATE', 'ja_JP', '論文査読のお願いの復活', '{$reviewerName}様:<br />\n<br />\n雑誌『{$contextName}』への投稿原稿「{$submissionTitle}」の査読のお願いを復活させたいと思います。本誌の査読作業のお手伝いをしていただければ幸いです。<br />\n<br />\n何かご不明な点がございましたら、ご連絡ください。', 'このメールは、セクションエディターから投稿査読中の査読者に、キャンセルされた審査が復活したことを通知するために送信されます。'),
('REVIEW_REINSTATE', 'ku_IQ', 'داواکاریی هەڵسەنگاندنی توێژینەوە دوبارە کرایەوە', '{$reviewerName}:<br />\n<br />\nئێمە دەمانەوێت دوبارە داواتان لێ بکەینەوە بۆ هەڵسەنگاندنی &quot;{$submissionTitle},&quot; بۆ {$contextName}. ئێمە هیواخوازین کە بەڕێزتان هاوکارمان بن لە پرۆسەی هەڵسەنگاندنەکەدا.<br />\n<br />\nئەگەر هەر پرسیارێکتان هەیە، تکایە بە ئیمەیڵ پەیوەندیم پێوە بکەن.', 'ئەم ئیمەیڵە لە لایەن سەرنوسەری بەشەوە بۆ هەڵسەنگێنەرێک نێردراوە کە لە کاتی هەڵسەنگاندندا پرۆسەی  هەڵسەنگاندنەکە هەڵ وەشیندراوەتەوە و ئەمەش دوبارە دڵنیاکردنەوەی هەڵ وەشاندنەوەکەیە.'),
('REVIEW_REINSTATE', 'mk_MK', 'Барањето за рецензија е обновено', '{$reviewerName}:<br />\n<br />\nБи сакале да го обновиме нашето барање да го рецензирате поднесокот, &quot;{$submissionTitle},&quot; за {$contextName}. Се надеваме дека ќе можете да помогнете со процесот на рецензија на ова списание.<br />\n<br />\nДоколку имате дополнителни прашања, ве молам да ме контактирате.', 'Овој и-меил е испратен од Секциски уредник до Рецензент кој има рецензија во тек за да ги извести дека откажаната рецензија е обновена.'),
('REVIEW_REINSTATE', 'nb_NO', 'Forespørsel om fagfellevurdering gjenopptatt', '{$reviewerName}:<br />\n<br />\nVi vil gjerne spørre på nytt om du vil foreta en fagfellevurdering av innleveringen, &quot;{$submissionTitle},&quot; for {$contextName}. Vi håper at du har mulighet til å assistere med tidsskriftets fagfellevurdering.<br />\n<br />\nKontakt meg hvis du har noen spørsmål.', 'Denne e-posten blir sendt av seksjonsredaktøren til en fagfelle som er i gang med en vurdering for å informere han eller henne om at en annulert fagfellevurdering er gjenopptatt.'),
('REVIEW_REINSTATE', 'nl_NL', 'Herindienen beoordelingsverzoek', '{$reviewerName}:<br />\n<br />\nWe willen graag ons beoordelingsverzoek over de inzending, &quot;{$submissionTitle},&quot; for {$contextName}, herindienen.<br />\n<br />\nVoor vragen kunt u contact met mij opnemen.', 'Deze e-mail wordt door de sectieredacteur naar een reviewer gestuurd die bezig is met de beoordeling van een inzending teneinde de persoon in kwestie te laten weten dat de annulering van de beoordeling is teruggedraaid.'),
('REVIEW_REINSTATE', 'pl_PL', 'Ponowienie prośby o recenzje', '{$reviewerName}:<br />\n<br />\nChcielibyśmy ponowić prośbę o recenzję zgłoszenia, &quot;{$submissionTitle},&quot; dla $contextName}. Mamy nadzieję, że będzie Pan/ Pani mógł/mogła asystować w procesie recenzji dla tego czasopisma.<br />\n<br />\nW razie pytań, proszę się ze mną skontaktować.', 'Ten email jest wysłany przez Redaktora sekcji do recenzenta, który jest w trakcie recenzowania zgłoszenia, aby powiadomić, że anulowana recenzja została przywrócona.'),
('REVIEW_REINSTATE', 'pt_BR', 'Solicitação de revisão restabelecida', '{$reviewerName}:<br />\n<br />\nNós gostaríamos de convidá-lo(a) novamente para dar um parecer à submissão, &quot;{$submissionTitle},&quot; para o periódico {$contextName}. Nós esperamos que você possa nos ajudar no processo de avaliação por pares deste periódico.<br />\n<br />\nSe tiver alguma dúvida, por favor, entre em contato comigo.', 'Este e-mail é enviado pelo Editor de Seção a um Avaliador que possui uma avaliação de uma submissão em andamento para notificá-lo de que uma avaliação cancelada foi restabelecida.'),
('REVIEW_REINSTATE', 'pt_PT', 'Pedido de revisão restabelecida', '{$reviewerName}:<br />\n<br />\nGostaríamos de restabelecer o nosso pedido para que reveja esta submissão, &quot;{$submissionTitle},&quot; para a {$contextName}. Esperamos que esteja disponível para ajudar no processo de revisão a esta revista.<br />\n<br />\nSe tiver alguma questão, não hesite em contactar.', 'Este email é enviado pelo Editor de Secção ao Revisor que possui uma revisão em curso para o notificar de que uma revisão cancelada, foi restabelecida.'),
('REVIEW_REINSTATE', 'ro_RO', 'Cerere de revizuire reactivată', '{$reviewerName}:<br />\n<br />\nAm dori să vă retrimitem cererea noastră de a examina manuscrisul, &quot;{$submissionTitle},&quot; pentru {$contextName}. Sperăm că veți putea contribui la procesul de revizuire în cadrul acestei reviste.<br />\n<br />\nDacă aveți întrebări, vă rog să mă contactați.', 'Acest e-mail este trimis de către editorul de secțiuni unui revizor care are în revizuire o trimitere, pentru a-l anunța că o revizia anulată a fost restabilită.'),
('REVIEW_REINSTATE', 'ru_RU', 'Запрос на возобновление рецензирования', 'Здравствуйте, {$reviewerName}!<br />\n<br />\nМы бы хотели возобновить наш запрос на рецензирование Вами материала «{$submissionTitle}» для журнала «{$contextName}». Мы надеемся, что Вы сможете помочь нам в процессе рецензирования для этого журнала.<br />\n<br />\nЕсли у Вас есть вопросы, пожалуйста, свяжитесь со мной.', 'Это письмо редактора раздела, отправляемое рецензенту, который начал рецензировать материал, с уведомлением о том, что ранее отмененное рецензирование было возобновлено.'),
('REVIEW_REINSTATE', 'sk_SK', 'Žiadosť o recenziu bola obnovená', '{$reviewerName}:<br />\n<br />\nRadi by sme obnovili našu žiadosť o kontrolu príspevku &quot;{$submissionTitle},&quot; pre {$contextName}. Dúfame, že budete môcť pomôcť s procesom recenzií tohto časopisu. <br />\n<br />\nAk máte nejaké otázky, kontaktujte ma.', 'Tento e-mail je odoslaný editorom sekcie recenzentovi, ktorý práve vykonáva recenziu príspevku, aby mu oznámil, že zrušené recenzie boli obnovené.'),
('REVIEW_REINSTATE', 'sl_SI', 'Ponovna prošnja za recenzijo', '{$reviewerName}:<br />\n<br />\nPonovno bi vas radi prosili za recenzijo prispevka, &quot;{$submissionTitle},&quot; za{$contextName}. Upamo, da boste lahko sprejeli recenzijo in s tem pomagali pri uredniškem postopku.<br />\n<br />\nČe imate kakršnakoli vprašanja, se lahko obrnete name.', 'Email pošlje urednik rubrike recenzentu, ki mu je bila odvzeta zadolžitev za recenzijo in ponovno dodeljena.'),
('REVIEW_REINSTATE', 'sv_SE', 'Granskningsförfrågan återinsatt', '{$reviewerName}:<br />\n<br />\nVi vill återigen be dig att granska, &quot;{$submissionTitle},&quot; åt {$contextName}. Vi hoppas att du har möjlighet att bidra till tidskriftens granskningsprocess.<br />\n<br />\nKontakta gärna oss om du har några frågor.', 'Detta är ett e-postmeddelande från sektionsredaktören till granskare  som har en pågående granskning, för att meddela att en tidigare annullerad granskning har återupptagits.'),
('REVIEW_REINSTATE', 'tr_TR', 'Değerlendirme İsteği Eski Durumuna Getirildi', 'Sayın {$reviewerName},<br />\n<br />\n{$contextName}. için gönderilen &quot;{$submissionTitle},&quot başlıklı aday makaleyi değerlendirmeniz için hatırlatma yapmak istedik. Değerlendirme sürecine yardımcı olabileceğinizi umuyoruz.<br />\n<br />\nHerhangi bir sorunuz olursa, lütfen benimle iletişime geçin.', 'Bu e-posta, Bölüm Editör tarafından iptal edilmiş bir değerlendirmenin eski haline getirildiğini bildirmek için Hakem''e gönderilir.'),
('REVIEW_REINSTATE', 'uk_UA', 'Запит на відновлення рецензії', '{$reviewerName}:<br />\n<br />\nМи хотіли б відновити наш запит, щоб Ви ще раз переглянули подання, &quot;{$submissionTitle},&quot; для {$contextName}. Ми сподіваємось, що вам вдасться допомогти з процесом рецензування у цьому журналі. <br />\n<br />\nЯкщо у вас виникнуть якісь питання, будь ласка, зв''яжіться зі мною.', 'Цей лист надіслано Редактором Розділу до Рецензента, який почав рецензування, з повідомленням що скасоване рецензування було поновленим.'),
('REVIEW_REINSTATE', 'vi_VN', 'Khôi phục yêu cầu đánh giá bài báo', 'Kính gửi {$reviewerName},<br />\n<br />\nChúng tôi muốn khôi phục yêu cầu của chúng tôi để bạn đánh giá bài gửi, &quot;{$submissionTitle},&quot; cho {$contextName}. Chúng tôi hy vọng rằng bạn sẽ có thể hỗ trợ quá trình đánh giá của tạp chí này.<br />\n<br />\nNếu bạn có thắc mắc, xin vui lòng liên hệ với chúng tôi.', 'Email này được gửi bởi Biên tập viên chuyên mục tới Người phản biện đang tiến hành đánh giá bản thảo để thông báo cho họ rằng đánh giá bị hủy đã được khôi phục.'),
('REVIEW_REINSTATE', 'zh_CN', '恢复审核的请求', '{$reviewerName}:<br/>\n<br/>\n我们真心希望您能够替我们评阅 &quot;{$submissionTitle},&quot; ， {$contextName}，帮助我们审查期刊的论文稿件。<br/>\n<br/>\n如果您有任何问题，请同我们联系。', '此邮件由“栏目编辑”发送给正在进行审阅的审阅者，以通知他们先前取消的审阅已经恢复。'),
('REVIEW_REMIND', 'ar_IQ', 'تذكير لتحكيم طلب نشر', '{$reviewerName}:<br />\n<br />\nهذا مجرد تذكير لجنابكم الكريم بشأن تحكيمكم للمؤلَّف الموسوم &quot;{$submissionTitle},&quot; والمرسل إلى {$contextName}. نحن نأمل الحصول منكم على هذا التحكيم حتى يوم {$reviewDueDate}، ونرجو أن نتلقاه منكم حالماً تكونوا جاهزين لإرساله.<br />\n<br />\nإن لم يكن اسم الدخول وكلمة المرور متوفرين بين يديك لتتمكن من الولوج إلى موقع المجلة، بإمكانك اتباع الرابط أدناه لإعادة تعيين كلمة مرورك (التي عندها ستُرسل إليك مع اسم الدخول) عبر البريد الالكتروني. {$passwordResetUrl}<br />\n<br />\nرابط الطلب: {$submissionReviewUrl}<br />\n<br />\nلطفاً، أكدوا لنا قدرتكم على إكمال هذه المساهمة الحيوية في أعمال مجلتنا. إنني أتطلع إلى ردكم في أقرب وقت.<br />\n<br />\n{$editorialContactSignature}', 'هذه الرسالة يذكر بها محرر القسم محكماً قد استوجب إكمال تقييمه لمؤلَّف ما ولم يرسله/يرفعه إلى المجلة بعد.'),
('REVIEW_REMIND', 'bs_BA', 'Podsjetnik za predaju Recenzije', 'Poštovana/i {$reviewerName},<br />\n<br />\nželjeli bismo vas samo podsjetiti da je rok koji smo dogovorili za recenziju članka &quot;{$submissionTitle}&quot; za časopis {$contextName} istekao {$reviewDueDate}. Bilo bi nam izuzetno drago ukoliko biste recenziju završili i predali što je prije moguće.<br />\n<br />\nU slučaju da nemate pri ruci svoje korisničko ime ili lozinku za mrežnu stranicu časopisa, možete se koristi ovom poveznicom kako biste promijenili lozinku (koju ćemo vam tada, zajedno s korisničkim imenom, poslati putem e-pošte). {$passwordResetUrl}<br />\n<br />\nURL članka: {$submissionReviewUrl}<br />\n<br />\nMolimo vas da nas izvijestite u kojem ste roku u mogućnosti izraditi recenziju. Nadamo se skorom odgovoru.<br />\n<br />\nSrdačno,<br />\n{$editorialContactSignature}', 'Ovim obrascem e-pošte urednik rubrike podsjeća recenzenta da rok za izradu recenzije istekao.'),
('REVIEW_REMIND', 'ca_ES', 'Recordatori de revisió de la tramesa', 'Benvolgut/uda {$reviewerName},<br />\n<br />\nUs recordem la nostra petició per a revisar la tramesa &quot;{$submissionTitle}&quot; per a {$contextName}. Esperàvem aquesta revisió abans del {$reviewDueDate}, i confiem rebre-la tan aviat com la tingueu enllestida.<br />\n<br />\nSi heu perdut el vostre nom d''usuari o la vostra contrasenya per al lloc web de la revista, podeu utilitzar l''enllaç següent per a reinicialitzar la contrasenya (en rebreu una de nova per correu electrònic, juntament amb el vostre nom d''usuari). {$passwordResetUrl}<br />\n<br />\nURL de la tramesa: {$submissionReviewUrl}<br />\n<br />\nUs agrairem que ens confirmeu la vostra disponibilitat per a completar aquesta contribució vital per al funcionament de la revista, i confiem rebre notícies vostres ben aviat.<br />\n<br />\n{$editorialContactSignature}', 'Aquest missatge de correu electrònic té un editor de secció com a remitent i s''envia a un revisor per a recordar-li que ha superat la data de venciment per a lliurar la revisió.');
INSERT INTO `email_templates_default_data` VALUES
('REVIEW_REMIND', 'cs_CZ', 'Připomenutí recenze příspěvku', '{$reviewerName}:<br />\n<br />\nDovolujeme si Vám opatrně připomenout naši žádost o zpracování recenze příspěvku &quot;{$submissionTitle}&quot; pro {$contextName}. Doufali jsme, že budeme mít tuto recenzi hotovou do {$reviewDueDate} a budeme rádi, když ji od Vás dostaneme hned, jak ji budete moci dokončit.<br />\n<br />\nPokud nemáte své uživatelské jméno a heslo pro webovou stránku časopisu, můžete použít tento odkaz pro resetování Vašeho hesla (které Vám bude zasláno emailem spolu s Vaším uživatelským jménem). {$passwordResetUrl}<br />\n<br />\nURL příspěvku: {$submissionReviewUrl}<br />\n<br />\nPotvrďte prosím, zda můžete dokončit tento nezbytný úkol pro náš časopis. Těším se, že se ozvete.<br />\n<br />\n{$editorialContactSignature}', 'Tento email posílá editor sekce recenzentovi, aby mu připomněl, že vypršel termín pro zpracování recenze.'),
('REVIEW_REMIND', 'da_DK', 'Påmindelse om bedømmelse af manuskript', '{$reviewerName}:<br />\n<br />\nDette er blot for at minde dig om vores forespørgsel om din bedømmelse af manuskriptet &quot;{$submissionTitle}&quot; til {$contextName}. Vi havde håbet på at modtage bedømmelsen senest den {$reviewDueDate} og ser frem til at modtage den, så snart du er færdig med den.<br />\n<br />\nHvis du ikke har dit brugernavn og din adgangskode til tidsskriftets websted, kan du bruge dette link til at nulstille adgangskoden (som så vil blive sendt til dig via e-mail sammen med dit brugernavn). {$passwordResetUrl}<br />\n<br />\nManuskriptets URL-adresse: {$submissionReviewUrl}<br />\n<br />\nVi beder dig bekræfte, at du er i stand til at fuldføre dette vigtige bidrag til tidsskriftets arbejde. Jeg ser frem til at høre fra dig.<br />\n<br />\n{$editorialContactSignature}', 'Denne e-mail sendes af sektionsredaktøren til en bedømmer for at minde vedkommende om, at bedømmelsen skulle have været afleveret.'),
('REVIEW_REMIND', 'de_DE', 'Erinnerung an fälliges Gutachten', '{$reviewerName},<br />\n<br />\nwir möchten Sie freundlich an Ihre Zusage erinnern, den Beitrag &quot;{$submissionTitle}&quot; für {$contextName} zu begutachten. Wir hatten gehofft, das Gutachten bis zum {$reviewDueDate} zu erhalten. Wir würden uns freuen, wenn es uns baldmöglichst zur Verfügung stünde.<br />\n<br />\nFalls Ihnen Benutzer/innenname und Passwort fehlen, können Sie über folgenden Link Ihr Passwort neu setzen (Benutzer/innenname und Passwort gehen Ihnen umgehend per E-Mail zu). {$passwordResetUrl}<br />\n<br />\nURL des Beitrags: {$submissionReviewUrl}<br />\n<br />\nKönnten Sie uns bitte bestätigen, dass Sie nach wie vor bereit sind, unsere Zeitschrift gutachterlich zu unterstützen? Wir würden uns freuen, bald von Ihnen zu hören.<br />\n<br />\n{$editorialContactSignature}', 'Diese E-Mail wird von einer Rubrikredakteurin/einem Rubrikredakteur gesendet, um eine/n Gutachter/in daran zu erinnern, dass ihr/sein Gutachten fällig ist.'),
('REVIEW_REMIND', 'el_GR', 'Υπενθύμιση αξιολόγησης υποβολής', '{$reviewerName}:<br />\n<br />\nΤο παρόν μήνυμα αποτελεί υπενθύμιση του αιτήματός μας για αξιολόγηση της υποβολής &quot;{$submissionTitle},&quot; για το περιοδικό {$contextName}. Ελπίζουμε να έχουμε αυτή την αξιολόγηση μέχρι τις {$reviewDueDate} και θα σας είμαστε ευγνώμονες αν τη λάβουμε το συντομότερο δυνατό.<br />\n<br />\nΕάν δε διαθέτετε το όνομα Χρήστη και τον κωδικό πρόσβασης στον ιστότοπο του περιοδικού, μπορείτε να χρησιμοποιήσετε τον σύνδεσμο {$passwordResetUrl} για να επαναφέρετε τον κωδικό (ο οποίος θα σας σταλεί με ηλεκτρονικό μήνυμα, μαζί με το όνομα Χρήστη σας).<br />\n<br />\nΣύνδεσμος υποβολής: {$submissionReviewUrl}<br />\n<br />\nΠαρακαλούμε επιβεβαιώστε τη δυνατότητά σας να ολοκληρώσετε την αξιολόγηση. Ελπίζουμε να λάβουμε σύντομα την απάντησή σας.<br />\n<br />\n{$editorialContactSignature}', 'Το παρόν μήνυμα αποστέλλεται από τον Επιμελητή Ενότητας στον Αξιολογητή, ως υπενθύμιση ότι η αξιολόγηση εκκρεμεί.'),
('REVIEW_REMIND', 'en_US', 'Submission Review Reminder', '{$reviewerName}:<br />\n<br />\nJust a gentle reminder of our request for your review of the submission, &quot;{$submissionTitle},&quot; for {$contextName}. We were hoping to have this review by {$reviewDueDate}, and would be pleased to receive it as soon as you are able to prepare it.<br />\n<br />\nIf you do not have your username and password for the journal''s web site, you can use this link to reset your password (which will then be emailed to you along with your username). {$passwordResetUrl}<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nPlease confirm your ability to complete this vital contribution to the work of the journal. I look forward to hearing from you.<br />\n<br />\n{$editorialContactSignature}', 'This email is sent by a Section Editor to remind a reviewer that their review is due.'),
('REVIEW_REMIND', 'es_ES', 'Recordatorio de envío de revisión', '{$reviewerName}:<br />\n<br />\nLe recordamos nuestra petición de revisión del envío &quot;{$submissionTitle},&quot; para {$contextName}. Esperábamos su revisión antes del {$reviewDueDate}, esperamos nos la mande en cuanto la tenga lista.<br />\n<br />\nSi ha perdido su nombre de usuaria/o y contraseña para la revista puede pinchar en el siguiente enlace para cambiar su contraseña (se la enviaremos por correo-e junto con su nombre de usuaria/o). {$passwordResetUrl}<br />\n<br />\nURL del envío: {$submissionReviewUrl}<br />\n<br />\nLe rogamos nos confirme su disponibilidad para completar esta contribución vital para el trabajo de la revista. Esperamos tener noticias suyas a la mayor brevedad.<br />\n<br />\n{$editorialContactSignature}', 'Este correo es enviado por el/la Editor/a de Sección para recordar a un/a revisor/a que ya debe entregar su revisión.'),
('REVIEW_REMIND', 'eu_ES', 'Artikulua ebaluatzeko oroigarria', '{$reviewerName}:<br />\n<br />\n{$contextName} aldizkarirako &quot;{$submissionTitle}&quot; artikuluaren ebaluazioa gogorarazteko ohartxo bat baino ez. {$reviewDueDate} egunerako espero genuen zure ebaluazio-txostena, eta prestatuta daukazunean lehenbailehen bidaltzea eskertuko genizuke.<br />\n<br />\nEz badaukazu aldizkariaren webgunean sartzeko erabiltzaile-izenik eta pasahitzik, behean ematen den esteka erabil dezakezu pasahitza berrezartzeko (erabiltzaile-izenarekin batera bidaliko dizugu). {$passwordResetUrl}<br />\n<br />\nArtikuluaren URLa: {$submissionReviewUrl}<br />\n<br />\nMesedez, berrets iezaguzu aldizkariarentzat biziki garrantzitsua den lan hori burutuko duzula. Besterik gabe, zure erantzunaren zain geratzen naiz.<br />\n<br />\n{$editorialContactSignature}', 'Mezu hau Ataleko editoreak Ebaluatzaileari bidaltzen dio, ebaluazioa egiteko epea pasatu dela gogorarazteko.'),
('REVIEW_REMIND', 'fa_IR', 'یادآوری داوری مقاله ارسالی', '{$reviewerName}:<br />\n<br />\nاین فقط یک یادآوری درخواست {$contextName} از شما جهت بررسی مقاله ارسالی &quot;{$submissionTitle}&quot;است. امیدوار بودیم که متن داوری شما تا تاریخ &amp;lt;{$reviewDueDate}&amp;gt; به مجله ارسال شده باشد و بسیار خوشحال خواهیم شد اگر هرچه زودتر بتوانید آنرا آماده کرده و نسبت به ارسال آن اقدام کنید.<br />\n<br />\nچنانچه نام کاربری و رمز عبور خود مربوط به وب سایت این مجله را در دسترس ندارید، می توانید از پیوند زیر جهت دوباره تنظیم کردن رمزعبور خود استفاده کنید (که به همراه نام کاربری برایتان ارسال می گردد).<br />\n<br />\n<a href="{$passwordResetUrl}">{$passwordResetUrl}</a><br />\nآدرس مقاله: <a href="{$submissionReviewUrl}">{$submissionReviewUrl}</a><br />\n<br />\nلطفا آمادگی خودرا نسبت به انجام این کمک مهم به مجله اعلام نمائید. منتظر پاسخ شما هستیم.<br />\n<br />\n{$editorialContactSignature}', 'ایمیلی از طرف دبیر یا دبیر بخش به داور برای یادآوری انجام داوری'),
('REVIEW_REMIND', 'fi_FI', 'Muistutus käsikirjoituksen arvioinnista', 'Hyvä {$reviewerName},<br />\n<br />\nMuistuttaisin ystävällisesti pyynnöstämme arvioida käsikirjoitus &quot;{$submissionTitle}&quot; julkaisulle {$contextName}. Toivoimme saavamme arviointinne {$reviewDueDate} mennessä, ja nyt olisimme iloisia, mikäli voisitte lähettää arvioinnin meille heti sen suoritettuanne.<br />\n<br />\nJos ette muista käyttäjätunnustanne ja salasanaanne julkaisun verkkosivustolle, klikatkaa seuraavaa linkkiä vaihtaaksenne salasanan (salasana ja käyttäjätunnus lähetetään teille sähköpostitse). {$passwordResetUrl}<br />\n<br />\nKäsikirjoituksen URL: {$submissionReviewUrl}<br />\n<br />\nVahvistattehan vielä, voitteko suorittaa tämän arvioinnin.<br />\n\n<br />\n{$editorialContactSignature}', 'This email is sent by a Section Editor to remind a reviewer that their review is due.'),
('REVIEW_REMIND', 'fr_CA', 'Rappel d''évaluation d''une soumission', '{$reviewerName},<br />\n<br />\nCeci est un petit rappel concernant notre demande d''évaluation de la soumission « {$submissionTitle} » pour la revue {$contextName}. Nous espérions recevoir votre évaluation avant le {$reviewDueDate}. Nous serions heureux de la recevoir dès que possible.<br />\n<br />\nSi vous n''avez pas vos nom d''utilisateur-trice et mot de passe pour le site de la revue, vous pouvez utiliser le lien suivant pour réinitialiser votre mot de passe (lequel vous sera envoyé par courriel avec votre nom d''utilisateur-trice). {$passwordResetUrl}<br />\n<br />\nURL de la soumission : {$submissionReviewUrl}<br />\n<br />\nVeuillez confirmer que vous êtes en mesure d''effectuer ce travail essentiel pour la publication de notre revue. Nous espérons avoir de vos nouvelles très bientôt.<br />\n<br />\n{$editorialContactSignature}', 'Ce courriel est envoyé par le,la rédacteur-trice de rubrique pour rappeler à un,une évaluateur-trice que son évaluation est due.'),
('REVIEW_REMIND', 'fr_FR', 'Rappel d''évaluation d''une soumission', '{$reviewerName}:<br />\n<br />\nJuste un petit mot pour vous rappeler notre demande d''évaluation de la soumission intitulée « {$submissionTitle} » pour {$contextName}. Nous espérions recevoir votre évaluation avant le {$reviewDueDate}, et nous serions heureux de la recevoir dès que possible.<br />\n<br />\nSi vous n''avez pas de nom d''utilisateur ni de mot de passe pour le site Web de la revue, cliquer sur le lien ci-dessous pour réinitialiser votre mot de passe (qui vous sera alors envoyé par courriel avec votre nom d''utilisateur). {$passwordResetUrl}<br />\n<br />\nURL de la soumission : {$submissionReviewUrl}<br />\n<br />\nVeuillez confirmer que vous êtes en mesure d''effectuer ce travail essentiel pour la publication de notre revue. Nous espérons avoir de vos nouvelles très bientôt.<br />\n<br />\n{$editorialContactSignature}', 'Ce courriel est envoyé par le Rédacteur de rubrique pour rappeler à un rapporteur que son évaluation est due.'),
('REVIEW_REMIND', 'gd_GB', 'Cuimhneachan mu lèirmheas tagraidh', '{$reviewerName}:<br />\n<br />\nDìreach cuimhneachan beag gun deach iarraidh ort lèirmheas a dhèanamh air an tagradh “{$submissionTitle},” airson {$contextName}. Bha sinn an dòchas an lèirmheas seo a choileanadh ro {$reviewDueDate} agus bhiomaid fada nad chomain nam b’ urrainn dhut a chur thugainn cho luath ’s a ghabhas.<br />\n<br />\nMur eil am facal-faire is ainm-cleachdaiche agad airson làrach-lìn an iris-leabhair, ’s urrainn dhut am facal-faire agad ath-shuidheachadh leis a’ cheangal seo agus thèid a chur thugad air a’ phost-d an uairsin còmhla ris an ainm-chleachdaiche agad. {$passwordResetUrl}<br />\n<br />\nURL an tagraidh: {$submissionReviewUrl}<br />\n<br />\nSaoil am b’ urrainn dhut fios a leigeil thugainn am b’ urrainn dhut an obair chudromach seo a dhèanamh airson an iris-leabhair fhathast? Tha mi an dòchas cluinntinn uat.<br />\n<br />\n{$editorialContactSignature}', 'Thèid am post-d seo a chur gu lèirmheasaiche le deasaiche earrainn airson cur na c(h)uimhne gu bheil an lèirmheas aca ri lìbhrigeadh.'),
('REVIEW_REMIND', 'he_IL', 'תזכורת שליחת חוות דעת', '{reviewerName$}:<br />\n<br />\nזוהי תזכורת לבקשתנו לחוות דעתך על ההגשה "{submissionTitle$} ל{contextName$}. קוינו לקבל את חוות הדעת עד {revewDueDate$}, ונשמח לקבל את זה בהקדם.<br />\n<br />\nאם אין ברשותך שם משתמש וסיסמתך לאתר כתב העת, ניתן לאפס אותו עם לינק זה (ישלח אליך בדוא"ל עם שם משתמש שלך). {passwordResetUrl$}<br />\n<br />\nאתר הגשה: {submissionReviewUrl$}<br />\n<br />\nנא לאשר הסכמתך לסקור את המאמר ולהגיש חוות דעת. מחכים לשמוע ממך.<br />\n<br />\n{editorialContactSignature$}', 'דוא"ל זה נשלח על ידי עורך מדור להזכיר מבקר שהביקורת שלהם נובעת.'),
('REVIEW_REMIND', 'hi_IN', 'सबमिशन रिव्यू रिमाइंडर', '{$reviewerName}:<br />\n<br />\nप्रस्तुत करने की आपकी समीक्षा के लिए हमारे अनुरोध का एक सौम्य अनुस्मारक, &quot;{$submissionTitle},&quot; for {$contextName}. हम {$ reviewDueDate} द्वारा इस समीक्षा की उम्मीद कर रहे थे, और जैसे ही आप इसे तैयार करने वाले हैं, इसे प्राप्त करके प्रसन्न होंगे.<br />\n<br />\nयदि आपके पास जर्नल की वेब साइट के लिए आपका उपयोगकर्ता नाम और पासवर्ड नहीं है, तो आप अपना पासवर्ड रीसेट करने के लिए इस लिंक का उपयोग कर सकते हैं (जो तब आपके उपयोगकर्ता नाम के साथ आपको ईमेल किया जाएगा)। {$ PasswordResetUrl}<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nकृपया जर्नल के काम में इस महत्वपूर्ण योगदान को पूरा करने की अपनी क्षमता की पुष्टि करें। तुम्हारे उत्तर की प्रतीक्षा है मुझे.<br />\n<br />\n{$editorialContactSignature}', 'यह ईमेल एक अनुभाग संपादक द्वारा एक समीक्षक को याद दिलाने के लिए भेजा जाता है कि उनकी समीक्षा होने वाली है.'),
('REVIEW_REMIND', 'hr_HR', 'Podsjetnik za predaju Recenzije', 'Poštovana/i {$reviewerName},<br />\n<br />\nželjeli bismo vas samo podsjetiti da je rok koji smo dogovorili za recenziju članka &quot;{$submissionTitle}&quot; za časopis {$contextName} istekao {$reviewDueDate}. Bilo bi nam izuzetno drago ukoliko biste recenziju završili i predali što je prije moguće.<br />\n<br />\nU slučaju da nemate pri ruci svoje korisničko ime ili lozinku za mrežnu stranicu časopisa, možete se koristi ovom poveznicom kako biste promijenili lozinku (koju ćemo vam tada, zajedno s korisničkim imenom, poslati putem e-pošte). {$passwordResetUrl}<br />\n<br />\nURL članka: {$submissionReviewUrl}<br />\n<br />\nMolimo vas da nas izvijestite u kojem ste roku u mogućnosti izraditi recenziju. Nadamo se skorom odgovoru.<br />\n<br />\nSrdačno,<br />\n{$editorialContactSignature}', 'Ovim obrascem e-pošte urednik rubrike podsjeća recenzenta da rok za izradu recenzije istekao.'),
('REVIEW_REMIND', 'hu_HU', 'Emlékeztető cikk szakmai lektorálásáról', 'Tisztelt {$reviewerName}!<br />\n<br />\nÉrtesítjük, hogy a(z) {$contextName} folyóirat &quot;{$submissionTitle},&quot; című cikkének lektorálási határideje ({$reviewDueDate}) lejárt.<br />\nKérjük mielőbb készítse el szakmai bírálatát.<br />\n<br />\nKézirat URL: {$submissionReviewUrl}<br />\n<br />\nHa elfelejtette felhasználónevét vagy jelszavát, az alábbi linken emlékeztetőt kérhet. (Jelszavát és felhasználónevét emailben küldjük el.)<br />\n{$passwordResetUrl}<br />\n<br />\nKérjük, határidő módosításának ügyében vegye fel a kapcsolatot a szerkesztőséggel!<br />\n<br />\nÜdvözlettel,<br />\n{$editorialContactSignature}', 'Ezt az emailt a Rovatszerkesztő küldi a Szakmai Lektornak, hogy emlékeztesse a lektorálási határidőre.'),
('REVIEW_REMIND', 'id_ID', 'Pengingat Review Naskah', '{$reviewerName}:<br />\n<br />\nSekedar mengingatkan tentang permohonan kami untuk melakukan review terhadap naskah, &quot;{$submissionTitle},&quot; untuk {$contextName}. Kami mengharapkan telah menerima review ini pada {$reviewDueDate}, dan akan sangat berbahagia untuk dapat menerimanya segera setelah Anda menyelesaikannya.<br />\n<br />\nJika Anda tidak memiliki nama pengguna dan sandi untuk website jurnal ini, Anda dapat menggunakan tautan berikut untuk mereset sandi Anda (yang selanjutnya akan diemailkan kepada Anda bersama nama pengguna Anda). {$passwordResetUrl}<br />\n<br />\nURL Naskah: {$submissionReviewUrl}<br />\n<br />\nMohon konfirmasi kesanggupan Anda untuk menyelesaikan kontribusi penting ini.  Kami menunggu balasan Anda.<br />\n<br />\n{$editorialContactSignature}', 'Email ini dikirimkan Editor Bagian untuk mengingatkan reviewer bahwa review telah mencapai tenggat.'),
('REVIEW_REMIND', 'it_IT', 'Promemoria revisione in attesa', 'Gentile {$reviewerName}:<br />\n<br />\nTi ricordo la richiesta di revisione della submission, &quot;{$submissionTitle},&quot; per {$contextName}. La data di scadenza prevista è {$reviewDueDate}.<br />\n<br />\nSe non hai una username and password per il sito web della rivista, puoi usare questo link per resettare la  password (che ti sarà quindi mandata per email insieme con la username). {$passwordResetUrl}<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nTi chiedo la cortesia di di confermare la volontà di portare a termine l''incarico.<br />\n<br />\n{$editorialContactSignature}', 'Questa email viene mandata da un section editor per ricordare al revisore che è attesa la revisione.'),
('REVIEW_REMIND', 'ja_JP', '論文査読の督促', '{$reviewerName} 様:<br />\n<br />\n雑誌『{$contextName}』への投稿原稿「{$submissionTitle}」の査読は進んでいるでしょうか。査読期限日は、{$reviewDueDate}となっております。準備ができ次第できるだけ早く査読結果をいただきたいと考えております。<br />\n<br />\n雑誌のWebサイトにログインするユーザー名とパスワードをお持ちでない場合は、次のリンクを使ってパスワードをリセットしてください（パスワードはユーザー名と共にメールで送信されます）： {$passwordResetUrl}<br />\n<br />\n投稿物のURL: {$submissionReviewUrl}<br />\n<br />\n本誌の投稿物にとって極めて重要なこの貢献を貴殿が遂行できることを確認してください。お返事をお待ちしております。<br />\n<br />\nよろしくお願いいたします。<br />\n<br />\n{$editorialContactSignature}', 'このメールは、セクションエディタから査読者に査読期限日が過ぎたことを督促するものです。'),
('REVIEW_REMIND', 'ku_IQ', 'بیرخەرەوەی هەڵسەنگاندنی توێژینەوە', '{$reviewerName}:<br />\n<br />\nبیرخەرەوەی هەڵسەنگاندنی توێژینەوەی &quot;{$submissionTitle},&quot; بۆ{$contextName}.ئێمە هیواخوازین کە هەڵسەنگاندنەکەتان هەتا {$reviewDueDate} تەواو بێت و بە هیواین لە نزیکترین دەرفەتتدا تێبینی و بڕیارەکانتان دەربارەی توێژینەوەکە بنێرن.<br />\n<br />\nئەگەر تۆ هەژمار و وشەی نهێنیت نییە، دەتوانیت لێرەوە داوای وشەیەکی نهێنیی نوێ بکەیت (کە بە ئیمەیڵ لەگەڵ ناوی بەکارهێنەر بە دەستت دەگات). {$passwordResetUrl}<br />\n<br />\nلینکی توێژینەوەکە: {$submissionReviewUrl}<br />\n<br />\nتکایە دڵنیامان بکەوە لە هاوکاریت و بڕیاری هەڵسەنگاندنی توێژینەوەکە، ئێمە چاوەڕێی وەڵامی ئێوەین.<br />\n<br />\n{$editorialContactSignature}', 'ئەم ئیمەیڵە لە لایەن سەرنوسەری بەشەوە بۆ هەڵسەنگێنەر دەنێردرێت وەک بیرخەرەوەیەکی کاتی هەڵسەنگاندنەکە.'),
('REVIEW_REMIND', 'mk_MK', 'Потсетник за поднесување на рецензија', '{$reviewerName}:<br />\n<br />\nМал потсетник за нашето барање за вашата рецензија на поднесокот, &quot;{$submissionTitle},&quot; за {$contextName}. Се надевавме дека ќе ја добиеме вашата рецензија до {$reviewDueDate}, и би биле задоволни да ја добиеме веднаш штом ќе можете да ја подготвите.<br />\n<br />\nДоколку не ги имате вашето корисничко име и лозинка за веб-страницата на списанието, можете да го искористите овој линк за да ја ресетирате вашата лозинка (која потоа ќе ви биде испратена преку и-меил заедно со вашето корисничко име). {$passwordResetUrl}<br />\n<br />\nURL-адреса на поднесокот: {$submissionReviewUrl}<br />\n<br />\nВе молам за потврда дека можете да го завршите овој неопходен придонес кон работата на ова списание. Со нетрпение очекувам да слушнам од вас.<br />\n<br />\n{$editorialContactSignature}', 'Овој и-меил е испратен од Секциски уредник како потсетник до рецензентот дека рокот за нивната рецензија е достигнат.'),
('REVIEW_REMIND', 'nb_NO', 'Påminnelse om fagfellevurdering', '{$reviewerName}:<br />\n<br />\nDenne e-posten sendes for å minne deg på at du har tatt på deg å vurdere innleveringen «{$submissionTitle}» for {$contextName}. Jeg minner om at fristen var satt til {$reviewDueDate}, og ser fram til å motta vurderingen din så snart den er klar.<br />\n<br />\nHvis du ikke har brukernavnet og passordet ditt til tidsskriftets nettsted, kan du bruke denne lenken for å fornye passordet (som du så får tilsendt i en e-post, sammen med brukernavnet ditt): {$passwordResetUrl}<br />\n<br />\nInnleveringens URL: {$submissionReviewUrl}<br />\n<br />\nKan du bekrefte om du fortsatt vil fullføre vurderingen for tidsskriftet vårt? Jeg ser fram til å høre fra deg.<br />\n<br />\n{$editorialContactSignature}', 'Denne e-posten sendes av en seksjonsredaktør til en fagfelle for å minne om at fagfellevurderingen ventes ferdigstilt innen fristen.'),
('REVIEW_REMIND', 'nl_NL', 'Review herinnering', '{$reviewerName}:<br />\n<br />\nWe willen u vriendelijk herinneren aan ons verzoek om de inzending &quot;{$submissionTitle}&quot; voor {$contextName} te reviewen. We verwachtten uw review op {$reviewDueDate}. We stellen het zeer op prijs om de review te ontvangen zodra u in de gelegenheid bent om die uit te voeren.<br />\n<br />\nAls u de gebruikersnaam en het wachtwoord van de website van het tijdschrift niet heeft, kunt u deze link gebruiken voor het herstellen van uw wachtwoord (dat samen met uw gebruikersnaam in een e-mail naar u verstuurd wordt). {$passwordResetUrl}<br />\n<br />\nURL inzending: {$submissionReviewUrl}<br />\n<br />\nWilt u uw beschikbaarheid voor het voltooien van deze voor het werk van het tijdschrift vitale taak bevestigen. Ik kijk uit naar uw reactie.<br />\n<br />\n{$editorialContactSignature}', 'Deze e-mail wordt door de sectieredacteur verstuurd om een reviewer eraan te herinneren dat de afgesproken reviewperiode verstreken is.'),
('REVIEW_REMIND', 'pl_PL', 'Przypomnienie o terminie przygotowania recenzji', 'Szanowna Pani/ Szanowny Panie,<br />\n<br />\nprzypominamy, że w dniu {$reviewDueDate} mija termin wykonania recenzji tekstu "{$submissionTitle}", zgłoszonego do czasopisma "{$contextName}". Prosimy o nadesłanie do tego czasu ukończonej recenzji.<br />\n<br />\nJeżeli nie posiada Pani/ Pan danych niezbędnych do zalogowania na stronie czasopisma, prosimy zresetować hasło przechodząc na stronę: {$passwordResetUrl}<br />\n<br />\nWWW tekstu: {$submissionReviewUrl}<br />\n<br />\nZ wyrazami szacunku, <br />\n{$editorialContactSignature}<br />', 'Wiadomość wysyłana przez redaktora prowadzącego do recenzenta. Zawiera przypomnienie o terminie wykonania recenzji.'),
('REVIEW_REMIND', 'pt_BR', 'Lembrete de solicitação de avaliação', '{$reviewerName}:<br />\n<br />\nEste é apenas um lembrete amigável do nosso pedido de avaliação da submissão, &quot;{$submissionTitle},&quot; ao periódico {$contextName}. Esperávamos ter recebido sua avaliação até {$reviewDueDate}, então gostaríamos de recebê-la assim que você conseguir prepará-la.<br />\n<br />\nSe você não tiver seu nome de usuário e senha para o site do periódico, poderá usar este link para redefinir sua senha (que será enviada por e-mail juntamente com seu nome de usuário). {$passwordResetUrl}<br />\n<br />\nURL da submissão: {$submissionReviewUrl}<br />\n<br />\nPor favor, confirme que poderá completar essa contribuição vital ao trabalho do periódico. Aguardo seu retorno.<br />\n<br />\n{$editorialContactSignature}', 'Mensagem enviada pelo Editor de Seção ao Avaliador como lembrete da tarefa de avaliação em andamento ainda não concluída.'),
('REVIEW_REMIND', 'pt_PT', 'Lembrete de pedido de revisão', '{$reviewerName}:<br />\n<br />\nEsta mensagem é apenas um lembrete relativamente ao pedido de revisão da submissão &quot;{$submissionTitle}&quot; à revista {$contextName}. Esperávamos receber a sua revisão até {$reviewDueDate} e aguardamos a receção assim que for possível.<br />\n<br />\nCaso não possua o nome de utilizador e a senha para aceder ao sistema da revista, use o link a seguir para criar uma nova senha, que lhe será enviada via email junto com os seus dados de acesso. {$passwordResetUrl}<br />\n<br />\nURL da Submissão: {$submissionReviewUrl}<br />\n<br />\nConfirme a sua disponibilidade para concluir a revisão, contribuição vital para a qualidade desta publicação.\nAguardando o seu contacto,<br />\n<br />\n{$editorialContactSignature}', 'Este e-mail é enviado pelo Editor de Secção ao Revisor como lembrete da tarefa de revisão em curso.'),
('REVIEW_REMIND', 'ro_RO', 'Memento de revizuire a manuscrisului', '{$reviewerName}:<br />\n<br />\nVă reamintim că ați acceptat să revizuiți manuscrisul, &quot;{$submissionTitle},&quot; fpentru {$contextName}. Sperăm că veți finaliza această revizuire până la {$reviewDueDate}, pentru a putea continua procesul editorial.<br /> \n<br />\nDacă nu aveți numele de utilizator și parola pentru site-ul web al jurnalului, puteți utiliza acest link pentru a vă reseta parola (care vă va fi apoi trimisă prin e-mail împreună cu numele de utilizator). {$passwordResetUrl}<br />\n<br />\nLink înregistrare: {$submissionReviewUrl}<br />\n<br />\nToate cele bune.<br />\n<br />\n{$editorialContactSignature}', 'Acest e-mail este trimis de un editor de secțiune pentru a reaminti recenzorului că revizuirea sa se apropie de data limită.'),
('REVIEW_REMIND', 'ru_RU', 'Напоминание о рецензии на материал', 'Здравствуйте, {$reviewerName}:<br />\n<br />\nЭто напоминание о нашем запросе Вашей рецензии на материал «{$submissionTitle}» для журнала «{$contextName}». Мы надеялись получить эту рецензию до {$reviewDueDate} и будем рады, если Вы как можно скорее ее подготовите.<br />\n<br />\nЕсли у Вас нет имени пользователя и пароля для доступа к сайту журнала, Вы можете воспользоваться этой ссылкой для сброса Вашего пароля (он будет направлен Вам вместе с Вашим именем пользователя на электронную почту). {$passwordResetUrl}<br />\n<br />\nURL материала: {$submissionReviewUrl}<br />\n<br />\nПожалуйста, подтвердите, что Вы сможете сделать этот важный вклад в работу нашего журнала. Жду вашего ответа.<br />\n<br />\n{$editorialContactSignature}', 'Это письмо отправляется редактором раздела, чтобы напомнить рецензенту о том, что срок предоставления рецензии уже прошел.'),
('REVIEW_REMIND', 'sk_SK', 'Pripomenutie recenzie príspevku', '{$reviewerName}:<br />\n<br />\nDovoľujeme si Vám opatrne pripomenúť našu žiadosť o spracovanie recenzie príspevku &quot;{$submissionTitle}&quot; pre {$contextName}. Dúfali sme, že budeme mať túto recenziu hotovú do {$ reviewDueDate} a budeme radi, keď ju od Vás dostaneme hneď, ako ju budete môcť dokončiť.<br />\n<br />\nAk nemáte svoje používateľské meno a heslo pre webovú stránku časopisu, môžete použiť tento odkaz pre obnovenie Vášho hesla (ktoré Vám bude zaslané emailom spolu s Vašim používateľským menom). {$passwordResetUrl}<br />\n<br />\nURL príspevku: {$submissionReviewUrl}<br />\n<br />\nPotvrďte nám prosím, či môžete dokončiť túto nevyhnutnú úlohu pre náš časopis. Tešíme sa, že sa ozvete.<br />\n<br />\n{$editorialContactSignature}', 'Tento email posiela editor sekcie recenzentovi, aby mu pripomenul, že vypršal termín pre spracovanie recenzie.'),
('REVIEW_REMIND', 'sl_SI', 'Opomnik za recenzijo prispevka', '{$reviewerName}:<br />\n<br />\nSamo prijazen opomnik za našo prošnjo za recenzijo prispevka, &quot;{$submissionTitle},&quot; za revijo {$contextName}. Upali smo, da boste opravili recenzijo do predvidenega datuma {$reviewDueDate}. Z veseljem jo bomo sprejeli takoj, ko jo pripravite.<br />\n<br />\nČe nimate uporabniškega imena in gesla za dostop do spletne strani revije, lahko uporabite naslednjo povezavo za ponastavitev gesla (ki vam bo posredovano po e-pošti skupaj z vašim uporabniškim imenom): {$passwordResetUrl}<br />\n<br />\nURL povezava do prispevka: {$submissionReviewUrl}<br />\n<br />\nProsim, če potrdite vašo pripravljenost za dokončanje vašega pomembnega prispevka za delo revije. Veselimo se vašega odgovora.<br />\n<br />\n{$editorialContactSignature}', 'Ta email pošlje urednik rubrike recenzentu kot opomnik za opravljanje recenzije.'),
('REVIEW_REMIND', 'sv_SE', 'Påminnelse om granskning av bidrag', '{$reviewerName}:<br />\n<br />\nDet här är bara en påminnelse om vår förfrågan om din granskning av bidraget &quot;{$submissionTitle}&quot; för {$contextName}. Vi hade hoppats på att få din granskning senast {$reviewDueDate} och skulle vara tacksamma om du ville inkomma med den så fort som möjligt.<br />\n<br />\nOm du har glömt ditt användarnamn och/eller lösenord till tidskriftens webbplats, använd följande länk för att återställa lösenordet: {$passwordResetUrl}. Dina inloggningsuppgifter skickas då till dig per e-post.<br />\n<br />\nBidragets URL: {$submissionReviewUrl}<br />\n<br />\nVänligen bekräfta snarast om du har möjlighet att genomföra granskningsuppdraget, som utgör en viktig del av tidskriftens arbete. Vi ser fram emot att höra från dig.<br />\n<br />\n{$editorialContactSignature}', 'Det här e-postmeddelandet skickas från en sektionsredaktör som en påminnelse till granskaren att deadline för granskningen har passerat.'),
('REVIEW_REMIND', 'tr_TR', 'Değerlendirme Konusunda Hatırlatma', 'Sayın {$reviewerName},<br />\n<br />\n{$contextName} adlı dergide yayınlanması için değerlendirilmek üzere gönderilen &quot;{$submissionTitle}&quot; başlıklı çalışmanın değerlendirmesini {$reviewDueDate} tarihinden önce tamamlayacağınızı ümit ediyoruz. Yoğun işleriniz arasında değerlendirme raporunuzu tamamlayıp, bize bir an önce ileteceğiniz inancı ile dergimiz sitesindeki ulaşım bilgilerini size iletmeyi istedik.<br />\n<br />\nEğer derginin web sitesine giriş için kullanıcı adı ve şifreniz yoksa veya unuttunuz ise, şifrenizi yenilemek için bu bağlantıyı kullanabilirsiniz (Kullanıcı adınızla birlikte şifreniz size postalanacaktır). {$passwordResetUrl}<br />\n<br />\nMakale Erişim Adresi: {$submissionReviewUrl}<br />\n<br />\nDerginin kalitesini arttıracak bu önemli katkıyı yapabileceğinizi lütfen onaylayınız. <br />\n<br />\n{$editorialContactSignature}', 'Bu elektronik posta gözden geçirmeyi yapan kişiye işlemin zamanının dolmakta olduğunu hatırlatmak için Bölüm Editörü tarafından gönderilir.'),
('REVIEW_REMIND', 'uk_UA', 'Нагадування про рецензування', '{$reviewerName}:<br />\n<br />\nХотів б нагадати Вам про рецензування подання &quot;{$submissionTitle}&quot; для видання &quot;{$contextName}&quot;. Ми очікували отримати цю рецензію до {$reviewDueDate}. Будь ласка, надішліть нам її якомога скоріше.<br />\n<br />\nЯкщо Ви не зберегли імені користувача та пароль для веб-сайту журналу, Ви можете скористатися наступним посиланням для того, щоб скинути свій пароль (після цього пароль та ім''я користувача будуть відправлені Вам електронною поштою). <a href="{$passwordResetUrl}">{$passwordResetUrl}</a><br />\n<br />\nURL подання: {$submissionReviewUrl}<br />\n<br />\nБудь ласка, підтвердіть можливість завершити цю важливу для нашого журналу роботу. З нетерпінням очікую Вашої відповіді.<br />\n<br />\n{$editorialContactSignature}', 'Цим листом редактор розділу нагадує рецензенту про настання кінцевої дати рецензування.'),
('REVIEW_REMIND', 'vi_VN', 'Nhắc nhở nộp đánh giá', 'Kính gửi {$reviewerName},<br />\n<br />\nĐây là nhắc nhở về yêu cầu của chúng tôi để bạn xem xét bài gửi, &quot;{$submissionTitle},&quot; for {$contextName}. Chúng tôi hy vọng sẽ có đánh giá này vào ngày {$reviewDueDate}, và sẽ rất vui khi nhận được nó ngay khi bạn có thể gửi nó.<br />\n<br />\nNếu bạn không có username và mật khẩu cho trang web của tạp chí, bạn có thể sử dụng liên kết này để đặt lại mật khẩu của mình (sau đó sẽ được gửi qua email cho bạn cùng với username của bạn). {$passwordResetUrl}<br />\n<br />\nURL bài gửi: {$submissionReviewUrl}<br />\n<br />\nVui lòng xác nhận khả năng hoàn thành quy trình quan trọng này cho công việc của tạp chí. Chúng tôi mong nhận được phản hồi của bạn.<br />\n<br />\n{$editorialContactSignature}', 'Email này được gửi bởi một Biên tập viên chuyên mục để nhắc nhở người phản biện rằng đánh giá của họ đến hạn nộp.'),
('REVIEW_REMIND', 'zh_CN', '稿件审查提醒函', '{$reviewerName}:<br />\n<br />\n这封信只是礼貌地提醒您，我们已邀请您为《{$contextName}》审查稿件〈{$submissionTitle}〉。我们希望您<br />\n能在 {$reviewDueDate}前完成这份审查工作，并请您在备妥审查意见书之后尽快寄给我们。<br />\n<br />\n如果您没有您在这个期刊网站的用户帐号和密码。您可以使用这个链接去重新设定您的密码（该密码会和您的用户帐号名称一起电邮给您）：{$passwordResetUrl}<br />\n<br />\n稿件网址：{$submissionReviewUrl}<br />\n<br />\n请确认您能够完成这个对本期刊作品而言非常重要的审稿任务。我们期盼得到您的回复。<br />\n<br />\n{$editorialContactSignature}', '这封电子邮件是由区段编辑发出，提醒一位审查人他们的审查工作已经到期。'),
('REVIEW_REMIND_AUTO', 'ar_IQ', 'تذكير آلي لتحكيم طلب نشر', '{$reviewerName}:<br />\n<br />\nهذا مجرد تذكير لجنابكم الكريم بشأن تحكيمكم للمؤلَّف الموسوم &quot;{$submissionTitle},&quot; والمرسل إلى {$contextName}. نحن نأمل الحصول منكم على هذا التحكيم حتى يوم {$reviewDueDate} وهذه الرسالة مولدة آلياً نظراً لتجاوز ذلك التاريخ. مع ذلك، يسرنا أن نتلقاه منكم حالماً تكونوا جاهزين لإرساله.<br />\n<br />\nإن لم يكن اسم الدخول وكلمة المرور متوفرين بين يديك لتتمكن من الولوج إلى موقع المجلة، بإمكانك اتباع الرابط أدناه لإعادة تعيين كلمة مرورك (التي عندها ستُرسل إليك مع اسم الدخول) عبر البريد الالكتروني. {$passwordResetUrl}<br />\n<br />\nرابط الطلب: {$submissionReviewUrl}<br />\n<br />\nلطفاً، أكدوا لنا قدرتكم على إكمال هذه المساهمة الحيوية في أعمال مجلتنا. إنني أتطلع إلى ردكم في أقرب وقت.<br />\n<br />\n{$editorialContactSignature}', 'هذه الرسالة يولدها الموقع آلياً عندما يتم تجاوز موعد تسليم التحكيم من قبل أحد المحكمين (أنظر خيارات التحكيم ضمن: الإعدادات، المخطط الانسيابي، التحكيم) وعندما يكون خيار الوصول المباشر للمحكم غير مفعل. المهام المجدول يجب أن تكون مفعلة ومهيئة (أنظر ملف تهيئة الموقع.'),
('REVIEW_REMIND_AUTO', 'bs_BA', 'Automatski podsjetnik za predaju recenzije', 'Poštovana/i {$reviewerName},<br />\n<br />\nželjeli bismo vas samo podsjetiti da je rok koji smo dogovorili za recenziju članka &quot;{$submissionTitle}&quot; za časopis {$contextName} istekao. Nadali smo se da će recenzija biti gotova do {$reviewDueDate}. Ova poruka se automatski šalje nakon prolaska tog datuma. Molimo vas da nam recenziju pošaljete u najskorijem roku.<br />\n<br />\nU slučaju da nemate pri ruci svoje korisničko ime ili lozinku za mrežnu stranicu časopisa, možete se koristiti ovom poveznicom kako biste promijenili lozinku (koju ćemo vam tada, zajedno s korisničkim imenom, poslati putem e-pošte). {$passwordResetUrl}<br />\n<br />\nURL članka: {$submissionReviewUrl}<br />\n<br />\nMolimo vas da nas izvijestite u kojem ste roku u mogućnosti izraditi recenziju. Nadamo se skorom odgovoru.<br />\n<br />\nSrdačno,<br />\n{$editorialContactSignature}', 'Ovaj se obrazac e-pošte automatski šalje recenzentu kada datum naveden kao rok za izradu recenzije istekao (pogledajte Opcije recenzije unutar Postavljanja časopisa, 2. korak), a recenzentu nije omogućen pristup jednim klikom. Za ovu funkciju Raspoređeni zadaci moraju biti aktivirani i namješteni (pogledajte konfiguracijsku datoteku stranice).'),
('REVIEW_REMIND_AUTO', 'ca_ES', 'Recordatori automàtic de revisió de la tramesa', 'Benvolgut/uda {$reviewerName},<br />\n<br />\nUs recordem la nostra petició per a revisar la tramesa &quot;{$submissionTitle}&quot; per a {$contextName}. Esperàvem aquesta revisió abans del {$reviewDueDate}, i aquest missatge de correu electrònic s''ha generat i enviat automàticament en haver-se superat aquesta data. Malgrat això, encara confiem rebre la vostra revisió tan aviat com la tingueu enllestida.<br />\n<br />\nSi heu perdut el vostre nom d''usuari o la vostra contrasenya per al lloc web de la revista, podeu utilitzar l''enllaç següent per a reinicialitzar la contrasenya (en rebreu una de nova per correu electrònic, juntament amb el vostre nom d''usuari). {$passwordResetUrl}<br />\n<br />\nURL de la tramesa: {$submissionReviewUrl}<br />\n<br />\nUs agrairem que ens confirmeu la vostra disponibilitat per a completar aquesta contribució vital per al funcionament de la revista, i confiem rebre notícies vostres ben aviat.<br />\n<br />\n{$editorialContactSignature}', 'Aquest missatge de correu electrònic s’envia automàticament quan se supera la data de venciment per a una revisió (vegeu les opcions de revisió del pas 2 de la configuració de la revista) i s''ha inhabilitat l''accés per a revisors en un clic. Les tasques planificades han d''estar habilitades i configurades (vegeu el fitxer de configuració del lloc).'),
('REVIEW_REMIND_AUTO', 'cs_CZ', 'Automatické připomenutí recenze příspěvku', '{$reviewerName}:<br />\n<br />\nDovolujeme si Vám opatrně připomenout naši žádost o zpracování recenze příspěvku &quot;{$submissionTitle}&quot; pro {$contextName}. Doufali jsme, že budeme mít tuto recenzi hotovou do {$reviewDueDate} a tento email byl automaticky vygenerován a poslán, jelikož stanovený termín již vypršel. Budeme velice rádi, když od Vás recenzi dostaneme hned, jak ji budete moci dokončit.<br />\n<br />\nPokud nemáte své uživatelské jméno a heslo pro webovou stránku časopisu, můžete použít tento odkaz pro resetování Vašeho hesla (které Vám bude zasláno emailem spolu s Vaším uživatelským jménem). {$passwordResetUrl}<br />\n<br />\nURL příspěvku: {$submissionReviewUrl}<br />\n<br />\nPotvrďte prosím, zda můžete dokončit tento nezbytný úkol pro náš časopis. Těším se, že se ozvete.<br />\n<br />\n{$editorialContactSignature}', 'Tento email je automaticky poslán, když recenzentovi vyprší stanovený termín pro zpracování recenze (viz Možnosti recenze v Nastavení časopisu, Krok 2) a je zakázán přístup recenzenta na jedno kliknutí. Musí být povoleny a nakonfigurovány naplánované úlohy (viz konfigurační soubor stránky).'),
('REVIEW_REMIND_AUTO', 'da_DK', 'Automatisk påmindelse om bedømmelse af manuskript', '{$reviewerName}:<br />\n<br />\nDette er blot for at minde dig om vores forespørgsel om din bedømmelse af manuskriptet &quot;{$submissionTitle}&quot; til {$contextName}. Vi havde håbet på at modtage bedømmelsen senest den {$reviewDueDate}, og denne e-mail er blevet automatisk genereret og sendt til dig, da den pågældende dato er overskredet. Vi ser stadig frem til at modtage den, så snart du er færdig med den.<br />\n<br />\nHvis du ikke har dit brugernavn og din adgangskode til tidsskriftets websted, kan du bruge dette link til at nulstille adgangskoden (som så vil blive sendt til dig via e-mail sammen med dit brugernavn). {$passwordResetUrl}<br />\n<br />\nManuskriptets URL-adresse: {$submissionReviewUrl}<br />\n<br />\nVi beder dig bekræfte, at du er i stand til at fuldføre dette vigtige bidrag til tidsskriftets arbejde. Jeg ser frem til at høre fra dig.<br />\n<br />\n{$editorialContactSignature}', 'Denne e-mail sendes automatisk, når en bedømmers forfaldsdato overskrides (se Bedømmelsesindstillinger under Indstillinger> Workflow > Bedømmelse), og når adgang for bedømmere ved hjælp af ét klik er deaktiveret. Planlagte opgaver skal aktiveres og konfigureres (se webstedets konfigurationsfil).'),
('REVIEW_REMIND_AUTO', 'de_DE', 'Automatische Erinnerung an die Fälligkeit eines Gutachtens', '{$reviewerName},<br />\n<br />\nhiermit möchten wir Sie freundlich an Ihre Zusage erinnern, den Beitrag &quot;{$submissionTitle}&quot; für {$contextName} zu begutachten. Wir hatten gehofft, das Gutachten zum {$reviewDueDate} zu erhalten. Diese E-Mail wurde automatisch erstellt und nach Überschreitung des Termins versandt. Wir würden uns freuen, wenn uns das Gutachten baldmöglichst zur Verfügung stünde.<br />\n<br />\nFalls Ihnen Benutzer/innennamen und Passwort fehlen, können Sie über folgenden Link Ihr Passwort neu setzen (Benutzer/innenname und Passwort gehen Ihnen umgehend per E-Mail zu). {$passwordResetUrl}<br />\n<br />\nURL des Beitrags: {$submissionReviewUrl}<br />\n<br />\nKönnten Sie uns bitte bestätigen, dass Sie nach wie vor bereit sind, unsere Zeitschrift gutachterlich zu unterstützen? Wir würden uns freuen, bald von Ihnen zu hören.<br />\n<br />\n{$editorialContactSignature}', 'Diese E-Mail wird automatisch verschickt, wenn das Fälligkeitsdatum für eine/n Gutachter/in verstrichen ist (vgl. die Begutachtungseinstellungen in Schritt 2 des Zeitschriftensetups) und wenn der One-Click-Zugang für Gutachter/innen deaktiviert ist. Planmäßige Aufgaben (scheduled tasks) müssen aktiviert und konfiguriert sein (vgl. die Konfigurationsdatei der Website).'),
('REVIEW_REMIND_AUTO', 'el_GR', 'Αυτοματοποιημένη υπενθύμιση αξιολόγησης υποβολής', '{$reviewerName}:<br />\n<br />\nΤο παρόν μήνυμα αποτελεί υπενθύμιση του αιτήματός μας για αξιολόγηση της υποβολής &quot;{$submissionTitle},&quot; για το περιοδικό {$contextName}. Ελπίζαμε να έχουμε την αξιολόγηση μέχρι τις {$reviewDueDate}. Το παρόν μήνυμα δημιουργήθηκε και στάλθηκε αυτόματα με την παρέλευση της ημερομηνίας αυτής. Θα σας ήμαστε ευγνώμονες αν λαμβάναμε την αξιολόγηση το συντομότερο δυνατό.<br />\n<br />\nΕάν δε διαθέτετε το όνομα Χρήστη και τον κωδικό πρόσβασης στον ιστότοπο του περιοδικού, μπορείτε να χρησιμοποιήσετε τον σύνδεσμο {$passwordResetUrl} για να επαναφέρετε τον κωδικό (ο οποίος θα σας σταλεί με ηλεκτρονική μήνυμα, μαζί με το όνομα Χρήστη). <br />\n<br />\nΣύνδεσμος υποβολής: {$submissionReviewUrl}<br />\n<br />\nΠαρακαλούμε επιβεβαιώστε τη δυνατότητά σας να ολοκληρώσετε την αξιολόγηση. Ελπίζουμε να λάβουμε σύντομα την απάντησή σας.<br />\n<br />\n{$editorialContactSignature}', 'Το παρόν μήνυμα αποστέλλεται αυτόματα όταν παρέλθει η προθεσμία ολοκλήρωσης μίας αξιολόγησης (ανατρέξτε στις Επιλογές Αξιολόγησης κάτω από τις Ρυθμίσεις > Ροή εργασιών > Αξιολόγηση) και η πρόσβαση με ένα κλικ είναι απενεργοποιημένη για τους Αξιολογητές. Οι προγραμματισμένες εργασίες θα πρέπει να έχουν ενεργοποιηθεί και διαμορφωθεί (ανατρέξτε στο αρχείο διαμόρφωσης του ιστοτόπου).');
INSERT INTO `email_templates_default_data` VALUES
('REVIEW_REMIND_AUTO', 'en_US', 'Automated Submission Review Reminder', '{$reviewerName}:<br />\n<br />\nJust a gentle reminder of our request for your review of the submission, &quot;{$submissionTitle},&quot; for {$contextName}. We were hoping to have this review by {$reviewDueDate}, and this email has been automatically generated and sent with the passing of that date. We would still be pleased to receive it as soon as you are able to prepare it.<br />\n<br />\nIf you do not have your username and password for the journal''s web site, you can use this link to reset your password (which will then be emailed to you along with your username). {$passwordResetUrl}<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nPlease confirm your ability to complete this vital contribution to the work of the journal. I look forward to hearing from you.<br />\n<br />\n{$editorialContactSignature}', 'This email is automatically sent when a reviewer''s due date elapses (see Review Options under Settings > Workflow > Review) and one-click reviewer access is disabled. Scheduled tasks must be enabled and configured (see the site configuration file).'),
('REVIEW_REMIND_AUTO', 'es_ES', 'Recordatorio automático de revisión de envío', '{$reviewerName}:<br />\n<br />\nLe recordamos nuestra petición de revisión del envío &quot;{$submissionTitle},&quot; para {$contextName}. Esperábamos su revisión antes del {$reviewDueDate}, y se ha generado automáticamente este correo-e al haberse superado dicha fecha. Aún estaríamos encantados de recibirla una vez la tenga lista.<br />\n<br />\nSi ha perdido su nombre de usuaria/o y contraseña para la revista puede pinchar en el siguiente enlace para cambiar su contraseña (se la enviaremos por correo-e junto con su nombre de usuaria/o). {$passwordResetUrl}<br />\n<br />\nURL del envío: {$submissionReviewUrl}<br />\n<br />\nLe rogamos nos confirme su disponibilidad para completar esta contribución vital para el trabajo de la revista. Esperamos tener noticias suyas a la mayor brevedad.<br />\n<br />\n{$editorialContactSignature}', 'Este correo es enviado automáticamente cuando se supera la fecha de entrega de un/a revisor/a (véase Opciones de Revisión en Configuración de la revista, paso 2). Las tareas planificadas deben estar activadas y configuradas (ver fichero de configuración del sitio).'),
('REVIEW_REMIND_AUTO', 'eu_ES', 'Artikulua ebaluatzeko oroigarri automatizatua', '{$reviewerName}:<br />\n<br />\n{$contextName} aldizkarirako &quot;{$submissionTitle}&quot; artikuluaren ebaluazioa gogorarazteko ohartxo bat baino ez. &quot;{$reviewDueDate}&quot; egunerako espero genuen zure ebaluazio-txostena, eta, epea igaro denez, mezu hau automatikoki sortu eta bidali da. Eskertuko genizuke prestatu orduko bidaliko bazenigu.<br />\n<br />\nEz badaukazu aldizkariaren webgunean sartzeko erabiltzaile-izenik eta pasahitzik, behean ematen den esteka erabil dezakezu pasahitza berrezartzeko (erabiltzaile-izenarekin batera bidaliko dizugu). {$passwordResetUrl}<br />\n<br />\nArtikuluaren URLa: {$submissionReviewUrl}<br />\n<br />\nMesedez, berrets iezaguzu aldizkariarentzat biziki garrantzitsua den lan hori burutuko duzula. Besterik gabe, zure erantzunaren zain geratzen naiz.<br />\n<br />\n{$editorialContactSignature}', 'Mezu hau automatikoki bidaltzen da ebaluatzaile baten epea amaitu eta erantzun ez duenean (ikus Konfigurazioko 2. urratseko Ebaluazio-aukerak) eta klik bakarreko ebaluatzaile-sarbidea desgaituta dagoenean. Programatutako atazak (scheduled_tasks) gaituta eta konfiguratuta egon behar dute (ikus konfigurazio-fitxategia).'),
('REVIEW_REMIND_AUTO', 'fa_IR', 'یادآوری اتوماتیک برای کارشناسی مقاله ارسالی', '{$reviewerName}:<br />\n<br />\nاین فقط یک یادآوری درخواست ما از شما جهت بررسی مقاله ارسالی &quot;{$submissionTitle}&quot;مربوط به {$contextName} است. امیدوار بودیم که متن کارشناسی شما تا تاریخ &amp;lt;{$reviewDueDate}&amp;gt; دریافت نماییم و به دلیل اتمام فرصت مقرر، این ایمیل به صورت اتوماتیک برای شما فرستاده می شود. بسیار خوشحال خواهیم شد اگر هرچه زودتر بتوانید نتیجه کارشناسی خود را برایمان ارسال کنید.<br />\n<br />\nچنانچه نام کاربری و رمز عبور خود مربوط به وب سایت این مجله را در دسترس ندارید می توانید از پیوند زیر جهت تنظیم دوباره رمزعبور خود استفاده کنید (که به همراه نام کاربری برایتان ارسال می گردد).<br />\n<br />\n<a href="{$passwordResetUrl}">{$passwordResetUrl}</a><br />\nآدرس مقاله: <a href="{$submissionReviewUrl}">{$submissionReviewUrl}</a><br />\n<br />\nلطفا آمادگی خودرا نسبت به انجام این کمک مهم به مجله اعلام نمائید. منتظر پاسخ شما هستم.<br />\n<br />\n{$editorialContactSignature}', 'This email is automatically sent when a reviewer''s due date elapses (see Review Options under Journal Setup, Step 2) and one-click reviewer access is disabled. Scheduled tasks must be enabled and configured (see the site configuration file).'),
('REVIEW_REMIND_AUTO', 'fi_FI', 'Automaattinen muistutus käsikirjoituksen arvioinnista', 'Hyvä {$reviewerName},<br />\n<br />\nMuistuttaisin ystävällisesti pyynnöstämme arvioida käsikirjoitus &quot;{$submissionTitle}&quot; julkaisulle {$contextName}. Toivoimme saavamme arviointinne {$reviewDueDate} mennessä, ja tämä sähköposti on lähetetty automaattisesti määräajan umpeuduttua. Olisimme iloisia, mikäli edelleen voisitte lähettää arvioinnin meille heti sen suoritettuanne.<br />\n<br />\nJos ette muista käyttäjätunnustanne ja salasanaanne julkaisun verkkosivustolle, klikatkaa seuraavaa linkkiä vaihtaaksenne salasanan (salasana ja käyttäjätunnus lähetetään teille sähköpostitse). {$passwordResetUrl}<br />\n<br />\nKäsikirjoituksen URL: {$submissionReviewUrl}<br />\n<br />\nVahvistattehan vielä voitteko suorittaa tämän arvioinnin.<br />\n\n<br />\n{$editorialContactSignature}', 'This email is automatically sent when a reviewer''s due date elapses (see Review Options under Settings > Workflow > Review) and one-click reviewer access is disabled. Scheduled tasks must be enabled and configured (see the site configuration file).'),
('REVIEW_REMIND_AUTO', 'fr_CA', 'Rappel automatique d''évaluation d''une soumission', '{$reviewerName},<br />\n<br />\nCeci est un petit rappel concernant notre demande d''évaluation de la soumission « {$submissionTitle} » pour la revue {$contextName}. Puisque nous n''avons pas reçu, comme nous l''espérions, votre évaluation avant le {$reviewDueDate}, ce courriel a été généré et envoyé automatiquement après l''échéance du délai. Nous serions toutefois heureux de recevoir votre évaluation dès que possible.<br />\n<br />\nSi vous n''avez pas vos nom d''utilisateur-trice et mot de passe pour le site de la revue, vous pouvez utiliser le lien suivant pour réinitialiser votre mot de passe (lequel vous sera envoyé par courriel avec votre nom d''utilisateur-trice). {$passwordResetUrl}<br />\n<br />\nURL de la soumission : {$submissionReviewUrl}<br />\n<br />\nVeuillez confirmer que vous êtes en mesure d''effectuer ce travail essentiel pour la publication de notre revue. Nous espérons avoir de vos nouvelles très bientôt.<br />\n<br />\n{$editorialContactSignature}', 'Ce courriel est envoyé automatiquement lorsque la date d''échéance de remise d''une évaluation est révolue (voir Options d''évaluation sous Paramètres > Flux des travaux > Évaluation) et que l''accès de l''évaluateur-trice en un clic est désactivé. Les tâches planifiées doivent être activées et configurées (voir le fichier de configuration du site).'),
('REVIEW_REMIND_AUTO', 'fr_FR', 'Rappel automatique d''évaluation d''une soumission', '{$reviewerName},<br />\n<br />\nJuste un petit mot pour vous rappeler notre demande à propos de l''évaluation de la soumission intitulée « {$submissionTitle} » pour {$contextName}. Nous espérions recevoir votre évaluation avant le {$reviewDueDate}. Ce courriel a été envoyé automatiquement parce que la date d''échéance est passée. Nous serions quand même heureux de recevoir votre évaluation dès que possible.<br />\n<br />\nSi vous n''avez pas de nom d''utilisateur ni de mot de passe pour le site Web de la revue, cliquez sur le lien ci-dessous pour réinitialiser votre mot de passe (qui vous sera envoyé par courriel avec votre nom d''utilisateur). {$passwordResetUrl}<br />\n<br />\nURL de la soumission : {$submissionReviewUrl}<br />\n<br />\nVeuillez confirmer que vous êtes en mesure d''effectuer ce travail important pour notre revue. J''espère avoir de vos nouvelles très bientôt.<br />\n<br />\n{$editorialContactSignature}', 'Ce courriel est envoyé automatiquement quand la date due d''un rapporteur est dépassée. (Voir Options d''évaluation à l''Étape 2 de la Configuration de la revue) et que l''accès en « un clic » est désactivé. Les tâches planifiées doivent être activées et configurées (voir le fichier de Configuration du site).'),
('REVIEW_REMIND_AUTO', 'gd_GB', 'Cuimhneachan fèin-obrachail mu lèirmheas tagraidh', '{$reviewerName}:<br />\n<br />\nDìreach cuimhneachan beag gun deach iarraidh ort lèirmheas a dhèanamh air an tagradh “{$submissionTitle},” airson {$contextName}. Bha sinn an dòchas an lèirmheas seo a choileanadh ro {$reviewDueDate} agus chaidh am post-d seo a chur gu fèin-obrachail leis gu bheil sinn seachad air a’ cheann-là ud a-nis. Bhiomaid fada nad chomain nam b’ urrainn dhut a chur thugainn fhathast cho luath ’s a ghabhas.<br />\n<br />\nMur eil am facal-faire is ainm-cleachdaiche agad airson làrach-lìn an iris-leabhair, ’s urrainn dhut am facal-faire agad ath-shuidheachadh leis a’ cheangal seo agus thèid a chur thugad air a’ phost-d an uairsin còmhla ris an ainm-chleachdaiche agad. {$passwordResetUrl}<br />\n<br />\nURL an tagraidh: {$submissionReviewUrl}<br />\n<br />\nSaoil am b’ urrainn dhut fios a leigeil thugainn am b’ urrainn dhut an obair chudromach seo a dhèanamh airson an iris-leabhair fhathast? Tha mi an dòchas cluinntinn uat.<br />\n<br />\n{$editorialContactSignature}', 'Thèid am post-d seo a chur gu fèin-obrachail nuair a dh’fhalbhas an ùine air a’ cheann-là lìbhrigidh aig lèirmheasaiche (faic na roghainnean lèirmheis fo na “Roghainnean” > “Sruth-obrach” > “Lèirmheas) agus nuair a bhios inntrigeadh lèirmheasaichean le aon bhriogadh à comas. Feumaidh sgeidealachadh shaothraichean a bhith an comas agus air a rèiteachadh (faic faidhle rèiteachadh na làraich).'),
('REVIEW_REMIND_AUTO', 'hi_IN', 'ऑटोमेटेड सबमिशन रिव्यू रिमाइंडर', '{$reviewerName}:<br />\n<br />\nप्रस्तुत करने की आपकी समीक्षा के लिए हमारे अनुरोध का एक सौम्य अनुस्मारक, &quot;{$submissionTitle},&quot; for {$contextName}. हम {$ reviewDueDate} द्वारा इस समीक्षा की उम्मीद कर रहे थे, और यह ईमेल स्वचालित रूप से जनरेट किया गया है और उस तारीख को पारित करने के साथ भेजा गया है। जैसे ही आप इसे तैयार करने में सक्षम होंगे, हम इसे प्राप्त करके प्रसन्न होंगे.<br />\n<br />\nयदि आपके पास जर्नल की वेब साइट के लिए आपका उपयोगकर्ता नाम और पासवर्ड नहीं है, तो आप अपना पासवर्ड रीसेट करने के लिए इस लिंक का उपयोग कर सकते हैं (जो तब आपके उपयोगकर्ता नाम के साथ आपको ईमेल किया जाएगा)। {$ PasswordResetUrl}<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nकृपया जर्नल के काम में इस महत्वपूर्ण योगदान को पूरा करने की अपनी क्षमता की पुष्टि करें। तुम्हारे उत्तर की प्रतीक्षा है मुझे.<br />\n<br />\n{$editorialContactSignature}', 'यह ईमेल स्वचालित रूप से तब भेजा जाता है जब एक समीक्षक की नियत तिथि समाप्त हो जाती है (सेटिंग्स> वर्कफ़्लो> समीक्षा के तहत समीक्षा विकल्प देखें) और एक-क्लिक समीक्षक पहुंच अक्षम है। अनुसूचित कार्यों को सक्षम और कॉन्फ़िगर किया जाना चाहिए (साइट कॉन्फ़िगरेशन फ़ाइल देखें).'),
('REVIEW_REMIND_AUTO', 'hr_HR', 'Automatski podsjetnik za predaju recenzije', 'Poštovana/i {$reviewerName},<br />\n<br />\nželjeli bismo vas samo podsjetiti da je rok koji smo dogovorili za recenziju članka &quot;{$submissionTitle}&quot; za časopis {$contextName} istekao. Nadali smo se da će recenzija biti gotova do {$reviewDueDate}. Ova poruka se automatski šalje nakon prolaska tog datuma. Molimo vas da nam recenziju pošaljete u najskorijem roku.<br />\n<br />\nU slučaju da nemate pri ruci svoje korisničko ime ili lozinku za mrežnu stranicu časopisa, možete se koristiti ovom poveznicom kako biste promijenili lozinku (koju ćemo vam tada, zajedno s korisničkim imenom, poslati putem e-pošte). {$passwordResetUrl}<br />\n<br />\nURL članka: {$submissionReviewUrl}<br />\n<br />\nMolimo vas da nas izvijestite u kojem ste roku u mogućnosti izraditi recenziju. Nadamo se skorom odgovoru.<br />\n<br />\nSrdačno,<br />\n{$editorialContactSignature}', 'Ovaj se obrazac e-pošte automatski šalje recenzentu kada datum naveden kao rok za izradu recenzije istekao (pogledajte Opcije recenzije unutar Postavljanja časopisa, 2. korak), a recenzentu nije omogućen pristup jednim klikom. Za ovu funkciju Raspoređeni zadaci moraju biti aktivirani i namješteni (pogledajte konfiguracijsku datoteku stranice).'),
('REVIEW_REMIND_AUTO', 'hu_HU', 'Automatikus emlékeztető cikk szakmai lektorálásáról', 'Tisztelt {$reviewerName}!<br />\n<br />\nÉrtesítjük, hogy a(z) {$contextName} folyóirat &quot;{$submissionTitle},&quot; című cikkének lektorálási határideje ({$reviewDueDate}) lejárt.<br />\nKérjük mielőbb készítse el szakmai bírálatát.<br />\n<br />\nHa elfelejtette felhasználónevét vagy jelszavát, az alábbi linken emlékeztetőt kérhet. (Jelszavát és felhasználónevét emailben küldjük el.)<br />\n{$passwordResetUrl}<br />\n<br />\nKézirat URL: {$submissionReviewUrl}<br />\n<br />\nKérjük, határidő módosításának ügyében vegye fel a kapcsolatot a szerkesztőséggel!<br />\n<br />\nÜdvözlettel,<br />\n{$editorialContactSignature}', 'Ez az email automatikusan generált, amikor a lektorálási határidő lejár (lásd a Lektorálási beállításokat a Beállítások > Munkafolyamat > Szakmai lektorálás résznél) és az egykattintásos lektorálási hozzáférés nincs engedélyezve. Az ütemezett feladatokat engedélyezni és konfigurálni kell (lásd az oldal konfigurálást).'),
('REVIEW_REMIND_AUTO', 'id_ID', 'Pengingat Otomatis Review Naskah', '{$reviewerName}:<br />\n<br />\nSekedar mengingatkan tentang permohonan kami untuk melakukan review terhadap naskah, &quot;{$submissionTitle},&quot; untuk {$contextName}. Kami mengharapkan telah menerima review ini pada {$reviewDueDate}, dan email ini dikirim secara otomatis seiring terlewatinya tanggal tersebut. Kami masih tetap menanti review tersebut segera setelah Anda dapat menyelesaikannya.<br />\n<br />\nJika Anda tidak memiliki nama pengguna dan sandi untuk website jurnal ini, Anda dapat menggunakan tautan berikut untuk mereset sandi Anda (yang selanjutnya akan diemailkan kepada Anda bersama nama pengguna Anda). {$passwordResetUrl}<br />\n<br />\nURL Naskah: {$submissionReviewUrl}<br />\n<br />\nMohon konfirmasi kesanggupan Anda untuk menyelesaikan kontribusi penting ini.  Kami menunggu balasan Anda.<br />\n<br />\n{$editorialContactSignature}', 'Email ini dikirimkan otomatis saat tenggat waktu review terlewati (lihat Opsi Review di menu Pengaturan > Alur Kerja > Review) and one-click reviewer access is disabled. Scheduled tasks must be enabled and configured (see the site configuration file).'),
('REVIEW_REMIND_AUTO', 'it_IT', 'Promemoria automatico revisione in attesa', 'Gentile {$reviewerName},<br />\n<br />\nQuesto è un promemoria automatico della richiesta di revisione del manoscritto &quot;{$submissionTitle},&quot; per {$contextName}.<br />\n<br />\nScadenza prevista:  {$reviewDueDate}.<br />\n<br />\nPuoi usare questo link per resettare la  password (che ti sarà quindi mandata per email insieme con la username). {$passwordResetUrl}<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nTi chiedo la cortesia di confermare al più presto la tua disponibilità di prendere in carico questo incarico.<br />\n<br />\n{$editorialContactSignature}', 'Questa email viene mandata automaticamente quando una data di revisionee scade (vedi opzioni del revisore nel Impostazioni > Flusso di lavoro > Revisione) e l''accesso one-click del revisore è disattivato. I compiti programmati devono essere abilitati e configurati (vedi il file di configurazione del sito).'),
('REVIEW_REMIND_AUTO', 'ja_JP', '論文査読の督促（自動送信）', '{$reviewerName} 様:<br />\n<br />\n雑誌『{$contextName}』への投稿原稿「{$submissionTitle}」の査読は進んでいるでしょうか。査読期限日は、{$reviewDueDate}となっております。このメールは、期限日が過ぎた査読者に対し、システムにより自動的に作成され送信されるものです。準備ができ次第できるだけ早く査読結果をいただきたいと考えております。<br />\n<br />\n雑誌のWebサイトにログインするユーザー名とパスワードをお持ちでない場合は、次のリンクを使ってパスワードをリセットしてください（パスワードはユーザー名と共にメールで送信されます）： {$passwordResetUrl}<br />\n<br />\n投稿物のURL: {$submissionReviewUrl}<br />\n<br />\n本誌の投稿物にとって極めて重要なこの貢献を貴殿が遂行できることを確認してください。お返事をお待ちしております。<br />\n<br />\nよろしくお願いいたします。<br />\n<br />\n{$editorialContactSignature}', 'このメールは、査読者の査読期限日が過ぎ（雑誌設定ステップ2の査読オプションを参照）、査読者ワンクリックアクセスが無効な場合に、自動的に送信されるものです。定期タスク機能が有効かつ設定されている必要があります（サイト設定ファイルを参照）。'),
('REVIEW_REMIND_AUTO', 'ku_IQ', 'بیرخەرەوەی تۆماتیکی هەڵسەنگاندنی توێژینەوە', '{$reviewerName}:<br />\n<br />\nبیرخەرەوەی هەڵسەنگاندنی توێژینەوەی &quot;{$submissionTitle},&quot; بۆ{$contextName}.ئێمە هیواخوازین کە هەڵسەنگاندنەکەتان هەتا {$reviewDueDate} تەواو بێت و بە هیواین لە نزیکترین دەرفەتتدا تێبینی و بڕیارەکانتان دەربارەی توێژینەوەکە بنێرن.<br />\n<br />\nئەگەر تۆ هەژمار و وشەی نهێنیت نییە، دەتوانیت لێرەوە داوای وشەیەکی نهێنیی نوێ بکەیت (کە بە ئیمەیڵ لەگەڵ ناوی بەکارهێنەر بە دەستت دەگات). {$passwordResetUrl}<br />\n<br />\nلینکی توێژینەوەکە: {$submissionReviewUrl}<br />\n<br />\nتکایە دڵنیامان بکەوە لە هاوکاریت و بڕیاری هەڵسەنگاندنی توێژینەوەکە، ئێمە چاوەڕێی وەڵامی ئێوەین.<br />\n<br />\n{$editorialContactSignature}', 'ئەم ئیمەیڵە بە شێوەیەکی تۆماتیکی بۆ هەڵسەنگێنەر نێردراوە بە هۆی کۆتاییهاتنی وادەی هەڵسەنگاندن (بژاردەکانی هەڵسەنگاندن لێرەوە ببینە ڕێکخستنەکان/ ڕێڕەوی کار/ هەڵسەنگاندن) و بە کلیکێک دەستپێڕاگەیشتنی هەڵسەنگێنەر ناچالاک دەکریت. ئەرکە پلان بۆ دانراوەکان دەبێت چالاک کرابن.'),
('REVIEW_REMIND_AUTO', 'mk_MK', 'Автоматски потсетник за рецензија на поднесок', '{$reviewerName}:<br />\n<br />\nМал потсетник за нашето барање за вашата рецензија на поднесокот, &quot;{$submissionTitle},&quot; за {$contextName}. Се надевавме дека ќе ја добиеме вашата рецензија до {$reviewDueDate},  и овој и-меил е автоматски генериран и испратен со истекот на тој датум. Ни се уште би биле задоволни да ја добиеме веднаш штом ќе можете да ја подготвите.<br />\n<br />\nДоколку не ги имате вашето корисничко име и лозинка за веб-страницата на списанието, можете да го искористите овој линк за да ја ресетирате вашата лозинка (која потоа ќе ви биде испратена преку и-меил заедно со вашето корисничко име). {$passwordResetUrl}<br />\n<br />\nURL-адреса на поднесокот: {$submissionReviewUrl}<br />\n<br />\nВе молам за потврда дека можете да го завршите овој неопходен придонес кон работата на ова списание. Со нетрпение очекувам да слушнам од вас.<br />\n<br />\n{$editorialContactSignature}', 'Овој и-меил е автоматски испратен кога рокот за рецензија на рецензентот е истечен (видете Опции за рецензија во Поставки > Тек на работа > Рецензија) и пристапот за рецензентот преку еден клик е оневозможен. Закажаните задачи мора да се овозможени и прилагодени(видете ја датотеката за прилагодување на веб-страницата).'),
('REVIEW_REMIND_AUTO', 'nb_NO', 'Påminnelse om fagfellevurdering (automatisk e-post)', '{$reviewerName}:<br />\n<br />\nDette er en automatisk generert e-post som sendes for å minne deg på at du har tatt på deg å vurdere «{$submissionTitle}» for {$contextName}. Jeg minner om at fristen for oppdraget var satt til {$reviewDueDate}. Jeg ser fram til å motta vurderingen din, så snart du har den klar.<br />\n<br />\nHvis du ikke har brukernavnet og passordet ditt til tidsskriftets nettsted, kan du bruke lenken under for å fornye passordet ditt. Du vil få det tilsendt i en e-post, sammen med brukernavnet ditt. {$passwordResetUrl}<br />\n<br />\nInnleveringens URL: {$submissionReviewUrl}<br />\n<br />\nKan du bekrefte om du fortsatt vil fullføre vurderingen for tidsskriftet vårt? Jeg ser fram til å høre fra deg.<br />\n<br />\n{$editorialContactSignature}', 'Denne e-posten sendes automatisk til fagfellen når tidsfristen for fagfellevurdering utløper (se: Tid for fagfellevurdering under Innstillinger > Arbeidsflyt > Fagfellevurdering) og når ettklikks fagfelletilgang er slått av. Planlagte oppgaver må være slått på og konfiguert (se etter Scheduled tasks i konfigurasjonsfilen for nettstedet).'),
('REVIEW_REMIND_AUTO', 'nl_NL', 'Geautomatiseerde review herinnering', '{$reviewerName}:<br />\n<br />\nWe willen u vriendelijk herinneren aan ons verzoek om de inzending &quot;{$submissionTitle}&quot; voor {$contextName} te reviewen. We verwachtten uw review op {$reviewDueDate}. We stellen het zeer op prijs om de review te ontvangen zodra u in de gelegenheid bent om die uit te voeren.<br />\n<br />\nAls u de gebruikersnaam en het wachtwoord van de website van het tijdschrift niet heeft, kunt u deze link gebruiken voor het herstellen van uw wachtwoord (dat samen met uw gebruikersnaam in een e-mail naar u verstuurd wordt). {$passwordResetUrl}<br />\n<br />\nURL inzending: {$submissionReviewUrl}<br />\n<br />\nWilt u uw beschikbaarheid voor het voltooien van deze voor het werk van het tijdschrift vitale taak bevestigen. Ik kijk uit naar uw reactie.<br />\n<br />\n{$editorialContactSignature}', 'Deze e-mail wordt automatisch verstuurd als de afgesproken reviewperiode verstrijkt (zie Review opties onder Tijdschrift inrichten) en een-klik toegang voor reviewers is uitgeschakeld. Scheduled tasks moet ingeschakeld en geconfigureerd zijn (zie het configuratiebestand).'),
('REVIEW_REMIND_AUTO', 'pl_PL', 'Automatyczne przypomnienie o upłynięciu terminu wykonania recenzji', '{$reviewerName}:<br />\n<br />\nprzypominamy, że w dniu {$reviewDueDate} minął termin wykonania recenzji tekstu &quot;{$submissionTitle}&quot; zgłoszonego do czasopisma {$contextName}. Mamy nadzieję, że w krótkim czasie otrzymamy od Pani/ Pana gotową recenzję. <br />\n<br />\nJeżeli nie posiada Pani/ Pan danych do zalogowania na stronie czasopisma, prosimy użyj linku poniżej, aby zresetować hasło (które zostanie następnie przesłane mejlem razem z nazwą użytkownika). {$passwordResetUrl}<br />\n<br />\nWWW tekstu: <br />\n<br />\nBędziemy wdzięczni za potwierdzenie gotowości do wykonania recenzji.<br />\n<br />\n{$editorialContactSignature}', 'Wiadomość automatycznie wysłana po upłynięciu terminu nadesłania recenzji. Zaplanowane zadania w systemie muszą zostać na nowo skonfigurowane.'),
('REVIEW_REMIND_AUTO', 'pt_BR', 'Lembrete automático de solicitação de avaliação', '{$reviewerName}:<br />\n<br />\nEste é apenas um lembrete amigável do nosso pedido de avaliação da submissão, &quot;{$submissionTitle},&quot; ao periódico {$contextName}. Esperávamos ter recebido sua avaliação até {$reviewDueDate}, então este email foi gerado automaticamente com o passar daquele prazo. Nós ainda assim ficaríamos gratos em recebê-la assim que você conseguir prepará-la.<br />\n<br />\nSe você não tiver seu nome de usuário e senha para o site do periódico, poderá usar este link para redefinir sua senha (que será enviada por e-mail juntamente com seu nome de usuário). {$passwordResetUrl}<br />\n<br />\nURL da submissão: {$submissionReviewUrl}<br />\n<br />\nPor favor, confirme que poderá completar essa contribuição vital ao trabalho do periódico. Aguardo seu retorno.<br />\n<br />\n{$editorialContactSignature}', 'Mensagem enviada automaticamente ao avaliador quando a data de conclusão de avaliação for ultrapassada (veja as Opções de Avaliação no Passo 2 da Configuração da Revista). Tarefas agendadas devem ser habilitadas e configuradas (veja o arquivo de configuração do sistema).'),
('REVIEW_REMIND_AUTO', 'pt_PT', 'Lembrete automático de pedido de revisão', '{$reviewerName},<br />\n<br />\nEste é apenas um lembrete automático, referente ao pedido de revisão da submissão &quot;{$submissionTitle}&quot; a {$contextName}. Esperávamos receber a revisão até {$reviewDueDate} e este email foi enviado automaticamente pois o prazo para entrega foi ultrapassado.\nAguardamos a receção da revisão assim que for possível concluí-la.<br />\n<br />\nCaso não possua o nome de utilizador e a senha para aceder ao sistema da revista, use o link a seguir para criar uma nova senha, que lhe será enviada via email junto com os seus dados de acesso. {$passwordResetUrl}<br />\n<br />\nURL da Submissão: {$submissionReviewUrl}<br />\n<br />\nConfirme a sua disponibilidade para concluir a revisão, contribuição vital para a qualidade desta publicação.\nAguardando o seu contacto,<br />\n<br />\n{$editorialContactSignature}', 'Este e-mail é enviado automaticamente ao revisor quando a data de conclusão de revisão for ultrapassada (veja as Opções de Revisão em Configurações > Fluxo de Trabalho > Revisão). Tarefas agendadas devem ser ativadas e configuradas (veja o ficheiro de configuração do sistema).'),
('REVIEW_REMIND_AUTO', 'ro_RO', 'Memento automat de revizuire a manuscrisului', '{$reviewerName}:<br />\n<br />\nAcest email v-a fost trimis pentru a vă reaminti că ați acceptat să revizuiți manuscrisul, &quot;{$submissionTitle},&quot; pentru {$contextName}. Speram că veți finaliza această revizuire până la {$reviewDueDate}, iar acest e-mail a fost generat și trimis automat odată cu trecerea acestei date. Ne-ar face plăcere să primim revizia dumneavoastră imediat ce o puteți pregăti.<br />\n<br />\nDacă nu aveți numele de utilizator și parola pentru site-ul web al jurnalului, puteți utiliza acest link pentru a vă reseta parola (care vă va fi apoi trimisă prin e-mail împreună cu numele de utilizator). {$passwordResetUrl}<br />\n<br />\nMink manuscris: {$submissionReviewUrl}<br />\n<br />\nToate cele bune.<br />\n<br />\n{$editorialContactSignature}', 'Acest e-mail este trimis automat la expirarea termenului de scadență al unui revizor (consultați Opțiunile de revizuire din Setări> Flux de lucru> Revizuire) și accesul cu un singur clic al revizorului este dezactivat. Sarcinile programate trebuie să fie activate și configurate (consultați fișierul de configurare a site-ului).'),
('REVIEW_REMIND_AUTO', 'ru_RU', 'Автоматическое напоминание о рецензии на материал', 'Здравствуйте, {$reviewerName}!<br />\n<br />\nЭто напоминание о нашем запросе Вашей рецензии на материал «{$submissionTitle}» для журнала «{$contextName}». Мы надеялись получить эту рецензию до {$reviewDueDate}, и это письмо было автоматически сгенерировано и отправлено, так как эта дата уже прошла. Мы будем рады, если Вы как можно скорее ее подготовите.<br />\n<br />\nЕсли у Вас нет имени пользователя и пароля для доступа к сайту журнала, Вы можете воспользоваться этой ссылкой для сброса Вашего пароля (он будет направлен Вам вместе с Вашим именем пользователя на электронную почту). {$passwordResetUrl}<br />\n<br />\nURL материала: {$submissionReviewUrl}<br />\n<br />\nПожалуйста, подтвердите, что Вы сможете сделать этот важный вклад в работу нашего журнала. Жду вашего ответа.<br />\n<br />\n{$editorialContactSignature}', 'Это письмо отправляется автоматически, когда дата предоставления рецензии рецензентом прошла (смотрите Параметры рецензирования в Настройки > Рабочий процесс > Рецензирование) и прямой доступ рецензента по ссылке отключен. Запланированные задачи должны быть включены и настроены (смотрите файл конфигурации сайта).'),
('REVIEW_REMIND_AUTO', 'sk_SK', 'Automatické pripomenutie recenzie príspevku', '{$reviewerName}:<br />\n<br />\nDovoľujeme si Vám opatrne pripomenúť našu žiadosť o spracovanie recenzie príspevku &quot;{$submissionTitle}&quot; pre {$contextName}. Dúfali sme, že budeme mať túto recenziu hotovú do {$reviewDueDate} a tento email bol automaticky vygenerovaný a poslaný, lebo stanovený termín už vypršal. Budeme veľmi radi, keď od Vás recenziu dostaneme hneď, ako ju budete môcť dokončiť.<br />\n<br />\nAk nemáte svoje používateľské meno a heslo pre webovú stránku časopisu, môžete použiť tento odkaz pre obnovenie Vášho hesla (ktoré Vám bude zaslané emailom spolu s Vašim používateľským menom).{$passwordResetUrl}<br />\n<br />\nURL príspevku: {$submissionReviewUrl}<br />\n<br />\nPotvrďte nám prosím, či môžete dokončiť túto nevyhnutú úlohu pre náš časopis. Tešíme sa, že sa ozvete.<br />\n<br />\n{$editorialContactSignature}', 'Tento email je poslaný automaticky, keď recenzentovi vyprší stanovený termín pre spracovanie recenzie (pozri Možnosti recenzie v Nastavenie časopisu, Krok 2) a je zakázaný prístup recenzenta na jedno kliknutie. Musia byť povolené a nakonfigurované naplánované úlohy (pozri konfiguračný súbor stránky).'),
('REVIEW_REMIND_AUTO', 'sl_SI', 'Avtomatski opomnik za recenzijo prispevka', '{$reviewerName}:<br />\n<br />\nSamo prijazen opomnik za našo prošnjo za recenzijo prispevka, &quot;{$submissionTitle},&quot; za revijo {$contextName}. Upali smo, da boste opravili recenzijo do predvidenega datuma {$reviewDueDate}. E-pošta je bila generirana avtomatično s potekom tega datuma. Z veseljem bomo sprejeli recenzijo takoj, ko jo pripravite.<br />\n<br />\nČe nimate uporabniškega imena in gesla za dostop do spletne strani revije, lahko uporabite naslednjo povezavo za ponastavitev gesla (ki vam bo posredovano po e-pošti skupaj z vašim uporabniškim imenom: {$passwordResetUrl}<br />\n<br />\nURL povezava do prispevka: {$submissionReviewUrl}<br />\n<br />\nProsim, če potrdite vašo pripravljenost za dokončanje vašega pomembnega prispevka za delo revije. Veselimo se vašega odgovora.<br />\n<br />\n{$editorialContactSignature}', 'Ta email se pošlje recenzentu avtomatično, ko poteče rok za opravljanje recenzije (več v recenzijskih nastavitveh v Nastavitve > Potek dela > Recenzija) in je izključena opcija za recenzentski dostop z enim klikom. Opozorilo: administrator spletišča mora v nastavitveni datoteki spletišča nastaviti "Scheduled tasks".'),
('REVIEW_REMIND_AUTO', 'sv_SE', 'Automatisk påminnelse om granskning av bidrag', '{$reviewerName}:<br />\n<br />\nDet här är bara en påminnelse om vår förfrågan om din granskning av bidraget &quot;{$submissionTitle}&quot; för {$contextName}. Vi hade hoppats på att få din granskning senast {$reviewDueDate} och det här e-postmeddelandet skickas automatiskt när datum för deadline passeras. Vi skulle fortfarande vara tacksamma över att få in din granskning, så fort som möjligt.<br />\n<br />\nOm du har glömt ditt användarnamn och/eller lösenord till tidskriftens webbplats, använd följande länk för att återställa lösenordet: {$passwordResetUrl}. Dina inloggningsuppgifter skickas då till dig per e-post.<br />\n<br />\nBidragets URL: {$submissionReviewUrl}<br />\n<br />\nVänligen bekräfta snarast om du har möjlighet att genomföra granskningsuppdraget, som utgör en viktig del av tidskriftens arbete. Vi ser fram emot att höra från dig.<br />\n<br />\n{$editorialContactSignature}', 'Det här e-postmeddelandet skickas automatiskt när en granskares deadline löper ut (se Granskningsalternativ under Inställningar > Arbetsflöde > Granskning) och när Granskartillgång med ett klick är avaktiverat. Schemalagda aktiviteter måste vara aktiverat och konfigurerat (se serverns konfigurationsfil).'),
('REVIEW_REMIND_AUTO', 'tr_TR', 'Değerlendirilme Konusunda Otomatik Hatırlatma', 'Sayın {$reviewerName},<br />\n<br />\n{$contextName} adlı dergide yayınlanması için değerlendirilmek üzere gönderilen &quot;{$submissionTitle}&quot; başlıklı çalışmanın değerlendirmesini {$reviewDueDate} tarihinden önce tamamlayacağınızı ümit ediyorduk. Yoğun işleriniz nedeni ile oluşan gecikme nedeni ile sistemimiz tarafından bu mesaj tarafınıza otomatik olarak gönderilmişitir. <br />\n<br />\nDeğerlendirme raporunuzu bize bir an önce ileteceğiniz inancı ile dergimiz sitesindeki ulaşım bilgilerini size iletmeyi istedik.<br />\n<br />\nEğer derginin web sitesine giriş için kullanıcı adı ve şifreniz yoksa veya unuttunuz ise, şifrenizi yenilemek için bu bağlantıyı kullanabilirsiniz (Kullanıcı adınızla birlikte şifreniz size postalanacaktır). {$passwordResetUrl}<br />\n<br />\nMakale Erişim Adresi: {$submissionReviewUrl}<br />\n<br />\nDerginin kalitesini arttıracak bu önemli katkıyı yapabileceğinizi lütfen onaylayınız.<br />\n<br />\n{$editorialContactSignature}', 'Gözden geçirme işlemi için verilen süre geçtiğinde bu elektronik posta otomatik olarak gönderilir(Derginin Kurulum Bölümü altındaki Gözden Geçirme seçeneklerine bakınız, Adım 2). Zamanlanmış görevler aktif hale getirilmeli ve düzenlenmelidir(alan düzenleme dosyasına bakınız).'),
('REVIEW_REMIND_AUTO', 'uk_UA', 'Автоматичне нагадування про рецензування', '{$reviewerName}:<br />\n<br />\nНагадуємо Вам про рецензування подання, &quot;{$submissionTitle},&quot; для видання {$contextName}. Ми очікували отримати цю рецензію до {$reviewDueDate}, цей лист був автоматично надісланий Вам, оскільки вказана дата минула. Ми все ще чекаємо на Вашу рецензію і будемо вдячні, якщо Ви завершите та надішлете її якомога скоріше.<br />\n<br />\nЯкщо Ви не зберегли імені користувача та пароль для веб-сайту журналу, Ви можете скористатися наступним посиланням для того, щоб скинути свій пароль (після цього пароль та ім''я користувача будуть відправлені Вам електронною поштою). {$passwordResetUrl}<br />\n<br />\nURL подання: {$submissionReviewUrl}<br />\n<br />\nБудь ласка, підтвердіть можливість завершити цю важливу для нашого журналу роботу. З нетерпінням очікую Вашої відповіді.<br />\n<br />\n{$editorialContactSignature}', 'Цей лист автоматично надсилається рецензенту, коли настає кінцева дата рецензування (див. розділ "Налаштування рецензування" кроку 2 Налаштування журналу) та відключений доступ рецензента "єдиним натисканням". Щоб ця функціональність працювала необхідно включити на налаштувати Scheduled tasks (див. файл конфігурації сайту).'),
('REVIEW_REMIND_AUTO', 'vi_VN', 'Nhắc nhở nộp đánh giá (tự động)', 'Kính gửi {$reviewerName},<br />\n<br />\nJust a gentle reminder of our request for your review of the submission, &quot;{$submissionTitle},&quot; for {$contextName}. We were hoping to have this review by {$reviewDueDate}, and this email has been automatically generated and sent with the passing of that date. We would still be pleased to receive it as soon as you are able to prepare it.<br />\n<br />\nNếu bạn không có username và mật khẩu cho trang web của tạp chí, bạn có thể sử dụng liên kết này để đặt lại mật khẩu của mình (sau đó sẽ được gửi qua email cho bạn cùng với username của bạn). {$passwordResetUrl}<br />\n<br />\nURL bài gửi: {$submissionReviewUrl}<br />\n<br />\nVui lòng xác nhận khả năng hoàn thành quy trình quan trọng này cho công việc của tạp chí. Chúng tôi mong nhận được phản hồi của bạn.<br />\n<br />\n{$editorialContactSignature}', 'Email này được gửi tự động khi hết hạn đánh giá của người phản biện (xem Tùy chọn đánh giá trong Cài đặt > Quy trình làm việc > Phản biện) và quyền truy cập của người phản biện không cần đăng nhập bị vô hiệu hóa. Các tác vụ theo lịch trình phải được bật và định cấu hình (xem tệp cấu hình trang).'),
('REVIEW_REMIND_AUTO', 'zh_CN', '自动发出的稿件审查提醒函', '{$reviewerName}:<br />\n<br />\n这封信只是礼貌地提醒您，我们已邀请您为《{$contextName}》审查稿件〈{$submissionTitle}〉。我们希望您<br />\n能在 {$reviewDueDate}前完成这份审查工作，并请您在备妥审查意见书之后尽快寄给我们。<br />\n<br />\n如果您没有您在这个期刊网站的用户帐号和密码。您可以使用这个链接去重新设定您的密码（该密码会和您的用户帐号名称一起电邮给您）：{$passwordResetUrl}<br />\n<br />\n稿件网址：{$submissionReviewUrl}<br />\n<br />\n请确认您能够完成这个对本期刊作品而言非常重要的贡献。我们期盼听到您的回复。<br />\n<br />\n{$editorialContactSignature}', '这封电子邮件在一位审查人的工作期限日已经超过的时候，会自动发出给他（见「期刊设定」之步骤2，「审查选项」），而审查访问一点即入的功能已经停用。必须启用并且设定排程任务（见网站设定）。'),
('REVIEW_REMIND_AUTO_ONECLICK', 'ar_IQ', 'تذكير تلقائي بتحكيم طلب التقديم', '{$reviewerName}:<br />\n<br />\nهذا مجرد تذكير لجنابكم الكريم بشأن تحكيمكم للمؤلَّف الموسوم &quot;{$submissionTitle},&quot; والمرسل إلى {$contextName}. نحن نأمل الحصول منكم على هذا التحكيم حتى يوم {$reviewDueDate}،وهذه الرسالة مولدة آلياً نظراً لتجاوز ذلك التاريخ. مع ذلك، يسرنا أن نتلقاه منكم حالماً تكونوا جاهزين لإرساله.<br />\n<br />\nرابط الطلب: {$submissionReviewUrl}<br />\n<br />\nلطفاً، أكدوا لنا قدرتكم على إكمال هذه المساهمة الحيوية في أعمال مجلتنا. إنني أتطلع إلى ردكم في أقرب وقت.<br />\n<br />\n{$editorialContactSignature}', 'هذه الرسالة يولدها الموقع آلياً عندما يتم تجاوز موعد تسليم التحكيم من قبل أحد المحكمين (أنظر خيارات التحكيم ضمن: الإعدادات، المخطط الانسيابي، التحكيم) وعندما يكون خيار الوصول المباشر للمحكم مفعل. المهام المجدول يجب أن تكون مفعلة ومهيئة (أنظر ملف تهيئة الموقع.'),
('REVIEW_REMIND_AUTO_ONECLICK', 'bs_BA', 'Automatski podsjetnik za predaju recenzije', 'Poštovana/i {$reviewerName},<br />\n<br />\nželjeli bismo vas samo podsjetiti da je rok koji smo dogovorili za recenziju članka &quot;{$submissionTitle}&quot; za časopis {$contextName} istekao {$reviewDueDate}. Bilo bi nam izuzetno drago ukoliko biste recenziju završili i predali čim je prije moguće.<br />\n<br />\nDo priloga možete doći izravno prateći ovu kodiranu pozivnicu:<br />\nURL članka: {$submissionReviewUrl}<br />\n<br />\nMolimo vas da potvrdite da ste u mogućnosti privesti kraju ovaj ključan doprinos radu časopisa. Nadamo se skorom odgovoru.<br />\n<br />\nSrdačno,<br />\n{$editorialContactSignature}', 'Ovim obrascem e-pošte urednik rubrike podsjeća recenzenta da rok za izradu recenzije istekao. Obrazac se koristi ukoliko je recenzentu je omogućen pristup jednim klikom.'),
('REVIEW_REMIND_AUTO_ONECLICK', 'ca_ES', 'Recordatori automàtic de revisió de la tramesa', 'Benvolgut/uda {$reviewerName},<br />\n<br />\nUs recordem la nostra petició per a revisar la tramesa &quot;{$submissionTitle}&quot; per a {$contextName}. Esperàvem aquesta revisió abans del {$reviewDueDate}, i aquest missatge de correu electrònic s''ha generat i enviat automàticament en haver-se superat aquesta data. Malgrat això, encara confiem rebre la vostra revisió tan aviat com la tingueu enllestida.<br />\n<br />\nURL de la tramesa: {$submissionReviewUrl}<br />\n<br />\nUs agrairem que ens confirmeu la vostra disponibilitat per a completar aquesta contribució vital per al funcionament de la revista, i confiem rebre notícies vostres  ben aviat.<br />\n<br />\n{$editorialContactSignature}', 'Aquest missatge de correu electrònic s''envia automàticament quan se supera la data de venciment per a una revisió (vegeu les opcions de revisió del pas 2 de la configuració de la revista) i s''ha habilitat l''accés per a revisors en un clic. Les tasques planificades han d''estar habilitades i configurades (vegeu el fitxer de configuració del lloc).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'cs_CZ', 'Automatické připomenutí recenze příspěvku', '{$reviewerName}:<br />\n<br />\nDovolujeme si Vám opatrně připomenout naši žádost o zpracování recenze příspěvku &quot;{$submissionTitle}&quot; pro {$contextName}. Doufali jsme, že budeme mít tuto recenzi hotovou do {$reviewDueDate} a tento email byl automaticky vygenerován a poslán, jelikož stanovený termín již vypršel. Budeme velice rádi, když od Vás recenzi dostaneme hned, jak ji budete moci dokončit.<br />\n<br />\nURL příspěvku: {$submissionReviewUrl}<br />\n<br />\nPotvrďte prosím, zda můžete dokončit tento nezbytný úkol pro náš časopis. Těším se, že se ozvete.<br />\n<br />\n{$editorialContactSignature}', 'Tento email je automaticky poslán, když recenzentovi vyprší stanovený termín pro zpracování recenze (viz Možnosti recenze v Nastavení časopisu, Krok 2) a je povolen přístup recenzenta na jedno kliknutí. Musí být povoleny a nakonfigurovány naplánované úlohy (viz konfigurační soubor stránky).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'da_DK', 'Automatisk påmindelse om bedømmelse af manuskript', '{$reviewerName}:<br />\n<br />\nDette er blot for at minde dig om vores forespørgsel om din bedømmelse af manuskriptet &quot;{$submissionTitle}&quot; til {$contextName}. Vi havde håbet på at modtage bedømmelsen senest den {$reviewDueDate}, og denne e-mail er blevet automatisk genereret og sendt til dig, da den pågældende dato er overskredet. Vi ser stadig frem til at modtage den, så snart du er færdig med den.<br />\n<br />\nManuskriptets URL-adresse: {$submissionReviewUrl}<br />\n<br />\nVi beder dig bekræfte, at du er i stand til at fuldføre dette vigtige bidrag til tidsskriftets arbejde. Jeg ser frem til at høre fra dig.<br />\n<br />\n{$editorialContactSignature}', 'Denne e-mail sendes automatisk, når en bedømmers forfaldsdato overskrides (se Bedømmelsesindstillinger under Indstillinger > Workflow > Bedømmelse), og når adgang for bedømmere ved hjælp af ét klik er aktiveret. Planlagte opgaver skal aktiveres og konfigureres (se webstedets konfigurationsfil).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'de_DE', 'Automatische Erinnerung an Begutachtung', '{$reviewerName},<br />\n<br />\nhiermit möchten wir Sie freundlich an Ihre Zusage erinnern, den Beitrag &quot;{$submissionTitle}&quot; für {$contextName} zu begutachten. Wir hatten gehofft, das Gutachten zum {$reviewDueDate} zu erhalten. Diese E-Mail wurde automatisch erstellt und nach Überschreitung des Termins versandt. Wir würden uns freuen, wenn uns das Gutachten baldmöglichst zur Verfügung stünde.<br />\n<br />\nURL des Beitrags: {$submissionReviewUrl}<br />\n<br />\nKönnten Sie uns bitte bestätigen, dass Sie nach wie vor bereit sind, unsere Zeitschrift mit Ihrer wertvollen gutachterlichen Arbeit zu unterstützen? Wir würden uns freuen, bald von Ihnen zu hören.<br />\n<br />\n{$editorialContactSignature}', 'Diese E-Mail wird automatisch verschickt, wenn das Fälligkeitsdatum für eine/n Gutachter/in verstrichen ist (vgl. die Begutachtungseinstellungen in Schritt 2 des Zeitschriftensetups) und wenn der One-Click-Zugang für Gutachter/innen aktiviert ist. Planmäßige Aufgaben (scheduled tasks) müssen aktiviert und konfiguriert sein (vgl. die Konfigurationsdatei der Website).');
INSERT INTO `email_templates_default_data` VALUES
('REVIEW_REMIND_AUTO_ONECLICK', 'el_GR', 'Αυτοματοποιημένη υπενθύμιση αξιολόγησης υποβολής', '{$reviewerName}:<br />\n<br />\nΤο παρόν μήνυμα αποτελεί υπενθύμιση του αιτήματός μας για αξιολόγηση της υποβολής &quot;{$submissionTitle},&quot; για το περιοδικό {$contextName}. Ελπίζαμε να έχουμε αυτή την αξιολόγηση μέχρι τις {$reviewDueDate}. Το παρόν μήνυμα δημιουργήθηκε και στάλθηκε αυτόματα με την παρέλευση της ημερομηνίας αυτής. Θα σας ήμαστε ευγνώμονες αν λαμβάναμε την αξιολόγηση το συντομότερο δυνατό.<br />\n<br />\nΣύνδεσμος υποβολής: {$submissionReviewUrl}<br />\n<br />\nΠαρακαλούμε επιβεβαιώστε τη δυνατότητά σας να ολοκληρώσετε την αξιολόγηση. Ελπίζουμε να λάβουμε σύντομα την απάντησή σας.<br />\n<br />\n{$editorialContactSignature}', 'Το παρόν μήνυμα αποστέλλεται αυτόματα όταν παρέλθει η προθεσμία ολοκλήρωσης μίας αξιολόγησης (ανατρέξτε στις Επιλογές Αξιολόγησης κάτω από τις Ρυθμίσεις > Ροή εργασιών > Αξιολόγηση) και η πρόσβαση με ένα κλικ στον Αξιολογητή είναι ενεργοποιημένη. Οι προγραμματισμένες εργασίες θα πρέπει να έχουν ενεργοποιηθεί και διαμορφωθεί (ανατρέξτε στο αρχείο διαμόρφωσης του ιστοτόπου).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'en_US', 'Automated Submission Review Reminder', '{$reviewerName}:<br />\n<br />\nJust a gentle reminder of our request for your review of the submission, &quot;{$submissionTitle},&quot; for {$contextName}. We were hoping to have this review by {$reviewDueDate}, and this email has been automatically generated and sent with the passing of that date. We would still be pleased to receive it as soon as you are able to prepare it.<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nPlease confirm your ability to complete this vital contribution to the work of the journal. I look forward to hearing from you.<br />\n<br />\n{$editorialContactSignature}', 'This email is automatically sent when a reviewer''s due date elapses (see Review Options under Settings > Workflow > Review) and one-click reviewer access is enabled. Scheduled tasks must be enabled and configured (see the site configuration file).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'es_ES', 'Recordatorio automático de revisión de envío', '{$reviewerName}:<br />\n<br />\nLe recordamos nuestra petición de revisión del envío &quot;{$submissionTitle},&quot; para {$contextName}. Esperábamos su revisión antes del {$reviewDueDate}, y se ha generado automáticamente este correo-e al haberse superado dicha fecha. Aún estaríamos encantados de recibirla una vez la tenga lista.<br />\n<br />\nURL del envío: {$submissionReviewUrl}<br />\n<br />\nLe rogamos nos confirme su disponibilidad para completar esta contribución vital para el trabajo de la revista. Esperamos tener noticias suyas a la mayor brevedad.<br />\n<br />\n{$editorialContactSignature}', 'Este correo electrónico se envía automáticamente cuando transcurre la fecha de vencimiento del revisor (consulte Opciones de revisión en Configuración > Flujo de trabajo> Revisar) y cuando se habilita el acceso de revisor con un clic. Las tareas programadas deben estar habilitadas y configuradas (consulte el archivo de configuración del sitio).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'eu_ES', 'Artikulua ebaluatzeko oroigarri automatizatua', '{$reviewerName}:<br />\n<br />\n{$contextName} aldizkarirako &quot;{$submissionTitle}&quot; artikuluaren ebaluazioa gogorarazteko ohartxo bat baino ez. &quot;{$reviewDueDate}&quot; egunerako espero genuen zure ebaluazio-txostena, eta, epea igaro denez, mezu hau automatikoki sortu eta bidali da. Eskertuko genizuke prestatu orduko bidaliko bazenigu.<br />\n<br />\nArtikuluaren URLa: {$submissionReviewUrl}<br />\n<br />\nMesedez, berrets iezaguzu aldizkariarentzat biziki garrantzitsua den lan hori burutuko duzula. Besterik gabe, zure erantzunaren zain geratzen naiz.<br />\n<br />\n{$editorialContactSignature}', 'Mezu hau automatikoki bidaltzen da ebaluatzaile baten epea amaitu eta erantzun ez duenean (ikus Konfigurazioko 2. urratseko Ebaluazio-aukerak) eta klik bakarreko ebaluatzaile-sarbidea gaituta dagoenean. Programatutako atazak (scheduled_tasks) gaituta eta konfiguratuta egon behar dute (ikus konfigurazio-fitxategia).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'fa_IR', 'یادآوری برای کارشناسی مقاله (اتوماتیک)', '{$reviewerName}:<br />\n<br />\nبا عرض پوزش بدین وسیله یادآوری مینمایم که متعاقب ارسال درخواست اولیه مبنی بر انجام کارشناسی مقاله &quot;{$submissionTitle},&quot; برای {$contextName}<br />\nمنتظر دریافت نظرات کارشناسی جنابعالی میباشیم. امیدواریم که نتیجه کارشناسی جنابعالی تا تاریخ {$reviewDueDate} به دست ما برسد.<br />\n<br />\nآدزس مقاله: <a href="{$submissionReviewUrl}">{$submissionReviewUrl}</a><br />\n<br />\nدر صورت امکان با ایمیل اطلاع دهید که آیا مایلید این کارسناسی را انجام دهید.<br />\n<br />\n{$editorialContactSignature}', 'This email is automatically sent when a reviewer''s due date elapses (see Review Options under Journal Setup, Step 2) and one-click reviewer access is enabled. Scheduled tasks must be enabled and configured (see the site configuration file).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'fi_FI', 'Automaattinen muistutus käsikirjoituksen arvioinnista', 'Hyvä {$reviewerName},<br />\n<br />\nMuistuttaisin ystävällisesti pyynnöstämme arvioida käsikirjoitus &quot;{$submissionTitle}&quot; julkaisulle {$contextName}. Toivoimme saavamme arviointinne {$reviewDueDate} mennessä, ja tämä sähköposti on lähetetty automaattisesti määräajan umpeuduttua. Olisimme iloisia, mikäli edelleen voisitte lähettää arvioinnin meille heti sen suoritettuanne.<br />\n<br />\nKäsikirjoituksen URL: {$submissionReviewUrl}<br />\n<br />\nVahvistattehan vielä, voitteko suorittaa tämän arvioinnin.<br />\n\n<br />\n{$editorialContactSignature}', 'This email is automatically sent when a reviewer''s due date elapses (see Review Options under Settings > Workflow > Review) and one-click reviewer access is enabled. Scheduled tasks must be enabled and configured (see the site configuration file).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'fr_CA', 'Rappel automatique d''évaluation d''une soumission', '{$reviewerName},<br />\n<br />\nCeci est un petit rappel concernant notre demande d''évaluation de la soumission « {$submissionTitle} » pour la revue {$contextName}. Puisque nous n''avons pas reçu, comme nous l''espérions, votre évaluation avant le {$reviewDueDate}, ce courriel a été généré et envoyé automatiquement après l''échéance du délai. Nous serions toutefois heureux de recevoir votre évaluation dès que possible.<br />\n<br />\nURL de la soumission : {$submissionReviewUrl}<br />\n<br />\nVeuillez confirmer que vous êtes en mesure d''effectuer ce travail essentiel pour la publication de notre revue. Nous espérons avoir de vos nouvelles très bientôt.<br />\n<br />\n{$editorialContactSignature}', 'Ce courriel est envoyé automatiquement lorsque la date d''échéance de remise d''une évaluation est révolue (voir Options d''évaluation sous Paramètres > Flux des travaux > Évaluation) et que l''accès de l''évaluateur-trice en un clic est activé. Les tâches planifiées doivent être activées et configurées (voir le fichier de configuration du site).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'fr_FR', 'Rappel automatique d''évaluation d''une soumission', '{$reviewerName}:<br />\n<br />\nCeci est un petit rappel concernant notre demande d''évaluation de la soumission « {$submissionTitle} », pour {$contextName}. Puisque nous n''avons pas reçu, comme nous l''espérions, votre évaluation avant le {$reviewDueDate}, ce courriel a été généré et envoyé automatiquement après l''échéance du délai. Nous serions toutefois heureux de recevoir votre évaluation dès que possible.<br />\n<br />\nL''adresse URL de la soumission : {$submissionReviewUrl}<br />\n<br />\nVeuillez confirmer que vous êtes en mesure d''effectuer ce travail essentiel pour la publication de notre revue. Nous espérons avoir de vos nouvelles très bientôt.<br />\n<br />\n{$editorialContactSignature}', 'Ce courriel est envoyé automatiquement quand la date d''échéance de l''évaluation est dépassée (voir Options d''évaluation à l''Étape 2 de Configuration de la revue) et que l''accès en « un clic » à un rapporteur est activé. Les Tâches planifiées doivent être activées et configurées (voir le fichier de configuration du site).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'gd_GB', 'Cuimhneachan fèin-obrachail mu lèirmheas tagraidh', '{$reviewerName}:<br />\n<br />\nDìreach cuimhneachan beag gun deach iarraidh ort lèirmheas a dhèanamh air an tagradh “{$submissionTitle},” airson {$contextName}. Bha sinn an dòchas an lèirmheas seo a choileanadh ro {$reviewDueDate} agus chaidh am post-d seo a chur gu fèin-obrachail leis gu bheil sinn seachad air a’ cheann-là ud a-nis. Bhiomaid fada nad chomain nam b’ urrainn dhut a chur thugainn fhathast cho luath ’s a ghabhas.<br />\n<br />\nURL an tagraidh: {$submissionReviewUrl}<br />\n<br />\nSaoil am b’ urrainn dhut fios a leigeil thugainn am b’ urrainn dhut an obair chudromach seo a dhèanamh airson an iris-leabhair fhathast? Tha mi an dòchas cluinntinn uat.<br />\n<br />\n{$editorialContactSignature}', 'Thèid am post-d seo a chur gu fèin-obrachail nuair a dh’fhalbhas an ùine air a’ cheann-là lìbhrigidh aig lèirmheasaiche (faic na roghainnean lèirmheis fo na “Roghainnean” > “Sruth-obrach” > “Lèirmheas) agus nuair a bhios inntrigeadh lèirmheasaichean le aon bhriogadh an comas. Feumaidh sgeidealachadh shaothraichean a bhith an comas agus air a rèiteachadh (faic faidhle rèiteachadh na làraich).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'he_IL', 'תזכורת אוטומטי להגשת חוות דעת', '{reviewerName$}:<br />\n<br />\nזוהי תזכורת לבקשתנו לחוות דעתך על ההגשה "{submissionTitle$} ל{contextName$}. קוינו לקבל את חוות הדעת עד {revewDueDate$}, ומייל זה נשלח אוטומטית לאחר תאריך זו. עדיין נשמח לקבל את זה בהקדם האפשרי.<br />\n<br />\nאתר הגשה: {submissionReviewUrl$}<br />\n<br />\nנא לאשר הסכמתך לסקור את המאמר ולהגיש חוות דעת. מחכים לשמוע ממך.<br />\n<br />\n{editorialContactSignature$}', 'דוא"ל זה נשלח אוטומטית עם חלוף תאריך היעד של הסוקר (ראה אפשרויות סקירה תחת הגדרות> זרימת עבודה> סקירה) וגישה של בודק בלחיצה אחת מופעלת. יש לאפשר ולהגדיר משימות מתוזמנות (ראה קובץ תצורת האתר).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'hi_IN', 'ऑटोमेटेड सबमिशन रिव्यू रिमाइंडर', '{$reviewerName}:<br />\n<br />\nप्रस्तुत करने की आपकी समीक्षा के लिए हमारे अनुरोध का एक सौम्य अनुस्मारक, &quot;{$submissionTitle},&quot; for {$contextName}. हम {$ reviewDueDate} द्वारा इस समीक्षा की उम्मीद कर रहे थे, और यह ईमेल स्वचालित रूप से जनरेट किया गया है और उस तारीख को पारित करने के साथ भेजा गया है। जैसे ही आप इसे तैयार करने में सक्षम होंगे, हम इसे प्राप्त करके प्रसन्न होंगे.<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nकृपया पत्रिका के काम में इस महत्वपूर्ण योगदान को पूरा करने की अपनी क्षमता की पुष्टि करें। तुम्हारे उत्तर की प्रतीक्षा है मुझे.<br />\n<br />\n{$editorialContactSignature}', 'यह ईमेल स्वचालित रूप से तब भेजा जाता है जब एक समीक्षक की नियत तिथि समाप्त हो जाती है (सेटिंग्स> वर्कफ़्लो> समीक्षा के तहत समीक्षा विकल्प देखें) और एक-क्लिक समीक्षक पहुंच सक्षम है। अनुसूचित कार्यों को सक्षम और कॉन्फ़िगर किया जाना चाहिए (साइट कॉन्फ़िगरेशन फ़ाइल देखें).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'hr_HR', 'Automatski podsjetnik za predaju recenzije', 'Poštovana/i {$reviewerName},<br />\n<br />\nželjeli bismo vas samo podsjetiti da je rok koji smo dogovorili za recenziju članka &quot;{$submissionTitle}&quot; za časopis {$contextName} istekao {$reviewDueDate}. Bilo bi nam izuzetno drago ukoliko biste recenziju završili i predali čim je prije moguće.<br />\n<br />\nDo priloga možete doći izravno prateći ovu kodiranu pozivnicu:<br />\nURL članka: {$submissionReviewUrl}<br />\n<br />\nMolimo vas da potvrdite da ste u mogućnosti privesti kraju ovaj ključan doprinos radu časopisa. Nadamo se skorom odgovoru.<br />\n<br />\nSrdačno,<br />\n{$editorialContactSignature}', 'Ovim obrascem e-pošte urednik rubrike podsjeća recenzenta da rok za izradu recenzije istekao. Obrazac se koristi ukoliko je recenzentu je omogućen pristup jednim klikom.'),
('REVIEW_REMIND_AUTO_ONECLICK', 'hu_HU', 'Automatikus emlékeztető cikk szakmai lektorálásáról', 'Tisztelt {$reviewerName}!<br />\n<br />\nÉrtesítjük, hogy a(z) {$contextName} folyóirat &quot;{$submissionTitle},&quot; című cikkének lektorálási határideje ({$reviewDueDate}) lejárt.<br />\nKérjük mielőbb készítse el szakmai bírálatát.<br />\n<br />\nKézirat URL: {$submissionReviewUrl}<br />\n<br />\nKérjük, határidő módosításának ügyében vegye fel a kapcsolatot a szerkesztőséggel!<br />\n<br />\nÜdvözlettel,<br />\n{$editorialContactSignature}', 'Ez az email automatikusan kerül kiküldésre, amikor a lektorálási határidő lejárt (lásd a Lektorálási beállításokat a Beállítások > Munkafolyamat > Szakmai lektorálás résznél) és az egykattintásos lektorálási hozzáférés engedélyezett. Az ütemezett feladatokat engedélyezni és konfigurálni kell (lásd az oldal konfigurálást).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'id_ID', 'Pengingat Review Naskah Otomatis', '{$reviewerName}:<br />\n<br />\nSekedar mengingatkan tentang permohonan kami untuk melakukan review terhadap naskah, &quot;{$submissionTitle},&quot; untuk {$contextName}. We were hoping to have this review by {$reviewDueDate}, dan email ini dikirim secara otomatis seiring terlewatinya tanggal tersebut. We would still be pleased to receive it as soon as you are able to prepare it.<br />\n<br />\nURL Naskah: {$submissionReviewUrl}<br />\n<br />\nMohon konfirmasi kesanggupan Anda untuk menyelesaikan kontribusi penting ini.  Kami menunggu balasan Anda.<br />\n<br />\n{$editorialContactSignature}', 'Email ini dikirimkan otomatis saat tenggat waktu review terlewati (lihat Opsi Review di menu Pengaturan > Alur Kerja > Review) dan akses one-click reviewer diaktifkan. Tugas terjadwal harus diaktifkan dan diatur (lihat file konfigurasi website).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'it_IT', 'Promemoria automatico revisione in attesa', 'Gentile {$reviewerName},<br />\n<br />\nQuesto è un promemoria automatico della richiesta di revisione della submission &quot;{$submissionTitle},&quot; per {$contextName}.<br />\n<br />\nScadenza prevista:  {$reviewDueDate}.<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nTi chiedo la cortesia di confermare al più presto la tua disponibilità di portare a termine l''incarico o meno.<br />\n<br />\n{$editorialContactSignature}', 'Questa email viene mandata automaticamente quando una data di revisionee scade (vedi opzioni del revisore nel Journal Setup, passo 2) e l''accesso one-click del revisore è attivato. I compiti programmati devono essere abilitati e configurati (vedi il file di configurazione del sito).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'ja_JP', '論文査読の督促（自動送信）', '{$reviewerName} 様:<br />\n<br />\n雑誌『{$contextName}』への投稿原稿「{$submissionTitle}」の査読は進んでいるでしょうか。査読期限日は、{$reviewDueDate}となっております。このメールは、期限日が過ぎた査読者に対し、システムにより自動的に作成され送信されるものです。準備ができ次第できるだけ早く査読結果をいただきたいと考えております。<br />\n<br />\n雑誌のWebサイトにログインするユーザー名とパスワードをお持ちでない場合は、次のリンクを使ってパスワードをリセットしてください（パスワードはユーザー名と共にメールで送信されます）： {$passwordResetUrl}<br />\n<br />\n投稿物のURL: {$submissionReviewUrl}<br />\n<br />\n本誌の投稿物にとって極めて重要なこの貢献を貴殿が遂行できることを確認してください。お返事をお待ちしております。<br />\n<br />\nよろしくお願いいたします。<br />\n<br />\n{$editorialContactSignature}', 'このメールは、査読者の査読期限日が過ぎ（雑誌設定ステップ2の査読オプションを参照）、査読者ワンクリックアクセスが無効な場合に、自動的に送信されるものです。定期タスク機能が有効かつ設定されている必要があります（サイト設定ファイルを参照）。'),
('REVIEW_REMIND_AUTO_ONECLICK', 'ku_IQ', 'بیرخەرەوەی تۆماتیکی هەڵسەنگاندنی توێژینەوە', '{$reviewerName}:<br />\n<br />\nبیرخەرەوەیەک بۆ هەڵسەنگاندنی, &quot;{$submissionTitle},&quot; بۆ {$contextName}. ئێمە هیواخوازین هەڵسەنگاندنەکە هەتا {$reviewDueDate} تەواو بکرێت، ئەم ئیمەیڵە بە شێوەی تۆماتیکی و دوای کۆتاییهاتنی وادەکە نێردراوە. ئێمە هێشتا چاوەڕوانین کە لە زوترین کاتدا وەڵامی ئێوەمان بەدەست بگاتەوە.<br />\n<br />\nلینکی توێژینەوەکە: {$submissionReviewUrl}<br />\n<br />\nتکایە دڵنیامان بکەوە کە دەتوانیت کارەکە ئەنجام بدەیت، ئێمە چاوەڕوانی وەڵامی ئێوەین.<br />\n<br />\n{$editorialContactSignature}', 'ئەم ئیمەیڵە بە شێوەیەکی تۆماتیکی بۆ هەڵسەنگێنەر نێردراوە بە هۆی کۆتاییهاتنی وادەی هەڵسەنگاندن (بژاردەکانی هەڵسەنگاندن لێرەوە ببینە ڕێکخستنەکان/ ڕێڕەوی کار/ هەڵسەنگاندن) و بە کلیکێک دەستپێڕاگەیشتنی هەڵسەنگێنەر ناچالاک دەکریت. ئەرکە پلان بۆ دانراوەکان دەبێت چالاک کرابن.'),
('REVIEW_REMIND_AUTO_ONECLICK', 'mk_MK', 'Автоматски потсетник за рецензија на поднесок', '{$reviewerName}:<br />\n<br />\nМал потсетник за нашето барање за вашата рецензија на поднесокот, &quot;{$submissionTitle},&quot; за {$contextName}. Се надевавме дека ќе ја добиеме вашата рецензија до {$reviewDueDate}, и овој и-меил е автоматски генериран и испратен со истекот на тој датум. Ни се уште би биле задоволни да ја добиеме веднаш штом ќе можете да ја подготвите.<br />\n<br />\nURL-адреса на поднесокот: {$submissionReviewUrl}<br />\n<br />\nВе молам за потврда дека можете да го завршите овој неопходен придонес кон работата на ова списание. Со нетрпение очекувам да слушнам од вас.<br />\n<br />\n{$editorialContactSignature}', 'Овој и-меил е автоматски испратен кога рокот за рецензија на рецензентот е истечен (видете Опции за рецензија во Поставки > Тек на работа > Рецензија) и пристапот за рецензентот преку еден клик е оневозможен. Закажаните задачи мора да се овозможени и прилагодени(видете ја датотеката за прилагодување на веб-страницата).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'nb_NO', 'Påminnelse om fagfellevurdering (automatisk e-post)', '{$reviewerName}:<br />\n<br />\nDette er en automatisk generert e-post som sendes for å minne deg på at du har tatt på deg å vurdere manuskriptet «{$submissionTitle}» for {$contextName}. Jeg minner om at fristen for oppdraget var satt til {$reviewDueDate}. Jeg ser fram til å motta vurderingen din, så snart du har den klar.<br />\n<br />\nInnleveringens URL: {$submissionReviewUrl}<br />\n<br />\nKan du bekrefte om du fortsatt vil fullføre vurderingen for tidsskriftet vårt? Jeg ser fram til å høre fra deg.<br />\n<br />\n{$editorialContactSignature}', 'Denne e-posten sendes automatisk til fagfellen når tidsfristen for en fagfellevurdering utløper (se Oppsett for fagfellevurdering  under Innstillinger > Arbeidsflyt Fagfellevurdering). «Planlagte oppgaver» må være slått på og konfigurert (se konfigurasjonsfilen for nettstedet).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'nl_NL', 'Geautomatiseerde review herinnering', '{$reviewerName}:<br />\n<br />\nWe willen u vriendelijk herinneren aan ons verzoek om de inzending &quot;{$submissionTitle}&quot; voor {$contextName} te reviewen. We verwachtten uw review op {$reviewDueDate}. Deze e-mail is automatisch gegenereerd bij het verstrijken van die datum. We stellen het zeer op prijs om de review te ontvangen zodra u in de gelegenheid bent om die uit te voeren.<br />\n<br />\nInzendings-URL: {$submissionReviewUrl}<br />\n<br />\nWilt u uw beschikbaarheid voor het voltooien van deze voor het werk van het tijdschrift vitale taak bevestigen. Ik kijk uit naar uw reactie.<br />\n<br />\n{$editorialContactSignature}', 'Deze e-mail wordt automatisch verzonden als de afgesproken reviewperiode verstrijkt (zie review opties onder Tijdschrift inrichten, stap 2) en een-klik toegang voor de reviewer is ingeschakeld. Geplande taken moeten worden ingeschakeld en geconfigureerd (zie het siteconfiguratiebestand).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'pl_PL', 'Automatyczne przypomnienie o upłynięciu terminu wykonania recenzji', '{$reviewerName}:<br />\n<br />\nprzypominamy, że w dniu {$reviewDueDate} minął termin wykonania recenzji tekstu &quot;{$submissionTitle}&quot; zgłoszonego do czasopisma {$contextName}. Mamy nadzieję, że w krótkim czasie otrzymamy od Pani/ Pana gotową recenzję.<br />\n<br />\nWWW tekstu: {$submissionReviewUrl}<br />\n<br />\nBędziemy wdzięczni za potwierdzenie gotowości do wykonania recenzji.<br />\n<br />\n{$editorialContactSignature}', 'Wiadomość automatycznie wysłana po upłynięciu terminu nadesłania recenzji. Zaplanowane zadania w systemie muszą zostać na nowo skonfigurowane.'),
('REVIEW_REMIND_AUTO_ONECLICK', 'pt_BR', 'Lembrete automático de solicitação de avaliação', '{$reviewerName}:<br />\n<br />\nEste é apenas um lembrete amigável do nosso pedido de avaliação da submissão, &quot;{$submissionTitle},&quot; ao periódico {$contextName}. Esperávamos ter recebido sua avaliação até {$reviewDueDate}, então este email foi gerado automaticamente com o passar daquele prazo. Nós ainda assim ficaríamos gratos em recebê-la assim que você conseguir prepará-la.<br />\n<br />\nURL da submissão: {$submissionReviewUrl}<br />\n<br />\nPor favor, confirme que poderá completar essa contribuição vital ao trabalho do periódico. Aguardo seu retorno.<br />\n<br />\n{$editorialContactSignature}', 'Mensagem enviada automaticamente ao avaliador quando a data de conclusão de avaliação for ultrapassada (veja as Opções de Avaliação no Passo 2 da Configuração da Revista) e o acesso 1-Clique estiver ativado. Tarefas agendadas devem ser habilitadas e configuradas (veja o arquivo de configuração do sistema).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'pt_PT', 'Lembrete automático de pedido de revisão', '{$reviewerName},<br />\n<br />\nEste é apenas um lembrete automático, referente ao pedido de revisão da submissão &quot;{$submissionTitle}&quot; a {$contextName}. Esperávamos receber a revisão até {$reviewDueDate} e este email foi enviado automaticamente pois o prazo expirou. Aguardamos a receção da revisão assim que for possível concluí-la.<br />\n<br />\nURL da submissão: {$submissionReviewUrl}<br />\n<br />\nConfirme a sua disponibilidade para concluir esta tarefa fundamental para a qualidade da revista. \nAguardando o seu contacto,<br />\n<br />\n{$editorialContactSignature}', 'Este e-mail é enviado automaticamente quando o prazo de revisão expirou (consulte Opções de revisão em Configurações > Fluxo de trabalho > Revisão) e o acesso em um clique está ativo. As tarefas agendadas devem ser ativadas e configuradas (consulte o ficheiro de configuração do portal).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'ro_RO', 'Memento automat de revizuire a manuscrisului', '{$reviewerName}:<br />\n<br />\nVă reamintim că ați acceptat să revizuiți manuscrisul, &quot;{$submissionTitle},&quot; pentru {$contextName}. Sperăm să ne trimiteți această revizuire până la {$reviewDueDate}, iar acest e-mail a fost generat și trimis automat odată cu trecerea acestei date. Ne-ar face plăcere să primim revizia dumneavoastră imediat ce o puteți pregăti.<br />\n<br />\nURL Manuscris: {$submissionReviewUrl}<br />\n<br />\nToate cele bune.<br />\n<br />\n{$editorialContactSignature}', 'Acest e-mail este trimis automat la expirarea termenului de scadență al unui revizor (consultați Opțiunile de revizuire din Setări> Flux de lucru> Revizuire) și accesul cu un singur clic al revizorului este activat. Sarcinile programate trebuie să fie activate și configurate (consultați fișierul de configurare a site-ului).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'ru_RU', 'Автоматическое напоминание о рецензии на материал', 'Здравствуйте, {$reviewerName}!<br />\n<br />\nЭто напоминание о нашем запросе Вашей рецензии на материал «{$submissionTitle}» для журнала «{$contextName}». Мы надеялись получить эту рецензию до {$reviewDueDate}, и это письмо было автоматически сгенерировано и отправлено, так как эта дата уже прошла. Мы будем рады, если Вы как можно скорее ее подготовите.<br />\n<br />\nURL материала: {$submissionReviewUrl}<br />\n<br />\nПожалуйста, подтвердите, что Вы сможете сделать этот важный вклад в работу нашего журнала. Жду вашего ответа.<br />\n<br />\n{$editorialContactSignature}', 'Это письмо отправляется автоматически, когда дата предоставления рецензии рецензентом прошла (смотрите Параметры рецензирования в Настройки > Рабочий процесс > Рецензирование) и прямой доступ рецензента по ссылке включен. Запланированные задачи должны быть включены и настроены (смотрите файл конфигурации сайта).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'sk_SK', 'Automatické pripomenutie recenzie príspevku', '{$reviewerName}:<br />\n<br />\nDovoľujeme si Vám opatrne pripomenúť našu žiadosť o spracovanie recenzie príspevku &quot;{$submissionTitle}&quot; pre {$contextName}. Dúfali sme, že budeme mať túto recenziu hotovú do {$reviewDueDate} a tento email bol automaticky vygenerovaný a poslaný, keďže stanovený termín už vypršal. Budeme veľmi radi, keď od Vás recenziu dostaneme hneď, ako ju budete môcť dokončiť.<br />\n<br />\nURL príspevky: {$submissionReviewUrl}<br />\n<br />\nPotvrďte prosím, či môžete dokončiť túto nevyhnutnú úlohu pre náš časopis. Teším sa, že sa ozvete.<br />\n<br />\n{$editorialContactSignature}', 'Tento email je automaticky poslaný, keď recenzentovi vyprší stanovený termín pre spracovanie recenzie (pozri Možnosti recenzie v Nastavenie časopisu, Krok 2) a je povolený prístup recenzenta na jedno kliknutie. Musia byť povolené a nakonfigurované naplánované úlohy (pozri konfiguračný súbor stránky).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'sl_SI', 'Avtomatski opomnik za recenzijo prispevka', '{$reviewerName}:<br />\n<br />\nAvtomatski opomnik za recenzijo prispevka, &quot;{$submissionTitle},&quot; za revijo {$contextName}. Upali smo, da boste opravili recenzijo do predvidenega datuma {$reviewDueDate}. E-pošta je bila generirana avtomatično s potekom datuma. Z veseljem jo bomo sprejeli takoj, ko jo pripravite.<br />\n<br />\nURL povezava do prispevka: {$submissionReviewUrl}<br />\n<br />\nProsim, če potrdite vašo pripravljenost za dokončanje vašega pomembnega prispevka za delo revije. Veselimo se vašega odgovora.<br />\n<br />\n{$editorialContactSignature}', 'Ta email se pošlje recenzentu avtomatično, ko poteče rok za opravljanje recenzije (več v recenzijskih nastavitveh v Nastavitve > Potek dela > Recenzija) in je vključena opcija za recenzentski dostop z enim klikom. Opozorilo: administrator spletišča mora v nastavitveni datoteki spletišča nastaviti "Scheduled tasks".'),
('REVIEW_REMIND_AUTO_ONECLICK', 'sv_SE', 'Automatisk påminnelse om granskning av bidrag', '{$reviewerName}:<br />\n<br />\nDet här är bara en påminnelse om vår förfrågan om din granskning av bidraget &quot;{$submissionTitle}&quot; för {$contextName}. Vi hade hoppats på att få din granskning senast {$reviewDueDate} och det här e-postmeddelandet skickas automatiskt när datum för deadline passeras. Vi skulle fortfarande vara tacksamma över att få in din granskning, så fort som möjligt.<br />\n<br />\nBidragets URL: {$submissionReviewUrl}<br />\n<br />\nVänligen bekräfta snarast om du har möjlighet att genomföra granskningsuppdraget, som utgör en viktig del av tidskriftens arbete. Vi ser fram emot att höra från dig.<br />\n<br />\n{$editorialContactSignature}', 'Det här e-postmeddelandet skickas automatiskt när en granskares deadline löper ut (se Granskningsalternativ under Inställningar > Arbetsflöde > Granskning) och när Granskning utan inloggning är aktiverat. Schemalagda aktiviteter måste vara aktiverat och konfigurerat (se serverns konfigurationsfil).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'tr_TR', 'Değerlendirilme Konusunda Otomatik Hatırlatma', 'Sayın {$reviewerName},<br />\n<br />\n{$contextName} adlı dergide yayınlanması için değerlendirilmek üzere gönderilen &quot;{$submissionTitle}&quot; başlıklı çalışmanın değerlendirmesini {$reviewDueDate} tarihinden önce tamamlayacağınızı ümit ediyorduk. Yoğun işleriniz nedeni ile oluşan gecikme nedeni ile sistemimiz tarafından bu mesaj tarafınıza otomatik olarak gönderilmişitir. <br />\n<br />\nDeğerlendirme raporunuzu bize bir an önce ileteceğiniz inancı ile dergimiz sitesindeki ulaşım bilgilerini size iletmeyi istedik.<br />\n<br />\nEğer derginin web sitesine giriş için kullanıcı adı ve şifreniz yoksa veya unuttunuz ise, şifrenizi yenilemek için bu bağlantıyı kullanabilirsiniz (Kullanıcı adınızla birlikte şifreniz size postalanacaktır). {$passwordResetUrl}<br />\n<br />\nMakale Erişim Adresi: {$submissionReviewUrl}<br />\n<br />\nDerginin kalitesini arttıracak bu önemli katkıyı yapabileceğinizi lütfen onaylayınız.<br />\n<br />\n{$editorialContactSignature}', 'Gözden geçirme işlemi için verilen süre geçtiğinde ve hakemler için tek tıklama özelliği açıldığında bu elektronik posta otomatik olarak gönderilir(Derginin Kurulum Bölümü altındaki Gözden Geçirme seçeneklerine bakınız, Adım 2). Zamanlanmış görevler aktif hale getirilmeli ve düzenlenmelidir(alan düzenleme dosyasına bakınız).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'uk_UA', 'Автоматичне нагадування про рецензування', '{$reviewerName}:<br />\n<br />\nНагадуємо Вам про рецензування подання, &quot;{$submissionTitle},&quot; для видання {$contextName}. Ми очікували отримати цю рецензію до {$reviewDueDate}, цей лист був автоматично надісланий Вам, оскільки вказана дата минула. Ми все ще чекаємо на Вашу рецензію і будемо вдячні, якщо Ви завершите та надішлете її якомога скоріше.<br />\n<br />\nURL подання:{$submissionReviewUrl}<br />\n<br />\nБудь ласка, підтвердіть можливість завершити цю важливу для нашого журналу роботу. З нетерпінням очікую Вашої відповіді.<br />\n<br />\n{$editorialContactSignature}', 'Цей лист автоматично надсилається рецензенту, коли настає кінцева дата рецензування (див. розділ "Налаштування рецензування" кроку 2 Налаштування журналу) та включений доступ рецензента "єдиним натисканням". Щоб ця функціональність працювала необхідно включити на налаштувати Scheduled tasks (див. файл конфігурації сайту).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'vi_VN', 'Nhắc nhở nộp bài đánh giá (tự động)', 'Kính gửi {$reviewerName},<br />\n<br />\nĐây là lời nhắc về yêu cầu của chúng tôi để bạn xem xét bài gửi, &quot;{$submissionTitle},&quot; cho {$contextName}. Chúng tôi hy vọng sẽ có đánh giá này vào ngày {$reviewDueDate}, và email này đã được tự động tạo và gửi cùng với ngày đó. Chúng tôi vẫn sẽ vui lòng nhận được nó ngay khi bạn gửi nó.<br />\n<br />\nURL bài gửi: {$submissionReviewUrl}<br />\n<br />\nVui lòng xác nhận khả năng hoàn thành quy trình quan trọng này cho công việc của tạp chí. Chúng tôi mong nhận được phản hồi của bạn.<br />\n<br />\n{$editorialContactSignature}', 'Email này được gửi tự động khi hết hạn đánh giá của người phản biện (xem Tùy chọn đánh giá trong Cài đặt > Quy trình làm việc > Phản biện) và quyền truy cập của người phản biện không cần đăng nhập được bật. Các tác vụ theo lịch trình phải được bật và định cấu hình (xem tệp cấu hình trang).'),
('REVIEW_REMIND_AUTO_ONECLICK', 'zh_CN', '自动发出的稿件审查提醒函', '{$reviewerName}:<br />\n<br />\n这封信只是礼貌地提醒您，我们已邀请您为《{$contextName}》审查稿件〈{$submissionTitle}〉。我们希望您<br />\n能在 {$reviewDueDate}前完成这份审查工作，并请您在备妥审查意见书之后尽快寄给我们。<br />\n<br />\n稿件网址：{$submissionReviewUrl}<br />\n<br />\n请确认您能够完成这个对本期刊作品而言非常重要的贡献。我们期盼听到您的回复。<br />\n<br />\n{$editorialContactSignature}', '这封电子邮件这封电子邮件在一位审查人的工作期限日已经超过的时候，会自动发出给他（见「期刊设定」之步骤2，「审查选项」），而审查访问一点即入的功能已经启用。必须启用并且设定排程任务（见网站设定档案）。'),
('REVIEW_REMIND_ONECLICK', 'ar_IQ', 'تذكير لتحكيم طلب نشر', '{$reviewerName}:<br />\n<br />\nهذا مجرد تذكير لجنابكم الكريم بشأن تحكيمكم للمؤلَّف الموسوم &quot;{$submissionTitle},&quot; والمرسل إلى {$contextName}.  نحن نأمل الحصول منكم على هذا التحكيم حتى يوم {$reviewDueDate}، ونرجو أن نتلقاه منكم حالماً تكونوا جاهزين لإرساله.<br />\n<br />\nرابط الطلب: {$submissionReviewUrl}<br />\n<br />\nلطفاً، أكدوا لنا قدرتكم على إكمال هذه المساهمة الحيوية في أعمال مجلتنا. إنني أتطلع إلى ردكم في أقرب وقت.<br />\n<br />\n{$editorialContactSignature}', 'هذه الرسالة يذكر بها محرر القسم محكماً باستيجاب مهلة تقييمه لمؤلَّف ما.'),
('REVIEW_REMIND_ONECLICK', 'bs_BA', 'Podsjetnik za predaju Recenzije', '{$reviewerName}:<br />\n<br />\nŽeljeli bismo vas samo podsjetiti da je rok koji smo dogovorili za recenziju članka, &quot;{$submissionTitle},&quot; za časopis {$contextName} istekao {$reviewDueDate}. Bilo bi nam izuzetno drago ukoliko biste recenziju završili i predali čim je prije moguće.<br />\n<br />\nPodsjećamo da do priloga možete doći izravno prateći ovu kodiranu pozivnicu:<br />\n{$submissionReviewUrl}<br />\n<br />\nMolimo vas da potvrdite da ste u mogućnosti privesti kraju ovaj ključan doprinos radu časopisa. Nadamo se skorom odgovoru.<br />\n<br />\n{$editorialContactSignature}', 'Ovu e-poštu je poslao urednik rubrike da podsjeti recenzenta da je njegova recenzija dospjela.'),
('REVIEW_REMIND_ONECLICK', 'ca_ES', 'Recordatori de revisió de la tramesa', 'Benvolgut/uda {$reviewerName},<br />\n<br />\nUs recordem la nostra petició per a revisar la tramesa &quot;{$submissionTitle}&quot; per a {$contextName}. Esperàvem aquesta revisió abans del {$reviewDueDate}, i confiem rebre-la tan aviat com la tingueu enllestida.<br />\n<br />\nURL de la tramesa: {$submissionReviewUrl}<br />\n<br />\nUs agrairem que ens confirmeu la vostra disponibilitat per a completar aquesta contribució vital per al funcionament de la revista, i confiem rebre notícies vostres ben aviat.<br />\n<br />\n{$editorialContactSignature}', 'Aquest missatge de correu electrònic té un editor de secció com a remitent i s''envia a un revisor per a recordar-li que ha superat la data de venciment per a lliurar la revisió.'),
('REVIEW_REMIND_ONECLICK', 'cs_CZ', 'Připomenutí recenze příspěvku', '{$reviewerName}:<br />\n<br />\nDovolujeme si Vám opatrně připomenout naši žádost o zpracování recenze příspěvku &quot;{$submissionTitle}&quot; pro {$contextName}. Doufali jsme, že budeme mít tuto recenzi hotovou do {$reviewDueDate} a budeme rádi, když ji od Vás dostaneme hned, jak ji budete moci dokončit.<br />\n<br />\nURL příspěvku: {$submissionReviewUrl}<br />\n<br />\nPotvrďte prosím, zda můžete dokončit tento nezbytný úkol pro náš časopis. Těším se, že se ozvete.<br />\n<br />\n{$editorialContactSignature}', 'Tento email posílá editor sekce recenzentovi, aby mu připomněl, že vypršel termín pro zpracování recenze.'),
('REVIEW_REMIND_ONECLICK', 'da_DK', 'Påmindelse om bedømmelse af manuskript', '{$reviewerName}:<br />\n<br />\nDette er blot for at minde dig om vores forespørgsel om din bedømmelse af manuskriptet &quot;{$submissionTitle}&quot; til {$contextName}. Vi havde håbet på at modtage bedømmelsen senest den {$reviewDueDate} og ser frem til at modtage den, så snart du er færdig med den.<br />\n<br />\nManuskriptets URL-adresse: {$submissionReviewUrl}<br />\n<br />\nVi beder dig bekræfte, at du er i stand til at fuldføre dette vigtige bidrag til tidsskriftets arbejde. Jeg ser frem til at høre fra dig.<br />\n<br />\n{$editorialContactSignature}', 'Denne e-mail sendes af sektionsredaktøren til en bedømmer for at minde vedkommende om, at bedømmelsen skulle have været afleveret.'),
('REVIEW_REMIND_ONECLICK', 'de_DE', 'Erinnerung an die Fälligkeit eines Gutachtens', '{$reviewerName},<br />\n<br />\nhiermit möchten wir Sie freundlich an Ihre Zusage erinnern, den Beitrag &quot;{$submissionTitle}&quot; für {$contextName} zu begutachten. Wir hatten gehofft, das Gutachten zum {$reviewDueDate} zu erhalten. Diese E-Mail wurde automatisch erstellt und nach Überschreitung des Termins versandt. Wir würden uns freuen, wenn uns das Gutachten baldmöglichst zur Verfügung stünde.<br />\n<br />\nURL des Beitrags: {$submissionReviewUrl}<br />\n<br />\nKönnten Sie uns bitte bestätigen, dass Sie nach wie vor bereit sind, unsere Zeitschrift gutachterlich zu unterstützen? Wir würden uns freuen, bald von Ihnen zu hören.<br />\n<br />\n{$editorialContactSignature}', 'Diese E-Mail wird von einer Rubrikredakteurin/einem Rubrikredakteur gesendet, um eine/n Gutachter/in daran zu erinnern, dass ihr/sein Gutachten fällig ist.'),
('REVIEW_REMIND_ONECLICK', 'el_GR', 'Υπενθύμιση αξιολόγησης υποβολής', '{$reviewerName}:<br />\n<br />\nΤο παρόν μήνυμα αποτελεί υπενθύμιση του αιτήματός μας για αξιολόγηση της υποβολής, &quot;{$submissionTitle},&quot; για το περιοδικό {$contextName}. Ελπίζουμε να έχουμε αυτή την αξιολόγηση μέχρι τις {$reviewDueDate} και θα σας είμαστε ευγνώμονες αν τη λάβουμε το συντομότερο δυνατό.<br />\n<br />\nΣύνδεσμος υποβολής: {$submissionReviewUrl}<br />\n<br />\nΠαρακαλούμε επιβεβαιώστε τη δυνατότητά σας να ολοκληρώσετε την αξιολόγηση. Ελπίζουμε να λάβουμε σύντομα την απάντησή σας.<br />\n<br />\n{$editorialContactSignature}', 'Το παρόν μήνυμα αποστέλλεται από τον Επιμελητή Ενότητας στον Αξιολογητή, ως υπενθύμιση ότι η αξιολόγηση εκκρεμεί.'),
('REVIEW_REMIND_ONECLICK', 'en_US', 'Submission Review Reminder', '{$reviewerName}:<br />\n<br />\nJust a gentle reminder of our request for your review of the submission, &quot;{$submissionTitle},&quot; for {$contextName}. We were hoping to have this review by {$reviewDueDate}, and would be pleased to receive it as soon as you are able to prepare it.<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nPlease confirm your ability to complete this vital contribution to the work of the journal. I look forward to hearing from you.<br />\n<br />\n{$editorialContactSignature}', 'This email is sent by a Section Editor to remind a reviewer that their review is due.'),
('REVIEW_REMIND_ONECLICK', 'es_ES', 'Recordatorio de envío de revisión', '{$reviewerName}:<br />\n<br />\nLe recordamos nuestra petición de revisión del envío &quot;{$submissionTitle},&quot; para {$contextName}. Esperábamos su revisión antes del {$reviewDueDate}, esperamos nos la mande en cuanto la tenga lista.<br />\n<br />\nURL del envío: {$submissionReviewUrl}<br />\n<br />\nLe rogamos nos confirme su disponibilidad para completar esta contribución vital para el trabajo de la revista. Esperamos tener noticias suyas a la mayor brevedad.<br />\n<br />\n{$editorialContactSignature}', 'Este correo es enviado por el/la Editor/a de Sección para recordar a un/a revisor/a que ya debe entregar su revisión.'),
('REVIEW_REMIND_ONECLICK', 'eu_ES', 'Artikulua ebaluatzeko oroigarria', '{$reviewerName}:<br />\n<br />\n{$contextName} aldizkarirako &quot;{$submissionTitle}&quot; artikuluaren ebaluazioa gogorarazteko ohartxo bat baino ez. {$reviewDueDate} egunerako espero genuen zure ebaluazio-txostena, eta prestatuta daukazunean lehenbailehen bidaltzea eskertuko genizuke.<br />\n<br />\nArtikuluaren URLa: {$submissionReviewUrl}<br />\n<br />\nMesedez, berrets iezaguzu aldizkariarentzat biziki garrantzitsua den lan hori burutuko duzula. Besterik gabe, zure erantzunaren zain geratzen naiz.<br />\n<br />\n{$editorialContactSignature}', 'Mezu hau Ataleko editoreak Ebaluatzaileari bidaltzen dio, ebaluazioa egiteko epea pasatu dela gogorarazteko.'),
('REVIEW_REMIND_ONECLICK', 'fa_IR', 'یادآوری برای کارشناسی مقاله', '{$reviewerName}:<br />\n<br />\nبا عرض پوزش بدین وسیله یادآوری مینمایم که متعاقب ارسال درخواست اولیه مبنی بر انجام کارشناسی مقاله &quot;{$submissionTitle},&quot; برای {$contextName}<br />\nمنتظر دریافت نظرات کارشناسی جنابعالی میباشیم. امیدواریم که نتیجه کارشناسی جنابعالی تا تاریخ {$reviewDueDate} به دست ما برسد.<br />\n<br />\nآدزس مقاله: <a href="{$submissionReviewUrl}">{$submissionReviewUrl}</a><br />\n<br />\nدر صورت امکان با ایمیل اطلاع دهید که آیا مایلید این کارسناسی را انجام دهید.<br />\n<br />\n{$editorialContactSignature}', 'This email is sent by a Section Editor to remind a reviewer that their review is due.'),
('REVIEW_REMIND_ONECLICK', 'fi_FI', 'Muistutus käsikirjoituksen arvioinnista', 'Hyvä {$reviewerName},<br />\n<br />\nMuistuttaisin ystävällisesti pyynnöstämme arvioida käsikirjoitus &quot;{$submissionTitle}&quot; julkaisulle {$contextName}. Toivoimme saavamme arviointinne {$reviewDueDate} mennessä, ja nyt olisimme iloisia, mikäli voisitte lähettää arvioinnin meille heti sen suoritettuanne.<br />\n<br />\nKäsikirjoituksen URL: {$submissionReviewUrl}<br />\n<br />\nVahvistattehan vielä, voitteko suorittaa tämän arvioinnin.<br />\n\n<br />\n{$editorialContactSignature}', 'This email is sent by a Section Editor to remind a reviewer that their review is due.'),
('REVIEW_REMIND_ONECLICK', 'fr_CA', 'Rappel d''évaluation d''une soumission', '{$reviewerName},<br />\n<br />\nCeci est un petit rappel concernant notre demande d''évaluation de la soumission « {$submissionTitle} » pour la revue {$contextName}. Nous espérions recevoir votre évaluation avant le {$reviewDueDate}. Nous serions heureux de la recevoir dès que possible.<br />\n<br />\nURL de la soumission : {$submissionReviewUrl}<br />\n<br />\nVeuillez confirmer que vous êtes en mesure d''effectuer ce travail essentiel pour la publication de notre revue. Nous espérons avoir de vos nouvelles très bientôt.<br />\n<br />\n{$editorialContactSignature}', 'Ce courriel est envoyé par le,la rédacteur-trice de rubrique à un,une évaluateur-trice pour lui rappeler que son évaluation est due.'),
('REVIEW_REMIND_ONECLICK', 'fr_FR', 'Rappel d''évaluation d''une soumission', '{$reviewerName}:<br />\n<br />\nJuste un petit mot pour vous rappeler notre demande d''évaluation de la soumission intitulée « {$submissionTitle} », pour {$contextName}. Nous espérions recevoir votre évaluation le {$reviewDueDate} et nous serions heureux de la recevoir aussitôt qu''il vous sera possible de le faire.<br />\n<br />\nAdresse URL de la soumission : {$submissionReviewUrl}<br />\n<br />\nVeuillez confirmer si vous êtes en mesure de compléter ce travail essentiel pour la publication de la revue. Espérant avoir de vos nouvelles sous peu.<br />\n<br />\n{$editorialContactSignature}', 'Ce courriel est envoyé par le Rédacteur de rubrique à un rapporteur pour lui rappeler que son évaluation est due.');
INSERT INTO `email_templates_default_data` VALUES
('REVIEW_REMIND_ONECLICK', 'gd_GB', 'Cuimhneachan mu lèirmheas tagraidh', '{$reviewerName}:<br />\n<br />\nDìreach cuimhneachan beag gun deach iarraidh ort lèirmheas a dhèanamh air an tagradh “{$submissionTitle},” airson {$contextName}. Bha sinn an dòchas an lèirmheas seo a choileanadh ro {$reviewDueDate} agus bhiomaid fada nad chomain nam b’ urrainn dhut a chur thugainn cho luath ’s a ghabhas.<br />\n<br />\nURL an tagraidh: {$submissionReviewUrl}<br />\n<br />\nSaoil am b’ urrainn dhut fios a leigeil thugainn am b’ urrainn dhut an obair chudromach seo a dhèanamh airson an iris-leabhair fhathast? Tha mi an dòchas cluinntinn uat.<br />\n<br />\n{$editorialContactSignature}', 'Thèid am post-d seo a chur gu lèirmheasaiche le deasaiche earrainn airson cur na c(h)uimhne gu bheil an lèirmheas aca ri lìbhrigeadh.'),
('REVIEW_REMIND_ONECLICK', 'he_IL', 'תזכורת הגשת חוות דעת', '{reviewerName$}:<br />\n<br />\nזוהי תזכורת לבקשתנו לחוות דעתך על ההגשה "{submissionTitle$} ל{contextName$}. קוינו לקבל את חוות הדעת עד {revewDueDate$}, ונשמח לקבל את זה בהקדם.<br />\n<br />\nאתר הגשה: {submissionReviewUrl$}<br />\n<br />\nנא לאשר הסכמתך לסקור את המאמר ולהגיש חוות דעת. מחכים לשמוע ממך.<br />\n<br />\n{editorialContactSignature$}', 'דוא"ל זה נשלח על ידי עורך מדור להזכיר מבקר שהביקורת שלהם נובעת.'),
('REVIEW_REMIND_ONECLICK', 'hi_IN', 'सबमिशन समीक्षा रिमाइंडर', '{$reviewerName}:<br />\n<br />\nप्रस्तुत करने की आपकी समीक्षा के लिए हमारे अनुरोध का एक सौम्य अनुस्मारक, &quot;{$submissionTitle},&quot; for {$contextName}. हम {$ reviewDueDate} द्वारा इस समीक्षा की उम्मीद कर रहे थे, और जैसे ही आप इसे तैयार करने वाले हैं, इसे प्राप्त करके प्रसन्न होंगे.<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nकृपया जर्नल के काम में इस महत्वपूर्ण योगदान को पूरा करने की अपनी क्षमता की पुष्टि करें। तुम्हारे उत्तर की प्रतीक्षा है मुझे.<br />\n<br />\n{$editorialContactSignature}', 'यह ईमेल एक अनुभाग संपादक द्वारा एक समीक्षक को याद दिलाने के लिए भेजा जाता है कि उनकी समीक्षा होने वाली है.'),
('REVIEW_REMIND_ONECLICK', 'hr_HR', 'Podsjetnik za predaju Recenzije', '{$reviewerName}:<br />\n<br />\nŽeljeli bismo vas samo podsjetiti da je rok koji smo dogovorili za recenziju članka, &quot;{$submissionTitle},&quot; za časopis {$contextName} istekao {$reviewDueDate}. Bilo bi nam izuzetno drago ukoliko biste recenziju završili i predali čim je prije moguće.<br />\n<br />\nPodsjećamo da do priloga možete doći izravno prateći ovu kodiranu pozivnicu:<br />\n{$submissionReviewUrl}<br />\n<br />\nMolimo vas da potvrdite da ste u mogućnosti privesti kraju ovaj ključan doprinos radu časopisa. Nadamo se skorom odgovoru.<br />\n<br />\n{$editorialContactSignature}', 'Ovu e-poštu je poslao urednik rubrike da podsjeti recenzenta da je njegova recenzija dospjela.'),
('REVIEW_REMIND_ONECLICK', 'hu_HU', 'Emlékeztető cikk szakmai lektorálásáról', 'Tisztelt {$reviewerName}!<br />\n<br />\nÉrtesítjük, hogy a(z) {$contextName} folyóirat &quot;{$submissionTitle},&quot; című cikkének lektorálási határideje ({$reviewDueDate}) lejárt.<br />\nKérjük mielőbb készítse el szakmai bírálatát.<br />\n<br />\nKézirat URL: {$submissionReviewUrl}<br />\n<br />\nKérjük, határidő módosításának ügyében vegye fel a kapcsolatot a szerkesztőséggel!<br />\n<br />\nÜdvözlettel,<br />\n{$editorialContactSignature}', 'Ezt az emailt a Rovatszerkesztő küldi a Szakmai Lektornak, hogy emlékeztesse a lektorálási határidőre.'),
('REVIEW_REMIND_ONECLICK', 'id_ID', 'Pengingat Review Naskah', '{$reviewerName}:<br />\n<br />\nSekedar mengingatkan tentang permohonan kami untuk melakukan review terhadap naskah, &quot;{$submissionTitle},&quot; untuk {$contextName}. Kami mengharapkan telah menerima review ini pada {$reviewDueDate}, dan akan sangat berbahagia untuk dapat menerimanya segera setelah Anda menyelesaikannya.<br />\n<br />\nURL Naskah: {$submissionReviewUrl}<br />\n<br />\nMohon konfirmasi kesanggupan Anda untuk menyelesaikan kontribusi penting ini.  Kami menunggu balasan Anda.<br />\n<br />\n{$editorialContactSignature}', 'Email ini dikirimkan Editor Bagian untuk mengingatkan reviewer bahwa review telah mencapai tenggat.'),
('REVIEW_REMIND_ONECLICK', 'it_IT', 'Promemoria revisione in attesa', 'Gentile {$reviewerName},<br />\n<br />\nTi ricordo la richiesta di revisione della submission, &quot;{$submissionTitle},&quot; per {$contextName}. La data di scadenza prevista è {$reviewDueDate}.<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nTi chiedo la cortesia di confermare al più presto la tua disponibilità a portare a termine l''incarico o meno.<br />\n<br />\n{$editorialContactSignature}', 'Questa email viene mandata da un section editor per ricordare al revisore che è attesa la revisione.'),
('REVIEW_REMIND_ONECLICK', 'ja_JP', '論文査読の督促', '{$reviewerName} 様:<br />\n<br />\n雑誌『{$contextName}』への投稿原稿「{$submissionTitle}」の査読は進んでいるでしょうか。査読期限日は、{$reviewDueDate}となっております。準備ができ次第できるだけ早く査読結果をいただきたいと考えております。<br />\n<br />\n雑誌のWebサイトにログインするユーザー名とパスワードをお持ちでない場合は、次のリンクを使ってパスワードをリセットしてください（パスワードはユーザー名と共にメールで送信されます）： {$passwordResetUrl}<br />\n<br />\n投稿物のURL: {$submissionReviewUrl}<br />\n<br />\n本誌の投稿物にとって極めて重要なこの貢献を貴殿が遂行できることを確認してください。お返事をお待ちしております。<br />\n<br />\nよろしくお願いいたします。<br />\n<br />\n{$editorialContactSignature}', 'このメールは、セクションエディタから査読者に査読期限日が過ぎたことを督促するものです。'),
('REVIEW_REMIND_ONECLICK', 'ku_IQ', 'بیرخەرەوەی هەڵسەنگاندنی توێژینەوە', '{$reviewerName}:<br />\n<br />\nبیرخەرەوەی هەڵسەنگاندنی توێژینەوەی &quot;{$submissionTitle},&quot; بۆ {$contextName}. کە ئێمە هیوادارین هەتا {$reviewDueDate} هەڵسەنگاندنەکە تەواو ببێت. سوپاسگوزار دەبین ئەگەر بە زوترین کات بتوانن ئەم کارە بکەن.<br />\n<br />\nلینکی توێژینەوەکە: {$submissionReviewUrl}<br />\n<br />\nتکایە دڵنیامان بکەوە لە ئەنجامدانی هەڵسەنگاندنەکە، ئێمە چاوەڕێی وەڵامی ئێوەین.<br />\n<br />\n{$editorialContactSignature}', 'ئەم ئیمەیڵە لە لایەن سەرنوسەری بەشەوە بۆ هەڵسەنگێنەر دەنێردرێت وەک بیرخەرەوەیەکی کاتی هەڵسەنگاندنەکە.'),
('REVIEW_REMIND_ONECLICK', 'mk_MK', 'Потсетник за поднесување на рецензија', '{$reviewerName}:<br />\n<br />\nМал потсетник за нашето барање за вашата рецензија на поднесокот, &quot;{$submissionTitle},&quot; за {$contextName}. Се надевавме дека ќе ја добиеме вашата рецензија до {$reviewDueDate}, и би биле задоволни да ја добиеме веднаш штом ќе можете да ја подготвите.<br />\n<br />\nURL-адреса на поднесокот: {$submissionReviewUrl}<br />\n<br />\nВе молам за потврда дека можете да го завршите овој неопходен придонес кон работата на ова списание. Со нетрпение очекувам да слушнам од вас.<br />\n<br />\n{$editorialContactSignature}', 'Овој и-меил е испратен од Секциски уредник како потсетник до рецензентот дека рокот за нивната рецензија е достигнат.'),
('REVIEW_REMIND_ONECLICK', 'nb_NO', 'Påminnelse om fagfellevurdering', '{$reviewerName}:<br />\n<br />\nJeg sender denne e-posten for å minne deg på at du har tatt på deg å vurdere innleveringen «{$submissionTitle}» for {$contextName}. Jeg minner om at fristen for oppdraget var satt til {$reviewDueDate}, og ser fram til å motta vurderingen din så snart den er klar.<br />\n<br />\nInnleveringens URL: {$submissionReviewUrl}<br />\n<br />\nKan du bekrefte om du vil fullføre dette vurderingsoppdraget for tidsskriftet vårt? Jeg ser fram til å høre fra deg.<br />\n<br />\n{$editorialContactSignature}', 'Denne e-posten sendes av en seksjonsredaktør til en fagfelle for å minne om at fagfellevurderingen ventes ferdigstilt innen tidsfristen.'),
('REVIEW_REMIND_ONECLICK', 'nl_NL', 'Herinnering review', '{$reviewerName}:<br />\n<br />\nWe willen u vriendelijk herinneren aan ons verzoek om de inzending &quot;{$submissionTitle}&quot; voor {$contextName} te reviewen. We verwachtten uw review op {$reviewDueDate}. We stellen het zeer op prijs om de review te ontvangen zodra u in de gelegenheid bent om die uit te voeren.<br />\n<br />\nURL inzending: {$submissionReviewUrl}<br />\n<br />\nWilt u uw beschikbaarheid voor het voltooien van deze voor het werk van het tijdschrift vitale taak bevestigen. Ik kijk uit naar uw reactie.<br />\n<br />\n{$editorialContactSignature}', 'Deze e-mail wordt door de sectieredacteur verstuurd om een reviewer eraan te herinneren dat de afgesproken reviewperiode verstreken is.'),
('REVIEW_REMIND_ONECLICK', 'pl_PL', 'Przypomnienie o terminie przygotowania recenzji', 'Szanowna Pani / Szanowny Panie,<br />\n<br />\nprzypominamy, że w dniu {$reviewDueDate} mija termin przygotowania recenzji artykułu &quot;"{$submissionTitle}"&quot; zgłoszonego do czasopisma {$contextName}. Prosimy o nadesłanie do tego czasu gotowej recenzji.<br />\n<br />\nWWW artykułu: {$submissionReviewUrl}<br />\n<br />\nBędziemy wdzięczni za potwierdzenie gotowości do wykonania recenzji.<br />\n<br />\nZ wyrazami szacunku,\n{$editorialContactSignature}', 'Wiadomość wysyłana przez redaktora prowadzącego do recenzenta celem przypomnienia o terminie wykonania recenzji. Wysyłane do recenzenta mającego trudności z obsługą OJS.'),
('REVIEW_REMIND_ONECLICK', 'pt_BR', 'Lembrete de solicitação de avaliação', '{$reviewerName}:<br />\n<br />\nEste é apenas um lembrete amigável do nosso pedido de avaliação da submissão, &quot;{$submissionTitle},&quot; ao periódico {$contextName}. Esperávamos ter recebido sua avaliação até {$reviewDueDate}, então gostaríamos de recebê-la assim que você conseguir prepará-la.<br />\n<br />\nURL da submissão: {$submissionReviewUrl}<br />\n<br />\nPor favor, confirme que poderá completar essa contribuição vital ao trabalho do periódico. Aguardo seu retorno.<br />\n<br />\n{$editorialContactSignature}', 'Mensagem enviada pelo Editor de Seção ao Avaliador como lembrete da tarefa de avaliação em andamento ainda não concluída.'),
('REVIEW_REMIND_ONECLICK', 'pt_PT', 'Lembrete de pedido de revisão', '{$reviewerName},<br />\n<br />\nEsta mensagem é apenas um lembrete relativamente ao pedido de revisão da submissão &quot;{$submissionTitle}&quot; a {$contextName}. Esperávamos receber a revisão até {$reviewDueDate}, e aguardamos a sua receção assim que for possível.<br />\n<br />\nURL da submissão: {$submissionReviewUrl}<br />\n<br />\nConfirme a sua disponibilidade para concluir esta tarefa e agradecemos o contributo para a qualidade desta revista. Aguardamos notícias suas!<br />\n<br />\n{$editorialContactSignature}', 'Este e-mail é enviado por um Editor de Secção para lembrar o revisor sobre o prazo de revisão.'),
('REVIEW_REMIND_ONECLICK', 'ro_RO', 'Memento de revizuire a trimiterii', '{$reviewerName}:<br />\n<br />\nVă reamintim că ați acceptat să revizuiți manuscrisul, &quot;{$submissionTitle},&quot; pentru {$contextName}. Sperăm să ne trimiteți această revizuire până la {$reviewDueDate}, și am fi încântați să o primim de îndată ce o finalizați.<br />\n<br />\nURL manuscris: {$submissionReviewUrl}<br />\n<br />\nToate cele bune.<br />\n<br />\n{$editorialContactSignature}', 'Acest e-mail este trimis de un editor de secțiune pentru a reaminti recenzorului că revizuirea sa se apropie de data limită.'),
('REVIEW_REMIND_ONECLICK', 'ru_RU', 'Напоминание о рецензии на материал', 'Здравствуйте, {$reviewerName}!<br />\n<br />\nЭто напоминание о нашем запросе Вашей рецензии на материал «{$submissionTitle}» для журнала «{$contextName}». Мы надеялись получить эту рецензию до {$reviewDueDate} и будем рады, если Вы как можно скорее ее подготовите.<br />\n<br />\nURL материала: {$submissionReviewUrl}<br />\n<br />\nПожалуйста, подтвердите, что Вы сможете сделать этот важный вклад в работу нашего журнала. Жду вашего ответа.<br />\n<br />\n{$editorialContactSignature}', 'Это письмо отправляется редактором раздела, чтобы напомнить рецензенту о том, что срок предоставления рецензии уже прошел.'),
('REVIEW_REMIND_ONECLICK', 'sk_SK', 'Pripomenutie recenzie príspevku', '{$reviewerName}:<br />\n<br />\nDovoľujeme si Vám opatrne pripomenúť našu žiadosť o spracovanie recenzie príspevku &quot;{$submissionTitle}&quot; pre {$contextName}. Dúfali sme, že budeme mať túto recenziu hotovú do {$reviewDueDate} a budeme radi, keď ju od Vás dostaneme hneď, ako ju budete môcť dokončiť.<br />\n<br />\nURL príspevku: {$submissionReviewUrl}<br />\n<br />\nPotvrďte prosím, či môžete dokončiť túto nevyhnutnú úlohu pre náš časopis. Teším sa, že sa ozvete.<br />\n<br />\n{$editorialContactSignature}', 'Tento email posiela editor sekcie recenzentovi, aby mu pripomenul, že vypršal termín pre spracovanie recenzie.'),
('REVIEW_REMIND_ONECLICK', 'sl_SI', 'Opomnik za recenzijo prispevka', '{$reviewerName}:<br />\n<br />\nSamo prijazen opomnik za našo prošnjo za recenzijo prispevka, &quot;{$submissionTitle},&quot; za revijo {$contextName}. Upali smo, da boste opravili recenzijo do predvidenega datuma {$reviewDueDate}. Z veseljem jo bomo sprejeli takoj, ko jo pripravite.<br />\n<br />\nURL povezava do prispevka: {$submissionReviewUrl}<br />\n<br />\nProsim, če potrdite vašo pripravljenost za dokončanje vašega pomembnega prispevka za delo revije. Veselimo se vašega odgovora.<br />\n<br />\n{$editorialContactSignature}', 'Ta email pošlje urednik rubrike recenzentu kot opomnik za opravljanje recenzije.'),
('REVIEW_REMIND_ONECLICK', 'sv_SE', 'Påminnelse om granskning av bidrag', '{$reviewerName}:<br />\n<br />\nDet här är bara en påminnelse om vår förfrågan om din granskning av bidraget &quot;{$submissionTitle}&quot; för {$contextName}. Vi hade hoppats på att få din granskning senast {$reviewDueDate} och skulle vara tacksamma om du ville inkomma med den så fort som möjligt.<br />\n<br />\nBidragets URL: {$submissionReviewUrl}<br />\n<br />\nVänligen bekräfta snarast om du har möjlighet att genomföra granskningsuppdraget, som utgör en viktig del av tidskriftens arbete. Vi ser fram emot att höra från dig.<br />\n<br />\n{$editorialContactSignature}', 'Det här e-postmeddelandet skickas från en sektionsredaktör som en påminnelse till granskaren att deadline för granskningen har passerat.'),
('REVIEW_REMIND_ONECLICK', 'tr_TR', 'Değerlendirilme Konusunda Hatırlatma', 'Sayın {$reviewerName},<br />\n<br />\n{$contextName} adlı dergide yayınlanması için değerlendirilmek üzere gönderilen &quot;{$submissionTitle}&quot; başlıklı çalışmanın değerlendirmesini {$reviewDueDate} tarihinden önce tamamlayacağınızı ümit ediyoruz. Yoğun işleriniz arasında değerlendirme raporunuzu tamamlayıp, bize bir an önce ileteceğiniz inancı ile dergimiz sitesindeki ulaşım bilgilerini size iletmeyi istedik.<br />\n<br />\nMakale Erişim Adresi: {$submissionReviewUrl}<br />\n<br />\nDerginin kalitesini arttıracak bu önemli katkıyı yapabileceğinizi lütfen onaylayınız.<br />\n<br />\n{$editorialContactSignature}', 'Bu elektronik posta hakemler için tek tıklama özelliği açık ise, gözden geçirmeyi yapan kişiye işlemin zamanının dolmakta olduğunu hatırlatmak için Bölüm Editörü tarafından gönderilir.'),
('REVIEW_REMIND_ONECLICK', 'uk_UA', 'Нагадування про рецензування', '{$reviewerName}:<br />\n<br />\nХотів б нагадати Вам про рецензування подання, &quot;{$submissionTitle},&quot; для видання {$contextName}. Ми очікували отримати цю рецензію до {$reviewDueDate}. Будь ласка, надішліть нам її якомога скоріше.<br />\n<br />\nURL подання: {$submissionReviewUrl}<br />\n<br />\nБудь ласка, підтвердіть можливість завершити цю важливу для нашого журналу роботу. З нетерпінням очікую Вашої відповіді.<br />\n<br />\n{$editorialContactSignature}', 'Цим листом редактор розділу нагадує рецензенту про настання кінцевої дати рецензування.'),
('REVIEW_REMIND_ONECLICK', 'vi_VN', 'Nhắc nhở nộp đánh giá', 'Kính gửi {$reviewerName},<br />\n<br />\nĐây là nhắc nhở về yêu cầu của chúng tôi để bạn xem xét bài gửi, &quot;{$submissionTitle},&quot; cho {$contextName}. Chúng tôi hy vọng sẽ có đánh giá này vào ngày {$reviewDueDate}, và sẽ rất vui khi nhận được nó ngay khi bạn có thể gửi nó.<br />\n<br />\nURL bài gửi: {$submissionReviewUrl}<br />\n<br />\nVui lòng xác nhận khả năng hoàn thành quy trình quan trọng này cho công việc của tạp chí. Chúng tôi mong nhận được phản hồi của bạn.<br />\n<br />\n{$editorialContactSignature}', 'Email này được gửi bởi một Biên tập viên chuyên mục để nhắc nhở người phản biên rằng rằng đánh giá của họ tới hạn nộp.'),
('REVIEW_REMIND_ONECLICK', 'zh_CN', '稿件审查提醒函', '{$reviewerName}:<br />\n<br />\n这封信只是礼貌地提醒您，我们已邀请您为《{$contextName}》审查稿件〈{$submissionTitle}〉。我们希望您<br />\n能在 {$reviewDueDate}前完成这份审查工作，并请您在备妥审查意见书之后尽快寄给我们。<br />\n<br />\n稿件网址：{$submissionReviewUrl}<br />\n<br />\n请确认您能够完成这个对本期刊作品而言非常重要的贡献。我们期盼听到您的回复。<br />\n<br />\n{$editorialContactSignature}', '这封电子邮件是由区段编辑发出，提醒一位审查人他们的审查工作已经到期。'),
('REVIEW_REQUEST', 'ar_IQ', 'إلتماس تحكيم مؤلَّف', '{$reviewerName}:<br />\n<br />\nكلي ثقة بأنك ستكون محكماً متميزاً للمؤلَّف الموسوم &quot;{$submissionTitle},&quot; والذي أُرسل طلب لنشره إلى {$contextName}. إن ملخص موضوعه مبين أدناه، وأنا أرجو أنك ستأخذ على عاتقك إنجاز هذه المهمة لمجلتنا.<br />\n<br />\nلطفاً، أدخل إلى موقع المجلة حتى يوم {$responseDueDate} لتبين لنا فيما لو أنك موافق على هذا التحكيم أم لا، كما يمكنك أيضاً عبر الرابط أدناه الوصول إلى متعلقات طلب النشر المذكور، وتثبيت تقييمك له وملاحظاتك بشأنه. الرابط هو: {$contextUrl}<br />\n<br />\nأما التحكيم نفسه، فإن موعده النهائي سيكون: {$reviewDueDate}.<br />\n<br />\nإن لم يكن اسم الدخول وكلمة المرور متوفرين بين يديك لتتمكن من الولوج إلى موقع المجلة، بإمكانك اتباع الرابط أدناه لإعادة تعيين كلمة مرورك (التي عندها ستُرسل إليك مع اسم الدخول) عبر البريد الالكتروني. {$passwordResetUrl}<br />\n<br />\nرابط الطلب: {$submissionReviewUrl}<br />\n<br />\nنشكر لك اهتمامك بالتماسنا هذا.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'هذه الرسالة يرسلها محرر قسم المجلة إلى أحد المحكمين ليلتمس منه قبول مهمة التحكيم أو رفضها. وهي توفر معلومات متعلقة بطلب النشر من عنوانه وملخصه، فضلاً عن موعد استيجاب التحكيم ورابط الدخول إلى الموقع للاطلاع على الطلب نفسه. هذه الرسالة تستعمل عندما يكون التحكيم في المجلة متبعاً لعملية التحكيم القياسية وذلك عبر تفعيله ضمن (خيارات التحكيم في: الإعدادات، المخطط الانسيابي، التحكيم). (بخلاف ذلك أنظر. REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'bs_BA', 'Zamolba za recenziju članka', 'Poštovana/i {$reviewerName},<br />\n<br />\ns obzirom na vaše iskustvo i područje ekspertize, rado bismo vam povjerili zadatak recenzije članka &quot;{$submissionTitle}&quot; prijavljenog u naš časopis {$contextName}. Sažetak članka nalazi se u nastavku ove poruke. Nadamo se da ćete prihvatiti našu ponudu te izvršiti ovu, za nas iznimno važnu, zadaću.<br />\n<br />\nMolimo vas da se kao korisnik prijavite na mrežnu stranicu časopisa do {$responseDueDate} kako biste naznačili hoćete li preuzeti recenziju ili ne. Potom, ukoliko prihvatite izradu recenzije, na istome mjestu možete pristupiti tekstu članka te zabilježili vašu recenziju i preporuku. Mrežna stranica časopisa je {$contextUrl}<br />\n<br />\nU slučaju da nemate pri ruci svoje korisničko ime ili lozinku za mrežnu stranicu časopisa, možete se koristiti ovom poveznicom kako biste promijenili lozinku (koju ćemo vam tada, zajedno s korisničkim imenom, poslati putem e-pošte). {$passwordResetUrl}<br />\n<br />\nSama recenzija trebala bi biti završena zaključno s {$reviewDueDate}.<br />\n<br />\nURL članka: {$submissionReviewUrl}<br />\n<br />\nSrdačno,<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Ovim obrascem e-pošte urednik rubrike šalje upit recenzentu može li prihvatiti zadatak recenziranja članka. Zamolba sadrži osnovne informacije u vidu naslova i kratkog sadržaja članka, datum do kojeg bi recenzija trebala biti napisana te načina na koji se recenzent može prijaviti u sustav. Ova poruka se koristi kada je odabran standardni recenzijski postupak u 2. koraku Postavljanja časopisa (Ako nije, koristi se Zamolba za recenziju članka u privitku)'),
('REVIEW_REQUEST', 'ca_ES', 'Sol·licitud de revisió d''un article', '{$reviewerName}:<br />\n<br />\nConsidero que el vostre perfil és adequat per revisar el manuscrit, &quot;{$submissionTitle},&quot; enviat a la revista {$contextName}. A continuació trobareu un resum de la tramesa, confio que acceptareu encarregar-vos d''aquesta tasca tan important per a nosaltres.<br />\n<br />\nUs demano que inicieu la sessió a la revista abans del {$responseDueDate} per indicar-nos si accepteu o no encarregar-vos de la revisió de la tramesa i, en cas d''acceptar-la, per accedir-hi i enregistrar-ne la revisió i la recomanació. El lloc web de la revista és {$contextUrl}<br />\n<br />\nLa data límit per fer la revisió és el {$reviewDueDate}.<br />\n<br />\nSi no recordeu el vostre nom d''usuari/ària o la contrasenya per al lloc web de la revista, podeu utilitzar l''enllaç següent per restablir la contrasenya (la rebreu per correu electrònic juntament amb el vostre nom d''usuari/ària).  {$passwordResetUrl}<br />\n<br />\nURL de la tramesa: {$submissionReviewUrl}<br />\n<br />\nGràcies per tenir en compte aquesta sol·licitud.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Aquest missatge de correu electrònic de l''editor de secció s''adreça a un revisor/a per sol·licitar-li que accepti o rebutgi la tasca de revisió d''una tramesa. El correu dona informació sobre la tramesa, com el títol i el resum, la data límit per fer la revisió i com accedir-hi. Aquest missatge s''utilitza quan s''ha seleccionat el procés de revisió estàndard a Gestió > Configuració > Flux de treball > Revisió. (Si no consulteu REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'cs_CZ', 'Žádost o zpracování recenze článku', '{$reviewerName}:<br />\n<br />\nDomnívám se, že byste mohl být výborným recenzentem příspěvku &quot;{$submissionTitle},&quot; který byl zaslán do {$contextName}. Abstrakt příspěvku je vložen níže. Věřím, že zvážíte možnost přijetí tohoto pro nás důležitého úkolu.<br />\n<br />\nProsím, přihlaste se do {$responseDueDate} na stránkách časopisu, abyste uvedl, zda recenzi zpracujete nebo ne a také pro přístup k příspěvku a zaznamenání Vaší recenze a doporučení. Adresa webové stránky je {$contextUrl}<br />\n<br />\nTermín pro zpracování recenze je {$reviewDueDate}.<br />\n<br />\nPokud nemáte své uživatelské jméno a heslo pro webovou stránku časopisu, můžete použít tento odkaz pro resetování Vašeho hesla (které Vám bude zasláno emailem spolu s Vaším uživatelským jménem). {$passwordResetUrl}<br />\n<br />\nURL příspěvku: {$submissionReviewUrl}<br />\n<br />\nDěkujeme za zvážení této žádosti.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Tento email od editora sekce pro recenzenta žádá, aby recenzent přijal nebo odmítl úkol zpracovat recenzi příspěvku. Obsahuje informace o příspěvku, jako je název a abstrakt, termín pro zpracování recenze a jak se dostat k samotnému příspěvku. Tato zpráva je používána, pokud je zvoleno Standardní recenzí řízení ve druhém kroku  Nastavení časopisu. (V jiném případě viz REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'da_DK', 'Forespørgsel om bedømmelse af artikel', '{$reviewerName}:<br />\n<br />\nJeg tror, at du vil være en fremragende bedømmer af manuskriptet &quot;{$submissionTitle}&quot;, der er blevet sendt til {$contextName}. Nedenfor finder du et resumé af manuskriptet, og jeg håber, at du vil overveje at påtage dig denne vigtige opgave for os.<br />\n<br />\nLog på tidsskriftets websted inden den {$responseDueDate} for at angive, om du vil påtage dig bedømmelsen eller ej, samt for at få adgang til manuskriptet og registrere din bedømmelse og anbefaling. Webstedet er {$contextUrl}<br />\n<br />\nSelve bedømmelsen skal afleveres senest den {$reviewDueDate}.<br />\n<br />\nHvis du ikke har dit brugernavn og din adgangskode til tidsskriftets websted, kan du bruge dette link til at nulstille adgangskoden (som så vil blive sendt til dig via e-mail sammen med dit brugernavn). {$passwordResetUrl}<br />\n<br />\nManuskriptets URL-adresse: {$submissionReviewUrl}<br />\n<br />\nTak for din overvejelse af denne forespørgsel.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n {$submissionAbstract}', 'Denne e-mail fra sektionsredaktøren til en bedømmer anmoder bedømmeren om at acceptere eller afvise at bedømme et manuskript. Den indeholder oplysninger om manuskriptet, f.eks. titel og resumé, forfaldsdato for bedømmelse, samt hvordan der kan oprettes adgang til selve manuskriptet. Denne meddelelse benyttes, hvis indstillingen Standardbedømmelsesproces er valgt under Konfiguration af tidsskrift, trin 2. (Se ellers REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'de_DE', 'Bitte um ein Gutachten', '{$reviewerName},<br />\n<br />\naufgrund Ihrer Forschungsschwerpunkte wären Sie ein/e ausgezeichnete/r Gutachter/in für das Manuskript &quot;{$submissionTitle}&quot;, das zur Publikation in {$contextName} eingereicht worden ist. Weiter unten finden Sie eine Kurzfassung des Beitrags. Ich hoffe sehr, dass Sie sich bereitfinden können, uns mit Ihrer Stellungnahme zu unterstützen. Sie wären uns eine große Hilfe.<br />\n<br />\nLoggen Sie sich bitte bis zum {$responseDueDate} auf der Webseite unserer Zeitschrift ein, um uns Ihre Zu- oder Absage mitzuteilen. Sie finden dort den Beitrag und können gegebenenfalls auch Ihr Gutachten und Ihre Empfehlung dort abgeben. Die Webseite ist {$contextUrl}.<br />\n<br />\nDas Gutachten wäre fällig am {$reviewDueDate}.<br />\n<br />\nFalls Sie nicht über Benutzer/innennamen und Passwort verfügen, können Sie über folgenden Link Ihr Passwort neu setzen (Benutzer/innennamen und Passwort gehen Ihnen umgehend per E-Mail zu). {$passwordResetUrl}<br />\n<br />\nURL des Beitrags: {$submissionReviewUrl}<br />\n<br />\nIn der Hoffnung auf eine positive Antwort,<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Diese E-Mail von der/dem Rubrikredakteur/in an eine/n Gutachter/in bittet darum, dass diese/r die Aufgabe, eine Einreichung zu begutachten, übernimmt oder ablehnt. Sie liefert Informationen über die Einreichung wie Titel und Abstract, ein Fälligkeitsdatum für das Gutachten und darüber, wie auf die Einreichung zugegriffen werden kann. Diese Nachricht wird benutzt, wenn in Schritt 2 des Zeitschriftensetups das Standardbegutachtungsverfahren ausgewählt worden ist. (Ansonsten siehe REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'el_GR', 'Αίτημα αξιολόγησης άρθρου', '{$reviewerName}:<br />\n<br />\nΠιστεύουμε ότι θα αποτελέσετε έξοχο Αξιολογητή της εργασίας &quot;{$submissionTitle},&quot; που έχει υποβληθεί στο περιοδικό {$contextName}. Η περίληψη της υποβολής παρατίθεται παρακάτω. Ελπίζουμε ότι θα αναλάβετε αυτό το σημαντικό έργο για εμάς.<br />\n<br />\nΘα σας παρακαλούσαμε να συνδεθείτε στον ιστότοπο του περιοδικού μέχρι τις {$responseDueDate} για να δηλώσετε εάν θα αναλάβετε την αξιολόγηση, να αποκτήσετε πρόσβαση στην υποβολή και να καταχωρήσετε τα σχόλιά σας. Ο ιστότοπος του περιοδικού είναι {$contextUrl}<br />\n<br />\nΗ προθεσμία υποβολής της αξιολόγησης λήγει στις {$reviewDueDate}.<br />\n<br />\nΕάν δεν έχετε το όνομα Χρήστη τον κωδικό πρόσβασης στον ιστότοπο του περιοδικού, μπορείτε να χρησιμοποιήσετε τον σύνδεσμο {$passwordResetUrl} για να επαναφέρετε τον κωδικό πρόσβασής σας (ο οποίος θα σας αποσταλεί με ηλεκτρονικό μήνυμα, μαζί με το όνομα Χρήστη). <br />\n<br />\nΣύνδεσμος υποβολής: {$submissionReviewUrl}<br />\n<br />\nΣας ευχαριστούμε εκ των προτέρων για την εξέταση του αιτήματός μας.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Το παρόν αίτημα αξιολόγησης μιας υποβολής αποστέλλεται από τον Επιμελητή Ενότητας σε έναν Αξιολογητή. Παρέχει πληροφορίες σχετικά με την υποβολή όπως ο τίτλος, η περίληψη, η προθεσμία της αξιολόγησης και ο τρόπος πρόσβασης στην υποβολή. Το συγκεκριμένο μήνυμα χρησιμοποιείται όταν η "Τυπική Διαδικασία Αξιολόγησης" έχει επιλεχθεί στη Διαχείριση > Ρυθμίσεις > Ροή εργασιών > Αξιολόγηση. (Σε διαφορετική περίπτωση ανατρέξτε στο REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'en_US', 'Article Review Request', '{$reviewerName}:<br />\n<br />\nI believe that you would serve as an excellent reviewer of the manuscript, &quot;{$submissionTitle},&quot; which has been submitted to {$contextName}. The submission''s abstract is inserted below, and I hope that you will consider undertaking this important task for us.<br />\n<br />\nPlease log into the journal web site by {$responseDueDate} to indicate whether you will undertake the review or not, as well as to access the submission and to record your review and recommendation. The web site is {$contextUrl}<br />\n<br />\nThe review itself is due {$reviewDueDate}.<br />\n<br />\nIf you do not have your username and password for the journal''s web site, you can use this link to reset your password (which will then be emailed to you along with your username). {$passwordResetUrl}<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nThank you for considering this request.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'This email from the Section Editor to a Reviewer requests that the reviewer accept or decline the task of reviewing a submission. It provides information about the submission such as the title and abstract, a review due date, and how to access the submission itself. This message is used when the Standard Review Process is selected in Management > Settings > Workflow > Review. (Otherwise see REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'es_ES', 'Solicitud de revisión de artículo', '{$reviewerName}:<br />\n<br />\nTengo el convencimiento de que sería un excelente revisor/a del manuscrito, &quot;{$submissionTitle},&quot; que ha sido enviado a {$contextName}. A continuación encontrará el resumen del envío, con la esperanza de que aceptará llevar a cabo esta importante tarea para nosotros.<br />\n<br />\nPor favor, inicie sesión en la página web de la revista antes del {$responseDueDate} para indicarnos si llevará a cabo o no la revisión, así como para tener acceso al envío y para registrar su revisión y recomendación. La dirección es {$contextUrl}<br />\n<br />\nLa revisión propiamente dicha debería estar lista el {$reviewDueDate}.<br />\n<br />\nSi no recuerda su nombre de usuaria/o y contraseña, puede utilizar este enlace para restablecer su contraseña (esta le será enviada por correo electrónico junto con su nombre de usuario/a). {$passwordResetUrl}<br />\n<br />\nURL del envío: {$submissionReviewUrl}<br />\n<br />\nGracias por considerar nuestra solicitud.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Este correo electrónico del editor/a de sección se dirige a un revisor/a para solicitarle que acepte o rechace la tarea de revisión de un envío. El correo proporciona información sobre el envío, como el título y el resumen, el plazo de revisión y cómo acceder al envío propiamente dicho. Este mensaje se usa cuando se selecciona el proceso de revisión estándar en Gestión > Ajustes > Flujo de trabajo > Revisión. (Si no consulte REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'eu_ES', 'Artikulua ebaluatzeko eskaera', '{$reviewerName}:<br />\n<br />\nUste dut ebaluatzaile bikaina izango zinatekeela {$contextName} aldizkarira bidali diguten {$submissionTitle} eskuizkribuari buruzko iritzia emateko. Artikuluaren laburpena behean duzu, eta espero dut aintzakotzat hartu eta pentsatuko duzula guretzat lan garrantzitsu hau egiteko eskaera.<br />\n<br />\nMesedez, sar zaitez aldizkariaren webgunean {$responseDueDate} aurretik, eta esaguzu ebaluazioa egiteko prest zauden ala ez, eta prest egonez gero, artikulua hartzeko eta zure ebaluazio-txostena eta gomendioa emateko. Webgunea {$contextUrl} da<br />\n<br />\nEbaluazioa egiteko epea {$reviewDueDate} izango litzateke.<br />\n<br />\nEz badaukazu aldizkariaren webgunean sartzeko erabiltzaile-izenik eta pasahitzik, behean ematen den esteka erabil dezakezu pasahitza berrezartzeko (erabiltzaile-izenarekin batera bidaliko dizugu). {$passwordResetUrl}<br />\n<br />\nArtikuluaren URLa: {$submissionReviewUrl}<br />\n<br />\nEskerrik asko gure eskaera kontuan hartzeagatik.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Mezu hau Ataleko editoreak bidaltzen dio Ebaluatzaile bati, artikulu bat ebaluatzea onartuko duen ala ez galdetzeko. Artikuluari buruzko informazioa ematen du, hala nola titulua eta laburpena, ebaluazioa egiteko epea eta artikulua bera hartzeko zer egin behar den. Mezu hau erabiltzen da aldizkariaren Konfigurazioko 2. urratsean Ebaluazio-prozesu estandarra hautatzen denean. (Bestela, ikus REVIEW_REQUEST_ATTACHED).'),
('REVIEW_REQUEST', 'fa_IR', 'درخواست کارشناسی مقاله', '{$reviewerName}:<br />\n<br />\nشما به عنوان یک کارشناس ممتاز برای بررسی مقاله &quot;{$submissionTitle}&quot;که برای {$contextName} ارسال شده است انتخاب شده اید. در ذیل، چکیده مقاله ارسالی برای شما گنجانده شده است و امیدوارم که در این زمینه مایل به همکاری با این مجله باشید<br />\n<br />\nلطفا قبل از تاریخ &quot;{$responseDueDate}&quot; وارد وب سایت مجله شده و مشخص کنید که آیا مایل به قبول کارشناسی مقاله هستید یا خیر. همچنین به طور همزمان می توانید به مقاله ارسالی دسترسی پیدا کرده و متن کارشناسی و توصیه های خودرا ذخیره کنید. آدرس وب سایت مجله <a href="{$contextUrl}">{$contextUrl}</a> است.<br />\n<br />\nضمنا آخرین مهلت بررسی این مقاله تا تاریخ &quot;{$reviewDueDate}&quot; می باشد<br />\n<br />\nچنانچه نام کاربری و رمز عبور خود مربوط به وب سایت این مجله را در دسترس ندارید می توانید از پیوند زیر جهت تنظیم دوباره رمزعبور خود استفاده کنید (که به همراه نام کاربری برایتان ارسال می گردد).<br />\n<br />\n<a href="{$passwordResetUrl}">{$passwordResetUrl}</a><br />\nآدرس مقاله : <a href="{$submissionReviewUrl}">{$submissionReviewUrl}</a><br />\n<br />\nاز توجه شما به این درخواست سپاسگزاری می کنم.<br />\n<br />\n{$editorialContactSignature}', 'This email from the Section Editor to a Reviewer requests that the reviewer accept or decline the task of reviewing a submission. It provides information about the submission such as the title and abstract, a review due date, and how to access the submission itself. This message is used when the Standard Review Process is selected in Journal Setup, Step 2. (Otherwise see REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'fi_FI', 'Artikkelin arviointipyyntö', 'Hyvä {$reviewerName},<br />\n<br />\nUskon, että olisitte sopiva arvioija käsikirjoitukselle &quot;{$submissionTitle}&quot;, joka on lähetetty {$contextName} -julkaisuun. Käsikirjoituksen tiivistelmä löytyy tämän viestin lopusta. Toivon, että harkitsette tähän meille tärkeään tehtävään ryhtymistä.<br />\n<br />\nKirjautukaa julkaisun verkkosivustolle {$responseDueDate} mennessä ilmoittaaksenne haluatteko suorittaa arvioinnin vai ette. Teidän on kirjauduttava verkkosivustolle myös, jotta saatte pääsyn käsikirjoitukseen ja voitte tallentaa arviointinne ja suosituksenne. Sivusto on osoitteessa {$contextUrl}<br />\n<br />\nArvioinnin määräpäivä on {$reviewDueDate}.<br />\n<br />\nJos ette muista käyttäjätunnustanne ja salasanaanne julkaisun verkkosivustolle, klikatkaa seuraavaa linkkiä vaihtaaksenne salasanan (salasana ja käyttäjätunnus lähetetään teille sähköpostitse). {$passwordResetUrl}<br />\n<br />\nKäsikirjoituksen URL: {$submissionReviewUrl}<br />\n<br />\nKiitos, että harkitsette arvioijaksi ryhtymistä.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'This email from the Section Editor to a Reviewer requests that the reviewer accept or decline the task of reviewing a submission. It provides information about the submission such as the title and abstract, a review due date, and how to access the submission itself. This message is used when the Standard Review Process is selected in Management > Settings > Workflow > Review. (Otherwise see REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'fr_CA', 'Demande d''évaluation d''un article', '{$reviewerName},<br />\n<br />\nNous croyons que vous feriez un-e excellent-e évaluateur-trice pour le manuscrit intitulé « {$submissionTitle} » qui a été soumis à la revue {$contextName}. Vous trouverez un résumé de la soumission ci-dessous. Nous espérons que vous accepterez ce travail essentiel à la publication de la revue.<br />\n<br />\nVeuillez accéder au site Web de la revue avant le {$responseDueDate} pour nous laisser savoir si vous acceptez de faire l''évaluation ou non. Vous pouvez également y consulter la soumission et y enregistrer votre évaluation et votre recommandation. Le site Web se trouve à l''adresse suivante : {$contextUrl}<br />\n<br />\nLa date d''échéance de l''évaluation a été fixée au {$reviewDueDate}.<br />\n<br />\nSi vous n''avez pas de nom d''utilisateur-trice et de mot de passe pour le site Web de la revue, cliquez sur le lien ci-dessous pour réinitialiser votre mot de passe (lequel vous sera envoyé par courriel avec votre nom d''utilisateur-trice). {$passwordResetUrl}<br />\n<br />\nURL de la soumission : {$submissionReviewUrl}<br />\n<br />\nNous vous remercions de l''attention que vous porterez à notre demande.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n« {$submissionTitle} »<br />\n<br />\n{$submissionAbstract}', 'Ce courriel du,de la rédacteur-trice à un,une évaluateur-trice demande que l''évaluateur-trice accepte ou refuse la tâche d''évaluation d''une soumission. Il fournit de l''information sur la soumission, tel son titre et un résumé, la date d''échéance pour l''évaluation, et comment accéder à la soumission. Ce message est utilisé quand « Processus d''évaluation standard » est sélectionné dans Configuration de la revue > Paramètres > Flux des travaux > Évaluation. (Autrement voir « Demande d''évaluation d''un article (en pièce jointe) ».)'),
('REVIEW_REQUEST', 'fr_FR', 'Demande d''évaluation d''un article', '{$reviewerName}:<br />\n<br />\nNous croyons que vous seriez un excellent rapporteur pour le manuscrit intitulé « {$submissionTitle} » qui a été soumis à la revue {$contextName}. Vous trouverez un résumé de la soumission ci-dessous.  Nous espérons que vous accepterez ce travail essentiel à la publication de la revue.<br />\n<br />\nVeuillez accéder au site Web de la revue avant le {$responseDueDate} pour nous laisser savoir si vous acceptez de faire l''évaluation ou non. Vous pouvez également y consulter la soumission et y enregistrer votre évaluation et votre recommandation. Le site Web se trouve à l''adresse suivante : {$contextUrl}<br />\n<br />\nLa date d''échéance de l''évaluation a été fixée au {$reviewDueDate}.<br />\n<br />\nSi vous n''avez pas de nom d''utilisateur et de mot de passe pour le site Web de la revue, cliquer sur le lien ci-dessous pour réinitialiser votre mot de passe (qui vous sera envoyé par courriel avec votre nom d''utilisateur). {$passwordResetUrl}<br />\n<br />\nURL de la soumission : {$submissionReviewUrl}<br />\n<br />\nEn espérant que vous accepterez notre demande, veuillez agréer l''expression de notre considération distinguée.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n« {$submissionTitle} »<br />\n<br />\n{$submissionAbstract}', 'Ce courriel du Rédacteur de rubrique à un Rapporteur demande que le rapporteur accepte ou refuse la tâche d''évaluation d''une soumission. Il fournit de l''information sur la soumission, tel son titre et un résumé, la date d''échéance pour l''évaluation, et comment accéder à la soumission elle-même. Ce message est utilisé quand « Processus d''évaluation standard » est sélectionné à l''Étape 2, dans la Configuration de la revue. (Autrement voir « Demande d''évaluation d''un article en pièce jointe »).'),
('REVIEW_REQUEST', 'gd_GB', 'Iarrtas airson lèirmheas artaigil', '{$reviewerName}:<br />\n<br />\nTha mi a’ creidsinn gum biodh tu fìor mhath mar lèirmheasaiche airson na sgrìobhainn “{$submissionTitle}” a chaidh a chur gu {$contextName}. Tha geàrr-chunntas an tagraidh gu h-ìosal agus bhiomaid fada nad chomain nam b’ urrainn dhut an obair chudromach seo a dhèanamh dhuinn.<br />\n<br />\nClàraich a-steach gu làrach-lìn an iris-leabhair ron {$responseDueDate} a dh’innse an dèan thu an lèirmheas seo gus nach dèan agus a dh’fhaighinn cothrom air an tagradh agus a chlàradh do lèirmheis is do mholaidhean. ’S e {$contextUrl} an làrach-lìn<br />\n<br />\nBidh an lèirmheas fhèin ri lìbhrigeadh {$reviewDueDate}.<br />\n<br />\nMur eil am facal-faire is ainm-cleachdaiche agad airson làrach-lìn an iris-leabhair, ’s urrainn dhut am facal-faire agad ath-shuidheachadh leis a’ cheangal seo agus thèid a chur thugad air a’ phost-d an uairsin còmhla ris an ainm-chleachdaiche agad. {$passwordResetUrl}<br />\n<br />\nURL an tagraidh: {$submissionReviewUrl}<br />\n<br />\nMòran taing airson an t-iarrtas seo a thoirt fa-near.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n“{$submissionTitle}”<br />\n<br />\n{$submissionAbstract}', 'Tha am post-d seo dheasaiche earrainn gu lèirmheasaiche a’ faighneachd an gabh iad ri lèirmheas air tagradh no an diùlt iad e. Tha e a’ toirt seachad fiosrachadh mun tagradh, mar an tiotal is geàrr-chunntas, ceann-là lìbhrigeadh an lèirmheis agus mar a gheibhear greim air an tagradh e fhèin. Seo an teachdaireachd a thèid a chleachdadh nuair a thaghar am pròiseas lèirmheis stannardach fo “Stiùireadh” > “Roghainnean” > “Sruth-obrach” > “Lèirmheas”. (Air neo faic REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'he_IL', 'בקשה לביקורת מאמר', '{reviewerName}:<br$ />\n<br />\nאתה תהיה סוקר מצוין של כתב היד {submissionTitle$} שהוגש לכתב עת {contextName$}. תקציר ההגשה מוכנס למטה, ואני מקווה שתשקול לבצע את המשימה החשובה הזו עבורנו.<br />\n<br />\nאנא היכנס לאתר כתב העת עד {responseDueDate$} לציין אם תבצע את הביקורת או לא, וכן לגשת למאמר ולרשום את הביקורת וההמלצה שלך. האתר הוא {contextUrl$}.<br />\n<br />\nהביקורת עצמו ניתן להגשה עד {reviewDueDate$}.<br />\n<br />\nאם אין ברשותך שם משתמש וסיסמה לאתר, ניתן לאפס את סיסמתך (שיישלח אליך ביחד עם שם משתמש שלך). {passwordResetUrl$}.<br />\n<br />\nאתר הגשה: {submissionReviewUrl$}<br />\n<br />\nתודה ששקלת את הבקשה הזו.<br />\n<br />\n"{submissionTitle$}"<br />\n<br />\n{submissionAbstract$}', 'הודעת דוא"ל זו מעורך המדור לבודק מבקשת שהמבקר יקבל או ידחה את משימת בדיקת ההגשה. הוא מספק מידע על ההגשה כמו הכותרת והתקציר, תאריך יעד לבדיקה וכיצד לגשת להגשה עצמה. הודעה זו משמשת כאשר נבחר תהליך הבדיקה הרגיל בניהול> הגדרות> זרימת עבודה> סקירה. (אחרת ראה REVIEW_REQUEST_ATTACHED.)');
INSERT INTO `email_templates_default_data` VALUES
('REVIEW_REQUEST', 'hi_IN', 'लेख समीक्षा का अनुरोध', '{$reviewerName}:<br />\n<br />\nमुझे विश्वास है कि आप पांडुलिपि के एक उत्कृष्ट समीक्षक के रूप में काम करेंगे, &quot;{$submissionTitle},&quot; जिसे {$contextName}को सबमिट किया गया है। सबमिशन का सार नीचे दिया गया है, और मुझे आशा है कि आप हमारे लिए इस महत्वपूर्ण कार्य को करने पर विचार करेंगे.<br />\n<br />\nकृपया जर्नल वेब साइट पर लॉग इन करें {$responseDueDate} यह इंगित करने के लिए कि क्या आप समीक्षा करेंगे या नहीं, साथ ही सबमिशन तक पहुँचने के लिए और अपनी समीक्षा और अनुशंसा दर्ज करने के लिए। वेब साइट है {$contextUrl}<br />\n<br />\nThe review itself is due {$reviewDueDate}.<br />\n<br />\nयदि आपके पास जर्नल की वेब साइट के लिए आपका उपयोगकर्ता नाम और पासवर्ड नहीं है, तो आप अपना पासवर्ड रीसेट करने के लिए इस लिंक का उपयोग कर सकते हैं (जो तब आपके उपयोगकर्ता नाम के साथ आपको ईमेल किया जाएगा). {$passwordResetUrl}<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nइस अनुरोध पर विचार करने के लिए धन्यवाद.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'अनुभाग संपादक से लेकर समीक्षक तक का यह ईमेल अनुरोध करता है कि समीक्षक किसी सबमिशन की समीक्षा करने के कार्य को स्वीकार या अस्वीकार करता है। यह प्रस्तुत करने के बारे में जानकारी प्रदान करता है जैसे शीर्षक और सार, समीक्षा की नियत तारीख, और प्रस्तुत करने के लिए कैसे उपयोग करें। इस संदेश का उपयोग तब किया जाता है जब प्रबंधन> सेटिंग्स> वर्कफ़्लो> समीक्षा में मानक समीक्षा प्रक्रिया का चयन किया जाता है. (Otherwise see REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'hr_HR', 'Zamolba za recenziju članka', 'Poštovana/i {$reviewerName},<br />\n<br />\ns obzirom na vaše iskustvo i područje ekspertize, rado bismo vam povjerili zadatak recenzije članka &quot;{$submissionTitle}&quot; prijavljenog u naš časopis {$contextName}. Sažetak članka nalazi se u nastavku ove poruke. Nadamo se da ćete prihvatiti našu ponudu te izvršiti ovu, za nas iznimno važnu, zadaću.<br />\n<br />\nMolimo vas da se kao korisnik prijavite na mrežnu stranicu časopisa do {$responseDueDate} kako biste naznačili hoćete li preuzeti recenziju ili ne. Potom, ukoliko prihvatite izradu recenzije, na istome mjestu možete pristupiti tekstu članka te zabilježili vašu recenziju i preporuku. Mrežna stranica časopisa je {$contextUrl}<br />\n<br />\nU slučaju da nemate pri ruci svoje korisničko ime ili lozinku za mrežnu stranicu časopisa, možete se koristiti ovom poveznicom kako biste promijenili lozinku (koju ćemo vam tada, zajedno s korisničkim imenom, poslati putem e-pošte). {$passwordResetUrl}<br />\n<br />\nSama recenzija trebala bi biti završena zaključno s {$reviewDueDate}.<br />\n<br />\nURL članka: {$submissionReviewUrl}<br />\n<br />\nSrdačno,<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Ovim obrascem e-pošte urednik rubrike šalje upit recenzentu može li prihvatiti zadatak recenziranja članka. Zamolba sadrži osnovne informacije u vidu naslova i kratkog sadržaja članka, datum do kojeg bi recenzija trebala biti napisana te načina na koji se recenzent može prijaviti u sustav. Ova poruka se koristi kada je odabran standardni recenzijski postupak u 2. koraku Postavljanja časopisa (Ako nije, koristi se Zamolba za recenziju članka u privitku)'),
('REVIEW_REQUEST', 'hu_HU', 'Cikk lektorálás kérése', 'Tisztelt {$reviewerName}!<br />\n<br />\nA(z) {$contextName} szerkesztőbizottsága nevében szeretném felkérni a(z) &quot;{$submissionTitle},&quot; című kézirat szakmai lektorálására, melynek absztraktját levelünk végén olvashatja.<br />\n<br />\nKérem, jelezze a folyóirat weboldalán ({$contextUrl}) legkésőbb {$responseDueDate}-ig, hogy vállalja-e a lektorálást. Amennyiben vállalja a bírálatot, ugyanitt rögzítheti véleményét és javaslatait. <br />A szakmai lektorálás határideje: {$reviewDueDate}.<br />\n<br />\nAmennyiben vállalná a szakmai lektorálást, de a jelzett határidő nem megfelelő, kérjük jelezze emailben.<br />\n<br />\nHa nincs felhasználóneve és jelszava a folyóirat weboldalához vagy elfelejtette azt, az alábbi linken emlékeztetőt kérhet. (Jelszavát és felhasználónevét emailben küldjük el.)<br />\n{$passwordResetUrl}<br />\n<br />\nA kézirat elérhető az alábbi URL címen:  {$submissionReviewUrl}<br />\n<br />\nKöszönettel,<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Ez az emailt a Rovatszerkesztő küldi a Lektornak, megkérve, hogy vállalja el, vagy, ha nem alkalmas, akkor utasítsa el a beküldött anyag lektorálási feladatát. Illetve információt ad a beküldött anyagról, úgymint cím, absztrakt, a lektori vélemény határideje, valamint hogyan lehet hozzáférni magához az anyaghoz. Ezt az üzenetet akkor kell használni, ha az általános lektorálási folyamat van kiválasztva a folyóirat menedzselése részben  > Beállítások > Munkafolyamat > Szakmai lektorálás. (Lásd még REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'id_ID', 'Permohonan Review Artikel', '{$reviewerName}:<br />\n<br />\nKami memandang bahwa Anda merupakan reviewer yang tepat untuk naskah, &quot;{$submissionTitle},&quot; yang diserahkan ke {$contextName}. Abstrak naskah tersebut disertakan di bawah ini, dan kami berharap Anda berkenan melakukannya.<br />\n<br />\nSilakan login ke website jurnal sebelum {$responseDueDate} untuk memberitahukan apakah Anda bersedia melakukan review atau tidak, juga untuk mengakses naskah dan menyerahkan review beserta rekomendasi Anda. Website jurnal adalah {$contextUrl}<br />\n<br />\nTenggat review ini sendiri adalah {$reviewDueDate}.<br />\n<br />\nJika Anda tidak memiliki nama pengguna dan sandi untuk website jurnal ini, Anda dapat menggunakan tautan berikut untuk mereset sandi Anda (yang selanjutnya akan diemailkan kepada Anda bersama nama pengguna Anda). {$passwordResetUrl}<br />\n<br />\nURL Naskah: {$submissionReviewUrl}<br />\n<br />\nTerimakasih atas perhatiannya.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Email ini dari Editor Bagian kepada Reviewer untuk meminta reviewer memberitahukan apakah menerima atau menolak permohonan review. Email ini memberikan informasi tentang naskah meliputi judul dan abstrak, tenggat review, dan cara mengakses naskah. Pesan ini digunakan saat Proses Review Standar dipilih di Manajemen > Pengaturan > Alur Kerja > Review. (Selain itu lihat di REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'it_IT', 'Richiesta di revisione di un articolo', '<br />Gentile {$reviewerName},<br />\n<br />\nDesidero invitarti alla  revisione del manoscritto &quot;{$submissionTitle},&quot; che è stato sottomesso per la pubblicazione {$contextName}. L''abstract del manoscritto  è inserito in calce. Spero che vorrai prendere in carico questo compito.<br />\n<br />\nTi chiedo quindi di effettuare il log in al sito web della rivista entro il {$responseDueDate} per indicare se prenderai in carico la revisione o meno.<br />\nPotrai poi accedere alla submission e inviare il tuo parere. Il sito web è {$contextUrl}<br />\n<br />\nLa data di scadenza per la revisione è fissata al {$reviewDueDate}.<br />\n<br />\nSe non hai una username and password per il sito web della rivista, puoi usare questo link per resettare la  password (che ti sarà quindi mandata per email insieme con la username). {$passwordResetUrl}<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nGrazie per la tua collaborazione.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n======<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\nAbstract<br />\n{$submissionAbstract}', 'Questa email dal section editor al revisore richiede che quest''ultimo accetti o rifiuti il compito di revisionare una proposta. Fornisce informazioni sulla submission quali il titolo e l''abstract, una data attesa per la revisione, e su come accedere alla submission stessa. Questo messaggio è usato quando il processo Standard di revisione è selezionato nel Journal Setup, fase 2. (Altrimenti vedi  ALLEGATA_RICHIESTA_REVISIONE.)'),
('REVIEW_REQUEST', 'ja_JP', '論文査読のお願い', '{$reviewerName}様<br />\n<br />\n雑誌『{$contextName}』への投稿原稿「{$submissionTitle}」の査読をお願いいたしたくメールを差し上げました。投稿物の要旨を以下に添付しました。貴殿がこの重要な仕事を引き受けてくださることを希望いたしております。<br />\n<br />\n{$responseDueDate}までに、雑誌のWebサイトにログインして、査読を引き受けていただけるかどうかを示していただけるようお願いいたします。引き受けていただける場合は、このサイトで投稿物にアクセスし、査読結果と答申を記録することができます。雑誌のWebサイトのURLは、{$contextUrl} です。<br />\n<br />\n査読作業自体の期限日は、{$reviewDueDate}です。<br />\n<br />\n雑誌のWebサイトにアクセスするユーザー名とパスワードをお持ちでない場合は、次のリンクを使ってパスワードをリセットしてください（パスワードはユーザー名と共にメールで送信されます）: {$passwordResetUrl}<br />\n<br />\n投稿物のURL: {$submissionReviewUrl}<br />\n<br />\nよろしくご検討くださるよう、お願いいたします。<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n「{$submissionTitle}」<br />\n<br />\n{$submissionAbstract}', 'このメールは、セクションエディタから査読者に投稿物の査読を依頼するものです。メールには、タイトルや要旨などの投稿物に関する情報、査読期限日、投稿物へのアクセス方法を示しています。このメールは、雑誌設定のステップ2で標準的査読プロセスが選択された場合に使用されます（そうでない場合は、REVIEW_REQUEST_ATTACHEDを参照してください）。'),
('REVIEW_REQUEST', 'ku_IQ', 'داواکاریی هەڵسەنگاندنی توێژینەوە', '{$reviewerName}:<br />\n<br />\nئێمە ئێوەمان بە شیاوی هەڵسەنگاندنی ئەم توێژینەوە زانی, &quot;{$submissionTitle},&quot; کە بۆ  {$contextName} نێردراوە. پوختەی توێژینەوەکە لە خوارەوە بەردەستە و ئێمە هیواخوازین کە بەڕێزتان ئەم ئەرکە قبوڵ بکەن.<br />\n<br />\nلێرەوە سەردانی پەڕەی گۆڤار بکەن {$responseDueDate} بۆ دیاریکردنی ئەوەی کە ئایا داخوازینامەکەمان قبوڵ یان ڕەت دەکەنەوە یان بۆ بینینی توێژینەوەکە و تۆمارکردنی هەڵسەنگاندنەکەتان. پەڕەی گۆڤار {$contextUrl}<br />\n<br />\nدوا کات بۆ هەڵسەنگاندن {$reviewDueDate}.<br />\n<br />\nئەگەر بەڕێزتان ناوی بەکارهێنەر و وشەی تێپەڕتان ون کردووە، دەتوانن لەم لینکەی خوارەوە داوای وشەیەکی نهێنیی نوێ بکەن (کە دواتر بە شێوەی ئیمەیڵ ناوی بەکارهێنەر و وشەی نهێنییەکەتان بەدەست دەگات). {$passwordResetUrl}<br />\n<br />\nلینکی پێشکەشکردنەکە: {$submissionReviewUrl}<br />\n<br />\nسوپاس بۆ قبوڵکردنی داخوازییەکەمان.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'ئەم ئیمەیڵە لە سەرنوسەری بەشەوە بۆ هەڵسەنگێنەرە کە داوا لە هەڵسەنگێنەر دەکات بە قبوڵکردن یان ڕەتکردنەوەی داخوازیی هەڵسەنگاندن. زانیاریی دەربارەی توێژینەوە پێشکەشکراوەکە دەخاتە ڕو، بۆ نمونە ناونیشان و پوختە، کۆتا وادە بۆ هەڵسەنگاندن و چۆنییەتی بینینی تەواوی توێژینەوەکە. ئەم نامەیە کاتێک بەکار دێت کە پرۆسەی هەڵسەنگاندنی ستاندارد بەکار بێت بەم شێوەیە: بەڕێوەبردن/ ڕێکخستنەکان/ ڕێڕەوی کار/ هەڵسەنگاندن. (ئەگەر نا سەردانی REVIEW_REQUEST_ATTACHED بکە.)'),
('REVIEW_REQUEST', 'mk_MK', 'Барање за рецензија на насловот', '{$reviewerName}:<br />\n<br />\nВерувам дека би биле одличен рецензент на трудот, &quot;{$submissionTitle},&quot; кој е поднесен до {$contextName}. Апстрактот на поднесокот е вметнат подолу, и се надевам дека ќе размислите да ја преземете оваа важна задача за нас.<br />\n<br />\nВе молиме, најавете се на веб-страницата на списанието до {$answerDueDate} за да наведете дали ќе го рецензирате трудот или не, како и да пристапите до поднесокот и да ги зачувате вашите прегледи и препораки. Веб-страницата е {$textUrl} <br />\n<br />\nРокот на самата рецензија е до {$reviewDueDate}. <br />\n<br />\nДоколку не ги имате вашето корисничко име и лозинка за веб-страницата на списанието, можете да го искористите овој линк за да ја ресетирате вашата лозинка (која потоа ќе ви биде испратена преку и-меил заедно со вашето корисничко име). {$passwordResetUrl} <br />\n<br />\nURL-адреса на поднесокот: {$missionReviewUrl} <br />\n<br />\nВи благодариме што го земавте во предвид ова барање. <br />\n<br />\n{$editorialContactSignature} <br />\n<br />\n&quot; {$missionTitle}&quot; <br />\n<br />\n{$submissionAbstract}', 'Овој и-меил од Секцискиот уредник до Рецензентот бара рецензентот да ја прифати или одбие задачата за рецензирање на поднесок. Обезбедува информации за поднесокот како насловот и апстрактот, рок за достава на рецензијата, и како да се пристапи до самиот поднесок. Оваа порака се користи кога е одбран Стандарден процес на рецензија во Раководење > Поставки > Тек на рабоатата > Рецензија. (Во спротивно погледнете  REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'nb_NO', 'Forespørsel om fagfellevurdering', '{$reviewerName}:<br />\n<br />\nVårt tidsskrift {$contextName} har fått tilsendt manuskriptet &quot;{$submissionTitle}&quot;. Vi håper du er villig til å vurdere dette manuskriptet, fordi vi mener dette kan passe med din vurderingskompetanse. Sammendraget som var vedlagt manuskriptet er skrevet inn nedenfor, og jeg håper du vil påta deg dette viktige oppdraget.<br />\n<br />\nVennligst logg inn på tidsskriftets nettsted innen {$responseDueDate}, for å bekrefte om du vil påta deg dette vurderingsoppdraget for oss eller ikke. Hvis du påtar deg oppdraget skal du også bruke nettstedet for å skrive inn vurderingen din, og for å registrere den anbefalingen du gir oss. Adressen til nettstedet er {$contextUrl}<br />\n<br />\nFrist for å levere en vurdering er {$reviewDueDate}.<br />\n<br />\nHvis du har mistet eller glemt brukernavnet og passordet ditt til tidsskriftets nettsted, kan du bruke denne lenken for å fornye passordet (som du så får tilsendt i en e-post, sammen med brukernavnet ditt). {$passwordResetUrl}<br />\nManuskriptets URL: {$submissionReviewUrl}<br />\n<br />\nTakk for at du har sagt deg villig til å bidra til arbeidet vårt.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'I denne e-posten ber Seksjonsredaktøren en Fagkonsulent om å akseptere eller avslå oppdraget med å fagfellevurdere et manuskript. E-posten gir informasjon om 1) manuskriptet (også tittel og sammendrag), 2) en forfallsdato for oppdraget, og 3) informasjon om pålogging og tilgang til manuskriptet. Denne e-posten brukes når Standard fagvurderingsprosess er valgt i Tidsskriftoppsett, Trinn 2. (Ellers: se e-posten REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'nl_NL', 'Artikel review verzoek', '{$reviewerName}:<br />\n<br />\nIk geloof dat u een excellente reviewer zou zijn voor het manuscript &quot;{$submissionTitle}&quot; dat is ingestuurd bij {$contextName}. De samenvatting van de inzending staat hieronder. Ik hoop dat u wilt overwegen deze belangrijke taak voor ons uit te voeren.<br />\n<br />\nWilt u voor {$responseDueDate} inloggen op de website van het tijdschrift om aan te geven of u de review al of niet doet. Daar kunt u ook de inzending vinden en uw review en aanbeveling vastleggen. De website is {$contextUrl}<br />\n<br />\nHet review wordt verwacht op {$reviewDueDate}.<br />\n<br />\nAls u uw gebruikersnaam en het wachtwoord van de website van het tijdschrift niet heeft, kunt u deze link gebruiken voor het herstellen van uw wachtwoord (dat samen met uw gebruikersnaam in een e-mail naar u verstuurd wordt). {$passwordResetUrl}<br />\n<br />\nURL inzending: {$submissionReviewUrl}<br />\n<br />\nDank u voor het overwegen van dit verzoek.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Deze e-mail van de sectieredacteur aan een reviewer vraagt aan de reviewer een review te accepteren of te weigeren. Er wordt informatie meegestuurd over de inzending zoals de titel en de samenvatting, de datum waarop de review gereed moet zijn en instructies voor het benaderen van de inzending. Dit bericht word gebruikt wanneer het standaard reviewproces is geselecteerd in stap 2 van het inrichten van het tijdschrift (zie verder REVIEW_REQUEST_ATTACHED)'),
('REVIEW_REQUEST', 'pl_PL', 'Prośba o wykonanie recenzji tekstu', '{$reviewerName}:<br />\n<br />\nredakcja czasopisma "{$contextName}" zwraca się do Pani/ Pana z prośbą o wykonanie recenzji tekstu &quot;{$submissionTitle}&quot; Poniżej zamieszczamy abstrakt tekstu. Mamy nadzieję, że zaakceptuje Pani/ Pan naszą prośbę.<br />\n<br />\nProsimy o zalogowanie się na stronie czasopisma nie później niż {$responseDueDate} w celu przyjęcia lub odrzucenia naszej prośby. Po akceptacji na Pani/ Pana adres e-mail zostanie przysłana wiadomość wraz z linkiem do zgłoszonego tekstu oraz formularza recenzji. Adres strony internetowej czasopisma to {$contextUrl}<br />\n<br />\nTermin wykonania recenzji: {$reviewDueDate}.<br />\n<br />\nJeżeli nie posiada Pani/ Pan danych niezbędnych do zalogowania się na stronie czasopisma, użyj ten link, aby zresetować hasło (które zostanie Ci następnie przesłane razem z nazwą użytkownika). {$passwordResetUrl}<br />\n<br />\nWWWW tekstu: {$submissionReviewUrl}<br />\n<br />\nZ wyrazami szacunku, <br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Wiadomość od redaktora prowadzącego do recenzenta. Zawiera prośbę o przygotowanie recenzji tekstu, jego tytuł i abstrakt, a także zalecenie dot. zresetowania hasła w sytuacji, gdy recenzent nie pamięta danych do logowania. Wysyłana, jeśli recenzent pracować będzie w systemie'),
('REVIEW_REQUEST', 'pt_BR', 'A revista {$contextName} solicita avaliação de artigo', '{$reviewerName}:<br />\n<br />\nAcredito que você poderia servir como um(a) excelente avaliador(a) do manuscrito, &quot;{$submissionTitle},&quot; que foi submetido ao periódico {$contextName}. O resumo da submissão está inserido abaixo e espero que você considere realizar essa importante tarefa para nós.<br />\n<br />\nFaça o login no site do periódico antes de {$responseDueDate} para indicar sua disponibilidade, bem como para acessar submissão e registrar sua avaliação e recomendação. O site é {$contextUrl}<br />\n<br />\nA avaliação em si tem como prazo {$reviewDueDate}.<br />\n<br />\nSe você não tiver seu nome de usuário e senha para o site do periódico, poderá usar este link para redefinir sua senha (que será enviada por e-mail juntamente com seu nome de usuário). {$passwordResetUrl}<br />\n<br />\nURL da submissão: {$submissionReviewUrl}<br />\n<br />\nAgradeço por considerar esta solicitação.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Mensagem do Editor de Seção para solicitar ao Avaliador que indique disponibilidade ou não para realizar uma avaliação. Oferece informações sobre a submissão, como título e resumo, além da data para a conclusão dos trabalhos e como acessar o documento. Esta mensagem é usada quando se utiliza o Processo Padrão de Avaliação, definido no Passo 2 de Configuração da Revista. (Caso contrário veja REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'pt_PT', 'Pedido de revisão de artigo', '{$reviewerName},<br />\n<br />\nAcreditamos que o seu conhecimento será fundamental para realizar a revisão do manuscrito, &quot;{$submissionTitle}&quot; submetido à {$contextName}. O resumo da submissão encontra-se abaixo, esperamos que considere assumir esta importante tarefa para o nosso trabalho.<br />\n<br />\nAceda ao sistema até {$responseDueDate} para confirmar a sua disponibilidade ou não para realizar a revisão, bem como para ter acesso aos dados completos do artigo e registar a sua revisão e recomendações, através do URL {$contextUrl}<br />\n<br />\nO prazo para a entrega da revisão é {$reviewDueDate}.<br />\n<br />\nCaso ainda não possua o seu nome de utilizador e senha de acesso para aceder à revista, use o link a seguir para que o sistema crie uma nova senha que lhe será enviada via email, junto com os seus dados de acesso.{$passwordResetUrl}<br />\n<br />\nURL da submissão: {$submissionReviewUrl}<br />\n<br />\nAgradecemos a resposta a este pedido.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Este e-mail é enviado pelo Editor de Secção para o Revisor a solicitar que aceite ou recuse a tarefa de rever um artigo. Fornece informações sobre a submissão, como o título e resumo, prazo de revisão e como aceder à submissão. Esta mensagem é usada quando o Processo de revisão padrão é selecionado em Configurações > Fluxo de trabalho > Revisão. (Caso contrário, veja REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'ro_RO', 'Rugăminte revizuire articol', '{$reviewerName}:<br />\n<br />\nVă rugăm să ne sprijiniți cu revizuirea manuscrisului, &quot;{$submissionTitle},&quot; care a fost înregistrat la {$contextName}. Rezumatul manuscrisului este inserat mai jos.<br />\n<br />\nVă rugăm să vă conectați la site-ul jurnalului până la data de {$responseDueDate} pentru a indica dacă veți efectua sau nu revizuirea, precum și pentru a accesa manuscrisul și zona de completare/încărcare a revizuirii și recomanărilor. Adresa web este {$contextUrl}<br />\n<br />\nVă rugăm să fiți de acord cu data de finalizare a revizuirii de {$reviewDueDate}.<br />\n<br />\nDacă nu aveți numele de utilizator și parola pentru site-ul jurnalului, puteți utiliza acest link pentru a vă reseta parola (care vă va fi trimisă prin e-mail împreună cu numele de utilizator). {$passwordResetUrl}<br />\n<br />\nURL înregistrare: {$submissionReviewUrl}<br />\n<br />\nVă mulțumim că ați luat în considerare această solicitare.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Acest e-mail de la editorul de secțiuni către un revizor, căruia i se solicită să accepte sau să refuze sarcina de a examina o trimitere. Oferă informații despre manuscris, cum ar fi titlul și rezumatul, data limită de revizuire și modul de accesare a prezentării. Acest mesaj este utilizat atunci când procesul de revizuire standard este selectat în Management> Setări> Flux de lucru> Revizuire. (În caz contrar, consultați REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'ru_RU', 'Запрос на рецензирование статьи', 'Здравствуйте, {$reviewerName}!<br />\n<br />\nЯ полагаю, что Вы могли бы быть прекрасным рецензентом для материала «{$submissionTitle}», который был направлен в журнал «{$contextName}». Аннотация статьи приведена ниже, и я надеюсь, что Вы возьметесь выполнить эту важную задачу для нас.<br />\n<br />\nПожалуйста, войдите на сайт журнала до {$responseDueDate}, чтобы подтвердить Ваше согласие на рецензирование или отказаться от рецензирования, а также получить доступ к материалу и оставить свою рецензию и рекомендацию. Адрес сайта — {$contextUrl}<br />\n<br />\nСама рецензия должна быть предоставлена до {$reviewDueDate}.<br />\n<br />\nЕсли у Вас нет имени пользователя и пароля для доступа к сайту журнала, Вы можете воспользоваться этой ссылкой для сброса Вашего пароля (он будет направлен Вам вместе с Вашим именем пользователя на электронную почту). {$passwordResetUrl}<br />\n<br />\nURL материала: {$submissionReviewUrl}<br />\n<br />\nЗаранее благодарю Вас,<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n«{$submissionTitle}»<br />\n<br />\n{$submissionAbstract}', 'Это письмо редактора раздела, отправляемое рецензенту, с запросом согласия или отказа от выполнения рецензирования материала. В письме приводится информация о материале, такая как название и аннотация, срок выполнения рецензии и как получить доступ к самому материалу. Это сообщение используется, если выбран стандартный процесс рецензирования в Управление > Настройки > Рабочий процесс > Рецензирование. (В ином случае, смотрите REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'sk_SK', 'Žiadosť o spracovanie recenzie článku', '{$reviewerName}:<br />\n<br />\nDomnievam sa, že by ste mohli byť výborným recenzentom príspevku &quot;{$submissionTitle},&quot; ktorý bol zaslaný do {$contextName}. Abstrakt príspevku je vložený nižšie. Verím, že zvážite možnosť prijatia tejto pre nás dôležitej úlohy.<br />\n<br />\nProsím, prihláste sa do {$responseDueDate} na stránkach časopisu, aby ste uviedli, či recenziu spracujete alebo nie a tiež pre prístup k príspevku a zaznamenanie Vašej recenzie a odporúčania. Adresa webovej stránky je {$contextUrl}<br />\n<br />\nTermín pre spracovanie recenzie je {$reviewDueDate}.<br />\n<br />\nAk nemáte svoje používateľské meno a heslo pre webovú stránku časopisu, môžete použiť tento odkaz pre obnovenie Vášho hesla (ktoré Vám bude zaslané emailom spolu s Vašim používateľským menom). {$passwordResetUrl}<br />\n<br />\nURL príspevku: {$submissionReviewUrl}<br />\n<br />\nĎakujeme Vám za zváženie tejto žiadosti.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Tento email od editora sekcie pre recenzenta žiada, aby recenzent prijal alebo odmietol úlohu spracovať recenziu príspevku. Obsahuje informácie o príspevku, ako je názov a abstrakt, termín pre spracovanie recenzie a ako sa dostať k samotnému príspevku. Táto správa je používaná, pokiaľ je zvolené Štandardné recenzné konanie v druhom kroku  Nastavenie časopisu. (V inom prípade pozri REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'sl_SI', 'Prošnja za recenzijo prispevka', '{$reviewerName}:<br />\n<br />\nVerjamem, da bi lahko bili odličen recenzent rokopisa, &quot;{$submissionTitle},&quot; ki je bil oddan v revijo {$contextName}. Spodaj je izvleček prispevka in upam, da boste sprejeli to nalogo, ki je za nas pomembna.<br />\n<br />\nProsimo prijavite se na spletno stran revije do {$responseDueDate} in potrdite ali zavrnite prošnjo za recenzijo. Enako lahko dostopate do prispevka in oddate vašo recenzijo in priporočilo. Spletna stran je {$contextUrl}<br />\n<br />\nSama recenzija mora biti opravljena do {$reviewDueDate}.<br />\n<br />\nČe nimate uporabniškega imena in gesla za dostop do spletne strani revije, lahko uporabite naslednjo povezavo za ponastavitev gesla (ki vam bo posredovano po e-pošti skupaj z vašim uporabniškim imenom): {$passwordResetUrl}<br />\n<br />\nURL povezava do prispevka: {$submissionReviewUrl}<br />\n<br />\nHvala lepa za sprejetje prošnje.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Ta email pošilja urednik rubrike recenzentu s prošnjo, da recenzent potrdi ali zavrne oipravljanje recenzije. Vsebuje informaciej o prispevku kot so naslov in izvleček, datum do dokončanja recenzije ter dostopom do prispevka. Email se uporablja, ko je v nastavitvah izbran standarden recnezijski proces (Upravljanje > Nastavitve > Potek dela > Recenzija. (Drugače poglej REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'sv_SE', 'Förfrågan om granskning av artikel', '{$reviewerName}:<br />\n<br />\nJag tror att du skulle passa utmärkt som sakkunniggranskare av manuskriptet &quot;{$submissionTitle}&quot;, som har skickats in till {$contextName}. Bidragets abstract bifogas nedan. Jag hoppas att du kan överväga att genomföra granskningen åt oss, då det vore mycket värdefullt.<br />\n<br />\nVänligen logga in på tidskriftens webbplats senast {$responseDueDate} och svara om du har möjlighet att åta dig granskningsuppdraget eller inte. Det är också där du får tillgång till bidraget och lägger in din granskning och rekommendation. Adressen till webbplatsen är {$contextUrl}.<br />\n<br />\nDeadline för själva granskningen är {$reviewDueDate}.<br />\n<br />\nOm du har glömt ditt användarnamn och/eller lösenord till tidskriftens webbplats, använd följande länk för att återställa lösenordet: {$passwordResetUrl}. Dina inloggningsuppgifter skickas då till dig per e-post.<br />\n<br />\nBidragets URL: {$submissionReviewUrl}<br />\n<br />\nTack för att du överväger granskningsuppdraget.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Det här e-postmeddelandet från sektionsredaktören till en granskare ber granskaren att acceptera eller tacka nej till uppdraget att sakkunniggranska ett bidrag. Det innehåller information om bidraget i form av titel och abstract, en deadline för granskning och instruktioner för hur man kommer åt bidraget. Meddelandet används när granskningsprocess Standard är valt i Administration > Inställningar > Arbetsflöde > Granskning. (Annars, se REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'tr_TR', 'Hakem Değerlendirmesi Talebi', 'Sayın {$reviewerName},<br />\n<br />\n{$contextName} adlı dergi için gönderilen &quot;{$submissionTitle}&quot; başlıklı çalışma, sizin uzmanlık alanlarınız ile uyuştuğundan  bu makaleyi hakem olarak değerlendirmenizi talep ediyoruz. Makalenin Öz''ü aşağıda verilmiştir. Dergimiz için oldukça önemli olan bu hakem değerlendirmesi talebimizi kabul edeceğinizi ümit ediyoruz.<br />\n<br />\nLütfen, {$responseDueDate} tarihine kadar bu çalışmanın hakemliğini kabul edip etmediğinizi bildirmek için dergimizin internet sitesine giriş yapınız. Dergimiz internet sitesinden ilgili çalışmanın tam metnine ulaşabilir, hakem değerlendirme formunu ve önerilerinizi gönderebilirsiniz. Dergi adresi: {$contextUrl} <br />\n<br />\nDeğerlendirmeyi tamamlamak için son tarih: {$reviewDueDate}.<br />\n<br />\nEğer derginin web sitesine giriş için kullanıcı adı ve şifreniz yoksa veya unuttuysanız, şifrenizi yenilemek için bu bağlantıyı kullanabilirsiniz (Kullanıcı adınızla birlikte şifreniz size e-posta olarak gönderilecektir). {$passwordResetUrl}<br />\n<br />\nMakale Erişim Adresi: {$submissionReviewUrl}<br />\n<br />\nTalebimize olumlu yaklaşımınız için şimdiden teşekkür ederiz.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\nÖz: {$submissionAbstract}', 'Bu eposta Bölüm Editöründen bir hakeme bir çalışmanın hakemlik görevine cavet amacı ile iletir. Gönderiyle ilgili başlık ve özet gibi bilgileri, değerlendirme sona erme tarihini ve kendisinin başvuruya nasıl erişilebileceği ile ilgili bilgileri içerir.	Bu mesaj Dergi Ayarları Adım 2''de seçilen Standart Değerlendirme Sürecinde kullanılır. (Ayrıca bkz.: REVIEW_REQ_MULTI_ATTACHED ve REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'uk_UA', 'Запит на рецензування статті', '{$reviewerName}:<br />\n<br />\nЯ вірю, що Ви могли б стати прекрасним рецензентом для рукопису,  &quot;{$submissionTitle},&quot; надісланого до видання {$contextName}. Нижче подана анотація цієї праці, і, хочу сподіватись, Ви розглянете можливість виконання цієї важливої роботи для нас.<br />\n<br />\nБудь ласка, до {$responseDueDate} зайдіть на сайт журналу, щоб повідомити, чи візьметеся Ви за цю рецензію, а також для того, щоб отримати доступ до подання, записати Вашу рецензію та рекомендацію. Адреса веб-сайту журналу {$contextUrl}<br />\n<br />\nМи хотіли б мати готову рецензію до {$reviewDueDate}.<br />\n<br />\nЯкщо Ви не зберегли імені користувача та пароль для веб-сайту журналу, Ви можете скористатися наступним посиланням для того, щоб скинути свій пароль (після цього пароль та ім''я користувача будуть відправлені Вам електронною поштою). {$passwordResetUrl}<br />\n<br />\nURL подання: {$submissionReviewUrl}<br />\n<br />\nДякую, що розглянули цей запит.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Цим листом редактор розділу просить рецензента взятися за виконання рецензії подання або відмовитись від цієї роботи. У листі міститься інформація про подання (назва та анотація), про кінцевий термін рецензування та про те, як отримати доступ безпосередньо до подання. Цей шаблон використовується, якщо на кроці 2 Налаштування журналу обраний Стандартний процес рецензування (у іншому випадку див. REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'vi_VN', 'Yêu cầu đánh giá bài báo', 'Kính gửi {$reviewerName},<br />\n<br />\nTôi tin rằng bạn sẽ một người phản biện thích hợp của bản thảo, &quot;{$submissionTitle},&quot; được gửi tới {$contextName}. Bản tóm tắt của bản thảo được chèn bên dưới và tôi hy vọng rằng bạn sẽ xem xét thực hiện quá trình quan trọng này cho chúng tôi.<br />\n<br />\nVui lòng đăng nhập vào trang web tạp chí trước ngày {$responseDueDate} để cho biết liệu bạn sẽ thực hiện đánh giá này hay không, cũng như truy cập vào bài gửi và ghi lại nhận xét và đề xuất của bạn. Trang web là {$contextUrl}<br />\n<br />\nThời hạn của việc đánh giá là ngày {$reviewDueDate}.<br />\n<br />\nNếu bạn quên username và mật khẩu đăng nhập vào trang web của tạp chí, bạn có thể sử dụng liên kết này để đặt lại mật khẩu của mình (sau đó sẽ được gửi qua email cho bạn cùng với username của bạn).{$passwordResetUrl}<br />\n<br />\nURL bài gửi: {$submissionReviewUrl}<br />\n<br />\nCảm ơn bạn đã xem xét yêu cầu này.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Email này từ Biên tập viên chuyên mục tới Người phản biện yêu cầu họ chấp nhận hoặc từ chối nhiệm vụ đánh giá nội dung bài gửi. Nó cung cấp thông tin về bài gửi như tiêu đề và tóm tắt, ngày đến hạn gửi bài đánh giá và cách truy cập bài gửi. Thông báo này được sử dụng khi Quy trình phản biện tiêu chuẩn được chọn trong Quản lý> Cài đặt> Quy trình làm việc> Phản biện. (Nếu không, hãy xem REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST', 'zh_CN', '邀请您审查稿件', '{$reviewerName}您好：<br />\n<br />\n《{$contextName}》的编辑团队相信您是投稿到本期刊之稿件&quot;{$submissionTitle}&quot;的最佳审查人选。该份稿件的摘要如下，而我们希望您会考虑进行这份对我们来说相当重要的一个工作。<br />\n<br />\n无论您是否接受审查工作与否，都请在{$responseDueDate}之前登入这个期刊网站，同时检阅这份稿件并且记录您的审查意见和编辑建议。网站为：{$contextUrl}<br />\n<br />\n请注意审查工作的期限为：{$reviewDueDate}。<br />\n<br />\n如果您没有您在这个期刊网站的用户帐号和密码。您可以使用这个链接去重新设定您的密码（该密码会和您的用户帐号名称一起电邮给您）：{$passwordResetUrl}<br />\n<br />\n稿件网址：{$submissionReviewUrl}<br />\n<br />\n非常感谢您考虑我们的邀请。<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n<br />\n{$submissionAbstract}', '这封电子邮件是由区段编辑寄发给审查人一份邀请函，询问审查人接受或婉谢一份稿件的审查工作。邮件中含有关于稿件标题和摘要的信息，一个审查工作到期日，以及如何访问稿件的说明信息。在「期刊设定」之步骤2中选择「标准审查流程」选项时，才会用到这份消息。(否则请见：REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST_ATTACHED', 'ar_IQ', 'إلتماس تحكيم مؤلَّف', '{$reviewerName}:<br />\n<br />\nكلي ثقة بأنك ستكون محكماً متميزاً للمؤلَّف, &quot;{$submissionTitle},&quot; وأنا أرجو أنك ستأخذ على عاتقك إنجاز هذه المهمة لمجلتنا. إن دليل عمل المحكم في مجلتنا مضمن في أدنى الرسالة، وإن طلب النشر المذكور مرفق بها. إن تحكيمك لهذا المؤلَّف مع توصياتك بشأنه ينبغي إرسالها لي عبر البريد الالكتروني قبل يوم {$reviewDueDate}.<br />\n<br />\nلطفاً، بين عبر ردك على هذه الرسالة حتى يوم {$responseDueDate} مدى قدرتك وقبولك القيام بهذا التحكيم.<br />\n<br />\nنشكر لك اهتمامك بالتماسنا هذا.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nدليل عمل المحكم<br />\n<br />\n{$reviewGuidelines}<br />\n', 'هذه الرسالة يرسلها محرر قسم المجلة إلى أحد المحكمين ليلتمس منه قبول مهمة التحكيم أو رفضها. وهي مرفقة بطلب النشر بشكل ملف. يتم استعمال هذه الرسالة عندما تكون عمية التحكيم مبنية على أساس التراسل عبر البريد الالكتروني خلال تهيئة إعدادات المجلة. (إنظر خيارات التحكيم ضمن: الإعدادات، المخطط الانسيابي، التحكيم). (بخلاف ذلك، أنظر REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'bs_BA', 'Zamolba za recenziju članka u privitku', 'Poštovana/i {$reviewerName},<br />\n<br />\ns obzirom na vaše iskustvo i područje ekspertize, rado bismo vam povjerili zadatak recenzije članka &quot;{$submissionTitle}&quot; prijavljenog u naš časopis. Nadamo se da ćete prihvatiti našu ponudu te izvršiti ovu, za nas iznimno važnu, zadaću.<br />\nU nastavku teksta poruke nalaze se upute za recenzente našeg časopisa, a tekst članka nalazi se u prilogu. Od vas očekujemo da nam vašu recenziju članka, zajedno s preporukom dostavite e-poštom zaključno s {$reviewDueDate}.<br />\n<br />\nNo prije svega, molimo vas da nam u odgovoru na ovu poruku e-poštom zaključno s datumom {$responseDueDate} naznačite da li ste u mogućnosti i da li ste voljni izvršiti recenziju<br />\n<br />\nSrdačno,<br />\n{$editorialContactSignature}<br />\n<br />\nUpute za recenzente<br />\n<br />\n{$reviewGuidelines}', 'Ovim obrascem e-pošte urednik rubrike šalje upit recenzentu može li prihvatiti ili je prisiljen odbiti zadatak recenziranja članka. Zamolba sadrži i tekst članka u privitku. Ova poruka se koristi kada je u 2. koraku Postavljanja časopisa odabran recenzijski postupak u kojem se prilog šalje recenzentu kao privitak e-pošte. (Ako ne, pogledajte Zamolba za recenziju članka.)'),
('REVIEW_REQUEST_ATTACHED', 'ca_ES', 'Sol·licitud de revisió d''un article', '{$reviewerName}:<br />\n<br />\nConsidero que el vostre perfil és adequat per a revisar el manuscrit &quot;{$submissionTitle},&quot; per la qual cosa us demano que valoreu la possibilitat d''encarregar-vos d''aquesta important tasca per a la nostra revista. A continuació trobareu les directrius de revisió d''aquesta revista, així com la tramesa com a arxiu adjunt. M''hauríeu d''enviar per correu electrònic la vostra revisió, juntament amb la recomanació, abans del {$reviewDueDate}.<br />\n<br />\nUs demano que respongueu a aquest missatge abans del {$responseDueDate} per indicar-nos si accepteu encarregar-vos de la revisió.<br />\n<br />\nGràcies per tenir en compte aquesta sol·licitud.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nDirectrius de revisió<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Aquest missatge de correu electrònic de l''editor de secció s''adreça a un revisor/a per sol·licitar-li que accepti o rebutgi la tasca de revisió d''una tramesa. El correu inclou la tramesa com a adjunt. Aquest missatge s''utilitza quan s''ha seleccionat el procés de revisió d''adjunt de correu a Gestió > Configuració > Flux de treball > Revisió. (Si no consulteu REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'cs_CZ', 'Žádost o zpracování recenze článku', '{$reviewerName}:<br />\n<br />\nDomnívám se, že byste mohl být výborným recenzentem příspěvku &quot;{$submissionTitle}&quot; a žádám Vás, abyste zvážil možnost přijetí tohoto pro nás důležitého úkolu. Instrukce pro zpracování recenze pro tento časopis jsou připojeny níže a příspěvek je přiložen k tomuto emailu. Vaši recenzi příspěvku spolu s Vaším doporučením byste mi měl zaslat emailem do {$reviewDueDate}.<br />\n<br />\nUveďte prosím do {$responseDueDate} v odpovědi na tento email, zda můžete a chcete zpracovat tuto recenzi.<br />\n<br />\nDěkujeme za zvážení této žádosti.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nInstrukce pro zpracování recenze<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Tento email od editora sekce pro recenzenta žádá, aby recenzent přijal nebo odmítl úkol zpracovat recenzi příspěvku. Obsahuje příspěvek jako přílohu. Tato zpráva je používána, pokud je zvoleno Recenzí řízení vyžívající emailových příloh ve druhém kroku  Nastavení časopisu. (V jiném případě viz REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'da_DK', 'Forespørgsel om bedømmelse af artikel', '{$reviewerName}:<br />\n<br />\nJeg tror, at du vil kunne være en fremragende bedømmer af manuskriptet &quot;{$submissionTitle}&quot;, og jeg beder dig om at overveje at påtage dig denne vigtige opgave for os. Dette tidsskrifts Retningslinjer for bedømmelser er angivet nedenfor, og manuskriptet er vedhæftet denne e-mail. Din bedømmelse af manuskriptet samt din anbefaling skal sendes til mig pr. e-mail senest den {$reviewDueDate}.<br />\n<br />\nMeld venligst tilbage via e-mail inden den {$responseDueDate}, om du kan og er villig til at foretage bedømmelsen.<br />\n<br />\nTak for din overvejelse af denne forespørgsel.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nRetningslinjer for bedømmelser<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Denne e-mail sendes af sektionsredaktøren til en bedømmer og beder vedkommende om at acceptere eller afvise at bedømme et manuskript. Manuskriptet er vedhæftet denne e-mail. Denne meddelelse benyttes, hvis indstillingen Bedømmelsesproces, hvor manuskript er vedhæftet e-mail, er valgt under konfiguration af tidsskrift, Indstillinger > Workflow > Bedømmelse. (Se ellers REVIEW_REQUEST.)');
INSERT INTO `email_templates_default_data` VALUES
('REVIEW_REQUEST_ATTACHED', 'de_DE', 'Bitte um ein Gutachten', '{$reviewerName},<br />\n<br />\naufgrund Ihrer Forschungsschwerpunkte wären Sie ein/e ausgezeichnete/r Gutachter/in für das Manuskript &quot;{$submissionTitle}&quot;. Ich hoffe sehr, dass Sie sich bereitfinden können, uns mit Ihrer Stellungnahme zu unterstützen. Sie wären uns eine große Hilfe. Die Richtlinien für die Begutachtung sind angefügt, ebenso der Beitrag, um den es geht. Ihr Gutachten und Ihre Empfehlung sollten gegebenenfalls bis zum {$reviewDueDate} per E-Mail bei uns eingehen.<br />\n<br />\nBitte benachrichtigen Sie uns bis zum {$responseDueDate} per E-Mail, ob Sie das Gutachten übernehmen können.<br />\n<br />\nIn der Hoffnung auf eine positive Antwort,<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nRichtlinien für Gutachter/innen<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Diese E-Mail wird von der/dem Rubrikredakteur/in an eine/n Gutachter/in gesendet, um darum zu bitten, dass sie/er die Aufgabe, eine Einreichung zu begutachten, übernimmt oder ablehnt. Sie enthält die Einreichung als E-Mail-Anhang. Diese Nachricht wird benutzt, wenn in Schritt 2 des Zeitschriftensetups das Begutachtungsverfahren über E-Mail-Anhänge ausgewählt worden ist. (Ansonsten siehe REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'el_GR', 'Αίτημα αξιολόγησης άρθρου', '{$reviewerName}:<br />\n<br />\nΠιστεύουμε ότι θα αποτελέσετε έξοχο Αξιολογητή της εργασίας &quot;{$submissionTitle},&quot;, που επισυνάπτεται στο παρόν μήνυμα. Σας ζητούμε να αναλάβετε αυτό το σημαντικό έργο για εμάς. Οι Οδηγίες Αξιολόγησης για το περιοδικό παρατίθενται ακολούθως. Η αξιολόγηση και τα σχόλιά σας θα πρέπει να μας αποσταλούν με ηλεκτρονικό μήνυμα μέχρι τις {$reviewDueDate}.<br />\n<br />\nΠαρακαλούμε ενημερώστε μέχρι τις {$responseDueDate} εάν μπορείτε και επιθυμείτε να αναλάβετε την αξιολόγηση.<br />\n<br />\nΣας ευχαριστούμε εκ των προτέρων για την εξέταση του αιτήματός μας.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nΟδηγίες Αξιολόγησης<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Το παρόν αίτημα αξιολόγησης μιας υποβολής αποστέλλεται από τον Επιμελητή Ενότητας σε έναν Αξιολογητή. Περιλαμβάνει την υποβολή ως επισυναπτόμενο αρχείο. Το συγκεκριμένο μήνυμα χρησιμοποιείται όταν επιλέγεται η Διαδικασία Αξιολόγησης με Επισύναψη σε Ηλεκτρονικό Μήνυμα στη Διαχείριση > Ρυθμίσεις > Ροή εργασιών > Αξιολόγηση. (Σε διαφορετική περίπτωση ανατρέξτε στο REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'en_US', 'Article Review Request', '{$reviewerName}:<br />\n<br />\nI believe that you would serve as an excellent reviewer of the manuscript, &quot;{$submissionTitle},&quot; and I am asking that you consider undertaking this important task for us. The Review Guidelines for this journal are appended below, and the submission is attached to this email. Your review of the submission, along with your recommendation, should be emailed to me by {$reviewDueDate}.<br />\n<br />\nPlease indicate in a return email by {$responseDueDate} whether you are able and willing to do the review.<br />\n<br />\nThank you for considering this request.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nReview Guidelines<br />\n<br />\n{$reviewGuidelines}<br />\n', 'This email is sent by the Section Editor to a Reviewer to request that they accept or decline the task of reviewing a submission. It includes the submission as an attachment. This message is used when the Email-Attachment Review Process is selected in Management > Settings > Workflow > Review. (Otherwise see REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'es_ES', 'Petición de revisión de artículo', '{$reviewerName}:<br />\n<br />\nTengo el convencimiento de que sería un/a excelente revisor/a del manuscrito &quot;{$submissionTitle},&quot;. A continuación encontrará un extracto del envío, con la esperanza de que aceptará llevar a cabo esta importante tarea para nosotros. A continuación le mostramos las Normas de Revisión de esta revista y adjunto a este correo-e recibirá el envío. Debería enviarme por correo-e su revisión del envío, así como su recomendación antes del {$reviewDueDate}.<br />\n<br />\nLe ruego me conteste a este correo-e antes del {$responseDueDate} y me comunique si puede y quiere hacer la revisión.<br />\n<br />\nGracias por tener en cuenta esta solicitud.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nNormas de Revisión<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Este correo electrónico del editor/a de sección se dirige a un revisor/a para solicitarle que acepte o rechace la tarea de revisión de un envío. El correo incluye el envío como adjunto. Este mensaje se usa cuando se selecciona el proceso de revisión de adjunto de correo en Gestión > Ajustes > Flujo de trabajo > Revisión. (Si no consulte REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'eu_ES', 'Artikulua ebaluatzeko eskaera', '{$reviewerName}:<br />\n<br />\nUste dut ebaluatzaile bikaina izango zinatekeela {$submissionTitle} eskuizkribuari buruzko iritzia emateko, eta guretzat lan hori egiteko aukerarik izango ote zenukeen galdetzera natorkizu. Aldizkari honetako Ebaluazioak egiteko gidalerroak behean dituzu, eta artikulua mezu honi erantsita bidaltzen dizut. Artikuluari buruzko ebaluazio-txostena eta zure gomendioa niri bidali beharko zenizkidake posta elektronikoz {$reviewDueDate} aurretik.<br />\n<br />\nErantzun iezadazu posta elektronikoz, mesedez, {$responseDueDate} aurretik, ebaluazioa egiterik daukazun ala ez.<br />\n<br />\nEskerrik asko gure eskaera kontuan hartzeagatik.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nEbaluazioa egiteko gidalerroak<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Mezu hau Ataleko editoreak bidaltzen dio Ebaluatzaile bati, artikulu bat ebaluatzea onartuko duen ala ez galdetzeko. Artikulua ere bidaltzen da mezuari erantsita. Mezu hau erabiltzen da aldizkariaren Konfigurazioko 2. urratsean "Eranskina bidali Ebaluazio-prozesuan" hautatzen denean. (Bestela, ikus REVIEW_REQUEST).'),
('REVIEW_REQUEST_ATTACHED', 'fa_IR', 'درخواست داوری مقاله', '{$reviewerName}:<br />\n<br />\nشما به عنوان یک داور برای بررسی مقاله &quot;{$submissionTitle}&quot; انتخاب شده اید. در ذیل، چکیده مقاله ارسالی برای شما گنجانده شده است و امیدوارم که در این زمینه مایل به همکاری با این مجله باشید.<br />\nدر ذیل متن راهنمای کارشناسی برای این مجله آمده است و مقاله ارسالی به این ایمیل پیوست شده است. توجه داشته باشید که باید متن کارشناسی و توصیه خود را تا تاریخ {$reviewDueDate} از طریق ایمیل ارسال کنید.<br />\n<br />\nلطفا با پاسخ دادن به این ایمیل قبل از تاریخ &amp;lt;{$reviewDueDate}&amp;gt; مشخص سازید که آیا قادر به انجام کارشناسی هستید یا خیر؟<br />\nاز توجه شما به این درخواست سپاسگزارم.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\nراهنمای داوری<br />\n<br />\n{$reviewGuidelines}', 'ایمیلی از طرف دبیر یا دبیر بخش به داور برای درخواست انجام داوری'),
('REVIEW_REQUEST_ATTACHED', 'fi_FI', 'Artikkelin arviointipyyntö', 'Hyvä {$reviewerName},<br />\n<br />\nUskon, että sopisitte erinomaisesti käsikirjoituksen &quot;{$submissionTitle}&quot; arvioijaksi, ja pyydänkin, että harkitsette ryhtyvänne tähän meille tärkeään tehtävään. Julkaisumme arviointiohjeet löytyvät tämän sähköpostin lopusta ja käsikirjoitus on liitteenä. Arviointinne sekä suosituksenne tulisi lähettää minulle sähköpostitse {$reviewDueDate} mennessä.<br />\n<br />\nIlmoittakaa pystyttekö ja haluatteko suorittaa arvioinnin vastaamalla tähän viestiin {$responseDueDate} mennessä.<br />\n<br />\nKiitos, että harkitsette arviointiin ryhtymistä.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nArviointiohjeet<br />\n<br />\n{$reviewGuidelines}<br />\n', 'This email is sent by the Section Editor to a Reviewer to request that they accept or decline the task of reviewing a submission. It includes the submission as an attachment. This message is used when the Email-Attachment Review Process is selected in Management > Settings > Workflow > Review. (Otherwise see REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'fr_CA', 'Demande d''évaluation d''un article', '{$reviewerName},<br />\n<br />\nNous croyons que vous feriez un-e excellent-e évaluateur-trice pour le manuscrit intitulé « {$submissionTitle} ». Nous espérons que vous envisagerez d''entreprendre cette tâche essentielle à la publication de la revue. Les directives d''évaluation de la revue se trouvent ci-dessous et la soumission est jointe au présent courriel. Votre évaluation de la soumission, ainsi que vos recommandations, devraient nous parvenir par courriel d''ici le {$reviewDueDate}.<br />\n<br />\nVeuillez nous faire savoir par courriel d''ici le {$responseDueDate} si vous acceptez ou non d''effectuer cette évaluation.<br />\n<br />\nNous vous remercions de l''attention que vous porterez à notre demande.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nDirectives pour l''évaluation<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Ce courriel est envoyé par le,la rédacteur-trice de rubrique à un,une évaluateur-trice pour lui demander s''il ou elle accepte ou refuse la tâche d''évaluation d''une soumission. Il inclut la soumission en pièce jointe. Ce message est utilisé quand le processus de « Demande d''évaluation par pièce-jointe de courriel » est sélectionné dans Configuration de la revue > Paramètres > Flux des travaux > Évaluation . (Autrement, voir « Demande d''évaluation ».)'),
('REVIEW_REQUEST_ATTACHED', 'fr_FR', 'Demande d''évaluation d''un article', '{$reviewerName},<br />\n<br />\nNous croyons que vous feriez un excellent évaluateur ou une excellente évaluatrice pour le manuscrit intitulé « {$submissionTitle} ». Nous espérons que vous envisagerez d''entreprendre cette tâche essentielle à la publication de la revue. Les directives d''évaluation de la revue se trouvent ci-dessous et la soumission est jointe au présent courriel. Votre évaluation de la soumission, ainsi que vos recommandations, devraient nous parvenir par courriel d''ici le {$reviewDueDate}.<br />\n<br />\nVeuillez nous faire savoir par courriel d''ici le {$responseDueDate} si vous acceptez ou non d''effectuer cette évaluation.<br />\n<br />\nNous vous remercions de l''attention que vous porterez à notre demande.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nDirectives pour l''évaluation<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Ce courriel est envoyé par le Rédacteur de rubrique à un Rapporteur pour lui demander s''il accepte ou refuse la tâche d''évaluation d''une soumission. Il inclut la soumission en pièce jointe. Ce message est utilisé quand le processus de « Demande d''évaluation par courriel » est sélectionné à l''Étape 2 de la Configuration de la revue. (Autrement, voir « Demande d''évaluation ».)'),
('REVIEW_REQUEST_ATTACHED', 'gd_GB', 'Iarrtas airson lèirmheas artaigil', '{$reviewerName}:<br />\n<br />\nTha mi a’ creidsinn gum biodh tu fìor mhath mar lèirmheasaiche airson na sgrìobhainn “{$submissionTitle}” agus bhiomaid fada nad chomain nam b’ urrainn dhut an obair chudromach seo a dhèanamh dhuinn. Gheibh thu riaghailtean lèirmheas an iris-leabhair seo gu h-ìosal agus tha an tagradh ceangailte ris a’ phost-d seo. Bu chòir dhut lèirmheas an tagraidh agus do mholaidhean a chur thugam ron {$reviewDueDate}.<br />\n<br />\nNach cuir thu post-d thugam ron {$responseDueDate} a dh’innse dhomh an urrainn dhut an lèirmheas a dhèanamh?<br />\n<br />\nMòran taing airson an t-iarrtas seo a thoirt fa-near.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nStiùireadh airson lèirmheasan<br />\n<br />\n{$reviewGuidelines}<br/>\n', 'Thèid am post-d seo a chur gu lèirmheasaiche le deasaiche earrainn a dh’fhaighneachd an gabh iad ri lèirmheas air tagradh no an diùlt iad e. Tha seo a’ gabhail a-staigh an tagraidh mar cheanglachan. Seo an teachdaireachd a thèid a chleachdadh nuair a thaghar am pròiseas lèirmheis le ceanglachan puist-d fo “Stiùireadh” > “Roghainnean” > “Sruth-obrach” > “Lèirmheas”. (Air neo faic REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'he_IL', 'בקשת סקירת מאמר', '{$reviewerName}:<br />\n<br />\nאני מאמין שתשמש סוקר מצוין על כתב היד, &quot;{$submissionTitle},&quot; ואני מבקש שתשקול לבצע משימה חשובה זו עבורנו. הנחיות הביקורת לכתב העת הזה מצורפות להלן, וההגשה מצורפת לדוא"ל זה. את הביקורת שלך על ההגשה, יחד עם המלצתך, יש לשלוח אלי בדוא"ל עד {$reviewDueDate}.<br />\n<br />\nנא לציין בדוא"ל חוזר עד {$responseDueDate} באם אם אתה מסוגל ומוכן לבצע את הביקורת.<br />\n<br />\nתודה על עזרתך.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nהנחיות הביקורת<br />\n<br />\n{$reviewGuidelines}<br />\n', 'דוא"ל זה נשלח על ידי עורך המדור לבודק בבקשה לקבל או לדחות את משימת בדיקת ההגשה. זה כולל את ההגשה כקובץ מצורף. הודעה זו משמשת כאשר נבחר תהליך בדיקת קבצים מצורפים לדוא"ל בניהול> הגדרות> זרימת עבודה> סקירה. (אחרת ראה REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'hi_IN', 'लेख समीक्षा का अनुरोध', '{$reviewerName}:<br />\n<br />\nमुझे विश्वास है कि आप पांडुलिपि के एक उत्कृष्ट समीक्षक के रूप में काम करेंगे, &quot;{$submissionTitle},&quot; और मैं पूछ रहा हूं कि आप हमारे लिए इस महत्वपूर्ण कार्य को करने पर विचार कर रहे हैं। इस जर्नल के लिए समीक्षा दिशानिर्देश नीचे संलग्न हैं, और प्रस्तुत इस ईमेल से जुड़ा हुआ है। प्रस्तुत करने की आपकी समीक्षा, आपकी सिफारिश के साथ, मेरे द्वारा ईमेल की जानी चाहिए {$reviewDueDate}.<br />\n<br />\nकृपया {$ responseDueDate} द्वारा वापसी ईमेल में इंगित करें कि क्या आप समीक्षा करने में सक्षम और इच्छुक हैं।<br />\n<br />\nइस अनुरोध पर विचार करने के लिए धन्यवाद।<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nReview Guidelines<br />\n<br />\n{$reviewGuidelines}<br />\n', 'यह ईमेल अनुभाग संपादक द्वारा एक समीक्षक को यह अनुरोध करने के लिए भेजा जाता है कि वे सबमिशन की समीक्षा करने के कार्य को स्वीकार या अस्वीकार करें। इसमें अनुलग्नक के रूप में सबमिशन शामिल है। इस संदेश का उपयोग तब किया जाता है जब ईमेल> अनुलग्नक समीक्षा प्रक्रिया प्रबंधन> सेटिंग्स> वर्कफ़्लो> समीक्षा में चुनी जाती है। (अन्यथा REVIEW_REQUEST देखें।)'),
('REVIEW_REQUEST_ATTACHED', 'hr_HR', 'Zamolba za recenziju članka u privitku', 'Poštovana/i {$reviewerName},<br />\n<br />\ns obzirom na vaše iskustvo i područje ekspertize, rado bismo vam povjerili zadatak recenzije članka &quot;{$submissionTitle}&quot; prijavljenog u naš časopis. Nadamo se da ćete prihvatiti našu ponudu te izvršiti ovu, za nas iznimno važnu, zadaću.<br />\nU nastavku teksta poruke nalaze se upute za recenzente našeg časopisa, a tekst članka nalazi se u prilogu. Od vas očekujemo da nam vašu recenziju članka, zajedno s preporukom dostavite e-poštom zaključno s {$reviewDueDate}.<br />\n<br />\nNo prije svega, molimo vas da nam u odgovoru na ovu poruku e-poštom zaključno s datumom {$responseDueDate} naznačite da li ste u mogućnosti i da li ste voljni izvršiti recenziju<br />\n<br />\nSrdačno,<br />\n{$editorialContactSignature}<br />\n<br />\nUpute za recenzente<br />\n<br />\n{$reviewGuidelines}', 'Ovim obrascem e-pošte urednik rubrike šalje upit recenzentu može li prihvatiti ili je prisiljen odbiti zadatak recenziranja članka. Zamolba sadrži i tekst članka u privitku. Ova poruka se koristi kada je u 2. koraku Postavljanja časopisa odabran recenzijski postupak u kojem se prilog šalje recenzentu kao privitak e-pošte. (Ako ne, pogledajte Zamolba za recenziju članka.)'),
('REVIEW_REQUEST_ATTACHED', 'hu_HU', 'Cikk lektorálás kérése', 'Tisztelt {$reviewerName}!<br />\n<br />\nSzeretném felkérni a(z) &quot;{$submissionTitle},&quot; című kézirat szakmai lektorálására.<br />\nA lektorálási útmutatót levelünk végén, a kéziratot pedig csatoltan találja. A kézirattal kapcsolatos szakértői véleményét és javaslatait, kérem emailben küldje meg részemre {$reviewDueDate}-ig.<br />\n<br />\nKérem, jelezze válasz emailben legkésőbb {$responseDueDate}-ig, hogy vállalja-e a lektorálást.<br />\n<br />\nEgyüttműködését előre is köszönjük.<br />\n<br />\nKöszönettel,<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nLektorálási útmutató:<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Ezt az emailt a Rovatszerkesztő küldi a Lektornak, megkérve, hogy vállalja el, vagy, ha nem alkalmas, akkor utasítsa el a beküldött anyag lektori feladatát. A levél csatoltan tartalmazza a kéziratot. Ez az üzenet akkor kerül használatra, ha az email csatolmány lektorálási folyamat van kiválasztva a folyóirat menedzselése részben > Beállítások > Munkafolyamat > Szakmai lektorálás. (Máskülönben lásd a REVIEW_REQUEST-et.)'),
('REVIEW_REQUEST_ATTACHED', 'id_ID', 'Permohonan Review Artikel', '{$reviewerName}:<br />\n<br />\nKami memandang bahwa Anda merupakan reviewer yang tepat untuk naskah, &quot;{$submissionTitle},&quot; dan kami mengharapkan Anda berkenan melakukan review. Panduan Review untuk jurnal ini disertakan di bawah, dan naskah telah dilampirkan bersama email ini. Review beserta rekomendasi Anda, kami harap telah diemailkan sebelum tenggat review {$reviewDueDate}.<br />\n<br />\nMohon sampaikan dalam email balasan sebelum {$responseDueDate} tentang kesediaan Anda untuk melakukan review.<br />\n<br />\nTerimakasih atas perhatiannya.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nPanduan Review<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Email ini dari Editor Bagian kepada Reviewer untuk meminta reviewer memberitahukan apakah menerima atau menolak permohonan review. Email disertai naskah terlampir bersama email. Pesan ini digunakan saat Proses Review Lampiran Email dipilih di Manajemen > Pengaturan > Alur Kerja > Review. (Selain itu lihat REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'it_IT', 'Richiesta di revisione di un articolo', 'Gentilissimo {$reviewerName}:<br />\n<br />\nDesidero invitarti alla revisione del manoscritto &quot;{$submissionTitle}&quot;.<br />\nLe linee guida per la revisione sono indicate sotto e il manoscritto è allegato.<br />\n<br />\nPuoi comunicarmi il tuo parere per email entro il {$reviewDueDate}.<br />\n<br />\nTi chiedo di farmi sapere entro il {$responseDueDate} se accetti o meno l''incarico di revisione.<br />\n<br />\nGrazie per la tua collaborazione<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nLinee guida per le revisioni<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Questa email viene inviata dal section editor al revisore richiedendo a quest''ultimo di accettare o rifiutare il compito di revisionare una proposta. Include la submission come allegato. Questo messaggio è usato il processo di revisione degli allegati Email è selezionato nel Journal Setup, fase 2. (Altrimenti vedi RICHIESTA_REVISIONE.)'),
('REVIEW_REQUEST_ATTACHED', 'ja_JP', '論文査読のお願い', '{$reviewerName}様<br />\n<br />\n雑誌『{$contextName}』への投稿原稿「{$submissionTitle}」の査読をお願いいたしたくメールを差し上げました。貴殿がこの重要な仕事を引き受けてくださることをお願いいたしております。この雑誌の査読の手引きを以下に添付しました。また、投稿物はメールの添付ファイルとしてお送りいたしました。投稿物の査読結果と答申は、{$reviewDueDate}までに私宛にメールでいただきたいと考えております。<br />\n<br />\n査読をしていただけるか否かを、{$responseDueDate}までにメールでご返事いただけるようお願いいたします。\n<br />\nよろしくご検討くださるよう、お願いいたします。<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\n査読の手引き<br />\n<br />\n{$reviewGuidelines}<br />\n', 'このメールは、セクションエディタから査読者に投稿物の査読を依頼するものです。メールには、査読物をファイルで添付します。このメールは、雑誌設定のステップ2でメール添付による査読プロセスが選択された場合に使用されます（そうでない場合は、REVIEW_REQUESTを参照してください）。'),
('REVIEW_REQUEST_ATTACHED', 'ku_IQ', 'داواکاریی هەڵسەنگاندنی توێژینەوە', '{$reviewerName}:<br />\n<br />\n من پێم وایە کە بەڕێزت کەسێکی گونجاویت بۆ هەڵسەنگاندنی ئەم توێژینەوەیە.&quot;{$submissionTitle},&quot; aهەر بۆیە من داواتان لێ دەکەم کە ئەرکی هەڵسەنگاندنەکە لە ئەستۆ بگرن. ڕێنماییەکانی هەڵسەنگاندن لە خوارەوە بەردەست و پێشکەشکردنەکەش لەگەڵ ئەم ئیمەیڵە دەنێردرێت. هەڵسەنگاندن و تێبینییەکانت هەتا  {$reviewDueDate} دەبێت بنێردرێنەوە بۆ گۆڤار.<br />\n<br />\nتکایە لە وەڵامدا لێرەوە {$responseDueDate} هەڵسەنگاندنەکە قبوڵ یان ڕەت بکەوە<br />\n<br />\nسوپاس بۆ هاوکاریتان.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nڕێنماییەکانی هەڵسەنگاندن<br />\n<br />\n{$reviewGuidelines}<br />\n', 'ئەم ئیمەیڵە لە لایەن سەرنوسەری بەشەوە بۆ هەڵسەنگێنەر دەنێردرێت بۆ ئەوەی هەڵسەنگاندنی توێژینەوەکە قبوڵ یان ڕەت بکاتەوە. هەروەها، توێژینەوەکە هاوپێچ کراوە. ئەم نامەیە بەکار دێت کاتێک پرۆسەی هەڵسەنگاندن بەم شێوەیە دەستنیشان بکرێت بەڕێوەبردن/ ڕێکخستنەکان/ ڕێڕەوی کار/ هەڵسەنگاندن. (بە پێچەوانەوە، سەیری REVIEW_REQUEST بکە.)'),
('REVIEW_REQUEST_ATTACHED', 'mk_MK', 'Барање за рецензија на наслов', '{$reviewerName}:<br />\n<br />\nВерувам дека би биле одличен рецензент на трудот, &quot;{$submissionTitle},&quot; и ве замолувама да размислите да ја преземете оваа важна задача за нас. Директивите за рецензија на ова списание се додадени подолу, и поднесокот е прикачен на овој и-меил. Вашата рецензија на поднесокот, заедно со вашата препорака, треба да ми ги испратите преку и-меил до {$reviewDueDate}.<br />\n<br />\nВе молам да наведете во повратен и-меил до {$responseDueDate}дали сте способни и подготвени да ја извршите рецензијата.<br />\n<br />\nВи благодариме што го земавте во предвид ова барање.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nДирективи за рецензија<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Овој и-меил е испратен од Секцискиот уредник до Рецензент за да побараат тие да ја прифатат или одбијат задачата за рецензирање на поднесок. Го вклучува поднесокот во прилог. Оваа порака се користи кога Процес на рецензија со и-меил прилог е одбрано во Раководење > Поставки > Тек на рабоатата > Рецензија. (Во спротивно погледнете REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST_ATTACHED', 'nb_NO', 'Forespørsel om fagfellevurdering', '{$reviewerName}:<br />\n<br />\nVårt tidsskrift {$contextName} har fått tilsendt innleveringen &quot;{$submissionTitle}&quot;. Vi håper du er villig til å vurdere manuskriptet, fordi vi tror du har rett faglig kompetanse. Tidsskriftets retningslinjer for fagfellevurdering følger nedenfor. Artikkelen er vedlagt. Dersom du tar på deg oppdraget, sender du fagfellevurderingen og anbefalingen din til meg via e-post. Fristen for dette er i tilfelle {$reviewDueDate}.<br />\n<br />\nVi hadde satt pris på om du kunne gi beskjed innen {$responseDueDate} om du kan ta på deg oppdrage eller ikket.<br />\n<br />\nTakk for at du overveier denne forespørslen.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nRetningslinjer for fagvurdering<br />\n<br />\n{$reviewGuidelines}<br />\n', 'I denne e-posten ber seksjonsredaktøren en fagfelle om å akseptere eller avslå oppdraget med å fagfellevurdere en innlevering, som er vedlagt. Denne e-posten brukes når «Fagvurdering med e-post-vedlegg» er valgt i Innstillinger > Arbeidsflyt > Fagfellevurdering  (Ellers: se REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'nl_NL', 'Artikel review verzoek', '{$reviewerName}:<br />\n<br />\nIk geloof dat u een excellente reviewer zou zijn voor het manuscript &quot;{$submissionTitle}&quot; en ik wil u vragen om te overwegen deze belangrijke taak voor ons uit te voeren. De review richtlijnen voor dit tijdschrift staan hieronder en de inzending is als bijlage meegestuurd. Uw review van de inzending en uw aanbeveling zou naar mij gemaild moeten zijn op {$reviewDueDate}.<br />\n<br />\nWilt u voor {$responseDueDate} in een retourbericht aangeven of u bereid en in staat bent om deze review te doen.<br />\n<br />\nDank u voor het overwegen van dit verzoek.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nReview richtlijnen<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Deze e-mail van de sectieredacteur aan een reviewer vraagt aan de reviewer een review te accepteren of te weigeren. De inzending wordt als bijlage meegestuurd. Dit bericht word gebruikt wanneer het e-mail attachment reviewproces is geselecteerd in stap 2 van het inrichten van het tijdschrift (zie verder REVIEW_REQUEST_ATTACHED)'),
('REVIEW_REQUEST_ATTACHED', 'pl_PL', 'Prośba o wykonanie recenzji tekstu', '{$reviewerName}:<br />\n<br />\nredakcja czasopisma zwraca się do Pani/ Pana z prośbą o wykonanie recenzji tekstu &quot;{$submissionTitle}&quot; Poniżej zamieszczamy opis procedury recenzowania, a w załączeniu przesyłamy plik z tekstem do zrecenzowania. Będziemy wdzięczni za wykonanie recenzji i przesłanie jej pod ten adres do dnia {$reviewDueDate}.<br />\n<br />\nProsimy o rozważenie naszej prośby i nadesłanie informacji zwrotnej (o jej przyjęciu lub odrzuceniu) do dnia {$responseDueDate}.<br />\n<br />\nZ wyrazami szacunku, <br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nProcedura recenzowania <br />\n<br />\n{$reviewGuidelines}<br />\n', 'Wiadomość od redaktora prowadzącego do recenzenta. Zawiera załączony artykuł. Ta wiadomość jest wykorzystywana w procesie recenzji opartym o załączniki'),
('REVIEW_REQUEST_ATTACHED', 'pt_BR', 'A revista {$contextName} solicita avaliação de artigo', '{$reviewerName}:<br />\n<br />\nEu acredito que você seria um ótimo(a) parecerista para o manuscrito, &quot;{$submissionTitle},&quot; e estou pedindo que considere aceitar esta importante tarefa para nós. As Diretrizes de Avaliação deste periódico seguem abaixo, e a submissão está anexa ao email. Sua avaliação da submissão, junto à sua recomendação, devem ser enviadas por email para mim até {$reviewDueDate}.<br />\n<br />\nPor gentileza, indique se você aceita dar o parecer ou não por e-mail até {$responseDueDate}.<br />\n<br />\nObrigado por considerar este pedido.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nDiretrizes de Avaliação<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Este email é enviado pelo Editor de Seção para um Avaliador solicitando que ele aceite ou decline a tarefa de dar um parecer para uma submissão. A submissão é enviada anexada ao e-mail. A mensagem é utilizada quando o Processo de Avaliação por Anexo de E-mail é selecionado em Gerenciamento > Configurações > Fluxo de Trabalho > Avaliação. (Alternativamente veja REVIEW_REQUEST)'),
('REVIEW_REQUEST_ATTACHED', 'pt_PT', 'Pedido de revisão de artigo', '{$reviewerName},<br />\n<br />\nAcreditamos que o seu conhecimento será valioso para realizar a revisão do manuscrito, &quot;{$submissionTitle}&quot; e esperamos que considere assumir esta importante tarefa. As Instruções para Revisão encontram-se no final desta mensagem, e o manuscrito encontra-se em anexo. O prazo para entrega da revisão e as suas recomendações é {$reviewDueDate}.<br />\n<br />\nResponda se está disponível para efetuar ou não esta revisão até {$responseDueDate} .<br />\n<br />\nAgradecemos desde já a resposta a este pedido.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nInstruções para Revisão<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Este e-mail é enviado pelo Editor de Secção para o Revisor a solicitar que aceite ou recuse a tarefa de rever um artigo. Inclui a submissão como anexo. Esta mensagem é usada quando o Processo de revisão de anexos de e-mail está selecionado em Configurações > Fluxo de trabalho > Revisão. (Caso contrário, veja REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'ro_RO', 'Rugăminte revizuire articol', '{$reviewerName}:<br />\n<br />\nEvaluarea manuscrisului &quot;{$submissionTitle},&quot; efectuată de dumneavoastră, este foarte importă pentru noi. Ghidurile de revizuire pentru această revistă sunt anexate mai jos, iar manuscrisul este atașat la acest e-mail. Revizia împreună cu recomandarea dvs., ar trebui să le primim prin e-mail până la data de {$reviewDueDate}.<br />\n<br />\nVă rugăm astfel, ca printr-un email de răspuns să ne spuneți dacă întâmpinați probleme în revizuirea acestui manuscris, sau aveți nevoie de timp suplimentar<br />\n<br />\nVă mulțumim că luați  în considerare această solicitare.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nGhidul re revizuire<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Acest e-mail este trimis de către editorul de secțiuni unui revizor pentru a solicita ca acesta să accepte sau să refuze examinarea unui manuscris. Include manuscrisul în atașament. Acest mesaj este utilizat atunci când procesul de examinare a manuscrisului prin e-mail este selectat în Management> Setări> Flux de lucru> Revizuire. (În caz contrar, consultați REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'ru_RU', 'Запрос на рецензирование статьи', 'Здравствуйте, {$reviewerName}!<br />\n<br />\nЯ полагаю, что Вы могли бы быть прекрасным рецензентом для материала «{$submissionTitle}» и прошу Вас взяться выполнить эту важную задачу для нас. Руководство для рецензентов этого журнала добавлено ниже, материал для рецензирования приложен к этому письму. Ваша рецензия на материал, вместе с рекомендацией, должны быть отправлены мне электронной почтой до {$reviewDueDate}.<br />\n<br />\nПожалуйста, сообщите в ответном письме до {$responseDueDate} сможете ли Вы взяться за рецензирование.<br />\n<br />\nЗаранее благодарю Вас,<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nРуководство для рецензентов<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Это письмо редактора раздела, отправляемое рецензенту, с запросом согласия или отказа от выполнения рецензирования материала. К письму приложен сам материал для рецензирования. Это сообщение используется, если выбран процесс рецензирования через электронную почту в Управление > Настройки > Рабочий процесс > Рецензирование. (В ином случае, смотрите REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'sk_SK', 'Žiadosť o spracovanie recenze článku', '{$reviewerName}:<br />\n<br />\nDomnievam sa, že by ste mohol byť výborným recenzentom príspevku &quot;{$submissionTitle}&quot; a žiadam Vás, aby ste zvážil možnosť prijatia tejto pre nás dôležitej úlohy. Inštrukcie pre spracovanie recenzie pre tento časopis sú pripojené nižšie a príspevok je priložený k tomuto emailu. Vašu recenziu príspevku spolu s Vašim odporúčaním by ste mi mal zaslať emailom do {$reviewDueDate}.<br />\n<br />\nUveďte prosím do {$responseDueDate} v odpovedi na tento email, či môžete a chcete spracovať túto recenziu.<br />\n<br />\nĎakujeme za zváženie tejto žiadosti.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nInštrukcie pre spracovanie recenzie<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Tento email od editora sekcie pre recenzenta žiada, aby recenzent prijal alebo odmietol úlohu spracovať recenziu príspevku. Obsahuje príspevok ako prílohu. Táto správa je používaná, pokiaľ je zvolené Recenzií riadenie vyžívajúce emailových príloh v druhom kroku  Nastavenie časopisu. (V inom prípade pozri REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'sl_SI', 'Prošnja za recenzijo prispevka', '{$reviewerName}:<br />\n<br />\nVerjamem, da bi lahko bili odličen recenzent rokopisa, &quot;{$submissionTitle},&quot; in vas prosim, če lahko naredite to nalogo, ki je pomembna za nas. Spodaj so navodila za recenzijo za našo revijo, v priponki pa je prispevek. Vašo recenzijo, skupaj s priporočilom, bi mi morali poslati po e-pošti do {$reviewDueDate}.<br />\n<br />\nProsim, če mi po e-pošti sporočite do {$responseDueDate}, če ste pripravljeni narediti to recenzijo ali ne.<br />\n<br />\nHvala lepa za sprejetje prošnje.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nNavodila za recenzijo<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Ta email pošilja urednik rubrike recenzentu s prošnjo, da recenzent potrdi ali zavrne oipravljanje recenzije. Vsebuje prispevek v priponki. Email se uporablja, ko je v nastavitvah izbran "Email-attached" recnezijski proces (Upravljanje > Nastavitve > Potek dela > Recenzija). (v nasprotnem primeru glej REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'sv_SE', 'Förfrågan om granskning av artikel', '{$reviewerName}:<br />\n<br />\nJag tror att du skulle passa utmärkt som sakkunniggranskare av manuskriptet &quot;{$submissionTitle}&quot; och detta är en förfrågan om du skulle vara villig att ta dig an den här viktiga uppgiften åt oss. Tidskriftens Riktlinjer för granskare bifogas här nedan, och bidraget finns som bilaga i det här e-postmeddelandet. Din bedömning av bidraget ska tillsammans med din rekommendation skickas per e-post till mig senast {$reviewDueDate}.<br />\n<br />\nVänligen meddela mig genom att svara på det här meddelandet senast {$responseDueDate} om du har möjlighet att åta dig uppdraget eller inte.<br />\n<br />\nTack för att du överväger granskningsuppdraget.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nRiktlinjer för granskare:<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Det här e-postmeddelandet från sektionsredaktören till en granskare ber granskaren att acceptera eller tacka nej till uppdraget att sakkunniggranska ett bidrag. Det innehåller bidraget som bifogad fil. Det här e-postmeddelandet används när granskningsprocess med e-postbilaga är valt i > Inställningar > Arbetsflöde > Granskning. (Annars, se REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'tr_TR', 'Makale Değerlendirme İsteği', 'Sayın {$reviewerName},<br />\n<br />\nDergimizde yayınlanmak üzere gönderilen &quot;{$submissionTitle}&quot; başlıklı makaleyi değerlendiremek için uygun hakemlerden birisi olarak, yazı hakkındaki değerli görüşlerinizi bize ileteceğinizi umuyoruz. Yazı e-posta ekinde gönderilmiştir ve dergimizin hakemlerimizden beklentileri aşağıda verilmiştir. Dergimiz için çok değerli olan görüşlerinizi bizimle paylaşacağınızı umuyoruz. Değerlendirme raporunuzun {$reviewDueDate} tarihine kadar gönderilmiş olması gerekmektedir.<br />\n<br />\nLütfen değerlendirmeyi kabul edip, etmediğinizi {$responseDueDate} tarihine kadar e-posta mesajı ile bildiriniz.<br />\n<br />\nKatkılarınız için şimdiden teşekkür ederiz.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nDeğerlendirme Rehberi:<br />\n<br />\n{$reviewGuidelines}\n', 'Yazının hakemlere önerilmesi için kullanılan mesajdır. Ayarlarda e-posta eki ile değerlendirme seçeneği seçili ise kullanılacaktır.'),
('REVIEW_REQUEST_ATTACHED', 'uk_UA', 'Запит на рецензування статті', '{$reviewerName}:<br />\n<br />\nЯ вірю, що Ви могли б стати прекрасним рецензентом для рукопису &quot;{$submissionTitle}&quot; та прошу Вас розглянути можливість виконання цієї важливої роботи для нас. Нижче Ви знайдете керівництво для рецензентів, яке використовується нашим журналом. Саме подання я надсилаю у додатку до цього листа. Ваша рецензія разом з Вашою рекомендацією повинна бути надіслана мені до {$reviewDueDate}.<br />\n<br />\nБудь ласка, до {$responseDueDate} повідомте мені листом, чи згодні Ви працювати над цією рецензією.<br />\n<br />\nДякую, що розглянули цей запит.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nКерівництво для рецензентів<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Цим листом редактор розділу просить рецензента відрецензувати подання або відмовитись від цієї роботи. Лист містить файл подання у додатку. Цей шаблон використовується, якщо на кроці 2 Налаштування журналу обраний Процес рецензування вкладень до листів (у іншому випадку див. REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'vi_VN', 'Yêu cầu đánh giá bài báo', 'Kính gửi {$reviewerName},<br />\n<br />\nTôi tin rằng bạn là người phản biện phù hợp cho bản thảo, &quot;{$submissionTitle},&quot; và tôi đang yêu cầu bạn xem xét thực hiện nhiệm vụ quan trọng này cho chúng tôi. Hướng dẫn phản biện cho tạp chí này được thêm vào bên dưới và bài gửi được đính kèm với email này. Đánh giá của bạn về bài gửi, cùng với khuyến nghị của bạn, nên được gửi qua email cho chúng tôi trước ngày {$reviewDueDate}.<br />\n<br />\nXin cho biết trong một email phản hồi trước ngày {$responseDueDate} cho dù bạn có thể và sẵn sàng thực hiện đánh giá.<br />\n<br />\nCảm ơn bạn đã xem xét yêu cầu này.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nReview Guidelines<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Email này được gửi bởi Biên tập viên chuyên mục tới một phản biện để yêu cầu họ chấp nhận hoặc từ chối nhiệm vụ phản biện bài gửi. Nó bao gồm các bài gửi như một tập tin đính kèm. Thông báo này được sử dụng khi Quy trình phản biện đính kèm email được chọn trong Quản lý > Cài đặt > Quy trình làm việc > Phản biện. (Nếu không, hãy xem REVIEW_REQUEST.)'),
('REVIEW_REQUEST_ATTACHED', 'zh_CN', '邀请您审查稿件', '{$reviewerName}:<br />\n<br />\n我相信您是投稿到本期刊之稿件〈{$submissionTitle}〉的最佳审查人选，而我们希望您会考虑进行这份对我们来说相当重要的一个工作。该份期刊的审查指引已经附列如下，而稿件随附在这封电子邮件的附加档案之中。如果您接受这份审查工作，麻烦您在{$reviewDueDate}之前，将您对这份稿件的审查意见书以及编辑建议寄给我们。<br />\n<br />\n无论您是否接受审查工作与否，都请在{$responseDueDate}之内回复此封电子邮件给我们，告知我们您是否愿意进行审查工作。<br />\n<br />\n非常感谢您考虑我们的邀请。<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\n审查指引<br />\n<br />\n{$reviewGuidelines}', '这封电子邮件是由区段编辑寄发给审查人一份邀请函，询问审查人接受或婉谢一份稿件的审查工作。邮件中含有一份稿件的附加档案。在「期刊设定」之步骤2中选择「电邮附件审查流程」选项时，才会用到这份消息。(否则请见：REVIEW_REQUEST。)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'ar_IQ', 'إلتماس تحكيم مؤلَّف', '{$reviewerName}:<br />\n<br />\nالأمر يتعلق بالمؤلَّف الموسوم &quot;{$submissionTitle},&quot; الذي هو قيد المعالجة من قبل {$contextName}.<br />\n<br />\nبالنظر إلى التنقيحات المؤشرة على النسخة السابقة من المؤلَّف، قدم المؤلف/المؤلفون الآن نسخة منقحة من أوراقهم. نكون شاكرين لتعاونك معنا في تقييمها.<br />\n<br />\nإن دليل عمل المحكم في مجلتنا مضمن في أدنى الرسالة، وإن طلب النشر المذكور مرفق بها. إن تحكيمك لهذا المؤلَّف مع توصياتك بشأنه ينبغي إرسالها لي عبر البريد الالكتروني قبل يوم {$reviewDueDate}.<br />\n<br />\nلطفاً، بين عبر ردك على هذه الرسالة حتى يوم {$responseDueDate} مدى قدرتك وقبولك القيام بهذا التحكيم.<br />\n<br />\nنشكر لك اهتمامك بالتماسنا هذا.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nدليل عمل المحكم<br />\n<br />\n{$reviewGuidelines}<br />\n', 'هذه الرسالة يعنونها محرر القسم إلى المحكم ليلتمس منه قبول أو رفض مهمة تحكيم المؤلَّف لمرة أخرى. وهي مرفقة بطلب النشر بشكل ملف. يتم استعمال هذه الرسالة عندما تكون عمية التحكيم مبنية على أساس التراسل عبر البريد الالكتروني خلال تهيئة إعدادات المجلة ضمن: الإعدادات، المخطط الانسيابي، التحكيم. (بخلاف ذلك، أنظر REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'ca_ES', 'Sol·licitud de revisió d''article', '{$reviewerName}:<br />\n<br />\nUs contactem en referència al manuscrit &quot;{$submissionTitle},&quot; que està essent estudiat per {$contextName}.<br />\n<br />\nDesprés de la revisió de la versió prèvia del manuscrit, els autors/ores han enviat una versió revisada del seu article. Us agrairíem que ens ajudéssiu a avaluar-la.<br />\n<br />\nLes directrius de revisió d''aquesta revista s''annexen a sota i l''article s''adjunta en aquest correu electrònic. Hauríeu d''enviar-nos la vostra revisió, juntament amb la recomanació, abans del {$reviewDueDate}.<br />\n<br />\nSi us plau, contesteu aquest correu electrònic abans del {$responseDueDate} per dir-nos si esteu disponible i sou capaç de fer aquesta revisió.<br />\n<br />\nGràcies per considerar aquesta sol·licitud.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nReview Guidelines<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Aquest correu electrònic de l''editor/a de secció a un revisor/a sol·licita que el revisor/a accepti o rebutgi la tasca de revisió d''una tramesa per a una segona, o posterior, ronda de revisió. El correu inclou l''article com a adjunt. Aquest missatge s''utilitza quan el procés de revisió d''adjunt de correu electrònic s''ha seleccionat a Gestió > Configuració > Flux de treball > Revisió. (Si no consulteu REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'cs_CZ', 'Požadavek na recenzi článku', '{$reviewerName}:<br />\n<br />\nTento email se týká rukopisu &quot;{$submissionTitle},&quot; předkládaného autorem {$contextName}.<br />\n<br />\nNa základě recenze předchozí verze rukopisu podali autoři nyní opravenou verzi tohoto článku. Byly bychom rádi, kdybyste nám pomohli tuto revidovanou verzi ohodnotit.<br />\n<br />\nPokyny pro recenzenty tohoto časopisu jsou připojeny níže, a samotný opravený příspěvek je vložen do tohoto emailu jako příloha. Vaše recenze opraveného příspěvku spolu s vašemi doporučeními by měla být odeslána emailem do {$reviewDueDate}.<br />\n<br />\nProsíme vás, abyste v odpovědi na tento email uvedl(a) do {$responseDueDate}, zda jste schopen(a) a ochoten(na) udělat tuto recenzi.<br />\n<br />\nDěkujeme předem za vaši ochotu.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nPokyny pro recenzenty<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Tento email je zaslán Editorem sekce recenzentovi, aby ho požádal o přijetí nebo odmítnutí opakované recenze příspěvku v druhém či dalším kole recenzního řízení. Zahrnuje příspěvek jako přílohu. Tato zpráva se používá v případě, že je v části Správa> Nastavení> Pracovní postup> Kontrola vybrána možnost Prověřování příloh emailu. (Jinak viz REVIEW_REQUEST_SUBSEQUENT.)');
INSERT INTO `email_templates_default_data` VALUES
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'da_DK', 'Forespørgsel om bedømmelse af artikel', '{$reviewerName}:<br />\n<br />\nDette omhandler manuskriptet &quot;{$submissionTitle},&quot; som behandles af {$contextName}.<br />\n<br />\nSom opfølgning på en tidligere bedømmelse af manuskriptet, har forfatterne indsendt en revideret version af deres indlæg. Vi vil sætte stor pris på din hjælp, hvis du vil foretage en bedømmelse af det.<br />\n<br />\nTidsskriftets retningslinjer for bedømmelser er tilføjet nedenfor og indlægget er vedhæftet denne e-mail. Din bedømmelse af indlægget sammen med din anbefaling bedes sendt til mig senest {$reviewDueDate}.<br />\n<br />\nDu bedes meddele os, om du vil påtage dig bedømmelsen eller ej senest {$responseDueDate}.<br />\n<br />\nTak for din overvejelse af denne forespørgsel.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nRetningslinjer for bedømmelser<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Denne mail sendes af sektionsredaktøren til en bedømmer, der bedes oplyse om vedkommende vil påtage sig at bedømme et indlæg i en anden eller senere bedømmelsesrunde. Det inkluderer indlægget som vedhæftet fil. Denne forespørgsel anvendes når man har valgt at sende bedømmelsen vedhæftet e-mailen under Indstillinger > Workflow > Bedømmelse. (Ellers see REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'de_DE', 'Bitte um ein Gutachten', '{$reviewerName},<br />\n<br />\ndiese E-Mail betrifft das Manuskript &quot;{$submissionTitle}&quot;, das bei {$contextName} in der Begutachtung ist.<br />\n<br />\nNach der Begutachtung der früheren Fassung des Manuskripts haben die Autor/innen nun eine überarbeitete Fassung ihres Artikels eingereicht. Wir würden uns freuen, wenn Sie bei der Beurteilung helfen könnten.<br />\n<br />\nDie Begutachtungsrichtlinien dieser Zeitschrift sind unten angehängt, und der Beitrag selber ist dieser E-Mail beigefügt. Ihr Gutachten zu diesem Beitrag sollte zusammen mit Ihrer Empfehlung mir per E-Mail bis zum {$reviewDueDate} zugehen.<br />\n<br />\nBitte teilen Sie uns in einer E-Mail bis zum {$responseDueDate} mit, ob Sie das Gutachten übernehmen können.<br />\n<br />\nIn der Hoffnung auf eine positive Antwort,<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nBegutachtungsrichtlinien<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Diese E-Mail wird von der/dem Rubrikredakteur/in an eine/n Gutachter/in gesendet, damit diese/r die Aufgabe, eine Einreichung in einer zweiten oder weiteren Begutachtungsrunde zu beurteilen, übernimmt oder ablehnt. Sie enthält die Einreichung als E-Mail-Anhang. Diese Nachricht wird benutzt, wenn in Schritt 2 des Zeitschriftensetups das Begutachtungsverfahren über E-Mail-Anhänge ausgewählt worden ist. (Ansonsten siehe  REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'el_GR', 'Αίτημα αξιολόγησης άρθρου', '{$reviewerName}:<br />\n<br />\nΤο παρόν μήνυμα αφορά την εργασία &quot;{$submissionTitle},&quot; που βρίσκεται υπό αξιολόγηση στο περιοδικό {$contextName}.<br />\n<br />\nΟι Συγγραφείς υπέβαλαν μία αναθεωρημένη έκδοση της εργασίας. Θα εκτιμούσαμε ιδιαίτερα τη συνδρομή σας στην αξιολόγησή της.<br />\n<br />\nΟι Οδηγίες Αξιολόγησης για το περιοδικό αυτό παρατίθενται παρακάτω και η υποβολή επισυνάπτεται στο παρόν μήνυμα. Η αξιολόγησή σας για την υποβολή μαζί με τις συστάσεις σας θα πρέπει να αποσταλούν με ηλεκτρονικό μήνυμα σε εμάς, μέχρι τις {$reviewDueDate}.<br />\n<br />\nΠαρακαλούμε ενημερώστε με ένα απαντητικό μήνυμα μέχρι τις {$responseDueDate} εάν μπορείτε και θέλετε να αναλάβετε την αξιολόγηση.<br />\n<br />\nΣας ευχαριστούμε εκ των προτέρων για την εξέταση του αιτήματός μας.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nΟδηγίες Αξιολόγησης<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Το παρόν αίτημα αξιολόγησης μιας υποβολής αποστέλλεται από τον Επιμελητή Ενότητας σε έναν Αξιολογητή για τον δεύτερο ή ακόλουθο κύκλο αξιολόγησης. Περιλαμβάνει την υποβολή ως επισυναπτόμενο αρχείο. Το συγκεκριμένο μήνυμα χρησιμοποιείται όταν έχει επιλεγεί η Διαδικασία Αξιολόγησης με Επισύναψη σε Ηλεκτρονικό Μήνυμα στη Διαχείριση > Ρυθμίσεις > Ροή εργασιών > Αξιολόγηση. (Σε διαφορετική περίπτωση ανατρέξτε στο REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'en_US', 'Article Review Request', '{$reviewerName}:<br />\n<br />\nThis regards the manuscript &quot;{$submissionTitle},&quot; which is under consideration by {$contextName}.<br />\n<br />\nFollowing the review of the previous version of the manuscript, the authors have now submitted a revised version of their paper. We would appreciate it if you could help evaluate it.<br />\n<br />\nThe Review Guidelines for this journal are appended below, and the submission is attached to this email. Your review of the submission, along with your recommendation, should be emailed to me by {$reviewDueDate}.<br />\n<br />\nPlease indicate in a return email by {$responseDueDate} whether you are able and willing to do the review.<br />\n<br />\nThank you for considering this request.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nReview Guidelines<br />\n<br />\n{$reviewGuidelines}<br />\n', 'This email is sent by the Section Editor to a Reviewer to request that they accept or decline the task of reviewing a submission for a second or greater round of review. It includes the submission as an attachment. This message is used when the Email-Attachment Review Process is selected in Management > Settings > Workflow > Review. (Otherwise see REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'es_ES', 'Solicitud de revisión de artículo', '{$reviewerName}:<br />\n<br />\nEste correo es en referencia al manuscrito &quot;{$submissionTitle},&quot;, que {$contextName} está considerando.<br />\n<br />\nDespués de la revisión de la versión previa del manuscrito, los autores/as han enviado una versión revisada de su artículo. Le agradeceríamos mucho si pudiera ayudarnos a evaluarla.<br />\n<br />\nLas normas de revisión de esta revista se pueden ver a continuación. Además, el artículo se adjunta en este correo electrónico. Debería enviarnos su revisión del envío, junto con su recomendación, antes del {$reviewDueDate}.<br />\n<br />\nPor favor, responda a este correo electrónico antes del {$responseDueDate} e indíquenos si puede y desea realizar esta revisión.<br />\n<br />\nGracias por considerar esta solicitud.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nNormas de revisión<br />\n<br />\n{$reviewGuidelines}<br />\n', 'El editor de sección envía este correo electrónico a un revisor para pedirle si acepta o rechaza la tarea de revisión de un artículo en segunda ronda. Este incluye el envío como adjunto. Este mensaje se usa cuando se selecciona el proceso de revisión de archivos adjuntos por correo electrónico en el paso 2 de la configuración de la revista. (Por lo demás, vea SOLICITUD_DE_REVISIÓN_POSTERIOR.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'eu_ES', 'Artikulua berrikusteko eskakizuna', '{$reviewerName}:<br />\n<br />\nHau &quot;{$submissionTitle},&quot; eskuizkribuari dagokio, {$contextName} aldizkariak aintzat hartu duena.<br />\n<br />\nEskuizkribuaren aurreko bertsioaren berrikuspenari jarraituz, egileek orain haien lanaren bertsio berrikusi bat bidali dute. Eskertuko genuke ebaluatzen lagunduko bazenu.<br />\n<br />\nAldizkari honetarako Berrikuspen Gidalerroak behean erantsita daude, eta mezuak bidalketa bat du erantsia. Bidalketaren berrikuspena, zure gomendioarekin batera, bidali niri posta elektronikoz {$reviewDueDate} datarako.<br />\n<br />\nMesedez, adierazi mezu baten bidez {$responseDueDate} datarako berrikuspena egiteko gai izango zaren eta egingo duzun.<br />\n<br />\nMila esker eskari hau kontuan hartzeagatik.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\n<br />\nBerrikusi gidalerroak<br />\n<br />\n{$reviewGuidelines}', 'Atalen Editoreak Berrikusleari bidalitako mezu honetan berrikusleari eskatzen dio bidalitakoaren bigarren edo hurrengo berrikuspen bat onartu edo baztertu dezala. Bidalitakoari buruzko informazioa ematen du, besteak beste, titulua eta aurkezpena, berrikuspena egiteko muga, eta nola sartu bidalitakora.  Mezu hau erabiltzen da Aldizkariaren Konfigurazioan, 2. urratsean, Berrikuspen Prozesuaren Mezu Erantsia hautatzen denean. (Bestela, ikus BERRIKUSPENA_ESKAKIZUNA_ONDORENGOA.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'fa_IR', 'درخواست داوری مقاله', '{$reviewerName}:<br />\n<br />\nاین ایمیل در مورد مقاله &quot;{$submissionTitle},&quot; که به مجله {$contextName} ارسال شده است، می باشد.<br />\n<br />\nدر ادامه داوری های قبلی  این مقاله نمایش داده شده است و اکنون نویسنده نسخه اصلاحی خود را ارسال کرده است. در صورت امکان در ارزیابی این اصلاحات به ما کمک کنید.<br />\n<br />\nراهنمای داوری و همچنین مقاله به این ایمیل ضمیمه شده است. نتیجه داوری و همچنین توصیه شما در موذد این مقاله باید تا تاریخ {$reviewDueDate} ارسال شود.<br />\n<br />\nلطفاً تا تاریخ {$responseDueDate} برای ما با ایمیل پاسخ دهید که این داوری را می پذیرید یا نه.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nراهنمای داوری<br />\n<br />\n{$reviewGuidelines}<br />', 'ایمیلی از طرف دبیر یا دبیر بخش به داور برای درخواست انجام داوری'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'fi_FI', 'Artikkelin arviointipyyntö', 'Hyvä {$reviewerName},<br />\n<br />\nTämä viesti koskee käsikirjoitusta &quot;{$submissionTitle}&quot;, joka on käsiteltävänä julkaisussa {$contextName}.<br />\n<br />\nKäsikirjoituksen aiemman version arvioinnin jälkeen kirjoittaja on nyt lähettänyt korjatun version työstään. Arvostaisimme suuresti, jos voisitte auttaa sen arvioinnissa.<br />\n<br />\nJulkaisumme arviointiohjeet löytyvät tämän sähköpostin lopusta ja käsikirjoitus on liitteenä. Arviointinne sekä suosituksenne tulisi lähettää minulle sähköpostitse {$reviewDueDate} mennessä.<br />\n<br />\nIlmoittakaa pystyttekö ja haluatteko suorittaa arvioinnin vastaamalla tähän viestiin {$responseDueDate} mennessä.<br />\n<br />\nKiitos, että harkitsette arviointiin ryhtymistä.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nArviointiohjeet<br />\n<br />\n{$reviewGuidelines}<br />\n', 'This email is sent by the Section Editor to a Reviewer to request that they accept or decline the task of reviewing a submission for a second or greater round of review. It includes the submission as an attachment. This message is used when the Email-Attachment Review Process is selected in Management > Settings > Workflow > Review. (Otherwise see REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'fr_CA', 'Demande d''évaluation d''un article', '{$reviewerName},<br />\n<br />\nCeci concerne le manuscrit « {$submissionTitle} », qui est présentement évalué par la revue {$contextName}.<br />\n<br />\nSuivant l''évaluation de la dernière version du manuscrit, l''auteur-e a soumis une version révisée de son document. Nous apprécierions que vous évaluiez cette nouvelle version.<br />\n<br />\nLes directives d''évaluation de la revue se trouvent ci-dessous et la soumission est jointe au présent courriel. Votre évaluation de la soumission, ainsi que vos recommandations, devraient nous parvenir par courriel d''ici le {$reviewDueDate}.<br />\n<br />\nVeuillez nous faire savoir par courriel d''ici le {$responseDueDate} si vous acceptez ou non d''effectuer cette évaluation.<br />\n<br />\nNous vous remercions de l''attention que vous porterez à notre demande.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nDirectives pour l''évaluation<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Ce courriel est envoyé par le,la rédacteur-trice de rubrique à un,une évaluateur-trice pour lui demander s''il ou elle accepte ou refuse la tâche d''évaluation d''une soumission pour un cycle subséquent d''évaluation. Il inclut la soumission en pièce jointe. Ce message est utilisé quand le processus de « Demande d''évaluation par pièce-jointe de courriel » est sélectionné dans Configuration de la revue > Paramètres > Flux des travaux > Évaluation . (Autrement voir « Demande d''évaluation (cycle subséquent)».)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'fr_FR', 'Demande d''évaluation d''un article', '{$reviewerName},<br />\n<br />\nCeci concerne le manuscrit « {$submissionTitle} », qui est actuellement évalué par la revue {$contextName}.<br />\n<br />\nÀ la suite de l''évaluation de la dernière version du manuscrit, l''auteur ou l''auteure a soumis une version révisée de son document. Nous apprécierions que vous évaluiez cette nouvelle version.<br />\n<br />\nLes directives d''évaluation de la revue se trouvent ci-dessous et la soumission est jointe au présent courriel. Votre évaluation de la soumission, ainsi que vos recommandations, devraient nous parvenir par courriel d''ici le {$reviewDueDate}.<br />\n<br />\nVeuillez nous faire savoir par courriel d''ici le {$responseDueDate} si vous acceptez ou non d''effectuer cette évaluation.<br />\n<br />\nNous vous remercions de l''attention que vous porterez à notre demande.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nDirectives pour l''évaluation<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Ce courriel du responsable de rubrique à un rapporteur demande que le rapporteur accepte ou refuse la tâche d''examiner une soumission pour une deuxième fois ou plus. Il fournit des informations sur la soumission, comme le titre et le résumé, la date d''échéance de l''évaluation et la façon d''accéder à la soumission elle-même. Ce message est utilisé lorsque le processus de révision avec pièce jointe est sélectionné dans Administration> Paramètres> Flux des travaux> Révision.(Autrement voir REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'gd_GB', 'Iarrtas airson lèirmheas artaigil', '{$reviewerName}:<br />\n<br />\nTha seo mu dhèidhinn na sgrìobhainn “{$submissionTitle}” a tha {$contextName} a’ cnuasachadh.<br />\n<br />\nRi linn lèirmheis air an tionndadh roimhe dhen sgrìobhainn, chuir na h-ùghdaran tionndadh lèirmheaste dhen phàipear aca thugainn. Bhiomaid fada nad chomain nam b’ urrainn dhut sgrùdadh a dhèanamh air còmhla rinn.<br />\n<br />\nGheibh thu riaghailtean lèirmheas an iris-leabhair seo gu h-ìosal agus tha an tagradh ceangailte ris a’ phost-d seo. Bu chòir dhut lèirmheas an tagraidh agus do mholaidhean a chur thugam ron {$reviewDueDate}.<br />\n<br />\nNach cuir thu post-d thugam ron {$responseDueDate} a dh’innse dhomh an urrainn dhut an lèirmheas a dhèanamh?<br />\n<br />\nMòran taing airson an t-iarrtas seo a thoirt fa-near.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nStiùireadh airson lèirmheasan<br />\n<br />\n{$reviewGuidelines}<br/>\n', 'Thèid am post-d seo a chur gu lèirmheasaiche le deasaiche earrainn a dh’fhaighneachd an gabh iad ri lèirmheas air tagradh san dàrna cuairt (no cuairt nas motha) no an diùlt iad e. Tha seo a’ gabhail a-staigh an tagraidh mar cheanglachan. Seo an teachdaireachd a thèid a chleachdadh nuair a thaghar am pròiseas lèirmheis le ceanglachan puist-d fo “Stiùireadh” > “Roghainnean” > “Sruth-obrach” > “Lèirmheas”. (Air neo faic REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'hi_IN', 'लेख समीक्षा का अनुरोध', '{$reviewerName}:<br />\n<br />\nयह पांडुलिपि का संबंध है &quot;{$submissionTitle},&quot; जो विचाराधीन है {$contextName}.<br />\n<br />\nपांडुलिपि के पिछले संस्करण की समीक्षा के बाद, लेखकों ने अब अपने पेपर का एक संशोधित संस्करण प्रस्तुत किया है। यदि आप इसका मूल्यांकन करने में मदद कर सकते हैं तो हम इसकी सराहना करेंगे.<br />\n<br />\nइस जर्नल के लिए समीक्षा दिशानिर्देश नीचे संलग्न हैं, और प्रस्तुत इस ईमेल से जुड़ा हुआ है। आपकी अनुशंसा के साथ, आपकी सबमिट की समीक्षा, {$ reviewDueDate} द्वारा मुझे ईमेल की जानी चाहिए.<br />\n<br />\nकृपया {$ responseDueDate} द्वारा वापसी ईमेल में इंगित करें कि क्या आप समीक्षा करने में सक्षम और इच्छुक हैं.<br />\n<br />\nइस अनुरोध पर विचार करने के लिए धन्यवाद।<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nReview Guidelines<br />\n<br />\n{$reviewGuidelines}<br />\n', 'यह ईमेल अनुभाग संपादक द्वारा एक समीक्षक को यह अनुरोध करने के लिए भेजा जाता है कि वे समीक्षा के दूसरे या अधिक दौर के लिए प्रस्तुत समीक्षा के कार्य को स्वीकार या अस्वीकार करें। इसमें अनुलग्नक के रूप में सबमिशन शामिल है। इस संदेश का उपयोग तब किया जाता है जब ईमेल> अनुलग्नक समीक्षा प्रक्रिया प्रबंधन> सेटिंग्स> वर्कफ़्लो> समीक्षा में चुनी जाती है। (अन्यथा REVIEW_REQUEST_SUBSEQUENT देखें।)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'hu_HU', 'Cikk lektorálás kérése', 'Tisztelt {$reviewerName}!<br />\n<br />\nA(z) {$contextName} folyóirathoz érkezett &quot;{$submissionTitle},&quot; című kézirat módosított változatának lektorálására szeretném felkérni. <br />\n<br />\nFolyóiratunk lektorálási irányelveit megtekintheti a levél végén, a benyújtott cikket pedig csatoltan küldjük. A kézirattal kapcsolatos szakértői véleményét és javaslatait kérem emailben küldje meg részemre {$reviewDueDate}-ig.<br />\n<br />\nKérem, jelezze válasz emailben legkésőbb {$responseDueDate}-ig, hogy vállalja-e a lektorálást.<br />\n<br />\nÜdvözlettel,<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nLektorálási irányelvek:<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Ez az emailt a Rovatszerkesztő küldi a Lektornak, megkérve, hogy vállalja el, vagy, ha nem alkalmas, akkor utasítsa el a beküldött anyag lektorálási feladatát a második vagy további lektorálási körökben. Ez csatoltan tartalmazza a kéziratot is. Ezt az üzenetet akkor kell használni, ha az email csatolásos lektorálási folyamat van engedélyezve a folyóirat menedzselése részben > Beállítások > Munkafolyamat > Szakmai lektorálás. (Lásd még REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'id_ID', 'Permohonan Review Artikel', '{$reviewerName}:<br />\n<br />\nEmail ini terkait naskah &quot;{$submissionTitle},&quot; yang sedang dalam pertimbangan di {$contextName}.<br />\n<br />\nSetelah review untuk versi naskah sebelumnya, penulis saat ini telah menyerahkan versi revisi naskahnya.  Kami berharap Anda dapat membantu mengevaluasinya.<br />\n<br />\nPanduan Review untuk jurnal ini disertakan di bawah, dan naskah dilampirkan bersama email ini. Review dan rekomendasi Anda, mohon dapat diemailkan ke kami pada {$reviewDueDate}.<br />\n<br />\nMohon sampaikan di email balasan sebelum {$responseDueDate} tentang kesediaan Anda untuk melakukan review.<br />\n<br />\nTerimakasih atas perhatiannya.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nPanduan Review<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Email ini dari Editor Bagian kepada Reviewer untuk meminta reviewer memberitahukan apakah menerima atau menolak permohonan review untuk ronde kedua atau berikutnya.  Email disertai naskah terlampir bersama email. Pesan ini digunakan saat Proses Review Lampiran Email dipilih di Manajemen > Pengaturan > Alur Kerja > Review. (Selain itu lihat REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'it_IT', 'Richiesta di revisione di un articolo', 'Gentile {$reviewerName}:<br />\n<br />\nTi scrivo riguardo al manoscritto &quot;{$submissionTitle},&quot; proposto per la pubblicazione in {$contextName}.<br />\n<br />\nSeguendo i suggerimenti ricevuti dai revisori, l''autore ha inviato una nuova versione modificata. Ti sarei grato se ci aiutassi a valutarla.<br />\n<br />\nPiù sotto trovi le Linee guida sulla revisione e il file del manoscritto è in allegato. Puoi inviarmi la revisione e il tuo parere sulla proposta via email, entro il  {$reviewDueDate}.<br />\n<br />\nPerfavore informami entro il {$responseDueDate} se accetti o meno l''incarico.<br />\n<br />\nGrazie della disponibilià<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nLinee guida sulla revisione<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Questo messaggio viene inviato dall''editor a un revisore chiedendogli di accettare o rifiutare l''incarico di revisione di una proposta per un secondo o successivo round di revisione. Contiene in allegato il file del manoscritto. Questo messaggio viene utilizzato quando è stato selezionato nel Setup, il processo di revisione con allegati email. (In caso contrario vedi REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'ja_JP', '論文査読のお願い', '{$reviewerName}様<br />\n<br />\n雑誌『{$contextName}』への投稿原稿「{$submissionTitle}」に関して連絡いたします。<br />\n<br />\nこの度、前回の原稿の査読を経て、改訂版が提出されました。評価にご協力いただければ幸いです。<br />\n<br />\nこの雑誌の査読の手引きを以下に添付しました。また、投稿物はメールの添付ファイルとしてお送りいたしました。投稿物の査読結果と答申は、{$reviewDueDate}までに私宛にメールでいただきたいと考えております。<br />\n<br />\n査読をしていただけるか否かを、{$responseDueDate}までにメールでご返事いただけるようお願いいたします。\n<br />\nよろしくご検討くださるよう、お願いいたします。<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\n査読の手引き<br />\n<br />\n{$reviewGuidelines}<br />\n', 'このメールは、セクションエディタから査読者に投稿物の査読の次回目を依頼するものです。メールには、査読物をファイルで添付します。このメールは、雑誌設定のステップ2でメール添付による査読プロセスが選択された場合に使用されます（そうでない場合は、REVIEW_REQUEST_SUBSEQUENTを参照してください）。'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'ku_IQ', 'داواکاریی هەڵسەنگاندنی توێژینەوە', '{$reviewerName}:<br />\n<br />\nئەمە دەربارەی ڕەشنوسی توێژینەوەی &quot;{$submissionTitle},&quot; کە لە ژێر هەڵسەنگاندن دایە لە لایەن {$contextName}.<br />\n<br />\nدوای تێبینییەکانی هەڵسەنگاندنی یەکەم جار، توێژەر بە تێبینییەکاندا چووەتەوە و سوپاسگوزار دەبین ئەگەر لە دوبارە هەڵسەنگاندنەوەیدا هاوکاریمان بکەن.<br />\n<br />\nڕێنماییەکانی هەڵسەنگاندن لە خوارەوە بەردەستن و توێژینەوە پێشکەشکراوەکە هاوپێچی ئەم ئیمەیڵە کراوە. هەڵسەنگاندن و تێبینییەکانی بەڕێزتان دەبێت بە شێوەی ئیمەیڵ بۆ من بنێردرێتەوە هەتا  {$reviewDueDate}.<br />\n<br />\nتکایە لە ئیمەیڵی وەڵامدا هەتا {$responseDueDate} دیاری بکە کە ئایا هەڵسەنگاندنەکە قبوڵ یان ڕەت دەکەنەوە.<br />\n<br />\nسوپاس بۆ هاوکاریتان.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nڕێنماییەکانی هەڵسەنگاندن<br />\n<br />\n{$reviewGuidelines}<br />\n', 'ئەم ئیمەیڵە لەلایەن سەرنوسەری بەشەوە بۆ هەڵسەنگێنەر نێردراوە بە مەبەستی قبوڵکردن یان ڕەتکردنەوەی خولی دووەمی هەڵسەنگاندن. ئەمە زانیاریی وەک ناونیشان و پوختە و کۆتا ڕۆژی هەڵسەنگاندن و ڕێنماییەکانی هەڵسەنگاندن لەخۆ دەگرێت. ئەم نامەیە کاتێک بەکار دێت کە هەڵسەنگاندن لە پرۆسەیەکی ستاندارد و بەم ڕێڕەوەدا تێپەڕ ببێت: بەڕێوەبردن/ ڕێکخستنەکان/ ڕێڕەوی کار/ هەڵسەنگاندن. (ئەگەر نا سەیری ئێرە بکەن REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'mk_MK', 'Барање за рецензија на наслов', '{$reviewerName}:<br />\n<br />\nОва се однесува на трудот &quot;{$submissionTitle},&quot; кој е предмет на разглед на {$contextName}.<br />\n<br />\nПосле рецензијата на претходната верзија на трудот, авторите сега имаат поднесено корегирана верзија на нивниот труд. Би ценеле доколку би можеле да ни помогнете со евалуацијата на истиот.<br />\n<br />\nДирективите за рецензија на ова списание се додадени подолу, и поднесокот е прикачен на овој и-меил. Вашата рецензија на поднесокот, заедно со вашата препорака, треба да ми ги испратите преку и-меил до {$reviewDueDate}.<br />\n<br />\nВе молам да наведете во повратен и-меил до {$responseDueDate} дали сте способни и подготвени да ја извршите рецензијата.<br />\n<br />\nВи благодариме што го земавте во предвид ова барање.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nДирективи за рецензија<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Овој и-меил од Секциски уредник до Рецензент бара рецензентот да ја прифати или одбие задачата за рецензирање на поднесок во вториот или понатамошен циклус на рецензирање. Го вклучува поднесокот во прилог. Оваа порака се користи кога Процес на рецензија со и-меил прилог е одбрано во Раководење > Поставки > Тек на рабоатата > Рецензија. (Во спротивно погледнете REVIEW_REQUEST_ATTACHED.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'nb_NO', 'Forespørsel om fagfellevurdering av artikkel', '{$reviewerName}:<br />\n<br />\nDette gjelder innleveringen &quot;{$submissionTitle},&quot; som behandles av {$contextName}.<br />\n<br />\nSom oppfølgning på en tidligere vurdering av manuskriptet, har forfatterene sendt inn en revidert versjon av manuskriptet. Vi vil sette stor pris på din hjelp til å vurdere det.<br />\n<br />\nTidsskriftets retningslinjer for fagfellevurdering er lagt til nedenfor og manuskriptet er vedlagt denne e-posten. Din fagfellevurdering av manuskriptet sammen med din anbefaling bes sendt til meg senest {$reviewDueDate}.<br />\n<br />\nVær vennlig å gi beskjed til oss om du vil påta deg fagfellevurderingen eller ei senest {$responseDueDate}.<br />\n<br />\nTakk for at du overveier denne forespørslen.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nRetningslinjer for fagfellevurdering<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Denne e-posten sendes av seksjonsredaktøren til en fagfelle, som blir bedt om å indikere om han eller hun vil forplikte seg til å vurdere en innlevering i en andre eller senere vurderingsrunde. Det inkluderer innleveringen som et vedlegg. Denne meldingen brukes når du har valgt en fagfellevurderingsprosess med e-post-vedlegg  under Innstillinger > Arbeidsflyt > Fagfellevurdering. (Se ellers REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'nl_NL', 'Verzoek tot reviewen van een artikel', '{$reviewerName}:<br />\n<br />\nDit betreft het manuscript &quot;{$submissionTitle},&quot; dat wordt overwogen door {$contextName}.<br />\n<br />\nNa een review van een eerdere versie van het manuscript hebben de auteurs een gereviseerde versie van hun manuscript ingestuurd. We zouden het op prijs stellen als u wilt helen die te evalueren.<br />\n<br />\nDe Review richtlijnen voor dit tijdschrift staan hieronder en de inzending is bijgevoegd bij deze e-mail. Uw review van de inzending en uw aanbeveling, zouden uiterlijk op {$reviewDueDate} naar mij gemaild moeten worden.<br />\n<br />\nGelieve mij voor {$responseDueDate} per e-mail te laten weten of u deze review kunt en wilt doen.<br />\n<br />\nDank u voor het overwegen van dit verzoek.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nReview richtlijnen<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Deze e-mail wordt door de sectieredacteur aan een reviewer verstuurd om te vragen of die een review voor de tweede of latere ronde van een inzending wil doen. De inzending wordt als bijlage meegestuurd. Dit bericht wordt gebruikt als het e-mail reviewproces wordt geselecteerd in stap 2 van het instellen. (Zie verder REVIEW_REQUEST_SUBSEQUENT)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'pl_PL', 'Prośba o wykonanie recenzji tekstu', '{$reviewerName}:<br />\n<br />\nWiadomość dotyczy manuskryptu &quot;{$submissionTitle},&quot; który jest rozważany do publikacji przez {$contextName}.<br />\n<br />\nAutorzy tekstu po zapoznaniu się z uwagami przedstawionymi z recenzji przesłali poprawioną wersję tekstu. Będziemy wdzięczni za pomoc w ocenie tekstu po poprawkach.<br />\n<br />\nWskazówki dp recenzji są zamieszczone poniżej, a zgłoszenie znajduje się w załączniku. Twoja recenzja zgłoszenia, razem z poprawkami powinna być przesłana do mnie do {$reviewDueDate}.<br />\n<br />\nProsimy o przesłanie odpowiedzi emailem do {$responseDueDate} z informacją, czy podejmujesz się tego zadania.  <br />\n<br />\nDziękujemy za rozważenie naszej propozycji.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nWskazówki do recenzji<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Wiadomość od redaktora prowadzącego do recenzenta. Zawiera prośbę o przygotowanie recenzji tekstu, jego tytuł i abstrakt. Wysyłana, jeżeli recenzent pracować będzie w systemie'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'pt_BR', 'Solicitação de avaliação de artigo', '{$reviewerName}:<br />\n<br />\nEsta mensagem é referente ao manuscrito &quot;{$submissionTitle},&quot; que está sendo considerado para publicação pelo periódico {$contextName}.<br />\n<br />\nApós a avaliação da versão anterior do manuscrito, os autores submeteram uma versão revisada do artigo. Nós agradeceríamos se você pudesse ajudar com uma avaliação.<br />\n<br />\nAs Diretrizes de Avaliação deste periódico seguem abaixo e a submissão está anexa ao e-mail. Sua avaliação da submissão, junto à recomendação, deve ser enviada por e-mail até {$reviewDueDate}.<br />\n<br />\nPor gentileza, envie um email de retorno até{$responseDueDate} indicando se você poderá dar o parecer ou não.<br />\n<br />\nObrigado por considerar este pedido.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nDiretrizes de Avaliação<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Esta mensagem é enviada pelo Editor de seção ao avaliador, perguntando se estaria disponível para enviar a avaliação de uma submissão em uma segunda rodada ou superior. A mensagem inclui a submissão como anexo. Ela é usada quando o processo de avaliação via e-mail é escolhido em  Configurações > Fluxo de trabalho > Avaliação.  (Caso contrário, veja REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'pt_PT', 'Pedido de revisão de artigo', '{$reviewerName}:<br />\n<br />\nEsta mensagem é relativa ao manuscrito &quot;{$submissionTitle},&quot; submetido a {$contextName}.<br />\n<br />\nNa sequência do processo de revisão, os autores submeteram a versão revista do artigo. Gostaríamos que considerasse a sua revisão.<br />\n<br />\nAs Instruções de Revisão desta revista são apresentadas abaixo, e a submissão foi anexada a este e-mail. A sua revisão do artigo, conjuntamente com as suas recomendações, devem ser enviadas até {$reviewDueDate}.<br />\n<br />\nIndique até {$responseDueDate} se está disponível para fazer a revisão. <br />\n<br />\nAgradecemos a sua resposta a este pedido.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nInstruções de Revisão<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Este e-mail é enviado pelo Editor de Secção para o Revisor a solicitar que aceite ou recuse a tarefa de rever um artigo na segunda ronda de revisão. Inclui a submissão como anexo. Esta mensagem é usada quando o Processo de revisão como anexo de e-mail está selecionado em Configurações > Fluxo de trabalho > Revisão. (Caso contrário, veja REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'ro_RO', 'Rugăminte revizuire articol', '{$reviewerName}:<br />\n<br />\nAcest mesaj se referă la manuscrisul &quot;{$submissionTitle},&quot; care este evaluat de {$contextName}.<br />\n<br />\nÎn urma revizuirii versiunii anterioare a manuscrisului, autorii au transmis acum o versiune revizuită a lucrării lor. Am aprecia dacă ați putea contribui la o nouă evaluare a acestuia.<br />\n<br />\nGhidul de revizuire pentru acest jurnal este anexat mai jos, iar manuscrisul este atașat acestui e-mail. Vă rog să trimiteți prin email revizia și recomandările dumneavoastră până la data de {$reviewDueDate}.<br />\n<br />\nVă rugăm să indicați într-un e-mail de răspuns până la {$responseDueDate} dacă sunteți dispus să faceți revizuirea. <br />\n<br />\nMulțumim că luați în considerare solicitarea noastră.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nGhid de revizuire<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Acest e-mail este trimis de către editorul de secțiuni unui revizor pentru a ști dacă acesta  acceptă sau să refuză sarcina de a revizui manuscrisului pentru o a doua sau altă rundă de revizuire. Include manuscrisul ca atașament. Acest mesaj este utilizat atunci când procesul de examinare a manuscrisului prin e-mail, este selectat în Management> Setări> Flux de lucru> Revizuire. (În caz contrar, consultați REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'ru_RU', 'Запрос на рецензирование статьи', 'Здравствуйте, {$reviewerName}!<br />\n<br />\nЭто письмо касается материала «{$submissionTitle}», который рассматривается журналом «{$contextName}».<br />\n<br />\nПо результатам рецензирования предыдущей версии материала авторы прислали откорректированную версию их статьи. Мы были бы рады, если бы Вы помогли оценить ее.<br />\n<br />\nРуководство для рецензентов этого журнала добавлено ниже, материал для рецензирования приложен к этому письму. Ваша рецензия на материал, вместе с рекомендацией, должны быть отправлены мне электронной почтой до {$reviewDueDate}.<br />\n<br />\nПожалуйста, сообщите в ответном письме до {$responseDueDate} сможете ли Вы взяться за рецензирование.<br />\n<br />\nЗаранее благодарю Вас,<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nРуководство для рецензентов<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Это письмо редактора раздела, отправляемое рецензенту, с запросом согласия или отказа от выполнения рецензирования материала во втором или последующих раундах рецензирования. К письму приложен сам материал для рецензирования. Это сообщение используется, если выбран процесс рецензирования через электронную почту в Управление > Настройки > Рабочий процесс > Рецензирование. (В ином случае, смотрите REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'sk_SK', 'Požiadavka na recenziu článku', '{$reviewerName}:<br />\n<br />\nTento email sa týka rukopisu &quot;{$submissionTitle},&quot; predkladaného autorom {$contextName}.<br />\n<br />\nNa základe recenzie predchádzajúcej verzie rukopisu podali autori teraz opravenú verziu tohto článku. Boli by sme radi, keby ste nám pomohli túto revidovanú verziu ohodnotiť.<br />\n<br />\nPokyny pre recenzentov tohto časopisu sú pripojené nižšie, a samotný opravený príspevok je vložený do tohto emailu ako príloha. Vaša recenzia opraveného príspevku spolu s vašimi odporúčaniami by mala byť odoslaná emailom do {$reviewDueDate}.<br />\n<br />\nProsíme vás, aby ste v odpovedi na tento email uviedol(a) do {$responseDueDate}, či ste schopný(á) a ochotný(á) urobiť túto recenziu.<br />\n<br />\nĎakujeme vopred za vašu ochotu.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nPokyny pre recenzentov<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Tento email je zaslaný Editorom sekcie recenzentovi, aby ho požiadal o prijatie alebo odmietnutie opakovanej recenzie príspevku v druhom či ďalšom kole recenzného konania. Zahŕňa príspevok ako prílohu. Táto správa sa používa v prípade, že je v časti Správa> Nastavenia> Pracovný postup> Kontrola vybraná možnosť Preverovanie príloh emailu. (Inak pozri REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'sl_SI', 'Prošnja za recenzijo prispevka', '{$reviewerName}:<br />\n<br />\nTa e-pošta se nanaša na rokopis &quot;{$submissionTitle},&quot; , ki je v obravnavi pri reviji {$contextName}.<br />\n<br />\nPo pregledu recenzije prejšnje verzije rokopisa, so avtorji oddali dopolnjeno verzijo prispevka. Prosimo vas, če nam lahko pomagate pri ponovni oceni prispevka.<br />\n<br />\nSpodaj so navodila za recenzijo za našo revijo, v priponki pa je prispevek. Vašo recenzija, skupaj s priporočilom, bi mi morali poslati po e-pošti do {$reviewDueDate}.<br />\n<br />\nProsim, če mi po e-pošti sporočite do {$responseDueDate}, če ste pripravljeni narediti to recenzijo ali ne.<br />\n<br />\nHvala lepa za sprejetje prošnje.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nNavodila za recenzijo<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Ta email pošlje urednik rubrike recenzentu s prošnjo za opravljanje ali zavrnitev recenzije v drugem ali kasnejšem recenzentskem krogu. V priponki vsebuje prispevek. Email se uporablja, kadar je uporabljen "Email-attached" recenzijski proces (Upravljanje > Nastavitve > Potek dela > Recenzija) (Drugače glej REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'sv_SE', 'Förfrågan om granskning av artikel', '{$reviewerName}:<br />\n<br />\nDetta gäller manuskriptet &quot;{$submissionTitle},&quot;, som är under övervägande hos {$contextName}.<br />\n<br />\nEfter granskningen av en tidigare version av manuskriptet har författarna nu skickat in en reviderad version av sin artikel. Vi är glada om du skulle kunna hjälpa oss att utvärdera denna.<br />\n<br />\nRiktlinjer för granskare bifogas här nedan, och bidraget finns som bilaga i det här e-postmeddelandet. Din bedömning av bidraget ska tillsammans med din rekommendation skickas per e-post till mig senast {$reviewDueDate}.<br />\n<br />\nVänligen meddela mig genom att svara på det här meddelandet senast {$responseDueDate} om du har möjlighet att åta dig uppdraget eller inte.<br />\n<br />\nTack för att du överväger granskningsuppdraget.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nRiktlinjer för granskare<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Det här e-postmeddelandet från sektionsredaktören till en granskare ber granskaren att acceptera eller tacka nej till uppdraget att sakkunniggranska ett bidrag en andra gång eller på nytt. Det innehåller information bidraget som en bifogad fil. Det här e-postmeddelandet används när Granskningsprocess med e-postbilaga är valt i > Inställningar > Arbetsflöde > Granskning. (Annars, se REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'tr_TR', 'Makale Değerlendirme Talebi', 'Sayın {$reviewerName},<br />\n<br />\nThis regards the manuscript &quot;{$submissionTitle},&quot; which is under consideration by {$contextName}.<br />\n<br />\nFollowing the review of the previous version of the manuscript, the authors have now submitted a revised version of their paper. We would appreciate it if you could help evaluate it.<br />\n<br />\nThe Review Guidelines for this journal are appended below, and the submission is attached to this email. Your review of the submission, along with your recommendation, should be emailed to me by {$reviewDueDate}.<br />\n<br />\nPlease indicate in a return email by {$responseDueDate} whether you are able and willing to do the review.<br />\n<br />\nThank you for considering this request.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nReview Guidelines<br />\n<br />\n{$reviewGuidelines}\n', 'This email is sent by the Section Editor to a Reviewer to request that they accept or decline the task of reviewing a submission for a second or greater round of review. It includes the submission as an attachment. This message is used when the Email-Attachment Review Process is selected in Journal Setup, Step 2. (Otherwise see REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'uk_UA', 'Запит на рецензування статті', '{$reviewerName}:<br />\n<br />\nЦей лист стосується рукопису &quot;{$submissionTitle}&quot;, що розглядається в журналі {$contextName}.<br />\n<br />\nЗгідно рекомендацій попереднього раунду рецензування, автори надіслали виправлену версію своєї роботи. Ми були б вдячні Вам за допомогу в оцінці цього подання.<br />\n<br />\nНижче подана інструкція для рецензентів. Рукопис, поданий у редакцію авторами, прикріплений до цього листа. Я хотів би отримати лист з Вашою рецензією та рекомендацією до {$reviewDueDate}.<br />\n<br />\nБудь ласка, надішліть мені листом відповідь, чи маєте Ви можливість і бажання працювати над цією рецензію, до {$responseDueDate} .<br />\n<br />\nДякую, що розглянули цей запит.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\nІнструкція для рецензентів<br />\n<br />\n{$reviewGuidelines}\n', 'Цим листом редактор розділу просить рецензента виконати другий раунд рецензування подання або відмовитись від цієї роботи. У додатку до листа міститься рукопис, поданий до редакції. Цей шаблон використовується, якщо на кроці 2 Налаштування журналу обраний доступ рецензента "єдиним натисканням" (у іншому випадку див. REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'vi_VN', 'Yêu cầu đánh giá bài báo', 'Kính gửi {$reviewerName},<br />\n<br />\nLiên quan tới bản thảo &quot;{$submissionTitle},&quot; which is under consideration by {$contextName}.<br />\n<br />\nSau khi xem xét phiên bản trước của bản thảo, các tác giả hiện đã gửi phiên bản sửa chữa bài báo của họ. Chúng tôi đánh giá cao nếu bạn có thể giúp đánh giá bản sửa chữa này.<br />\n<br />\nHướng dẫn phản biện cho tạp chí này được thêm vào bên dưới và bài gửi được đính kèm với email này. Đánh giá của bạn về bài gửi, cùng với khuyến nghị của bạn, nên được gửi qua email cho tôi trước ngày {$reviewDueDate}.<br />\n<br />\nXin cho biết trong một email phả hồi trước {$responseDueDate} cho dù bạn có thể và sẵn sàng để xem xét.<br />\n<br />\nCảm ơn bạn đã xem xét yêu cầu này.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nHướng dẫn phản biện<br />\n<br />\n{$reviewGuidelines}<br />\n', 'Email này được Biên tập viên chuyên mục gửi đến Người phản biện để yêu cầu họ chấp nhận hoặc từ chối nhiệm vụ đánh giá bài gửi cho vòng đánh giá thứ hai trở lên. Nó bao gồm các bài gửi như một tập tin đính kèm. Thông báo này được sử dụng khi Quy trình phản biện đính kèm email được chọn trong Quản lý > Cài đặt > Quy trình làm việc > Phản biện. (Nếu không, hãy xem REVIEW_REQUEST_SUBSEQUENT.)'),
('REVIEW_REQUEST_ATTACHED_SUBSEQUENT', 'zh_CN', '文章审稿请求', '{$reviewerName}:<br />\n<br />\nThis regards the manuscript &quot;{$submissionTitle},&quot; which is under consideration by {$contextName}.<br />\n<br />\nFollowing the review of the previous version of the manuscript, the authors have now submitted a revised version of their paper. We would appreciate it if you could help evaluate it.<br />\n<br />\nThe Review Guidelines for this journal are appended below, and the submission is attached to this email. Your review of the submission, along with your recommendation, should be emailed to me by {$reviewDueDate}.<br />\n<br />\nPlease indicate in a return email by {$responseDueDate} whether you are able and willing to do the review.<br />\n<br />\nThank you for considering this request.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\nReview Guidelines<br />\n<br />\n{$reviewGuidelines}', 'This email is sent by the Section Editor to a Reviewer to request that they accept or decline the task of reviewing a submission for a second or greater round of review. It includes the submission as an attachment. This message is used when the Email-Attachment Review Process is selected in Journal Setup, Step 2. (Otherwise see REVIEW_REQUEST_SUBSEQUENT.)');
INSERT INTO `email_templates_default_data` VALUES
('REVIEW_REQUEST_ONECLICK', 'ar_IQ', 'إلتماس تحكيم مؤلَّف', '{$reviewerName}:<br />\n<br />\nكلي ثقة بأنك ستكون محكماً متميزاً للمؤلَّف الموسوم &quot;{$submissionTitle},&quot; والذي أُرسل طلب لنشره إلى {$contextName}. إن ملخص موضوعه مبين أدناه، وأنا أرجو أنك ستأخذ على عاتقك إنجاز هذه المهمة لمجلتنا.<br />\n<br />\nلطفاً، أدخل إلى موقع المجلة حتى يوم {$responseDueDate} لتبين لنا فيما لو أنك موافق على هذا التحكيم أم لا، كما يمكنك أيضاً عبر الرابط أدناه الوصول إلى متعلقات طلب النشر المذكور، وتثبيت تقييمك له وملاحظاتك بشأنه.<br />\n<br />\nأما التحكيم نفسه، فإن موعده النهائي سيكون: {$reviewDueDate}.<br />\n<br />\nرابط الطلب: {$submissionReviewUrl}<br />\n<br />\nنشكر لك اهتمامك بالتماسنا هذا.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'هذه الرسالة يرسلها محرر قسم المجلة إلى أحد المحكمين ليلتمس منه قبول مهمة التحكيم أو رفضها. وهي توفر معلومات متعلقة بطلب النشر من عنوانه وملخصه، فضلاً عن موعد استيجاب التحكيم ورابط الدخول إلى الموقع للاطلاع على الطلب نفسه. هذه الرسالة تستعمل عندما يكون التحكيم في المجلة متبعاً لعملية التحكيم القياسية وذلك عبر تفعيله ضمن (خيارات التحكيم في: الإعدادات، المخطط الانسيابي، التحكيم)، مع تفعيل الوصول المباشر للمحكم أيضاً.'),
('REVIEW_REQUEST_ONECLICK', 'bs_BA', 'Zamolba za recenziju članka', 'Poštovana/i {$reviewerName},<br />\n<br />\ns obzirom na vaše iskustvo i područje ekspertize, rado bismo vam povjerili zadatak recenzije članka &quot;{$submissionTitle}&quot; prijavljenog u naš časopis {$contextName}. Sažetak članka nalazi se u nastavku ove poruke. Nadamo se da ćete prihvatiti našu ponudu te izvršiti ovu, za nas iznimno važnu, zadaću.<br />\n<br />\nMolimo vas da se kao korisnik prijavite na mrežnu stranicu časopisa do {$responseDueDate} kako biste naznačili hoćete li preuzeti recenziju ili ne. Potom, ukoliko prihvatite izradu recenzije, na istome mjestu možete pristupiti tekstu članka te zabilježili vašu recenziju i preporuku.<br />\n<br />\nSama recenzija trebala bi biti završena zaključno s {$reviewDueDate}.<br />\n<br />\nDo priloga možete doći izravno prateći ovu kodiranu pozivnicu: {$submissionReviewUrl}<br />\n<br />\nSrdačno,<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Ovim obrascem e-pošte urednik rubrike šalje upit recenzentu može li prihvatiti ili je prisiljen odbiti zadatak recenziranja članka. Zamolba sadrži osnovne informacije u vidu naslova i kratkog sadržaja članka, datum do kojeg bi recenzija trebala biti napisana te načina na koji  recenzent može pristupiti članku. Ova poruka se koristi kada je odabran standardni recenzijski postupak u 2. koraku Postavljanja časopisa, a recenzentu je omogućen pristup jednim klikom.'),
('REVIEW_REQUEST_ONECLICK', 'ca_ES', 'Sol·licitud de revisió d''un article', '{$reviewerName}:<br />\n<br />\nConsidero que el vostre perfil és adequat per a revisar el manuscrit &quot;{$submissionTitle},&quot; enviat a la revista {$contextName}. A continuació trobareu el resum de l''article, espero que accepteu encarregar-vos d''aquesta tasca tan important per a nosaltres.<br />\n<br />\nUs demano que inicieu la sessió a la revista abans del {$responseDueDate} per indicar-nos si accepteu o no encarregar-vos de la revisió de la tramesa i, en cas d''acceptar-la, per a accedir-hi i enregistrar-ne la revisió i la recomanació.<br />\n<br />\nLa data límit per fer la revisió és el {$reviewDueDate}.<br />\n<br />\nURL de la tramesa: {$submissionReviewUrl}<br />\n<br />\nGràcies per tenir en compte aquesta sol·licitud.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Aquest missatge de correu electrònic té com a remitent l''editor de secció i s''envia a un possible revisor perquè accepti o rebutgi la revisió d''una tramesa. Proporciona la informació següent relativa a la tramesa: títol i resum, data de venciment per a la revisió i mode d''accés a la tramesa. Aquest missatge s''utilitza si s''ha seleccionat el procés de revisió estàndard en el pas 2 de la configuració de la revista i s''ha habilitat l''accés a la revisió en un clic.'),
('REVIEW_REQUEST_ONECLICK', 'cs_CZ', 'Žádost o zpracování recenze článku', '{$reviewerName}:<br />\n<br />\nDomnívám se, že byste mohl být výborným recenzentem příspěvku &quot;{$submissionTitle},&quot; který byl zaslán do {$contextName}. Abstrakt příspěvku je vložen níže. Věřím, že zvážíte možnost přijetí tohoto pro nás důležitého úkolu.<br />\n<br />\nProsím, přihlaste se do {$responseDueDate} na stránkách časopisu, abyste uvedl, zda recenzi zpracujete nebo ne a také pro přístup k příspěvku a zaznamenání Vaší recenze a doporučení.<br />\n<br />\nTermín pro zpracování recenze je {$reviewDueDate}.<br />\n<br />\nURL příspěvku: {$submissionReviewUrl}<br />\n<br />\nDěkujeme za zvážení této žádosti.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Tento email od editora sekce pro recenzenta žádá, aby recenzent přijal nebo odmítl úkol zpracovat recenzi příspěvku. Obsahuje informace o příspěvku, jako je název a abstrakt, termín pro zpracování recenze a jak se dostat k samotnému příspěvku. Tato zpráva je používána, pokud je zvoleno Standardní recenzí řízení ve druhém kroku  Nastavení časopisu a je povolen přístup recenzenta na jedno kliknutí.'),
('REVIEW_REQUEST_ONECLICK', 'da_DK', 'Forespørgsel om bedømmelse af artikel', '{$reviewerName}:<br />\n<br />\nJeg tror, at du vil være en fremragende bedømmer af manuskriptet &quot;{$submissionTitle}&quot;, der er blevet sendt til {$contextName}. Nedenfor finder du et resumé af manuskriptet, og jeg håber, at du vil overveje at påtage dig denne vigtige opgave for os.<br />\n<br />\nLog på tidsskriftets websted inden den {$responseDueDate} for at angive, om du vil påtage dig bedømmelsen eller ej, samt for at få adgang til manuskriptet og registrere din bedømmelse og anbefaling.<br />\n<br />\nSelve bedømmelsen skal afleveres senest den {$reviewDueDate}.<br />\n<br />\nManuskriptets URL-adresse: {$submissionReviewUrl}<br />\n<br />\nTak for din overvejelse af denne forespørgsel.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n {$submissionAbstract}', 'Denne e-mail fra sektionsredaktøren til en bedømmer anmoder bedømmeren om at acceptere eller afvise at bedømme et manuskript. Den indeholder oplysninger om manuskriptet, f.eks. titel og resumé, forfaldsdato for bedømmelse, samt hvordan der kan oprettes adgang til selve manuskriptet. Denne meddelelse benyttes, hvis indstillingen ''Standardbedømmelsesproces'' er valgt under konfiguration af tidsskrift, Indstillinger > Workflow > Bedømmelse og adgang for bedømmere ved hjælp af ét klik er aktiveret.'),
('REVIEW_REQUEST_ONECLICK', 'de_DE', 'Bitte um ein Gutachten', '{$reviewerName},<br />\n<br />\naufgrund Ihrer Forschungsschwerpunkte wären Sie ein/e ausgezeichnete/r Gutachter/in für das Manuskript &quot;{$submissionTitle}&quot;, das zur Publikation in {$contextName} eingereicht worden ist. Weiter unten finden Sie eine Kurzfassung des Beitrags. Ich hoffe sehr, dass Sie sich bereitfinden können, uns mit Ihrer Stellungnahme zu unterstützen. Sie wären uns eine große Hilfe.<br />\n<br />\nLoggen Sie sich bitte bis zum {$responseDueDate} auf der Webseite unserer Zeitschrift ein, um uns Ihre Zu- oder Absage mitzuteilen. Sie finden dort den Beitrag und können gegebenenfalls auch Ihr Gutachten und Ihre Empfehlung dort abgeben.<br />\n<br />\nDas Gutachten wäre fällig am {$reviewDueDate}.<br />\n<br />\nURL des Beitrags: {$submissionReviewUrl}<br />\n<br />\nIn der Hoffnung auf eine positive Antwort,<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Diese E-Mail von der/dem Rubrikredakteur/in an eine/n Gutachter/in bittet darum, dass diese/r die Aufgabe, eine Einreichung zu begutachten, übernimmt oder ablehnt. Sie liefert Informationen über die Einreichung wie Titel und Abstract, ein Fälligkeitsdatum für das Gutachten und darüber, wie auf die Einreichung zugegriffen werden kann. Diese Nachricht wird benutzt, wenn in Schritt 2 des Zeitschriftensetups das Standardbegutachtungsverfahren ausgewählt worden ist und wenn der One-Click-Zugang für Gutachter/innen aktiviert ist.'),
('REVIEW_REQUEST_ONECLICK', 'el_GR', 'Αίτημα αξιολόγησης άρθρου', '{$reviewerName}:<br />\n<br />\nΠιστεύουμε ότι θα αποτελέσετε έξοχο Αξιολογητή της εργασίας &quot;{$submissionTitle},&quot; που υποβλήθηκε στο περιοδικό {$contextName}. Η περίληψη της εργασίας παρατίθεται παρακάτω. Ελπίζουμε ότι θα δεχθείτε να αναλάβετε αυτό το σημαντικό έργο για εμάς.<br />\n<br />\nΘα σας παρακαλούσαμε να συνδεθείτε στον ιστότοπο του περιοδικού έως τις {$responseDueDate} για να δηλώσετε εάν θα αναλάβετε την αξιολόγηση, να αποκτήσετε πρόσβαση στην υποβολή και να καταχωρήσετε τα σχόλιά σας.<br />\n<br />\nΗ προθεσμία υποβολής της αξιολόγησης λήγει στις {$reviewDueDate}.<br />\n<br />\nΣύνδεσμος υποβολής: {$submissionReviewUrl}<br />\n<br />\nΣας ευχαριστούμε εκ των προτέρων για την εξέταση του αιτήματός μας.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Το παρόν αίτημα αξιολόγησης μιας υποβολής αποστέλλεται από τον Επιμελητή Ενότητας σε έναν Αξιολογητή. Παρέχει πληροφορίες σχετικά με την υποβολή, όπως ο τίτλος, η περίληψη, η προθεσμία της αξιολόγησης και ο τρόπος πρόσβασης στην υποβολή. Το συγκεκριμένο μήνυμα χρησιμοποιείται όταν επιλέγεται η Πρότυπη Διαδικασία Αξιολόγησης στη Διαχείριση > Ρυθμίσεις > Ροή εργασιών > Αξιολόγηση, και είναι ενεργοποιημένη η πρόσβαση με ένα κλικ.'),
('REVIEW_REQUEST_ONECLICK', 'en_US', 'Article Review Request', '{$reviewerName}:<br />\n<br />\nI believe that you would serve as an excellent reviewer of the manuscript, &quot;{$submissionTitle},&quot; which has been submitted to {$contextName}. The submission''s abstract is inserted below, and I hope that you will consider undertaking this important task for us.<br />\n<br />\nPlease log into the journal web site by {$responseDueDate} to indicate whether you will undertake the review or not, as well as to access the submission and to record your review and recommendation.<br />\n<br />\nThe review itself is due {$reviewDueDate}.<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nThank you for considering this request.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'This email from the Section Editor to a Reviewer requests that the reviewer accept or decline the task of reviewing a submission. It provides information about the submission such as the title and abstract, a review due date, and how to access the submission itself. This message is used when the Standard Review Process is selected in Management > Settings > Workflow > Review, and one-click reviewer access is enabled.'),
('REVIEW_REQUEST_ONECLICK', 'es_ES', 'Petición de revisión de artículo', '{$reviewerName}:<br />\n<br />\nTengo el convencimiento de que sería un/a excelente revisor/a del manuscrito &quot;{$submissionTitle},&quot; que ha sido enviado a {$contextName}. A continuación encontrará un extracto del envío, con la esperanza de que aceptará llevar a cabo esta importante tarea para nosotros.<br />\n<br />\nPor favor, identifíquese en la revista antes de {$responseDueDate} para decirnos si hará o no la revisión, así como para tener acceso al envío y para registrar su revisión y recomendación.<br />\n<br />\nLa revisión propiamente dicha debe estar lista para el {$reviewDueDate}.<br />\n<br />\nURL del envío: {$submissionReviewUrl}<br />\n<br />\nGracias por tener en cuenta nuestra solicitud.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Este correo del / de la Editor/a de Sección a un/a revisor/a le solicita que acepte o rechace la revisión de un envío. Proporciona información sobre el envío como el título y el resumen, el plazo de revisión, y cómo acceder al envío propiamente dicho. Este mensaje se usa cuando se selecciona el Proceso de Envío Estándar en la configuración de la revista, paso 2, y está activado el acceso a la revisión en un click.'),
('REVIEW_REQUEST_ONECLICK', 'eu_ES', 'Artikulua ebaluatzeko eskaera', '{$reviewerName}:<br />\n<br />\nUste dut ebaluatzaile bikaina izango zinatekeela {$contextName} aldizkarira bidali diguten {$submissionTitle} eskuizkribuari buruzko iritzia emateko. Artikuluaren laburpena behean duzu, eta espero dut aintzakotzat hartu eta pentsatuko duzula guretzat lan garrantzitsu hau egiteko eskaera.<br />\n<br />\nMesedez, sar zaitez aldizkariaren webgunean {$responseDueDate} aurretik, eta esaguzu ebaluazioa egiteko prest zauden ala ez, eta prest egonez gero, artikulua hartzeko eta zure ebaluazio-txostena eta gomendioa emateko.<br />\n<br />\nEbaluazioa egiteko epea {$reviewDueDate} izango litzateke.<br />\n<br />\nArtikuluaren URLa: {$submissionReviewUrl}<br />\n<br />\nEskerrik asko gure eskaera kontuan hartzeagatik.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'Mezu hau Ataleko editoreak bidaltzen dio Ebaluatzaile bati, artikulu bat ebaluatzea onartuko duen ala ez galdetzeko. Artikuluari buruzko informazioa ematen du, hala nola titulua eta laburpena, ebaluazioa egiteko epea eta artikulua bera hartzeko zer egin behar den. Mezu hau erabiltzen da aldizkariaren Konfigurazioko 2. urratsean Ebaluazio-prozesu estandarra hautatzen denean, eta klik bakarreko ebaluatzaile-sarbidea gaitzen denean.'),
('REVIEW_REQUEST_ONECLICK', 'fa_IR', 'درخواست داوری مقاله', '{$reviewerName}:<br />\n<br />\nشما به عنوان یک کارشناس ممتاز برای بررسی مقاله &quot;{$submissionTitle}&quot; که برای {$contextName} ارسال شده است انتخاب شده اید. در ذیل، چکیده مقاله ارسالی برای شما گنجانده شده است و امیدوارم که در این زمینه مایل به همکاری با این مجله باشید.<br />\n<br />\nلطفا قبل از تاریخ {$reviewDueDate} وارد وب سایت مجله شده و مشخص سازید که آیا مایل به قبول کارشناسی هستید یا خیر؟ همچنین به طور همزمان می توانید به مقاله ارسالی دسترسی پیدا کرده و متن کارشناسی و توصیه های خودرا ذخیره کنید.<br />\n<br />\nضمنا آخرین مهلت بررسی این مقاله تا تاریخ {$reviewDueDate} می باشد.<br />\n<br />\nآدرس مقاله: <a href="{$submissionReviewUrl}">{$submissionReviewUrl}</a><br />\n<br />\nاز توجه شما به این درخواست متشکرم.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n<br />\n--------------------------------<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\nچکیده:<br />\n{$submissionAbstract}', 'This email from the Section Editor to a Reviewer requests that the reviewer accept or decline the task of reviewing a submission. It provides information about the submission such as the title and abstract, a review due date, and how to access the submission itself. This message is used when the Standard Review Process is selected in Journal Setup, Step 2, and one-click reviewer access is enabled.'),
('REVIEW_REQUEST_ONECLICK', 'fi_FI', 'Artikkelin arviointipyyntö', 'Hyvä {$reviewerName},<br />\n<br />\nUskon, että olisitte sopiva arvioija käsikirjoitukselle &quot;{$submissionTitle}&quot; joka on lähetetty julkaisuun {$contextName}. Julkaisun tiivistelmä löytyy tämän viestin lopusta. Toivon, että harkitsette tähän meille tärkeään tehtävään ryhtymistä.<br />\n<br />\nKirjautukaa julkaisun verkkosivustolle {$responseDueDate} mennessä ilmoittaaksenne haluatteko suorittaa arvioinnin vai ette. Teidän on kirjauduttava verkkosivustolle myös, jotta saatte pääsyn käsikirjoitukseen ja voitte tallentaa arviointinne ja suosituksenne.<br />\n<br />\nArvioinnin määräpäivä on {$reviewDueDate}.<br />\n<br />\nKäsikirjoituksen URL: {$submissionReviewUrl}<br />\n<br />\nKiitos, että harkitsette arvioijaksi ryhtymistä.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'This email from the Section Editor to a Reviewer requests that the reviewer accept or decline the task of reviewing a submission. It provides information about the submission such as the title and abstract, a review due date, and how to access the submission itself. This message is used when the Standard Review Process is selected in Management > Settings > Workflow > Review, and one-click reviewer access is enabled.'),
('REVIEW_REQUEST_ONECLICK', 'fr_CA', 'Demande d''évaluation d''un article', '{$reviewerName},<br />\n<br />\nNous croyons que vous feriez un-e excellent-e évaluateur-trice pour le manuscrit intitulé « {$submissionTitle} » qui a été soumis à la revue {$contextName}. Vous trouverez un résumé de la soumission ci-dessous. Nous espérons que vous accepterez ce travail essentiel à la publication de la revue.<br />\n<br />\nVeuillez accéder au site Web de la revue avant le {$responseDueDate} pour nous laisser savoir si vous acceptez de faire l''évaluation ou non. Vous pouvez également y consulter la soumission et y enregistrer votre évaluation et votre recommandation.<br />\n<br />\nDate limite pour l''évaluation {$reviewDueDate}.<br />\n<br />\nURL de la soumission : {$submissionReviewUrl}.<br />\n<br />\nNous vous remercions de l''attention que vous porterez à notre demande.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n« {$submissionTitle} »<br />\n<br />\n{$submissionAbstract}', 'Ce courriel du,de la rédacteur-trice de rubrique à un,une évaluateur-trice demande que l''évaluateur-trice accepte ou décline la tâche d''évaluation d''une soumission. Il contient des informations sur la soumission tel que son titre et un résumé, la date d''échéance pour faire l''évaluation, et comment accéder à la soumission. Ce message est utilisé quand « Processus d''évaluation standard » est sélectionné dans Configuration de la revue > Paramètres > Flux des travaux > Évaluation et que l''accès de l''évaluateur-trice en un clic a été activé.'),
('REVIEW_REQUEST_ONECLICK', 'fr_FR', 'Demande d''évaluation d''un article', '{$reviewerName}:<br />\n<br />\nNous croyons que vous seriez un excellent rapporteur pour le manuscrit intitulé « {$submissionTitle} » qui a été soumis à la revue {$contextName}. Vous trouverez un résumé de la soumission ci-dessous.  Nous espérons que vous accepterez ce travail essentiel à la publication de la revue.<br />\n<br />\nVeuillez accéder au site Web de la revue avant le {$responseDueDate} pour nous informer si vous acceptez de faire l''évaluation ou non. Vous pouvez également y consulter la soumission et y enregistrer votre évaluation et votre recommandation. Le site Web se trouve à l''adresse suivante : {$contextUrl}<br />\n<br />\nDate limite pour l''évaluation {$reviewDueDate}.<br />\n<br />\nURL de la soumission : {$submissionReviewUrl}.<br />\n<br />\nEn espérant que vous accepterez notre demande, veuillez agréer l''expression de notre considération distinguée.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n« {$submissionTitle} »<br />\n<br />\n{$submissionAbstract}', 'Ce courriel du Rédacteur de rubrique à un Rapporteur demande que le rapporteur accepte ou décline la tâche d''évaluation d''une soumission. Il contient des informations sur la soumission tel que son titre et un résumé, la date d''échéance pour faire l''évaluation, et comment accéder à la soumission. Ce message est utilisé quand « Processus d''évaluation standard » a été sélectionné à l''Étape 2  de la Configuration de la revue, et que l''accès en « un clic » du rapporteur a été activé.'),
('REVIEW_REQUEST_ONECLICK', 'gd_GB', 'Iarrtas airson lèirmheas artaigil', '{$reviewerName}:<br />\n<br />\nTha mi a’ creidsinn gum biodh tu fìor mhath mar lèirmheasaiche airson na sgrìobhainn “{$submissionTitle}” a chaidh a chur gu {$contextName}. Tha geàrr-chunntas an tagraidh gu h-ìosal agus bhiomaid fada nad chomain nam b’ urrainn dhut an obair chudromach seo a dhèanamh dhuinn.<br />\n<br />\nClàraich a-steach gu làrach-lìn an iris-leabhair ron {$responseDueDate} a dh’innse an dèan thu an lèirmheas seo gus nach dèan agus a dh’fhaighinn cothrom air an tagradh agus a chlàradh do lèirmheis is do mholaidhean.<br />\n<br />\nBidh an lèirmheas fhèin ri lìbhrigeadh {$reviewDueDate}.<br />\n<br />\nURL an tagraidh: {$submissionReviewUrl}<br />\n<br />\nMòran taing airson an t-iarrtas seo a thoirt fa-near.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n“{$submissionTitle}”<br />\n<br />\n{$submissionAbstract}', 'Tha am post-d seo dheasaiche earrainn gu lèirmheasaiche a’ faighneachd an gabh iad ri lèirmheas air tagradh no an diùlt iad e. Tha e a’ toirt seachad fiosrachadh mun tagradh, mar an tiotal is geàrr-chunntas, ceann-là lìbhrigeadh an lèirmheis agus mar a gheibhear greim air an tagradh e fhèin. Thèid an teachdaireachd seo a chleachdadh nuair a thaghadh pròiseas lèirmheis stannardach ann an “Stiùireadh” > “Roghainnean” > “Sruth-obrach” > “Lèirmheas” agus nuair a bhios inntrigeadh lèirmheasaichean le aon bhriogadh an comas.'),
('REVIEW_REQUEST_ONECLICK', 'he_IL', 'בקשת סקירת מאמר', '{reviewerName}:<br$ />\nאנחנו מאמינים שאתה סוקר מצוין לבקר את ההגשה "{submissionTitle$}", ל{contextName$}. תקציר ההגשה נמצא למטה, ונשמח אם תוכל לתת חוות דעת.\n<br />\nאנא חבר לאתר כתב העת עד {responseDueDate$} לציין אם אתה מסכים, וכן לגשת לכתב היד ולהעלות את חוות דעתך ואת המלמצתך. אתר כתב היד הוא {contextUrl$}.<br />\n<br />\nחוות הדעת עצמו צריך להגיש עד {reviewDueDate$}.<br />\n<br />\nאתר הגשה: {submissionUrl$}<br />\n<br />\nתודה על עזרתך.<br />\n<br />\n{editorialContactSignature$}<br />\n<br />\n"{submissionTitle$}"<br />\n<br />\n{submissionAbstract$}', 'הודעת דוא"ל זו מעורך המדור לבודק מבקשת שהמבקר יקבל או ידחה את משימת בדיקת ההגשה. הוא מספק מידע על ההגשה כמו הכותרת והתקציר, תאריך יעד לבדיקה וכיצד לגשת להגשה עצמה. הודעה זו משמשת כאשר נבחר תהליך הבדיקה הרגיל בניהול> הגדרות> זרימת עבודה> סקירה, וגישה של בודק בלחיצה אחת מופעלת.'),
('REVIEW_REQUEST_ONECLICK', 'hi_IN', 'लेख समीक्षा का अनुरोध', '{$reviewerName}:<br />\n<br />\nमुझे विश्वास है कि आप पांडुलिपि के एक उत्कृष्ट समीक्षक के रूप में काम करेंगे, &quot;{$submissionTitle},&quot; जिसे  {$contextName}को सबमिट किया गया है। सबमिशन का सार नीचे दिया गया है, और मुझे आशा है कि आप हमारे लिए इस महत्वपूर्ण कार्य को करने पर विचार करेंगे.<br />\n<br />\nकृपया यह दिखाने के लिए कि क्या आप समीक्षा करेंगे या नहीं, साथ ही सबमिशन एक्सेस करने और अपनी समीक्षा और अनुशंसा दर्ज करने के लिए कृपया {$ responseDueDate} जर्नल में लॉग इन करें।.<br />\n<br />\nThe review itself is due {$reviewDueDate}.<br />\n<br />\nSubmission URL: {$submissionReviewUrl}<br />\n<br />\nइस अनुरोध पर विचार करने के लिए धन्यवाद.<br />\n<br />\n{$editorialContactSignature}<br />\n<br />\n&quot;{$submissionTitle}&quot;<br />\n<br />\n{$submissionAbstract}', 'सेक्शन एडिटर से लेकर समीक्षक तक का यह ईमेल अनुरोध करता है कि समीक्षक किसी सबमिशन की समीक्षा करने के कार्य को स्वीकार