

<?php $__env->startSection('content'); ?>

<!-- Begin Page Content -->
<div class="container-fluid">


    <!-- Page Heading -->
    <h1 class="h3 mb-2 text-gray-800">Website settings</h1>
    <p class="mb-2">For programmers, this template can be edited in {root-path/resources/views/settings/pixel-edit.blade.php}. Check our  
    <a target="_blank" href="https://themeforest.net/item/niva-creative-agency-freelancer-wordpress-theme/22732180"> WordPress theme</a> too.</p>
    <p class="mb-4">The Facebook pixel is an analytics tool that allows you to measure the effectiveness of your advertising by understanding the actions people take on your website. You can use the pixel to make sure your ads are shown to the right people. For more information please click <a target="_blank" href="https://www.facebook.com/business/learn/lessons/overview-of-how-facebook-pixels-work">here</a></p>

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Settings</h6>
        </div>
        <div class="card-body">


                <?php if($message = Session::get('setting_success')): ?>
                    <div class="alert alert-success alert-block">
                        <button type="button" class="close" data-dismiss="alert">×</button>    
                        <strong><?php echo e($message); ?></strong>
                    </div>
                <?php endif; ?>


                <?php echo $__env->make('includes.form-errors', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="row">

                	<div class="col-md-12">

                		<form action="<?php echo e(route('pixel-setting.update', $setting->id)); ?>" method="POST" enctype="multipart/form-data">
					        <?php echo csrf_field(); ?>
					        <?php echo method_field('PUT'); ?>

					        <div class="row">

                                <div class="col-xs-12 col-sm-12 col-md-12">
                                    <div class="form-group">
                                        <strong>Enable or disable Facebook Pixel</strong>
                                        
                                        <div class="form-check">
                                          <input class="form-check-input" type="radio" name="facebook_pixel_switch" id="pixel_switch1" value="1" 
                                            <?php if($setting->facebook_pixel_switch == 1): ?> checked <?php endif; ?>>
                                          <label class="form-check-label" for="pixel_switch1"> On  </label>
                                        </div>

                                        <div class="form-check">
                                          <input class="form-check-input" type="radio" name="facebook_pixel_switch" id="pixel_switch0" value="0" 
                                            <?php if($setting->facebook_pixel_switch == 0): ?> checked <?php endif; ?>>
                                          <label class="form-check-label" for="pixel_switch0"> Off  </label>
                                        </div>
                                        
                                        
                                    </div>
                                </div>
					   
	                           
                               <div class="col-xs-12 col-sm-12 col-md-12">
                                    <div class="form-group">
                                        <strong>Pixel code</strong>
                                        <input type="text" name="facebook_pixel" class="form-control" value="<?php echo e($setting->facebook_pixel); ?>">
                                    </div>
                                </div>

					            <div class="col-xs-12 col-sm-12 col-md-12 text-right">
					                <button type="submit" class="btn btn-primary">Update</button>
					            </div>
					        </div>

					    </form>
                		
                	</div>
                </div>

        </div>
    </div>

</div>
<!-- /.container-fluid -->




<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lucilzud/niva.lucian.host/resources/views/settings/pixel-edit.blade.php ENDPATH**/ ?>