<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>

    <?php $setting = App\Models\Setting::find($currentLang->id); ?>
    <!-- Page Title -->
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <!-- Meta Data -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <meta name="description" content="<?php echo $__env->yieldContent('meta'); ?>">
    <link rel="canonical" href="<?php echo e(url()->current()); ?>">
    <meta name="keywords" content="<?php echo e($setting->keywords); ?>" />
    <meta name="publisher" content="<?php echo e(url()->current()); ?>">
    <meta name="copyright" content="Copyright (c) <?php echo e($setting->title); ?>" />
    <meta name="author" content="<?php echo e($setting->author); ?>" />
    <meta name="contact" content="<?php echo e($setting->contact); ?>" />

    <meta name="revisit-after" content="7 Days" />
    <meta name="robots" content="index, follow" />
    <meta name="googlebot" content="index, follow" />
    <meta name="subjects" content="<?php echo e($setting->title); ?>" />
    <meta name="classification" content="<?php echo e($setting->title); ?>" />

    <meta itemprop="name" content="<?php echo $__env->yieldContent('title'); ?>">
    <meta itemprop="description" content="<?php echo $__env->yieldContent('meta'); ?>">
    <meta itemprop="image" content="<?php echo e(route('home')); ?><?php echo e($setting->photo ? '/public/images/media/' . $setting->photo->file : '/public/img/200x200.png'); ?>">
    
    <?php if($setting->OGgraph_switch == 1): ?>

    <meta property="og:title" content="<?php echo $__env->yieldContent('title'); ?>" />
    <meta property="og:type" content="website" />
    <meta property="og:url" content="<?php echo e(route('home')); ?>" />
    <meta property="og:image" content="<?php echo e(route('home')); ?><?php echo e($setting->photo ? '/public/images/media/' . $setting->photo->file : '/public/img/200x200.png'); ?>" />
    <meta property="og:site_name" content="<?php echo e($setting->author); ?>" />
    <meta property="og:description" content="<?php echo $__env->yieldContent('meta'); ?>" />
    
    <?php endif; ?>

    <?php if($setting->analytics_switch == 1): ?>

    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e($setting->analytics); ?>"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', '<?php echo e($setting->analytics); ?>');
    </script>
    
    <?php endif; ?>

    <?php if($setting->facebook_pixel_switch == 1): ?>

    <!-- Facebook Pixel Code -->
    <script>
    !function(f,b,e,v,n,t,s)
    {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
    n.callMethod.apply(n,arguments):n.queue.push(arguments)};
    if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
    n.queue=[];t=b.createElement(e);t.async=!0;
    t.src=v;s=b.getElementsByTagName(e)[0];
    s.parentNode.insertBefore(t,s)}(window, document,'script',
    'https://connect.facebook.net/en_US/fbevents.js');
    fbq('init', '<?php echo e($setting->facebook_pixel); ?>');
    fbq('track', 'PageView');
    </script>
    <noscript><img height="1" width="1" style="display:none"
    src="https://www.facebook.com/tr?id=<?php echo e($setting->facebook_pixel); ?>&ev=PageView&noscript=1"
    /></noscript>
    <!-- End Facebook Pixel Code -->
    
    <?php endif; ?>
    
    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo e($setting->favicon); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e($setting->favicon); ?>" type="image/x-icon">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.gstatic.com">

    
    <?php if($currentLang->rtl == 1): ?> 
        <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700;900&display=swap" rel="stylesheet">
    <?php else: ?> 
        <link href="<?php echo e($setting->font); ?>" rel="stylesheet">
    <?php endif; ?>
    <!-- Styles -->
    <link href="<?php echo e(asset('css/front/bootstrap.min.css')); ?>" type="text/css" rel="stylesheet">
    <link href="<?php echo e(asset('css/libs/fontawesome.min.css')); ?>" type="text/css" rel="stylesheet">
    <link href="<?php echo e(asset('css/front/owl.carousel.min.css')); ?>" type="text/css" rel="stylesheet">
    <link href="<?php echo e(asset('css/front/niva.css')); ?>" type="text/css" rel="stylesheet">
    <?php echo $__env->yieldContent('styles'); ?>

    <?php if($currentLang->rtl == 1): ?> 
        <link href="<?php echo e(asset('css/front/rtl.css')); ?>" type="text/css" rel="stylesheet">
    <?php endif; ?>


    <!-- Inline Styles -->
    <style>
        body {
            <?php if($currentLang->rtl == 1): ?> 
                font-family: 'Cairo', sans-serif;
            <?php else: ?> 
                font-family: 'Nunito', sans-serif;
            <?php endif; ?>
        }
    </style>

    <?php if($setting->custom_css): ?>
        <style>
            <?php echo $setting->custom_css; ?>

        </style>
    <?php endif; ?>

</head>
<body class="common-front <?php if($currentLang->rtl == 1): ?> rtl <?php endif; ?>" <?php if($currentLang->rtl == 1): ?> dir="rtl" <?php endif; ?>>

    <header class="header-niva">

        

        <div id="ct-topbar" class="ct-topbar-layout1">
           <div class="container">
              <div class="row">
                 <div class="ct-topbar-meta">
                    <div class="ct-topbar-item"> <i class="fas fa-phone-square-alt"></i> <label><?php echo e(clean( trans('niva-backend.call_help') , array('Attr.EnableID' => true))); ?></label> <a href="tel:<?php echo $setting->phone; ?>"><?php echo $setting->phone; ?></a></div>
                    <div class="ct-topbar-item"> <i class="fas fa-envelope-open"></i> <label><?php echo e(clean( trans('niva-backend.mail_us') , array('Attr.EnableID' => true))); ?></label> <a href="mailto:<?php echo $setting->contact; ?>"><?php echo $setting->contact; ?></a></div>
                    <div class="ct-topbar-item"> <i class="fas fa-map-marker-alt"></i> <label><?php echo e(clean( trans('niva-backend.our_address') , array('Attr.EnableID' => true))); ?></label> <span><?php echo $setting->address; ?></span></div>
                 </div>
                 <div class="ct-topbar-social">
                    <?php if(!empty($currentLang) && count($langs) > 1): ?>
                        <a class="nav-link dropdown-toggle" title="<?php echo e($currentLang->code); ?>" href="#0"  role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <img class="flag-lang" width="16" height="16" src="<?php echo e($currentLang->photo ? '/public/images/media/' . $currentLang->photo->file : '/public/img/200x200.png'); ?>"> 
                            <span><?php echo e($currentLang->code); ?></span>
                        </a>
                        <div class="dropdown-menu">
                            <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a title="<?php echo e($lang->name); ?>" class="dropdown-item" href='<?php echo e(route('changeLanguage', $lang->code)); ?>'> <img class="flag-lang" width="16" height="16" src="<?php echo e($lang->photo ? '/public/images/media/' . $lang->photo->file : '/public/img/200x200.png'); ?>">  <span><?php echo e($lang->name); ?></span></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                 </div>
              </div>
           </div>
        </div>

        <nav class="navbar navbar-expand-lg">
            <div class="container">
                <div class="row w-100">
                    
                    <div class="navbar-header col-6 col-md-2">
                        <a class="navbar-brand" href="<?php echo e(url('/')); ?>" title="<?php echo e($setting->title); ?>">
                            <img width="123" height="37" class="img-fluid logo-front" src="<?php echo e($setting->photo ? '/public/images/media/' . $setting->photo->file : '/public/img/200x200.png'); ?>" alt="">
                        </a>
                        
                    </div>

                    

                    <div class="navbar-menu  col-md-8">

                        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNiva" aria-controls="navbarNiva" aria-expanded="false" aria-label="Toggle navigation">
                            <i class="fas fa-bars"></i>
                        </button>

                        <div class="collapse navbar-collapse" id="navbarNiva">
                            <ul class="navbar-nav mr-auto ml-auto">

                                    <?php $__currentLoopData = $menus->sortBy('order'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                       
                                        <?php if($prod->on_off_submenu == 1): ?>
                                           <li class="nav-item dropdown">
                                                <a class="nav-link dropdown-toggle" href="<?php echo e($prod->link); ?>"  role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><?php echo e($prod->name); ?>

                                                </a>
                                                <?php echo $prod->submenu; ?>

                                            </li>
                                        <?php else: ?> 
                                             <li class="nav-item"> <a title="<?php echo e($prod->name); ?>" class="nav-link" href="<?php echo e($prod->link); ?>"><?php echo e($prod->name); ?></a> </li>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

             

                            </ul>
                        </div>

                    </div>


                    <div class="navbar-buttons  col-6  col-md-2">
                        
                        <div class="navbar-buttons-inner">
                            <div class="link_user_section">
                                <div class="link_user_section_inner">
                                    <?php if(Auth::guest()): ?>
                                    <a href="<?php echo e(route('login')); ?>"><i class="far fa-user"></i></a>
                                    <?php else: ?>
                                    <a href="<?php echo e(route('dashboard.index')); ?>"><i class="far fa-user"></i></a>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="side_panel_sidebar_parent">
                                <div class="side_panel_sidebar">
                                    <span class="side_panel_toggle"><span></span><span></span><span></span><span></span></span>
                                </div> 
                            </div>
                        </div>
                        


                    </div>

                </div>
            </div>
            
        </nav>
    </header>
    
    <div class="fixed-sidebar-menu-overlay" style="opacity: 0;"></div>

    <div class="fixed-sidebar-menu-holder header7">
        <div class="fixed-sidebar-menu">
            <div class="close-sidebar"></div>
            <div class="header7 sidebar-content">
                <div class="left-side">
                    <aside class="widget_sweetthemes_address_social_icons">
                        <div class="address-social-links">
                            <h5 class="widget-title"><?php echo e($headerfooter->sidebar_title); ?></h5>
                            <div class="contact-details">
                                <?php echo $headerfooter->sidebar_description; ?>

                            </div>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->yieldContent('content'); ?>

    <div class="typed-section">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                        <h4 class="parent-typed-text">
                        <span class="mt_typed-beforetext"><?php echo e($headerfooter->typed_title); ?> </span>
                            <span class="mt_typed_text"></span>

                        </h4>
                </div>
                <div class="col-md-4 text-right">
                    <a href="<?php echo e($headerfooter->typed_buttonlink); ?>" target="_self" class="btn btn-style1"><span><?php echo e($headerfooter->typed_buttontext); ?></span></a>
                </div>
            </div>
        </div>
    </div>


    <footer class="footer-section">
        <div class="footer-wrapper">
            <div class="row align-items-end">
                <div class="col-lg-6">
                    <div class="footer-left">
                        <div class="inner">
                            <span><?php echo e($headerfooter->footer_col1_subtitle); ?></span>
                            <h4><?php echo e($headerfooter->footer_col1_title); ?></h4>
                            <a class="btn btn-style2" href="<?php echo e($headerfooter->footer_col1_buttonlink); ?>"> <span><?php echo e($headerfooter->footer_col1_buttontext); ?></span> </a> 
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="footer-right">
                        <div class="row">
                            <div class="col-lg-6 col-sm-6 col-12">
                                <div class="footer-widget">
                                    <div class="footer-widget widget_nav_menu">
                                        <h4 class="title"><?php echo e($headerfooter->footer_col2_title1); ?></h4>
                                        <span class="niva-animate-border"></span>
                                        <div class="menu-quick-link-container">
                                            <?php echo $headerfooter->footer_col2_html1; ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-6 col-12">
                                <div class="footer-widget">
                                    <div class="widget widget_custom_html">
                                        <h4 class="title"><?php echo e($headerfooter->footer_col2_title2); ?></h4>
                                        <span class="niva-animate-border"></span>
                                        <div class="custom-html-widget">
                                            <?php echo $headerfooter->footer_col2_html2; ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="copyright-text">
                                    <?php echo $headerfooter->footer_copyright; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>


    <div class="progress-wrap">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"/>
        </svg>
    </div>




    <?php if($setting->SchmeaORG_switch == 1): ?>

    <div class="hidden"  itemscope="" itemtype="https://schema.org/LocalBusiness">
        <span itemprop="description"><?php echo $__env->yieldContent('meta'); ?></span> 
        <a itemprop="url" href="<?php echo e(route('home')); ?>"> </a>
        <div itemprop="image" itemscope itemtype="http://schema.org/ImageObject">
        <img src="<?php echo e(route('home')); ?><?php echo e($setting->photo ? '/public/images/media/' . $setting->photo->file : '/public/img/200x200.png'); ?>" alt="logo" width="120" itemprop="url"></div>
        <span itemprop="name"><?php echo e($setting->title); ?></span>
        <em><span itemprop="priceRange"><?php echo e($setting->price_range); ?></span></em>
        <div itemprop="address" itemscope="" itemtype="https://schema.org/PostalAddress"> 
            <span itemprop="addressLocality"><?php echo e($setting->address); ?></span> | 
            <span itemprop="addressCountry"><?php echo e($setting->country); ?></span> | 
            <span itemprop="telephone"><?php echo e($setting->phone); ?></span> | 
            <span itemprop="email"><?php echo e($setting->contact); ?></span>
        </div>
    </div> 

    <?php endif; ?>


    <?php if($setting->whatsapp == 1): ?>
    <a target="_blank" class="codeless-add-purchase-button" href="https://wa.me/<?php echo e($setting->phone); ?>"><i class="icon"><svg height="682pt" viewBox="-23 -21 682 682.66669" width="682pt" xmlns="http://www.w3.org/2000/svg"><path d="m544.386719 93.007812c-59.875-59.945312-139.503907-92.9726558-224.335938-93.007812-174.804687 0-317.070312 142.261719-317.140625 317.113281-.023437 55.894531 14.578125 110.457031 42.332032 158.550781l-44.992188 164.335938 168.121094-44.101562c46.324218 25.269531 98.476562 38.585937 151.550781 38.601562h.132813c174.785156 0 317.066406-142.273438 317.132812-317.132812.035156-84.742188-32.921875-164.417969-92.800781-224.359376zm-224.335938 487.933594h-.109375c-47.296875-.019531-93.683594-12.730468-134.160156-36.742187l-9.621094-5.714844-99.765625 26.171875 26.628907-97.269531-6.269532-9.972657c-26.386718-41.96875-40.320312-90.476562-40.296875-140.28125.054688-145.332031 118.304688-263.570312 263.699219-263.570312 70.40625.023438 136.589844 27.476562 186.355469 77.300781s77.15625 116.050781 77.132812 186.484375c-.0625 145.34375-118.304687 263.59375-263.59375 263.59375zm144.585938-197.417968c-7.921875-3.96875-46.882813-23.132813-54.148438-25.78125-7.257812-2.644532-12.546875-3.960938-17.824219 3.96875-5.285156 7.929687-20.46875 25.78125-25.09375 31.066406-4.625 5.289062-9.242187 5.953125-17.167968 1.984375-7.925782-3.964844-33.457032-12.335938-63.726563-39.332031-23.554687-21.011719-39.457031-46.960938-44.082031-54.890626-4.617188-7.9375-.039062-11.8125 3.476562-16.171874 8.578126-10.652344 17.167969-21.820313 19.808594-27.105469 2.644532-5.289063 1.320313-9.917969-.664062-13.882813-1.976563-3.964844-17.824219-42.96875-24.425782-58.839844-6.4375-15.445312-12.964843-13.359374-17.832031-13.601562-4.617187-.230469-9.902343-.277344-15.1875-.277344-5.28125 0-13.867187 1.980469-21.132812 9.917969-7.261719 7.933594-27.730469 27.101563-27.730469 66.105469s28.394531 76.683594 32.355469 81.972656c3.960937 5.289062 55.878906 85.328125 135.367187 119.648438 18.90625 8.171874 33.664063 13.042968 45.175782 16.695312 18.984374 6.03125 36.253906 5.179688 49.910156 3.140625 15.226562-2.277344 46.878906-19.171875 53.488281-37.679687 6.601563-18.511719 6.601563-34.375 4.617187-37.683594-1.976562-3.304688-7.261718-5.285156-15.183593-9.253906zm0 0" fill-rule="evenodd"/></svg></i></a>
    <?php endif; ?>


    <script src="<?php echo e(asset('js/libs/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/front/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/front/bootstrap.min.js')); ?>" defer></script>
    <script src="<?php echo e(asset('js/front/owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/front/simpleParallax.min.js')); ?>" defer></script>
    <script src="<?php echo e(asset('js/front/countTO.js')); ?>" defer></script>
    <script src="<?php echo e(asset('js/front/typed.min.js')); ?>" defer></script>
    <script src="<?php echo e(asset('js/front/niva.js')); ?>" defer></script>





    <?php echo $__env->make('cookieConsent::index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

      <section class="sweet-buy-section">

        <div class="sweet-buy-related" style="top: calc(30% - 25px);">
            <a target="_blank" href="https://themeforest.net/item/niva-creative-agency-freelancer-wordpress-theme/22732180">
                <div class="sweet-btn">
                    <span class="sweet-icon">
                        <svg x="0px" y="0px"
                             viewBox="0 0 511.992 511.992">
                        <path  d="M411.809,2.806c-18.304-8.992-111.168,1.28-178.112,65.504
                            C128.225,173.622,130.753,312.374,130.753,312.374s-3.488,14.272-18.336-6.432c-32.512-41.44-15.488-136.768-13.568-150.048
                            c2.688-18.72-9.248-19.264-14.208-13.088C-32.863,305.942,73.249,439.51,142.721,481.91c81.344,49.632,241.792,49.6,305.696-91.2
                            C528.033,215.382,434.753,14.038,411.809,2.806z"/>

                        </svg>
                    </span>
                    <span class="sweet-text-name">RELATED</span>
                </div>
            </a>
        </div>

        <div class="sweet-purchase" style="top: calc(30% + 25px);">
            <a target="_blank" href="https://codecanyon.net/checkout/from_item/31152501?license=regular&size=source&support=bundle_12month">
                <span class="sweet-icon">
                    <svg x="0px" y="0px" viewBox="0 0 24 24">
                        <circle cx="9" cy="21" r="2"></circle>
                        <circle cx="20" cy="21" r="2"></circle>
                        <path d="M23.8,5.4C23.6,5.1,23.3,5,23,5H6.8L6,0.8C5.9,0.3,5.5,0,5,0H1C0.4,0,0,0.4,0,1s0.4,1,1,1h3.2L5,6.2c0,0,0,0.1,0,0.1
                            l1.7,8.3C7,16,8.2,17,9.6,17c0,0,0,0,0.1,0h9.7c1.5,0,2.7-1,3-2.4L24,6.2C24,5.9,24,5.6,23.8,5.4z"></path>
                        </svg>
                </span>
                <span class="sweet-purchase-text">BUY NOW</span>
            </a>
        </div>

        
    </section>

    <style scoped>
        section.sweet-buy-section {
            width: 300px;
            height: 100%;
            min-height: 100%;
            position: fixed;
            right: -300px;
            top: 0;
            z-index: 777777;
        }
        .sweet-purchase, .sweet-buy-related {
            position: absolute;
            left: -127px;
            z-index: 777777;
            font-size: 12px !important;
            letter-spacing: .07em;
            display: block;
            height: 44px;
            width: 127px;
        }
        .sweet-buy-related .sweet-btn, .sweet-purchase a {
            position: relative;
            display: block;
            cursor: pointer;
            font-size: 0 !important;
            line-height: 44px !important;
            font-weight: 500;
        }
        span.sweet-icon {
            color: #fff;
            width: 44px;
            display: inline-block;
            line-height: 1 !important;
            text-align: center;
            vertical-align: middle;
            position: relative;
        }
        span.sweet-text-name {
            color: #000;
            font-size: 12px !important;
            letter-spacing: 0.07em !important;
                font-weight: 500;
        }
        .sweet-purchase {
            background-color: #6164ff;
            box-shadow: 0 0 9.5px 0.3px rgba(0, 0, 0, 0.1);
        }
        span.sweet-purchase-text {
            color: #fff;
            font-size: 12px !important;
            letter-spacing: .11em !important;
                font-weight: 500;
        }
        span.sweet-icon svg {
            max-width: 20px;
            fill: #fff;
            height: 16px;
            position: relative;
            bottom: 4px;
            right: -2px;
        }
        .sweet-buy-related {
            background-color: #fff;
            box-shadow: 0 0 9.5px 0.3px rgba(0, 0, 0, 0.1);
        }
        .sweet-buy-related svg {
            fill: rgb(130, 181, 65) !important;
        }
        .rtl .sweet-purchase {
    padding-left: 15px;
}
.rtl .sweet-btn {
    padding-left: 15px;
}
</style>



    <script type="text/javascript">
    ( function ( $ ) {
        'use strict';
        $( document ).ready( function () {
            /* TYPED TEXT */
            $(function(){
                $(".mt_typed_text").typed({
                  strings: <?php echo $headerfooter->typed_text; ?>,
                  typeSpeed: 1,
                  backDelay: 2000,
                  loop: true
                });
            });
        })
    } ( jQuery ) )
    </script>

    <?php if($setting->custom_css): ?>
        <script type="text/javascript">
            <?php echo $setting->custom_js; ?>

        </script>
    <?php endif; ?>

    <?php echo $__env->yieldContent('scripts'); ?>



</body>
</html>
<?php /**PATH /home/lucilzud/niva4.lucian.host/resources/views/layouts/front.blade.php ENDPATH**/ ?>