from dataclasses import dataclass, asdict
from defence360agent.contracts import config


@dataclass
class MILicenseType:
    FREEMIUM = "Freemium"


@dataclass
class IncompatibilityID:
    """
    Contains unique incompatibilities IDs for a billing
    """

    UNSUPPORTED_LICENSE = "LICENSE_IS_NOT_SUPPORTED"


@dataclass
class CompatibilityIssue:
    """
    Generic class for keeping compatibility issues with WHMCS
    """

    type: str
    description: str

    @property
    def dict_repr(self):
        return asdict(self)


def get_license_type():
    if config.is_mi_freemium_license():
        return MILicenseType.FREEMIUM
    return None


async def collect_billing_incompatibilities():
    """
    Collects all incompatibilities for WHMCS:
    1. No Freemium license means WHMCS cannot configure current server
    2. ....
    """
    issues = []
    if get_license_type() != MILicenseType.FREEMIUM:
        issues.append(
            CompatibilityIssue(
                type=IncompatibilityID.UNSUPPORTED_LICENSE,
                description=(
                    "There is no supported MyImunify license on the server"
                ),
            ).dict_repr
        )
    return issues
