<?php

/**
 * The Cymraeg language file - Welsh (Cymraeg) translation
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at https://mozilla.org/MPL/2.0/.
 *
 * @package phpMyFAQ
 * @author Duncan Thomas AKA Pinman <pinman@gmail.com>
 * @copyright 2006-2024 phpMyFAQ Team
 * @license https://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link https://www.phpmyfaq.de
 * @since 2006-08-23
 * @codingStandardsIgnoreFile
 */

$PMF_LANG["metaCharset"] = "UTF-8";
$PMF_LANG["metaLanguage"] = "cy";
$PMF_LANG["language"] = "cymraeg";
$PMF_LANG['direction'] = "ltr";
$PMF_LANG["nplurals"] = "4";

// Navigation
$PMF_LANG["msgCategory"] = "Categorïau";
$PMF_LANG["msgShowAllCategories"] = "Dangos yr holl gategorïau";
$PMF_LANG["msgSearch"] = "chwilio";
$PMF_LANG["msgAddContent"] = "Ychwanegu cynnwys";
$PMF_LANG["msgQuestion"] = "Gofyn cwestiwn";
$PMF_LANG["msgOpenQuestions"] = "Cwestiynau agored";
$PMF_LANG["msgHelp"] = "Help";
$PMF_LANG["msgContact"] = "Cyswllt";
$PMF_LANG["msgHome"] = "Hafan";
$PMF_LANG["msgNews"] = "Cwestiynau Cyffredin - Newyddion";
$PMF_LANG["msgUserOnline"] = " Defnyddwyr ar-lein";
$PMF_LANG["msgXMLExport"] = "Ffeil-XML";
$PMF_LANG["msgBack2Home"] = "Nôl i'r hafan";

// Contentpages
$PMF_LANG["msgFullCategories"] = "Categorïau gyda chofnodion";
$PMF_LANG["msgFullCategoriesIn"] = "Categorïau gyda chofnodion yn ";
$PMF_LANG["msgSubCategories"] = "Isgategorïau";
$PMF_LANG["msgEntries"] = "Cofnodion";
$PMF_LANG["msgEntriesIn"] = "Cwestiynau yn ";
$PMF_LANG["msgViews"] = "safbwyntiau";
$PMF_LANG["msgPage"] = "Tudalen ";
$PMF_LANG["msgPages"] = " Tudalennau";
$PMF_LANG["msgPrevious"] = "blaenorol";
$PMF_LANG["msgNext"] = "nesaf";
$PMF_LANG["msgCategoryUp"] = "un categori yn uwch";
$PMF_LANG["msgLastUpdateArticle"] = "Diweddariad diwethaf: ";
$PMF_LANG["msgAuthor"] = "Awdur: ";
$PMF_LANG["msgPrinterFriendly"] = "fersiwn y gellir ei hargraffu";
$PMF_LANG["msgPrintArticle"] = "Argraffu'r cofnod hwn";
$PMF_LANG["msgMakeXMLExport"] = "Allforio fel ffeil-XML";
$PMF_LANG["msgAverageVote"] = "Cyfradd gyfartalog";
$PMF_LANG["msgVoteUsability"] = "Graddiwch y cofnod hwn";
$PMF_LANG["msgVoteFrom"] = "oddi wrth";
$PMF_LANG["msgVoteBad"] = "hollol ddiwerth";
$PMF_LANG["msgVoteGood"] = "gwerthfawr iawn";
$PMF_LANG["msgVotings"] = "Pleidleisiau ";
$PMF_LANG["msgVoteSubmit"] = "Pleidlais";
$PMF_LANG["msgVoteThanks"] = "Diolch yn fawr am eich pleidlais!";
$PMF_LANG["msgYouCan"] = "Gallech ";
$PMF_LANG["msgWriteComment"] = "awgrymu sylwadau ar y cofnod hwn";
$PMF_LANG["msgShowCategory"] = "Golwg gyffredinol o'r Cynnwys: ";
$PMF_LANG["msgCommentBy"] = "Sylw ";
$PMF_LANG["msgCommentHeader"] = "Cyflwyno sylw ar y cofnod hwn";
$PMF_LANG["msgYourComment"] = "Eich sylwadau";
$PMF_LANG["msgCommentThanks"] = "Diolch yn fawr am eich sylwadau!";
$PMF_LANG["msgSend2Friend"] = "Anfon at ffrind";
$PMF_LANG["msgS2FButton"] = "anfon e-bost";

// Search
$PMF_LANG["msgSearchWord"] = "Gair allweddol";
$PMF_LANG["msgSearchFind"] = "Canlyniad chwilio am ";
$PMF_LANG["msgSearchAmount"] = " Canlyniad chwilio";
$PMF_LANG["msgSearchAmounts"] = " Canlyniadau chwilio";
$PMF_LANG["msgSearchCategory"] = "Categori: ";
$PMF_LANG["msgSearchContent"] = "Cynnwys: ";

// new Content
$PMF_LANG["msgNewContentHeader"] = "Cynigion ar gyfer Cwestiynau Cyffredin";
$PMF_LANG["msgNewContentAddon"] = "Ni fydd eich awgrym yn ymddangos ar unwaith, ond bydd yn cael ei wirio gennym ni cyn ei gyhoeddi. Mae meysydd gorfodol yn feysydd sydd wedi'u marcio â *.";
$PMF_LANG["msgNewContentName"] = "Eich Enw";
$PMF_LANG["msgNewContentMail"] = "Eich cyfeiriad e-bost";
$PMF_LANG["msgNewContentCategory"] = "Pa gategori i'w ddewis?";
$PMF_LANG["msgNewContentTheme"] = "Pennawd";
$PMF_LANG["msgNewContentArticle"] = "Cofnod Eich Cwestiynau Cyffredin";
$PMF_LANG["msgNewContentKeywords"] = "Geiriau Allweddol";
$PMF_LANG["msgNewContentLink"] = "Dolen y cofnod hwn";
$PMF_LANG["msgNewContentSubmit"] = "cyflwyno";
$PMF_LANG["msgInfo"] = "Mwy o wybodaeth: ";
$PMF_LANG["msgNewContentThanks"] = "Diolch am eich awgrym!";
$PMF_LANG["msgNoQuestionsAvailable"] = "Nid oes cwestiynau i'w hystyried ar hyn o bryd.";

// ask Question
$PMF_LANG["msgNewQuestion"] = "Gofynnwch eich cwestiwn isod";
$PMF_LANG["msgAskCategory"] = "Eich cwestiwn am gategori";
$PMF_LANG["msgAskYourQuestion"] = "Eich cwestiwn";
$PMF_LANG["msgAskThx4Mail"] = "<h2> Diolch am eich cwestiwn!</h2>";
$PMF_LANG["msgDate_User"] = "Dyddiad / Defnyddiwr";
$PMF_LANG["msgQuestion2"] = "Cwestiwn";
$PMF_LANG["msg2answer"] = "Ateb";
$PMF_LANG["msgQuestionText"] = "Gallwch weld cwestiynau a ofynnwyd gan ddefnyddwyr eraill yma. Os byddwch yn ateb y cwestiynau hyn, efallai caiff eich atebion eu cynnwys yn y Cwestiynau Cyffredin.";

// Help
$PMF_LANG["msgHelpText"] = "Mae strwythur CC (Cwestiynau Cyffredin) yn eithaf syml. Gallwch naill ai chwilior <strong><a href=\"?action=show\">Categorïau</a></strong> neu adael i <strong><a href=\"?action=search\">beiriant chwilio CC</a></strong> chwilio am eiriau allweddol.";

// Contact
$PMF_LANG["msgContactEMail"] = "e-bostio at y gwefeistr";
$PMF_LANG["msgMessage"] = "Eich neges";

// Startseite
$PMF_LANG["msgNews"] = " Newyddion";
$PMF_LANG["msgTopTen"] = "10 UCHAF";
$PMF_LANG["msgHomeThereAre"] = "Mae ";
$PMF_LANG["msgHomeArticlesOnline"] = " cofnod ar-lein";
$PMF_LANG["msgNoNews"] = "Prin chwedl, llawen chwedl.";
$PMF_LANG["msgLatestArticles"] = "Y pum cwestiwn a ofynnwyd yn fwyaf diweddar";

// E-Mailbenachrichtigung
$PMF_LANG["msgMailThanks"] = "Diolch yn fawr am eich cynnig i'r Cwestiynau Cyffredin.";
$PMF_LANG["msgMailCheck"] = "Mae cofnod newydd yn y Cwestiynau Cyffredin! Gwiriwch yr adran weinyddol!";
$PMF_LANG["msgMailContact"] = "Anfonwyd eich neges at y gweinyddwr.";

// Fehlermeldungen
$PMF_LANG["err_noDatabase"] = "Does dim cysylltiad cronfa ddata ar gael.";
$PMF_LANG["err_noHeaders"] = "Ni chafwyd categori.";
$PMF_LANG["msgErrorNoRecords"] = "Dim cofnodion ar gael.";
$PMF_LANG["err_badID"] = "Gwybodaeth adnabod anghywir.";
$PMF_LANG["err_noTopTen"] = "Does dim Deg Uchaf ar gael eto.";
$PMF_LANG["err_nothingFound"] = "Ni chafwyd cofnod.";
$PMF_LANG["err_SaveEntries"] = " Y meysydd gofynnol yw <strong>eich enw</strong>, <strong> eich cyfeiriad e-bost</strong>, <strong>categori</strong>, <strong>pennawd</strong>, <strong> eich cofnod </strong> a phan ofynnir amdano, <strong>Captcha Code</strong>!<br><br>\n<a href=\"javascript:history.back();\">un dudalen yn ôl</a><br><br>\n";
$PMF_LANG["err_SaveComment"] = " Y meysydd gofynnol yw <strong> eich enw </strong>, <strong> eich cyfeiriad e-bost </strong>, <strong> eich sylwadau</strong> a phan ofynnir amdano, <strong>Captcha Code</strong>!<br><br>\n<a href=\"javascript:history.back();\">un dudalen yn ôl </a><br><br>\n";
$PMF_LANG["err_VoteTooMuch"] = " nid ydym yn cyfrif pleidleisio ddwywaith. Cliciwch yma, i fynd yn ôl.";
$PMF_LANG["err_noVote"] = "<strong> ni wnaethoch ateb y cwestiwn hwn!</strong> <a href=\"javascript:history.back();\">Cliciwch yma </a>, to vote.";
$PMF_LANG["err_noMailAdress"] = " nid yw eich cyfeiriad e-bost yn gywir.<br><a href=\"javascript:history.back();\">back</a>";
$PMF_LANG["err_sendMail"] = " Y meysydd gofynnol yw <strong> eich enw </strong>, <strong> eich cyfeiriad e-bost </strong>, <strong> eich cwestiwn</strong> a phan ofynnir amdano, <strong>Captcha Code</strong>!";

// Hilfe zur Suche
$PMF_LANG["help_search"] = "<strong> chwilior cofnodion:</strong><br> Gyda chofnod fel <strong style=\"color: Red;\"> gair1 gair2</strong> gallwch wneud chwiliad yn ôl perthnasedd ar gyfer dau faen prawf chwilio neu fwy.<strong> Sylwer:</strong> rhaid ich maen prawf chwilio fod o leiaf 4 llythyren neu fel arall bydd eich cais yn cael ei wrthod.";

// Menü
$PMF_LANG["ad"] = "ADRAN WEINYDDOL";
$PMF_LANG["ad_menu_user_administration"] = "Gweinyddiaeth y Defnyddiwr";
$PMF_LANG["ad_menu_entry_aprove"] = "Cymeradwyo Cofnodion";
$PMF_LANG["ad_menu_entry_edit"] = "Golygu Cofnodion";
$PMF_LANG["ad_menu_categ_add"] = "Ychwanegu Categori";
$PMF_LANG["msgHeaderCategoryOverview"] = "Golygu Categori";
$PMF_LANG["ad_menu_news_add"] = "Ychwanegu Newyddion";
$PMF_LANG["ad_menu_news_edit"] = "Golygu Newyddion";
$PMF_LANG["ad_menu_open"] = "Golygu cwestiynau agored";
$PMF_LANG["ad_menu_stat"] = "Ystadegau";
$PMF_LANG["ad_menu_cookie"] = "Cwcis";
$PMF_LANG["ad_menu_session"] = "Gweld Sesiynau";
$PMF_LANG["ad_menu_adminlog"] = "Gweld log gweinyddol";
$PMF_LANG["ad_menu_passwd"] = "Newid cyfrinair";
$PMF_LANG["ad_menu_logout"] = "Allgofnodi";
$PMF_LANG["ad_menu_startpage"] = "Tudalen cychwyn";

// Nachrichten
$PMF_LANG["ad_msg_identify"] = "Cyflwynwch eich hun.";
$PMF_LANG["ad_msg_passmatch"] = "Rhaid i'r ddau gyfrinair <strong>gyd-fynd</strong>!";
$PMF_LANG["ad_msg_savedsuc_1"] = "Proffil";
$PMF_LANG["ad_msg_savedsuc_2"] = "cadwyd yn llwyddiannus.";
$PMF_LANG["ad_msg_mysqlerr"] = "Oherwydd <strong>gwall cronfa ddata</strong>, ni ellir cadw'r proffil.";
$PMF_LANG["ad_msg_noauth"] = "Nid oes gennych ganiatâd.";

// Allgemein
$PMF_LANG["ad_gen_page"] = "Tudalen";
$PMF_LANG["ad_gen_of"] = "o";
$PMF_LANG["ad_gen_lastpage"] = "Tudalen Blaenorol";
$PMF_LANG["ad_gen_nextpage"] = "Tudalen Nesaf";
$PMF_LANG["ad_gen_save"] = "Cadw";
$PMF_LANG["ad_gen_reset"] = "Ailosod";
$PMF_LANG["ad_gen_yes"] = "Ie";
$PMF_LANG["ad_gen_no"] = "Na";
$PMF_LANG["ad_gen_top"] = "Brig y tudalen";
$PMF_LANG["ad_gen_ncf"] = "Ni chafwyd categori!";
$PMF_LANG["ad_gen_delete"] = "Dileu";

// Benutzerverwaltung
$PMF_LANG["ad_user"] = "Gweinyddiaeth y Defnyddiwr";
$PMF_LANG["ad_user_username"] = "Defnyddwyr cofrestredig";
$PMF_LANG["ad_user_rights"] = "Hawliau Defnyddiwr";
$PMF_LANG["ad_user_edit"] = "golygu";
$PMF_LANG["ad_user_delete"] = "dileu";
$PMF_LANG["ad_user_add"] = "Ychwanegu Defnyddiwr";
$PMF_LANG["ad_user_profou"] = "Proffil y defnyddiwr";
$PMF_LANG["ad_user_name"] = "Enw";
$PMF_LANG["ad_user_password"] = "Cyfrinair";
$PMF_LANG["ad_user_confirm"] = "Cadarnhau";
$PMF_LANG["ad_user_rights"] = "Hawliau";
$PMF_LANG["ad_user_del_1"] = "Y Defnyddiwr";
$PMF_LANG["ad_user_del_2"] = "dileu?";
$PMF_LANG["ad_user_del_3"] = "Ydych chi'n siwr?";
$PMF_LANG["ad_user_deleted"] = "Dilëwyd y defnyddiwr yn llwyddiannus.";
$PMF_LANG["ad_user_checkall"] = "Dewis oll";

// Beitragsverwaltung
$PMF_LANG["msgHeaderFAQOverview"] = "Gweinyddu Cofnodion";
$PMF_LANG["ad_entry_id"] = "Gwybodaeth Adnabod";
$PMF_LANG["ad_entry_topic"] = "Pwnc";
$PMF_LANG["ad_entry_action"] = "Gweithred";
$PMF_LANG["ad_entry_edit_1"] = "Golygu Cofnod";
$PMF_LANG["ad_entry_edit_2"] = "";
$PMF_LANG["ad_entry_theme"] = "Thema";
$PMF_LANG["ad_entry_content"] = "Cynnwys";
$PMF_LANG["ad_entry_keywords"] = "Geiriau Allweddol";
$PMF_LANG["ad_entry_author"] = "Awdur";
$PMF_LANG["ad_entry_category"] = "Categori";
$PMF_LANG["ad_entry_active"] = "Gweithredol?";
$PMF_LANG["ad_entry_date"] = "Dyddiad";
$PMF_LANG["ad_entry_status"] = "Status der FAQ";
$PMF_LANG["ad_entry_changed"] = "Newidiwyd?";
$PMF_LANG["ad_entry_changelog"] = "Newid log";
$PMF_LANG["ad_entry_commentby"] = "Sylw gan";
$PMF_LANG["ad_entry_comment"] = "Sylwadau";
$PMF_LANG["ad_entry_save"] = "Cadw";
$PMF_LANG["msgDelete"] = "dileu";
$PMF_LANG["ad_entry_delcom_1"] = "Ydych chi'n siwr dylid dileu sylw'r defnyddiwr";
$PMF_LANG["ad_entry_delcom_2"] = " Dylid ei ddileu?";
$PMF_LANG["ad_entry_commentdelsuc"] = "Dilëwyd y sylw yn <strong>llwyddiannus</strong>.";
$PMF_LANG["ad_entry_back"] = "Yn ôl i'r erthygl";
$PMF_LANG["ad_entry_commentdelfail"] = "Ni <strong>ddilëwyd</strong> y sylw.";
$PMF_LANG["ad_entry_savedsuc"] = "Cadwyd y newidiadau yn <strong>llwyddiannus</strong>.";
$PMF_LANG["ad_entry_savedfail"] = "Yn anffodus, roedd gwall yn y gronfa ddata.";
$PMF_LANG["ad_entry_del_1"] = "Ydych chi'n siwr dylid dileu'r pwnc";
$PMF_LANG["ad_entry_del_2"] = "of";
$PMF_LANG["ad_entry_del_3"] = " Dylid ei ddileu
?";
$PMF_LANG["ad_entry_delsuc"] = " y mater <strong> yn llwyddiannus </strong> Dilëwyd.";
$PMF_LANG["ad_entry_delfail"] = "Dilëwyd y mater yn llwyddiannus!";
$PMF_LANG["ad_entry_back"] = "Yn ôl";


// Newsverwaltung
$PMF_LANG["ad_news_header"] = "Pennawd yr Erthygl";
$PMF_LANG["ad_news_text"] = "Testun y Cofnod";
$PMF_LANG["ad_news_link_url"] = "Dolen: (<strong>without https://</strong>)!";
$PMF_LANG["ad_news_link_title"] = "Teitl y ddolen";
$PMF_LANG["ad_news_link_target"] = "Targed y ddolen";
$PMF_LANG["ad_news_link_window"] = "Bydd y ddolen yn agor ffenestr newydd";
$PMF_LANG["ad_news_link_faq"] = "Dolen o fewn y Cwestiynau Cyffredinol";
$PMF_LANG["ad_news_add"] = "Ychwanegu Newyddion";
$PMF_LANG["ad_news_id"] = "#";
$PMF_LANG["ad_news_headline"] = "Pennawd";
$PMF_LANG["ad_news_date"] = "Dyddiad";
$PMF_LANG["ad_news_action"] = "Gweithred";
$PMF_LANG["ad_news_update"] = "diweddariad";
$PMF_LANG["ad_news_delete"] = "dileu";
$PMF_LANG["ad_news_nodata"] = "Ni chafwyd data yn y gronfa ddata";
$PMF_LANG["ad_news_updatesuc"] = "Diweddarwyd y Newyddion.";
$PMF_LANG["ad_news_del"] = "Ydych chi'n siwr eich bod am ddileu'r eitem newyddion hon?";
$PMF_LANG["ad_news_yesdelete"] = "ydw, dilëwch!";
$PMF_LANG["ad_news_nodelete"] = "nac ydw!";
$PMF_LANG["ad_news_delsuc"] = "Dilëwyd yr eitem newyddion.";
$PMF_LANG["ad_news_updatenews"] = "Diweddaru'r newyddion";

// Kategorieverwaltung
$PMF_LANG["ad_categ_new"] = "Ychwanegu categori newydd";
$PMF_LANG["ad_categ_catnum"] = "Rhif Categori";
$PMF_LANG["ad_categ_subcatnum"] = "Rhif Isgategori";
$PMF_LANG["ad_categ_nya"] = "<em>ddim ar gael eto!</em>";
$PMF_LANG["ad_categ_titel"] = "Tetil y Categori";
$PMF_LANG["ad_categ_add"] = "Ychwanegu Categori";
$PMF_LANG["ad_categ_existing"] = "Categorïau Presennol";
$PMF_LANG["ad_categ_id"] = "#";
$PMF_LANG["ad_categ_categ"] = "Categori";
$PMF_LANG["ad_categ_subcateg"] = "Isgategori";
$PMF_LANG["ad_categ_titel"] = "Tetil y Categori";
$PMF_LANG["ad_categ_action"] = "Gweithred";
$PMF_LANG["ad_categ_update"] = "diweddaru";
$PMF_LANG["ad_categ_delete"] = "dileu";
$PMF_LANG["ad_categ_updatecateg"] = "Diweddaru'r Categori";
$PMF_LANG["ad_categ_nodata"] = "Ni chafwyd data yn y gronfa ddata";
$PMF_LANG["msgCategoryRemark"] = "Sylwch na fydd cofnodion presennol yn weladwy bellach os byddwch yn dileu'r categori. Rhaid i chi neilltuo categori newydd i'r erthygl neu ddileu'r erthygl.";
$PMF_LANG["ad_categ_edit_1"] = "Golygu";
$PMF_LANG["ad_categ_edit_2"] = "Categori";
$PMF_LANG["ad_categ_add"] = "ychwanegu Categori";
$PMF_LANG["ad_categ_added"] = "Ychwanegwyd y categori.";
$PMF_LANG["ad_categ_updated"] = "Diweddarwyd y categori.";
$PMF_LANG["ad_categ_del_yes"] = "ie, dilëwch!";
$PMF_LANG["ad_categ_del_no"] = "na!";
$PMF_LANG["ad_categ_deletesure"] = "Ydych chi'n siwr eich bod am ddileu'r categori hwn?";
$PMF_LANG["ad_categ_deleted"] = "Dilëwyd y categori.";

// Cookies
$PMF_LANG["ad_cookie_cookiesuc 	"] = "Gosodwyd y cwci'n llwyddiannus.";
$PMF_LANG["ad_cookie_already"] = "osodwyd cwci eisoes. Mae gennych y dewisiadau canlynol";
$PMF_LANG["ad_cookie_again"] = "Gosod cwci eto";
$PMF_LANG["ad_cookie_delete"] = "dileu cwci";
$PMF_LANG["ad_cookie_no"] = "Nid oes cwci wedi'i gadw eto. Gyda chwci gallech gadw eich sgript mewngofnodi a bydd dim rhaid i chi gofio eich manylion mewngofnodi eto. Mae gennych y dewisiadau canlynol";
$PMF_LANG["ad_cookie_set"] = "Gosod cwci";
$PMF_LANG["ad_cookie_deleted"] = "Dilëwyd cwci'n llwyddiannus.";

// Adminlog
$PMF_LANG["ad_adminlog"] = "Log gweinyddol";

// Passwd
$PMF_LANG["ad_passwd_cop"] = "Newid eich Cyfrinair";
$PMF_LANG["ad_passwd_old"] = "Hen gyfrinair";
$PMF_LANG["ad_passwd_new"] = "Cyfrinair newydd";
$PMF_LANG["ad_passwd_con"] = "Cadarnhau";
$PMF_LANG["ad_passwd_change"] = "Newid cyfrinair";
$PMF_LANG["ad_passwd_suc"] = "Newidiwyd y cyfrinair yn llwyddiannus.";
$PMF_LANG["ad_passwd_remark"] = "<strong>SYLWER:</strong><br>Rhaid gosod cwci eto!";
$PMF_LANG["ad_passwd_fail"] = "Rhaid cyflwyno'r hen gyfrinair yn gywir a rhaid i'r ddau newydd gyd-fynd.";

// Adduser
$PMF_LANG["ad_adus_adduser"] = "Ychwanegu defnyddiwr";
$PMF_LANG["ad_adus_name"] = "Enw";
$PMF_LANG["ad_adus_password"] = "Cyfrinair";
$PMF_LANG["ad_adus_add"] = "Ychwanegu defnyddiwr";
$PMF_LANG["ad_adus_suc"] = "Ychwanegwyd y defnyddiwr yn llwyddiannus.";
$PMF_LANG["ad_adus_edit"] = "Golygu proffil";
$PMF_LANG["ad_adus_dberr"] = "<strong>gwall cronfa ddata!</strong>";
$PMF_LANG["ad_adus_exerr"] = "Mae'r enw defnyddiwr yn bodoli eisoes.";

// Sessions
$PMF_LANG["ad_sess_id"] = "Gwybodaeth adnabod";
$PMF_LANG["ad_sess_sid"] = "Gwybodaeth adnabod sesiwn";
$PMF_LANG["ad_sess_ip"] = "IP";
$PMF_LANG["ad_sess_time"] = "Amser";
$PMF_LANG["ad_sess_pageviews"] = "Gweld Tudalennau";
$PMF_LANG["ad_sess_search"] = "Chwilio";
$PMF_LANG["ad_sess_sfs"] = "Chwilio am sesiynau";
$PMF_LANG["ad_sess_s_ip"] = "IP";
$PMF_LANG["ad_sess_s_minct"] = "gweithredoedd lleiaf";
$PMF_LANG["ad_sess_s_date"] = "Dyddiad";
$PMF_LANG["ad_sess_s_after"] = "ar ôl";
$PMF_LANG["ad_sess_s_before"] = "Chwilio";
$PMF_LANG["ad_sess_session"] = "Sesiwn";
$PMF_LANG["ad_sess_r"] = "Cyfeiriwr";
$PMF_LANG["ad_sess_browser"] = "Categori";
$PMF_LANG["ad_sess_ai_artikel"] = "Cofnod";
$PMF_LANG["ad_sess_ai_sb"] = "Chwilio-Llinynnau";
$PMF_LANG["ad_sess_ai_sid"] = "Gwybodaeth adnabod sesiwn";
$PMF_LANG["ad_sess_back"] = "Yn ôl";

// Statistik
$PMF_LANG["ad_rs"] = "Ystadegau Cyfraddau";
$PMF_LANG["ad_rs_rating_1"] = "Safle";
$PMF_LANG["ad_rs_rating_2"] = "defnyddwyr yn dangos";
$PMF_LANG["ad_rs_red"] = "Coch";
$PMF_LANG["ad_rs_green"] = "Gwyrdd";
$PMF_LANG["ad_rs_altt"] = "gyda chyfartaledd is na 20%";
$PMF_LANG["ad_rs_ahtf"] = "gyda chyfartaledd uwch na 80%";
$PMF_LANG["ad_rs_no"] = "Does dim safle ar gael";

// Auth
$PMF_LANG["ad_auth_insert"] = "Rhowch eich enw defnyddiwr a'ch cyfrinair.";
$PMF_LANG["ad_auth_user"] = "Enw defnyddiwr";
$PMF_LANG["ad_auth_passwd"] = "Cyfrinair";
$PMF_LANG["ad_auth_ok"] = "OK";
$PMF_LANG["ad_auth_reset"] = "Ailosod";
$PMF_LANG["ad_auth_fail"] = "Defnyddiwr neu gyfrinair annilys.";
$PMF_LANG["ad_auth_sess"] = "Pasiwyd gwybodaeth adnabod y Sesiwn.";

// Added v0.8 - 24.05.2001 - Bastian - Admin
$PMF_LANG["ad_config_edit"] = "Golygu ffurfwedd";
$PMF_LANG["ad_config_save"] = "Cadw ffurfwedd";
$PMF_LANG["ad_config_reset"] = "Ailosod";
$PMF_LANG["ad_config_saved"] = "Cadwyd y ffurfwedd yn llwyddiannus.";
$PMF_LANG["ad_menu_editconfig"] = "Golygu ffurfwedd";
$PMF_LANG["ad_att_none"] = "Nid oes atodiadau ar gael";
$PMF_LANG["ad_att_att"] = "Atodiadau";
$PMF_LANG["ad_att_add"] = "Atodi ffeil";
$PMF_LANG["ad_entryins_suc"] = "Cadwyd y cofnod yn llwyddiannus.";
$PMF_LANG["ad_entryins_fail"] = "Gwall.";
$PMF_LANG["ad_att_del"] = "Dileu";
$PMF_LANG["ad_att_nope"] = "Gellir ychwanegu atodiadau wrth olygu yn unig.";
$PMF_LANG["ad_att_delsuc"] = "Dilëwyd yr atodiad yn llwyddiannus.";
$PMF_LANG["ad_att_delfail"] = "Roedd gwall wrth ddileu'r atodiad.";
$PMF_LANG["ad_entry_add"] = "Creu Cofnod";

// Added v0.85 - 08.06.2001 - Bastian - Admin
$PMF_LANG["ad_csv_make"] = "> Ffeiliau wrth gefn yw delwedd gyflawn o gynnwys y gronfa ddata. Fformat y ffeil wrth gefn yw ffeil trafod SQL y gellir ei mewnforio gan ddefnyddio offer megis phpMyAdmin neu'r gorchymyn cleient sql.  Dylid cyflawni ffeil wrth gefn o leiaf unwaith y mis..";
$PMF_LANG["ad_csv_link"] = "Lawrlwytho'r ffeil wrth gefn";
$PMF_LANG["ad_csv_head"] = "Gwneud ffeil wrth gefn";
$PMF_LANG["ad_att_addto"] = "Ychwanegu atodiad at y mater";
$PMF_LANG["ad_att_addto_2"] = "";
$PMF_LANG["ad_att_att"] = "Ffeil";
$PMF_LANG["ad_att_butt"] = "OK";
$PMF_LANG["ad_att_suc"] = "Atodwyd y ffeil yn llwyddiannus.";
$PMF_LANG["ad_att_fail"] = "Roedd gwall wrth atodi'r ffeil.";
$PMF_LANG["ad_att_close"] = "Cau'r ffenestr hon";

// Added v0.85 - 08.07.2001 - Bastian - Admin
$PMF_LANG["ad_csv_restore"] = "Gyda'r ffurflen hon gallwch adfer cynnwys y gronfa ddata, gan ddefnyddio ffeil wrth gefn a wnaed gyda phpmyfaq.  Sylwer y trosysgrifir y data presennol.";
$PMF_LANG["ad_csv_file"] = "Ffeil";
$PMF_LANG["ad_csv_ok"] = "OK";
$PMF_LANG["ad_csv_linklog"] = "LOGiau wrth gefn";
$PMF_LANG["ad_csv_linkdat"] = "data wrth gefn";
$PMF_LANG["ad_csv_head2"] = "Adfer";
$PMF_LANG["ad_csv_no"] = "Dyw hwn ddim yn ffeil wrth gefn o fy phpmyfaq.";
$PMF_LANG["ad_csv_prepare"] = "Paratoi ymholiadau'r gronfa ddata...";
$PMF_LANG["ad_csv_process"] = "Ymholi...";
$PMF_LANG["ad_csv_of"] = "o";
$PMF_LANG["ad_csv_suc"] = "roedd  yn llwyddiannus.";
$PMF_LANG["ad_csv_backup"] = "Wrth gefn";
$PMF_LANG["ad_csv_rest"] = "Adfer ffeiliau wrth gefn";

// Added v0.8 - 25.05.2001 - Bastian - Admin
$PMF_LANG["ad_menu_backup"] = "Wrth gefn";
$PMF_LANG["ad_logout"] = "Terfynwyd y sesiwn yn llwyddiannus.";
$PMF_LANG["ad_news_add"] = "Ychwanegu newyddion";
$PMF_LANG["ad_news_edit"] = "Golygu newyddion";
$PMF_LANG["ad_cookie"] = "Cwcis";
$PMF_LANG["ad_sess_head"] = "Gweld sesiynau";

// Added v1.1 - 06.01.2002 - Bastian
$PMF_LANG["msgHeaderCategoryOverview"] = "Gweinyddiaeth y Categori";
$PMF_LANG["ad_menu_stat"] = "Ystadegau Cyfraddau";
$PMF_LANG["msgAddCategory"] = "Ailenwi";
$PMF_LANG["ad_adminlog_date"] = "Dyddiad";
$PMF_LANG["ad_adminlog_user"] = "Defnyddiwr";
$PMF_LANG["ad_adminlog_ip"] = "Cyfeiriad IP";

$PMF_LANG["ad_stat_sess"] = "Sesiynau";
$PMF_LANG["ad_stat_days"] = "Dyddiau";
$PMF_LANG["ad_stat_vis"] = "Sesiynau (Ymweliadau)";
$PMF_LANG["ad_stat_vpd"] = "Ymweliad y Dydd";
$PMF_LANG["ad_stat_fien"] = "Log Cyntaf";
$PMF_LANG["ad_stat_laen"] = "Log Olaf";
$PMF_LANG["ad_stat_browse"] = "pori Sesiynau";
$PMF_LANG["ad_stat_ok"] = "OK";

$PMF_LANG["ad_sess_time"] = "Amser";
$PMF_LANG["ad_sess_sid"] = "Gwybodaeth adnabod sesiwn";
$PMF_LANG["ad_sess_ip"] = "Cyfeiriad IP";

$PMF_LANG["ad_ques_take"] = "Cymryd cwestiwn a'i olygu";
$PMF_LANG["no_cats"] = "Ni chafwyd unrhyw gategorïau.";

// Added v1.1 - 17.01.2002 - Bastian
$PMF_LANG["ad_log_lger"] = "Defnyddiwr neu gyfrinair annilys.";
$PMF_LANG["ad_log_sess"] = "Amser sesiwn wedi dod i ben.";
$PMF_LANG["ad_log_edit"] = "\"Golygu Defnyddiwr\"-Ffurflen ar gyfer y defnyddiwr canlynol: ";
$PMF_LANG["ad_log_crea"] = "\"Erthygl newydd\" Ffurflen.";
$PMF_LANG["ad_log_crsa"] = "Crëwyd cofnod newydd.";
$PMF_LANG["ad_log_ussa"] = "Diweddaru data ar gyfer y defnyddiwr canlynol: ";
$PMF_LANG["ad_log_usde"] = "Dilëwyd y defnyddiwr canlynol: ";
$PMF_LANG["ad_log_beed"] = "Golygu ffurflen ar gyfer y defnyddiwr canlynol: ";
$PMF_LANG["ad_log_bede"] = "Dilëwyd y cofnod canlynol: ";

$PMF_LANG["msgVisits"] = "Ymweliadau";
$PMF_LANG["ad_start_articles"] = "Erthyglau";
$PMF_LANG["ad_start_comments"] = "Sylwadau";


// Added v1.1 - 30.01.2002 - Bastian
$PMF_LANG["ad_categ_paste"] = "pastio";
$PMF_LANG["ad_categ_cut"] = "torri";
$PMF_LANG["msgCopy"] = "copïo";
$PMF_LANG["ad_categ_process"] = "Prosesu categorïau...";

// Added v1.1.4 - 07.05.2002 - Thorsten
$PMF_LANG["err_NotAuth"] = "<strong>Nid oes caniatâd gennych.</strong>";

// Added v1.2.3 - 29.11.2002 - Thorsten
$PMF_LANG["msgPreviusPage"] = "tudalen blaenorol";
$PMF_LANG["msgNextPage"] = "tudalen nesaf";
$PMF_LANG["msgPageDoublePoint"] = "tudalen: ";
$PMF_LANG["msgMainCategory"] = "Prif gategori";

// Added v1.2.4 - 30.01.2003 - Thorsten
$PMF_LANG["ad_passwdsuc"] = "Mae eich cyfrinair wedi newid.";

// Added v1.3.0 - 04.03.2003 - Thorsten
$PMF_LANG["msgPDF"] = "Dangoswch hwn fel ffeil PDF";
$PMF_LANG["ad_xml_head"] = "XML-Wrth gefn";
$PMF_LANG["ad_xml_hint"] = "Cadw pob cofnod o'ch Cwestiynau Cyffredin mewn un ffeil XML.";
$PMF_LANG["ad_xml_gen"] = "Gwneud ffeil XML";
$PMF_LANG["ad_entry_locale"] = "Iaith";
$PMF_LANG["msgLanguageSubmit"] = "newid iaith";

// Added v1.3.1 - 29.04.2003 - Thorsten
$PMF_LANG["ad_entry_preview"] = "Preview";
$PMF_LANG["ad_attach_1"] = "Dewiswch gyfeiriadur ar gyfer atodiadau yn gyntaf yn y ffurfwedd.";
$PMF_LANG["ad_attach_2"] = "Dewiswch ddolen ar gyfer atodiadau yn gyntaf yn y ffurfwedd.";
$PMF_LANG["ad_attach_3"] = "Ni ellir agor yr atodiad ffeil .php heb awdurdodaeth gywir.";
$PMF_LANG["ad_attach_4"] = "Rhaid i'r ffeil atodedig fod yn llai na %s Bytes.";
$PMF_LANG["ad_menu_export"] = "Allforio eich Cwestiynau Cyffredin";
$PMF_LANG["ad_export_file"] = "Gwall: Ni ellir ysgrifennu'r ffeil.";
$PMF_LANG["ad_export_pdf"] = "PDF-Allforio pob cofnod";

$PMF_LANG['permission::add_user'] = "ychwanegu defnyddiwr";
$PMF_LANG['permission::edit_user'] = "golygu defnyddiwr";
$PMF_LANG['permission::delete_user'] = "dileu defnyddiwr";
$PMF_LANG['permission::add_faq'] = "ychwanegu cofnod";
$PMF_LANG['permission::edit_faq'] = "golygu cofnod";
$PMF_LANG['permission::delete_faq'] = "dileu cofnod";
$PMF_LANG['permission::viewlog'] = "gweld log";
$PMF_LANG['permission::adminlog'] = "gweld log gweinyddol";
$PMF_LANG['permission::delcomment'] = "dileu sylw";
$PMF_LANG['permission::addnews'] = "ychwanegu newyddion";
$PMF_LANG['permission::editnews'] = "golygu newyddion";
$PMF_LANG['permission::delnews'] = "dileu newyddion";
$PMF_LANG['permission::addcateg'] = "ychwanegu categori";
$PMF_LANG['permission::editcateg'] = "golygu categori";
$PMF_LANG['permission::delcateg'] = "dileu categori";
$PMF_LANG['permission::passwd'] = "newid cyfrinair";
$PMF_LANG['permission::editconfig'] = "golygu ffurfwedd";
$PMF_LANG['permission::addatt'] = "ychwanegu atodiadau";
$PMF_LANG['permission::delatt'] = "dileu atodiadau";
$PMF_LANG['permission::backup'] = "creu ffeil wrth gefn";
$PMF_LANG['permission::restore'] = "adfer ffeil wrth gefn";
$PMF_LANG['permission::delquestion'] = "dileu cwestiynau agored";
$PMF_LANG['permission::changebtrevs'] = "golygu adolygiadau";

$PMF_LANG["msgAttachedFiles"] = "ffeiliau atodedig";

// Added v1.3.3 - 27.05.2003 - Thorsten
$PMF_LANG["ad_user_action"] = "gweithred";
$PMF_LANG["msgEmail"] = "cyfeiriad e-bost";
$PMF_LANG["ad_entry_allowComments"] = "caniatáu sylwadau";
$PMF_LANG["msgWriteNoComment"] = "Ni allwch gyflwyno sylw ar y cofnod hwn";
$PMF_LANG["msgRealname"] = "enw cywir";
$PMF_LANG["ad_export_generate_pdf"] = "cynhyrchu ffeil PDf";
$PMF_LANG["ad_export_full_faq"] = "Eich Cwestiynau Cyffredin fel ffeil PDF: ";
$PMF_LANG["err_bannedIP"] = "Mae eich cyfeiriad IP wedi'i wahardd.";
$PMF_LANG["err_SaveQuestion"] = " Y meysydd gofynnol yw <strong>eich enw</strong>, <strong> eich cyfeiriad e-bost </strong>, <strong> eich cwestiwn</strong> a phan ofynnir amdano, <strong>Captcha Code</strong>.<br><br><a href=\"javascript:history.back();\">un dudalen yn ôl </a><br><br>\n";

// added v1.3.4 - 23.07.2003 - Thorsten
$PMF_LANG["ad_entry_fontcolor"] = "Lliw'r ffont : ";
$PMF_LANG["ad_entry_fontsize"] = "Maint y ffont: ";

// added v1.4.0 - 2003-12-04 by Thorsten / Mathias
$LANG_CONF['main.language'] = array("select", " Iaith-Ffeil");
$LANG_CONF["main.languageDetection"] = array("checkbox", " Galluogi trafod cynnwys awtomatig");
$LANG_CONF['main.titleFAQ'] = array("input", " Teitl y CC");
$LANG_CONF['main.currentVersion'] = array("print", " Fersiwn y CC");
$LANG_CONF["main.metaDescription"] = array("input", " Disgrifiad or Dudalen");
$LANG_CONF["main.metaPublisher"] = array("input", " Enwr Cyhoeddwr");
$LANG_CONF['main.administrationMail'] = array("input", " Cyfeiriad e-bost Gweinyddol");
$LANG_CONF["main.contactInformation"] = array("area", " Gwybodaeth gyswllt");
$LANG_CONF["main.send2friendText"] = array("area", " Testun ar gyfer y dudalen anfonatffrind");
$LANG_CONF['records.maxAttachmentSize'] = array("input", " Uchafswm maint ar gyfer atodiadau mewn Beitiau(max. %sByte)");
$LANG_CONF["records.disableAttachments"] = array("checkbox", " Cysylltur atodiadau islawr cofnodion?");
$LANG_CONF["main.enableUserTracking"] = array("checkbox", " Defnyddio tracio?");
$LANG_CONF["main.enableAdminLog"] = array("checkbox", " defnyddio cofnod gweinyddol?");
$LANG_CONF["security.ipCheck"] = array("checkbox", " Ydych chi am ir IP gael ei wirio wrth wirio UINs yn admin.php?");
$LANG_CONF["records.numberOfRecordsPerPage"] = array("input", " Nifer y pynciau a ddangosir fesul tudalen");
$LANG_CONF["records.numberOfShownNewsEntries"] = array("input", " Nifer yr erthyglau newyddion");
$LANG_CONF['security.bannedIPs'] = array("area", " Gwahardd yr Ips hyn");
$LANG_CONF["ldap.ldapSupport"] = array("checkbox", " Hoffech chi osod cefnogaeth LDAP? (default: disabled)");

$PMF_LANG["ad_categ_new_main_cat"] = "fel prif gategori newydd";
$PMF_LANG["ad_categ_paste_error"] = "Nid yw'n bosibl symud y categori hwn.";
$PMF_LANG["ad_categ_move"] = "symud y categori";
$PMF_LANG["ad_categ_lang"] = "Iaith";
$PMF_LANG["ad_categ_desc"] = "Disgrifiad";
$PMF_LANG["ad_categ_change"] = "Newid gyda";

$PMF_LANG["lostPassword"] = "Anghofio cyfrinair? Cliciwch yma.";
$PMF_LANG["lostpwd_err_1"] = "Gwall: Ni chafwyd yr enw defnyddiwr na'r cyfeiriad e-bost.";
$PMF_LANG["lostpwd_err_2"] = "Gwall: Cofnodion anghywir!";
$PMF_LANG["lostpwd_text_1"] = "Diolch am ofyn am wybodaeth eich cyfrif.";
$PMF_LANG["lostpwd_text_2"] = "Gosodwch gyfrinair personol newydd yn adran weinyddol eich Cwestiynau Cyffredin.";
$PMF_LANG["lostpwd_mail_okay"] = "Anfonwyd yr e-bost.";

$PMF_LANG["msgButtonFetchLatestVersion"] = "Cael rhif fersiwn phpMyFAQ diweddaraf drwy wasanaeth gwe";
$PMF_LANG["ad_xmlrpc_latest"] = "Y fersiwn ddiweddaraf ar gael ar";

// added v1.5.0 - 2005-07-31 by Thorsten
$PMF_LANG['ad_categ_select'] = 'Dewiswch iaith y categori';

// added v1.5.1 - 2005-09-06 by Thorsten
$PMF_LANG['msgSitemap'] = 'Map or safle';

// added v1.5.2 - 2005-09-23 by Lars
$PMF_LANG['err_inactiveArticle'] = 'Maer cofnod hwn yn cael ei adolygu ac nid oes modd ei ddangos.';
$PMF_LANG['msgArticleCategories'] = 'Categorïau ar gyfer y cofnod hwn';

// added v1.6.0 - 2006-02-02 by Thorsten
$PMF_LANG['ad_entry_solution_id'] = 'Gwybodaeth adnabod ateb unigryw';
$PMF_LANG['ad_entry_faq_record'] = 'Cofnod Cwestiynau Cyffredin';
$PMF_LANG['ad_entry_new_revision'] = 'Creu adolygiad newydd?';
$PMF_LANG['ad_entry_record_administration'] = 'Cofnodi gweinyddiaeth';
$PMF_LANG['ad_entry_changelog'] = 'Newid log';
$PMF_LANG['ad_entry_revision'] = 'Adolygu';
$PMF_LANG['ad_changerev'] = 'Dethol Adolygu';
$PMF_LANG['msgCaptcha'] = "Nodwch y cymeriadau yr ydych yn eu darllen yn y ddelwedd";
$PMF_LANG['msgSelectCategories'] = 'Chwilio ym ...';
$PMF_LANG['msgAllCategories'] = '... mhob categori';
$PMF_LANG['ad_you_should_update'] = 'Mae eich gosodiad phpMyFAQ yn hen.  Dylech ei ddiweddaru ir fersiwn ddiweddaraf sydd ar gael.';
$PMF_LANG['msgAdvancedSearch'] = 'Chwiliad manwl';

// added v1.6.1 - 2006-04-25 by Matteo and Thorsten
$PMF_LANG['spamControlCenter'] = 'Canolfan rheoli sbam';
$LANG_CONF["spam.enableSafeEmail"] = array("checkbox", " Argraffu e-bost defnyddiwr mewn ffordd ddiogel (default: enabled).");
$LANG_CONF["spam.checkBannedWords"] = array("checkbox", " Cynnwys ffurflen gyhoeddus yn erbyn geiriau a waharddwyd (default: enabled).");
$LANG_CONF["spam.enableCaptchaCode"] = array("checkbox", " Defnyddio côd catpcha i gyflwyno ffurflen gyhoeddus (default: enabled).");
$PMF_LANG['ad_session_expiring'] = 'Bydd eich sesiwn yn dod i ben mewn %d munud: hoffech chi barhau i weithio?';

// added v1.6.2 - 2006-06-13 by Matteo
$PMF_LANG['ad_stat_management'] = 'Rheoli sesiynau';
$PMF_LANG['ad_stat_choose'] = 'Dewiswch y mis';
$PMF_LANG['ad_stat_delete'] = 'Dilëwch y sesiynau a ddewiswyd ar unwaith';

return $PMF_LANG;
