<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_usertours', language 'fr', version '5.0'.
 *
 * @package     tool_usertours
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['above'] = 'Au-dessus';
$string['actions'] = 'Actions';
$string['appliesto'] = 'S’applique à';
$string['backdrop'] = 'Afficher avec image de fond';
$string['backdrop_help'] = 'Il est possible d’utiliser une image de fond pour faire ressortir la partie de la page que vous voulez désigner.

Les images de fond ne sont pas compatibles avec certaines partie de la page, comme la barre de navigation.';
$string['below'] = 'Au-dessous';
$string['block'] = 'Bloc';
$string['block_named'] = 'Bloc appelé « {$a} »';
$string['cachedef_stepdata'] = 'Liste des étapes de la visite guidée';
$string['cachedef_tourdata'] = 'Liste des informations de visite guidée qui sont récupérées sur toutes les pages';
$string['confirmstepremovalquestion'] = 'Voulez-vous vraiment supprimer cette étape ?';
$string['confirmstepremovaltitle'] = 'Confirmer la suppression de l’étape';
$string['confirmtourremovalquestion'] = 'Voulez-vous vraiment supprimer cette visite guidée ?';
$string['confirmtourremovaltitle'] = 'Confirmer la suppression de la visite guidée';
$string['content'] = 'Contenu';
$string['content_heading'] = 'Contenu';
$string['content_help'] = 'La description d’une étape peut être ajoutée en texte pur ou en utilisant la syntaxe multilingue de Moodle (pour utilisation avec le filtre multilingue).';
$string['content_type'] = 'Type de contenu';
$string['content_type_help'] = '* Manuel - le contenu est saisi avec un éditeur de texte
* ID de chaîne de langue - sous la forme d’un identifiant de chaîne « identifiant,composant » (sans délimiteur, ni espace après la virgule)';
$string['content_type_langstring'] = 'ID de chaîne de langue';
$string['content_type_manual'] = 'Manuel';
$string['cssselector'] = 'Sélecteur CSS';
$string['defaultvalue'] = 'Défaut ({$a})';
$string['delay'] = 'Délai avant d’afficher l’étape';
$string['delay_help'] = 'Un délai optionnel peut être ajouté avant l’affichage de l’étape.

Ce délai est défini en millisecondes.';
$string['description'] = 'Description';
$string['description_help'] = 'La description d’une visite guidée doit être écrite en texte pur, avec au besoin des balises multilingues lorsque le filtre multilingue est utilisé.

Il est aussi possible d’indiquer un identifiant de chaîne de caractères, sous la forme « identifiant,composant » (sans espace ni crochet après la virgule).';
$string['displaystepnumbers'] = 'Afficher les numéros des étapes';
$string['displaystepnumbers_help'] = 'Ce réglage indique s’il faut afficher un compteur d’étapes, p.ex. 1/4, 2/4, etc. pour indiquer la longueur de la viste guidée.';
$string['done'] = 'Terminé';
$string['duplicatetour'] = 'Dupliquer la visite guidée';
$string['duplicatetour_name'] = '{$a} (copie)';
$string['editstep'] = 'Modification de « {$a} »';
$string['enabled'] = 'Activé';
$string['endonesteptour'] = 'Compris';
$string['endtour'] = 'Terminer la visite guidée';
$string['endtourlabel'] = 'Libellé du bouton pour terminer la visite guidée';
$string['endtourlabel_help'] = 'Il est possible de spécifier un libellé personnalisé pour le bouton permettant de terminer la visite guidée. Le libellé par défaut est « Compris » pour les visites à une seule étape, et « Terminer la visite guidée » pour les visites à plusieurs étapes.

Il est aussi possible d’indiquer un identifiant de chaîne de caractères, sous la forme « identifiant,composant » (sans espace ni crochet après la virgule).';
$string['event_step_shown'] = 'Étape affichée';
$string['event_tour_ended'] = 'Visite guidée terminée';
$string['event_tour_reset'] = 'Visite guidée relancée';
$string['event_tour_started'] = 'Visite guidée commencée';
$string['exporttour'] = 'Exporter la visite guidée';
$string['filter_accessdate'] = 'Date d’accès';
$string['filter_accessdate_enabled'] = 'Activer le filtre de date d’accès';
$string['filter_accessdate_enabled_help'] = 'N’afficher la visite guidée qu’aux nouveaux utilisateurs ou aux utilisateurs qui ont accès au site récemment.';
$string['filter_category'] = 'Catégorie';
$string['filter_category_help'] = 'Affiche cette visite guidée sur les pages associée à des cours des catégories sélectionnées.';
$string['filter_course'] = 'Cours sélectionnés';
$string['filter_course_error_course_selection'] = 'Vous devez sélectionner au moins un cours';
$string['filter_course_help'] = 'Selon la valeur du filtre de cours :

* **Seulement cours sélectionnés** : afficher cette visite guidée sur les pages associées aux cours sélectionnés.
* **Tous les cours non sélectionnés** : ne pas afficher cette visite guidée sur les pages associées aux cours sélectionnés.';
$string['filter_course_operator'] = 'Cours';
$string['filter_course_operator_all'] = 'Tous les cours';
$string['filter_course_operator_except'] = 'Tous les cours non sélectionnés';
$string['filter_course_operator_help'] = 'La visite guidée peut être configurée pour n’apparaître que sur certains cours.

* **Tous les cours**: afficher cette visite guidée quel que soit le cours.
* **Seulement cours sélectionnés**: afficher cette visite guidée sur les pages associées aux cours sélectionnés ci-dessous.
* **Tous les cours non sélectionnés**: ne pas afficher cette visite guidée sur les pages associées aux cours sélectionnés ci-dessous.';
$string['filter_course_operator_select'] = 'Seulement cours sélectionnés';
$string['filter_courseformat'] = 'Format de cours';
$string['filter_courseformat_help'] = 'Affiche la visite guidée sur une page d’un cours utilisant le format de cours sélectionné.';
$string['filter_cssselector'] = 'Sélecteur CSS';
$string['filter_cssselector_help'] = 'N’afficher la visite guidée que lorsque le sélecteur CSS est trouvé sur la page.';
$string['filter_date_account_creation'] = 'Date de création de l’utilisateur dans un délai de';
$string['filter_date_first_login'] = 'Date de premier accès de l’utilisateur dans un délai de';
$string['filter_date_last_login'] = 'Date de dernier accès de l’utilisateur dans un délai de';
$string['filter_exclude_category'] = 'Exclure les catégories';
$string['filter_exclude_category_help'] = 'Ne pas afficher cette visite sur les pages associées aux catégories de cours sélectionnées.

Si une catégorie parente est sélectionnée, les sous-catégories correspondantes seront automatiquement sélectionnées et ne pourront pas être sélectionnées individuellement.

Dé-sélectionner la catégorie parente pour sélectionner individuellement des sous-catégories.';
$string['filter_header'] = 'Filtres les visites guidées';
$string['filter_help'] = 'Il est possible de choisir à quelles conditions la visite guidée sera affichée. Tous les filtres doivent correspondre à une visite guidée à afficher à l’utilisateur concerné.';
$string['filter_role'] = 'Rôle';
$string['filter_role_help'] = 'L’affichage d’une visite guidée peut être restreint aux utilisateurs disposant dans le contexte où la visite est affichée d’un des rôles sélectionnés.';
$string['filter_theme'] = 'Thème';
$string['filter_theme_help'] = 'N’afficher la visite guidée que lorsque l’utilisateur utilise l’un des thèmes indiqués.';
$string['importtour'] = 'Importer une visite guidée';
$string['invalid_lang_id'] = 'ID de chaîne de langue non valide';
$string['left'] = 'À gauche';
$string['modifyshippedtourwarning'] = 'Cette visite guidée est fournie avec Moodle. Toutes les modifications que vous y apportez sont susceptibles d’être écrasées lors de la prochaine mise à jour de votre plateforme.';
$string['moodle_language_identifier'] = 'ID de chaîne de langue';
$string['movestepdown'] = 'Déplacer l’étape vers le bas';
$string['movestepup'] = 'Déplacer l’étape vers le haut';
$string['movetourdown'] = 'Déplacer la visite guidée vers le bas';
$string['movetourup'] = 'Déplacer la visite guidée vers le haut';
$string['name'] = 'Nom';
$string['name_help'] = 'Le nom d’une visite guidée doit être écrit en texte pur, avec au besoin des balises multilingues lorsque le filtre multilingue est utilisé.

Il est aussi possible d’indiquer un identifiant de chaîne de caractères, sous la forme « identifiant,composant » (sans espace ni crochet après la virgule).';
$string['newstep'] = 'Nouvelle étape';
$string['newtour'] = 'Créer une visite guidée';
$string['next'] = 'Suivant';
$string['nextstep'] = 'Suivant';
$string['nextstep_sequence'] = 'Suivant ({$a->position}/{$a->total})';
$string['options_heading'] = 'Options';
$string['orphan'] = 'Afficher si la cible n’est pas trouvée';
$string['orphan_help'] = 'Afficher l’étape si la cible ne peut pas être trouvée sur la page.';
$string['pathmatch'] = 'Afficher si l’URL correspond';
$string['pathmatch_help'] = 'Les visites guidées seront affichées sur toutes les pages dont l’URL correspond à cette valeur.

Le caractère % peut être utilisé comme joker pour remplacer une chaîne de caractères quelconque. Voici quelques exemples :

* /my/% - correspond au Tableau de bord
* /course/view.php?id=2 - correspond à un cours spécifique
* /mod/forum/view.php% - correspond à la liste des forums de discussion
* /user/profile.php% - correspond au profil des utilisateurs

Pour afficher une visite guidée sur la page d’accueil, utiliser la valeur « FRONTPAGE ».';
$string['pausetour'] = 'Pause';
$string['placement'] = 'Position';
$string['placement_help'] = 'Une étape peut être affichée au-dessus, au-dessous, à gauche ou à droite de la cible. Un positionnement au-dessus ou au-dessous est recommandé, car s’adaptant mieux aux appareils mobiles.

Si l’étape ne tient pas dans la page à l’emplacement choisi, elle sera automatiquement déplacée.';
$string['pluginname'] = 'Visites guidées';
$string['privacy:metadata:preference:completed'] = 'Date et heure du dernier achèvement d’une visite guidée par un utilisateur.';
$string['privacy:metadata:preference:requested'] = 'Date et heure du dernier lancement de visite guidée par un utilisateur.';
$string['privacy:request:preference:completed'] = 'Vous avez marqué la visite guidée « {$a->name} » comme terminée le {$a->time}';
$string['privacy:request:preference:requested'] = 'Vous avez lancé la visite guidée « {$a->name} » le {$a->time}';
$string['reflex'] = 'Continuer au clic';
$string['reflex_help'] = 'Passer à la prochaine étape lors d’un clic sur la cible.';
$string['resettouronpage'] = 'Relancer la visite guidée sur cette page';
$string['resumetour'] = 'Reprendre';
$string['right'] = 'À droite';
$string['select_block'] = 'Sélectionner un bloc';
$string['selector_defaulttitle'] = 'Saisir un titre descriptif';
$string['selectordisplayname'] = 'Un sélecteur CSS correspondant à « {$a} »';
$string['selecttype'] = 'Choisir un type d’étape';
$string['sharedtourslink'] = 'Dépôt des visites guidées';
$string['showtoureachtime'] = 'chaque fois qu’un filtre correspond';
$string['showtouruntilcomplete'] = 'jusqu’à sa fermeture';
$string['showtourwhen'] = 'Afficher la visite guidée';
$string['skip'] = 'Passer';
$string['skip_tour'] = 'Sauter la visite guidée';
$string['target'] = 'Cible';
$string['target_block'] = 'Bloc';
$string['target_heading'] = 'Cible de l’étape';
$string['target_selector'] = 'Sélecteur';
$string['target_selector_targetvalue'] = 'Sélecteurs CSS';
$string['target_selector_targetvalue_help'] = 'Un sélecteur CSS peut être utilisé pour cibler presque n’importe quel élément d’une page. Le sélecteur approprié peut être facilement trouvé à l’aide des outils de développement de votre navigateur.';
$string['target_unattached'] = 'Afficher au milieu de la page';
$string['targettype'] = 'Type de cible';
$string['targettype_help'] = 'Chaque étape est associée à une partie de la page, la cible. Les types de cible sont :

* Bloc – pour afficher l’étape suivante à proximité d’un bloc indiqué
* Sélecteur CSS – pour définir précisément la zone de la cible au moyen de CSS
* Afficher au milieu de la page – pour une étape ne nécessitant pas d’être associée à une partie spécifique de la page';
$string['title'] = 'Titre';
$string['title_help'] = 'Le titre d’une étape peut être ajouté en texte pur ou en utilisant la syntaxe multilingue de Moodle (pour utilisation avec le filtre multilingue).

Il est aussi possible d’indiquer un identifiant de chaîne de caractères, sous la forme « identifiant,composant » (sans espace ni crochet après la virgule).';
$string['tour1_content_addingblocks'] = 'En fait, réfléchissez à deux fois avant d’ajouter des blocs sur vos pages. Les blocs ne sont pas affichés dans l’app Moodle, donc de façon générale, il est beaucoup mieux de s’assurer que votre plateforme fonctionne bien sans aucun bloc.';
$string['tour1_content_blockregion'] = 'Il reste encore une région pour les blocs à cet endroit. Nous vous recommandons de retirer complètement les blocs Navigation et Administration, puisque toutes leurs fonctionnalités sont disponibles ailleurs dans le thème Boost.';
$string['tour1_content_customisation'] = 'Pour personnaliser l’apparence de votre site et de sa page d’accueil, utilisez le menu des réglages au coin de cet en-tête. Activez le mode édition maintenant.';
$string['tour1_content_end'] = 'Vous venez de terminer une visite guidée. Cette visite ne s’affichera plus, à moins que vous ne la relanciez au moyen du lien dans le pied de page. En tant qu’administrateur, vous pouvez aussi créer vos propres visites guidées comme celle-ci !';
$string['tour1_content_navigation'] = 'La navigation principale s’effectue maintenant au moyen de ce tiroir de navigation. Son contenu s’adapte au contexte dans lequel vous êtes sur la plateforme. Le bouton en haut permet de l’afficher ou de le cacher.';
$string['tour1_content_welcome'] = 'Bienvenue au thème Boost. Si vous avez mis à jour Moodle à partir d’une version antérieure, vous trouverez certaines choses changées.';
$string['tour1_title_addingblocks'] = 'Ajout de blocs';
$string['tour1_title_blockregion'] = 'Région des blocs';
$string['tour1_title_customisation'] = 'Personnalisation';
$string['tour1_title_end'] = 'Fin de la visite guidée';
$string['tour1_title_navigation'] = 'Navigation';
$string['tour1_title_welcome'] = 'Bienvenue';
$string['tour2_content_addblock'] = 'En activant le mode édition, vous pouvez ajouter des blocs à partir du tiroir de navigation. Cependant, réfléchissez à deux fois avant d’ajouter des blocs sur vos pages. Les blocs ne sont pas affichés dans l’app Moodle, et pour une meilleure expérience utilisateur de vos étudiants, il est beaucoup mieux de vous assurer que votre cours se passe bien sans aucun bloc.';
$string['tour2_content_addingblocks'] = 'Vous pouvez ajouter des blocs à cette page au moyen de ce bouton. Cependant, réfléchissez à deux fois avant d’ajouter des blocs sur vos pages. Les blocs ne sont pas affichés dans l’app Moodle, et pour une meilleure expérience utilisateur de vos étudiants, il est beaucoup mieux de vous assurer que votre cours se passe bien sans aucun bloc.';
$string['tour2_content_customisation'] = 'Pour modifier les réglages du cours, utilisez le menu des réglages dans le coin de cet en-tête. Vous trouverez d’autres menus de réglages similaires sur la page de chaque activité. Activez maintenant le mode édition.';
$string['tour2_content_end'] = 'Vous venez de faire une visite guidée. Cette visite ne s’affichera plus, à moins que vous ne la relanciez au moyen du lien dans le pied de page. L’administrateur du site peut créer d’autres visites guidées pour cette plateforme.';
$string['tour2_content_navigation'] = 'La navigation s’effectue maintenant au moyen de ce tiroir de navigation. Le bouton en haut permet de l’afficher ou de le cacher. Vous constaterez qu’il s’y trouve des liens vers les sections de votre cours.';
$string['tour2_content_opendrawer'] = 'Ouvrez maintenant le tiroir de navigation.';
$string['tour2_content_participants'] = 'Consultez la liste des participants ici. C’est également ici que vous ajoutez ou retirez des étudiants.';
$string['tour2_content_welcome'] = 'Bienvenue au thème Boost. Si votre plateforme a été mise à jour à partir d’une version antérieure, vous trouverez certaines choses changées ici, sur la page d’un cours.';
$string['tour2_title_addblock'] = 'Ajouter un bloc';
$string['tour2_title_addingblocks'] = 'Ajout de blocs';
$string['tour2_title_customisation'] = 'Personnalisation';
$string['tour2_title_end'] = 'Fin de la visite guidée';
$string['tour2_title_navigation'] = 'Navigation';
$string['tour2_title_opendrawer'] = 'Ouvrir le tiroir de navigation';
$string['tour2_title_participants'] = 'Participants au cours';
$string['tour2_title_welcome'] = 'Bienvenue';
$string['tour3_content_dashboard'] = 'Votre nouveau Tableau de bord a de nombreuses fonctions pour vous permettre d’accéder facilement aux informations les plus importantes pour vous.';
$string['tour3_content_displayoptions'] = 'Les cours peuvent être triés par nom, par nom abrégé ou par date du dernier accès.

Vous pouvez aussi choisir d’afficher les cours dans une liste, avec les informations résumées, ou dans la vue par défaut en « cartes ».';
$string['tour3_content_overview'] = 'Le bloc Vue d’ensemble des cours affiche la totalité des cours dans lesquels vous êtes inscrit.

Vous pouvez choisir de n’afficher que les cours actuellement actifs, ou ceux qui sont passés ou à venir, ou les cours que vous avez marqués comme favoris.';
$string['tour3_content_recentcourses'] = 'Le bloc Cours consultés récemment affiche les cours que vous avez visités en dernier, vous permettant d’y retourner directement.';
$string['tour3_content_starring'] = 'Vous pouvez marquer un cours comme favori pour le mettre en évidence ou le cacher s’il n’est plus important pour vous.

Ces actions n’ont d’effet que sur ce que vous voyez.

Vous pouvez aussi choisir d’afficher les cours dans une liste, avec les informations résumées, ou dans la vue par défaut en « cartes ».';
$string['tour3_content_timeline'] = 'Le bloc Chronologie affiche les événements à venir importants.

Vous pouvez choisir d’afficher les activités de la semaine prochaine, du mois prochain, ou plus loin encore dans l’avenir.

Vous pouvez aussi afficher les éléments en retard.';
$string['tour3_title_dashboard'] = 'Votre tableau de bord';
$string['tour3_title_displayoptions'] = 'Options d’affichage';
$string['tour3_title_overview'] = 'Vue d’ensemble des cours';
$string['tour3_title_recentcourses'] = 'Cours consultés récemment';
$string['tour3_title_starring'] = 'Marquer des cours comme favoris ou les cacher';
$string['tour3_title_timeline'] = 'Bloc Chronologie';
$string['tour4_content_groupconvo'] = 'Si vous êtes un membre d’un groupe dans lequel la messagerie de groupe est activée, vous verrez ici les conversations du groupe.

Les conversations de groupes de cours vous permettent d’interagir avec d’autres personnes de votre groupe de façon simple et en privé.';
$string['tour4_content_icon'] = 'Vous pouvez accéder à vos messages depuis n’importe quelle page à l’aide de cette icône.

Si vous avez des messages non lus, leur nombre sera affiché ici également.

Cliquer sur l’icône pour ouvrir le tiroir de messagerie et continuer la visite guidée.';
$string['tour4_content_messaging'] = 'Les nouvelles fonctionnalités de messagerie comprennent la possibilité d’envoyer des messages de groupes dans les cours, ainsi qu’un meilleur contrôle de qui peut vous envoyer des messages.';
$string['tour4_content_settings'] = 'Vous pouvez accéder à vos réglages de messagerie au moyen de l’icône d’engrenage. Un nouveau réglage de confidentialité vous permet de restreindre les personnes qui peuvent vous envoyer des messages.';
$string['tour4_content_starred'] = 'Vous pouvez choisir de marquer comme favorites certaines conversations afin de les retrouver plus facilement.';
$string['tour4_title_groupconvo'] = 'Messages de groupe';
$string['tour4_title_icon'] = 'Messagerie';
$string['tour4_title_messaging'] = 'Nouvelle interface de messagerie';
$string['tour4_title_settings'] = 'Réglages de messagerie';
$string['tour4_title_starred'] = 'Favoris';
$string['tour_activityinfo_activity_student_content'] = 'Les dates des activités ainsi que les actions à effectuer pour terminer l’activité sont affichées sur la page de l’activité.';
$string['tour_activityinfo_activity_student_title'] = 'Nouveau : informations sur l’activité';
$string['tour_activityinfo_activity_teacher_content'] = 'Les dates des activités et les conditions d’achèvement sont maintenant affichées pour les étudiants sur la page de chaque activité (et optionnellement sur la page du cours).

Pour les activités qui demandent de marquer manuellement l’activité comme terminée, un bouton « Marquer comme terminé » est affiché sur la page de l’activité.';
$string['tour_activityinfo_activity_teacher_title'] = 'Nouveau : informations sur l’activité';
$string['tour_activityinfo_course_student_content'] = 'Les dates de l’activité et/ou ce qu’il faut faire pour terminer l’activité sont affichées sur la page de cours.';
$string['tour_activityinfo_course_student_title'] = 'Nouveau : informations sur l’activité';
$string['tour_activityinfo_course_teacher_content'] = 'Les nouveaux réglages « Afficher les conditions d’achèvement » et « Afficher les dates de l’activité » vous permettent de choisir si les conditions d’achèvement et/ou les dates sont affichées pour les étudiants sur la page de cours.';
$string['tour_activityinfo_course_teacher_title'] = 'Nouveau : informations sur l’activité';
$string['tour_final_step_content'] = 'Cette visite guidée est terminée. Elle ne sera pas ré-affichée à moins que vous ne la réinitialisiez au moyen du lien dans le pied de page.';
$string['tour_final_step_title'] = 'Fin de la visite guidée';
$string['tour_gradebook_action_content'] = '<div class="text-center">@@PIXICON::tour/tour_grader_report_action_menu::tool_usertours@@</div>Trier les colonnes et choisir celles à afficher. En mode d’édition, utiliser ce raccourci pour accéder aux tâches récurrentes en lien avec la consultation et la modification des éléments d’évaluation.';
$string['tour_gradebook_action_title'] = 'Lien rapide vers actions';
$string['tour_gradebook_filter_content'] = '<div class="text-center">@@PIXICON::tour/tour_grader_report_initials::tool_usertours@@</div>Filtrer les étudiants par les premières lettres de leur nom ou prénom.';
$string['tour_gradebook_filter_title'] = 'Filtrer par nom';
$string['tour_gradebook_search_content'] = '<div class="text-center">@@PIXICON::tour/tour_grader_report_search::tool_usertours@@</div>Utiliser le champ de recherche pour trouver rapidement des étudiants.';
$string['tour_gradebook_search_title'] = 'Trouver rapidement des étudiants';
$string['tour_gradebook_tour_description'] = 'Fonctionnalités de recherche et de navigation du rapport de l’évaluateur';
$string['tour_gradebook_tour_name'] = 'Rapport de l’évaluateur du carnet de notes';
$string['tour_navigation_course_announcements_teacher_content'] = '@@PIXICON::tour/tour_course_admin_3::tool_usertours@@<br>Publier ici des infos importantes.';
$string['tour_navigation_course_announcements_teacher_title'] = 'Quelque chose à annoncer à tout le monde ?';
$string['tour_navigation_course_edit_teacher_content'] = '@@PIXICON::tour/tour_course_admin_1::tool_usertours@@<br>Ajouter un nouveau contenu ou modifier un contenu existant.';
$string['tour_navigation_course_edit_teacher_title'] = 'Activer le mode édition';
$string['tour_navigation_course_index_student_content'] = '@@PIXICON::tour/tour_course_student::tool_usertours@@<br>Parcourir les activités et suivre votre progression.';
$string['tour_navigation_course_index_student_title'] = 'Retrouver votre chemin';
$string['tour_navigation_course_index_teacher_content'] = '@@PIXICON::tour/tour_course_admin_2::tool_usertours@@<br>Glisser-déposer les activités pour ré-arranger les contenus du cours.';
$string['tour_navigation_course_index_teacher_title'] = 'Index du cours';
$string['tour_navigation_course_student_tour_des'] = 'L’endroit pour parcourir les activités d’un cours';
$string['tour_navigation_course_student_tour_name'] = 'Index du cours';
$string['tour_navigation_course_teacher_tour_des'] = 'Mode d’édition, glisser-déposer des activités et publier des annonces dans un cours';
$string['tour_navigation_course_teacher_tour_name'] = 'Édition de cours';
$string['tour_navigation_dashboard_content'] = '@@PIXICON::tour/tour_dashboard::tool_usertours@@<br>Ce panneau latéral peut contenir d’autres fonctionnalités.';
$string['tour_navigation_dashboard_title'] = 'Déplier pour explorer';
$string['tour_navigation_dashboard_tour_des'] = 'Où se trouvent les blocs';
$string['tour_navigation_dashboard_tour_name'] = 'Tiroir des blocs';
$string['tour_navigation_mycourses_content'] = '@@PIXICON::tour/tour_mycourses::tool_usertours@@<br>Ajouter, copier, supprimer et cacher des cours dans ce menu.';
$string['tour_navigation_mycourses_endtourlabel'] = 'J’ai compris';
$string['tour_navigation_mycourses_title'] = 'Cours et catégories';
$string['tour_navigation_mycourses_tour_des'] = 'Options de gestion des cours sur la page Mes cours';
$string['tour_navigation_mycourses_tour_name'] = 'Gestion des cours';
$string['tour_resetforall'] = 'Le statut de la visite guidée a été relancé. La visite sera affichée de nouveau à tous les utilisateurs.';
$string['tourconfig'] = 'Fichier de configuration de visite guidée à importer';
$string['tourisenabled'] = 'La visite est activée';
$string['tourlist_explanation'] = 'Il est possible de créer autant de visites guidées que désiré et de les activer pour diverses parties de Moodle. Une seule visite guidée peut être créée pour chaque page.';
$string['tours'] = 'Visites guidées';
$string['usertours'] = 'Visites guidées';
$string['usertours:managetours'] = 'Créer, modifier et supprimer des visites guidées';
$string['viewtour_edit'] = 'Il est possible de <a href="{$a->editlink}">modifier les réglages par défaut de la visite guidée</a> et d’<a href="{$a->resetlink}">imposer l’affichage de la visite guidée</a> une nouvelle fois à tous les utilisateurs.';
$string['viewtour_info'] = 'Voici la visite guidée « {$a->tourname} ». Elle s’applique au chemin « {$a->path} ».';
