<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'offlinequiz', language 'sr_cr', version '5.0'.
 *
 * @package     offlinequiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add'] = 'Додај';
$string['addarandomquestion'] = 'насумично питање';
$string['addarandomquestion_help'] = 'Moodle додаје насумичнo изaбрaна питања вишеструког избора (или питања вишеструког избора са више тачних одговора која се оцењују по принципу ”све-или-ништа”) у текућу групу офлајн теста. Број питања који се додаје може се подесити. Питања се бирају из текуће категорије питања (и, ако је изабрано, из њених поткатегорија).';
$string['addarandomselectedquestion'] = 'Додај насумично одабрано питање...';
$string['addlist'] = 'Додај списак присутних';
$string['addnewpagesafterselected'] = 'Додај прелом странице после изабраних питања';
$string['addnewquestion'] = 'ново питање';
$string['addnewquestionsqbank'] = 'Додај питања у категорију {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Додај корисничке измене';
$string['addpagebreak'] = 'Додај прелом странице';
$string['addpagehere'] = 'Додај страницу овде';
$string['addparts'] = 'Додај учеснике';
$string['addquestionfrombankatend'] = 'Додај из банке питања  на крај';
$string['addquestionfrombanktopage'] = 'Додај из банке питања на страницу {$a}';
$string['addrandom'] = 'Насумично додај {$a} питање/a вишеструког избора';
$string['addrandomfromcategory'] = 'питања насумично из категорије';
$string['addrandomquestion'] = 'питања насумично';
$string['addrandomquestiontoofflinequiz'] = 'Додавање питања у офлајн тест {$a->name} (група {$a->group})';
$string['addrandomquestiontopage'] = 'Додај насумично изабрано питање на страницу {$a}';
$string['addtoofflinequiz'] = 'Додај у офлајн тест';
$string['addtoqueue'] = 'Додај у ред за чекање';
$string['allinone'] = 'Неограничено';
$string['alllists'] = 'Сви спискови';
$string['allornothing'] = 'Све-или-ништа';
$string['allresults'] = 'Прикажи све покушаје';
$string['allstudents'] = 'Прикажи све полазнике';
$string['alwaysavailable'] = 'Увек доступно';
$string['analysis'] = 'Анализа питања';
$string['answerform'] = 'Образац за одговоре';
$string['answerformforgroup'] = 'Образац за одговоре за групу {$a}';
$string['answerforms'] = 'Обрасци за одговоре';
$string['answerpdfxy'] = 'Образац за одговоре ({$a}->maxquestions питања / {$a}->maxanswers одговора)';
$string['areyousureremoveselected'] = 'Да ли сте сигурни да желите да уклоните сва изабрана питања?';
$string['attemptexists'] = 'Покушај постоји';
$string['attemptsexist'] = 'Више не можете да додајете или уклањате питања.';
$string['attemptsnum'] = 'Укупан број покушајa: {$a}';
$string['attemptsonly'] = 'Прикажи само полазнике са покушајима';
$string['attendanceoverview'] = 'Присутност';
$string['attendances'] = 'Присутност';
$string['attendancesevaluationheadline'] = '2. Евалуација';
$string['attendancesheadline'] = 'Присутност';
$string['attendancespreparationheadline'] = '1. Припрема';
$string['attendenceoverviewattwithoutresults'] = 'Присутни без резултата:';
$string['attendenceoverviewattwithresults'] = 'Присутни са резултатима:';
$string['attendenceoverviewcorrectionnecessary'] = 'Потребна исправка (странице):';
$string['attendenceoverviewnoattwithoutresults'] = 'Одсутни без резултата:';
$string['attendenceoverviewnoattwithresults'] = 'Одсутни са резултатима:';
$string['backtopreview'] = 'Прикажи преглед';
$string['basicideasofofflinequiz'] = 'Основне идеје о прављењу офлајн теста';
$string['blackwhitethreshold'] = 'Црно/бели праг.';
$string['bulksavegrades'] = 'Сачувај оцене';
$string['calibratescanner'] = 'Калибриши скенер';
$string['cannoteditafterattempts'] = 'Не можете да додајете или уклањате питања јер већ постоје комплетирани покушаји. ({$a})';
$string['category'] = 'Категорија';
$string['changed'] = 'Резултат је промењен.';
$string['changeevaluationmode'] = 'Промените начин на који се врши евалуација. Могуће је само уколико то администратор дозволи.';
$string['checkparts'] = 'Обележи изабране учеснике као присутне';
$string['checkuserid'] = 'Обележи групу/ID ознаку корисника';
$string['chooseagroup'] = 'Изабери групу...';
$string['closebeforeopen'] = 'Није могуће ажурирати офлајн тест. Навели сте датум затварања пре датума отварања.';
$string['closestudentview'] = 'Затвори преглед из угла полазника';
$string['closewindow'] = 'Затвори прозор';
$string['cmmissing'] = 'Модул курса за офлајн тест са ID ознаком {$a} недостаје';
$string['completiondetail:passgrade'] = 'Добијте прелазну оцену';
$string['completionpass'] = 'Добију прелазну оцену';
$string['completionpass_help'] = 'Полазници ће завршити овај офлајн тест само ако постигну оцену већу или једнаку прелазној оцени, онако како је то подешено у оквиру опција за оцену';
$string['configblackwhitethreshold'] = 'Поставља праг за црно-белу конверзију 1-99 - Што је праг већи, то више белих пиксела мора да буде импортовано како би се препознали као бели. Било која друга вредност уопште не води ка црно-белој конверзији.';
$string['configdecimalplaces'] = 'Број цифара који треба приказати иза децималне тачке, када се се приказују оцене за офлајн тест.';
$string['configdisableimgnewlines'] = 'Ова опција онемогућава нове редове пре и после слика у pdf листовима са питањима. Упозорење: Ово може довести до проблема са форматирањем.';
$string['configexperimentalevaluation'] = 'Експериментална евалуација листова са одговорима';
$string['configexperimentalevaluationdesc'] = 'НЕ КОРИСТИТИ НА САЈТОВИМА СА АКТИВНИМ КУРСЕВИМА! Ова опција се користи за алфа тестове новог евалуационог алгоритма. Ако је ова опција подешена на \'Да\', можете је укључити у опцијама инстанце офлајн теста. Не препоручујемо коришћење ове опције. Уопште не постоји никаква подршка за изгубљене податке због укључивања ове опције.';
$string['configintro'] = 'Вредности које овде подесите користиће се као подразумеване вредности за нове офлајн тестове.';
$string['configkeepfilesfordays'] = 'Одредите колико дана ће се постављене датотеке слика чувати у привременом складишту. Током овог периода датотеке слика биће доступне у администраторском извештају о офлајн тесту.';
$string['configonlylocalcategories'] = 'Нису дозвољене дељене категорије питања.';
$string['configpapergray'] = '”вредност за бело” папира, који се користи за евалуацију листова са одговорима';
$string['configshuffleanswers'] = 'Измешај одговоре';
$string['configshufflequestions'] = 'Ако омогућите ову опцију, онда ће редослед питања у групама офлајн теста бити насумично измешан сваки пут када поново креирате преглед теста на картици "Креирај обрасце".';
$string['configshufflewithin'] = 'Ако омогућите ову опцију, онда ће делови који чине појединачна питања бити насумично измешани када се креирају обрасци за питања и одговоре.';
$string['configuseridentification'] = 'Формула описује идентитет корисника. Ова формула се користи како би се доделили обрасци за одговоре корисницима у систему. Лева страна једначине дефинише број цифара (само цео број, до 10 цифара). Десна страна једначине мора да означава поље у табели корисника у Moodleu (нпр. id, idnumber, phone1).
Поред тога, једначина се може бавити и префиксом и суфиксом који се додаје означеним цифрама (нпр. "a[7]=username" или "b[5]cd=username"). Ови спојеви стрингова и бројева означавају вредност коришћеног поља у табели корисника, која се користи за идентификацију корисника.';
$string['confirmremovequestion'] = 'Да ли сте сигурни да желите да уклоните ово {$a} питање?';
$string['copy'] = 'Копирај';
$string['copyright'] = '<strong>Упозорење: Текстови на овој страници су само за вашу личну информацију. Као и било које други текст ова питања су заштићена ауторским правима. Није вам дозвољено да их копирате или да их показујете другим људима!</strong>';
$string['copyselectedtogroup'] = 'Додај изабрана питања групи: {$a}';
$string['copytogroup'] = 'Додај сва питања групи: {$a}';
$string['correct'] = 'тачно';
$string['correcterror'] = 'реши';
$string['correctforgroup'] = 'Тачни одговори за групу {$a}';
$string['correctheader'] = 'Потребна исправка:';
$string['correctionerrors'] = 'Обрасци са исправљеним грешкама:';
$string['correctionform'] = 'Исправка';
$string['correctionforms'] = 'Обрасци са тачним одговорима';
$string['correctionheader'] = 'Исправка';
$string['correctionheader_help'] = '<p>Обрасци за одговоре који су овде приказани захтевају вашу пажњу и морају се ручно исправити. Аутоматска евалуација није могућа.</p>
<u>Могу се појавити следеће грешке...</u>
<ul>
  <li><strong>Нетачне ознаке:</strong> Неке ознаке нису могле бити евалуиране.</li>
  <li><strong>Неисправан број групе:</strong> Број групе није могао да буде евалуиран.</li>
  <li><strong>Неисправан број странице:</strong> Број странице није могао да буде евалуиран.</li>
  <li><strong>Неисправно скениран образац:</strong> Образац са одговорима је укриво скениран и не може бити евалуиран.</li>
  <li><strong>Постоји другачији резултат:</strong> Евалуирани резултат са другачијим бројем групе већ постоји.</li>
  <li><strong>Странице су непотпуне:</strong> Тренутни образац са одговорима је евалуиран, али недостаје најмање 1 додатни лист како би се завршила евалуација за идентификованог учесника. (Појављује се само код образаца са одговорима на више страница.)</li>
  <li><strong>Резултат постоји:</strong> Евалуирани резултат већ постоји.</li>
  <li><strong>Корисник није уписан на курс:</strong> Идентификовани учесник тренутно није уписан на курс.</li>
  <li><strong>Корисник не постоји:</strong> Идентификовани учесник је непознат.</li>
</ul>';
$string['correctionoptionsheading'] = 'Опције исправке';
$string['correctupdated'] = 'Ажуриран образац са тачним одговорима за групу {$a}.';
$string['couldnotextractpages'] = 'Грешка приликом издвајања страница из отпремљених датотека.';
$string['couldnotextractpdf'] = 'Грешка приликом конвертовања PDF документа у појединачне слике. Молимо вас да покушате са документом мање величине или контактирајте администратора.';
$string['couldnotextracttiff'] = 'Грешка приликом конвертовања tiff датотека у појединачне слике. Молимо вас да покушате са датотеком мање величине или контактирајте свог локалног администратора.';
$string['couldnotgrab'] = 'Није могуће дохватити слику {$a}';
$string['couldnotinsertjobs'] = 'Грешка са базом података приликом издвајања страница';
$string['couldnotregister'] = 'Није могуће регистровати корисника {$a}';
$string['createcategoryandaddrandomquestion'] = 'Креирај категорију и додај насумична питања';
$string['createlistfirst'] = 'Прво додајте списак учесника';
$string['createofflinequiz'] = 'Креирај обрасце';
$string['createpartpdferror'] = 'PDF образац за списак корисника {$a} не може да се креира. Списак је можда празан.';
$string['createpdf'] = 'Образац';
$string['createpdferror'] = 'Образац за групу {$a} не може да се креира. Можда не постоје питања за групу.';
$string['createpdffirst'] = 'Креирај прво PDF списак';
$string['createpdfforms'] = 'Креирај обрасце';
$string['createpdfs'] = 'Обрасци';
$string['createpdfsparticipants'] = 'Обрасци';
$string['createquestionandadd'] = 'Креирај ново питање и додај га у тест.';
$string['createquiz'] = 'Креирај обрасце';
$string['csvfile'] = 'CSV датотека';
$string['csvformat'] = 'Текстуална датотека са вредностима раздвојеним зарезом (CSV)';
$string['csvplus1format'] = 'Текстуална датотека са необрађеним подацима (CSV)';
$string['csvpluspointsformat'] = 'Текстуална датотека са тачкама (CSV)';
$string['darkgray'] = 'Тамно сива';
$string['datanotsaved'] = 'Није могуће сачувати подешавања';
$string['decimalplaces'] = 'Децимална места';
$string['decimalplaces_help'] = 'Број цифара који треба приказати иза децималне тачке, када се се приказују оцене за офлајн тест.';
$string['defaultparticipantsusage'] = 'Евидентирај присуство';
$string['defaultparticipantsusagedesc'] = 'Одређује да ли би стандардно требало присуство да се евидентира заједно са списком присутних.';
$string['defaultpdffont'] = 'Подразумевани фонт обрасца';
$string['defaultpdffont_help'] = 'Подразумевани фонт који ће офлајн тест користити за обрасце. Можда ћете желети да ручно преузмете tcpdf пакет и издвојите његове фонтове/директоријуме у вашу конфигурациону датотеку $CFG->dataroot/fonts/ за више фонтова. Препоручује се коришћење Freeserif као подразумевани фонт, јер подржава већину знакова. Погледајте  на https://www.gnu.org/software/freefont/coverage.html за комплетни списак компатибилности.';
$string['defaultpdffontsize'] = 'Подразумевана величина фонта';
$string['defaultpdffontsize_help'] = 'Подразумевана величина фонта коју ће користити сви обрасци.';
$string['deletelistcheck'] = 'Да ли заиста желите да обришете изабрану листу и све њене учеснике?';
$string['deletepagecheck'] = 'Да ли заиста желите да обришете изабране странице?';
$string['deletepagesafterselected'] = 'Уклони прелом странице после изабраних питања';
$string['deletepartcheck'] = 'Да ли заиста желите да обришете изабране учеснике?';
$string['deleteparticipantslist'] = 'Обриши списак учесника';
$string['deletepdfs'] = 'Обриши документе';
$string['deleteresultcheck'] = 'Да ли заиста желите да обришете изабране покушаје?';
$string['deleteselectedpart'] = 'Обриши изабране учеснике';
$string['deleteselectedresults'] = 'Обриши изабране покушаје';
$string['deletethislist'] = 'Обриши овај списак';
$string['deleteupdatepdf'] = 'Обриши и ажурирај PDF обрасце';
$string['difficultytitle'] = 'Тежина';
$string['difficultytitlea'] = 'Тежина А';
$string['difficultytitleb'] = 'Тежина Б';
$string['difficultytitlediff'] = 'Разлика';
$string['disableimgnewlines'] = 'Онемогућите нове редове пре и после слика';
$string['disableimgnewlines_help'] = 'Ова опција онемогућава нове редове пре и после слика у pdf листовима са питањима. Упозорење: Ово може довести до проблема са форматирањем.';
$string['discriminationindex_info'] = 'Пошто индекс дискриминативности процењује питања на основу одговора најбољих и најлошијих резултата на тесту, он неће моћи да буде израчунат, уколико:
- на ово питање нема различитих одговора полазника
- на тесту нема различитих оцена';
$string['displayoptions'] = 'Опције приказа';
$string['documentschanged'] = 'Једно или више питања у офлајн тесту је промењено од када су креирани докуменати.<br>Будући покушаји ће бити аутоматски промењени током евалуације на основу тренутне верзије измењених питања, овде изабраних. У документима је и даље приказана оригинална верзија питања.';
$string['documentschangedwithresults'] = 'Једно или више питања у офлајн тесту је промењено од када су креирани докуменати.<br>Постојећи покушаји су били аутоматски промењени на основу тренутне верзије измењених питања, овде изабраних. У документима је и даље приказана оригинална верзија питања.';
$string['done'] = 'готово';
$string['downloadallzip'] = 'Преузми све датотеке као ZIP архиву';
$string['downloadpartpdf'] = 'Преузми PDF датотеку за списак \'{$a}\'';
$string['downloadpdfs'] = 'Обрасци';
$string['downloadresultsas'] = 'Преузми резултате као:';
$string['dragtoafter'] = 'После {$a}';
$string['dragtostart'] = 'На почетак';
$string['editgroupquestions'] = 'Уреди групу питања';
$string['editgroups'] = 'Уреди офлајн групе';
$string['editingofflinequiz'] = 'Уређивање групе питања';
$string['editingofflinequiz_help'] = 'Када се креира офлајн тест, главни појмови су:
<ul><li> Офлајн тест, који садржи питања на једној или више страна</li>
<li> Банка питања, у којој се чувају копије свих питања, организованих у категорије</li></ul>';
$string['editingofflinequizx'] = 'Питања';
$string['editlist'] = 'Уреди списак';
$string['editlists'] = 'Спискови присутних';
$string['editmaxmark'] = 'Уреди максималну оцену';
$string['editofflinequiz'] = 'Уреди офлајн тест';
$string['editofflinesettings'] = 'Уреди офлајн подешавања';
$string['editorder'] = 'Уреди редослед';
$string['editparticipants'] = 'Уреди учеснике';
$string['editquestion'] = 'Уреди питање';
$string['editquestionlistitem'] = '{$a}';
$string['editquestions'] = 'Питања';
$string['editscannedform'] = 'Уреди скенирани образац';
$string['editthislist'] = 'Уреди овај списак';
$string['emptygroups'] = 'Неке групе питања офлајн тестова су празне. Молимо, додајте неколико питања.';
$string['enroluser'] = 'Упиши корисника';
$string['erroraccessingreport'] = 'Није вам дозвољено да видите овај извештај.';
$string['errormultiuserinlist'] = 'Корисник је више пута наведен у списку присутних!';
$string['errorreport'] = 'Извештај о грешкама приликом увоза';
$string['evaluated'] = 'Евалуирано:';
$string['evaluation'] = '2. Евалуација';
$string['eventattemptdeleted'] = 'Покушај решавања офлајн теста обрисан';
$string['eventattemptpreviewstarted'] = 'Преглед покушаја решавања офлајн теста започет';
$string['eventattemptreviewed'] = 'Покушај решавања офлајн теста прегледан';
$string['eventattemptsummaryviewed'] = 'Резиме покушаја решавања офлајн теста приказан';
$string['eventattemptviewed'] = 'Покушај решавања офлајн теста приказан';
$string['eventdocscreated'] = 'Обрасци за питања и одговоре офлајн теста креирани';
$string['eventdocsdeleted'] = 'Обрасци за питања и одговоре офлајн теста обрисани';
$string['eventeditpageviewed'] = 'Страница  за уређивање офлајн теста приказана';
$string['eventofflinequizattemptsubmitted'] = 'Покушај решавања офлајн теста предат';
$string['eventoverridecreated'] = 'Измена офлајн теста креирана';
$string['eventoverridedeleted'] = 'Измена офлајн теста обрисана';
$string['eventoverrideupdated'] = 'Измена офлајн теста ажурирана';
$string['eventparticipantmarked'] = 'Учесника офлајн тест ручно обележен';
$string['eventquestionmanuallygraded'] = 'Питање ручно оцењено';
$string['eventreportviewed'] = 'Извештај о офлајн тесту приказан';
$string['eventresultsregraded'] = 'Покушаји офлајн теста поново оцењени';
$string['everythingon'] = 'омогућено';
$string['excelformat'] = 'Excel радна табела (XLSX)';
$string['experimentalevaluation'] = 'Експериментална евалуација листова са одговорима';
$string['experimentalevaluation_help'] = 'Експериментална евалуација листова са одговорима';
$string['fileformat'] = 'Формат за листове са питањима';
$string['fileformat_help'] = 'Изаберите да ли желите да ваши листови са питањима буду у PDF, DOCX или TEX формату. Обрасци за одговоре и листови са тачним одговорима ће увек бити генерисан у PDF формату.';
$string['fileprefixanswer'] = 'answer_form';
$string['fileprefixcorrection'] = 'correction_form';
$string['fileprefixform'] = 'question_form';
$string['fileprefixparticipants'] = 'participants_list';
$string['filesizetolarge'] = 'Неке од ваших датотека слика су врло велике. Димензије ће бити промењене током интерпретације скенираних образаца. Молимо вас да обрасце скенирате у резолуцији између 200 и 300 dpi (тачака по инчу) и у црно-бело режиму. Ово ће убрзати интерпретацију следећи пут.';
$string['filterbytags'] = 'Филтрирање по ознакама...';
$string['fontfamilycourier'] = 'Courier';
$string['fontfamilyfreemono'] = '(Free-)Mono';
$string['fontfamilyfreesans'] = '(Free-)Sans';
$string['fontfamilyfreeserif'] = '(Free-)Serif (препоручено)';
$string['fontfamilyhelvetica'] = 'Helvetica';
$string['fontfamilyhysmyeongjostdmedium'] = 'MyungJo Medium (Korean)';
$string['fontfamilykozgopromedium'] = 'Kozuka Gothic Pro (Japanese Sans-Serif)';
$string['fontfamilykozminproregular'] = 'Kozuka Mincho Pro (Japanese Serif)';
$string['fontfamilymsungstdlight'] = 'MSung Light (Trad. Chinese)';
$string['fontfamilystsongstdlight'] = 'STSong Light (Simp. Chinese)';
$string['fontfamilysymbol'] = 'Symbol';
$string['fontfamilytimes'] = 'Times';
$string['fontfamilyzapfdingbats'] = 'ZapfDingbats';
$string['fontsize'] = 'Величина фонта';
$string['forautoanalysis'] = 'За аутоматску анализу';
$string['formforcorrection'] = 'Образац са тачним одговорима за групу {$a}';
$string['formforgroup'] = 'Образац са питањима за групу {$a}';
$string['formforgroupdocx'] = 'Образац са питањима за групу {$a} (DOCX)';
$string['formforgrouplatex'] = 'Образац са питањима за групу {$a} (LATEX)';
$string['forms'] = 'Обрасци';
$string['formsexist'] = 'Обрасци су већ креирани.';
$string['formsexistx'] = 'Обрасци су већ креирани (<a href="{$a}">Преузми обрасце</a>)';
$string['formsheetsettings'] = 'Подешавања образаца';
$string['formspreview'] = 'Преглед';
$string['formwarning'] = 'Не постоји дефинисан образац за одговоре. Молимо контактирајте свог администратора.';
$string['fromquestionbank'] = 'из банке питања';
$string['functiondisabledbysecuremode'] = 'Ова функционалност је тренутно онемогућена';
$string['furtheroptionsheading'] = 'Додатне опције';
$string['generalfeedback'] = 'Опште повратне информације';
$string['generalfeedback_help'] = 'Опште повратне информације представљају текст који се приказује након покушаја да се одговори на питање. За разлику од повратне информације за појединачно питање које зависи од датог одговора, исте опште повратне информације се увек приказују.';
$string['generatepdfform'] = 'Генериши PDF образац';
$string['grade'] = 'Оцена';
$string['gradedon'] = 'Оцењено';
$string['gradedscannedform'] = 'Скенирани образац са оценама';
$string['gradeiszero'] = 'Напомена: максимална оцена за овај офлајн тест је 0 бодова!';
$string['gradeswarning'] = 'Оцене за питања морају бити бројеви!';
$string['gradewarning'] = 'Оцена за питање мора бити број!';
$string['gradingofflinequiz'] = 'Оцене';
$string['gradingofflinequizx'] = 'Оцене';
$string['gradingoptionsheading'] = 'Опције оцењивања';
$string['greeniscross'] = 'рачунато као крстић';
$string['group'] = 'Група';
$string['groupoutofrange'] = 'Група је ван опсега и замењена је са групом А.';
$string['hasresult'] = 'Постоји резултат';
$string['hotspotdeletiontask'] = 'Брисање активних подручја';
$string['html'] = 'HTML';
$string['id'] = 'ID ознака корисника';
$string['idnumber'] = 'ID број / Број досијеа';
$string['imagefile'] = 'Датотека слике';
$string['imagenotfound'] = 'Датотека слике: {$a} није пронађена!';
$string['imagenotjpg'] = 'Слика није jpg или png: {$a}';
$string['imagickwarning'] = 'Недостаје imagemagick библиотека: Замолите свог администратора система да инсталира imagemagick библиотеку и да провери путању до датотеке за конверзију у вашим подешавањима филтера за TeX нотацију. TIF датотеке не можетете да увезете без imagemagick библиотеке!';
$string['import'] = 'Евалуирај';
$string['importedon'] = 'Евалуирано';
$string['importerror11'] = 'Постоји други резултат';
$string['importerror12'] = 'Корисник није регистрован';
$string['importerror13'] = 'Нема податка о групи';
$string['importerror14'] = 'Није могуће дохватити';
$string['importerror15'] = 'Нејасно обележени одговори';
$string['importerror16'] = 'Грешка странице';
$string['importerror17'] = 'Странице непотпуне';
$string['importerror21'] = 'Није могуће дохватити';
$string['importerror22'] = 'Нејасно обележени одговори';
$string['importerror23'] = 'Корисник није на списку';
$string['importerror24'] = 'Списак није детектован';
$string['importforms'] = 'Отпремите формуларе са одговорима';
$string['importfromto'] = 'Евалуирање од {$a->from} до {$a->to} од укупно {$a->total}.';
$string['importisfinished'] = 'Евалуација за офлајн тест {$a} је завршена.';
$string['importlinkresults'] = 'Линк за резултате: {$a}';
$string['importlinkverify'] = 'Линк за проверу: {$a}';
$string['importmailsubject'] = 'обавештење о увозу офлајн теста';
$string['importnew'] = 'Евалуирај';
$string['importnew_help'] = '<p>
Можете да увезете појединачне датотеке скенираних слика или већи број њих, упакованих у ZIP-архиву. Модул \'Офлајн тест\' ће обрадити датотеке слика у позадини.
Називи датотека нису битни али не би требало да садрже посебне знакове као што су дијакритици, умлаути итд. Слике треба да буду у форматима GIF, PNG или TIF. Препоручује се резолуција између 200 и 300dpi (тачака по инчу).</p>';
$string['importnumberexisting'] = 'Број дуплих образаца: {$a}';
$string['importnumberpages'] = 'Број успешно увезених страница: {$a}';
$string['importnumberresults'] = 'Број увезених: {$a}';
$string['importnumberverify'] = 'Број образаца за који је потребна провера: {$a}';
$string['importtimefinish'] = 'Обрада је завршена: {$a}';
$string['importtimestart'] = 'Обрада је започела: {$a}';
$string['inconsistentdata'] = 'Противречни подаци: {$a}';
$string['info'] = 'Информације';
$string['infoshort'] = 'инфо';
$string['insecuremarkings'] = 'Нејасно обележени одговори траже ручне исправке';
$string['insecuremarkingsforquestion'] = 'Нејасно обележени одговори траже ручне исправке за питања';
$string['insertnumber'] = 'Молимо вас да убаците тачан идентификациони број обележен плавим оквиром.';
$string['instruction1'] = 'Овај образац са одговорима биће аутоматски скениран. Молимо вас да га не савијате или жврљате по њему. За обележавање одговора користите црну или плаву оловку:';
$string['instruction2'] = 'Само јасно обележени одговори биће интерпретирани као исправни. Ако желите да исправите (поништите) свој одговор, комплетно испуните поље бојом. Тако обележено поље, приликом скенирања, биће интерпретирано као празно:';
$string['instruction3'] = 'Поља која су исправљена (комплетно испуњена бојом) не могу више да буду исправно обележена. Молимо вас да не ништа не пишете изван поља за обележавање.';
$string['introduction'] = 'Увод';
$string['invalidformula'] = 'Неисправна формула за идентификацију корисника. Формула мора имати облик <prefix>[<#digits>]<suffix>=<db-field&>.';
$string['invalidnumberofdigits'] = 'Коришћен је неисправан број цифара. Дозвољено је само 1 до 9 цифара.';
$string['invaliduserfield'] = 'Коришћено је неисправно поље корисничке табеле.';
$string['invigilator'] = 'Дежурни на испиту';
$string['ischecked'] = 'Учешће је проверено';
$string['isnotchecked'] = 'Учешће није проверено';
$string['itemdata'] = 'Подаци о ајтему';
$string['keepfilesfordays'] = 'Временски период чувања датотека (у данима)';
$string['legend'] = 'Легенда';
$string['legenddone'] = 'Корак је успешно обављен (није потребна додатна акција).';
$string['legendnextitem'] = 'Потребна акција у даљем току рада (могуће зависност од претходних корака).';
$string['legendnoaction'] = 'Никаква акција није потребна';
$string['legendwarning'] = 'Потребна је хитна акција.';
$string['letter'] = 'Слово';
$string['lightgray'] = 'Светло сивa';
$string['linktoscannedform'] = 'Прикажи скенирани образац';
$string['listnotdetected'] = 'Није могуће детектовати бар кôд за списак!';
$string['logdeleted'] = 'Запис {$a} је обрисан.';
$string['logourl'] = 'URL адреса логотипа';
$string['logourldesc'] = 'URL адреса датотеке слике који се приказује у горњем десном углу обрасца са одговорима, тј. <b>http://www.yoursite.tld/mylogo.png</b> или <b>../path/to/your/logo.png</b>. Максимална дозвољена величина је 520x140 пиксела. Образац са одговорима не може да се евалуира ако слика прелази максималну величину!';
$string['lowertrigger'] = 'Друга доња граница';
$string['lowertriggerzero'] = 'Друга доња граница је нула';
$string['lowerwarning'] = 'Прва доња граница';
$string['lowerwarningzero'] = 'Прва доња граница је нула';
$string['marginwarning'] = 'Молимо вас да одштампате следеће PDF документе без додатних маргина!<br /> Избегавајте да студентима дајете фотокопије.';
$string['marks'] = 'Оцене';
$string['matrikel'] = 'идентификациони број полазника';
$string['maxgradewarning'] = 'Највећа оцена мора да буде број!';
$string['maxmark'] = 'Максимална оцена';
$string['membersinplist'] = '{$a->count} учесник/а у<a href="{$a->url}">{$a->name}</a>';
$string['messageprovider:jobs'] = 'Обавештења о офлајн тесту';
$string['missingimagefile'] = 'Недостаје датотека слике';
$string['missingitemdata'] = 'Недостаје/у одговор/и за корисника {$a}';
$string['missinglogdata'] = 'Недостају подаци о запису за постојећи резултат.';
$string['missingquestion'] = 'Изгледа да ово питање више не постоји';
$string['missinguserid'] = 'Недостаје идентификациони број корисника! Није могуће прочитати бар кôд!';
$string['modulename'] = 'Офлајн тест';
$string['modulename_help'] = 'Овај модул омогућава предавачима да дизајнирају офлајн тестове који се састоје од питања вишеструког избора.
Ова питања се чувају у банци питања и могу се користите више пута унутар курсева, као и на другим курсевима.
Офлајн тестови могу да се преузму као PDF-, DOCX- или LaTeX датотеке. Полазници обележавају своје одговоре на листу са обрасцем за одговоре. Листови са обрасцима се скенирају након чега се одговори увозе у систем.
<p><a href="https://academic-moodle-cooperation.org/anleitungen/offline-test-einstellungen/?lng=en" target="_blank">Офлајн тест: подешавања</a></p>
<p><a href="https://academic-moodle-cooperation.org/anleitungen/offline-test-fragen-hinzufugen-und-formulare-generieren/?lng=en" target="_blank">Офлајн тест: додавање питања и генерисање образаца</a></p>
<p><a href="https://academic-moodle-cooperation.org/anleitungen/offline-test-durchfuhren-und-auswerten/?lng=en" target="_blank">Офлајн тест: спровеђење и евалуација офлајн теста</a></p>';
$string['modulenameplural'] = 'Офлајн тестови';
$string['moodleprocessing'] = 'Пустите да Moodle обради податке';
$string['movecorners'] = 'Промените прво позицију угаоних маркера. Користите опцију \'превуци и спусти\'';
$string['moveselectedonpage'] = 'Преместите изабрана питања на страницу: {$a}';
$string['multianswersforsingle'] = 'Питање вишеструког избора са једним одговором';
$string['multichoice'] = 'Вишеструки избор';
$string['multipleanswers'] = 'Изаберите бар један одговор.';
$string['name'] = 'Назив офлајн теста';
$string['neededcorrection'] = '<strong>Пажња: За неке од ваших обележених одговара потребна је ручна исправка. Погледајте црвени квадрат на следећој слици.
<br />Ово подразумева ручну интервенције од стране предавача и одложено објављивање резултата офлајн теста!</strong>';
$string['newgrade'] = 'Оцењено';
$string['newpage'] = 'Нова страница';
$string['noattemptexists'] = 'Не постоји ниједан покушај';
$string['noattempts'] = 'Није увезен ниједан покушај!';
$string['noattemptsonly'] = 'Прикажи само студенте без покушаја';
$string['nocourse'] = 'Недостаје курс са ID ознаком {$a->course} којем припада офлајн тест са ID ознаком {$a->offlinequiz}.';
$string['nogradesseelater'] = 'Овај тест није оцењен још за {$a}. Резултати ће бити овде објављени.';
$string['nogroupdata'] = 'Нема податка о групи за корисника {$a}';
$string['nomcquestions'] = 'Не постоје питања вишеструког избора у групи {$a}!';
$string['noofflinequiz'] = 'Не постоји офлајн тест са ID ознаком {$a}!';
$string['nopages'] = 'Није увезена ниједна страница';
$string['noparticipantsfound'] = 'Није пронађен ниједан учесник';
$string['nopdfscreated'] = 'Није креиран ниједан документ!';
$string['noquestions'] = 'Неке групе офлајн теста су празне. Додајте питања.';
$string['noquestionselected'] = 'Није изабрано ниједно питање!';
$string['noquestionsfound'] = 'Не постоје питања у групи {$a}!';
$string['noquestionsonpage'] = 'Празна страница';
$string['noresults'] = 'Не постоје резултати.';
$string['noreview'] = 'Није вам дозвољено да прегледате овај офлајн тест';
$string['noscannedpage'] = 'Не постоји скенирана страница са ID ознаком {$a}!';
$string['notagselected'] = 'Није изабрана ниједна ознака';
$string['notavailable'] = 'N/A';
$string['nothingtodo'] = 'Не ради ништа';
$string['notxtfile'] = 'Нема TXT датотеке';
$string['notyetgraded'] = 'Још није оцењено';
$string['nozipfile'] = 'Нема ZIP датотеке';
$string['numattempts'] = 'Број увезених покушаја: {$a}';
$string['numattemptsqueue'] = 'Број образаца са одговорима који су додати на чекање: {$a}. Након обраде података биће послата порука на вашу е-адресу.';
$string['numattemptsverify'] = 'Број скенираних образаца који чекају исправку: {$a}';
$string['numberformat'] = 'Вредност мора да буде број са {$a} цифре/цифара!';
$string['numbergroups'] = 'Број група';
$string['numpages'] = 'Увезено страна: {$a}';
$string['numquestionsx'] = 'Питања: {$a}';
$string['numusersadded'] = 'Додато учесника: {$a}';
$string['odsformat'] = 'OpenDocument радна табела (ODS)';
$string['offlineimplementationfor'] = 'Офлајн имплементација за';
$string['offlinequiz:addinstance'] = 'Додај офлајн тест';
$string['offlinequiz:attempt'] = 'Покушај решавања тестова';
$string['offlinequiz:changeevaluationmode'] = 'Омогућите промену начина евалуације. УПОЗОРЕЊЕ: НЕ КОРИСТИТИ НА САЈТОВИМА СА АКТИВНИМ КУРСЕВИМА!';
$string['offlinequiz:createofflinequiz'] = 'Креирај обрасце за офлајн тест';
$string['offlinequiz:deleteattempts'] = 'Обриши покушаје решавања офлајн теста';
$string['offlinequiz:grade'] = 'Оцени офлајн тестове ручно';
$string['offlinequiz:manage'] = 'Управљање офлајн тестовима';
$string['offlinequiz:preview'] = 'Прегледај офлајн тестове';
$string['offlinequiz:view'] = 'Прикажи информације о офлајн тесту';
$string['offlinequiz:viewreports'] = 'Прикажи извештаје о офлајн тесту';
$string['offlinequizcloses'] = 'Офлајн тест се затвара';
$string['offlinequizcloseson'] = 'Преглед овог офлајн теста ће се затворити {$a}';
$string['offlinequizcontent'] = 'Садржај офлајн теста';
$string['offlinequizisclosed'] = 'Офлајн тест је затворен';
$string['offlinequizisclosedwillopen'] = 'Офлајн тест затворен (отвара се {$a})';
$string['offlinequizisopen'] = 'Овај офлајн тест је отворен';
$string['offlinequizisopenwillclose'] = 'Офлајн тест отворен (затвара се {$a})';
$string['offlinequizopenedon'] = 'Овај офлајн тест је отворен {$a}';
$string['offlinequizopens'] = 'Офлајн тест се отвара';
$string['offlinequizsettings'] = 'Подешавања офлајн теста';
$string['offlinequizwillopen'] = 'Офлајн тест се отвара {$a}';
$string['oneclickenrol'] = 'Упис на 1 клик';
$string['oneclickenroldesc'] = 'Ако је активирана ова опција предавачи имају могућност да упишу кориснике једним кликом док исправљају обрасце са одговорима (грешка "Корисник није уписан на курс").';
$string['oneclickrole'] = 'Улога за ”Упис на 1 клик”';
$string['oneclickroledesc'] = 'Изаберите улогу која се користи за ”Упис на 1 клик”. Могу бити изабране само улоге са архетипом ”студент”.';
$string['onlylocalcategories'] = 'Само локалне категорије питања';
$string['orderandpaging'] = 'Редослед и пагинација';
$string['orderandpaging_help'] = 'Бројеви 10, 20, 30... поред сваког питања указују на редослед питања у тесту. Бројеви се повећавају у корацима по 10 како би се оставио простор за убацивање додатних питања. Да бисте променили редослед питања, промените број а онда кликните на дугме "Промени редослед питања".

Да бисте додали прелом странице након одређеног питања, означите поље за потврду одмах поред самог питања а затим кликните на дугме "Додај прелом странице после изабраних питања"

Да бисте организовали питања на више страница кликните на дугме "Реорганизуј странице" и изаберите жељени број питања по страници.';
$string['orderingofflinequiz'] = 'Редослед и пагинација';
$string['otherresultexists'] = 'Другачији резултат за {$a} већ постоји, увоз је игнорисан! Обришите резултат прво.';
$string['outof'] = '{$a->grade} од максималних {$a->maxgrade}';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Свеобухватне повратне информације';
$string['overview'] = 'Информације о тесту';
$string['overviewdownload_help'] = 'Преузмите преглед';
$string['page-mod-offlinequiz-edit'] = 'Страница за уређивање офлајн теста';
$string['page-mod-offlinequiz-x'] = 'Било која страница офлајн теста';
$string['pagecorrected'] = 'Исправљени лист са списком учесника увезен';
$string['pageevaluationtask'] = 'Евалуација листова са одговорима за офлајн тест';
$string['pageimported'] = 'Лист са списком учесника увезен';
$string['pagenotdetected'] = 'Није могуће детектовати бар кôд за страницу!';
$string['pagenumberimported'] = 'Лист {$a} са списком учесника увезен';
$string['pagenumberupdate'] = 'Ажурирање броја странице';
$string['pagesinprocessing'] = 'У обради:';
$string['pagesizeparts'] = 'Број учесника приказаних по страници:';
$string['papergray'] = 'Вредност белине папира';
$string['papergray_help'] = 'Ако су бели делови ваших скенираних образаца за одговоре веома тамни, то можете да исправите тако што ћете ову вредност подесити на \'Тамно сива\'.';
$string['partcheckedwithoutresult'] = '<a href="{$a->url}">Потврђени учесници без резултата: {$a->count}</a>';
$string['partcheckedwithresult'] = 'Потврђени учесници са резултатом: {$a}';
$string['partial'] = 'делимично';
$string['participants'] = 'Учесници';
$string['participants_help'] = '<p>Спискови учесника су дизајнирани за велике тестове са великим бројем учесника. Они помажу предавачу да провери који полазници су приступили тесту и да ли су сви резултати исправно увезени.
Можете да додате кориснике на различите спискове. Сваки списак може, на пример, да садржи учеснике у одређеној просторији. Учесници могу да буду чланови посебне групе. За креирање тих група може се користити алат за регистрацију групе.
Спискови учесника могу се преузети као PDF документи и одштампати. Присутни полазници се могу обележити крстићем, баш као што се обележавају одговори у обрасцу за одговоре офлајн теста. Након тога, скенирани спискови могу да буду постављени на сервер, а полазници обележени крстићем биће означени у бази података као присутни.
Избегавајте мрље на бар кôдовима јер се они користе за идентификацију полазника.</p>';
$string['participantsinlists'] = 'Учесници';
$string['participantslist'] = 'Списак учесника';
$string['participantslists'] = 'Учесници';
$string['participantsusage'] = 'Евидентирај присуство';
$string['participantsusage_help'] = 'Ова опција одређује да ли можете да евидентирате присуство полазника са списком присутних. Спискови присутних су дизајниране за велике офлајн тестове са много учесника. Помоћу њих се може проверити који су полазници учествовали на тесту и да ли су сви резултати тачно оцењени.';
$string['partimportnew'] = 'Постављање списка учесника';
$string['partimportnew_help'] = '<p>
У овој картици можете да поставите попуњене спискове учесника. Можете да отпремите појединачне датотеке скенираних слика или већи број њих, упакованих у ZIP-архиву. Модул \'Офлајн тест\' ће обрадити датотеке слика у позадини.
Називи датотека нису битни али не би требало да садрже посебне знакове као што су дијакритици, умлаути итд. Слике треба да буду у форматима GIF, PNG или TIF. Препоручује се резолуција између 200 и 300dpi (тачака по инчу).</p>';
$string['partuncheckedwithoutresult'] = 'Непотврђени учесници без резултата: {$a}';
$string['partuncheckedwithresult'] = '<a href="{$a->url}">Непотврђени учесници са резултатом: {$a->count}</a>';
$string['pdfdeletedforgroup'] = 'Образац за групу {$a} обрисан';
$string['pdffont'] = 'Фонт обрасца';
$string['pdffont_help'] = 'Овде можете изабрати фонт за све ваше PDF обрасце: за одговоре, за исправке, за присуство, као и обрасце за питања, уколико сте за све обрасце изабрали PDF формат. Избор такође треба да зависи од тога које знакове користите у својим обрасцима. DOCX и LATEX формат не утичу на листове са питањима.';
$string['pdfintro'] = 'Додатне информације';
$string['pdfintro_help'] = 'Ове информације биће штампане на првој страници листа са питањима. Оне треба да садрже упутство како се попуњава образац са одговорима.';
$string['pdfintrotext'] = '<b>Како да правилно обележим одговоре?</b><br />Овај образац са одговорима биће аутоматски скениран. Молимо вас да га не савијате или жврљате по њему. За обележавање одговора користите црну или плаву оловку. Одговор који сматрате тачним обележите знаком X. Ако желите да исправите свој одговор, комплетно испуните поље бојом. Тако обележено поље, приликом скенирања, биће интерпретирано као празно.<br />';
$string['pdfintrotoolarge'] = 'Увод је предугачак (максимално 2000 знакова).';
$string['pdfscreated'] = 'PDF обрасци су креирани';
$string['pdfsdeletedforgroup'] = 'Обрасци за групу {$a} обрисани';
$string['pearlywhite'] = 'Бисерно бела';
$string['pluginadministration'] = 'Администрација офлајн теста';
$string['pluginname'] = 'Офлајн тест';
$string['point'] = 'поен';
$string['preparation'] = '1. Припрема';
$string['present'] = 'Присутан';
$string['preventsamequestion'] = 'Спречите вишеструко коришћење истог питања у различитим групама';
$string['preview'] = 'Преглед';
$string['previewforgroup'] = 'Група {$a}';
$string['previewquestion'] = 'Прегледај питање';
$string['printstudycodefield'] = 'Штампај поље за шифру студијског програма на листу са питањима';
$string['printstudycodefield_help'] = 'Ако омогућите ову опцију, онда ће на првој страници обрасца са питањима бити одштампано поље за уписивање шифре студијског програма.';
$string['privacy:data_folder_name'] = 'Подаци офлајн теста';
$string['privacy:metadata:core_files'] = 'Офлајн тест користи API за чување генерисаних листова са питањима, листова за одговоре и листова за исправке, као и листове са попуњеним одговорима.';
$string['privacy:metadata:core_question'] = 'Офлајн тест користи API за питања за чување питања за тестове.';
$string['privacy:metadata:mod_quiz'] = 'Офлајн тест користи API теста за чување резултата тестова.';
$string['privacy:metadata:offlinequiz'] = 'Табела офлајн теста чува све информације везане за конкретну инстанцу офлајн теста.';
$string['privacy:metadata:offlinequiz:course'] = 'Колона \'course\' у табели офлајн теста чува податак у ком курсу се овај офлајн теста налази.';
$string['privacy:metadata:offlinequiz:decimalpoints'] = 'Број децималних поена за израчунавање оцена.';
$string['privacy:metadata:offlinequiz:disableimgnewlines'] = 'Требало би да онемогући нове редове пре и после слика.';
$string['privacy:metadata:offlinequiz:docscreated'] = 'Ако су документи креирани, ово поље је подешено на 1, иначе је 0.';
$string['privacy:metadata:offlinequiz:fileformat'] = 'Формат датотеке који се користи за штампање листова са питањима,  0 за pdf, 1 за docx, 2 за LaTeX.';
$string['privacy:metadata:offlinequiz:fontsize'] = 'Величина фонта у листовима са питањима.';
$string['privacy:metadata:offlinequiz:grade'] = 'Оцена показује максималан број поена који можете се добити на овом офлајн тесту.';
$string['privacy:metadata:offlinequiz:id_digits'] = 'Чува број цифара коју је ID број имао када су листови за одговоре креирани. Ово је потребно због повратне компатибилности, уколико се број цифара повећа у периоду између креирања (пре теста) и увоза листова са одговорима (након теста).';
$string['privacy:metadata:offlinequiz:introformat'] = 'Ово поље се не користи.';
$string['privacy:metadata:offlinequiz:name'] = 'Колона \'name\' чува назив офлајн теста.';
$string['privacy:metadata:offlinequiz:numgroups'] = 'Број група које овај офлајн тест има.';
$string['privacy:metadata:offlinequiz:papergray'] = '”Вредност за бело” овог офлајн теста.';
$string['privacy:metadata:offlinequiz:pdfintro'] = 'Додатне информације које се умећу на почетак листова са питањима.';
$string['privacy:metadata:offlinequiz:printstudycodefield'] = 'Параметар који одређује да ли треба одштампати шифру студија на обрасцу са питањима. 1 да, 0 не';
$string['privacy:metadata:offlinequiz:review'] = 'Ова колона чува информације о томе како се преглед врши.';
$string['privacy:metadata:offlinequiz:showgrades'] = 'Чува податке о томе да ли треба на листу са питањима одштамапти број поена који се добија за свако питање.';
$string['privacy:metadata:offlinequiz:showquestioninfo'] = 'Чува се ако треба да буде приказана информација о питањима, 0 за не, 1 за информације о типу питања, 2 за информације о броју тачних одговора.';
$string['privacy:metadata:offlinequiz:showtutorial'] = 'Чува се уколико се од учесника тражи да ураде туторијал за офлајн тест.';
$string['privacy:metadata:offlinequiz:shufflequestions'] = 'Параметар који одређује да ли приликом креирања офлајн теста питања треба да буду измешана; 1- да, 0 - не';
$string['privacy:metadata:offlinequiz:time'] = 'Колона \'time\' чува датум офлајн теста.';
$string['privacy:metadata:offlinequiz:timeclose'] = 'Колона \'timeclose\' чува време када је офлајн тест био, односно, када ће бити затворен.';
$string['privacy:metadata:offlinequiz:timecreated'] = 'Колона \'timecreated\' чува време када је офлајн тест био креиран.';
$string['privacy:metadata:offlinequiz:timemodified'] = 'Колона \'timemodified\' чува време када је офлајн тест био последњи пут промењен.';
$string['privacy:metadata:offlinequiz:timeopen'] = 'Колона \'timeclose\' чува време када је офлајн тест био, односно, када ће бити oтворен.';
$string['privacy:metadata:offlinequiz_choices'] = 'Ова табела садржи информације о свим прецртаним одговорима (обележеним знаком X) на свим скенираним страницама. Информације су потребне за касније креирање резултата на основу прецртаних одговора (обележених знаком X).';
$string['privacy:metadata:offlinequiz_choices:choicenumber'] = 'Број понуђених одговора за ово питање.';
$string['privacy:metadata:offlinequiz_choices:scannedpageid'] = 'Скенирана страница на коју се овај изабрани одговор односи.';
$string['privacy:metadata:offlinequiz_choices:slotnumber'] = 'Место овог одговора у питању';
$string['privacy:metadata:offlinequiz_choices:value'] = 'Да ли се изабрани одговор сматра прецртаним (обележеним знаком X). 0 за не, 1 за да, -1 за није сигурно.';
$string['privacy:metadata:offlinequiz_group_questions'] = 'Ова табела чува сва питања за сваку групу офлајн теста.';
$string['privacy:metadata:offlinequiz_group_questions:maxmark'] = 'Максимални број поена који се може постићи за ово питање.';
$string['privacy:metadata:offlinequiz_group_questions:offlinegroupid'] = 'Група офлајн теста на коју се ово питање односи.';
$string['privacy:metadata:offlinequiz_group_questions:offlinequizid'] = 'ID ознака офлајн теста на коју се ово питање односи.';
$string['privacy:metadata:offlinequiz_group_questions:page'] = 'Страница на којој је ово питање одштампано у листовима за одговоре.';
$string['privacy:metadata:offlinequiz_group_questions:position'] = 'Позиција у овом офлајн тесту.';
$string['privacy:metadata:offlinequiz_group_questions:questionid'] = 'ID ознака изабраног питања.';
$string['privacy:metadata:offlinequiz_group_questions:slot'] = 'Место питања у тесту';
$string['privacy:metadata:offlinequiz_groups'] = 'Табела за групе офлајн тестова.';
$string['privacy:metadata:offlinequiz_groups:answerfilename'] = 'Назив датотеке која је коришћена за чување одговора.';
$string['privacy:metadata:offlinequiz_groups:correctionfilename'] = 'Датотека која је коришћена за чување исправки';
$string['privacy:metadata:offlinequiz_groups:number'] = 'Број групе за овај офлајн тест, 1 за групу А, 2 за групу Б, итд.';
$string['privacy:metadata:offlinequiz_groups:numberofpages'] = 'Број страница који је потребан за штампање листова за одговоре.';
$string['privacy:metadata:offlinequiz_groups:offlinequizid'] = 'ID ознака офлајн теста ком припада овај офлајн тест.';
$string['privacy:metadata:offlinequiz_groups:questionfilename'] = 'Назив датотеке које је коришћено за чување датотеке са питањима';
$string['privacy:metadata:offlinequiz_groups:sumgrades'] = 'Збир свих оцена за сва питања у овој групи.';
$string['privacy:metadata:offlinequiz_groups:templateusageid'] = 'ID ознака употребе шаблона API-ја, који се користи за креирање резултата у API-ју теста.';
$string['privacy:metadata:offlinequiz_hotspots'] = 'Ова табела чува све позиције поља за одговоре уколико су успешно она евалуирана.';
$string['privacy:metadata:offlinequiz_hotspots:blank'] = 'Ако је активно подручје успешно анализирано.';
$string['privacy:metadata:offlinequiz_hotspots:name'] = 'Тип активног подручја, нпр. u%number за активно подручје корисника, a-0-0 за питање 1 одговор 1, и тако даље.';
$string['privacy:metadata:offlinequiz_hotspots:scannedpageid'] = 'Скенирана страница на којој се налази активно подручје.';
$string['privacy:metadata:offlinequiz_hotspots:time'] = 'Време када је последњи пут ажурирано ово активно подручје.';
$string['privacy:metadata:offlinequiz_hotspots:x'] = 'X вредност активног подручја';
$string['privacy:metadata:offlinequiz_hotspots:y'] = 'Y вредност активног подручја';
$string['privacy:metadata:offlinequiz_p_choices'] = 'Ова табела чува све прецртане одговоре (обележене знаком X) на листовима за одговоре полазника.';
$string['privacy:metadata:offlinequiz_p_choices:scannedpageid'] = 'Скенирана страница на коју се овај изабрани одговор односи.';
$string['privacy:metadata:offlinequiz_p_choices:userid'] = 'ID ознака корисника на ког се односи овај изабрани одговор.';
$string['privacy:metadata:offlinequiz_p_choices:value'] = 'Pozivna URL adresa strima';
$string['privacy:metadata:offlinequiz_p_lists'] = 'Ова табела чува информације о списковима учесника где предавачи могу да означе, да ли је полазник био на тесту или не.';
$string['privacy:metadata:offlinequiz_p_lists:filename'] = 'Назив датотеке за списак.';
$string['privacy:metadata:offlinequiz_p_lists:name'] = 'Назив списка учесника.';
$string['privacy:metadata:offlinequiz_p_lists:number'] = 'Број списка у офлајн тесту.';
$string['privacy:metadata:offlinequiz_p_lists:offlinequizid'] = 'Офлајн тест коме овај списак припада.';
$string['privacy:metadata:offlinequiz_page_corners'] = 'Ова табела чува све углове сваке скениране странице како би је брже евалуирала приликом следеће евалуације или исправке.';
$string['privacy:metadata:offlinequiz_page_corners:position'] = 'Информација о томе да ли је овај угао на врху или на дну и десно или лево.';
$string['privacy:metadata:offlinequiz_page_corners:scannedpageid'] = 'Скенирана страница на којој се налази овај угао.';
$string['privacy:metadata:offlinequiz_page_corners:x'] = 'X вредност угла.';
$string['privacy:metadata:offlinequiz_page_corners:y'] = 'Y вредност угла.';
$string['privacy:metadata:offlinequiz_participants'] = 'Табела учесника чува податке о томе да ли је корисник учествовао у офлајн тесту или не.';
$string['privacy:metadata:offlinequiz_participants:checked'] = 'Информације о томе да ли је овај корисник обележен на списку учесника.';
$string['privacy:metadata:offlinequiz_participants:listid'] = 'ID ознака списка на ком се овај учесник налази.';
$string['privacy:metadata:offlinequiz_participants:userid'] = 'ID ознака корисника.';
$string['privacy:metadata:offlinequiz_queue'] = 'Ова табела чува податке о реду за отпремање офлајн теста. За свако отпремање постоји његов засебни објекат у овој табели.';
$string['privacy:metadata:offlinequiz_queue:importuserid'] = 'Корисничка ID ознака предавача који је увезао датотеке.';
$string['privacy:metadata:offlinequiz_queue:offlinequizid'] = 'ID ознака офлајн теста у реду за чекање.';
$string['privacy:metadata:offlinequiz_queue:status'] = 'Статус реда за чекање који је потребан.';
$string['privacy:metadata:offlinequiz_queue:timecreated'] = 'Време када су увезени ови листови офлајн теста.';
$string['privacy:metadata:offlinequiz_queue:timefinish'] = 'Време када је евалуација офлајн теста у реду за чекање завршена.';
$string['privacy:metadata:offlinequiz_queue:timestart'] = 'Време када је евалуација офлајн теста у реду за чекање започета.';
$string['privacy:metadata:offlinequiz_queue_data'] = 'Ова табела чува податке за ред пошто ће свака датотека у реду за чекање добити објекат података реда.';
$string['privacy:metadata:offlinequiz_queue_data:error'] = 'Уколико је статус грешка, овде ће стајати детаљнија порука о грешци.';
$string['privacy:metadata:offlinequiz_queue_data:filename'] = 'Назив датотеке на коју се овај ред односи.';
$string['privacy:metadata:offlinequiz_queue_data:queueid'] = 'Ред којем ови подаци припадају.';
$string['privacy:metadata:offlinequiz_queue_data:status'] = 'Статус података о реду.';
$string['privacy:metadata:offlinequiz_results'] = 'Ова табела чува све податке о резултатима, који се не могу чувати у API-ју теста.';
$string['privacy:metadata:offlinequiz_results:offlinegroupid'] = 'Група офлајн теста којој овај резултат припада.';
$string['privacy:metadata:offlinequiz_results:offlinequizid'] = 'Офлајн тест, којем овај резултат припада.';
$string['privacy:metadata:offlinequiz_results:status'] = 'Статус резултата (непотпун или потпун).';
$string['privacy:metadata:offlinequiz_results:sumgrades'] = 'Збир свих оцена за овај резултат.';
$string['privacy:metadata:offlinequiz_results:teacherid'] = 'Предавач који је поставио резултат.';
$string['privacy:metadata:offlinequiz_results:timefinish'] = 'Време завршетка када је резултат уметнут по први пут.';
$string['privacy:metadata:offlinequiz_results:timemodified'] = 'Датум измене резултата.';
$string['privacy:metadata:offlinequiz_results:timestart'] = 'Време почетка када је резултат уметнут по први пут.';
$string['privacy:metadata:offlinequiz_results:usageid'] = 'ID ознака употребе шаблона API-ја теста где се овај резултат чува.';
$string['privacy:metadata:offlinequiz_results:userid'] = 'Корисник коме овај резултат припада.';
$string['privacy:metadata:offlinequiz_scanned_p_pages'] = 'Ова табела чува странице учесника и њихове опште информације.';
$string['privacy:metadata:offlinequiz_scanned_p_pages:error'] = 'Грешка (ако постоји) коју је ова страница покренула током обраде.';
$string['privacy:metadata:offlinequiz_scanned_p_pages:filename'] = 'Назив датотеке за скенирану страницу.';
$string['privacy:metadata:offlinequiz_scanned_p_pages:listnumber'] = 'Број листа';
$string['privacy:metadata:offlinequiz_scanned_p_pages:offlinequizid'] = 'Офлајн тест којем припада ова страница са учесницима.';
$string['privacy:metadata:offlinequiz_scanned_p_pages:status'] = 'Статус ове скениране странице.';
$string['privacy:metadata:offlinequiz_scanned_p_pages:time'] = 'Време обраде ове странице.';
$string['privacy:metadata:offlinequiz_scanned_pages'] = 'Табела чува информације о скенираној страници офлајн теста.';
$string['privacy:metadata:offlinequiz_scanned_pages:error'] = 'Детаљна грешка коју ова страница има (ако постоји).';
$string['privacy:metadata:offlinequiz_scanned_pages:filename'] = 'Назив датотеке скениране странице.';
$string['privacy:metadata:offlinequiz_scanned_pages:groupnumber'] = 'Број (groupnumber) групе којој припада овај офлајн тест';
$string['privacy:metadata:offlinequiz_scanned_pages:offlinequizid'] = 'Офлајн тест скениране странице.';
$string['privacy:metadata:offlinequiz_scanned_pages:pagenumber'] = 'Број (pagenumber) ове странице.';
$string['privacy:metadata:offlinequiz_scanned_pages:resultid'] = 'Резултат који се односи на ову страницу.';
$string['privacy:metadata:offlinequiz_scanned_pages:status'] = 'Статус ове странице.';
$string['privacy:metadata:offlinequiz_scanned_pages:time'] = 'Време обраде странице.';
$string['privacy:metadata:offlinequiz_scanned_pages:userkey'] = 'userkey (не userid) прецртаног корисника на страници.';
$string['privacy:metadata:offlinequiz_scanned_pages:warningfilename'] = 'Назив датотеке која се креира када се погрешно попуњен офлајн тест исправи и корисник добије упозорење о томе.';
$string['privacy:metadata:offlinequizpagesize'] = 'Подешава број резултата теста за страницу са резултатима.';
$string['questionanalysis'] = 'Анализа питања';
$string['questionanalysistitle'] = 'Табела са анализом питања';
$string['questionandansweranalysis'] = 'Анализа питања и одговора';
$string['questionbankcontents'] = 'Садржај банке питања';
$string['questionforms'] = 'Обрасци са питањима';
$string['questioninfoanswers'] = 'Број тачних одговора';
$string['questioninfocorrectanswer'] = 'тачан одговор';
$string['questioninfocorrectanswers'] = 'тачни одговори';
$string['questioninfonone'] = 'Ништа';
$string['questioninfoqtype'] = 'Тип питања';
$string['questionname'] = 'Назив питања';
$string['questionpage'] = 'Страница';
$string['questionsheet'] = 'Лист са питањима';
$string['questionsheetlatextemplate'] = '% !TEX encoding = UTF-8 Unicode
\\documentclass[11pt,a4paper]{article}
\\usepackage[utf8x]{inputenc}
\\usepackage[T1]{fontenc}
\\textwidth 16truecm
\\textheight 23truecm
\\setlength{\\oddsidemargin}{0cm}
\\setlength{\\evensidemargin}{0cm}
\\setlength{\\topmargin}{-1cm}
\\usepackage{amsmath} % for \\implies etc
\\usepackage{amsfonts} % for \\mathbb etc
\\usepackage[colorlinks=true,urlcolor=dunkelrot,linkcolor=black]{hyperref} % For using hyperlinks
\\usepackage{ifthen}
\\usepackage{enumitem}
\\usepackage{xcolor}
\\usepackage{ulem}
\\parindent 0pt % no indent on the beginning of a section
\\renewcommand\\UrlFont{\\sf}
\\usepackage{lastpage}
\\usepackage{fancyhdr}
\\pagestyle{fancy}
\\chead{\\sc \\TestTitle, Group \\Group}
\\cfoot{Seite \\thepage/\\pageref{LastPage}}
\\makeatletter %%% disable pagebreaks between answers
\\@beginparpenalty=10000
\\@itempenalty=10000
\\makeatother
%
\\newcommand{\\answerIs}[1]{} %%%Disable showing the right answer
% \\newcommand{\\answerIs}[1]{[#1]} %%%Enable showing the right answer
%%%


% ===========================================================================================================
%%% Course data:
\\newcommand{\\Group}{{$a->groupname}}
\\newcommand{\\Title}{{$a->activityname}}
%%% Or use {{$a->coursename} as course name instead
\\newcommand{\\Date}

\\newcommand{\\TestTitle}{%
\\begin{center}
{\\bf \\Large Question sheet}\\\\[3mm]
\\fbox{
\\begin{tabular}{rl}
\\rule{0pt}{25pt} Name: & $\\underline{\\hspace*{8cm}}$ \\rule{20pt}{0pt}\\\\[5mm]
ID number: & $\\underline{\\hspace*{8cm}}$\\\\[5mm]
\\ifthenelse{\\equal{true}{{$a->printstudycodefield}}}{\\rule{10pt}{0pt} Study code: & $\\underline{\\hspace*{8cm}}$\\\\[5mm]}{}
\\rule[-20pt]{0pt}{20pt} Signature: & $\\underline{\\hspace*{8cm}}$
\\end{tabular}}
\\end{center}
}

\\InputIfFileExists{offline_test_extras.tex}{}{} % Input extra user definitions

\\begin{document}


% ===========================================================================================================
\\TestTitle

% ===========================================================================================================


\\bigskip
% ===========================================================================================================

{$a->pdfintrotext}

% ===========================================================================================================

\\newpage

% ===========================================================================================================


{$a->latexforquestions}


\\end{document}';
$string['questionsin'] = 'Питања у';
$string['questionsingroup'] = 'Група';
$string['questionsinthisofflinequiz'] = 'Питања у овом офлајн тесту';
$string['questiontextisempty'] = '[Празан текст питања]';
$string['queueamountofpages'] = 'Број укључених датотека:';
$string['queuedownload'] = 'Преузми';
$string['queuefilecorrect'] = 'Тачно';
$string['queuefilecorrectionhovertext'] = 'Исправка';
$string['queuefiledownloadhovertext'] = 'Преузимање';
$string['queuefileerror'] = 'Порука о грешци:';
$string['queuefilefilename'] = 'Оригинална датотека:';
$string['queuefilegroupnumber'] = 'Број групе:';
$string['queuefileheader'] = 'Странице у овој датотеци';
$string['queuefileimportedat'] = 'Увезена датотека:';
$string['queuefileimportedby'] = 'Увезао/ла:';
$string['queuefilenotstarted'] = 'Евалуација још није почела';
$string['queuefilepagenumber'] = 'Број странице:';
$string['queuefileprocessing'] = 'Евалуација у току...';
$string['queuefilesactionsheader'] = 'Акције';
$string['queuefilesdetailsheader'] = 'Детаљње информације';
$string['queuefilesfileheader'] = 'Датотека';
$string['queuefilestatus'] = 'Статус датотеке:';
$string['queuefilestatusheader'] = 'Статус';
$string['queuefilestatusmessage_error'] = 'Неопходна је корекција';
$string['queuefilestatusmessage_new'] = 'предато';
$string['queuefilestatusmessage_processed'] = 'OK';
$string['queuefilestatusmessage_processing'] = 'обрада';
$string['queuefilestatusmessage_submitted'] = 'предато';
$string['queuefilestudent'] = 'Име полазника:';
$string['queuefinishedtime'] = 'Евалуација завршена у:';
$string['queueheader'] = 'Отпремљене датотеке';
$string['queuenotfinished'] = 'Евалуација није завршена.';
$string['queuenotstarted'] = 'Евалуација није започета.';
$string['queuestarttime'] = 'Евалуација је започета у:';
$string['queuestatus'] = 'Статус реда за чекање:';
$string['quizdate'] = 'Датум офлајн теста';
$string['quizopenclose'] = 'Датуми отварања и затварања';
$string['quizopenclose_help'] = 'Онлјан преглед може бити ограничен на одређени временски период. Кликните на "Прикажи" како бисте променили подешавања датума и времена.

**Опрез:** Уколико временски период за онлајн преглед није активиран, преглед је неограничен све док је офлајн тест видљив учесницима.

У свим случајевима, приказују се само опције означене под "Преглед укључује".';
$string['qversioncannotupdate'] = 'Верзија питања се не може ажурирати';
$string['qversionnumbersdiffer'] = 'Број одговора се разликује између старе и нове верзије. То доводи до недоследности.';
$string['qversionupdated'] = 'Верзија питања је ажурирана';
$string['qversionupdatedwarning'] = 'Обрасци су већ креирани.<br>Ако резултати постоје, они ће аутоматски бити промењени на основу тренутне верзије измењених питања, овде изабраних. У документима је и даље приказана оригинална верзија питања.';
$string['qversionupdateerror'] = 'Дошло је до грешке приликом ажурирања верзије питања.';
$string['randomfromexistingcategory'] = 'Насумично питања из постојеће категорије';
$string['randomnumber'] = 'Број насумичних питања';
$string['randomquestionusinganewcategory'] = 'Насумично питање користећи нову категорију';
$string['readjust'] = 'Подеси';
$string['reallydeletepdfs'] = 'Да ли заиста желите да избришете датотеке образаца?';
$string['reallydeleteupdatepdf'] = 'Да ли заиста желите да обришете и ажурирате списак учесника?';
$string['recordupdateanddocscreated'] = 'Питања су ажурирана, али пошто су обрасци већ креирани, претходна верзија питања је и даље активна. Да бисте прешли на новију верзију, обришите обрасце и промените верзију ручно.';
$string['recordupdateanddocscreatedversion'] = 'Питања су ажурирана, али су обрасци већ креирани. Проверите да ли измене у питањима нису довеле до промена које утичу на оцењивање.';
$string['recreatepdfs'] = 'Поново креирај PDF документе';
$string['recurse'] = 'Укључи и питања из поткатегорија';
$string['rediswrong'] = 'крстић погрешан или недостаје';
$string['refreshpreview'] = 'Освежи преглед';
$string['regrade'] = 'Поновно оцењивање';
$string['regradedisplayexplanation'] = '<b>Пажња:</b> Поновно оцењивање неће променити обележене одговоре који су ручно измењени!';
$string['regradinginfo'] = 'Ако промените оцену за питање, морате поново да оцените офлајн тест како бисте ажурирали резултате учесника.';
$string['regradingquiz'] = 'Поновно оцењивање';
$string['regradingresult'] = 'Поновно оцењивање резултата за корисника {$a}...';
$string['reloadpreview'] = 'Поново учитај преглед';
$string['reloadquestionlist'] = 'Поново учитај списак питања';
$string['remove'] = 'Уклони';
$string['removeemptypage'] = 'Уклони празну страницу';
$string['removepagebreak'] = 'Уклони прелом странице';
$string['removeselected'] = 'Уклони изабрано';
$string['reordergroupquestions'] = 'Промени редослед питања групе';
$string['reorderquestions'] = 'Промени редослед питања';
$string['reordertool'] = 'Прикажи алат за реорганизовање питања';
$string['repaginate'] = 'Реорганизуј странице са {$a} питања по једној страници';
$string['repaginatecommand'] = 'Реорганизуј странице';
$string['repaginatenow'] = 'Реорганизуј странице сад';
$string['reportends'] = 'Преглед резултата се завршава';
$string['reportoverview'] = 'Преглед';
$string['reportstarts'] = 'Преглед резултата почиње';
$string['resetofflinequizzes'] = 'Ресетуј податке офлајн теста';
$string['resultexists'] = 'Исти резултат за {$a} већ постоји, увоз се игнорише';
$string['resultimport'] = 'Отпреми';
$string['results'] = 'Резултати';
$string['resultsavailable'] = 'Број доступних резултата:';
$string['review'] = 'Преглед';
$string['reviewbefore'] = 'Дозволи преглед док је офлајн тест отворен';
$string['reviewclosed'] = 'Након што се офлајн тест затвори';
$string['reviewcloses'] = 'Преглед се затвара';
$string['reviewimmediately'] = 'Одмах након покушаја';
$string['reviewincludes'] = 'Преглед укључује';
$string['reviewofresult'] = 'Преглед резултата';
$string['reviewopens'] = 'Преглед се отвара';
$string['reviewoptions'] = 'Полазници могу да виде';
$string['reviewoptions_help'] = 'Са овим опцијама можете да контролишете шта полазници могу да виде након што се увезу покушаји. Такође можете да дефинишете временски период током којег ће бити доступан извештај са резултатима.

Поља за потврду имају следећа значења:

**Покушај** - Текст питања и одговори биће приказани полазницима. Они ће видети одговоре које су изабрали, али тачни одговори неће бити назначени.

**Да ли је одговор тачан** - Ова опција може да буде активирана само ако је укључена опција "Покушај". Ако се активира, полазници ће моћи да виде који од одговора које су изабрали је тачан (зелена позадина), а који нетачан (црвена позадина).

**Оцене** - Биће приказана група теста (нпр. Б), резултати (постигнута оцена, укупна оцена за питања, постигнуће у процентима, на пример 40/80 (50)) и оцена (нпр. 50 од максималних100). Поред тога, ако је укључена опција "Покушај", за свако питање биће приказани постигнут, као и максималан резултат.

**Специфичне повратне информације** - Повратне информације зависи од тога какав је одговор полазник дао.

**Опште повратне информације** - Опште повратне информације се приказују полазнику након што су резултати увезени. За разлику од специфичних повратних информација, које зависе од типа питања и одговора који је полазник дао, исти текст опште повратне информације се приказује свим полазницима. Можете користити опште повратне информације како бисте полазницима дали потпун одговор и можда линк ка додатним информацијама, које они могу да искористе ако нису разумели питања.

**Тачни одговори** - Ако је ова опција активирана биће показано који одговори су тачни, а који нетачни. Ова опција доступна је само ако је укључен "Покушај".

**Скенирани образац** - Приказује су скенирани обрасци са одговорима. Обележена поља (одговори) су означена зеленим квадратом.

**Скенирани образац са оценама** - Приказује су скенирани обрасци са одговорима. Обележена поља (одговори) су означена зеленим квадратом. Погрешно обележени одговори, као и они који нису обележени су истакнути. Поред тога, табела приказује максималну и постигнуту оцену за свако питање.';
$string['reviewoptionsheading'] = 'Опције прегледа';
$string['rimport'] = 'Отпреми';
$string['rotate'] = 'Ротирај';
$string['rotatingsheet'] = 'Лист је ротиран...';
$string['save'] = 'Сачувај';
$string['saveandshow'] = 'Сачувај и покажи промене полазницима';
$string['savescannersettings'] = 'Сачувај подешавања скенера';
$string['scannedform'] = 'Скенирани образац';
$string['scannerformfortype'] = 'Образац за тип {$a}';
$string['scanneroptions'] = 'Подешавања скенера';
$string['scannerpdfs'] = 'Празни обрасци';
$string['scannerpdfstext'] = 'Преузети следећа празне обрасце ако желите да користите свој софтвер за скенирање.';
$string['scanningoptionsheading'] = 'Опције за скенирање';
$string['score'] = 'Скор';
$string['search:activity'] = 'Офлајн тест – информације о активности';
$string['select'] = 'Изабери';
$string['selectagroup'] = 'Изабери групу';
$string['selectall'] = 'Изабери све';
$string['selectcategory'] = 'Изабери категорију';
$string['selectdifferentgroup'] = 'Молимо вас, изаберите другу групу!';
$string['selectedattempts'] = 'Изабрани покушаји...';
$string['selectformat'] = 'Изабери формат...';
$string['selectgroup'] = 'Изабери групу';
$string['selectlist'] = 'Изаберите списак или покушајте да подесите лист:';
$string['selectmultipletoolbar'] = 'Изаберите вишеструку траку са алаткама';
$string['selectnone'] = 'Поништи избор свега';
$string['selectpage'] = 'Изаберите број странице или покушајте да подесите лист:';
$string['selectquestion'] = 'Изаберите питање {$a}';
$string['selectquestiontype'] = '-- Изабери тип питања --';
$string['showallparts'] = 'Прикажи све учеснике, њих {$a}';
$string['showcopyright'] = 'Прикажи изјаву о ауторским правима';
$string['showcopyrightdesc'] = 'Ако омогућите ову опцију, изјава о ауторским правима биће приказана на страници полазника за преглед резултата.';
$string['showgrades'] = 'Штампај оцене за питања';
$string['showgrades_help'] = 'Ова опција одређује да ли на листу са питањима треба да се штампају максималне оцене за питања офлајн теста.';
$string['showmissingattemptonly'] = 'Прикажи све означене учеснике без покушаја';
$string['showmissingcheckonly'] = 'Прикажи све означене учеснике са резултатом';
$string['shownumpartsperpage'] = 'Прикажи {$a} учесника по страници';
$string['showquestioninfo'] = 'Штампај информације о одговорима';
$string['showquestioninfo_help'] = 'Помоћу ове опције можете да одредите које додатне информације о питању ће се штампати на листу са питањима.
Можете да изаберете једну од следећих опција:
<ul>
<li> Ништа
<li> Тип питања - зависно од типа питања биће одштампано ”Вишеструки избор са једним тачним одговором”, ”Вишеструки избор са више тачних одговора”, ”Вишеструки избор са више тачних одговора типа све-или-ништа”
<li> Број тачних одговора
</ul>';
$string['showstudentview'] = 'Прикажи преглед из угла полазника';
$string['showtutorial'] = 'Прикажи полазницима упутство за офлајн тест.';
$string['showtutorial_help'] = 'Ова опција одређује да ли полазници могу да виде упутство са основним информацијама о офлајн тестовима.
Упутство пружа информације о томе како се поступа са различитим врстама докумената унутар офлајн тестова. У интерактивном делу полазници уче како да правилно унесу своју ID ознаку.<br />
<b>Имајте у виду:</b><br />
Ако поставите ову опцију на "Да", али притом сакријете офлајн тест линк ка упутству неће бити видљив. У том случају можете да додате линк ка упутству на страници курса.';
$string['showtutorialdescription'] = 'Можете додати линк ка упутству на страници курса користећи следећу URL адресу:';
$string['shuffleanswers'] = 'Измешај одговоре';
$string['shufflequestions'] = 'Измешај питања';
$string['shufflequestionsanswers'] = 'Измешај питања и одговоре';
$string['shufflequestionsselected'] = 'Опција за мешање питања је укључена, тако да поједине акције у вези са страницама нису доступне. Да бисте променили опцију за мешање питања идите на страницу за уређивање офлајн теста - {$a}.';
$string['shufflewithin'] = 'Измешај унутар питања';
$string['shufflewithin_help'] = 'Ако је ова опција омогућена, онда ће одговори унутар свих питања бити насумично измешани сваки пут када притиснете дугме за поновно учитавање на страници за преглед обрасца са питањима. НАПОМЕНА: Ово подешавање се примењује само на питања код којих је опција за мешање активирана.';
$string['signature'] = 'Потпис';
$string['singlechoice'] = 'Вишеструки избор са једним тачним одговором';
$string['standard'] = 'Стандардна';
$string['starttutorial'] = 'Стартуј упутство о офлајн тестирању';
$string['statistics'] = 'Статистика';
$string['statisticsplural'] = 'Статистика';
$string['statisticsviewheader'] = '3. Статистика';
$string['statsoverview'] = 'Преглед статистике';
$string['studycode'] = 'Шифра студијског програма';
$string['subplugintype_offlinequiz'] = 'Извештај о офлајн тесту';
$string['subplugintype_offlinequiz_plural'] = 'Извештаји са офлајн тестова';
$string['tabattendances'] = 'Присутност';
$string['tabattendancesoverview'] = 'Присутност';
$string['tabdownloadparticipantsforms'] = 'Обрасци';
$string['tabdownloadquizforms'] = 'Обрасци';
$string['tabeditgrades'] = 'Оцене';
$string['tabeditgroupquestions'] = 'Питања';
$string['tabeditparticipants'] = 'Учесници';
$string['tabofflinequizcontent'] = 'Припрема';
$string['tabofflinequizcorrect'] = 'Исправка';
$string['tabofflinequizupload'] = 'Отпремање';
$string['tabparticipantlists'] = 'Списак присутних';
$string['tabparticipantscorrect'] = 'Тачно';
$string['tabparticipantsupload'] = 'Отпремање';
$string['tabpreview'] = 'Обрасци';
$string['tabquestionandanswerstats'] = 'Анализа питања и одговора';
$string['tabquestionstats'] = 'Анализа питања';
$string['tabresults'] = 'Резултати';
$string['tabresultsoverview'] = 'Резултати';
$string['tabstatistics'] = 'Статистика';
$string['tabstatsoverview'] = 'Информације о тесту';
$string['temporaryfiledeletiontask'] = 'Обришите привремене датотеке';
$string['theattempt'] = 'Покушај';
$string['timesup'] = 'Време је истекло!';
$string['totalmarksx'] = 'Укупна оцене за сва питања: {$a}';
$string['totalpointsx'] = 'Укупна оцене за сва питања: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Укупан број питања у категорији: {$a}.';
$string['trigger'] = 'доња/горња граница';
$string['tutorial'] = 'Упутство за офлајн тестове';
$string['tutorial:feedback:1:1'] = 'У обрасцу за одговоре нема питања. Образац за одговоре садржи само поља за означавање ваших одговора.';
$string['tutorial:feedback:1:2'] = 'Изглед листа са питањима не мора да буде потпуно исти као на екрану. Он служи само да вам покаже питања и неће бити скениран.';
$string['tutorial:feedback:2:1'] = 'Овај крстић (знак X) је превише блед. Могуће је да неће бити исправно скениран.';
$string['tutorial:feedback:2:2'] = 'Крстић (ознака X) нормалне дебљине биће увек правилно интерпретиран.';
$string['tutorial:feedback:2:3'] = 'Крстић (ознака X) дебљих линија би се могао интерпретирати као исправљен одговор.';
$string['tutorial:feedback:2:4'] = 'Празан квадрат никад неће бити интерпретиран као квадрат са крстићем.';
$string['tutorial:feedback:2:5'] = 'Потпуно попуњен квадрат тумачи се потпуно исто као и празан квадрат.';
$string['tutorial:feedback:3:1'] = 'Скенирају се само крстићи у квадратима. Зато је веома важно да означите праве квадратиће испод свог идентификационог броја.';
$string['tutorial:feedback:3:2'] = 'Скенирају се само крстићи у квадратима. Зато је веома важно да означите праве квадратиће испод свог идентификационог броја.';
$string['tutorial:feedback:3:3'] = 'Скенирају се само крстићи у квадратима. Зато је веома важно да означите праве квадратиће испод свог идентификационог броја.';
$string['tutorial:feedback:3:4'] = 'Скенирају се само крстићи у квадратима. Зато је веома важно да означите праве квадратиће испод свог идентификационог броја.';
$string['tutorial:feedback:4:0'] = 'Погрешили сте. Ваш идентификациони број је {$a->correctusernumber}, а ви сте означили {$a->selectedusernumber}';
$string['tutorial:feedback:4:1'] = 'Успешно сте завршили ово упутство.';
$string['tutorial:feedback:correct'] = 'Тачно!';
$string['tutorial:feedback:wrong'] = 'Погрешно!';
$string['tutorial:generatedusernumberwarning'] = 'Ово је генерисани идентификациони број пошто га ваш налог нема!';
$string['tutorial:header:1'] = '1. Листови са питањима и обрасци за одговоре';
$string['tutorial:header:2'] = '2. Крстићи (ознаке X) и исправке';
$string['tutorial:header:3'] = '3. Образац за одговоре';
$string['tutorial:header:4'] = '4. Обележавање вашег идентификационог броја';
$string['tutorial:header:5'] = '5. На крају...';
$string['tutorial:identification_info'] = 'Ваш идентификациони број је: {$a}';
$string['tutorial:introduction:1'] = 'На испиту ћете добити два листа: један са питањима и један са квадратићима на којима ћете означити своје одговоре. Питања су нумерисана, као и поља на обрасцу за одговоре. Сваки одговор је означен словом. Након испита, образац за одговоре се скенира и компјутерски интерпретира.';
$string['tutorial:introduction:2:1'] = 'Квадрати на листу за одговоре су широки 5 милиметара. Квадрати које припадају истом питању су у истом реду. Број питања је на левој страни, а слово које одговара ставци одговора је на врху колоне.';
$string['tutorial:introduction:2:2'] = 'Користите црну или плаву оловку да означите квадрате. Ако желите да исправите ознаку, попуните поље у потпуности. Ово поље ће се тада бити онтерпретирано као празан квадрат.';
$string['tutorial:introduction:3:1'] = 'Образац за одговоре садржи блок за ваше име (А), блок за ваш идентификациони број (Б) и блок за одговоре (Ц). Прво попуните поља за своје име, потпис и идентификациони број. Имајте на уму да машина неће покушати да интерпретира ваш рукопис након прегледа. Ова поља служе само за потребе документације.';
$string['tutorial:introduction:3:2'] = 'Пажљиво означите поља за свој идентификациони број јер ће рачунару бити потребне ове ознаке да идентификује ваше резултате. Грешке у блоку са вашим идентификационим бројем могу довести до кашњења и погрешног тумачења.';
$string['tutorial:introduction:4'] = 'На крају овог упутства нудимо вам мали тест где можете научити како да правилно попуните ознаке за свој идентификациони број. Испод поља за ваш идентификациони број налази се матрица са квадратима. Свака колона представља једну цифру вашег идентификационог броја. Редови означавају бројеве написане на левој и десној страни. Кликните на квадрате како бисте их означили. Кликните поново да уклоните ознаку. Ако желите да кренете испочетка, молим вас <a href="javascript: document.location.reload()">поново учитајте страницу</a>.';
$string['tutorial:introduction:5'] = 'Имајте на уму да образац са одговорима интерпретира компјутер. Он не може да прочита ништа што напишете поред квадрата. За компјутерски програм све што је ван квадрата је само место које га спречава да правилно протумачи образац. Уколико не означите одговоре исправно изгубићете поене.';
$string['tutorial:option:1:1'] = 'Образац за одговоре';
$string['tutorial:option:1:2'] = 'Лист са питањима';
$string['tutorial:option:3:1'] = 'Систем чита ваше име користећи софтвер за оптичко препознавање знакова.';
$string['tutorial:option:3:2'] = 'Ваш потпис се скенира помоћу софтвера који се користи за отиске прстију у кривичним истрагама.';
$string['tutorial:option:3:3'] = 'Интерпретирају се само крстићи у квадратима под вашим идентификационим бројем.';
$string['tutorial:option:3:4'] = 'Систем чита ваш идентификациони број користећи софтвер за оптичко препознавање знакова.';
$string['tutorial:question:1'] = 'Ова слика показује:';
$string['tutorial:question:2'] = 'Која ознака ће се сигурно тумачити као крстић (знак X)?';
$string['tutorial:question:3'] = 'Како компјутер додељује образац за одговоре правој особи?';
$string['tutorial:question:4'] = 'Идентификациони број';
$string['tutorial:question:5'] = 'Срећно!';
$string['tutorial:questionsheet:1'] = '1)&nbsp;&nbsp; Колико докумената офлајн теста ће вам бити дато током испита?';
$string['tutorial:questionsheet:1:1'] = 'а)&nbsp;&nbsp;0';
$string['tutorial:questionsheet:1:2'] = 'б)&nbsp;&nbsp;1';
$string['tutorial:questionsheet:1:3'] = 'ц)&nbsp;&nbsp;2';
$string['tutorial:questionsheet:1:4'] = 'д)&nbsp;&nbsp;3';
$string['tutorial:questionsheet:1:5'] = 'е)&nbsp;&nbsp;4';
$string['tutorial:questionsheet:1:marks'] = '(Поени: 1)';
$string['tutorial:questionsheet:2'] = '2)&nbsp;&nbsp; Који садржај је доступан на упитнику офлајн теста?';
$string['tutorial:questionsheet:2:1'] = 'а)&nbsp;&nbsp;Питања';
$string['tutorial:questionsheet:2:2'] = 'б)&nbsp;&nbsp;Опције одговора';
$string['tutorial:questionsheet:2:3'] = 'ц)&nbsp;&nbsp;Тачни одговори';
$string['tutorial:questionsheet:2:4'] = 'д)&nbsp;&nbsp;Додатне информације';
$string['tutorial:questionsheet:2:5'] = 'е)&nbsp;&nbsp;Ништа од наведеног';
$string['tutorial:start_text'] = 'Овај туторијал би требало да вам покаже правилан начин попуњавања образаца офлајн теста и обележавања одговора за аутоматску процену. Топло вам препоручујемо да прођете кроз туторијал барем једном, пре него што покренете свој први тест или испит са офлајн тестом.';
$string['tutorial:starttutorial'] = 'Покрени туторијал';
$string['tutorial:title'] = 'Упутство';
$string['tutorial:title:navigation'] = 'Навигација';
$string['type'] = 'Тип';
$string['uncheckparts'] = 'Обележи изабране кориснике као одсутне';
$string['unknownmimetype'] = 'Непознати и неподржани mimetype датотеке {$a->mimetpye}';
$string['updatedsumgrades'] = 'Збир свих оцена за групу {$a->letter} је прерачунат на {$a->grade}.';
$string['upgradingfilenames'] = 'Ажурирање назива датотека докумената: офлајн тест {$a->done}/{$a->outof} <br/>(Офлајн тест ID {$a->info})';
$string['upgradingilogs'] = 'Ресетуј податке Офлајн теста';
$string['upgradingofflinequizattempts'] = 'Ажурирање покушаја решавања теста: офлајн тест $a->done}/{$a->outof} <br/>(Офлајн тест ID {$a->info})';
$string['upload'] = 'Отпреми';
$string['uploadfurtherfiles'] = 'Отпреми додатне датотеке';
$string['uploadpart'] = 'Otpremi';
$string['uppertrigger'] = 'Друга горња граница';
$string['uppertriggerzero'] = 'Друга горња граница је нула';
$string['upperwarning'] = 'Прва горња граница';
$string['upperwarningzero'] = 'Прва горња граница је нула';
$string['useradded'] = 'Корисник {$a} је додат/а';
$string['userdoesnotexist'] = 'Корисник {$a} не постоји у систему';
$string['useridentification'] = 'Идентификација корисника';
$string['useridviolation'] = 'Пронађено је више корисника са истом ID ознаком';
$string['userimported'] = 'Корисник {$a} је увезен/а и оцењен/а';
$string['usernotincourse'] = 'Корисник {$a} није на курсу.';
$string['usernotinlist'] = 'Корисник није регистрован на списку!';
$string['usernotregistered'] = 'Корисник {$a} није регистрован на курсу';
$string['userpageimported'] = 'Једна страница увезена за корисника {$a}';
$string['usetabs'] = 'Користите навигацију путем картица';
$string['usetabsdesc'] = 'Ако је ова опција омогућена, трећи ниво навигације у оквиру офлајн теста биће приказан путем картица. Ако је ова опција онемогућена, уместо картица за навигацију ће се користити падајући мени.';
$string['valuezero'] = 'Вредност не би требало да буде нула';
$string['viewresults'] = 'Прикажи резултате';
$string['white'] = 'Бела';
$string['wirismathenabled'] = 'Омогући WIRIS Math једначине';
$string['wirismathenabled_help'] = 'Ако је ова опција омогућена, WIRIS Math једначине могу се користити у тексту питања, као и у одговорима.';
$string['withselected'] = 'Са изабраним....';
$string['zerogradewarning'] = 'Упозорење: Ваша оцена за офлајн тест је 0.0!';
$string['zipfile'] = 'ZIP датотека';
$string['zipok'] = 'ZIP датотека увезена';
