<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'ai', language 'sr_cr', version '5.0'.
 *
 * @package     ai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptai'] = 'Прихвати и настави';
$string['action'] = 'Акција';
$string['action_explain_text'] = 'Tекст објашњења';
$string['action_explain_text_desc'] = 'Објашњава текстуални садржај на страници курса.';
$string['action_explain_text_instruction'] = 'Добићете текст који је корисник унео. Ваш задатак је да објасните дати текст. Следите ове смернице:
1. Елаборирајте. Проширите кључне идеје и концепте, водеђи рачуна о томе да ваше објашњење значајно продубљује добијени текст. Потрудите да избегнете дословно понављање текста.
 2. Поједноставите. Раставите сложене термине или идеје на једноставније компоненте, чинећи их лаким за разумевање за широку публику, укључујући ученике.
 3. Наведите контекст. Објасните зашто се нешто дешава, како функционише или која је његова сврха. Укључите релевантне примере или аналогије како бисте побољшали разумевање тамо где је то потребно.
 4. Логично организујте. Структурирајте своје објашњење тако да текст тече природно, почевши од основних идеја пре него што пређете на финије детаље.

Важна упутства:
 1. Сажетак који саставите нека буде искључиво у формату обичног текста.
 2. Немојте укључивати било какво форматирање текста, поздраве или фразе.
 3. Фокусирајте се на јасноћу, сажетост и приступачност.

Проверите да ли је објашњење лако за читање и да ли адекватно одражава главне тачке оригиналног текста.';
$string['action_generate_image'] = 'Генерисање слике';
$string['action_generate_image_desc'] = 'Генерише слику на основу текстуалног упита.';
$string['action_generate_text'] = 'Генерисање текста';
$string['action_generate_text_desc'] = 'Генерише текст на основу текстуалног упита.';
$string['action_generate_text_instruction'] = 'Добићете текст тј. захтев који је унео корисник. Ваш задатак је да генеришете текст на основу тог захтева. Пратите ова важна упутства:
1. У одговору пошаљите резиме само у формату обичног текста.
2. Немојте укључивати било какво форматирање текста, поздраве или флоскуле.';
$string['action_summarise_text'] = 'Резимирај текст';
$string['action_summarise_text_desc'] = 'Сажима текстуални садржај на страници курса';
$string['action_summarise_text_instruction'] = 'Добићете текст тј. захтев који је унео корисник. Ваш задатак је да резимирате дати текст. Следите ове смернице:
1. Сажимајте: скратите дугачке пасусе на кључне тачке.
2. Поједноставите: учините сложене информације лакшим за разумевање, посебно за ученике.

Важна упутства:
1. У одговору пошаљите резиме у формату обичног текста.
2. Немојте укључивати било какво форматирање, поздраве или флоскуле.
3. Фокусирајте се на јасноћу, сажетост и приступачност.

Уверите се да је резиме лак за читање и да ефикасно преноси главне поенте оригиналног текста.';
$string['action_translate_text'] = 'Преведи текст';
$string['action_translate_text_desc'] = 'Преводи унети текст са једног језика на други.';
$string['actionsettingprovider'] = 'Подешавање акције {$a}';
$string['actionsettingprovider_desc'] = 'Ова подешавања контролишу како провајдер {$a->providername} изводи акцију {$a->actionname}.';
$string['actionsettings'] = 'Подешавања акције';
$string['actionsettings_desc'] = 'Ова подешавања контролишу акције AI сервиса за ову инстанцу провајдера.';
$string['ai'] = 'AI (вештачка интелигенција)';
$string['aiactionregister'] = 'Регистар AI акција';
$string['aiplacements'] = 'Позиције AI сервиса';
$string['aipolicyacceptance'] = 'Прихватање правила коришћења AI';
$string['aipolicyregister'] = 'Регистар правила коришћења AI';
$string['aiproviders'] = 'Провајдери AI сервиса';
$string['aireports'] = 'AI извештаји';
$string['aiusage'] = 'Коришћење AI';
$string['aiusagepolicy'] = 'Правила коришћења AI';
$string['availableplacements'] = 'Изаберите где су доступне акције AI сервиса';
$string['availableplacements_desc'] = 'Позиција AI сервиса одређује како и где се акције AI сервиса могу користити на вашем сајту. У подешавањима можете да изаберете које су акције доступне на свакој појединачној позицији.';
$string['availableproviders'] = 'Управљање провајдерима AI сервиса повезаним са вашим LMS-ом';
$string['availableproviders_desc'] = 'AI провајдери додају AI додају функционалност вашем сајту кроз \'акције\' као што су резимирање текста или генерисање слике.<br/>
Можете управљати акцијама сваког датог провајдера у њиховим подешавањима.';
$string['btninstancecreate'] = 'Креирајте инстанцу';
$string['btninstanceupdate'] = 'Ажурирајте инстанцу';
$string['completiontokens'] = 'Токени упита за допуну';
$string['completiontokens_help'] = 'Токени упита за допуну представљају текстуалне јединице које генерише AI модел као одговор на ваш упит. Дужи одговори користе више токена, што ће вероватно коштати више.';
$string['configureprovider'] = 'Конфигуришите инстанцу провајдера';
$string['contentwatermark'] = 'Генерисано од стране AI (вештачке интелигенције)';
$string['createnewprovider'] = 'Креирајте нову инстанцу провајдера';
$string['dateaccepted'] = 'Датум прихватања';
$string['declineaipolicy'] = 'Одбиј';
$string['enableglobalratelimit'] = 'Подесите ограничење броја захтева на нивоу целог сајта';
$string['enableglobalratelimit_help'] = 'Ограничите број захтева које AI провајдер може да прими на нивоу целог сајту сваког сата.';
$string['enableuserratelimit'] = 'Подесите ограничење броја захтева на нивоу корисника';
$string['enableuserratelimit_help'] = 'Ограничите број захтева који сваки корисник може да упути AI провајдеру сваког сата.';
$string['error:actionnotfound'] = 'Акција \'{$a}\' није подржана';
$string['error:providernotfound'] = 'Инстанца AI провајдера није пронађена';
$string['globalratelimit'] = 'Максималан број захтева на нивоу целог сајта';
$string['globalratelimit_help'] = 'Број дозвољених захтева на нивоу сајта по сату.';
$string['manageaiplacements'] = 'Управљање позицијама AI сервиса';
$string['manageaiproviders'] = 'Управљање провајдерима AI сервиса';
$string['noproviders'] = 'Ова акција је недоступна. Ниједан <a href="{$a}">AI провајдер</a> није конфигурисан за ову акцију';
$string['placement'] = 'Позиција';
$string['placementactionsettings'] = 'Акције';
$string['placementactionsettings_desc'] = 'Акције AI сервиса доступне за ову позицију.';
$string['placementsettings'] = 'Подешавања специфична за позицију AI сервиса';
$string['placementsettings_desc'] = 'Они контролишу начин на који се позција повезује са AI сервисом, као и повезане операције';
$string['privacy:metadata:ai_action_explain_text'] = 'Табела у којој се чува захтеви корисника за текст објашњења';
$string['privacy:metadata:ai_action_explain_text:completiontoken'] = 'Токени упита за допуну који се користе за објашњење текста.';
$string['privacy:metadata:ai_action_explain_text:fingerprint'] = 'Јединствени хеш који представља стање/верзију модела и садржаја.';
$string['privacy:metadata:ai_action_explain_text:generatedcontent'] = 'Актуелни текст који генерише AI модел на основу унетог упита.';
$string['privacy:metadata:ai_action_explain_text:prompt'] = 'Tекст објашњења';
$string['privacy:metadata:ai_action_explain_text:prompttokens'] = 'Токени упита који се користе за објашњење текста.';
$string['privacy:metadata:ai_action_explain_text:responseid'] = 'ID ознака одговора.';
$string['privacy:metadata:ai_action_generate_image'] = 'Табела у којој се чувају захтеви корисника за генерисање слика.';
$string['privacy:metadata:ai_action_generate_image:aspectratio'] = 'Однос ширине и висине генерисаних слика.';
$string['privacy:metadata:ai_action_generate_image:numberimages'] = 'Број генерисаних слика.';
$string['privacy:metadata:ai_action_generate_image:prompt'] = 'Упит за захтев за генерисање слике.';
$string['privacy:metadata:ai_action_generate_image:quality'] = 'Квалитет генерисаних слика.';
$string['privacy:metadata:ai_action_generate_image:revisedprompt'] = 'Ревидирани упит генерисаних слика.';
$string['privacy:metadata:ai_action_generate_image:sourceurl'] = 'Изворна URL адреса генерисаних слика.';
$string['privacy:metadata:ai_action_generate_image:style'] = 'Стил генерисаних слика.';
$string['privacy:metadata:ai_action_generate_text'] = 'Табела у којој се чувају захтеви за генерисање текста од стране корисника.';
$string['privacy:metadata:ai_action_generate_text:completiontoken'] = 'Токени упита за допуну који се користе за генерисање текста.';
$string['privacy:metadata:ai_action_generate_text:fingerprint'] = 'Јединствени хеш који представља статус/верзију модела и садржаја.';
$string['privacy:metadata:ai_action_generate_text:generatedcontent'] = 'Актуелни текст који генерише AI модел на основу унетог упита.';
$string['privacy:metadata:ai_action_generate_text:prompt'] = 'Упит за захтев за генерисање текста.';
$string['privacy:metadata:ai_action_generate_text:prompttokens'] = 'Токени упита који се користе за генерисање teksta.';
$string['privacy:metadata:ai_action_generate_text:responseid'] = 'ID ознака одговора.';
$string['privacy:metadata:ai_action_register'] = 'Табела у којој се чувају захтеви за акцију које су упутили корисници.';
$string['privacy:metadata:ai_action_register:actionid'] = 'ID ознака захтева за акцију';
$string['privacy:metadata:ai_action_register:actionname'] = 'Назив акције захтева.';
$string['privacy:metadata:ai_action_register:model'] = 'Модел који се користи за генерисање одговора.';
$string['privacy:metadata:ai_action_register:provider'] = 'Име провајдера који је обрадио захтев.';
$string['privacy:metadata:ai_action_register:success'] = 'Статус захтева за акцију.';
$string['privacy:metadata:ai_action_register:timecompleted'] = 'Време завршетка захтева.';
$string['privacy:metadata:ai_action_register:timecreated'] = 'Време креирања захтева.';
$string['privacy:metadata:ai_action_register:userid'] = 'ID ознака корисника који је поднео захтев.';
$string['privacy:metadata:ai_action_summarise_text'] = 'Табела у којој се чувају сумирани текстуални захтеви корисника.';
$string['privacy:metadata:ai_action_summarise_text:completiontoken'] = 'Токени упита за допуну који се користе за резимирање текста.';
$string['privacy:metadata:ai_action_summarise_text:fingerprint'] = 'Јединствени хеш који представља статус/верзију модела и садржаја.';
$string['privacy:metadata:ai_action_summarise_text:generatedcontent'] = 'Актуелни текст који генерише AI модел на основу унетог упита.';
$string['privacy:metadata:ai_action_summarise_text:prompt'] = 'Упит за резимирани текст.';
$string['privacy:metadata:ai_action_summarise_text:prompttokens'] = 'Токени упита који се користе за резимирање текста.';
$string['privacy:metadata:ai_action_summarise_text:responseid'] = 'ID ознака одговора.';
$string['privacy:metadata:ai_policy_register'] = 'Табела у којој се чува статус прихватања правила коришћења AI за сваког корисника.';
$string['privacy:metadata:ai_policy_register:contextid'] = 'ID ознака контекста чији су подаци сачувани.';
$string['privacy:metadata:ai_policy_register:timeaccepted'] = 'Време када је корисник прихватио правила коришћења вештачке интелигенције.';
$string['privacy:metadata:ai_policy_register:userid'] = 'ID ознака корисника чији су подаци сачувани.';
$string['prompttokens'] = 'Токени упита';
$string['prompttokens_help'] = 'Токени упита представљају текстуалне једнице које чине унос који шаљете AI моделу. Дужи упити користе више токена, што ће вероватно коштати више.';
$string['provider'] = 'Провајдер';
$string['provideractionsettings'] = 'Акције';
$string['provideractionsettings_desc'] = 'Изаберите и конфигуришите акције које провајдер AI сервиса {$a} може да обавља на вашем сајту.';
$string['providerinstanceactionupdated'] = 'Подешавања акције {$a} су ажурирана';
$string['providerinstancecreated'] = 'Инстанца AI провајдера {$a} је креирана.';
$string['providerinstancedelete'] = 'Обришите инстанцу AI провајдера';
$string['providerinstancedeleteconfirm'] = 'Намеравате да обришете инстанцу AI провајдера {$a->name} ({$a->provider}). Јесте ли сигурни?';
$string['providerinstancedeleted'] = 'Инстанца AI провајдера {$a} је обрисана';
$string['providerinstancedeletefailed'] = 'Није могуће обрисати инстанцу AI провајдера {$a}. Провајдер је или у употреби или постоји проблем са базом података. Проверите да ли је провајдер активан или се обратите администратору базе података за помоћ.';
$string['providerinstancedisablefailed'] = 'Није могуће онемогићити инстанцу AI провајдера {$a}. Провајдер је или у употреби или постоји проблем са базом података. Проверите да ли је провајдер активан или се обратите администратору базе података за помоћ.';
$string['providerinstanceupdated'] = 'Инстанца AI провајдера {$a} је ажурирана';
$string['providermoveddown'] = '{$a} премештен надоле.';
$string['providermovedup'] = '{$a} премештен нагоре.';
$string['providername'] = 'Назив за инстанцу';
$string['providers'] = 'Провајдери';
$string['providersettings'] = 'Подешавања';
$string['providertype'] = 'Изаберите додатак AI провајдера';
$string['timegenerated'] = 'Време генерисања';
$string['unknownvalue'] = '—';
$string['userpolicy'] = '<h4><strong>Добродошли у нову AI функционалност!</strong></h4>
<p>Ова функционалност вештачке интелигенције (Artificial Intelligence - AI) заснована је искључиво на екстерним великим језичким моделима (Large Language Models - LLM) са намером да унапреди ваше искуство у учењу и подучавању. Пре него што почнете да користите овај сервис вештачке интелигенције, прочитајте ова правила коришћења.</p>
<h4><strong>Тачност садржаја генерисаног вештачком интелигенцијом</strong></h4>
<p>AI може да пружи корисне предлоге и информације, али њена тачност може да варира. Увек треба да проверите добијене информације како бисте били сигурни да су оне тачне, потпуне и прикладне вашим специфичним потребама.</p>
<h4><strong>Како се ваши подаци обрађују</strong></h4>
<p>Ова AI функционалност користи екстерне велике језичке моделе (Large Language Models - LLM). Уколико користите ову функционалност, сви уноси или лични подаци које пошаљете биће обрађени у складу са политиком приватности тих екстерних платформи. Препоручујемо вам да прегледате правила о приватност LLM платформи како бисте разумели како ће се поступати са вашим личним подацима. Поред тога, запис о вашим интеракцијама са AI сервисом може се чувати на овом веб сајту.</p>
<p>Ако имате питања о томе како се ваши подаци обрађују, обратите се својим предавачима или образовној институцији.</p>
<p>Ако наставите, потврђујете да разумете и  да се слажете са овим правилима приватности.</p>';
$string['userratelimit'] = 'Максималан број захтева по кориснику';
$string['userratelimit_help'] = 'Број дозвољених захтева по сату, по једном кориснику.';
