<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_brick', language 'nl', version '5.0'.
 *
 * @package     theme_brick
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
<div class="theme_screenshot">
<h2 style="padding-top:0.5em;">Brick</h2>
<img src="brick/pix/screenshot.png" />
<h3>Thema discussie forum</h3>
<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>
<h3>Thema documentatie</h3>
<p><a href="http://docs.moodle.org/en/Themes">http://docs.moodle.org/en/Themes</a></p>
<h3>Thema credits</h3>
<p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>
<h3>Meld een bug</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
</div>
<div class="theme_description">
<h2>Beschrijving</h2>
<p>Brick is een thema in twee kolommen, met wisselende breedte, gecodeerd voor Moodle 2.0. Je kunt het kleurenschema van het thema veranderen via de pagina met instellingen van het thema.</p>
<h2>Aanpassingen</h2>
<p>Dit thema bouwt voort op Base en Canvas, twee parent thema\'s die behoren tot de Moodle core. Indien je bepaalde aspecten van dit thema wil aanpassen die verder gaan dan de aangeboden instellingen, dan raden we aan om een nieuw thema aan te maken die dit en het Base thema als parent thema\'s gebruikt. Op die manier zullen alle updates van de parent thema\'s in de core ook hun weg vinden naar jouw nieuwe thema.</p>
<h2>Credits</h2>
<p>Dit thema werd gecodeerd en wordt onderhouden door John Stabinger van NewSchool Learning. Je kunt hem contacteren via e-mail op contact@newschoollearning.com. </p>
<h2>Licentie</h2>
<p>De licentie van dit thema, en alle andere thema\'s die zijn opgenomen in de Moodle core, vallen onder de <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.</p>
 </div>
</div>';
$string['configtitle'] = 'Brick instellingen';
$string['headingcolor'] = 'Kleur hoofding';
$string['headingcolordesc'] = 'Dit is de hoofdingkleur voor grote hoofdingen (site nieuws, mijn cursussen) en andere titels.';
$string['linkcolor'] = 'link';
$string['linkcolordesc'] = 'Stelt de kleur van links in voor dit thema. Gebruik html hex code.';
$string['linkhover'] = 'link hover';
$string['linkhoverdesc'] = 'Stelt de kleur van links (hover) in voor dit thema. Gebruik html hex code.';
$string['logo'] = 'logo';
$string['logodesc'] = 'Geef de URL naar een afbeelding om als logo voor deze site te gebruiken. Moet zijn zoals http://www.jouwsite;be/pad/naar/logo.png.
Het standaardlogo is 265px breed en 60px hoog. Een transparante png werkt het best.';
$string['maincolor'] = 'hoofdkleur';
$string['maincolordesc'] = 'Stelt de kleur van de titel, de dock-balk en andere zones in. Ziet er het best uit in een donkere of verzadigde kleur';
$string['maincolorlink'] = 'hoofdkleurlink';
$string['maincolorlinkdesc'] = 'Linkkleur voor menubalk en blok titels';
$string['pluginname'] = 'Brick';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
