<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'sv', version '5.0'.
 *
 * @package     scheduler
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Åtgärd';
$string['actions'] = 'Åtgärder';
$string['addappointment'] = 'Lägg till ytterligare en student';
$string['addcommands'] = 'Lägg till tillfällen';
$string['addondays'] = 'Dagar';
$string['addsession'] = 'Lägg till återkommande tillfällen';
$string['addsingleslot'] = 'Lägg till ett tillfälle';
$string['addslot'] = 'Du kan lägga till ytterligare tillfällen när som helst.';
$string['addstudenttogroup'] = 'Lägg till den här studenten till grupptillfället';
$string['allappointments'] = 'Alla tillfällen';
$string['allononepage'] = 'Alla tillfällen på en sida';
$string['allowgroup'] = 'Exklusivt tillfälle - klicka för att ändra';
$string['alreadyappointed'] = 'Kan inte göra bokningen. Tillfället är redan fullbokat.';
$string['appointagroup_help'] = 'Välj om du ska boka bara för dig själv eller för hela din grupp.';
$string['appointfor'] = 'Gör bokning åt';
$string['appointforgroup'] = 'Gör bokningar åt: {$a}';
$string['appointingstudent'] = 'Bokning för tillfället';
$string['appointingstudentinnew'] = 'Bokning för nytt tillfälle';
$string['appointment'] = 'Tillfälle';
$string['appointmentmode'] = 'Välj tillfällets inställning';
$string['appointmentmode_help'] = '<p>Här kan du välja olika sätt som tillfällen kan bokas</p> <p><ul> <li><strong>"<emph>X</emph> antal mötestider i denna tidsbokning":</strong> Studenten kan bara boka ett fast antal tillfällen i denna aktivitet. Även om läraren markerar dem som "Avklarade" så kan studenten inte boka ytterligare tillfällen. Det enda sättet som en student kan boka fler tillfällen är att ta bort de gamla "Avklarade".</li> <li><strong>"<emph>X</emph> antal tillfällen åt gången": </li> Studenten kan boka ett visst antal tillfällen. När tillfället väl är över och läraren har markerat detta som "Avklarat" kan studenten boka ytterligare tillfällen. Däremot är studenten hela tiden begränsad till <emph>X</emph> antal "öppna" (ej avklarade) tillfällen. </li> </ul> </p>';
$string['appointmentno'] = 'Tillfälle {$a}';
$string['appointmentnote'] = 'Mötesanteckningar, synliga för studenten';
$string['appointments'] = 'Möten';
$string['appointmentsgrouped'] = 'Möten grupperade per tillfälle';
$string['appointmentsummary'] = 'Möte den {$a->startdate} från kl. {$a->starttime} till {$a->endtime} med {$a->teacher}';
$string['appointsolo'] = 'bara jag';
$string['appointsomeone'] = 'Lägg till ny bokning';
$string['areaappointmentnote'] = 'Filer i mötesanteckningar';
$string['areaslotnote'] = 'Filer i bokningstillfällen';
$string['areateachernote'] = 'Filer i konfidentiella anteckningar';
$string['attendable'] = 'Studenter';
$string['attendablelbl'] = 'Totalt antal som kunde boka tillfälle';
$string['attended'] = 'Närvarande';
$string['attendedlbl'] = 'Antal som närvarade';
$string['attendedslots'] = 'Tillfällen som närvarats';
$string['availableslots'] = 'Antal tillfällen';
$string['availableslotsall'] = 'Totalt';
$string['availableslotsnotowned'] = 'Andras';
$string['availableslotsowned'] = 'Mina';
$string['bookaslot'] = 'Boka en mötestid';
$string['bookingdetails'] = 'Bokningsdetaljer';
$string['bookingformoptions'] = 'Bokningsformulär och info från studenter';
$string['bookinginstructions'] = 'Instruktioner för bokning';
$string['bookinginstructions_help'] = 'Denna text kommer att visas för studenter innan de gör en bokning. Det kan till exempel instruera hur man fyller i det valfria meddelandefältet eller vilka filer som ska laddas upp.';
$string['bookslot'] = 'Boka tillfälle';
$string['bookwithteacher'] = 'Lärare';
$string['bookwithteacher_help'] = 'Välj en lärare för tillfället.';
$string['break'] = 'Paus mellan tillfällen';
$string['breaknotnegative'] = 'Pausens längd kan inte vara negativ';
$string['canbook1appointment'] = 'Du kan boka ytterligare ett tillfälle här.';
$string['canbooknappointments'] = 'Du kan boka ytterligare {$a} tillfällen här.';
$string['canbooknofurtherappointments'] = 'Du kan inte boka några fler tillfällen här.';
$string['canbooksingleappointment'] = 'Du kan boka ett tillfälle här.';
$string['canbookunlimitedappointments'] = 'Du kan boka valfritt antal tillfällen här.';
$string['cancelbooking'] = 'Avbryt bokningen';
$string['chooseexisting'] = 'Välj befintlig';
$string['choosingslotstart'] = 'Att välja starttid';
$string['choosingslotstart_help'] = 'Ändra (eller välj) tillfällets starttid. Om detta tillfälle kolliderar med andra tillfällen, kommer du att bli tillfrågad om denna tiden ska ersätta eventuella krockar. Observera att parametrarna för den nya tiden kommer att köra över tidigare inställningar.';
$string['comments'] = 'Kommentarer';
$string['complete'] = 'Bokad';
$string['confirmbooking'] = 'Bekräfta bokningen';
$string['confirmdelete-all'] = 'Detta kommer att ta bort <b>alla</b> mötestider i denna schemaläggare. Borttagningen kan inte ångras. Är du säker på att du vill fortsätta?';
$string['confirmdelete-mine'] = 'Detta kommer att ta bort alla dina  mötestider i denna schemaläggare. Borttagningen kan inte ångras. Är du säker på att du vill fortsätta?';
$string['confirmdelete-myunused'] = 'Detta kommer att ta bort alla oanvända mötestider i denna schemaläggare. Borttagningen kan inte ångras. Är du säker på att du vill fortsätta?';
$string['confirmdelete-one'] = 'Ta bort mötestid?';
$string['confirmdelete-selected'] = 'Detta kommer att ta bort de markerade mötestiderna. Borttagningen kan inte ångras. Är du säker på att du vill fortsätta?';
$string['confirmdelete-unused'] = 'Detta kommer att ta bort alla oanvända mötestider i denna schemaläggare. Borttagningen kan inte ångras. Är du säker på att du vill fortsätta?';
$string['conflictingslots'] = 'Mötestillfället {$a} kan inte skapas på grund av motstidiga tillfällen:';
$string['conflictlocal'] = '{$a->datetime} ({$a->duration} minuter) i denna tidsbokning';
$string['conflictremote'] = '{$a->datetime} ({$a->duration} minuter) i kursen {$a->courseshortname}, tidsbokning {$a->schedulername}';
$string['contentformat'] = 'Format';
$string['contentformat_help'] = '<p>Det finns tre grundläggande val för exportformatet som skiljer sig åt baserat på hur tillfällen med flera bokningar hanteras. <dl> <dt>En rad per mötestid</dt>: <dd> Den resulterande filen kommer innehålla en rad för varje enskilt tillfälle. Om ett tillfälle innehåller flera bokningar så kommer, istället för studentens namn o.s.v., en markör "(multipla)" visas. </dd> <dt>En rad per bokning</dt>: <dd> Den resulterande filen kommer att innehålla en rad för varje bokning. Om ett tillfälle är bokat av flera personer så kommer tillfället att visas flera gånger i listan (med dess data upprepad). </dd> <dt>Bokningar grupperade per tillfälle</dt>: <dd> Alla bokningar av ett tillfälle grupperas tillsammans, inledd med en rubrikrad som indikerar tillfället i fråga. Detta kan fungera dåligt om du väljer exportformatet CSV-fil eftersom antalet kolumner inte blir konstant. </dd> </dl> Du kan undersöka effekten av ditt val genom att använda dig av knappen "Förhandsgranska".</p>';
$string['copytomyself'] = 'Skicka en kopia till mig själv';
$string['course'] = 'Kurs';
$string['createexport'] = 'Skapa exportfil';
$string['csvfieldseparator'] = 'Fältseparator för csv';
$string['csvformat'] = 'CSV';
$string['cumulatedduration'] = 'Summerad längd på tillfällen';
$string['datatoinclude'] = 'Data att inkludera';
$string['datatoinclude_help'] = 'Välj de fält som ska inkluderas i exporten. Vart och ett av dessa kommer att visas som en kolumn i den resulterande filen.';
$string['date'] = 'Datum';
$string['datelist'] = 'Översikt';
$string['defaultslotduration'] = 'Standardlängd på tillfällen';
$string['defaultslotduration_help'] = 'Standardlängden (i minuter) för tillfällen du skapar';
$string['deleteallslots'] = 'Ta bort alla tillfällen';
$string['deleteallunusedslots'] = 'Ta bort oanvända tillfällen';
$string['deletecommands'] = 'Ta bort tillfällen';
$string['deletedconflictingslots'] = 'För tillfället {$a}, motstridiga tillfällen har raderats:';
$string['deletemyslots'] = 'Ta bort alla mina tillfällen';
$string['deleteonsave'] = 'Radera detta tillfälle (när fomuläret sparas).';
$string['deleteselection'] = 'Ta bort valda tillfällen';
$string['deletetheseslots'] = 'Ta bort dessa tillfällen';
$string['deleteunusedslots'] = 'Ta bort mina oanvända tillfällen';
$string['department'] = 'Varifrån?';
$string['disengage'] = 'Kasta mina bokningar';
$string['displayfrom'] = 'Visa bokningar för studenter från';
$string['distributetoslot'] = 'Distribuera till hela gruppen';
$string['divide'] = 'Dela upp i tillfällen?';
$string['duration'] = 'Varaktighet';
$string['durationrange'] = 'Tillfällets längd måste vara mellan {$a->min} och {$a->max} minuter.';
$string['editbooking'] = 'Redigera bokning';
$string['email_applied_html'] = '<p>Ett tillfälle har bokats den {$a->date} vid kl. {$a->time},<br/> av studenten <a href="{$a->attendee_url}">{$a->attendee}</a> i kursen: <p>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></p> <p>via tidsbokningen "<em>{$a->module}</em>" på sidan: <a href="{$a->site_url}">{$a->site}</a>.</p>';
$string['email_applied_plain'] = 'En bokning har gjorts för den {$a->date} vid {$a->time}, av studenten {$a->attendee}, i kursen: {$a->course_short}: {$a->course} bokningen gjordes genom tidsbokningen "{$a->module}" på sidan: {$a->site}.';
$string['email_applied_subject'] = '{$a->course_short}: Ny bokning';
$string['email_cancelled_html'] = '<p>Bokningen den <strong>{$a->date}</strong> vid kl. <strong>{$a->time}</strong>,<br/> med studenten <strong><a href="{$a->attendee_url}">{$a->attendee}</a></strong> i kursen:</p> <p><strong>{$a->course_short} : <a href="{$a->course_url}">{$a->course}</a></strong></p> <p>genom tidsbokningen "<em>{$a->module}</em>" på sidan : <strong><a href="{$a->site_url}">{$a->site}</a></strong></p> <p>,<strong><span class="error">har ställts in eller flyttats</span></strong>.</p>';
$string['email_cancelled_plain'] = 'Din bokning den {$a->date} vid {$a->time}, med studenten {$a->attendee} i kursen: {$a->course_short} : {$a->course} i tidsbokning "{$a->module}" på sidan: {$a->site} har blivit annullerad eller flyttad.';
$string['email_cancelled_subject'] = '{$a->course_short}: Bokningen annullerad eller flyttad av student';
$string['email_invite_html'] = '<p>Var god välj en mötestid:</p> <p>{$a->scheduler_url}</p>';
$string['email_invite_subject'] = 'Inbjudan: {$a->module}';
$string['email_invitereminder_html'] = '<p>Det här är en påminnelse att du ännu inte har gjort din bokning. Var god och gör detta så snart som möjligt här:</p><p>{$a->scheduler_url}</p>';
$string['email_invitereminder_subject'] = 'Påminnelse: {$a->module}';
$string['email_reminder_html'] = '<p>Du har ett möte bokat den <strong>{$a->date}</strong>
från klockan <strong>{$a->time}</strong> till <strong>{$a->endtime}</strong><br/>
med <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong>.</p>

<p>Plats: <strong>{$a->location}</strong></p>';
$string['email_reminder_plain'] = 'Du har ett bokat tillfälle den {$a->date} från {$a->time} till {$a->endtime} med {$a->attendant}. Plats: {$a->location}';
$string['email_reminder_subject'] = '{$a->course_short}: Bokningspåminnelse';
$string['email_teachercancelled_html'] = '<p>Bokningen den <strong>{$a->date}</strong> vid kl. <strong>{$a->time} </strong>,<br/> med {$a->staffrole} <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong> i kursen:</p> <p><strong>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></strong></p> <p>i tidsbokning "<em>{$a->module}</em>" på: <strong><a href="{$a->site_url}">{$a->site}</a></strong></p> <p><strong><span class="error">har blivit inställt</span></strong>. Försöka boka ett nytt tillfälle.</p>';
$string['email_teachercancelled_plain'] = 'Din bokning den {$a->date} vid {$a->time}, med {$a->staffrole} {$a->attendant} i kursen: {$a->course_short}: {$a->course} i tidsbokaren "{$a->module}" på sidan: {$a->site} har blivit annullerad. Var vänlig sök ett nytt tillfälle.';
$string['email_teachercancelled_subject'] = '{$a->course_short}: bokningen annullerad av läraren';
$string['emailreminder'] = 'Skicka en påminnelse';
$string['emailreminderondate'] = 'Skicka påminnelse den';
$string['end'] = 'Slut';
$string['enddate'] = 'Repetera tillfällen till och med';
$string['event_appointmentlistviewed'] = 'Tidsbokning, bokningslista visad';
$string['event_bookingadded'] = 'Tidsbokning, bokning tillagd';
$string['event_bookingformviewed'] = 'Tidsbokning, bokningformulär visat';
$string['event_bookingremoved'] = 'Tidsbokning, bokning borttagen';
$string['everyone'] = 'Alla';
$string['excelformat'] = 'Excel';
$string['exclusive'] = 'Exklusiv';
$string['exclusivity'] = 'Exklusivitet';
$string['exclusivity_help'] = '<p>Du kan sätta en gräns för hur många studenter som kan boka ett tillfälle. </p> <p>Sätter du gränsen till 1 (standard), kommer det sätta mötestiden i exklusivt läge.</p> <p>Sätts gränsen till obegränsad (0), kommer tillfället aldrig att begränsas, även om andra tillfällen är satta som exklusiva eller begränsade i samma tidsram. </p>';
$string['exclusivityoverload'] = 'Tillfället har {$a} bokade studenter, fler än vad som tillåts med den här inställningen.';
$string['exclusivitypositive'] = 'Antal studenter per tillfälle måste vara minst 1';
$string['explaingeneralconfig'] = 'De här alternativen kan enbart ställas in på systemnivå och kommer gälla för alla som skapar tidsbokare i den här Moodle-installationen.';
$string['export'] = 'Exportera';
$string['exporthdr'] = 'Exportera tillfällen och bokningar';
$string['exporttimerange'] = 'Tidsomfång';
$string['exporttimerangeall'] = 'Framtida och förflutna tillfällen';
$string['exporttimerangefuture'] = 'Endast framtida tillfällen';
$string['exporttimerangepast'] = 'Endast förflutna tillfällen';
$string['field-appointmentnote'] = 'Mötesanteckning (till student)';
$string['field-attended'] = 'Närvarade';
$string['field-date'] = 'Datum';
$string['field-endtime'] = 'Sluttid';
$string['field-filecount'] = 'Antal uppladdade filer';
$string['field-grade'] = 'Betyg';
$string['field-location'] = 'Plats';
$string['field-maxstudents'] = 'Max antal studenter';
$string['field-slotnotes'] = 'Anteckningar om tillfället';
$string['field-starttime'] = 'Starttid';
$string['field-studentemail'] = 'Students e-post';
$string['field-studentfirstname'] = 'Students förnamn';
$string['field-studentfullname'] = 'Students fullständiga namn';
$string['field-studentidnumber'] = 'Students ID-nummer';
$string['field-studentlastname'] = 'Students efternamn';
$string['field-studentnote'] = 'Meddelande från student';
$string['field-studentusername'] = 'Students användarnamn';
$string['field-teachernote'] = 'Konfidentiell anteckning (bara för lärare)';
$string['fileformat'] = 'Filformat';
$string['fileformat_help'] = 'Följande filformat finns tillgängliga:
     <ul>
          <li>Kommaseparerade värden (CSV) textfil. Fältseparatorn (kommatecken som standard) kan väljas nedan.
               CSV-filer kan sedan öppnas med de flesta kalkylarksprogrammen;</li>
          <li>Microsoft Excelfil (Excel 2007 format);</li>
          <li>Open Document spreadsheets (ODS);</li>
          <li>HTML format - en webbsida som visar utdata som tabell, vilken kan skrivas ut med hjälp av webbläsarens utskriftfunktion;</li>
          <li>PDF-doukument. Du kan välja mellan liggande eller stående utskrift.</li>
     </ul>';
$string['finalgrade'] = 'Slutgiltigt betyg';
$string['firstslotavailable'] = 'Det första tillfället kommer att öppnas: {$a}';
$string['forbidgroup'] = 'Grupptillfälle - klicka för att ändra';
$string['forcewhenoverlap'] = 'Tvinga vid överlappning';
$string['forcewhenoverlap_help'] = '<h3>Tvinga tillägg av tillfällen som krockar med en session</h3> <p>Den här inställningen tvingar fram tillägg av tillfällen när sessionen krockar med andra mötestider. Om så är fallet, kommer bara "rena" tillfällen att läggas till. Nya tillfällen som krockar kommer att ignoreras.</p> <p> Om detta inte används, kommer tilläggsproceduren att blockera när överlappande tider upptäcks, och du kommer att tillfrågas om att ta bort tidigare tillfällen innan proceduren kan lägga till de nya. </p>';
$string['forcewhenoverlap_link'] = 'mod/scheduler/conflict';
$string['forcourses'] = 'Välj studenter i kurser';
$string['friday'] = 'Fredag';
$string['generalconfig'] = 'Generell konfiguration';
$string['grade'] = 'Betyg';
$string['gradeingradebook'] = 'Betyg i betygsbok';
$string['gradingstrategy'] = 'Betygsättningsstrategi';
$string['gradingstrategy_help'] = 'Välj hur betyg sammanställs i en tidsbokning där studenter kan ha flera bokningar. Betygsboken kan visa endera <ul><li>det genomsnittliga betyget eller</li><li>det högsta betyget</li></ul> som studenten åstadkommit.';
$string['group'] = 'grupp';
$string['groupbookings'] = 'Bokning för grupp';
$string['groupbookings_help'] = 'Tillåt studenter att boka tillfälle för alla medlemmarna i sin grupp. (Observera att detta är skilt från "Gruppläge"-inställningen som kontrollerar vilka tillfällen en student kan se).';
$string['groupbreakdown'] = 'Enligt gruppstorlek';
$string['groupmodeyourgroups'] = 'Gruppläge: {$a->groupmode}. Endast studenter i {$a->grouplist} kan boka tillfällen med dig.';
$string['groupmodeyourgroupsempty'] = 'Gruppläge: {$a->groupmode}. Du är inte med i någon grupp och därför kan inte studenterna boka möten med dig.';
$string['groupscheduling'] = 'Aktivera grupptidsbokning';
$string['groupscheduling_desc'] = 'Tillåt hela grupper att bli inbokade samtidigt. (Förutom det globala alternativet, måste aktivitetens gruppläge vara inställt på "Synliga grupper" eller "Separata grupper" för att kunna aktivera denna funktion.)';
$string['groupsession'] = 'Grupptillfälle';
$string['groupsize'] = 'Gruppstorlek';
$string['guardtime'] = 'Stopptid för ändring';
$string['guardtime_help'] = 'En stopptid förhindrar studenter att ändra sin bokning kort innan tillfället.<p>Om stopptiden är aktiverad och inställd på till exempel 2 timmar så kommer inte studenterna att kunna boka ett tillfälle som startar mindre än två timmar från nu. De kommer heller inte kunna avboka ett tillfälle som är om mindre än två timmar.</p>';
$string['guestscantdoanything'] = 'Gäster kan inte göra något här.';
$string['howtoaddstudents'] = 'För att kunna lägga till studenter till en tidsbokning som har en global skala, använd modulens rollinställning.<br/>Du kan också använda modulens rolldefinitioner för att definiera vilka som kan ta emot dina studenter.';
$string['htmlformat'] = 'HTML';
$string['ignoreconflicts'] = 'Ignorera tidsmässiga konflikter';
$string['ignoreconflicts_help'] = 'Om den här checkrutan är markerad kommer tillfället att flyttas till det begärda datumet och tiden, även om andra tillfällen redan finns vid samma tider. Detta kan leda till överlappande bokningar för vissa lärare eller studenter och bör därför användas försiktigt.';
$string['ignoreconflicts_link'] = 'mod/scheduler/conflict';
$string['includeemptyslots'] = 'Inkludera tomma tillfällen';
$string['includeslotsfor'] = 'Inkludera tillfällen för';
$string['incourse'] = 'i kursen';
$string['introduction'] = 'Introduktion';
$string['isnonexclusive'] = 'Icke-exklusiv';
$string['landscape'] = 'Landskap';
$string['lengthbreakdown'] = 'Enligt möteslängd';
$string['limited'] = 'Begränsad ({$a} kvar)';
$string['location'] = 'Plats';
$string['location_help'] = 'Specificera platsen för tillfället.';
$string['markasseennow'] = 'Markera som avklarad';
$string['markseen'] = 'Då du har genomfört ett tillfälle, markera närvarande/klara student(-er) genom att kryssa för rutan vid deras namn och profilbild i tabellen ovan.';
$string['maxgrade'] = 'Välj det högsta betyget';
$string['maxstudentlistsize'] = 'Maximala längden på studentlistan';
$string['maxstudentlistsize_desc'] = 'The maximum length of the list of students who need to make an appointment, as shown in the teacher view of the scheduler. If there are more students than this, no list will be displayed.';
$string['maxstudentsperslot'] = 'Maximalt antal studenter per tillfälle';
$string['maxstudentsperslot_desc'] = 'Grupptillfällen / icke-exklusiva tillfällen kan ha det här antalet studenter som mest. Notera även att valet "obegränsad" alltid kan väljas utöver detta för ett tillfälle.';
$string['meangrade'] = 'Välj det genomsnittliga betyget';
$string['meetingwith'] = 'Möte med din';
$string['meetingwithplural'] = 'Möte med dina';
$string['message'] = 'Meddelande';
$string['messagebody'] = 'Meddelandetext';
$string['messageprovider:bookingnotification'] = 'Meddelande när en tidsbokning görs eller blir inställd';
$string['messageprovider:invitation'] = 'Inbjudan att boka en tid';
$string['messageprovider:reminder'] = 'Påminnelse om annalkande tidsbokat möte';
$string['messagesent'] = 'Meddelande skickat till {$a} mottagare';
$string['messagesubject'] = 'Ämne';
$string['minutes'] = 'minuter';
$string['minutesperslot'] = 'minuter per tillfälle';
$string['missingstudents'] = '{$a} studenter har ännu inte bokat tillfälle.';
$string['missingstudentsmany'] = '{$a} studenter har ännu inte bokat tillfälle. Lista visas inte på grund av det stora antalet';
$string['mixindivgroup'] = 'Blanda individuella- och gruppbokningar';
$string['mixindivgroup_desc'] = 'Där gruppbokningar är aktiverade, tillåt även individuella bokningar';
$string['mode'] = 'Läge';
$string['modeappointments'] = 'bokning(-ar)';
$string['modeintro'] = 'Studenter kan registrera';
$string['modeoneatatime'] = 'åt gången';
$string['modeoneonly'] = 'i denna tidsbokning';
$string['modulename'] = 'Tidsbokning';
$string['modulename_help'] = 'Aktiviteten Tidsbokning hjälper dig hantera möten med dina studenter, gruppstudiebesök, laborationer mm. En lärare kan specificera tider för olika tillfällen och studenterna kan välja en tid i kursrummet. Läraren kan, i sin tur, notera utkomsten av mötet/tillfället -och vid behov betygsätta det - inuti tidsbokningen. Gruppbokningar stöds; vilket betyder att ett tillfälle kan bokas av flera studenter på en gång och att det även är möjligt att boka möten för hela grupper på en och samma gång.';
$string['modulename_link'] = 'mod/scheduler/view';
$string['modulenameplural'] = 'Tidsbokningar';
$string['monday'] = 'Måndag';
$string['multiple'] = '(multipla)';
$string['myappointments'] = 'Mina bokningar';
$string['myself'] = 'Mig själv';
$string['name'] = 'Tidsbokarens namn';
$string['needteachers'] = 'Tillfällen kan inte läggas till då den här kursen inte har några lärare';
$string['negativerange'] = 'Räckvidden är negativ. Så får det inte vara.';
$string['never'] = 'Aldrig';
$string['nfiles'] = '{$a} filer';
$string['noappointments'] = 'Inga bokningar';
$string['noexistingstudents'] = 'Inga existerande studenter';
$string['nogroups'] = 'Ingen grupp tillgänglig för tidsbokning.';
$string['noresults'] = 'Inga resultat.';
$string['noschedulers'] = 'Det finns inga tidsbokningar';
$string['noslots'] = 'Det finns inga tillgängliga tillfällen.';
$string['noslotsavailable'] = 'Inga tillfällen finns tillgängliga att boka vid denna tid.';
$string['noslotsopennow'] = 'Inga tillfällen är tillgängliga nu.';
$string['nostudents'] = 'Inga studenter bokade';
$string['nostudenttobook'] = 'Ingen student att boka';
$string['note'] = 'Betyg';
$string['noteacherforslot'] = 'Ingen lärare för tillfällena';
$string['noteachershere'] = 'Ingen lärare tillgänglig';
$string['notenoughplaces'] = 'Det finns tyvärr inte tillräckligt med lediga platser för detta tillfälle.';
$string['notesrequired'] = 'Du behöver skriva in text i detta fält innan du kan boka mötestiden';
$string['notifications'] = 'Notifikationer';
$string['notifications_help'] = 'När detta är aktiverat kommer lärare att få notifikationer när bokning görs, och studenter får notifikation om en bokning annuleras av läraren.';
$string['notseen'] = 'Inte avklarad';
$string['now'] = 'Nu';
$string['occurrences'] = 'Förekomster';
$string['odsformat'] = 'ODS';
$string['on'] = 'på';
$string['onedaybefore'] = '1 dag före tillfället';
$string['onelineperappointment'] = 'En rad per bokning';
$string['onelineperslot'] = 'En rad per tillfälle';
$string['oneslotadded'] = '1 tillfället tillagt';
$string['oneslotdeleted'] = '1 tillfälle borttaget';
$string['oneweekbefore'] = '1 vecka för tillfället';
$string['onthemorningofappointment'] = 'På morgonen för bokningen';
$string['options'] = 'Alternativ';
$string['otherstudents'] = 'Andra deltagare';
$string['outlineappointments'] = '{$a->attended} möten närvarande, {$a->upcoming} återstående.';
$string['outlinegrade'] = 'Betyg: {$a}.';
$string['overall'] = 'Översikt';
$string['overlappings'] = 'Andra tillfällen överlappar';
$string['pageperteacher'] = 'En sida för varje {$a}';
$string['pagination'] = 'Sidnumrering';
$string['pagination_help'] = 'Välj huruvida exporten ska innehålla en separat sida för varje lärare.
 I Excel- eller i ODS-filformatet kommer dessa sidor motsvara flikar (arbetsblad) i ett kalkylark.';
$string['pdfformat'] = 'PDF';
$string['pdforientation'] = 'PDF sidorientering';
$string['pluginadministration'] = 'Administration av Tidsbokning';
$string['pluginname'] = 'Tidsbokning';
$string['portrait'] = 'Porträtt';
$string['preview'] = 'Förhandsgranska';
$string['previewlimited'] = '(Förhandsgranskning är begränsat till {$a} rader.)';
$string['purgeunusedslots'] = 'Rensa gamla oanvända mötestider';
$string['recipients'] = 'Mottagare';
$string['registeredlbl'] = 'Inbokade studenter';
$string['reminder'] = 'Påminnelse';
$string['requireupload'] = 'Filer är obligatoriska';
$string['resetappointments'] = 'Ta bort bokningar och betyg';
$string['resetslots'] = 'Ta bort tillfällen i Tidsbokningen';
$string['return'] = 'Tillbaka till kursen';
$string['revealteachernotes'] = 'Visa lärares anteckningar vid begärt utdrag.';
$string['revoke'] = 'Annullera bokningen';
$string['saturday'] = 'Lördag';
$string['save'] = 'Spara';
$string['savechoice'] = 'Spara mitt val';
$string['saveseen'] = 'Spara som avklarad';
$string['schedule'] = 'Tillfällen';
$string['scheduleappointment'] = 'Boka möte vid {$a}';
$string['schedulecancelled'] = '{$a} : Din bokning annullerad eller flyttad';
$string['schedulegroups'] = 'Boka tillfälle gruppvis';
$string['scheduleinnew'] = 'Boka in en ny lucka';
$string['scheduleinslot'] = 'Boka i tillfälle';
$string['scheduler'] = 'Tidbokning';
$string['scheduler:addinstance'] = 'Lägg till en ny tidsbokning';
$string['scheduler:appoint'] = 'Boka';
$string['scheduler:attend'] = 'Ta emot studenter';
$string['scheduler:canscheduletootherteachers'] = 'Boka tillfällen för andra medlemmar i personalen';
$string['scheduler:canseeotherteachersbooking'] = 'Se och gå igenom andra lärares bokningar';
$string['scheduler:disengage'] = 'Avboka alla dina tillfällen';
$string['scheduler:editallattended'] = 'Markera studenter i alla tillfällen som närvarande / ej närvarande.';
$string['scheduler:editallgrades'] = 'Redigera betyg för alla tillfällen.';
$string['scheduler:editallnotes'] = 'Redigera anteckningar i alla tillfällen.';
$string['scheduler:manage'] = 'Hantera dina tillfällen och bokningar';
$string['scheduler:manageallappointments'] = 'Hantera all data för tidsbokningen';
$string['scheduler:seeotherstudentsbooking'] = 'Se andra studenters bokningar för detta tillfälle';
$string['scheduler:seeotherstudentsresults'] = 'Se resultat för andra studenter för detta tillfälle';
$string['scheduler:seeoverviewoutsideactivity'] = 'Använd översiktsvyn för att se mötestider utanför den nuvarande tidsbokningsaktiviteten.';
$string['scheduler:viewfullslots'] = 'Se tillfällen även om de är fullbokade (studentvy)';
$string['scheduler:viewslots'] = 'Se tillfällen som kan bokas (studentvy)';
$string['schedulestudents'] = 'Boka per student';
$string['scopemenu'] = 'Visa tillfällen i: {$a}';
$string['scopemenuself'] = 'Visa mina tillfällen i: {$a}';
$string['search:activity'] = 'Tidsbokning - aktivitetsinformation';
$string['seen'] = 'Avklarat';
$string['selectedtoomany'] = 'Du har valt för många tillfällen. Du kan inte välja fler än {$a}.';
$string['sendinvitation'] = 'Skicka inbjudan';
$string['sendmessage'] = 'Skicka meddelande';
$string['sendreminder'] = 'Skicka påminnelse';
$string['sepcolon'] = 'Kolon';
$string['sepcomma'] = 'Komma';
$string['sepsemicolon'] = 'Semikolon';
$string['septab'] = 'Tab';
$string['showemailplain'] = 'Visa epost-adresser';
$string['showemailplain_desc'] = 'I lärarens vy av tidsbokningen, visa e-post till studenter som behöver göra en bokning i klartext utöver "mailto:"-länkar.';
$string['showparticipants'] = 'Visa deltagare';
$string['slot'] = 'Tillfälle';
$string['slot_is_just_in_use'] = 'Tyvärr så har detta tillfälle just valts av en annan student. Försök på nytt.';
$string['slotdatetime'] = '{$a->shortdatetime} i {$a->duration} minuter';
$string['slotdatetimelabel'] = 'Datum och tid';
$string['slotdescription'] = '{$a->status} den {$a->startdate} från kl. {$a->starttime} till {$a->endtime} i {$a->location} med {$a->facilitator}.';
$string['slots'] = 'Tillfällen';
$string['slotsadded'] = '{$a} tillfällen har lagts till';
$string['slotsdeleted'] = '{$a} tillfällen har tagits bort';
$string['slottype'] = 'Typ av tillfälle';
$string['slotupdated'] = '1 tillfälle uppdaterat';
$string['slotwarning'] = '<strong>Varning: </strong>Att flytta detta tillfälle till den valda tiden orsakar en konflikt med de tillfällen som listas nedan. Bocka för "Ignorera tidsmässiga konflikter" om du trots allt vill flytta tillfället.';
$string['staffbreakdown'] = 'Av {$a}';
$string['staffrolename'] = 'Roll/titel på den som leder tillfället';
$string['staffrolename_help'] = 'Ange roll/titel för den som tar emot studenterna. Det måste inte vara "lärare".';
$string['start'] = 'Start';
$string['startpast'] = 'Du kan inte lägga till ett tillfälle i det förflutna';
$string['statistics'] = 'Statistik';
$string['student'] = 'Student';
$string['studentbreakdown'] = 'Per student';
$string['studentcomments'] = 'Studentens anteckningar';
$string['studentdetails'] = 'Info om student';
$string['studentfiles'] = 'Uppladdade filer';
$string['studentmultiselect'] = 'Varje student kan väljas endast en gång i detta tillfälle';
$string['studentnote'] = 'Meddelande från student';
$string['studentprovided'] = 'Student bidrog: {$a}';
$string['students'] = 'Studenter';
$string['sunday'] = 'Söndag';
$string['tab-otherappointments'] = 'Alla bokningar för denna student';
$string['tab-otherstudents'] = 'Studenter i detta tillfälle';
$string['tab-thisappointment'] = 'Denna bokning';
$string['teacher'] = 'Lärare';
$string['teachernote'] = 'Konfidentiella anteckningar (bara lärare kan se dem)';
$string['teachersmenu'] = 'Visa tillfällen för: {$a}';
$string['thiscourse'] = 'denna kurs';
$string['thisscheduler'] = 'denna tidsbokning';
$string['thissite'] = 'hela webbplatsen';
$string['thursday'] = 'Torsdag';
$string['timefrom'] = 'Från:';
$string['timerange'] = 'Tidsomfattning';
$string['timeto'] = 'Till:';
$string['totalgrade'] = 'Totalt betyg';
$string['tuesday'] = 'Tisdag';
$string['unattended'] = 'Icke närvarande';
$string['unlimited'] = 'Obegränsad';
$string['unregisteredlbl'] = 'Ej inbokade studenter';
$string['upcomingslots'] = 'Kommande tillfällen';
$string['updategrades'] = 'Uppdatera betyg';
$string['updatesingleslot'] = '';
$string['uploadmaxfiles'] = 'Maximalt tillåtet antal bifogade filer';
$string['uploadmaxfiles_help'] = 'Maximalt antal filer som studenten kan bifoga. Filerna är frivilliga om inte "Filer är obligatoriska" är förkryssad. Om siffran 0 anges ser inte studenterna någon uppladdningsfunktion.';
$string['uploadmaxfilesglobal'] = 'Maximalt tillåtet antal bifogade filer';
$string['uploadmaxfilesglobal_desc'] = 'Max antal filer en student kan ladda upp i en bokning. Detta kan begränsas ytterligare av den som skapar tidsbokningen.';
$string['uploadmaxsize'] = 'Max filstorlek';
$string['uploadmaxsize_help'] = 'Maxstorlek per fil för studenters uppladdade filer.';
$string['uploadrequired'] = 'Du behöver ladda upp filer innan du kan boka mötestiden.';
$string['uploadstudentfiles'] = 'Ladda upp filer';
$string['usebookingform'] = 'Använd bokningsformuläret';
$string['usebookingform_help'] = 'Om aktiverat ser studenterna en separat bokningsformulär innan de kan boka tid. Formuläret kan kräva att de anger data, laddar upp filer eller löser en captcha; se alternativ nedan.';
$string['usebookingform_link'] = 'mod/scheduler/bookingform';
$string['usecaptcha'] = 'Kräv CAPTCHA för att göra bokningar';
$string['usecaptcha_help'] = 'Om det är aktiverat måste studenterna lösa en CAPTCHA-säkerhetsfråga innan de gör en ny bokning. Använd den här inställningen om du misstänker att elever använder automatiserade program för att få tag på tillgängliga platser. <p>Ingen captcha kommer att visas om studenten redigerar en befintlig bokning.</p>';
$string['usenotes'] = 'Använd mötesanteckningar';
$string['usenotesboth'] = 'Båda sorternas anteckningar';
$string['usenotesnone'] = 'Använd inte';
$string['usenotesstudent'] = 'Mötesanteckning, synlig för både lärare och student';
$string['usenotesteacher'] = 'Konfidentiell anteckning, bara lärare kan se den.';
$string['usestudentnotes'] = 'Låt studenterna skriva ett meddelande';
$string['usestudentnotes_help'] = 'Om aktiverad innehåller bokningsformuläret en textruta där studenten kan skriva ett meddelande. Använd fältet "Instruktioner för bokning" ovan för att ge studenterna instruktioner om vilken information de ska lämna.';
$string['viewbooking'] = 'Visa detaljer';
$string['wednesday'] = 'Onsdag';
$string['welcomebackstudent'] = 'Du kan boka ytterligare tillfällen genom att klicka på respektive "Boka tillfälle"-knapp nedan.';
$string['welcomenewstudent'] = 'Tabellen nedan visar alla tillfällen som är tillgängliga för bokningar. Gör ditt val genom att markera och glöm inte att klicka på "Spara mitt val" efteråt. Om du senare behöver ändra ditt val är det bara att gå tillbaka till den här sidan.';
$string['welcomenewteacher'] = 'Klicka på knappen nedan för att lägga till tillfällen.';
$string['what'] = 'Vad';
$string['whathappened'] = 'Vad hände';
$string['whatresulted'] = 'Resultat';
$string['when'] = 'När';
$string['where'] = 'Var';
$string['who'] = 'Vem';
$string['whosthere'] = 'Vem är där ?';
$string['xdaysbefore'] = '{$a} dagar före tillfället';
$string['xweeksbefore'] = '{$a} veckor före mötesttiden';
$string['yesallgroups'] = 'Ja, för alla grupper';
$string['yesingrouping'] = 'Ja, i gruppindelningen {$a}';
$string['yesoptional'] = 'Meddelande är frivilligt';
$string['yesrequired'] = 'Studenten måste skriva meddelande';
$string['yourappointmentnote'] = 'Dina privata kommentarer';
$string['yourslotnotes'] = 'Kommentarer på mötet';
$string['yourstudentnote'] = 'Ditt meddelande';
$string['yourtotalgrade'] = 'Ditt totala betyg i denna aktivitet är <strong>{$a}</strong>';
