<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'sv', version '5.0'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Bläddra bland samtliga kurser';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Du är inte registrerad till några kurser ännu.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Bläddra bland alla kurser nedan och börja lära dig.';
$string['addon.block_myoverview.noresult'] = 'Din sökning genererade inget resultat';
$string['addon.block_myoverview.noresultdescription'] = 'Prova att ändra filterinställningarna eller välj att visa alla kurser nedan.';
$string['addon.blog.errorloadentries'] = 'Fel vid inläsning av blogginlägg.';
$string['addon.blog.showonlyyourentries'] = 'Visa endast egna inlägg';
$string['addon.calendar.calendarevent'] = 'Kalenderhändelse';
$string['addon.calendar.calendarevents'] = 'Kalenderhändelser';
$string['addon.calendar.calendarreminders'] = 'Påminnelser';
$string['addon.calendar.currentmonth'] = 'Nuvarande månad';
$string['addon.calendar.defaultnotificationtime'] = 'Standardtidpunkt för notiser';
$string['addon.calendar.errorloadevent'] = 'Fel vid inläsning av händelse.';
$string['addon.calendar.errorloadevents'] = 'Fel vid inläsning av händelser';
$string['addon.calendar.noevents'] = 'Det finns inga händelser';
$string['addon.calendar.reminders'] = 'Påminnelser';
$string['addon.calendar.setnewreminder'] = 'Ställ in en ny påminnelse';
$string['addon.competency.errornocompetenciesfound'] = 'Inga kompetenser funna';
$string['addon.competency.nocompetencies'] = 'Inga kompetenser';
$string['addon.coursecompletion.complete'] = 'Slutför';
$string['addon.coursecompletion.couldnotloadreport'] = 'Det gick inte att ladda kursslutföranderapporten. Vänligen försök igen senare.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Konfigurera enheter';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Dina användare får inga meddelanden från den här webbplatsen på sina mobila enheter. Aktivera mobilaviseringar på sidan Aviseringsinställningar.';
$string['addon.messages.contactlistempty'] = 'Kontaktlistan är tom';
$string['addon.messages.contactname'] = 'Kontaktnamn';
$string['addon.messages.deletemessage'] = 'Ta bort meddelande';
$string['addon.messages.deletemessageconfirmation'] = 'Är du säker på att du vill ta bort detta meddelande? Det kommer bara att tas bort från din egen meddelandehistorik. Användaren som skickade eller tog emot meddelandet kommer fortfarande att kunna se det.';
$string['addon.messages.errordeletemessage'] = 'Fel vid borttagning av meddelandet';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Fel vid hämtning av kontakter från servern.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Fel vid hämtning  av diskussionerna från servern.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Fel vid hämtning meddelanden från servern.';
$string['addon.messages.errorwhileretrievingusers'] = 'Fel vid inläsning av användare från servern.';
$string['addon.messages.messagenotsent'] = 'Meddelandet skickades inte, försök igen senare.';
$string['addon.messages.newmessages'] = 'Nya meddelanden';
$string['addon.messages.nousersfound'] = 'Inga användare hittades';
$string['addon.messages.showdeletemessages'] = 'Visa borttagna meddelanden';
$string['addon.messages.type_blocked'] = 'Blockerad';
$string['addon.messages.type_offline'] = 'Offline';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Sökresultat';
$string['addon.messages.type_strangers'] = 'Andra';
$string['addon.messages.useentertosenddescdesktop'] = 'Om inaktiverad kan du använda Ctrl+Enter för att skicka meddelandet.';
$string['addon.messages.useentertosenddescmac'] = 'Om inaktiverad kan du använda Cmd+Enter för att skicka meddelandet.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Kunde inte skicka meddelande till konversation {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Ett eller flera meddelanden till användare {{user}} kunde inte skickas. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Vänligen godkänn inlämningsvillkoren.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Du kan inte lägga till eller redigera en inlämningsuppgift i appen eftersom inlämningsvillkoren inte kunde hämtas från webbplatsen.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Vissa betygssättningsmetoder stöds ännu inte av appen och kan inte ändras.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Du kan inte göra en inlämning i appen eftersom det inte gick att hämta inlämningsvillkoren från webbplatsen.';
$string['addon.mod_assign.duedateno'] = 'Inget förfallodatum';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Du kan inte lägga till eller redigera en inlämningsuppgift i appen eftersom vissa pluginmoduler ännu inte stödjer redigering.';
$string['addon.mod_assign.errorshowinginformation'] = 'Information om inlämningen kunde inte visas.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Appen stödjer inte denna återkoppling och det kan hända att information saknas.';
$string['addon.mod_assign.gradenotsynced'] = 'Betyg har inte synkats';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Deltagare som inte lämnat in visas inte.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Det finns {{count}} utkast.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Det finns {{count}} deltagare.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Det finns {{count}} inlämningar som behöver betygsättas.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Det finns {{count}} inskickade inlämningsuppgifter.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Det finns {{count}} teams.';
$string['addon.mod_assign.submissionnotsupported'] = 'Appen stödjer inte denna inlämning och det kan hända att information saknas.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'betyg';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Betyget för inlämningsuppgiften ändrades på webbplatsen.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Inlämningsuppgiften ändrades på webbplatsen.';
$string['addon.mod_chat.confirmloss'] = 'Är du säker? Chatthistoriken kan gå förlorad.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Fel vid anslutning till chatten.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Fel vid vid hämtning av chattinformation.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Fel vid vid hämtning av chattanvändare.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Fel vid hämtning av meddelanden från servern.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Fel när meddelandet skickades';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Du måste vara online för att skicka meddelanden';
$string['addon.mod_chat.nosessionsfound'] = 'Inga sessioner hittades';
$string['addon.mod_chat.showincompletesessions'] = 'Visa ej slutförda sessioner';
$string['addon.mod_choice.errorgetchoice'] = 'Fel vid hämtning av val-information.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% av användarna valde alternativet: {{text}}';
$string['addon.mod_choice.resultsnotsynced'] = 'Ditt senaste svar behöver synkroniseras innan det kan inkluderas i resultaten.';
$string['addon.mod_data.edittagsnotsupported'] = 'Det går inte att redigera etiketter i appen.';
$string['addon.mod_data.errorapproving'] = 'Fel vid godkännande eller icke-godkännande av den inmatade informationen.';
$string['addon.mod_data.errordeleting'] = 'Ett fel uppstod då posten skulle tas bort.';
$string['addon.mod_data.gettinglocation'] = 'Hämtar platsinformation';
$string['addon.mod_data.locationnotenabled'] = 'Platsinformation är inte aktiverad';
$string['addon.mod_data.locationpermissiondenied'] = 'Behörighet att komma åt din plats har nekats.';
$string['addon.mod_data.mylocation'] = 'Min plats';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Det går inte att söka via etiketter i den här appen.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Feedback med CAPTCHA kan inte slutföras offline, om det inte konfigurerats eller om servern är onåbar.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Det finns {{count}} inskickade svar.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Denna återkoppling har sparats och kommer att skickas in senare.';
$string['addon.mod_feedback.questionscountdescription'] = 'Det finns {{count}} frågor.';
$string['addon.mod_folder.emptyfilelist'] = 'Det finns inga filer att visa';
$string['addon.mod_forum.errorgetforum'] = 'Fel vid hämtning av foruminformation.';
$string['addon.mod_forum.errorgetgroups'] = 'Fel vid hämtning av gruppinställningar.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Kunde inte skapa ny diskussion i alla grupperna.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Det finns inga diskussioner i detta forum ännu.';
$string['addon.mod_forum.group'] = 'Grupp';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} diskussioner';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} svar';
$string['addon.mod_forum.refreshposts'] = 'Uppdatera inlägg';
$string['addon.mod_glossary.browsemode'] = 'Bläddrar bland poster';
$string['addon.mod_glossary.byalphabet'] = 'Alfabetiskt';
$string['addon.mod_glossary.byauthor'] = 'Gruppera på författare';
$string['addon.mod_glossary.bycategory'] = 'Gruppera per kategori';
$string['addon.mod_glossary.bynewestfirst'] = 'Nyaste först';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Senast uppdaterade';
$string['addon.mod_glossary.bysearch'] = 'Sök';
$string['addon.mod_glossary.cannoteditentry'] = 'Kan inte redigera inlägg';
$string['addon.mod_glossary.entriestobesynced'] = 'Inlägg som kommer synkas';
$string['addon.mod_glossary.entrypendingapproval'] = 'Detta inlägg väntar på godkännande';
$string['addon.mod_glossary.errorloadingentries'] = 'Ett fel uppstod vid inläsning av inläggen.';
$string['addon.mod_glossary.errorloadingentry'] = 'Ett fel uppstod vid inläsning av inlägget.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Ett fel uppstod vid inläsning av ordboken.';
$string['addon.mod_glossary.noentriesfound'] = 'Inga inlägg hittades.';
$string['addon.mod_glossary.searchquery'] = 'Sökfråga';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Ladda ner H5P-fil';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Det gick inte att hämta data för H5P-aktiviteten';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'H5P-paketet är inte nedladdat. Du behöver ladda ned det för att kunna använda det.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'H5P-paketet har ändrats sen den senaste nedladdningen. Du behöver ladda ned det igen för att kunna använda det.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Du behöver vara on-line för att kunna visa H5P-paketet.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Visa försök {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Visa beskrivning';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Den här lektionen innehåller ett hopp till en slumpmässig innehållssida. Det kan inte göras ett försök i appen förrän den har startats i en webbläsare.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Det går inte längre att granska detta försök eftersom ett annat försök har avslutats.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Detta försök avslutades offline.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Ett offlineförsök synkroniserades. Vill du granska det?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Detta försök avslutades på webbplatsen.';
$string['addon.mod_lti.errorgetlti'] = 'Fel vid hämtning av moduldata.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'URL är ogiltig';
$string['addon.mod_lti.launchactivity'] = 'Starta aktiviteten';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Fel vid laddning av sidans innehåll.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Du kan försöka detta test i appen, men du kommer att behöva skicka in försöket i webbläsaren av följande skäl:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Det här försöket av testet kan inte lämnas in av följande skäl:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Detta försök har inte synkroniserats sedan {{$a}}. Om du har fortsatt detta försök på en annan enhet sedan dess kan du förlora data.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Ett fel uppstod när svaren sparades. Är du säker på att du vill lämna det här testet?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Det här kunskapstestet kan inte genomföras i mobilappen eftersom frågebeteendet inte stöds av den:';
$string['addon.mod_quiz.errordownloading'] = 'Det gick inte att ladda ner nödvändig data.';
$string['addon.mod_quiz.errorgetattempt'] = 'Kunde inte hämta data för försöket.';
$string['addon.mod_quiz.errorgetquestions'] = 'Kunde inte hämta frågor.';
$string['addon.mod_quiz.errorgetquiz'] = 'Kunde inte hämta quizdata.';
$string['addon.mod_quiz.errorparsequestions'] = 'Ett fel uppstod när frågorna lästes in. Försök gärna göra detta test i en webbläsare istället.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Det går inte att försöka göra det här testet i appen eftersom det enbart innehåller frågor som inte stöds av appen:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Det går inte att försöka göra det här testet i appen eftersom det har åtkomstregler som inte stöds av appen:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Ett fel uppstod när försöksdata skulle sparas.';
$string['addon.mod_quiz.finishnotsynced'] = 'Avslutad men inte synkroniserad';
$string['addon.mod_quiz.opentoc'] = 'Öppna navigeringsöversikt';
$string['addon.mod_quiz.warningattemptfinished'] = 'Offlineförsöket ignorerades eftersom det redan slutförts på webbplatsen eller inte kunde hittas.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Vissa offlinesvar ignorerades eftersom frågorna ändrades online.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Försök oavslutat eftersom vissa offlinesvar ignorerades. Vänligen granska dina svar och skicka sedan in försöket igen.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Det här kunskapstestet innehåller frågor som inte stöds av appen:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Fel vid laddning av innehåll.';
$string['addon.mod_resource.openthefile'] = 'Öppna';
$string['addon.mod_resource.resourcestatusoutdated'] = 'Den här filen har ändrats sedan du senast öppnade den.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'Det finns en nyare version av den här filen. Anslut till internet för att se den.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Betyg kunde inte beräknas';
$string['addon.mod_scorm.dataattemptshown'] = 'Dessa data tillhör försök nummer {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Ett fel uppstod. Vänligen försök igen.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Fel vid nedladdning av SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Fel vid hämtning av SCORM-data.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Tyvärr, applikationen stödjer endast SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Nedladdningen av SCORM paket är inaktiverad. Kontakta administratören.';
$string['addon.mod_scorm.errornovalidsco'] = 'Denna SCORM har ingen synlig SCO att ladda';
$string['addon.mod_scorm.errorpackagefile'] = 'Tyvärr, applikationen stödjer endast ZIP filer';
$string['addon.mod_scorm.errorsyncscorm'] = 'Fel vid synkronisering. Vänligen försök igen';
$string['addon.mod_scorm.offlineattemptnote'] = 'Detta försök har data som inte har synkroniserats';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Detta försök kan inte skickas eftersom du har överstigit det maximala antalet försök';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Detta SCORM är inte nedladdat. Det kommer att laddas ner automatiskt när du öppnar den';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Detta SCORM har modifierats sedan sista nedladdningen. Det kommer att laddas ner automatiskt när du öppnar den';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Vissa offlinedata av försöket {{nummer}} har tagits bort eftersom den inte kunnat skapas in ett nytt försök .';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Vissa försök kunde inte synkroniseras med sidan, eftersom senaste online försök inte är klar än . Vänligen avsluta online- försöket först .';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Tyvärr fanns det ett problem att skicka din enkät . Var god försök igen.';
$string['addon.mod_survey.errorgetsurvey'] = 'Fel vid hämtning av enkätdata';
$string['addon.mod_survey.results'] = 'Resultat';
$string['addon.mod_url.accessurl'] = 'Gå till webbadressen';
$string['addon.mod_url.pointingtourl'] = 'URL som resursen pekar på.';
$string['addon.mod_wiki.errorloadingpage'] = 'Ett fel uppstod när sidan laddades';
$string['addon.mod_wiki.errornowikiavailable'] = 'Det finns ingen Wiki tillgänglig som kan visas';
$string['addon.mod_wiki.gowikihome'] = 'Wiki hem';
$string['addon.mod_wiki.subwiki'] = 'Subwiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Titel får inte lämnas tom';
$string['addon.mod_wiki.viewpage'] = 'Visa sida';
$string['addon.mod_wiki.wikipage'] = 'Wikisida';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Bedömningsstrategi {{$a}} stöds inte';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Du behöver ange titel.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Inlämningen ändrades på webbplatsen.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Bedömningen ändrades på webbplatsen.';
$string['addon.notes.warningnotenotsent'] = 'Kunde inte lägga till anteckning till kursen {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Fel då notiserna hämtades.';
$string['addon.notifications.notifications'] = 'Notiser';
$string['addon.notifications.playsound'] = 'Spela upp ljud';
$string['addon.notifications.therearentnotificationsyet'] = 'Det finns inga notiser.';
$string['addon.privatefiles.couldnotloadfiles'] = 'Fillistan kunde inte laddas.';
$string['addon.privatefiles.emptyfilelist'] = 'Det finns inga filer att visa.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Just nu är det tyvärr inte möjligt att ladda upp filer till webbplatsen.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Ta bort all nedladdad webbplatsdata?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Ta bort nedladdade data från alla kurser?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Ta bort nedladdade data från \'{{name}\'?';
$string['addon.storagemanager.coursedownloads'] = 'Kursnedladdningar';
$string['addon.storagemanager.courseinfo'] = 'Ladda ner kursinnehåll för att arbeta offline. Din aktivitet synkroniseras automatiskt när enheten är online igen.';
$string['addon.storagemanager.deleteallsitedata'] = 'Ta bort all nedladdad data';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Detta tar bort alla nedladdade data från \'{{name}}\', inklusive alla nedladdade kurser och data som låter dig arbeta offline.';
$string['addon.storagemanager.deletecourses'] = 'Ta bort all kursdata';
$string['addon.storagemanager.deletedata'] = 'Ta bort nedladdade data';
$string['addon.storagemanager.deletedatafrom'] = 'Ta bort data från {{name}}';
$string['addon.storagemanager.downloadedcourses'] = 'Nedladdade kurser';
$string['addon.storagemanager.downloads'] = 'Nedladdningar';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Ett fel uppstod då nedladdade data skulle tas bort';
$string['addon.storagemanager.managedownloads'] = 'Hantera nedladdningar';
$string['addon.storagemanager.totaldownloads'] = 'Totalt nedladdat';
$string['addon.storagemanager.totalspaceusage'] = 'Totalt använt utrymme';
$string['appstoredescription'] = '<strong>OBS!</strong> Denna officiella Mobile-appen fungerar ENDAST med Moodle webbplatser som har konfigurerats för att tillåta det. Vänligen prata med din Moodleadministratör om du har problem att ansluta.

Om din Moodlewebbplats har konfigurerats korrekt kan du använda den här appen för att:

- bläddra i innehållet i dina kurser, även när du är offline
- få omedelbara notiser, meddelanden och andra händelser
- snabbt hitta och kontakta andra personer i dina kurser
- ladda upp bilder, ljud, videor och andra filer från din mobila enhet
- se dina kursbetyg
- och mer!

Vänligen se http://docs.moodle.org/sv/Mobile_app för den senaste informationen.

Vi skulle verkligen uppskatta några bra recensioner om funktionaliteten så här långt samt dina förslag på vad du mer vill att denna app ska kunna göra!

Appen kräver följande behörigheter:

Spela in ljud - För inspelning av ljud att ladda upp till Moodle
Läs och ändra innehållet på ditt SD-kort - Innehållet hämtas till SD-kortet så att du kan se det offline
Nätverksåtkomst - För att kunna ansluta till din Moodle-webbplats och kontrollera om du är ansluten eller inte och att växla till offline-läge
Kör vid start - Så du kan ta emot meddelanden även när appen körs i bakgrunden
Förhindra att telefonen växlar till viloläge - Så att du kan ta emot push-notiser när som helst.';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Google Drive-ljud';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Docs';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google Drawing';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Google Drive-fil';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Google Drive-mapp';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Google Forms';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Fusion Tables';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Google Slides';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Scripts';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Google Sites';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Google Sheets';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Google Drive-video';
$string['core.ajaxendpointnotfound'] = '<p>AJAX-slutpunkten hittades inte. Detta kan inträffa om Moodle-webbplatsen är för gammal eller om den blockerar åtkomsten till den här slutpunkten. Moodle-appen stöder endast Moodle-system {{$a}} och framåt. Kontakta webbplatsadministratören.</p>
<p>{{whoisadmin}}</p>';
$string['core.browser'] = 'Webbläsare';
$string['core.calculating'] = 'Beräknar';
$string['core.cannotconnect'] = 'Kan inte ansluta';
$string['core.cannotdownloadfiles'] = 'Nedladdning av filer är inaktiverad. Vänligen kontakta webbsidans administratör.';
$string['core.cannotlogoutpageblocks'] = 'Spara eller ignorera dina ändringar innan du fortsätter.';
$string['core.cannotopeninapp'] = 'Den här filen kanske inte fungerar som förväntat på den här enheten. Vill du öppna den ändå?';
$string['core.cannotopeninappdownload'] = 'Den här filen kanske inte fungerar som förväntat på den här enheten. Vill du ladda ner den ändå?';
$string['core.captureaudio'] = 'Spela in ljud';
$string['core.capturedimage'] = 'Tagen bild.';
$string['core.captureimage'] = 'Ta bild';
$string['core.capturevideo'] = 'Spela in video';
$string['core.certificaterror'] = '<p>Certifikatet för den här webbplatsen är inte betrott av din enhet. Kontakta webbplatsadministratören.</p>
<p>{{whoisadmin}}</p>';
$string['core.clearsearch'] = 'Rensa sökning';
$string['core.clearstoreddata'] = 'Töm lagringsutrymme {{$a}}';
$string['core.clicktoseefull'] = 'Klicka för att se hela innehållet';
$string['core.comments.commentsnotworking'] = 'Kan inte ta emot kommentarer';
$string['core.comments.warningcommentsnotsent'] = 'Kan inte synka kommentarer. {{error}}';
$string['core.confirmcanceledit'] = 'Är du säker på att du vill lämna den här sidan? Alla ändringar kommer att gå förlorade.';
$string['core.confirmleaveunknownchanges'] = 'Är du säker på att du vill lämna den här sidan? Eventuellt osparade ändringar kommer att gå förlorade.';
$string['core.confirmloss'] = 'Är du säker? Alla ändringar kommer att gå förlorade.';
$string['core.confirmopeninbrowser'] = 'Vill du öppna den i webbläsaren?';
$string['core.contenteditingsynced'] = 'Innehållet du redigerar har synkroniserats.';
$string['core.contentlinks.chooseaccount'] = 'Välj konto';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Välj ett konto att öppna länken med.';
$string['core.contentlinks.confirmurlothersite'] = 'Länken tillhör en annan webbsida. Vill du öppna den?';
$string['core.contentlinks.errornoactions'] = 'Kunde inte hitta en åtgärd att använda för denna länk.';
$string['core.contentlinks.errornosites'] = 'Hittade ingen webbsida som kunde hantera den här länken.';
$string['core.contentlinks.errorredirectothersite'] = 'Omdirigerings-URL:en kan inte peka på en annan webbplats.';
$string['core.copiedtoclipboard'] = 'Text kopierad till urklipp';
$string['core.copytoclipboard'] = 'Kopiera';
$string['core.course.activitydisabled'] = 'Din organisation har inaktiverat denna aktivitet i mobilappen.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Din organisation har installerat en pluginmodul som ännu inte stöds av mobilappen.';
$string['core.course.allsections'] = 'Alla sektioner';
$string['core.course.aria:sectionprogress'] = 'Avsnittsförlopp:';
$string['core.course.availablespace'] = 'Du har för närvarande omkring {{available}} ledigt utrymme.';
$string['core.course.cannotdeletewhiledownloading'] = 'Det går inte att ta bort filer medan aktiviteten hämtas. Vänligen vänta tills nedladdningen är klar.';
$string['core.course.confirmdownload'] = 'Du håller på att hämta {{size}}. {{availableSpace}} Är du säker på att du vill fortsätta?';
$string['core.course.confirmdownloadunknownsize'] = 'Det gick inte att beräkna storleken på nedladdningen. {{availableSpace}} Är du säker på att du vill fortsätta?';
$string['core.course.confirmdownloadzerosize'] = 'Du är på väg att börja ladda ner. {{availableSpace}} Är du säker på att du vill fortsätta?';
$string['core.course.confirmlimiteddownload'] = 'Du är för närvarande inte ansluten till Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Du är på väg att hämta <strong>minst</strong> {{size}}.{{availableSpace}} Är du säker på att du vill fortsätta?';
$string['core.course.couldnotloadsectioncontent'] = 'Det gick inte att läsa sektionens innehåll. Vänligen försök igen senare.';
$string['core.course.couldnotloadsections'] = 'Det gick inte att läsa sektionen. Vänligen försök igen senare.';
$string['core.course.downloadcoursesprogressdescription'] = 'Laddar ned kurser: {{count}} av {{total}} nedladdade.';
$string['core.course.downloadsectionprogressdescription'] = 'Laddar ned avsnitt: {{count}} av {{total}} nedladdade.';
$string['core.course.errordownloadingcourse'] = 'Fel vid nedladdning av kurs.';
$string['core.course.errordownloadingsection'] = 'Fel vid nedladdning av sektion.';
$string['core.course.errorgetmodule'] = 'Fel vid hämtning av aktivitetsdata.';
$string['core.course.insufficientavailablequota'] = 'Enheten kunde inte allokera utrymme för att spara den här hämtningen. Den kanske reserverar utrymme för app- och systemuppdateringar. Vänligen rensa lite lagringsutrymme först.';
$string['core.course.insufficientavailablespace'] = 'Du försöker hämta {{size}}. Då får enheten otillräckligt med utrymme för att kunna fungera normalt. Vänligen frigör lite lagringsutrymme först.';
$string['core.course.lastaccessedactivity'] = 'Senaste aktivitet';
$string['core.course.manualcompletionnotsynced'] = 'Manuellt slutförande synkroniserades inte.';
$string['core.course.modulenotfound'] = 'Resursen eller aktiviteten hittades inte. Kontrollera att du är online och att den fortfarande är tillgänglig.';
$string['core.course.nextactivity'] = 'Nästa aktivitet';
$string['core.course.nextactivitynotfound'] = 'Kunde inte hitta nästa aktivitet. Den kan ha dolts eller tagits bort.';
$string['core.course.nocontentavailable'] = 'Inget innehåll tillgängligt för tillfället.';
$string['core.course.previousactivity'] = 'Föregående aktivitet';
$string['core.course.previousactivitynotfound'] = 'Kunde inte hitta föregående aktivitet. Den kan ha dolts eller tagits bort.';
$string['core.course.refreshcourse'] = 'Uppdatera kurs';
$string['core.course.useactivityonbrowser'] = 'Du kan fortfarande använda den genom att använda din enhets webbläsare.';
$string['core.course.warningmanualcompletionmodified'] = 'Det manuella slutförandet av en aktivitet modifierades på webbplatsen.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Vissa manuella slutföranden offline av kurs \'{{namn}}\' har tagits bort. {{error}}';
$string['core.coursenogroups'] = 'Du är inte medlem i någon grupp i denna kurs.';
$string['core.courses.browserenrolinstructions'] = 'Vi skickar dig nu till din enhets webbläsare. När du har slutfört din registrering kan du komma tillbaka till den här appen.';
$string['core.courses.cannotretrievemorecategories'] = 'Det går inte att hämta kategorier djupare än {{$a}}.';
$string['core.courses.completeenrolmentbrowser'] = 'Slutför registreringen i webbläsaren';
$string['core.courses.downloadcourses'] = 'Ladda ned kurser';
$string['core.courses.enrolme'] = 'Registrera mig';
$string['core.courses.errorloadcategories'] = 'Ett fel inträffade då kategorier laddades.';
$string['core.courses.errorloadcourses'] = 'Ett fel uppstod vid inläsning av kurser.';
$string['core.courses.errorloadplugins'] = 'De pluginmoduler som krävs för denna kurs kunde inte laddas korrekt. Vänligen ladda om appen för att försöka igen.';
$string['core.courses.errorsearching'] = 'Fel uppstod vid sökning';
$string['core.courses.filtermycourses'] = 'Filtrera mina kurser';
$string['core.courses.notenrollable'] = 'Du kan inte självregistrera dig i kursen';
$string['core.courses.otherenrolments'] = 'Övriga registreringar';
$string['core.courses.password'] = 'Kursnyckel';
$string['core.courses.refreshcourses'] = 'Uppdatera kurser';
$string['core.courses.searchcoursesadvice'] = 'Du kan använda knappen "Sök kurser" för att få tillgång som gäst eller registrera dig på kurser som tillåter det .';
$string['core.courses.showonlyenrolled'] = 'Visa endast mina kurser';
$string['core.courses.totalcoursesearchresults'] = 'Total antal kurser: {{$a}}';
$string['core.currentdevice'] = 'Nuvarande enhet';
$string['core.datastoredoffline'] = 'Data som lagras i enheten eftersom det inte gick att skicka den. Den skickas automatiskt senare.';
$string['core.deletedoffline'] = 'Borttagen off-line';
$string['core.deleting'] = 'Tar bort';
$string['core.desktop'] = 'Skrivbord';
$string['core.dfdaymonthyear'] = 'YYYY-MM-DD';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'Y-m-d H:i';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Överge';
$string['core.dismiss'] = 'Avfärda';
$string['core.dontshowagain'] = 'Visa inte igen';
$string['core.downloaded'] = 'Hämtat';
$string['core.downloading'] = 'Laddar ner';
$string['core.editor.hidetoolbar'] = 'Dölj verktygsrad';
$string['core.editor.toggle'] = 'Växla redigerare';
$string['core.emptysplit'] = 'Den här sidan är tom om den vänstra panelen är tom eller håller på att läsas in.';
$string['core.errorchangecompletion'] = 'Ett fel uppstod när slutförandestatusen ändrades. Vänligen god försök igen.';
$string['core.errordeletefile'] = 'Ett fel inträffade när filen skulle tas bort. Försök igen.';
$string['core.errordownloading'] = 'Fel vid nedladdning av fil';
$string['core.errordownloadingsomefiles'] = 'Fel vid hämtning av modulens filer. Vissa filer kanske saknas.';
$string['core.errorfileexistssamename'] = 'Det finns redan en fil med det här namnet.';
$string['core.errorinvalidform'] = 'Formuläret innehåller ogiltiga data. Vänligen kontrollera att alla obligatoriska fält är ifyllda och att uppgifterna är giltiga.';
$string['core.errorinvalidresponse'] = 'Fick ogiltigt svar. Kontakta administratören om felet kvarstår.';
$string['core.errorloadingcontent'] = 'Fel vid laddning av innehåll.';
$string['core.errorofflinedisabled'] = 'Bläddring offline är inaktiverat på din webbplats. Du måste vara ansluten till internet för att använda appen.';
$string['core.erroropenfiledownloading'] = 'Fel vid öppning av fil: vänta tills nedladdningen är slutförd.';
$string['core.erroropenfilenoapp'] = 'Fel vid öppning av filen: ingen app hittades som kan öppna denna typ av fil.';
$string['core.erroropenfilenoextension'] = 'Fel vid öppning av fil: filen saknar filnamnstillägg.';
$string['core.erroropenpopup'] = 'Aktiviteten försöker öppna ett pop-up fönster. Detta stöds inte i av appen.';
$string['core.errorrenamefile'] = 'Ett fel inträffade då filen skulle döpas om. Vänligen försök igen.';
$string['core.errorsomedatanotdownloaded'] = 'Om du har hämtat den här aktiviteten, observera att vissa data inte hämtas under hämtningsprocessen av prestanda- och dataanvändningsskäl.';
$string['core.errorsync'] = 'Ett fel inträffade vid synkronisering. Försök igen.';
$string['core.errorsyncblocked'] = '{{$a}} kan inte synkroniseras just nu på grund av en pågående process. Försök igen senare. Om problemet kvarstår kan du försöka starta om appen.';
$string['core.errorurlschemeinvalidscheme'] = 'Den här webbadressen är tänkt att användas i en annan app: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'Den här webbadress kan inte öppnas i denna app.';
$string['core.filenameexist'] = 'Filnamnet finns redan: {{$a}}';
$string['core.fileuploader.audio'] = 'Ljud';
$string['core.fileuploader.camera'] = 'Kamera';
$string['core.fileuploader.confirmuploadfile'] = 'Du är på väg att ladda upp {{size}}. Är du säker på att du vill fortsätta?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Det gick inte att beräkna storleken på uppladdningen. Är du säker på att du vill fortsätta?';
$string['core.fileuploader.errorcapturingaudio'] = 'Fel vid inspelning av ljud.';
$string['core.fileuploader.errorcapturingimage'] = 'Fel då bilden skulle tas.';
$string['core.fileuploader.errorcapturingvideo'] = 'Fel vid inspelning av video';
$string['core.fileuploader.errorgettingimagealbum'] = 'Fel vid hämtning av bild från album.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Du måste vara online för att ladda upp filer.';
$string['core.fileuploader.errornoapp'] = 'Du har ingen app installerad som kan utföra den här åtgärden.';
$string['core.fileuploader.errorreadingfile'] = 'Fel vid läsning av fil.';
$string['core.fileuploader.errorwhileuploading'] = 'Ett fel uppstod under filöverföringen.';
$string['core.fileuploader.file'] = 'Fil';
$string['core.fileuploader.fileuploaded'] = 'Filen laddades upp.';
$string['core.fileuploader.maxbytesfile'] = 'Filen {{$a.file}} är för stor. Den maximala storleken du kan överföra är {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Fotoalbum';
$string['core.fileuploader.readingfile'] = 'Läser fil';
$string['core.fileuploader.readingfileperc'] = 'Läser fil: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'Välj fil';
$string['core.fileuploader.uploadafile'] = 'Ladda upp fil';
$string['core.fileuploader.uploading'] = 'Laddar upp';
$string['core.fileuploader.uploadingperc'] = 'Laddar upp: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Gå till {{$a}}';
$string['core.h5p.errorgetemail'] = 'Fel vid hämtning av e-post. Vänligen kontrollera din anslutning och försök igen.';
$string['core.h5p.offlinedisabled'] = 'Denna webbplats tillåter inte nedladdning av H5P-paket.';
$string['core.h5p.play'] = 'Visa HP5';
$string['core.hasdatatosync'] = 'Den här {{$a}} har offlinedata som ska synkroniseras.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Fungerar inte detta innehåll?';
$string['core.image'] = 'Bild';
$string['core.imageviewer'] = 'Bildvisare';
$string['core.ioscookieshelp'] = 'Inbäddat innehåll kan kräva att cookies är tillåtna. Vänligen gå till appens iOS-inställningar och aktivera \'Tillåt spårning mellan webbplatser\' och försök igen.';
$string['core.lastdownloaded'] = 'Senast nedladdat';
$string['core.lastsync'] = 'Senaste synkronisering';
$string['core.loadmore'] = 'Hämta mer';
$string['core.login.authenticating'] = 'Autentiserar';
$string['core.login.changepasswordbutton'] = 'Öppna sidan för lösenordsbyte';
$string['core.login.changepasswordhelp'] = 'Om du har problem med att ändra ditt lösenord, kontakta din webbplatsadministratör. "Webbplatsadministratörer" är de personer som sköter Moodle i din organisation. Om du inte vet hur du kontaktar dem, kontakta dina lärare.';
$string['core.login.changepasswordreconnectinstructions'] = 'Klicka på följande knapp för att återansluta till webbplatsen. (Tänk på att om du inte lyckades ändra ditt lösenord, skulle du återgå till föregående skärm).';
$string['core.login.confirmdeletesite'] = 'Är du säker på att du vill ta bort webbplatsen {{sitename}}?';
$string['core.login.connect'] = 'Anslut!';
$string['core.login.connecttomoodle'] = 'Anslut till Moodle';
$string['core.login.connecttomoodleapp'] = 'Du försöker ansluta till en vanlig Moodle-webbplats. Vänligen ladda ner den officiella Moodle appen för att komma åt denna webbplats.';
$string['core.login.connecttoworkplaceapp'] = 'Du försöker ansluta till en Moodle Workplace-webbplats. Vänligen ladda ner Moodle Workplace-appen för att komma åt den här webbplatsen.';
$string['core.login.credentialsdescription'] = 'Ange ditt användarnamn och lösenord för att logga på';
$string['core.login.emailconfirmsentnoemail'] = '<p>Ett e-postmeddelande ska ha skickats till din adress.</p><p>Det innehåller enkla instruktioner för att slutföra din registrering.</p><p>Om du fortsätter att ha svårigheter kontaktar du webbplatsens administratör.</p>';
$string['core.login.emailnotmatch'] = 'E-postmeddelandena stämmer inte överens.';
$string['core.login.erroraccesscontrolalloworigin'] = 'Det korsanrop du försöker utföra har avvisats. Vänligen se https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Ett fel inträffade vid borttagning av denna webbplats. Vänligen försök igen.';
$string['core.login.errorexampleurl'] = 'https://campus.example.edu är bara ett exempel på en webbadress, det är inte en riktig webbplats. <strong>Vänligen använd webbadressen till din organisations webbplats.</strong>';
$string['core.login.errorqrnoscheme'] = 'Detta är inte en giltig inloggnings-URL.';
$string['core.login.errorupdatesite'] = 'Ett fel inträffade vid uppdatering av webbplatsens token.';
$string['core.login.exceededloginattemptssupportsubject'] = 'Jag kan inte logga in';
$string['core.login.faqcannotfindmysiteanswer'] = 'Har du skrivit namnet rätt? Det är också möjligt att din webbplats inte ingår i vår offentliga webbplats-katalog. Om du fortfarande inte hittar den, ange din webbplatsadress istället.';
$string['core.login.faqcannotfindmysitequestion'] = 'Jag hittar inte min webbplats.';
$string['core.login.faqsetupsiteanswer'] = 'Besök {{$link}} för att se vilka olika alternativ du har för att skapa din egen Moodle-webbplats.';
$string['core.login.faqsetupsitelinktitle'] = 'Kom igång.';
$string['core.login.faqsetupsitequestion'] = 'Jag vill sätta upp min egna Moodle-webbplats.';
$string['core.login.faqtestappanswer'] = 'Om du vill testa appen på en Moodle Demo-webbplats skriver du "teacher" eller "student" i fältet "Din webbplats" och klickar på knappen "Anslut till din webbplats".';
$string['core.login.faqtestappquestion'] = 'Jag vill bara testa appen. Hur gör jag?';
$string['core.login.faqwhatisurlanswer'] = '<p>Varje organisation har sin egen unika adress eller URL till sin Moodle-webbplats. Så här hittar du adressen:</p><ol><li>Öppna en webbläsare och gå till inloggningssidan för Moodle-webbplatsen.</li> <li>Högst upp på sidan, i adressfältet, ser du webbadressen till din Moodle-webbplats, t.ex. "campus.example.edu". <br>{{$image}}</li><li>Kopiera adressen (kopiera inte /login och det som kommer efter) och klistra in den i Moodle-appen och klicka sedan på "Anslut till din webbplats"</li><li>Nu kan du logga in på din webbplats med ditt användarnamn och lösenord.</li></ol>';
$string['core.login.faqwhatisurlquestion'] = 'Vad är min webbplatsadress? Hur kan jag hitta min webbplats-URL?';
$string['core.login.faqwhereisqrcode'] = 'Var hittar jag QR-koden?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Om din organisation har aktiverat det hittar du en QR-kod på webbplatsen längst ned på din användarprofilsida.</p> {{$image}}';
$string['core.login.findyoursite'] = 'Hitta din webbplats';
$string['core.login.invalidaccount'] = 'Kontrollera dina inloggningsuppgifter stämmer eller be webbplatsadministratören att kontrollera webbplatsens konfiguration';
$string['core.login.invalidmoodleversion'] = '<p>Ogiltig Moodle webbplatsversion. Moodle-appen stöder bara Moodle-system version {{$a}} och senare.</p>
<p>Du kan kontakta dina webbplatsadministratörer och be dem uppdatera sitt Moodle-system.</p>
<p>"Webbplatsadministratörer" är de personer som hanterar Moodle i din organisation. Om du inte vet hur du kontaktar dem, kontakta dina lärare.</p>';
$string['core.login.invalidsite'] = 'Webbplatsadressen är ogiltig.';
$string['core.login.invalidtime'] = 'Ogiltig tid';
$string['core.login.invalidvaluemax'] = 'Maxvärdet är {{$a}}';
$string['core.login.invalidvaluemin'] = 'Lägsta värdet är {{$a}}';
$string['core.login.loginbutton'] = 'Logga in';
$string['core.login.mobileservicesnotenabled'] = 'Mobila tjänster är inte aktiverade på din webbplats. Vänligen kontakta din administratör om du tycker att mobil åtkomst ska aktiveras.';
$string['core.login.notloggedin'] = 'Du måste vara inloggad.';
$string['core.login.onboardingcreatemanagecourses'] = 'Skapa & hantera dina kurser';
$string['core.login.onboardingenrolmanagestudents'] = 'Registrera & hantera dina studenter';
$string['core.login.onboardinggetstarted'] = 'Kom igång med Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Jag har redan en Moodle-webbplats.';
$string['core.login.onboardingimalearner'] = 'Jag är student.';
$string['core.login.onboardingimaneducator'] = 'Jag är utbildare.';
$string['core.login.onboardingineedasite'] = 'Jag behöver en Moodle-webbplats';
$string['core.login.onboardingprovidefeedback'] = 'Erbjud återkoppling';
$string['core.login.onboardingtoconnect'] = 'För att ansluta till Moodle-appen behöver du en Moodle-webbplats.';
$string['core.login.onboardingwelcome'] = 'Välkommen till Moodle-appen!';
$string['core.login.or'] = 'ELLER';
$string['core.login.passwordrequired'] = 'Lösenord krävs';
$string['core.login.policyacceptmandatory'] = 'Jag är införstådd med och godkänner de obligatoriska användarvillkoren för webbplatsen';
$string['core.login.recaptchachallengeimage'] = 'reCAPTCHA bildutmaning';
$string['core.login.recaptchaexpired'] = 'Verifieringen har löpt ut. Svara på säkerhetsfrågan igen.';
$string['core.login.recaptchaincorrect'] = 'Felaktigt svar på säkerhetsfrågan.';
$string['core.login.reconnect'] = 'Återanslut';
$string['core.login.removeaccount'] = 'Ta bort konto';
$string['core.login.searchby'] = 'Sök via:';
$string['core.login.selectsite'] = 'Vänligen välj din webbplats:';
$string['core.login.signupplugindisabled'] = '{{$a}} är inte aktiverad.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Registreringsformuläret innehåller ett obligatoriskt anpassat fält som inte stöds i appen. Vänligen skapa ditt konto med hjälp av en webbläsare.';
$string['core.login.siteaddress'] = 'Din webbplats';
$string['core.login.sitebadgedescription'] = 'Det finns {{count}} olästa notiser.';
$string['core.login.sitehasredirect'] = 'Din webbplats innehåller minst en HTTP-omdirigering. Appen kan inte följa omdirigeringar. Detta kan vara det problem som hindrar appen från att ansluta till din webbplats.';
$string['core.login.siteinmaintenance'] = 'Din webbplats är i underhållsläge';
$string['core.login.sitenotallowed'] = 'Den här webbplatsen är inte längre tillgänglig.';
$string['core.login.sitepolicynotagreederror'] = 'Webbplatspolicy inte godkänd.';
$string['core.login.siteurl'] = 'Webbplatsadress';
$string['core.login.siteurlrequired'] = 'Webbplats-URL krävs, dvs <i> http://www.yourmoodlesite.abc eller https://www.yourmoodlesite.efg </ i>';
$string['core.login.stillcantconnect'] = 'Fortfarande problem att ansluta?';
$string['core.login.toggleremove'] = 'Redigera kontolistan';
$string['core.login.usernamerequired'] = 'Användarnamn krävs';
$string['core.login.visitchangepassword'] = 'Vill du gå till webbplatsen för att ändra ditt lösenord?';
$string['core.login.webservicesnotenabled'] = 'Det verkar som om webbtjänster inte har aktiverats för webbplatsen. Kontakta administratören för att få hjälp.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Du kan fortfarande ansluta till webbplatsen genom att ange ditt användarnamn och lösenord.';
$string['core.login.yourenteredsite'] = 'Anslut till din webbplats';
$string['core.lostconnection'] = 'Ditt autentiseringstoken är ogiltigt eller har förfallit. Du behöver ansluta till webbplatsen på nytt.';
$string['core.mainmenu.switchaccount'] = 'Växla konto';
$string['core.mainmenu.usermenutourdescription'] = 'Här kontrollerar du dina betyg, ändrar dina inställningar eller växlar konto.';
$string['core.mainmenu.usermenutourtitle'] = 'Utforska din personliga yta';
$string['core.needhelp'] = 'Behöver du hjälp?';
$string['core.networkerroriframemsg'] = 'Detta innehåll är inte tillgängligt offline. Vänligen anslut till internet och försök igen.';
$string['core.networkerrormsg'] = 'Det uppstod ett problem vid anslutningen till webbplatsen. Vänligen kontrollera nätverksanslutningen och försök sedan igen.';
$string['core.nooptionavailable'] = 'Inget alternativ tillgängligt';
$string['core.nopasswordchangeforced'] = 'Du kan inte fortsätta utan att byta ditt lösenord.';
$string['core.nopermissionerror'] = 'Ledsen, men du har inte behörigheter för att göra det';
$string['core.notapplicable'] = 'n/a';
$string['core.notsent'] = 'Inte skickat';
$string['core.nummore'] = '{{$a}} mer';
$string['core.openfile'] = 'Öppna fil';
$string['core.openfullimage'] = 'Klick här för att visa bilden i full storlek';
$string['core.openinbrowser'] = 'Öppna i webbläsare';
$string['core.openmodinbrowser'] = 'Öppna {{$a}} i webbläsare';
$string['core.opensecurityquestion'] = 'Öppna säkerhetsfråga';
$string['core.opensettings'] = 'Öppna inställningar';
$string['core.openwith'] = 'Öppna med…';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Spela upp';
$string['core.pulltorefresh'] = 'Dra för att uppdatera';
$string['core.qrscanner'] = 'QR-skanner';
$string['core.question.cannotdeterminestatus'] = 'Kan inte avgöra status';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Din webbplats stödjer inte bilagor i svar ännu.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Din webbplats stödjer inte redigering av infogade filer ännu.';
$string['core.question.errorquestionnotsupported'] = 'Denna frågetyp stöds inte av mobilappen: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Tryck för att välja och sedan tryck för att släppa.';
$string['core.question.questionmessage'] = 'Fråga {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Du kommer att skickas vidare till webbplatsen.';
$string['core.removefiles'] = 'Ta bort filer {{$a}}';
$string['core.requireduserdatamissing'] = 'Den här användaren saknar vissa nödvändiga profildata. Vänligen fyll i uppgifterna på din Moodle-webbplats och försök igen. <br>{{$a}}';
$string['core.resume'] = 'Återuppta';
$string['core.retry'] = 'Försök igen';
$string['core.scanqr'] = 'Skanna QR-kod';
$string['core.scrollbackward'] = 'Skrolla bakåt';
$string['core.scrollforward'] = 'Skrolla framåt';
$string['core.searching'] = 'Söker';
$string['core.settings.about'] = 'Om';
$string['core.settings.appsettings'] = 'Appinställningar';
$string['core.settings.appversion'] = 'Appversion';
$string['core.settings.cannotsyncloggedout'] = 'Den här webbplatsen kan inte synkroniseras eftersom du har loggat ut. Försök igen när du är inloggad på webbplatsen.';
$string['core.settings.cannotsyncoffline'] = 'Kan inte synkronisera offline.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Din enhet är inte ansluten till ett Wi-Fi nätverk. Anslut till ett Wi-Fi nätverk eller inaktivera Datasparläget i inställningarna.';
$string['core.settings.changelanguage'] = 'Byt till {{$a}}';
$string['core.settings.changelanguagealert'] = 'Om du byter språk kommer appen att startas om.';
$string['core.settings.colorscheme'] = 'Färgschema';
$string['core.settings.colorscheme-dark'] = 'Mörkt';
$string['core.settings.colorscheme-light'] = 'Ljust';
$string['core.settings.colorscheme-system'] = 'Systemstandard';
$string['core.settings.colorscheme-system-notice'] = 'Systemets standardläge beror på vad din enhet stödjer.';
$string['core.settings.compilationinfo'] = 'Kompileringsinformation';
$string['core.settings.connectwifitosync'] = 'Anslut till ett Wi-Fi nätverk eller inaktivera datasparläget för att synkronisera.';
$string['core.settings.copyinfo'] = 'Kopiera enhetsinformation till urklipp';
$string['core.settings.cordovadevicemodel'] = 'Cordova enhetsmodell';
$string['core.settings.cordovadeviceosversion'] = 'Cordova enhets OS-version';
$string['core.settings.cordovadeviceplatform'] = 'Cordova enhetsplattform';
$string['core.settings.cordovadeviceuuid'] = 'Cordova enhets-UUID';
$string['core.settings.cordovaversion'] = 'Cordovaversion';
$string['core.settings.debugdisplaydescription'] = 'Om aktiverat visas ytterligare felinformation i felmeddelanden.';
$string['core.settings.developeroptions'] = 'Alternativ för utvecklare';
$string['core.settings.deviceinfo'] = 'Enhetsinformation';
$string['core.settings.deviceos'] = 'Enhets-OS';
$string['core.settings.displayformat'] = 'Visningsformat';
$string['core.settings.enabledownloadsection'] = 'Aktivera nedladdning av sektioner';
$string['core.settings.enablerichtexteditor'] = 'Aktivera textredigerare';
$string['core.settings.enablerichtexteditordescription'] = 'Om aktiverat används en textredigerare vid inmatning av innehåll.';
$string['core.settings.entriesincache'] = '{{$a}} cacheposter';
$string['core.settings.estimatedfreespace'] = 'Beräknat ledigt utrymme';
$string['core.settings.filesystemroot'] = 'Filsystemrot';
$string['core.settings.fontsize'] = 'Teckenstorlek';
$string['core.settings.forcedsetting'] = 'Denna inställning har bestämts av webbplatsinställningarna.';
$string['core.settings.helpusimprove'] = 'Hjälp oss förbättra appen';
$string['core.settings.ioscookies'] = 'Spårning mellan webbplatser';
$string['core.settings.ioscookiesdescription'] = 'Inbäddat innehåll från webbplatsen kan kräva att cookies för webbplatsspårning tillåts. För att aktivera detta, vänligen gå till appens iOS-inställningar och aktivera \'Tillåt spårning mellan webbplatser\'.';
$string['core.settings.localnotifavailable'] = 'Lokala notiser tillgängliga';
$string['core.settings.locationhref'] = 'Webbvisnings-URL';
$string['core.settings.logintosync'] = 'Logga in för att synkronisera';
$string['core.settings.navigatorlanguage'] = 'Menyspråk';
$string['core.settings.navigatoruseragent'] = 'Navigator userAgent';
$string['core.settings.networkstatus'] = 'Status för internetanslutning';
$string['core.settings.opensourcelicenses'] = 'Licenser för öppen källkod';
$string['core.settings.privacypolicy'] = 'Sekretesspolicy';
$string['core.settings.publisher'] = 'Utgivare';
$string['core.settings.pushid'] = 'Pushnotifierings-ID';
$string['core.settings.reportinbackground'] = 'Rapportera fel automatiskt';
$string['core.settings.screen'] = 'Skärminformation';
$string['core.settings.showdownloadoptions'] = 'Visa nedladdningsalternativ';
$string['core.settings.siteinfo'] = 'Webbplatsinformation';
$string['core.settings.spaceusage'] = 'Utrymmesanvändning';
$string['core.settings.syncdatasaver'] = 'Datasparläge: Synkronisera endast via Wi-Fi';
$string['core.settings.synchronization'] = 'Synkronisering';
$string['core.settings.synchronizenow'] = 'Synkronisera nu';
$string['core.settings.synchronizenowhelp'] = 'Vid synkronisering av en webbplats laddas alla väntande ändringar och all offlineaktivitet som lagrats på enheten upp till webbplatsen. Dessutom synkroniseras vissa övriga data, såsom meddelanden och notiser.';
$string['core.settings.syncsettings'] = 'Synkroniseringsinställningar';
$string['core.settings.wificonnection'] = 'Wi-Fi anslutning';
$string['core.settings.youradev'] = 'Du är nu utvecklare';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Välj ett konto för att spara filen.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Det finns redan en fil med det här namnet. Vill du ersätta den befintliga filen eller byta namn på den till "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Det finns inga platser lagrade. Vänligen lägg till en webbplats innan du delar en fil med appen.';
$string['core.sharedfiles.nosharedfiles'] = 'Det finns inga delade filer på webbplatsen.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Du har inga filer att ladda upp här. Om du vill ladda upp en fil från en annan app letar du upp filen och klickar på knappen \'Öppna med\'.';
$string['core.sharedfiles.rename'] = 'Byt namn';
$string['core.sharedfiles.replace'] = 'Ersätt';
$string['core.sharedfiles.sharedfiles'] = 'Delade filer';
$string['core.sharedfiles.successstorefile'] = 'Lagringen lyckades. Välj filen som ska laddas upp till dina privata filer eller användas i en aktivitet.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Ledsen...';
$string['core.start'] = 'Starta';
$string['core.storingfiles'] = 'Lagrar filer';
$string['core.swipenavigationtourdescription'] = 'Svep vänster eller höger för att navigera runt.';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Denna etikettkategori stöds inte av appen.';
$string['core.tag.tagareabadgedescription'] = 'Det finns {{count}} objekt.';
$string['core.tag.warningareasnotsupported'] = 'Vissa etikettkategorier visas inte eftersom de inte stöds av appen.';
$string['core.thereisdatatosync'] = 'Det finns offline {{$a}} som väntar på synkronisering.';
$string['core.toggledelete'] = 'Visa/dölj Ta bort-knappar';
$string['core.tryagain'] = 'Försök igen';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Oj då!';
$string['core.unexpectederror'] = 'Oväntad fel. Stäng och öppna programmet igen för ett nytt försök.';
$string['core.unicodenotsupported'] = 'Vissa emojis stöds inte av webbplatsen. Dessa kommer tas bort när meddelandet skickas.';
$string['core.unicodenotsupportedcleanerror'] = 'Tom text hittades när Unicode-tecken städades.';
$string['core.unknown'] = 'Okänd';
$string['core.unzipping'] = 'Packar upp';
$string['core.updaterequired'] = 'En uppdatering krävs';
$string['core.updaterequireddesc'] = 'Vänligen uppdatera din app till version {{$a}}';
$string['core.user.contact'] = 'Kontakt';
$string['core.user.detailsnotavailable'] = 'Detaljerna till denna användare är inte tillgängliga för dig.';
$string['core.user.errorloaduser'] = 'Fel vid inläsning av användare.';
$string['core.user.sendemail'] = 'E-post';
$string['core.user.userwithid'] = 'Användare med ID {{id}}';
$string['core.usernologin'] = 'Inloggningen har spärrats för detta konto';
$string['core.viewcode'] = 'Visa kod';
$string['core.vieweditor'] = 'Visa redigerare';
$string['core.viewembeddedcontent'] = 'Visa inbäddat innehåll';
$string['core.warningofflinedatadeleted'] = 'Offlinedata från {{component}} \'{{name}}\' har tagits bort. {{error}}';
$string['core.warnopeninbrowser'] = '<p>Du är på väg att lämna appen för att öppna följande URL i enhetens webbläsare. Vill du fortsätta?</p>
<p><b>{{url}}</b></p>';
$string['core.whyisthishappening'] = 'Varför händer detta?';
$string['core.wsfunctionnotavailable'] = 'Webbtjänstfunktion är inte tillgänglig.';
$string['core.youreoffline'] = 'Du är offline';
$string['core.youreonline'] = 'Du är online igen';
$string['core.zoomin'] = 'Zooma in';
$string['core.zoomout'] = 'Zooma ut';
$string['pluginname'] = 'Moodle Mobil språksträngar';
