<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'sv', version '5.0'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Åtkomst nekad';
$string['accountlocked'] = 'Ditt konto har låsts. En upplåsningslänk har skickats till den e-postadress som är kopplad till ditt konto.';
$string['accounts'] = 'Konton';
$string['accountunlocked'] = 'Ditt konto har låsts upp. Du kan nu logga in nedanför.';
$string['addcategory'] = 'Lägg till en kategori';
$string['additionalhtml'] = 'Kompletterande HTML';
$string['additionalhtml_desc'] = 'Med de här inställningarna kan du ange HTML-kod som du vill lägga till på varje sida. Du kan ange HTML som ska läggas till i HEAD-taggen för sidan, omedelbart efter att BODY-taggen har öppnats eller omedelbart innan brödtexttaggen stängs. Genom detta kan du lägga till anpassade sidhuvuden eller sidfötter på varje sida eller lägga till stöd för tjänster som Google Analytics, oberoende av ditt valda tema.';
$string['additionalhtml_heading'] = 'Kompletterande HTML som ska läggas till till varje sida,';
$string['additionalhtmlfooter'] = 'Innan BODY avslutas';
$string['additionalhtmlfooter_desc'] = 'Innehåll som finns här kommer att upprepas på alla sidor straxt innan taggen för body stängs. ';
$string['additionalhtmlhead'] = 'Inom HEAD';
$string['additionalhtmlhead_desc'] = 'Innehåll här läggs till botten av HEAD taggen på varje sida.';
$string['additionalhtmltopofbody'] = 'När BODY öppnas';
$string['additionalhtmltopofbody_desc'] = 'Innehåll här kommer att läggas in på varje sida omedelbart efter den inledande body-taggen.';
$string['admincategory'] = 'Kategori: {$a}';
$string['adminseesall'] = 'Administratörer ser allt';
$string['adminseesallevents'] = 'Administratörer ser alla händelser';
$string['adminseesownevents'] = 'Administratörer är precis som andra användare';
$string['advancedfeatures'] = 'Avancerade egenskaper';
$string['agedigitalconsentverification'] = 'Digital ålder för verifiering av samtycke';
$string['agedigitalconsentverification_desc'] = 'Möjliggör verifiering av den digitala åldern för samtycke innan registreringssidan visas för användare som själva registrerar sig. Detta skyddar din webbplats från att minderåriga registrerar sig utan förälders / vårdnadshavares samtycke. <a target="_blank" href="{$a}">Supportinformation</a> ges till minderåriga för ytterligare hjälp.';
$string['ageofdigitalconsentmap'] = 'Digital ålder för samtycke';
$string['ageofdigitalconsentmap_desc'] = 'Den digitala standardåldern för samtycke och åldern i alla länder där den skiljer sig från standard kan anges här. Ange varje ålder på en ny rad med format: landskod, ålder (avgränsad med ett komma). Standardåldern anges med * i stället för landskoden. Landskoderna enligt ISO 3166-2.';
$string['allcountrycodes'] = 'Alla landskoder';
$string['allowattachments'] = 'Tillåt bilagor';
$string['allowbeforeblock'] = 'Tillåtet-listan kommer att behandlas först';
$string['allowbeforeblockdesc'] = 'Som standard kommer poster i listan över blockerade IP-adresser matchas först. Om det här alternativet är aktivt, kommer posterna i den tillåtna IP-adresslistan bearbetas före listan med blockerade IP-adresser.';
$string['allowcategorythemes'] = 'Tillåt kategoriteman';
$string['allowcohortthemes'] = 'Tillåt kohortteman';
$string['allowcoursethemes'] = 'Tillåt kursteman';
$string['allowedemaildomains'] = 'Tillåtna e-postdomäner';
$string['allowediplist'] = 'Lista över tillåtna IP-adresser';
$string['allowemailaddresses'] = 'Tillåtna e-postdomäner';
$string['allowemojipicker'] = 'Emoji-väljare';
$string['allowframembedding'] = 'Tillåt inbäddning i ramar';
$string['allowframembedding_help'] = 'Om aktiverad kan den här webbplatsen vara inbäddad i en ram på en extern webbplats, vilket t.ex rekommenderas när du använder pluginmodulen \'Publish as LTI\' för registreringar. I annat fall rekommenderas att lämna raminbäddning inaktiverad av säkerhetsskäl. Observera att för mobilappen ignoreras denna inställning och raminbäddning är alltid tillåten.';
$string['allowguestmymoodle'] = 'Tillåt gäståtkomst till Översiktssidan';
$string['allowindexing'] = 'Tillåt indexering av sökmotorer';
$string['allowindexing_desc'] = 'Detta avgör om sökmotorer ska kunna indexera webbplatsen. "Överallt" kommer att tillåta sökmotorerna att söka överallt inklusive inloggnings- och registrerings-sidor, vilket innebär att webbplatser med Force Login påslagen fortfarande indexeras. För att undvika risken att skräppost tas emot då registrerings-sidan är sökbar, använd "Överallt förutom inloggnings- och registrerings-sidor". "Ingenstans" kommer att meddela sökmotorer att inte indexera någon sida alls. Observera att detta bara är en tagg i huvudet på webbplatsen. Det är upp till sökmotorn att respektera taggen.';
$string['allowindexingeverywhere'] = 'Överallt';
$string['allowindexingexceptlogin'] = 'Överallt förutom inloggnings- och registrerings-sidor';
$string['allowindexingnowhere'] = 'Ingenstans';
$string['allowobjectembed'] = 'Tillåt EMBED- och OBJECT-taggar';
$string['allowthemechangeonurl'] = 'Tillåt ändringar av teman i URLen';
$string['allowuserblockhiding'] = 'Tillåt användarna att dölja block';
$string['allowusermailcharset'] = 'Tillåt användare att välja teckenuppsättning';
$string['allowuserswitchrolestheycantassign'] = 'Tillåt användare utan kapacitet att tilldela roller att ändå byta roller.';
$string['allowuserthemes'] = 'Tillåt användarna att välja teman';
$string['alternativefullnameformat'] = 'Alternativt fullständigt namn';
$string['alternativefullnameformat_desc'] = 'Detta definierar hur namn visas för användare med funktionsbehörigheten <code>moodle/site:viewfullnames</code> - som standard användare med rollen chef, lärare eller icke-redigerande lärare. Platshållare som kan användas är som för inställningen "Fullständigt namnformat".';
$string['always'] = 'Alltid';
$string['appearance'] = 'Utseende';
$string['aspellpath'] = 'Sökväg till aspell';
$string['authentication'] = 'Autentisering';
$string['authpreventaccountcreation'] = 'Förhindra att konto skapas vid autentisering';
$string['authpreventaccountcreation_help'] = 'När en användare autentiserar, skapas ett konto på webbplatsen automatiskt om det inte redan finns. Om en extern databas, såsom LDAP, används för autentisering och du vill begränsa åtkomsten till webbplatsen för användare med ett befintligt konto, då skall detta alternativ vara aktiverat.

Nya konton måste skapas manuellt eller via funktionen uppladdning av användare. Observera att denna inställning inte gäller MNET autentisering.';
$string['authsettings'] = 'Hantera autentisering';
$string['autolang'] = 'Identifiera språk automatiskt';
$string['autolangusercreation'] = 'Vid skapande av konto, använd användarens webbläsarspråk som deras föredragna språk';
$string['autologinguests'] = 'Logga in gäster automatiskt';
$string['availableto'] = 'Tillgänglig till';
$string['availabletoanyone'] = 'Tillgängligt för alla besökare';
$string['availabletoauthenticated'] = 'Begränsat till inloggade användare';
$string['backgroundcolour'] = 'Genomskinlig färg';
$string['backup_shortname'] = 'Använd kursnamnet i säkerhetskopians filnamn';
$string['backup_shortnamehelp'] = 'Använd kursens namn som en del i filnamnet för säkerhetskopian.';
$string['backups'] = 'Säkerhetskopior';
$string['badwordsconfig'] = 'Ange din lista över olämpliga ord separarerade med kommatecken.';
$string['badwordsdefault'] = 'Om den anpassade listan är tom kommer språkpaketets standardlista att användas.';
$string['badwordslist'] = 'Anpassad lista över olämpliga ord';
$string['blockediplist'] = 'Lista över blockerade IP-adresser';
$string['blockinstances'] = 'Instanser';
$string['blockmultiple'] = 'Flerfaldiga';
$string['blockprotect'] = 'Skydda instanser';
$string['blockprotect_help'] = 'Om du låser en viss typ av block kan ingen lägga till eller ta bort instanser av dessa. (Du kan naturligtvis låsa upp detta igen om du behöver redigera instanser.)

Detta är avsett att skydda block som navigering och inställningar som är mycket svåra att få tillbaka om de oavsiktligt raderas.';
$string['blockprotectblock'] = 'Skydda instanser av {$a}';
$string['blockprotected'] = '{$a} blockinstanser är skyddade.';
$string['blocksettings'] = 'Hantera block';
$string['blockunprotectblock'] = 'Ta bort skydd för {$a}';
$string['blockunprotected'] = '{$a} blockinstanser är oskyddade.';
$string['bloglevel'] = 'Bloggsynlighet';
$string['bookmarkadded'] = 'Bokmärke tillagt.';
$string['bookmarkalreadyexists'] = 'Du har redan bokmärkt den här sidan';
$string['bookmarkdeleted'] = 'Bokmärke borttaget.';
$string['bookmarkthispage'] = 'Bokmärk denna sida';
$string['cacheapplication'] = 'Applikationscache';
$string['cacheapplicationhelp'] = 'Cachelagrade objekt delas mellan alla användare och upphör att gälla efter en inställd livslängd.';
$string['cachejs'] = 'Cacha Javascript';
$string['cachejs_help'] = 'JavaScript-cachelagring och -komprimering förbättrar sidinläsningsprestandan avsevärt. Det rekommenderas starkt för produktionswebbplatser. Utvecklare kommer förmodligen att vilja inaktivera den här funktionen.';
$string['cacherequest'] = 'Begärans-cache';
$string['cacherequesthelp'] = 'Användarspecifik cache som upphör när begäran är slutförd. Designad för att ersätta de områden där vi använder statisk lagring.';
$string['cachesession'] = 'Sessionscache';
$string['cachesessionhelp'] = 'Användarspecifik cache som upphör när användarens session avslutas.';
$string['cachesettings'] = 'Cacheinställningar';
$string['cachetemplates'] = 'Cacha mallar';
$string['cachetemplates_help'] = 'Cachning av mallar minskar laddningstiden för sidor och är rekommenderat för produktionssajter. Utvecklare vill antagligen inaktivera denna funktion.';
$string['caching'] = 'Cachning';
$string['calendar_weekend'] = 'Helgdagar';
$string['calendarexportsalt'] = 'Salt vid kalenderexport';
$string['calendarsettings'] = 'Kalender';
$string['calendartype'] = 'Kalendertyp';
$string['calendartype_desc'] = 'Välj en förvald kalendertyp för hela webbplatsen. Inställningen kan åsidosättas i kursinställningarna eller av användare i deras personliga profil.';
$string['cannotdeletemodfilter'] = 'Du kan inte avinstallera \'{$a->filter}\' eftersom det är en del av \'{$a->module}\'-modulen.';
$string['cannotuninstall'] = '{$a} kan inte avinstalleras.';
$string['categoryemail'] = 'E-post';
$string['cfgwwwrootslashwarning'] = '<code>$CFG->wwwroot</code> är felkonfigurerad i config.php. Den innehåller ett \'/\'-tecken på slutet som måste tas bort.';
$string['cfgwwwrootwarning'] = '<code>$CFG->wwwroot</code> är felkonfigurerad i config.php. Den ska matcha den URL du använder för att visa den här sidan.';
$string['change'] = 'ändra';
$string['checkboxno'] = 'Nej';
$string['checkboxyes'] = 'Ja';
$string['checkupgradepending'] = 'Uppgradera';
$string['choosefiletoedit'] = 'Välj en fil för redigering';
$string['cleanup'] = 'Städa upp';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliexitgraceful'] = 'Avslutar kontrollerat. Vänligen vänta...';
$string['cliexitnow'] = 'Avslutar NU';
$string['cliincorrectvalueerror'] = 'Fel, värdet "{$a->value}" för "{$a->option}" är inte korrekt.';
$string['cliincorrectvalueretry'] = 'Felaktigt värde, vänligen försök igen';
$string['clistatusdisabled'] = 'Status: inaktiverad';
$string['clistatusenabled'] = 'Status: aktiverad';
$string['clistatusenabledlater'] = 'status: CLI underhållsläge kommer aktiveras på {$a}';
$string['clitypevalue'] = 'ange värde';
$string['clitypevaluedefault'] = 'ange värde. Tryck på <em>Enter</em> för att använda standardvärdet ({$a})';
$string['cliunknowoption'] = 'Ej identifierade alternativ:
  {$a}
Vänligen använd <code>--help</code> alternativet.';
$string['cliupgradecompletenomaintenanceupgrade'] = 'Så här rensar du återstående cacheminnen efter att användartrafiken har flyttats till ny kod:

<code>php admin/cli/purge_caches.php --muc</code>
<code>php admin/cli/purge_caches.php --js</code>
<code>php admin/cli/purge_caches.php --filter</code>
<code>php admin/cli/purge_caches.php --other</code>

Kör dessa kommandon var för sig för att minska belastningen på webbservern.';
$string['cliupgradedefault'] = 'Ny inställning: {$a}';
$string['cliupgradedefaultheading'] = 'Ställer in nya standardvärden';
$string['cliupgradedefaultverbose'] = 'Ny inställning: {$a->name}. Standardvärde: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Uppgradering via kommandoraden från {$a->oldversion} till {$a->newversion} slutfördes.';
$string['cliupgrademaintenancenotrequired'] = 'Denna uppgradering kommer INTE att resultera i underhållsläge för användare.';
$string['cliupgrademaintenancerequired'] = 'Denna uppgradering KOMMER resultera i underhållsläge för användare.';
$string['cliupgradenoneed'] = 'Ingen uppgradering behövs för den installerade versionen {$a}.';
$string['cliupgradepending'] = 'Det finns en väntande uppgradering';
$string['cliupgradesetlock'] = 'Uppgraderingen har låsts till enbart CLI-körning.';
$string['cliupgradeunsetlock'] = 'Befintligt CLI-körningslås har tagits bort.';
$string['cliyesnoprompt'] = 'ange <em>y</em> (betyder ja) eller <em>n</em> (betyder nej)';
$string['close'] = 'Stäng';
$string['cohort_customfield'] = 'Kohort - anpassade fält';
$string['commentsperpage'] = 'Antal kommentarer per sida';
$string['commonactivitysettings'] = 'Standardinställningar för aktiviteter';
$string['commonfiltersettings'] = 'Standardinställningar för filter';
$string['commonsettings'] = 'Standardinställningar';
$string['componentinstalled'] = 'Installerade komponenter';
$string['computedfromlogs'] = 'Beräknade från loggarna sedan {$a}.';
$string['condifmodeditdefaults'] = 'De värden du anger här definierar standardvärden som används i aktivitetsinställningarna när du skapar en ny aktivitet.';
$string['confeditorhidebuttons'] = 'Välj de knappar som ska vara dolda i HTML-redigeraren.';
$string['configallcountrycodes'] = 'Detta är en lista över länder som kan väljas på olika ställen, till exempel i en användares profil. Om det lämnas tomt (standard) i förteckningen i  countries.php används engelska språkpaketetet som standard. Detta är en lista från ISO 3166-1. Annars kan du ange en kommaseparerad lista av koder, till exempel \'GB, FR, ES\';. Om du lägger till nya, icke-standardiserade koder här, måste du lägga till dem i <code>countries.php</code> i <b>en</b>-katalogen samt i ditt egna språkpaket.';
$string['configallowassign'] = 'För varje roll i den vänstra kolumnen väljer du vilka roller som de kan tilldela andra.';
$string['configallowattachments'] = 'Om aktiverat kan bilagor (som t.ex. märken) infogas i e-postmeddelanden från webbplatsen.';
$string['configallowcategorythemes'] = 'Om du aktiverar detta då går det att ställa in teman på nivån kategorier. Detta kommer att påverka alla \'barn\'-kategorier eller kurser om det inte är så att det finns ett tema som är inställt specifikt för dem. OBS! Om du aktiverar teman för kategorier så kan det påverka systemets prestanda.';
$string['configallowcohortthemes'] = 'Om du aktiverar detta kan teman anges på kohortnivå. Detta kommer att påverka alla användare med endast en kohort eller mer än en men med samma tema.';
$string['configallowcoursethemes'] = 'Om detta är aktiverat kan kurserna ange sina egna teman. Kursteman åsidosätter alla andra temaalternativ (webbplats, användare, kategori, kohort eller URL-definierade teman).';
$string['configallowedemaildomains'] = 'Lista e-postdomäner som tillåts i "Från"-fältet i utgående e-post. Standardvärdet "Tom" kommer att använda No-reply-adressen för all utgående e-post. Användningen av jokertecken är tillåten. T.ex. kommer *.example.com att tillåta e-postmeddelanden som skickas från någon underdomän av example.com, men inte example.com själv. Detta kommer att kräva en egen post i listan.';
$string['configallowemailaddresses'] = 'Om du vill begränsa nya e-postadresser till särskilda domäner listar du dem här åtskilda av blanksteg. Alla andra domäner kommer att avvisas. Om du vill tillåta underdomäner lägger du till domänen med en föregående \'.\'. Om du vill tillåta en rotdomän tillsammans med dess underdomäner lägger du till domänen två gånger - en gång med en föregående \'.\' och en gång utan, t.ex <code>.ourcollege.edu.au</code> (med inledande \'.\') och <code>ourcollege.edu.au</code> (utan inledande \'.\').';
$string['configallowemojipicker'] = 'Emojiväljaren gör det möjligt för användare att välja emojis, till exempel smilies, att lägga till i meddelanden och andra textområden via en emojiväljare-knapp i Atto-verktygsfältet.';
$string['configallowemojipickerincompatible'] = 'Din nuvarande databaskonfiguration stöder inte emojis på korrekt sätt. För att aktivera emojiväljaren måste du <a href="https://docs.moodle.org/en/MySQL_full_unicode_support">uppgradera din databas för fullt unicode-stöd</a>.';
$string['configallowguestmymoodle'] = 'Om alternativet aktiverats kommer gäster åt Översiktssidan, annars omdirigeras gäster till webbplatsen startsida.';
$string['configallowobjectembed'] = 'Som ett standardmässigt sätt att öka säkerheten så får användare inte bädda in multimedia inne i text (som Flash t.ex.) genom att använda taggarna EMBED eller OBJECT (det går dock att ta med multimedia på ett säkert sätt med hjälp av filtret för multimedia-plugins. Om du vill tillåta dessa taggar så ska du aktivera detta alternativ.';
$string['configallowoverride'] = 'Du kan tillåta användare med rollerna på den vänstra sidan att åsidosätta några av rollerna i kolumnerna.';
$string['configallowoverride2'] = 'För varje roll i den vänstra kolumnen väljer du vilka roller som de kan ange åsidosättningar för.<br />Användare måste också ha antingen funktionsbehörigheten <code>moodle/role:override</code> eller <code>moodle/role:safeoverride</code>.';
$string['configallowswitch'] = 'För varje roll i den vänstra kolumnen väljer du vilka roller de kan växla till.<br />Användare måste också ha funktionsbehörigheten <code>moodle/role:switchroles</code>.';
$string['configallowthemechangeonurl'] = 'Om aktiverad, kan temat ändras genom att antingen lägga till:<br />?theme=temanamn till alla Moodle URL:er (tex: minmoodlesite.com/?theme=afterburner ) eller <br />&theme=temanamn till valfri intern Moodle URL (tex: minmoodlesite.com/kurs/vy.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Vill du att användare själva ska kunna välja att dölja/visa ytterkolumnerna (sidoblocken) på hela webbplatsen? Den här egenskapen använder Javascript och cookies för att komma ihåg statusen på varje ihopfällt block och detta påverkar bara det användaren själv ser.';
$string['configallowusermailcharset'] = 'Om du aktiverar detta så kommer varje deltagare på den här webbplatsen att kunna ange sin egen teckenuppsättning för e-post.';
$string['configallowuserswitchrolestheycantassign'] = 'Som standard krävs <code>moodle/role:assign</code> för att användare ska kunna byta roller. Om du aktiverar den här inställningen tas det här kravet bort och resulterar i att de roller som finns i "Byt roll till"-listrutan bestäms av inställningar i tabellen "Tillåt rolltilldelningar". Det rekommenderas att inställningarna i tabellen "Tillåt rolltilldelningar" inte tillåter användare att byta till en roll med fler funktioner än deras befintliga roll.';
$string['configallowuserthemes'] = 'Om du aktiverar detta så kommer det att bli möjligt för användare att ställa in sina egna teman. Teman för användare är giltiga över teman för webbplatsen (men inte över teman för kurser).';
$string['configallowview'] = 'För varje roll i den vänstra kolumnen väljer du vilka roller som de kan visa, söka och filtrera efter.';
$string['configallusersaresitestudents'] = 'För aktiviteter på webbplatsens startsida; bör ALLA användare betraktas som studenter?  Om du svarar "Ja" får alla bekräftade användarkonton delta som deltagare i dessa aktiviteter.  Om du svarar "Nej" kommer endast användare som redan är deltagare i minst en kurs att kunna delta i dessa aktiviteter på startsidan. Endast administratörer och särskilt tilldelade lärare kan fungera som lärare för dessa aktiviteter på startsidan.';
$string['configauthenticationplugins'] = 'Välj de autentiserings-pluginmoduler du vill använda och ordna dem i prioritetsordning.';
$string['configautolang'] = 'Identifiera standardspråket från webbläsarinställningen. Om inaktiverat används webbplatsens standardspråk.';
$string['configautolangusercreation'] = 'Om aktiverad anges användarens webbläsarspråk som önskat språk när användarens konto skapas automatiskt vid första inloggning (t.ex. med hjälp av LDAP eller OAuth 2-autentisering). Annars används standardspråket för webbplatsen som användarens önskade språk.';
$string['configautologinguests'] = 'Ska besökare automatiskt loggas in som gäster när de klickar sig in i kurser med behörighet som gäster?';
$string['configbloglevel'] = 'Den här inställningen gör det möjligt för dig att begränsa den nivå som kan användas för visning av användarbloggar på den här webbplatsen. Lägg märke till att de anger det maximala sammanhanget för DEN SOM DET VISAS FÖR och inte för den som har gjort inlägget i bloggen eller typerna av blogginlägg. Du kan även inaktivera bloggar helt och hållet om du inte alls vill ha dem.';
$string['configcalendarcustomexport'] = 'Aktivera anpassade datumintervall för export av kalender';
$string['configcalendarexportsalt'] = 'Denna slumpmässiga text används för att förbättra säkerheten av autentiseringstoken som används för export av kalendrar. Observera att alla aktuella tokens ogiltigförklaras om du ändrar det här hash saltet.';
$string['configcookiesecure'] = 'Om servern endast accepterar https-anslutningar rekommenderas att du aktiverar nedladdning av säkra cookies. Om det här alternativet är aktiverat kontrollerar du att webbservern inte accepterar http://, eller så ställer du in en permanent omdirigering till https://. Allra bäst är att dessutom skicka HSTS-headers. Om <em>wwwroot</em>-adressen inte börjar med  https:// ignoreras dessa inställningar.';
$string['configcountry'] = 'Om du väljer ett land här så kommer detta land att vara förvalt när det gäller nya användarkonton. Om du vill tvinga användare att välja ett land så lämnar du bara det här tomt.';
$string['configcoursegraceperiodafter'] = 'Klassificera tidigare kurser som pågående så här många dagar efter kursens slutdatum.';
$string['configcoursegraceperiodbefore'] = 'Klassificera framtida kurser som pågående så här många dagar före kursens startdatum.';
$string['configcourseoverviewfilesext'] = 'En kommaseparerad lista över tillåtna filändelser för kursbilder.';
$string['configcourseoverviewfileslimit'] = 'Det maximala antalet filer som kan visas bredvid kurssammanfattningen på sidan med kurslistan. Den första bildfilen som lagts till används som kursbild i kursöversikten på användarnas Översiktssida; alla ytterligare filer visas enbart på listan över kurser.';
$string['configcourserequestnotify'] = 'Skriv namnet  för användaren som skall meddelas vid nya kursfötfrågningar.';
$string['configcourserequestnotify2'] = 'Användare som ska meddelas vid en kursförfrågan. Endast användare som kan godkänna kursförfrågningar listas här.';
$string['configcoursesperpage'] = 'Mata in det antal kurser som ska visas per sida i kurslistan.';
$string['configcourseswithsummarieslimit'] = 'Det maximala antalet kurser som ska visas i en kurslista inklusive sammanfattningar innan den faller tillbaka till en enklare lista.';
$string['configcronclionly'] = 'Att köra cron från en webbläsare kan exponera privilegierad information för anonyma användare. Det är därför rekommenderat att endast köra cron från kommandoraden eller ställa in ett cron-lösenord för fjärråtkomst.';
$string['configcronremotepassword'] = 'Detta innebär att det inte kommer att gå att köra skriptet cron.php via en webbläsare utan att ange lösenordet genom att använda följande URL-format <code>
http://webbplats.exempel.com/admin/cron.php?password=opensesame
</code> Om fältet lämnas tomt kommer det inte att krävas något lösenord.';
$string['configcurlcache'] = 'Livslängd för cURL-cache i sekunder.';
$string['configcustommenuitems'] = 'Här kan du konfigurera en anpassad meny. Ange varje menyalternativ på en ny rad i formatet: menytext, en länk-URL (valfritt, inte för ett toppmenyalternativ med underobjekt), en tooltip (valfritt) och en språkkod eller kommaseparerad lista med koder (valfritt, endast för att visa raden för användare på det angivna språket), åtskilda av pipe-symboler. Rader som börjar med ett bindestreck visas som menyalternativ i den föregående toppnivåmenyn. ### utgör en avdelare. Till exempel:
<pre>
Kurser
-Alla kurser|/course/
-Kurssökning|/course/search.php
-###
-Vanliga frågor|https://example.org/faq
-Preguntas más frecuentes|https://example.org/pmf|| Es
Mobilapp|https://example.org/app| Ladda ner vår app
</pre>';
$string['configcustomusermenuitems'] = 'Du kan konfigurera innehållet i användarmenyn (med undantag för länken logga ut, som läggs till automatiskt). Varje rad avgränsas med pipe-tecken och består av
1) en sträng i "langstringname, componentname"-format eller som oformaterad text,
2) en URL.
Avdelare kan användas genom att lägga till en rad med ett eller flera <kbd>#</kbd>-tecken där så önskas.';
$string['configdbsessions'] = 'Om aktiverat kommer den här inställningen att använda databasen för att lagra information om aktuella sessioner. Observera att en ändring av denna inställning kommer att logga ut alla nuvarande användare (inklusive dig). Om du använder MySQL, vänligen se till att \'max_allowed_packet\' i my.cnf (eller my.ini) är minst 4M. Andra sessionsdrivrutiner kan konfigureras direkt i config.php, se config-dist.php för mer information. Det här alternativet försvinner om du anger en sessionsdrivrutin i config.php fil.';
$string['configdebug'] = 'Om du aktiverar det här så utökar du PHP:s felrapportering. Systemet ger då ifrån sig fler varningar. Detta är av värde bara för utvecklare.';
$string['configdebugdisplay'] = 'Om detta är inaktiverat kommer felrapporteringen att ske via en HTML-sida. Detta är praktiskt men XHTML, JS, cookies och HTTP headers
fungerar i allmänhet inte med detta. Om detta är inaktiverat så kommer utdata att skickas till loggarna för Din server, vilket erbjuder bättre felsökning. Inställningen \'error_log\' i PHP styr vilken logg detta går till.';
$string['configdebugpageinfo'] = 'Aktivera detta om du vill att sidinformation ska skrivas ut i sidfoten.';
$string['configdebugvalidators'] = 'Aktivera om du vill ha länkar till externa valideringsservrar i sidfoten. Du kan behöva skapa nya användare med användarnamn <em>w3cvalidator</em> och aktivera gästaccess. Dessa förändringar kan ge obehöriga åtkomst till servern, använd inte detta på färdiga webbplatser!';
$string['configdefaulthomepage'] = 'Vilken sida ska användarna omdirigeras till efter att ha loggat in på webbplatsen? Inställningen bestämmer också den första länken i navigeringen för användare som valt att använda klassiska teman.';
$string['configdefaultrequestcategory'] = 'Kurser som efterfrågas av användare med möjlighet att begära nya kurser i systemkontexten kommer att placeras i denna kategori om inte användarna kan välja en annan kategori.';
$string['configdefaultrequestedcategory'] = 'Standardkategori att sätta kurser som efterfrågades i, om de är godkända.';
$string['configdefaultuserroleid'] = 'Alla inloggade användare kommer att tilldelas de funktionsbehörigheter som ingår i den roll du anger här, på webbplatsnivån, TILLSAMMANS med vilken annan roll som helst som de kan ha tilldelats. Det förinställda standardvalet  är autenticerad användare (eller \'gäst\' i äldre versioner). Lägg märke till att detta inte kommer att stå i konflikt med andra roller de kan ha. Det säkerställer bara att alla användare har funktionsbehörigheter som inte går att tilldela på kursnivå (inlägg i bloggar, administration av egen kalender osv).';
$string['configdeleteincompleteusers'] = 'Efter denna period tas alla konton utan förnamn, efternamn eller e-postfält i ifyllt bort.';
$string['configdeleteunconfirmed'] = 'För vissa autentiseringsmetoder, till exempel e-postbaserad självregistrering, måste användarna bekräfta sitt konto inom en viss tid. Efter denna period tas alla gamla obekräftade konton bort.';
$string['configdenyemailaddresses'] = 'Om du vill avvisa e-postadresser från specifika domäner så listar du dem här på samma sätt. Alla andra domäner kommer att accepteras. Ett exempel:
<strong>hotmail.com yahoo.co.uk</strong>';
$string['configdisableuserimages'] = 'Inaktivera möjligheten för användare att ändra bilder i användarprofilerna.';
$string['configdisplayloginfailures'] = 'Detta visar information för användare om tidigare misslyckade inloggningar.';
$string['configdndallowtextandlinks'] = 'Aktivera eller inaktivera dra och släppa av text och länkar på en kurssida, vid sidan av att dra och släppa filer. Observera att släpa på text i Firefox eller mellan olika webbläsare är opålitlig och kan resultera i att inga data laddas upp, eller felaktig text laddas upp.';
$string['configdoclang'] = 'Detta språk kommer att användas i länkar för dokumentationen.';
$string['configdocroot'] = 'Definierar sökvägen till Moodle Docs som tillhandahåller kontextspecifik dokumentation via <em>\'Hjälp och dokumentation\'</em>-länkar i sidfoten på varje sida. Om fältet lämnas tomt visas inga länkar.';
$string['configdoctonewwindow'] = 'Om aktiverat visas länkarna till Moodle Docs i ett nytt fönster.';
$string['configduration_high'] = 'Detta värde är för högt. Högsta värde är {$a}.';
$string['configduration_low'] = 'Detta värde är för lågt. Lägsta värde är {$a}.';
$string['configeditordictionary'] = 'Det här värdet kommer att användas om det inte finns någon stavningskontroll för aspell på användarens eget språk.';
$string['configeditorfontlist'] = 'Välj de typsnitt som ska visas i redigerarens nedrullningsmeny.';
$string['configemailchangeconfirmation'] = 'Kräv en e-postbekräftelse när användarna ändrar sin e-postadress i sin profil.';
$string['configemaildkimselector'] = 'DKIM-väljaren är godtycklig och din/dina DNS-post(er) måste matcha detta.';
$string['configemailfromvia'] = 'Lägg till via-information i avsnittet "Från" i utgående e-post. Detta informerar mottagaren varifrån detta e-postmeddelande kom ifrån och hjälper också till att bekämpa mottagare som av misstag svarar på no-reply e-postadresser.';
$string['configemailheaders'] = 'Omodifierade e-post headers som ska läggas till ordagrant till all utgående e-post.';
$string['configemailsubjectprefix'] = 'Text som ska läggas som prefix i ämnesraden för all utgående e-post.';
$string['configenableanalytics'] = 'Analysmodeller, såsom \'Elever som riskerar att hoppa av\', eller  \'Kommande aktiviteter som förfaller\' kan generera förutsägelser, skicka aviseringar om nya insikter samt erbjuda vidare åtgärder, som t.ex. skicka meddelanden till användare.';
$string['configenableblogs'] = 'Detta alternativ ger alla användare av webbplatsen tillgång till en egen blogg.';
$string['configenablecalendarexport'] = 'Aktivera export av och prenumeration på kalendrar.';
$string['configenablecomments'] = 'Aktivera kommentarer';
$string['configenablecourserequests'] = 'Om aktiverad har användare med funktionsbehörigheten <code>moodle/course:request</code> möjlighet att begära nya kurser. Den här funktionsbehörigheten tillåts inte för någon av standardrollerna. Den kan tillämpas på system- eller kategorikontext.';
$string['configenablemobilewebservice'] = 'Aktivera mobiltjänsten för den officiella Moodleappen, eller annan app som begär det. För mer information, se {$a}';
$string['configenablerssfeeds'] = 'Om det är aktiverat genereras RSS-flöden av olika funktioner webbplatsen som till exempel bloggar, forum, databasaktiviteter och ordlistor. Observera att RSS-flöden också måste aktiveras för de specifika aktivitetsmodulerna.';
$string['configenablerssfeedsdisabled'] = 'Detta är inte tillgängligt eftersom RSS-flödena är inaktiverade på hela webbplatsen. För att aktivera dem behöver du gå till <em>Hantera webbplats &#10132; Avancerade egenskaper</em>.';
$string['configenablerssfeedsdisabled2'] = 'RSS-flöden är inaktiverade på servernivå. Du måste först aktivera dem under <em>Hantera webbplats &#10132; Avancerade egenskaper</em>';
$string['configenablestats'] = 'Om du väljer \'ja\' här kommer Moodles cron-jobb bearbeta loggarna och samla in statistik. Beroende på mängden trafik på din webbplats kan detta ta en stund. Om du aktiverar detta kommer du kunna se intressanta grafer och statistik för var och en av dina kurser, eller på en webbplatsövergripande basis.';
$string['configenabletrusttext'] = 'Som standard kommer Moodle alltid att rensa text som kommer från användare för att ta bort eventuella dåliga skript, media etc som kan vara en säkerhetsrisk. Systemet för tillförlitligt innehåll är ett sätt att ge vissa användare som du litar på möjligheten att inkludera dessa avancerade funktioner i innehållet utan störningar. Om du vill aktivera det här systemet måste du först aktivera den här inställningen och sedan ge behörigheten <em>Lita på inskickat innehåll</em> till en viss Moodle-roll. Texter som skapas eller laddas upp av sådana användare markeras som betrodda och kommer inte att rensas före visning.';
$string['configenablewebservices'] = 'Webbtjänster gör det möjligt för andra system, till exempel Moodle-appen, att logga in på webbplatsen och utföra åtgärder. För extra säkerhet ska inställningen inaktiveras om du inte använder appen, eller ett externt verktyg/tjänst som kräver integrering via webbtjänster.';
$string['configenablewsdocumentation'] = 'Aktivera automatisk generering av dokumentation för webbtjänster. En användare kan få tillgång till sin egen dokumentation på sidan med säkerhetsnycklar ({$a}). Den visar endast dokumentation för de aktiverade protokollen.';
$string['configerrorlevel'] = 'Välj det antal PHP-varningar som du vill låta visas. \'Normalt\' är vanligtvis det bästa valet.';
$string['configexportlookahead'] = 'Dagar att se framåt under export';
$string['configexportlookback'] = 'Dagar att se tillbaka under export';
$string['configextendedusernamechars'] = 'Om det är aktiverat kan användarnamn inkludera alla teckentyper, utom versaler. I annat fall tillåts endast alfanumeriska tecken med gemener, understreck (_), bindestreck (-), punkt (.) och snabel-a (@).';
$string['configextramemorylimit'] = 'Vissa skript såsom sökningar, säkerhetskopieringar, återställningar eller cron kräver mer minne. Ställ in högre värden för stora webbplatser.';
$string['configfilterall'] = 'Filtrera alla strängar inklusive rubriker, navigationsrader osv. Detta är som mest användbart när du använder multilang filtret. I andra fall kommer det att belasta din server utan att tillföra så mycket.';
$string['configfiltermatchoneperpage'] = 'Automatiska filter för länkning kommer bara att skapa en enskild länk för den instansen av en matchande text som hittas på den kompletta sidan. Allt annat ignoreras.';
$string['configfiltermatchonepertext'] = 'Automatiska länkfilter genererar bara en enda länk för den första matchande textförekomsten som finns i varje textobjekt på sidan. Alla andra ignoreras. Den här inställningen har ingen effekt om "Filtermatchning en gång per sida" är aktiverat.';
$string['configfilternavigationwithsystemcontext'] = 'Normal användning av filtreringen är knuten till det sammanhang där den används (t.ex. kurskontext), men för webbplatsnavigeringen kan det uttryckligen leda till prestandaförbättringar om du filtrerar allt i webbplatskontexten när du använder filtrering av "innehåll och rubriker".';
$string['configfilteruploadedfiles'] = 'Om du aktiverar detta så kommer Moodle att bearbeta alla uppladdade HTML- och textfiler genom dessa filter innan de visas.';
$string['configforcelogin'] = 'Normalt kan webbplatsens startsida och kurslistorna (men inte kurserna) ses av personer utan att logga in på webbplatsen. Om du vill tvinga personer att behöva logga in innan de överhuvudtaget kan göra NÅGOT på webbplatsen bör du aktivera den här inställningen.';
$string['configforceloginforprofiles'] = 'Den här inställningen tvingar personer att logga in med ett verkligt (icke-gäst) konto innan de kan se någon användares profil. Om du inaktiverat den här inställningen kan du upptäcka att vissa användare lägger upp reklam (skräppost) eller annat olämpligt innehåll i sina profiler, som sedan är synligt för hela världen.';
$string['configfrontpage'] = 'De objekt som väljs ovan kommer att visas på webbplatsens startsida.';
$string['configfrontpagecourselimit'] = 'Maximalt antal kurser';
$string['configfrontpagecourselimithelp'] = 'Maximalt antal kurser som ska visas i kurslistorna på webbplatsens startsida.';
$string['configfrontpageloggedin'] = 'De objekt som väljs ovan kommer att visas på webbplatsens startsida när en användare är inloggad.';
$string['configfullnamedisplay'] = 'Detta definierar hur namn visas när de visas i sin helhet. Standardvärdet, "language", låter strängen "fullnamedisplay" i det aktuella språkpaketet avgöra visningsformatet. Vissa språk har andra namnvisningskonventioner.

För de flesta enspråkiga webbplatser är den mest effektiva inställningen "förnamn efternamn", men du kan välja att dölja efternamn helt och hållet. Platshållare som kan användas är: förnamn, efternamn, fonetiskt förnamn, fonetiskt efternamn, mellannamn och alternativnamn.';
$string['configgeoipfile'] = 'Plats för binär GeoLite2 City-datafil. Denna fil är inte en del i Moodle-distributionen och måste erhållas separat från <a href="https://www.maxmind.com/">MaxMind</a>. Du kan antingen köpa en kommersiell version eller använda gratisversionen. Du måste registrera dig för att ladda ner City-databasfilen, vilket du kan göra på <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. När du har registrerat och hämtat filen extraherar du den till katalogen <em>"{$a}"</em> på servern.';
$string['configgetremoteaddrconf'] = 'Om servern ligger bakom en omvänd proxy kan du använda den här inställningen för att ange vilka HTTP-headers som betros innehålla fjärr IP-adressen. Rubrikerna läses i turordning med hjälp av den första som är tillgänglig.';
$string['configgradebookroles'] = 'Den här inställningen låter dig specificera vem som visas i betygsboken. Användare behöver ha åtminstone en av dessa roller i en kurs för att de ska visas i betygsboken för den kursen.';
$string['configgradeexport'] = 'Välj vilka exportformat för betygsbok som är dina primära metoder för att exportera betyg. Valda plugins kommer då att ställas in och använda ett "senast exporterat"-fält för varje betyg. Detta kan leda till att exporterade poster identifieras som "nya" eller "uppdaterade". Om du inte är säker på detta sedan lämna allting omarkerat.';
$string['confighiddenuserfields'] = 'Välj vilka användarfält du önskar dölja för andra användare än kurslärare/administratörer. Detta kommer att öka elevernas integritet. Håll CTRL-tangenten för att markera flera fält.';
$string['configidnumber'] = 'Den här valmöjligheten specificerar följande: (a)Användarnas ska inte alls behöva ange ID-nummer (b) Användarna kan ange ID-nummer eller avstå från det (c) Användarna måste ange ID-nummer. Om användaren anger sitt ID-nummer så visas det i dennes Presentation.';
$string['configintro'] = 'På denna sida kan du ange ett antal konfigurationsvariabler som hjälper Moodle att fungera tillfredställande på din server. Bekymra dig inte så mycket om det - standardvalen brukar fungera bra och du kan alltid återvända senare till denna sida för att ändra inställningarna.';
$string['configintroadmin'] = 'På den här sidan kan du konfigurera webbplatsens administratörskonto. En administratör har fullständig kontroll över webbplatsen. Se till att du anger ett säkert användarnamn och lösenord liksom en giltig e-postadress. Du kan skapa ytterligare administratörskonton senare.';
$string['configintrosite'] = 'På den här sidan kan du konfigurera startsidan och namnet på den nya webbplatsen. Du kan komma tillbaka hit senare och ändra dessa inställningar. Använd administrationsmenyerna.';
$string['configiplookup'] = 'När du klickar på en IP-adress (som t.ex. 34.12.222.93), som i loggarna så kommer du att få se en karta med en kvalificerad gissning om var denna IP finns geografiskt. Det finns olika pluginmoduler för det här som du kan välja bland, vart och ett har sina för- och nackdelar.';
$string['configkeeptagnamecase'] = 'Markera för att behålla stora och små bokstäver så som de skrevs in av användaren';
$string['configlang'] = 'Välj ett standardspråk för hela webbplatsen. Användare kan åsidosätta den här inställningen med hjälp av språkmenyn eller inställningen i sin personliga profil.';
$string['configlanglist'] = 'Om det lämnas tomt visas alla språk som är installerade på webbplatsen i språkmenyn. Alternativt kan språkmenyn förkortas genom att ange en lista över språkkoder, åtskilda av kommatecken, t.ex. en,de,fr. Om så önskas kan ett annat språknamn än språkpaketets namn anges med formatet: språkkod|språknamn t.ex. <code>en_kids| English, de_kids| Deutsch</code>.';
$string['configlangmenu'] = 'Välj om du vill visa den allmänna språkmenyn på startsidan, inloggningssidan etc.  Detta påverkar inte användarens möjlighet att ange önskat språk i sin egen profil.';
$string['configlangstringcache'] = 'Cachelagrar alla språksträngar i kompilerade filer i datakatalogen. Om du översätter Moodle eller byter strängar i Moodle-källkoden så kanske du vill stänga av detta. Annars lämna det på för att få prestandafördelar.';
$string['configlatinexcelexport'] = 'Väljer teckenuppsättning vid export av Excel';
$string['configlocale'] = 'Välj ett webbplatsövergripande språk. Detta åsidosätter datumformat och -språk för alla språkpaket (även om namn på veckodagar i kalendern inte påverkas). Stöd för den här språkinställningen måste vara konfigurerat för ditt operativsystem (t.ex. för Linux <em>sv_SE.UTF-8</em> eller <em>en_US.UTF-8</em>). I de flesta fall bör det här fältet lämnas tomt.';
$string['configlockrequestcategory'] = 'Om aktiverad kommer användare med möjlighet att begära nya kurser i på systemnivå inte att kunna välja en kategori i formuläret för begäran om ny kurs. Ett alternativt sätt att begränsa användarna till att begära en ny kurs i bara en kategori är att tillämpa möjligheten att begära nya kurser i kategorisammanhang.';
$string['configloglifetime'] = 'Detta specificerar hur länge du vill spara loggar om användarnas aktiviteter. Loggar som är äldre än så raderas automatiskt. Det bästa är att spara loggarna så länge som möjligt ifall du skulle behöva dem. Om du emellertid har en hårt belastad server och får problem med dess prestanda kanske du måste ta bort loggar för att spara systemresurser. Värden som är lägre än 30 rekommenderas inte eftersom statistiken kanske inte fungerar som den ska då.';
$string['configlookahead'] = 'Dagar att se framåt';
$string['configmailnewline'] = 'De tecken för ny rad som används i e-postmeddelanden. CRLF krävs i enlighet med RFC 822bis, en del e-postservrar konverterar automatiskt från LF till CRLF,  andra e-postservrar gör en felaktig konvertering från CRLF till CRCRLF, medan åter andra avvisar e-post med bara LF (t.ex. qmail). Försök att ändra denna inställning om du får problem med icke levererade e-postmeddelanden eller dubbla radmatningar.';
$string['configmaxbytes'] = 'Detta anger en maximal storlek för filer som laddas upp till webbplatsen. Denna inställning är begränsad av PHP-inställningen <code>post_max_size</code> och <code>upload_max_filesize</code>, samt Apache-inställningen <code>LimitRequestBody</code>. Därutöver begränsar maxbytes det storleksintervall som kan väljas på kurs- eller aktivitetsnivå. Om \'Uppladdningsgräns Webbplats\' väljs kommer den maximala storlek som tillåts av servern att användas.';
$string['configmaxconsecutiveidentchars'] = 'Lösenorden får inte ha mer än detta antal på varandra följande identiska tecken. Använd 0 för att inaktivera den här kontrollen.';
$string['configmaxeditingtime'] = 'Detta anger den tid som folk har på sig att redigera om sina foruminlägg, kommentarer i ord- och begreppslistor etc. Vanligtvis är 30 minuter tillräcklig tid.';
$string['configmaxevents'] = 'Händelser framåt';
$string['configmaxusersperpage'] = 'Maximalt antal användare som visas inom användarväljaren i kurs, grupp, korhort, webservice mm.';
$string['configmessaging'] = 'Om aktiverad kan användare skicka meddelanden till andra användare på denna webbplats.';
$string['configmessagingallowemailoverride'] = 'Tillåt att aviseringar om nya meddelanden skickas till annan e-postadress än den som angivits i användarens profil.';
$string['configmessagingallusers'] = 'Om aktiverad kan användare se listan över alla användare på webbplatsen när de väljer någon att skicka meddelanden till. Användarens meddelandeinställningar behöver också innehålla alternativet att acceptera meddelanden från vem som helst på webbplatsen. Om inaktiverat kan användarna bara se listan över användare i sina kurser, och de har bara två alternativ i meddelandeinställningarna - att acceptera meddelanden från sina kontakter, eller,  deras kontakter och vem som helst i deras kurser.';
$string['configmessagingdefaultpressenter'] = 'Huruvida \'Använd Returtangenten för att skicka\' är aktiverat som standard i användarnas meddelandeinställningar.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Lästa och olästa meddelanden kan tas bort för att spara utrymme. Hur lång tid efter det att en avisering har skapats kan den tas bort?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Notiser som är lästa kan tas bort för att spara utrymme. Hur lång tid efter det att en notis har lästs kan det tas bort?';
$string['configminpassworddigits'] = 'Lösenord måste ha åtminstone så här många siffror.';
$string['configminpasswordlength'] = 'Lösenord måste innehålla åtminstone så här många tecken.';
$string['configminpasswordlower'] = 'Lösenord måste innehålla åtminstone så här många små bokstäver.';
$string['configminpasswordnonalphanum'] = 'Lösenord måste innehålla åtminstone så här många icke alfanumeriska tecken.';
$string['configminpasswordupper'] = 'Lösenord måste innehålla åtminstone så här många stora bokstäver.';
$string['configmypagelocked'] = 'Denna inställning förhindrar standardsidan från att redigeras av  icke-administratörer';
$string['confignavcourselimit'] = 'Begränsar antalet kurser som visas för användaren i navigeringsmenyn.';
$string['confignavshowallcourses'] = 'Den här inställningen avgör om användare som är registrerade på kurser kan se avsnittet <em>Kurser</em> (visar samtliga kurser) i navigeringen förutom avsnittet <em>Mina kurser</em> (visar kurser de är registrerade på).';
$string['confignavshowcategories'] = 'Visa kurskategorier i navigeringsmenyn och -blocken. Detta gäller inte för kurser som användaren redan är registrerad på. Dessa kommer fortfarande visas under <em>Mina kurser</em> utan kategorier.';
$string['confignoreplyaddress'] = 'E-postmeddelanden skickas ibland på uppdrag av en användare (t.ex. ett inlägg i ett forum). Den e-postadress som du anger här kommer att användas som "Från" adress i de fall då mottagarna inte ska kunna svara direkt till användaren (t.ex. då användaren väljer att inte uppge sin e-postadress):';
$string['confignotifyloginfailures'] = 'Skicka meddelanden om inloggningsfel till dessa användare. Detta kräver att ett internt logglager (t.ex. Standardloggen) aktiveras.';
$string['confignotifyloginthreshold'] = 'Om notering av misslyckade inloggningar är aktiverat - hur många sådana försök av en användare från en IP-adress ska det till för att det ska vara värt att göra någon uppmärksam på det?';
$string['confignotloggedinroleid'] = 'Användare som inte är inloggade på webbplatsen kommer att behandlas som om de har beviljats den här rollen i webbplatsens kontext. Gäst är nästan alltid det du vill ange här, men du kanske vill skapa roller som är mindre eller mer restriktiva. Saker som att skapa inlägg kräver fortfarande att användaren loggar in på riktigt.';
$string['configopentowebcrawlers'] = 'Om du aktiverar den här inställningen kommer sökmotorer att tillåtas att nå din webbplats som gäst. Dessutom kommer personer som kommer in på din webbplats via en sökmotor automatiskt att vara inloggad som gäst. Observera att detta endast ger transparent åtkomst till kurser som redan tillåter gäståtkomst.';
$string['configoverride'] = 'Definierad i config.php';
$string['configpasswordpolicy'] = 'Om aktiverad, kommer användarlösenord kontrolleras mot lösenordpolicyn som anges i inställningarna nedan. Om du aktiverar lösenordspolicyn påverkas inte befintliga användare förrän de bestämmer sig för att, eller är skyldiga att, ändra sitt lösenord eller inställningen \'Kontrollera lösenord vid inloggning\' aktiverat.';
$string['configpasswordpolicycheckonlogin'] = 'Om aktiverad kommer användarens lösenord kontrolleras mot lösenordspolicyn varje gång användare loggar in. Om kontrollen misslyckas kommer användaren att tvingas uppdatera sitt lösenord. Det är användbart att aktivera den här inställningen efter uppdatering av lösenordspolicyn.';
$string['configpasswordresettime'] = 'Detta anger den tidsperiod användare har för att validera lösenord efter att ha begärt återställning av lösenord. 30 minuter är vanligtvis ett bra värde.';
$string['configpathtodu'] = 'Sökväg till du. Antagligen något i stil med /usr/bin/du. Om du matar in detta så kommer sidor som visar innehåll i kataloger att köras mycket fortare för kataloger med många filer.';
$string['configpathtophp'] = 'Om sökvägen är angiven är det möjlig att köra PHP-skript via administratörens webbgränssnitt.';
$string['configperfdebug'] = 'Om du aktiverar det här så kommer info om prestanda att skrivas ut i sidfoten på standardtemat.';
$string['configprofileroles'] = 'Roller som listas i användarprofiler och på deltagarsidan.';
$string['configprofilesforenrolledusersonly'] = 'För att förhindra missbruk av spammare, är profilbeskrivningar av användare som ännu inte registrerats i någon kurs gömda. Nya användare måste registrera sig i minst en kurs innan de kan lägga till några personliga uppgifter.';
$string['configprotectusernames'] = 'Om det här alternativet är aktiverat visas inga ledtrådar för användarnamn eller e-postadresser i formuläret för lösenordsåterställning.';
$string['configproxybypass'] = 'Kommaseparerad lista med (partiella) domännamn eller IP-adresser som ska kringgå proxy (t.ex. 192,168.,. Mydomain.com)';
$string['configproxyfixunsafe_help'] = 'Detta försöker fixa interna anrop som inte går via proxyn genom att lägga till MoodleBot-användaragenten och använda proxyn.';
$string['configproxyhost'] = 'Om den här <b>servern</b> måste använda en proxyserver (t.ex. en brandvägg) för att komma åt internet, ange då namnet på proxyservern här. Annars lämnar du fältet tomt.';
$string['configproxylogunsafe_help'] = 'Detta försöker logga interna anrop som inte går via proxyn men som borde göra det.';
$string['configproxypassword'] = 'Lösenord som behövs för att få tillgång till Internet via proxy om en sådan krävs. Lämna tomt om det inte krävs (PHP cURL-tillägget behöver vara konfigurerat).';
$string['configproxyport'] = 'Om servern behöver använda en proxyserver, ange då proxyporten här.';
$string['configproxytype'] = 'Typ av webbproxy (PHP5 och cURL-tilläggrt krävs för SOCKS5-stöd).';
$string['configproxyuser'] = 'Användarnamn som behövs för att få tillgång till Internet via proxy om en sådan krävs. Lämna tomt om det inte krävs (PHP cURL-tillägget behöver vara konfigurerat).';
$string['configrecaptchaprivatekey'] = 'Teckensträng (hemlig nyckel) som används för att kommunicera mellan Moodle-servern och recaptcha-servern. ReCAPTCHA-nycklar kan erhållas från <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Teckensträng (webbplatsnyckel) som används för att visa reCAPTCHA-elementet i registreringsformuläret och webbplatssupportformuläret. ReCAPTCHA-nycklar kan erhållas från <a target ="_blank" href = "https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'Ord för "student" i den begärda kursen';
$string['configrequestedstudentsname'] = 'Ord för "studenter" i den begärda kursen';
$string['configrequestedteachername'] = 'Ord för kursansvarig, lärare, handledare, coach, mentor i den begärda kursen';
$string['configrequestedteachersname'] = 'Ord för lärare (i plural) i kurserna';
$string['configreverseproxyignore'] = 'Om din server ligger bakom flera omvända proxyservrar som lägger till i X-Forwarded-For-headern anger du en kommaseparerad lista över IP-adresser eller undernät med de omvända proxyservrar som ska ignoreras för att hitta användarens korrekta IP-adress.';
$string['configsectioninterface'] = 'Gränssnitt';
$string['configsectionmail'] = 'E-post';
$string['configsectionmaintenance'] = 'Underhåll';
$string['configsectionmisc'] = 'Övrigt';
$string['configsectionoperatingsystem'] = 'Operativsystem';
$string['configsectionpermissions'] = 'Behörigheter';
$string['configsectionrequestedcourse'] = 'Begäran om kurs';
$string['configsectionsecurity'] = 'Säkerhet';
$string['configsectionstats'] = 'Statistik';
$string['configsectionuser'] = 'Användare';
$string['configsecureforms'] = 'Moodle kan använda ytterligare en säkerhetsnivå när systemet tar emot data från ett formulär. Om detta är aktiverat så jämförs webbläsarens variabel HTTP_REFERER med det aktuella formulärets adress. I några enstaka fall kan det ge upphov till problem om användaren utnyttjar en brandvägg (t.ex. Zonealarm) som är inställd på att ta bort HTTP_REFERER från sin webbtrafik,. Symptom på detta är att man "fastnar" på ett formulär. Om dina användare har problem med loginsidan så kanske du vill inaktivera den här inställningen även om det öppnar din sajt för lösenordsattacker. Om du är tveksam så är det bäst att låta inställningen \'Ja\' vara kvar.';
$string['configservicespage'] = 'Ange webbadressen till en service- och supportsida eller lämna tomt för att länka till Moodle-tjänster på moodle.com.';
$string['configsessioncookie'] = 'Den här inställningen anpassar namnet på den cookie som används för Moodle-sessioner. Detta är valfritt och endast användbart om man vill undvika att cookies förväxlas med varandra när det finns mer än en instans av Moodle på samma webbplats.';
$string['configsessioncookiedomain'] = 'Detta gör att du kan ändra domänen som Moodle-cookies är tillgängliga från. Detta är användbart om Moodle-anpassningar (t.ex. autentiserings- eller kursregistrerings-plugins) behöver dela Moodle-sessionsinformation med ett webbprogram på en annan underdomän.
<strong>VARNING: Det rekommenderas bestämt att låta den här inställningen vara inställd med sitt standardvärde (tom). Ett felaktigt värde kommer att förhindra alla inloggningar till webbplatsen.</strong>';
$string['configsessioncookiepath'] = 'Om du behöver ändra var webbläsarna skickar Moodle-cookies kan du ändra den här inställningen för att ange en underkatalog på webbplatsen. Annars bör standardinställningen \'/\' fungera bra.';
$string['configsessiontimeout'] = 'Om personer som är inloggade på denna webbplats är inaktiva under en lång period (utan att ladda några sidor) loggas de automatiskt ut (deras session avslutas). Den här variabeln anger hur lång den här perioden ska vara.';
$string['configsessiontimeoutwarning'] = 'Om personer som är inloggade på denna webbplats är inaktiva under en lång period (utan att ladda några sidor) får de en varning om att deras session är på väg att avslutas. Den här variabeln anger hur lång den här perioden ska vara.';
$string['configsessiontimeoutwarningcheck'] = 'Sessionsvarnings-timeouten måste vara lägre än sessionstimeouten.';
$string['configshowcommentscount'] = 'Visa kommentarsräkning, det kommer kosta ytterligare en databasfråga vid visning av kommentarslänk';
$string['configshowicalsource'] = 'Visa källinformation för iCal händelser';
$string['configshowsiteparticipantslist'] = 'Alla dessa studenter och lärare kommer att finnas med på listan över deltagare på webbplatsen. Vem ska har rätt att se denna lista?';
$string['configsitedefaultlicense'] = 'Standardlicens för webbplatsen';
$string['configsitedefaultlicensehelp'] = 'Standardlicensen för att publicera innehåll på den här webbplatsen.';
$string['configsitemailcharset'] = 'Alla e-postmeddelanden som skapas av din webbplats kommer att sändas med den teckenuppsättning som du anger här. Varje enskild användare kommer att kunna ändra detta om du aktiverar nästa inställning.';
$string['configsitemaxcategorydepth'] = 'Maximalt kategoridjup';
$string['configsitemaxcategorydepthhelp'] = 'Detta anger det maximala djupet för underordnade kategorier som expanderats när kategorier eller kombinationslista visas. Kategorier på djupare nivå visas som länkar och användaren kan utöka dem genom en AJAX-förfrågan.';
$string['configslasharguments'] = '\'Slash arguments\' (<em>PATH_INFO</em>) krävs för att SCORM-paket och flerfilsresurser ska visas korrekt. Om din webbserver inte stöder \'slash arguments\' och du inte kan ställa in detta kan denna inställning inaktiveras även om det kommer att resultera i att saker inte fungerar.<br />Observera: Användning av \'slash arguments\' kommer att krävas i framtida versioner av Moodle.';
$string['configsmtpauthtype'] = 'Detta anger autentiseringstypen som ska användas för SMTP-servrar.';
$string['configsmtphosts'] = 'Ange fullständigt namn på en eller flera lokala SMTP-servrar som Moodle skall använda för att sända e-post (t.ex. \'mail.a.com\' eller \'mail.a.com;mail.b.com\'). För att ange en icke-standardport (t ex en annan än port 25) så kan du använda syntaxen [server]:[port] (t ex \'mail.a.com:537\'. Om du lämnar det tomt, kommer Moodle att använda standardmetoden för PHP att skicka e-post.';
$string['configsmtpmaxbulk'] = 'Maximalt antal meddelanden som kan skickas per SMTP session. Att gruppera meddelanden kan höja hastigheten på utskickningen av e-post. Värden som är lägre än 2 framtvingar skapandet av en ny SMTP-session för varje e-postmeddelande.';
$string['configsmtpoauthservice'] = 'Välj den OAuth 2-tjänst som är konfigurerad för att kommunicera med SMTP-servern. Om tjänsten inte finns ännu måste du skapa den. Observera att du måste ställa in SMTP-autentiseringstypen till XOAUTH2.';
$string['configsmtpsecure'] = 'Om SMTP-servern kräver säker anslutning, ange protokollet här.';
$string['configsmtpuser'] = 'Om du har angivit en SMTP-server ovan, och servern kräver autentisering, så ska du skriva in användarnamn och lösenord här.';
$string['configstartwday'] = 'Veckan börjar';
$string['configstatsfirstrun'] = 'Det här anger hur långt tillbaka som loggar ska behandlas <b>första gången</b> som cron-jobbet will behandla statistik. Om du har mycket trafik och delar server med andra, så är det bäst att inte gå alltför långt tillbaka eftersom det tar tid och är resurskrävande. (Notera att för den här inställningen så är 1 månad = 28 dagar. I diagrammen och rapporterna som skapas är 1 månad = 1 kalendermånad.)';
$string['configstatsmaxruntime'] = 'Behandling av statistik kan vara ganska resurskrävande så använd en kombination av det här fältet och nästa för att ange när det ska köras och hur länge.';
$string['configstatsmaxruntime2'] = 'Behandling av statistik kan bli ganska intensiv så därför bör du ange max hur länge det får ta att samla in all statistik för en dag. Max antal dagar som kan behandlas i en cron-körning är 3.';
$string['configstatsmaxruntime3'] = 'Detta anger den maximala tiden som tillåts för att beräkna statistiken för en dag, men kom ihåg att beräkning av statistik kraftigt kan belasta serverns kapacitet. Det maximala antalet dagar som beräknas i en cron körning kan anges nedan.';
$string['configstatsruntimedays'] = 'Detta anger det maximala antalet dagar som beräknas i varje statistikberäkning. När väl statistiken är uppdaterad kommer endast en dag att beräknas, så anpassa detta värde beroende på din serverbelastning, ange mindre värde om kortare cron körningar behövs.';
$string['configstatsruntimestart'] = 'När ska  cron-jobbet som sköter behandlingen av statistiken börja? Ange olika tider om det finns ett flertal Moodle-installationer på samma fysiska server.';
$string['configstatsuserthreshold'] = 'Den här inställningen anger det minsta antal registrerade användare som krävs för att en kurs ska tas med i statistiska beräkningar.';
$string['configstrictformsrequired'] = 'Om aktiverat hindras användare från att ange mellanslag eller radbrytning i obligatoriska fält i formulär.';
$string['configstripalltitletags'] = 'Avmarkera den här inställningen om du vill tillåta HTML-taggar i namn på resurser och aktiviteter.';
$string['configsupportavailability'] = 'Anger vem som har behörighet att kontakta webbplatssupporten från sidfoten.';
$string['configsupportemail'] = 'Om SMTP har konfigurerats på den här webbplatsen och en supportsida inte har angetts kommer den här e-postadressen att få meddelanden som skickas via supportformuläret. Om sändningen misslyckas visas e-postadressen för inloggade användare.';
$string['configsupportname'] = 'Namnet på den person eller annan enhet som erbjuder stöd via supportformuläret eller supportsidan.';
$string['configsupportpage'] = 'En länk till den här sidan kommer att tillhandahållas så att användare kan kontakta webbplatsens support. Om fältet lämnas tomt kommer istället en länk till ett supportformulär tillhandahållas.';
$string['configtempdatafoldercleanup'] = 'Ta bort tillfälliga datafiler som är äldre än angiven tid från datakatalogen.';
$string['configthemedesignermode'] = 'Normalt cachelagras alla bilder och stilmallar i webbläsare och på servern under en mycket lång tid, av prestandaskäl. Om du designar teman eller utvecklar kod så vill du förmodligen aktivera detta läge, för att du inte ska få cachade versioner. Varning: detta kommer att göra din webbplats långsammare för alla användare! Alternativt kan du manuellt rensa cachelagringen för teman på sidan Att välja teman.';
$string['configthemelist'] = 'Låt detta vara tomt så att användare kan välja tema själva. Om du vill ha en mindre urval så kan du ange en komma-separerad lista med namn på teman här (Använd inte mellanslag). T.ex.: standard,orangewhite';
$string['configtimezone'] = 'Detta är standardtidszonen för visning av datum. Varje användare kan åsidosätta den här inställningen i sin profil. Cron-jobb och andra serverinställningar anges i denna tidszon. Du bör ändra inställningen om den visas som "Ogiltig tidszon"';
$string['configuseblogassociations'] = 'Ska användare kunna organisera sin blogg genom att koppla ihop inlägg med kurser och kursmoduler?';
$string['configusesitenameforsitepages'] = 'Om det är aktiverat används webbplatsens korta namn för noden webbplatssidor i navigeringen i stället för strängen "Webbplatssidor".';
$string['configusetags'] = 'Ska funktionaliteten med etiketter vara aktiverad globalt över hela webbplatsen?';
$string['configvariables'] = 'Variabler';
$string['configverifychangedemail'] = 'Möjliggör verifiering av ändrade e-postadresser med hjälp av inställningar för tillåtna och förbjudna e-postdomäner. Om denna inställning är inaktiverad kommer domän endast att vara tvingande vid skapande av ny användare.';
$string['configvisiblecourses'] = 'Visa normalt sett kurser i dolda kategorier';
$string['configwarning'] = 'Var försiktig med att ändra dessa inställningar - konstiga värden kan leda till problem.';
$string['configyuicomboloading'] = 'Detta alternativ aktiverar optimerad kombinerad filladdning
för Yui bibliotek. Denna inställning ska vara aktiverad på produktionsmilöer av prestandaskäl.';
$string['confirmation'] = 'Bekräftelse';
$string['confirmcontextlock'] = '{$a->contextname} är för närvarande olåst. Låsning kommer att göra det skrivskyddat och hindra användare från att göra ändringar. Är du säker på att du vill fortsätta?';
$string['confirmcontextunlock'] = '{$a->contextname} är för närvarande låst. Upplåsning kommer att göra det skrivbart och tillåta användare att göra ändringar. Är du säker på att du vill fortsätta?';
$string['confirmdeletecomments'] = 'Du håller på att ta bort kommentarer, är du säker?';
$string['confirmed'] = 'Bekräftad';
$string['contactsitesupport'] = 'Kontakta webbplatssupporten';
$string['contenttypeuninstalling'] = 'Det finns {$a->count} innehåll som stöds av {$a->type}. De kommer att tas bort. Är du säker på att du vill fortsätta?';
$string['contextlockappliestoadmin'] = 'Kontextlåsning gäller för administratörer';
$string['contextlockappliestoadmin_desc'] = 'Om inaktiverad behåller administratörer skrivrättighet för alla låsta kontext.';
$string['contextlocking'] = 'Kontextlåsning';
$string['contextlocking_desc'] = 'Denna inställning gör det möjligt att låta kategorier, kurser, aktiviteter och block enbart erbjuda läsrättigheter.';
$string['cookiesecure'] = 'Endast säkra cookies';
$string['country'] = 'Förvalt land';
$string['course_customfield'] = 'Anpassade kursfält';
$string['coursecolor'] = 'Färg {$a}';
$string['coursecolorheading_desc'] = 'Eventuella kurser utan kursbild visas på startsidan med ett mönstrat kurskort. De färger som används i mönstret kan anges nedan.';
$string['coursecolorsettings'] = 'Färginställningar';
$string['coursecontact'] = 'Kurskontakter';
$string['coursecontact_desc'] = 'Den här inställningen tillåter dig att kontrollera vem som dyker upp på kursbeskrivningen. Användarna kommer att behöva ha åtminstone en av dessa roller för att de ska vara synliga på beskrivningen av den kursen.';
$string['coursecontactduplicates'] = 'Visa alla kurskontakt-roller';
$string['coursecontactduplicates_desc'] = 'Om aktiverad kommer användare med fler än en av de valda kurskontaktrollerna att visas i kursbeskrivningen med var och en av sina roller. Annars visas de med endast en roll (det som anges högst upp i listan \'Definiera roller\' i Webbplatsadministrationen).';
$string['coursecreationguide'] = 'URL till guide för att skapa Moodle-kurser';
$string['coursecreationguide_help'] = 'Definierar sökvägen till en snabbstartsguide med korta videor och allmänna tips för att skapa kurser. En länk till guiden visas på sidan Mina kurser när det inte finns några kurser att visa. Endast användare med möjlighet att skapa kurser ser länken.';
$string['coursegraceperiodafter'] = 'Respitperiod för tidigare kurser';
$string['coursegraceperiodbefore'] = 'Respitperiod för kommande kurser';
$string['courselistshortnames'] = 'Visa utökade kursnamn';
$string['courselistshortnames_desc'] = 'Om aktiverat kommer kursernas kortnamn att visas som tillägg till hela namnet i kurslistor. Om så krävs kan förlängda kursnamn ändras genom att ändra \'courseextendednamedisplay\' språksträngen med språkanpassningsverktyget.';
$string['coursemgmt'] = 'Hantera kurser och kategorier';
$string['courseoverview'] = 'Översikt över kurs';
$string['courserequestnotify'] = 'Meddelande om begäran om kurs';
$string['courserequestnotifyemail'] = '{$a->user} har begärt en ny kurs <a href="{$a->link}">{$a->link}</a>';
$string['courserequests'] = 'Kursförfrågningar';
$string['courserequestspending'] = 'Avvaktande begäranden om kurs ';
$string['courses'] = 'Kurser';
$string['coursesperpage'] = 'Kurser per sida';
$string['courseswithsummarieslimit'] = 'Gräns för visning av kurser inklusive sammanfattning';
$string['creatornewroleid'] = 'Kursutvecklarens roll i nya kurser';
$string['creatornewroleid_help'] = 'Om användaren inte redan har behörighet att administrera den nya kursen kommer användaren automatiskt att registreras med denna roll.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Aktivera cron';
$string['cron_enabled_desc'] = 'Cron bör normalt vara aktiverat. Dock kan den här inställningen inaktiveras tillfälligt, till exempel innan en omstart av servern. Om den är inaktiverad hindras systemet från att starta nya bakgrundsaktiviteter. Observera att cron inte bör inaktiveras under en längre tid eftersom detta förhindrar viktig funktionalitet.';
$string['cron_help'] = 'Cron-skriptet kör ett antal schemalagda bakgrundsaktiviteter, som till exempel att söka efter uppdateringar, sammanställa statistik, m.m. Skriptet bör köras regelbundet - helst varje minut.';
$string['cron_keepalive'] = 'Håll levande';
$string['cron_keepalive_desc'] = 'Tidsgränsen för att leta efter ytterligare uppgifter. Den här inställningen är till för att säkerställa att cron alltid körs. Om du använder dedikerade uppgiftshämtare ställer du in den på 0. Annars anger du det till ett värde som liknar adhoc-uppgiftens samtidighetsgräns. Undvik längre tider. Maxtiden är 15 minuter.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Körning av cron endast via en kommandorad';
$string['cronerrorclionly'] = 'Tyvärr har internetåtkomst till den här sidan inaktiverats av administratören.';
$string['cronerrorpassword'] = 'Du har tyärr inte angivit något giltigt lösenord för att få tillgång till den här sidan.';
$string['croninfrequent'] = 'Det gick {$a->actual} mellan de två senaste körningarna av cron-skriptet. Det bör dock inte gå mer än {$a->expected} mellan dem. Vi rekommenderar att skriptet konfigureras för att köra oftare.';
$string['cronremotepassword'] = 'Lösenord för tillträde till cron på distans.';
$string['cronwarning'] = 'Skrifter <a href="{$a->url}">admin/cron.php</a> har inte körts på {$a->actual}. Det bör köras varje {$a-> expected}.';
$string['cronwarningcli'] = 'Skriptet <code>admin/cli/cron.php</code> har inte körts på {$a->actual}. Det bör köras varje {$a->expected}.';
$string['cronwarningnever'] = 'Skriptet <code>admin/cli/cron.php</code> har aldrig körts. Det bör köras varje {$a->expected}.';
$string['cronwarningneverweb'] = 'Skriptet <a href="{$a->url}">admin/cron.php script</a> har aldrig körts. Det bör köras varje {$a->expected}.';
$string['ctyperequired'] = 'PHP-tillägget ctype krävs av Moodle för att förbättra webbplatsprestandan och för att bli flerspråkskompatibel.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrequired'] = 'PHP-tillägget cURL krävs av Moodle för att kommunicera med Moodle-lagringsplatser.';
$string['curlsecurityallowedport'] = 'Lista över tillåtna cURL-portar';
$string['curlsecurityallowedportsyntax'] = 'Lista över portnummer som cURL kan ansluta till. Giltiga poster är enbart heltalsnummer. Sätt varje post på en ny rad. Om den lämnas tom, är alla portar är tillåtna. Om angiven bör både 443 och 80 anges för att ansluta till standard HTTPS och HTTP-portar.';
$string['curlsecurityblockedhosts'] = 'Lista över blockerade cURL-värdar';
$string['curlsecurityblockedhostssyntax'] = 'Sätt varje post på en ny rad. Giltiga poster är antingen fullständiga IPv4- eller IPv6-adresser (t.ex. 192.168.10.1, 0:0:0:0:0:0:1, ::1, fe80::) som matchar en specifik värd; eller via CIDR-notation (såsom 231.54.211.0/20 eller fe80::/64); eller ett intervall av IP-adresser (såsom 231.3.56.10-20 eller fe80::1111-bbbb) där intervallet gäller den sista gruppen av adressen; eller domännamn (som localhost eller example.com); eller jokerteckendomännamn (till exempel *.example.com eller *.sub.example.com). Tomma rader är inte tillåtna.';
$string['curlsecurityurlblocked'] = 'URL:en är blockerad.';
$string['curltimeoutkbitrate'] = 'Bitrate att använda vid beräkning av curl timeout (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Denna inställning används för att beräkna en lämplig timeout vid stora cURL-förfrågningar. Som en del i denna beräkning görs en <em>HTTP HEAD</em>-förfrågan för att avgöra storleken på innehållet. Om detta värde sätts till 0 inaktiveras denna förfrågan.';
$string['currenttheme'] = 'Nuvarande tema';
$string['customcheck'] = 'Övriga kontroller';
$string['custommenu'] = 'Standardmeny';
$string['custommenuitems'] = 'Komponenter på standardmenyn';
$string['customusermenuitems'] = 'Användarmeny';
$string['datarootsecurityerror'] = '<p><strong>SÄKERHETSVARNING!</strong></p> <p>Din rotkatalog för data är på fel plats och är öppet exponerad för webben. Detta innebär att alla dina privata filer är tillgängliga för alla i världen, och några av dem skulle kunna användas av en hackare för att få obehörig administrativ tillgång till din webbplats!</p> <p>Du <em>måste</em> flytta dataroot-katalogen ({$a}) till en ny plats som inte är i din offentliga webbkatalog, och uppdatera <code>$CFG->dataroot</code> inställningen i din config.php i enlighet med detta.</p>';
$string['datarootsecuritywarning'] = 'Den konfiguration som du använder för webbplatsen kanske inte är säker. Vänligen säkerställ att din dataroot-katalog ({$a}) inte är direkt tillgänglig via webben.';
$string['dbsessions'] = 'Använd databas för sessionsinformation';
$string['debug'] = 'Felsökningsmeddelanden';
$string['debugall'] = 'ALLA: Visa alla rimliga meddelanden angående felsökning i PHP.';
$string['debugdeveloper'] = 'UTVECKLARE: extra meddelanden för felsökning för utvecklare.';
$string['debugdisplay'] = 'Visa felsökningsmeddelanden';
$string['debugging'] = 'Felsökning';
$string['debugminimal'] = 'MINIMAL: Visa bara allvarliga fel';
$string['debugnone'] = 'INGA: Visa inte några fel eller varningar';
$string['debugnormal'] = 'NORMAL: Visa fel, varningar och meddelanden.';
$string['debugpageinfo'] = 'Visa information för sida';
$string['debugsqltrace'] = 'Visa ursprung för SQL-anrop';
$string['debugsqltrace1'] = 'Visa enbart en anropsrad';
$string['debugsqltrace100'] = 'Visa fullständig stackspårning';
$string['debugsqltrace2'] = 'Visa 2 rader ur stackspårningen';
$string['debugsqltrace_desc'] = 'Om aktiverad läggs en partiell eller fullständig PHP-stackspårning till i SQL:en som en kommentar.';
$string['debugstringids'] = 'Visa språksträngarnas id';
$string['debugstringids_desc'] = 'Om detta är aktiverat kan du, genom att lägga till parametern <code>?strings=1</code> eller <code>&strings=1</code> till en URL, visa språkfilen och sträng-id:t bredvid respektive sträng som visas på sidan.';
$string['debugtemplateinfo'] = 'Visa mallinformation';
$string['debugtemplateinfo_desc'] = 'Om det här alternativet är aktiverat visas mallar som används för visning som kommentarer i sidans HTML-kod. Använd endast för tillfällig felsökning eftersom detta medför HTML-valideringsfel och kan bryta vissa sidskript.';
$string['debugvalidators'] = 'Visa länkarna för validering';
$string['defaultcity'] = 'Förvald stad';
$string['defaultcity_help'] = 'Den stad som anges här kommer att vara standard när du skapar nya användarkonton.';
$string['defaultformatnotset'] = 'Fel uppstod vid bestämning av förvalt kursformat. Kontrollera inställningarna.';
$string['defaulthomepage'] = 'Startsida för användare';
$string['defaultrequestcategory'] = 'Förvald standardkategori för kurser som efterfrågas.';
$string['defaultsettinginfo'] = 'Standardinställning: {$a}';
$string['defaultuserroleid'] = 'Förvald roll för alla användare';
$string['deleteincompleteusers'] = 'Ta bort ofullständiga användare efter';
$string['deleteunconfirmed'] = 'Ta bort alla inte fullt bekräftade användare efter';
$string['deleteuser'] = 'Ta bort användare';
$string['density'] = 'Densitet';
$string['denyemailaddresses'] = 'Blockerade e-postdomäner';
$string['development'] = 'Utveckling';
$string['devicetype'] = 'Enhetstyp';
$string['devlibdirpresent'] = 'Kataloger med utvecklingsbibliotek, särskilt <em>/vendor</em> och <em>/node_modules</em>, bör inte finnas på offentliga webbplatser. Se översiktsrapporten <a href="{$a->moreinfourl}">Säkerhetsöversikt</a> för mer information.';
$string['disabled'] = 'Inaktiverad';
$string['disableplugin'] = 'Inaktivera {$a}';
$string['disableuserimages'] = 'Inaktivera profilbilder';
$string['displayerrorswarning'] = 'Du bör inaktivera PHP-inställningen <code>display_errors</code> i produktionsmiljöer eftersom vissa felmeddelanden kan avslöja känslig information om din server.';
$string['displayloginfailures'] = 'Visa inloggningsfel';
$string['divertallemails'] = 'Omdirigering av e-post';
$string['divertallemailsdetail'] = 'Används som ett skydd i utvecklingsmiljöer vid testning av e-post och bör inte användas i produktion.';
$string['divertallemailsexcept'] = 'Omdirigeringsundantag för E-post';
$string['divertallemailsexcept_desc'] = 'En lista över undantagsregler för e-post avgränsade med antingen kommatecken eller med nya rader. Varje regel tolkas som ett reguljärt uttryck, t.ex. <pre>simone@acme.com .*@acme.com fred(\\+.*)?@acme.com </pre>';
$string['divertallemailsto'] = 'Vidarebefordra alla e-postmeddelanden';
$string['divertallemailsto_desc'] = 'Om inställt omdirigeras alla e-postmeddelanden istället till denna adress.';
$string['dndallowtextandlinks'] = 'Dra och släpp uppladdning av text/länkar';
$string['doclang'] = 'Språk för dokumentation';
$string['docroot'] = 'Rotkatalog för Moodle Docs';
$string['doctonewwindow'] = 'Öppna i nytt fönster';
$string['doesnotfit'] = 'Visningsinställningar för e-post';
$string['doesnotfitdetail'] = 'Visningsinställningar för utgående e-post från Moodle.';
$string['download'] = 'Ladda ned';
$string['downloadcoursecontentallowed'] = 'Nedladdning av kursinnehåll möjligt';
$string['downloadcoursecontentallowed_desc'] = 'Om funktionen för nedladdning av kursinnehåll är tillgänglig för kurser. Om den är aktiverad kan hämtning av kursinnehåll aktiveras/inaktiveras i inställningen "Tillåt nedladdning av kursinnehåll" i kursredigeringsmenyn (standard för detta kan anges under <a href={$a} target="_blank">Förvalda kursinställningar</a>).';
$string['durationunits'] = 'varaktighetsenheter';
$string['edithelpdocs'] = 'Redigera hjälpdokument';
$string['editlang'] = '<strong>Redigera</strong>';
$string['editorbackgroundcolor'] = 'Bakgrundsfärg';
$string['editordictionary'] = 'Ordlista för redigerare';
$string['editorfontfamily'] = 'Typsnitt';
$string['editorfontlist'] = 'Lista över typsnitt';
$string['editorfontsize'] = 'Storlek på typsnitt';
$string['editorhidebuttons'] = 'Dolda knappar';
$string['editorkillword'] = 'Filter för Word-format';
$string['editorspelling'] = 'Stavning för redigerare';
$string['editorspellinghelp'] = 'Aktivera eller inaktivera stavningskontroll. När detta är aktiverat måste <strong>aspell</strong> vara installerat på servern.';
$string['editstrings'] = 'Redigera ord eller fraser';
$string['emailchangeconfirmation'] = 'Bekräftelse av ändrad e-postadress';
$string['emaildkim'] = 'Signering med DomainKeys Mail (DKIM)';
$string['emaildkiminfo'] = 'Om både DKIM-väljaren är inställd och en privat certifikatfil hittas som matchar e-postmeddelandets "Från"-adressdomän i $CFG->dataroot/dkim/[domän]/[selector].private kommer e-postmeddelandet att signeras. I de flesta fall (till exempel om allowedemaildomains är tom) behövs endast ett ensamt certifikat i <pre>{$a->path}</pre>. Mer information om inställningar finns i dokumentationen <a href="{$a->docs}">Mail-konfiguration</a>.';
$string['emaildkimselector'] = 'DKIM-väljare';
$string['emailfromvia'] = 'E-post via-information';
$string['emailheaders'] = 'E-postrubriker';
$string['emailsubjectprefix'] = 'Ämnesprefix för E-post';
$string['emoticonalt'] = 'Alternativ text';
$string['emoticoncomponent'] = 'Bildkomponent';
$string['emoticonimagename'] = 'Bildnamn';
$string['emoticons'] = 'Uttryckssymboler';
$string['emoticons_desc'] = 'I det här formuläret definieras de uttryckssymboler (eller smileys) som används på din webbplats. Om du vill ta bort en rad ur tabellen sparar du formuläret med ett tomt värde i något av de obligatoriska fälten. Om du vill registrera en ny uttryckssymbol fyller du i fälten i den sista tomma raden. Om du vill återställa alla fälten till standardvärden följer du länken ovan.

* Text (obligatorisk) - Denna text kommer att ersättas med uttryckssymbolbilden. Den måste vara minst två tecken lång.
* Bildnamn (obligatoriskt) - Filnamnet för uttryckssymbolen (utan tillägg) relativt komponentens pix-katalog.
* Bildkomponent (obligatorisk) - Komponenten som tillhandahåller ikonen (t.ex. <code>core</code>).
* Alternativ text (valfritt) - Strängidentifierare och komponent (t.ex. <code>core_pix</code>) i den alternativa texten för uttryckssymbolen.';
$string['emoticonsreset'] = 'Återställ emoji-inställningarna till standard';
$string['emoticontext'] = 'Text';
$string['emptysettingvalue'] = 'Tom';
$string['enableanalytics'] = 'Analysfunktioner';
$string['enableblogs'] = 'Aktivera bloggar';
$string['enablecalendarexport'] = 'Aktivera export av kalender';
$string['enablecomments'] = 'Aktivera kommentarer';
$string['enablecommunicationsubsystem'] = 'Aktivera undersystem för kommunikation';
$string['enablecommunicationsubsystem_desc'] = 'Den här inställningen aktiverar det nya kommunikationsundersystemet. Detta nya delsystem gör det möjligt för lärare och elever att lättare kommunicera medan de använder Moodle för undervisning och lärande.';
$string['enablecourserelativedates'] = 'Aktivera relativa kursdatum';
$string['enablecourserelativedates_desc'] = 'Tillåt att kurser ställs in så att datum visas i förhållande till användarens startdatum i kursen.';
$string['enablecourserequests'] = 'Aktivera förfrågan om kurs';
$string['enabled'] = 'Aktiverat';
$string['enabledashboard'] = 'Aktivera översiktssida';
$string['enabledashboard_help'] = 'Översiktssidan visar tidslinje, kalender och nyligen öppnade objekt som standard. Du kan ange en standardöversiktssida för alla och sedan låta användare anpassa sin egen översiktssida. Om den är inaktiverad måste du ange "Startsida för användare" till ett annat värde än Översiktssida.';
$string['enableglobalsearch'] = 'Aktivera global sökning';
$string['enableglobalsearch_desc'] = 'Om aktiverad kommer data indexeras och synkroniseras av en schemalagd aktivitet.';
$string['enablegravatar'] = 'Aktivera Gravatar';
$string['enablegravatar_help'] = 'När funktionen är aktiverad kommer Moodle att försöka hämta en bild för användarprofilen från <em>Gravatar</em> (gäller bara om användaren inte har laddat upp en bild).';
$string['enablemobilewebservice'] = 'Aktivera webbtjänster för mobila enheter';
$string['enablepdfexportfont'] = 'Aktivera PDF-teckensnitt';
$string['enablepdfexportfont_desc'] = 'Om din webbplats har kurser på olika språk och som behöver andra teckensnitt i genererade PDF-filer kan du ge möjlighet att ställa in teckensnittet i kursinställningarna. Du måste ange tillgängliga teckensnitt i <code>$CFG->pdfexportfont</code> i <em>config.php</em>.';
$string['enableplugin'] = 'Aktivera {$a}';
$string['enablerecordcache'] = 'Aktivera postcachning';
$string['enablerssfeeds'] = 'Aktivera RSS-flöden';
$string['enablesearchareas'] = 'Aktivera sökområden';
$string['enablesharingtomoodlenet'] = 'Aktivera delning till MoodleNet (utgående)';
$string['enablesharingtomoodlenet_desc'] = 'Gör det möjligt för användare att dela kursinnehåll till en konfigurerad MoodleNet-instans om de har denna funktionsbehörighet.';
$string['enablestats'] = 'Aktivera statistik';
$string['enabletrusttext'] = 'Aktivera betrott innehåll';
$string['enableuserfeedback'] = 'Aktivera feedback';
$string['enableuserfeedback_desc'] = 'Om aktiverad visas en länk för att ge feedback om den här programvaran i sidfoten där användare kan ge feedback om Moodle-programvaran till Moodle HQ. Om alternativet \'Nästa feedbackpåminnelse\' är inställt visas även en påminnelse på Instrumentpanelen med angivet intervall. Om du ställer in "Nästa feedback-påminnelse" till "Aldrig" inaktiveras påminnelsen på instrumentpanelen, samtidigt som länken "Ge feedback om den här programvaran" finns kvar i sidfoten.';
$string['enablewebservices'] = 'Aktivera webbtjänster';
$string['enablewsdocumentation'] = 'Dokumentation av webbtjänster';
$string['encryptedpassword_edit'] = 'Ange nytt värde';
$string['encryptedpassword_set'] = '(Inställt och krypterat)';
$string['enroladminnewcourse'] = 'Registrera automatiskt administratörer till nya kurser';
$string['enroladminnewcourse_help'] = 'När en administratör lägger till en ny kurs, ska den automatiskt registreras och tilldelas rollen kursskapare i nya kurser?';
$string['enrolinstancedefaults'] = 'Standardvärden för instanser av registreringar';
$string['enrolinstancedefaults_desc'] = 'Standardinställningar för registreringar på nya kurser';
$string['enrolmultipleusers'] = 'Registrera användarna';
$string['entitytasklog'] = 'Aktivitetslogg';
$string['environment'] = 'Miljö';
$string['environmenterrortodo'] = 'Du måste lösa alla ovanstående problem i din miljö innan du fortsätter att installera denna Moodle-version!';
$string['environmenterrorupgrade'] = 'Varning! Du bör lösa alla problem (fel) med miljön som har hittats här ovan innan du fortsätter uppgraderingen till den här versionen av Moodle. Om du uppgraderar utan att uppfylla dessa krav så riskerar du att få problem som t.ex. förlust av data. Är du säker på att du vill gå vidare med den här uppgraderingen?';
$string['environmentmariadbwrongdbtype'] = 'Felaktig <code>$CFG->dbtype</code>: du behöver ändra den i din <code>config.php</code>-fil, från \'<code>mysql</code>\' till \'<code>mariadb</code>\'.';
$string['environmentmustfixsetting'] = 'Inställningen för PHP måste ändras.';
$string['environmentok'] = 'Servern uppfyller minimikraven';
$string['environmentrecommendcustomcheck'] = 'om det här testet misslyckas signalerar det ett möjligt problem';
$string['environmentrecommendinstall'] = 'bör vara installerat och aktiverat för bästa resultat';
$string['environmentrecommendversion'] = 'version {$a->needed} rekommenderas och du använder  {$a->current}';
$string['environmentrequirecustomcheck'] = 'det här testet måste lyckas';
$string['environmentrequireinstall'] = 'måste vara installerat och aktiverat';
$string['environmentrequireversion'] = 'version {$a->needed} krävs och du använder {$a->current}';
$string['environmentsettingok'] = 'korrekt inställt';
$string['environmentshouldfixsetting'] = 'Inställningen för PHP bör ändras.';
$string['environmentxmlerror'] = 'Fel i samband med läsning av data angående den tekniska miljön ({$a->error_code})';
$string['errordeletingconfig'] = 'Ett fel inträffade vid borttagning av konfigurationsdata för plugin \'{$a}\'.';
$string['errorsetting'] = 'Det gick inte att spara inställningen:';
$string['errorwithsettings'] = 'Vissa inställningar ändrades inte på grund av ett fel.';
$string['eventshandlersinuse'] = 'Följande plugins i ditt system använder Events 1 API-hanterare: \'{$a}\'. Vänligen uppdatera dem till att använda Events 2-API:t. Se https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Alla som kan  \'{$a}\'';
$string['exceptions'] = 'undantag';
$string['execpathnotallowed'] = 'Möjligheten att ange lokala sökvägar eller sökvägar till exekverbara filer är inaktiverad i config.php';
$string['experimental'] = 'Experimentell';
$string['experimentalsettings'] = 'Experimentella inställningar';
$string['extendedusernamechars'] = 'Tillåt specialtecken i användarnamn';
$string['extramemorylimit'] = 'Extra minnesgräns för PHP';
$string['fatalsessionautostart'] = '<p> Ett allvarligt konfigurationsfel har upptäckts, vänligen meddela serveradministratören. </p><p> För att fungera korrekt kräver Moodle att administratören ändrar PHP inställningar. </p><p> <code>session.auto_start</code> måste vara inställd på <code>off</code> . </p><p> Denna inställning kontrolleras genom att redigera <code>php.ini</code> , Apache/IIS <br /> eller <code>.htaccess</code> -filen på servern. </p>';
$string['favicon'] = 'Favikon';
$string['favicon_desc'] = 'Favikon att använda som ikon för webbplatsen';
$string['feedbacksettings'] = 'Inställningar för återkoppling';
$string['fileconversioncleanuptask'] = 'Städa upp tillfälliga filkonverteringsposter';
$string['filecreated'] = 'En ny fil har skapats';
$string['filescleanupperiod'] = 'Städa upp bland skräpfiler';
$string['filescleanupperiod_help'] = 'Hur ofta filer i papperskorgen tas bort. Dessa är filer som är associerade med ett sammanhang som inte längre finns, till exempel när en kurs tas bort. <strong>OBS!</strong> Den här inställningen kan resultera i att filer saknas i en kurs som säkerhetskopieras, raderas och sedan återställs om inställningen <em>Inkludera filer</em> (<code>backup_auto_files</code>) i <em>Inställningar för automatisk säkerhetskopiering</em> är inaktiverad.';
$string['filesizeunits'] = 'filstorleksenheter';
$string['filestoredin'] = 'Spara fil till katalog:';
$string['filestoredinhelp'] = 'Där filen kommer att sparas';
$string['filterall'] = 'Filtrera alla strängar';
$string['filtermatchoneperpage'] = 'Filtrera matchning en gång per sida';
$string['filtermatchonepertext'] = 'Filtrera matchning en gång per text';
$string['filternavigationwithsystemcontext'] = 'Filternavigering med systemkontext';
$string['filters'] = 'Filter';
$string['filtersettings'] = 'Hantera filter';
$string['filtersettingsgeneral'] = 'Generella inställningar för filter';
$string['filteruploadedfiles'] = 'Filtrera uppladdade filer';
$string['forceclean'] = 'Rensa innehåll överallt';
$string['forceclean_desc'] = 'Innehåll som läggs till på webbplatsen rensas normalt innan det visas för att ta bort något som kan vara ett säkerhetshot. Innehållet rensas dock inte på vissa ställen som aktivitetsbeskrivningar, sidresurser eller HTML-block för att tillåta att skript, media, infogade ramar etc. läggs till. Om den här inställningen är aktiverad kommer ALLT innehåll att rensas. Detta kan resultera i att befintligt innehåll inte längre visas korrekt.';
$string['forcelogin'] = 'Tvinga användare att logga in';
$string['forceloginforprofileimage'] = 'Tvinga användarna att logga in för att se användarnas bilder';
$string['forceloginforprofileimage_help'] = 'Om aktiverad måste användarna logga in för att se  användares profilbilder. Standardanvändarbilden kommer att användas i alla e-postmeddelanden.';
$string['forceloginforprofiles'] = 'Tvinga användare att logga in för att se profiler';
$string['forcetimezone'] = 'Tvinga tidszon';
$string['formatuninstallwithcourses'] = 'Det finns {$a->count} kurser som använder {$a->format}. Deras format kommer att ändras till {$a->defaultformat} (förvalt format för denna webbplats). Vissa formatspecifika data kan komma att förloras. Är du säker på att du vill fortsätta?';
$string['frontpage'] = 'Startsida';
$string['frontpagebackup'] = 'Säkerhetskopia för startsidan';
$string['frontpagedefaultrole'] = 'Standardroll på startsidan';
$string['frontpagefilters'] = 'Filter på startsidan';
$string['frontpageloggedin'] = 'Startsidesobjekt när man är inloggad';
$string['frontpageoverrides'] = 'Åsidosätt behörigheter för startsidan';
$string['frontpagequestions'] = 'Frågor på startsidan';
$string['frontpagerestore'] = 'Återställning av startsidan';
$string['frontpageroles'] = 'Startsidesroller';
$string['frontpagesettings'] = 'Inställningar för startsidan';
$string['fullnamedisplay'] = 'Format för fullständigt namn';
$string['fullnamedisplayprivate'] = 'Format för fullständigt namn - privat';
$string['gdrequired'] = 'Tillägget GD krävs nu av Moodle för bildkonvertering.';
$string['generalsettings'] = 'Allmänna inställningar';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Källa till loggad IP-adress';
$string['globalsearch'] = 'Global sökning';
$string['globalsearchmanage'] = 'Hantera global sökning';
$string['googlemapkey3'] = 'API-nyckel V3 för Google Maps';
$string['googlemapkey3_help'] = 'Du måste ange en specifik nyckel för att använda Google Maps för visualisering av IP-address platsvisualisering. Du kan skaffa denna nyckel utan kostnad på <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Gå till den första saknade strängen';
$string['gradebook'] = 'Betygskatalog';
$string['gradebookroles'] = 'Betygssatta roller';
$string['gradeexport'] = 'Primära exportmetoder';
$string['gravatardefaulturl'] = 'Förvald bild URL för Gravatar';
$string['gravatardefaulturl_help'] = 'Gravatar behöver en standardbild att visa om den inte kan hitta bild för en viss användare. Ge en fullständig URL till en bild. Om du lämnar den här inställningen tom kommer Moodle att försöka använda den mest lämpliga standardbilden för den sida du visar. Observera också att Gravatar har ett antal koder som kan användas för att <a href="https://en.gravatar.com/site/implement/images/#default-image">generera standardbilder</a> .';
$string['groupenrolmentkeypolicy'] = 'Nyckelpolicy för registrering via grupp';
$string['groupenrolmentkeypolicy_desc'] = 'Om det här alternativet är aktiverat kontrolleras nycklar för gruppregistrering mot lösenordsprincipen enligt inställningarna ovan.';
$string['guestroleid'] = 'Roll för gäst';
$string['guestroleid_help'] = 'Den här rollen tilldelas automatiskt till gästanvändaren. Den tilldelas också tillfälligt icke-registrerade användare som kommer in i kursen via inställningen "Tillåt gäster".';
$string['h5pgetcontenttypestask'] = 'Hämta tillgängliga H5P-innehållstyper från h5p.org';
$string['helpadminseesall'] = 'I webbplatskalendern; ser och filtrerar administratörer händelser från alla kurskalendrar eller bara de från kurser som de är inskrivna i? Oavsett det valda alternativet kommer administratörer alltid att kunna hantera händelser för varje kurskalender genom att navigera till kursen och sedan direkt komma åt kurskalendern.';
$string['helpcalendarcustomexport'] = 'Aktivera anpassade datumintervall i exportalternativ i kalenderexport. Kalenderexport måste aktiveras innan detta har effekt.';
$string['helpexportlookahead'] = 'Hur många dagar framåt letar kalendern efter händelser under export av det anpassade exportalternativet?';
$string['helpexportlookback'] = 'Hur många dagar bakåt letar kalendern efter händelser under export av det anpassade exportalternativet?';
$string['helpforcetimezone'] = 'Du kan tillåta användare att individuellt välja sin tidszon, eller tvinga fram en tidszon för alla.';
$string['helpshowicalsource'] = 'Om aktiverad, kommer prenumerationsnamn och länk att visas för iCal importerade händelser.';
$string['helpsitemaintenance'] = 'För uppgraderingar och annat arbete';
$string['helpstartofweek'] = 'Vilken dag inleder veckan i kalendern?';
$string['helpupcominglookahead'] = 'Hur många dagar framåt i tiden övervakar kalendern som standard när det gäller kommande händelser?';
$string['helpupcomingmaxevents'] = 'Hur många (maximalt) kommande händelser visas för användarna som standard?';
$string['helpweekenddays'] = 'Vilka dagar i veckan markeras som "helgdagar" och visas med en annan färg?';
$string['hiddenuserfields'] = 'Dolda användarfält';
$string['hidefromall'] = 'Dölj för alla användare';
$string['hidefromnone'] = 'Dölj inte för någon';
$string['hidefromstudents'] = 'Dölj för studenter';
$string['hookcallbacknotcallable'] = 'Denna callback går inte att anropa. Detta kan bero på att klassen eller metoden saknas eller på att den inte är publik.';
$string['hookcallbacks'] = 'Callbacks';
$string['hookconfigoverride'] = 'Åsidosatt';
$string['hookconfigoverride_help'] = 'Definitionen för denna callback har åsidosatts i webbplatsens konfigurationsfil (config.php)';
$string['hookdescription'] = 'Beskrivning';
$string['hostname'] = 'Värdnamn';
$string['htmleditor'] = 'HTML-redigerare';
$string['htmleditorsettings'] = 'Inställningar för HTML-redigerare';
$string['htmlsettings'] = 'HTML-inställningar';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP-säkerhet';
$string['iconvrequired'] = 'Det är obligatoriskt att installera ett ICONV-tillägg.';
$string['igbinary322buggyversion'] = 'Tillägget <code>php-igbinary</code> som är installerat på den här webbplatsen kan medföra problem tillsammans med PHP 7.2. Du rekommenderas att antingen uppgradera det här tillägget till version 3.2.5, eller uppgradera PHP till version 7.3.';
$string['ignore'] = 'Ignorera';
$string['includemoduleuserdata'] = 'Ta med modulens användardata';
$string['incompatibleblocks'] = 'Inkompatibla block';
$string['incompleteunicodesupport'] = 'Den nuvarande inställningen av MySQL eller MariaDB använder \'utf8\'. Den här teckenuppsättningen stöder inte fyra bytes-tecken som inkluderar vissa emoji. Att försöka använda dessa tecken kommer att resultera i ett fel när du uppdaterar en post, och all information som skickas till databasen kommer att gå förlorad. Vänligen överväg att ändra dina inställningar till \'utf8mb4\'. Se dokumentationen för fullständig information.';
$string['indexdata'] = 'Indexera data';
$string['indexinginfo'] = 'Det rekommenderade sättet att indexera webbplatsens innehåll är med hjälp av den schemalagda aktiviteten \'Global sökindexering\'.';
$string['installhijacked'] = 'Installationen måste avslutas från den ursprungliga IP-adress, ledsen.';
$string['installsessionerror'] = 'Kan inte initiera PHP-session. Kontrollera att din webbläsare accepterar cookies.';
$string['intlrecommended'] = 'Tillägget Intl används för att förbättra stöd för internationalisering, såsom lokal medveten sortering.';
$string['intlrequired'] = 'Intl-tillägg krävs för förbättrat internationaliseringsstöd, till exempel lokalmedveten sortering och internationella domännamn.';
$string['invalidagedigitalconsent'] = 'Den digitala samtyckesåldern är ogiltig: {$a}';
$string['invalidforgottenpasswordurl'] = 'URL:en för återställning av lösenord är ogiltig.';
$string['invalidsection'] = 'Ogiltig sektion';
$string['invalidthemepreset'] = 'Den valda förinställningsfilen är inte kompatibel med detta tema. SCSS-kompileringsfelet var: "{$a}"';
$string['invaliduserchangeme'] = 'Anvädarnamnet "changename" är reserverat - du kan inte använda det för att skapa ett konto.';
$string['ipblocked'] = 'Den här webbplatsen är för närvarande inte tillgänglig.';
$string['ipblocker'] = 'IP-blockerare';
$string['ipblockersyntax'] = 'Sätt varje post på en rad. Giltiga värden är antingen en full IP-adress (t.ex. <b>192.168.10.1</b>) som matchar en enda värd, eller partiell adress (t.ex. <b>192,168</b>), som matchar alla adresser som börjar med dessa siffror, eller CIDR (såsom <b>231.54.211.0/20</b>) , eller ett intervall av IP-adresser (t.ex. <b>231.3.56.10-20)</b> där området gäller den sista delen av adressen. Text-domännamn (som \'example.com\') stöds inte. Tomma rader och text efter "#" ignoreras.';
$string['iplookup'] = 'IP-adressökning';
$string['iplookupgeoplugin'] = '<a href="http://www.geoplugin.com">geoPlugin</a> tjänsten används för närvarande för att slå upp geografisk information. För mer exakta resultat rekommenderar vi att installera en lokal kopia av MaxMind GeoLite-databasen.';
$string['iplookupinfo'] = 'Som standard använder Moodle den fria NetGeo (The Internet Geographic Database) servern för att leta upp platser för IP-adresser. Dessvärre underhålls inte denna databas längre och den kan därför returnera <em>helt felaktig</em> data. Det rekommenderas att installera en lokal kopia av den fria GeoLite2 City-databasen från MaxMind.<br / > Platsen för IP-adressen visas på enkel karta eller med hjälp av Google Maps. Observera att du måste ha ett Google-konto och ansöka om en gratis Google Maps API-nyckel för att möjliggöra interaktiva kartor.';
$string['iplookupmaxmindnote'] = 'Den här produkten inkluderar GeoLite2 data som har skapats av MaxMind som är tillgängligt från  <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['iscustomadminwarnings'] = 'Det har upptäckts att din webbplats använder en anpassad administratörskatalog. Den här funktionen stöds inte längre och tas bort efter Moodle 4.2.';
$string['ishttpswarning'] = 'Det har upptäckts att din webbplats inte är säkrad med hjälp av HTTPS. Det rekommenderas starkt att migrera din webbplats till HTTPS för ökad säkerhet och förbättrad integration med andra system.';
$string['keeptagnamecase'] = 'Behåll stora och små bokstäver i etikettnamn';
$string['lang'] = 'Standardspråk';
$string['langcache'] = 'Cacha språkmenyn';
$string['langcache_desc'] = 'Cachelagra språkmenyn. Om aktiverat visas listan över tillgängliga översättningar cachelagrad. Cachen uppdateras automatiskt när du installerar eller tar bort ett språkpaket via den inbyggda verktyget för språkpaket . Om du installerar ett nytt språkpaket manuellt, måste du använda funktionen Rensa alla cachar för att uppdatera den cachelagrade listan.';
$string['langlist'] = 'Språk på språkmenyn';
$string['langmenu'] = 'Visa språkmenyn';
$string['langmenuinsecurelayout'] = 'Meny för visningsspråk i säker layout';
$string['langmenuinsecurelayout_desc'] = 'Om aktiverad, kommer en användare att kunna ändra sitt språk när man gör ett test eller annan aktivitet i säker layout.';
$string['langpackwillbeupdated'] = 'OBS! Moodle kommer att försöka hämta uppdateringar för dina språkpaket under uppdateringen.';
$string['langstringcache'] = 'Cacha alla språksträngar';
$string['languagesettings'] = 'Språkinställningar';
$string['latinexcelexport'] = 'Teckenuppsättning för Excel';
$string['legacyfilesaddallowed'] = 'Tillåt att lägga till i kurser av äldre format';
$string['legacyfilesaddallowed_help'] = 'Tillåt att nya filer och kataloger läggs till i kursfiler av äldre format.';
$string['legacyfilesinnewcourses'] = 'Tillåt kursfiler i äldre format i nya kurser';
$string['legacyfilesinnewcourses_help'] = 'Som standard är kursfiler i äldre format endast tillgängliga i kurser som uppgraderats. Tänk på att vissa funktioner, som säkerhetskopiering och återställning av aktiviteter, inte är kompatibla med den här inställningen.';
$string['libcurlwarning'] = 'Det har upptäckts att <em>libcurl</em> inte har stöd för <code>CURLOPT_PROTOCOL</code>. Av säkerhetsskäl rekommenderas den senaste versionen av <em>libcurl</em>.';
$string['licensesettings'] = 'Licensinställningar';
$string['linkadmincategories'] = 'Länka adminkategorier';
$string['linkadmincategories_help'] = 'Om aktiverad kommer admin inställningskategorier att visas som länkar i navigationsträdet och kommer att leda till admin kategorisidor.';
$string['loading'] = 'Laddar in';
$string['localetext'] = 'Lokal inställning för hela webbplatsen';
$string['localstringcustomization'] = 'Standardisering av lokala (text)-strängar';
$string['location'] = 'Plats';
$string['locationsettings'] = 'Platsinställningar';
$string['locked'] = 'Låst';
$string['lockoutduration'] = 'Varaktighet kontoutelåsning';
$string['lockoutduration_desc'] = 'Utelåst konto automatiskt upplåst efter denna tidsrymd.';
$string['lockoutemailbody'] = 'Ditt konto med användarnamn {$a->username} på server \'{$a->sitename}\'
blev låst på grund av för många felaktiga inloggningsförsök.

För att omedelbart låsa upp kontot gå till följande adress

{$a->link}

I de flesta e-postprogram borde detta visas som en blå länk som du kan klicka på. Om det inte fungerar så kopiera adressen och klistra in den i webbläsarens adressfönster.

Om du behöver hjälp kontakta webbplatsadministratören,
{$a->admin}';
$string['lockoutemailsubject'] = 'Ditt konto på {$a} stängdes av.';
$string['lockouterrorunlock'] = 'Ogiltig information för kontoupplåsning angiven.';
$string['lockoutthreshold'] = 'Tröskelvärde för kontoutelåsning';
$string['lockoutthreshold_desc'] = 'Välj det antal misslyckade inloggningsförsök som resulterar i kontolåsning. Den här funktionen kan missbrukas i överbelastningsattacker.';
$string['lockoutwindow'] = 'Observationsfönster för kontolåsning';
$string['lockoutwindow_desc'] = 'Om det gått så här lång tid sedan det senaste misslyckade inloggningsförsöket återställs räknaren för antal misslyckade inloggningsförsök.';
$string['lockrequestcategory'] = 'Förhindra kategorival';
$string['log'] = 'Loggar';
$string['logguests'] = 'Logga gäståtkomst';
$string['logguests_help'] = 'Den här inställningen aktiverar loggning av åtgärder från gästkonto och inte inloggade användare. Webbplatser med hög trafik kanske vill inaktivera den här loggningen av prestandaskäl. Vi rekommenderar att du håller den här inställningen aktiverad på produktionswebbplatser.';
$string['logininfoinsecurelayout'] = 'Visa inloggad användare i säker layout.';
$string['logininfoinsecurelayout_desc'] = 'Om aktiverad kommer den inloggade användarens fullständiga namn att visas i navigeringsfältet när du försöker göra ett test eller annan aktivitet med hjälp av säker layout.';
$string['loginpageautofocus'] = 'Autofokus formulär inloggningssida';
$string['loginpageautofocus_help'] = 'Aktivering av det här alternativet förbättrar användbarheten på inloggningssidan, men automatiskt fältfokus kan betraktas som en tillgänglighetsfråga.';
$string['loglifetime'] = 'Spara loggar i';
$string['logo'] = 'Logotyp';
$string['logo_desc'] = 'En fullständig logotyp som ska användas som dekoration i vissa teman (t.ex. systemteman). Den här bilden kan ha ganska hög upplösning eftersom den kommer att skalas ner vid användning (och cachas för prestanda). Logotyper som är bredare än de är höga ger vanligtvis bättre resultat.';
$string['logocompact'] = 'Kompakt logotyp';
$string['logocompact_desc'] = 'En kompakt version av samma logotyp som ovan, till exempel ett emblem, sköld eller ikon. Bilden ska vara tydlig även i små storlekar.';
$string['logossettings'] = 'Logotyper';
$string['logstorenotrequired'] = 'Logglagringsplats ej obligatorisk';
$string['logstoressupported'] = 'Loggarkiv som stödjer denna rapport';
$string['longtimewarning'] = '<b>OBS denna process kan ta lång tid.</b>';
$string['mailnewline'] = 'Tecken för ny rad i e-post';
$string['maintenancemode'] = 'I underhållsläge';
$string['maintenancemodeisscheduled'] = 'Denna webbplats kommer övergå till läge för underhåll om {$a->min} minuter {$a->sec} sekunder';
$string['maintenancemodeisscheduledlong'] = 'Den här webbplatsen kommer att växla till underhållsläge om {$a->hour} tim {$a->min} min {$a->sec} sekunder';
$string['maintfileopenerror'] = 'Fel i samband med att filerna för underhål skulle öppnas';
$string['maintinprogress'] = 'Underhåll pågår';
$string['managecontextlock'] = 'Lås detta kontext';
$string['managecontextlocklocked'] = '{$a->contextname} och lägre kontext är nu låsta.';
$string['managecontextlockunlocked'] = '{$a->contextname} och lägre kontext är nu upplåsta.';
$string['managecontextunlock'] = 'Lås upp detta kontext';
$string['managecustomfields'] = 'Hantera fälttyper';
$string['manageformats'] = 'Hantera kursformat';
$string['manageformatsgotosettings'] = 'Förvalt format kan ändras i {$a}';
$string['managelang'] = 'Hantera';
$string['manageqbanks'] = 'Hantera pluginmoduler för frågebank';
$string['manageqbehaviours'] = 'Hantera frågebeteenden';
$string['manageqtypes'] = 'Hantera frågetyper';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Releasekandidat';
$string['maturity200'] = 'Stabil version';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Tips: Du kanske vill köra skriptet med --allow-unstable alternativet';
$string['maturitycoreinfo'] = 'Din webbplats kör för närvarande ostabil "{$a}" utvecklingskod.';
$string['maturitycorewarning'] = 'Versionen av Moodle som du vill installera eller uppgradera till innehåller ostabil "{$a}" utvecklingskod som inte är lämplig för de flesta webbplatser i produktion. Om detta inte är vad du vill göra se till att du uppdaterar från en stabil version av Moodle kod. Se Moodle Docs för mer detaljer.';
$string['maxbytes'] = 'Maximal storlek på uppladdade filer';
$string['maxconsecutiveidentchars'] = 'Efter varandra följande identiska tecken';
$string['maxeditingtime'] = 'Maximal tillåten tid för att redigera inlägg';
$string['maxsizeperdownloadcoursefile'] = 'Maxstorlek per fil';
$string['maxsizeperdownloadcoursefile_desc'] = 'Den maximala storleken för en fil vid nedladdning av kursinnehåll. Filer som överskrider denna storlek kommer att utelämnas vid nedladdningen.';
$string['maxtimelimit'] = 'Maximal tidsgräns';
$string['maxtimelimit_desc'] = 'Om du vill begränsa den maximala PHP-körningstiden som Moodle tillåter utan att någon utdata visas anger du ett värde (i sekunder) här. 0 innebär att standardbegränsningarna i Moodle används. Om du har en frontend-server med en egen tidsgräns anger du ett värde som är lägre än denna tidsgräns för att ta emot PHP-fel i loggarna. Detta gäller inte för CLI-skript.';
$string['maxusersperpage'] = 'Högsta antal användare per sida';
$string['mbstringrecommended'] = 'Du rekommenderas starkt att installera det valfria MBSTRING-biblioteket. Detta förbättrar webbplatsens prestanda, speciellt om din webbplats stödjer icke-latinska språk.';
$string['mbstringrequired'] = 'MBSTRING-biblioteket krävs för att förbättra webbplatsens prestanda, särskilt om din webbplats stöder icke-latinska språk.';
$string['mediapluginavi'] = 'Aktivera .avi-filter';
$string['mediapluginflv'] = 'Aktivera .flv filter';
$string['mediapluginimg'] = 'Aktivera automatisk inbäddning av länkade bildet';
$string['mediapluginmov'] = 'Aktivera .mov-filter';
$string['mediapluginmp3'] = 'Aktivera  .mp3-filter';
$string['mediapluginmpg'] = 'Aktivera mpg-filter';
$string['mediapluginogg'] = 'Aktivera .ogg-filter';
$string['mediapluginogv'] = 'Aktivera .ogv-filter';
$string['mediapluginram'] = 'Aktivera .ram filter';
$string['mediapluginrm'] = 'Aktivera .rm filter';
$string['mediapluginrpm'] = 'Aktivera .rpm filter';
$string['mediapluginwmv'] = 'Aktivera .wmv-filter';
$string['mediapluginyoutube'] = 'Aktivera filter för länkar från YouTube';
$string['messaging'] = 'Aktivera meddelandefunktionen';
$string['messagingallowemailoverride'] = 'Åsidosätt meddelandeaviseringar via E-post';
$string['messagingallusers'] = 'Tillåt webbplatsövergripande meddelanden';
$string['messagingcategory'] = 'Meddelanden';
$string['messagingdefaultpressenter'] = 'Använd Returtangenten för att skicka';
$string['messagingdeleteallnotificationsdelay'] = 'Ta bort notiser efter';
$string['messagingdeletereadnotificationsdelay'] = 'Ta bort lästa notiser efter';
$string['messagingssettings'] = 'Meddelandeinställningar';
$string['minpassworddigits'] = 'Siffror';
$string['minpasswordlength'] = 'Lösenordslängd';
$string['minpasswordlower'] = 'Små bokstäver';
$string['minpasswordnonalphanum'] = 'Icke-alfanumeriska tecken';
$string['minpasswordupper'] = 'Stora bokstäver';
$string['misc'] = 'Övrigt';
$string['mlbackendsettings'] = 'Serverinställningar för maskininlärning';
$string['mnetrestore_extusers'] = '<strong>OBS!</strong> Den här säkerhetskopian innehåller fjärranvändarkonton i ett nätverk för Moodle och de kommer att återställas som e n del av processen.';
$string['mnetrestore_extusers_admin'] = '<strong>OBS:</strong> Denna säkerhetskopia verkar komma från en annan Moodle installation och innehåller användarkonton från  utanförliggande Moodlenätverk. Återställningen kommer att försöka matcha Moodle nätverksvärdar för alla skapade användare. De som inte matchar automatiskt kopplas till intern verifiering (istället för Mnet). Återställningsloggen kommer att informera dig om detta.';
$string['mnetrestore_extusers_mismatch'] = '<strong>OBS!</strong> Den här säkerhetskopian verkar komma från en annan Moodleinstallation och innehåller externa Moodlekonton som kanske inte går att återställa. Den här operationen stödjs inte. Om du är säker på att den var skapad av den här Moodleinstallationen, eller om du kan säkerställa att alla de nödvändiga värdarna i Moodlenätverket är konfigurerade kan du ändå försöka genomföra återställningen.';
$string['mnetrestore_extusers_noadmin'] = '<strong>OBS!</strong> Denna säkerhetskopia verkar komma från en annan Moodle-installation och innehåller användarkonton från externa Moodlenätverk. Det är inte tillåtet att utföra denna typ av återställning. Kontakta administratören av webbplatsen eller, alternativt, återställ denna kurs utan någon användarinformation (moduler, filer ...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Remote Moodle Network-användare {$a->username} (som kommer från {$a->mnethosturl}) växlade till lokal {$a->auth} autentiserad användare.';
$string['mobilenotconfiguredwarning'] = 'Moodle-appen är inte aktiverad.';
$string['modassignmentinuse'] = 'Din webbplats använder fortfarande pluginmodulen <em>Inlämningsuppgift 2.2</em>. Innan du uppgraderar måste du 1) säkerhetskopiera alla Inlämningsuppgift 2.2-aktiviteter som du vill behålla och återställa dem som Inlämningsuppgift samt 2) ta bort alla Inlämningsuppgift 2.2-data från databasen.';
$string['modassignmentsubpluginsexist'] = 'Underpluginmoduler till Inlämningsuppgift 2.2-aktiviteten kan finnas. Katalogen <kbd>mod/assignment</kbd> måste tas bort innan uppgradering.';
$string['modeditdefaults'] = 'Standardvärden för inställningar för aktiviteter';
$string['modsettings'] = 'Hantera aktiviteter';
$string['modulesecurity'] = 'Säkerhet för modul';
$string['moodlebrandedapp'] = 'Skräddarsydd mobilapp för Moodle';
$string['moodlebrandedappreference'] = 'Eller så kan du skaffa en <a href="https://moodle.com/branded-app/">skräddarsydd mobilapp för Moodle</a> med dina egna anpassningar.';
$string['mustenablestats'] = 'Statistikfunktioner har ännu inte aktiverats för den här webbplatsen.';
$string['mycourses'] = 'Mina kurser';
$string['mydashboard'] = 'Systemets standardinstrumentpanel';
$string['mymoodle'] = 'Översikt';
$string['mypage'] = 'Standardinställningar för Översiktssidan';
$string['mypagelocked'] = 'Lås standardsidan';
$string['myprofile'] = 'Standardinställningar för Profilsida';
$string['navadduserpostslinks'] = 'Lägg till  länkar för att visa användarinlägg';
$string['navadduserpostslinks_help'] = 'Om aktiverad kommer två länkar att läggas till varje användare i navigeringen för att visa de diskussioner användaren har startat och de inlägg som användaren har gjort i forum på hela webbplatsen eller i specifika kurser.';
$string['navcourselimit'] = 'Begränsning av kurs';
$string['navigationupgrade'] = 'Denna uppgradering introducerar två nya navigeringsblock som kommer att ersätta dessa block: Administration, Kurser, Aktiviteter och Deltagare. Om du hade satt några speciella behörigheter på dessa block bör du kontrollera att allt beter sig som du vill ha det.';
$string['navshowallcourses'] = 'Visa alla kurser';
$string['navshowcategories'] = 'Visa kurskategorier';
$string['navshowfrontpagemods'] = 'Visa startsidesaktiviteter i navigeringsmenyn';
$string['navshowfrontpagemods_help'] = 'Om aktiverat visas startsidesaktiviteter i navigeringsmenyn på webbplatssidor. Den här inställningen gäller enbart för teman baserade på Classic.';
$string['navshowfullcoursenames'] = 'Visa kursens fullständiga namn';
$string['navshowfullcoursenames_help'] = 'Om aktiverat kommer kurser att visas med sitt fulla namn snarare än deras kortnamn i navigeringen.';
$string['navshowmycoursecategories'] = 'Visa mina kurskategorier';
$string['navshowmycoursecategories_help'] = 'Om det här alternativet är aktiverat visas kurser under <em>Mina kurser</em> i kategorier i navigeringsblocket (endast klassiska teman).';
$string['navsortmycourseshiddenlast'] = 'Sortera mina dolda kurser till att ligga sist';
$string['navsortmycourseshiddenlast_help'] = 'Om aktiverad kommer eventuella dolda kurser att listas efter synliga kurser (för användare som kan visa dolda kurser). I annat fall kommer alla kurser, oavsett deras synlighet, att listas enligt inställningen \'Sortera mina kurser\'.';
$string['navsortmycoursessort'] = 'Sortera mina kurser';
$string['navsortmycoursessort_help'] = 'Detta avgör om kurser listas under Mina kurser enligt sorteringsordningen (dvs. i den ordning som angivits under <em>Hantera webbplats &#10132; Kurser &#10132; Hantera kurser och kategorier</em>) eller i alfabetisk ordning efter kursinställningen.';
$string['never'] = 'Aldrig';
$string['neverdeleteruns'] = 'Radera aldrig körningar';
$string['newestdocindexed'] = 'Senast indexerade dokumentet';
$string['nobookmarksforuser'] = 'Du har inga bokmärken';
$string['nodatabase'] = 'Ingen databas';
$string['noemaileverwarning'] = '<strong>OBS!</strong> All utgående e-post har inaktiverats.';
$string['nohttpsformobilewarning'] = 'Det är rekommenderat att aktivera HTTPS tillsammans med ett giltigt certifikat. Mobilappen kommer alltid att försöka använda en säker anslutning först.';
$string['nomissingstrings'] = 'Det saknas inga (text)strängar';
$string['none'] = 'Ingen';
$string['nonewsettings'] = 'Inga nya inställningar lades till under den här uppgraderingen.';
$string['nonexistentbookmark'] = 'Det gick inte att hitta det bokmärke som du efterfrågade.';
$string['noreplyaddress'] = 'Adress för inget-svar';
$string['noreplydomain'] = 'No-reply och domän';
$string['noreplydomaindetail'] = 'Inställningar för No-reply konfigurerade domäner';
$string['noresults'] = 'Det gick inte att hitta några resultat';
$string['noroles'] = 'Inga roller';
$string['nosupportedlogstore'] = 'Inga loggarkiv hittades';
$string['noteunneededblocks'] = '<strong>OBS!</strong> Block som ska visas syns inte i menyn <em>Lägg till ett block</em> i en kurs om de anges i temainställningarna under "Ej nödvändiga block".';
$string['notifications'] = 'Notiser';
$string['notifyloginfailures'] = 'E-post om misslyckade inloggningar till';
$string['notifyloginthreshold'] = 'Tröskel för notiser via e-post';
$string['notloggedinroleid'] = 'Roll för besökare';
$string['numberofmissingstrings'] = 'Antal saknade textsträngar';
$string['numberofstrings'] = 'Det sammanlagda antalet textsträngar: {$a->strings}<br />Saknas: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Uppdateringstoken för en av OAuth-tjänsterna {$a->issuer} på din webbplats {$a->siteurl} har gått ut. Detta kommer att begränsa funktionaliteten hos alla plugins som använder denna tjänst. Åtgärda problemet genom att besöka konfigurationssidan OAuth 2-tjänster och klicka på ikonen "Anslut systemkonto" i tabellraden för den här tjänsten. Var noga med att logga in med samma tjänstekonto för OAuth-systemet varje gång.';
$string['oauthrefreshtokenexpiredshort'] = 'OAuth uppdateringstoken för {$a->issuer} på {$a->siteurl} har gått ut.';
$string['onlynoreply'] = 'Enbart från en no-reply adress';
$string['opcacherecommended'] = 'PHP opcode caching förbättrar prestanda och sänker minneskrav. OPcache-tillägget är rekommenderas och stöds fullt ut.';
$string['opensslrecommended'] = 'Vi rekommenderar starkt att du installerar det valfria OpenSSL-biblioteket - det möjliggör funktionaliteten för nätverk med Moodle.';
$string['opensslrequired'] = 'OpenSSL OHP-tillägget är nu obligatoriskt i Moodle för att kunna erbjuda starkare krypteringstjänster.';
$string['opentowebcrawlers'] = 'Öppen för sökmotorer';
$string['optionalmaintenancemessage'] = 'Valfritt underhållsmeddelande';
$string['order1'] = 'Första';
$string['order2'] = 'Andra';
$string['order3'] = 'Tredje';
$string['order4'] = 'Fjärde';
$string['outgoingmailconfig'] = 'Konfiguration av utgående E-post';
$string['overridetossl'] = 'HTTPS för inloggningar har nu avvecklats. Denna instans har nu gått över till SSL. För att åtgärda denna varning, ändra din wwwroot i config.php till https://';
$string['pageinfodebugsummary'] = 'Den här sidan är: {$a}';
$string['passwordchangelogout'] = 'Logga ut efter lösenordsändring';
$string['passwordchangelogout_desc'] = 'Om aktiverat avslutas alla webbläsarsessioner när ett lösenord ändrad, bortsett från den där det nya lösenordet anges. (Den här inställningen påverkar inte lösenordsändringar via massanvändaruppladdning.)';
$string['passwordchangetokendeletion'] = 'Ta bort åtkomsttoken för webbtjänst efter lösenordsändring';
$string['passwordchangetokendeletion_desc'] = 'Om aktiverat tas alla åtkomsttoken för en användare bort när lösenordet ändras.';
$string['passwordpolicy'] = 'Använd lösenordspolicy';
$string['passwordpolicycheckonlogin'] = 'Kontrollera lösenord vid inloggning';
$string['passwordresettime'] = 'Tidsgräns för validering av nytt lösenord';
$string['passwordreuselimit'] = 'Tillåt tidigare lösenord efter';
$string['passwordreuselimit_desc'] = 'Antal gånger en användare måste ändra sitt lösenord innan de tillåts återanvända ett lösenord. Hashar av tidigare använda lösenord lagras i databasen. Den här funktionen kanske inte är kompatibel med vissa externa autentiseringsplugins.';
$string['pathtodot'] = 'Sökväg till dot';
$string['pathtodot_help'] = 'Sökväg till <em>dot</em>. På Linux är den  någonting i stil med <code>/usr/bin/dot</code>. På Windows är den någonting i stil med <code>C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe</code>. På Mac är den någonting i stil med <code>/opt/local/bin/dot</code>. För att kunna generera grafik från DOT-filer måste du ha installerat <em>dot</em>-programmet och peka på det här.';
$string['pathtodu'] = 'Sökväg till du';
$string['pathtogs'] = 'Sökväg till ghostscript';
$string['pathtogs_help'] = 'På de flesta Linux-installationer kan detta lämnas som \'/usr/bin/gs\'. På Windows kommer det att bli något i stil med "c:\\gs\\bin\\gswin32c.exe" (se till att det inte finns några mellanslag i sökvägen - om nödvändigt kopiera filerna \'gswin32c.exe\' och \'gsdll32.dll\' till en ny mapp som inte innehåller mellanslag i namnet)';
$string['pathtopdftoppm'] = 'Sökväg till pdftoppm';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a> är ett PDF-renderingsbibliotek som innehåller verktyget pdftoppm för att konvertera PDF-filer till PNG. Prestandan är i allmänhet bättre än när du använder Ghostscript - särskilt för stora filer. Om tillgängligt kommer pdftoppm att användas i stället för Ghostscript. På de flesta Linux-installationer kan sökvägen lämnas som <em>/usr/bin/pdftoppm</em>. Annars måste du installera poppler-utils eller poppler-paketet, beroende på din Linux-distribution. På Windows tillhandahålls det av Cygwin-installationer.';
$string['pathtopgdump'] = 'Sökväg till pg_dump';
$string['pathtopgdumpdesc'] = 'Det är bara nödvändigt att mata in om du har mer än en på_dump i ditt system. (om du t ex har mer än en version av postgresql installerad).';
$string['pathtopgdumpinvalid'] = 'Ogiltig sökväg till pg_dump - antingen fel sökväg eller också går den inte att använda';
$string['pathtophp'] = 'Sökväg till PHP CLI';
$string['pathtopsql'] = 'Sökväg till psql';
$string['pathtopsqldesc'] = 'Det är bara nödvändigt att mata in om du har mer än en psql i ditt system. (om du t ex har mer än en version av postgresql installerad).';
$string['pathtopsqlinvalid'] = 'Ogiltig sökväg till psql - antingen fel sökväg eller också går den inte att använda';
$string['pathtopython'] = 'Sökväg till Python';
$string['pathtopythondesc'] = 'Sökväg till Python.exe-filen (både version 2 och 3 stöds).';
$string['pathtosassc'] = 'Sökväg till SassC';
$string['pathtosassc_help'] = 'Om du anger en sökväg till SassC medför detta att SASS-kompilatorn ändras från Moodles egna PHP-implementation till SassC. Se https://github.com/sass/sassc för mer information.';
$string['pcreunicodewarning'] = 'Det rekommenderas starkt att använda PCRE PHP-tillägget som är kompatibelt med Unicode-tecken.';
$string['perfdebug'] = 'Info om prestanda';
$string['performance'] = 'Prestanda';
$string['pgcluster'] = 'PostgreSQL kluster';
$string['pgclusterdescription'] = 'PostgreSQL version/kluster parameter för aktiviteter av typ kommandorad. Om du bara har en postgresql i ditt system eller om du inte vet vad detta är så bör du lämna tdetta tomt.';
$string['phpfloatproblem'] = 'Upptäckte problem vid hanteringen av flyttal i PHP - {$a}';
$string['pid'] = 'PNR';
$string['pleaserefreshregistration'] = 'Din webbplats är registrerad. Registreringen uppdaterades senast {$a}.<br />Den schemalagda aktiviteten \'Webbplatsregistrering\' håller din registrering uppdaterad. Du kan också uppdatera din registrering manuellt när som helst.';
$string['pleaserefreshregistrationnewdata'] = 'Registreringsinformationen har ändrats. Vänligen bekräfta med \'Uppdatera registrering\'-knappen.';
$string['pleaserefreshregistrationunknown'] = 'Din webbplats har registrerats men registreringsdatumet är okänt. Vänligen uppdatera din registrering med hjälp av \'Uppdatera registrering\'-knappen eller se till att den schemalagda aktiviteten \'Webbplatsregistrering\' är aktiverad så att din registrering uppdateras automatiskt.';
$string['plugin'] = 'Pluginmodul';
$string['plugin_disabled'] = '{$a} inaktiverad.';
$string['plugin_enabled'] = '{$a} aktiverad.';
$string['plugins'] = 'Pluginmoduler';
$string['pluginscheck'] = 'Kontrollerar pluginberoenden';
$string['pluginscheckfailed'] = 'Beroendenkontrollen misslyckades för {$a->pluginslist}';
$string['pluginschecktodo'] = 'Du måste lösa alla plugin-krav innan du fortsätter att installera denna Moodle version!';
$string['pluginsoverview'] = 'Hantera pluginmoduler';
$string['pluginsoverviewsee'] = 'Se <a href="{$a->url}">Hantera pluginmoduler</a> för mer information.';
$string['policysettings'] = 'Policyinställningar';
$string['privacy:metadata'] = 'Pluginmodulen Administration lagrar ingen personinformation.';
$string['privacyandpolicies'] = 'Integritet och policys';
$string['privacysettings'] = 'Sekretessinställningar';
$string['profilecategory'] = 'Kategori';
$string['profilecategoryname'] = 'Namn på kategori (måste vara unikt)';
$string['profilecategorynamenotunique'] = 'Det här kategorinamnet används redan';
$string['profilecommonsettings'] = 'Vanliga inställningar';
$string['profileconfirmcategorydeletion'] = 'Det finns {$a} fält i den här kategorin som kommer att flyttas till kategorin ovan (eller nedan om den är längst upp i kategorin) <br /> Vill du fortfarande ta bort den här kategorin?';
$string['profileconfirmfielddeletion'] = 'Det finns {$a} användare med detta fält.<br />Är du säker på att du vill ta bort fältet?';
$string['profilecreatecategory'] = 'Ny profilkategori';
$string['profilecreatefield'] = 'Nytt fält';
$string['profilecreatenewcategory'] = 'Skapar en ny kategori';
$string['profilecreatenewfield'] = 'Skapar ett nytt "{$a}" profilfält.';
$string['profiledefaultcategory'] = 'Övriga fält';
$string['profiledefaultchecked'] = 'Förvald som standard';
$string['profiledefaultdata'] = 'Förvalt standardvärde';
$string['profiledeletecategory'] = 'Definierar en kategori';
$string['profiledeletefield'] = 'Tar bort fält \'{$a}\'';
$string['profiledescription'] = 'Beskrivning';
$string['profiledscript'] = 'Detta skript har profilerats';
$string['profiledscriptview'] = 'Visa profileringsinformation för det här skriptet';
$string['profileeditcategory'] = 'Redigerar kategori: {$a}';
$string['profileeditfield'] = 'Redigerar ett fält för profil: {$a}';
$string['profilefield'] = 'Fält';
$string['profilefieldcolumns'] = 'Kolumner';
$string['profilefieldispassword'] = 'Är detta ett fält för lösenord?';
$string['profilefieldlink'] = 'Länk';
$string['profilefieldlink_help'] = 'För att omvandla texten till en länk anger du en URL innehållandes $$, där $$ kommer ersättas av texten. För att t.ex. omvandla ett Twitter-ID till en länk skriver du <code>https://twitter.com/$$</code>';
$string['profilefieldlinktarget'] = 'Mål för länk';
$string['profilefieldmaxlength'] = 'Max antal tecken';
$string['profilefieldmaxlength_help'] = 'Om du vill använda det här fältet i inställningen <em>Visa användaridentitet</em> måste gränsen för antalet tecken vara högst 255.';
$string['profilefieldrows'] = 'Rader';
$string['profilefields'] = 'Profilfält';
$string['profilefieldsize'] = 'Visningsstorlek';
$string['profileforceunique'] = 'Innehåller fältet unika värden?';
$string['profileinvaliddata'] = 'Ogiltigt värde';
$string['profilelocked'] = 'Är det här fältet låst?';
$string['profilemenudefaultnotinoptions'] = 'Det förvalda standardvärdet går inte att välja.';
$string['profilemenunooptions'] = 'Det finns inte några angivna menyval';
$string['profilemenuoptions'] = 'Menyval (ett per rad)';
$string['profilemenutoofewoptions'] = 'Du måste ange åtminstone två alternativ';
$string['profilename'] = 'Namn';
$string['profilenofieldsdefined'] = 'Inga fält har definierats';
$string['profilerequired'] = 'Är det här fältet obligatoriskt?';
$string['profileroles'] = 'Synliga roller för profil';
$string['profilesforenrolledusersonly'] = 'Profil som endast gäller för registrerade användare';
$string['profileshortname'] = 'Kortnamn (måste vara unikt)';
$string['profileshortnameinvalid'] = 'Kortnamnet får endast bestå av alfanumeriska tecken eller understreck (_).';
$string['profileshortnamenotunique'] = 'Kortnamnet används redan';
$string['profilesignup'] = 'Visa på registreringssidan?';
$string['profilespecificsettings'] = 'Specifika inställningar';
$string['profilevisible'] = 'För vem är detta fält synligt?';
$string['profilevisible_help'] = '* Ingen - För privata data som endast kan ses av administratörer och chefer
* Användaren - För privata data som endast ses av användaren och administratörerna
* Användaren, lärare och administratörer - För privata data som endast kan ses av användaren, administratörer och lärare (i kursprofilen)
* Alla';
$string['profilevisibleall'] = 'Alla';
$string['profilevisiblenone'] = 'Ingen';
$string['profilevisibleprivate'] = 'Användaren';
$string['profilevisibleteachers'] = 'Användaren, lärare och administratörer (i profilen)';
$string['profiling'] = 'Profilering';
$string['profilingallowall'] = 'Kontinuerlig profilering';
$string['profilingallowall_help'] = 'Om du aktiverar den här inställningen kan du sedan när som helst använda <code>PROFILEALL</code>-parametern (PGC) för att aktivera profilering för alla skriptkörningar under Moodle-sessionens livstid. Använd <code>PROFILEALLSTOP</code>-parametern för att inaktivera den.';
$string['profilingallowme'] = 'Selektiv profilering';
$string['profilingallowme_help'] = 'Om du aktiverar den här inställningen kan du sedan, selektivt, använda <code>PROFILEME</code>-parametern var som helst (PGC) och profilering för det skriptet kommer att ske. Analogt kan du använda <code>DONTPROFILEME</code>-parametern för att förhindra att profilering sker.';
$string['profilingautofrec'] = 'Automatisk profilering';
$string['profilingautofrec_help'] = 'Genom att konfigurera den här inställningen kommer vissa begäranden (slumpmässigt, baserat på den frekvens som anges - 1 av N) att väljas ut och profileras automatiskt. Resultaten lagras för vidare analys. Observera att detta sätt att profilera respekterar inställningarna inkludera/exkludera. Ställ in den på 0 för att inaktivera automatisk profilering.';
$string['profilingenabled'] = 'Aktivera profilering';
$string['profilingenabled_help'] = 'Om du aktiverar den här inställningen kommer profilering att vara möjlig på den här webbplatsen och du kommer att kunna definiera dess beteende genom att konfigurera nästa alternativ.';
$string['profilingexcluded'] = 'Undanta profilering';
$string['profilingexcluded_help'] = 'Lista över (komma eller radseparerade, absoluta utan \'www\', anropsbara) webbadresser som kommer att uteslutas från att profileras från de som definieras i \'Profilera dessa\'-inställningen.';
$string['profilingimportprefix'] = 'Profileringsprefix';
$string['profilingimportprefix_desc'] = 'För att lättare kunna hittas kommer importerade profileringsrundor förses med ett prefix enligt vad som anges här.';
$string['profilingincluded'] = 'Profilera dessa';
$string['profilingincluded_help'] = 'Lista över (komma eller radseparerade, absoluta utan \'www\', anropsbara) webbadresser som kommer att profileras automatiskt. Exempel: /index.php, /course/view.php. Accepterar även \'*\' på valfri position. Exempel: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Behåll profileringskörningarna';
$string['profilinglifetime_help'] = 'Ange den tid du vill behålla information om gamla profileringskörningar. Äldre kommer att tas bort regelbundet. Observera att detta utesluter alla profileringskörningar som markerats som "referenskörning".';
$string['profilingslow'] = 'Profilera långsamma sidor';
$string['profilingslow_help'] = 'Genom att ställa in en minimitid i sekunder kommer alla sidor långsammare än detta att profileras. Endast profiler som är långsammare än en befintlig profil för samma skript kommer att behållas. Ställ in på 0 för att inaktivera. Observera att detta respekterar exkluderingsinställningarna.';
$string['protectusernames'] = 'Skydda användarnamn';
$string['proxybypass'] = 'Undantagna IP-adresser';
$string['proxyfixunsafe'] = 'Fixa anrop som inte går via proxy';
$string['proxyhost'] = 'Proxyserver';
$string['proxylogunsafe'] = 'Logga anrop som inte går via proxy';
$string['proxypassword'] = 'Lösenord för proxy';
$string['proxyport'] = 'Proxyport';
$string['proxytype'] = 'Typ av proxy';
$string['proxyuser'] = 'Användarnamn för proxy';
$string['purgecaches'] = 'Rensa alla cacheminnen';
$string['purgecachesconfirm'] = 'Moodle kan cacha teman, javascript, språksträngar, filtrerad text, rss-flöden och många andra typer av beräknad data. Genom att rensa dessa cachar kommer den cachelagrade informationen tas bort från servern och tvinga webbläsare att hämta ny data. På så sätt kan du vara säker på att ser de mest aktuella värdena som produceras av den aktuella koden. Det ligger ingen fara i att rensa cachen, men din webbplats kan upplevas långsammare tills ny data sparats i cachen.';
$string['purgecachesfinished'] = 'Allt i cacheminnet tömdes';
$string['purgecachesnoneselected'] = 'Välj ett eller flera cacheminnen att tömma';
$string['purgecachespage'] = 'Rensa cacheminnen';
$string['purgefiltercache'] = 'Textfilter';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Språksträngar';
$string['purgemuc'] = 'Alla MUC-cacheminnen';
$string['purgeothercaches'] = 'Fil- och diverse andra cachminnen';
$string['purgeselectedcaches'] = 'Rensa valda cacheminnen';
$string['purgeselectedcachesfinished'] = 'Valda cacheminnen tömdes.';
$string['purgetemplates'] = 'Mallar';
$string['purgethemecache'] = 'Teman';
$string['query'] = 'Fråga';
$string['question'] = 'Fråga';
$string['questionbehaviours'] = 'Frågebeteenden';
$string['questioncwqpfscheck'] = 'En eller flera slumpmässiga frågor i kunskapstestet har ställts in för att välja frågor från en blandning av delade och enskilda frågekategorier. Läs mer om slumpmässiga frågerapporter <a href="{$a->reporturl}">här</a> samt i <a href="{$a->docsurl}">dokumentationen</a>.';
$string['questioncwqpfsok'] = 'Bra! Det finns inga slumpmässiga frågor i Dina test som är inställda till att välja frågor ur en blandning av gemensamma och separata kategorier av frågor.';
$string['questiontype'] = 'Frågetyp';
$string['questiontypes'] = 'Frågetyper';
$string['quizattemptsupgradedmessage'] = 'Moodle 2.1 innehöll en stor uppgradering som berörde frågor. Det var möjligt att fördröja delar av databasuppgraderingen till att genomföras vid ett senare tillfälle. Innan du uppgraderar till Moodle 2.7 måste den uppgraderingen slutföras.';
$string['recaptchaprivatekey'] = 'Hemlig nyckel för ReCAPTCHA';
$string['recaptchapublickey'] = 'ReCAPTCHA-webbplatsnyckel';
$string['referrernone'] = 'Standard för webbläsare';
$string['referrerpolicy'] = 'Hänvisningspolicy';
$string['referrerpolicydesc'] = 'Ange hänvisningspolicy-huvudet som ska inkluderas i svar från din webbplats.';
$string['register'] = 'Registrera din webbplats';
$string['registration'] = 'Registrering';
$string['registration_help'] = 'Genom att registrera dig får du:

* Säkerhetsnotiser
* Möjlighet att på din webbplats aktivera pushnotiser till mobilappen
* Möjlighet att bidra till den gemensamma statistiken över Moodle-användningen i världen.';
$string['registrationwarning'] = 'Din webbplats är inte registrerad ännu.';
$string['registrationwarningcontactadmin'] = 'Din webbplats är inte registrerad ännu. Kontakta administratören.';
$string['releasenoteslink'] = 'För information om den här versionen av Moodle, se <a target="_blank" href="{$a}">Viktig information</a>';
$string['rememberuserlicensepref'] = 'Kom ihåg användarens licensinställningar';
$string['rememberuserlicensepref_help'] = 'Om aktiverad är den senaste licensen som valts av användaren förvald när användaren laddar upp en fil med filväljaren. I annat fall är webbplatsens standardlicens förvald.';
$string['rememberusername'] = 'Kom ihåg användarnamn';
$string['rememberusername_desc'] = 'Aktivera om du vill lagra permanenta cookies med användarnamn vid användarinloggning. Permanenta cookies kan innebära ett integritetsproblem om de används utan samtycke.';
$string['replacefrontsearch'] = 'Används för kurssökningar på startsidan';
$string['reportsmanage'] = 'Hantera rapporter';
$string['required'] = 'Obligatoriskt';
$string['requiredentrieschanged'] = 'Efter uppgraderingen tillämpas nu inställningen \'Obligatoriska poster före visning\' i följande databasaktiviteter:<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Kräv aktivitetsbeskrivning';
$string['requiremodintro_desc'] = 'Om aktiverad måste användare ange en beskrivning för varje aktivitet.';
$string['requires'] = 'Kräver';
$string['resetindentation'] = 'Återställ indrag';
$string['resetindentation_help'] = 'Detta tar bort alla indrag som angivits för kurser i {$a->format}.';
$string['resetindentation_title'] = 'Vill du återställa indrag på kurssidan?';
$string['resetindentationsuccess'] = 'Återställning av indrag';
$string['restorecourse'] = 'Återställ kurs';
$string['restorernewroleid'] = 'Kursåterställares roll';
$string['restorernewroleid_help'] = 'Om användaren inte redan har behörighet att hantera den nyligen återställda kursen tilldelas användaren automatiskt den här rollen och registreras om det behövs. Välj "Ingen" om du inte vill att återställare ska kunna hantera varje återställd kurs.';
$string['resultfilter'] = 'Filtrera på resultat';
$string['reverseproxy'] = 'Omvänd proxy';
$string['reverseproxyignore'] = 'Ignorera omvända proxys';
$string['riskconfig'] = 'Användare kan ändra konfiguration och beteende för webbplatsen.';
$string['riskconfigshort'] = 'Risk med konfiguration';
$string['riskdataloss'] = 'Användare kan förstöra stora mängder av innehåll eller information';
$string['riskdatalossshort'] = 'Risk för dataförlust';
$string['riskmanagetrust'] = 'Användare kan ändra andra användares inställningar för tillförlitlighet.';
$string['riskmanagetrustshort'] = 'Hantera tillförlitlighet';
$string['riskpersonal'] = 'Användare skulle kunna få tillgång till privat information om andra användare.';
$string['riskpersonalshort'] = 'Risk för integritet';
$string['riskspam'] = 'Användare skulle kunna skicka skräppost till användare på webbplatsen eller till andra.';
$string['riskspamshort'] = 'Risk för skräppost';
$string['riskxss'] = 'Användare skulle kunna lägga till filer och texter som tillåter skript (XSS) globalt på webbplatsen.';
$string['riskxssshort'] = 'XSS-risk';
$string['roleswithexceptions'] = '$a->roles}, med {$a->exceptions}';
$string['rssglobaldisabled'] = 'Inaktiverat på webbplatsnivå';
$string['save'] = 'Spara';
$string['savechanges'] = 'Spara';
$string['scssinvalid'] = 'Ogiltig SCSS-kod. Fel: {$a}';
$string['search'] = 'Sök';
$string['searchablecourses'] = 'Sökbara kurser';
$string['searchallavailablecourses'] = 'Sökbara kurser';
$string['searchallavailablecourses_desc'] = 'I vissa situationer fungerar sökmotorn kanske inte när du söker över ett stort antal kurser. Ställ in till att endast söka in anmälda kurser om du behöver begränsa antalet sökta kurser.';
$string['searchallavailablecourses_off'] = 'Sök enbart i kurser där det finns registreringar';
$string['searchallavailablecourses_on'] = 'Sök i kurser användaren har åtkomst till';
$string['searchallavailablecoursesdesc'] = 'Om inställd på sökning inom enbart registrerade kurser kommer kursinformation (namn och sammanfattning) och kursinnehåll endast att sökas i kurser som användaren är registrerad i. I annat fall kommer kursinformation och kursinnehåll att sökas i alla kurser som användaren kan komma åt, till exempel kurser där gäståtkomst aktiverats.';
$string['searchalldeleted'] = 'Allt indexerat innehåll har tagits bort';
$string['searchalternatesettings'] = 'Fråga-endast alternativa inställningar';
$string['searchalternatesettings_desc'] = 'Om du slutför dessa inställningar kan du välja \'alternativa inställningar\' för den här sökmotorn i alternativet för \'endast frågor\' på sidan \'Hantera global sökning\'. Detta är endast användbart när du flyttar mellan två sökmotorer av samma typ.';
$string['searchareadisabled'] = 'Sökområde inaktiverat';
$string['searchareaenabled'] = 'Sökområde aktiverat';
$string['searchareas'] = 'Sökområden';
$string['searchbanner'] = 'Sök information';
$string['searchbannerenable'] = 'Visa banderoll i sökfönstret';
$string['searchbannerenable_desc'] = 'Om aktiverat visas texten nedan högst upp på sökskärmen för alla användare. Detta kan användas för att informera användarna när sökmotorunderhåll utförs.';
$string['searchdefaultcategory'] = 'Standardsökkategori';
$string['searchdefaultcategory_desc'] = 'Resultat från den valda sökområdeskategorin visas som standard.';
$string['searchdeleteindex'] = 'Ta bort allt indexerat innehåll';
$string['searchdisplay'] = 'Visningsalternativ för sökresultat';
$string['searchenablecategories'] = 'Visa resultat i enskilda kategorier';
$string['searchenablecategories_desc'] = 'Om aktiverat visas sökresultat i separata kategorier.';
$string['searchengine'] = 'Sökmotor';
$string['searchenginealternatesettings'] = '{$a} (alternativa inställningar)';
$string['searchenginequeryonly'] = 'Sökmotor endast för förfrågningar';
$string['searchenginequeryonly_desc'] = 'Den här sökmotorn används bara för att ställa frågor, inte för indexering. Genom att använda den här funktionen kan du indexera om i en annan sökmotor, medan användarfrågor fortsätter att fungera från den här.';
$string['searchenginequeryonly_none'] = 'Ingen (använd huvudsökmotor för sökningar)';
$string['searchenginequeryonlysame'] = 'Sökmotorn endast för förfrågningar och huvudsökmotorn kan inte ställas in på samma värde.';
$string['searchhideallcategory'] = 'Dölj kategorin \'Allt\'';
$string['searchhideallcategory_desc'] = 'Om markerad kommer kategorin \'Allt\' döljas på sidan med sökresultat.';
$string['searchincludeallcourses'] = 'Inkludera alla synliga kurser';
$string['searchincludeallcourses_desc'] = 'Om det här alternativet är aktiverat kommer sökresultaten att innehålla kursinformation (namn och sammanfattning) för kurser som är synliga för användaren, även om de inte har tillgång till kursinnehållet.';
$string['searchindexactions'] = 'Indexåtgärder';
$string['searchindexdeleted'] = 'Index borttaget';
$string['searchindextime'] = 'Tidsgräns för indexering';
$string['searchindextime_desc'] = 'När stora mängder nytt innehåll indexeras stoppas den schemalagda aktiviteten när den här tidsgränsen har uppnåtts. Den fortsätter nästa gång aktiviteten körs.';
$string['searchindexupdated'] = 'Innehållet för sökmotorn har uppdaterats';
$string['searchindexwhendisabled'] = 'Indexera när inaktiv';
$string['searchindexwhendisabled_desc'] = 'Tillåter den schemalagda uppgiften att bygga sökindexet även när söktjänsten är inaktiverad. Detta är användbart om du vill bygga upp indexet innan möjligheten till sökning görs tillgänglig för studenterna.';
$string['searchinsettings'] = 'Sök i inställningar';
$string['searchlastrun'] = 'Senaste körning (tid, # dok, # poster, # överhoppade)';
$string['searchmanagement'] = 'Hantera sökningar';
$string['searchmanagement_desc'] = 'Dessa alternativ är användbara när du gör ändringar på webbplatser med mycket stora sökindex som tar lång tid att återskapa.';
$string['searchmaxtopresults'] = 'Maxantal toppresultat';
$string['searchmaxtopresults_desc'] = 'Det maximala antalet högst rankade resultat som ska visas ovanför sökresultaten för kursinnehåll, kurser och användare.';
$string['searchnotavailable'] = 'Sökfunktionen är inte tillgänglig';
$string['searchoptions'] = 'Sökalternativ';
$string['searchpartial'] = '(ännu ej fullständigt indexerat)';
$string['searchreindexed'] = 'Allt webbplatsinnehåll har omindexerats.';
$string['searchreindexindex'] = 'Indexera om allt webbplatsinnehåll';
$string['searchresults'] = 'Sökresultat';
$string['searchsetupinfo'] = 'Sökinställningar';
$string['searchteacherroles'] = 'Lärarroller';
$string['searchteacherroles_desc'] = 'Välj alla roller som ska rankas högre i sökresultaten.';
$string['searchtopresults'] = 'Topprankade resultat';
$string['searchupdateindex'] = 'Uppdatera indexerat innehåll';
$string['sectionerror'] = 'Sektionsfel!';
$string['secureforms'] = 'Använd utvidgad säkerhet för formulär';
$string['security'] = 'Säkerhet';
$string['selectsearchengine'] = 'Välj sökmotor';
$string['server'] = 'Server';
$string['serverchecks'] = 'Serverkontroller';
$string['serverlimit'] = 'Server gräns';
$string['servicespage'] = 'Länk till service och support';
$string['sessionautostartwarning'] = '<p>Ett allvarligt fel i konfigurationen har upptäckts. Vänligen informera administratören.</p><p> För att Moodle ska fungera korrekt krävs att administratören ändrar PHP-inställningarna.</p><p><code>session.auto_start</code> måste sättas till <code>off</code>.</p><p>Denna inställning görs genom att göra en ändring i <code>php.ini</code>, Apache/IIS-inställningarna eller i <code>.htaccess</code>-filen på servern.</p>';
$string['sessioncookie'] = 'Cookie-prefix';
$string['sessioncookiedomain'] = 'Cookie-domän';
$string['sessioncookiepath'] = 'Cookie-sökväg';
$string['sessionhandling'] = 'Sessionshantering';
$string['sessiontimeout'] = 'Timeout';
$string['sessiontimeoutwarning'] = 'Timeoutvarning';
$string['settingdependenton'] = 'Denna inställning kan komma att vara dold baserat på värdet för <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'Filuppladdning krävs för normal drift, vänligen aktivera det i PHP-inställningar.';
$string['settingmaxinputvars'] = 'PHP-inställningen <code>max_input_vars</code> bör vara minst 5000.';
$string['settingmaxinputvarsrequired'] = 'PHP-inställningen <code>max_input_vars</code> måste vara minst 5000.';
$string['settingmemorylimit'] = 'Otillräckligt minne har upptäcks, ställ högre minnesgräns i PHP inställningar.';
$string['settingsafemode'] = 'Moodle är inte helt kompatibelt med säkert läge. Be administratören stänga av det. Körning av Moodle i säkert läge stöds inte av Moodle. Räkna med diverse problem om du gör detta ändå.';
$string['setupsearchengine'] = 'Konfigurera sökmotor';
$string['showcommentscount'] = 'Visa räkning av kommentarer';
$string['showdetails'] = 'Visa detaljer';
$string['showuseridentity'] = 'Visa användarens identitet';
$string['showuseridentity_desc'] = 'Vid val eller sökning efter användare, och när listor över användare visas, kan dessa fält visas utöver deras fullständiga namn. Fälten visas bara för användare som har funktionsbehörigheten <code>moodle/site:viewuseridentity</code> - som standard, lärare och chefer. (Det här alternativet är mest meningsfullt om du väljer ett eller två fält som är obligatoriska på din institution).

Fält markerade med * är anpassade användarprofilfält. Du kan markera dessa fält, men det finns för närvarande vissa sidor där de inte kommer att visas.';
$string['simplexmlrequired'] = 'Från och med nu kräver Moodle PHP-tillägget  SimpleXML';
$string['sitemailcharset'] = 'Teckenuppsättning';
$string['sitemaintenance'] = 'Webbplatsen genomgår underhållsarbete och är för närvarande otillgänglig';
$string['sitemaintenancemode'] = 'Underhållsläge';
$string['sitemaintenanceoff'] = 'Underhållsläget har inaktiverats och platsen körs normalt igen';
$string['sitemaintenanceon'] = 'Din webbplats är för närvarande i underhållsläge (enbart adminstratörer kan logga in eller använda webbplatsen).';
$string['sitemaintenanceoncli'] = 'Webbplatsen är för närvarande i CLI- underhållsläge och inloggning är därför inte tillåten.';
$string['sitemaintenancetitle'] = 'Underhåll pågår för {$a}';
$string['sitemaintenancewarning'] = 'Din webbplats är för närvarande i underhållsläge (endast administratörer kan logga in). För att återställa denna webbplats till normal drift, <a href ="maintenance.php">Inaktivera underhållsläge</a>.';
$string['sitemaintenancewarning2'] = 'Din webbplats är för närvarande i underhållsläge (endast administratörer kan logga in). För att återställa webbplatsen till normal drift, <a href="{$a}">avsluta underhållsläget</a>.';
$string['sitemenubar'] = 'Webbplatsnavigering';
$string['sitepolicies'] = 'Säkerhetsinställningar';
$string['sitepolicy'] = 'URL till webbplatspolicy';
$string['sitepolicy_help'] = 'Webbadressen till webbplatsens policy som alla registrerade användare måste se och godkänna innan de får åtkomst till webbplatsen. Observera att den här inställningen endast har effekt om policyhanteraren är inställd på standard (system).';
$string['sitepolicyguest'] = 'URL till webbplatspolicy för gäster';
$string['sitepolicyguest_help'] = 'Webbadressen till webbplatsens policy som alla gäster måste se och godkänna innan de får tillgång till webbplatsen. Observera att den här inställningen endast har effekt om policyhanteraren är inställd på standard (system).';
$string['sitepolicyhandler'] = 'Policyhanterare för webbplatsen';
$string['sitepolicyhandler_desc'] = 'Detta avgör hur principer och användarsamtycken hanteras. Standardhanteraren (system) gör det möjligt att ange en webbadress för webbplatspolicyn och en webbadress för webbplatspolicyn för gäster. Policyhanteraren gör det möjligt att ange policys för webbplats, integritet samt andra policys. Den gör det också möjligt att se användarnas samtycken och vid behov ge samtycke för minderårigas räkning.';
$string['sitepolicyhandlercore'] = 'Standard (system)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Om detta är valt kommer en ämnessektion att visas på webbplatsens startsida.';
$string['sixtyfourbitsrequired'] = 'Det har upptäckts att din webbplats inte använder en 64-bitars PHP-version. Du måste uppgradera ditt system (operativsystem, PHP ...) innan du installerar den här Moodle-versionen.';
$string['sixtyfourbitswarning'] = 'Det har upptäckts att din webbplats inte använder en 64-bitars PHP-version. Vi rekommenderar att du uppgraderar webbplatsen för att säkerställa framtida kompatibilitet.';
$string['slasharguments'] = 'Använd \'snedstrecks\'-argument';
$string['slashargumentswarning'] = 'Vi rekommenderar att du använder snedstrecksargument. I framtiden kommer detta att vara obligatoriskt. Mer information finns i dokumentationen <a href="https://docs.moodle.org/sv/admin/environment/slasharguments">Använda snedstrecksargument</a>.';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP-autentiseringstyp';
$string['smtpdetail'] = 'Simple Mail Transfer Protocol (SMTP) inställningar för utgående e-post.';
$string['smtphosts'] = 'SMTP-värdar';
$string['smtpmaxbulk'] = 'Begränsning för SMTP session';
$string['smtppass'] = 'Lösenord för SMTP';
$string['smtpsecure'] = 'SMTP-säkerhet';
$string['smtpuser'] = 'Användarnamn för SMTP';
$string['soaprecommended'] = 'Att installera det valfria SOAP-tillägget är användbart för webbtjänster och vissa plugins.';
$string['sort_fullname'] = 'Kursens fullständiga namn';
$string['sort_idnumber'] = 'Kurs ID-nummer';
$string['sort_shortname'] = 'Kursens kortnamn';
$string['sort_sortorder'] = 'Sorteringsordning';
$string['spellengine'] = 'Stavningskontroll';
$string['spelllanguagelist'] = 'Språk för stavningskontroll';
$string['splrequired'] = ' SPL PHP-tillägget är nu obligatoriskt i Moodle';
$string['stats'] = 'Statistik';
$string['statsfirstrun'] = 'Maximalt bearbetningsintervall';
$string['statsmaxruntime'] = 'Maximal körningstid';
$string['statsmoodleorg'] = 'statistik';
$string['statsruntimedays'] = 'Dagar att bearbeta';
$string['statsruntimestart'] = 'Kör vid';
$string['statsuserthreshold'] = 'Tröskelvärde för användare';
$string['stickyblocks'] = 'Permantenta block';
$string['stickyblockscourseview'] = 'Kurssida';
$string['stickyblocksduplicatenotice'] = 'Om något av de block som Du lägger till här redan finns på en specifik sida så kommer detta att resultera i att det blir ytterligare en kopia.<br />Bara det markerade blocket kommer att vara låst för redigering, kopian kommer att vara redigeringsbar.';
$string['stickyblocksmymoodle'] = 'Översikt';
$string['stickyblockspagetype'] = 'Sidtyp att konfigurera';
$string['strictformsrequired'] = 'Strikt validering av obligatoriska fält';
$string['stripalltitletags'] = 'Ta bort HTML-taggar från alla aktivitetsnamn';
$string['supportavailability'] = 'Supporttillgänglighet';
$string['supportcontact'] = 'Supportkontakt';
$string['supportemail'] = 'E-post till supporten';
$string['supportemailsubject'] = 'Supportförfrågan - {$a}';
$string['supportname'] = 'Namn på supporten';
$string['supportpage'] = 'Sida för support';
$string['suspenduser'] = 'Spärra användarkonto';
$string['switchlang'] = 'Byt katalog för språk';
$string['systempaths'] = 'Systemsökvägar';
$string['tablenosave'] = 'Ändringarna i den ovanstående tabellen sparas automatiskt.';
$string['tablesnosave'] = 'Ändringarna i de ovanstående tabellerna sparas automatiskt.';
$string['tabselectedtofront'] = 'I tabeller med flikar bör raden med den för tillfället valda fliken placeras längst fram.';
$string['tabselectedtofronttext'] = 'Flytta den markerade tab-raden till förgrunden';
$string['task_adhoc_concurrency_limit'] = 'Gräns för samtidiga Ad hoc-uppgifter';
$string['task_adhoc_concurrency_limit_desc'] = 'Antalet ad hoc-aktiviteter som tillåts köra samtidigt. Om gränsen är hög kanske schemalagda aktiviteter inte körs regelbundet när det finns många ad hoc-aktiviteter. En inställning på 0 inaktiverar behandling av ad hoc-aktiviteter helt.';
$string['task_adhoc_max_runtime'] = 'Livslängd för Ad-hoc aktiviteter';
$string['task_adhoc_max_runtime_desc'] = 'Åldern på en Ad hoc-aktivitet innan den frigörs. En kort varaktighet rekommenderas eftersom det inte finns någon gräns för antalet ad hoc-aktiviteter som kan stå i kö. Om det här värdet är för högt och du har en stor ad hoc-aktivitetskö kanske schemalagda aktiviteter inte körs regelbundet.';
$string['task_dbreads'] = 'Databasläsningar';
$string['task_dbstats'] = 'Databas';
$string['task_dbwrites'] = 'Databasskrivningar';
$string['task_duration'] = 'Varaktighet';
$string['task_endtime'] = 'Sluttid';
$string['task_logmode'] = 'Vad ska loggas?';
$string['task_logmode_all'] = 'Alla jobb';
$string['task_logmode_desc'] = 'Du kan välja vad du vill ska loggas. Som standard loggad alla jobb. Du kan inaktivera loggning helt, eller ändra till att endast logga misslyckade jobb.';
$string['task_logmode_failonly'] = 'Misslyckade jobb';
$string['task_logmode_none'] = 'Inget';
$string['task_logoutput'] = 'Aktivitetsresultat';
$string['task_logretainruns'] = 'Behåll körningar';
$string['task_logretainruns_desc'] = 'Antal körningar att behålla. Den här inställningen interagerar med inställningen \'Kvarhållningsperiod\'. Det som uppnås först gäller.';
$string['task_logretention'] = 'Kvarhållningsperiod';
$string['task_logretention_desc'] = 'Den maximala tidsperiod som loggar ska sparas. Den här inställningen samverkar med inställningen \'Behåll körningar\'. Det som uppnås först gäller.';
$string['task_logtostdout'] = 'Visa utdata från logg';
$string['task_logtostdout_desc'] = 'Anger om utdata som genereras under körning ska inkluderas i loggen.';
$string['task_result'] = 'Resultat';
$string['task_result:failed'] = 'Misslyckades';
$string['task_scheduled_concurrency_limit'] = 'Samtidiga bakgrundsaktiviteter';
$string['task_scheduled_concurrency_limit_desc'] = 'Antalet schemalagda bakgrundsaktiviteter som tillåts att köras samtidigt. Om gränsen är hög kan servern uppleva hög belastning som påverkar prestanda. Ett värde på 0 kommer att inaktivera bearbetning av schemalagda aktiviteter helt.';
$string['task_scheduled_max_runtime'] = 'Livslängd för schemalagda aktiviteter';
$string['task_scheduled_max_runtime_desc'] = 'Livslängden fören schemalagd aktivitet innan den frigörs.';
$string['task_starttime'] = 'Starttid';
$string['task_stats:dbreads'] = '{$a} läsningar';
$string['task_stats:dbwrites'] = '{$a} skrivningar';
$string['task_status'] = 'Aktivitetsstatus';
$string['task_status_desc'] = 'Aktiviteten <em>"{$a->name}"</em> är <strong>{$a->status}</strong>.<br />För detaljer, se {$a->class}{$a->extradescription} i <a href="{$a->gotourl}">Schemalagda aktiviteter</a>.';
$string['task_type:adhoc'] = 'Ad hoc';
$string['task_type:scheduled'] = 'Schemalagd';
$string['taskadmintitle'] = 'Bakgrundsaktiviteter';
$string['taskanalyticscleanup'] = 'Städa upp analyser';
$string['taskautomatedbackup'] = 'Automatisk säkerhetskopiering';
$string['taskbackupcleanup'] = 'Städa upp tabeller för säkerhetskopior, loggar och filer';
$string['taskbadgescron'] = 'Tilldela märken';
$string['taskbadgesmessagecron'] = 'Skicka märkesnotiser';
$string['taskblogcron'] = 'Synkronisera externa bloggar';
$string['taskcachecleanup'] = 'Ta bort utgångna cacheposter';
$string['taskcachecron'] = 'Bakgrundsbearbetning av cache';
$string['taskcalendarcron'] = 'Skicka kalendernotiser';
$string['taskcheckforupdates'] = 'Sök efter uppdateringar';
$string['taskcompletiondaily'] = 'Slutförande markerat som påbörjat';
$string['taskcompletionregular'] = 'Beräkna vanlig slutförandedata';
$string['taskcontextcleanup'] = 'Städa upp kontext';
$string['taskcreatecontexts'] = 'Skapa saknade kontext';
$string['taskdeleteincompleteusers'] = 'Ta bort ofullständiga användare';
$string['taskdeleteunconfirmedusers'] = 'Ta bort obekräftade användare';
$string['taskeventscron'] = 'Bakgrundsbearbetning av händelser';
$string['taskfiletrashcleanup'] = 'Städa upp filer i papperskorgen';
$string['taskglobalsearchindex'] = 'Global sökindexering';
$string['taskglobalsearchoptimize'] = 'Optimisering av globalt sökindex';
$string['taskgradecron'] = 'Bakgrundsbearbetning av betygsbok';
$string['taskgradehistorycleanup'] = 'Bakgrundsbearbetning av uppstädning av tabellerna för betygshistorik';
$string['taskh5pcleanup'] = 'Städa upp oanvända H5P-filer';
$string['tasklegacycron'] = 'Äldre cron-bearbetning för pluginmoduler';
$string['tasklockcleanuptask'] = 'Rensa ad-hoc metadata';
$string['tasklogcleanup'] = 'Städa upp aktivitetsloggar';
$string['tasklogging'] = 'Konfigurera aktivitetslogg';
$string['tasklogs'] = 'Aktivitetsloggar';
$string['taskmessagingcleanup'] = 'Bakgrundsbearbetning av meddelanden';
$string['taskpasswordresetcleanup'] = 'Städa upp återställningsförsök av lösenord';
$string['taskplagiarismcron'] = 'Bakgrundsbearbetning av äldre cron för plagiat-pluginmoduler';
$string['taskportfoliocron'] = 'Bakgrundsbearbetning för portfölj-pluginmoduler';
$string['taskprocessing'] = 'Generella inställningar';
$string['taskquestioncron'] = 'Bakgrundsbearbetning för att rensa bort förhandsgranskade frågor';
$string['taskquestionstatscleanupcron'] = 'Bakgrundsbearbetning av uppstädning av cachen för frågestatistik';
$string['taskrefreshsystemtokens'] = 'Uppdatera OAuthtoken för tjänstekonton';
$string['taskregistrationcron'] = 'Webbplatsregistrering';
$string['tasksendfailedloginnotifications'] = 'Skicka notiser om misslyckade inloggningar';
$string['tasksendnewuserpasswords'] = 'Skicka nya lösenord';
$string['tasksessioncleanup'] = 'Städa upp gamla sessioner';
$string['taskstatscron'] = 'Bakgrundsbearbetning av statistik';
$string['tasktagcron'] = 'Bakgrundsbearbetning av etiketter';
$string['tasktempfilecleanup'] = 'Ta bort döda tempfiler';
$string['tasktype'] = 'Typ';
$string['tempdatafoldercleanup'] = 'Städa upp temporära datafiler äldre än';
$string['templates'] = 'Mallar';
$string['testoutgoingmailconf'] = 'Testa konfiguration för utgående E-post';
$string['testoutgoingmailconf_errorcommunications'] = 'Webbplatsen kunde inte kommunicera med din e-postserver. Vänligen kontrollera inställningarna för utgående e-post.';
$string['testoutgoingmailconf_fromemail'] = 'Från användarnamn eller E-postadress';
$string['testoutgoingmailconf_fromemail_help'] = 'Det här fältet emulerar att skicka meddelandet från den användaren, men från-huvudet som används i det verkliga e-postmeddelandet som skickas beror på andra inställningar som t.ex. <em>Tillåtna e-postdomäner</em>.';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Ogiltigt Från-användarnamn eller E-post. Måste vara ett giltigt användarnamn  i Moodle eller E-postadress';
$string['testoutgoingmailconf_message'] = 'Detta är ett testmeddelande för att bekräfta att du konfigurerat webbplatsens utgående e-post korrekt.

Skickades: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Skicka ett testmeddelande';
$string['testoutgoingmailconf_sentmail'] = 'Den här webbplatsen har skickat ett testmeddelande till e-post servern.<br />Från: {$a->fromemail}<br />Till: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: testmeddelande. {$a->additional} Skickat: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Ytterligare ämne';
$string['testoutgoingmailconf_toemail'] = 'E-postmottagare';
$string['testoutgoingmaildetail'] = 'OBS! Spara inställningarna innan du testar.<br />{$a}';
$string['testsiteupgradewarning'] = 'Du använder för närvarande testwebbplatsen {$a}. För att uppgradera den korrekt, använd kommandoradsverktyget';
$string['themedesignermode'] = 'Temadesignläge';
$string['themedesignermodewarning'] = 'Tema-designläget är aktiverat. Detta bör inte vara aktiverat på produktionsservrar då det väsentligt reducerar prestandan för webbplatsen.';
$string['themelist'] = 'Lista över teman';
$string['themeresetcaches'] = 'Töm cachminnet på teman';
$string['themeselect'] = 'Ändra tema';
$string['themeselector'] = 'Temaväljare';
$string['therewereerrors'] = 'Det fanns fel i dina data';
$string['thirdpartylibrary'] = 'Bibliotek';
$string['thirdpartylibrarylocation'] = 'Plats';
$string['thirdpartylibs'] = 'Tredjepartsbibliotek';
$string['timezone'] = 'Förvald tidszon';
$string['timezoneforced'] = 'Det här är fastställt av systemadministratören';
$string['timezoneinvalid'] = 'Ogiltig tidszon "{$a}"';
$string['timezoneisforcedto'] = 'Tvinga alla användare att använda';
$string['timezonenotforced'] = 'Användare kan själva välja sin egen tidszon';
$string['timezonephpdefault'] = 'Förvald PHP-tidszon ({$a})';
$string['timezoneserver'] = 'Servertidszon ({$a})';
$string['tlswarning'] = 'Inget PHP/cURL-tillägg med stöd för TLSv1.2 har upptäckts. Vissa tjänster kanske inte fungerar. Det rekommenderas starkt att uppgradera dina TLS-bibliotek.';
$string['tokenduration'] = 'Giltighetstid för användartoken';
$string['tokenduration_desc'] = 'Anger giltighetstiden för webbtjänsttoken skapade av en användare (t.ex. via mobilappen).';
$string['tokenizerrecommended'] = 'Vi rekommenderar att du installerar det valfria tillägget PHP Tokenizer - det förbättrar funktionaliteten för nätverk med Moodle.';
$string['tools'] = 'Administratörsverktyg';
$string['toolsmanage'] = 'Hantera verktyg';
$string['unattendedoperation'] = 'Operation som inte monitoreras';
$string['unbookmarkthispage'] = 'Ta bort bokmärke för den här sidan';
$string['unicoderequired'] = 'Det är ett krav att du lagrar alla dina data i Unicode (UTF-8). Nya installationer måste genomföras i databaser som har Unicode som förvald standardinställning för teckenuppsättningar. Om du uppgraderar så bör du genomföra processen för migration till UTF-8 (se sidan för administration).';
$string['uninstallplugin'] = 'Avinstallera';
$string['unlockaccount'] = 'Lås upp konto';
$string['unoconvwarning'] = 'Den installerade versionen av <em>unoconv</em> stöds inte.';
$string['unsupported'] = 'Stödjs inte';
$string['unsupporteddbfileformat'] = 'Databasen använder Antelope som filformat. Fullständigt UTF-8-stöd i MySQL och MariaDB kräver Barracuda-filformatet. Byt till Filformatet Barracuda. Se dokumentationen <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">MySQL full unicode support</a> för mer information.';
$string['unsupporteddbfilepertable'] = 'För fullt stöd för UTF-8 kräver både MySQL och MariaDB att du ändrar din MySQL-inställning <code>innodb_file_per_table</code> till "<b>ON</b>". Se dokumentationen för mer information.';
$string['unsupporteddblargeprefix'] = 'För fullt stöd för UTF-8 kräver både MySQL och MariaDB att du ändrar din MySQL-inställning <code>innodb_large_prefix</code> till "<b>ON</b>". Se dokumentationen för mer information.';
$string['unsupporteddbstorageengine'] = 'Denna databaslagringsmotor stöds inte längre.';
$string['unsupporteddbtablerowformat'] = 'Databasen har tabeller med Antelope som filformat. Du rekommenderas att konvertera tabellerna till filformatet Barracuda. Se dokumentationen <a href="https://docs.moodle.org/en/cli">Administration via kommandorad</a> för mer information om ett verktyg för att konvertera InnoDB-tabeller till Barracuda.';
$string['unsupportedphpversion7'] = 'PHP version 7 och senare stöds inte.';
$string['unsupportedphpversion71'] = 'PHP version 7.1 och senare stöds inte.';
$string['unsupportedphpversion72'] = 'PHP version 7.2 och senare stöds inte.';
$string['unsupportedphpversion73'] = 'PHP version 7.3 och senare stöds inte.';
$string['unsupportedphpversion74'] = 'PHP version 7.4 och senare stöds inte.';
$string['unsupportedphpversion80'] = 'PHP version 8.0 och senare stöds inte.';
$string['unsupportedphpversion81'] = 'PHP version 8.1 och senare stöds inte.';
$string['unsupportedphpversion82'] = 'PHP version 8.2 eller senare stöds ej.';
$string['unsuspenduser'] = 'Aktivera användarkonto';
$string['updateaccounts'] = 'Uppdatera befintliga konton';
$string['updateautocheck'] = 'Sök automatiskt efter nya uppdateringar';
$string['updateautocheck_desc'] = 'Om aktiverad, kommer din webbplats att automatiskt söka efter nya uppdateringar både för Moodle och alla installerade pluginmoduler. Om det finns en ny uppdatering kommer ett meddelande att skickas till administratörerna.';
$string['updateavailable'] = 'Det finns en nyare version av Moodle';
$string['updateavailable_moreinfo'] = 'Mer info...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Version {$a}';
$string['updateavailabledetailslink'] = 'Gå till {$a->url} för ytterligare information.';
$string['updateavailableforplugin'] = 'Det finns en nyare version för några av dina pluginmoduler';
$string['updateavailableinstall'] = 'Installera uppdatering';
$string['updateavailableinstallall'] = 'Installera uppdateringar ({$a})';
$string['updateavailableinstallallhead'] = 'Installerar uppdateringar';
$string['updateavailablenot'] = 'Moodle använder senaste versionen!';
$string['updateavailablerecommendation'] = 'Du bör uppdatera Moodle till den här versionen för att få de senaste säkerhetsuppdateringarna och buggrättningarna.';
$string['updatecomponent'] = 'Uppdatera';
$string['updateminmaturity'] = 'Obligatorisk kodmognad';
$string['updateminmaturity_desc'] = 'Meddela om nya uppdateringar endast om den tillgängliga koden minst har den valda mognadsnivån. Uppdateringar för pluginmoduler som inte deklarerar sin kodmognadsnivå rapporteras alltid oavsett denna inställning.';
$string['updatenotificationfooter'] = 'Din Moodlewebbplats {$a->siteurl} har konfigurerats för att automatiskt söka efter nya uppdateringar. Du får detta meddelande eftersom du är administratör för denna webbplats. Du kan stänga av den automatiska sökningen genom att gå till <em>Hantera webbplats &#10132; Server &#10132; Uppdateringsnotiser</em> eller genom att ändra dina personliga inställningar för aviseringar under <em>Mina inställningar &#10132; Notisinställningar</em>.';
$string['updatenotifications'] = 'Uppdateringsinformation';
$string['updatenotificationsubject'] = 'Det finns en nyare version av Moodle ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Notifiera vid nya kodbyggen';
$string['updatenotifybuilds_desc'] = 'Om aktiverat rapporteras om nya uppdateringar för Moodle även när ett nytt <em>bygge</em> för den aktuella versionen är tillgängligt. Byggen är kontinuerliga förbättringar av en given Moodle-version. De släpps i allmänhet varje vecka. Om inaktiverat kommer nya versioner att rapporteras endast när det finns en högre <em>version</em> av Moodle tillgänglig. Uppdateringskontroller för pluginmoduler påverkas inte av den här inställningen.';
$string['upgradeerror'] = 'Okänt fel vid uppgradering av {$a->plugin} till version {$a->version}. Kan inte fortsätta.';
$string['upgradeforumread'] = 'En ny egenskap har lagts till i Moodle 1.5. Den innebär att man kan spåra lästa/olästa inlägg. <br />För att använda denna funktion behöver du <a href="{$a}">uppdatera dina tabeller</a>.';
$string['upgradeforumreadinfo'] = 'En ny egenskap har lagts till i Moodle 1.5. Den innebär att man kan spåra lästa/olästa inlägg. För att använda denna funktion behöver du uppdatera dina tabeller med all spårande information för befintliga inlägg. Beroende på hur stor din webbplats är så kan detta ta en hel del tid och utgöra en belastning på din databas. Därför är det bäst om du kan göra detta under en lugn period. Din webbplats kommer emellertid att fortsätta att fungera under denna uppgradering och användarna kommer inte att påverkas. När du väl har påbörjat denna process så bör du också fullfölja den (lämna webbläsarens fönter öppet). Skulle du råka stänga det och avbryta processen så är det ingen stor olycka. Du kan börja om igen. Vill du påbörja processen för uppgradering nu?';
$string['upgradekeyreq'] = 'Uppgraderingsnyckel krävs';
$string['upgradekeyset'] = 'Uppgraderingsnyckel (lämna tom för att inte ange någon)';
$string['upgradelogs'] = 'För att du ska kunna utnyttja all funktionalitet så måste dina gamla loggar uppgraderas. <a href="{$a}">Mer information</a>';
$string['upgradelogsinfo'] = 'En del förändringar har nyligen gjorts när det gäller hur loggarna lagras. För att Du ska kunna se alla Dina gamla loggar per aktivitet s a s så måste Dina gamla loggar uppgraderas. Detta kan ta lång tid, beroende på hur Din webbplats fungerar och det kan vara rätt krävande för databasen om det är en stor webbplats. När Du väl har påbörjat den här processen så bör Du också slutföra den (genom att hålla webbläsarens fönster öppet). Var dock inte orolig för Dina användare, webbplatsen bör fungera normalt för dem medan detta pågår. <br /><br /> Vill Du uppdatera Dina loggar nu?';
$string['upgradepluginsfirst'] = 'Du rekommenderas att först installera alla tillgängliga uppdateringar';
$string['upgradepluginsinfo'] = 'Uppdaterar plugins';
$string['upgradepluginsinfo_help'] = 'Det finns nya uppdateringar för några av dina pluginmoduler. Du bör installera dem innan du uppgraderar Moodle-databasen. Om din webbplats inte stöder automatiska uppdateringar måste du ladda ner och installera nya pluginversioner på servern manuellt.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Nya inställningar';
$string['upgradesettingsintro'] = 'Inställningarna här nedan lades till under din senaste uppgradering. Gör eventuella ändringar av de förvalda standardinställningarna och klicka sedan på <strong>Spara</strong> längst ned på den här sidan.';
$string['upgradestalefiles'] = 'Blandade Moodle versioner upptäckta, uppgraderingen kan inte fortsätta';
$string['upgradestalefilesinfo'] = 'Moodle-uppdateringsprocessen har pausats eftersom PHP-skript från minst två huvudversioner av Moodle har upptäckts i Moodle-katalogen.

Detta kan orsaka betydande problem senare, så för att fortsätta måste du se till att Moodle-katalogen bara innehåller filer från en enskild version av Moodle.

Det rekommenderade sättet att rensa Moodle-katalogen är följande:

* byt namn på den aktuella Moodle-katalogen till "moodle_old"
* skapa en ny Moodle-katalog som endast innehåller filer från antingen en standard nedladdning av Moodle-paket eller från Moodle Git-lagringsplatsen
* flytta den ursprungliga config.php-filen och eventuella icke-standardiserade plugins från katalogen "moodle_old" till den nya Moodle-katalogen

När du har en ren Moodle-katalog uppdaterar du den här sidan för att återuppta Moodle-uppdateringsprocessen.

Denna varning orsakas ofta då ett standard Moodle-paket packas upp över en tidigare version av Moodle. Även om detta är OK för mindre uppgraderingar, avråds det starkt från att göra detta för stora Moodle-uppgraderingar.

Den här varningen kan också orsakas av en ofullständig utchecknings- eller uppdateringsåtgärd från Git-databasen, i vilket fall du kanske bara måste vänta på att åtgärden ska slutföras, eller kanske köra lämpligt rensningskommando och försöka utföra åtgärden igen.

Mer information finns i uppgraderingsdokumentationen på <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Uppgradera nu';
$string['upgradesure'] = '<p>Dina Moodlefiler har ändrats och du är på väg att uppgradera servern till följande version:</p>
<p><strong>{$a}</strong></p>
<p>När du gör detta går det inte att ångra. Vänligen observera att den här processen kan ta lång tid.</p>
<p>Är du säker på att du vill uppgradera servern till den här versionen?</p>';
$string['upgradetimedout'] = 'Uppgraderingen avbröts, v.g. starta om den.';
$string['upgradingdata'] = 'Uppgraderar data';
$string['upgradinglogs'] = 'Uppgraderar loggarna';
$string['upgradingversion'] = 'Uppgraderar till en ny version';
$string['upwards'] = 'uppåt';
$string['useblogassociations'] = 'Aktivera associationer';
$string['user'] = 'Användare';
$string['userbulk'] = 'Masshantering av användare';
$string['userbulkdownload'] = 'Exportera användare som';
$string['userdefaultpreferences'] = 'Standardinställningar för användare';
$string['userfeedbackafterupgrade'] = 'Efter varje större uppgradering';
$string['userfeedbackencouragement'] = '<p>I Moodle 3.9 och framåt ingår en ny funktion som ger användarna möjlighet att ge feedback om Moodle-programvara till Moodle HQ via en extern undersökningswebbplats som drivs av Moodle HQ. Ingen användaridentifierande information vidarebefordras till undersökningswebbplatsen.</p>
<p>Moodle HQ strävar efter att vara öppet och transparent om sina datainsamlingsmetoder. Således vill vi försäkra oss om att du är medveten om och har kontroll över den här funktionen.</p>
<p>Feedback från användare kommer i hög grad att hjälpa Moodle HQ att förbättra Moodle-programvaran. Om du vill aktivera den här funktionen går du till <a href="{$a}">Feedback-inställningar</a>.</p>';
$string['userfeedbacknextreminder'] = 'Nästa feedbackpåminnelse';
$string['userfeedbacknextreminder_desc'] = 'När ska vi be användaren att ge feedback igen?';
$string['userfeedbackperiodically'] = 'Periodvis';
$string['userfeedbackremindafter'] = 'Visa påminnelse efter';
$string['userfeedbackremindafter_desc'] = 'Påminn användarna igen om att ge feedback efter det angivna antalet dagar.';
$string['userfiltersdefault'] = 'Användarfilter';
$string['userfiltersdefault_desc'] = 'Välj de filter som ska visas på sidan \'Användarlista\' och på sidan \'Hantera användare i bulk\'. Håll ned Ctrl-tangenten för att markera flera objekt. Eventuella filter som inte är valda blir tillgängliga genom att klicka på länken \'Visa mer\'.';
$string['userimagesdisabled'] = 'Profilbilder har inaktiverats.';
$string['userlist'] = 'Användarlista';
$string['usermanagement'] = 'Användarhantering';
$string['userpolicies'] = 'Användarprinciper';
$string['userpreference'] = 'Inställningar för användare';
$string['userquota'] = 'Filutrymme för användare';
$string['userquota_desc'] = 'Den maximala mängden data som varje användare kan lagra i sitt privata filområde.';
$string['users'] = 'Användare';
$string['usesitenameforsitepages'] = 'Använd webbplatsnamnet för webbplatssidor';
$string['usetags'] = 'Aktivera etiketter';
$string['validateemptylineerror'] = 'Tomma rader är inte giltiga';
$string['validateerror'] = 'Detta värde är ogiltigt';
$string['validateerrorlist'] = 'Dessa poster är ogiltiga: {$a}';
$string['validateiperror'] = 'Dessa IP-adresser är ogiltiga: {$a}';
$string['verifychangedemail'] = 'Begränsa domäner när det görs ändringar av e-postadresser';
$string['warningcurrentsetting'] = 'Ogiltigt aktuellt värde: {$a}';
$string['warningiconvbuggy'] = 'Aktuell version av iconv-biblioteket stöder inte //IGNORE-växeln. Du bör installera mbstring-tillägget i stället, för att städa strängar som innehåller ogiltiga UTF-8-tecken.';
$string['webproxy'] = 'Webb proxy';
$string['webproxyinfo'] = 'Fyll i följande alternativ om din Moodle-server inte har direktåtkomst till internet. Åtkomst till internet är nödvändig för att du ska kunna ladda ner miljödata, språkpaket, RSS-flöden, tidszoner, etc.<br /><em>PHP cURL-tillägget rekommenderas.</em>';
$string['xmlrpcwebserviceenabled'] = 'Det har upptäckts att XML-RPC-protokollet är aktiverat på webbplatsen. Den här funktionen förlitar sig på PHP XML-RPC-tillägget som inte längre underhålls av PHP.';
$string['yuicomboloading'] = 'Laddar YUI combo';
$string['ziprequired'] = 'PHP-tillägget zip krävs nu av Moodle. Info-ZIP binärfiler eller PclZip-biblioteket används inte längre.';
