<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_dynamicrule', language 'id', version '5.0'.
 *
 * @package     tool_dynamicrule
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['active'] = 'Aktif';
$string['activerules'] = 'Aturan aktif';
$string['addcondition'] = 'Tambahkan kondisi';
$string['addconditions'] = 'Tambahkan kondisi untuk aturan ini';
$string['addoutcome'] = 'Tambahkan tindakan';
$string['addoutcomes'] = 'Tambahkan tindakan untuk aturan ini';
$string['any'] = 'Apa pun';
$string['applyon'] = 'Terapkan pada';
$string['archive'] = 'Arsip';
$string['archived'] = 'Diarsip';
$string['archivedrules'] = 'Aturan yang diarsip';
$string['availableplaceholders'] = 'Tempat penampung yang tersedia';
$string['body'] = 'Badan';
$string['cachedef_conditions'] = 'Menyimpan daftar kondisi aturan dinamis dan event yang perlu didengarkan.';
$string['cannotdisablerule'] = 'Anda tidak memiliki hak yang cukup untuk menonaktifkan aturan ini \'{$a}\'';
$string['cannotdisablesharedrule'] = 'Aturan bersama \'{$a}\' hanya dapat dinonaktifkan dari ruang bersama.';
$string['cannotenablecomponentrule'] = 'Tidak dapat mengaktifkan aturan \'{$a}\' kecuali aturan tersebut memiliki tindakan dan tidak mengandung kesalahan apa pun.';
$string['cannotenablerule'] = 'Tidak dapat mengaktifkan aturan \'{$a}\' kecuali memiliki kondisi, tindakan, dan tidak mengandung kesalahan apa pun.';
$string['cannotenablesharedrule'] = 'Aturan bersama \'{$a}\' hanya dapat diaktifkan dari ruang bersama.';
$string['cohort'] = 'Kohor';
$string['conditioncohortmember'] = 'Pengguna anggota kohor';
$string['conditioncohortmemberdescription'] = 'Pengguna yang merupakan anggota kohor \'{$a}\'';
$string['conditioncohortmemberdescriptionwithdate'] = 'Pengguna yang merupakan anggota kohor \'{$a->name}\'<br />
Ditambahkan ke kohor pada atau setelah: \'{$a->conditiondate}\'';
$string['conditioncohortnotmember'] = 'Pengguna bukan anggota kohor';
$string['conditioncohortnotmemberdescription'] = 'Pengguna yang bukan anggota kohor \'{$a}\'';
$string['conditioncompetencydescription'] = 'Pengguna yang telah mencapai kompetensi \'{$a}\'';
$string['conditioncompetencyselector'] = 'Pilih kompetensi';
$string['conditioncompetencyselector_help'] = 'Pilih kompetensi untuk menemukan pengguna yang mencapainya';
$string['conditioncompetencytitle'] = 'Pengguna telah mencapai kompetensi';
$string['conditioncoursecompleted'] = 'Kursus selesai';
$string['conditioncoursecompletedafter'] = 'Tanggal penyelesaian setelah {$a}';
$string['conditioncoursecompletedbefore'] = 'Tanggal penyelesaian sebelum {$a}';
$string['conditioncoursecompleteddescription'] = 'Pengguna yang telah menyelesaikan kursus \'{$a}\'';
$string['conditioncoursecompletedgradeany'] = 'Nilai kursus apa pun';
$string['conditioncoursecompletedgradegreaterthan'] = 'Nilai kursus lebih besar dari {$a}%';
$string['conditioncoursecompletedgradelessthan'] = 'Nilai kursus kurang dari {$a}%';
$string['conditioncoursecompletedgraderange'] = 'Nilai kursus antara {$a->value}% dan {$a->value2}%';
$string['conditioncourselastaccess'] = 'Akses terakhir kursus';
$string['conditioncourselastaccessdescriptionafter'] = 'Pengguna yang terakhir mengakses kursus \'{$a->coursename}\' sejak {$a->conditiondate}';
$string['conditioncourselastaccessdescriptionbefore'] = 'Pengguna yang terakhir mengakses kursus \'{$a->coursename}\' sebelum {$a->conditiondate}';
$string['conditioncourselastaccessdescriptionbeforelast'] = 'Pengguna yang belum mengakses kursus \'{$a->coursename}\' pada {$a->conditiondate}';
$string['conditioncourselastaccessdescriptionever'] = 'Pengguna yang telah mengakses kursus \'{$a->coursename}\' setidaknya sekali';
$string['conditioncourselastaccessdescriptioninlast'] = 'Pengguna yang telah mengakses kursus \'{$a->coursename}\' pada {$a->conditiondate} terakhir';
$string['conditioncourselastaccessdescriptionnever'] = 'Pengguna yang belum pernah mengakses kursus \'{$a->coursename}\'';
$string['conditioncourselastaccessnotice'] = 'Ketentuan ini berlaku bagi pengguna yang terdaftar dalam kursus.';
$string['conditioncoursenotcompleted'] = 'Kursus belum selesai';
$string['conditioncoursenotcompleteddescription'] = 'Pengguna yang belum menyelesaikan kursus \'{$a}\'';
$string['conditioncoursenotcompletedformnotice'] = 'Kondisi ini berlaku kepada pengguna tanpa memandang pendaftaran mereka pada kursus.';
$string['conditioncriteria'] = 'Kriteria';
$string['conditioncriterianotavailableyet'] = 'Belum tersedia';
$string['conditionisbroken'] = 'Kondisi ini mengandung galat.';
$string['conditionisnotavailable'] = 'Kondisi ini tidak tersedia.';
$string['conditionnotsaved'] = 'Kondisi tidak disimpan.';
$string['conditionruledate'] = 'Dari {$a->startdate}';
$string['conditionruledateuntil'] = 'Dari {$a->startdate} hingga {$a->enddate}';
$string['conditions'] = 'Kondisi';
$string['conditionusercreated'] = 'Waktu sejak pengguna dibuat';
$string['conditionusercreateddescriptionbefore'] = 'Pengguna yang dibuat selama {$a} terakhir';
$string['conditionusercreateddescriptionover'] = 'Pengguna yang dibuat sebelum {$a} terakhir';
$string['conditionuserenrolled'] = 'Pengguna terdaftar';
$string['conditionuserenrolleddescription'] = 'Pengguna yang terdaftar dalam kursus \'{$a->course}\'<br />
Metode pendaftaran: \'{$a->enrol}\'';
$string['conditionuserenrolleddescriptionwithdate'] = 'Pengguna yang terdaftar dalam kursus \'{$a->course}\'<br />
Metode pendaftaran: \'{$a->enrol}\'<br />
Tanggal mulai pendaftaran pada atau setelah: \'{$a->conditiondate}\'';
$string['conditionuserfirstlogindescriptionever'] = 'Pengguna yang pertama kali login setidaknya sekali';
$string['conditionuserfirstlogindescriptioninlast'] = 'Pengguna yang pertama kali masuk pada {$a} terakhir';
$string['conditionuserfirstlogindescriptionover'] = 'Pengguna yang pertama kali masuk antara {$a->startdate} hingga {$a->enddate}';
$string['conditionuserlastlogin'] = 'Masuk terakhir pengguna';
$string['conditionuserlastlogindescriptionbefore'] = 'Pengguna yang terakhir masuk sebelum {$a} terakhir';
$string['conditionuserlastlogindescriptionever'] = 'Pengguna yang telah login setidaknya sekali';
$string['conditionuserlastlogindescriptioninlast'] = 'Pengguna yang masuk selama {$a} terakhir';
$string['conditionuserlastlogindescriptionnever'] = 'Pengguna yang belum pernah masuk';
$string['conditionusernotenrolled'] = 'Pengguna tidak terdaftar';
$string['conditionusernotenrolleddescription'] = 'Pengguna yang tidak terdaftar dalam kursus \'{$a->course}\'<br />
Metode pendaftaran: \'{$a->enrol}\'';
$string['conditionuserprofilefield'] = 'Kolom profil pengguna';
$string['conditionuserprofilefielddescription'] = 'Pengguna yang nilainya untuk kolom profil \'{$a->fieldname}\' adalah \'{$a->fieldvalue}\'';
$string['conditionuserprofilefielddescriptiontext'] = 'Pengguna yang nilainya untuk kolom profil \'{$a->fieldname}\' {$a->fieldvalue}';
$string['confirmarchiverule'] = 'Apakah Anda yakin ingin mengarsipkan aturan \'{$a}\'? Aturan dinamis yang diarsipkan akan tetap tersedia untuk laporan saat ini dan mendatang.';
$string['confirmdeletecondition'] = 'Apakah Anda yakin ingin menghapus kondisi \'{$a}\' dan semua data terkait? Tindakan ini tidak dapat dibatalkan.';
$string['confirmdeleteoutcome'] = 'Apakah Anda yakin ingin menghapus tindakan \'{$a}\' dan semua data terkait? Tindakan ini tidak dapat dibatalkan.';
$string['confirmdeleterule'] = 'Apakah Anda yakin ingin menghapus aturan \'{$a}\' dan semua data terkait? Tindakan ini tidak dapat dibatalkan.';
$string['confirmduplicaterule'] = 'Apakah Anda yakin ingin menduplikasi aturan \'{$a}\'?';
$string['confirmduplicateruleconflicts'] = 'Aturan tersebut berisi entitas yang tidak dapat digunakan dalam aturan non-bersama dan akan dihilangkan:';
$string['confirmeditrule'] = 'Karena beberapa pengguna pernah mengikuti aturan ini sebelumnya, Anda hanya dapat menyunting tindakan aturan. Anda dapat mempertimbangkan untuk menduplikasinya guna mengubah ketentuannya';
$string['confirmenablecomponentrule'] = 'Apakah Anda yakin ingin mengaktifkan aturan ini? Mengaktifkannya akan memengaruhi pengguna {$a}.';
$string['confirmenablerule'] = 'Kondisi akan terkunci jika setidaknya satu pengguna terpengaruh oleh aturan ini. Apakah Anda yakin ingin mengaktifkan aturan ini?';
$string['countmatchingusers'] = '{$a} total kecocokan';
$string['coursecompletiondate'] = 'Tanggal penyelesaian';
$string['coursegrade'] = 'Nilai kursus';
$string['coursegrade_help'] = 'Pilih persentase untuk mencocokkan pengguna yang telah mencapai nilai kursus dalam rentang yang ditentukan. Nilai dibulatkan hingga 5 angka desimal. Perbandingan lebih besar dan lebih kecil bersifat ketat.';
$string['courseinternalid'] = 'ID kursus internal yang digunakan di URL';
$string['courselastaccesstime'] = 'Akses kursus terakhir pengguna';
$string['courselastaccesstime_help'] = 'Perlu diketahui bahwa aturan ini hanya akan diterapkan satu kali kepada pengguna yang cocok, sehingga tidak dapat digunakan untuk pengingat berulang kepada pengguna yang sudah lama tidak mengakses kursus.<br />Perlu diketahui juga bahwa setelah pengguna terdaftar pada kursus, mereka dapat langsung cocok dengan kondisi "Tidak pernah mengakses".';
$string['courseurl'] = 'URL Kursus';
$string['creationdate'] = 'Tanggal pembuatan';
$string['creationdate_help'] = 'Anda dapat memilih tanggal yang relatif terhadap tanggal saat ini untuk mencocokkan pengguna yang dibuat dalam periode waktu yang ditentukan.';
$string['dateinthefuture'] = 'Berada di masa mendatang';
$string['dateinthepast'] = 'Berada di masa lampau';
$string['datelast'] = '{$a} hari terakhir';
$string['datelastdays'] = '... hari terakhir';
$string['datelastplural'] = '{$a} hari terakhir';
$string['datenext'] = '{$a} hari berikutnya';
$string['datenextdays'] = '... hari berikutnya';
$string['datenextplural'] = '{$a} hari berikutnya';
$string['datetypeever'] = 'Pernah';
$string['datetypeinlast'] = 'Selama yang terakhir ...';
$string['datetypenever'] = 'Tidak pernah';
$string['datetypenone'] = 'Tidak diatur';
$string['datetypepast'] = 'Sebelum yang terakhir...';
$string['datetyperange'] = 'Rentang';
$string['deletecondition'] = 'Hapus kondisi';
$string['deleteoutcome'] = 'Hapus tindakan';
$string['disablerulemsg'] = 'Hapus aturan';
$string['duplicate'] = 'Duplikat';
$string['dynamicrule:manage'] = 'Kelola aturan dinamis';
$string['editanyway'] = 'Sunting saja';
$string['editcondition'] = 'Sunting kondisi';
$string['editdetails'] = 'Sunting rincian aturan \'{$a}\'';
$string['editoutcome'] = 'Sunting tindakan';
$string['editrulename'] = 'Sunting nama aturan \'{$a}\'';
$string['enable'] = 'Aktifkan';
$string['enabled'] = 'Diaktifkan';
$string['enablehelp'] = 'mengaktifkan aturan';
$string['enablehelp_help'] = 'Suatu aturan mengharuskan setidaknya satu kondisi dan satu tindakan untuk diaktifkan. Selain itu, kondisi atau tindakan tidak boleh mengandung kesalahan.';
$string['enablehelpmodal'] = 'mengaktifkan aturan';
$string['enablehelpmodal_help'] = 'Suatu aturan mengharuskan setidaknya satu tindakan untuk diaktifkan.';
$string['enablerulemsg'] = 'Aktifkan aturan';
$string['enddate'] = 'Tanggal akhir';
$string['enddate_help'] = 'Tanggal akhir yang dipilih akan berfungsi sebagai batas waktu tetap untuk mengevaluasi aturan.';
$string['errorbadgehasextracriteria'] = 'Lencana ini memiliki kriteria lain yang diperlukan selain masalah manual, sehingga tidak dapat dikeluarkan berdasarkan aturan dinamis';
$string['errorbadgenopermission'] = 'Anda tidak memiliki peran yang diperlukan untuk menerbitkan lencana ini';
$string['errorcannotcreate'] = 'Anda tidak memiliki izin untuk membuat aturan';
$string['errorcannoteditaftermatchedusers'] = 'Satu atau beberapa pengguna telah memenuhi aturan ini setelah halaman ini dimuat. Kondisi tidak dapat lagi diedit atau dihapus.';
$string['errorcannotmanage'] = 'Anda tidak memiliki izin untuk mengelola aturan ini';
$string['errorcannotmanagecondition'] = 'Anda tidak memiliki izin untuk mengelola kondisi ini';
$string['errorcannotmanageoutcome'] = 'Anda tidak memiliki izin untuk mengelola tindakan ini';
$string['errorcohortnotamember'] = 'Tidak dapat menghapus pengguna dari kohor karena pengguna bukan anggota kohor ini';
$string['errorcompletionnotenabled'] = 'Penyelesaian tidak diaktifkan untuk kursus ini';
$string['errorinvalidbadge'] = 'Lencana tidak valid';
$string['errorinvalidbody'] = 'Badan pemberitahuan tidak valid';
$string['errorinvalidcertificatetenant'] = 'Sertifikat tidak dapat digunakan di penyewa ini';
$string['errorinvalidcohort'] = 'Kohor tidak valid';
$string['errorinvalidcohorttenant'] = 'Kohor tidak dapat digunakan di penyewa ini';
$string['errorinvalidcompetency'] = 'Kompetensi tidak valid';
$string['errorinvalidcourse'] = 'Kursus tidak valid';
$string['errorinvalidcoursetenant'] = 'Kursus tidak dapat digunakan di penyewa ini';
$string['errorinvaliddates'] = 'Tanggal mulai dan akhir tidak valid';
$string['errorinvalidenrolmentmethod'] = 'Kursus ini tidak memiliki metode pendaftaran yang dipilih atau tidak diaktifkan';
$string['errorinvalidlearningplan'] = 'Rencana pembelajaran tidak valid';
$string['errorinvalidoperator'] = 'Operator tidak valid.';
$string['errorinvalidsubject'] = 'Subyek pemberitahuan tidak valid';
$string['errorinvaliduserfirstlogin'] = 'Tanggal login pertama tidak valid';
$string['errorinvaliduserfirstlogintype'] = 'Tipe login pertama tidak valid';
$string['errorinvaliduserlastcourseaccess'] = 'Tanggal akses kursus terakhir tidak valid';
$string['errorinvaliduserlastlogin'] = 'Tanggal login terakhir tidak valid';
$string['errorinvaliduserlastlogintype'] = 'Tipe login terakhir tidak valid';
$string['errorinvaliduserprofilefield'] = 'Kolom profil tidak valid';
$string['errorinvaliduserprofilefieldvalue'] = 'Nilai kolom profil tidak valid';
$string['errorinvalidvalue'] = 'Nilai tidak valid';
$string['errornopermissionissuecertificate'] = 'Anda tidak memiliki izin untuk menerbitkan sertifikat ini';
$string['eventconditionadded'] = 'Kondisi aturan dinamis ditambahkan';
$string['eventconditiondeleted'] = 'Kondisi aturan dinamis dihapus';
$string['eventconditionupdated'] = 'Kondisi aturan dinamis diperbarui';
$string['eventoutcomeadded'] = 'Tindakan aturan dinamis ditambahkan';
$string['eventoutcomedeleted'] = 'Tindakan aturan dinamis dihapus';
$string['eventoutcomeupdated'] = 'Tindakan aturan dinamis diperbarui';
$string['eventrulearchived'] = 'Aturan dinamis diarsip';
$string['eventrulecreated'] = 'Aturan dinamis dibuat';
$string['eventruledeleted'] = 'Aturan dinamis dihapus';
$string['eventruleunarchived'] = 'Aturan dinamis tidak diarsip';
$string['eventruleupdated'] = 'Aturan dinamis diperbarui';
$string['ever'] = 'pernah';
$string['exporterdescription'] = 'Definisi, kondisi, dan tindakan aturan dinamis';
$string['exportselectactive'] = 'Pilih semua aturan Dinamis (kecuali yang diarsip)';
$string['exportselectall'] = 'Pilih semua aturan Dinamis (termasuk yang diarsip)';
$string['exportselectenabled'] = 'Pilih semua aturan Dinamis yang diaktifkan';
$string['exportsettings'] = 'Definisi aturan, kondisi dan tindakan';
$string['exportsettings_help'] = 'Semua aturan akan dinonaktifkan saat diimpor, apa pun status aslinya.';
$string['field'] = 'Kolom';
$string['filterrulename'] = 'Nama aturan';
$string['firstlogin'] = 'Login pertama pengguna';
$string['firstlogin_help'] = 'Anda dapat memilih pengguna yang pertama kali masuk selama kurun waktu tertentu atau dalam periode relatif terhadap tanggal saat ini, serta pengguna yang pertama kali masuk kapan saja atau belum pernah masuk.';
$string['future'] = 'Masa mendatang';
$string['general'] = 'Umum';
$string['greaterthan'] = 'Lebih besar dari';
$string['importlogerror'] = 'Tidak dapat mengimpor aturan \'{$a}\'';
$string['importlogerrorinvalidcondition'] = 'Kondisi aturan hilang atau tidak valid';
$string['importlogerrorinvalidoutcome'] = 'Hasil aturan hilang atau tidak valid';
$string['importlogsuccess'] = 'Membuat aturan baru \'{$a->name}\' dengan kondisi {$a->conditionscount} dan tindakan {$a->outcomescount}';
$string['importlogsuccesslink'] = 'Membuat aturan baru \'<a href="{$a->url}">{$a->name}</a>\' dengan kondisi {$a->conditionscount} dan tindakan {$a->outcomescount}';
$string['importselectall'] = 'Pilih semua aturan Dinamis dalam file ini';
$string['importselectspecified'] = 'Pilih secara manual...';
$string['includesuspendedusers'] = 'Sertakan pengguna yang ditangguhkan';
$string['includesuspendedusers_help'] = 'Jika dicentang, aturan akan mengevaluasi kondisi juga terhadap pengguna yang akunnya ditangguhkan di situs ini. Aturan kemudian akan mencoba menerapkan tindakan ke semua pengguna yang cocok. Perlu diingat bahwa beberapa tindakan mungkin tidak berlaku sepenuhnya untuk pengguna yang ditangguhkan, misalnya, mereka tidak pernah menerima pemberitahuan.';
$string['lastlogin'] = 'Login terakhir pengguna';
$string['lastlogin_help'] = 'Anda dapat memilih tanggal yang relatif terhadap tanggal saat ini atau pengguna yang belum pernah masuk.';
$string['lessthan'] = 'Kurang dari';
$string['limitreached'] = 'Batas aturan dinamis tercapai';
$string['limitreacheddescr'] = 'Anda telah mencapai batas jumlah aturan dinamis di situs ini. Harap perhatikan bahwa aturan yang diarsipkan juga dihitung dalam batas ini.';
$string['limitreachednumdescr'] = 'Anda hanya dapat membuat {$a} aturan dinamis di situs ini. Harap perhatikan bahwa aturan yang diarsipkan juga dihitung dalam batasan ini.';
$string['managebadges'] = 'Kelola lencana';
$string['managecohorts'] = 'Kelola kohor';
$string['managecompetencies'] = 'Kelola kompetensi';
$string['match'] = 'Cocok';
$string['matchedtime'] = 'Cocok di';
$string['matchlimitinvalid'] = 'Aturan perlu dipicu setidaknya satu kali.';
$string['matchstatus'] = 'Status';
$string['matchstatusdone'] = 'Selesai';
$string['matchstatuserror'] = 'Gagal';
$string['matchstatuspending'] = 'Tertunda';
$string['matchstatusprogress'] = 'Sedang berlangsung';
$string['messageprovider:notificationoutcome'] = 'Tindakan pemberitahuan untuk alat aturan dinamis';
$string['missingcondition'] = 'Kondisi hilang';
$string['missingconditiondescr'] = 'Kondisi \'{$a->condition}\' tidak ada dalam pengaya \'{$a->plugin}\'.';
$string['missingoutcome'] = 'Tindakan hilang';
$string['missingoutcomedescr'] = 'Tindakan \'{$a->outcome}\' tidak ada dalam pengaya \'{$a->plugin}\'.';
$string['newnameforrule'] = 'Nama baru untuk aturan \'{$a}\'';
$string['newrule'] = 'Aturan baru';
$string['noavailablebadges'] = 'Tidak ada lencana yang tersedia';
$string['noavailablecohorts'] = 'Tidak ada kohor yang tersedia';
$string['noavailablecompetencies'] = 'Tidak ada kompetensi yang tersedia';
$string['noavailablecompletioncourses'] = 'Tidak ada kursus yang penyelesaiannya diaktifkan';
$string['noavailableenrolledcourses'] = 'Tidak ada kursus di mana Anda dapat mengakses daftar peserta';
$string['noruleconditions'] = 'Tidak ada kondisi pada aturan ini';
$string['noruleoutcomes'] = 'Tidak ada tindakan pada aturan ini';
$string['operatorafter'] = 'Setelah';
$string['operatoranytime'] = 'Kapan pun';
$string['operatorbefore'] = 'Sebelum';
$string['outcomeactivatedesc'] = 'Aktifkan semua pengguna yang terpengaruh';
$string['outcomebadge'] = 'Lencana penghargaan';
$string['outcomebadgedescription'] = 'Lencana penghargaan \'{$a}\' kepada pengguna';
$string['outcomecertificate'] = 'Terbitkan sertifikat';
$string['outcomecertificatedescription'] = 'Terbitkan sertifikat \'{$a}\' kepada pengguna';
$string['outcomecohort'] = 'Tambahkan ke kohor';
$string['outcomecohortbroken'] = 'Kohor dengan ID \'{$a}\' tidak ada.';
$string['outcomecohortdescription'] = 'Tambahkan pengguna ke kohor \'{$a}\'';
$string['outcomecohortremove'] = 'Hapus dari kohor';
$string['outcomecohortremovedescription'] = 'Hapus pengguna dari kohor \'{$a}\'';
$string['outcomecompetency'] = 'Kompetensi penghargaan';
$string['outcomecompetencybroken'] = 'Kompetensi dengan ID \'{$a}\' tidak ada.';
$string['outcomecompetencydescription'] = 'Kompetensi penghargaan \'{$a}\' kepada pengguna';
$string['outcomedeletedesc'] = 'Hapus semua pengguna yang terpengaruh';
$string['outcomedeleteuser'] = 'Hapus pengguna';
$string['outcomedeleteuserdescription'] = 'Hapus pengguna sehingga mereka tidak lagi ada dalam sistem';
$string['outcomedeleteuserwarning'] = 'Peringatan: Tindakan ini dapat menghapus pembuat aturan, dan berpotensi menghapus semua data Anda (yang tidak dapat dibatalkan). Lanjutkan dengan hati-hati.';
$string['outcomeisbroken'] = 'Tindakan ini mengandung galat.';
$string['outcomeisnotavailable'] = 'Tindakan ini tidak tersedia.';
$string['outcomelearningplan'] = 'Tetapkan rencana pembelajaran';
$string['outcomelearningplanbroken'] = 'Templat rencana pembelajaran dengan ID \'{$a}\' tidak ada.';
$string['outcomelearningplandescription'] = 'Tetapkan templat rencana pembelajaran \'{$a}\' ke pengguna';
$string['outcomelearningplanunassign'] = 'Batalkan penetapan rencana pembelajaran';
$string['outcomelearningplanunassigndescription'] = 'Batalkan penetapan templat rencana pembelajaran \'{$a}\' dari pengguna';
$string['outcomenotification'] = 'Pemberitahuan';
$string['outcomenotificationdescription'] = 'Kirim pemberitahuan \'{$a}\' ke pengguna';
$string['outcomenotsaved'] = 'Tindakan tidak disimpan.';
$string['outcomes'] = 'Tindakan';
$string['outcomesuspenddesc'] = 'Tangguhkan semua pengguna yang terpengaruh';
$string['outcomesuspenduser'] = 'Tangguhkan pengguna';
$string['outcomesuspenduserdescription'] = 'Tangguhkan pengguna sehingga mereka tidak lagi dapat masuk dan menerima pemberitahuan';
$string['outcomesuspenduserwarning'] = 'Peringatan: Tindakan ini dapat menangguhkan pembuat aturan, yang berpotensi mengunci Anda dari sistem. Lanjutkan dengan hati-hati.';
$string['outcomeunsuspenduser'] = 'Aktifkan pengguna';
$string['outcomeunsuspenduserdescription'] = 'Aktifkan pengguna sehingga mereka dapat masuk dan menerima pemberitahuan';
$string['past'] = 'Masa lampau';
$string['per'] = 'per';
$string['placeholdersdesc'] = 'Tempat penampung';
$string['placeholdersdesc_help'] = 'Tempat penampung memungkinkan Anda menambahkan konten dinamis, mis. tempat penampung {{userfullname}} akan diganti dengan nama lengkap pengguna dalam pemberitahuan yang dikirimkan ke pengguna.';
$string['pluginname'] = 'Aturan dinamis';
$string['previewcoursefullname'] = 'Nama lengkap kursus';
$string['previewcourseshortname'] = 'Nama singkat kursus';
$string['privacy:metadata:tool_dynamicrule_match'] = 'Informasi tentang kecocokan pengguna dengan kondisi aturan tertentu. Akibat kecocokan tersebut, pengguna akan terpengaruh oleh tindakan yang ditetapkan dalam aturan.';
$string['privacy:metadata:tool_dynamicrule_match:matchedtime'] = 'Stempel waktu yang menunjukkan saat pengguna telah dicocokkan dengan kondisi aturan.';
$string['privacy:metadata:tool_dynamicrule_match:ruleid'] = 'ID aturan.';
$string['privacy:metadata:tool_dynamicrule_match:unmatchedtime'] = 'Stempel waktu yang menunjukkan saat pengguna tidak lagi cocok dengan kondisi aturan setelah tindakan diterapkan.';
$string['privacy:metadata:tool_dynamicrule_match:userid'] = 'ID pengguna yang telah dicocokkan dengan kondisi aturan.';
$string['quarter'] = 'Seperempat';
$string['range'] = 'Rentang';
$string['reg_wpdynamicrules'] = 'Jumlah aturan dinamis ({$a})';
$string['rolemanager'] = 'Manajer aturan dinamis';
$string['rolemanagerdescription'] = 'Memungkinkan untuk membuat dan mengelola aturan dinamis dalam penyewa saat ini';
$string['rulearchive'] = 'Arsip';
$string['ruleeditactions'] = 'Sunting tindakan';
$string['rulematchfreq'] = 'Batasan tindakan aturan';
$string['rulematchfreq_help'] = 'Begitu pengguna memenuhi ketentuan aturan, tindakan akan diterapkan kepada mereka. Tindakan ini tidak akan berlaku lagi jika pengguna terus memenuhi ketentuan. Namun, jika pengguna berhenti memenuhi ketentuan lalu memenuhi ketentuan lagi, tindakan dapat diterapkan lagi. Pengaturan ini menentukan jumlah maksimum tindakan yang harus diterapkan.';
$string['rulematchfreqdesc0'] = 'Tidak dapat diterapkan lebih dari';
$string['rulematchfreqdesc1'] = 'kali';
$string['rulematchfreqenable'] = 'Batasi jumlah kali tindakan diterapkan ke setiap pengguna';
$string['rulename'] = 'Nama';
$string['rulenamecopy'] = '{$a->name} Salin {$a->number}';
$string['rulenotfound'] = 'Aturan tidak ditemukan.';
$string['ruleselectitemarchived'] = '{$a} (diarsip)';
$string['ruleunarchive'] = 'Batalkan arsip';
$string['ruleviewreport'] = 'Lihat laporan';
$string['scheduledtask'] = 'Tugas terjadwal';
$string['seedetails'] = 'Lihat rinciannya';
$string['seemore'] = 'Lihat selengkapnya...';
$string['select'] = 'Pilih';
$string['selectbadge'] = 'Pilih lencana';
$string['selectbadge_help'] = 'Hanya lencana situs yang menggunakan kriteria eksklusif \'masalah manual berdasarkan peran\' yang memenuhi syarat untuk diberikan oleh Dynamic Rules.';
$string['selectcertificate'] = 'Pilih sertifikat';
$string['selectcompetency'] = 'Pilih kompetensi';
$string['selectcompetency_help'] = 'Pilih kompetensi yang akan diterbitkan';
$string['selectlearningplan'] = 'Pilih rencana pembelajaran';
$string['selectlearningplan_help'] = 'Pilih templat rencana pembelajaran';
$string['sendto'] = 'Kirim ke';
$string['sendtodptlead'] = 'Pimpinan departemen';
$string['sendtomanager'] = 'Manajer';
$string['sendtomanualmanager'] = 'Manajer yang ditetapkan secara manual';
$string['sendtomatching'] = 'Mencocokkan pengguna';
$string['sitelink'] = 'Tautan situs';
$string['sitelinkspecific'] = 'Tautan situs khusus untuk penyewa';
$string['siteshortname'] = 'Nama singkat situs';
$string['startdate'] = 'Tanggal mulai';
$string['startdate_help'] = 'Tanggal mulai yang dipilih akan menandai dimulainya evaluasi aturan. Peristiwa yang memengaruhi kondisi seperti "kursus selesai" dapat terjadi kapan saja sebelum atau sesudah tanggal yang dipilih.';
$string['subject'] = 'Subyek';
$string['tagarea_tool_dynamicrule'] = 'Aturan dinamis';
$string['taskprocessrules'] = 'Aturan proses';
$string['timeadded'] = 'Ditambahkan ke kohor pada atau setelah tanggal dan waktu ini';
$string['timecreated'] = 'Dibuat';
$string['timeenrolled'] = 'Tanggal dan waktu mulai pendaftaran pada atau setelah';
$string['timeprocessed'] = 'Diproses di';
$string['toomanybadgestoshow'] = 'Terlalu banyak lencana untuk ditampilkan';
$string['toomanycertificatestoshow'] = 'Terlalu banyak sertifikat ({$a}) untuk ditampilkan';
$string['toomanycohortstoshow'] = 'Terlalu banyak kohor ({$a}) untuk ditampilkan';
$string['toomanycompetenciestoshow'] = 'Terlalu banyak kompetensi ({$a}) untuk ditampilkan';
$string['toomanylptoshow'] = 'Terlalu banyak rencana pembelajaran ({$a}) untuk ditampilkan';
$string['uneditabledescription'] = '{$a} (rincian tidak tersedia)';
$string['userdetailshidden'] = 'Rinciannya disembunyikan';
$string['userfirstlogin'] = 'Pengguna pertama kali masuk';
$string['viewmatchingusers'] = 'Lihat pengguna yang cocok';
$string['warningchangeswillnotapplymatchedusers'] = 'Perubahan ini tidak akan berlaku bagi pengguna yang sesuai dengan aturan ini di masa lampau';
