<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_quickmail', language 'pt_br', version '5.0'.
 *
 * @package     block_quickmail
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Ações';
$string['additional_emails'] = 'E-mails adicionais';
$string['additional_emails_help'] = 'Outros endereços de e-mail para os quais você gostaria que a mensagem fosse enviada, em uma lista separada por vírgulas ou ponto e vírgula. Exemplo:

 email1@exemplo.com, email2@exemplo.com';
$string['additionalemail'] = 'Permitir e-mails para endereços de e-mail externos';
$string['additionalemail_desc'] = 'Se esta opção estiver habilitada, o remetente terá a capacidade de enviar mensagens para e-mails adicionais fora do Moodle';
$string['all_in_course'] = 'Todos no Curso';
$string['allow_mentor_copy'] = 'Permitir que os remetentes enviem automaticamente mensagens aos mentores dos destinatários';
$string['allow_mentor_copy_help'] = 'Se não, esta opção não será visível para os remetentes e os mentores nunca serão copiados. Se sim, o remetente terá a opção de escolher por mensagem. Se forçado, esta opção será forçada sem opção de desmarcar.';
$string['allowstudents'] = 'Permitir que os estudantes usem o Quickmail';
$string['allowstudents_desc'] = 'Permitir que os estudantes usem o Quickmail. Se você escolher "Nunca", o bloco não poderá ser configurado para permitir o acesso dos estudantes no nível do curso.';
$string['alternate'] = 'E-mails alternativos';
$string['alternate_activated'] = 'E-mail alternativo {$a} agora pode ser usado!';
$string['alternate_already_confirmed'] = 'Esse e-mail já foi confirmado.';
$string['alternate_availability'] = 'Quem pode enviar deste e-mail?';
$string['alternate_availability_course'] = 'Todos os papéis permitidos em {$a->courseshortname}';
$string['alternate_availability_only'] = 'Somente eu, apenas em {$a->courseshortname}';
$string['alternate_availability_user'] = 'Somente eu, em qualquer curso';
$string['alternate_body'] = '<p>
{$a->fullname} adicionou {$a->email} como um endereço de envio alternativo para {$a->plugin_name}.
</p>

<p>
O propósito deste e-mail foi verificar se este endereço existe e se o proprietário deste endereço tem as permissões apropriadas no Moodle.
</p>

<p>
Se você deseja completar o processo de verificação, por favor, continue direcionando seu navegador para o seguinte URL: {$a->url}.
</p>

<p>
Se a descrição deste e-mail não fizer sentido para você, então você pode ter
recebido por engano. Simplesmente descarte esta mensagem.
</p>

Obrigado.';
$string['alternate_confirmation_email_resent'] = 'O e-mail de confirmação foi reenviado!';
$string['alternate_confirmed'] = 'Confirmado';
$string['alternate_created'] = 'E-mail alternativo criado com sucesso!';
$string['alternate_delete'] = 'Deletar Endereço Alternativo';
$string['alternate_delete_confirm'] = 'Isso deletará permanentemente seu e-mail alternativo, você tem certeza?';
$string['alternate_deleted'] = 'Seu e-mail alternativo foi deletado.';
$string['alternate_email_not_found'] = 'Não foi possível encontrar esse e-mail alternativo.';
$string['alternate_invalid_token'] = 'Token de confirmação inválido.';
$string['alternate_new'] = 'Adicionar Endereço Alternativo';
$string['alternate_owner_must_confirm'] = 'Deve ser o proprietário do e-mail para confirmar.';
$string['alternate_owner_must_delete'] = 'Deve ser o proprietário do e-mail para deletar.';
$string['alternate_resend_confirmation'] = 'Reenviar e-mail de confirmação';
$string['alternate_subject'] = 'Verificação de endereço de e-mail alternativo';
$string['alternate_waiting'] = 'Aguardando';
$string['altsendfrom'] = 'Permitir e-mails alternativos';
$string['altsendfrom_desc'] = 'Permitir e-mails alternativos (necessita de uma mudança no núcleo para isso).';
$string['attached_files'] = 'Arquivos Anexados ({$a})';
$string['attachments'] = 'Anexos';
$string['back_to_course'] = 'Voltar ao curso';
$string['back_to_mypage'] = 'Voltar à Minha página';
$string['backup_block_configuration'] = 'Configurações de Backup do Nível do Bloco Quickmail (Como [Permitir que os Estudantes usem o Quickmail])';
$string['backup_history'] = 'Incluir Histórico do Quickmail';
$string['body'] = 'Mensagem';
$string['broadcast'] = 'Compor Mensagem do Administrador';
$string['cachedef_qm_controller_store'] = 'Armazenamento em cache para instâncias de controladores.';
$string['cachedef_qm_event_notif_last_fired_at'] = 'Armazenamento em cache para carimbos de data/hora quando a notificação de evento foi disparada pela última vez.';
$string['cachedef_qm_msg_addl_email_count'] = 'Contagens de e-mails adicionais de mensagens em cache.';
$string['cachedef_qm_msg_attach_count'] = 'Contagens de anexos de mensagens em cache.';
$string['cachedef_qm_msg_deliv_count'] = 'Contagens de mensagens entregues em cache.';
$string['cachedef_qm_msg_recip_count'] = 'Contagens de destinatários de mensagens em cache.';
$string['compose'] = 'Compor Mensagem do Curso';
$string['condition_grade_greater_than'] = 'Nota maior que';
$string['condition_grade_less_than'] = 'Nota menor que';
$string['condition_summary_reminder_course_grade_range'] = 'Todos que têm uma nota entre {$a->grade_greater_than} e {$a->grade_less_than}';
$string['condition_summary_reminder_course_non_participation'] = 'Todos que não acessaram o curso em {$a->time_amount} {$a->time_unit}';
$string['could_not_duplicate'] = 'Não foi possível duplicar este rascunho. Por favor, tente novamente.';
$string['course_required'] = 'Um curso é necessário.';
$string['coursealternate_not_allowed'] = 'Você não pode compartilhar este e-mail alternativo neste curso.';
$string['courseferpa'] = 'Respeitar Modo do Curso';
$string['courseneveraccessed'] = 'Nunca Acessado';
$string['create_new'] = 'Criar Novo';
$string['create_notification'] = 'Criar Notificação';
$string['create_notification_message'] = 'Criar Mensagem de Notificação {$a->model} {$a->type}';
$string['create_notification_message_description'] = 'Agora crie a mensagem que você gostaria que fosse enviada quando esta notificação for disparada.';
$string['created'] = 'Criado';
$string['critical_error'] = 'Erro crítico';
$string['default_message_type'] = 'Método de envio de mensagem preferido';
$string['default_message_type_configuration'] = 'Esta configuração será o método de envio padrão para qualquer pessoa que compuser uma mensagem neste curso. O remetente poderá substituir ao compor a mensagem.';
$string['default_message_type_configuration_help'] = 'Esta configuração será o método de envio padrão para qualquer pessoa que compuser uma mensagem neste curso. O remetente poderá substituir ao compor a mensagem.';
$string['default_message_type_desc'] = 'Envie suas mensagens como Mensagens do Moodle ou e-mail tradicional.';
$string['delete_draft_confirm_message'] = 'Isso deletará permanentemente seu rascunho de mensagem, você tem certeza?';
$string['delete_draft_modal_title'] = 'Deletar Rascunho de Mensagem';
$string['delete_signature'] = 'Deletar Assinatura';
$string['delete_signature_confirm_message'] = 'Isso deletará permanentemente sua assinatura, você tem certeza?';
$string['delete_signature_modal_title'] = 'Deletar Assinatura';
$string['deleted'] = 'Deletado';
$string['download_file_content'] = 'Baixar Conteúdo do Arquivo';
$string['downloads'] = 'Requerer login para anexos';
$string['downloads_desc'] = 'Esta configuração determina se os anexos estão disponíveis apenas para usuários logados no Moodle';
$string['draft_no_record'] = 'Não foi possível encontrar esse rascunho de mensagem.';
$string['drafted'] = 'Rascunhado';
$string['drafts'] = 'Rascunhos';
$string['duplicate'] = 'Duplicar';
$string['duplicate_draft_confirm_message'] = 'Isso fará uma cópia do rascunho, você tem certeza?';
$string['duplicate_draft_modal_title'] = 'Duplicar Rascunho de Mensagem';
$string['edit'] = 'Editar';
$string['edit_conditions'] = 'Editar Condições';
$string['edit_event_details'] = 'Editar Detalhes do Evento';
$string['edit_message'] = 'Editar Mensagem';
$string['edit_messages'] = 'Editar Mensagens';
$string['edit_notification'] = 'Editar Notificação';
$string['edit_schedule'] = 'Editar Agenda';
$string['email_profile_fields'] = 'Campos de perfil de e-mail';
$string['email_profile_fields_desc'] = 'Esses campos de perfil serão automaticamente enviados por e-mail se estiverem configurados para o usuário destinatário.';
$string['enable_notification'] = 'Habilitar Notificação';
$string['eventalternateemailadded'] = 'E-mail alternativo adicionado';
$string['eventalternateemailadded_desc'] = 'O usuário com id {$a->user_id} adicionou um e-mail alternativo: {$a->email}';
$string['excluded_ids_label'] = 'Excluir';
$string['excluded_recipients_desc'] = 'Quem NÃO deve receber esta mensagem?';
$string['failed_recipients'] = 'Destinatários com Falha ou Pendentes';
$string['failed_recipients_promise'] = 'Continuaremos tentando enviar para esses destinatários até que a mensagem seja enviada com sucesso.';
$string['ferpa'] = 'Modo FERPA';
$string['ferpa_desc'] = 'Permite que o sistema se comporte de acordo com a configuração do modo de grupo do curso, ignorando a configuração do modo de grupo, mas separando grupos, ou ignorando grupos completamente.';
$string['found_filtered_users'] = 'Encontrado(s) {$a} usuário(s)';
$string['from_email'] = 'Endereço de e-mail do remetente';
$string['from_email_help'] = 'O endereço de e-mail do qual esta mensagem será enviada. Você pode adicionar endereços alternativos adicionais através do menu do bloco na página do curso.';
$string['here'] = 'aqui';
$string['included_ids_label'] = 'Para';
$string['included_recipients_desc'] = 'Quem deve receber esta mensagem?';
$string['invalid_additional_email'] = 'O e-mail adicional "{$a}" que você inseriu é inválido';
$string['invalid_additional_emails_validation'] = 'Alguns dos e-mails adicionais que você inseriu eram inválidos.';
$string['invalid_availability'] = 'Valor de disponibilidade inválido.';
$string['invalid_condition_grade_greater_than'] = 'Valor de nota maior que inválido.';
$string['invalid_condition_grade_less_than'] = 'Valor de nota menor que inválido.';
$string['invalid_condition_time_amount'] = 'Quantidade de tempo inválida para condição.';
$string['invalid_condition_time_unit'] = 'Unidade de tempo inválida para condição.';
$string['invalid_custom_data_delimiters'] = 'Códigos de substituição do corpo da mensagem não formatados corretamente.';
$string['invalid_custom_data_key'] = 'Chave de dados personalizada "{$a}" não é permitida.';
$string['invalid_custom_data_not_allowed'] = 'Códigos de substituição personalizados não são permitidos para esta mensagem.';
$string['invalid_email'] = 'Endereço de e-mail inválido.';
$string['invalid_notification_model'] = 'Seleção de modelo de notificação inválida.';
$string['invalid_notification_type'] = 'O tipo de notificação deve ser "Lembrete" ou "Evento".';
$string['invalid_schedule_time_amount'] = 'Quantidade de tempo inválida para agenda.';
$string['invalid_schedule_time_unit'] = 'Unidade de tempo inválida para agenda.';
$string['invalid_send_method'] = 'Esse método de envio não é permitido.';
$string['invalid_time_amount'] = 'Quantidade de tempo inválida.';
$string['invalid_time_relation'] = 'Deve ser "antes" ou "depois".';
$string['invalid_time_unit'] = 'Unidade de tempo inválida.';
$string['is_enabled'] = 'Habilitado';
$string['last_run_at'] = 'Última Execução';
$string['last_updated'] = 'Última Atualização';
$string['manage_alternates'] = 'E-mails Alternativos';
$string['manage_drafts'] = 'Ver Rascunhos';
$string['manage_signatures'] = 'Minhas Assinaturas';
$string['mentor_copy'] = 'Enviar cópias para mentores dos destinatários?';
$string['mentor_copy_help'] = 'Se selecionado, qualquer mentor dos seus destinatários receberá uma cópia da mensagem.';
$string['mentor_copy_message_prefix'] = '<p><strong>Você está recebendo esta mensagem porque você é designado como mentor de</strong>: {$a}. A seguir está uma cópia da mensagem que também foi enviada ao seu mentorado.</p>';
$string['mentor_copy_subject_prefix'] = '[Cópia do Mentor]';
$string['mentors_copied'] = 'Enviar cópias para mentores';
$string['message_deleted'] = 'Mensagem deletada';
$string['message_details'] = 'Detalhes da Mensagem';
$string['message_no_record'] = 'Não foi possível encontrar essa mensagem.';
$string['message_not_found'] = 'Não foi possível encontrar essa mensagem';
$string['message_preview'] = 'Pré-visualização da Mensagem';
$string['message_queued'] = 'Mensagem agendada para ser enviada';
$string['message_sent_asap'] = 'Mensagem será enviada em breve';
$string['message_sent_now'] = 'Mensagem enviada';
$string['message_type'] = 'Enviar mensagens do Quickmail como';
$string['message_type_available_all'] = 'Sem restrições, preferência do remetente';
$string['message_type_available_email'] = 'Restringir apenas para e-mail tradicional';
$string['message_type_available_message'] = 'Restringir apenas para mensagens do Moodle';
$string['message_type_desc'] = 'Permite que as mensagens do Quickmail sejam enviadas como uma mensagem do Moodle, e-mail tradicional, ou preferência do remetente.';
$string['message_type_email'] = 'E-mail';
$string['message_type_message'] = 'Mensagem do Moodle';
$string['message_types_available'] = 'Restrições de tipo de mensagem';
$string['message_types_available_desc'] = 'Restringir mensagens do Quickmail para serem enviadas como Mensagens do Moodle, e-mails tradicionais, ou preferência do remetente.';
$string['message_unqueued'] = 'Mensagem desagendada';
$string['messageprovider:quickmessage'] = 'Mensagem Quickmail';
$string['migrate'] = 'Migrar Dados';
$string['migrate_legacy_data_task'] = 'Migrar dados históricos do Quickmail v1 para v2';
$string['migration_chunk_size'] = 'Tamanho do Lote de Migração';
$string['migration_chunk_size_desc'] = 'Número de registros que devem ser processados pela tarefa de migração de dados legados cada vez que for executada, se habilitada.';
$string['missing_body'] = 'Corpo da mensagem ausente.';
$string['missing_email'] = 'Endereço de e-mail ausente.';
$string['missing_firstname'] = 'Primeiro nome ausente.';
$string['missing_lastname'] = 'Último nome ausente.';
$string['missing_notification_name'] = 'Nome da notificação ausente.';
$string['missing_subject'] = 'Linha de assunto ausente.';
$string['ms_alternate'] = 'E-mails Alternativos';
$string['ms_compose'] = 'Compor';
$string['ms_config'] = 'Configurar';
$string['ms_create_notification'] = 'Criar Notificação';
$string['ms_drafts'] = 'Rascunhos';
$string['ms_notifications'] = 'Notificações';
$string['ms_queued'] = 'Agendados';
$string['ms_sent'] = 'E-mails Enviados';
$string['ms_signatures'] = 'Minhas Assinaturas';
$string['must_be_draft_to_duplicate'] = 'A mensagem deve ser um rascunho para ser duplicada.';
$string['must_be_owner_to_duplicate'] = 'Desculpe, esse rascunho não pertence a você e não pode ser duplicado.';
$string['mute_time_summary'] = 'Tempo de Silenciamento';
$string['mute_time_unit'] = 'Tempo de Silenciamento';
$string['mute_time_unit_help'] = 'Uma quantidade opcional de tempo que deve passar entre o envio automático desta notificação.';
$string['never'] = 'Nunca';
$string['next_run_at'] = 'Próxima Execução';
$string['no_alternates'] = 'Você não tem e-mails alternativos. Crie um novo agora!';
$string['no_drafts'] = 'Você não tem rascunhos de mensagens.';
$string['no_excluded_recipients'] = 'Nenhum destinatário excluído';
$string['no_included_recipients'] = 'Nenhum destinatário incluído';
$string['no_included_recipients_validation'] = 'Você deve selecionar pelo menos um destinatário.';
$string['no_notifications'] = 'Você não tem notificações criadas.';
$string['no_queued'] = 'Você não tem mensagens agendadas.';
$string['no_sents'] = 'Você não tem histórico de mensagens enviadas.';
$string['no_signatures_create'] = 'Você não tem assinaturas. {$a}.';
$string['noferpa'] = 'Não respeitar configuração de grupos';
$string['notification_already_sent'] = 'Esta notificação já foi enviada pelo menos uma vez.';
$string['notification_conditions'] = 'Condições';
$string['notification_conditions_description'] = 'Especifique as condições desta notificação. Qualquer destinatário que atenda a essas condições será notificado.';
$string['notification_created'] = 'Notificação criada.';
$string['notification_deleted'] = 'Notificação deletada.';
$string['notification_is_enabled'] = 'Notificação Habilitada';
$string['notification_is_enabled_help'] = 'Se habilitado, esta notificação estará ativa, caso contrário, a notificação será desativada até que você a habilite.';
$string['notification_model'] = 'Modelo de Notificação';
$string['notification_model_event_course_entered'] = 'Curso Acessado';
$string['notification_model_event_course_entered_description'] = 'Notificar um participante do curso quando ele acessar o curso pela primeira vez.';
$string['notification_model_reminder_course_grade_range'] = 'Intervalo de Notas do Curso';
$string['notification_model_reminder_course_grade_range_condition_description'] = 'Especifique o intervalo de notas. Se um participante do curso atualmente estiver dentro desse intervalo, ele será notificado.';
$string['notification_model_reminder_course_grade_range_description'] = 'Notificar participantes do curso que atualmente têm uma nota dentro do intervalo especificado.';
$string['notification_model_reminder_course_non_participation'] = 'Não Participação no Curso';
$string['notification_model_reminder_course_non_participation_condition_description'] = 'Especifique a quantidade de tempo desde o último acesso ao curso. Se um participante do curso não acessou o curso nesse período de tempo, ele será notificado.';
$string['notification_model_reminder_course_non_participation_description'] = 'Notificar participantes do curso que não acessaram o curso em um determinado período de tempo.';
$string['notification_name'] = 'Título';
$string['notification_name_help'] = 'Uma breve descrição desta notificação para ajudá-lo a identificá-la facilmente de outras notificações que você possa ter configurado.';
$string['notification_name_too_long'] = 'O nome da notificação deve ter 40 caracteres ou menos.';
$string['notification_not_found'] = 'Não foi possível encontrar essa notificação.';
$string['notification_not_updated'] = 'Notificação atualizada.';
$string['notification_review'] = 'Revisar Sua Notificação';
$string['notification_schedule'] = 'Agenda';
$string['notification_type'] = 'Tipo de Notificação';
$string['notification_type_event'] = 'Evento';
$string['notification_type_event_description'] = 'Uma mensagem automatizada que é enviada como uma reação a um evento específico. Eventos podem ser usados para alertar destinatários que atividades foram concluídas, tarefas foram enviadas ou avaliadas, e mais.';
$string['notification_type_reminder'] = 'Lembrete';
$string['notification_type_reminder_description'] = 'Uma mensagem recorrente que será enviada automaticamente em uma base programada. Lembretes podem ser usados para alertar destinatários sobre atividades futuras, datas de vencimento, participação em aulas e mais.';
$string['notification_updated'] = 'Notificação atualizada.';
$string['notifications'] = 'Notificações';
$string['notifications_enabled'] = 'Habilitar Notificações do Quickmail';
$string['notifications_enabled_desc'] = 'Permitir que os cursos criem notificações automatizadas, incluindo lembretes e respostas a eventos.';
$string['notified_by'] = 'Notificado Por';
$string['open'] = 'Abrir';
$string['open_broadcast'] = 'Compor Mensagem';
$string['open_compose'] = 'Compor Mensagem';
$string['overwrite_history'] = 'Sobrescrever Histórico do Quickmail';
$string['pending_recipients'] = 'Destinatários Pendentes';
$string['pending_recipients_promise'] = 'Esses destinatários estão atualmente sendo enviados, volte mais tarde para ver quaisquer falhas.';
$string['picker_style_autocomplete'] = 'Autocompletar';
$string['picker_style_multiselect'] = 'Multiseleção';
$string['picker_style_option_title'] = 'Meu Estilo Preferido de Seleção de Destinatários';
$string['picker_style_option_title_help'] = 'Sua interface pessoalmente preferida para selecionar destinatários ao compor uma mensagem.';
$string['pluginname'] = 'Quickmail';
$string['prepend_class'] = 'Prefixar nome do curso';
$string['prepend_class_configuration'] = 'Prefixar informações de identificação do curso ao assunto da mensagem.';
$string['prepend_class_configuration_help'] = 'Prefixar informações de identificação do curso ao assunto da mensagem.';
$string['prepend_class_desc'] = 'Prefixar informações de identificação do curso ao assunto da mensagem. Esta configuração pode ser substituída pela configuração do curso.';
$string['preview_no_body'] = '(Sem conteúdo)';
$string['preview_no_subject'] = '(Sem assunto)';
$string['profile_mentor_copy_message_prefix'] = '<p><strong>Você está recebendo esta mensagem porque você é designado como {$a} do destinatário pretendido</strong>. A seguir está uma cópia do que foi enviado ao destinatário.</p>';
$string['queue_scheduled_notifications_task'] = 'Agendar qualquer notificação do Quickmail para ser enviada';
$string['queued'] = 'Agendado';
$string['queued_no_record'] = 'Não foi possível encontrar essa mensagem agendada.';
$string['quickmail:addinstance'] = 'Adicionar um novo bloco Quickmail à página do curso';
$string['quickmail:allowalternate'] = 'Criar endereços de e-mail alternativos para enviar';
$string['quickmail:allowcoursealternate'] = 'Criar endereços de e-mail alternativos para compartilhar com outros instrutores do curso';
$string['quickmail:canconfig'] = 'Configurar as configurações do Quickmail em um curso';
$string['quickmail:cansend'] = 'Enviar mensagens do Quickmail em um curso';
$string['quickmail:createnotifications'] = 'Criar notificações automáticas no Quickmail';
$string['quickmail:myaddinstance'] = 'Adicionar um novo bloco Quickmail à página /my';
$string['quickmail:viewgroupusers'] = 'Ver todos os usuários em todos os grupos';
$string['receipt'] = 'Receber um relatório de envio';
$string['receipt_configuration'] = 'Enviar um e-mail de confirmação para o remetente da mensagem quando a mensagem for enviada. Esta configuração será a preferência padrão para o remetente.';
$string['receipt_configuration_help'] = 'Enviar um e-mail de confirmação para o remetente da mensagem quando a mensagem for enviada. Esta configuração será a preferência padrão para o remetente.';
$string['receipt_email_body'] = '<p>Sua mensagem foi enviada! Você pode ver mais detalhes desta mensagem enviada {$a->sent_message_link}.</p>

<p>
    <strong>Resumo dos detalhes da mensagem:</strong><br><br>
    <strong>Curso:</strong> {$a->course_name}<br><br>
    <strong>Assunto da Mensagem:</strong> {$a->subject}<br><br>
    <strong>Destinatários:</strong> {$a->recipient_count}<br><br>
    <strong>E-mails de Destinatários Adicionais:</strong> {$a->addition_emails_string}<br><br>
    <strong>Enviado para Mentores:</strong> {$a->sent_to_mentors}<br><br>
    <strong>Contagem de Anexos de Arquivos:</strong> {$a->attachment_count}<br><br>
    <strong>Corpo da Mensagem:</strong>
</p>

{$a->message_body}';
$string['receipt_help'] = 'Enviar um e-mail de confirmação para o remetente da mensagem quando a mensagem for enviada por padrão. Esta configuração pode ser substituída pela configuração do curso.';
$string['recipients'] = 'Destinatários';
$string['redirect_back_from_message_detail_message_deleted'] = 'A mensagem que você está tentando visualizar foi deletada.';
$string['redirect_back_from_message_detail_no_access'] = 'Você não pode visualizar esta mensagem.';
$string['redirect_back_to_course_from_message_after_duplicate'] = 'Sua mensagem foi duplicada com sucesso.';
$string['redirect_back_to_course_from_message_after_save'] = 'Seu rascunho foi salvo.';
$string['redirect_back_to_course_from_notifications_not_enabled'] = 'As notificações do Quickmail estão desativadas para o seu site.';
$string['reset_success_message'] = 'As configurações padrão do Quickmail foram restauradas!';
$string['restore_default_confirm_message'] = 'Isso restaurará as configurações do Quickmail deste curso para o padrão, você tem certeza?';
$string['restore_default_modal_title'] = 'Restaurar Configuração Padrão';
$string['restore_history'] = 'Restaurar Histórico do Quickmail';
$string['save'] = 'Salvar';
$string['save_draft'] = 'Salvar Rascunho';
$string['save_signature'] = 'Salvar Assinatura';
$string['schedule_begin_at'] = 'Data de Início';
$string['schedule_end_at'] = 'Data de Término';
$string['scheduled_time'] = 'Hora Agendada';
$string['select_allowed_user_fields'] = 'Campos de dados do usuário suportados';
$string['select_allowed_user_fields_desc'] = 'Os remetentes poderão referenciar os campos selecionados para tornar o conteúdo da mensagem dinâmico e específico para o destinatário. Ex: "[:firstname:]"';
$string['select_message_type'] = 'Enviar mensagem como';
$string['select_notification_model'] = 'Selecione o Modelo de Notificação {$a}';
$string['select_signature_for_edit'] = 'Selecionar Assinatura Para Editar';
$string['selectable_roles'] = 'Funções selecionáveis';
$string['selectable_roles_configuration'] = 'Essas funções estarão disponíveis para seleção ao compor uma mensagem.';
$string['selectable_roles_configuration_help'] = 'Essas funções estarão disponíveis para seleção ao compor uma mensagem.';
$string['selectable_roles_desc'] = 'Essas funções estarão disponíveis para seleção ao compor uma mensagem. Esta configuração pode ser substituída pela configuração do curso.';
$string['send_all_ready_messages_task'] = 'Enviar todas as mensagens agendadas do Quickmail';
$string['send_as_tasks'] = 'Enviar todas as mensagens como tarefas em segundo plano.';
$string['send_as_tasks_help'] = 'Se selecionado, enviará todas as mensagens de forma assíncrona como tarefas cron. Caso contrário, enviará imediatamente.';
$string['send_at'] = 'Enviar em';
$string['send_message'] = 'Enviar Mensagem';
$string['send_now'] = 'Enviar Agora';
$string['send_now_scheduled_confirm_message'] = 'Isso esquecerá o agendamento e enviará a mensagem agora, você tem certeza?';
$string['send_now_scheduled_modal_title'] = 'Enviar Mensagem Agora';
$string['send_now_threshold'] = 'Limite de Envio Imediato';
$string['send_now_threshold_desc'] = 'Forçar uma mensagem não agendada a ser enviada imediatamente se o número de destinatários for este número ou menos, mesmo que o bloco esteja configurado para enviar mensagens como tarefas em segundo plano. Configuração de 0 ignorará esta configuração.';
$string['send_receipt_subject_addendage'] = 'Mensagem Enviada';
$string['send_schedule'] = 'Agendar Envio';
$string['sending'] = 'Enviando';
$string['sent'] = 'Enviado';
$string['sent_at'] = 'Enviado em';
$string['sent_messages'] = 'Histórico de Mensagens Enviadas';
$string['set_event_details'] = 'Definir Detalhes da Notificação de Evento {$a->model}';
$string['set_event_details_description'] = 'Especifique opções adicionais sobre o evento.';
$string['set_notification_conditions'] = 'Definir Condições de Notificação {$a->model} {$a->type}';
$string['set_notification_schedule'] = 'Definir Agenda de Notificação {$a->model} {$a->type}';
$string['set_notification_schedule_description'] = 'Especifique com que frequência esta notificação deve ser enviada, quando deve começar e quando deve terminar. Se nenhuma data de término for especificada, esta notificação continuará a ser enviada até que seja desativada ou deletada.';
$string['signature'] = 'Assinatura';
$string['signature_signature_required'] = 'Uma assinatura é necessária.';
$string['signature_title_must_be_unique'] = 'O título da assinatura deve ser único.';
$string['signature_title_required'] = 'Um título de assinatura é necessário.';
$string['signatures'] = 'Assinaturas';
$string['status'] = 'Status';
$string['strictferpa'] = 'Sempre Separar Grupos';
$string['subject'] = 'Assunto';
$string['success_recipients_promise'] = 'Esses destinatários foram todos enviados com sucesso pelo sistema.';
$string['time_amount'] = 'Quantidade de Tempo';
$string['time_beginning'] = 'Início';
$string['time_delay_summary'] = 'Atraso de Tempo';
$string['time_delay_unit'] = 'Atraso de Tempo';
$string['time_delay_unit_help'] = 'Uma quantidade opcional de tempo para esperar antes que a notificação seja enviada.';
$string['time_ending'] = 'Término';
$string['time_every'] = 'Todo';
$string['time_once_a'] = 'Uma vez por';
$string['time_relation'] = 'Antes ou Depois';
$string['time_unit'] = 'Unidade de Tempo';
$string['time_unit_day'] = 'Dia';
$string['time_unit_days'] = 'Dias';
$string['time_unit_month'] = 'Mês';
$string['time_unit_months'] = 'Meses';
$string['time_unit_week'] = 'Semana';
$string['time_unit_weeks'] = 'Semanas';
$string['title'] = 'Título';
$string['unqueue'] = 'Desagendar';
$string['unqueue_scheduled_confirm_message'] = 'Isso desagendará esta mensagem para ser enviada e salvará a mensagem como um rascunho, você tem certeza?';
$string['unqueue_scheduled_modal_title'] = 'Desagendar Mensagem Agendada';
$string['user_signature_deleted'] = 'Sua assinatura foi deletada.';
$string['validation_exception_message'] = 'Exceção de validação!';
$string['view'] = 'Ver';
$string['view_message_detail'] = 'Ver Detalhes da Mensagem';
$string['view_queued'] = 'Ver Agendados';
$string['view_sent'] = 'Ver Mensagens Enviadas';
