<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_pioneer', language 'es', version '5.0'.
 *
 * @package     theme_pioneer
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitybackground'] = 'Color de Fondo de la Actividad en Curso';
$string['activitybackground_desc'] = 'Este es el color de fondo de la caja cuando se muestran actividades tales como lección, tarea, etc.';
$string['allclasses'] = 'Todas las Clases';
$string['allcourses'] = 'Todos los Cursos';
$string['allmodules'] = 'Todos Los Módulos';
$string['allunits'] = 'Todas las Unidades';
$string['alwaysdisplay'] = 'Mostrar Siempre';
$string['analyticscleanurl'] = 'URL limpias';
$string['analyticscleanurldesc'] = 'Generar URL limpias para seguimiento avanzado';
$string['analyticsenabled'] = 'Activado';
$string['analyticsenableddesc'] = 'Activar analíticas para Moodle';
$string['analyticsheading'] = 'Analíticas Google';
$string['analyticssiteid'] = 'ID del Sitio';
$string['analyticssiteiddesc'] = 'Indique la ID de su Sitio';
$string['analyticstrackadmin'] = 'Seguimiento de Administradores';
$string['analyticstrackadmindesc'] = 'Activa el seguimiento de usuarios Administradores (no recomendable)';
$string['analyticstrackingid'] = 'ID del Sitio';
$string['analyticstrackingiddesc'] = 'Escriba su ID de seguimiento de Google';
$string['backgroundfixed'] = 'Fondo fijo';
$string['backgroundfixed_desc'] = 'Use este ajuste para fijar de la imagen de fondo de la página.';
$string['backgroundimage'] = 'Imagen de fondo';
$string['backgroundimage_desc'] = 'La imagen a mostrar como fondo del sitio.';
$string['backgroundimageinfo'] = 'Imagen de fondo';
$string['backgroundimageinfodesc'] = 'Dado que el contenido principal ocupa todo el ancho solo verá una pequeña porción del color de fondo al final de la página. Puede subir una imagen si lo desea.';
$string['backgroundposition'] = 'Posición del fondo';
$string['backgroundposition_desc'] = 'La posición de la imagen de fondo.';
$string['backgroundpositioncenterbottom'] = 'Centrado abajo';
$string['backgroundpositioncentercenter'] = 'Centrado en medio';
$string['backgroundpositioncentertop'] = 'Centrado arriba';
$string['backgroundpositionleftbottom'] = 'Izuierda abajo';
$string['backgroundpositionleftcenter'] = 'Izquierdo en medio';
$string['backgroundpositionlefttop'] = 'Izquierdo arriba';
$string['backgroundpositionrightbottom'] = 'Derecha abajo';
$string['backgroundpositionrightcenter'] = 'Derecha en medio';
$string['backgroundpositionrighttop'] = 'Derecha arriba';
$string['backgroundrepeat'] = 'Repetir fondo';
$string['backgroundrepeat_desc'] = 'Define la forma en que se repetirá la imagen de fondo.';
$string['backgroundrepeatnorepeat'] = 'Sin repetición';
$string['backgroundrepeatrepeat'] = 'Repetir';
$string['backgroundrepeatrepeatx'] = 'Repetir horizontalmente';
$string['backgroundrepeatrepeaty'] = 'Repetir verticalmente';
$string['blockbordercolor'] = 'Color del Borde del Bloque';
$string['blockbordercolor_desc'] = 'Este es el color del borde del bloque del curso. Es el color de fondo del área de título.';
$string['blockcolor'] = 'Color Bloque';
$string['blockcolor_desc'] = 'Este es el color de fondo del bloque de curso.';
$string['blockheadercolor'] = 'Color del Bloque de Cabecera';
$string['blockheadercolor_desc'] = 'Este es el color de fondo de la cabecera en cada bloque. Use este ajuste si quiere un color de fondo para la cabecera en todos los bloques.';
$string['blockposition'] = 'Alinear Bloques';
$string['blockposition_desc'] = 'Colocar los bloques a la izquierda o la derecha del contenido.';
$string['blocksdesc'] = 'Alinear los bloques en la izquierda o la derecha de la página.';
$string['blocksinfo'] = 'Posición del Bloque';
$string['blocksleft'] = 'Alinear los bloques a la izquierda';
$string['blocksright'] = 'Alinear los bloques a la derecha';
$string['blocktitlecolor'] = 'Color del Texto del Título del Bloque';
$string['blocktitlecolor_desc'] = 'Este es el color de texto del título del bloque.';
$string['bodybackground'] = 'Color de fondo';
$string['bodybackground_desc'] = 'El color principal a usar como fondo.';
$string['bodyfont'] = 'Cuerpo de la Fuente';
$string['bodyfontdesc'] = 'Copie y pegue el código de la fuente Google que empieza por font-family (Integra las fuentes en su CSS)';
$string['bodysize'] = 'Tamaño Cuerpo Texto';
$string['bodysizedesc'] = 'Use un número como 14px';
$string['bodyweight'] = 'Peso del Cuerpo';
$string['bodyweightdesc'] = 'Normalmente las fuentes Google tienen un número como 100, 00, 300, etc. Úselos aquí.';
$string['bothpositions'] = 'Ambas Posiciones';
$string['breadcrumbcolor'] = 'Color \'Migas de pan\'';
$string['breadcrumbcolor_desc'] = 'Elija un color de fondo para la barra de \'migas de pan\'. Está justo debajo de la imagen de la cabecera principal de la página.';
$string['breadcrumbcolorhover'] = 'Color Hover \'Migas de pan\'';
$string['breadcrumbcolorhover_desc'] = 'Elija el color de fondo de la barra de \'migas de pan\' cuando se pasa el ratón por encima de ella.  Está justo debajo de la imagen de la cabecera principal de la página.';
$string['breadcrumbtext'] = 'Color Texto \'Migas de pan\'';
$string['breadcrumbtext_desc'] = 'Elija el color del texto de las \'migas de pan\'.';
$string['choosereadme'] = '<p> Pioneer es un tema hermoso y adaptable cargado con grandes características desde pestañas personalizadas y un libro de calificaciones de curso deslizable a la capacidad para los profesores de subir su propia imagen de cabecera en los resúmenes de los cursos! Cada uno de los elementos principales del tema puede ser personalizado en la página de configuración del tema. Pioneer está desarrollado en Michigan en las Escuelas Públicas de Dearborn. </p> <p> Somos un distrito escolar K-12 en Dearborn, Michigan. Pioneer es la mascota de Dearborn High School. </p>';
$string['colorheading'] = 'Opciones de Color';
$string['configtitle'] = 'Pioneer';
$string['contentbackground'] = 'Color de fondo del área principal';
$string['contentbackground_desc'] = 'El color de fondo de contenido principal del sitio. Déjelo vacío para ninguno.';
$string['contentbackgroundcolor'] = 'Color de Fondo de Contenidos';
$string['contentbackgroundcolor_desc'] = 'Este es el color del fondo del área de contenido principal del curso. Si borra el color aquí se aplicará el color de Fondo del Cuerpo así como los ajustes de imagen de fondo.';
$string['copyrighttext'] = 'Nota de Copyright';
$string['copyrighttext_desc'] = 'Agregar una nota de copyrigth para el sitio. Aparecerá en el pie.';
$string['coursecomplete'] = 'Mostrar Cumplimiento del Curso de forma Radial';
$string['coursecomplete_desc'] = 'Si un curso utiliza cumplimiento del curso y está activado, Pioneer mostrará el estado del mismo de forma radial al estudiante arriba a la izquierda de la página.';
$string['coursegradebutton'] = 'Calificaciones del Curso';
$string['coursegradeinfo'] = 'Área de Cabecera del Curso (Pestañas Página principal y Calificaciones del Curso)';
$string['coursegradeinfodesc'] = 'Estos ajustes controlan el botón de desplazamiento que aparece en la página principal y del curso. Las calificaciones del curso muestran al estudiante todos los elementos calificables y su calificación. Las pestañas de la página principal necesitan que agregue contenido a las pestañas en la página de ajustes de Pestañas de la Página principal. A fin de que las calificaciones del curso que aparezcan, los ajustes del curso en Apariencia deben estar en Sí en \'Mostrar libro de calificaciones a los estudiantes\'.';
$string['coursegradestext'] = 'Texto del Botón de Calificaciones del Curso';
$string['coursegradestextdesc'] = 'Escriba el texto que quiera que aparezca para el botón de activación.';
$string['coursegradetoggle'] = 'Mostrar/Ocultar Deslizamiento Calificaciones del Curso';
$string['coursegradetoggle_desc'] = 'Permitirá a los estudiantes ver la lista de todas las actividades y su calificación justo encima del área de cabecera, encima de las \'migas de pan\' y debajo del título del curso.';
$string['coursetitlebkg'] = 'Color de Fondo del Título del Curso';
$string['coursetitlebkg_desc'] = 'Este es el color de la caja que aparece debajo del Título del Curso. Se utiliza también como color de fondo del Carrusel del Curso y los Títulos de los Cursos Disponibles para crear una apariencia consistente.';
$string['coursetitletxt'] = 'Color de Texto del Título del Curso';
$string['coursetitletxt_desc'] = 'Este es el color del texto del título del curso.';
$string['createusertoggle'] = 'Enlace Crear Usuario';
$string['createusertoggle_desc'] = 'Muestra u oculta el enlace de crear usuario en el formulario de inicio de sesión de la página principal.';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Las reglas CSS que agregue a este área se reflejarán en cada página facilitando la personalización del tema.';
$string['customlogindesc'] = 'Opciones Inicio Sesión personalizadas';
$string['customlogininfo'] = 'Inicio Sesión Personalizado';
$string['custommenudesc'] = 'Los ajustes permiten agregar nuevas funcionalidades dinámicas al menú personalizable (también conocido como menú Desplegable)';
$string['custommenuheadingsub'] = 'Agregar funcionalidad a su menú desplegable.';
$string['displayafterlogin'] = 'Mostrar solo después del inicio de sesión';
$string['displaybeforelogin'] = 'Mostrar solo antes del inicio de sesión';
$string['displaymycourses'] = 'Cursos Matriculados';
$string['displaymycoursesdesc'] = 'Muestra, en el Menú Personal, los cursos en que el usuario está matriculado';
$string['displaymydashboard'] = 'Mostrar Area personal';
$string['displaymydashboarddesc'] = 'Mostrar Area personal en el Menú Personalizado';
$string['dontdisplay'] = 'No mostrar nunca';
$string['editoff'] = 'Sin Edición';
$string['editon'] = 'Editar';
$string['enablethiscourse'] = 'Menú Actividades Curso';
$string['enablethiscoursedesc'] = 'Mostrar un menú desplegable con las actividades del curso.';
$string['footertext1'] = 'Caja de Texto Una Pie de Página';
$string['footertext2'] = 'Caja de Texto Dos Pie de Página';
$string['footertext3'] = 'Caja de Texto Tres Pie de Página';
$string['footertext4'] = 'Caja de Texto Cuatro Pie de Página';
$string['footertext_desc'] = 'Entre el texto HTML que aparecerá al pie de cada página. Se utiliza <span3> con Bootstrap dando 4 columnas.';
$string['footertextboxes'] = 'Pie de Página';
$string['forgotpasstoggle'] = 'Enlace Olvido Contraseña';
$string['forgotpasstoggle_desc'] = 'Muestra u oculta el enlace a Olvido de Contraseña en el formulario personalizable de inicio de sesión de la página principal.';
$string['fpcreatortextbox'] = 'Cuadro de texto Página Principal Rol Creador de Curso';
$string['fpcreatortextbox_desc'] = 'Agregar contenido solo visible para los usuarios con rol de Creador de Curso.';
$string['fpdashboard'] = 'Area personal Página Principal';
$string['fpheaderimagepadding'] = 'Relleno Imagen Cabecera Página Principal';
$string['fpheaderimagepadding_desc'] = 'Controla el relleno y la altura de la imagen en la página principal. El valor se aplica por encima y por debajo del formulario de inicio de sesión para usuarios que no hayan realizado la misma.';
$string['fpsearch'] = 'Buscar cursos';
$string['fpsearchboxmain'] = 'Mostrar Buscar Curso en área de Contenido Principal';
$string['fpsearchboxmain_desc'] = 'Muestra una caja de búsqueda de cursos en el área de la página principal. Esta opción depende de los ajustes de la navegación por iconos y solo se mostrará si la navegación por iconos está activada en el área de contenido.';
$string['fpsearchboxtop'] = 'Mostrar Buscar Curso en la barra de Navegación Principal';
$string['fpsearchboxtop_desc'] = 'Muestra una caja de búsqueda en la barra principal de navegación. Aparecerá en lo alto de la página, a la derecha de la navegación por iconos, y puede mostrarse incluso si no está activada la navegación por iconos. Esta caja de búsqueda es independiente de los ajustes de la navegación por iconos.';
$string['fpsearchbutton'] = 'Buscar';
$string['fptextbox'] = 'Caja de Texto Página Principal';
$string['fptextboxdesc'] = 'Esta caja aparece en la página principal y es ideal para poner un mensaje de bienvenida.';
$string['fptextboxinfo'] = 'Caja Bienvenida Página Principal';
$string['fptextboxinfodesc'] = 'Agregar un mensaje de bienvenida para los usuarios.';
$string['fptoppromotedpadding'] = 'Altura del carrusel de Cursos';
$string['fptoppromotedpadding_desc'] = 'Controla la altura de las imágenes del pase de diapositivas de los cursos.';
$string['frontpagecoursesettings'] = 'Cursos Página Principal';
$string['frontpagedesc'] = 'Configure la forma como se van a presentar las cajas de los cursos en la página principal.';
$string['frontpageheading'] = 'Opciones de la Página Principal';
$string['frontpagerenderer'] = 'Caja Cursos Página Principal';
$string['frontpagerendererdefaultimage'] = 'Imagen predeterminada del curso';
$string['frontpagerendererdefaultimagedesc'] = 'La imagen predeterminada que se utilizará cuando no se encuentra imagen para el curso (solo se aplica a mosaicos con superposición)';
$string['frontpagerendererdesc'] = 'Controla la forma en la que se van a presentar las cajas de los cursos en la página principal.';
$string['frontpagerendereroption1'] = 'Mosaico';
$string['frontpagerendereroption2'] = 'Mosaico con superposición';
$string['frontpagesettingsheading'] = 'Representación Página Principal';
$string['fullfootertext'] = 'Caja de texto todo ancho del pie de página';
$string['fullfootertext_desc'] = 'Es un cuadro de texto que ocupa todo el ancho y que aparece por encima de las 4 columnas de cajas de texto. Es ideal si no quiere utilizar los 4 cuadros de texto de más abajo.';
$string['gbodyimporturl'] = 'URL Importar Cuerpo';
$string['gbodyimporturldesc'] = 'CUERPO PASO 1: Encuentre una fuente en google.com/fonts. Pulse el icono "Select this font". Pulse sobre el cuadro de la fuente seleccionada. Copie y pegue el enlace aquí. Asegúrese de cumplimentar CUERPO PASO 2. <a href="https://www.google.com/fonts">Encontrar una fuente Google</a>';
$string['geneicsettings'] = 'Ajustes Generales';
$string['generalalert'] = 'Alerta General';
$string['generalalertdesc'] = 'Lo que añada a este área de texto se mostrará en la zona de Alerta General de la página principal.';
$string['gheadingimporturl'] = 'URL Importar Encabezado';
$string['gheadingimporturldesc'] = 'ENCABEZADO PASO 1: Encuentre una fuente en google.com/fonts. Pulse el icono "Select this font". Pulse sobre el cuadro de la fuente seleccionada. Copie y pegue el enlace aquí. Asegúrese de cumplimentar ENCABEZADO  PASO 2. <a href="https://www.google.com/fonts">Encontrar una fuente Google</a>';
$string['googleheading'] = 'Fuentes de Google';
$string['gradecomplete'] = 'Indicador Radial Calificación Total Curso';
$string['gradecomplete_desc'] = 'Si se activa un curso para que se muestren las calificaciones de estudiante, Pioneer mostrará la calificación total del curso en un indicador radial animado en la parte superior izquierda de la página del estudiante.';
$string['grades'] = 'Mis Calificaciones';
$string['headerbackgroundimage'] = 'Imagen de Cabecera predeterminada';
$string['headerbackgroundimage_desc'] = 'Esta es la imagen predeterminada.';
$string['headerbackgroundtoggle'] = 'Los profesores pueden subir imágenes de cabecera';
$string['headerbackgroundtoggle_desc'] = 'Si está activada, el profesor puede subir una imagen a <a href="https://docs.moodle.org/all/es/Configuraciones_del_curso#Archivos_del_resumen_del_curso" target="_new">Archivos Resumen del Curso</a>. Esta imagen debe ser pequeña para reducir el tiempo de carga. El tamaño recomendado es de un ancho de 1024 y un peso menor de 500KB. Si no lo está, todos los cursos utilizarán la imagen que se encuentra debajo como imagen de cabecera.';
$string['headerimageinfo'] = 'Altura Imagen de Cabecera';
$string['headerimageinfodesc'] = 'Estos ajustes controlan la altura de la imagen de la cabecera en el sitio y en las actividades del curso.';
$string['headerimagepadding'] = 'Relleno Imagen Cabecera';
$string['headerimagepadding_desc'] = 'Controla el relleno y la altura de la imagen en los cursos. Se debe seleccionar un mínimo de 120px si se utilizan los indicadores radiales para mostrar las calificaciones y el cumplimiento del curso.';
$string['headerimagepage'] = 'Ajustes Imagen de Cabecera';
$string['headerincourseimagepadding'] = 'Relleno Imagen Cabecera Actividades (en curso)';
$string['headerincourseimagepadding_desc'] = 'Después de la página del curso esta será la altura de relleno para la imagen de la cabecera. El harcerla pequeña permite que se muestre mas contenido';
$string['headingfont'] = 'Familia Fuente Encabezado';
$string['headingfontdesc'] = 'ENCABEZADO PASO 2: Copie y pegue la información de la font-family de Google aquí.';
$string['iconnavbackgroundcolor'] = 'Fondo Icono Contenido principal y Buscar en Navegación';
$string['iconnavbackgroundcolor_desc'] = 'Es el color de fondo para el icono de la barra de navegación y el área de búsqueda en la zona principal de contenido.';
$string['iconnavbackgroundcolortop'] = 'Fondo Navegación Iconos y Buscar';
$string['iconnavbackgroundcolortop_desc'] = 'Este es el color de fondo de la navegación con iconos y de la caja de búsqueda de cursos que se encuentran arriba a la derecha de la página.';
$string['iconnavheading'] = 'Iconos de Navegación';
$string['inmaincontent'] = 'Solo Contenido Principal';
$string['intopnav'] = 'Solo Barra Navegación Superior';
$string['invert'] = 'Invertir Barra Navegación';
$string['invertdesc'] = 'Intercambia los colores del fondo y del texto de la barra de navegación en lo alto de la página entre blanco y negro.';
$string['lginforgot'] = '¿no recuerda?';
$string['lginlogin'] = 'Inicio de Sesión';
$string['lginpass'] = 'contraseña';
$string['lginuser'] = 'nombre usuario';
$string['linkcolor'] = 'Color de enlaces';
$string['linkcolor_desc'] = 'El color de los enlaces.';
$string['loginbuttoncolor'] = 'Color del botón de Inicio de Sesión';
$string['loginbuttoncolor_desc'] = 'Este es color del botón del formulario personalizado de inicio de sesión.';
$string['logo'] = 'Logotipo';
$string['logodesc'] = 'El logotipo debe ser de 140px por 40px. Se mostrará arriba a la izquierda y abajo a la derecha del tema.';
$string['marketboxbuttoncolor'] = 'Color del Botón del Anuncio';
$string['marketboxbuttoncolor_desc'] = 'El color de fondo del botón para el anuncio.';
$string['marketboxcolor'] = 'Color de Fondo del Anuncio';
$string['marketboxcolor_desc'] = 'El color de fondo de la caja del anuncio.';
$string['marketboxcontentcolor'] = 'Color de Fondo del Contenido del Anuncio';
$string['marketboxcontentcolor_desc'] = 'El color de fondo del contenido de la caja del anuncio. Aquí es donde aparece el texto del anuncio y puede ser diferente del color del fondo de la caja donde aparece el texto que llama la atención.';
$string['marketing1'] = 'Anuncio Uno';
$string['marketing2'] = 'Anuncio Dos';
$string['marketing3'] = 'Anuncio Tres';
$string['marketing4'] = 'Anuncio Cuatro';
$string['marketing5'] = 'Anuncio Cinco';
$string['marketing6'] = 'Anuncio Seis';
$string['marketingbuttontext'] = 'Enlace Texto';
$string['marketingbuttontextdesc'] = 'Texto que aparecerá en el botón.';
$string['marketingbuttonurl'] = 'Enlace URL';
$string['marketingbuttonurldesc'] = 'La URL a la que apuntará el botón.';
$string['marketingcontent'] = 'Contenido';
$string['marketingcontentdesc'] = 'Contenido que se mostrará en el anuncio. Que sea bueno y breve.';
$string['marketingdesc'] = 'Este tema proporciona la posibilidad de mostrar tres "anuncios" justo debajo del carrusel. Esto le permite identificar información importante para sus usuarios y proporcionales enlaces directos.';
$string['marketingheading'] = 'Anuncios Abajo';
$string['marketingheadingsub'] = 'Tres localizaciones en la página principal para agregar información y enlaces';
$string['marketingheadingtextbox'] = 'Caja de texto Superior de los Anuncios';
$string['marketingheadingtop'] = 'Anuncios Arriba';
$string['marketingheight'] = 'Alto de las Imágenes del Anuncio';
$string['marketingheightdesc'] = 'Si quiere mostrar imágenes en la caja del anuncio debe especificar su alto aquí.';
$string['marketingicon'] = 'Enlace Icono';
$string['marketingicondesc'] = 'Nombre del icono que desea utilizar en el botón con la URL de ventas. La lita está <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>.  Entre lo que desea después de "fa-", p.e. "star".';
$string['marketingimage'] = 'Imagen';
$string['marketingimage_desc'] = 'Proporciona la posibilidad de mostrar una imagen en el anuncio';
$string['marketinginfodesc'] = 'Entre los ajustes de su anuncio.';
$string['marketingtitle'] = 'Título';
$string['marketingtitledesc'] = 'Título que se mostrará en este anuncio';
$string['marketingurltarget'] = 'Mostrar en';
$string['marketingurltargetdesc'] = 'Elija como se mostrará el enlace que se abrirá';
$string['marketingurltargetnew'] = 'Página nueva';
$string['marketingurltargetparent'] = 'Marco Padre';
$string['marketingurltargetself'] = 'Página actual';
$string['mybkg'] = 'Fondo Diapositivas Mis Cursos';
$string['mybkg_desc'] = 'Elija un color para el fondo de las diapositivas de Mis Cursos.';
$string['myclasses'] = 'Mis Clases';
$string['mycorusesinfo'] = 'Opciones Menú Navegable';
$string['mycorusesinfodesc'] = 'Estos ajustes controlan la barra de navegación superior incluyendo los menús desplegables Mis Cursos y Este Curso.';
$string['mycourses'] = 'Mis Cursos';
$string['mycoursesheading'] = 'Diapositivas Mis Cursos';
$string['mycoursesheadingdesc'] = 'Mostrará los cursos en los que un usuario está matriculado o está impartiendo. Se mostrarán en diapositivas adaptables, ideal para entornos de escritorio.';
$string['mycoursesinfo'] = 'Lista Cursos Matriculación Dinámica';
$string['mycoursesinfodesc'] = 'Muestra una lista dinámica de los cursos en que el usuario está matriculado.';
$string['mycoursetitle'] = 'Terminología';
$string['mycoursetitledesc'] = 'Cambiar la terminología para el enlace del menú desplegable "Mis Cursos"';
$string['mydashboardinfo'] = 'Personalizar Area personal del Usuario';
$string['mydashboardinfodesc'] = 'Muestra una lista de funciones comunes utilizadas por los usuarios.';
$string['mymodules'] = 'Mis Módulos';
$string['myunits'] = 'Mis Unidades';
$string['navbkgcolor'] = 'Fondo Barra Navegación Principal';
$string['navbkgcolor_desc'] = 'Es el color de fondo para la barra principal de navegación.';
$string['navcolor'] = 'Color Barra Navegación Desplegable';
$string['navcolor_desc'] = 'El color del menú desplegable en la barra de navegación.';
$string['navcolorhover'] = 'Color Menú Barra Navegación al Apuntar';
$string['navcolorhover_desc'] = 'El color del menú desplegable en la barra de navegación al pasar el ratón sobre él.';
$string['navicon'] = 'Icono';
$string['navicon1'] = 'Icono Personificado Página Principal Uno';
$string['navicon2'] = 'Icono Personificado Página Principal Dos';
$string['navicon3'] = 'Icono Personificado Página Principal Tres';
$string['navicon4'] = 'Icono Personificado Página Principal Cuatro';
$string['navicon5'] = 'Icono Personificado Página Principal Cinco';
$string['navicon6'] = 'Icono Personificado Página Principal Seis';
$string['navicon7'] = 'Icono Personificado Página Principal Siete';
$string['navicon8'] = 'Icono Personificado Página Principal Ocho';
$string['naviconbuttontext'] = 'Texto Ayuda';
$string['naviconbuttontextdesc'] = 'El texto que aparecerá cuando se pase el cursor del ratón sobre el icono.';
$string['naviconbuttonurl'] = 'Enlace URL';
$string['naviconbuttonurldesc'] = 'La URL a la que apuntará el botón. Puede apuntar a cualquier sitio incluyendo sitios externos. Si su sitio Moodle es un subdirectorio de la URL predeterminada, no funcionará. Por favor, ajuste la URL para que refleje el subdirectorio. Ejemplo si "moodle" fuera su subdirectorio entonces la URL necesitaria cambiarse a /moodle/my/';
$string['navicondesc'] = 'Nombre del icono que desea utilizar. La lista está <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>.  Solo entre lo que hay detrás de "fa-", p.e. "star".';
$string['naviconoff'] = 'Desctivar iconos de navegación personalizados';
$string['naviconon'] = 'Activar iconos de navegación personalizados';
$string['navigation'] = 'Opciones de Navegación';
$string['noenrolments'] = 'No tiene mátriculaciones ahora mismo';
$string['pcourseenable'] = 'Activar Cursos Destacados';
$string['pcourses'] = 'Cola Cursos Destacados';
$string['pcoursesdesc'] = 'Por favor, los id de los cursos destacados deber ir separados por una coma.';
$string['people'] = 'Compañeros';
$string['pluginname'] = 'Pioneer';
$string['promotedcoursesheading'] = 'Cola Diapositivas Cursos Destacados';
$string['promotedlink'] = 'URL Ver Más Cursos Destacados';
$string['promotedlink_desc'] = 'Entre una URL a una de las categorías de cursos. Se muestra a continuación del título de Cursos Destacados.';
$string['promotedlinktext'] = 'Texto Ver Más Cursos Destacados';
$string['promotedlinktext_desc'] = 'Proporciona una opción para enlazar a una categoría de cursos para mostrar más cursos en la cola del pase de diapositivas. Entre una URL debajo.';
$string['promotedmylink'] = 'URL Diapositivas Mis Cursos Ver Más';
$string['promotedmylink_desc'] = 'Pase una URL a una de las categorías de sus cursos. Se mostrará al lado del título de las Diapositivas Mis Cursos.';
$string['promotedmylinktext'] = 'Texto Diapositivas Mis Cursos Ver Más';
$string['promotedmylinktext_desc'] = 'Proporciona un enlace opcional a una categoría de cursos para mostrar más cursos. Pase la URL debajo.';
$string['promotedmytextbox'] = 'Caja Texto Descripción Diapositivas Mis Cursos';
$string['promotedmytextbox_desc'] = 'Una caja de texto que aparecerá con el bloque de Diapositivas de Mis Cursos.';
$string['promotedmytitle'] = 'Título Diapositivas Mis Cursos';
$string['promotedmytitledesc'] = 'Por favor, de un título al bloque de diapositivas de Mis Cursos.';
$string['promotedtaglink'] = 'URL Ver Más Cursos Recomendados';
$string['promotedtaglink_desc'] = 'La URL que apunta a la categoría de los cursos.  Se muestra al nado del título de cursos destacados.';
$string['promotedtaglinktext'] = 'Texto Ver Más Cursos Recomendados';
$string['promotedtaglinktext_desc'] = 'Proporciona una opción para enlazar a una categoría de cursos para mostrar más cursos. Pase la URL debajo.';
$string['promotedtagtextbox'] = 'Caja Texto Descripción Personalizada';
$string['promotedtagtextbox_desc'] = 'Utilícelo para explicar al usuario como agregar etiquetas a su perfil y a los cursos para que puedan aparecer los cursos recomendados al usuario.';
$string['promotedtagtitle'] = 'Título Cursos Personalizados Recomendados';
$string['promotedtagtitledesc'] = 'Por favor, de un título al bloque de los Cursos Personalizados Recomendados.';
$string['promotedtitledefault'] = 'Cursos Destacados';
$string['promotedtitledesc'] = 'Por favor, ponga un título a los cursos Promocionados.';
$string['radialboxbackground'] = 'Fondo Radial Calificación y Cumplimiento del Curso';
$string['radialboxbackground_desc'] = 'Este es el color de fondo de la caja que contiene los elementos del Indicador Radial de la Calificación y Cumplimiento del Curso arriba a la izquierda de la página.';
$string['radialcolor'] = 'Color Círculo Radial';
$string['radialcolor_desc'] = 'El color del círculo del indicador radial.';
$string['recommendedbkg'] = 'Color Fondo Multiples Diapositivas';
$string['recommendedbkg_desc'] = 'El color se aplicará a los Cursos Destacados, Personalizados Recomendados y Mis Cursos. Están localizados en la página principal.';
$string['recommendedcoursesheading'] = 'Diapositivas Cursos Personalizados Recomendables';
$string['recommendedcoursesheadingdesc'] = 'Las Diapositivas Cursos Personalizados Recomendables buscarán coincidencias entre las etiquetas del usuario (intereses) y las etiquetas de los cursos. Las que se encuentre formarán una lista que se mostrará un diapositivas adaptables en la página principal. Los ajustes son automáticos y no se necesita otra interacción salvo la de proporcionar etiquetas a los cursos y en los perfiles de usuario.';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['rendereroverlaycolor'] = 'Color superposición';
$string['rendereroverlaycolordesc'] = 'El color de la superposición cuando se selecciona "Mosaico con superposición".';
$string['rendereroverlayfontcolor'] = 'Color fuente superposición';
$string['rendereroverlayfontcolordesc'] = 'El color del texto de la superposición cuando se selecciona "Mosaico con superposición".';
$string['secondarybackground'] = 'Color de fondo secundario';
$string['secondarybackground_desc'] = 'El color de fondo de cualquier contenido secundario tales como bloques.';
$string['sectionheadericon'] = 'Icono Título de Sección';
$string['sectionheadericondesc'] = 'Este icono aparece justo antes del título de cada tema para los cursos con formatos semanales y por temas. Use los ajustes de unicode de Font Awesome. La lista está <a href="https://fortawesome.github.io/Font-Awesome/icons/" target="_new">aquí</a>. El icono f02d (predeterminado) es un libro.';
$string['settingfeaturedmyslider'] = 'Mis Matriculaciones';
$string['settingfeaturedslider'] = 'Cursos Destacados';
$string['settingfeaturedtagslider'] = 'Cursos Personalizados Recomendados';
$string['settinggradebutton'] = 'Ver Calificaciones';
$string['settingpromotedlink'] = 'ejemplo: http://misitiomoodle/curso/';
$string['settingpromotedlinktext'] = 'Ver Más Cursos Destacados';
$string['settingpromotedmylink'] = 'ejemplo: http://misitiomoodle/cursos/';
$string['settingpromotedmylinktext'] = 'Diapositivas Mis Cursos Ver Más';
$string['settingpromotedtaglink'] = 'ejemplo: http://misitiomoodle/cursos/';
$string['settingpromotedtaglinktext'] = 'Ver Más Cursos Recomendados';
$string['settingshowtagline'] = 'Matricúlate Ahora';
$string['settingtabbutton'] = 'Empezar con Moodle';
$string['showlogintoggle'] = 'Formulario Inicio de Sesión';
$string['showlogintoggle_desc'] = 'Mostrar u ocultar el formulario de inicio de sesión de la página principal.';
$string['showmycourses'] = 'Diapositivas de Mis Cursos';
$string['showmycourses_desc'] = 'Actívelo si quiere que se muestren las diapositivas de Mis Cursos.';
$string['showrecommendedcourses'] = 'Cursos Personalizados Recomendados';
$string['showrecommendedcourses_desc'] = 'Selecciónelo si desea mostrar cursos personalizados recomendados.';
$string['signuplogin'] = 'Crear Nuevo';
$string['socialicon1'] = 'URL Facebook';
$string['socialicon2'] = 'URL Twitter';
$string['socialicon3'] = 'URL Pinterest';
$string['socialicon4'] = 'URL Flickr';
$string['socialicon5'] = 'URL LinkedIn';
$string['socialicon6'] = 'URL YouTube';
$string['socialicon7'] = 'URL Vimeo';
$string['socialicon8'] = 'URL Google Plus';
$string['socialiconheading'] = 'Iconos Navegación Social';
$string['socialwallheaddesc'] = 'Las opciones del Curso Social son un conjunto de formatos para la extensión de Moodle que proporciona a los profesores con un curso fácil de usar que opera de forma similar a Facebook.  Puede descargar el Formato Social de Moodle.org <a href="https://moodle.org/plugins/browse.php?list=set&id=74">https://moodle.org/plugins/browse.php?list=set&id=74</a>.  Los ajustes que siguen permiten configurar los colores del muro.';
$string['socialwallheading'] = 'Formatos del Curso Social';
$string['stylinginfo'] = 'Estilos y Alertas';
$string['stylinginfodesc'] = 'Personalizaciones adicionales y ajustes de la alerta.';
$string['swaddpost'] = 'Fondo Agregar Publicación Curso Formato Social';
$string['swaddpost_desc'] = 'Si utiliza el Formato Social en un curso, este ajuste cambiará el color de fondo del área Agregar Publicación del muro.';
$string['swattach'] = 'Fondo Adjunto Curso Formato Social';
$string['swattach_desc'] = 'Si utiliza el Formato Social en un curso, este ajuste cambiará el color de fondo del área de adjuntos en el muro.';
$string['swcomment'] = 'Fondo Comentario Curso Formato Social';
$string['swcomment_desc'] = 'Si utiliza el Formato Social en un curso, este ajuste cambiará el color de fondo del área de comentarios en el muro.';
$string['swicontext'] = 'Icono y Texto de curso con Formato Social';
$string['swicontext_desc'] = 'Si utiliza un curso con Formato Social estos ajustes cambiarán el color de los iconos y de las palabras Adjunto, Publicación, Mensaje y Comentario en el muro.';
$string['swlabelattachment'] = 'CSS Etiqueta Adjunto';
$string['swlabelattachment_desc'] = 'Cuando hay adjuntos en una publicación, esta etiqueta los identificará.';
$string['swlabelcomment'] = 'CSS Etiqueta Comentario';
$string['swlabelcomment_desc'] = 'Esta etiqueta identifica la sección de comentarios para cada publicación en la línea de tiempo.';
$string['swlabelmessage'] = 'CSS Etiqueta Mensaje';
$string['swlabelmessage_desc'] = 'Por encima del contenido de una publicación, esta es la etiqueta de mensaje que aparecerá en la línea de tiempo.';
$string['swlabelpost'] = 'CSS Etiqueta Publicar';
$string['swlabelpost_desc'] = 'Por encima de cada publicación, esta es la etiqueta que aparecerá en la línea de tiempo.';
$string['swmessage'] = 'Fondo Mensaje Curso Formato Social';
$string['swmessage_desc'] = 'Si utiliza el Formato Social en un curso, este ajuste cambiará el color de fondo del área de texto del mensaje en el muro.';
$string['swmultilangcss'] = 'Etiqueta de Traducción Tema Social';
$string['swmultilangcss_desc'] = 'Si opera en un sitio multilenguaje, puede utilizar el ejemplo proporcionado traducir las etiquetas sociales a los lenguajes soportados.';
$string['swpost'] = 'Fondo Publicación Curso Formato Social';
$string['swpost_desc'] = 'Si utiliza el Formato Social en un curso, este ajuste cambiará el color de fondo de los mensajes publicados en el muro.';
$string['tab1'] = 'Pestaña Una';
$string['tab2'] = 'Pestaña Dos';
$string['tab3'] = 'Pestaña Tres';
$string['tab4'] = 'Pestaña Cuatro';
$string['tab5'] = 'Pestaña Cinco';
$string['tab6'] = 'Pestaña Seis';
$string['tabbutton'] = 'Empezando';
$string['tabbuttoncolor'] = 'Color Botón Pestañas';
$string['tabbuttoncolor_desc'] = 'El color de los botones utilizados para conmutar las pestañas de la página principal y el desplazamiento de las calificaciones del curso que aparecen justo debajo del título de la página donde están activados.';
$string['tabbuttonhovercolor'] = 'Color Botón Pestaña al Apuntar';
$string['tabbuttonhovercolor_desc'] = 'El color del botón de la pestaña al pasar el ratón sobre él acción que hace que conmute el deslizamiento de las pestañas de la página central y las calificaciones de los cursos. Aparecen justo debajo del título de la página si están activadas.';
$string['tabbuttontext'] = 'Texto Botón Pestaña';
$string['tabbuttontextdesc'] = 'Se utiliza en el botón de mostrar/ocultar las pestañas.';
$string['tabcontent'] = 'Contenido Pestaña';
$string['tabcontentdesc'] = 'El texto y el HTML que introduzca se mostrará en la pestaña.';
$string['tabheading'] = 'Pestañas Página Principal';
$string['tabinfodesc'] = 'Agregar un título y una descripción debajo. Solo aparecerá en la página principal como pase de diapositivas. El botón para activarlo se encuentra arriba, en la cabecera.';
$string['tabtitle'] = 'Título Pestaña';
$string['tabtitledesc'] = 'Este es el título de la pestaña que aparece en lo alto del contenido de la pestaña.';
$string['tabtoggle'] = 'Pestañas';
$string['tabtoggle_desc'] = 'Muestra u oculta las pestañas de la página de inicio.';
$string['textcolor'] = 'Color del Texto';
$string['textcolor_desc'] = 'El color del texto.';
$string['themecolorsettings'] = 'Colores del Tema';
$string['thiscourse'] = 'Éste Curso';
$string['title'] = 'Título';
$string['togglefptextbox'] = 'Caja de Texto';
$string['togglefptextboxdesc'] = 'Permite ocultar o mostrar la Caja de Texto de la Página Principal para usuarios sin inicio de sesión.';
$string['toggleiconnav'] = 'Localización Navegación por Iconos';
$string['toggleiconnav_desc'] = 'Determina dónde quiere que aparezcan los iconos y la caja de búsqueda de cursos.';
$string['togglemarketing'] = 'Mostrar Anuncios';
$string['togglemarketingdesc'] = 'Elija si quiere mostrar u ocultar los tres anuncios.';
$string['togglenavicons'] = 'Activar Icono Personalizados';
$string['togglenaviconsdesc'] = 'Permite incluir iconos de navegación personalizados basados en Font-Awesome.';
$string['toolsmenu'] = 'Menú Herramientas';
$string['toolsmenudesc'] = 'Puede configurar los enlaces que se van a mostrar en el menú de herramientas. Cada línea consiste en el texto del menú, una URL (opcional), un texto de ayuda (opcional) y un código de idioma o una lista separada por comas de códigos (opcional, para mostrar la línea a los usuarios del idioma especificado), separados por el caracter |. Por ejemplo:
<pre>
Comunidad Moodle|https://moodle.org
-Soporte gratuito de Moodle|https://moodle.org/support
-Desarrollo de Moodle|https://moodle.org/development
--Docs de Moodle|http://docs.moodle.org|Docs de Moodle
--Docs de Moodle en Alemán|http://docs.moodle.org/de|Documentación en alemán|de
Moodle.com|http://moodle.com/
</pre>';
$string['toolsmenulabel'] = 'Herramientas';
$string['topclosefeatured'] = 'Enlace a Cerrar Listado de Cursos Destacados';
$string['topclosefeatureddesc'] = 'Este texto aparece por encima del listado de los cursos destacados y cerrará la lista de cursos destacados. "Cerrar Listado de Cursos" es el texto que se sugiere.';
$string['topclosefeaturedtext'] = 'Cerrar Listado de Cursos';
$string['topichighlight'] = 'Color Tema Resaltado';
$string['topichighlight_desc'] = 'El color utilizado cuando un tema o semana se resalta en el curso.';
$string['topicweekcolor'] = 'Fondo Temas y Sección Semanal';
$string['topicweekcolor_desc'] = 'En cursos por Temas y Semanales, éste es el color de fondo para cada tema o semana del curso.';
$string['toppcourseenable'] = 'Diapositivas Cursos Destacados';
$string['toppcourses'] = 'Diapositivas Cursos Destacados';
$string['toppcoursesdesc'] = 'LIMITE=10 No puede entrar más de 10 ID de cursos. Por favor, introduzca los id de los cursos destacados separados por una coma.';
$string['toppromotedcoursesheading'] = 'Diapositivas Cursos Destacados';
$string['toppromotedtitledefault'] = 'Cursos destacados';
$string['toppromotedtitledesc'] = 'Este texto aparece debajo del Título del Curso en la diapositiva. "Matricúlate Ahora" sería el lema ideal.';
$string['topsearch'] = 'Buscar cursos';
$string['topsearchbutton'] = 'Encontrar';
$string['topshowfeatured'] = 'Mostrar Enlace a Todos los Cursos';
$string['topshowfeatureddesc'] = 'Este texto aparece el el pase de diapositivas y mostrará un listado de todos los cursos destacados. "Ver Todos Los Cursos Destacados" es el texto que se sugiere.';
$string['topshowfeaturedtext'] = 'Ver Todos Los Cursos Destacados';
$string['toptitle'] = 'Lema';
