<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'tr', version '5.0'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'kurulmak üzere';
$string['accept'] = 'Kabul Et';
$string['action'] = 'Eylem';
$string['actionchoice'] = '\'{$a}\' dosyası ile ne yapmak istiyorsun?';
$string['actions'] = 'Eylemler';
$string['actionsfor'] = '{$a} için eylemler';
$string['actionsmenu'] = 'Eylemler menüsü';
$string['active'] = 'Aktif';
$string['activeusers'] = 'Aktif kullanıcılar';
$string['activities'] = 'Etkinlikler';
$string['activities_help'] = 'Forumlar, mini sınavlar (quizler) ve vikiler gibi etkinlikler etkileşimli içerik olarak kurslara eklenebilirler.';
$string['activity'] = 'Etkinlik';
$string['activityclipboard'] = 'Bu etkinliği şuraya taşınıyor: {$a}';
$string['activityheader'] = 'Etkinlik menüsü';
$string['activityicon'] = '{$a} simgesi';
$string['activityiscurrentlyhidden'] = 'Üzgünüz, bu etkinlik şu an gizlidir';
$string['activitymodule'] = 'Etkinlik modülü';
$string['activitymodules'] = 'Etkinlik modülleri';
$string['activitynotready'] = 'Etkinlik henüz hazır değil';
$string['activityorresource'] = 'Etkinlik veya kaynak';
$string['activityreport'] = 'Etkinlik raporu';
$string['activityreports'] = 'Etkinlik raporları';
$string['activityselect'] = 'Başka bir yere taşımak için bu etkinliği seçin';
$string['activitysince'] = '{$a} sonrasındaki etkinlikler';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Kullanıcı başına etkinlik';
$string['add'] = 'Ekle';
$string['addactivity'] = 'Bir etkinlik ekle...';
$string['addactivitytosection'] = '\'{$a}\' bölümüne etkinlik ekle';
$string['addadmin'] = 'Yönetici ekle';
$string['addblock'] = 'Blok ekle';
$string['addcomment'] = 'Yorum ekle...';
$string['addcondition'] = 'Koşul ekle';
$string['addcontent'] = 'İçerik ekle';
$string['addcountertousername'] = 'Kullanıcı adına sayı ekleyerek kullanıcı oluştur';
$string['addcreator'] = 'Kurs oluşturucu ekle';
$string['adddots'] = 'Ekle...';
$string['added'] = '{$a} eklendi';
$string['addedtogroup'] = '"{$a}" grubuna eklendi';
$string['addedtogroupnot'] = '"{$a}" grubuna eklenemedi.';
$string['addedtogroupnotenrolled'] = '"{$a}" grubuna eklenmedi, çünkü derse kayıtlı değil';
$string['addfilehere'] = 'Bölümün altına eklemek istediğiniz dosya(ları) buraya sürükleyip bırakın';
$string['addfilesdrop'] = 'Yüklemek için dosyaları buraya sürükleyip bırakabilir veya seçmek için tıklayabilirsiniz.';
$string['addinganew'] = 'Yeni {$a}';
$string['addingdatatoexisting'] = 'Veri var olana ekleniyor';
$string['additionalcustomnav'] = 'Ek özel gezinme';
$string['additionalnames'] = 'Ek isimler';
$string['addlinkhere'] = 'Buraya bağlantı ekle';
$string['addnew'] = 'Yeni {$a} ekle';
$string['addnewcategory'] = 'Yeni kategori ekle';
$string['addnewcourse'] = 'Yeni kurs ekle';
$string['addnewuser'] = 'Yeni kullanıcı ekle';
$string['addnousersrecip'] = '{$a} \'e hiç erişmemiş kişileri alıcı listesine ekle';
$string['addpagehere'] = 'Buraya metin ekle';
$string['addresource'] = 'Yeni bir kaynak ekle...';
$string['addresourceoractivity'] = 'Yeni etkinlik veya kaynak ekle';
$string['addresourcetosection'] = 'Bir kaynağı \'{$a}\' bölümüne ekle';
$string['address'] = 'Adres';
$string['addsections'] = 'Bölümler ekle';
$string['addstudent'] = 'Öğrenci ekle';
$string['addsubcategory'] = 'Alt kategori ekle';
$string['addteacher'] = 'Öğretmen ekle';
$string['admin'] = 'Yönetici';
$string['adminhelpaddnewuser'] = 'Elle yeni kullanıcı oluşturmak için';
$string['adminhelpassignadmins'] = 'Yöneticiler istedikleri herşeyi yapabilir ve site içerisinde heryere gidebilirler';
$string['adminhelpassigncreators'] = 'Kurs oluşturucular yeni kurs açabilirler';
$string['adminhelpassignsiteroles'] = 'Belirli kullanıcılara tanımlı site rollerini uygula';
$string['adminhelpassignstudents'] = 'Bir derse git ve yönetim menüsünden öğrencileri ekle';
$string['adminhelpauthentication'] = 'Dahili kullanıcı hesapları ya da harici veritabanları kullanabilirsiniz';
$string['adminhelpbackup'] = 'Otomatik yedeklemeleri ve zamanlamasını ayarla';
$string['adminhelpconfiguration'] = 'Sitenin nasıl görüneceğini ve çalışacağını ayarla';
$string['adminhelpconfigvariables'] = 'Sitenin genel işleyişini etkileyen değişkenleri yapılandır';
$string['adminhelpcourses'] = 'Bölümleri ve kursları tanımla, üyeleri ata, onay bekleyen kursları düzenle';
$string['adminhelpeditorsettings'] = 'HTML editörü için temel ayarları tanımla';
$string['adminhelpedituser'] = 'Kullanıcı hesaplarına gözat ve düzenle';
$string['adminhelpenvironment'] = 'Sunucunun şu anki ve gelecekteki kurulum gereksinimleri için uygunluğunu kontrol et';
$string['adminhelpfailurelogs'] = 'Başarısız girişlerin kayıtlarını görüntüle';
$string['adminhelplanguage'] = 'Şu anki dil paketini kontrol edip düzenle';
$string['adminhelplogs'] = 'Sitedeki etkinliklere ait kayıtlara gözat';
$string['adminhelpmanageblocks'] = 'Kurulu blokları ve bunların ayarlarını yönet';
$string['adminhelpmanagedatabase'] = 'Veritabanına doğrudan erişin (dikkatli olun!)';
$string['adminhelpmanagefilters'] = 'İçerik filtrelerini ve ilgili ayarlarını yönet';
$string['adminhelpmanagemodules'] = 'Kurulu eklentileri ve bunların ayarlarını yönet';
$string['adminhelpmanageroles'] = 'Kullanıcılar için uygulanabilecek rolleri oluştur ve tanımla';
$string['adminhelpmymoodle'] = 'Kullanıcılar için Kişisel Sayfam (My Moodle) bloklarını yapılandır';
$string['adminhelpreports'] = 'Site seviye raporları';
$string['adminhelpsitefiles'] = 'Genel dosyaların yayınlanması ya da yedeklerin yüklenmesi için';
$string['adminhelpsitesettings'] = 'Sitenin anasayfasının nasıl görüneceğini tanımla';
$string['adminhelpstickyblocks'] = 'Moodle-wide yapışkan blokları yapılandırın';
$string['adminhelpthemes'] = 'Sitenin nasıl görüneceğini seç (renkler, fontlar, vs.)';
$string['adminhelpuploadusers'] = 'Bir metin dosyasından yeni kullanıcı hesaplarını içeri aktar';
$string['adminhelpusers'] = 'Kullanıcılarınızı ve nasıl kayıt olacaklarını tanımlayın';
$string['adminhelpxmldbeditor'] = 'XMLDB dosyalarını ayarlamak için arayüz. Sadece geliştiriciler için.';
$string['administration'] = 'Yönetim';
$string['administrationsite'] = 'Site yönetimi';
$string['administrator'] = 'Yönetici';
$string['administratordescription'] = 'Yöneticiler çoğunlukla sitede ve tüm kurslarda her yetkiye sahiplerdir.';
$string['administrators'] = 'Yöneticiler';
$string['administratorsall'] = 'Tüm yöneticiler';
$string['administratorsandteachers'] = 'Yöneticiler ve eğitimciler';
$string['advanced'] = 'Gelişmiş';
$string['advancedfilter'] = 'Gelişmiş arama';
$string['advancedsettings'] = 'Gelişmiş ayarlar';
$string['afterresource'] = '"{$a}" kaynağından sonra';
$string['aftersection'] = '"{$a}" bölümünden sonra';
$string['again'] = 'tekrar';
$string['agelocationverification'] = 'Yaş ve konum doğrulama';
$string['ajaxuse'] = 'AJAX ve JavaScript';
$string['all'] = 'Tüm';
$string['allactions'] = 'Tüm etkinlikler';
$string['allactivities'] = 'Tüm etkinlikler';
$string['allcategories'] = 'Tüm kategoriler';
$string['allchanges'] = 'Tüm değişiklikler';
$string['alldays'] = 'Tüm günler';
$string['allfiles'] = 'Bütün dosyalar';
$string['allgroups'] = 'Bütün grublar';
$string['alllogs'] = 'Bütün kayıtlar';
$string['allmods'] = 'Tüm {$a}';
$string['allow'] = 'İzin ver';
$string['allowinternal'] = 'Dahili yöntemlere de izin ver';
$string['allownone'] = 'Hiçbirine izin verme';
$string['allownot'] = 'İzin verme';
$string['allowstealthmodules'] = 'Görünmez etkinliklere izin ver';
$string['allowstealthmodules_help'] = 'Etkinleştirilirse, etkinlikler mevcut hale getirilse de kurs sayfasının görünür bölümlerinde gösterilmez. Böyle olunca da görünmez etkinliklerin bağlantıları başka bir yere yerleştirilmelidir - örneğin bir sayfa içine. Görünmez etkinlikler not defterinde ve diğer raporlarda listelenir.';
$string['allparticipants'] = 'Bütün katılımcılar';
$string['allteachers'] = 'Bütün eğitimciler';
$string['alphanumerical'] = 'Sadece alfanumerik karakterler, tire (-) veya nokta (.) içerebilir';
$string['alreadyconfirmed'] = 'Kayıt zaten onaylandı';
$string['alternatename'] = 'Alternatif isim';
$string['always'] = 'Her zaman';
$string['and'] = '{$a->one} ve {$a->two}';
$string['answer'] = 'Cevap';
$string['any'] = 'Herhangi bir';
$string['appearance'] = 'Görünüm';
$string['apply'] = 'Uygula';
$string['applyfilters'] = 'Filitre uygula';
$string['approve'] = 'Onayla';
$string['areyousure'] = 'Emin misiniz?';
$string['areyousuretorestorethis'] = 'Devam etmek istiyor musunuz?';
$string['areyousuretorestorethisinfo'] = 'Daha sonra bu işlemde bu yedeklemeyi varolan bir derse ekleme veya tamamen yeni bir kurs oluşturma seçeneğine sahipsiniz.';
$string['asc'] = 'Artan';
$string['assessment'] = 'Değerlendirme';
$string['assignadmins'] = 'Yöneticileri belirle';
$string['assigncreators'] = 'Kurs oluşturucuları belirle';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Site geneli rolleri ata';
$string['authenticateduser'] = 'Giriş yapmış kullanıcı';
$string['authenticateduserdescription'] = 'Tüm giriş yapmış kullanıcılar.';
$string['authentication'] = 'Kimlik doğrulama';
$string['authenticationplugins'] = 'Kimlik doğrulama eklentileri';
$string['autosubscribe'] = 'Forum otomatik abone ol';
$string['autosubscribeno'] = 'Hayır: beni forum tartışmalarına otomatik abone yapma';
$string['autosubscribeyes'] = 'Evet: ileti gönderdiğimde beni o forum tartışmasına abone yap';
$string['availability'] = 'Uygunluk';
$string['availablecourses'] = 'Mevcut Kurslar';
$string['back'] = 'Geri';
$string['backto'] = 'Geri dön; {$a}';
$string['backtocourselisting'] = 'Kurs listesine dön';
$string['backtohome'] = 'Site ana sayfasına geri dön';
$string['backtopageyouwereon'] = 'Önceki sayfaya dön';
$string['backup'] = 'Yedekle';
$string['backupactivehelp'] = 'Otomatik yedeklemelerin yapılıp yapılmayacağını seç.';
$string['backupadhocpending'] = 'Kurs yedeklemeye özel görev beklemede';
$string['backupcancelled'] = 'Yedekleme iptal edildi';
$string['backupcoursefileshelp'] = 'Etkinleştirilirse kurs dosyaları otomatik yedeklemeye dahil edilecek';
$string['backupdate'] = 'Yedekleme tarihi';
$string['backupdatenew'] = '&nbsp; {$a->TAG} şimdi {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br/>';
$string['backupdateold'] = '{$a->TAG}, {$a->weekday}, {$a->mday} {$a->month} {$a->year} idi';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br/>';
$string['backupdetails'] = 'Yedekleme ayrıntıları';
$string['backuperrorinvaliddestination'] = 'Yedek  dosyaları kaydedeceğiniz hedef klasör yok ya da yazmaya karşı korumalı';
$string['backupexecuteathelp'] = 'Otomatik yedeklemelerin ne zaman çalıştırılacağını seçin.';
$string['backupfailed'] = 'Kurslarınızın bazıları kaydedilmedi!';
$string['backupfilename'] = 'yedek';
$string['backupfinished'] = 'Yedekleme başarıyla tamamlandı';
$string['backupfromthissite'] = 'Yedekleme bu sitede mi yapıldı?';
$string['backupgradebookhistoryhelp'] = 'Etkinleştirilirse not defteri geçmişi otomatik yedeklemelere dahil edilecektir. Bunun çalışması için not defteri geçmişi sunucu ayarlarında (disablegradehistory) kapalı olmamalıdır.';
$string['backupincludemoduleshelp'] = 'Otomatik yedeklemede kurs eklentilerinin dahil edilip edilmeyeceğini, kullanıcı verisinin olup olmayacağını seçiniz.';
$string['backupincludemoduleuserdatahelp'] = 'Otomatik yedeklemelerde eklenti kullanıcı verisinin dahil edilip edilmeyeceğini seçin.';
$string['backupinfo'] = 'Bugüne kadarki tüm içerik ve etkinlikleri içeren bu kursun bir kopyasını oluşturun.  Kursu geri yüklemek için yedekleme dosyasını kullanabilirsiniz.';
$string['backuplogdetailed'] = 'Ayrıntılı çalıştırma kaydı';
$string['backuploglaststatus'] = 'Son çalıştırma kaydı';
$string['backupmissinguserinfoperms'] = 'Not: Yedekleme kullanıcı verisini içermiyor. Alıştırma ve Çalıştay etkinlikleri, bu tip yedeklemeyle uyumlu olmadığından yedeklemeye dahil edilmeyecek.';
$string['backupnext'] = 'Sonraki yedek';
$string['backupnonisowarning'] = 'Uyarı: bu yedekleme Moodle yazılımının Unicode olmayan sürümünden (1.6 öncesi) elde edilmiştir. Bu yedek ISO-8859-1 olmayan herhangi bir metin içeriyorsa ve bunu Moodle Unicode sürümünden geri yüklüyorsanız METİNLER BOZULABİLİR. Bu yedeği nasıl kurtaracağınız hakkında daha fazla bilgi için <a href="https://docs.moodle.org/en/Backup_FAQ">Yedekleme SSS</a> sayfasına bakın.';
$string['backupnotyetrun'] = 'Bekleyen otomatik yedekleme';
$string['backuporiginalname'] = 'Yedek adı';
$string['backuproleassignments'] = 'Bu roller için rol atamalarını yedekle';
$string['backupsavetohelp'] = 'Yedek dosyaları kaydetmek istediğiniz dizinin tam yolu';
$string['backupsitefileshelp'] = 'Etkinleştirilirse kurslar kullanılan site dosyaları otomatik yedeklemelere dahil edilir.';
$string['backuptakealook'] = 'Lütfen yedek kayıtlarınıza bir göz atın:
  {$a}';
$string['backupuserfileshelp'] = 'Kullanıcı dosyalarının (örn: profil resimleri) otomatik yedeklemelere dahil edilip edilmeyeceğini seçin';
$string['backupversion'] = 'Yedekleme versiyonu';
$string['badges'] = 'Rozetler';
$string['between'] = 'Arasında';
$string['block'] = 'Blok';
$string['blockconfiga'] = 'Bir {$a} bloğu yapılandırılıyor';
$string['blockconfigbad'] = 'Bu blok doğru olarak kurulmadı ve bu yüzden bir yapılandırma arayüzü sağlayamaz.';
$string['blocks'] = 'Bloklar';
$string['blocks_main'] = 'Ana içerik blokları';
$string['blocks_supplementary'] = 'Tamamlayıcı bloklar';
$string['blocksaddedit'] = 'Blok ekle/düzenle';
$string['blockseditoff'] = 'Blok düzenleme kapalı';
$string['blocksediton'] = 'Blok düzenleme açık';
$string['blocksetup'] = 'Blok tabloları ayarlanıyor';
$string['blocksuccess'] = '{$a} tabloları doğru ayarlandı';
$string['brief'] = 'Özet';
$string['bulkactions'] = 'Toplu eylemler';
$string['bulkactionselect'] = '{$a} toplu eylem seçimi';
$string['bulkcancel'] = 'Toplu düzenlemeyi kapat';
$string['bulkmovecoursessuccess'] = '{$a->courses} kursları {$a->category} içerisine başarıyla taşındı';
$string['bulkselection'] = '{$a} seçildi';
$string['bycourseorder'] = 'Kurs sırasına göre';
$string['byname'] = '{$a} tarafından';
$string['bypassed'] = 'Baypas edildi';
$string['cachecontrols'] = 'Önbellek kontrolleri';
$string['calltofeedback'] = 'Bu yazılımın yaratıcıları sizden ger bildirim almak istiyor';
$string['calltofeedback_give'] = 'Bu yazılıma geri bildirim ver';
$string['calltofeedback_remind'] = 'Sonra hatırlat';
$string['cancel'] = 'İptal';
$string['cancelled'] = 'İptal edildi';
$string['categories'] = 'Kurs Kategorileri';
$string['categoriesandcourses'] = 'Kurs kategorileri ve kurslar';
$string['category'] = 'Kategori';
$string['categoryadded'] = '\'{$a}\' kategorisi eklendi';
$string['categorybulkaction'] = 'Seçilen kategoriler için toplu işlem';
$string['categorycontents'] = 'Alt kategoriler ve kurslar';
$string['categorycurrentcontents'] = '{$a} İçeriği';
$string['categorydeleted'] = '\'{$a}\' kategorisi silindi';
$string['categoryduplicate'] = '\'{$a}\' isminde bir kategori zaten var!';
$string['categoryheader'] = 'Kategori Menüsü';
$string['categoryhidden'] = '(gizli)';
$string['categorymodifiedcancel'] = 'Kategoride değişiklik yapıldı! Lütfen iptal edin ve yeniden deneyin.';
$string['categoryname'] = 'Kategori adı';
$string['categorypath'] = 'Kategori yolu';
$string['categorysubcategoryof'] = '{$a->category} - {$a->parentcategory}  alt kategorisi';
$string['categoryupdated'] = '\'{$a}\' kategorisi güncellendi';
$string['changedpassword'] = 'Değişmiş şifre';
$string['changepassword'] = 'Şifre değiştir';
$string['changesmade'] = 'Değişiklikler yapıldı';
$string['changesmadereallygoaway'] = 'Değişiklikler yaptınız. Çıkarsanız yaptığınız değişiklikler kaydedilmeyecek. Emin misiniz?';
$string['changessaved'] = 'Değişiklikler kaydedildi';
$string['check'] = 'Kontrol et';
$string['checkactual'] = 'Gerçek';
$string['checkall'] = 'Tümünü seç';
$string['checkerror'] = '\'{$a}\' kontrolünün sonucu alınırken hata oluştu. Daha fazla bilgi için tarayıcı konsolunu kontrol edin.';
$string['checkexpected'] = 'Beklenen';
$string['checkingbackup'] = 'Yedekleme kontrol ediliyor';
$string['checkingcourse'] = 'Kurs kontrol ediliyor';
$string['checkingforbbexport'] = 'KaraTahta dışa aktarılması için kontrol ediliyor';
$string['checkinginstances'] = 'Kullanımlar kontrol ediliyor';
$string['checkingsections'] = 'Bölümler kontrol ediliyor';
$string['checklanguage'] = 'Dili kontrol et';
$string['checkloading'] = '\'{$a}\' kontrolünün sonucu alınıyor';
$string['checknone'] = 'Hiçbirini seçme';
$string['checks'] = 'Kontrol';
$string['checksok'] = 'Tüm \'{$a}\' kontrolleri tamam';
$string['childcoursenotfound'] = 'Alt kurs bulunamadı!';
$string['childcourses'] = 'Alt kurslar';
$string['choose'] = 'Seç';
$string['choosecourse'] = 'Bir kurs seç';
$string['choosedots'] = 'Seç...';
$string['chooselivelogs'] = 'Veya mevcut etkinliği izle';
$string['chooselogs'] = 'Hangi kayıtları görmek istediğini seç';
$string['choosereportfilter'] = 'Rapor için bir filtre seç';
$string['choosetheme'] = 'Tema seç';
$string['chooseuser'] = 'Bir kullanıcı seç';
$string['city'] = 'Şehir';
$string['cleaningtempdata'] = 'Geçici veri temizleniyor';
$string['clear'] = 'Temizle';
$string['clearall'] = 'Tümünü temizle';
$string['clearfilterrow'] = 'Filtreleri kaldır';
$string['clearfilters'] = 'Filtreleri temizle';
$string['clearsearch'] = 'Arama girişini temizle';
$string['clickhelpiconformoreinfo'] = '... devamı eder ... Makalenin tamamını okumak için yardım simgesine tıklayın';
$string['clickhere'] = 'Buraya tıkla...';
$string['clicktohideshow'] = 'Genişletmek/Daraltmak içìn tıkla';
$string['closeblockdrawer'] = 'Blok çekmeceyi kapat';
$string['closebuttontitle'] = 'Kapat';
$string['closecourseindex'] = 'Kurs dizinini kapat';
$string['closedrawer'] = 'Cekmeceyi kapat';
$string['closewindow'] = 'Bu pencereyi kapat';
$string['collapse'] = 'Daralt';
$string['collapseall'] = 'Tümünü daralt';
$string['collapsecategory'] = '{$a} \'yı daralt';
$string['comebacklater'] = 'Lütfen daha sonra tekrar gelin.';
$string['commentincontext'] = 'Bu yorumu bağlamda ara';
$string['comments'] = 'Yorumlar';
$string['commentscount'] = 'Yorumlar ({$a})';
$string['commentsnotenabled'] = 'Yorum özelliği etkinleştirilmedi';
$string['commentsrequirelogin'] = 'Yorumları görmek için giriş yapmanız gerekmekte.';
$string['comparelanguage'] = 'Geçerli dili karşılaştır ve düzenle';
$string['complete'] = 'Tamamla';
$string['completed'] = 'Tamamlanmış';
$string['completereport'] = 'Rapor tamamla';
$string['configuration'] = 'Yapılandırma';
$string['confirm'] = 'Onayla';
$string['confirmaccount'] = 'Hesabı onayla';
$string['confirmcheckfull'] = '{$a} \'yı tamamen onayladığınızdan emin misiniz?';
$string['confirmcoursemove'] = '({$a->course}) dersini ({$a->category}) kategorisi içine taşımak istediğinizden emin misiniz?';
$string['confirmdeletesection'] = '"{$a}" ve içerdiği tüm etkinlikler tamamen silinecek; emin misiniz?';
$string['confirmed'] = 'Kaydınız onaylandı';
$string['confirmednot'] = 'Kaydınız henüz onaylanmadı. Lütfen onay e-postası için posta kutunuzu kontrol edin.';
$string['considereddigitalminor'] = 'Bu sitede bir hesap oluşturmak için çok gençsiniz.';
$string['contactsbyrolelist'] = '{$a->role}: {$a->contacts}';
$string['content'] = 'İçerik';
$string['contentbank'] = 'İçerik bankası';
$string['contentexport_aboutthiscourse'] = 'Kurs özeti';
$string['contentexport_coursesummary'] = 'Bu dosya <a href="{$a->courselink}">{$a->coursename}</a> dersinden indirilen içeriğin bir parçası.';
$string['contentexport_footersummary'] = 'Bu dosya  <a href="{$a->courselink}">{$a->coursename}</a> dersinden {$a->userfullname} tarafından {$a->date} tarihinde indirilen içeriğin bir parçası.';
$string['contentexport_modulesummary'] = 'Bu sayfa <a href="{$a->modulelink}">{$a->modulename}</a> dersinden {$a->date} tarihinde indirilen içeriğin bir parçası. {$a->maxfilesize} dan büyük içeriğe sahip olan bazı dosyalar kaydedilmemiş olabilir.';
$string['contentexport_viewfilename'] = '{$a} dosyasını gör';
$string['context'] = 'Bağlam';
$string['contextlevel'] = 'Bağlam düzeyi';
$string['contextname'] = 'Bağlam Adı';
$string['contextparent'] = 'Ebeveyn';
$string['contexturl'] = 'Bağlam URL\'si';
$string['continue'] = 'Devam';
$string['continuetocourse'] = 'Kursa için burayı tıklayın';
$string['convertingwikitomarkdown'] = 'Wiki, Markdown koduna dönüştürülüyor';
$string['cookiesenabled'] = 'Tarayıcınız çerez kabul edecek biçimde yapılandırılmalı';
$string['cookiesenabled_help'] = '<p>Bu site tarafından iki adet çerez kullanılır.</p>

<p>Gerekli olan çerez, genellikle MoodleSession adı verilen oturum çerezidir. Bu çerezin tarayıcınızdaki sürekliliği sağlamasına ve siteye göz atarken oturumda kalmasına izin vermelisiniz. Tarayıcıdan çıkış yaptığınızda veya kapattığınızda, bu çerez yok edilir (hem tarayıcınızda, hem de sunucuda).</p>

<p>Diğer çerez ise, genellikle MOODLEID olarak adlandırılır ve siteye girişte kolaylık sağlamak içindir. Sadece tarayıcıdaki kullanıcı adınızı hatırlar. Bu, siteye geri döndüğünüzde, giriş sayfasındaki kullanıcı adı alanının sizin için önceden doldurulmuş olduğu anlamına gelir. Bu çerezi reddetmek güvenlik açısından tercih edilebilir; bu durumda her giriş yaptığınızda kullanıcı adınızı tekrar yazmanız gerekecektir.</p>';
$string['cookiesenabled_help_html'] = 'Bu sitede iki çerez kullanılmaktadır:<br/><br/>

 Temel olan, genellikle MoodleSession olarak adlandırılan oturum çerezidir.  Sitede gezinirken sürekliliği sağlamak ve oturumunuzun açık kalması için tarayıcınızda bu çereze izin vermelisiniz.  Oturumu kapattığınızda veya tarayıcıyı kapattığınızda, bu tanımlama bilgisi (tarayıcınızda ve sunucuda) yok edilir.<br/><br/>

 Diğer tanımlama bilgisi tamamen kolaylık sağlamak içindir ve genellikle MOODLEID veya benzeri olarak adlandırılır.  Sadece tarayıcıdaki kullanıcı adınızı hatırlar.  Bu, bu siteye döndüğünüzde, giriş sayfasındaki kullanıcı adı alanının sizin için zaten doldurulmuş olduğu anlamına gelir.  Bu tanımlama bilgisini reddetmek güvenlidir - her giriş yaptığınızda kullanıcı adınızı yeniden yazmanız yeterlidir.';
$string['cookiesenabledonlysession'] = 'Oturum desteği etkin olmalıdır';
$string['cookiesenabledonlysession_help'] = 'Bu site genellikle MoodleSession adı verilen bir oturum çerezi kullanır. Bu çerezin tarayıcınızdaki sürekliliği sağlamasına ve siteye göz atarken oturumda kalmasına izin vermelisiniz. Tarayıcıdan çıkış yaptığınızda veya kapattığınızda, bu çerez yok edilir (tarayıcınızda ve sunucuda).';
$string['cookiesnotenabled'] = 'Maalesef tarayıcınız çerez kabul edecek biçimde yapılandırılmamış';
$string['cookiesnotice'] = 'Çerez bildirimi';
$string['copy'] = 'kopyala';
$string['copyasnoun'] = 'kopya';
$string['copycourse'] = 'Kursu kopyala';
$string['copyingcoursefiles'] = 'Kurs dosyaları kopyalanıyor';
$string['copyingsitefiles'] = 'Kursda kullanılan site dosyaları kopyalanıyor';
$string['copyinguserfiles'] = 'Kullanıcı dosyaları kopyalanıyor';
$string['copyingzipfile'] = 'Zip dosyası kopyalanıyor';
$string['copyrightnotice'] = 'Telif hakkı bildirimi';
$string['copytoclipboard'] = 'Panoya kopyala';
$string['coresystem'] = 'Sistem';
$string['cost'] = 'Ücret';
$string['costdefault'] = 'Varsayılan tutar';
$string['count_of_total'] = '<strong>{$a->count}</strong> of {$a->total}';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Ülke';
$string['course'] = 'Kurs';
$string['courseadministration'] = 'Kurs yönetimi';
$string['courseapprovedemail'] = 'Talep ettiğiniz kurs onaylandı, <a href=“{$a->url}”>{$a->name}</a>, ve siz bir {$a->teacher}\'sınız.';
$string['courseapprovedemail2'] = 'Talep ettiğiniz kurs onaylanmıştır: <a href=“{$a->url}”>{$a->name}</a>.';
$string['courseapprovedfailed'] = 'Kurs onaylandığı şekilde kaydedilemedi!';
$string['courseapprovedsubject'] = 'Kursunuz onaylandı.';
$string['courseavailable'] = 'Bu kurs öğrencilere yöneliktir';
$string['courseavailablenot'] = 'Bu kurs öğrencilere yönelik değildir';
$string['coursebackup'] = 'Kurs yedekleme';
$string['coursebulkaction'] = 'Seçilen kurslar için toplu işlem';
$string['coursecategories'] = 'Kurs kategorileri';
$string['coursecategory'] = 'Kurs kategorisi';
$string['coursecategory_help'] = 'Bu ayar kursun, kurs listesinde gösterileceği kategoriyi belirler.';
$string['coursecategorydeleted'] = '{$a} kurs kategorisi silindi';
$string['coursecatmanagement'] = 'Kurs ve kategori yönetimi';
$string['coursecompletion'] = 'Kurs tamamlama';
$string['coursecompletions'] = 'Kurs tamamlamaları';
$string['coursecreators'] = 'Kurs oluşturucu';
$string['coursecreatorsdescription'] = 'Kurs oluşturucuları yeni kurs oluşturabilir.';
$string['coursedeleted'] = '{$a} dersi silindi';
$string['coursedetails'] = 'Kurs ayrıntıları';
$string['coursedisplay'] = 'Kurs düzeni';
$string['coursedisplay_help'] = 'Kursun bölümleri tek sayafada veya bir kaç farklı sayfaya bölünerek görüntülenebilir';
$string['coursedisplay_multi'] = 'Sayfa başına bir bölüm göster';
$string['coursedisplay_single'] = 'Tüm bölümleri tek sayfada göster';
$string['courseduration'] = 'Kurs süresi';
$string['courseduration_desc'] = 'Kurs süresi, varsayılan kurs bitiş tarihini hesaplamak için kullanılır. Kurs bitiş tarihi, bir kursun kullanıcının kurs listesine dahil edilip edilmeyeceğini belirlemek için de kullanılır. Özel raporlamalar için de kullanılabilir. Kullanıcılar, bitiş tarihinden sonra kursa yine de girebilirler.';
$string['courseenddateenabled'] = 'Kurs bitiş tarihi varsayılan olarak etkindir';
$string['courseenddateenabled_desc'] = 'Bu ayar, kurs bitiş tarihinin varsayılan olarak yeni kurslar için etkinleştirilip etkinleştirilmeyeceğini ve belirlenen tarihin kurs süresine göre hesaplanıp, hesaplanmayacağını belirler.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Eski kurs dosyaları';
$string['coursefilesedit'] = 'Eski kurs dosyalarını düzenle';
$string['coursefileswarning'] = 'Kurs dosyaları kullanımda değil';
$string['coursefileswarning_help'] = 'Moodle 2.0 sürümünden beri kurs dosyaları kullanımda değil, lütfen mümkün olduğu kadar harici depoları kullanın.';
$string['courseformatdata'] = 'Kurs biçimi verisi';
$string['courseformatoptions'] = '{$a} için biçimlendirme seçenekleri';
$string['courseformats'] = 'Kurs biçimleri';
$string['courseformatudpate'] = 'Formatı güncelle';
$string['coursegrades'] = 'Kurs notları';
$string['courseheader'] = 'Kurs menüsü';
$string['coursehelpcategory'] = 'Kursu, kurs listesine yerleştirerek öğrencilerin bulmasını kolaylaştır.';
$string['coursehelpforce'] = 'Kursdaki her etkinlik için kurs grup modunu zorunlu kıl.';
$string['coursehelpformat'] = 'Kurs ana sayfası bu formatta görüntülenecek';
$string['coursehelphiddensections'] = 'Kursun saklı bölümleri öğrencilere nasıl gösterilmekte.';
$string['coursehelpmaximumupload'] = 'Site için varsayılan ayarla sınırlı olmak üzere, bu kursa yüklenebilecek en büyük dosya boyutunu tanımlayın.';
$string['coursehelpnewsitemsnumber'] = 'Kurs sayfasında en yeni bildirimler bloğundaki en yeni bildirimlerin sayısı. Bu ayar sıfır olursa, bildirimler bloğu gösterilmez.';
$string['coursehelpnumberweeks'] = 'Kursdaki bölüm sayısı (sadece belirli kurs biçimleri için geçerlidir).';
$string['coursehelpshowgrades'] = 'Not defterinin görüntülenmesini etkin kılın. Bu, bireysel etkinlikler içinde notların görüntülenmesini engellemez.';
$string['coursehidden'] = 'Bu kurs şu anda öğrencilere açık değil';
$string['courseinfo'] = 'Kurs bilgisi';
$string['courselegacyfiles'] = 'Eski kurs dosyaları';
$string['courselegacyfiles_help'] = 'Kurs dosyaları alanı geriye dönük olarak Moodle 1.9 ve önceki sürümleriyle bazı uyumluluklar sağlar. Bu alandaki tüm dosyalar kursun tüm katılımcılarının (onları ilişkilendirip ilişkilendirmediğiniz önemli olmadan) erişimine açıktır ve bu dosyaların Moodle içinde nerelerde kullanıldığını bilmenizin bir yolu yoktur.

Bu alanı kurs dosyalarını kaydetmek için kullanırsanız, kendinizi gizlilik ve güvenlik konularında bir dizi açıkla baş başa bırakmış olursunuz. Ayrıca yedeklemelerde, dersleri içeri aktarırken ve herhangi bir zamanda içerik paylaşılırken veya tekrar kullanılırken eksik dosyalarla karşılaşabilirsiniz. Bu nedenle, ne yaptığınızdan emin değilseniz, bu alanı kullanmamanız önerilir.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Eski kurs dosyaları: {$a}';
$string['coursenotaccessible'] = 'Bu kurs herkesin erişimine açık değil';
$string['courseoverview'] = 'Kursa genel bakış';
$string['courseoverviewfiles'] = 'Kurs görseli';
$string['courseoverviewfiles_help'] = 'Kurs görseli Kurslarım bölümünde ve Ana sayfadaki mevcut kurslar listesinde görüntülenir. Site yöneticileri ek dosya türlerini ve birden fazla dosya kullanımını etkinleştirebilir. Birden fazla dosya kullanırsanız bunların tümü Ana sayfadaki mevcut kurslar listesinde görüntülenir.';
$string['courseoverviewfilesext'] = 'Kurs görseli dosya uzantıları';
$string['courseoverviewfileslimit'] = 'Kurs görseli dosya boyutu limiti';
$string['courseoverviewgraph'] = 'Kurs genel bakış grafiği';
$string['courseprofiles'] = 'Kurs profilleri';
$string['coursereasonforrejecting'] = 'Bu isteği reddetme sebepleriniz';
$string['coursereasonforrejectingemail'] = 'Bu, talepte bulunan kişiye e-posta olarak gidecek';
$string['coursereject'] = 'Kurs isteğini reddet';
$string['courserejected'] = 'Kurs reddedildi ve talepte bulunan kişi bilgilendirildi.';
$string['courserejectemail'] = 'Üzgünüz, istediğiniz kurs onaylanmadı. Reddedilme sebebi:

{$a}';
$string['courserejectreason'] = 'Bu kursu reddetme sebebini açıklayın<br />(bu dersi talep edene iletilecek)';
$string['courserejectsubject'] = 'Kursunuz reddedildi';
$string['coursereport'] = 'Kurs raporu';
$string['coursereports'] = 'Kurs raporları';
$string['courserequest'] = 'Kurs talebi';
$string['courserequestdetails'] = 'Talep ettiğiniz dersin ayrıntıları';
$string['courserequestfailed'] = 'Bazı nedenlerle kurs talebiniz kaydedilmedi';
$string['courserequestintro'] = 'Sizin için açılacak bir kursu talep etmek için bu formu kullanın.<br />Bu dersin açılmasına izin verilmesi için gerektiği kadar bilgiyi yazın<br /> ki yöneticinin bu kursu isteme sebebinizi anlamasını sağlamış olun';
$string['courserequestreason'] = 'Bu kursu isteme sebepleri';
$string['courserequestroleerror'] = 'İçerik oluşturucuların yeni kurs yapılandırmasındaki rolü geçersiz. Lütfen <a href="{$a}">kullanıcı ilkeleri</a> bölümüne bakın.';
$string['courserequestsuccess'] = 'Kurs talebi gönderildi';
$string['courserequestsupport'] = 'Yöneticinin bu isteği değerlendirmesi için yardımcı bilgi';
$string['courserequestwarning'] = 'Bu kursu talep eden kullanıcı otomatik olarak kayıt yaptırılacak ve {$a} rolü atanacaktır.';
$string['courserestore'] = 'Kurs geri yükleme';
$string['coursereuse'] = 'Kurs yeniden kullanımı';
$string['coursereusenavigationmenu'] = 'Kurs yeniden kullanım gezinti menüsü';
$string['courses'] = 'Kurslar';
$string['coursesectionsummaries'] = 'Kurs bölüm özetleri';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Toplu düzenleme {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Düzenle {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Kurs varsayılan ayarları';
$string['coursesmovedout'] = 'Kurslar {$a} \'den çıkartıldı';
$string['coursespending'] = 'Onay bekleyen kurslar';
$string['coursestart'] = 'Kurs başlangıcı';
$string['coursesummary'] = 'Kurs özeti';
$string['coursesummary_help'] = 'Kursunuzun kısa bir açıklaması. Buraya eklediğiniz içerik aramaya dahil edilir.';
$string['coursetitle'] = 'Kurs : {$a->course}';
$string['coursetitlebulkediting'] = 'Kursu toplu düzenle: {$a->course}';
$string['coursetitleediting'] = 'Kursu düzenle: {$a->course}';
$string['courseupdates'] = 'Kurs güncellemeleri';
$string['coursevisibility'] = 'Kurs görünürlüğü';
$string['coursevisibility_help'] = '* Göster: Kurs, kurslar listesinde görünür ve öğrenciler kursa erişebilir.
* Gizle: Erişim, öğretmenler ve gizli kursları görüntüleme yetkisine sahip diğer kullanıcılarla sınırlıdır.';
$string['create'] = 'Oluştur';
$string['createaccount'] = 'Yeni hesabımı oluştur';
$string['createcategory'] = 'Kategori oluştur';
$string['createfolder'] = '{$a} içinde bir klasör oluştur';
$string['createnew'] = 'Yeni oluştur';
$string['createnewcategory'] = 'Yeni kategori oluştur';
$string['createnewcourse'] = 'Yeni kurs oluştur';
$string['createnewsubcategory'] = 'Yeni alt kategori oluştur';
$string['createsubcategoryof'] = '{$a} için alt kategori oluştur';
$string['createuser'] = 'Kullanıcı oluştur';
$string['createziparchive'] = 'Zip arşivi oluştur';
$string['creatingblocks'] = 'Bloklar oluşturuluyor';
$string['creatingblocksroles'] = 'Blok seviyesindeki rol atamaları ve üstüne yazma izinleri oluşturuluyor';
$string['creatingblogsinfo'] = 'Blog bilgileri oluşturuluyor';
$string['creatingcategoriesandquestions'] = 'Kategoriler ve sorular oluşturuluyor';
$string['creatingcoursemodules'] = 'Kurs eklentileri oluşturuluyor';
$string['creatingcourseroles'] = 'Kurs seviyesindeki rol atamaları ve üstüne yazma izinleri oluşturuluyor';
$string['creatingevents'] = 'Etkinlikler oluşturuluyor';
$string['creatinggradebook'] = 'Not defteri oluşturuluyor';
$string['creatinggroupings'] = 'Gruplamalar oluşturuluyor';
$string['creatinggroupingsgroups'] = 'Gruplar gruplamalara ekleniyor';
$string['creatinggroups'] = 'Gruplar oluşturuluyor';
$string['creatinglogentries'] = 'Kayıt girdileri oluşturuluyor';
$string['creatingmessagesinfo'] = 'İleti bilgileri oluşturuluyor';
$string['creatingmodroles'] = 'Eklenti seviyesindeki rol atamaları ve üstüne yazma izinleri oluşturuluyor';
$string['creatingnewcourse'] = 'Yeni kurs oluşturuluyor';
$string['creatingrolesdefinitions'] = 'Rol tanımlamaları oluşturuluyor';
$string['creatingscales'] = 'Ölçekler oluşturuluyor';
$string['creatingsections'] = 'Bölümler oluşturuluyor';
$string['creatingtemporarystructures'] = 'Geçici yapılar oluşturuluyor';
$string['creatinguserroles'] = 'Kullanıcı seviyesindeki rol atamaları ve geçersiz kılma izinleri oluşturuluyor';
$string['creatingusers'] = 'Kullanıcılar oluşturuluyor';
$string['creatingxmlfile'] = 'XML dosyası oluşturuluyor';
$string['currency'] = 'Para birimi';
$string['currentcourse'] = 'Şu andaki ders';
$string['currentcourseadding'] = 'Şu andaki ders, veri eklemekte';
$string['currentcoursedeleting'] = 'Şu andaki ders, öncelikle siliyor';
$string['currentlanguage'] = 'Geçerli dil';
$string['currentlocaltime'] = 'geçerli yerel zamanınız';
$string['currentpicture'] = 'Geçerli resim';
$string['currentrelease'] = 'Şu andaki sürüm bilgisi';
$string['currenttheme'] = 'Geçerli tema';
$string['currentversion'] = 'Şu andaki versiyon';
$string['databasechecking'] = 'Moodle veritabanı {$a->oldversion} sürümünden {$a->newversion} sürümüne yükseltiliyor';
$string['databaseperformance'] = 'Veritabanı performansı';
$string['databasesetup'] = 'Veritabanı ayarlanıyor';
$string['databasesuccess'] = 'Veritabanı başarıyla yükseltildi';
$string['databaseupgradebackups'] = 'Yedekleme versiyonu şu anda; {$a}';
$string['databaseupgradeblocks'] = 'Bloklar versiyonu şu anda; {$a}';
$string['databaseupgradegroups'] = 'Gruplar versiyonu şu anda; {$a}';
$string['databaseupgradelocal'] = 'Yerel veritabanı özelleştirmeleri versiyonu; {$a}';
$string['databaseupgrades'] = 'Veritabanı yükseltiliyor';
$string['dataformats'] = 'Veri formatları';
$string['date'] = 'Tarih';
$string['datechanged'] = 'Değiştirme tarihi';
$string['datemostrecentfirst'] = 'Tarih - en yeniler önce';
$string['datemostrecentlast'] = 'Tarih - en yeniler sonra';
$string['datetimefilterafter'] = '{$a->title} sonraki';
$string['datetimefilterbefore'] = '{$a->başlık} önceki';
$string['day'] = 'gün';
$string['days'] = 'gün';
$string['decodinginternallinks'] = 'Dahili bağlantılar çözülüyor';
$string['default'] = 'Varsayılan';
$string['defaultcategoryname'] = 'Kategori 1';
$string['defaultcompetencescale'] = 'Varsayılan yetki ölçeği';
$string['defaultcompetencescaledesc'] = 'Birisinin yetkinlik gösterip göstermediği hakkında daha fazla bilgi sağlayan ikili derecelendirme ölçeği.';
$string['defaultcompetencescalenotproficient'] = 'Henüz yetkin değil';
$string['defaultcompetencescaleproficient'] = 'Yetkin';
$string['defaultcoursestudent'] = 'Öğrenci';
$string['defaultcoursestudentdescription'] = 'Öğrenciler genellikle kurs içinde daha az ayrıcalıklara sahiptir.';
$string['defaultcoursestudents'] = 'Öğrenciler';
$string['defaultcoursesummary'] = 'Bu kursun ne hakkında olduğunu açıklayan özlü ve ilgi çekici bir paragraf yazın';
$string['defaultcourseteacher'] = 'Öğretmen';
$string['defaultcourseteacherdescription'] = 'Etkinlikleri değiştirme ve öğrencilere not vermek de dahil, bir derste her şeyi yapabilirler.';
$string['defaultcourseteachers'] = 'Öğretmen(ler)';
$string['defaulteditor'] = 'Varsayılan düzenleyici';
$string['defaulthomepageuser'] = 'Başlangıç sayfası';
$string['defaulthomepageuser_help'] = 'Siteye giriş yaptıktan sonra hangi sayfaya yönlendirilmeniz gerekiyor?';
$string['delete'] = 'Sil';
$string['deleteablock'] = 'Bir blok sil';
$string['deleteall'] = 'Tümünü sil';
$string['deleteallcannotundo'] = 'Tümünü sil - geri alınamaz';
$string['deleteallcomments'] = 'Tüm yorumlar';
$string['deleteallratings'] = 'Tüm puanlar';
$string['deletecategory'] = 'Kategori sil: {$a}';
$string['deletecategorycheck'] = '<b>\'{$a}\'</b> kategosini tamamen silmek istediğinizden emin misiniz?<br />Bu kategoride herhangi bir kurs varsa bu kurslar \'Ana kategori\'ye veya \'Çeşitli kategorisi\'ne taşınacak.';
$string['deletecategorycheck2'] = 'Bu kategoriyi silmeniz durumunda bu kategorideki karslara ve alt kategorilerine ne yapılması gerektiğini seçmeniz gerekir.';
$string['deletecategoryempty'] = 'Bu kategori boş.';
$string['deletecheck'] = '{$a} silinsin mi?';
$string['deletecheckfiles'] = 'Bu dosyaları silmek istediğinizden emin misiniz?';
$string['deletecheckfull'] = '{$a} adlı kullanıcıyı, derse üyeliğini ve onun diğer tüm kullanıcı verilerini tamamen silmek istediğinize emin misiniz?';
$string['deletechecktype'] = '{$a->type} öğesini silmek istediğinizden emin misiniz?';
$string['deletechecktypename'] = '{$a->type} "{$a->name}" öğesini silmek istediğinizden emin misiniz?';
$string['deletecheckwarning'] = 'Bu dosyaları silmek üzeresiniz';
$string['deletecommentbyon'] = '{$a->user} tarafından {$a->time} tarihinde/zamanında gönderilmiş olan yorumu sil';
$string['deletecompletely'] = 'Tamamen sil';
$string['deletecourse'] = 'Kursu sil';
$string['deletecoursecheck'] = 'Bu kursu ve içindeki tüm bilgileri tamamen silmek istediğinizden emin misiniz?';
$string['deleted'] = 'Silindi';
$string['deletedactivity'] = '{$a} silindi';
$string['deletedcourse'] = '{$a} tamamen silindi';
$string['deletednot'] = '{$a} silinemedi!';
$string['deletepicture'] = 'Sil';
$string['deletesection'] = 'Sil';
$string['deleteselected'] = 'Seçilileri sil';
$string['deleteselectedkey'] = 'Seçili anahtarı sil';
$string['deletingcourse'] = '{$a} siliniyor';
$string['deletingexistingcoursedata'] = 'Mevcut kurs verileri siliniyor';
$string['deletingolddata'] = 'Eski veri siliniyor';
$string['department'] = 'Bölüm';
$string['deprecatedeventname'] = '{$a} (artık kullanılmıyor)';
$string['desc'] = 'Azalan';
$string['description'] = 'Açıklama';
$string['deselectall'] = 'Tümünü seçimini kaldır';
$string['deselectnos'] = 'Tüm \'Hayır\'ları kaldırın';
$string['detailedless'] = 'Daha az ayrıntılı';
$string['detailedmore'] = 'Daha fazla ayrıntılı';
$string['details'] = 'Detay';
$string['digitalminor'] = 'Dijital küçük';
$string['digitalminor_desc'] = 'Lütfen ebeveyninizden / velinizden iletişim kurmasını isteyin:';
$string['directory'] = 'Dizin';
$string['disable'] = 'Devre dışı bırak';
$string['disabledcomments'] = 'Yorumlar devre dışı bırakıldı';
$string['dismissnotification'] = 'Bu bildirimi reddet';
$string['displayingfirst'] = 'Sadece ilk {$a->count} {$a->things} gösteriliyor';
$string['displayingrecords'] = '{$a} kayıt gösteriliyor';
$string['displayingusers'] = '{$a->start} - {$a->end} arası kullanıcılar gösteriyor';
$string['displayonpage'] = 'Sayfada göster';
$string['dndcourse'] = 'Sıralamasını değiştirmek veya başka bir kategoriye taşımak için bu kursu sürükleyip bırakabilirsin.';
$string['dndenabled_inbox'] = 'Eklemek istediğiniz dosyaları buraya sürükleyip bırakabilirsiniz.';
$string['dndnotsupported'] = 'Sürükle bırak yükleme özelliği desteklenmiyor';
$string['dndnotsupported_help'] = 'Tarayıcınız sürükle bırakla yükleme özelliğini deseklemiyor. Bu özellik İnternet Explorer v10 ve üzeri versiyonlarda olduğu gibi Chrome, Firefox ve Safari tarayıcılarının mevcut sürümleri tarafından da desteklenmektedir.';
$string['dndnotsupported_insentence'] = 'sürükle ve bırak desteklenmiyor';
$string['dnduploadwithoutcontent'] = 'Yüklenen dosyada içerik yok';
$string['dndworkingfile'] = 'Dosyaları kurs bölümlerine yüklemek için sürükleyin ve bırakın';
$string['dndworkingfilelink'] = 'Dosyaları veya bağlantıları kurs bölümlerine yüklemek için sürükleyin ve bırakın';
$string['dndworkingfiletext'] = 'Dosyaları veya metinleri kurs bölümlerine yüklemek için sürükleyin ve bırakın';
$string['dndworkingfiletextlink'] = 'Dosyaları, metinleri veya bağlantıları kurs bölümlerine yüklemek için sürükleyin ve bırakın';
$string['dndworkinglink'] = 'Bağlantıları kurs bölümlerine yüklemek için sürükleyin ve bırakın';
$string['dndworkingtext'] = 'Metinleri kurs bölümlerine yüklemek için sürükleyin ve bırakın';
$string['dndworkingtextlink'] = 'Metinleri veya bağlantıları kurs bölümlerine yüklemek için sürükleyin ve bırakın';
$string['documentation'] = 'Moodle dökümantasyon';
$string['dontsortcategories'] = 'Kategorileri sıralama';
$string['dontsortcourses'] = 'Kursları sıralama';
$string['down'] = 'Aşağı';
$string['download'] = 'İndir';
$string['downloadall'] = 'Tümünü indir';
$string['downloadexcel'] = 'Excel formatında indir';
$string['downloadfile'] = 'Dosya indir';
$string['downloadods'] = 'ODS formatında indir';
$string['downloadtext'] = 'Metin formatında indir';
$string['doyouagree'] = 'Koşulları okuyup kabul ediyor musunuz?';
$string['droptoupload'] = 'Yüklemek için dosyaları buraya bırakın';
$string['duplicate'] = 'Kopyasını oluştur';
$string['duplicatedmodule'] = '{$a} (kopya)';
$string['duplicatedsection'] = 'copy{$a} (copy)';
$string['edhelpaspellpath'] = 'Sözcük-denetimini kullanabilmeniz için sunucuda <strong>aspell 0.50</strong> veya daha yeni bir sürümünün olması ve aspell programının yolunun doğru belirtilmesi gerekiyor. Bu genellikle Unix/Linux sistemlerinde <strong>/usr/bin/aspell</strong> yolundadır fakat bazen başka bir yer de olabilir.';
$string['edhelpbgcolor'] = 'Düzenleme alanının arkaplan rengini tanımlayın.<br />Geçerli değerlere örnekler: #FFFFFF veya beyaz';
$string['edhelpcleanword'] = 'Bu ayar Word\'e özgü biçimlendirme filtresini etkinleştirir ya da devre dışı bırakır.';
$string['edhelpenablespelling'] = 'Sözcük denetimini etkinleştirin ya da devre dışı bırakın. Etkinleştirildiğinde <strong>aspell</strong> sunucuda kurulu olmalıdır. İkinci değer <strong>varsayılan sözlük</strong>tür. Aspell kullanıcının kendisinin belirtiği sözcüğe sahip değilse, buradaki değer kullanılacaktır.';
$string['edhelpfontfamily'] = 'Yazıtipi-ailesi özelliği genel font adlarının ve/veya font adlarının listesidir. Font tipleri virgül ile ayrılmalı.';
$string['edhelpfontlist'] = 'Editörün açılır menüsünde kullanılacak fontları tanımlayın.';
$string['edhelpfontsize'] = 'Font için varsayılan yazı boyutu. <br />Geçerli değerlere örnekler: orta, büyük, daha küçük, daha büyük, 10pt, 11px.';
$string['edit'] = 'Düzenle ';
$string['edita'] = '{$a} \'yı düzenle';
$string['editcategorysettings'] = 'Kategori ayarlarını düzenle';
$string['editcategorythis'] = 'Bu kategoriyi düzenle';
$string['editcoursesettings'] = 'Kurs ayarlarını düzenle';
$string['editfiles'] = 'Dosyaları düzenle';
$string['editgroupprofile'] = 'Grup bilgisini düzenle';
$string['editingteachershort'] = 'Editör';
$string['editlock'] = 'Bu değer düzenlenemez!';
$string['editmode'] = 'Düzenleme modu';
$string['editmyprofile'] = 'Profil düzenle';
$string['editorbgcolor'] = 'Arka plan rengi';
$string['editorcleanonpaste'] = 'Yapıştırırken World HTML değerlerini temizle';
$string['editorcommonsettings'] = 'Genel ayarlar';
$string['editordefaultfont'] = 'Varsayılan font';
$string['editorenablespelling'] = 'Sözcük denetimini etkinleştir';
$string['editorfontlist'] = 'Font listesi';
$string['editorfontsize'] = 'Varsayılan font boyutu';
$string['editorpreferences'] = 'Editör tercihleri';
$string['editorresettodefaults'] = 'Varsayılan değerlere dön';
$string['editorsettings'] = 'Editor ayarları';
$string['editorshortcutkeys'] = 'Editör kısayolları';
$string['editsection'] = 'Bölümleri düzenle';
$string['editsectionname'] = 'Bölüm adını düzenle';
$string['editsectionsettings'] = 'Bölüm ayarlarını düzenleyin';
$string['editsectiontitle'] = 'Bölümü düzenle: {$a}';
$string['editsettings'] = 'Ayarları düzenle';
$string['editthisactivity'] = 'Bu etkinliği düzenle';
$string['editthiscategory'] = 'Bu kategoriyi düzenle';
$string['edittitle'] = 'Başlığı Düzenle';
$string['edittitleinstructions'] = 'İptal için Esc tuşuna, bittiğinde Enter tuşuna basın';
$string['edituser'] = 'Kullanıcı hesaplarını düzenle';
$string['edulevel'] = 'Tüm etkinlikler';
$string['edulevel_help'] = '* Öğretme - bir öğretmen tarafından gerçekleştirilen eylemler; örneğin, bir kaynağı güncelleme
* Katılımcılık - bir öğrencinin yaptığı eylemler; örneğin, foruma ileti gönderme
* Diğer - öğretmen veya öğrenciden başka bir rolü olan bir kullanıcı tarafından gerçekleştirilen eylemler';
$string['edulevelother'] = 'Diğer';
$string['edulevelparticipating'] = 'Katılıyor';
$string['edulevelteacher'] = 'Öğretiyor';
$string['email'] = 'E-posta adresi';
$string['emailactive'] = 'E-posta etkinleştirildi';
$string['emailagain'] = 'E-posta (tekrar)';
$string['emailalreadysent'] = 'Şifre sıfırlama e-postası zaten gönderildi. E-postanızı kontrol edin.';
$string['emailcharset'] = 'E-posta karakter seti';
$string['emailconfirm'] = 'Hesabınızı onaylayın';
$string['emailconfirmation'] = 'Merhaba {$a->firstname},

E-posta adresiniz kullanılarak
 \'{$a->sitename}\'de yeni bir hesap talep edilmiştir.

Yeni hesabınızı onaylamak için lütfen bu web adresine gidin:

{$a->link}

Çoğu posta programında bu, üzerine tıklayabileceğiniz
mavi bir bağlantı olarak görünmelidir.
Bu işe yaramazsa, adresi kesip
web tarayıcınızın penceresinin üst kısmındaki
adres satırına yapıştırın.

Yardıma ihtiyacınız olursa, lütfen site yöneticisi ile iletişime geçin, {$a->admin}';
$string['emailconfirmationresend'] = 'Onaylama e-postasını yeniden gönder';
$string['emailconfirmationsubject'] = '{$a}: hesap onayı';
$string['emailconfirmsent'] = '<p>Bu e-posta adresinize (<b>{$a}</b>) bir e-posta gönderildi.</p>
<p>Bu e-posta, kaydınızı tamamlamanız için basit yönergeleri içermektedir.</p>
<p>Bu işlemleri yaparken bir zorlukla karşılaşırsanız site yöneticiyle iletişim kurabilirsiniz.</p>';
$string['emailconfirmsentfailure'] = 'Onaylama e-postası gönderilemedi';
$string['emailconfirmsentsuccess'] = 'Onaylama e-postası başarıyla gönderildi';
$string['emaildigest'] = 'E-posta özet türü';
$string['emaildigest_help'] = 'Bu, forumların varsayılan olarak kullanacağı günlük özet ayarıdır.

* Özet gönderilmesin - her forum iletisi başına bir e-posta alırsınız;
* Özet - eksiksiz iletiler - her forum iletisinin tüm içeriğini kapsayan günde sadece bir e-posta alırsınız;
* Özet - sadece konular - her forum iletisinin sadece konusunu kapsayan günde sadece bir e-posta alırsınız.

İsterseniz her bir forum için farklı bir ayar seçebilirsiniz.';
$string['emaildigestcomplete'] = 'Tamamı (bütün iletileri içeren günlük e-posta)';
$string['emaildigestoff'] = 'Özet yok (her forum iletisi için bir e-posta)';
$string['emaildigestsubjects'] = 'Konular (sadece konuları içeren günlük email)';
$string['emaildisable'] = 'Bu e-posta adresi etkin değil';
$string['emaildisableclick'] = 'Bu adrese gönderilen tüm e-postaları devre dışı bırakmak için burayı tıklayın';
$string['emaildisplay'] = 'E-posta gösterimi';
$string['emaildisplay_help'] = '* Gizli - Yalnızca öğretmenler gibi uygun izinlere sahip kullanıcılar e-posta adresinizi görebilir.
* Herkes görebilir - Sitedeki tüm kullanıcılar e-posta adresinizi görebilir.
* Kurs katılımcılarına görünür - E-posta adresinizi yalnızca kayıtlı olduğunuz kursların katılımcıları görebilir.';
$string['emaildisplaycourse'] = 'Kurs katılımcılarına görünür';
$string['emaildisplaycoursemembersonly'] = '(Diğer derse katılanlar da görebilir)';
$string['emaildisplayeveryone'] = '(Herkes görebilir)';
$string['emaildisplayhide'] = 'Gerekli izinlere sahip kullanıcılar dışında herkesten gizlenmiştir)';
$string['emaildisplayno'] = 'Gizli';
$string['emaildisplayyes'] = 'Herkesin görünür';
$string['emailenable'] = 'Bu e-posta adresi etkin';
$string['emailenableclick'] = 'Bu adrese gönderilen tüm epostaları tekrar aktif hale getirmek için burayı tıklayın';
$string['emailexists'] = 'Bu e-posta adresi zaten kayıtlı.';
$string['emailexistshintlink'] = 'Unutulan kullanıcı adını ya da şifreyi yeniden edin';
$string['emailexistssignuphint'] = 'Geçmişte bir hesap oluşturmuş olabilir misiniz? {$a}';
$string['emailformat'] = 'E-posta formatı';
$string['emailmustbereal'] = 'Not: E-posta adresiniz gerçek olmalıdır';
$string['emailnotallowed'] = '{$a} alan adından e-posta adreslerine izin verilmiyor';
$string['emailnotfound'] = 'E-posta adresi veritabanında bulunamadı';
$string['emailonlyallowed'] = 'Bu e-posta kullanılamaz. İzin verilen e-posta alan adları şunlardır: {$a}.';
$string['emailpasswordchangeinfo'] = 'Merhaba {$a->firstname},

Birisi (büyük olasılıkla siz) \'{$a->sitename}\' sitesindeki \'{$a->username}\'  hesabı için yeni bir şifre isteğinde bulundu.

Şifrenizi değiştirmek için aşağıdaki linki takip edin:

{$a->link}

Bir çok mail programı yukarıdaki linki tıklanabilir olarak göstermektedir. Tıklanabilir değilse, linkin üzerine gelip sağ tıklayarak kopyalayın ve web tarayıcınızı açarak adres çubuğuna bu adresi yapıştırın.

Yardıma ihtiyacınız olursa site yöneticisiyle iletişim kurun:
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Merhaba {$a->firstname},

Birisi (büyük olasılıkla siz) \'{$a->sitename}\' sitesindeki hesabınız için yeni bir şifre isteğinde bulundu.

Bu sitedeki hesabınız etkin olmadığı için şifreniz oluşturulamaz. Lütfen site yöneticisiyle iletişim kurun:
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Merhaba {$a->firstname},

Birisi (büyük olasılıkla siz) \'{$a->sitename}\' sitesindeki hesabınız için yeni bir şifre isteğinde bulundu.

Maalesef, bu sitede şifreler yeniden oluşturulamaz. Lütfen site yöneticisiyle iletişim kurun:
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Şifre değişim bilgisi';
$string['emailpasswordconfirmation'] = 'Merhaba {$a->firstname},

Birisi (büyük olasılıkla siz) \'{$a->sitename}\' sitesindeki hesabınız için yeni bir şifre isteğinde bulundu.

Bunu onaylıyor ve yeni bir şifrenin e-posta adresinize gönderilmesini istiyorsanız, aşağıdaki bağlantıyı takip edin:

{$a->link}

Bir çok e-posta programı yukarıdaki bağlantıyı tıklanabilir olarak göstermektedir. Tıklanabilir değilse, bağlantının üzerine gelip sağ tıklayarak kopyalayın ve web tarayıcınızı açarak adres çubuğuna bu adresi yapıştırın.

Yardıma ihtiyacınız olursa site yöneticisiyle iletişim kurun:
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Şifre değiştirme onayı';
$string['emailpasswordconfirmmaybesent'] = '<p>Geçerli bir kullanıcı adı veya benzersiz bir e-posta adresi belirttiyseniz size şu anda bir e-posta gönderildi.</p>
<p>Bu e-posta, şifre değişimini onaylayıp işlemi tamamlamanız için basit yönergeleri içermektedir. Zorluk yaşarsanız, lütfen site yöneticisiyle iletişim kurun.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Belirttiğiniz kullanıcı hesabının kayıtlı bir e-posta adresi yok.</p>
   <p>Lütfen site yöneticisi ile iletişime geçin.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Verdiğiniz kullanıcı bilgileri, mevcut bir kullanıcı hesabı tanımlamıyor.</p>
   <p>Yazdığınız bilgileri kontrol edip tekrar deneyin.
Sorun yaşamaya devam ederseniz, site yöneticisi ile iletişime geçin.</p>';
$string['emailpasswordconfirmsent'] = 'E-posta adresinize (<b>{$a}</b>) bir e-posta gönderildi.<br />Bu e-posta, şifre değişimini tamamlamanız için basit yönergeleri içermektedir.
Bu işlemleri yaparken zorluk yaşarsanız site yöneticisiyle iletişim kurabilirsiniz.';
$string['emailresetconfirmation'] = 'Merhaba {$a->firstname},

{$a->sitename} sitesindeki \'{$a->username}\' hesabınız için şifre sıfırlama talebinde bulunuldu.

Bu isteği onaylamak ve hesabınız için yeni bir şifre belirlemek için, lütfen aşağıdaki web adresini ziyaret edin:
<a href="{$a->link}">{$a->link}</a>

(Bu bağlantı, sıfırlama talebinin istendiği andan itibaren {$a->resetminutes} dakika geçerlidir)

Şifre sıfırlama, sizin tarafınızdan talep edilmediyse herhangi bir şey yapmanıza gerek yok.

Yardıma ihtiyacınız varsa, site yöneticisi ile irtibata geçiniz.
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Şifre sıfırlama talebi';
$string['emailresetconfirmsent'] = '<b>{$a}</b> adresinize bir e-posta gönderildi.<br />
Bu e-posta, şifre değiştirmenizi onaylamak ve tamamlamak için kolay yönergeler içermektedir.
Sorun yaşamaya devam ederseniz, site yöneticisine başvurun.';
$string['emailstop'] = 'Bildirimleri devre dışı bırak';
$string['emailtoprivatefiles'] = 'Dosyalarınızı e-postayla doğrudan özel alanınıza gönderebilirsiniz. Dosyalarınızı e-postaya ekleyin ve {$a} adresine gönderin';
$string['emailtoprivatefilesdenied'] = 'Yönetici kendi dosyalarınızı yükleme seçeneğini kapattı.';
$string['emailvia'] = '{$a->name} ({$a->siteshortname} üzerinden)';
$string['emojicategoryactivities'] = 'Etkinlikler';
$string['emojicategoryanimalsnature'] = 'Hayvanlar ve doğa';
$string['emojicategoryflags'] = 'Bayraklar';
$string['emojicategoryfooddrink'] = 'Yiyecek & içecek';
$string['emojicategoryobjects'] = 'Nesneler';
$string['emojicategorypeoplebody'] = 'İnsan & vücut';
$string['emojicategoryrecent'] = 'Son kullanılanlar';
$string['emojicategorysmileysemotion'] = 'Gülümseme & Duygu';
$string['emojicategorysymbols'] = 'Semboller';
$string['emojicategorytravelplaces'] = 'Seyahat & yerler';
$string['emptycmids'] = 'Boş Modül ID\'si';
$string['emptydragdropregion'] = 'boş bölge';
$string['emptysectionids'] = 'Boş Bölüm ID\'si';
$string['enable'] = 'Etkinleştir';
$string['encryptedcode'] = 'Şifrelenmiş kod';
$string['enddate'] = 'Kurs bitiş tarihi';
$string['enddate_help'] = 'Bitiş tarihi, öğrencilerin kursa erişimini kısıtlamaz. Bir kursun Kurslarım bölümünde Geçmiş olarak listelenip listelenmediğini belirler.';
$string['enddatewithtaskenabled'] = 'Kurs bitiş tarihi';
$string['enddatewithtaskenabled_help'] = 'Kursun öğrenciler için gizli hale geldiği ve artık erişemeyecekleri tarih.';
$string['english'] = 'İngilizce';
$string['enrolmentmethods'] = 'Kayıt yöntemleri';
$string['entercourse'] = 'Bu kursa girmek için tıklayınız';
$string['enteremail'] = 'E-posta adresinizi girin';
$string['enteremailaddress'] = 'Şifrenizi sıfırlamak ve yeni şifrenizi
e-postayla almak için e-posta adresinizi girin.';
$string['enterusername'] = 'Kullanıcı adınızı girin';
$string['entries'] = 'Girdiler';
$string['error'] = 'Hata';
$string['errorcreatingactivity'] = '\'{$a}\' etkinliğinin örneği oluşturulamıyor';
$string['errorfiletoobig'] = 'Dosya {$a} bayt limitinden daha büyük';
$string['errornouploadrepo'] = 'Bu site için etkin bir yükleme deposu yok';
$string['errorwhenconfirming'] = 'Bir hata oluştuğundan dolayı işlem onaylanamadı. E-postadaki bir bağlantıya tıklayarak buraya geldiyseniz, bu bağlantının yarım ya da alt satıra geçmiş halde olmadığından emin olun. Bağlantının düzgün olarak görünmesi için kopyala/yapıştır özelliğini kullanabilirsiniz.';
$string['eventcommentcreated'] = 'Yorum oluşturuldu';
$string['eventcommentdeleted'] = 'Yorum silindi';
$string['eventcommentsviewed'] = 'Yorumlar görüntülendi';
$string['eventconfiglogcreated'] = 'Yapılandırma günlüğü (kayıt defteri) oluşturuldu';
$string['eventcontentviewed'] = 'İçerik görüntülendi';
$string['eventcoursebackupcreated'] = 'Kurs yedeği oluşturuldu';
$string['eventcoursecategorycreated'] = 'Kategori oluşturuldu';
$string['eventcoursecategorydeleted'] = 'Kategori silindi';
$string['eventcoursecategoryupdated'] = 'Kategori güncellendi';
$string['eventcoursecategoryviewed'] = 'Kategori görüntülendi';
$string['eventcoursecontentdeleted'] = 'Kurs içeriği silindi';
$string['eventcoursecreated'] = 'Kurs oluşturuldu';
$string['eventcoursedeleted'] = 'Kurs silindi';
$string['eventcourseended'] = 'Kurs sona erdi';
$string['eventcourseinformationviewed'] = 'Kurs özeti görüntülendi';
$string['eventcoursemodulecreated'] = 'Kurs modülü oluşturuldu';
$string['eventcoursemoduledeleted'] = 'Kurs modülü silindi';
$string['eventcoursemoduleinstancelistviewed'] = 'Kurs modül örneği listesi görüntülendi';
$string['eventcoursemoduleupdated'] = 'Kurs modülü güncellendi';
$string['eventcoursemoduleviewed'] = 'Kurs modülü görüntülendi';
$string['eventcourseoverviewviewed'] = 'Kurs etkinliklerine genel bakış sayfası görüntülendi.';
$string['eventcourseresetended'] = 'Kurs sıfırlama tamamlandı';
$string['eventcourseresetstarted'] = 'Kurs sıfırlama başladı';
$string['eventcourserestored'] = 'Kurs geri yüklendi';
$string['eventcoursesectioncreated'] = 'Kurs bölümü oluşturuldu';
$string['eventcoursesectiondeleted'] = 'Kurs bölümü silindi';
$string['eventcoursesectionupdated'] = 'Kurs bölümü güncellendi';
$string['eventcoursessearched'] = 'Aranan kurslar';
$string['eventcoursestarted'] = 'Kurs başladı';
$string['eventcourseupdated'] = 'Kurs güncellendi';
$string['eventcourseuserreportviewed'] = 'Kurs kullanıcı raporu görüntülendi';
$string['eventcourseviewed'] = 'Kurs görüntülendi';
$string['eventdashboardreset'] = 'Kontrol paneli sıfırlandı';
$string['eventdashboardsreset'] = 'Kontrol panelleri sıfırlandı';
$string['eventdashboardviewed'] = 'Kontrol paneli görüntülendi';
$string['eventdatabasetextfieldcontentreplaced'] = 'Veritabanı genel arama ve değiştirme';
$string['eventemailfailed'] = 'E-posta gönderilemedi';
$string['eventmycoursesviewed'] = 'Kurslarım görüntülendi';
$string['eventname'] = 'Etkinlik adı';
$string['eventrecentactivityviewed'] = 'Görüntülenen yakın zaman etkinliği';
$string['eventsearchindexed'] = 'Arama verisi indekslendi';
$string['eventsearchresultsviewed'] = 'Arama sonuçları görüntülendi';
$string['eventsectionviewed'] = 'Bölüm görüntülendi';
$string['eventunknownlogged'] = 'Bilinmeyen etkinlik';
$string['eventurlblocked'] = 'URL engellendi';
$string['eventusercreated'] = 'Kullanıcı oluşturuldu';
$string['eventuserdeleted'] = 'Kullanıcı silindi';
$string['eventuserfeedbackgiven'] = 'Geri bildirim bağlantısı tıklandı';
$string['eventuserfeedbackremind'] = 'Yeniden hatırlat geri bildirim bağlantısı tıklandı';
$string['eventuserinfocategorycreated'] = 'Kullanıcı profili alanı kategorisi oluşturuldu';
$string['eventuserinfocategorydeleted'] = 'Kullanıcı profili alanı kategorisi silindi';
$string['eventuserinfocategoryupdated'] = 'Kullanıcı profili alanı kategorisi güncelendi';
$string['eventuserinfofieldcreated'] = 'Kullanıcı profili alanı oluşturuldu';
$string['eventuserinfofielddeleted'] = 'Kullanıcı profili alanı silindi';
$string['eventuserinfofieldupdated'] = 'Kullanıcı profili alanı güncellendi';
$string['eventuserlistviewed'] = 'Kullanıcı listesi görüntülendi';
$string['eventuserloggedout'] = 'Kullanıcı oturumu kapattı';
$string['eventuserpasswordpolicyfailed'] = 'Kullanıcı şifresi başarısız şifre ilkesi';
$string['eventuserpasswordupdated'] = 'Kullanıcı şifresi güncellendi';
$string['eventuserprofileviewed'] = 'Kullanıcı profili görüntülendi';
$string['eventuserupdated'] = 'Kullanıcı güncellendi';
$string['everybody'] = 'Herkes';
$string['executeat'] = 'Şu saatte çalıştır:';
$string['existing'] = 'Mevcut';
$string['existingadmins'] = 'Mevcut yöneticiler';
$string['existingcourse'] = 'Mevcut ders';
$string['existingcourseadding'] = 'Mevcut ders, veri ekleniyor';
$string['existingcoursedeleting'] = 'Mevcut ders, öncelikle siliniyor';
$string['existingcreators'] = 'Mevcut kurs oluşturucular';
$string['existingstudents'] = 'Kayıtlı öğrenciler';
$string['existingteachers'] = 'Mevcut eğitimciler';
$string['expand'] = 'Genişlet';
$string['expandall'] = 'Tümünü genişlet';
$string['expandcategory'] = '{$a} \'yı genişlet';
$string['explanation'] = 'Açıklama';
$string['explanationdigitalminor'] = 'Bu bilgi, yaşınızın dijital rıza yaşının üzerinde olup olmadığını belirlemek için gereklidir.  Bu, bireyin şartlar ve koşulları kabul edebileceği ve verilerinin yasal olarak saklanıp işlendiği yaştır.';
$string['extendperiod'] = 'Uzatılan süre';
$string['extendsession'] = 'Uzatılan oturum';
$string['failedloginattempts'] = 'Son girişinizden beri {$a->attempts} hatalı giriş yapıldı';
$string['failedtaskbody'] = '<p>Merhaba {$a->firstname},</p>
<p>Görev <b>{$a->taskname}</b> birden çok kez başarısız oldu ve kontrol etmeniz gerektiriyor.</p>
<p><a href="{$a->link}">Görevi inceleyin</a></p>';
$string['failedtaskcontexturlname'] = 'Durum raporu';
$string['failedtasksubject'] = 'Görev başarısız oldu: {$a}';
$string['favourites'] = 'Yıldızlı';
$string['feedback'] = 'Geri bildirim';
$string['file'] = 'Dosya';
$string['fileexists'] = '{$a} adında bir dosya zaten var';
$string['filemissing'] = '{$a} eksik';
$string['filereaderror'] = '\'{$a}\' dosyası okunamıyor. Lütfen bunun gerçekten bir dosya yada klasör olduğunu kontrol edin.';
$string['files'] = 'Dosyalar';
$string['filesanduploads'] = 'Dosyalar ve yüklenenler';
$string['filesfolders'] = 'Dosyalar/klasörler';
$string['fileuploadwithcontent'] = 'Yüklenecek dosyalar içerik parametresi içermemelidir';
$string['filloutallfields'] = 'Bu formdaki tüm alanları doldurunuz';
$string['filter'] = 'Filtre';
$string['filteroption'] = '{$a-> criteria}: {$a-> value}';
$string['filterrowlegend'] = '{$a} süz';
$string['filters'] = 'Filtreler';
$string['filtersetmatchdescription'] = 'Birden çok filtre nasıl birleştirilmelidir?';
$string['filtertype'] = 'Filitre türü';
$string['findmorecourses'] = 'Daha fazla kurs bul...';
$string['first'] = 'İlk';
$string['firstaccess'] = 'İlk erişim';
$string['firstname'] = 'Adı';
$string['firstnamephonetic'] = 'Adı - fonetik';
$string['firstpage'] = 'İlk sayfa';
$string['firstsiteaccess'] = 'Siteye ilk erişim';
$string['firsttime'] = 'Buraya ilk defa mı geliyorsunuz?';
$string['folder'] = 'Klasör';
$string['folderclosed'] = 'Kapalı klasör';
$string['folderopened'] = 'Açık klasör';
$string['followingoptional'] = 'Aşağıdakiler isteğe bağlıdır';
$string['followingrequired'] = 'Aşağıdakiler zorunludur';
$string['for'] = 'İçin';
$string['force'] = 'Zorunlu kıl';
$string['forcelanguage'] = 'Dili zorunlu kıl';
$string['forceno'] = 'Zorunlu kılma';
$string['forcepasswordchange'] = 'Şifre değişimini zorunlu tut';
$string['forcepasswordchange_help'] = 'Eğer bu onay kutusu işaretli ise, kullanıcı bir sonraki oturumda kendi şifresini değiştirmesi ile ilgili bir uyarı alır.';
$string['forcepasswordchangecheckfull'] = '{$a} şifre değişimini zorunlu  yapmak istediğinizden emin misiniz?';
$string['forcepasswordchangenot'] = 'Şifrenin {$a} olması dayatılamadı';
$string['forcepasswordchangenotice'] = 'Devam etmek için şifrenizi değiştirmelisiniz.';
$string['forcepasswordresetfailurenotice'] = 'Mevcut şifreniz artık ayarlanan şifre politikasını geçemez. Lütfen yardım için Moodle yöneticinizle iletişime geçin.    {$a}';
$string['forcepasswordresetnotice'] = 'Mevcut şifreniz artık ayarlanan şifre politikasını geçmiyor, oturum açmak için şifrenizi sıfırlamalısınız.  {$a}';
$string['forcetheme'] = 'Temayı zorunlu tut';
$string['forgotaccount'] = 'Şifrenizi mi unuttunuz?';
$string['forgotten'] = 'Kullanıcı adı veya şifrenizi mi unuttunuz?';
$string['forgottenduplicate'] = 'E-posta adresi birkaç hesap tarafından kullanıldığından bunun yerine kullanıcı adını girin';
$string['forgotteninvalidurl'] = 'Geçersiz şifre sıfırlama URL\'si';
$string['format'] = 'Biçim';
$string['formathtml'] = 'HTML biçimi';
$string['formatmarkdown'] = 'Markdown biçimi';
$string['formatplain'] = 'Düzyazı biçimi';
$string['formattext'] = 'Moodle otomatik-biçim';
$string['forumpreferences'] = 'Forum tercihleri';
$string['framesetinfo'] = 'Bu çerçeve kümesi belgesinin içeriği:';
$string['fromdate'] = 'Başlangıç';
$string['fromsender'] = 'Başlangıç';
$string['frontpagecategorycombo'] = 'Açılır liste';
$string['frontpagecategorynames'] = 'Kategorilerin listesi';
$string['frontpagecourselist'] = 'Kurs listesi';
$string['frontpagecoursesearch'] = 'Kurs arama kutusu';
$string['frontpagedescription'] = 'Ana sayfa özeti';
$string['frontpagedescriptionhelp'] = 'Bu özet anasayfada, ders/site özet bloğu kullanılarak  görüntülenebilir.';
$string['frontpageenrolledcourselist'] = 'Kaydolunan kurslar';
$string['frontpageformat'] = 'Site anasayfa biçimi';
$string['frontpageformatloggedin'] = 'Giriş yapıldığında anasayfa biçimi';
$string['frontpagenews'] = 'Duyurular';
$string['frontpagesettings'] = 'Site anasayfa ayarları';
$string['fulllistofcourses'] = 'Tüm kurslar';
$string['fullname'] = 'Tam adı';
$string['fullnamecourse'] = 'Kursun tam adı';
$string['fullnamecourse_help'] = 'Kurslarım bölümünde ve Ana sayfadaki mevcut kurslar listesinde görüntülenen ad.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Kullanıcının tam adı';
$string['fullprofile'] = 'Tam profil';
$string['fullsitename'] = 'Sitenin tam adı';
$string['functiondisabled'] = 'Bu işlevsellik şu anda etkin değil';
$string['general'] = 'Genel';
$string['geolocation'] = 'enlem - boylam';
$string['gettheselogs'] = 'Bu kayıtları getir';
$string['go'] = 'Git';
$string['gobacktosite'] = 'Siteye geri dön';
$string['gpl'] = 'Telif Hakkı (C) 1999\'dan itibaren Martin Dougiamas (http://moodle.com)

Bu program ücretsiz bir yazılımdır. Bu yazılımı, Free Software Foundation tarafından yayınlanan GNU Genel Kamu Lisansı (GPL) 2 veya (isteğinize bağlı olarak) herhangi bir sürümü ile düzenleyebilir veya dağıtabilirsiniz.

Bu program, HİÇBİR GARANTİSİ OLMAKSIZIN, ima şeklinde bile olsa  PAZARLANABİLİRLİK ya da BELİRLİ BİR AMAÇ İÇİN UYGUNLUK garantisi verilmeden, yararlı olması umularak dağıtılmaktadır.

Bütün ayrıntılar için Moodle Lisans sayfasına bakınız:
https://moodledev.io/general/license';
$string['gpl3'] = 'Telif Hakkı (C) 1999\'dan itibaren Martin Dougiamas (https://moodle.com)

Bu program özgür bir yazılımdır: Özgür Yazılım Vakfı tarafından yayınlanan GNU Genel Kamu Lisansı koşulları altında, Lisansın 3. sürümü veya (sizin tercihinize bağlı olarak) daha sonraki herhangi bir sürümü altında yeniden dağıtabilir ve/veya değiştirebilirsiniz.

Bu program, yararlı olacağı umuduyla, ancak HERHANGİ BİR GARANTİ OLMAKSIZIN; hatta ZIMNİ TİCARİ ELVERİŞLİLİK veya BELİRLİ BİR AMACA UYGUNLUK garantisi olmaksızın dağıtılmaktadır.

Tüm ayrıntılar için Moodle Lisans bilgileri sayfasına bakın: https://moodledev.io/general/license';
$string['gpllicense'] = 'GPL lisansı';
$string['gradenoun'] = 'Not';
$string['grades'] = 'Notlar';
$string['gradeverb'] = 'Not';
$string['gravatarenabled'] = 'Bu sitede <a href="https://www.gravatar.com/">Gravatar</a> etkinleştirilmiştir. Profil resimi yüklemezseniz, Moodle sizin için Gravatar\'dan bir profil resimi yüklemeye çalışır.';
$string['group'] = 'Grup';
$string['groupadd'] = 'Yeni grup ekle';
$string['groupaddusers'] = 'Seçili olanı gruba ekle';
$string['groupfor'] = 'grup için';
$string['groupinfo'] = 'Seçili grup hakkında bilgi';
$string['groupinfoedit'] = 'Grup ayarlarını düzenle';
$string['groupinfomembers'] = 'Seçili üyeler hakkında bilgi';
$string['groupinfopeople'] = 'Seçili kişiler hakkında bilgi';
$string['groupmembers'] = 'Grup üyeleri';
$string['groupmemberssee'] = 'Grup üyelerine bak';
$string['groupmembersselected'] = 'Seçili grubun üyeleri';
$string['groupmode'] = 'Grup modu';
$string['groupmodeforce'] = 'Grup modunu zorunlu tut';
$string['groupmy'] = 'Grubum';
$string['groupnonmembers'] = 'Grupta olmayan kişiler';
$string['groupnotamember'] = 'Üzgünüz, bu grubun üyesi değilsiniz';
$string['grouprandomassign'] = 'Tümünü gruplara rastgele ata';
$string['groupremove'] = 'Seçili grubu kaldır';
$string['groupremovemembers'] = 'Seçili üyeleri kaldır';
$string['groups'] = 'Gruplar';
$string['groupsnone'] = 'Grup yok';
$string['groupsseparate'] = 'Ayrı gruplar';
$string['groupsvisible'] = 'Görünür gruplar';
$string['guest'] = 'Misafir';
$string['guestdescription'] = 'Misafirler en az ayrıcalığa sahiptir ve genellikle hiçbir yere hiçbir şey yazamazlar.';
$string['guestskey'] = 'Kayıt anahtarı olan misafirlere izin ver';
$string['guestsno'] = 'Misafir girmesini yasakla';
$string['guestsnotallowed'] = 'Özür dileriz, \'{$a}\' misafirlerin girmesine izin vermemekte.';
$string['guestsyes'] = 'Kayıt anahtarı olmayan misafirlere izin ver';
$string['guestuser'] = 'Misafir kullanıcı';
$string['guestuserinfo'] = 'Bu özel bir kullanıcıdır ve bazı kurslara sadece-okuma modunda girebilir.';
$string['help'] = 'Yardım';
$string['helpprefix2'] = '{$a} ile yardım';
$string['helpwiththis'] = 'Bu ile yardım';
$string['hiddenassign'] = 'Gizli atama';
$string['hiddenfromstudents'] = 'Öğrencilerden gizli';
$string['hiddenoncoursepage'] = 'Kullanılabilir ancak kurs sayfasında gösterilmez';
$string['hiddensections'] = 'Gizli bölümler';
$string['hiddensections_help'] = 'Gizli bölümler öğrencilere kurs sayfasında \'mevcut değil\' olarak gösterilebilir veya tamamen gizli tutulabilir.
.';
$string['hiddensectionscollapsed'] = 'Gizli bölümler mevcut değil olarak görünsün';
$string['hiddensectionsinvisible'] = 'Gizli bölümler tamamen görünmez olsun';
$string['hiddenwithbrackets'] = '(Gizli)';
$string['hide'] = 'Gizle';
$string['hideadvancedsettings'] = 'Gelişmiş ayarları gizle';
$string['hidecategory'] = 'Kategori gizlensin mi?';
$string['hidechartdata'] = 'Grafik verilerini gizle';
$string['hidefromstudents'] = 'Kurs sayfasında gizle';
$string['hideoncoursepage'] = 'Kullanılabilir yap ancak kurs sayfasında gösterme';
$string['hidepopoverwindow'] = 'Açılır pencereyi gizle';
$string['hidesection'] = '{$a} bölümünü gizle';
$string['hidesettings'] = 'Ayarları gizle';
$string['hideshowblocks'] = 'Blokları gizle/göster';
$string['highlight'] = 'Vurgula';
$string['highlighted'] = 'Vurgulanmış';
$string['highlightoff'] = 'Vurgulamayı temizle';
$string['hits'] = 'Tıklamalar';
$string['hitsoncourse'] = '{$a->username} tarafından {$a->coursename} tıklamaları';
$string['hitsoncoursetoday'] = 'Bugünün {$a->username} tarafindan {$a->coursename} tıklamaları';
$string['home'] = 'Ana sayfa';
$string['homeheader'] = 'Ana sayfa menüsü';
$string['hour'] = 'saat';
$string['hours'] = 'saat';
$string['howtomakethemes'] = 'Nasıl yeni tema yapılır';
$string['htmleditor'] = 'HTML editörünü kullan';
$string['htmleditoravailable'] = 'HTML editörü kullanılabilir';
$string['htmleditordisabled'] = 'Kullanıcı profilinizdeki HTML editörünü etkinleştirmediniz';
$string['htmleditordisabledadmin'] = 'Yönetici bu sitedeki HTML editörünü etkinleştirmemiş';
$string['htmleditordisabledbrowser'] = 'Tarayıcınız uyumlu olmadığı için HTML editörüne erişilemez';
$string['htmlfilesonly'] = 'Sadece HTML türündeki dosyalar';
$string['htmlformat'] = 'Göze hoş HTML biçimi';
$string['icon'] = 'Simge';
$string['idnumber'] = 'ID numarası';
$string['idnumbercourse'] = 'Kurs kimlik numarası';
$string['idnumbercourse_help'] = 'Yalnızca kursu harici sistemlere bağlamak için kullanılır. Resmi bir kurs kimliğiniz yoksa boş bırakın.';
$string['idnumbercoursecategory'] = 'Kategori ID numarası';
$string['idnumbercoursecategory_help'] = 'Kurs kategorisi ID numarası yalnızca harici sistemlerde kategori eşleştirme yaparken kullanılır ve sitede herhangi bir yerde görüntülenmez. Kategorinin resmi kod adı varsa girilebilir, aksi halde bu alan boş bırakılabilir.';
$string['idnumbergroup'] = 'Grup ID numarası';
$string['idnumbergroup_help'] = 'Grup ID numarası yalnızca harici sistemlerde grup eşleştirme yaparken kullanılır ve sitede herhangi bir yerde görüntülenmez. Grup için resmi kod adı varsa girilebilir, aksi halde bu alan boş bırakılabilir.';
$string['idnumbergrouping'] = 'Gruplama ID numarası';
$string['idnumbergrouping_help'] = 'Gruplama kimlik numarası sadece dış sistemlere karşı gruplandırmada kullanılır ve sayfanın hiçbir yerinde görüntülenmez. Gruplamanın resmi bir kodu varsa girilebilir, aksi durumda bu alan boş bırakılabilir.';
$string['idnumbermod'] = 'ID numarası';
$string['idnumbermod_help'] = 'Kimlik numarası ayarlamak, not hesaplama veya özel raporlama gibi amaçlar için etkinliği veya kaynağı tanımlamanın bir yolunu sağlar.  Aksi takdirde alan boş bırakılabilir.
Not verilebilen etkinlikler için kimlik numarası not defterinde de ayarlanabilir, ancak yalnızca etkinlik ayarları sayfasında düzenlenebilir.';
$string['idnumbertaken'] = 'Bu ID numarası önceden alınmış';
$string['imagealt'] = 'Resim açıklaması';
$string['import'] = 'İçeri aktar';
$string['importdata'] = 'Kurs verisini içeri aktar';
$string['importdataexported'] = '\'Kaynak\' dersten veriler başarıyla alındı.<br />Hedef derse verileri aktarmak için devam edin.';
$string['importdatafinished'] = 'İçeri aktarma tamamlandı! Kursunuza devam edin';
$string['importdatafrom'] = 'Verinin alınacağı ders:';
$string['importinfo'] = 'Etkinlikler, bloklar veya takvim etkinlikleri gibi diğer kurslardan öğeleri içe aktarın. Hiçbir kullanıcı verisi içe aktarılmayacaktır.';
$string['inactive'] = 'Etkin değil';
$string['include'] = 'Dahil et';
$string['includeallusers'] = 'Tüm kullanıcıları içersin';
$string['includecoursefiles'] = 'Kurs dosyalarını dahil et';
$string['includecourseusers'] = 'Kurs kullanıcılarını dahil et';
$string['included'] = 'Dahil edildi';
$string['includelogentries'] = 'Kayıt girdilerini içersin';
$string['includemodules'] = 'Modülleri dahil et';
$string['includemoduleuserdata'] = 'Modül kullanıcı verisini dahil et';
$string['includeneededusers'] = 'Gerekli kullanıcıları dahil et';
$string['includenoneusers'] = 'Hiçbir kullanıcıyı dahil etme';
$string['includeroleassignments'] = 'Rol atamalarını dahil et';
$string['includesitefiles'] = 'Bu kursda kullanılan site dosyalarını dahil et';
$string['includesubcategories'] = 'Alt kategorileri dahil et';
$string['includeuserfiles'] = 'Kullanıcı dosyalarını dahil et';
$string['increasesections'] = 'Bölümlerin sayısını artır';
$string['indicator:accessesafterend'] = 'Kurs bitiş tarihinden sonra erişildi';
$string['indicator:accessesafterend_help'] = 'Bu gösterge, öğrencinin kursa kurs bitiş tarihinden sonra erişip erişmediğini gösterir.';
$string['indicator:accessesbeforestart'] = 'Kursa başlangıç tarihinden önce erişildi';
$string['indicator:accessesbeforestart_help'] = 'Bu gösterge, öğrencinin derse başlama tarihinden önce erişip erişmediğini gösterir.';
$string['indicator:activitiesdue'] = 'Yapılması gerekenler';
$string['indicator:activitiesdue_help'] = 'Bu öğrencinin yapması gerekenler';
$string['indicator:anycourseaccess'] = 'Herhangi bir kurs erişimi';
$string['indicator:anycourseaccess_help'] = 'Bu gösterge, kullanıcının kayıtlı olduğu herhangi bir kursa erişimi gösterir.';
$string['indicator:anywrite'] = 'Herhangi bir yazma etkinliği';
$string['indicator:anywrite_help'] = 'Bu gösterge, öğrenci tarafından yapılan herhangi bir yazma (gönderme) eylemini temsil eder.';
$string['indicator:anywriteincourse'] = 'Kursdaki herhangi bir yazma etkinliği';
$string['indicator:anywriteincourse_help'] = 'Bu gösterge, herhangi bir kurs etkinliğinde öğrenci tarafından gerçekleştirilen herhangi bir yazma (gönderme) eylemini temsil eder.';
$string['indicator:completeduserprofile'] = 'Kullanıcı profili tamamlandı';
$string['indicator:completeduserprofile_help'] = 'Bu gösterge, öğrencinin kullanıcı profilini tamamladığını gösterir.';
$string['indicator:completeduserprofiledef'] = 'Kullanıcı profili tamamlandı';
$string['indicator:completeduserprofiledef_help'] = 'Site politikaları kabul edildi ve kullanıcı aşağıdaki alanları doldurdu: Kurum, Departman, Adres, Şehir, Ülke, URL.';
$string['indicator:completionenabled'] = 'Tamamlama takibi etkinleştirildi';
$string['indicator:completionenabled_help'] = 'Bu gösterge, bu kurs için tamamlama izlemenin etkinleştirildiğini gösterir.';
$string['indicator:nostudent'] = 'Öğrenci kayıtları';
$string['indicator:nostudent_help'] = 'Bu gösterge, dersteki öğrencilerin uygunluğunu yansıtır.';
$string['indicator:noteacher'] = 'Öğretmen uygunluğu';
$string['indicator:noteacher_help'] = 'Bu gösterge, dersteki öğretmenlerin uygunluğunu yansıtır.';
$string['indicator:potentialcognitive'] = 'Kursun potansiyel bilişsel derinliği';
$string['indicator:potentialcognitive_help'] = 'Bu gösterge, kurs etkinliklerine katılan bir öğrencinin ulaşabileceği potansiyel bilişsel derinliğe dayanmaktadır.';
$string['indicator:potentialcognitivedef'] = 'Kursun potansiyel bilişsel derinliği';
$string['indicator:potentialcognitivedef_help'] = 'Kursun " derinlikli" bilişsel katılım sunma derecesi, örneğin geri bildirim için çalışma sunma, başkalarının çalışmalarını gözden geçirme fırsatı ve çalışmayı gözden geçirme ve yeniden sunma fırsatı.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Kursun potansiyel sosyal genişliği';
$string['indicator:potentialsocial_help'] = 'Bu gösterge, kurs etkinliklerine katılan öğrencinin ulaşabileceği potansiyel sosyal genişliğe dayanmaktadır.';
$string['indicator:potentialsocialdef'] = 'Kursun potansiyel sosyal genişliği';
$string['indicator:potentialsocialdef_help'] = 'Kursun "geniş" sosyal katılım, diğer katılımcılarla ve sınıfın ötesinde uygulama topluluğu ile etkileşime girme derecesi.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Aksiyon miktarını oku';
$string['indicator:readactions_help'] = 'Bu gösterge, öğrenci tarafından gerçekleştirilen okuma (görüntüleme) eylemlerinin sayısını temsil eder.';
$string['indicator:userforumstracking'] = 'Öğrenci forumları takip ediyor';
$string['indicator:userforumstracking_help'] = 'Bu gösterge, öğrencinin forumlarda izlemenin açık olup olmadığını gösterir.';
$string['info'] = 'Bilgi';
$string['inprogress'] = 'Geliştiriliyor';
$string['insertcontentbefore'] = '\'{$a->activityname}\' öncesine içerik ekleyin';
$string['insertresourceoractivitybefore'] = '\'{$a->activityname}\'den önce bir etkinlik veya kaynak ekleyin';
$string['institution'] = 'Kurum';
$string['instudentview'] = 'öğrencinin bakış açısından';
$string['interests'] = 'İlgi alanları';
$string['interestslist'] = 'İlgi alanları listesi';
$string['interestslist_help'] = 'İlgi alanlarınızı tek tek, virgülle ayrılmış şekilde yazın; ilgi alanlarınız, profil sayfanızda etiket olarak görüntülenecektir.';
$string['invalidemail'] = 'Geçersiz e-posta adresi';
$string['invalidlogin'] = 'Hatalı giriş, lütfen tekrar deneyin';
$string['invalidtaskclassname'] = 'Geçersiz görev sınıfı {$a}';
$string['invalidtaskid'] = 'Geçersiz görev kimliği';
$string['invalidusername'] = 'Kullanıcı adı yalnızca alfanumerik küçük harf (harf ve sayı), alt çizgi (_), tire (-), nokta (.) veya (@) sembolü içerebilir.';
$string['invalidusernameupload'] = 'Geçersiz kullanıcı adı';
$string['ip_address'] = 'IP adresi';
$string['jump'] = 'Geç';
$string['jumpto'] = 'Geçiş yap...';
$string['keep'] = 'Sakla';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Dil yönü soldan sağa';
$string['langrtl'] = 'Dil yönü sağdan sola';
$string['language'] = 'Dil';
$string['languagegood'] = 'Bu dil paketi güncel.';
$string['languageselector'] = 'Dil seçici';
$string['last'] = 'En son';
$string['lastaccess'] = 'En son erişim';
$string['lastcourseaccess'] = 'Kursa en son erişim';
$string['lastedited'] = 'En son düzenlenme';
$string['lastip'] = 'En son IP adresi';
$string['lastlogin'] = 'En son giriş';
$string['lastmodified'] = 'En son değiştirme';
$string['lastname'] = 'Soyadı';
$string['lastnamephonetic'] = 'Soyadı - fonetik';
$string['lastpage'] = 'Son sayfa';
$string['lastsiteaccess'] = 'Siteye son erişim';
$string['lastyear'] = 'Geçen yıl';
$string['latestlanguagepack'] = 'En güncel dil paketini moodle.org adresinden indir';
$string['layouttable'] = 'Yerleşim tablosu';
$string['leavetokeep'] = 'Şifreyi değiştirmek istemiyorsanız boş bırakın';
$string['legacylogginginuse'] = 'Bu site şu anda geçerli günlük deposuna yazma özelliğine sahip. Bu günlük kaydına yazma önerisi kullanımdan kaldırıldı. Lütfen "standart" veya "harici" gibi desteklenen bir günlük deposuna yazın.';
$string['legacythemeinuse'] = 'Tarayıcınız çok eski olduğu için site size şu anda uyumluluk modunda görüntüleniyor.';
$string['license'] = 'Lisans';
$string['licenses'] = 'Lisanslar';
$string['liketologin'] = 'Şimdi gerçek kullanıcı hesabı ile girmek ister misiniz?';
$string['list'] = 'Listele';
$string['listfiles'] = '{$a} içindeki dosyaların listesi';
$string['listofallpeople'] = 'Tüm kullanıcıların listesi';
$string['listofcourses'] = 'Kurs listeleri';
$string['loading'] = 'Yükleniyor';
$string['loadinghelp'] = 'Yükleniyor...';
$string['local'] = 'Yerel';
$string['localplugins'] = 'Yerel eklentiler';
$string['localpluginsmanage'] = 'Yerel eklentileri yönet';
$string['location'] = 'Konum';
$string['locktimeout'] = 'Bir kilit için beklenirken işlem zaman aşımına uğradı.';
$string['log_excel_date_format'] = 'd mmmm yyyy h:mm';
$string['loggedinas'] = '{$a} olarak giriş yaptınız';
$string['loggedinasguest'] = 'Şu anda misafir erişimini kullanıyorsunuz';
$string['loggedinnot'] = 'Giriş yapmadınız.';
$string['login'] = 'Giriş yap';
$string['login_failure_logs'] = 'Giriş hatası kayıtları';
$string['loginactivity'] = 'Giriş etkinliği';
$string['loginagain'] = 'Yeniden giriş yapınız';
$string['loginalready'] = 'Zaten giriş yaptınız';
$string['loginas'] = 'Şu olarak giriş yap;';
$string['loginaspasswordexplain'] = '<p>Bu özelliği kullanmak için "farklı şifreyle giriş" anahtarını girmelisiniz.<br />Bilmiyorsanız, sunucu yöneticisine sorabilirsiniz.</p>';
$string['loginguest'] = 'Misafir olarak giriş yap';
$string['loginsite'] = 'Siteye giriş yap';
$string['loginsteps'] = 'Bu siteye tam erişim için önce bir hesap oluşturmalısınız.';
$string['loginstepsnone'] = '<p>Merhaba!</p>
<p>Kursları tam erişim için yeni bir hesap oluşturmanız gerekiyor.</p><p>Tek yapmanız gereken kullanıcı adınızı ve şifrenizi oluşturarak bu sayfadaki formdan giriş yapmak!</p>
<p>Seçtiğiniz kullanıcı adı başkası tarafından alınmışsa farklı bir kullanıcı adı kullanmayı denemelisiniz.</p>';
$string['loginto'] = '{$a} sayfasına giriş yap';
$string['logoof'] = '{$a} Logosu';
$string['logout'] = 'Çıkış yap';
$string['logoutconfirm'] = 'Gerçekten çıkış yapmak istiyor musunuz?';
$string['logs'] = 'Kayıtlar';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">dahası</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">dahası</a> ]';
$string['lookback'] = 'Geçmişe bak';
$string['mailadmins'] = 'Yöneticileri bilgilendir';
$string['mailstudents'] = 'Öğrencileri bilgilendir';
$string['mailteachers'] = 'Öğretmenleri bilgilendir';
$string['maincoursepage'] = 'Kurs ana sayfası';
$string['makeafolder'] = 'Klasör oluştur';
$string['makeavailable'] = 'Kullanılabilir yap';
$string['makeeditable'] = '\'{$a}\' dosyasını sunucu programı yoluyla (örn. apache) değiştirilebilir yaparsanız, bu dosyayı doğrudan bu sayfada düzenleyebilirsiniz';
$string['makethismyhome'] = 'Bu sayfayı varsayılan ana sayfam yap';
$string['makeunavailable'] = 'Kullanılamaz yap';
$string['manageblocks'] = 'Bloklar';
$string['managecategories'] = 'Kurs kateiorilerini yönet';
$string['managecategorythis'] = 'Bu kategoriyi yönet';
$string['managecombined'] = 'Kurs kategorileri ve kursları yönet';
$string['managecontentbanktypes'] = 'İçerik türlerini yönetin';
$string['managecourses'] = 'Kursları yönet';
$string['managedatabase'] = 'Veritabanı';
$string['managedataformats'] = 'Veri formatlarını yönet';
$string['manageeditorfiles'] = 'Editör tarafından kullanılan dosyaları yönet';
$string['managefilters'] = 'Filtreler';
$string['managemodules'] = 'Modüller';
$string['manageroles'] = 'Roller ve İzinler';
$string['markallread'] = 'Tümünü okunmuş olarak işaretle';
$string['match'] = 'Eşleşme';
$string['matchingsearchandrole'] = '\'{$a->search}\' ve {$a->role} eşleşiyor';
$string['matchofthefollowing'] = 'aşağıdakilerden:';
$string['maxareabytesreached'] = 'Dosya (veya dosyaların toplam boyutu), bu alanda kalan disk kapasitesinden daha büyük.';
$string['maxfilesize'] = 'Yeni dosyalar için maksimum boyut: {$a}';
$string['maxfilesreached'] = 'Bu öğeye en fazla {$a} dosya ekleyebilirsiniz';
$string['maximumchars'] = 'En çok {$a} karakter';
$string['maximumgrade'] = 'En yüksek not';
$string['maximumgradex'] = 'En yüksek not: {$a}';
$string['maximumshort'] = 'Maksimum';
$string['maximumupload'] = 'En fazla dosya yükleme boyutu';
$string['maximumupload_help'] = 'Kurslara yüklenen en fazla dosya boyutunu tanımlar. Ayrıca her etkinlik için en büyük dosya yükleme boyutunu kısıtlayabilirsiniz.';
$string['maxlengthreached'] = '{$a} karakter sınırına ulaşıldı.';
$string['maxnumberweeks'] = 'Maksimum bölüm sayısı';
$string['maxnumberweeks_desc'] = 'Bölümlerin açılır menü sayısı için en büyük değer (sadece belirli kurs biçimleri için geçerlidir).';
$string['maxnumcoursesincombo'] = '<a href="{$a->link}">{$a->numberofcourses} kurslara</a> göz at.';
$string['maxsectionslimit'] = 'Bu kurs için izin verilen maksimum bölüm sayısını ({$a}) aşacağından yeni bölüm oluşturulamıyor.';
$string['maxsize'] = 'En büyük boyut: {$a}';
$string['maxsizeandareasize'] = 'Yeni dosyalar için en büyük boyut: {$a->size}, genel sınır: {$a->areasize}';
$string['maxsizeandattachments'] = 'En büyük dosya boyutu: {$a->size}, en fazla ek dosya sayısı: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maksimum dosya boyutu: {$a->size}, maksimum dosya sayısı: {$a->attachments}, maksimum toplam boyut: {$a->areasize}';
$string['memberincourse'] = 'Kursdaki kişiler';
$string['menu'] = 'Menü';
$string['message'] = 'Mesaj';
$string['messagebody'] = 'İleti içeriği';
$string['messagedselectedusers'] = 'Seçili kullanıcılara ileti gönderildi ve alıcı listesi temizlendi.';
$string['messagedselectedusersfailed'] = 'Seçili kullanıcılara ileti gönderilirken bazı şeyler yanlış gitti. Bazıları e-postayı almış olabilir.';
$string['messageprovider:asyncbackupnotification'] = 'Eşzamansız yedekleme / geri yükleme bildirimleri';
$string['messageprovider:availableupdate'] = 'Mevcut güncelleme bildirimleri';
$string['messageprovider:backup'] = 'Yedekleme bildirimleri';
$string['messageprovider:badgecreatornotice'] = 'Rozet oluşturucu bildirimleri';
$string['messageprovider:badgerecipientnotice'] = 'Rozet alıcı bildirimleri';
$string['messageprovider:competencyplancomment'] = 'Bir öğrenme planında yayınlanan yorum';
$string['messageprovider:competencyusercompcomment'] = 'Bir yetkinlikte yayınlanan yorum';
$string['messageprovider:coursecompleted'] = 'Kurs tamamlandı';
$string['messageprovider:coursecontentupdated'] = 'Kurs içeriği değişiklikleri';
$string['messageprovider:courserequestapproved'] = 'Kurs oluşturma isteği onay bildirimi';
$string['messageprovider:courserequested'] = 'Kurs oluşturma isteği bildirimi';
$string['messageprovider:courserequestrejected'] = 'Kurs oluşturma isteği red bildirimi';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Yeni kurs kayıtları için hoş geldiniz mesajı';
$string['messageprovider:errors'] = 'Sitedeki önemli hatalar';
$string['messageprovider:errors_help'] = 'Yöneticinin bilmesi gereken önemli hatalar var.';
$string['messageprovider:failedtaskmaxdelay'] = 'Görev maksimum başarısızlık gecikmesine ulaşır';
$string['messageprovider:gradenotifications'] = 'Not bildirimleri';
$string['messageprovider:infected'] = 'Antivirüs hatası bildirimleri.';
$string['messageprovider:insights'] = 'Tahmin modelleri tarafından oluşturulan bilgiler';
$string['messageprovider:instantmessage'] = 'Kullanıcılar arasındaki kişisel mesajları';
$string['messageprovider:instantmessage_help'] = 'Bu bölüm, sitede başka kullanıcılar tarafından doğrudan size gönderilen mesajlara ne olacağını yapılandırır.';
$string['messageprovider:messagecontactrequests'] = 'İleti kişisi bildirim istekleri';
$string['messageprovider:newlogin'] = 'Yeni giriş bildirimleri';
$string['messageprovider:notices'] = 'Küçük sorunlar hakkındaki bilgilendirmeler';
$string['messageprovider:notices_help'] = 'Yöneticinin görmeyi isteyebileceği uyarılar.';
$string['messageprovider:reportbuilderschedule'] = 'Özel rapor oluşturucu programları';
$string['messageselect'] = 'Bu kullanıcıyı bir mesaj alıcısı olarak seç';
$string['messageselectadd'] = 'Mesaj gönder';
$string['middlename'] = 'İkinci ad';
$string['migratinggrades'] = 'Notlar çevriliyor';
$string['min'] = 'dk';
$string['mins'] = 'dk';
$string['minute'] = 'dakika';
$string['minutes'] = 'dakika';
$string['miscellaneous'] = 'Çeşitli';
$string['missingcategory'] = 'Bir kategori seçmelisiniz';
$string['missingdescription'] = 'Açıklama eksik';
$string['missingemail'] = 'E-posta adresi eksik';
$string['missingfirstname'] = 'Adı eksik';
$string['missingfromdisk'] = 'Dosya diskte yok';
$string['missingfullname'] = 'Tam adı eksik';
$string['missinglastname'] = 'Soyadı eksik';
$string['missingname'] = 'Ad eksik';
$string['missingnewpassword'] = 'Yeni şifre eksik';
$string['missingpassword'] = 'Şifre eksik';
$string['missingrecaptchachallengefield'] = 'reCAPTCHA sorgulaması başarısız oldu, tekrar deneyin.';
$string['missingreqreason'] = 'Sebep eksik';
$string['missingshortname'] = 'Kısa ad eksik';
$string['missingshortsitename'] = 'Kısa site adı eksik';
$string['missingsitedescription'] = 'Site açıklaması eksik';
$string['missingsitename'] = 'Site adı eksik';
$string['missingstrings'] = 'Çevrilmeyen cümleleri veya ifadeleri kontrol et';
$string['missingstudent'] = 'Bir şeyler seçmelisiniz';
$string['missingsummary'] = 'Özet eksik';
$string['missingteacher'] = 'Bir şeyler seçmelisiniz';
$string['missingurl'] = 'URL eksik';
$string['missingusername'] = 'Kullanıcı adı eksik';
$string['moddoesnotsupporttype'] = '{$a->modname} modülü {$a->type} türündeki yüklemeleri desteklemiyor';
$string['modhide'] = 'Gizle';
$string['modified'] = 'Değiştirildi';
$string['modshow'] = 'Göster';
$string['moduleintro'] = 'Açıklama';
$string['modulesetup'] = 'Eklenti tabloları ayarlanıyor';
$string['modulesuccess'] = '{$a} tabloları doğru bir şekilde kuruldu';
$string['modulesused'] = 'Kullanılan modüller';
$string['modvisible'] = 'Uygunluk';
$string['modvisible_help'] = '* Kurs sayfasında göster: Öğrenciler tarafından kullanılabilir (ayarlanabilecek erişim kısıtlamalarına tabidir).
* Kurs sayfasında gizle: Öğrenciler tarafından kullanılamaz.';
$string['modvisiblehiddensection'] = 'Uygunluk';
$string['modvisiblehiddensection_help'] = '* Kurs sayfasında gizle: Öğrenciler için mevcut değildir.
* Kullanılabilir hale getirin ancak kurs sayfasında göstermeyin: Bir bağlantı sağlarsanız öğrenciler için kullanılabilir. Etkinlikler not defterinde ve diğer raporlarda görünmeye devam eder.';
$string['modvisiblewithstealth'] = 'Uygunluk';
$string['modvisiblewithstealth_help'] = '* Kurs sayfasında göster: Öğrenciler tarafından kullanılabilir (ayarlanabilecek erişim kısıtlamalarına tabidir).
* Kurs sayfasında gizle: Öğrenciler için mevcut değil.
* Kullanılabilir yap ancak kurs sayfasında gösterme: Bir bağlantı sağlarsanız öğrenciler tarafından kullanılabilir. Etkinlikler not defterinde ve diğer raporlarda görünmeye devam edecektir.';
$string['month'] = 'Ay';
$string['months'] = 'Ay';
$string['moodledocs'] = 'Moodle Dökümantasyon';
$string['moodledocslink'] = 'Bu sayfaya ilişkin belgeler';
$string['moodlelogo'] = 'Moodle logosu';
$string['moodlenet:cannotconnecttoserver'] = 'MoodleNet sunucusuna bağlanılamıyor';
$string['moodlenet:columnname'] = 'İsimi';
$string['moodlenet:columnsenddate'] = 'Göneri tarihi';
$string['moodlenet:columnsendstatus'] = 'Gönderi durumu';
$string['moodlenet:columntype'] = 'Tür';
$string['moodlenet:configoauthservice'] = 'Söz konusu MoodleNet sitesinde paylaşımı etkinleştirmek için bir moodlenet OAuth 2 hizmeti seçin. Hizmet henüz mevcut değilse, <a href="{$a}">oluşturmanız < / a > gerekir.';
$string['moodlenet:deletedactivity'] = 'Silinmiş etkinlik';
$string['moodlenet:deletedcourse'] = 'Silinen kurs';
$string['moodlenet:eventresourceexported'] = 'Dışa aktarılan kaynak';
$string['moodlenet:gotomoodlenet'] = 'MoodleNet taslaklarına git';
$string['moodlenet:issuerisnotauthorized'] = 'MoodleNet yayıncısı yetkililendirilmemiş';
$string['moodlenet:issuerisnotenabled'] = 'MoodleNet yayıncısı yetkili değil';
$string['moodlenet:issuerisnotset'] = 'MoodleNet yayıncısı site yönetiminde ayarlanmamış';
$string['moodlenet:nosharedresources'] = 'Şu anda görüntülenecek paylaşılan kaynak bulunmamaktadır.';
$string['moodlenet:outboundsettings'] = 'MoodleNet giden ayarları';
$string['moodlenet:packagingandsending'] = 'Dosyanızı paketleyip moodlenet\'e gönderin...';
$string['moodlenet:sharefailtext'] = 'İçeriğinizi MoodleNet ile paylaşırken bir hata oluştu.Lütfen daha sonra tekrar deneyin.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'İçeriğinizi MoodleNet ile paylaşırken bir hata oluştu.<br > Lütfen daha sonra tekrar deneyin veya <a href="{$a}">site desteğine başvurun< / a>.';
$string['moodlenet:sharefailtitle'] = 'Bir şeyler ters gitti';
$string['moodlenet:sharefilesizelimitexceeded'] = 'Paylaşılan kaynağın boyutu ({$a->filesize} bayt) {$a->filesizelimit} bayt sınırını aşıyor.';
$string['moodlenet:sharenoticeactivity'] = 'Bu etkinlik MoodleNet ile kaynak olarak paylaşılmaktadır.';
$string['moodlenet:sharenoticecourse'] = 'Bu kurs MoodleNet ile kaynak olarak paylaşılmaktadır.';
$string['moodlenet:sharenoticepartial'] = 'Seçilen faaliyetler kaynak olarak MoodleNet ile paylaşılmaktadır.';
$string['moodlenet:sharenoticepartialactivitynumber'] = 'Kursa {$a} etkinlikleri dahil edilecektir.';
$string['moodlenet:shareprogress'] = 'MoodleNet paylaşım ilerlemesi';
$string['moodlenet:shareprogressinfo'] = 'Liste, MoodleNet\'te paylaştığınız kursları ve etkinlikleri gösterir.<br>MoodleNet\'te görüntülemek için kaynak adına tıklayın.';
$string['moodlenet:sharesuccesstext'] = 'Neredeyse bitti! İçeriğinizi paylaşmayı bitirmek için moodlenet\'teki taslaklarınızı ziyaret edin.';
$string['moodlenet:sharesuccesstitle'] = 'MoodleNet taslaklarına kaydedildi';
$string['moodlenet:sharetomoodlenet'] = 'MoodleNet ile paylaş';
$string['moodlenet:sharinglargefile'] = 'Büyük dosyalar biraz zaman alabilir.';
$string['moodlenet:sharingstatus'] = 'MoodleNet\'te Paylaşma';
$string['moodlenet:sharingto'] = 'Şuraya paylaşılıyor:';
$string['moodlerelease'] = 'Moodle sürümü';
$string['moodleservicesandsupport'] = 'Hizmetler ve destek';
$string['moodleversion'] = 'Moodle versiyonu';
$string['more'] = 'dahası';
$string['moreactions'] = 'Daha fazla eylem';
$string['morehelp'] = 'Daha fazla yardım';
$string['morehelpaboutmodule'] = '{$a} etkinliği hakkında daha fazla yardım';
$string['moreinfo'] = 'Daha fazla bilgi';
$string['moreinformation'] = 'Bu hata hakkında daha fazla bilgi';
$string['moremenu'] = 'Daha fazla';
$string['morenavigationlinks'] = 'Daha fazla...';
$string['moreprofileinfoneeded'] = 'Lütfen biraz daha kendinizden bahsediniz';
$string['mostrecently'] = 'en yakın';
$string['move'] = 'Taşı';
$string['movecategoriessuccess'] = '{$a->count} kategori \'{$a->to}\' kategorisi içine başarılı bir şekilde taşındı';
$string['movecategoriestotopsuccess'] = '{$a->count} kategori üst seviyeye başarılı bir şekilde taşındı';
$string['movecategorycontentto'] = 'Buraya taşı';
$string['movecategorysuccess'] = '\'{$a->moved}\' kategorisi \'{$a->to}\' kategorisi içine başarılı bir şekilde taşındı';
$string['movecategoryto'] = 'Kategoriyi şuraya taşı:';
$string['movecategorytotopsuccess'] = '\'{$a->moved}\' kategorisi üst seviyeye başarılı bir şekilde taşındı';
$string['movecontent'] = '{$a} \'yı taşı';
$string['movecontentafter'] = '"{$a}" dan sonra';
$string['movecontentstoanothercategory'] = 'İçeriği başka bir kategoriye taşı';
$string['movecontenttothetop'] = 'Listenin en üstü';
$string['movecoursemodule'] = 'Etkinliği taşı';
$string['movecoursesection'] = 'Bölümü taşı';
$string['movecourseto'] = 'Kursu şuraya taşı:';
$string['movedown'] = 'Aşağı taşı';
$string['movefilestohere'] = 'Dosyaları buraya taşı';
$string['movefull'] = '{$a} \'yı bu bölgeye taşı';
$string['movehere'] = 'Buraya taşı';
$string['moveitemdown'] = '{$a}\'yı aşağı taşı';
$string['moveitemup'] = '{$a}\'yı yukarı taşı';
$string['moveleft'] = 'Sola taşı';
$string['moveright'] = 'Sağa taşı';
$string['movesection'] = '{$a} bölümünü taşı';
$string['moveselectedcategoriesto'] = 'Seçili kategorileri şuraya taşı';
$string['moveselectedcoursesto'] = 'Seçili kursları şuraya taşı...';
$string['movetoanotherfolder'] = 'Başka klasöre taşı';
$string['moveup'] = 'Yukarı taşı';
$string['multipleitemsfound'] = '{$a} karakter sınırına ulaşıldı.';
$string['mustchangepassword'] = 'Yeni şifre şu ankinden farklı olmalı';
$string['mustconfirm'] = 'Hesabınızı onaylamanız gerekiyor';
$string['mycourses'] = 'Kurslarım';
$string['myfiles'] = 'Kişisel dosyalarım';
$string['myfilesmanage'] = 'Kişisel dosyalarımı yönet';
$string['myhome'] = 'Kontrol paneli';
$string['mymoodledashboard'] = 'Moodle kontrol panelim';
$string['myprofile'] = 'Profilim';
$string['name'] = 'Adı';
$string['namedfiletoolarge'] = '\'{$a->filename}\' dosyası çok büyük ve yüklenemiyor';
$string['nameforlink'] = 'Bu bağlantıyı ne şekilde adlandırmak istiyorsunuz?';
$string['nameforpage'] = 'Adı';
$string['navigation'] = 'Gezinme';
$string['needed'] = 'Gerekli';
$string['networkdropped'] = 'İnternet bağlantınızın zayıf ya da kopmuş olduğunu saptadık.<br />
Bağlantınız normale dönene kadar değişikliklerin kaydedilemeyebileceğini lütfen unutmayınız.';
$string['never'] = 'Hiçbir zaman';
$string['neverdeletelogs'] = 'Kayıtları hiçbir zaman silme';
$string['new'] = 'Yeni';
$string['newaccount'] = 'Yeni hesap';
$string['newactivityname'] = '{$a} etkinliği için yeni bir isim';
$string['newcourse'] = 'Yeni ders';
$string['newloginnotificationbodyfull'] = '<p>Merhaba {$a->userfullname},</p>
<p>{$a->sitename} hesabınızda az önce yeni bir cihazdan oturum açıldı.</p>
<ul>
<li>Hesabınız: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Cihaz: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Eğer bu sizseniz, hiçbir şey yapmanıza gerek yok.</p>
<p>Bu etkinliği tanımıyorsanız, lütfen <a href="{$a->changepasswordlink}">şifrenizi değiştirin</a>.</p>';
$string['newloginnotificationbodysmall'] = '{$a} hesabınızda az önce yeni bir cihazdan oturum açıldı.';
$string['newloginnotificationtitle'] = '{$a} hesabınızda yeni oturum açın';
$string['newpassword'] = 'Yeni şifre';
$string['newpassword_help'] = 'Yeni bir şifre girin ya da mevcut şifrenizi korumak için boş bırakın.';
$string['newpasswordfromlost'] = '<strong>UYARI:</strong> <strong>Mevcut şifreniz</strong> şifre kurtarma işleminin bir aşaması olarak e-postalardan <strong>ikincisinde</strong> gönderilmiş olacak. Bu ekranda devam etmeden önce değiştirme şifrenizi almış olduğunuzdan emin olun.';
$string['newpasswordtext'] = 'Merhaba {$a->firstname},

\'{$a->sitename}\' sitesindeki eski şifreniz silindi
ve geçici yeni bir şifre oluşturuldu.

Mevcut giriş bilgileriniz:

  kullanıcı adı: {$a->username}
  şifre: {$a->newpassword}

Şifrenizi değiştirmek için lütfen bu sayfaya gidin:
{$a->link}

Bu bağlantıyı tıkladığınızda yeni sayfada site açılacaktır. Açılmıyorsa yukarıdaki bağlantıyı tarayıcınızın adres satırına kopyalayın.

\'{$a->sitename}\' yöneticisinden saygılar,
{$a->signoff}';
$string['newpicture'] = 'Yeni resim';
$string['newpicture_help'] = 'Yeni bir resim eklemek için göz ata tıklayıp, bir resim (JPG veya PNG formatında) seçin ve "Profili güncelle"ye tıklayın. Resim, otomatik olarak kare şekline ve 100x100 ebatlarına dönüştürülecektir.';
$string['newpictureusernotsetup'] = 'Bir profil resmi ancak gerekli tüm profil bilgileri kaydedildikten sonra eklenebilir.';
$string['newsectionname'] = '{$a} bölümü için yeni isim';
$string['newsitem'] = 'haber ögesi';
$string['newsitems'] = 'duyurular';
$string['newsitemsnumber'] = 'Duyuruların sayısı';
$string['newsitemsnumber_help'] = 'Duyurular forumunda varsayılan olarak zorunlu abonelik ayarlanmıştır. Yalnızca öğretmenler ve uygun yetkiye sahip diğer kullanıcılar gönderi paylaşabilir.

Duyurular forumuna ihtiyacınız yoksa bunu sıfır olarak ayarlayın.

Bu ayar aynı zamanda en son duyurular bloğunda kaç yeni duyurunun görüneceğini de belirler.';
$string['newuser'] = 'Yeni kullanıcı';
$string['newusernewpasswordsubj'] = 'Yeni kullanıcı hesabı';
$string['newusernewpasswordtext'] = 'Merhaba {$a->firstname},

\'{$a->sitename}\' adresinde sizin için bir hesap oluşturuldu.

   kullanıcı adı: {$a->kullanıcı adı}
   şifre: {$a->newpassword}

(İlk kez giriş yaptığınızda şifrenizi değiştirmeniz istenecektir.)

\'{$a->sitename}\' kullanmaya başlamak için şu adreste oturum açın:
   {$a->bağlantı}

Yardıma ihtiyacınız varsa site yöneticisiyle iletişime geçin.
{$a->imza at}';
$string['newusers'] = 'Yeni kullanıcılar';
$string['newwindow'] = 'Yeni pencere';
$string['next'] = 'Sonraki';
$string['nextpage'] = 'Sonraki Sayfa';
$string['nextsection'] = 'Sonraki bölüm';
$string['no'] = 'Hayır';
$string['noblockstoaddhere'] = 'Bu sayfaya ekleyebileceğiniz herhangi bir blok yok';
$string['nobody'] = 'Hiç kimse';
$string['nochange'] = 'Değişiklik yok';
$string['nocomments'] = 'Yorum yok';
$string['nocourses'] = 'Kurs yok';
$string['nocoursesfound'] = '\'{$a}\' sözcüğüyle ilişkili kurs bulunamadı';
$string['nocoursestarttime'] = 'Kursun başlangıç tarihi yok';
$string['nocoursesyet'] = 'Bu kategoride kurs yok';
$string['nodstpresets'] = 'Yönetici Yaz Saati Uygulaması desteğini etkinleştirmedi.';
$string['nofilesselected'] = 'Geri yükleme için dosya seçilmedi';
$string['nofilesyet'] = 'Kursunuza henüz bir dosya yüklenmedi';
$string['nofiltersapplied'] = 'Hiçbir filtre uygulanmadı';
$string['nograde'] = 'Not yok';
$string['nohelpforactivityorresource'] = 'Bu kaynak veya etkinlik ile ilişkilendirilmiş bir yardım henüz yok.';
$string['noimagesyet'] = 'Kursunuza henüz bir resim yüklenmedi';
$string['noitemsfound'] = 'Hiçbir öge bulunamadı.';
$string['nologsfound'] = 'Herhangi bir kayıt yok';
$string['nomatchingusers'] = '\'{$a}\' ile eşleşen kullanıcı yok';
$string['nomorecourses'] = 'Daha fazla eşleşen kurs bulunamadı';
$string['nomoreidnumber'] = 'Çakışmayı engellemek için bir ID numarası kullanmıyor';
$string['none'] = 'Hiçbiri';
$string['noneditingteacher'] = 'Düzenleme yapamayan eğitimci';
$string['noneditingteacherdescription'] = 'Düzenleme yapamayan eğitimciler, kurslarda eğitim verebilirler ve öğrencilere not verebilirler ama etkinlikleri değiştiremezler.';
$string['nonstandard'] = 'Standart olmayan';
$string['nopendingcourses'] = 'Onay bekleyen kurs yok';
$string['nopotentialadmins'] = 'Potansiyel bir yönetici yok';
$string['nopotentialcreators'] = 'Potansiyel bir kurs oluşturucu yok';
$string['nopotentialstudents'] = 'Potansiyel bir öğrenci yok';
$string['nopotentialteachers'] = 'Potansiyel bir eğitimci yok';
$string['norecentactivity'] = 'Yakın tarihli bir etkinlik yok';
$string['noreplybouncemessage'] = 'Geri yanıt e-posta adresi olmayan bir iletiye yanıt verdiniz. Bir forum iletisine yanıt yazmaya çalışıyorsanız {$a} forumlarını kullanarak yanıt veriniz.

E-postanızın içeriği aşağıdadır:';
$string['noreplybouncesubject'] = '{$a} - geri dönen mesaj';
$string['noreplyname'] = 'Bu e-postaya yanıt verme';
$string['noresetrecord'] = 'Bu sıfırlama isteğine dair herhangi bir kayıt yok. Lütfen yeni bir şifre sıfırlama isteğinde bulunun.';
$string['noresults'] = 'Sonuç yok';
$string['noresultsfor'] = '"{$a}" için sonuç bulunamadı';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Normal arama';
$string['nosite'] = 'Site düzeyinde ders bulunamadı';
$string['nostudentsfound'] = '{$a} bulunamadı';
$string['nostudentsingroup'] = 'Bu grupta henüz öğrenci yok';
$string['nostudentsyet'] = 'Bu kursa henüz öğrenci kaydolmadı';
$string['nosuchemail'] = 'Böyle bir e-posta adresi yok';
$string['notavailable'] = 'Mevcut değil';
$string['notavailablecourse'] = '{$a} mevcut/müsait değil';
$string['noteachersyet'] = 'Bu kursda henüz bir eğitimci yok';
$string['noteachingupcomingcourses'] = 'Yaklaşan karslarda öğretmen veya öğrenci yok';
$string['notenrolled'] = '{$a} bu kursa kaydolmadı.';
$string['notenrolledprofile'] = 'Bu kullanıcı bu kursa kayıtlı olmadığı için kullanıcı bilgilerine ulaşılamaz.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Dikkat:</strong> Bu yedeklemeyi geri yüklerken tarihleri geri döndürme özelliği, gerekli izinlere sahip olmadığınız için devre dışı bırakıldı.';
$string['noteuserschangednonetocourse'] = '<strong>Dikkat:</strong> Etkinlikler, dosyalar, mesajlardaki kullanıcı verisini geri yüklerken kurs kullanıcılarının da geri yüklenmesi gerekiyor. Bu ayar sizin için değiştirildi.';
$string['nothingnew'] = 'Yeni bir etkinlik yok';
$string['nothingtodisplay'] = 'Gösterilecek bir şey yok';
$string['notice'] = 'Uyarı';
$string['noticenewerbackup'] = 'Bu yedek dosyası sürüm {$a->backuprelease} ({$a->backupversion}) ile oluşturuldu ve bu şu an kullandığınız sürümden {$a->serverrelease} ({$a->serverversion}) daha yeni. Bu bazı uyuşmazlıklara sebep olabilir, çünkü, geriye yönelik yedekleme uyumluluğu garantisi verilemez.';
$string['notifications'] = 'Bildirimler';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Kullanıcı: {$a->info}, Kullanıcı tam adı: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Bu kayıtlara buradan bakabilirsiniz: {$a}';
$string['notifyloginfailuresmessagestart'] = 'Son bilgilendirildiğinizden beri hatalı girişlerin listesi: {$a}';
$string['notifyloginfailuressubject'] = '{$a} :: Hatalı giriş bildirimi';
$string['notincluded'] = 'Dahil edilmedi';
$string['notingroup'] = 'Üzgünüz, bu sayfayı görebilmeniz için bir grubun üyesi olmanız gerekiyor.';
$string['notpublic'] = 'Herkese açık değil!';
$string['nousersfound'] = 'Kullanıcı bulunamadı';
$string['nousersmatching'] = '\'{$a}\' ile eşleşen kullanıcı yok';
$string['nousersyet'] = 'Henüz bir kullanıcı yok';
$string['novalidcourses'] = 'Gösterilecek geçerli bir kurs yok';
$string['now'] = 'şimdi';
$string['numattempts'] = '{$a} hatalı giriş denemesi';
$string['numberofcourses'] = 'Kurs sayısı';
$string['numberweeks'] = 'Bölüm sayısı';
$string['numday'] = '{$a} gün';
$string['numdays'] = '{$a} gün';
$string['numhours'] = '{$a} saat';
$string['numletters'] = '{$a} harf';
$string['numminutes'] = '{$a} dakika';
$string['nummonth'] = '{$a} ay';
$string['nummonths'] = '{$a} ay';
$string['numseconds'] = '{$a} saniye';
$string['numviews'] = '{$a} görüntülenme';
$string['numweek'] = '{$a} hafta';
$string['numweeks'] = '{$a} hafta';
$string['numwords'] = '{$a} kelime';
$string['numyear'] = '{$a} yıl';
$string['numyears'] = '{$a} yıl';
$string['ok'] = 'Tamam';
$string['oldpassword'] = 'Mevcut şifre';
$string['olduserdirectory'] = 'Bu ESKİ kullanıcı klasörüdür ve artık gerekmemekte. Güvenle silebilirsiniz. Bu klasörün içindeki bütün dosyalar YENİ kullanıcı klasörüne kopyalanmıştır.';
$string['oneitemfound'] = '1 adet öge bulundu.';
$string['opendrawerblocks'] = 'Blok çekmecesini aç';
$string['opendrawerindex'] = 'Kurs dizinini aç';
$string['opensinnewwindow'] = 'Yeni pencerede açılır';
$string['operator_and'] = 've';
$string['operator_andnot'] = 've';
$string['operator_or'] = 'veya';
$string['optional'] = 'isteğe bağlı';
$string['options'] = 'seçenekler';
$string['order'] = 'Sırala';
$string['originalpath'] = 'Orjinal yolu';
$string['orphanedactivitiesinsectionno'] = 'Sahipsiz etkinlikler (bölüm {$a})';
$string['other'] = 'Diğer';
$string['outline'] = 'Özet';
$string['outlinereport'] = 'Özet rapor';
$string['page'] = 'Sayfa';
$string['pagea'] = 'Sayfa {$a}';
$string['pagedcontentnavigation'] = 'Sayfalandırma gezintisi';
$string['pagedcontentnavigationactiveitem'] = 'Şu anki sayfa, sayfa {$a}';
$string['pagedcontentnavigationitem'] = '{$a} sayfasına git';
$string['pagedcontentpagingbaritemsperpage'] = 'Her sayfada {$a} kadar madde göster';
$string['pageheaderconfigablock'] = '{$a->fullname} içindeki bir blok yapılandırılıyor';
$string['pagepath'] = 'Sayfa yolu';
$string['pageshouldredirect'] = 'Bu sayfa otomatik olarak yönlendirilecek. Eğer bir sorun olduğunu düşünüyorsanız lütfen aşağıdaki devam et bağlantısına tıklayın.';
$string['parentcategory'] = 'Ebeveyn kategori';
$string['parentcoursenotfound'] = 'Ebeveyn kurs bulunamadı!';
$string['parentfolder'] = 'Ebeveyn klasör';
$string['participants'] = 'Katılımcılar';
$string['participantslist'] = 'Katılımcı listesi';
$string['participationratio'] = 'Katılım oranı';
$string['participationreport'] = 'Katılım raporu';
$string['password'] = 'Şifre';
$string['passwordchanged'] = 'Şifre değiştirildi';
$string['passwordextlink'] = 'Aşağıdaki bağlantı unutulan şifrenizi kurtarmak için sağlanmıştır. Bu, sizi Moodle\'ın dışına götürecek.';
$string['passwordforgotten'] = 'Unutulan şifre';
$string['passwordforgotteninstructions'] = 'Bilgileriniz öncelikle kullanıcı veritabanında bulunmalı. Lütfen, kullanıcı adınızı <strong>ya da</strong> kayıtlı e-posta adresinizi ilgili alana yazın. İkisini birden yazmanıza gerek yok.';
$string['passwordforgotteninstructions2'] = 'Şifrenizi yeniden oluşturmak için aşağıya kullanıcı adınızı ya da şifrenizi girip gönderiniz. Sizi veritabanımızda bulabilirsek, tekrar erişim sağlamak için neler yapmanız gerektiğini anlatan bir e-posta göndereceğiz.';
$string['passwordpolicynomatch'] = 'Mevcut şifreniz yeni şifre politikasıyla eşleşmiyor.
 {$a}';
$string['passwordsdiffer'] = 'Bu şifreler uyuşmuyor';
$string['passwordset'] = 'Şifreniz ayarlandı.';
$string['path'] = 'Dosya adresi';
$string['pathnotexists'] = 'Bu dosya adresi sunucuda yok!';
$string['pathslasherror'] = 'Dosya adresleri \'/\' ile bitemez!';
$string['paymentinstant'] = 'Ödeme yapmak ve dakikalar içinde kaydolmak için aşağıdaki düğmeyi kullanın.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> bekliyor</small>)';
$string['paymentrequired'] = 'Bu kursa giriş için ödeme yapmanız gerekir.';
$string['payments'] = 'Ödemeler';
$string['paymentsorry'] = 'Ödemeniz için teşekkürler. İşlem tamamlandığında {$a->fullname} kursuna giriş yapabileceksiniz.  Lütfen bekleyin ve tekrar deneyin. Sorun yaşamaya devam ederseniz, {$a->teacher} veya site yöneticisi ile iletişime geçin.';
$string['paymentthanks'] = 'Ödemeniz için teşekkürler. Şimdi {$a} kursuna kaydoldunuz.';
$string['pendingrequests'] = 'Bekleyen talepler';
$string['percents'] = '% {$a}';
$string['periodending'] = 'Bitiş süresi ({$a})';
$string['perpage'] = 'Sayfa başına';
$string['perpagea'] = 'Sayfa başına: {$a}';
$string['personal'] = 'Kişisel';
$string['personalprofile'] = 'Kişisel profil';
$string['phone'] = 'Telefon';
$string['phone1'] = 'Telefon';
$string['phone2'] = 'Cep telefonu';
$string['phpinfo'] = 'PHP bilgisi';
$string['picture'] = 'Resim';
$string['pictureof'] = '{$a} \'ın resmi';
$string['pictureofuser'] = 'Kullanıcı resmi';
$string['placeholdertypeorselect'] = 'Yaz veya seç...';
$string['pleaseclose'] = 'Bu pencereyi şimdi kapat.';
$string['pleasesearchmore'] = 'Lütfen daha fazlasını arayın';
$string['pleaseusesearch'] = 'Lütfen aramayı kullanın';
$string['plugin'] = 'Eklenti';
$string['pluginarea'] = 'Alan';
$string['plugincheck'] = 'Eklenti kontrolleri';
$string['plugindeletefiles'] = '\'{$a->name}\' eklentisi ile ilişkili tüm veriler veritabanından silindi. Eklentinin kendini yeniden kurmasını önlemek için,  {$a->directory} dizinini sunucudan silmeniz gerekir.';
$string['pluginitemid'] = 'Öge kimliği';
$string['pluginmissingfromdisk'] = '{$a->name} (Diskte eksik)';
$string['pluginsetup'] = 'Eklenti tabloları ayarlanıyor';
$string['policyaccept'] = 'Anladım ve kabul ediyorum';
$string['policyagree'] = 'Bu siteyi kullanmaya devam etmek için bu sözleşmeyi kabul etmelisiniz. Kabul ediyor musunuz?';
$string['policyagreement'] = 'Site politikası sözleşmesi';
$string['policyagreementclick'] = 'Site politikası sözleşmesi';
$string['popup'] = 'açılır pencere';
$string['popupwindow'] = 'Dosyayı yeni bir pencerede aç';
$string['popupwindowname'] = 'Açılır pencere';
$string['post'] = 'İleti';
$string['posts'] = 'İleti';
$string['potentialadmins'] = 'Potansiyel yöneticiler';
$string['potentialcreators'] = 'Potansiyel kurs oluşturucular';
$string['potentialstudents'] = 'Potansiyel öğrenciler';
$string['potentialteachers'] = 'Potansiyel eğitimciler';
$string['poweredbymoodle'] = '<a href="https://moodle.com">Moodle</a> tarafından desteklenmektedir';
$string['preferences'] = 'Tercihler';
$string['preferredlanguage'] = 'Tercih edilen dil';
$string['preferredtheme'] = 'Tercih edilen tema';
$string['preprocessingbackupfile'] = 'Yedek dosyası ön işleme alınıyor';
$string['prev'] = 'Önceki';
$string['preview'] = 'Önizleme';
$string['previeworchoose'] = 'Ön izleme gerçekleştir ya da bir tema seç';
$string['previewthemename'] = '\'{$a}\' temasını önizle';
$string['previous'] = 'Önceki';
$string['previouslyselectedusers'] = 'Önceden seçilen kullanıcılar \'{$a}\' ile eşleşmiyor';
$string['previouspage'] = 'Önceki Sayfa';
$string['previoussection'] = 'Önceki bölüm';
$string['primaryadminsetup'] = 'Yönetici hesabını ayarla';
$string['privacy:metadata:config_log'] = 'Yapılandırma değişikliklerinin günlüğü.';
$string['privacy:metadata:config_log:name'] = 'Ayar değişikliği adı';
$string['privacy:metadata:config_log:oldvalue'] = 'Önceki ayar değeri';
$string['privacy:metadata:config_log:plugin'] = 'Plug-in değiştirildi';
$string['privacy:metadata:config_log:timemodified'] = 'Değişikliğin yapıldığı zaman';
$string['privacy:metadata:config_log:userid'] = 'Değişiklik yapan kullanıcı';
$string['privacy:metadata:config_log:value'] = 'Ayarın yeni değeri';
$string['privacy:metadata:events_queue'] = 'İşlenmeyi bekleyen kullanıcı olayları kuyruğu.';
$string['privacy:metadata:events_queue:eventdata'] = 'Etkinlikte saklanan veriler.';
$string['privacy:metadata:events_queue:stackdump'] = 'Bu olayla ilişkili herhangi bir yığın izleme.';
$string['privacy:metadata:events_queue:timecreated'] = 'Bu etkinliğin oluşturulduğu saat.';
$string['privacy:metadata:events_queue:userid'] = 'Bu etkinlikle ilişkili kullanıcı kimliği';
$string['privacy:metadata:log'] = 'Bu olayla ilişkilendirilen kullanıcı kimliği';
$string['privacy:metadata:log:action'] = 'Eylemin açıklaması';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'kurs';
$string['privacy:metadata:log:info'] = 'Ek bilgiler';
$string['privacy:metadata:log:ip'] = 'Etkinlik sırasında kullanılan IP adresi';
$string['privacy:metadata:log:module'] = 'Modül';
$string['privacy:metadata:log:time'] = 'Eylemin gerçekleştiği zaman';
$string['privacy:metadata:log:url'] = 'Eylemle ilgili URL';
$string['privacy:metadata:log:userid'] = 'Eylemi gerçekleştiren kullanıcının kimliği';
$string['privacy:metadata:moodlenet_share_progress'] = 'MoodleNet paylaşım ilerleme ayrıntıları';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'İlişkili kurs modülü kimliği';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'İlişkili kurs kimliği';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'Başarılı bir paylaşımdan sonra MoodleNet\'ten döndürülen URL';
$string['privacy:metadata:moodlenet_share_progress:status'] = 'Ortaya çıkan paylaşım durumu';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'Paylaşımın yapıldığı zaman';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'Yapılan paylaşımın türü';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'Paylaşımı yapan kullanıcı';
$string['privacy:metadata:oauth2_refresh_token'] = 'Yenilemede kullanılan OAuth 2.0 jetonu';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'Jetonun karşılık geldiği kartı veren kuruluşun kimliği';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'Jetonun karşılık geldiği kullanıcının kimliği';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Jetonun oluşturulduğu zaman';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Jetonun en son güncellendiği zaman';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'İlgili kapsamlar ve kullanıcı için yenileme simgesi';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'Jetonun karşılık geldiği kullanıcının kimliği';
$string['privacy:metadata:task_adhoc'] = 'Ad hoc görevlerin durumu.';
$string['privacy:metadata:task_adhoc:component'] = 'Görevin sahibi olan bileşen.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Bu görevi çalıştırmanın en erken zamanı.';
$string['privacy:metadata:task_adhoc:userid'] = 'Görevi çalıştıracak kullanıcı.';
$string['privacy:metadata:task_log'] = 'Log (günlük) için günlük çıktısı';
$string['privacy:metadata:task_log:component'] = 'Görevin sahibi olan bileşen.';
$string['privacy:metadata:task_log:userid'] = 'Görevin ait olduğu kullanıcı.';
$string['privacy:metadata:upgrade_log'] = 'Yükseltme günlük dosyası';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Bu yükseltme (upgrade) adımıyla ilişkili herhangi bir geri izleme.';
$string['privacy:metadata:upgrade_log:details'] = 'Bu yükseltme (upgrade) için ekstra bilgi';
$string['privacy:metadata:upgrade_log:info'] = 'Bu yükseltme (upgrade) adımı için ana bilgiler.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Yükseltme (upgrade) yapılan plug-in';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Yükseltme (upgrade)  olacak yeni versiyon';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Yükseltme (upgrade)  yapılan zaman';
$string['privacy:metadata:upgrade_log:type'] = 'Log Girişi çeşidi';
$string['privacy:metadata:upgrade_log:userid'] = 'Yükseltme (upgrade) alamayacak kullanıcı';
$string['privacy:metadata:upgrade_log:version'] = 'Plug-in eski versiyonu';
$string['private_files_handler'] = 'E-posta eklerini kullanıcının kişisel dosyalar depolama alanında sakla.';
$string['private_files_handler_name'] = 'Kişisel dosyalara e-posta ile ilet';
$string['privatefiles'] = 'Kişisel dosyalar';
$string['privatefilesmanage'] = 'Kişisel dosyaları yönet';
$string['proceed'] = 'İlerlemek';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Bu profil açıklaması kişi en az bir derse kaydolmadan gösterilmeyecektir.';
$string['progress'] = 'İlerleme';
$string['publicprofile'] = 'Herkese açık profil';
$string['publicsitefileswarning'] = 'Not: Buradaki dosyalara herkes erişebilir';
$string['publicsitefileswarning2'] = 'Not: Buradaki dosyalara URL\'sini bilen (veya tahmin edebilen) herkes erişebilir. Güvenlik önlemi olarak, yedekleme dosyalarını geri yükledikten sonra hemen silmeniz önerilir.';
$string['publicsitefileswarning3'] = 'Not: Buradaki dosyalara URL\'sini bilen (veya tahmin edebilen) herkes erişebilir.<br />Güvenlik önlemi olarak, yedekleme dosyaları, sadece güvenli "backupdata" klasörüne kaydedilmelidir.';
$string['question'] = 'Soru';
$string['questionsinthequestionbank'] = 'Soru bankasındaki sorular';
$string['queued'] = 'Sıralanmış';
$string['quotausage'] = 'Şu anda {$a->total} limitinizin {$a->used} adresini kullandınız.';
$string['readinginfofrombackup'] = 'Yedekleme dosyasından bilgi okunuyor';
$string['readme'] = 'BENIOKU';
$string['recentactivity'] = 'En son etkinlik';
$string['recentactivityreport'] = 'En son etkinliklerin tüm raporları...';
$string['recipientslist'] = 'Alıcılar listesi';
$string['recommended'] = 'Önerilmiş';
$string['recreatedcategory'] = '{$a} kategorisi tekrar oluşturuldu';
$string['redirect'] = 'Yönlendir';
$string['reducesections'] = 'Bölüm sayısını azalt';
$string['refresh'] = 'Yenile';
$string['refreshingevents'] = 'Etkinlikler yenileniyor';
$string['registration'] = 'Moodle kayıt';
$string['registrationcontact'] = 'İletişim (herkese açık)';
$string['registrationcontactno'] = 'Hayır, diğer insanların benimle iletişim kurulmasını istemiyorum';
$string['registrationcontactyes'] = 'Evet, potansiyel Moodle kullanıcıları benimle iletişim kurabilsin';
$string['registrationemail'] = 'E-posta bildirimleri';
$string['registrationinfo'] = '<p>Bu sayfa Moodle sitenizin moodle.org adresine kaydedilmesini sağlar. Kayıt ücretsizdir.
Kayıt olmanın asıl faydası, sizi çok az ileti gönderilen bir e-posta listesine kayıt ederek, <strong>önemli güvenlik uyarıları</strong> duyurulduğunda ve <strong>yeni sürüm</strong> çıktığında bunu size bildirmektir.</p>
<p>Bilgileriniz gizli tutulacak, asla hiç kimseye verilmeyecek veya satılmayacaktır. Bu bilgileri toplamamızın tek amacı, Moodle\'nin dünyada ne kadar kullanıldığının istatistiklerini tutmaktır.</p>
<p>Aşağıdan seçim yaparak, sitenizin adını, ülkesini ve web adresini herkese açık olan Moodle Siteleri bölümünde yayınlatabilirsiniz.</p>
<p>Tüm yeni kayıtlar listeye eklenmeden önce bizim tarafımızdan denetlenir. Ancak, siteniz eklendikten sonra kayıt bilgilerinizi istediğiniz zaman tekrar bu formu kullanarak  güncelleyebilirsiniz.</p>';
$string['registrationinfotitle'] = 'Kayıt bilgisi';
$string['registrationsend'] = 'Kayıt bilgisini moodle.org adresine gönder';
$string['registrationyes'] = 'Evet, yeni  Moodle sürümlerini, güvenlik uyarılarını ve diğer önemli haberleri bana bildir';
$string['reject'] = 'Reddet';
$string['rejectdots'] = 'Reddet...';
$string['relativedatesmode'] = 'Göreceli tarihler modu';
$string['relativedatesmode_help'] = 'Kurs veya etkinlik tarihlerini kullanıcının kurstaki başlangıç tarihine göre görüntüleyin.

Kullanıcının kurs başlangıç tarihi, kurs başlamadan önce kaydolmadıkları sürece kayıt başlangıç tarihi olacaktır; bu durumda, başlangıç tarihi kurs başlangıç tarihi olacaktır.

UYARI: Bu deneysel bir özelliktir ve tüm etkinlikler onu desteklemeyebilir. Kurs oluşturulduktan sonra bu kurs ayarı artık değiştirilemez.';
$string['relativedatesmode_warning'] = '<strong>Uyarı:</strong> Kurs oluşturulduktan sonra göreli tarih modu değiştirilemez.';
$string['reload'] = 'Tekrar yükle';
$string['remoteappuser'] = 'Uzak {$a} Kullanıcısı';
$string['remove'] = 'Kaldır';
$string['removeadmin'] = 'Yöneticiyi kaldır';
$string['removecreator'] = 'Kurs oluşturucuyu kaldır';
$string['removed'] = '{$a} kaldırıldı.';
$string['removestudent'] = 'Öğrenciyi kaldır';
$string['removeteacher'] = 'Öğretmeni kaldır';
$string['rename'] = 'Yeniden adlandır';
$string['renamefileto'] = '<b>{$a}</b> şu olarak yeniden isimlendir;';
$string['report'] = 'Rapor';
$string['reports'] = 'Raporlar';
$string['reporttype'] = 'Rapor Türü';
$string['repositories'] = 'Depolar';
$string['requestcourse'] = 'Kurs talep et';
$string['requestedby'] = 'Talep eden';
$string['requestedcourses'] = 'Talep edilen kurslar';
$string['requestreason'] = 'Kurs talep etme nedeni';
$string['requests'] = 'İstekler';
$string['required'] = 'Gerekli';
$string['requirespayment'] = 'Bu kursa erişim için ödeme yapmanız gerekmekte';
$string['resendemail'] = 'Onay e-postasını yeniden gönder';
$string['reset'] = 'Sıfırla';
$string['resetcomponent'] = 'Bileşen';
$string['resetcourse'] = 'Kursu sıfırla';
$string['resetcourseconfirm'] = 'Kurs sıfırlansınmı?';
$string['resetcoursewarning'] = '\'{$a}\' kursunu sıfırlamak istediğinizden emin misiniz? <br/><br/> Bu işlem seçilen verileri siler ve kursu orijinal durumuna geri döndürür. Bu işlemi geri alamazsınız.';
$string['resetinfo'] = 'Bu özellik, tüm kullanıcı verilerini temizlemenize ve kursu orijinal durumuna sıfırlamanıza yardımcı olur. Kurs etkinlikleri ve ayarları değişmeden kalır.';
$string['resetinfoselect'] = 'Aşağıdaki kategorilerden silmek veya sıfırlamak istediğiniz verileri seçin:';
$string['resetnotimplemented'] = 'Sıfırlama desteklenmiyor';
$string['resetnotimplementedinfo'] = 'Bu etkinlikler sıfırlanamıyor';
$string['resetrecordexpired'] = 'Kullandığınız şifre sıfırlama bağlantısı {$a} dakikadan daha eski ve süresi dolmuş. Lütfen yeni bir şifre sıfırlama başlatın.';
$string['resetstartdate'] = 'Sıfırlama başlangıç tarihi';
$string['resetstatus'] = 'Durum';
$string['resettable'] = 'Tablo tercihlerini sıfırla';
$string['resettask'] = 'Sıfırla';
$string['resettodefaults'] = 'Varsayılanlara sıfırla';
$string['resortcourses'] = 'Kursları sırala';
$string['resortsubcategoriesby'] = 'Alt kategorileri {$a} \'ye göre sırala (artan)';
$string['resortsubcategoriesbyreverse'] = 'Alt kategorileri {$a} \'ye göre sırala (azalan)';
$string['resource'] = 'Kaynak';
$string['resource_type'] = 'Kaynak türü';
$string['resourcedisplayauto'] = 'Otomatik';
$string['resourcedisplaydownload'] = 'İndirmeye zorla';
$string['resourcedisplayembed'] = 'Göm';
$string['resourcedisplayframe'] = 'Çerçeve içinde';
$string['resourcedisplaynew'] = 'Yeni pencere';
$string['resourcedisplayopen'] = 'Aç';
$string['resourcedisplaypopup'] = 'Açılır pencere';
$string['resources'] = 'Kaynaklar';
$string['resources_help'] = 'Kaynak türleri, hemen her türlü web içeriğinin derse eklenmesini sağlar.';
$string['restore'] = 'Geri yükle';
$string['restorecancelled'] = 'Geri yüklemeden vazgeçildi';
$string['restorecannotassignroles'] = 'Rolleri atamak için geri yükleme yapılması gerekiyor ve sizin bunu yapmaya izniniz yok';
$string['restorecannotcreateorassignroles'] = 'Rol yaratmak ya da atamak için geri yükleme yapılması gerekiyor ve sizin bunu yapmaya izniniz yok';
$string['restorecannotcreateuser'] = 'Geri yükleme, yedek dosyasından \'{$a}\' kullanıcısını oluşturmak istiyor ancak bunu yapmaya izniniz yok';
$string['restorecannotoverrideperms'] = 'İzinleri yeniden düzenlemek için geri yükleme yapılması gerekiyor ve sizin bunu yapmaya izniniz yok';
$string['restorecoursenow'] = 'Şimdi bu kursu geri yükle!';
$string['restoredaccount'] = 'Geri yüklenmiş hesap';
$string['restoredaccountinfo'] = 'Bu hesap başka bir sunucudan içe aktarıldı ve şifre kayboldu. E-posta ile yeni şifre belirlemek için lütfen "Devam" \'a tıklayın.';
$string['restorefinished'] = 'Geri yükleme başarıyla tamamlandı';
$string['restoreinfo'] = 'Bir kursun önceki bir sürümünü geri yüklemek veya yeni bir kurs oluşturmak için bir yedekleme dosyası kullanın.';
$string['restoremnethostidmismatch'] = '\'{$a}\' kullanıcısının MNet ana makine kimliği yerel MNet ana makine kimliğiyle eşleşmiyor.';
$string['restoreto'] = 'Şuna geri yükle;';
$string['restoretositeadding'] = 'Uyarı: Sitenin anasayfasını geri yüklemek üzeresiniz, veri ekleniyor!';
$string['restoretositedeleting'] = 'Uyarı: Sitenin ana sayfa geri yüklemesini başlatmak üzeresiniz, ilk olarak veriler siliniyor!';
$string['restoreuserconflict'] = 'Yedek dosyasından \'{$a}\' kullanıcını geri yüklemeye çalışmak, çakışmaya neden olacaktır';
$string['restoreuserinfofailed'] = 'Geri yükleme işlemi durduruldu, çünkü sizin kullanıcı verisini geri yükleme izniniz yok.';
$string['restoreusersprecheck'] = 'Kullanıcı verileri denetleniyor';
$string['restoreusersprecheckerror'] = 'Kullanıcı verileri kontrol edilirken bazı sorunlar tespit edildi';
$string['restricted'] = 'Sınırlandırılmış';
$string['resultsfound'] = 'Sonuç bulundu {$a}';
$string['retry'] = 'Yeniden Dene';
$string['returningtosite'] = 'Kayıtlı kullanıcı mısınız?';
$string['returntooriginaluser'] = 'Şuna geri dön; {$a}';
$string['revert'] = 'Geri al';
$string['role'] = 'Rol';
$string['roleassignments'] = 'Rol atamaları';
$string['rolemappings'] = 'Rol eşleştirmeleri';
$string['rolerenaming'] = 'Rol yeniden adlandırma';
$string['rolerenaming_help'] = 'Bu kurstaki rollerin görünen adlarını değiştirin.';
$string['rolerenaming_success'] = 'Kurs rol adları güncellendi.';
$string['roles'] = 'Roller';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Yakın zamandaki RSS makale sayısı';
$string['rsserror'] = 'RSS verisi okunurken hata olustu';
$string['rsserrorauth'] = 'RSS bağlantınız geçerli bir giriş kaydı içermiyor.';
$string['rsserrorguest'] = 'Bu bildirim misafir erişimini kullanarak veriye erişimi sağlar ama misafirin bu veriyi okumaya izni yoktur. Geçerli bir kullanıcı hesabı ile bildirimin geldiği konumu ziyaret edin(URL) ve yeni bir RSS bağlantısı edinin.';
$string['rsskeyshelp'] = 'Güvenlik ve gizliliğin sağlanması için RSS besleme adresleri kullanıcıyı tanımlamayan özel bir belirteç içerir. Bu kullanıcıların Moodle\'da erişmemeleri gereken yerlere erişimlerini önler.</p><p>Bu belirteç, RSS besleme prosedürü olarak ilk erişiminizde otomatik olarak yaratılır. Eğer RSS besleme belirtecinizin herhangi bir yolla güvenilir durumda olmadığını hissediyorsanız, burada Sıfırla bağlantısına tıklayarak yeni bir tane isteyebilirsiniz. Lütfen var olan RSS besleme adresinizin geçersiz olacağını unutmayınız.';
$string['rsstype'] = 'Bu etkinlik için RSS beslemesi';
$string['save'] = 'Kaydet';
$string['saveandnext'] = 'Kaydet ve sonrakini göster';
$string['savechanges'] = 'Değişiklikleri kaydet';
$string['savechangesanddisplay'] = 'Kaydet ve göster';
$string['savechangesandreturn'] = 'Kaydet ve geri dön';
$string['savechangesandreturntocourse'] = 'Kaydet ve derse dön';
$string['savecomment'] = 'Yorumu kaydet';
$string['savedat'] = 'Kaydedildi:';
$string['savepreferences'] = 'Seçenekleri kaydet';
$string['saveto'] = 'Şuraya kaydet;';
$string['scale'] = 'Ölçek';
$string['scale_help'] = 'Bir ölçek, bir etkinlikteki puanlama performansını hesaplamanız için bir yol sağlar. "Üzücü, Yeterince iyi değil, Ortalama, İyi, Çok iyi, Mükemmel!" gibi olumsuz ile olumlu arasında listelenmiş değerler tanımlanmasını sağlar.';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Ölçekler';
$string['scalescustom'] = 'Özel ölçekler';
$string['scalescustomcreate'] = 'Yeni ölçek ekle';
$string['scalescustomno'] = 'Henüz özel bir ölçek oluşturulmadı';
$string['scalesstandard'] = 'Standart ölçekler';
$string['scalestandard'] = 'Standart ölçek';
$string['scalestandard_help'] = 'Standart ölçek, tüm kurslar için site genelinde mevcuttur.';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Özel ölçek oluşturmak için kurs yönetim menüsündeki \'Ölçekler...\' bağlantısını kullanın.';
$string['scalestip2'] = 'Özel ölçekler oluşturmak için kurs yönetim menüsünde Notlar bağlantısını tıklayıp Ölçekleri Düzenle\'yi seçin.';
$string['schedule'] = 'Program';
$string['screenshot'] = 'Ekran görüntüsü';
$string['search'] = 'Ara';
$string['search_help'] = 'Temel arama yaparken metin içinde herhangi bir yerde bir veya birden çok sözcük için sadece aralarında boşluk bırakarak sözcükleri yazın. İki karakterden uzun tüm sözcükler aranabilir.

Arama kutusuna hiç birşey yazmadan ara butonuna tıklarsanız,  gelişmiş arama seçeneklerine ulaşırsınız.';
$string['searchactivities'] = 'Ada veya açıklamaya göre etkinlikleri arayın';
$string['searchagain'] = 'Tekrar ara';
$string['searchbyemail'] = 'E-posta adresine göre ara';
$string['searchbyusername'] = 'Kullanıcı adına göre ara';
$string['searchcoursecategories'] = 'Kategorileri Ara';
$string['searchcourses'] = 'Kursları ara';
$string['searchgroups'] = 'Gurupları ara';
$string['searchitems'] = 'Ögeleri ara';
$string['searchoptions'] = 'Arama seçenekleri';
$string['searchresults'] = 'Arama sonuçları';
$string['searchusers'] = 'Kullanıcıları ara';
$string['sec'] = 'sn';
$string['seconds'] = 'saniye';
$string['secondsleft'] = '{$a} saniye';
$string['secondstotime172800'] = '2 gün';
$string['secondstotime259200'] = '3 gün';
$string['secondstotime345600'] = '4 gün';
$string['secondstotime432000'] = '5 gün';
$string['secondstotime518400'] = '6 gün';
$string['secondstotime604800'] = '1 hafta';
$string['secondstotime86400'] = '1 gün';
$string['secretalreadyused'] = 'Şifre değişimi onaylama bağlantısı daha önceden kullanılmış; şifre değiştirilmedi.';
$string['secs'] = 'sn';
$string['section'] = 'Bölüm';
$string['sectionactionnotsupported'] = '"{$a}" bölüm eylemi burada desteklenmiyor';
$string['sectionname'] = 'Bölüm adı';
$string['sectionoutline'] = 'Bölüm anahatları';
$string['sections'] = 'Bölümler';
$string['seealsostats'] = 'Ayrıca bakınız: istatistikler';
$string['selctauser'] = 'Bir kullanıcı seç';
$string['select'] = 'Seç';
$string['selectacategory'] = 'Lütfen bir kategori seçin';
$string['selectacountry'] = 'Bir ülke seç';
$string['selectacourse'] = 'Bir kurs seç';
$string['selectacoursesite'] = 'Bir kurs ya da site seç';
$string['selectagroup'] = 'Bir grup seç';
$string['selectall'] = 'Tümünü seç';
$string['selectallusersonpage'] = 'Bu sayfadaki tüm kullanıcıları seç';
$string['selectalluserswithcount'] = 'Tüm {$a} kullanıcıyı seç';
$string['selectamodule'] = 'Lütfen bir etkinlik eklentisi seçin';
$string['selectanaction'] = 'Bir eylem seç';
$string['selectanoptions'] = 'Bir seçenek seç';
$string['selectaregion'] = 'Bir bölge seç';
$string['selectcategorysort'] = 'Hangi kategorileri sıralamak istersiniz?';
$string['selectcategorysortby'] = 'Kategorileri nasıl sıralamak istediğinizi seçiniz';
$string['selectcoursesortby'] = 'Kursları nasıl sıralamak istediğinizi seçiniz';
$string['selectdates'] = 'Tarihleri seçin';
$string['selectdefault'] = 'Varsayılanı seç';
$string['selectedcategories'] = 'Seçili kategoriler';
$string['selectedfile'] = 'Seçili dosya';
$string['selectednowmove'] = '{$a} dosya taşınmak için seçildi. Şimdi hedef klasöre gidin ve \'Dosyaları buraya taşı\'ya basın';
$string['selectfiles'] = 'Dosyaları seç';
$string['selectfiltertype'] = 'Seç';
$string['selectgroupsseparate'] = 'Ayrı gruplar seçin';
$string['selectgroupsvisible'] = 'Görünür grupları seç';
$string['selectitem'] = '\'{$a}\' Seç';
$string['selectmoduletoviewhelp'] = 'Yardım görüntülemek için bir etkinlik ya da kaynak seçin.

Bir etkinlik veya kaynağa çift tıklayarak hızlıca ekleyebilirsiniz.';
$string['selectnos'] = 'Tümünü \'Hayır\' olarak seç';
$string['selectperiod'] = 'Süre seç';
$string['selecttheme'] = 'Tema seç';
$string['selectthemename'] = '\'{$a}\' temasını seç';
$string['senddetails'] = 'Bilgilerimi e-posta ile gönder';
$string['sent'] = 'Gönder';
$string['separate'] = 'Ayır';
$string['separateandconnected'] = 'Ayrı ve Bağlantılı bilgi yolları';
$string['separateandconnected1'] = 'Çoğunlukla ayrık bilgi';
$string['separateandconnected2'] = 'Ayrık ve bağlantılı';
$string['separateandconnected3'] = 'Çoğunlukla bağlantılı bilgi';
$string['separateandconnectedinfo'] = 'Ölçekleme ayrık ve bağlantılı bilgi teorisi üzerine kuruludur. Bu teori, birşeyi hesaplamak ya da öğrenmek için kullandığımız görme ve duyma yetilerini açıklar.<ul><li><strong>Ayrık bilenler</strong> objektif olarak duygu ve hisleri hesaba katmayacaklardır. Diğer insanlarla tartışmalarda, kendi fikirlerini savunurken, karşı tarafın açıklarını bulmak için mantıklarını kullanmayı severler.</li><li><strong>Bağlantılı bilenler</strong> diğer insanlara karşı daha esnektir. "Karşı bakış açısından birşeyler anlayabildikleri" sürece karşı tarafla empati kurma, dinleme ve sorular sorma yetilerine sahiptirler. Bu insanlar deneyimlerini paylaşarak diğer insanlardaki bilgiyi keşfetme yöntemini kullanırlar.</li></ul>';
$string['servererror'] = 'Sunucu ile iletişim kurarken bir hata oluştu';
$string['serverlocaltime'] = 'Sunucunun yerel zamanı';
$string['sessionforceclean'] = 'Bir güvenlik önlemi olarak, kullanıcı tarafından oluşturulan komut dosyaları bu oturumda devre dışı bırakıldı.';
$string['sessiontimeoutsoon'] = 'Oturumunuzun süresi dolmak üzere. Mevcut oturumunuzu uzatmak ister misiniz?';
$string['setcategorytheme'] = 'Kategori temasını ayarla';
$string['setmode'] = 'Modu ayarla';
$string['setpassword'] = 'Şifre belirle';
$string['setpasswordinstructions'] = 'Lütfen yeni şifrenizi aşağıya yazın ve değişiklikleri kaydedin.';
$string['settings'] = 'Ayarlar';
$string['share'] = 'Paylaş';
$string['shortname'] = 'Kısa adı';
$string['shortnamecollisionwarning'] = '[*] = Bu kısa ad başka bir kurs tarafından kullanılmakta ve onaylanması için bunu değiştirmeniz gerekiyor';
$string['shortnamecourse'] = 'Kurs kısa adı';
$string['shortnamecourse_help'] = 'Sınırlı alana sahip alanlarda görüntülenen ad. Benzersiz olmalıdır.';
$string['shortnametaken'] = 'Bu kısa ad başka bir kurs için kullanılıyor ({$a})';
$string['shortnameuser'] = 'Kullanıcının kısa adı';
$string['shortsitename'] = 'Sitenin kısa adı (örneğin tek bir sözcük)';
$string['show'] = 'Göster';
$string['showactions'] = 'Eylemleri göster';
$string['showactivitydates'] = 'Etkinlik tarihlerini göster';
$string['showactivitydates_help'] = 'Kurs sayfasında etkinlik tarihlerini gösterin.';
$string['showadvancededitor'] = 'Gelişmiş';
$string['showadvancedsettings'] = 'Gelişmiş ayarları göster';
$string['showall'] = 'Tümünü göster: {$a}';
$string['showallcourses'] = 'Tüm kursları göster';
$string['showblockcourse'] = 'Blok içeren kursların listesini göster';
$string['showcategory'] = '{$a} \'i göster';
$string['showchartdata'] = 'Grafik verilerini göster';
$string['showcomments'] = 'Yorumları göster/gizle';
$string['showcommentsnonjs'] = 'Yorumları göster';
$string['showdescription'] = 'Kurs sayfasında açıklama göster';
$string['showdescription_help'] = 'Etkinse, yukarıdaki açıklama kurs sayfasında etkinlik veya kaynak bağlantısının hemen altında görüntülenir.';
$string['showgrades'] = 'Notları öğrencilere göster';
$string['showgrades_help'] = 'Kursdaki bir çok etkinlik not ayarlanabilir. Bu ayarla öğrencinin kurs yönetim bloğundaki bir bağlantı yoluyla dersteki notların listesini görüp göremeyeceği belirlenir.';
$string['showingacourses'] = 'Tüm {$a} kursları göster';
$string['showingxofycourses'] = 'Toplam {$a->total} kursdan , {$a->start} ile {$a->end} arasındaki kurs görüntüleniyor';
$string['showless'] = 'Daha az göster';
$string['showlistofcourses'] = 'Kurs listesini göster';
$string['showmodulecourse'] = 'Etkinlik içeren kursların listesini göster';
$string['showmore'] = 'Daha fazla göster';
$string['showoncoursepage'] = 'Kurs sayfasında göster';
$string['showonly'] = 'Sadece göster';
$string['showperpage'] = 'Her sayfada {$a} kayıt göster';
$string['showpopoverwindow'] = 'Popover penceresini göster';
$string['showrecent'] = 'Son etkinlikleri göster';
$string['showreports'] = 'Etkinlik raporlarını göster';
$string['showreports_help'] = 'Öğrencilerin profil sayfaları aracılığıyla kendi etkinlik raporlarını görüntülemelerine izin verin.';
$string['showsettings'] = 'Ayarları göster';
$string['showtheselogs'] = 'Bu kayıtları göster';
$string['showthishelpinlanguage'] = 'Dilde bu yardımı göster: {$a}';
$string['sidepanel'] = 'Yan panel';
$string['signoutofotherservices'] = 'Tüm web uygulamalarından çıkış yapın';
$string['signoutofotherservices_help'] = 'Mobil uygulama gibi web hizmetlerini kullanan tüm cihazlardan ve sistemlerden çıkış yapın. Tarayıcı oturumları etkin kalacaktır.';
$string['since'] = 'Şu tarihten beri';
$string['sincelast'] = 'son girişten beri';
$string['site'] = 'Site';
$string['sitedefault'] = 'Site varsayılanı';
$string['sitedefaultspecified'] = 'Site varsayılanı ({$a})';
$string['siteerrors'] = 'Site hataları';
$string['sitefiles'] = 'Site dosyaları';
$string['sitefilesused'] = 'Bu kursda kullanılan site dosyaları';
$string['sitehome'] = 'Site ana sayfası';
$string['sitelegacyfiles'] = 'Eski site dosyaları';
$string['sitelogs'] = 'Site kayıtları';
$string['sitenews'] = 'Site duyuruları';
$string['sitepages'] = 'Site sayfaları';
$string['sitepartlist'] = 'Katılımcı listesini görmek için gereken yetkiye sahip değilsiniz';
$string['sitepartlist0'] = 'Site katılımcı listesini görmek için site eğitimcisi olmanız gerekiyor';
$string['sitepartlist1'] = 'Site katılımcı listesini görmek için eğitimci olmanız gerekiyor';
$string['sites'] = 'Siteler';
$string['sitesection'] = 'Özel içerik ekle';
$string['sitesettings'] = 'Site ayarları';
$string['siteteachers'] = 'Site eğitimcileri';
$string['size'] = 'Boyut';
$string['sizeb'] = 'bayt';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Atlandı';
$string['skiptocategorylisting'] = 'Kategori listelerine geç';
$string['skiptocoursedetails'] = 'Ayrıntılı kurs bilgisine geç';
$string['skiptocourselisting'] = 'Kurs listelelerine geç';
$string['someallowguest'] = 'Bazı kurslara misafir olarak erişebilirsiniz';
$string['someerrorswerefound'] = 'Bazı bilgiler eksik veya yanlış. Ayrıntılar için aşağıya bakınız.';
$string['sort'] = 'Sırala';
$string['sortby'] = 'Sıralama ölçütü';
$string['sortbyx'] = '{$a} ölçütüne göre sırala - artan';
$string['sortbyxreverse'] = '{$a} ölçütüne göre sırala - azalan';
$string['sorting'] = 'Sıralama';
$string['sourcerole'] = 'Kaynak rol';
$string['specifyname'] = 'Bir isim belirtmelisiniz.';
$string['standard'] = 'Standart';
$string['starpending'] = '([*] = onay bekleyen ders)';
$string['startdate'] = 'Kurs başlangıç tarihi';
$string['startdate_help'] = 'Bu tarih, haftalık biçimde bir kurs için ilk haftanın başlangıcını belirler. Aynı zamanda kurs etkinliklerinin günlükleri için de başlangıç tarihidir.

Kursu sıfırlar ve bu tarihi değiştirirseniz kurstaki tüm tarihler yeni başlangıç tarihine göre ayarlanacaktır.';
$string['startdatewithtaskenabled'] = 'Kurs başlangıç kanipi';
$string['startdatewithtaskenabled_help'] = 'Kursun öğrenciler tarafından görülebilir hale geldiği tarih. Bu tarihten önce kursa erişemezler.

Bu tarih aynı zamanda haftalık formatta bir kurs için ilk haftanın başlangıcını belirler ve kurs etkinliklerinin günlükleri için başlangıç tarihidir. kursu sıfırlar ve bu tarihi değiştirirseniz kurstaki tüm tarihler yeni başlangıç tarihine göre taşınacaktır.';
$string['startingfrom'] = 'Başlangıç';
$string['startsignup'] = 'Yeni hesap oluştur';
$string['state'] = 'Eyalet/Bölge';
$string['statistics'] = 'İstatistikler';
$string['statisticsgraph'] = 'İstatistik grafiği';
$string['stats'] = 'İstatistikler';
$string['statslogins'] = 'Girişler';
$string['statsmodedetailed'] = 'Ayrıntılı (kullanıcı) görünümü';
$string['statsmodegeneral'] = 'Genel görünüm';
$string['statsnodata'] = 'Bu kurs ve zaman dilimi için mevcut veri bulunmamaktadır.';
$string['statsnodatauser'] = 'Bu kurs ve zaman dilimi için mevcut veri bulunmamaktadır.';
$string['statsoff'] = 'İstatistikler şu anda etkinleştirilmemiş';
$string['statsreads'] = 'Görüntülenmeler';
$string['statsreport1'] = 'Girişler';
$string['statsreport10'] = 'Kullanıcı etkinliği';
$string['statsreport11'] = 'En etkin kurslar';
$string['statsreport12'] = 'En etkin kurslar (ağırlıklı)';
$string['statsreport13'] = 'En çok katılımcısı olan kurslar (kurs kayıtlanmaları)';
$string['statsreport14'] = 'En çok katılımcısı olan kurslar (görüntülenmeler/gönderiler)';
$string['statsreport2'] = 'Görüntülenmeler (tüm roller)';
$string['statsreport3'] = 'Gönderiler (tüm roller)';
$string['statsreport4'] = 'Tüm etkinlikler (tüm roller)';
$string['statsreport5'] = 'Tüm etkinlikler (görüntülenmeler ve gönderiler)';
$string['statsreport7'] = 'Kullanıcı etkinliği (görüntülenmeler ve gönderiler)';
$string['statsreport8'] = 'Tüm kullanıcı etkinliği';
$string['statsreport9'] = 'Girişler (site geneli)';
$string['statsreportactivity'] = 'Tüm etkinlikler (tüm roller)';
$string['statsreportactivitybyrole'] = 'Tüm etkinlikler (görüntülenmeler ve gönderiler)';
$string['statsreportforuser'] = 'için';
$string['statsreportlogins'] = 'Girişler';
$string['statsreportreads'] = 'İzlemeler (tüm roller)';
$string['statsreporttype'] = 'Rapor tipi';
$string['statsreportwrites'] = 'Gönderiler (tüm roller)';
$string['statsstudentactivity'] = 'Öğrenci etkinliği';
$string['statsstudentreads'] = 'Öğrenci görüntülenmeleri';
$string['statsstudentwrites'] = 'Öğrenci gönderileri';
$string['statsteacheractivity'] = 'Öğretmen etkinliği';
$string['statsteacherreads'] = 'Öğretmen görüntülenmeleri';
$string['statsteacherwrites'] = 'Öğretmen gönderileri';
$string['statstimeperiod'] = 'Zaman periyodu - son:';
$string['statsuniquelogins'] = 'Benzersiz girişler';
$string['statsuseractivity'] = 'Tüm etkinlikler';
$string['statsuserlogins'] = 'Girişler';
$string['statsuserreads'] = 'Görüntülenmeler';
$string['statsuserwrites'] = 'Gönderiler';
$string['statswrites'] = 'Gönderiler';
$string['status'] = 'Durum';
$string['statuschecks'] = 'Durum kontrolü';
$string['statuscritical'] = 'Kritik';
$string['statusdone'] = 'Bitti';
$string['statuserror'] = 'Hata';
$string['statusinfo'] = 'Bilgi';
$string['statusna'] = 'Uygulanamaz';
$string['statusok'] = 'Tamam';
$string['statusunknown'] = 'Bilinmiyor';
$string['statuswarning'] = 'Uyarı';
$string['stringsnotset'] = 'Bu ifadeler {$a} içinde tanımlanmadı';
$string['studentnotallowed'] = 'Maalesef bu kursa\'{$a}\' olarak giremezsiniz';
$string['students'] = 'Öğrenciler';
$string['studentsandteachers'] = 'Öğrenciler ve eğitimciler';
$string['subcategories'] = 'Alt Kategoriler';
$string['subcategory'] = 'Alt kategori';
$string['subcategoryof'] = '{$a} için alt kategori';
$string['subject'] = 'Konu';
$string['submit'] = 'Gönder';
$string['subsectionmoveerror'] = 'Bu alt bölüm başka bir alt bölüm üzerine taşınamaz';
$string['success'] = 'Başarılı';
$string['successduration'] = 'Başarılı ({$a} saniyede)';
$string['summary'] = 'Özet';
$string['suspended'] = 'Askıya alınmış';
$string['suspendedusers'] = 'Askıya alınmış kullanıcılar';
$string['switchdevicedefault'] = 'Standart temaya geç';
$string['switchdevicerecommended'] = 'Cihazınız için önerilen temaya geçin';
$string['switchrolereturn'] = 'Normal rolüme dön';
$string['switchroleto'] = 'Şu role geç...';
$string['switchroleto_help'] = 'Bu roldeki bir kişinin bu kursu nasıl göreceği hakkında fikir edinmek için bir rol seçin.

Bu görünümün mükemmel olmayabileceğini lütfen unutmayın (<a href="https://docs.moodle.org/en/Switch_roles">Ayrıntılara ve alternatiflere bakın</a>).';
$string['tag'] = 'Etiket';
$string['tagalready'] = 'Bu etiket zaten var';
$string['tagmanagement'] = 'Etiket ekle/sil...';
$string['tags'] = 'Etiketler';
$string['targetrole'] = 'Hedef rol';
$string['teacheronly'] = 'sadece {$a} için';
$string['teacherroles'] = '{$a} rol';
$string['teachers'] = 'Öğretmen(ler)';
$string['textcopiedtoclipboard'] = 'Metin panoya kopyalandı';
$string['textediting'] = 'Metin düzenleyici';
$string['textediting_help'] = 'Atto veya TinyMCE gibi bir HTML düzenleyici seçilirse, metin girişi alanlarında kolayca içerik eklenmesi için düğmeler bulunan bir araç çubuğu bulunur.

\'Düz metin alanı\' seçilirse, HTML veya Markdown gibi metin girişi alanları için bir format seçilebilir.

Mevcut metin editörlerinin listesi site yöneticisi tarafından belirlenir.';
$string['texteditor'] = 'Standart web formları kullan';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Düz metin biçimi';
$string['thanks'] = 'Teşekkürler';
$string['theme'] = 'Tema';
$string['themepreviewdescription'] = '{$a} tema açıklaması';
$string['themepreviewimage'] = '{$a} önizleme görüntüsü';
$string['themes'] = 'Temalar';
$string['themesaved'] = 'Yeni tema kaydedildi';
$string['therearecourses'] = '{$a} kurs var';
$string['thereareno'] = 'Bu kurda hiç {$a} yok';
$string['thiscategory'] = 'Bu kategori';
$string['thiscategorycontains'] = 'Bu kategori içerir;';
$string['time'] = 'Zaman';
$string['timecreated'] = 'Oluşturma tarihi';
$string['timecreatedcourse'] = 'Kurs süresi oluşturuldu';
$string['timesplitting:deciles'] = 'Son onluk';
$string['timesplitting:deciles_help'] = 'Bu analiz aralığı, dersi onda birlik bölüme (10 eşit parça) böler ve her tahmin yalnızca önceki en son ondalığın verilerine dayanır.';
$string['timesplitting:decilesaccum'] = 'Önceki tüm onluk düzenler';
$string['timesplitting:decilesaccum_help'] = 'Bu analiz aralığı, dersi onda birine (10 eşit parça) böler ve her tahmin, önceki ondalıkların tümünün birikmiş verilerine dayanır.';
$string['timesplitting:nosplitting'] = 'Zaman sınırı yok';
$string['timesplitting:nosplitting_help'] = 'Bu model için tanımlanmış bir analiz aralığı yok.';
$string['timesplitting:onemonthafterstart'] = 'Başlangıçtan bir ay sonra';
$string['timesplitting:onemonthafterstart_help'] = 'Bu analiz aralığı, analiz edilebilir başlangıçtan 1 ay sonra bir tahmin oluşturur.';
$string['timesplitting:oneweekafterstart'] = 'Başlangıçtan bir ay sonra';
$string['timesplitting:oneweekafterstart_help'] = 'Bu analiz aralığı, analiz edilebilir başlangıçtan 1 hafta sonra bir tahmin oluşturur.';
$string['timesplitting:past3days'] = 'Son 3 gün';
$string['timesplitting:past3days_help'] = 'Bu analiz aralığı, her 3 günde bir tahmin üretir. Gösterge hesaplamaları son 3 güne dayalı olacaktır.';
$string['timesplitting:pastmonth'] = 'Geçen ay';
$string['timesplitting:pastmonth_help'] = 'Bu analiz aralığı, her ay tahminler üretir. Gösterge hesaplamaları geçen ay esas alınacaktır.';
$string['timesplitting:pastweek'] = 'Geçen hafta';
$string['timesplitting:pastweek_help'] = 'Bu analiz aralığı, her hafta tahminler üretir. Gösterge hesaplamaları geçen haftaya göre yapılacaktır.';
$string['timesplitting:quarters'] = 'Son çeyrek';
$string['timesplitting:quarters_help'] = 'Bu analiz  dersi çeyreğe (4 eşit parçaya) böler. Her tahmin sadece en son çeyreğin bilgileri baz alınarak başlar.';
$string['timesplitting:quartersaccum'] = 'Tüm önceki çeyrekler';
$string['timesplitting:quartersaccum_help'] = 'Bu analiz aralığı dersi çeyreğe (4 eşit parçaya) böler. Her tahmin önceki çeyreklerin bilgileri baz alınarak başlar.';
$string['timesplitting:singlerange'] = 'Baştan sona';
$string['timesplitting:singlerange_help'] = 'Bu analiz aralığı dersi tek bir zaman aralığı olarak değerlendirir.';
$string['timesplitting:tenpercentafterstart'] = 'Başlangıçtan sonra %10';
$string['timesplitting:tenpercentafterstart_help'] = 'Bu analiz aralığı, kursun% 10\'u tamamlandıktan sonra bir tahmin oluşturur.';
$string['timesplitting:upcoming3days'] = 'Gelecek 3 gün';
$string['timesplitting:upcoming3days_help'] = 'Bu analiz aralığı, her 3 günde bir tahmin üretir. Gösterge hesaplamaları gelecek 3 güne dayalı olacaktır.';
$string['timesplitting:upcomingfortnight'] = 'Önümüzdeki iki hafta';
$string['timesplitting:upcomingfortnight_help'] = 'Bu analiz aralığı, her iki haftada bir tahminler üretir. Gösterge hesaplamaları önümüzdeki iki hafta esas alınacaktır.';
$string['timesplitting:upcomingweek'] = 'Gelecek hafta';
$string['timesplitting:upcomingweek_help'] = 'Bu analiz aralığı, her hafta tahminler üretir. Gösterge hesaplamaları önümüzdeki haftaya göre yapılacaktır.';
$string['timezone'] = 'Zaman dilimi';
$string['tocontent'] = '"{$a}" öğesine';
$string['tocreatenewaccount'] = 'Yeni hesap oluşturma adımına geç';
$string['todate'] = 'Bitiş';
$string['today'] = 'Bugün';
$string['todaylogs'] = 'Bugünün kayıtları';
$string['toeveryone'] = 'herkese';
$string['toggleemojipicker'] = 'Emoji seçiciyi aç / kapat';
$string['togglesearch'] = 'Arama girişini değiştir';
$string['toomanybounces'] = 'Bu e-posta adresi çok fazla geri dönüyor. Devam etmek için bu e-posta adresini <b>değiştirmelisiniz</b>.';
$string['toomanytags'] = 'Bu arama çok fazla etiket içeriyordu; bazıları yok sayılacaktır.';
$string['toomanytoshow'] = 'Gösterilecek çok fazla kullanıcı var';
$string['toomanyusersmatchsearch'] = '\'{$a->search}\' ile eşleşen çok fazla ({$a->count}) kullanıcı var';
$string['toomanyuserstoshow'] = 'Gösterilecek çok fazla ({$a}) kullanıcı var';
$string['toonly'] = 'sadece şuna; {$a}';
$string['top'] = 'Zirve';
$string['topic'] = 'Konu';
$string['toplevelcategory'] = 'En üst seviye kategori';
$string['torecipient'] = 'Bitiş';
$string['total'] = 'Toplam';
$string['totopofsection'] = '"{$a}" bölümünün başına';
$string['trackforums'] = 'Forum izleme';
$string['trackforumsno'] = 'Hayır: gördüğüm iletileri izlemeyi bırak';
$string['trackforumsyes'] = 'Evet: yeni iletileri benim için vurgula';
$string['trysearching'] = 'Aramayı deneyin.';
$string['turneditingoff'] = 'Düzenlemeyi kapat';
$string['turneditingon'] = 'Düzenlemeyi aç';
$string['unabletocopytoclipboard'] = 'Metin panoya kopyalanamıyor';
$string['unauthorisedlogin'] = '"{$a}" kullanıcı hesabı bu sitede bulunmuyor';
$string['undecided'] = 'Kararsız';
$string['unexistingcmid'] = 'Kurs Modül ID bulununamadı';
$string['unexistingsectionid'] = 'Kurs Bölüm ID bulununamadı';
$string['unfinished'] = 'Bitmedi';
$string['unknowncategory'] = 'Bilinmeyen kategori';
$string['unknownerror'] = 'Bilinmeyen hata';
$string['unknownuser'] = 'Bilinmeyen kullanıcı';
$string['unlimited'] = 'Limitsiz';
$string['unpacking'] = '{$a} açılıyor';
$string['unsafepassword'] = 'Güvenli olmayan şifre - başka birşey deneyin';
$string['untilcomplete'] = 'Tamamlanana kadar';
$string['unusedaccounts'] = '{$a} gün boyunca kullanılmayan hesapların ders kayıtları otomatik olarak iptal edilir';
$string['unzip'] = 'Zip dosyasını çıkar';
$string['unzippingbackup'] = 'Yedekleme arşivden(zip) çıkartılıyor';
$string['up'] = 'Yukarı';
$string['update'] = 'Güncelle';
$string['updated'] = '{$a} güncellendi';
$string['updatemymoodleoff'] = 'Sayfa özelleştirmesini durdur';
$string['updatemymoodleon'] = 'Bu sayfayı özelleştir';
$string['updatemyprofile'] = 'Profil güncelle';
$string['updatesevery'] = 'Her {$a} saniyede bir güncellenir';
$string['updatethis'] = 'Bu {$a} güncellensin';
$string['updatethiscourse'] = 'Bu kursu güncelle';
$string['upload'] = 'Yükle';
$string['uploadafile'] = 'Bir dosya yükle';
$string['uploadcantwrite'] = 'Diske yazılırken hata oluştu';
$string['uploadedfile'] = 'Dosya başarıyla yüklendi';
$string['uploadedfileto'] = '{$a->file}, {$a->directory} dizinine yüklendi';
$string['uploadedfiletoobig'] = 'Üzgünüz, bu dosya çok büyük (sınır: {$a} bayt)';
$string['uploadextension'] = 'Dosya yükleme PHP eklentisi tarafından durduruldu';
$string['uploadfailednotrecovering'] = 'Dosyalarından bir tanesinde, {$a->name}, sorun olduğu için dosya yüklemesi başarısız oldu. <br />Sorunla ilgili hata kayıtları:<br />{$a->problem}<br />Dosya kurtarılamıyor.';
$string['uploadfilelog'] = '{$a} dosyası için yükleme kayıtı';
$string['uploadformlimit'] = 'Gönderilen dosya {$a}, formda ayarlanan dosya boyutu sınırını aşıyor';
$string['uploadlabel'] = 'Başlık:';
$string['uploadlimitwithsize'] = '{$a->contextname} yükleme limiti ({$a->displaysize})';
$string['uploadnewfile'] = 'Yeni dosya yükle';
$string['uploadnofilefound'] = 'Dosya bulunamadı. Bir dosya seçtiğinizden emin misiniz?';
$string['uploadnotallowed'] = 'Yüklemelere izin yok';
$string['uploadnotempdir'] = 'Bir geçici klasör eksik';
$string['uploadoldfilesdeleted'] = 'Yükleme klasöründeki eski dosyalar silindi';
$string['uploadpartialfile'] = 'Dosyanın sadece bir kısmı yüklendi';
$string['uploadproblem'] = '\'{$a}\' dosyası gönderilirken bilinmeyen bir hata oluştu (dosya çok büyük olabilir?)';
$string['uploadrenamedchars'] = 'Geçersiz karakterlerden dolayı {$a->oldname} dosyası {$a->newname} olarak yeniden adlandırıldı.';
$string['uploadrenamedcollision'] = 'Dosya ismi çakışmasından dolayı {$a->oldname} dosyası {$a->newname} olarak yeniden adlandırıldı.';
$string['uploadserverlimit'] = 'Dosya boyutu sunucu tarafından ayarlanan sınırı aşıyor';
$string['uploadthisfile'] = 'Bu dosyayı yükle';
$string['url'] = 'URL';
$string['used'] = 'Kullanıldı';
$string['usedinnplaces'] = '{$a} yerde kullanıldı';
$string['user'] = 'Kullanıcı';
$string['useraccount'] = 'Bilinmeyen hesap';
$string['useractivity'] = 'Etkinlik';
$string['userconfirmed'] = '{$a} onaylandı';
$string['userdata'] = 'Kullanıcı verisi';
$string['userdeleted'] = 'Bu kullanıcı hesabı silindi';
$string['userdescription'] = 'Açıklama';
$string['userdescription_help'] = 'Bu kutuya yazacağınız bilgiler, profil sayfanızda başkaları tarafından görülebilir.';
$string['userdetails'] = 'Kullanıcı ayrıntıları';
$string['userfiles'] = 'Kullanıcı dosyaları';
$string['userlist'] = 'Kullanıcı listesi';
$string['usermatchedon'] = 'Bu kullanıcı aşağıdaki alan aracılığıyla aramayla eşleşiyor';
$string['usermenu'] = 'Kullanıcı menüsü';
$string['usermenugoback'] = 'Kullanıcı Menüsüne dön';
$string['username'] = 'Kullanıcı adı';
$string['usernameemail'] = 'Kullanıcı adı veya e-posta';
$string['usernameemailmatch'] = 'Kullanıcı adı ve e-posta adresi aynı kullanıcıyla ilişkili değil';
$string['usernameexists'] = 'Bu kullanıcı adı var, başka bir tane seçin';
$string['usernamelowercase'] = 'Sadece küçük harfler kabul edilir';
$string['usernamenotfound'] = 'Kullanıcı adı veritabanında bulunamadı';
$string['usernameoremail'] = 'Ya kullanıcı adını ya da e-posta adresini girin';
$string['usernotconfirmed'] = '{$a} onaylanmadı';
$string['userpic'] = 'Kullanıcı resmi';
$string['userpreferences'] = 'Kullanıcı tercihleri';
$string['users'] = 'Kullanıcılar';
$string['userselectorautoselectunique'] = 'Sadece bir kullanıcı arama ile eşleşirse, otomatik olarak seç';
$string['userselectorpreserveselected'] = 'Arama ile eşleşmese bile seçili kullanıcıları tut';
$string['userselectorsearchanywhere'] = 'her yerde';
$string['userselectorsearchexactmatchonly'] = 'sadece tam eşleşmeler';
$string['userselectorsearchfromstart'] = 'başlangıçtan itibaren';
$string['userselectorsearchmatching'] = 'Eşleşme:';
$string['usersnew'] = 'Yeni kullanıcılar';
$string['usersnoaccesssince'] = 'Şu günden fazla etkin olmayanlar;';
$string['userswithfiles'] = 'Dosyaları olan kullanıcılar';
$string['useruploadtype'] = 'Kullanıcı yükleme türü: {$a}';
$string['userzones'] = 'Kullanıcı bölgeleri';
$string['usetheme'] = 'Tema kullan';
$string['usingexistingcourse'] = 'Var olan kurs kullanılıyor';
$string['validatehtml'] = 'HTML\'yi doğrula';
$string['valuealreadyused'] = 'Bu değer zaten kullanımda.';
$string['version'] = 'Sürüm';
$string['view'] = 'Görüntüle';
$string['viewallcourses'] = 'Tüm kursları görüntüle';
$string['viewallcoursescategories'] = 'Tüm kursları ve kategorileri görüntüle';
$string['viewallresults'] = 'Tüm sonuçları görüntüle ({$a})';
$string['viewallsubcategories'] = 'Tüm alt kategorileri görüntüle';
$string['viewfileinpopup'] = 'Dosyayı açılır pencerede görüntüle';
$string['viewing'] = 'Görüntüleniyor:';
$string['viewmore'] = 'Daha fazlasını görüntüle';
$string['viewprofile'] = 'Profili görüntüle';
$string['views'] = 'Görüntülenmeler';
$string['viewsolution'] = 'çözümü görüntüle';
$string['visible'] = 'Görünür';
$string['visible_help'] = 'Bu ayar, kursun kurslar listesinde görünüp görünmeyeceğini belirler. Öğretmenler ve yöneticiler dışında kullanıcıların kursa giriş yapmasına izin verilmez.';
$string['visibletostudents'] = '{$a} görebilir';
$string['warning'] = 'Uyarı';
$string['warningdeleteresource'] = 'Dikkat: {$a} kaynağı başka bir yerde kullanılıyor. Kaynağı güncellemek ister misiniz?';
$string['wcagcheck'] = 'Web İçeriği Erişilebilirlik Yönergeleri (WCAG) kontrolü';
$string['webpage'] = 'Web sayfası';
$string['week'] = 'Hafta';
$string['weeks'] = 'haftalar';
$string['welcomeback'] = 'Hoş geldin, {$a->firstname}! 👋';
$string['welcometocourse'] = '{$a} \'a hoş geldiniz';
$string['welcometocoursetext'] = '$a->coursename}\'e hoş geldiniz!

Henüz yapmadıysanız, hakkınızda daha fazla bilgi edinebilmemiz için profil sayfanızı düzenlemelisiniz:

<a href="{$a->profileurl}">{$a->profileurl}</a>';
$string['welcometosite'] = 'Hoş geldin, {$a->firstname}! 👋';
$string['whatforlink'] = 'Bu bağlantı ile ne yapmak istiyorsunuz?';
$string['whatforpage'] = 'Bu metinle ne yapmak istiyorsunuz?';
$string['whatisyourage'] = 'Yaşınız nedir?';
$string['whattocallzip'] = 'Zip dosyasının adı ne olsun?';
$string['whattodo'] = 'Ne yapılacak';
$string['wheredoyoulive'] = 'Sen hangi ülkede yaşıyorsun?';
$string['whyisthisrequired'] = 'Bu neden gerekli?';
$string['windowclosing'] = 'Bu pencere otomatik olarak kapanır; eğer kapanmazsa şimdi kapatın.';
$string['withchosenfiles'] = 'Seçilen dosyalarla';
$string['withdisablednote'] = '{$a} (devre dışı)';
$string['withoutuserdata'] = 'kullanıcı verisi olmadan';
$string['withselectedusers'] = 'Seçili kullanıcılarla...';
$string['withuserdata'] = 'kullanıcı verisiyle';
$string['wontrunfuturescheduledtask'] = 'Başarısız olmayan ve gelecekte çalışması planlanan bir görevi çalıştırmaz';
$string['wordforstudent'] = 'Öğrenciye söyleyecekleriniz';
$string['wordforstudenteg'] = 'örn. Öğrenci, Katılımcı, vb.';
$string['wordforstudents'] = 'Öğrencilere söyleyecekleriniz';
$string['wordforstudentseg'] = 'örn. Öğrenciler, Katılımcılar, vb.';
$string['wordforteacher'] = 'Öğretmene söyleyecekleriniz';
$string['wordforteachereg'] = 'örn. Öğretmen, Öğretim Üyesi, Hoca, Eğitmen, Asistan, vb.';
$string['wordforteachers'] = 'Öğretmenlere söyleyecekleriniz';
$string['wordforteacherseg'] = 'ör. Eğitimciler, Öğretim Üyeleri, Hocalar, Öğretmenler, Asistanlar, vs.';
$string['writingblogsinfo'] = 'Blog bilgisi yazılıyor';
$string['writingcategoriesandquestions'] = 'Kategoriler ve sorular yazılıyor';
$string['writingcoursedata'] = 'Kurs verisi yazılıyor';
$string['writingeventsinfo'] = 'Etkinlik bilgileri yazılıyor';
$string['writinggeneralinfo'] = 'Genel bilgi yazılıyor';
$string['writinggradebookinfo'] = 'Notdefteri bilgisi yazılıyor';
$string['writinggroupingsgroupsinfo'] = 'Gruplama-grup bilgisi yazılıyor';
$string['writinggroupingsinfo'] = 'Gruplama bilgisi yazılıyor';
$string['writinggroupsinfo'] = 'Grup bilgileri yazılıyor';
$string['writingheader'] = 'Başlık yazılıyor';
$string['writingloginfo'] = 'Kayıtlar yazılıyor';
$string['writingmessagesinfo'] = 'Mesaj bilgileri yazılıyor';
$string['writingmoduleinfo'] = 'Modül bilgileri yazılıyor';
$string['writingscalesinfo'] = 'Ölçek bilgileri yazılıyor';
$string['writinguserinfo'] = 'Kullanıcı bilgileri yazılıyor';
$string['wrongpassword'] = 'Bu kullanıcı adı için yanlış şifre';
$string['year'] = 'yıl';
$string['years'] = 'yıl';
$string['yes'] = 'Evet';
$string['youareabouttocreatezip'] = 'Aşağıdakileri içeren bir zip dosyası oluşturmak üzeresiniz';
$string['youaregoingtorestorefrom'] = 'Geri yükleme işlemine şunun için başlamak üzeresiniz;';
$string['youhaveupcomingactivitiesdue'] = 'Tarihi yaklaşan etkinlikleriniz var';
$string['youhaveupcomingactivitiesdueinfo'] = 'Merhaba {$a},

<br/> <br/> Bitiş tarihi yaklaşan etkinlikleriniz var:';
$string['youneedtoenrol'] = 'Bu eylemi gerçekleştirmek için bu derse kaydolmanız gerekiyor.';
$string['yourlastlogin'] = 'Son giriş tarihiniz';
$string['yourself'] = 'kendiniz';
$string['yourteacher'] = 'sizin {$a}';
$string['yourwordforx'] = '\'{$a}\' için sözleriniz';
$string['zippingbackup'] = 'Yedekleme zip dosyasına dönüştürülüyor';
