<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'tr', version '5.0'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adres';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Çengel noktası ekle';
$string['advanced:backcolor_desc'] = 'Arkaplan rengi seç';
$string['advanced:block'] = 'Biçim';
$string['advanced:blockquote'] = 'Alıntı';
$string['advanced:blockquote_desc'] = 'Alıntı';
$string['advanced:bold_desc'] = 'Kalın (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Madde işaretli liste ekle/kaldır';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Özel karakter ekle';
$string['advanced:cleanup_desc'] = 'Dağınık kodu temizle';
$string['advanced:clipboard_msg'] = 'Kopyala/Kes/Yapıştır Mozilla ve Firefox\'ta kullanılamaz.
Bu konuda daha fazla bilgi edinmek ister misiniz?';
$string['advanced:code'] = 'Kod';
$string['advanced:code_desc'] = 'HTML Kaynağını Düzenle';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Kopyala';
$string['advanced:custom1_desc'] = 'Özel açıklamanızı buraya girin';
$string['advanced:cut_desc'] = 'Kes';
$string['advanced:dd'] = 'Tanım açıklaması';
$string['advanced:div'] = 'Bölüm';
$string['advanced:dt'] = 'Tanım terimi';
$string['advanced:font_size'] = 'Yazı boyutu';
$string['advanced:fontdefault'] = 'Yazı tipi';
$string['advanced:forecolor_desc'] = 'Metin rengi seç';
$string['advanced:h1'] = 'Başlık 1';
$string['advanced:h2'] = 'Başlık 2';
$string['advanced:h3'] = 'Başlık 3';
$string['advanced:h4'] = 'Başlık 4';
$string['advanced:h5'] = 'Başlık 5';
$string['advanced:h6'] = 'Başlık 6';
$string['advanced:help_desc'] = 'Yardım';
$string['advanced:help_shortcut'] = 'Araç çubuğu için ALT-F10 tuşlarına basın. Yardım için ALT-0 tuşlarına basın';
$string['advanced:hr_desc'] = 'Yatay çizgi ekle';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Resim ekle/düzenle';
$string['advanced:image_props_desc'] = 'Resim özellikleri';
$string['advanced:indent_desc'] = 'İçe kaydır';
$string['advanced:italic_desc'] = 'Eğik (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Ortala';
$string['advanced:justifyfull_desc'] = 'İki yana yasla';
$string['advanced:justifyleft_desc'] = 'Sola yasla';
$string['advanced:justifyright_desc'] = 'Sağa yasla';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Bağlantı ekle/düzenle';
$string['advanced:more_colors'] = 'Daha fazla renk';
$string['advanced:newdocument'] = 'Tüm içeriği boşaltmak istedinizden emin misiniz?';
$string['advanced:newdocument_desc'] = 'Yeni belge';
$string['advanced:numlist_desc'] = 'Numaralı liste ekleme/kaldırma';
$string['advanced:outdent_desc'] = 'Dışa kaydır';
$string['advanced:paragraph'] = 'Paragraf';
$string['advanced:paste_desc'] = 'Yapıştır';
$string['advanced:path'] = 'Yol';
$string['advanced:pre'] = 'Önformatlı';
$string['advanced:redo_desc'] = 'Tekrarla (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Biçimi kaldır';
$string['advanced:rich_text_area'] = 'Zengin metin alanı';
$string['advanced:samp'] = 'Kod örneği';
$string['advanced:shortcuts_desc'] = 'Erişilebilirlik yardımı';
$string['advanced:striketrough_desc'] = 'Ortası çizgili';
$string['advanced:style_select'] = 'Stiller';
$string['advanced:sub_desc'] = 'Altsimge';
$string['advanced:sup_desc'] = 'Üstsimge';
$string['advanced:toolbar'] = 'Araç kutusu';
$string['advanced:toolbar_focus'] = 'Araç düğmelerine git - Alt+Q, düzenleyiciye git - Alt-Z, öğe konumuna git - Alt-X';
$string['advanced:underline_desc'] = 'Altı çizgili (Ctrl+U)';
$string['advanced:undo_desc'] = 'Geri al (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Bağlantıyı sil';
$string['advanced:visualaid_desc'] = 'Yönergeleri ve görünmez elemanları aç/kapa';
$string['advanced_dlg:'] = '';
$string['advanced_dlg:about_author'] = 'Yazar';
$string['advanced_dlg:about_general'] = 'Hakkında';
$string['advanced_dlg:about_help'] = 'Yardım';
$string['advanced_dlg:about_license'] = 'Lisans';
$string['advanced_dlg:about_loaded'] = 'Yüklü eklentiler';
$string['advanced_dlg:about_plugin'] = 'Eklenti';
$string['advanced_dlg:about_plugins'] = 'Eklentiler';
$string['advanced_dlg:about_title'] = 'TinyMCE Hakkında';
$string['advanced_dlg:about_version'] = 'Sürüm';
$string['advanced_dlg:accessibility_help'] = 'Erişilebilirlik yardımı';
$string['advanced_dlg:accessibility_usage_title'] = 'Genel kullanım';
$string['advanced_dlg:anchor_invalid'] = 'Lütfen geçerli bir çapa adı belirtin.';
$string['advanced_dlg:anchor_name'] = 'Çengel noktası adı';
$string['advanced_dlg:anchor_title'] = 'Çengel noktası ekle/düzenle';
$string['advanced_dlg:charmap_title'] = 'Özel karakter seç';
$string['advanced_dlg:charmap_usage'] = 'Gezinti için sol ve sağ okları kullanın.';
$string['advanced_dlg:code_title'] = 'HTML kaynak düzenleyicisi';
$string['advanced_dlg:code_wordwrap'] = 'Sözcük kaydır';
$string['advanced_dlg:colorpicker_color'] = 'Renk:';
$string['advanced_dlg:colorpicker_name'] = 'İsim:';
$string['advanced_dlg:colorpicker_named_tab'] = 'İsimli';
$string['advanced_dlg:colorpicker_named_title'] = 'İsimli renkler';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Palet';
$string['advanced_dlg:colorpicker_palette_title'] = 'Palet renkleri';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Seçici';
$string['advanced_dlg:colorpicker_picker_title'] = 'Renk seçici';
$string['advanced_dlg:colorpicker_title'] = 'Bir renk seç';
$string['advanced_dlg:image_align'] = 'Hizalama';
$string['advanced_dlg:image_align_baseline'] = 'Taban çizgisi';
$string['advanced_dlg:image_align_bottom'] = 'Alt';
$string['advanced_dlg:image_align_left'] = 'Sola';
$string['advanced_dlg:image_align_middle'] = 'Orta';
$string['advanced_dlg:image_align_right'] = 'Sağa';
$string['advanced_dlg:image_align_textbottom'] = 'Metin altta';
$string['advanced_dlg:image_align_texttop'] = 'Metin üstte';
$string['advanced_dlg:image_align_top'] = 'Üst';
$string['advanced_dlg:image_alt'] = 'Resim tanımı';
$string['advanced_dlg:image_border'] = 'Kenarlık';
$string['advanced_dlg:image_dimensions'] = 'Boyutlar';
$string['advanced_dlg:image_hspace'] = 'Yatay boşluk';
$string['advanced_dlg:image_list'] = 'Resim listesi';
$string['advanced_dlg:image_src'] = 'Resim URL';
$string['advanced_dlg:image_title'] = 'Resim ekle/düzenle';
$string['advanced_dlg:image_vspace'] = 'Dikey boşluk';
$string['advanced_dlg:invalid_color_value'] = 'Geçersiz renk değeri';
$string['advanced_dlg:link_is_email'] = 'Girdiğiniz URL bir e-posta adresi gibi gözüküyor, gerekli olan mailto: önekinin eklenmesini ister misiniz?';
$string['advanced_dlg:link_is_external'] = 'Girdiğiniz URL dış bir bağlantı gibi gözüküyor, gerekli olan http:// önekinin eklenmesini ister misiniz?';
$string['advanced_dlg:link_list'] = 'Bağlantı listesi';
$string['advanced_dlg:link_target'] = 'Hedef';
$string['advanced_dlg:link_target_blank'] = 'Bağlantıyı yeni pencerede aç';
$string['advanced_dlg:link_target_same'] = 'Bağlantıyı aynı pencerede aç';
$string['advanced_dlg:link_title'] = 'Bağlantı ekle/düzenle';
$string['advanced_dlg:link_titlefield'] = 'Başlık';
$string['advanced_dlg:link_url'] = 'Bağlantı URL';
$string['advhr:advhr_desc'] = 'Yatay çizgi ekle';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Normal';
$string['advhr_dlg:noshade'] = 'Gölge yok';
$string['advhr_dlg:size'] = 'Yükseklik';
$string['advhr_dlg:width'] = 'Genişlik';
$string['advhr_dlg:widthunits'] = 'Birimler';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'Resim ekle/düzenle';
$string['advimage_dlg:align'] = 'Hizalama';
$string['advimage_dlg:align_baseline'] = 'Taban çizgisi';
$string['advimage_dlg:align_bottom'] = 'Alt';
$string['advimage_dlg:align_left'] = 'Sola';
$string['advimage_dlg:align_middle'] = 'Orta';
$string['advimage_dlg:align_right'] = 'Sağa';
$string['advimage_dlg:align_textbottom'] = 'Metin altta';
$string['advimage_dlg:align_texttop'] = 'Metin üstte';
$string['advimage_dlg:align_top'] = 'Üst';
$string['advimage_dlg:alt'] = 'Resim tanımı';
$string['advimage_dlg:alt_image'] = 'Alternatif resim';
$string['advimage_dlg:border'] = 'Kenarlık';
$string['advimage_dlg:classes'] = 'Sınıflar';
$string['advimage_dlg:constrain_proportions'] = 'Orantıyı koru';
$string['advimage_dlg:dialog_title'] = 'Resim ekle/düzenle';
$string['advimage_dlg:dimensions'] = 'Boyutlar';
$string['advimage_dlg:example_img'] = 'Görünüm önizleme resmi';
$string['advimage_dlg:general'] = 'Genel';
$string['advimage_dlg:height'] = 'Yükseklik';
$string['advimage_dlg:hspace'] = 'Yatay boşluk';
$string['advimage_dlg:id'] = 'Kimlik';
$string['advimage_dlg:image_list'] = 'Resim listesi';
$string['advimage_dlg:langcode'] = 'Dil kodu';
$string['advimage_dlg:langdir'] = 'Dil yönelimi';
$string['advimage_dlg:list'] = 'Resim listesi';
$string['advimage_dlg:long_desc'] = 'Uzun açıklama bağlantısı';
$string['advimage_dlg:ltr'] = 'Soldan sağa';
$string['advimage_dlg:map'] = 'Resim haritası';
$string['advimage_dlg:misc'] = 'Çeşitli';
$string['advimage_dlg:missing_alt'] = 'Bir Resim Tanımı girmeden devam etmek istediğinizden emin misiniz? Bu olmadan resim bazı engelli kullanıcılar, metin tabanlı tarayıcılar veya Web\'i resimleri kapatarak dolaşanlar için erişilmez olabilir.';
$string['advimage_dlg:mouseout'] = 'fare dışındayken';
$string['advimage_dlg:mouseover'] = 'fare üzerindeyken';
$string['advimage_dlg:preview'] = 'Önizleme';
$string['advimage_dlg:rtl'] = 'Sağdan sola';
$string['advimage_dlg:src'] = 'Resim URL';
$string['advimage_dlg:style'] = 'Stil';
$string['advimage_dlg:swap_image'] = 'Resmi takas et';
$string['advimage_dlg:tab_advanced'] = 'Gelişmiş';
$string['advimage_dlg:tab_appearance'] = 'Görünüm';
$string['advimage_dlg:tab_general'] = 'Genel';
$string['advimage_dlg:title'] = 'Başlık';
$string['advimage_dlg:vspace'] = 'Dikey boşluk';
$string['advimage_dlg:width'] = 'Genişlik';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'Bağlantı ekle/düzenle';
$string['advlink_dlg:accesskey'] = 'Erişim tuşu';
$string['advlink_dlg:advanced_props'] = 'Gelişmiş özellikler';
$string['advlink_dlg:advanced_tab'] = 'Gelişmiş';
$string['advlink_dlg:anchor_names'] = 'Çengel noktaları';
$string['advlink_dlg:classes'] = 'Sınıflar';
$string['advlink_dlg:encoding'] = 'Hedef karakter kodlaması';
$string['advlink_dlg:event_props'] = 'Olaylar';
$string['advlink_dlg:events_tab'] = 'Olaylar';
$string['advlink_dlg:general_props'] = 'Genel özellikler';
$string['advlink_dlg:general_tab'] = 'General';
$string['advlink_dlg:height'] = 'Yakseklik';
$string['advlink_dlg:id'] = 'Kimlik';
$string['advlink_dlg:is_email'] = 'Girdiğiniz URL bir e-posta adresi gibi gözüküyor, gerekli olan mailto: önekinin eklenmesini ister misiniz?';
$string['advlink_dlg:is_external'] = 'Girdiğiniz URL dış bir bağlantı gibi gözüküyor, gerekli olan http:// önekinin eklenmesini ister misiniz?';
$string['advlink_dlg:langcode'] = 'Dil kodu';
$string['advlink_dlg:langdir'] = 'Dil yönelimi';
$string['advlink_dlg:link_list'] = 'Bağlantı listesi';
$string['advlink_dlg:list'] = 'Link list';
$string['advlink_dlg:ltr'] = 'Soldan sağa';
$string['advlink_dlg:mime'] = 'Hedef MIME tipi';
$string['advlink_dlg:popup'] = 'Javascript açılır pencere';
$string['advlink_dlg:popup_dependent'] = 'Bağımlı (sadece Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Konum çubuğunu göster';
$string['advlink_dlg:popup_menubar'] = 'Menü çubuğunu göster';
$string['advlink_dlg:popup_name'] = 'Pencere ismi';
$string['advlink_dlg:popup_opts'] = 'Seçenekler';
$string['advlink_dlg:popup_position'] = 'Konum (X/Y)';
$string['advlink_dlg:popup_props'] = 'Açılır pencere özellikleri';
$string['advlink_dlg:popup_resizable'] = 'Pencereyi boyutlanabilir yap';
$string['advlink_dlg:popup_return'] = '\'return false\' ekle';
$string['advlink_dlg:popup_scrollbars'] = 'Kaydırma çubuklarını göster';
$string['advlink_dlg:popup_size'] = 'Boyut';
$string['advlink_dlg:popup_statusbar'] = 'Durum çubuğunu göster';
$string['advlink_dlg:popup_tab'] = 'Açılma';
$string['advlink_dlg:popup_toolbar'] = 'Araç çubuklarını göster';
$string['advlink_dlg:popup_url'] = 'Açılacak URL';
$string['advlink_dlg:rel'] = 'Sayfadan hedefe ilişki';
$string['advlink_dlg:rev'] = 'Hedeften sayfaya ilişki';
$string['advlink_dlg:rtl'] = 'Sağdan sola';
$string['advlink_dlg:style'] = 'Stil';
$string['advlink_dlg:tabindex'] = 'Sekme indeksi';
$string['advlink_dlg:target'] = 'Hedef';
$string['advlink_dlg:target_blank'] = 'Yeni pencerede aç';
$string['advlink_dlg:target_langcode'] = 'Hedef dil';
$string['advlink_dlg:target_name'] = 'Hedef ismi';
$string['advlink_dlg:target_parent'] = 'Üst pencerede/çerçevede aç';
$string['advlink_dlg:target_same'] = 'Bu pencere/çerçevede aç';
$string['advlink_dlg:target_top'] = 'Üst çerçevede aç (tüm çerçeveleri değiştirir)';
$string['advlink_dlg:title'] = 'Bağlantı ekle/düzenle';
$string['advlink_dlg:titlefield'] = 'Başlık';
$string['advlink_dlg:url'] = 'Bağlantı URL';
$string['advlink_dlg:width'] = 'Genişlik';
$string['advlist:circle'] = 'Daire';
$string['advlist:def'] = 'Varsayılan';
$string['advlist:disc'] = 'Disk';
$string['advlist:lower_alpha'] = 'Alçalt alpha';
$string['advlist:lower_greek'] = 'Alçalt greek';
$string['advlist:lower_roman'] = 'Alçalt roman';
$string['advlist:square'] = 'Kare';
$string['advlist:types'] = 'Türler';
$string['advlist:upper_alpha'] = 'Yükselt alpha';
$string['advlist:upper_roman'] = 'Yükselt roman';
$string['aria:rich_text_area'] = 'Zengin metin alanı';
$string['autosave:restore_content'] = 'Otomatik olarak kaydedilen içeriği geri yükle';
$string['autosave:unload_msg'] = 'Bu sayfadan çıkarsanız yaptığınız değişiklikler kaybedilecek.';
$string['autosave:warning_message'] = 'Kaydedilen içeriği geri yüklerseniz, şu anda düzenleyicideki tüm içeriği kaybedeceksiniz.

Kaydedilen içeriği geri yüklemek istediğinizden emin misiniz?';
$string['availablebuttons'] = 'Kullanılabilir düğmeler';
$string['colors:000000'] = 'Siyah';
$string['colors:000080'] = 'Lacivert';
$string['colors:0000FF'] = 'Mavi';
$string['colors:003300'] = 'Koyu yeşil';
$string['colors:003366'] = 'Koyu gökmavisi';
$string['colors:008000'] = 'Yeşil';
$string['colors:008080'] = 'Çamurcun';
$string['colors:00CCFF'] = 'Gökyüzü mavisi';
$string['colors:00FF00'] = 'Çim rengi';
$string['colors:00FFFF'] = 'Deniz mavisi';
$string['colors:333300'] = 'Koyu zeytin rengi';
$string['colors:333333'] = 'Çok koyu gri';
$string['colors:333399'] = 'Çivit mavisi';
$string['colors:3366FF'] = 'Kraliyet mavisi';
$string['colors:339966'] = 'Deniz yeşili';
$string['colors:33CCCC'] = 'Turkuaz';
$string['colors:666699'] = 'Küllü mavi';
$string['colors:800000'] = 'Kestane rengi';
$string['colors:800080'] = 'Mor';
$string['colors:808000'] = 'Zeytin yeşili';
$string['colors:808080'] = 'Gri';
$string['colors:993300'] = 'Yanık turuncu';
$string['colors:993366'] = 'Kahverengi';
$string['colors:999999'] = 'Orta gri';
$string['colors:99CC00'] = 'Sarımtırak yeşil';
$string['colors:99CCFF'] = 'Açık gökyüzü mavisi';
$string['colors:C0C0C0'] = 'Gümüş rengi';
$string['colors:CC99FF'] = 'Erik yeşili';
$string['colors:CCFFCC'] = 'Soluk yeşil';
$string['colors:CCFFFF'] = 'Soluk cam göbeği';
$string['colors:FF0000'] = 'Kırmızı';
$string['colors:FF00FF'] = 'Morumtırak kırmızı';
$string['colors:FF6600'] = 'Turuncu';
$string['colors:FF9900'] = 'Kehribar sarısı';
$string['colors:FF99CC'] = 'Pembe';
$string['colors:FFCC00'] = 'Altın sarısı';
$string['colors:FFCC99'] = 'Şeftali sarısı';
$string['colors:FFFF00'] = 'Sarı';
$string['colors:FFFF99'] = 'Açık sarı';
$string['colors:FFFFFF'] = 'Beyaz';
$string['common:apply'] = 'Uygula';
$string['common:browse'] = 'Gözat';
$string['common:cancel'] = 'İptal';
$string['common:class_name'] = 'Sınıf';
$string['common:clipboard_msg'] = 'Mozilla ve Firefox\'ta kopyala/kes/yapıştır kullanılamıyor.
Bu sorun hakkında daha fazla bilgi ister misiniz?';
$string['common:clipboard_no_support'] = 'Şimdilik tarayıcınız tarafından desteklenmemektedir, bunun yerine kısayol tuşlarını kullanınız.';
$string['common:close'] = 'Kapat';
$string['common:edit_confirm'] = 'Bu metin bölgesi için WYSIWYG modunu kullanmak istiyor musunuz?';
$string['common:insert'] = 'Ekle';
$string['common:invalid_data'] = 'Hata: Geçersiz değerler girildi, bunlar kırmızıyla işaretlendi.';
$string['common:invalid_data_min'] = '{#field}, {#dakika} \'dan büyük bir sayı olmalıdır';
$string['common:invalid_data_number'] = '{#field} bir sayı olmalıdır';
$string['common:invalid_data_size'] = '{#field} bir sayı veya yüzde olmalıdır';
$string['common:more_colors'] = 'Daha fazla renk';
$string['common:not_set'] = '-- seçiniz --';
$string['common:popup_blocked'] = 'Üzgünüz, fakat popup-engelleyiciniz uygulama için gerekli bir pencerenin açılmasına izin vermedi. Bu aracı tam olarak kullanabilmek için popup engelleyicinizi kapatmanız gerekebilir.';
$string['common:update'] = 'Güncelle';
$string['common:value'] = '(değer)';
$string['contextmenu:align'] = 'Hizalama';
$string['contextmenu:center'] = 'Ortala';
$string['contextmenu:full'] = 'İki yana';
$string['contextmenu:left'] = 'Sola';
$string['contextmenu:right'] = 'Sağa';
$string['customconfig'] = 'Özel yapılandırma';
$string['customconfig_desc'] = 'Özel gelişmiş TinyMCE yapılandırması JSON biçiminde, örneğin: {"option1": "value2", "option2": "value2"}. Burada belirtilen herhangi bir seçenek standart ve eklenti ayarlarını geçersiz kılar.';
$string['customtoolbar'] = 'Editör araç çubuğu';
$string['customtoolbar_desc'] = 'Her satır, virgülle ayrılmış düğme adlarının bir listesini içerir, grup ayırıcı olarak "wrap" kullanın, boş satırlar yoksayılır. Varsayılan TinyMCE düğmeleri listesi için <a href="{$a}" target="_blank"> {$a} </a> adresine bakın. <br /> İlk satır her zaman gösterilir; burada görünürlük olarak Ikinci ve üçüncü araç çubukları değiştirilebilir.';
$string['directionality:ltr_desc'] = 'Sağdan sola yönelimli';
$string['directionality:rtl_desc'] = 'Soldan sağa yönelimli';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'İfadeler';
$string['emotions_dlg:cool'] = 'Havalı';
$string['emotions_dlg:cry'] = 'Ağla';
$string['emotions_dlg:desc'] = 'İfadeler';
$string['emotions_dlg:embarassed'] = 'Mahçup';
$string['emotions_dlg:foot_in_mouth'] = 'Ağzı kulaklarında';
$string['emotions_dlg:frown'] = 'Kaş çatmış';
$string['emotions_dlg:innocent'] = 'Masum';
$string['emotions_dlg:kiss'] = 'Öpücük';
$string['emotions_dlg:laughing'] = 'Kahkaha';
$string['emotions_dlg:money_mouth'] = 'Paragöz';
$string['emotions_dlg:sealed'] = 'Tıp';
$string['emotions_dlg:smile'] = 'Gülümse';
$string['emotions_dlg:surprised'] = 'Şaşırmış';
$string['emotions_dlg:title'] = 'İfade ekle';
$string['emotions_dlg:tongue_out'] = 'Dil çıkar';
$string['emotions_dlg:undecided'] = 'Kararsız';
$string['emotions_dlg:usage'] = 'Gezinti için sol ve sağ okları kullanın.';
$string['emotions_dlg:wink'] = 'Göz kırp';
$string['emotions_dlg:yell'] = 'Esne';
$string['fontselectlist'] = 'Kullanılabilir fontlar listesi';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Belge özellikleri';
$string['fullpage_dlg:active_color'] = 'Aktif rengi';
$string['fullpage_dlg:add'] = 'Yeni eleman ekle';
$string['fullpage_dlg:add_base'] = 'Taban eleman';
$string['fullpage_dlg:add_comment'] = 'Yorum düğümü';
$string['fullpage_dlg:add_link'] = 'Bağlantı elemanı';
$string['fullpage_dlg:add_meta'] = 'Meta elemanı';
$string['fullpage_dlg:add_script'] = 'Script elemanı';
$string['fullpage_dlg:add_style'] = 'Stil elemanı';
$string['fullpage_dlg:add_title'] = 'Başlık elemanı';
$string['fullpage_dlg:advanced_props'] = 'Gelişmiş';
$string['fullpage_dlg:advanced_tab'] = 'Gelişmiş';
$string['fullpage_dlg:appearance_bgprops'] = 'Arkaplan özellikleri';
$string['fullpage_dlg:appearance_linkprops'] = 'Bağlantı renkleri';
$string['fullpage_dlg:appearance_marginprops'] = 'Gövde kenar boşlukları';
$string['fullpage_dlg:appearance_style'] = 'Stil yaprağı ve stil özellikleri';
$string['fullpage_dlg:appearance_tab'] = 'Görünüm';
$string['fullpage_dlg:appearance_textprops'] = 'Metin özellikleri';
$string['fullpage_dlg:author'] = 'Yazar';
$string['fullpage_dlg:base_element'] = 'Taban eleman';
$string['fullpage_dlg:bgcolor'] = 'Arkaplan rengi';
$string['fullpage_dlg:bgimage'] = 'Arkaplan resmi';
$string['fullpage_dlg:bottom_margin'] = 'Alt kenar boşluğu';
$string['fullpage_dlg:charset'] = 'Krk.Seti';
$string['fullpage_dlg:comment_element'] = 'Yorum';
$string['fullpage_dlg:content'] = 'İçerik';
$string['fullpage_dlg:copyright'] = 'Telif';
$string['fullpage_dlg:defer'] = 'Ertele';
$string['fullpage_dlg:doctypes'] = 'Belge tipi';
$string['fullpage_dlg:encoding'] = 'Karakter kodlama';
$string['fullpage_dlg:font_face'] = 'Yazı tipi';
$string['fullpage_dlg:font_size'] = 'Yazı boyutu';
$string['fullpage_dlg:fontface'] = 'Yazı tipi';
$string['fullpage_dlg:fontsize'] = 'Yazı boyutu';
$string['fullpage_dlg:general_props'] = 'Genel';
$string['fullpage_dlg:head_elements'] = 'Başlık elemanları';
$string['fullpage_dlg:hover_color'] = 'Üzerinde rengi';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF dili';
$string['fullpage_dlg:info'] = 'Bilgi';
$string['fullpage_dlg:langcode'] = 'Dil kodu';
$string['fullpage_dlg:langdir'] = 'Dil yönelimi';
$string['fullpage_dlg:langprops'] = 'Dil ve kodlama';
$string['fullpage_dlg:language'] = 'Dil';
$string['fullpage_dlg:left_margin'] = 'Sol kenar boşluğu';
$string['fullpage_dlg:link_color'] = 'Bağlantı rengi';
$string['fullpage_dlg:link_element'] = 'Bağlantı elemanı';
$string['fullpage_dlg:ltr'] = 'Soldan sağa';
$string['fullpage_dlg:media'] = 'Medya';
$string['fullpage_dlg:meta_description'] = 'Tanım';
$string['fullpage_dlg:meta_element'] = 'Meta elemanı';
$string['fullpage_dlg:meta_index_follow'] = 'İndeksle ve bağlantıları izle';
$string['fullpage_dlg:meta_index_nofollow'] = 'İndeksle ve bağlantıları izleme';
$string['fullpage_dlg:meta_keywords'] = 'Anahtar sözcükler';
$string['fullpage_dlg:meta_noindex_follow'] = 'İndeksleme ama bağlantıları izle';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Dizine eklemeyin ve bağlantıları takip etmeyin';
$string['fullpage_dlg:meta_props'] = 'Meta bilgisi';
$string['fullpage_dlg:meta_robots'] = 'Robot\'lar';
$string['fullpage_dlg:meta_tab'] = 'Genel';
$string['fullpage_dlg:meta_title'] = 'Başlık';
$string['fullpage_dlg:movedown'] = 'Seçili elemanı alta al';
$string['fullpage_dlg:moveup'] = 'Seçili elemanı üste al';
$string['fullpage_dlg:name'] = 'İsim';
$string['fullpage_dlg:properties'] = 'Özellikler';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Seçili elemanı kaldır';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Sağ kenar boşluğu';
$string['fullpage_dlg:rtl'] = 'Sağdan sola';
$string['fullpage_dlg:script_element'] = 'Script elemanı';
$string['fullpage_dlg:src'] = 'Kaynak';
$string['fullpage_dlg:style'] = 'Stil';
$string['fullpage_dlg:style_element'] = 'Stil elemanı';
$string['fullpage_dlg:stylesheet'] = 'Stil yaprağı';
$string['fullpage_dlg:target'] = 'Hedef';
$string['fullpage_dlg:text_color'] = 'Metin rengi';
$string['fullpage_dlg:textcolor'] = 'Renk';
$string['fullpage_dlg:title'] = 'Belge özellikleri';
$string['fullpage_dlg:title_element'] = 'Başlık elemanı';
$string['fullpage_dlg:top_margin'] = 'Üst kenar boşluğu';
$string['fullpage_dlg:type'] = 'Tip';
$string['fullpage_dlg:value'] = 'Değer';
$string['fullpage_dlg:visited_color'] = 'Ziyaret edilmiş';
$string['fullpage_dlg:xml_pi'] = 'XML tanımı';
$string['fullscreen:desc'] = 'Tam ekran modunu değiştir';
$string['iespell:download'] = 'ieSpell bulunamadı. Şimdi kurmak ister misiniz?';
$string['iespell:iespell_desc'] = 'İmla kontrolünü çalıştır';
$string['insertdatetime:date_fmt'] = '%d-%m-%Y';
$string['insertdatetime:day_long'] = 'Pazar,Pazartesi,Salı,Çarşamba,Perşembe,Cuma,Cumartesi,Pazar';
$string['insertdatetime:day_short'] = 'Paz,Pzt,Sal,Çrş,Per,Cum,Cts,Paz';
$string['insertdatetime:insertdate_desc'] = 'Tarih ekle';
$string['insertdatetime:inserttime_desc'] = 'Zaman ekle';
$string['insertdatetime:months_long'] = 'Ocak,Şubat,Mart,Nisan,Mayıs,Haziran,Temmuz,Ağustos,Eylül,Ekim,Kasım,Aralık';
$string['insertdatetime:months_short'] = 'Oca,Şub,Mar,Nis,May,Haz,Tem,Ağu,Eyl,Eki,Kas,Ara';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Mutlak konumlandırmayı aç/kapa';
$string['layer:backward_desc'] = 'Arkaya al';
$string['layer:content'] = 'Yeni katman...';
$string['layer:forward_desc'] = 'Öne al';
$string['layer:insertlayer_desc'] = 'Yeni katman ekle';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Gömülü medya ekle/düzenle';
$string['media:edit'] = 'Tümleşik medya düzenle';
$string['media_dlg:advanced'] = 'Gelişmiş';
$string['media_dlg:align'] = 'Hizala';
$string['media_dlg:align_bottom'] = 'Alt';
$string['media_dlg:align_bottom_left'] = 'Sol alt';
$string['media_dlg:align_bottom_right'] = 'Sağ alt';
$string['media_dlg:align_center'] = 'Ortala';
$string['media_dlg:align_left'] = 'Sola';
$string['media_dlg:align_right'] = 'Sağa';
$string['media_dlg:align_top'] = 'Üst';
$string['media_dlg:align_top_left'] = 'Sol üst';
$string['media_dlg:align_top_right'] = 'Sağ üst';
$string['media_dlg:altsource1'] = 'Alternatif kaynak 1';
$string['media_dlg:altsource2'] = 'Alternatif kaynak 2';
$string['media_dlg:audio'] = 'HTML5 ses';
$string['media_dlg:autogotourl'] = 'Otomatik gidilecek URL';
$string['media_dlg:autohref'] = 'Otomatik HREF';
$string['media_dlg:autostart'] = 'Oto.başlat';
$string['media_dlg:balance'] = 'Balans';
$string['media_dlg:base'] = 'Taban';
$string['media_dlg:baseurl'] = 'Taban URL';
$string['media_dlg:bgcolor'] = 'Arkaplan';
$string['media_dlg:cache'] = 'Önbellek';
$string['media_dlg:captioningid'] = 'Başlıklandırma kimliği';
$string['media_dlg:center'] = 'Ortala';
$string['media_dlg:class_name'] = 'Sınıf';
$string['media_dlg:console'] = 'Konsol';
$string['media_dlg:constrain_proportions'] = 'Orantıyı koru';
$string['media_dlg:controller'] = 'Kontrolcü';
$string['media_dlg:controls'] = 'Kontroller';
$string['media_dlg:correction'] = 'Düzeltmesiz';
$string['media_dlg:currentmarker'] = 'Şimdiki işaretçi';
$string['media_dlg:currentposition'] = 'Şimdiki konum';
$string['media_dlg:defaultframe'] = 'Varsayılan çerçeve';
$string['media_dlg:embedded_audio_options'] = 'Gömülü ses seçenekleri';
$string['media_dlg:embeddedaudio'] = 'Gömülü ses';
$string['media_dlg:enabled'] = 'Etkin';
$string['media_dlg:enablejavascript'] = 'JavaScript etkin';
$string['media_dlg:endtime'] = 'Bitiş zamanı';
$string['media_dlg:file'] = 'Dosya/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Flash seçenekleri';
$string['media_dlg:flashvars'] = 'Flaş değişkenleri';
$string['media_dlg:fullscreen'] = 'Tam ekran';
$string['media_dlg:general'] = 'Genel';
$string['media_dlg:hidden'] = 'Gizli';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'Yty.Boşluk';
$string['media_dlg:html5_audio_options'] = 'Ses seçenekleri';
$string['media_dlg:html5_video_options'] = 'HTML5 video seçenekleri';
$string['media_dlg:id'] = 'Kimlik';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Resim durumu';
$string['media_dlg:invokeurls'] = 'Çağrılacak URL\'ler';
$string['media_dlg:kioskmode'] = 'Kiosk modu';
$string['media_dlg:list'] = 'Liste';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Döngü';
$string['media_dlg:maintainaspect'] = 'Orantıyı koru';
$string['media_dlg:menu'] = 'Menü göster';
$string['media_dlg:mute'] = 'Sessiz';
$string['media_dlg:name'] = 'İsim';
$string['media_dlg:nojava'] = 'Java yok';
$string['media_dlg:numloop'] = 'Döngü sayısı';
$string['media_dlg:play'] = 'Oto.Çal';
$string['media_dlg:playcount'] = 'Çalma sayısı';
$string['media_dlg:playeveryframe'] = 'Her çerçeveyi çal';
$string['media_dlg:poster'] = 'Poster';
$string['media_dlg:prefetch'] = 'Ön-getirme';
$string['media_dlg:preload'] = 'Önyükleme';
$string['media_dlg:preload_auto'] = 'Kullanıcının tarayıcısına karar ver';
$string['media_dlg:preload_metadata'] = 'Video meta verilerini önyükle';
$string['media_dlg:preload_none'] = 'Önyükleme yapma';
$string['media_dlg:preview'] = 'Önizleme';
$string['media_dlg:progress'] = 'İlerleme';
$string['media_dlg:qt_options'] = 'Quicktime seçenekleri';
$string['media_dlg:qt_stream_warn'] = 'Akışlı RTSP kaynakları, gelişmiş sekmesi altındaki QT kaynak alanına eklenmelidir.
Ayrıca kaynak alanına akışsız bir sürüm eklemelisiniz.';
$string['media_dlg:qtsrc'] = 'QT Kaynağı';
$string['media_dlg:qtsrcchokespeed'] = 'Tıkanma hızı';
$string['media_dlg:quality'] = 'Kalite';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Oran';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Real media player seçenekleri';
$string['media_dlg:salign'] = 'SHizala';
$string['media_dlg:scale'] = 'Ölçek';
$string['media_dlg:scriptcallbacks'] = 'Script çağrımları';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwave seçenekleri';
$string['media_dlg:shuffle'] = 'Karıştır';
$string['media_dlg:size'] = 'Boyutlar';
$string['media_dlg:sound'] = 'Ses';
$string['media_dlg:source'] = 'Kaynak';
$string['media_dlg:starttime'] = 'Başlangıc zamanı';
$string['media_dlg:stretchtofit'] = 'Sığacak şekilde boyutlandır';
$string['media_dlg:swstretchhalign'] = 'Esnetme Y-Hiza';
$string['media_dlg:swstretchstyle'] = 'Esnetme stili';
$string['media_dlg:swstretchvalign'] = 'Esnetme D-Hiza';
$string['media_dlg:target'] = 'Hedef';
$string['media_dlg:targetcache'] = 'Hedef önbellek';
$string['media_dlg:title'] = 'Gömülü ortam ekle/düzenle';
$string['media_dlg:type'] = 'Tip';
$string['media_dlg:uimode'] = 'kullanıcı arayüzü modu';
$string['media_dlg:video'] = 'HTML5 video';
$string['media_dlg:volume'] = 'Ses düzeyi';
$string['media_dlg:vspace'] = 'Dik.Boşluk';
$string['media_dlg:windowlessvideo'] = 'Penceresiz video';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Windows Media Player seçenekleri';
$string['nonbreaking:nonbreaking_desc'] = 'Kırılımsız boşluk karakteri ekle';
$string['pagebreak:desc'] = 'Yazdırmak için sayfa sonu ekle';
$string['paste:paste_text_desc'] = 'Sade Metin olarak yapıştır';
$string['paste:paste_word_desc'] = 'Word\'den yapıştır';
$string['paste:plaintext_mode'] = 'Yapıştır şu anda düz metin modunda. Düzenli yapıştır moduna geri dönmek için tekrar tıklayın. Bir şeyi yapıştırdıktan sonra, normal yapıştırma moduna geri dönersiniz.';
$string['paste:plaintext_mode_stick'] = 'Yapıştır şu anda düz metin modunda. Düzenli yapıştır moduna geri dönmek için tekrar tıklayın.';
$string['paste:selectall_desc'] = 'Tümünü Seç';
$string['paste_dlg:text_linebreaks'] = 'Satır kırılımlarını koru';
$string['paste_dlg:text_title'] = 'Pencereye metin yapıştırmak için CTRL+V tuşunu kullanınız.';
$string['paste_dlg:word_title'] = 'Pencereye metin yapıştırmak için CTRL+V tuşunu kullanınız.';
$string['pluginname'] = 'TinyMCE HTML düzenleyicisi (eski)';
$string['preview:preview_desc'] = 'Önizleme';
$string['print:print_desc'] = 'Yazdır';
$string['privacy:metadata'] = 'TinyMCE HTML düzenleyici eklentisi herhangi bir kişisel veri saklamaz.';
$string['save:cancel_desc'] = 'Tüm değişiklikleri iptal et';
$string['save:save_desc'] = 'Kaydet';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'Bul/Değiştir';
$string['searchreplace:search_desc'] = 'Bul';
$string['searchreplace_dlg:allreplaced'] = 'Aranan metin bulunduğu yerlerde değiştirildi.';
$string['searchreplace_dlg:direction'] = 'Yön';
$string['searchreplace_dlg:down'] = 'Aşağı';
$string['searchreplace_dlg:findnext'] = 'Sonrakini bul';
$string['searchreplace_dlg:findwhat'] = 'Aranacak';
$string['searchreplace_dlg:mcase'] = 'Büyük/küçük harf eşle';
$string['searchreplace_dlg:notfound'] = 'Arama tamamlandı. Aranan metin bulunamadı.';
$string['searchreplace_dlg:replace'] = 'Değiştir';
$string['searchreplace_dlg:replace_title'] = 'Bul/Değiştir';
$string['searchreplace_dlg:replaceall'] = 'Tümünü değiştir';
$string['searchreplace_dlg:replacewith'] = 'Değiştirilecek';
$string['searchreplace_dlg:search_title'] = 'Bul';
$string['searchreplace_dlg:searchnext_desc'] = 'Tekrar ara';
$string['searchreplace_dlg:up'] = 'Yukarı';
$string['settings'] = 'Genel Ayarlar';
$string['simple:bold_desc'] = 'Kalın (Ctrl+B)';
$string['simple:bullist_desc'] = 'Madde işaretli liste ekle/kaldır';
$string['simple:cleanup_desc'] = 'Dağınık kodu temizle';
$string['simple:italic_desc'] = 'Eğik (Ctrl+I)';
$string['simple:numlist_desc'] = 'Numaralı liste ekle/kaldır';
$string['simple:redo_desc'] = 'Tekrarla (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Ortası çizgili';
$string['simple:underline_desc'] = 'Altı çizgili (Ctrl+U)';
$string['simple:undo_desc'] = 'Geri al (Ctrl+Z)';
$string['spellchecker:desc'] = 'İmla kontrolünü aç/kapa';
$string['spellchecker:ignore_word'] = 'Sözcüğü önemseme';
$string['spellchecker:ignore_words'] = 'Hiçbirini önemseme';
$string['spellchecker:langs'] = 'Diller';
$string['spellchecker:learn_word'] = 'Kelimeyi öğren';
$string['spellchecker:menu'] = 'İmla kontrol ayarları';
$string['spellchecker:no_mpell'] = 'Bir imla hatası bulunamadı.';
$string['spellchecker:no_sug'] = 'Öneri yok';
$string['spellchecker:sug'] = 'Öneriler';
$string['spellchecker:wait'] = 'Lütfen bekleyiniz...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'CSS stili düzenle';
$string['style_dlg:apply'] = 'Uygula';
$string['style_dlg:background'] = 'Arka plan';
$string['style_dlg:background_attachment'] = 'Eklenti';
$string['style_dlg:background_color'] = 'Arkaplan rengi';
$string['style_dlg:background_hpos'] = 'Yatay konum';
$string['style_dlg:background_image'] = 'Arkaplan resmi';
$string['style_dlg:background_repeat'] = 'Tekrarla';
$string['style_dlg:background_tab'] = 'Arkaplan';
$string['style_dlg:background_vpos'] = 'Dikey konum';
$string['style_dlg:block'] = 'Blok';
$string['style_dlg:block_display'] = 'Görüntüleme';
$string['style_dlg:block_letterspacing'] = 'Harf boşluğu';
$string['style_dlg:block_tab'] = 'Blok';
$string['style_dlg:block_text_align'] = 'Metin hizalama';
$string['style_dlg:block_text_indent'] = 'Metin kaydırma';
$string['style_dlg:block_vertical_alignment'] = 'Dikey hizalama';
$string['style_dlg:block_whitespace'] = 'Beyaz boşluk';
$string['style_dlg:block_wordspacing'] = 'Sözcük boşluğu';
$string['style_dlg:border'] = 'Kenar';
$string['style_dlg:border_tab'] = 'Kenarlık';
$string['style_dlg:bottom'] = 'Alt';
$string['style_dlg:box'] = 'Kutu';
$string['style_dlg:box_clear'] = 'Serbest';
$string['style_dlg:box_float'] = 'Kayan';
$string['style_dlg:box_height'] = 'Yükseklik';
$string['style_dlg:box_tab'] = 'Kutu';
$string['style_dlg:box_width'] = 'Genişlik';
$string['style_dlg:bullet_image'] = 'Madde imi resmi';
$string['style_dlg:clip'] = 'Kırpma';
$string['style_dlg:color'] = 'Renk';
$string['style_dlg:height'] = 'Yükseklik';
$string['style_dlg:left'] = 'Sol';
$string['style_dlg:list'] = 'Liste';
$string['style_dlg:list_tab'] = 'Liste';
$string['style_dlg:list_type'] = 'Tip';
$string['style_dlg:margin'] = 'Kenar boşluğu';
$string['style_dlg:overflow'] = 'Taşma';
$string['style_dlg:padding'] = 'Dolgu';
$string['style_dlg:placement'] = 'Yerleştirme';
$string['style_dlg:position'] = 'Konum';
$string['style_dlg:positioning_tab'] = 'Konumlandırma';
$string['style_dlg:positioning_type'] = 'Tip';
$string['style_dlg:right'] = 'Sağ';
$string['style_dlg:same'] = 'Tümü için aynı';
$string['style_dlg:style'] = 'Stil';
$string['style_dlg:text'] = 'Metin';
$string['style_dlg:text_blink'] = 'Yanıp sön';
$string['style_dlg:text_case'] = 'Büyük/küçük';
$string['style_dlg:text_color'] = 'Renk';
$string['style_dlg:text_decoration'] = 'Dekorasyon';
$string['style_dlg:text_font'] = 'Yazı Tipi';
$string['style_dlg:text_lineheight'] = 'Satır yüksekliği';
$string['style_dlg:text_none'] = 'Hiçbiri';
$string['style_dlg:text_overline'] = 'Üst çizgi';
$string['style_dlg:text_props'] = 'Metin';
$string['style_dlg:text_size'] = 'Boyut';
$string['style_dlg:text_striketrough'] = 'Ortası çizgili';
$string['style_dlg:text_style'] = 'Stil';
$string['style_dlg:text_tab'] = 'Metin';
$string['style_dlg:text_underline'] = 'Alt çizgi';
$string['style_dlg:text_variant'] = 'Değişken';
$string['style_dlg:text_weight'] = 'Kalınlık';
$string['style_dlg:title'] = 'CSS stili düzenle';
$string['style_dlg:toggle_insert_span'] = 'Seçime span ekleyin';
$string['style_dlg:top'] = 'Üst';
$string['style_dlg:visibility'] = 'Görünürlük';
$string['style_dlg:width'] = 'Genişlik';
$string['style_dlg:zindex'] = 'Z-sırası';
$string['subplugintype_tinymce'] = 'Eklenti';
$string['subplugintype_tinymce_plural'] = 'Eklentiler';
$string['table:cell'] = 'Hücre';
$string['table:cell_desc'] = 'Tablo hücre özellikler';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Kolon';
$string['table:col_after_desc'] = 'Sağına bir kolon ekle';
$string['table:col_before_desc'] = 'Soluna bir kolon ekle';
$string['table:copy_row_desc'] = 'Tablo satırını kopyala';
$string['table:cut_row_desc'] = 'Tablo satırını kes';
$string['table:del'] = 'Tabloyu sil';
$string['table:delete_col_desc'] = 'Sütunu sil';
$string['table:delete_row_desc'] = 'Satırı sil';
$string['table:desc'] = 'Tablo ekle/düzenle';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Tablo hücrelerini birleştir';
$string['table:paste_row_after_desc'] = 'Altına tablo satırını yapıştır';
$string['table:paste_row_before_desc'] = 'Üstüne tablo satırını yapıştır';
$string['table:props_desc'] = 'Tablo özellikleri';
$string['table:row'] = 'Satır';
$string['table:row_after_desc'] = 'Altına bir satır ekle';
$string['table:row_before_desc'] = 'Üstüne bir satır ekle';
$string['table:row_desc'] = 'Tablo satır özellikleri';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Birleştirilmiş tablo hücrelerini ayır';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = 'Gelişmiş özellikler';
$string['table_dlg:advanced_tab'] = 'Gelişmiş';
$string['table_dlg:align'] = 'Hizalama';
$string['table_dlg:align_bottom'] = 'Alt';
$string['table_dlg:align_default'] = 'Varsayılan';
$string['table_dlg:align_left'] = 'Sola';
$string['table_dlg:align_middle'] = 'Ortala';
$string['table_dlg:align_right'] = 'Sağa';
$string['table_dlg:align_top'] = 'Üst';
$string['table_dlg:bgcolor'] = 'Arkaplan rengi';
$string['table_dlg:bgimage'] = 'Arkaplan resmi';
$string['table_dlg:border'] = 'Kenarlık';
$string['table_dlg:bordercolor'] = 'Kenarlık rengi';
$string['table_dlg:caption'] = 'Tablo başlığı';
$string['table_dlg:cell_all'] = 'Tablodaki tüm hücreleri güncelle';
$string['table_dlg:cell_cell'] = 'Seçili hücreyi güncelle';
$string['table_dlg:cell_col'] = 'Sütundaki tüm hücreleri güncelle';
$string['table_dlg:cell_limit'] = 'Maksimum hücre sayısı olan {$cells} değerini aştınız.';
$string['table_dlg:cell_row'] = 'Satırdaki tüm hücreleri güncelle';
$string['table_dlg:cell_title'] = 'Tablo hücre özellikleri';
$string['table_dlg:cell_type'] = 'Hücre tipi';
$string['table_dlg:cellpadding'] = 'Hücre dolgusu';
$string['table_dlg:cellspacing'] = 'Hücre aralama';
$string['table_dlg:col_limit'] = 'Maksimum kolon sayısı olan {$cols} değerini aştınız.';
$string['table_dlg:colgroup'] = 'Sütun Grubu';
$string['table_dlg:cols'] = 'Sütunlar';
$string['table_dlg:frame'] = 'Çerçeve';
$string['table_dlg:frame_all'] = 'tümü';
$string['table_dlg:frame_cols'] = 'kolonlar';
$string['table_dlg:frame_groups'] = 'gruplar';
$string['table_dlg:frame_none'] = 'hiçbiri';
$string['table_dlg:frame_rows'] = 'satırlar';
$string['table_dlg:general_props'] = 'Genel özellikler';
$string['table_dlg:general_tab'] = 'Genel';
$string['table_dlg:height'] = 'Yükseklik';
$string['table_dlg:id'] = 'Kimlik';
$string['table_dlg:langcode'] = 'Dil kodu';
$string['table_dlg:langdir'] = 'Dil yönelimi';
$string['table_dlg:ltr'] = 'Soldan sağa';
$string['table_dlg:merge_cells_title'] = 'Tablo hücrelerini birleştir';
$string['table_dlg:mime'] = 'Hedef MIME tipi';
$string['table_dlg:missing_scope'] = 'Bu tablo başlık hücresi için bir kapsam belirlemeden devam etmek istediğinizden emin misiniz? Bu değer olmadan, engelli kullanıcıların tabloda görüntülenen içeriği anlaması mümkün olmayabilir.';
$string['table_dlg:row_all'] = 'Tablodaki tüm satırları güncelle';
$string['table_dlg:row_even'] = 'Tablodaki çift nolu satırları güncele';
$string['table_dlg:row_limit'] = 'Maksimum satır sayısı olan {$rows} değerini aştınız.';
$string['table_dlg:row_odd'] = 'Tablodaki tek nolu satırları güncelle';
$string['table_dlg:row_row'] = 'Seçili satırı güncelle';
$string['table_dlg:row_title'] = 'Tablo satır özellikleri';
$string['table_dlg:rowgroup'] = 'Satır Grubu';
$string['table_dlg:rows'] = 'Satırlar';
$string['table_dlg:rowtype'] = 'Satır Türü';
$string['table_dlg:rtl'] = 'Sağdan sola';
$string['table_dlg:rules'] = 'Çizgiler';
$string['table_dlg:rules_above'] = 'üstünde';
$string['table_dlg:rules_below'] = 'altında';
$string['table_dlg:rules_border'] = 'kenarlık';
$string['table_dlg:rules_box'] = 'kutu';
$string['table_dlg:rules_hsides'] = 'solsağ';
$string['table_dlg:rules_lhs'] = 'soltaraf';
$string['table_dlg:rules_rhs'] = 'sağtaraf';
$string['table_dlg:rules_void'] = 'yok';
$string['table_dlg:rules_vsides'] = 'üstalt';
$string['table_dlg:scope'] = 'Kapsam';
$string['table_dlg:style'] = 'Stil';
$string['table_dlg:summary'] = 'Özet';
$string['table_dlg:tbody'] = 'Gövde';
$string['table_dlg:td'] = 'Veri';
$string['table_dlg:tfoot'] = 'Altlık';
$string['table_dlg:th'] = 'Başlık';
$string['table_dlg:thead'] = 'Başlık';
$string['table_dlg:title'] = 'Tablo ekle/düzenle';
$string['table_dlg:valign'] = 'Dikey hizalama';
$string['table_dlg:width'] = 'Genişlik';
$string['template:desc'] = 'Öntanımlı şablon içeriği ekle';
$string['template_dlg:cdate_format'] = '%d-%m-%Y %H:%M:%S';
$string['template_dlg:day_long'] = 'Pazar,Pazartesi,Salı,Çarşamba,Perşembe,Cuma,Cumartesi,Pazar';
$string['template_dlg:day_short'] = 'Paz,Pzt,Sal,Çrş,Per,Cum,Cts,Paz';
$string['template_dlg:desc'] = 'Öntanımlı şablon içeriği ekle';
$string['template_dlg:desc_label'] = 'Tanım';
$string['template_dlg:label'] = 'Şablon';
$string['template_dlg:mdate_format'] = '%d-%m-%Y %H:%M:%S';
$string['template_dlg:months_long'] = 'Ocak,Şubat,Mart,Nisan,Mayıs,Haziran,Temmuz,Ağustos,Eylül,Ekim,Kasım,Aralık';
$string['template_dlg:months_short'] = 'Oca,Şub,Mar,Nis,May,Haz,Tem,Ağu,Eyl,Eki,Kas,Ara';
$string['template_dlg:preview'] = 'Önizleme';
$string['template_dlg:select'] = 'Bir şablon seç';
$string['template_dlg:title'] = 'Şablonlar';
$string['template_dlg:warning'] = 'Uyarı: Bir şablonu bir diğeriyle güncellemek veri kaybına yol açabilir.';
$string['visualblocks:desc'] = 'Blok unsurlarını göster/gizle';
$string['visualchars:desc'] = 'Görsel kontrol karakterleri açık/kapalı.';
$string['wordcount:words'] = 'Kelimeler:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Kısaltma';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Kısa ad';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Nitelik ekle/düzenle';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Kaynak';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Silme';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Ekleme';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Nitelikler';
$string['xhtmlxtras_dlg:attribs_title'] = 'Nitelik ekle/düzenle';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Nitelikler';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Olaylar';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Erişim Anahtarı';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Belirt';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Sınıf';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Tarih/Zaman';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Dil';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Metin yönü';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Stil';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Sekme İndeksi';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Başlık';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Soldan sağa';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Sağdan sola';
$string['xhtmlxtras_dlg:events_tab'] = 'Olaylar';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Öğe nitelikleri';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Öğe olayları';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Genel ayarlar';
$string['xhtmlxtras_dlg:general_tab'] = 'Genel';
$string['xhtmlxtras_dlg:insert_date'] = 'Şimdiki tarih/zamanı ekle';
$string['xhtmlxtras_dlg:option_ltr'] = 'Soldan sağa';
$string['xhtmlxtras_dlg:option_rtl'] = 'Sağdan sola';
$string['xhtmlxtras_dlg:remove'] = 'Kaldır';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Özet öğesi';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Kısaltma öğesi';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Atıf ögesi';
$string['xhtmlxtras_dlg:title_del_element'] = 'Silme öğesi';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Ekleme ögesi';
