<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'tr', version '5.0'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Yaklaşan Bigbluebuttonb oturumlarınız var.';
$string['bbbduetimeoverstartingtime'] = 'Kapanış saati, açılış saatinden sonra olmalıdır.';
$string['bbbdurationwarning'] = 'Bu oturum için maksimum süre,% duration% dakikadır.';
$string['bbbrecordallfromstartwarning'] = 'Bu oturum başlangıçtan itibaren kaydedilecek.';
$string['bbbrecordwarning'] = 'Bu oturum kaydedilmeye başlandı.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Yeni bir BigBlueButton odası ekleyin';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Canlı kayıt oturumu oluştur';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Kaydedilen oturum oluştur';
$string['bigbluebuttonbn:deleterecordings'] = 'Kayıtları Sil';
$string['bigbluebuttonbn:importrecordings'] = 'Kayıtları İçe aktar';
$string['bigbluebuttonbn:join'] = 'Bir BigBlueButton odasına katılın';
$string['bigbluebuttonbn:managerecordings'] = 'Kayıtları yönet';
$string['bigbluebuttonbn:protectrecordings'] = 'Kayıtları koruyun';
$string['bigbluebuttonbn:publishrecordings'] = 'Kayıtları yayınlayın';
$string['bigbluebuttonbn:seepresentation'] = 'Sunum dosyasını her zaman etkinlik sayfasında görün';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Kayıt korumasını kaldırın';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Kayıtları yayından kaldırın';
$string['bigbluebuttonbn:view'] = 'BigBlueButton odasını görüntüle';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Tüm kayıt formatlarını görüntüleyin';
$string['cachedef_currentfetch'] = 'En son alınan tüm kayıtları listelemek için gereken veriler.';
$string['cachedef_recordings'] = 'Kayıt üstverileri';
$string['cachedef_serverinfo'] = 'Uzak sunucu bilgileri';
$string['cachedef_subplugins'] = 'Gerektiğinde eklenti bulma sürecini hızlandırmak için alt eklenti rutinleri tarafından kullanılan önbellek.';
$string['cachedef_validatedurls'] = 'Doğrulanmış URL kontrollerinin önbelleği';
$string['calendarstarts'] = '{$a} şu tarih için ayarlandı';
$string['cannotperformaction'] = 'Bu kayıtta {$a} işlemi gerçekleştirilemiyor';
$string['completionattendance'] = 'Katılım zorunluluğu (dakika)';
$string['completionattendance_desc'] = 'Öğrenci odaya girmeli ve en az {$a} dakika oturumda kalmalıdır';
$string['completionattendance_event_desc'] = 'Öğrenci odaya girdi ve en az {$a} dakika bu oturumda kaldı';
$string['completionattendancegroup'] = 'Katılımı zorunlu tut (dakika)';
$string['completionengagement_desc'] = 'Öğrenci toplantı sırasında etkinliklere katılmalıdır';
$string['completionengagementchats'] = 'Sohbetler';
$string['completionengagementchats_desc'] = 'Öğrenci tamamlamak için {$a} sohbet(ler)e katılmalıdır.';
$string['completionengagementchats_event_desc'] = '{$a} sohbet yaptı';
$string['completionengagementemojis'] = 'Emojiler';
$string['completionengagementemojis_desc'] = 'Öğrenci, tamamlamak için anketlere {$a} emoji göndermelidir.';
$string['completionengagementemojis_event_desc'] = '{$a} emoji oluşturdu';
$string['completionengagementgroup'] = 'Katılım zorunlu kıl';
$string['completionengagementpollvotes'] = 'Anket sonuçları';
$string['completionengagementpollvotes_desc'] = 'Öğrenci, anketi tamamlamak için {$a} kez oy kullanmalıdır.';
$string['completionengagementpollvotes_event_desc'] = '{$a} oy topladı';
$string['completionengagementraisehand'] = 'Elini kaldırmayı zorunlu tut';
$string['completionengagementraisehand_desc'] = 'Öğrenci, tamamlamak için elini {$a} kez kaldırmalıdır.';
$string['completionengagementraisehand_event_desc'] = '{$a} kez el kaldırdı';
$string['completionengagementtalks'] = 'Konuşma';
$string['completionengagementtalks_desc'] = 'Öğrencinin tamamlaması için {$a} kez konuşması gerekir';
$string['completionengagementtalks_event_desc'] = '{$a} konuşma yaptı';
$string['completionupdatestate'] = 'Tamamlanma güncelleme durumu';
$string['completionvalidatestate'] = 'Tamamlanmayı doğrula';
$string['completionvalidatestatetriggered'] = 'Doğrulama tamamlama tetiklendi.';
$string['completionview_event_desc'] = 'Odayı izledi.';
$string['config_checksum_algorithm'] = 'BigBlueButton sunucu sağlama toplamı algoritması';
$string['config_checksum_algorithm_description'] = 'SHA1 eski sunucularla uyumludur. SHA256 ve SHA512 daha güvenlidir. SHA512, FIPS 140-2 uyumludur.';
$string['config_default_messages'] = 'Varsayılan Mesajlar';
$string['config_default_messages_description'] = 'Etkinlikler için mesaj varsayılanlarını ayarla';
$string['config_disablecam_default'] = 'Web kamerasını varsayılan olarak devre dışı bırak';
$string['config_disablecam_default_description'] = 'Web kamerasını varsayılan olarak devre dışı bırak';
$string['config_disablecam_editable'] = 'Web kamerasını düzeleyi devre dışı bırak';
$string['config_disablecam_editable_description'] = 'Web kamerasını varsayılan olarak devre dışı bırak, oturum eklendiğinde veya güncellendiğinde düzenlenebilir.';
$string['config_disablemic_default'] = 'Mikrofonu varsayılan olarak devre dışı bırak';
$string['config_disablemic_default_description'] = 'Etkinleştirilirse mikrofonlar devre dışı bırakılır.';
$string['config_disablemic_editable'] = 'Mikrofonu düzeleyi devre dışı bırak';
$string['config_disablemic_editable_description'] = 'Varsayılan olarak mikrofonu devre dışı bırak seçeneği, oturum eklendiğinde veya güncellendiğinde düzenlenebilir.';
$string['config_disablenote_default'] = 'Varsayılan olarak etkin durumdaki paylaşılan notları devre dışı bırakın';
$string['config_disablenote_default_description'] = 'Etkinleştirilirse, paylaşılan notlar devre dışı bırakılır.';
$string['config_disablenote_editable'] = 'Paylaşılan notları varsayılan olarak düzenlenmesini devre dışı bırak';
$string['config_disablenote_editable_description'] = 'Paylaşılan notları varsayılan olarak devre dışı bırak, oturum eklendiğinde veya güncellendiğinde düzenlenebilir.';
$string['config_disableprivatechat_default'] = 'Varsayılan olarak etkin olan özel sohbeti devre dışı bırak';
$string['config_disableprivatechat_default_description'] = 'Etkinleştirilirse özel sohbet devre dışı bırakılır.';
$string['config_disableprivatechat_editable'] = 'Özel sohbeti düzenlemeyi deve dışı bırak';
$string['config_disableprivatechat_editable_description'] = 'Özel sohbeti varsayılan olarak düzenlemeyi dışı bırak, oturum eklendiğinde veya güncellendiğinde düzenlenebilir.';
$string['config_disablepublicchat_default'] = 'Genel sohbeti varsayılan olarak devre dışı bırak';
$string['config_disablepublicchat_default_description'] = 'Etkinleştirildiğinde genel sohbet devre dışı bırakılır.


Etkinleştirildiğinde genel sohbet devre dışı bırakılır.';
$string['config_disablepublicchat_editable'] = 'Genel sohbetlein düzenlenmesin devre dışı bırak';
$string['config_disablepublicchat_editable_description'] = 'Genel sohbeti varsayılan olarak devre dışı bırak, oturum eklendiğinde veya güncellendiğinde düzenlenebilir.';
$string['config_experimental_features'] = 'Deneysel Özellikler';
$string['config_experimental_features_description'] = 'Deneysel özellikler için yapılandırma.';
$string['config_extended_capabilities'] = 'Gelişmiş özellikler';
$string['config_extended_capabilities_description'] = 'BigBlueButton sunucusu bunları sunduğunda genişletilmiş yetenekler için yapılandırma.';
$string['config_general'] = 'Genel yapılandırma';
$string['config_general_description'] = 'BigBlueButton\'ı kurmak için kendi BigBlueButton sunucunuzu ve kimlik bilgilerinizi kullanabilir veya <a href="https://registration-portal.blindsidenetworks.com/" target="_blank">Blindside Networks Kayıt Portalı (yeni bir pencerede açılır)</a> üzerinden kimlik bilgilerini edinebilirsiniz.';
$string['config_guestaccess_enabled'] = 'Harici konuk erişimi';
$string['config_guestaccess_enabled_description'] = 'Sitenizde hesabı olmayan kullanıcıların odaya erişmesine izin verin.';
$string['config_hideuserlist_default'] = 'Varsayılan olarak etkin olan kullanıcı listesini gizle';
$string['config_hideuserlist_default_description'] = 'Etkinleştirilirse, oturum kullanıcı listesi gizlenecektir.';
$string['config_hideuserlist_editable'] = 'Kullanıcı lisitesini düzenlemeyi gizle';
$string['config_hideuserlist_editable_description'] = 'Kullanıcı listesini varsayılan olarak gizle seçeneği, oturum eklendiğinde veya güncellendiğinde düzenlenebilir.';
$string['config_importrecordings'] = 'Kayıtları içe aktar';
$string['config_importrecordings_description'] = 'Bu ayarlar özelliğe özgüdür.';
$string['config_importrecordings_enabled'] = 'Kayıtları içeri aktarma etkinileştirildi';
$string['config_importrecordings_enabled_description'] = 'Bu ve kayıt özelliği etkinleştirildiğinde, farklı kurslardan kayıtları bir etkinliğe aktarmak mümkündür.';
$string['config_importrecordings_from_deleted_enabled'] = 'Silinen etkinliklerden kayıtları içe aktarma etkin';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Bu ve içe aktarma kaydı özelliği etkinleştirildiğinde, artık kursta olmayan etkinliklerden kayıtları içe aktarmak mümkündür.';
$string['config_locksettings'] = 'Kilitleme ayarları için yapılandırma';
$string['config_locksettings_description'] = 'Bu ayarlar, kilitleme ayarları için kullanıcı arayüzündeki seçenekleri etkinleştirir veya devre dışı bırakır ve ayrıca bu seçenekler için varsayılan değerleri tanımlar.';
$string['config_meetingevents_enabled'] = 'Canlı oturumları kaydet';
$string['config_meetingevents_enabled_description'] = 'Etkinleştirilirse, canlı oturumlar oturum sona erdikten sonra işlenir. Bu özellik, Aktivitenin tamamlanması için gereklidir ve yalnızca BigBlueButton sunucusu, post_events komut dosyalarını işleyebiliyorsa çalışır.';
$string['config_muteonstart'] = 'Başlangıçta sesi kapat';
$string['config_muteonstart_default'] = 'Başlangıçta sessiz varsayılan olarak etkindir';
$string['config_muteonstart_default_description'] = 'Başlangıçta sessiz varsayılan olarak etkindir';
$string['config_muteonstart_description'] = 'Bu ayarlar kullanıcı arayüzündeki seçenekleri etkinleştirir veya devre dışı bırakır ve ayrıca bu seçenekler için varsayılan değerleri tanımlar.';
$string['config_muteonstart_editable'] = 'Başlangıçta sessiz düzenlenebilir';
$string['config_muteonstart_editable_description'] = 'Varsayılan olarak başlangıçta sessize alma özelliği, örnek eklendiğinde veya güncellendiğinde düzenlenebilir.';
$string['config_participant'] = 'Katılımcılar';
$string['config_participant_description'] = 'Bu ayarlar, katılımcılar için varsayılan rolü tanımlar.';
$string['config_participant_moderator_default'] = 'Moderatör';
$string['config_participant_moderator_default_description'] = 'Bu kural, yeni bir oda eklendiğinde varsayılan olarak kullanılır.';
$string['config_poll_interval'] = 'Odanın durumunu yenilemek için yoklama aralığı (saniye cinsinden)';
$string['config_poll_interval_description'] = 'Yoklama aralığı en az 2 saniye olmalıdır. Gerekirse, aralığı artırarak uzak sunucudaki yükü azaltabilirsiniz.';
$string['config_presentation_default'] = 'Varsayılan sunum dosyası';
$string['config_presentation_default_description'] = 'Tüm odalarda kullanılmak üzere bir dosya sağlanabilir.';
$string['config_preuploadpresentation'] = 'Sunumu dosyası';
$string['config_preuploadpresentation_description'] = 'Bu ayarlar kullanıcı arayüzündeki seçenekleri etkinleştirir veya devre dışı bırakır ayrıca bu seçenekler için varsayılan değerleri tanımlar. Bu özellik yalnızca Moodle sunucusuna BigBlueButton tarafından erişilebiliyorsa çalışır.';
$string['config_preuploadpresentation_editable'] = 'Etkinlik sayfasındaki sunum dosyası';
$string['config_preuploadpresentation_editable_description'] = 'Etkinlik ayarlarında, etkinlik sayfasında gösterilecek sunum dosyasını yükleme seçeneği.';
$string['config_profile_picture_enabled'] = 'Profil resimlerini göster';
$string['config_profile_picture_enabled_description'] = 'BigBlueButton oturumlarında katılımcıların profil resimleri gösterilsin mi?';
$string['config_recording'] = 'Kaydediliyor';
$string['config_recording_all_from_start_default'] = 'Kaydı en baştan başlat';
$string['config_recording_all_from_start_default_description'] = 'Yeni bir BigBlueButton odası eklerken \'Kayda baştan başla\' ayarı varsayılan olarak etkinleştirilmeli mi?';
$string['config_recording_all_from_start_editable'] = 'Başlangıçtan itibaren tüm kayıtlar düzenlenebilir';
$string['config_recording_all_from_start_editable_description'] = 'BigBlueButton etkinlik ayarlarında \'Kaydı baştan başlat\' seçeneği düzenlenebilir olacak mı?';
$string['config_recording_default'] = 'Kayıt özelliği varsayılan olarak etkindir';
$string['config_recording_default_description'] = 'Yeni bir BigBlueButton odası eklenirken \'Oturum kaydedilebilir\' ayarı varsayılan olarak etkinleştiriilsin mi?';
$string['config_recording_description'] = 'Bu ayarlar özelliğe özgüdür';
$string['config_recording_editable'] = 'Oturum kayıt özelliği düzenlenebilir';
$string['config_recording_editable_description'] = 'BigBlueButton etkinlik ayarlarında \'Oturum kaydedilebilir\' ifadesi düzenlenebilir olsun mu?';
$string['config_recording_hide_button_default'] = 'Kayıt düğmesini gizle';
$string['config_recording_hide_button_default_description'] = 'İşaretlenirse kayıt düğmesi gizlenir';
$string['config_recording_hide_button_editable'] = 'Kayıt düğmesini gizle düzenlenebilir';
$string['config_recording_hide_button_editable_description'] = 'BigBlueButton etkinlik ayarlarında \'Kaydı gizle düğmesi\' düzenlenebilir olsun mu?';
$string['config_recording_protect_editable'] = 'Korumalı kayıt durumu düzenlenebilir';
$string['config_recording_protect_editable_description'] = 'İşaretlenirse, arayüz kayıtları korumak/korumayı kaldırmak için bir seçenek içerir.';
$string['config_recording_refresh_period'] = 'Kayıt yenileme süresi (saniye cinsinden)';
$string['config_recording_refresh_period_description'] = 'BigBlueButton sunucusu bir kayıt için uzaktan bilgileri yenilemek üzere ne sıklıkta sorgulanacak?';
$string['config_recording_safe_formats'] = 'Herkes tarafından görülebilen kayıt formatları';
$string['config_recording_safe_formats_description'] = 'Herkes tarafından görüntülenebilen formatları seçin.
Diğer tüm biçimler yalnızca öğretmenler ve mod/bigbluebuttonbn:viewallrecordingformats ve mod/bigbluebuttonbn:managerecordings özelliklerine sahip diğer kullanıcılar tarafından görüntülenebilir.';
$string['config_recordingready_enabled'] = 'Kayıt hazır olduğunda bildirim gönder';
$string['config_recordingready_enabled_description'] = 'Etkinleştirilirse, bir kayıt bağlantısı mevcut olduğunda bir bildirim gönderilir. Bu özellik, post_publish_recording_ready_callback betiğinin BigBlueButton sunucusunda etkinleştirilmesini gerektirir.';
$string['config_recordings'] = 'Kayıtları göster';
$string['config_recordings_asc_sort'] = 'Kayıtları kronolojik sırayla listeleyin';
$string['config_recordings_asc_sort_description'] = 'Kayıtlar tarihe göre en yeni veya eneski şeklinde sıralanabilir. (önce en son kayıt).';
$string['config_recordings_deleted_default'] = 'Varsayılan olarak etkinleştirilmiş silinen etkinliklerin kayıtlarını dahil et';
$string['config_recordings_deleted_default_description'] = 'Etkinleştirilirse, kayıt tablosu o tarihten sonra silinmiş olan tüm etkinliklerin kayıtlarını içerecektir.';
$string['config_recordings_deleted_editable'] = 'Silinen etkinliklerden kayıtları dahil et özelliği düzenlenebilir';
$string['config_recordings_deleted_editable_description'] = 'Örnek eklendiğinde veya güncellendiğinde varsayılan olarak silinen etkinliklerden kayıtları dahil et düzenlenebilir.';
$string['config_recordings_description'] = 'Bu ayarlar özelliğe özgüdür';
$string['config_recordings_general'] = 'Kayıt ayarlarını göster';
$string['config_recordings_general_description'] = 'Bu ayarlar yalnızca kayıtları gösterirken kullanılır.';
$string['config_recordings_imported_default'] = 'Yalnızca içe aktarılan bağlantıları göster varsayılan olarak etkin';
$string['config_recordings_imported_default_description'] = 'Etkinleştirilirse, kayıt tablosu yalnızca kayıtların içe aktarılan bağlantılarını içerecektir.';
$string['config_recordings_imported_editable'] = 'Yalnızca içe aktarılan bağlantıları göster özelliği düzenlenebilir';
$string['config_recordings_imported_editable_description'] = 'Örnek eklendiğinde veya güncellendiğinde varsayılan olarak yalnızca içe aktarılan bağlantıları göster düzenlenebilir.';
$string['config_recordings_preview_default'] = 'Önizleme varsayılan olarak etkindir';
$string['config_recordings_preview_default_description'] = 'Etkinleştirilirse, tablo sunumun bir önizlemesini içerir';
$string['config_recordings_preview_editable'] = 'Önizleme özelliği düzenlenebilir';
$string['config_recordings_preview_editable_description'] = 'Önizleme özelliği, örnek eklendiğinde veya güncellendiğinde düzenlenebilir.';
$string['config_scheduled'] = 'Planlanmış oturumlar';
$string['config_scheduled_description'] = 'Bu ayarlar, planlanmış oturumlar için varsayılan davranışı tanımlar';
$string['config_scheduled_pre_opening'] = 'Açılış saatinden önce erişilebilir';
$string['config_scheduled_pre_opening_description'] = 'Planlanan açılış saatinden önce odanın açık kalacağı dakika cinsinden süre.';
$string['config_server_url'] = 'BigBlueButton Sunucu Bağlantısı';
$string['config_server_url_description'] = 'BigBlueButton sunucunuzun sunucu URL\'si';
$string['config_shared_secret'] = 'BigBlueButton paylaşılan parola';
$string['config_shared_secret_description'] = 'BigBlueButton sunucunuzun güvenlik sırrı.';
$string['config_showpresentation_default'] = 'Sunum dosyasını etkinlik sayfasında göster';
$string['config_showpresentation_default_description'] = 'Öğrencilerin oturumdan önce sunum dosyasına erişmeleri gerekiyor mu? Bu ayarın \'Sunum dosyasını her zaman etkinlik sayfasında gör\' özelliğine sahip kullanıcılar üzerinde hiçbir etkisi yoktur.';
$string['config_showpresentation_editable'] = '\'Sunum dosyasını etkinlik sayfasında göster\' seçeneği';
$string['config_showpresentation_editable_description'] = 'Etkinlik ayarlarında öğretmenlerin sunum dosyasını öğrencilere gösterip göstermeyeceğini seçme seçeneği.';
$string['config_uidelegation_enabled'] = 'Kullanıcı arayüzü yetkilendirmesi etkinleştirildi';
$string['config_uidelegation_enabled_description'] = 'Bu ayarlar, BigBlueButton sunucusuna UI temsilcisi seçmeyi etkinleştirir veya devre dışı bırakır.';
$string['config_userlimit'] = 'kullanıcı sınırı';
$string['config_userlimit_default'] = 'Kullanıcı sınırı varsayılan olarak etkin';
$string['config_userlimit_default_description'] = 'Yeni bir oda eklendiğinde bir oturumda varsayılan olarak izin verilen kullanıcı sayısı.  Sınırsız sayıda kullanıcıya izin vermek için 0 olarak ayarlayın.';
$string['config_userlimit_description'] = 'Bu ayarlar, kullanıcı arabirimindeki seçenekleri etkinleştirir veya devre dışı bırakır ve ayrıca bu seçenekler için varsayılan değerleri tanımlar.';
$string['config_userlimit_editable'] = 'Kullanıcı limiti özelliği düzenlenebilir';
$string['config_userlimit_editable_description'] = 'Oda veya konferans eklendiğinde veya güncellendiğinde varsayılan olarak kullanıcı sınırı değeri düzenlenebilir.';
$string['config_voicebridge'] = 'Ses köprüsü';
$string['config_voicebridge_description'] = 'Bu ayarlar, kullanıcı arabirimindeki seçenekleri etkinleştirir veya devre dışı bırakır ve ayrıca bu seçenekler için varsayılan değerleri tanımlar.';
$string['config_voicebridge_editable'] = 'Konferans ses köprüsü düzenlenebilir';
$string['config_voicebridge_editable_description'] = 'Konferans ses köprüsü numarası bir odaya kalıcı olarak atanabilir.  Atandığında, numara başka bir oda için kullanılamaz.';
$string['config_waitformoderator'] = 'Moderatörü bekleyin';
$string['config_waitformoderator_cache_ttl'] = 'Moderatör önbelleği TTL\'sini bekleyin (saniye)';
$string['config_waitformoderator_cache_ttl_description'] = 'Ağır bir müşteri yükünü desteklemek için bu eklenti bir önbellek kullanır.  Bu parametre, bir sonraki istek BigBlueButton sunucusuna gönderilmeden önce önbelleğin tutulacağı süreyi tanımlar.';
$string['config_waitformoderator_default'] = 'Moderatörün varsayılan olarak etkinleştirilmesini bekleyin';
$string['config_waitformoderator_default_description'] = 'Yeni bir BigBlueButton odası eklenirken \'Moderatörü bekle\' ayarı varsayılan olarak etkinleştirilmeli mi?';
$string['config_waitformoderator_description'] = 'Bu ayarlar özelliğe özgüdür';
$string['config_waitformoderator_editable'] = 'Moderatörün düzenlenebilir olmasını bekleyin';
$string['config_waitformoderator_editable_description'] = 'BigBlueButton etkinlik ayarlarında \'Moderatör bekleyin\' düzenlenebilir olmalı mı?';
$string['config_waitformoderator_ping_interval'] = 'Moderatör pingini bekleyin (saniye)';
$string['config_waitformoderator_ping_interval_description'] = 'Moderatörün odaya girip girmediğini kontrol etmek için sunucuya ne sıklıkla ping atılmalıdır?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton, kullanımdan kaldırılmış bir global değişkenle config.php\'yi kullanır.  Gelecekteki sürümlerde desteklenmeyeceği için lütfen dosyayı dönüştürün.';
$string['config_warning_curl_not_installed'] = 'Bu özellik, php için CURL uzantısının kurulu ve etkinleştirilmiş olmasını gerektirir.  Ayarlara yalnızca bu koşul yerine getirildiğinde erişilebilir.';
$string['config_welcome_default'] = 'Varsayılan karşılama mesajı';
$string['config_welcome_default_description'] = 'Katılımcılar odaya girdiğinde karşılama mesajı görüntülenir. Alan boş bırakılırsa, \'mod_form_field_welcome_default\' dil dizesi kullanılır.';
$string['config_welcome_editable'] = 'Varsayılan karşılama mesajı öğretmenler tarafından düzenlenebilir';
$string['config_welcome_editable_description'] = 'Örnek eklendiğinde veya güncellendiğinde karşılama mesajı düzenlenebilir';
$string['credentials_warning'] = 'Varsayılan sunucu kimlik bilgilerinin kullanımı yakında sona erecek (yeni kimlik bilgileri almak için yukarıdaki nota bakın).';
$string['end_session_confirm'] = 'Oturumu sonlandırmak istediğinize emin misiniz?';
$string['end_session_confirm_title'] = 'Oturum gerçekten sonlandırılsın mı?';
$string['end_session_notification'] = 'Oturum sona erdi.';
$string['ends_at'] = 'Bitiş';
$string['event_activity_created'] = 'Etkinlik oluşturuldu';
$string['event_activity_deleted'] = 'Etkinlik silindi';
$string['event_activity_updated'] = 'Etkinlik güncellendi';
$string['event_live_session'] = 'Canlı oturum etkinliği';
$string['event_meeting_created'] = 'Oturumu eklendi';
$string['event_meeting_ended'] = 'Oturumu zorla sona erdirildi';
$string['event_meeting_joined'] = 'Oturumu başladı';
$string['event_meeting_left'] = 'Toplantı bitti';
$string['event_recording_deleted'] = 'Kayıt silindi';
$string['event_recording_edited'] = 'Kayıt düzenlendi';
$string['event_recording_imported'] = 'Kayıt içe aktarıldı';
$string['event_recording_protected'] = 'Kayıt korumalı';
$string['event_recording_published'] = 'Kayıt yayınlandı';
$string['event_recording_unprotected'] = 'Kayıt korumasız';
$string['event_recording_unpublished'] = 'Kayıt yayınlanmadı';
$string['event_recording_viewed'] = 'Kayıtları görüntüleme';
$string['event_unknown'] = 'Bilinmeyen olay';
$string['general_error_cannot_create_meeting'] = 'Oturum oluşturulamıyor.';
$string['general_error_cannot_get_recordings'] = 'Kayıtlar alınamıyor.';
$string['general_error_no_answer'] = 'Boş yanıt.  Lütfen BigBlueButton sunucusunun URL\'sini kontrol edin VE BigBlueButton sunucusunun çalışıp çalışmadığını kontrol edin';
$string['general_error_not_allowed_to_create_instances'] = 'Kullanıcının herhangi bir örnek türü oluşturmasına izin verilmez.';
$string['general_error_not_found'] = 'Varlık bulunamadı : {$a}.';
$string['general_error_unable_connect'] = 'Boş yanıt.  Lütfen BigBlueButton sunucusunun URL\'sini kontrol edin VE BigBlueButton sunucusunun çalışıp çalışmadığını kontrol edin.';
$string['guest_invitation_full_message'] = 'Merhaba,
 <p>{$a->course_fullname} kursundaki <strong>{$a->name}</strong> BigBlueButton oturumuna davetlisiniz.</p>
 <p>Bağlantı: {$a->guestjoinurl}<br/>
 <p>Parola: {$a->guestpassword}</p>
 <p>Yardıma ihtiyacınız varsa lütfen {$a->sender} ile iletişime geçin.</p>';
$string['guest_invitation_small_message'] = 'Merhaba,

{$a->course_fullname} kursundaki {$a->name} BigBlueButton oturumuna davetlisiniz.

Bağlantı: {$a->guestjoinurl}
Şifre: {$a->guestpassword}

Yardıma ihtiyacınız varsa lütfen {$a->sender} ile iletişime geçin.';
$string['guest_invitation_subject'] = 'Davetiye: {$a->ad} oturumu {$a->course_fullname} içinde';
$string['guestaccess_activitynotfound'] = 'Etkinlik bulunamadı';
$string['guestaccess_add'] = 'Misafir Ekle';
$string['guestaccess_add_no_id'] = 'BigBlueButton örnek kimliği sağlanmadı.';
$string['guestaccess_copy_link'] = 'Bağlantıyı kopyala';
$string['guestaccess_copy_password'] = 'Şifreyi kopyala';
$string['guestaccess_emails'] = 'Misafir epostaları';
$string['guestaccess_emails_help'] = 'Virgülle ayrılmış e-posta adreslerinin bir listesi.';
$string['guestaccess_emails_invalidemail'] = 'Geçersiz e-posta: {$a}';
$string['guestaccess_feature_disabled'] = 'Misafir erişimi devre dışı bırakıldı.';
$string['guestaccess_invite_failure'] = '{$a->emails} davet edilirken {$a->errors} hatası.';
$string['guestaccess_invite_success'] = '{$a->emails} adresine bir davetiye gönderilecek.';
$string['guestaccess_join_meeting'] = 'Toplantıya katıl';
$string['guestaccess_meeting_invalid_password'] = 'Yanlış şifre';
$string['guestaccess_meeting_link'] = 'Görüşme bağlantısı';
$string['guestaccess_meeting_not_started'] = 'Toplantı henüz başlamadı.  Lütfen daha sonra tekrar gelin.';
$string['guestaccess_meeting_password'] = 'Toplantı şifresi';
$string['guestaccess_password'] = 'Şifre';
$string['guestaccess_title'] = 'Bu toplantıya konuk ekle';
$string['guestaccess_username'] = 'Misafir kullanıcı adı';
$string['index_confirm_end'] = 'Oturumu sonlandırmak istiyormusunuz?';
$string['index_disabled'] = 'deve dışı bırakıldı';
$string['index_enabled'] = 'etkinleştirildi';
$string['index_ending'] = 'Oturum sonlandırılıyor ... lütfen bekleyin';
$string['index_error_bbtn'] = 'BigBlueButton Kimliği {$a} yanlış';
$string['index_error_checksum'] = 'Bir kontrol işlemi hatası oluştu. Lütfen doğru şifreyi girip girmediğinizi kontrol edin.';
$string['index_error_forciblyended'] = 'Manuel olarak sonlandırıldığı için oturuma katılınamıyor.';
$string['index_error_noinstances'] = 'BigBlueButton odalarının hiçbir örneği yok';
$string['index_error_unable_display'] = 'Oturum görüntülenemiyor. Lütfen BigBlueButton sunucusunun adresini kontrol edin VE BigBlueButton sunucusunun çalışıp çalışmadığını kontrol edin.';
$string['index_heading'] = 'BigBlueButton Odaları';
$string['index_heading_actions'] = 'Eylem';
$string['index_heading_group'] = 'Grup';
$string['index_heading_moderator'] = 'Yöneticiler';
$string['index_heading_name'] = 'Odalar';
$string['index_heading_recording'] = 'Kayıtlar';
$string['index_heading_users'] = 'Kullanıcılar';
$string['index_heading_viewer'] = 'İzleyiciler';
$string['indicator:cognitivedepth'] = 'BigBlueButton bilişsel';
$string['indicator:cognitivedepth_help'] = 'Bu gösterge, öğrencinin bir BigBlueButton etkinliğinde ulaştığı bilişsel derinliğe dayanmaktadır.';
$string['indicator:socialbreadth'] = 'BigBlueButton sosyal';
$string['indicator:socialbreadth_help'] = 'Bu gösterge, öğrencinin bir BigBlueButton etkinliğinde ulaştığı sosyal genişliğe dayanmaktadır.';
$string['instance_type_default'] = 'Kaydedilen oda';
$string['instance_type_recording_only'] = 'Yalnızca kayıtlar';
$string['instance_type_room_only'] = 'Sadece oda';
$string['instanceprofilewithoutrecordings'] = 'Bu örnek profili, kayıtları görüntüleyemez';
$string['managebbbextplugins'] = 'BigBlueButton eklentilerini yönetme';
$string['messageprovider:instance_updated'] = 'BigBlueButton oturumu güncellendi';
$string['messageprovider:recording_ready'] = 'BigBlueButton kaydı mevcut';
$string['minute'] = 'dakika';
$string['minutes'] = 'dakika';
$string['mod_form_block_general'] = 'Genel';
$string['mod_form_block_guestaccess'] = 'Misafir erişimi';
$string['mod_form_block_participants'] = 'Canlı oturum sırasında atanan rol';
$string['mod_form_block_presentation'] = 'Sunum içeriği';
$string['mod_form_block_presentation_default'] = 'Sunum varsayılan içeriği';
$string['mod_form_block_record'] = 'Kayıt ayarları';
$string['mod_form_block_recordings'] = 'Kayıtları görüntüleme';
$string['mod_form_block_room'] = 'Oda ayarları';
$string['mod_form_block_schedule'] = 'Oturum zamanlaması';
$string['mod_form_field_closingtime'] = 'Kapat';
$string['mod_form_field_conference_name'] = 'Oturum adı';
$string['mod_form_field_disablecam'] = 'Web kameralarını devre dışı bırak';
$string['mod_form_field_disablemic'] = 'Mikofonları devre dışı bırak';
$string['mod_form_field_disablenote'] = 'Paylaşılan notları devre dışı bırak';
$string['mod_form_field_disableprivatechat'] = 'Özel sohbeti devre dışı bırak';
$string['mod_form_field_disablepublicchat'] = 'Genel sohbeti devre dışı bırak';
$string['mod_form_field_duration'] = 'Süre';
$string['mod_form_field_duration_help'] = 'Süre ayarı oturumu kaydını bitirmeden önceki süreyi aktif tutmak için maksimum süreyi ayarlayacak';
$string['mod_form_field_guestallowed'] = 'Konuk erişimine izin ver';
$string['mod_form_field_hideuserlist'] = 'Kullanıcı listesini gizle';
$string['mod_form_field_instanceprofiles'] = 'Oturum Türü';
$string['mod_form_field_instanceprofiles_help'] = 'Bir oturum kaydedilecekse, \'Kaydedilen oda\'yı, aksi halde \'Yalnızca oda\'yı seçin.  Bir oturum kaydedildikten sonra, başka oturum olmayacaksa \'Yalnızca kayıt\'ı seçin.';
$string['mod_form_field_intro'] = 'Tanım';
$string['mod_form_field_intro_help'] = 'Odanın kısa bir açıklaması.';
$string['mod_form_field_mustapproveuser'] = 'Katılan misafirlerin bir moderatör tarafından kabul edilmesi gerekir';
$string['mod_form_field_muteonstart'] = 'Başlangıçta sesi kapat';
$string['mod_form_field_name'] = 'Oda  adı';
$string['mod_form_field_nosettings'] = 'Ayarlar düzenlenemez';
$string['mod_form_field_openingtime'] = 'Aç';
$string['mod_form_field_participant_add'] = 'Katılımcı ekle';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Yönetici';
$string['mod_form_field_participant_bbb_role_viewer'] = 'İzleyici';
$string['mod_form_field_participant_list'] = 'Kalımcı';
$string['mod_form_field_participant_list_action_add'] = 'Ekle';
$string['mod_form_field_participant_list_action_remove'] = 'Kaldır';
$string['mod_form_field_participant_list_text_as'] = 'olarak';
$string['mod_form_field_participant_list_type_all'] = 'Tüm kullanıcılar eklendi';
$string['mod_form_field_participant_list_type_owner'] = 'Sahibi';
$string['mod_form_field_participant_list_type_role'] = 'Rol';
$string['mod_form_field_participant_list_type_user'] = 'Kullanıcı';
$string['mod_form_field_record'] = 'Oturum kaydedilebilir';
$string['mod_form_field_recordallfromstart'] = 'Tümünü baştan kaydet';
$string['mod_form_field_recordhidebutton'] = 'Kaydı gizle düğmesi';
$string['mod_form_field_recordings_deleted'] = 'Silinen etkinliklerden kayıtları dahil et';
$string['mod_form_field_recordings_html'] = 'Tabloyu düz HTML olarak göster';
$string['mod_form_field_recordings_imported'] = 'Yalnızca içe aktarılan bağlantıları göster';
$string['mod_form_field_recordings_preview'] = 'Kayıt önizlemesini göster';
$string['mod_form_field_room_name'] = 'Oda ismi';
$string['mod_form_field_showpresentation'] = 'Sunum dosyasını etkinlik sayfasında göster';
$string['mod_form_field_userlimit'] = 'Kullanıcı sınırı';
$string['mod_form_field_userlimit_help'] = 'Bir oturumda izin verilen maksimum kullanıcı sayısı.  Sınırsız sayıda kullanıcıya izin vermek için 0 olarak ayarlayın.';
$string['mod_form_field_voicebridge'] = 'Ses köprüsü [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Format hatası.  1 ile 9999 arasında bir sayı girmelisiniz.';
$string['mod_form_field_voicebridge_help'] = 'Katılımcıların arayarak katılmayı kullanırken sesli oturuma katılmak için girdiği 1 ile 9999 arasında bir sayı.  Değer 0 ise, statik ses köprüsü numarası göz ardı edilecek ve BigBlueButton tarafından rastgele bir sayı üretilecektir.  7 rakamı yazılan dört hanenin önüne gelir.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Benzersiz bir değer değil.  Bu numara başka bir oda tarafından kullanılıyor.';
$string['mod_form_field_wait'] = 'İzleyiciler moderatör katılana kadar beklesinler';
$string['mod_form_field_wait_help'] = 'Katılımcıların odaya girmeden önce bir moderatör beklemesi gerekiyor mu?';
$string['mod_form_field_welcome'] = 'Hoş geldin mesajı';
$string['mod_form_field_welcome_default'] = '%%CONFNAME%%\'e hoş geldiniz.';
$string['mod_form_field_welcome_help'] = 'Katılımcılar odaya girdiğinde karşılama mesajı görüntülenir. Alan boş bırakılırsa, site yönetiminde ayarlanan varsayılan bir mesaj görüntülenir.';
$string['mod_form_locksettings'] = 'Kilit ayarları';
$string['modulename'] = 'BigBlueButtonBN';
$string['modulename_help'] = 'BigBlueButton, ses, video, sohbet, slaytlar, ekran paylaşımı, çok kullanıcılı beyaz tahta, ara odaları, anket ve emojilerin gerçek zamanlı paylaşımını destekleyen çevrimiçi öğrenme için tasarlanmış açık kaynaklı bir web konferans sistemidir.

BigBlueButton\'u kullanarak canlı çevrimiçi sınıflar, sanal ofis saatleri veya uzaktaki öğrencilerle grup işbirliği gibi oturumlar için bir oda oluşturabilirsiniz. Oturum daha sonra oynatılmak üzere kaydedilebilir.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton etkinliği';
$string['new_bigblubuttonbn_activities'] = 'BigBlueButton etkinliği';
$string['nosuchinstance'] = '{$a->id} kimliğine sahip böyle bir {$a->entity} örneği yok';
$string['notification_instance_created_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton odası oluşturuldu.';
$string['notification_instance_created_small'] = '{$a->name} adlı yeni bir BigBlueButton odası oluşturuldu.';
$string['notification_instance_created_subject'] = 'Yeni bir BigBlueButton odası oluşturuldu';
$string['notification_instance_description'] = 'Tanım';
$string['notification_instance_end_date'] = 'Bitiş tarihi';
$string['notification_instance_name'] = 'Başlık';
$string['notification_instance_start_date'] = 'Başlangıç tarihi';
$string['notification_instance_updated_intro'] = '<a href="{$a->link}">{$a->name}</a> BigBlueButton odası güncellendi.';
$string['notification_instance_updated_small'] = '{$a->name} BigBlueButton oturumu güncellendi';
$string['notification_instance_updated_subject'] = 'BigBlueButton odanız güncellendi';
$string['notification_recording_ready_html'] = 'BigBlueButton odasında <a href="{$a->link}">{$a->name}</a> oturum için artık bir kayıt mevcut.';
$string['notification_recording_ready_plain'] = '{$a->name} BigBlueButton odasındaki oturum için artık bir kayıt mevcut.  Kayıt bağlantısına erişmek için {$a->link} adresine gidin.';
$string['notification_recording_ready_small'] = '{$a->name} BigBlueButton odasındaki oturum için artık bir kayıt mevcut.  Kayıt bağlantısına erişmek için {$a->link} adresine gidin.';
$string['notification_recording_ready_subject'] = 'Kayıt mevcut';
$string['pluginadministration'] = 'BigBlueButton yönetimi';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'BigBlueButton oturumları oluşturmak ve oturumlara katılmak için, kullanıcı verilerinin sunucu ile değiş tokuş edilmesi gerekir.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'BigBlueButton sunucusuna erişen kullanıcının tam adı.';
$string['privacy:metadata:bigbluebutton:userid'] = 'BigBlueButton sunucusuna erişen kullanıcının kullanıcı kimliği.';
$string['privacy:metadata:bigbluebuttonbn'] = 'BigBlueButton oturum yapılandırması';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Kullanıcıların BigBlueButton oturumunda sahip olacağı rolü tanımlayan kuralların listesi.  Rol veya kullanıcı başına izinler verilebileceğinden, bir kullanıcı kimliği saklanabilir.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Eklentiyi kullanırken tetiklenen olayları saklar.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Kullanıcı tarafından tetiklenen olayın türü.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'Kullanıcının erişim sahibi olduğu oturum kimliği.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Oturum veya kayıtla ilgili ek bilgiler.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Günlüğün oluşturulduğu saat.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'Etkinliği tetikleyen kullanıcının kullanıcı kimliği.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Kayıtlarla ilgili meta verileri depolar.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'Bir kaydı en son değiştiren kullanıcının kullanıcı kimliği.';
$string['progress_createbigbluebuttonbn'] = 'BigBlueButton etkinliği oluşturuluyor ({$a})';
$string['recordingnotfound'] = 'Kayıt bulunamadı';
$string['recordings_from_deleted_activities'] = 'Silinen etkinliklerden kayıtlar';
$string['recordingurlnotfound'] = 'Kayıt URL\'si geçersiz.';
$string['removedevents'] = 'Silinen etkinlikler';
$string['removedlogs'] = 'Silinmiş özel günlükler';
$string['removedrecordings'] = 'Silinen kayıtlar';
$string['removedtags'] = 'Silinen kayıtlar';
$string['report_join_info'] = 'Odaya {$a} kez katıldı';
$string['report_play_recording_info'] = 'Bir kaydı {$a} kez oynattı';
$string['report_room_view'] = 'Odayı görüntüledi';
$string['resetevents'] = 'Etkinlikleri sil';
$string['resetlogs'] = 'Etkinlikleri sil';
$string['resetlogs_help'] = 'Günlüklerin silinmesi, kayıtlara yapılan referansların kaybolmasına neden olur.';
$string['resetrecordings'] = 'Kayıtları sil';
$string['resetrecordings_help'] = 'Kayıtları silmek, onları herhangi bir yerden erişilemez hale getirecektir.  Bu işlem geri alınamaz!';
$string['resettags'] = 'Etiketleri sil';
$string['search:activity'] = 'BigBlueButton - etkinlk bilgisi';
$string['search:tags'] = 'BigBlueButton - etiket bilgileri';
$string['sendnotification'] = 'Bildirim gönder';
$string['settings'] = 'BigBlueButton ayarları';
$string['settings_credential_warning'] = 'BigBlueButton sunucu kimlik bilgilerinin süresi yakında dolacak. <a href="{$a->settingslink}" target="_blank">BigBlueButton genel ayarlarına bakın (yeni pencerede açılır)</a>.';
$string['settings_credential_warning_no_capability'] = 'BigBlueButton sunucu kimlik bilgilerinin süresi yakında dolacaktır. Lütfen site yöneticinizle iletişime geçin.';
$string['started_at'] = 'Başladı';
$string['starts_at'] = 'Başlangıç';
$string['subplugintype_bbbext'] = 'BigBlueButton etkinlik eklentisi';
$string['subplugintype_bbbext_plural'] = 'BigBlueButton etkinlik eklentisi';
$string['taskname:check_dismissed_recordings'] = 'Henüz bulunmayan kayıtları kontrol edin';
$string['taskname:check_pending_recordings'] = 'Bekleyen kayıtları getir';
$string['userlimitreached'] = 'Oturuma katılmasına izin verilen kullanıcı sayısına ulaşıldı.';
$string['view_conference_action_end'] = 'Oturumu bitir';
$string['view_conference_action_join'] = 'Oturuma katıl';
$string['view_error_action_not_completed'] = 'Eylem tamamlanamadı';
$string['view_error_bigbluebutton'] = 'BigBlueButton hatalarla yanıt verdi.  {$a}';
$string['view_error_create'] = 'BigBlueButton sunucu bir hata mesajı dönderdi, oda eklenemedi.';
$string['view_error_current_state_not_found'] = 'Geçerli durum bulunamadı. Kayıt silinmiş olabilir veya BigBlueButton sunucusu gerçekleştirilen işlemle uyumlu olmayabilir.';
$string['view_error_import_no_courses'] = 'Geçerli durum bulunamadı.  Kayıt silinmiş olabilir veya BigBlueButton sunucusu gerçekleştirilen işlemle uyumlu olmayabilir.';
$string['view_error_import_no_recordings'] = 'Bu kursta içe aktarılacak kayıt yok.';
$string['view_error_invalid_session'] = 'Oturumun süresi doldu.  Etkinlik sayfasına geri dönün.';
$string['view_error_max_concurrent'] = 'İzin verilen eş zamanlı oturum sayısına ulaşıldı.';
$string['view_error_meeting_not_running'] = 'Bir şeyler yanlış gitti;  oturum çalışmıyor.';
$string['view_error_no_group'] = 'Henüz grup oluşturulmadı . Lütfen oturuma katılmadan önce gruplarınız oluşturun.';
$string['view_error_no_group_student'] = 'Henüz bir gruba katılımınız onaylanmadı. Lütfen öğretmen veya yöneticinizle görüşün.';
$string['view_error_no_group_teacher'] = 'Grup yok.  Bazı gruplar oluşturmanız gerekiyor.';
$string['view_error_unable_join'] = 'Odaya girilmiyor, Lütefen  BigBlueButton sunucunun adresini kontrol edin VE  BigBlueButton sunucusunun çalışıp çalışmadığını kontrol edin';
$string['view_error_unable_join_student'] = 'BigBlueButton sunucusuna bağlanılamıyor.';
$string['view_error_unable_join_teacher'] = 'BigBlueButton sunucusuna bağlanılamıyor. Lüften  yöneticinize başvurun.';
$string['view_error_url_missing_parameters'] = 'Bu URL\'de eksik parametreler var';
$string['view_error_userlimit_reached'] = 'Bir oturumda izin verilen kullanıcı sayısına ulaşıldı.';
$string['view_groups_nogroups_warning'] = 'Oda, grupları kullanmak için yapılandırıldı, ancak kursta tanımlanmış gruplar yok.';
$string['view_groups_notenrolled_warning'] = 'Oda, grupları kullanmak için yapılandırıldı, ancak siz bir grubun üyesi değilsiniz.';
$string['view_groups_selection'] = 'Katılmak istediğiniz grubu seçin ve eylemi onaylayın';
$string['view_groups_selection_join'] = 'Katıl';
$string['view_groups_selection_warning'] = 'Her grup için bir oda var ve senin birden fazlasına erişimin var. Doğru olanı seçtiğine emin ol.';
$string['view_login_moderator'] = 'Yönetici olarak giriş yapılıyor.....';
$string['view_login_viewer'] = 'İzleyici olarak giriş yapılıyor.....';
$string['view_message_and'] = 've';
$string['view_message_conference_has_ended'] = 'Bu oturum sonlandı.';
$string['view_message_conference_in_progress'] = 'Oturum devam ediyor.';
$string['view_message_conference_not_started'] = 'Bu oturum henüz başlamadı.';
$string['view_message_conference_room_ready'] = 'Konferans odası hazır. Şimdi oturuma katılabilirsiniz.';
$string['view_message_conference_user_limit_reached'] = 'Bir oturumda izin verilen kullanıcı sayısı sınırına ulaşıldı.';
$string['view_message_conference_wait_for_moderator'] = 'Moderatörün katılması bekleniyor.';
$string['view_message_cron_disabled'] = 'Kayıtların listesi güncel olmayabilir. Lütfen aşağıdaki bilgilerle site yöneticisi ile iletişime geçin: {$a}';
$string['view_message_finished'] = 'Bu etkinlik bitti.';
$string['view_message_has_joined'] = 'katıldı';
$string['view_message_have_joined'] = 'katıldı';
$string['view_message_hour'] = 'saat';
$string['view_message_hours'] = 'saat';
$string['view_message_importrecordings_disabled'] = 'Kayıtları aktar özelliği bu sunucuda devre dışı bırakıldı.';
$string['view_message_minute'] = 'dakika';
$string['view_message_minutes'] = 'dakika';
$string['view_message_moderator'] = 'Yönetici';
$string['view_message_moderators'] = 'moderatörler';
$string['view_message_norecordings'] = 'Gösterilecek kayıt yok.';
$string['view_message_notavailableyet'] = 'Bu oturum henüz müsait değil.';
$string['view_message_recordings_disabled'] = 'Sunucuda kayıtlar devre dışı bırakıldı. \'Sadece kayıt\' türündeki BigBlueButton etkinlikleri kullanılamaz.';
$string['view_message_room_closed'] = 'Bu oda kapandı';
$string['view_message_room_open'] = 'Bu oda açıldı';
$string['view_message_room_ready'] = 'Bu oda hazır';
$string['view_message_session_for'] = 'için oturum';
$string['view_message_session_has_user'] = 'Burada';
$string['view_message_session_has_users'] = 'Burada';
$string['view_message_session_no_users'] = 'Bu oturumda hiçbir kullanıcı yok';
$string['view_message_session_running_for'] = 'Bu oturum şu süredir çalışıyor:';
$string['view_message_session_started_at'] = 'Oturum şu anda başladı';
$string['view_message_tab_close'] = 'Bu sekme/pencere manuel olarak kapatılmalıdır';
$string['view_message_times'] = 'kere';
$string['view_message_user'] = 'Kullanıcı';
$string['view_message_users'] = 'Kullanıcılar';
$string['view_message_viewer'] = 'İzleyici';
$string['view_message_viewers'] = 'izleyiciler';
$string['view_mobile_message_groups_not_supported'] = 'Bu örnek, gruplarla çalışacak şekilde etkinleştirildi, ancak mobil uygulama henüz bunu desteklemiyor. Lütfen web sürümünü kullanın.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Bu sayfada 45 saniyeyi aştınız.  Oturuma katılmak için lütfen sayfayı yenileyin.';
$string['view_noguests'] = 'BigBlueButton odası konukların katılımına açık değil';
$string['view_nojoin'] = 'Bu örnek, gruplarla çalışacak şekilde etkinleştirildi, ancak mobil uygulama henüz bunu desteklemiyor.  Lütfen web sürümünü kullanın.';
$string['view_recording'] = 'kayıt';
$string['view_recording_actionbar'] = 'Araç çubuğu';
$string['view_recording_activity'] = 'Etkinlik';
$string['view_recording_button_import'] = 'Kayıt bağlantılarını içe aktar';
$string['view_recording_button_return'] = 'Geriye dön';
$string['view_recording_course'] = 'Kurs';
$string['view_recording_date'] = 'Tarih';
$string['view_recording_delete_confirmation'] = '{$a} öğesini silmek istediğinizden emin misiniz?';
$string['view_recording_delete_confirmation_warning_p'] = 'Bu kayıtta, farklı kurslara veya etkinliklere aktarılan ilişkili {$a} bağlantı var.  Kayıt silinirse bu bağlantılar da kaldırılacaktır.';
$string['view_recording_delete_confirmation_warning_s'] = 'Bu kayıt, farklı bir kursa veya etkinliğe aktarılmış ilişkili {$a} bağlantıya sahip. Kayıt silinirse bu bağlantı da kaldırılacaktır.';
$string['view_recording_description'] = 'Açıklama';
$string['view_recording_description_edithint'] = 'Kaydın tanımlanmasına yardımcı olmak için bir açıklama eklenebilir.';
$string['view_recording_description_editlabel'] = 'Açıklamayı Düzenle';
$string['view_recording_duration'] = 'Süre';
$string['view_recording_duration_min'] = 'dk';
$string['view_recording_format_errror_unreachable'] = 'Bu kayıt formatının URL\'sine ulaşılamıyor.';
$string['view_recording_format_notes'] = 'Notlar';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Sunum';
$string['view_recording_format_screenshare'] = 'Ekran Paylaşımı';
$string['view_recording_format_statistics'] = 'İstatistikler';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Bu kaydı içe aktarmak istediğinize emin misiniz?';
$string['view_recording_length'] = 'Uzunluk';
$string['view_recording_link'] = 'İçe aktarılan bağlantı';
$string['view_recording_link_warning'] = 'Bu, farklı bir kursta veya etkinlikte oluşturulmuş bir kayda yönlendiren bir bağlantıdır.';
$string['view_recording_list_action_delete'] = 'Siliniyor';
$string['view_recording_list_action_edit'] = 'Güncelleniyor';
$string['view_recording_list_action_play'] = 'Oynat';
$string['view_recording_list_action_process'] = 'İşleniyor';
$string['view_recording_list_action_protect'] = 'Korunuyor';
$string['view_recording_list_action_publish'] = 'Yayınlanıyor';
$string['view_recording_list_action_unprotect'] = 'Korunmuyor';
$string['view_recording_list_action_unpublish'] = 'Yayından kaldırılıyor';
$string['view_recording_list_action_update'] = 'Güncelleniyor';
$string['view_recording_list_actionbar'] = 'Araç çubuğu';
$string['view_recording_list_actionbar_delete'] = 'Sil';
$string['view_recording_list_actionbar_edit'] = 'Düzenle';
$string['view_recording_list_actionbar_hide'] = 'Gizle';
$string['view_recording_list_actionbar_import'] = 'İçe aktar';
$string['view_recording_list_actionbar_protect'] = 'Özel yap';
$string['view_recording_list_actionbar_publish'] = 'Yayınla';
$string['view_recording_list_actionbar_show'] = 'Göster';
$string['view_recording_list_actionbar_unprotect'] = 'Herkese açık yap';
$string['view_recording_list_actionbar_unpublish'] = 'Yayınlanmadı';
$string['view_recording_list_activity'] = 'Etkinlik';
$string['view_recording_list_course'] = 'Kurs';
$string['view_recording_list_date'] = 'Tarih';
$string['view_recording_list_description'] = 'Açıklama';
$string['view_recording_list_duration'] = 'Süre';
$string['view_recording_list_recording'] = 'Kayıt';
$string['view_recording_meeting'] = 'Toplantı';
$string['view_recording_modal_button'] = 'Uygula';
$string['view_recording_modal_title'] = 'Kayıt için değerleri ayarlayın';
$string['view_recording_name'] = 'İsim';
$string['view_recording_name_edithint'] = 'Kaydın tanımlanmasına yardımcı olmak için bir isim eklenebilir.';
$string['view_recording_name_editlabel'] = 'İsmi düzenle';
$string['view_recording_playback'] = 'Kayıttan yüütme';
$string['view_recording_preview'] = 'Önizleme';
$string['view_recording_preview_help'] = 'Tam boyutta görüntülemek için resmin üzerine tıklayın';
$string['view_recording_protect_confirmation'] = 'Bu {$a}\'yı korumak istediğinden emin misin?';
$string['view_recording_protect_confirmation_warning_p'] = 'Bu kayıtta, farklı kurslara veya etkinliklere aktarılan {$a} bağlantıları ilişkilendirilmiştir. Kayıt korumalıysa içe aktarılan bağlantıları da etkileyecektir.';
$string['view_recording_protect_confirmation_warning_s'] = 'Bu kayıtta, farklı kurslara veya etkinliklere aktarılan {$a} bağlantıları ilişkilendirilmiştir. Kayıt korumalıysa içe aktarılan bağlantıları da etkileyecektir.';
$string['view_recording_publish_confirmation'] = 'Bunu {$a} yayınlamak istediğinizden emin misiniz?';
$string['view_recording_publish_confirmation_warning_p'] = 'Bu kayıtta, farklı kurslara veya etkinliklere aktarılan {$a} bağlantıları var. Kayıt yayınlanırsa, bu bağlantılar da yayınlanacaktır.';
$string['view_recording_publish_confirmation_warning_s'] = 'Bu kayıt, farklı bir kursa veya etkinliğe aktarılan {$a} bağlantısıyla ilişkilendirilmiştir. Kayıt yayınlanırsa bu bağlantı da yayınlanır.';
$string['view_recording_publish_link_deleted'] = 'Orijinal kayıt BigBlueButton sunucusunda bulunmadığı için bu bağlantı yeniden yayınlanamaz. Bağlantı kaldırılmalıdır.';
$string['view_recording_publish_link_not_published'] = 'Kaydın aslı yayınlanmadığı için bu bağlantı yeniden yayınlanamaz.';
$string['view_recording_recording'] = 'Kayıt';
$string['view_recording_select_course'] = 'Önce açılır menüden bir kurs seçin';
$string['view_recording_tags'] = 'Etiketler';
$string['view_recording_unprotect_confirmation'] = 'Bu {$a}\'nın korumasını kaldırmak istediğinden emin misin?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Bu kayıtta, farklı kurslara veya etkinliklere aktarılmış {$a} bağlantıları vardır. Kayıt korumasızsa içe aktarılan bağlantıları da etkileyecektir.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Bu kayıtta, farklı kurslara veya etkinliklere aktarılmış {$a} bağlantıları vardır. Kayıt korumasızsa içe aktarılan bağlantıları da etkileyecektir.';
$string['view_recording_unprotect_link_deleted'] = 'Orijinal kayıt BigBlueButton sunucusunda bulunmadığından bu bağlantı korumasız bırakılamaz. Bağlantı kaldırılmalıdır.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Asıl kayıt korumalı olduğu için bu bağlantı korumasız bırakılamaz.';
$string['view_recording_unpublish_confirmation'] = 'Bu {$a} yayından kaldırmak istediğinizden emin misiniz?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Bu kayıtta, farklı kurslara veya etkinliklere aktarılan ilişkili {$a} bağlantı var. Kayıt yayından kaldırıldıysa, bu bağlantılar da yayından kaldırılacaktır.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Bu kayıt, farklı bir kursa veya etkinliğe aktarılmış ilişkili {$a} bağlantıya sahip. Kayıt yayından kaldırıldıysa, bu bağlantı da yayından kaldırılacaktır.';
$string['view_recording_yui_first'] = 'İlk';
$string['view_recording_yui_go'] = 'Git';
$string['view_recording_yui_last'] = 'Son';
$string['view_recording_yui_next'] = 'Önceki';
$string['view_recording_yui_page'] = 'Sayfa';
$string['view_recording_yui_prev'] = 'Önceki';
$string['view_recording_yui_rows'] = 'Satırlar';
$string['view_recording_yui_show_all'] = 'Tümünü göster';
$string['view_room'] = 'Odayı görüntüle';
$string['view_section_title_presentation'] = 'Sunum dosyası';
$string['view_section_title_recordings'] = 'Kayıtlar';
$string['waitformoderator'] = 'Bir moderatörün katılması bekleniyor.';
