<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'es_mx', version '5.0'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'a punto de ser instalado.';
$string['accept'] = 'Aceptar';
$string['action'] = 'Acción';
$string['actionchoice'] = '¿Qué deseas hacer con el archivo \'{$a}\'';
$string['actions'] = 'Acciones';
$string['actionsfor'] = 'Acciones para {$a}';
$string['actionsmenu'] = 'Menú de acciones';
$string['active'] = 'Activo';
$string['activeusers'] = 'Usuarios activos';
$string['activities'] = 'Actividades';
$string['activities_help'] = 'Las actividades (tales como foros,exámenes y wikis) posibilitan agregar contenidos interactivos al curso.';
$string['activity'] = 'Actividad';
$string['activityclipboard'] = 'Moviendo esta actividad: {$a}';
$string['activityheader'] = 'Menú de actividades';
$string['activityicon'] = 'icono para {$a}';
$string['activityiscurrentlyhidden'] = 'Lo sentimos, esta actividad está oculta actualmente';
$string['activitymodule'] = 'Módulo de actividad';
$string['activitymodules'] = 'Módulos de actividad';
$string['activitynotready'] = 'La actividad no está lista aún';
$string['activityorresource'] = 'Actividad o recurso';
$string['activityreport'] = 'Reporte de actividades';
$string['activityreports'] = 'Reportes de actividades';
$string['activityselect'] = 'Seleccionar esta actividad para ser movida a otro lugar';
$string['activitysince'] = 'Actividad desde {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Actividad por usuario';
$string['add'] = 'Añadir';
$string['addactivity'] = 'Añadir una actividad...';
$string['addactivitytosection'] = 'Añadir una actividad a la sección \'{$a}\'';
$string['addadmin'] = 'Añadir administrador';
$string['addblock'] = 'Añadir un bloque';
$string['addcomment'] = 'Añadir comentario';
$string['addcondition'] = 'Añadir condición';
$string['addcontent'] = 'Añadir contenido';
$string['addcountertousername'] = 'Crear usuario agregando un número al nombre de usuario';
$string['addcreator'] = 'Añadir creador de curso';
$string['adddots'] = 'Añadir...';
$string['added'] = 'Se añadió {$a}';
$string['addedtogroup'] = 'Añadido al grupo "{$a}"';
$string['addedtogroupnot'] = 'No se ha añadido al grupo "{$a}"';
$string['addedtogroupnotenrolled'] = 'No agregado al grupo "{$a}" porque no está inscrito en el curso';
$string['addfilehere'] = 'Arrastre los archivos aquí para añadirlos al final de esta sección';
$string['addfilesdrop'] = 'Usted puede arrastrar y soltar archivos aquí para subir o puede hacer clic para seleccionar.';
$string['addinganew'] = 'Nueva {$a}';
$string['addingdatatoexisting'] = 'Agregando información';
$string['additionalcustomnav'] = 'Navegación adicional personalizada';
$string['additionalnames'] = 'Nombres adicionales';
$string['addlinkhere'] = 'Añadir enlace aquí';
$string['addnew'] = 'Añadir un nuevo {$a}';
$string['addnewcategory'] = 'Añadir nueva categoría';
$string['addnewcourse'] = 'Añadir un nuevo curso';
$string['addnewuser'] = 'Añadir un nuevo usuario';
$string['addnousersrecip'] = 'Añadir usuarios que no han accedido a este {$a} a la lista de destinatarios';
$string['addpagehere'] = 'Añadir texto aquí';
$string['addresource'] = 'Añadir un recurso...';
$string['addresourceoractivity'] = 'Añadir una actividad o recurso';
$string['addresourcetosection'] = 'Añadir un recurso a la sección \'{$a}\'';
$string['address'] = 'Domicilio';
$string['addsections'] = 'Añadir secciones';
$string['addstudent'] = 'Añadir estudiante';
$string['addsubcategory'] = 'Añadir una subcategoría';
$string['addteacher'] = 'Añadir profesor';
$string['admin'] = 'Administrador';
$string['adminhelpaddnewuser'] = 'Para crear una nueva cuenta de usuario manualmente';
$string['adminhelpassignadmins'] = 'Los administradores pueden hacer lo que sea donde sea dentro del sitio';
$string['adminhelpassigncreators'] = 'Los creadores de curso pueden crear nuevos cursos';
$string['adminhelpassignsiteroles'] = 'Aplicar roles definidos del sitio a usuarios específicos';
$string['adminhelpassignstudents'] = 'Entrar a un curso y añadir estudiantes desde el menú de administración';
$string['adminhelpauthentication'] = 'Puede utilizar cuentas internas o bases de datos externas';
$string['adminhelpbackup'] = 'Configurar los respaldos automáticos y sus agendas';
$string['adminhelpconfiguration'] = 'Configurar la apariencia y el funcionamiento general del sitio';
$string['adminhelpconfigvariables'] = 'Configurar variables que inciden en la operación general del sitio';
$string['adminhelpcourses'] = 'Definir cursos y categorías y asignarles personas';
$string['adminhelpeditorsettings'] = 'Definir ajustes básicos del editor HTML';
$string['adminhelpedituser'] = 'Navegar por la lista de usuarios y editar cualquiera de ellos';
$string['adminhelpenvironment'] = 'Compruebe si su servidor cumple con los requisitos de instalación actuales y futuros.';
$string['adminhelpfailurelogs'] = 'Revisar bitácoras de ingresos fallidos';
$string['adminhelplanguage'] = 'Revisar y editar el presente idioma';
$string['adminhelplogs'] = 'Navegar por las bitácoras de toda la actividad del sitio';
$string['adminhelpmanageblocks'] = 'Manejar bloques instalados y sus ajustes';
$string['adminhelpmanagedatabase'] = 'Acceder directamente a la base de datos (¡cuidado!)';
$string['adminhelpmanagefilters'] = 'Seleccionar filtros de texto y su configuración';
$string['adminhelpmanagemodules'] = 'Administrar los módulos instalados y sus configuraciones';
$string['adminhelpmanageroles'] = 'Crear y definir roles que pueden aplicarse a los usuarios';
$string['adminhelpmymoodle'] = 'Configurar los bloques de Mi Moodle  (My Moodle) para usuarios';
$string['adminhelpreports'] = 'Reportes a nivel del sitio';
$string['adminhelpsitefiles'] = 'Para publicar archivos en general o subir respaldos externos';
$string['adminhelpsitesettings'] = 'Definir cómo se ve la página de inicio del sitio';
$string['adminhelpstickyblocks'] = 'Configurar bloques pegajosos (\'sticky\') para todo el sitio Moodle';
$string['adminhelpthemes'] = 'Elegir el estilo del sitio (colores, fuentes, etc.)';
$string['adminhelpuploadusers'] = 'Importar usuarios desde un archivo de texto';
$string['adminhelpusers'] = 'Definir los usuarios y configurar la autenticación';
$string['adminhelpxmldbeditor'] = 'Interfaz para editar archivos XMLDB. Sólo para desarrolladores.';
$string['administration'] = 'Administración';
$string['administrationsite'] = 'Administración del sitio';
$string['administrator'] = 'Administrador';
$string['administratordescription'] = 'Normalmente los administradores pueden hacer cualquier cosa en el sitio, en todos los cursos.';
$string['administrators'] = 'Administradores';
$string['administratorsall'] = 'Todos los administradores';
$string['administratorsandteachers'] = 'Administradores y profesores';
$string['advanced'] = 'Avanzada';
$string['advancedfilter'] = 'Búsqueda avanzada';
$string['advancedsettings'] = 'Ajustes avanzados';
$string['afterresource'] = 'Después del recurso "{$a}"';
$string['aftersection'] = 'Después de la sección "{$a}"';
$string['again'] = 'de nuevo';
$string['agelocationverification'] = 'Verificación de ubicación y edad';
$string['ajaxuse'] = 'AJAX y Javascript';
$string['all'] = 'Todos';
$string['allactions'] = 'Todas las acciones';
$string['allactivities'] = 'Todas las actividades';
$string['allcategories'] = 'Todas las categorías';
$string['allchanges'] = 'Todos los cambios';
$string['alldays'] = 'Todos los días';
$string['allfiles'] = 'Todos los archivos';
$string['allgroups'] = 'Todos los grupos';
$string['alllogs'] = 'Todas las bitácoras';
$string['allmods'] = 'Todos {$a}';
$string['allow'] = 'Permitir';
$string['allowinternal'] = 'Permitir también métodos internos';
$string['allownone'] = 'No permitir ninguno';
$string['allownot'] = 'No permitir';
$string['allowstealthmodules'] = 'Permitir  actividades sigilosas';
$string['allowstealthmodules_help'] = 'Si se habilita, las actividades pueden hacerse disponibles pero no mostradas en secciones visibles de la página del curso. Si así fuera, los enlaces hacia las actividades sigilosas deben de proporcionarse desde otro lado, como por ejemplo desde un recurso página. Las actividades sigilosas todavía están enlistadas en el Libro de calificaciones y en otros reportes.';
$string['allparticipants'] = 'Todos los participantes';
$string['allteachers'] = 'Todos los profesores';
$string['alphanumerical'] = 'Sólo puede contener caracteres alfanuméricos, guion (-) o punto (.)';
$string['alreadyconfirmed'] = 'El registro ya ha sido confirmado';
$string['alternatename'] = 'Nombre adicional';
$string['always'] = 'Siempre';
$string['and'] = '{$a->one} y {$a->two}';
$string['answer'] = 'Respuesta';
$string['any'] = 'Cualquiera';
$string['appearance'] = 'Apariencia';
$string['apply'] = 'Aplicar';
$string['applyfilters'] = 'Aplicar filtros';
$string['approve'] = 'Aprobar';
$string['areyousure'] = '¿Está Usted seguro?';
$string['areyousuretorestorethis'] = '¿Está seguro de que desea continuar?';
$string['areyousuretorestorethisinfo'] = 'Más adelante en este proceso tendrá la opción de agregar este respaldo a otro curso o utilizarla para crear un curso completamente nuevo.';
$string['asc'] = 'Ascendente';
$string['assessment'] = 'Evaluación';
$string['assignadmins'] = 'Asignar administradores';
$string['assigncreators'] = 'Asignar creadores';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Asignar roles para todo el sitio';
$string['authenticateduser'] = 'Usuario autenticado';
$string['authenticateduserdescription'] = 'Todos los usuarios que iniciaron sesión.';
$string['authentication'] = 'Autenticación';
$string['authenticationplugins'] = 'Plugins de autenticación';
$string['autosubscribe'] = 'Subscripción automática al foro';
$string['autosubscribeno'] = 'No, no me suscriba automáticamente a las discusiones del foro';
$string['autosubscribeyes'] = 'Sí, cuando yo envíe una publicación, suscríbame a esa discusión del foro';
$string['availability'] = 'Disponibilidad';
$string['availablecourses'] = 'Cursos disponibles';
$string['back'] = 'Atrás';
$string['backto'] = 'Regresar a {$a}';
$string['backtocourselisting'] = 'Volver a la lista de cursos';
$string['backtohome'] = 'Regresar a la página de inicio del sitio';
$string['backtopageyouwereon'] = 'Volver a la página de procedencia';
$string['backup'] = 'Copia de respaldo';
$string['backupactivehelp'] = 'Decida si se hacen o no respaldos automatizados';
$string['backupadhocpending'] = 'Trabajo ad-hoc de respaldo de curso pendiente';
$string['backupcancelled'] = 'Respaldo cancelado';
$string['backupcoursefileshelp'] = 'Si se activa, los archivos del curso se incluirán en los respaldos automatizadas';
$string['backupdate'] = 'Fecha del respaldo';
$string['backupdatenew'] = '{$a->TAG} es ahora {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} fue {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Detalles del respaldo';
$string['backuperrorinvaliddestination'] = 'La carpeta del destino del respaldo no existe o no es escribible.';
$string['backupexecuteathelp'] = 'Decida a qué hora se realizarán los respaldos automatizados';
$string['backupfailed'] = 'Algunos de sus cursos no han sido guardados.';
$string['backupfilename'] = 'respaldo';
$string['backupfinished'] = 'Respaldo completado exitosamente';
$string['backupfromthissite'] = '¿Se ha hecho respaldo en el sitio?';
$string['backupgradebookhistoryhelp'] = 'Si está habilitada la opción, la historia del libro de calificaciones se incluirá en los respaldos  automatizados. Advierta que la historia de calificaciones no debe estar desactivada en los ajustes del servidor (disablegradhistory) para que esta característica funcione.';
$string['backupincludemoduleshelp'] = 'Seleccione si desea incluir los módulos del curso, con o sin los datos de usuario, en los respaldos';
$string['backupincludemoduleuserdatahelp'] = 'Decida si quiere incluir datos del usuario del módulo en los respaldos automatizados.';
$string['backupinfo'] = 'Hacer una copia de este curso, incluyendo todo el contenido y actividad hasta ahorita. Usted puede usar el archivo de respaldo para restaurar el curso.';
$string['backuplogdetailed'] = 'Registro de ejecución detallado';
$string['backuploglaststatus'] = 'Último registro de ejecución';
$string['backupmissinguserinfoperms'] = 'Nota: Este respaldo no contiene datos de usuarios. Las actividades de Ejercicio y Taller no se incluirán en el respaldo, puesto que estos módulos no son compatibles con este tipo de respaldo.';
$string['backupnext'] = 'Siguiente respaldo';
$string['backupnonisowarning'] = 'ADVERTENCIA: este respaldo proviene de una versión de Moodle no Unicode (anterior a la 1.6). Si el respaldo contiene cualquier texto que no sea ISO-8859-1 puede CORROMPERSE si intenta restaurarla a esta versión Unicode de Moodle. Si desea más información sobre cómo recuperar correctamente el respaldo, puede consultar <a href="https://docs.moodle.org/en/Backup_FAQ">Backup FAQ.';
$string['backupnotyetrun'] = 'Respaldo automático pendiente';
$string['backuporiginalname'] = 'Nombre del respaldo';
$string['backuproleassignments'] = 'Respaldo de asignaciones de rol para estos roles';
$string['backupsavetohelp'] = 'Ruta completa hacia el directorio en el que Usted desea que se guarden los archivos de respaldo.';
$string['backupsitefileshelp'] = 'Si se activa esta opción, los archivos del sitio usados en los cursos se incluirán en los respaldos automatizados';
$string['backuptakealook'] = 'Por favor, examine las bitácoras de sus respaldos en: {$a}';
$string['backupuserfileshelp'] = 'Seleccione si desea incluir los archivos personales de los usuarios (e.g., imágenes) en los respaldos automáticos';
$string['backupversion'] = 'Versión del respaldo';
$string['badges'] = 'Insignias';
$string['between'] = 'Entre';
$string['block'] = 'Bloque';
$string['blockconfiga'] = 'Configurando un bloque {$a}';
$string['blockconfigbad'] = 'Este bloque no se ha implementado correctamente y por consiguiente no se puede proporcionar una interfaz de configuración.';
$string['blocks'] = 'Bloques';
$string['blocks_main'] = 'Bloques de contenido principal';
$string['blocks_supplementary'] = 'Bloques suplementarios';
$string['blocksaddedit'] = 'Añadir/Editar bloques';
$string['blockseditoff'] = 'Desactivar la edición de bloques';
$string['blocksediton'] = 'Activar la edición de bloques';
$string['blocksetup'] = 'Configurando tablas de bloque';
$string['blocksuccess'] = '{$a} tablas han sido configuradas correctamente';
$string['brief'] = 'Resumen';
$string['bulkactions'] = 'Acciones masivas';
$string['bulkactionselect'] = 'acción masiva {$a} seleccionada';
$string['bulkcancel'] = 'Cerrar edición masiva';
$string['bulkmovecoursessuccess'] = 'Se movieron exitosamente {$a->courses} cursos adentro de {$a->category}';
$string['bulkselection'] = '{$a} seleccionado(s)';
$string['bycourseorder'] = 'Por orden de curso';
$string['byname'] = 'por {$a}';
$string['bypassed'] = 'Evitado';
$string['cachecontrols'] = 'Controles de caché';
$string['calltofeedback'] = 'A los creadores de este software les gustaría su retroalimentación.';
$string['calltofeedback_give'] = 'Proporcionar retroalimentación acerca de este software';
$string['calltofeedback_remind'] = 'Recordarme después';
$string['cancel'] = 'Cancelar';
$string['cancelled'] = 'Cancelado';
$string['categories'] = 'Categorías';
$string['categoriesandcourses'] = 'Categorías de cursos y cursos';
$string['category'] = 'Categoría';
$string['categoryadded'] = 'Se instaló la categoría \'{$a}\'';
$string['categorybulkaction'] = 'Acciones masivas para categorías seleccionadas';
$string['categorycontents'] = 'Subcategorías y cursos';
$string['categorycurrentcontents'] = 'Contenidos de {$a}';
$string['categorydeleted'] = 'Se ha borrado la categoría \'{$a}\'';
$string['categoryduplicate'] = '¡Ya existe una categoría llamada \'{$a}\'!';
$string['categoryheader'] = 'Menú de categoría';
$string['categoryhidden'] = '(oculto)';
$string['categorymodifiedcancel'] = 'La categoría se ha modificado. Por favor, cancele y pruebe de nuevo.';
$string['categoryname'] = 'Nombre de la categoría';
$string['categorypath'] = 'Ruta de categoría';
$string['categorysubcategoryof'] = '{$a->category} - subcategoría de {$a->parentcategory}';
$string['categoryupdated'] = 'La categoría \'{$a}\' fue actualizada';
$string['changedpassword'] = 'Contraseña actualizada';
$string['changepassword'] = 'Cambiar contraseña';
$string['changesmade'] = 'Cambios hechos';
$string['changesmadereallygoaway'] = 'Usted ha realizado cambios. ¿Está seguro de querer navegar lejos de esta página y perder los cambios?';
$string['changessaved'] = 'Cambios actualizados';
$string['check'] = 'Revisar';
$string['checkactual'] = 'Actual';
$string['checkall'] = 'Comprobar todo';
$string['checkerror'] = 'Error al obtener resultado de comprobar \'{$a}\'. Revise la consola del navegador para más información.';
$string['checkexpected'] = 'Esperado';
$string['checkingbackup'] = 'Revisando respaldo';
$string['checkingcourse'] = 'Revisando el curso';
$string['checkingforbbexport'] = 'Comprobando exportación a Blackboard';
$string['checkinginstances'] = 'Revisando instancias';
$string['checkingsections'] = 'Revisando secciones';
$string['checklanguage'] = 'Revisar el idioma';
$string['checkloading'] = 'Obteniendo el resultado de comprobar \'{$a}\'';
$string['checknone'] = 'No comprobar nada';
$string['checks'] = 'Revisiones';
$string['checksok'] = 'Todas las comprobaciones de \'{$a}\' están correctas';
$string['childcoursenotfound'] = '¡Curso hijo no encontrado!';
$string['childcourses'] = 'Cursos hijo';
$string['choose'] = 'Elegir';
$string['choosecourse'] = 'Seleccione un curso';
$string['choosedots'] = 'Elegir...';
$string['chooselivelogs'] = 'O vea la actividad actual';
$string['chooselogs'] = 'Seleccione las bitácoras que desea ver';
$string['choosereportfilter'] = 'Elegir un filtro para el reporte';
$string['choosetheme'] = 'Elegir tema';
$string['chooseuser'] = 'Seleccionar un usuario';
$string['city'] = 'Ciudad';
$string['cleaningtempdata'] = 'Borrando archivos temporales';
$string['clear'] = 'Limpiar';
$string['clearall'] = 'Borrar todo';
$string['clearfilterrow'] = 'Quitar fila de filtro';
$string['clearfilters'] = 'Borrar filtros';
$string['clearsearch'] = 'Borrar entrada de búsqueda';
$string['clickhelpiconformoreinfo'] = '...continúa... Haga clic en el ícono de ayuda para leer el artículo completo';
$string['clickhere'] = 'Haga clic aquí...';
$string['clicktohideshow'] = 'Clic para expandir o colapsar';
$string['closeblockdrawer'] = 'Cerrar cajón del bloque';
$string['closebuttontitle'] = 'Cerrar';
$string['closecourseindex'] = 'Cerrar índice del curso';
$string['closedrawer'] = 'Cerrar cajón';
$string['closewindow'] = 'Cerrar esta ventana';
$string['collapse'] = 'Colapsar';
$string['collapseall'] = 'Colapsar todo';
$string['collapsecategory'] = 'Colapsar {$a}';
$string['comebacklater'] = 'Por favor regrese más tarde.';
$string['commentincontext'] = 'Encontrar este comentario en el contexto';
$string['comments'] = 'Comentarios';
$string['commentscount'] = 'Comentarios ({$a})';
$string['commentsnotenabled'] = 'La característica de Comentarios no está habilitada';
$string['commentsrequirelogin'] = 'Usted necesita iniciar sesión para ver los comentarios.';
$string['comparelanguage'] = 'Comparar y editar el presente idioma';
$string['complete'] = 'Completado';
$string['completed'] = 'Completado';
$string['completereport'] = 'Reporte completo';
$string['configuration'] = 'Configuración';
$string['confirm'] = 'Confirmar';
$string['confirmaccount'] = 'Confirmar cuenta';
$string['confirmcheckfull'] = '¿Está totalmente seguro que quiere confirmar a {$a}?';
$string['confirmcoursemove'] = '¿Está Usted seguro de querer mover este curso ({$a->course}) dentro de esta categoría ({$a->category}) ?';
$string['confirmdeletesection'] = '¿Está Usted absolutamente seguro de querer eliminar completamente "{$a}" y todas las actividades que contiene ?';
$string['confirmed'] = 'Registro confirmado';
$string['confirmednot'] = 'Su registro no se ha confirmado aún. Por favor busque en su correo un Email de confirmación.';
$string['considereddigitalminor'] = 'Usted es demasiado joven para crear una cuenta en este sitio.';
$string['contactsbyrolelist'] = '{$a->role}: {$a->contacts}';
$string['content'] = 'Contenido';
$string['contentbank'] = 'Banco de contenido';
$string['contentexport_aboutthiscourse'] = 'Resumen del curso';
$string['contentexport_coursesummary'] = 'Este archivo es parte del contenido descargado de <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'Este archivo es parte del contenido descargado de <a href="{$a->courselink}">{$a->coursename}</a> por {$a->userfullname} en {$a->date}.';
$string['contentexport_modulesummary'] = 'Esta página es parte del contenido descargado de <a href="{$a->modulelink}">{$a->modulename}</a> en {$a->date}. Tenga en cuenta que algunos contenidos y cualquier archivo mayor de  {$a->maxfilesize} no son descargados.';
$string['contentexport_viewfilename'] = 'Ver el archivo {$a}';
$string['context'] = 'Contexto';
$string['contextlevel'] = 'Nivel del contexto';
$string['contextname'] = 'Nombre del contexto';
$string['contextparent'] = 'Padre';
$string['contexturl'] = 'URL del contexto';
$string['continue'] = 'Continuar';
$string['continuetocourse'] = 'Haga clic aquí para entrar a su curso';
$string['convertingwikitomarkdown'] = 'Convirtiendo Wiki a Markdown';
$string['cookiesenabled'] = 'Las \'Cookies\' deben estar habilitadas en su navegador';
$string['cookiesenabled_help'] = 'Se emplean dos \'cookies\' en este sitio:

La \'cookie\' esencial es la \'cookie\' de sesión, usualmente llamada MoodleSession. Usted debe permitir esta \'cookie\' en su navegador para proporcionar continuidad y mantener su ingreso de una página a otra página. Cuando Usted se salga del sitio o cierre su navegador, esta \'cookie\' es destruida (en su navegador y en el servidor).


La otra \'cookie\' es meramente por conveniencia, y usualmente se llama algo así como MOODLEID. Únicamente recuerda su nombre de usuario dentro del navegador. Esto significa que cuando regrese al sitio, el campo para nombre de usuario en la página de ingreso estará previamente llenado para Usted. Es seguro rechazar esta \'cookie\' - simplemente tendrá que volver a escribir su nombre de usuario cada vez que inicie sesión .';
$string['cookiesenabled_help_html'] = 'En este sitio se usan dos \'cookies\':<br/><br/>

La esencial es la \'cookie\' de sesión, que usualmente se llama MoodleSession. Usted debe permitir esta \'cookie\' en su navegador para proporcionar continuidad y permanecer ingresado cuando navegue por el sitio. Cuando usted abandone el sitio o cierre el navegador, esta \'cookie\' es destruida (en su navegador y en el servidor).<br/><br/>

La otra \'cookie\' es meramente por conveniencia, usualmente se llama MOODLEID o similar. Solamente recuerda su nombre de usuario en el navegador. Esto significa que cuando usted regresa a este sitio, el campo del nombre de usuario en la página para ingresar al sitio ya está llenado para usted. Es seguro el rechazar esta \'cookie\' - usted simplemente tendrá que re-escribir su nombre de usuario cada vez que inicie sesión .';
$string['cookiesenabledonlysession'] = 'Las \'cookies\' deben estar habilitadas en su navegador';
$string['cookiesenabledonlysession_help'] = 'Este sitio usa una \'cookie\' de sesión, generalmente llamada MoodleSession. Debe permitir esta \'cookie\' en su navegador para proporcionar continuidad y mantenerse conectado al navegar por el sitio. Cuando salga del sitio o cierre el navegador, esta \'cookie\' es destruida (en su navegador y en el servidor).';
$string['cookiesnotenabled'] = 'Las \'cookies\' no están habilitadas en su navegador';
$string['cookiesnotice'] = 'Aviso sobre \'cookies\'';
$string['copy'] = 'copia';
$string['copyasnoun'] = 'copia';
$string['copycourse'] = 'Copiar curso';
$string['copyingcoursefiles'] = 'Copiando los archivos del curso';
$string['copyingsitefiles'] = 'Copiando los archivos del sitio usados en el curso';
$string['copyinguserfiles'] = 'Copiando los archivos de los usuarios';
$string['copyingzipfile'] = 'Copiando archivo zip';
$string['copyrightnotice'] = 'Copyright';
$string['copytoclipboard'] = 'Copiar al portapapeles';
$string['coresystem'] = 'Sistema';
$string['cost'] = 'Costo';
$string['costdefault'] = 'Costo por defecto';
$string['count_of_total'] = '<strong>{$a->count}</strong> de {$a->total}';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'País';
$string['course'] = 'Curso';
$string['courseadministration'] = 'Administración del curso';
$string['courseapprovedemail'] = 'El curso que ha solicitado está aprobado, <a href="{$a->url}">{$a->name}</a>,  y usted es un {$a->teacher}.';
$string['courseapprovedemail2'] = 'El curso que ha solicitado está aprobado: <a href="{$a->url}">{$a->name}</a>.';
$string['courseapprovedfailed'] = '¡No se ha podido guardar su curso como aprobado!';
$string['courseapprovedsubject'] = 'Su curso ha sido aprobado.';
$string['courseavailable'] = 'Este curso está disponible para los estudiantes';
$string['courseavailablenot'] = 'Este curso no está disponible para los estudiantes';
$string['coursebackup'] = 'Respaldo del curso';
$string['coursebulkaction'] = 'Acciones masivas para cursos seleccionados';
$string['coursecategories'] = 'Categorías de cursos';
$string['coursecategory'] = 'Categoría de cursos';
$string['coursecategory_help'] = 'Este ajuste determina la categoría en la que aparecerá el curso en la lista de cursos.';
$string['coursecategorydeleted'] = 'Eliminada la categoría de curso {$a}';
$string['coursecatmanagement'] = 'Gestión de curso y categoría';
$string['coursecompletion'] = 'Finalización del curso';
$string['coursecompletions'] = 'Finalizaciones del curso';
$string['coursecreators'] = 'Creador de curso';
$string['coursecreatorsdescription'] = 'Los creadores de cursos pueden crear nuevos cursos.';
$string['coursedeleted'] = 'Eliminado el curso {$a}';
$string['coursedetails'] = 'Detalles del curso';
$string['coursedisplay'] = 'Acomodo del curso';
$string['coursedisplay_help'] = 'Las secciones del curso pueden ser mostradas en una página o divididas en varias páginas.';
$string['coursedisplay_multi'] = 'Mostrar una sección por página';
$string['coursedisplay_single'] = 'Mostrar todas las secciones en una página';
$string['courseduration'] = 'Duración del curso';
$string['courseduration_desc'] = 'La duración del curso es usada para calcular la fecha por defecto de terminación del curso. La fecha de terminación del curso es usada para determinar si es que un curso debería de ser incluido dentro de la lista de cursos de un usuario. También podría ser usada para reportes. Los usuarios todavía pueden ingresar al curso después de la fecha de terminación.';
$string['courseenddateenabled'] = 'Fecha de fin de curso habilitada por defecto';
$string['courseenddateenabled_desc'] = 'Esta configuración determina si es que la fecha de terminación del curso estará habilitada por defecto para cursos nuevos y la configura a la fecha calculada según la duración del curso.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Archivos antiguos heredados del curso';
$string['coursefilesedit'] = 'Editar archivos heredados del curso';
$string['coursefileswarning'] = 'Los archivos del curso están obsoletos';
$string['coursefileswarning_help'] = 'Los archivos del curso están obsoletos desde Moodle 2.0; por favor, utilice repositorios externos en su lugar cuanto le sea posible.';
$string['courseformatdata'] = 'Datos de formato del curso';
$string['courseformatoptions'] = 'Opciones de formato para {$a}';
$string['courseformats'] = 'Formatos de curso';
$string['courseformatudpate'] = 'Actualizar formato';
$string['coursegrades'] = 'Calificaciones del curso';
$string['courseheader'] = 'Menú del curso';
$string['coursehelpcategory'] = 'Coloque el curso en el listado de cursos a fin de facilitar el acceso a los estudiantes.';
$string['coursehelpforce'] = 'Forzar el modo de grupo en el curso para todas las actividades del curso.';
$string['coursehelpformat'] = 'La portada del curso se mostrará en este formato.';
$string['coursehelphiddensections'] = 'Cómo se mostrarán a los estudiantes las secciones ocultas del curso.';
$string['coursehelpmaximumupload'] = 'Define el tamaño máximo del archivo que los estudiantes, profesores y administrador pueden subir a este curso, limitado por el ajuste general del sitio. Si quiere subir archivos más grandes (.ZIP y .MBZ)  y su red y el servidor lo aguantan, puede editar el archivo PHP.INI y cambiar a (por ejemplo)  upload_max_filesize = 1000M , post_max_size = 1000M y max_execution_time = 600 .';
$string['coursehelpnewsitemsnumber'] = 'Número de avisos recientes que aparecen  en el bloque de avisos recientes en la página del curso. Si se configura a 0 entonces el bloque de avisos no se mostrará.';
$string['coursehelpnumberweeks'] = 'Número de secciones en el curso (solamente aplica para ciertos formatos de cursos).';
$string['coursehelpshowgrades'] = 'Activa la presentación del libro de calificaciones. No impide que las calificaciones se muestren dentro de las actividades individuales.';
$string['coursehidden'] = 'Este curso no es accesible de momento a los estudiantes';
$string['courseinfo'] = 'Información del curso';
$string['courselegacyfiles'] = 'Archivos antiguos heredados del curso';
$string['courselegacyfiles_help'] = 'El área de archivos del curso proporciona cierta compatibilidad hacia atrás con las versiones de Moodle 1.9 y anteriores. Todos los archivos de este área son siempre accesible a todos los participantes en el curso (tanto si enlaza a ellos como si no) y no hay manera de saber dónde se pueden estar usando en Moodle cualquiera de estos archivos.

Si utiliza este área para almacenar archivos de curso, puede exponerse a una serie de riesgos de privacidad y de seguridad, así como a la pérdida de archivos en los respaldos, en las importaciones de cursos o cada vez que el contenido del curso sea compartido o reutilizado. Por ello se recomienda que no utilice esta área a menos que realmente sepa lo que está haciendo.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Archivos de curso antiguos heredados: {$a}';
$string['coursenotaccessible'] = 'Este curso no permite acceso público';
$string['courseoverview'] = 'Vista general del curso';
$string['courseoverviewfiles'] = 'Imagen del curso';
$string['courseoverviewfiles_help'] = 'La imagen del curso es mostrada en Mis cursos y en la lista de cursos disponibles en la Página inicial del sitio. Los administradores del sitio pueden habilitar tipos adicionales de archivos y el uso de archivos múltiples. Si usted usa archivos múltiples, todos serán mostrados en la lista de cursos disponibles en la Página inicial del sitio.';
$string['courseoverviewfilesext'] = 'Extensiones para archivos de la imagen del curso';
$string['courseoverviewfileslimit'] = 'Límite para archivos de imagen del curso';
$string['courseoverviewgraph'] = 'Gráfico global del curso';
$string['courseprofiles'] = 'Perfiles de curso';
$string['coursereasonforrejecting'] = 'Razones para rechazar esta solicitud';
$string['coursereasonforrejectingemail'] = 'Esto se enviará al solicitante';
$string['coursereject'] = 'Rechazar solicitud de curso';
$string['courserejected'] = 'El curso ha sido rechazado y así se ha notificado al solicitante.';
$string['courserejectemail'] = 'Lo sentimos, el curso solicitado ha sido rechazado por la siguiente razón:

{$a}';
$string['courserejectreason'] = 'Describa sus razones para rechazar este curso<br />(serán enviadas al solicitante)';
$string['courserejectsubject'] = 'Su curso ha sido rechazado';
$string['coursereport'] = 'Reporte de curso';
$string['coursereports'] = 'Reportes del curso';
$string['courserequest'] = 'Solicitud de curso';
$string['courserequestdetails'] = 'Detalles del curso que solicita';
$string['courserequestfailed'] = 'Por alguna razón desconocida, su solicitud de curso no ha podido guardarse';
$string['courserequestintro'] = 'Utilice este formato para solicitar la creación de un curso.<br />Suministre toda la información posible para facilitar<br />a los administradores la comprensión de las razones por las que solicita el curso.';
$string['courserequestreason'] = 'Razones para solicitar el curso';
$string['courserequestroleerror'] = 'El rol de creador en a configuración de nuevos cursos es inválido. Plor favor vea <a href="{$a}">Políticas para el usuario</a>.';
$string['courserequestsuccess'] = 'Solicitud de curso enviada.';
$string['courserequestsupport'] = 'Información de apoyo para ayudar al administrador a evaluar esta solicitud';
$string['courserequestwarning'] = 'El usuario que solicita este curso será inscrito automáticamente y se le asignará el rol de "{$a}".';
$string['courserestore'] = 'Restaurar curso';
$string['coursereuse'] = 'Reutilización de curso';
$string['coursereusenavigationmenu'] = 'Menú de navegación re-utilizar curso';
$string['courses'] = 'Cursos';
$string['coursesectionsummaries'] = 'Resúmenes de sección del curso';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Editar masivamente {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Editar {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Ajustes por defecto del curso';
$string['coursesmovedout'] = 'Cursos sacados de {$a}';
$string['coursespending'] = 'Cursos pendientes de aprobación';
$string['coursestart'] = 'Comienzo del curso';
$string['coursesummary'] = 'Resumen del curso';
$string['coursesummary_help'] = 'Una descripción breve de su curso. El contenido que añada aquí puede ser buscado.';
$string['coursetitle'] = 'Curso: {$a->course}';
$string['coursetitlebulkediting'] = 'Editar masivamente curso: {$a->course}';
$string['coursetitleediting'] = 'Editar curso: {$a->course}';
$string['courseupdates'] = 'Actualizaciones de cursos';
$string['coursevisibility'] = 'Visibilidad del curso';
$string['coursevisibility_help'] = '* Mostrar:  El curso aparece en la lista de cursos y los estudiantes pueden acceder a él.

* Ocultar: El acceso está restringido a profesores y otros usuarios con la capacidad para  ver cursos ocultos.';
$string['create'] = 'Crear';
$string['createaccount'] = 'Crear mi cuenta nueva';
$string['createcategory'] = 'Crear categoría';
$string['createfolder'] = 'Crear un directorio en {$a}';
$string['createnew'] = 'Crear nuevo';
$string['createnewcategory'] = 'Crear nueva categoría';
$string['createnewcourse'] = 'Crear nuevo curso';
$string['createnewsubcategory'] = 'Crear nueva subcategoría';
$string['createsubcategoryof'] = 'Crear subcategoría de {$a}';
$string['createuser'] = 'Crear usuario';
$string['createziparchive'] = 'Crear archivo zip';
$string['creatingblocks'] = 'Creando bloques';
$string['creatingblocksroles'] = 'Creando asignaciones y anulaciones de rol en nivel de bloque';
$string['creatingblogsinfo'] = 'Creando información de blogs';
$string['creatingcategoriesandquestions'] = 'Creando categorías y preguntas';
$string['creatingcoursemodules'] = 'Creando módulos de curso';
$string['creatingcourseroles'] = 'Creando asignaciones y anulaciones de rol en nivel de curso';
$string['creatingevents'] = 'Creando eventos';
$string['creatinggradebook'] = 'Creando libro de calificaciones';
$string['creatinggroupings'] = 'Creando agrupamientos';
$string['creatinggroupingsgroups'] = 'Agregando grupos a agrupamientos';
$string['creatinggroups'] = 'Creando grupos';
$string['creatinglogentries'] = 'Creando entradas de bitácoras';
$string['creatingmessagesinfo'] = 'Creando información sobre mensajes';
$string['creatingmodroles'] = 'Creando asignaciones y anulaciones de rol en nivel de módulo';
$string['creatingnewcourse'] = 'Creando nuevo curso';
$string['creatingrolesdefinitions'] = 'Creando definiciones de roles';
$string['creatingscales'] = 'Creando escalas';
$string['creatingsections'] = 'Creando secciones';
$string['creatingtemporarystructures'] = 'Creando estructuras temporales';
$string['creatinguserroles'] = 'Creando asignaciones y anulaciones de rol en nivel de usuario';
$string['creatingusers'] = 'Creando usuarios';
$string['creatingxmlfile'] = 'Creando el archivo XML';
$string['currency'] = 'Moneda';
$string['currentcourse'] = 'Curso actual';
$string['currentcourseadding'] = 'Curso actual, agregando información';
$string['currentcoursedeleting'] = 'Curso actual, borrando primero';
$string['currentlanguage'] = 'Idioma actual';
$string['currentlocaltime'] = 'su hora local';
$string['currentpicture'] = 'Imagen actual';
$string['currentrelease'] = 'Información de la versión liberada actual';
$string['currenttheme'] = 'Tema actual';
$string['currentversion'] = 'Versión actual';
$string['databasechecking'] = 'Actualizando la base de datos: de la version {$a->oldversion} a {$a->newversion}...';
$string['databaseperformance'] = 'Rendimiento de la base de datos';
$string['databasesetup'] = 'Configurando la base de datos';
$string['databasesuccess'] = 'La base de datos se ha actualizado satisfactoriamente';
$string['databaseupgradebackups'] = 'La versión actual de respaldo es {$a}';
$string['databaseupgradeblocks'] = 'La versión actual de los bloques es {$a}';
$string['databaseupgradegroups'] = 'La versión actual de los grupos es {$a}';
$string['databaseupgradelocal'] = 'La versión de personalización de la base de datos local es ahora {$a}';
$string['databaseupgrades'] = 'Actualizando la base de datos';
$string['dataformats'] = 'Formatos de datos';
$string['date'] = 'Fecha';
$string['datechanged'] = 'Fecha cambiada';
$string['datemostrecentfirst'] = 'Fecha - primero el más reciente';
$string['datemostrecentlast'] = 'Fecha - el más reciente al final';
$string['datetimefilterafter'] = '{$a->title} después';
$string['datetimefilterbefore'] = '{$a->title} antes';
$string['day'] = 'día';
$string['days'] = 'días';
$string['decodinginternallinks'] = 'Decodificando enlaces internos';
$string['default'] = 'Por defecto';
$string['defaultcategoryname'] = 'Categoría 1';
$string['defaultcompetencescale'] = 'Escala de competencia por defecto';
$string['defaultcompetencescaledesc'] = 'Una escala de valoración binaria que no proporciona más información más allá de si es que alguien ha demostrado pericia o no.';
$string['defaultcompetencescalenotproficient'] = 'Aun no competente';
$string['defaultcompetencescaleproficient'] = 'Competente';
$string['defaultcoursestudent'] = 'Estudiante';
$string['defaultcoursestudentdescription'] = 'Los estudiantes tienen por lo general menos privilegios dentro de un curso.';
$string['defaultcoursestudents'] = 'Estudiantes';
$string['defaultcoursesummary'] = 'Escriba aquí un párrafo conciso e interesante que explique de qué se trata este curso';
$string['defaultcourseteacher'] = 'Profesor';
$string['defaultcourseteacherdescription'] = 'Los profesores pueden realizar cualquier acción dentro de un curso, incluyendo cambiar actividades y calificar a los estudiantes.';
$string['defaultcourseteachers'] = 'Profesores';
$string['defaulteditor'] = 'Editor por defecto';
$string['defaulthomepageuser'] = 'Página de inicio';
$string['defaulthomepageuser_help'] = '¿A cual página debería usted ser redirigido después de iniciar sesión en el sitio?';
$string['delete'] = 'Eliminar';
$string['deleteablock'] = 'Eliminar un bloque';
$string['deleteall'] = 'Eliminar todo';
$string['deleteallcannotundo'] = 'Eliminar todo (no se puede deshacer)';
$string['deleteallcomments'] = 'Todos los comentarios';
$string['deleteallratings'] = 'Todas las valuaciones (ratings)';
$string['deletecategory'] = 'Eliminar categoría: {$a}';
$string['deletecategorycheck'] = '¿Está totalmente seguro que quiere eliminar por completo la categoría <b>\'{$a}\'</b>?<br /> Esta acción trasladará todos los cursos a la categoría padre (si existe) o a Miscelánea.';
$string['deletecategorycheck2'] = 'Si elimina esta categoría, necesita decidir qué hacer con los cursos y subcategorías que contiene.';
$string['deletecategoryempty'] = 'Esta categoría está vacía';
$string['deletecheck'] = '¿ Eliminar {$a} ?';
$string['deletecheckfiles'] = '¿Está totalmente seguro que quiere borrar estos archivos?';
$string['deletecheckfull'] = '¿Está seguro que quiere eliminar al usuario {$a}, incluyendo datos como los detalles de su perfil, inscripciones, membresía a grupos y cohortes y algunos datos de actividad del usuario?';
$string['deletechecktype'] = '¿Está seguro que quiere borrar este(a) {$a->type}?';
$string['deletechecktypename'] = '¿Está seguro que quiere borrar el/la {$a->type}?';
$string['deletecheckwarning'] = 'Está a punto de borrar estos archivos';
$string['deletecommentbyon'] = 'Eliminar comentario publicado por {$a->user} en {$a->time}';
$string['deletecompletely'] = 'Eliminar completamente';
$string['deletecourse'] = 'Eliminar un curso';
$string['deletecoursecheck'] = '¿Está totalmente seguro que quiere borrar definitivamente este curso y toda la información que contiene?';
$string['deleted'] = 'Eliminado';
$string['deletedactivity'] = 'Se ha eliminado {$a}';
$string['deletedcourse'] = '{$a} se ha borrado completamente';
$string['deletednot'] = 'No se pudo borrar {$a}.';
$string['deletepicture'] = 'Eliminar';
$string['deletesection'] = 'Eliminar';
$string['deleteselected'] = 'Eliminar seleccionado';
$string['deleteselectedkey'] = 'Eliminar clave seleccionada';
$string['deletingcourse'] = 'Borrando {$a}';
$string['deletingexistingcoursedata'] = 'Borrando datos del curso';
$string['deletingolddata'] = 'Borrando datos antiguos';
$string['department'] = 'Departamento';
$string['deprecatedeventname'] = '{$a} (ya no está en uso)';
$string['desc'] = 'Descendente';
$string['description'] = 'Descripción';
$string['deselectall'] = 'No seleccionar ninguno';
$string['deselectnos'] = 'Des-seleccionar todos los \'No\'';
$string['detailedless'] = 'Menos detalle';
$string['detailedmore'] = 'Más detalle';
$string['details'] = 'Detalles';
$string['digitalminor'] = 'Menor digital';
$string['digitalminor_desc'] = 'Por favor pídale a su padre o tutor que se ponga en contacto con:';
$string['directory'] = 'Directorio';
$string['disable'] = 'Deshabilitar';
$string['disabledcomments'] = 'Los comandos están desactivados';
$string['dismissnotification'] = 'Descartar esta notificación';
$string['displayingfirst'] = 'Mostrando las primeras {$a->count} {$a->things}';
$string['displayingrecords'] = 'Mostrando {$a} registros';
$string['displayingusers'] = 'Mostrando los usuarios {$a->start} a {$a->end}';
$string['displayonpage'] = 'Mostrar en página';
$string['dndcourse'] = 'Usted puede arrastrar y soltar este curso para alterar su ordenamiento o para moverlo dentro de otra categoría.';
$string['dndenabled_inbox'] = 'Arrastre y suelte los archivos aquí para subirlos';
$string['dndnotsupported'] = 'No está soportado el arrastrar y soltar (drag and drop)';
$string['dndnotsupported_help'] = 'Su navegador no soporta la subida por \'arrastrar y soltar\' (drag and drop). Esta característica está disponible en todas las versiones recientes de Chrome, Firefox y Safari, al igual que en Internet Explorer versión 10 y superiores.';
$string['dndnotsupported_insentence'] = 'arrastrar y soltar no soportado';
$string['dnduploadwithoutcontent'] = 'Este archivo subido no tuvo ningún contenido';
$string['dndworkingfile'] = 'Para subir archivos, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkingfilelink'] = 'Para subir archivos o enlaces, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkingfiletext'] = 'Para subir archivos o texto, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkingfiletextlink'] = 'Para subir archivos, textos o enlaces, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkinglink'] = 'Para subir enlaces, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkingtext'] = 'Para subir textos, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkingtextlink'] = 'Para subir  textos o enlaces, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['documentation'] = 'Documentación de Moodle';
$string['dontsortcategories'] = 'No ordenar categorías';
$string['dontsortcourses'] = 'No ordenar cursos';
$string['down'] = 'Abajo';
$string['download'] = 'Descargar';
$string['downloadall'] = 'Descargar todo';
$string['downloadexcel'] = 'Descargar en formato Excel';
$string['downloadfile'] = 'Descargar archivo';
$string['downloadods'] = 'Descargar en formato ODS';
$string['downloadtext'] = 'Descargar en formato de texto';
$string['doyouagree'] = '¿Ha leído y comprendido los términos y condiciones?';
$string['droptoupload'] = 'Arrastre los archivos a subir aquí';
$string['duplicate'] = 'Duplicar';
$string['duplicatedmodule'] = '{$a} (copia)';
$string['duplicatedsection'] = '{$a} (copia)';
$string['edhelpaspellpath'] = 'Para usar un revisor de ortografía dentro del editor, usted DEBE tener instalado <strong>aspell 0.50</strong> o superior en su servidor, y debe especificar la ruta correcta de acceso al aspell binario. En sistemas Unix/Linux, esta ruta normalmente es <strong>/usr/bin/aspell</strong>, pero podría ser cualquiera otra.';
$string['edhelpbgcolor'] = 'Defina el color de fondo del área de edición.<br />Valores válidos son, por ejemplo: #ffffff o \'white';
$string['edhelpcleanword'] = 'Este ajuste activa o desactiva el filtro de formato específico Word.';
$string['edhelpenablespelling'] = 'Activa o desactiva la corrección ortográfica. Cuando está activado, <strong>aspell</strong> debe estar instalado en el servidor.';
$string['edhelpfontfamily'] = 'La propiedad familia de tipos de letras (fonts) es una lista de nombres de fonts y/o nombres de una familia genérica. Los nombres de la familia deben estar separados por comas.';
$string['edhelpfontlist'] = 'Defina los tipos de letra (fonts) usadas en el menú emergente de editores.';
$string['edhelpfontsize'] = 'El tamaño por defecto del tipo de letra (font) ajusta dicho tamaño. <br />Valores válidos son, por ejemplo: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Editar';
$string['edita'] = 'Editar {$a}';
$string['editcategorysettings'] = 'Editar ajustes de categoría';
$string['editcategorythis'] = 'Editar esta categoría';
$string['editcoursesettings'] = 'Editar la configuración del curso';
$string['editfiles'] = 'Editar archivos';
$string['editgroupprofile'] = 'Editar descripción del grupo';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = '¡Este valor no puede editarse!';
$string['editmode'] = 'Modo de edición';
$string['editmyprofile'] = 'Editar perfil';
$string['editorbgcolor'] = 'Color de fondo';
$string['editorcleanonpaste'] = 'Limpiar HTML de Word al pegar';
$string['editorcommonsettings'] = 'Ajustes comunes';
$string['editordefaultfont'] = 'Tipo de letra (font) por defecto';
$string['editorenablespelling'] = 'Activar corrección ortográfica';
$string['editorfontlist'] = 'Lista de tipos de letra (fonts)';
$string['editorfontsize'] = 'Tamaño por defecto del tipo de letra (font)';
$string['editorpreferences'] = 'Preferencias del editor';
$string['editorresettodefaults'] = 'Volver a valores por defecto';
$string['editorsettings'] = 'Ajustes del editor';
$string['editorshortcutkeys'] = 'Teclas de atajo del editor';
$string['editsection'] = 'Editar configuraciones';
$string['editsectionname'] = 'Editar nombre de sección';
$string['editsectionsettings'] = 'Editar configuraciones de sección';
$string['editsectiontitle'] = 'Editar sección: {$a}';
$string['editsettings'] = 'Editar ajustes';
$string['editthisactivity'] = 'Editar esta actividad';
$string['editthiscategory'] = 'Editar esta categoría';
$string['edittitle'] = 'Editar título';
$string['edittitleinstructions'] = 'Esc para cancelar, Enter para finalizar';
$string['edituser'] = 'Editar usuario';
$string['edulevel'] = 'Todos los eventos';
$string['edulevel_help'] = '* Enseñando - acciones realizadas por un profesor, como por ejemplo, actualizar un recurso
* Participando - acciones realizadas por un estudiante, como por ejemplo, publicar en un foro
* Otra - acciones realizadas por un usuario con un rol diferente al de profesor o estudiante';
$string['edulevelother'] = 'Otro';
$string['edulevelparticipating'] = 'Participando';
$string['edulevelteacher'] = 'Enseñando';
$string['email'] = 'Dirección Email';
$string['emailactive'] = 'Correo activado';
$string['emailagain'] = 'Correo (de nuevo)';
$string['emailalreadysent'] = 'Ya se ha enviado un Email para reinicio de contraseña. Por favor, revise su Email.';
$string['emailcharset'] = 'Conjunto de caracteres para email';
$string['emailconfirm'] = 'Confirme su cuenta';
$string['emailconfirmation'] = 'Hola, {$a->firstname},

Se ha solicitado la apertura de una nueva cuenta en \'{$a->sitename}\' utilizando su dirección de correo.

Para confirmar su nueva cuenta, por favor vaya a esta dirección web:

{$a->link}

En la mayoría de programas de correo electrónico este
enlace debería aparecer en azul. Si eso no funciona, corte y pegue la dirección en la línea para dirección en la parte superior de la ventana de su navegador web.

Si necesita ayuda, por favor póngase en contacto con el administrador del sitio,
{$a->admin}';
$string['emailconfirmationresend'] = 'Reenviar Email de confirmación';
$string['emailconfirmationsubject'] = '{$a}: confirmación de la cuenta';
$string['emailconfirmsent'] = '<p>Hemos enviado un correo electrónico a <b>{$a}</b></p>
<p>En él encontrará instrucciones sencillas para concluir el proceso.</p>
<p>Si tuviera alguna dificultad, póngase en contacto con el Administrador del Sistema.</p>';
$string['emailconfirmsentfailure'] = 'No se pudo enviar Email de confirmación';
$string['emailconfirmsentsuccess'] = 'Email de confirmación enviado exitosamente';
$string['emaildigest'] = 'Tipo de resumen de correo';
$string['emaildigest_help'] = 'Esta es la configuración del resumen diario que se usará por defecto.

* Sin resumen - Usted recibirá un Email por cada publicación del foro;
* Resumen - publicaciones completas - Usted recibirá un resumen en Email diariamente con los contenidos completos de cada publicación del foro;
* Resumen - asuntos solamente - Usted recibirá un Email resumido diariamente conteniendo solamente los asuntos de cada publicación del foro.

Usted también puede elegir una configuración diferente para cada foro si así lo deseara.';
$string['emaildigestcomplete'] = 'Completo (correo diario con mensajes completos)';
$string['emaildigestoff'] = 'Sin resumen (un correo por cada mensaje del foro)';
$string['emaildigestsubjects'] = 'Asuntos (correo diario sólo con asuntos)';
$string['emaildisable'] = 'La dirección de correo no está habilitada';
$string['emaildisableclick'] = 'Haga clic aquí para desactivar el envío de correo a esta dirección';
$string['emaildisplay'] = 'Visibilidad de Email';
$string['emaildisplay_help'] = '* Oculto - Solamente usuarios con los permisos apropiados, tales como profesores pueden ver su dirección Email.
* Visible para todos - Todos los usuarios en el sitio pueden ver su dirección Email.
* Visible a participantes del curso - Solamente los participantes de cursos donde usted está inscrito pueden ver su dirección Email.';
$string['emaildisplaycourse'] = 'Visible a participantes del curso';
$string['emaildisplaycoursemembersonly'] = '(Visible para otros participantes del curso)';
$string['emaildisplayeveryone'] = '(Visible para todos)';
$string['emaildisplayhide'] = '(Oculto a todos los usuarios excepto usuarios con los permisos apropiados)';
$string['emaildisplayno'] = 'Oculto';
$string['emaildisplayyes'] = 'Visible a todos';
$string['emailenable'] = 'La dirección de correo está habilitada';
$string['emailenableclick'] = 'Haga clic aquí para volver a activar el envío de correo a esta dirección';
$string['emailexists'] = 'Esta dirección de correo electrónico ya está registrada.';
$string['emailexistshintlink'] = 'Recuperar usuario o contraseña olvidada';
$string['emailexistssignuphint'] = '¿ Tal vez Usted creó una cuenta en el pasado ? {$a}';
$string['emailformat'] = 'Formato de correo';
$string['emailmustbereal'] = 'IMPORTANTE: Para concluir el proceso debe escribir una dirección de correo verdadera';
$string['emailnotallowed'] = 'Las direcciones Email en estos dominios no están permitidas ({$a})';
$string['emailnotfound'] = 'No se ha encontrado la dirección email en la base de datos';
$string['emailonlyallowed'] = 'Este Email no puede ser usado. Los dominios de Email permitidos son: {$a}.';
$string['emailpasswordchangeinfo'] = 'Hola, {$a->firstname}.

Alguien (probablemente Usted) ha solicitado una nueva contraseña para su cuenta  \'{$a->username}\' en \'{$a->sitename}\'.

Para cambiar su contraseña, por favor, diríjase a la siguiente dirección web:

{$a->link}

En la mayoría de los programas de correo electrónico, esto debería de aparecer como un enlace en color azul en el que usted puede hacer clic. Si esto no funcionara, copie y pegue la dirección en la barra de navegación de su navegador.

Si necesita ayuda, por favor póngase en contacto con el administrador del sitio,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Hola, {$a->firstname}.

Alguien (probablemente Usted) ha solicitado una nueva contraseña para su cuenta en \'{$a->sitename}\'.

Desafortunadamente, su cuenta en este sitio ha sido desactivada y no puede ser reactivada. Por favor, póngase en contacto con el administrador del sitio, {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Hola, {$a->firstname}.

Alguien (probablemente Usted)  ha solicitado una nueva contraseña para su cuenta en \'{$a->sitename}\'.

Desafortunadamente, las contraseñas no pueden cambiarse en este sitio. Contacte por favor con el administrador {$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Cambiar información sobre la contraseña';
$string['emailpasswordconfirmation'] = 'Hola, {$a->firstname}.

Recibimos la solicitud de nueva contraseña para su cuenta
en \'{$a->sitename}\'.

Para concluir el proceso y poder enviarle una nueva contraseña por correo,
diríjase a la siguiente dirección:

{$a->link}

En la mayoría de programas de correo electrónico el
enlace anterior debería aparecer en azul y puede hacer
clic sobre él. Si no funcionara, córtelo y péguelo en la
ventana de direcciones de su navegador.

Si necesita ayuda adicional, póngase en contacto con el
administrador, {$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Confirmación de cambio de contraseña';
$string['emailpasswordconfirmmaybesent'] = '<p>Si ha suministrado un nombre de usuario o dirección correctos, se le debería haber enviado un Email.</p>
<p>Contiene instrucciones sencillas para confirmar y completar el cambio de contraseña.
Si sigue teniendo dificultades, póngase en contacto por favor con el administrador del sitio.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>La cuenta de usuario que Usted especificó no tiene grabada una dirección de Email.</p> <p>Por favor, póngase en contacto con el administrador.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>El detalle del usuario que Usted proporcionó no identifica una cuenta de usuario existente.</p> <p>Por favor, revise la información que escribió, y vuelva a intentarlo. Si continúa teniendo dificultades, por favor póngase en contacto con el administrador del sitio.</p>';
$string['emailpasswordconfirmsent'] = 'Hemos enviado un correo a su dirección <b>{$a}</b>.
<p>Este mensaje contiene instrucciones sencillas para completar y confirmar el cambio de contraseña.
Si tuviera alguna dificultad, póngase en contacto con el Administrador.</p>';
$string['emailresetconfirmation'] = 'Hola {$a->firstname},

Se solicitó un reinicio de contraseña para su cuenta \'{$a->username}\' en {$a->sitename}.

Para confirmar esta solicitud, y configurar una nueva contraseña para su cuenta, por favor, vaya a la siguiente dirección web:
<a href="{$a->link}">{$a->link}</a>

(Este enlace es válido por {$a->resetminutes} minutos a partir de que se solicitó por vez primera el reinicio).

Si este reinicio de contraseña no fue solicitado por Usted, no necesita hacer nada.

Si necesita ayuda, por favor póngase en contacto con el administrador del sitio, {$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Solicitud de reinicio de contraseña';
$string['emailresetconfirmsent'] = 'Se ha enviado un Email a su dirección en <b>{$a}</b>. <br />Este Email contiene instrucciones sencillas para confirmar y completar este cambio de contraseña. Si Usted continúa experimentando dificultades, póngase en contacto con el administrador del sitio.';
$string['emailstop'] = 'Deshabilitar notificaciones';
$string['emailtoprivatefiles'] = 'Usted también puede enviar por E-mail archivos como anexos directamente a su espacio de archivos privados. Simplemente anexe sus archivos a un E-mail y envíelo a {$a}';
$string['emailtoprivatefilesdenied'] = 'Su administrador ha deshabilitado la opción para que Usted suba sus propios archivos privados.';
$string['emailvia'] = '{$a->name} (via {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Actividades';
$string['emojicategoryanimalsnature'] = 'Animales y naturaleza';
$string['emojicategoryflags'] = 'Banderas';
$string['emojicategoryfooddrink'] = 'Comida y bebida';
$string['emojicategoryobjects'] = 'Objetos';
$string['emojicategorypeoplebody'] = 'Personas y cuerpo';
$string['emojicategoryrecent'] = 'Reciente';
$string['emojicategorysmileysemotion'] = 'Caritas sonrientes y emociones';
$string['emojicategorysymbols'] = 'Símbolos';
$string['emojicategorytravelplaces'] = 'Viaje y lugares';
$string['emptycmids'] = 'IDs de módulo de curso vacío';
$string['emptydragdropregion'] = 'región vacía';
$string['emptysectionids'] = 'ID de sección vacía';
$string['enable'] = 'Habilitar';
$string['encryptedcode'] = 'Código encriptado';
$string['enddate'] = 'Fecha de terminación del curso';
$string['enddate_help'] = 'La fecha de terminación no restringe el acceso de estudiantes al curso. Determina si un curso es enlistado como ya pasado en Mis cursos.';
$string['enddatewithtaskenabled'] = 'Fecha de fin del curso';
$string['enddatewithtaskenabled_help'] = 'La fecha de  cuando el curso se vuelve oculto para estudiantes y ellos ya no pueden acceder a él.';
$string['english'] = 'Inglés';
$string['enrolmentmethods'] = 'Métodos de inscripción';
$string['entercourse'] = 'Haga clic aquí para entrar al curso';
$string['enteremail'] = 'Haga clic para entrar en este curso';
$string['enteremailaddress'] = 'Escriba su dirección de correo electrónico.
Le enviaremos una nueva contraseña.';
$string['enterusername'] = 'Escriba su usuario';
$string['entries'] = 'Entradas';
$string['error'] = 'Error';
$string['errorcreatingactivity'] = 'No se puede crear una instancia de la actividad \'{$a}\'';
$string['errorfiletoobig'] = 'El archivo era mayor de los {$a} bytes';
$string['errornouploadrepo'] = 'No existe un repositorio para subir archivos habilitado para este sitio';
$string['errorwhenconfirming'] = 'Ha ocurrido un error, por lo que usted aún no ha sido confirmado. Si llegó aquí a través de un enlace en su correo electrónico, asegúrese de que esa línea  en su correo no esté rota o cortada. De ser así, tendrá que utilizar copiar y pegar para reconstruir adecuadamente el enlace.';
$string['eventcommentcreated'] = 'Comentario creado';
$string['eventcommentdeleted'] = 'Comentario eliminado';
$string['eventcommentsviewed'] = 'Comentarios vistos';
$string['eventconfiglogcreated'] = 'Bitácora de configuración creada';
$string['eventcontentviewed'] = 'Contenido visto';
$string['eventcoursebackupcreated'] = 'Respaldo de curso creado';
$string['eventcoursecategorycreated'] = 'Categoria creada';
$string['eventcoursecategorydeleted'] = 'Categoría eliminada';
$string['eventcoursecategoryupdated'] = 'Categoria actualizada';
$string['eventcoursecategoryviewed'] = 'Categoría vista';
$string['eventcoursecontentdeleted'] = 'Contenido del curso eliminado';
$string['eventcoursecreated'] = 'Curso creado';
$string['eventcoursedeleted'] = 'Curso eliminado';
$string['eventcourseended'] = 'Curso terminó';
$string['eventcourseinformationviewed'] = 'Resumen de curso visto';
$string['eventcoursemodulecreated'] = 'Módulo de curso creado';
$string['eventcoursemoduledeleted'] = 'Módulo de curso eliminado';
$string['eventcoursemoduleinstancelistviewed'] = 'Lista de instancia de módulo de curso vista';
$string['eventcoursemoduleupdated'] = 'Módulo de curso actualizado';
$string['eventcoursemoduleviewed'] = 'Módulo de curso visto';
$string['eventcourseoverviewviewed'] = 'Página de resumen de actividades del curso vista';
$string['eventcourseresetended'] = 'Terminó reinicio de curso';
$string['eventcourseresetstarted'] = 'Inició reinicio de curso';
$string['eventcourserestored'] = 'Curso restaurado';
$string['eventcoursesectioncreated'] = 'Sección de curso creada';
$string['eventcoursesectiondeleted'] = 'Sección de curso eliminada';
$string['eventcoursesectionupdated'] = 'Sección de curso actualizada';
$string['eventcoursessearched'] = 'Cursos buscados';
$string['eventcoursestarted'] = 'Curso inició';
$string['eventcourseupdated'] = 'Curso actualizado';
$string['eventcourseuserreportviewed'] = 'Reporte de usuario de curso visto';
$string['eventcourseviewed'] = 'Curso visto';
$string['eventdashboardreset'] = 'Reiniciar Tablero';
$string['eventdashboardsreset'] = 'Reiniciar Tablero';
$string['eventdashboardviewed'] = 'Tablero visto';
$string['eventdatabasetextfieldcontentreplaced'] = 'Buscar y remplazar global de la Base de Datos';
$string['eventemailfailed'] = 'Email no pudo enviarse';
$string['eventmycoursesviewed'] = 'Mis cursos visto';
$string['eventname'] = 'Nombre del evento';
$string['eventrecentactivityviewed'] = 'Actividad reciente vista';
$string['eventsearchindexed'] = 'Datos de búsqueda indexados';
$string['eventsearchresultsviewed'] = 'Resultados de búsqueda vistos';
$string['eventsectionviewed'] = 'Sección vista';
$string['eventunknownlogged'] = 'Evento desconocido';
$string['eventurlblocked'] = 'La URL estaba bloqueada';
$string['eventusercreated'] = 'Usuario creado';
$string['eventuserdeleted'] = 'Usuario eliminado';
$string['eventuserfeedbackgiven'] = 'Enlace de retroalimentación elegido';
$string['eventuserfeedbackremind'] = 'Enlace de retroalimentación posterior elegido';
$string['eventuserinfocategorycreated'] = 'Categoría de campo de perfil del usuario creada';
$string['eventuserinfocategorydeleted'] = 'Categoría de campo de perfil del usuario eliminada';
$string['eventuserinfocategoryupdated'] = 'Categoría de campo de perfil del usuario actualizada';
$string['eventuserinfofieldcreated'] = 'Campo de perfil del usuario creado';
$string['eventuserinfofielddeleted'] = 'Campo de perfil del usuario eliminado';
$string['eventuserinfofieldupdated'] = 'Campo de perfil del usuario actualizado';
$string['eventuserlistviewed'] = 'Lista de usuario vista';
$string['eventuserloggedout'] = 'Usuario ha salido';
$string['eventuserpasswordpolicyfailed'] = 'Contraseña del usuario falló la política de contraseña';
$string['eventuserpasswordupdated'] = 'Contraseña de usuario actualizada';
$string['eventuserprofileviewed'] = 'Perfil de usuario visto';
$string['eventuserupdated'] = 'Usuario actualizado';
$string['everybody'] = 'Todos';
$string['executeat'] = 'Ejecutar a las';
$string['existing'] = 'Existente';
$string['existingadmins'] = 'Administradores existentes';
$string['existingcourse'] = 'Curso existente';
$string['existingcourseadding'] = 'Curso existente, agregando información';
$string['existingcoursedeleting'] = 'Curso existente, borrando primero';
$string['existingcreators'] = 'Creadores existentes';
$string['existingstudents'] = 'Estudiantes inscritos';
$string['existingteachers'] = 'Profesores existentes';
$string['expand'] = 'Expandir';
$string['expandall'] = 'Expandir todo';
$string['expandcategory'] = 'Expandir {$a}';
$string['explanation'] = 'Explicación';
$string['explanationdigitalminor'] = 'Esta información es necesaria para determinar si su edad está arriba de la edad digital de consentimiento. Esta es la edad cuando un individuo puede consentir a los términos y condiciones y que sus datos sean legalmente almacenados y procesados.';
$string['extendperiod'] = 'Período de ampliación';
$string['extendsession'] = 'Extender sesión';
$string['failedloginattempts'] = '{$a->attempts} intentos de ingreso fallidos desde su último ingreso';
$string['failedtaskbody'] = '<p>Hola {$a->firstname},</p>
<p>El trabajo <b>{$a->taskname}</b> ha fallado múltiples veces y requiere atención.</p>
<p><a href="{$a->link}">Ver el trabajo</a></p>';
$string['failedtaskcontexturlname'] = 'Reporte del estado';
$string['failedtasksubject'] = 'Trabajo fallido: {$a}';
$string['favourites'] = 'Destacados';
$string['feedback'] = 'Retroalimentación';
$string['file'] = 'Archivo';
$string['fileexists'] = 'Ya existe un archivo con nombre {$a}';
$string['filemissing'] = 'No se encuentra {$a}';
$string['filereaderror'] = 'No se puede leer el archivo \'{$a}\' - por favor revise que esto sea realmente un archivo y no una carpeta.';
$string['files'] = 'Archivos';
$string['filesanduploads'] = 'Archivos y subidas';
$string['filesfolders'] = 'Archivos/directorios';
$string['fileuploadwithcontent'] = 'La subida de archivos no debería incluir el parámetro contenido';
$string['filloutallfields'] = 'Por favor rellene todos los campos de este formato';
$string['filter'] = 'Filtro';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Filtro {$a}';
$string['filters'] = 'Filtros';
$string['filtersetmatchdescription'] = 'Como deberían ser combinados múltiples filtros';
$string['filtertype'] = 'Filtrar tipo';
$string['findmorecourses'] = 'Encontrar más cursos...';
$string['first'] = 'Primero';
$string['firstaccess'] = 'Primer acceso';
$string['firstname'] = 'Nombre';
$string['firstnamephonetic'] = 'Nombre - fonético';
$string['firstpage'] = 'Primera página';
$string['firstsiteaccess'] = 'Primer acceso al sitio';
$string['firsttime'] = 'Registrarse como usuario';
$string['folder'] = 'Carpeta';
$string['folderclosed'] = 'Carpeta cerrada';
$string['folderopened'] = 'Carpeta abierta';
$string['followingoptional'] = 'Los siguientes datos son opcionales';
$string['followingrequired'] = 'Los siguientes datos son indispensables';
$string['for'] = 'Para';
$string['force'] = 'Forzar';
$string['forcelanguage'] = 'Forzar idioma';
$string['forceno'] = 'No forzar';
$string['forcepasswordchange'] = 'Forzar cambio de contraseña';
$string['forcepasswordchange_help'] = 'Si esta casilla está activada, al usuario se le pedirá que cambie su contraseña en su siguiente ingreso.';
$string['forcepasswordchangecheckfull'] = '¿Está totalmente seguro que quiere forzar un cambio de contraseña a {$a} ?';
$string['forcepasswordchangenot'] = 'No se pudo forzar el cambio de contraseña a {$a}';
$string['forcepasswordchangenotice'] = 'Para continuar, deberá cambiar su contraseña.';
$string['forcepasswordresetfailurenotice'] = 'Su contraseña actual ya no pasa la política para configurar contraseña. Por favor póngase en contacto con su administrador Moodle para asistencia.
   {$a}';
$string['forcepasswordresetnotice'] = 'Su contraseña actual ya no pasa la política para configurar contraseña; Usted debe reiniciar su contraseña para poder ingresar.
   {$a}';
$string['forcetheme'] = 'Forzar tema';
$string['forgotaccount'] = '¿Ha extraviado la contraseña?';
$string['forgotten'] = '¿Olvidó su usuario o contraseña?';
$string['forgottenduplicate'] = 'La dirección email es compartida por varias cuentas: por favor, utilice el nombre de usuario en su lugar.';
$string['forgotteninvalidurl'] = 'Contraseña no válida, reiniciar URL';
$string['format'] = 'Formato';
$string['formathtml'] = 'Formato HTML';
$string['formatmarkdown'] = 'Formado Markdown';
$string['formatplain'] = 'Formato de texto simple';
$string['formattext'] = 'Formato automático Moodle';
$string['forumpreferences'] = 'Preferencias del foro';
$string['framesetinfo'] = 'Este documento contiene:';
$string['fromdate'] = 'Desde';
$string['fromsender'] = 'Desde';
$string['frontpagecategorycombo'] = 'Lista combo';
$string['frontpagecategorynames'] = 'Lista de categorías';
$string['frontpagecourselist'] = 'Lista de cursos';
$string['frontpagecoursesearch'] = 'Caja de búsqueda de curso';
$string['frontpagedescription'] = 'Resumen de la página de inicio del sitio';
$string['frontpagedescriptionhelp'] = 'Este resumen puede mostrarse en la página de inicio del sitio usando el bloque de resumen del curso/sitio .';
$string['frontpageenrolledcourselist'] = 'Cursos inscritos';
$string['frontpageformat'] = 'Formato de la página de inicio del sitio';
$string['frontpageformatloggedin'] = 'Formato de la página de inicio del sitio cuando se ha iniciado sesión';
$string['frontpagenews'] = 'Anuncios';
$string['frontpagesettings'] = 'Configuraciones de la página de inicio del sitio';
$string['fulllistofcourses'] = 'Todos los cursos';
$string['fullname'] = 'Nombre completo';
$string['fullnamecourse'] = 'Nombre completo del curso';
$string['fullnamecourse_help'] = 'El nombre mostrado en Mis cursos y en la lista de cursos disponibles en la Página inicial del sitio.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Nombre completo del usuario';
$string['fullprofile'] = 'Perfil completo';
$string['fullsitename'] = 'Nombre completo del sitio';
$string['functiondisabled'] = 'Esta funcionalidad está actualmente desactivada';
$string['general'] = 'General';
$string['geolocation'] = 'latitud - longitud';
$string['gettheselogs'] = 'Conseguir estas bitácoras';
$string['go'] = 'Ir';
$string['gobacktosite'] = 'Regresar al sitio';
$string['gpl'] = 'Copyright (C)1999 en adelante  Martin Dougiamas (http://moodle.com)

Este programa es software libre; usted puede redistribuirlo y/o modificarlo bajo los términos de GNU General Public License según la publicación de The Free Software Foundation; incluso la versión 2, o ( a su elección) alguna posterior.

El programa se distribuye con la esperanza de que resulte útil, pero SIN GARANTÍA ALGUNA; incluso la garantía implicada de DISTRIBUCIÓN MERCANTIL o AJUSTE A UN PROPÓSITO PARTICULAR.

Para más detalles, vea la información de la Página de Licencia:
https://moodledev.io/general/license';
$string['gpl3'] = 'Copyright (C) 1999 en adelante, Martin Dougiamas (http://moodle.com)

Este programa es software libre: usted puede redistribuirlo y /o modificarlo bajo los términos de la Licencia Pública General GNU (GNU General Public License) publicada por la Fundación para el Software Libre, ya sea la versión 3 de dicha Licencia, o (a su elección) cualquier versión posterior.

Este programa se distribuye con la esperanza de que sea útil, pero SIN NINGUNA GARANTÍA; incluso sin la garantía implícita de COMERCIALIZACIÓN o IDONEIDAD PARA UN PROPÓSITO PARTICULAR.

Vea la página de información de Licencia de Moodle para más detalles: https://moodledev.io/general/license';
$string['gpllicense'] = 'Licencia GPL';
$string['gradenoun'] = 'Calificación';
$string['grades'] = 'Calificaciones';
$string['gradeverb'] = 'Calificación';
$string['gravatarenabled'] = '<a href="https://www.gravatar.com/">Gravatar</a> se ha habilitado para este sitio. Si usted no carga una imagen en su perfil, Moodle intentará cargar una imagen para su perfil desde Gravatar';
$string['group'] = 'Grupo';
$string['groupadd'] = 'Agregar nuevo grupo';
$string['groupaddusers'] = 'Agregar seleccionados al grupo';
$string['groupfor'] = 'para el grupo';
$string['groupinfo'] = 'Información sobre el grupo seleccionado';
$string['groupinfoedit'] = 'Editar ajustes de grupo';
$string['groupinfomembers'] = 'Información sobre los miembros seleccionados';
$string['groupinfopeople'] = 'Información sobre las personas seleccionadas';
$string['groupmembers'] = 'Miembros del grupo';
$string['groupmemberssee'] = 'Ver los integrantes del grupo';
$string['groupmembersselected'] = 'Miembros del grupo seleccionado';
$string['groupmode'] = 'Modo de grupo';
$string['groupmodeforce'] = 'Forzar el modo de grupo';
$string['groupmy'] = 'Mi grupo';
$string['groupnonmembers'] = 'Personas que no están en ningún grupo';
$string['groupnotamember'] = 'Lo sentimos, usted no es miembro de ese grupo';
$string['grouprandomassign'] = 'Asignar aleatoriamente a todos a grupos';
$string['groupremove'] = 'Quitar el grupo seleccionado';
$string['groupremovemembers'] = 'Quitar los miembros seleccionados';
$string['groups'] = 'Grupos';
$string['groupsnone'] = 'No hay grupos';
$string['groupsseparate'] = 'Grupos separados';
$string['groupsvisible'] = 'Grupos visibles';
$string['guest'] = 'Invitado';
$string['guestdescription'] = 'Los invitados tienen privilegios mínimos y normalmente no están autorizados para escribir.';
$string['guestskey'] = 'Permitir la inscripción a invitados con contraseña';
$string['guestsno'] = 'No admitir invitados';
$string['guestsnotallowed'] = 'Lo sentimos, \'{$a}\' no permite acceso a invitados.';
$string['guestsyes'] = 'Permitir inscripción a invitados sin contraseña';
$string['guestuser'] = 'Invitado';
$string['guestuserinfo'] = 'Este usuario sólo tiene acceso de lectura en ciertos cursos.';
$string['help'] = 'Ayuda';
$string['helpprefix2'] = 'Ayuda con {$a}';
$string['helpwiththis'] = 'Ayuda';
$string['hiddenassign'] = 'Tarea oculta';
$string['hiddenfromstudents'] = 'Oculto para los estudiantes';
$string['hiddenoncoursepage'] = 'Disponible pero no mostrada en página del curso';
$string['hiddensections'] = 'Secciones ocultas';
$string['hiddensections_help'] = 'Las secciones ocultas pueden ser mostradas a estudiantes como \'no disponible\' en la página del curso, o pueden mantenerse completamente ocultas.';
$string['hiddensectionscollapsed'] = 'Las secciones ocultas son mostradas como no disponibles';
$string['hiddensectionsinvisible'] = 'Las secciones ocultas son totalmente invisibles';
$string['hiddenwithbrackets'] = '(oculto)';
$string['hide'] = 'Ocultar';
$string['hideadvancedsettings'] = 'Ocultar ajustes avanzados';
$string['hidecategory'] = '¿Ocultar categoría?';
$string['hidecategorymany'] = 'La categoría {$a->category} contiene {$a->coursecount} cursos.
<br/>Si usted la oculta, los usuarios sin permiso para ver categorías ocultas ya no podrán tener acceso a los cursos.';
$string['hidecategoryone'] = 'La categoría {$a->category} contiene {$a->coursecount} un curso.
<br/>Si usted la oculta, los usuarios sin permiso para ver categorías ocultas ya no podrán tener acceso al curso.';
$string['hidechartdata'] = 'Ocultar datos de gráfico';
$string['hidefromstudents'] = 'Ocultar en página de curso';
$string['hideoncoursepage'] = 'Hacer disponible, pero no mostrar en página del curso';
$string['hidepopoverwindow'] = 'Ocultar ventana \'popover\'';
$string['hidesection'] = 'Ocultar sección {$a}';
$string['hidesettings'] = 'Ocultar ajustes';
$string['hideshowblocks'] = 'Ocultar o mostrar bloques';
$string['highlight'] = 'Destacado';
$string['highlighted'] = 'Resaltado';
$string['highlightoff'] = 'Remover destacado';
$string['hits'] = 'Clics';
$string['hitsoncourse'] = 'Clics de {$a->username} en {$a->coursename}';
$string['hitsoncoursetoday'] = 'Clics de hoy de {$a->username} en {$a->coursename}';
$string['home'] = 'Inicio';
$string['homeheader'] = 'Menú inicial';
$string['hour'] = 'hora';
$string['hours'] = 'horas';
$string['howtomakethemes'] = 'Cómo desarrollar nuevos temas';
$string['htmleditor'] = 'Usar el editor de HTML';
$string['htmleditoravailable'] = 'El editor HTML está disponible';
$string['htmleditordisabled'] = 'Usted ha desactivado el editor HTML en su perfil de usuario.';
$string['htmleditordisabledadmin'] = 'El administrador ha deshabilitado el editor HTML';
$string['htmleditordisabledbrowser'] = 'El editor de HTML no está disponible porque su navegador no es compatible.';
$string['htmlfilesonly'] = 'Sólo archivos HTML';
$string['htmlformat'] = 'Formato HTML bonito';
$string['icon'] = 'Icono';
$string['idnumber'] = 'Número de ID';
$string['idnumbercourse'] = 'Número ID del curso';
$string['idnumbercourse_help'] = 'Únicamente usado para conectar el curso contra un sistema externo. Déjelo vacío si no tiene una ID oficial del curso.';
$string['idnumbercoursecategory'] = 'Número ID de la categoría';
$string['idnumbercoursecategory_help'] = 'El número de identificación ID de una categoría de cursos sólo se usa cuando se compara la categoría contra un sistema externo y no se muestra en ningún lugar del sitio. Si la categoría tiene un código oficial, este puede ser introducido, de lo contrario, el campo puede dejarse en blanco.';
$string['idnumbergroup'] = 'Número ID del grupo';
$string['idnumbergroup_help'] = 'El número ID del grupo solamente se usa cuando se hace coincidir el grupo contra un sistema externo y no se muestra en ninguna otra parte del sitio. Si el grupo tiene un nombre código oficial, se puede emplear, en caso contrario, el campo puede dejarse vacío.';
$string['idnumbergrouping'] = 'Número ID de agrupamiento';
$string['idnumbergrouping_help'] = 'El número ID del agrupamiento solamente se usa cuando se hace coincidir el agrupamiento contra un sistema externo y no se muestra en ninguna otra parte del sitio. Si el agrupamiento tiene un nombre código oficial, se puede emplear, en caso contrario, el campo puede dejarse vacío.';
$string['idnumbermod'] = 'Número ID';
$string['idnumbermod_help'] = 'El configurar un número ID proporciona una forma de identificar la actividad o recurso para propósitos como calcular la calificación o reportes personalizados. En caso contrario el campo puede dejarse vacío.

Para actividades calificables, el número ID también puede ajustarse en el Libro de calificaciones, aunque solamente puede ser editado en la página de las configuraciones de la activodad.';
$string['idnumbertaken'] = 'Este número ID ya está ocupado';
$string['imagealt'] = 'Descripción de la imagen';
$string['import'] = 'Importar';
$string['importdata'] = 'Importar datos del curso';
$string['importdataexported'] = 'Datos correctamente exportados \'desde\' el curso.<br />Continúe importando \'hacia\' su curso.';
$string['importdatafinished'] = 'Importación completa. Continúe con su curso';
$string['importdatafrom'] = 'Encontrar un curso desde el que importará datos:';
$string['importinfo'] = 'Importar elementos desde otros cursos, como actividades, bloques o eventos del calendario. No serán importados datos del usuario.';
$string['inactive'] = 'Inactivo';
$string['include'] = 'Incluir';
$string['includeallusers'] = 'Incluir a todos los usuarios';
$string['includecoursefiles'] = 'Incluir los archivos del curso';
$string['includecourseusers'] = 'Incluir los usuarios del curso';
$string['included'] = 'Incluido';
$string['includelogentries'] = 'Incluir las entradas de registro';
$string['includemodules'] = 'Incluir Módulos';
$string['includemoduleuserdata'] = 'Incluir datos del usuario del módulo';
$string['includeneededusers'] = 'Incluir usuarios necesarios';
$string['includenoneusers'] = 'No incluir usuarios';
$string['includeroleassignments'] = 'Incluir asignaciones de rol';
$string['includesitefiles'] = 'Incluir archivos del sitio usados en este curso';
$string['includesubcategories'] = 'Incluir subcategorías';
$string['includeuserfiles'] = 'Incluir los archivos de los usuarios';
$string['increasesections'] = 'Aumentar el número de secciones';
$string['indicator:accessesafterend'] = 'Curso accedido después de la fecha límite';
$string['indicator:accessesafterend_help'] = 'Este indicador refleja que el estudiante accedió al curso después de la fecha límite,';
$string['indicator:accessesbeforestart'] = 'Curso accedido antes de la fecha de inicio';
$string['indicator:accessesbeforestart_help'] = 'Este indicador refleja si el alumno accedió al curso antes de la fecha de inicio del curso.';
$string['indicator:activitiesdue'] = 'Actividades pendientes';
$string['indicator:activitiesdue_help'] = 'El usuario tiene actividades pendientes.';
$string['indicator:anycourseaccess'] = 'Cualquier acceso a curso';
$string['indicator:anycourseaccess_help'] = 'Este indicador refleja acceso a cualquier curso en donde está inscrito el usuario.';
$string['indicator:anywrite'] = 'Cualquier acción de escritura';
$string['indicator:anywrite_help'] = 'Este indicador representa cualquier acción de escritura (enviar) tomada por el estudiante.';
$string['indicator:anywriteincourse'] = 'Cualquier acción de escritura en el curso';
$string['indicator:anywriteincourse_help'] = 'Este indicador representa cualquier acción de escritura (enviar) tomada por el estudiante en cualquier actividad de curso.';
$string['indicator:completeduserprofile'] = 'Perfil de usuario está completo';
$string['indicator:completeduserprofile_help'] = 'Este indicador representa que el estudiante ha completado su perfil de usuario.';
$string['indicator:completeduserprofiledef'] = 'Perfil del usuario está completado';
$string['indicator:completeduserprofiledef_help'] = 'Las políticas del sitio han sido acordadas y el usuario ha llenado los campos siguientes: Institución, Departamento, Dirección, Ciudad, País, URL)';
$string['indicator:completionenabled'] = 'Seguimiento de finalización habilitada';
$string['indicator:completionenabled_help'] = 'Este indicador representa que se ha habilitado el seguimiento de la finalización para este curso.';
$string['indicator:nostudent'] = 'Inscripciones de estudiantes';
$string['indicator:nostudent_help'] = 'Este indicador refleja la disponibilidad de estudiantes en el curso.';
$string['indicator:noteacher'] = 'Disponibilidad de profesor';
$string['indicator:noteacher_help'] = 'Este indicador refleja la disponibilidad de profesores en el curso.';
$string['indicator:potentialcognitive'] = 'Profundidad cognitiva potencial del curso';
$string['indicator:potentialcognitive_help'] = 'Este indicador está basado en la profundidad del potencial cognitivo que podría ser alcanzado por un estudiante en esta actividad del curso.';
$string['indicator:potentialcognitivedef'] = 'Profundidad cognitiva potencial del curso';
$string['indicator:potentialcognitivedef_help'] = 'El grado en el que el curso ofrece "profundo" compromiso cognitivo, por ejemplo envío de trabajo para retroalimentación, la oportunidad para  revisar el trabajo de otros, y la oportunidad para revisar y reenviar trabajo.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Amplitud social potencial del curso';
$string['indicator:potentialsocial_help'] = 'Este indicador está basado en la amplitud del potencial social que podría ser alcanzado por un estudiante que participa en actividades del curso.';
$string['indicator:potentialsocialdef'] = 'Amplitud social potencial del curso';
$string['indicator:potentialsocialdef_help'] = 'El grado en el que el curso ofrece "amplio" compromiso social, interactuando con otros participantes y con la comunidad de práctica más allá de la clase.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Cantidad de acciones de lectura';
$string['indicator:readactions_help'] = 'Este indicador representa el número de acciones de lectura (ver) tomadas por el estudiante.';
$string['indicator:userforumstracking'] = 'El usuario está rastreando foros';
$string['indicator:userforumstracking_help'] = 'Este indicador representa si es que el estudiante ha activado o no el seguimiento en los foros.';
$string['info'] = 'Información';
$string['inprogress'] = 'En progreso';
$string['insertcontentbefore'] = 'Insertar contenido antes de \'{$a->activityname}\'';
$string['insertcontentsection'] = 'Insertar contenido en sección \'{$a->sectionname}\'';
$string['insertresourceoractivitybefore'] = 'Insertar una actividad o recurso antes de \'{$a->activityname}\'';
$string['institution'] = 'Institución';
$string['instudentview'] = 'en vista estudiante';
$string['interests'] = 'Intereses';
$string['interestslist'] = 'Lista de intereses';
$string['interestslist_help'] = 'Escriba sus intereses, uno a uno, separados por comas, los cuales se mostrarán en la página de su perfil como marcas ... Evite escribir palabras soeces y términos políticamente incorrectos.';
$string['invalidemail'] = 'Dirección de correo no válida';
$string['invalidlogin'] = 'Datos erróneos. Por favor, inténtelo otra vez.';
$string['invalidtaskclassname'] = 'Clase de trabajo inválida {$a}';
$string['invalidtaskid'] = 'ID de trabajo inválida';
$string['invalidusername'] = 'El nombre de usuario solamente puede contener caracteres alfanuméricos en minúsculas, (letras y números), subrayado (_), guion (-), punto (.) o arroba (@).';
$string['invalidusernameupload'] = 'Usuario no válido';
$string['ip_address'] = 'Dirección IP';
$string['jump'] = 'Salto';
$string['jumpto'] = 'Ir a...';
$string['keep'] = 'Mantener';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Dirección normal de texto de izquierda a derecha';
$string['langrtl'] = 'Dirección inversa de texto (japonés)';
$string['language'] = 'Idioma';
$string['languagegood'] = 'Este paquete de idioma está actualizado.';
$string['languageselector'] = 'Selector de idioma';
$string['last'] = 'Último';
$string['lastaccess'] = 'Último acceso';
$string['lastcourseaccess'] = 'Último acceso al curso';
$string['lastedited'] = 'Última edición';
$string['lastip'] = 'Última dirección IP';
$string['lastlogin'] = 'Último ingreso';
$string['lastmodified'] = 'Última modificación';
$string['lastname'] = 'Apellido(s)';
$string['lastnamephonetic'] = 'Apellido(s) - fonético';
$string['lastpage'] = 'Última página';
$string['lastsiteaccess'] = 'Último acceso al sitio';
$string['lastyear'] = 'Último año';
$string['latestlanguagepack'] = 'Revisar el paquete de idioma más reciente en moodle.org';
$string['layouttable'] = 'Acomodo de tabla';
$string['leavetokeep'] = 'Dejar en blanco para mantener la contraseña actual';
$string['legacylogginginuse'] = 'Este sitio actualmente tiene habilitado el escribir al almacén de bitácoras antiguo. El escribir hacia este almacén de bitácoras está obsoleto. Por favor, escriba hacia un almacenamiento de bitácoras soportado, como por ejemplo "estándar" o "externo".';
$string['legacythemeinuse'] = 'El sitio aparece en modo de compatibilidad porque su navegador es demasiado antiguo.';
$string['license'] = 'Licencia';
$string['licenses'] = 'Licencias';
$string['liketologin'] = '¿Desea acceder ahora con una cuenta de usuario completa?';
$string['list'] = 'Lista';
$string['listfiles'] = 'Lista de archivos en {$a}';
$string['listofallpeople'] = 'Lista total de personas';
$string['listofcourses'] = 'Lista de cursos';
$string['loading'] = 'Cargando';
$string['loadinghelp'] = 'Cargando...';
$string['local'] = 'Local';
$string['localplugins'] = 'Plugins locales';
$string['localpluginsmanage'] = 'Administrar plugins locales';
$string['location'] = 'Ubicación';
$string['locktimeout'] = 'La operación agotó el tiempo al esperar un bloque';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Usted ha iniciado sesión como {$a}';
$string['loggedinasguest'] = 'En este momento está usando el acceso para invitados';
$string['loggedinnot'] = 'Usted no ha iniciado sesión.';
$string['login'] = 'Iniciar sesión (ingresar)';
$string['login_failure_logs'] = 'Bitácoras de fallos de ingreso';
$string['loginactivity'] = 'Actividad de ingresos';
$string['loginagain'] = 'Ingresar nuevamente';
$string['loginalready'] = 'Usted ya ha iniciado sesión';
$string['loginas'] = 'Ingresar como';
$string['loginaspasswordexplain'] = '<p>Debe introducir la instrucción especial "loginas password" para usar esta característica.<br />Si no la sabe, pregunte al administrador de su servidor.</p>';
$string['loginguest'] = 'Ingresar como un invitado';
$string['loginsite'] = 'Ingresar al sitio';
$string['loginsteps'] = 'Para acceso completo a este sitio, Usted necesita primeramente crear una cuenta.';
$string['loginstepsnone'] = '<p>¡Hola!</p>
<p>Para acceder a todos los cursos necesita crear una cuenta.</p>
<p>Todo lo que tiene que hacer es inscribirse en esta página.</p>
<p>Si alguna otra persona hubiera elegido su nombre de usuario o su contraseña, deberá elegir un nombre de usuario diferente.</p>';
$string['loginto'] = 'Ingresar a {$a}';
$string['logoof'] = 'Logo de {$a}';
$string['logout'] = 'Salir';
$string['logoutconfirm'] = '¿Realmente desea desconectarse?';
$string['logs'] = 'Bitácoras';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">more</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">more</a> ]';
$string['lookback'] = 'Ver hacia atrás';
$string['mailadmins'] = 'Informar a administradores';
$string['mailstudents'] = 'Informar a estudiantes';
$string['mailteachers'] = 'Informar a profesores';
$string['maincoursepage'] = 'Página principal del curso';
$string['makeafolder'] = 'Crear un directorio';
$string['makeavailable'] = 'Hacer disponible';
$string['makeeditable'] = 'Si Usted hace a \'{$a}\' editable (CHMOD 777) por el proceso del servidor web (por ejemplo, apache), entonces Usted podría editar este archivo directamente desde esta página.';
$string['makethismyhome'] = 'Hacer esta mi página inicial';
$string['makeunavailable'] = 'Hacer no disponible';
$string['manageblocks'] = 'Bloques';
$string['managecategories'] = 'Gestionar categorías de cursos';
$string['managecategorythis'] = 'Gestionar esta categoría';
$string['managecombined'] = 'Gestionar categorías de cursos y cursos';
$string['managecontentbanktypes'] = 'Gestionar tipos de contenido';
$string['managecourses'] = 'Gestionar cursos';
$string['managedatabase'] = 'Administrar la base de datos';
$string['managedataformats'] = 'Gestionar formatos de datos';
$string['manageeditorfiles'] = 'Gestionar archivos usados por el editor';
$string['managefilters'] = 'Filtros';
$string['managemodules'] = 'Administrar módulos';
$string['manageroles'] = 'Roles y permisos';
$string['markallread'] = 'Marcar todo como leído';
$string['match'] = 'Coincidir con';
$string['matchingsearchandrole'] = 'Coincidencias \'{$a->search}\' y {$a->role}';
$string['matchofthefollowing'] = 'de lo siguiente:';
$string['maxareabytesreached'] = 'El archivo (o el tamaño total de varios archivos) es más grande que el espacio restante en esta área.';
$string['maxfilesize'] = 'Tamaño máximo para archivos nuevos: {$a}';
$string['maxfilesreached'] = 'A Usted se le permite anexar un máximo de {$a} archivo(s) a este item';
$string['maximumchars'] = 'Máximo de {$a} caracteres';
$string['maximumgrade'] = 'Calificación máxima';
$string['maximumgradex'] = 'Calificación máxima: {$a}';
$string['maximumshort'] = 'Max';
$string['maximumupload'] = 'Tamaño máximo para archivos cargados por usuarios';
$string['maximumupload_help'] = 'El tamaño máximo permitido para los archivos subidos por los estudiantes al curso. Adicionalmente, usted puede limitar aun más el tamaño máximo de archivo subido para cada actividad.';
$string['maxlengthreached'] = 'Se ha alcanzado el límite máximo de {$a} caracteres.';
$string['maxnumberweeks'] = 'Número máximo de secciones + subsecciones';
$string['maxnumberweeks_desc'] = 'El valor máximo en el número  de secciones + subsecciones del menú desplegable (solamente aplica para ciertos formatos de curso).';
$string['maxnumcoursesincombo'] = 'Ver <a href="{$a->link}">{$a->numberofcourses} cursos</a>.';
$string['maxsectionslimit'] = 'No se puede crear nueva sección ya que excedería el número máximo de secciones permitidas para este curso ({$a}).';
$string['maxsize'] = 'Tamaño máximo: {$a}';
$string['maxsizeandareasize'] = 'Tamaño máximo para archivos nuevos: {$a->size}, límite general: {$a->areasize}';
$string['maxsizeandattachments'] = 'Tamaño máximo para archivos: {$a->size}, número máximo de archivos: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Tamaño máximo para archivos : {$a->size}, número máximo de archivos: {$a->attachments}, tamaño máximo total: {$a->areasize}';
$string['memberincourse'] = 'Personas en el curso';
$string['menu'] = 'Menú';
$string['message'] = 'Mensaje';
$string['messagebody'] = 'Cuerpo del mensaje';
$string['messagedselectedusers'] = 'Se ha enviado un mensaje a los usuarios seleccionados y se ha reajustado la lista de receptores.';
$string['messagedselectedusersfailed'] = 'Algo ha salido mal al enviar mensajes a los usuarios seleccionados. Algunos pueden haber recibido el mensaje.';
$string['messageprovider:asyncbackupnotification'] = 'Notificaciones de respaldo/restauración asincrónicos';
$string['messageprovider:availableupdate'] = 'Notificaciones de actualización disponible';
$string['messageprovider:backup'] = 'Notificaciones de respaldo';
$string['messageprovider:badgecreatornotice'] = 'Notificaciones del creador de insignas';
$string['messageprovider:badgerecipientnotice'] = 'Notificaciones del receptor de insignas';
$string['messageprovider:competencyplancomment'] = 'Comentario publicado acerca de un plan de aprendizaje';
$string['messageprovider:competencyusercompcomment'] = 'Comentario publicado acerca de una competencia';
$string['messageprovider:coursecompleted'] = 'Curso completado';
$string['messageprovider:coursecontentupdated'] = 'Cambios de contenido del curso';
$string['messageprovider:courserequestapproved'] = 'Notificacíón de aprobación de solicitud de creación de curso';
$string['messageprovider:courserequested'] = 'Notificación de solicitud de creación de curso';
$string['messageprovider:courserequestrejected'] = 'Notificacíón de rechazo de solicitud de creación de curso';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Mensaje de bienvenida para nuevas inscripciones al grupo';
$string['messageprovider:errors'] = 'Errores importantes en el sitio';
$string['messageprovider:errors_help'] = 'Estos son errores importantes que un administrador debería de enterarse.';
$string['messageprovider:failedtaskmaxdelay'] = 'Retraso de trabajo que alcanza su máxima falla';
$string['messageprovider:gradenotifications'] = 'Notificaciones de calificación';
$string['messageprovider:infected'] = 'Notificaciones de falla del antivirus.';
$string['messageprovider:insights'] = 'Intuiciones generadas por modelos de predicción';
$string['messageprovider:instantmessage'] = 'Mensajes personales entre los usuarios';
$string['messageprovider:instantmessage_help'] = 'Esta sección configura lo que sucede con los mensajes que otros usuarios le han enviado en el sitio.';
$string['messageprovider:messagecontactrequests'] = 'Notificación de solicitudes de contacto de mensaje';
$string['messageprovider:newlogin'] = 'Notificaciones de nuevo ingreso';
$string['messageprovider:notices'] = 'Avisos sobre problemas menores';
$string['messageprovider:notices_help'] = 'Éstos son avisos que un administrador podría estar interesado en ver.';
$string['messageprovider:reportbuilderschedule'] = 'Agendas de constructor de reporte personalizado';
$string['messageselect'] = 'Seleccionar este usuario como receptor de mensaje';
$string['messageselectadd'] = 'Enviar mensaje';
$string['middlename'] = 'Segundo Nombre';
$string['migratinggrades'] = 'Migrando calificaciones';
$string['min'] = 'min';
$string['mins'] = 'mins';
$string['minute'] = 'minuto';
$string['minutes'] = 'minutos';
$string['miscellaneous'] = 'Misceláneos';
$string['missingcategory'] = 'Necesita elegir una categoría';
$string['missingdescription'] = 'Escribir: descripción';
$string['missingemail'] = 'Escribir: dirección de correo';
$string['missingfirstname'] = 'Escribir: nombre';
$string['missingfromdisk'] = 'Ausente del disco';
$string['missingfullname'] = 'Escribir: nombre completo';
$string['missinglastname'] = 'Falta apellido(s)';
$string['missingname'] = 'Escribir: nombre';
$string['missingnewpassword'] = 'Escribir: nueva contraseña';
$string['missingpassword'] = 'Escribir: contraseña';
$string['missingrecaptchachallengefield'] = 'Falló el reto reCAPTCHA; inténtelo de nuevo.';
$string['missingreqreason'] = 'Escribir: razón';
$string['missingshortname'] = 'Escribir: nombre corto';
$string['missingshortsitename'] = 'Escribir: nombre corto del sitio';
$string['missingsitedescription'] = 'Escribir: descripción del sitio';
$string['missingsitename'] = 'Escribir: nombre del sitio';
$string['missingstrings'] = 'Revisar palabras o frases sin traducir';
$string['missingstudent'] = 'Debe elegir algo';
$string['missingsummary'] = 'Falta resumen';
$string['missingteacher'] = 'Debe elegir algo';
$string['missingurl'] = 'Falta URL';
$string['missingusername'] = 'Falta nombre de usuario';
$string['moddoesnotsupporttype'] = 'El módulo {$a->modname} no soporta subida de archivos del tipo {$a->type}';
$string['modhide'] = 'Ocultar';
$string['modified'] = 'Modificado';
$string['modshow'] = 'Mostrar';
$string['moduleintro'] = 'Descripción';
$string['modulesetup'] = 'Instalando el módulo de tablas';
$string['modulesuccess'] = '{$a} tablas se han configurado correctamente';
$string['modulesused'] = 'Módulos usados';
$string['modvisible'] = 'Disponibilidad';
$string['modvisible_help'] = '* Mostrar en página de curso. Disponible para estudiantes (sujeto a cualquier restricción de acceso que podría estar configurada).
* Ocultar en página de curso. No disponible para estudiantes.';
$string['modvisiblehiddensection'] = 'Disponibilidad';
$string['modvisiblehiddensection_help'] = '* Ocultar en página de curso. No disponible para estudiantes.
* Hacer disponible pero no mostrar en página de curso. disponible para estudiantes si usted les proporciona un enlace. Las actividades seguirán apareciendo en el Libro de calificaciones y otros reportes.';
$string['modvisiblewithstealth'] = 'Disponibilidad';
$string['modvisiblewithstealth_help'] = '* Mostrar en página de curso. disponible a estudiantes (sujeto a cualquier restricción de acceso que podría estar configurada).
* Ocultar en página de curso. No disponible a estudiantes.
* Hacer disponible pero no mostrar en página de curso. Disponible para estudiantes si usted les proporciona un enlace. Las actividades seguirán apareciendo en el Libro de calificaciones y otros reportes.';
$string['month'] = 'Mes';
$string['months'] = 'Meses';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'Documentación para esta página';
$string['moodlelogo'] = 'Logo de Moodle';
$string['moodlenet:cannotconnecttoserver'] = 'No se puede conectar a servidor MoodleNet';
$string['moodlenet:columnname'] = 'Nombre';
$string['moodlenet:columnsenddate'] = 'Fecha de envío';
$string['moodlenet:columnsendstatus'] = 'Estado del envío';
$string['moodlenet:columntype'] = 'Tipo';
$string['moodlenet:configoauthservice'] = 'Seleccionar un servicio de OAuth 2 MoodleNet para habilitar compertir a ese sitio Moodle. Si el servicio aun no existe, usted necesitará  <a href="{$a}">crear</a>lo.';
$string['moodlenet:deletedactivity'] = 'Actividad eliminada';
$string['moodlenet:deletedcourse'] = 'Curso eliminado';
$string['moodlenet:eventresourceexported'] = 'Recurso exportado';
$string['moodlenet:gotomoodlenet'] = 'Ir a borradores MoodleNet';
$string['moodlenet:issuerisnotauthorized'] = 'Emisor MoodleNet no está autorizado';
$string['moodlenet:issuerisnotenabled'] = 'Emisor MoodleNet no está habilitado';
$string['moodlenet:issuerisnotset'] = 'Emisor MoodleNet no está configurado en administración del sitio';
$string['moodlenet:nosharedresources'] = 'No hay recursos compartidos para mostrar en este momento.';
$string['moodlenet:outboundsettings'] = 'Configuraciones de salida de MoodleNet';
$string['moodlenet:packagingandsending'] = 'Empacando su archivo y enviándolo a MoodleNet...';
$string['moodlenet:sharefailtext'] = 'Hubo un error al compartir su contenido a MoodleNet.<br>Por favor inténtelo de nuevo después.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Hubo un error al compartir su contenido a MoodleNet.<br>Por favor inténtelo de nuevo después o <a href="{$a}">póngase en contacto con el soporte del sitio</a>.';
$string['moodlenet:sharefailtitle'] = 'Algo salió mal';
$string['moodlenet:sharefilesizelimitexceeded'] = 'El tamaño del recurso que está siendo compartido ({$a->filesize} bytes) excede el límite de {$a->filesizelimit} bytes.';
$string['moodlenet:sharenoticeactivity'] = 'Esta actividad está siendo compartida con MoodleNet como un recurso.';
$string['moodlenet:sharenoticecourse'] = 'Este curso está siendo compartido con MoodleNet como un recurso.';
$string['moodlenet:sharenoticepartial'] = 'Las actividades seleccionadas están siendo compartidas con MoodleNet como un recurso.';
$string['moodlenet:sharenoticepartialactivitynumber'] = '{$a} actividades serán incluidas en el curso.';
$string['moodlenet:shareprogress'] = 'Progreso de compartir en MoodleNet';
$string['moodlenet:shareprogressinfo'] = 'La lista muestra cursos y actividades que usted ha compartido a MoodleNet.<br>Haga clic en el nombre del recurso para verlo en MoodleNet.';
$string['moodlenet:sharesuccesstext'] = '¡Casi terminamos! Visite sus borradores en MoodleNet para terminar de compartir su contenido.';
$string['moodlenet:sharesuccesstitle'] = 'Guardado a borradores de MoodleNet';
$string['moodlenet:sharetomoodlenet'] = 'Compartir a MoodleNet';
$string['moodlenet:sharinglargefile'] = 'Los archivos grandes pueden demorar un largo tiempo.';
$string['moodlenet:sharingstatus'] = 'Compartiendo a MoodleNet';
$string['moodlenet:sharingto'] = 'Compartiendo a:';
$string['moodlerelease'] = 'Lanzamiento de Moodle';
$string['moodleservicesandsupport'] = 'Servicios y soporte';
$string['moodleversion'] = 'Versión de Moodle';
$string['more'] = 'más';
$string['moreactions'] = 'Más acciones';
$string['morehelp'] = 'Más ayuda';
$string['morehelpaboutmodule'] = 'Más ayuda acerca de la actividad {$a}';
$string['moreinfo'] = 'Más información';
$string['moreinformation'] = 'Más información sobre este error';
$string['moremenu'] = 'Más';
$string['morenavigationlinks'] = 'Más...';
$string['moreprofileinfoneeded'] = 'Por favor, díganos algo acerca de Usted';
$string['mostrecently'] = 'más recientes';
$string['move'] = 'Mover';
$string['movecategoriessuccess'] = 'Se movieron exitosamente  {$a->count} categorías hacia adentro de la categoría \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Se movieron exitosamente {$a->count} categorías al nivel superior';
$string['movecategorycontentto'] = 'Mover a';
$string['movecategorysuccess'] = 'Se movió exitosamente la categoría \'{$a->moved}\' hacia adentro de la categoría \'{$a->to}\'';
$string['movecategoryto'] = 'Mover categoría a:';
$string['movecategorytotopsuccess'] = 'Se movió exitosamente la categoría \'{$a->moved}\' al nivel superior';
$string['movecontent'] = 'Mover {$a}';
$string['movecontentafter'] = 'Después de "{$a}"';
$string['movecontentstoanothercategory'] = 'Mover el contenido a otra categoría';
$string['movecontenttothetop'] = 'En la parte superior de la lista';
$string['movecoursemodule'] = 'Mover actividad';
$string['movecoursesection'] = 'Mover sección';
$string['movecourseto'] = 'Mover curso a:';
$string['movedown'] = 'Mover hacia abajo';
$string['movefilestohere'] = 'Colocar archivos aquí';
$string['movefull'] = 'Mover {$a} a este lugar';
$string['movehere'] = 'Colocar aquí';
$string['moveitemdown'] = 'Mover {$a} abajo';
$string['moveitemup'] = 'Mover {$a} arriba';
$string['moveleft'] = 'Mover a la izquierda';
$string['moveright'] = 'Mover a la derecha';
$string['movesection'] = 'Mover sección {$a}';
$string['moveselectedcategoriesto'] = 'Mover categorías seleccionadas a';
$string['moveselectedcoursesto'] = 'Mover los cursos seleccionados a...';
$string['movetoanotherfolder'] = 'Mover a otro directrorio';
$string['moveup'] = 'Mover hacia arriba';
$string['multipleitemsfound'] = 'Hay {$a} elementos encontrados.';
$string['mustchangepassword'] = 'La nueva contraseña debe ser diferente a la actual';
$string['mustconfirm'] = 'Necesita confirmar su cuenta';
$string['mycourses'] = 'Mis cursos';
$string['myfiles'] = 'Mis archivos privados';
$string['myfilesmanage'] = 'Gestionar mis archivos privados';
$string['myhome'] = 'Tablero';
$string['mymoodledashboard'] = 'Mi Tablero de control Moodle';
$string['myprofile'] = 'Mi perfil';
$string['name'] = 'Nombre';
$string['namedfiletoolarge'] = 'El archivo \'{$a->filename}\' es demasiado grande y no puede subirse';
$string['nameforlink'] = '¿Cómo quiere llamar a este enlace?';
$string['nameforpage'] = 'Nombre';
$string['navigation'] = 'Navegación';
$string['needed'] = 'Necesario';
$string['networkdropped'] = 'Hemos detectado que su conexión de Internet no es constante o ha sido interrumpida.<br />
Por favor, tenga en cuenta que sus cambios puede que no se guarden hasta que mejore su conexión.';
$string['never'] = 'Nunca';
$string['neverdeletelogs'] = 'Nunca borrar bitácoras';
$string['new'] = 'Nuevo';
$string['newaccount'] = 'Nueva cuenta';
$string['newactivityname'] = 'Nuevo nombre para actividad {$a}';
$string['newcourse'] = 'Nuevo curso';
$string['newloginnotificationbodyfull'] = '<p>Hola {$a->userfullname},</p>
<p>Su cuenta {$a->sitename} acaba de ser firmada desde un dispositivo nuevo.</p>
<ul>
<li>Su cuenta: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Dispositivo: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Si este era usted, entonces no necesita hacer nada.</p>
<p>Si usted no reconoce esta actividad, por favor  <a href="{$a->changepasswordlink}">cambie su contraseña</a></p>';
$string['newloginnotificationbodysmall'] = 'Su cuenta {$a} acaba de ingresar desde un dispositivo nuevo.';
$string['newloginnotificationtitle'] = 'Nuevo ingreso a su cuenta {$a}';
$string['newpassword'] = 'Nueva contraseña';
$string['newpassword_help'] = 'Escriba una nueva contraseña o déjelo en blanco para mantener la contraseña actual.';
$string['newpasswordfromlost'] = '<strong>AVISO:</strong> Su<strong>Contraseña actual</strong> ha sido enviada en el <strong>segundo</strong> de los dos correos electrónicos enviados como parte del proceso de recuperación de la contraseña perdida. Asegúrese de que ha recibido la nueva contraseña antes de continuar con esta pantalla.';
$string['newpasswordtext'] = 'Hola, {$a->firstname}.

La contraseña de su cuenta en \'{$a->sitename}\' se ha cancelado y se le ha otorgado una nueva contraseña temporal.

Su nueva información de acceso es: usuario : {$a->username} Contraseña: {$a->newpassword}

Diríjase por favor a esta página y cambie su contraseña temporal por una que pueda recordar mejor: {$a->link}

En la mayoría de los programas de correo electrónico el enlace anterior aparecerá como una línea de texto en azul sobre la que puede hacer clic. Si eso no sucede, copie y pegue la dirección en la barra de direcciones de su navegador.

Saludos de parte del Administrador de \'{$a->sitename}\', {$a->signoff}';
$string['newpicture'] = 'Imagen nueva';
$string['newpicture_help'] = 'Para añadir una imagen nueva, navegue y seleccione una imagen (en formato JPG o PNG) y después haga clic en "Actualizar perfil". La imagen será recortada a un cuadrado y escalada a 100 * 100 pixeles.';
$string['newpictureusernotsetup'] = 'Solamente puede añadirse una imagen de perfil una vez que se haya guardaddo toda la información requerida del perfil.';
$string['newsectionname'] = 'Nuevo nombre para la sección {$a}';
$string['newsitem'] = 'elemento de noticias';
$string['newsitems'] = 'avisos';
$string['newsitemsnumber'] = 'Número de avisos';
$string['newsitemsnumber_help'] = 'El foro de avisos tiene suscripción forzada configurada por defecto. Solamente los profesores y usuarios con permisos apropiados pueden publicar en él.

Si no se necesita un foro de avisos en el curso, configure esto a cero.

Esta configuración también  determina cuantos avisos recientes aparecen en el bloque de avisos recientes.';
$string['newuser'] = 'Nuevo usuario';
$string['newusernewpasswordsubj'] = 'Cuenta de nuevo usuario';
$string['newusernewpasswordtext'] = 'Hola {$a->firstname},

Se ha creado una cuenta para usted en \'{$a->sitename}\'.

   usuario: {$a->username}
   contraseña: {$a->newpassword}

(Se te solicitará que cambie ts contraseña cuando inicie sesión por primera vez).

Para comenzar a usar \'{$a->sitename}\', inicie sesión en
{$a->link}

Si necesita ayuda, comuníquese con el administrador del sitio,
{$a->signoff}';
$string['newusers'] = 'Nuevos usuarios';
$string['newwindow'] = 'Nueva ventana';
$string['next'] = 'Siguiente';
$string['nextpage'] = 'Página siguiente';
$string['nextsection'] = 'Siguiente sección';
$string['no'] = 'No';
$string['noblockstoaddhere'] = 'No existen bloques que pueda agregar a esta página.';
$string['nobody'] = 'Nadie';
$string['nochange'] = 'Sin cambios';
$string['nocomments'] = 'No hay comentarios';
$string['nocourses'] = 'Sin cursos';
$string['nocoursesfound'] = 'No se encontraron cursos con las palabras \'{$a}\'';
$string['nocoursestarttime'] = 'El curso no tiene una fecha de inicio.';
$string['nocoursesyet'] = 'No hay cursos en esta categoría';
$string['nodstpresets'] = 'El administrador no ha activado el soporte para horario de verano (Daylight Savings Time). ¡Es importante recordar que el horario de verano para México es (del primer domingo de abril al último domingo de octubre)  diferente al de Estados Unidos (del segundo domingo de marzo al primer domingo de noviembre) El estado de Sonora no tiene horario de verano, similar a su vecino del norte, Arizona. Los estados de Sinaloa, Chihuahua y Baja California Sur tienen una hora más tarde, Baja California Norte dos horas más tarde.

La hora oficial en México está definida en http://www.cenam.mx/hora_oficial/';
$string['nofilesselected'] = 'No se ha seleccionado ningún archivo para restaurar';
$string['nofilesyet'] = 'Aún no se han subido archivos a su curso';
$string['nofiltersapplied'] = 'Sin filtros aplicados';
$string['nograde'] = 'No hay calificación';
$string['nohelpforactivityorresource'] = 'Actualmente no hay ayuda asociada con este recurso o actividad';
$string['noimagesyet'] = 'Aún no se han subido  imágenes a su curso';
$string['noitemsfound'] = 'No se encontraron elementos.';
$string['nologsfound'] = 'No se encontraron bitácoras';
$string['nomatchingusers'] = 'Ningún usuario coincide con \'{$a}\'';
$string['nomorecourses'] = 'No se encontraron más cursos que cumplan el criterio';
$string['nomoreidnumber'] = 'No se usa un número de identificación para evitar colisiones';
$string['none'] = 'Ninguno(a)';
$string['noneditingteacher'] = 'Profesor sin permiso de edición';
$string['noneditingteacherdescription'] = 'Los profesores sin permiso de edición pueden enseñar en los cursos y calificar a los estudiantes, pero no pueden modificar las actividades.';
$string['nonstandard'] = 'No estándar';
$string['nopendingcourses'] = 'No hay cursos pendientes de aprobación';
$string['nopotentialadmins'] = 'No hay administradores potenciales';
$string['nopotentialcreators'] = 'No hay creadores potenciales';
$string['nopotentialstudents'] = 'No hay estudiantes potenciales';
$string['nopotentialteachers'] = 'No hay profesores potenciales';
$string['norecentactivity'] = 'No hay actividad reciente';
$string['noreplybouncemessage'] = 'Ha respondido a una dirección \'no-responder\' (no-replu). Si está intentando responder a un mensaje de foro, use por favor los foros {$a}.

Éste es el contenido de su correo:';
$string['noreplybouncesubject'] = '{$a} - correo devuelto.';
$string['noreplyname'] = 'No contestar a este correo';
$string['noresetrecord'] = 'No existe registro para esa solicitud de reinicio. Por favor empiece una nueva solicitud de reinicio de contraseña.';
$string['noresults'] = 'No hay resultados';
$string['noresultsfor'] = 'Sin resultados para "{$a}"';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Búsqueda normal';
$string['nosite'] = 'No se encontró curso en el nivel de sitio';
$string['nostudentsfound'] = 'No se encuentra {$a}';
$string['nostudentsingroup'] = 'Aún no hay estudiantes en este grupo';
$string['nostudentsyet'] = 'No hay estudiantes inscritos en este curso.';
$string['nosuchemail'] = 'No existe esa dirección de correo';
$string['notavailable'] = 'No disponible';
$string['notavailablecourse'] = '{$a} no está disponible';
$string['noteachersyet'] = 'Aún no hay profesores en este curso';
$string['noteachingupcomingcourses'] = 'Los cursos siguientes no tienen profesores o estudiantes';
$string['notenrolled'] = '{$a} no está inscrito en este curso.';
$string['notenrolledprofile'] = 'Este perfil no está disponible porque el usuario no está inscrito en este curso.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Nota:<strong>La capacidad de mover fechas al restaurar este respaldo se ha desactivado porque no tiene los permisos necesarios.';
$string['noteuserschangednonetocourse'] = '<strong>Nota:<strong>Los usuarios de los cursos deben ser restaurados cuando se restauran los datos de usuario (en actividades, archivos o mensajes). Esta configuración ha sido cambiada para usted.';
$string['nothingnew'] = 'Sin actividad reciente';
$string['nothingtodisplay'] = 'Nada que mostrar';
$string['notice'] = 'Aviso';
$string['noticenewerbackup'] = 'Este respaldo ha sido creada con Moodle {$a->backuprelease} ({$a->backupversion}) y es más reciente que la versión instalada de Moodle {$a->serverrelease} ({$a->serverversion}). Esto podría ocasionar algunas inconsistencias debido a que no se puede garantizar la compatibilidad retroactiva de los respaldos.';
$string['notifications'] = 'Notificaciones';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Usuario: {$a->info}. Nombre completo del usuario: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Usted puede ver estas bitácoras en {$a}';
$string['notifyloginfailuresmessagestart'] = 'Listado de intentos fallidos de ingreso a {$a} desde que se le envió la última notificación';
$string['notifyloginfailuressubject'] = '{$a} :: Notificación de intentos fallidos de ingreso';
$string['notincluded'] = 'No incluido';
$string['notingroup'] = 'Lo sentimos, pero Usted necesita ser miembro de un grupo  para ver esta página.';
$string['notpublic'] = '¡No es público!';
$string['nousersfound'] = 'No se encuentran usuarios';
$string['nousersmatching'] = 'No se encontraron usuarios con \'{$a}\'';
$string['nousersyet'] = 'Aún no hay usuarios';
$string['novalidcourses'] = 'No hay cursos válidos para mostrar';
$string['now'] = 'ahora';
$string['numattempts'] = '{$a} intento(s) fallido(s) de ingreso';
$string['numberofcourses'] = 'Número de cursos';
$string['numberweeks'] = 'Número de secciones';
$string['numday'] = 'día {$a}';
$string['numdays'] = '{$a} días';
$string['numhours'] = '{$a} horas';
$string['numletters'] = '{$a} letras';
$string['numminutes'] = '{$a} minutos';
$string['nummonth'] = 'mes {$a}';
$string['nummonths'] = '{$a} meses';
$string['numseconds'] = '{$a} segundos';
$string['numviews'] = '{$a} vistas';
$string['numweek'] = 'semana  {$a}';
$string['numweeks'] = '{$a} semanas';
$string['numwords'] = '{$a} palabras';
$string['numyear'] = 'año  {$a}';
$string['numyears'] = '{$a} años';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Contraseña actual';
$string['olduserdirectory'] = 'Éste es el ANTIGUO directorio de usuarios, y ya no es necesario. Puede eliminarlo con seguridad. Los archivos que contiene se han copiado al NUEVO directorio de usuarios.';
$string['oneitemfound'] = 'Hay 1 elemento encontrado.';
$string['opendrawerblocks'] = 'Abrir cajón del bloque';
$string['opendrawerindex'] = 'Abrir índice del curso';
$string['opensinnewwindow'] = 'Abre en ventana nueva';
$string['operator_and'] = 'y';
$string['operator_andnot'] = 'y';
$string['operator_or'] = 'o';
$string['optional'] = 'opcional';
$string['options'] = 'opciones';
$string['order'] = 'Ordenar';
$string['originalpath'] = 'Ruta original';
$string['orphanedactivitiesinsectionno'] = 'Actividades huéranas (sección {$a})';
$string['other'] = 'Otro';
$string['outline'] = 'Esquema';
$string['outlinereport'] = 'Reporte del esquema';
$string['page'] = 'Página';
$string['pagea'] = 'Página {$a}';
$string['pagedcontentnavigation'] = 'Navegación de paginación';
$string['pagedcontentnavigationactiveitem'] = 'Página actual, página {$a}';
$string['pagedcontentnavigationitem'] = 'Ir a página {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Mostrar {$a} elementos por página';
$string['pageheaderconfigablock'] = 'Configurando un bloque en {%fullname%}';
$string['pagepath'] = 'Ruta a la página';
$string['pageshouldredirect'] = 'Esta página debería redireccionar automáticamente. Si no ocurre nada, por favor utilice el enlace de continuar que aparece más abajo.';
$string['parentcategory'] = 'Categoría padre';
$string['parentcoursenotfound'] = '¡Curso raíz no encontrado!';
$string['parentfolder'] = 'Directorio raíz';
$string['participants'] = 'Participantes';
$string['participantslist'] = 'Lista de participantes';
$string['participationratio'] = 'Tasa de participación';
$string['participationreport'] = 'Reporte de participación';
$string['password'] = 'Contraseña';
$string['passwordchanged'] = 'La contraseña ha cambiado';
$string['passwordextlink'] = 'Este enlace sirve para recuperar su contraseña perdida y requiere salir de Moodle.';
$string['passwordforgotten'] = 'Contraseña olvidada';
$string['passwordforgotteninstructions'] = 'Sus detalles deben encontrarse primero en la base de datos del usuario. Por favor, escriba <strong>o bien</strong> su nombre de usuario o bien su dirección registrada de correo electrónico en el recuadro apropiado. No es necesario escribir ambos.';
$string['passwordforgotteninstructions2'] = 'Para reajustar su contraseña, envíe su nombre de usuario o su dirección de correo electrónico. Si podemos encontrarlo en la base de datos, le enviaremos un email con instrucciones para poder acceder de nuevo.';
$string['passwordpolicynomatch'] = 'Su contraseña actual ya no coincide con la política para configurar contraseña.
   {$a}';
$string['passwordsdiffer'] = 'Las contraseñas son diferentes';
$string['passwordset'] = 'Su contraseña ha sido configurada';
$string['path'] = 'Ruta';
$string['pathnotexists'] = '¡Esta ruta no existe en su servidor!';
$string['pathslasherror'] = 'La ruta no puede terminar con una barra diagonal';
$string['paymentinstant'] = 'Utilice el botón de abajo para pagar y poder inscribirse en minutos.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> pendiente</small>)';
$string['paymentrequired'] = 'Este curso requiere un pago para entrar.';
$string['payments'] = 'Pagos';
$string['paymentsorry'] = 'Gracias por su pago. Una vez procesado, podrá acceder al curso {$a->fullname}. Espere y vuelva a intentarlo. Si sigue teniendo problemas, contacte con el {$a->teacher} o con el administrador del sitio.';
$string['paymentthanks'] = 'Gracias por su pago. Usted ya está inscrito en el curso: {$a}.';
$string['pendingrequests'] = 'Solicitudes pendientes';
$string['percents'] = '{$a} %';
$string['periodending'] = 'Fin del período ({$a})';
$string['perpage'] = 'Por página';
$string['perpagea'] = 'Por página: {$a}';
$string['personal'] = 'Personal';
$string['personalprofile'] = 'Información personal';
$string['phone'] = 'Teléfono';
$string['phone1'] = 'Teléfono';
$string['phone2'] = 'Teléfono móvil';
$string['phpinfo'] = 'Información PHP';
$string['picture'] = 'Imagen';
$string['pictureof'] = 'Imagen de {$a}';
$string['pictureofuser'] = 'Imagen del usuario';
$string['placeholdertypeorselect'] = 'Escribir o seleccionar...';
$string['pleaseclose'] = 'Por favor, cierre ahora esta ventana.';
$string['pleasesearchmore'] = 'Por favor, busque algo más';
$string['pleaseusesearch'] = 'Por favor, use la búsqueda';
$string['plugin'] = 'Plugin';
$string['pluginarea'] = 'Área';
$string['plugincheck'] = 'Comprobación de plugins';
$string['plugindeletefiles'] = 'Todos los datos asociados con el plugin \'{$a->name}\' han sido eliminados de la base de datos. Para prevenir que el plugin se reinstale por sí mismo, debería eliminar ahora el directorio de su servidor: {$a->directory}';
$string['pluginitemid'] = 'ID del elemento';
$string['pluginmissingfromdisk'] = '{$a->name} (Faltante en el disco)';
$string['pluginsetup'] = 'Ajustando tablas de plugins';
$string['policyaccept'] = 'Entiendo y estoy de acuerdo';
$string['policyagree'] = 'Usted deberá estar de acuerdo con estas condiciones antes de seguir usando este sitio. ¿Está de acuerdo?';
$string['policyagreement'] = 'Acuerdo con las Condiciones del Sitio';
$string['policyagreementclick'] = 'Acuerdo con la política del sitio';
$string['popup'] = 'emergente';
$string['popupwindow'] = 'Abrir el archivo en una ventana nueva';
$string['popupwindowname'] = 'Ventana emergente';
$string['post'] = 'Publicar';
$string['posts'] = 'Mensajes';
$string['potentialadmins'] = 'Administradores potenciales';
$string['potentialcreators'] = 'Creadores potenciales';
$string['potentialstudents'] = 'Estudiantes potenciales';
$string['potentialteachers'] = 'Profesores potenciales';
$string['poweredbymoodle'] = 'Impulsado por <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Preferencias';
$string['preferredlanguage'] = 'Idioma preferido';
$string['preferredtheme'] = 'Tema preferido';
$string['preprocessingbackupfile'] = 'Procesando el archivo de respaldo';
$string['prev'] = 'Previo';
$string['preview'] = 'Vista previa';
$string['previeworchoose'] = 'Vista previa o elegir un tema';
$string['previewthemename'] = 'Previsualizar tema \'{$a}\'';
$string['previous'] = 'Anterior';
$string['previouslyselectedusers'] = 'Usuarios previamente seleccionados que no coinciden con \'{$a}\'';
$string['previouspage'] = 'Página anterior';
$string['previoussection'] = 'Sección anterior';
$string['primaryadminsetup'] = 'Configurar la cuenta del administrador';
$string['privacy:metadata:config_log'] = 'La bitácora de cambios de configuración.';
$string['privacy:metadata:config_log:name'] = 'El nombre de los cambios de configuración.';
$string['privacy:metadata:config_log:oldvalue'] = 'El valor anterior para esta configuración.';
$string['privacy:metadata:config_log:plugin'] = 'El plugin modificado';
$string['privacy:metadata:config_log:timemodified'] = 'La hora en la que fue hecho el cambio.';
$string['privacy:metadata:config_log:userid'] = 'El usuario que hizo el cambio.';
$string['privacy:metadata:config_log:value'] = 'El nuevo valor para la configuración.';
$string['privacy:metadata:events_queue'] = 'La cola de eventos del usuario que esperan para ser procesados.';
$string['privacy:metadata:events_queue:eventdata'] = 'Los datos almacenados en el evento.';
$string['privacy:metadata:events_queue:stackdump'] = 'Cualquier stacktrace asociado con este evento.';
$string['privacy:metadata:events_queue:timecreated'] = 'La hora en la cual fue creado este evento.';
$string['privacy:metadata:events_queue:userid'] = 'La ID del usuario asociado con este evento';
$string['privacy:metadata:log'] = 'Una colección de eventos anteriores';
$string['privacy:metadata:log:action'] = 'Una descripción de la acción';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'curso';
$string['privacy:metadata:log:info'] = 'Información adicional';
$string['privacy:metadata:log:ip'] = 'La dirección IP usada al momento del evento';
$string['privacy:metadata:log:module'] = 'módulo';
$string['privacy:metadata:log:time'] = 'El momento cuando tuvo lugar la acción';
$string['privacy:metadata:log:url'] = 'La URL relacionada con el evento';
$string['privacy:metadata:log:userid'] = 'La ID del usuario que efectuó la acción';
$string['privacy:metadata:moodlenet_share_progress'] = 'Detalles de progreso de compartición MoodleNet';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'La ID del módulo de curso asociado';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'La ID del curso asociado';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'La URL regresada de MoodleNet después de una compartición exitosa';
$string['privacy:metadata:moodlenet_share_progress:status'] = 'El estado resultante de la compartición';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'La hora de cuando fue realizada la compartición';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'El tipo de compartición que fue realizada';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'El usuario que realizó la compartición';
$string['privacy:metadata:oauth2_refresh_token'] = 'Token de refresco usado en comunicación OAuth 2.0';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'La ID del emisor a quien corresponde el token';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'La ID del usuario a quien corresponde el token';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'La hora de cuando fue creado el token';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'La hora de cuando fue actualizado por ultima vez el token';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'El token de refresco para los alcances (scopes) y usuario respectivos';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'La ID del usuario a quien corresponde el token';
$string['privacy:metadata:task_adhoc'] = 'El estado de los trabajos ad-hoc.';
$string['privacy:metadata:task_adhoc:component'] = 'El componente propietario del trabajo.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'La hora más temprana para ejecutar este trabajo.';
$string['privacy:metadata:task_adhoc:userid'] = 'El usuario para correr el trabajo como él.';
$string['privacy:metadata:task_log'] = 'Salida de bitácora para una bitácora';
$string['privacy:metadata:task_log:component'] = 'El componente propietario del trabajo.';
$string['privacy:metadata:task_log:userid'] = 'El usuario a quien pertenece el trabajo.';
$string['privacy:metadata:upgrade_log'] = 'La bitácora de actualización.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Cualquier backtrace asociado con este paso de actualización.';
$string['privacy:metadata:upgrade_log:details'] = 'Información extra relacionada con la actualización.';
$string['privacy:metadata:upgrade_log:info'] = 'La información principal para este paso de la actualización.';
$string['privacy:metadata:upgrade_log:plugin'] = 'El plugin que fue actualizado.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'La nueva versión a la cual actualizar.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'La hora en  la que tuvo lugar la actualización.';
$string['privacy:metadata:upgrade_log:type'] = 'El tipo de entrada de bitácora.';
$string['privacy:metadata:upgrade_log:userid'] = 'El usuario que ejecutó la actualización.';
$string['privacy:metadata:upgrade_log:version'] = 'La versión antigua del plugin.';
$string['private_files_handler'] = 'Almacenar los anexoa a un E-mail dentro del espacio de almacenamiento de archivos privados del usuario.';
$string['private_files_handler_name'] = 'E-mail a Archivos privados';
$string['privatefiles'] = 'Archivos privados';
$string['privatefilesmanage'] = 'Gestionar archivos privados';
$string['proceed'] = 'Proceder';
$string['profile'] = 'Perfil';
$string['profilenotshown'] = 'Esta descripción de perfil no se mostrará hasta que esta persona se inscriba al menos en un curso.';
$string['progress'] = 'Progreso';
$string['publicprofile'] = 'Perfil público';
$string['publicsitefileswarning'] = 'Nota: cualquiera puede ver los archivos colocados aquí';
$string['publicsitefileswarning2'] = 'Nota: Los archivos colocados aquí pueden ser vistos por cualquiera que conozca (o pueda adivinar) la URL. Por razones de seguridad, se recomienda que los archivos de cualquier respaldo se eliminen inmediatamente después de restaurarlos.';
$string['publicsitefileswarning3'] = 'Nota: Los archivos colocados aquí pueden ser vistos por cualquiera que conozca (o pueda adivinar) la URL. <br />Por razones de seguridad, se recomienda que los archivos de cualquier respaldo se eliminen inmediatamente después de restaurarlos.';
$string['question'] = 'Pregunta';
$string['questionsinthequestionbank'] = 'Preguntas en el banco de preguntas';
$string['queued'] = 'Puesto en cola';
$string['quotausage'] = 'Actualmente Usted ha usado {$a->used} de sus {$a->total} límite.';
$string['readinginfofrombackup'] = 'Leyendo información del respaldo';
$string['readme'] = 'LÉAME';
$string['recentactivity'] = 'Actividad reciente';
$string['recentactivityreport'] = 'Reporte completo de la actividad reciente...';
$string['recipientslist'] = 'Lista de receptores';
$string['recommended'] = 'Recomendado';
$string['recreatedcategory'] = 'Categoría recreada {$a}';
$string['redirect'] = 'Redireccionar';
$string['reducesections'] = 'Reducir el número de secciones';
$string['refresh'] = 'Refrescar';
$string['refreshingevents'] = 'Refrescando eventos';
$string['registration'] = 'Registro de Moodle';
$string['registrationcontact'] = 'Contacto del público';
$string['registrationcontactno'] = 'No, no deseo user contactado por otras personas';
$string['registrationcontactyes'] = 'Sí, proporcióneme un formato para que otros Moodlers me contacten';
$string['registrationemail'] = 'Notificaciones por correo electrónico';
$string['registrationinfo'] = '<p>Esta página le permite registrar su sitio Moodle en moodle.org. El registro es gratuito. El principal beneficio del registro es que usted será incluido en una lista de correo de bajo volumen para notificaciones importantes como alertas de seguridad y nuevos lanzamientos de Moodle.</p> <p>Su información será confidencial, y nunca será vendida o transmitida a nadie más. La única razón para recopilar esta información es prestarle apoyo y ayudar a costruir un cuadro estadístico de la comunidad Moodle.</p> <p>Si lo desea, puede escribir el nombre de su sitio, país y URL para que aparezca en la lista pública de los sitios que usan Moodle.</p> <p>Todos los registros son verificados manualmente antes de ser colocados en la lista, pero una vez en ella, puede actualizar su registro (y sus datos en la lista pública) en cualquier momento rellenando de nuevo este formato.</p>';
$string['registrationinfotitle'] = 'Información de registro';
$string['registrationsend'] = 'Enviar mi información de registro a moodle.org';
$string['registrationyes'] = 'Si, envíenme notificaciones sobre nuevas versiones liberadas de Moodle, alertas de seguridad y otras noticias importantes';
$string['reject'] = 'Rechazar';
$string['rejectdots'] = 'Rechazar...';
$string['relativedatesmode'] = 'Modo de fechas relativas';
$string['relativedatesmode_help'] = 'Mostrar fechas de curso o actividad relativas a la fecha de inicio del usuario en el curso.

La fecha de inicio del curso del usuario será su fecha de inicio de la inscripción, a menos que sean inscritos antes de que el curso principie, en cuyo caso sus fechas de inicio serán la fecha de inicio del curso.

ADVERTENCIA: Esta es una característica experimental y es posible que no todas las actividades la soporten. Una vez que el curso haya sido creado, esta configuración del curso ya no podrá ser cambiada.';
$string['relativedatesmode_warning'] = '<strong>Advertencia:</strong> El modo de fechas relativas no puede ser cambiado una vez que el curso haya sido creado.';
$string['reload'] = 'Recargar';
$string['remoteappuser'] = 'Usuario {$a} remoto';
$string['remove'] = 'Quitar';
$string['removeadmin'] = 'Quitar administrador';
$string['removecreator'] = 'Quitar creador';
$string['removed'] = 'Eliminado {$a}';
$string['removestudent'] = 'Quitar estudiante';
$string['removeteacher'] = 'Quitar profesor';
$string['rename'] = 'Renombrar';
$string['renamefileto'] = 'Renombrar <b>{$a}</b> a';
$string['report'] = 'Reporte';
$string['reports'] = 'Reportes';
$string['reporttype'] = 'Tipo de reporte';
$string['repositories'] = 'Repositorios';
$string['requestcourse'] = 'Solicitar un curso';
$string['requestedby'] = 'Solicitado por';
$string['requestedcourses'] = 'Cursos solicitados';
$string['requestreason'] = 'Razón para solicitar el curso';
$string['requests'] = 'Solicitudes';
$string['required'] = 'Obligatorio';
$string['requirespayment'] = 'Para acceder a este curso es preciso pagar';
$string['resendemail'] = 'Re-enviar Email de confirmación';
$string['reset'] = 'Reiniciar';
$string['resetcomponent'] = 'Componente';
$string['resetcourse'] = 'Reiniciar curso';
$string['resetcourseconfirm'] = '¿Reiniciar curso?';
$string['resetcoursewarning'] = '¿Está seguro de querer reiniciar el curso \'{$a}\'?
<br/><br/>
Esto eliminará los datos seleccionados y reiniciará el curso de regreso a su estado original. Usted no puede deshacer esta acción.';
$string['resetinfo'] = 'Esta característica le permite eliminar todos los datos del usuario y reiniciar este curso a su estado original. Las actividades del curso y configuraciones permanecen intactas.';
$string['resetinfoselect'] = 'Seleccionar los datos que desea eliminar o reiniciar de entre las categorías debajo:';
$string['resetnotimplemented'] = 'Reinicialización no soportada';
$string['resetnotimplementedinfo'] = 'Estas actividades no se pueden reiniciar:';
$string['resetrecordexpired'] = 'El enlace para reiniciar contraseña que Usted usó tiene más de {$a} minutos de antigüedad y ha expirado. Por favor, inicie un nuevo reinicio de contraseña.';
$string['resetstartdate'] = 'Reajustar fecha inicial';
$string['resetstatus'] = 'Estatus';
$string['resettable'] = 'Reiniciar  preferencias de tabla';
$string['resettask'] = 'Reiniciar';
$string['resettodefaults'] = 'Reajustar a valores por defecto';
$string['resortcourses'] = 'Ordenar cursos';
$string['resortsubcategoriesby'] = 'Ordenar subcategorías por {$a} ascendente';
$string['resortsubcategoriesbyreverse'] = 'Ordenar subcategorías por {$a} descendente';
$string['resource'] = 'Recurso';
$string['resource_type'] = 'Tipo de recurso';
$string['resourcedisplayauto'] = 'Automático';
$string['resourcedisplaydownload'] = 'Forzar descarga';
$string['resourcedisplayembed'] = 'Incrustar';
$string['resourcedisplayframe'] = 'En el marco';
$string['resourcedisplaynew'] = 'Nueva ventana';
$string['resourcedisplayopen'] = 'Abrir';
$string['resourcedisplaypopup'] = 'En ventana emergente';
$string['resources'] = 'Recursos';
$string['resources_help'] = 'Los tipos de recurso posibilitan que prácticamente cualquier contenido web se pueda insertar en el curso.';
$string['restore'] = 'Restaurar';
$string['restorecancelled'] = 'Cancelada la restauración';
$string['restorecannotassignroles'] = 'La restauración necesita asignar roles y usted carece de permiso para hacerlo';
$string['restorecannotcreateorassignroles'] = 'La restauración necesita crear o asignar roles y usted carece de permiso para hacerlo';
$string['restorecannotcreateuser'] = 'La restauración necesita crear un usuario \'{$a}\' a partir del respaldo y usted carece de permiso para hacerlo';
$string['restorecannotoverrideperms'] = 'La restauración necesita anular permisos y usted carece de permiso para hacerlo';
$string['restorecoursenow'] = '¡Restaurar este curso ahora!';
$string['restoredaccount'] = 'Cuenta restaurada';
$string['restoredaccountinfo'] = 'Esta cuenta se ha importado de otro servidor y la contraseña se ha perdido. Para fijar una nueva contraseña por email, haga clic en "Continuar"';
$string['restorefinished'] = 'Restauración completada con éxito';
$string['restoreinfo'] = 'Usar un archivo de respaldo para restaurar a una versión previa de un curso, o para crear un nuevo curso.';
$string['restoremnethostidmismatch'] = 'La ID del host MNet del usuario  \'{$a}\' no concuerda con la ID del host MNet local.';
$string['restoreto'] = 'Restaurar a';
$string['restoretositeadding'] = 'Advertencia: ¡Está a punto de restaurar a la página de inicio del sitio, añadiéndole datos!';
$string['restoretositedeleting'] = 'Advertencia: ¡Está a punto de restaurar a la página de inicio del sitio, eliminando la información anterior!';
$string['restoreuserconflict'] = 'Tratar de restaurar al usuario \'{$a}\' a partir del archivo de respaldo causará un conflicto';
$string['restoreuserinfofailed'] = 'El proceso de restauración se ha detenido porque usted no tiene permiso para restaurar datos de usuario.';
$string['restoreusersprecheck'] = 'Comprobando los datos de usuario';
$string['restoreusersprecheckerror'] = 'Se han detectado problemas en la comprobación de los datos de usuario';
$string['restricted'] = 'Restringido';
$string['resultsfound'] = '{$a} resultados encontrados';
$string['retry'] = 'Reintentar';
$string['returningtosite'] = 'Usuarios registrados';
$string['returntooriginaluser'] = 'Volver a {$a}';
$string['revert'] = 'Revertir';
$string['role'] = 'Rol';
$string['roleassignments'] = 'Asignaciones de roles';
$string['rolemappings'] = 'Mapeos de rol';
$string['rolerenaming'] = 'Renombrar rol';
$string['rolerenaming_help'] = 'Cambiar los nombres mostrados en los roles en este curso';
$string['rolerenaming_success'] = 'Nombres de roles del curso actualizados.';
$string['roles'] = 'Roles';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Número de artículos recientes RSS';
$string['rsserror'] = 'Error al leer datos RSS';
$string['rsserrorauth'] = 'Su enlace RSS no contiene una ficha (token) de autenticación válida.';
$string['rsserrorguest'] = 'Esta fuente utiliza el acceso de invitados para acceder a los datos, pero el invitado no tiene permiso para leer los datos. Visite la ubicación original de la que esta fuente proviene (URL) como un usuario válido y obtenga de allí un nuevo enlace RSS.';
$string['rsskeyshelp'] = '<p>Para garantizar la seguridad y la privacidad, las direcciones URL RSS feed contienen una ficha (token) especial que identifica al usuario para el que son. Esto impide que otros usuarios accedan a áreas de Moodle a las que no deben tener acceso. </p><p> Este token se crea automáticamente la primera vez que accede a un área de Moodle, que produce una fuente RSS. Si usted piensa que su token de fuente RSS ha sido comprometido de alguna manera, Usted puede solicitar uno nuevo haciendo clic en el vínculo para Restablecer enlace. Por favor tenga en cuenta que la URL de su fuente RSS actual dejará de ser válida.';
$string['rsstype'] = 'Canal RSS para esta actividad';
$string['save'] = 'Guardar';
$string['saveandnext'] = 'Guardar y mostrar siguiente';
$string['savechanges'] = 'Guardar cambios';
$string['savechangesanddisplay'] = 'Guardar cambios y mostrar';
$string['savechangesandreturn'] = 'Guardar y regresar';
$string['savechangesandreturntocourse'] = 'Guardar cambios y regresar al curso';
$string['savecomment'] = 'Guardar comentario';
$string['savedat'] = 'Guardado en:';
$string['savepreferences'] = 'Guardar preferencias';
$string['saveto'] = 'Guardar en';
$string['scale'] = 'Escala';
$string['scale_help'] = 'Una escala proporciona una manera de evaluar o calificar el desempeño en una actividad. Está definida por una lista ordenada de valores, que van de negativo a positivo, separados por comas; por ejemplo, "Decepcionante, Insuficientemente bueno, Promedio, Bueno, Muy bueno, Excelente".';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Escalas';
$string['scalescustom'] = 'Escalas personalizadas';
$string['scalescustomcreate'] = 'Agregar una nueva escala';
$string['scalescustomno'] = 'Aún no se han creado nuevas escalas';
$string['scalesstandard'] = 'Escalas estándar';
$string['scalestandard'] = 'Escala estándar';
$string['scalestandard_help'] = '<p>Una escala estándar es una que esta disponible globalmente en el sitio, para todos los cursos.</p>';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Para crear escalas personalizadas utilice el enlace \'Escalas...\' en el menú de administración del curso.';
$string['scalestip2'] = 'Para crear escalas personalizadas, haga clic en el enlace Calificaciones del menú de administración del curso, luego seleccione Editar, Escalas.';
$string['schedule'] = 'Agenda';
$string['screenshot'] = 'Pantallazo';
$string['search'] = 'Buscar';
$string['search_help'] = 'Para realizar una búsqueda básica de una o más palabras en cualquier lugar del texto, simplemente escríbalas separadas por espacios. Se usarán todas las palabras de más de dos caracteres.

Para realizar una búsqueda avanzada, pulse el botón de búsqueda sin teclear nada en la caja de texto.';
$string['searchactivities'] = 'Buscar actividades por nombre o descripción';
$string['searchagain'] = 'Volver a buscar';
$string['searchbyemail'] = 'Buscar por dirección email';
$string['searchbyusername'] = 'Buscar por nombre de usuario';
$string['searchcoursecategories'] = 'Buscar categorías';
$string['searchcourses'] = 'Buscar cursos';
$string['searchgroups'] = 'Buscar grupos';
$string['searchitems'] = 'Buscar elementos';
$string['searchoptions'] = 'Opciones de búsqueda';
$string['searchresults'] = 'Resultados de la búsqueda';
$string['searchusers'] = 'Buscar usuarios';
$string['sec'] = 'segundos';
$string['seconds'] = 'segundos';
$string['secondsleft'] = '{$a} segs';
$string['secondstotime172800'] = '2 días';
$string['secondstotime259200'] = '3 días';
$string['secondstotime345600'] = '4 días';
$string['secondstotime432000'] = '5 días';
$string['secondstotime518400'] = '6 días';
$string['secondstotime604800'] = '1 Semana';
$string['secondstotime86400'] = '1 día';
$string['secretalreadyused'] = 'El enlace de confirmación de cambio de contraseña ya se ha utilizado, y la contraseña no se ha cambiado.';
$string['secs'] = 'segundos';
$string['section'] = 'Sección';
$string['sectionactionnotsupported'] = 'La acción de sección "{$a}" no está soportada aquí';
$string['sectionname'] = 'Nombre de sección';
$string['sectionoutline'] = 'Descripción de la sección';
$string['sections'] = 'Secciones';
$string['seealsostats'] = 'Ver también: estadísticas';
$string['selctauser'] = 'Elija un usuario';
$string['select'] = 'Seleccionar';
$string['selectacategory'] = 'Por favor, seleccione una categoría';
$string['selectacountry'] = 'Seleccione su país';
$string['selectacourse'] = 'Elija un curso';
$string['selectacoursesite'] = 'Elija un curso o sitio';
$string['selectagroup'] = 'Elija un grupo';
$string['selectall'] = 'Seleccionar todos';
$string['selectallusersonpage'] = 'Seleccionar a todos los usuarios en esta página';
$string['selectalluserswithcount'] = 'Seleccionar a todos los {$a} usuarios';
$string['selectamodule'] = 'Por favor, seleccione un módulo de actividad';
$string['selectanaction'] = 'Elija una acción';
$string['selectanoptions'] = 'Elija una opción';
$string['selectaregion'] = 'Seleccionar una región';
$string['selectcategorysort'] = '¿Cuales categorías le gustaría ordenar?';
$string['selectcategorysortby'] = 'Seleccione cómo le gustaría ordenar categorías';
$string['selectcoursesortby'] = 'Seleccione cómo le gustaría ordenar cursos';
$string['selectdates'] = 'Seleccionar fechas';
$string['selectdefault'] = 'Seleccionar por defecto';
$string['selectedcategories'] = 'Categorías seleccionadas';
$string['selectedfile'] = 'Archivo seleccionado';
$string['selectednowmove'] = '{$a} archivos seleccionados. Ahora vaya al destino y pulse \'Colocar archivos aquí\'';
$string['selectfiles'] = 'Seleccionar archivos';
$string['selectfiltertype'] = 'Seleccionar';
$string['selectgroupsseparate'] = 'Seleccionar grupos separados';
$string['selectgroupsvisible'] = 'Seleccionar grupos visibles';
$string['selectitem'] = 'Seleccionar \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'Seleccione una actividad o un recurso para ver la ayuda.

Haga doble clic en el nombre de una actividad o recurso para añadirla de forma rápida.';
$string['selectnos'] = 'Seleccionar todos \'No';
$string['selectperiod'] = 'Seleccionar período';
$string['selecttheme'] = 'Seleccionar tema';
$string['selectthemename'] = 'Seleccionar tema \'{$a}\'';
$string['senddetails'] = 'Enviar detalles por correo electrónico';
$string['sent'] = 'Enviado';
$string['separate'] = 'Separar';
$string['separateandconnected'] = 'Vías de conocimiento separadas y conectadas';
$string['separateandconnected1'] = 'Muy individualista';
$string['separateandconnected2'] = 'Término medio';
$string['separateandconnected3'] = 'Muy comunicativo';
$string['separateandconnectedinfo'] = 'La escala está basada en la teoría del conocimiento separado y conectado. Esta teoría describe dos maneras diferentes con las que podemos evaluar y aprender a partir de lo que vemos y oímos..<ul><li><strong> Conocedores separados </strong> se mantienen lo más objetivo posible, sin incluir sentimientos ni emociones. En una discusión con otras personas, les gusta defender sus propias ideas, usando la lógica para encontrar hoyos en las ideas del adversario..</li><li><strong>Conocedores conectados </strong> son más sensibles a otras personas. Son expertos en empatía y tienden a escuchar y hacer preguntas hasta que sienten que pueden conectar y "entender las cosas desde el punto de vista de los otros". Aprenden tratando de compartir experiencias que condujeron al conocimiento que ellos encuentran en otras personas.</li></ul>';
$string['servererror'] = 'Ocurrió un error al comunicarse con el servidor';
$string['serverlocaltime'] = 'Hora local del servidor';
$string['sessionforceclean'] = 'Como una precaución de seguridad, se han deshabilitado los scripts generados por el usuario dentro de esta sesión.';
$string['sessiontimeoutsoon'] = 'Su sesión está a punto de caducar. ¿Desea extender su sesión actual?';
$string['setcategorytheme'] = 'Ajustar tema para categoría';
$string['setmode'] = 'Modo de configurar';
$string['setpassword'] = 'Configurar contraseña';
$string['setpasswordinstructions'] = 'Por favor escriba debajo su nueva contraseña, después guarde los cambios.';
$string['settings'] = 'Configuración';
$string['share'] = 'Compartir';
$string['shortname'] = 'Nombre corto';
$string['shortnamecollisionwarning'] = '[*] = Este nombre corto ya está en uso por un curso, y necesita cambiarse hasta que se apruebe';
$string['shortnamecourse'] = 'Nombre corto del curso';
$string['shortnamecourse_help'] = 'El nombre mostrado en áreas con espacio limitado. Debe ser único.';
$string['shortnametaken'] = 'Este nombre corto ya está en uso para otro curso ({$a})';
$string['shortnameuser'] = 'Nombre corto del usuario';
$string['shortsitename'] = 'Nombre corto para el sitio (una palabra)';
$string['show'] = 'Mostrar';
$string['showactions'] = 'Mostrar acciones';
$string['showactivitydates'] = 'Mostrar fechas de actividad';
$string['showactivitydates_help'] = 'Mostrar fechas de actividad en la página del curso.';
$string['showadvancededitor'] = 'Avanzada';
$string['showadvancedsettings'] = 'Mostrar ajustes avanzados';
$string['showall'] = 'Mostrar todos los {$a}';
$string['showallcourses'] = 'Mostrar todos los cursos';
$string['showblockcourse'] = 'Mostrar lista de cursos que contienen bloque';
$string['showcategory'] = 'Mostrar {$a}';
$string['showchartdata'] = 'Mostrar datos en gráfica';
$string['showcomments'] = 'Mostrar/ocultar comentarios';
$string['showcommentsnonjs'] = 'Mostrar comentarios';
$string['showdescription'] = 'Mostrar descripción en la página del curso';
$string['showdescription_help'] = 'Si se activa, la descripción anterior se mostrará en la página del curso justo debajo del enlace a la actividad o recurso.';
$string['showgrades'] = 'Mostrar libro de calificaciones a los estudiantes';
$string['showgrades_help'] = 'Permitirle a los estudiantes el ver una lista de todas sus calificaciones en el curso.';
$string['showingacourses'] = 'Mostrando todos los {$a} cursos';
$string['showingxofycourses'] = 'Mostrando cursos de {$a->start} a {$a->end}, de un total de {$a->total} cursos';
$string['showless'] = 'Mostrar menos';
$string['showlistofcourses'] = 'Mostrar listas de cursos';
$string['showmodulecourse'] = 'Mostrar lista de cursos que contienen actividad';
$string['showmore'] = 'Mostrar más';
$string['showoncoursepage'] = 'Mostrar en página del curso';
$string['showonly'] = 'Mostrar solamente';
$string['showperpage'] = 'Mostrar {$a} por página';
$string['showpopovermenu'] = 'Popover abierto';
$string['showpopoverwindow'] = 'Mostrar ventana \'popover\'';
$string['showrecent'] = 'Mostrar actividad reciente';
$string['showreports'] = 'Mostrar reportes de actividad';
$string['showreports_help'] = 'Permitirle a los estudiantes el ver sus propios reportes de actividad vía su página del perfil.';
$string['showsettings'] = 'Mostrar ajustes';
$string['showtheselogs'] = 'Mostrar estas bitácoras';
$string['showthishelpinlanguage'] = 'Mostrar esta ayuda en el idioma: {$a}';
$string['sidepanel'] = 'Pánel lateral';
$string['signoutofotherservices'] = 'Salir de todas las Apps de web';
$string['signoutofotherservices_help'] = 'Salir de todos los dispositivos y sistemas que usan servicios web, como la App mobile. Las sesiones del navegador permanecerán activas.';
$string['since'] = 'Desde';
$string['sincelast'] = 'desde el último ingreso';
$string['site'] = 'Sitio';
$string['sitedefault'] = 'Configuración por defecto del sitio';
$string['sitedefaultspecified'] = 'Predeterminado del sitio ({$a})';
$string['siteerrors'] = 'Errores de sitio';
$string['sitefiles'] = 'Archivos del sitio';
$string['sitefilesused'] = 'Archivos del sitio usados en este curso';
$string['sitehome'] = 'Página de inicio del sitio';
$string['sitelegacyfiles'] = 'Archivos antiguos heredados del sitio';
$string['sitelogs'] = 'Bitácoras del sitio';
$string['sitenews'] = 'Avisos del sitio';
$string['sitepages'] = 'Páginas del sitio';
$string['sitepartlist'] = 'No dispone de los permisos necesarios para ver la lista de participantes';
$string['sitepartlist0'] = 'Para poder ver la lista de participantes, usted debe ser un profesor del sitio';
$string['sitepartlist1'] = 'Para poder ver la lista de participantes, usted debe ser un profesor';
$string['sites'] = 'Sitios';
$string['sitesection'] = 'Añadir contenido personalizado';
$string['sitesettings'] = 'Configurar el sitio';
$string['siteteachers'] = 'Profesores del sitio';
$string['size'] = 'Tamaño';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Pasado por alto';
$string['skiptocategorylisting'] = 'Saltar hacia listados de categoría';
$string['skiptocoursedetails'] = 'Saltar hacia información detallada del curso';
$string['skiptocourselisting'] = 'Saltar hacia listados del curso';
$string['someallowguest'] = 'Algunos cursos pueden permitir el acceso de invitados';
$string['someerrorswerefound'] = 'Falta alguna información o es incorrecta. Abajo aparecen más detalles.';
$string['sort'] = 'Ordenar';
$string['sortby'] = 'Ordenar por';
$string['sortbyx'] = 'Ordenar por {$a} ascendente';
$string['sortbyxreverse'] = 'Ordenar por {$a} descendente';
$string['sorting'] = 'Ordenando';
$string['sourcerole'] = 'Rol fuente';
$string['specifyname'] = 'Debe especificar un nombre.';
$string['standard'] = 'Estándar';
$string['starpending'] = '([*] = curso pendiente de aprobación)';
$string['startdate'] = 'Fecha de inicio del curso';
$string['startdate_help'] = 'Esta fecha determina el comienzo de la primera semana para un curso en formato semanal. También determina la fecha de inicio para las  bitácoras de las actividades del curso.

Si usted re-inicia el curso y cambia esta fecha, todas las fechas en el curso se moverán en relación con la nueva fecha de inicio.';
$string['startdatewithtaskenabled'] = 'Fecha de inicio  delcurso';
$string['startdatewithtaskenabled_help'] = 'La fecha de  cuando el  curso se vuelve visible a los estudiantes. Antes de esta fecha, ellos no pueden acceder al curso.

Esta fecha también determina el inicio  de la  primera semana para un curso en formato semanal, y es la fecha de inicio para bitácoras de actividades del curso. Si usted reinicia el curso y cambia esta fecha, todas las fechas en el curso serán movidas en relación a la nueva fecha de inicio.';
$string['startingfrom'] = 'Comienzo en';
$string['startsignup'] = 'Comience ahora creando una cuenta nueva';
$string['state'] = 'Estado/Municipio/Provincia';
$string['statistics'] = 'Estadísticas';
$string['statisticsgraph'] = 'Gráfico de estadísticas';
$string['stats'] = 'Estadísticas';
$string['statslogins'] = 'Ingresos';
$string['statsmodedetailed'] = 'Vista detallada (usuario)';
$string['statsmodegeneral'] = 'Vista general';
$string['statsnodata'] = 'No existen datos disponibles para esa combinación de curso y período de tiempo.';
$string['statsnodatauser'] = 'No existen datos disponibles para esa combinación de curso, usuario y período de tiempo.';
$string['statsoff'] = 'Las estadísticas no están habilitadas actualmente';
$string['statsreads'] = 'Vistas';
$string['statsreport1'] = 'Ingresos';
$string['statsreport10'] = 'Actividad del usuario';
$string['statsreport11'] = 'Cursos más activos';
$string['statsreport12'] = 'Cursos más activos (ponderados)';
$string['statsreport13'] = 'Cursos con más participación (inscripciones)';
$string['statsreport14'] = 'Cursos con más participación (publicaciones/vistas)';
$string['statsreport2'] = 'Vistas (todos los roles)';
$string['statsreport3'] = 'Mensajes (todos los roles)';
$string['statsreport4'] = 'Toda la actividad (todos los roles)';
$string['statsreport5'] = 'Toda la actividad (vistas y mensajes)';
$string['statsreport7'] = 'Actividad del usuario (vistas y mensajes)';
$string['statsreport8'] = 'Toda la actividad del usuario';
$string['statsreport9'] = 'Ingresos (curso del sitio)';
$string['statsreportactivity'] = 'Toda la actividad (profesor y estudiante)';
$string['statsreportactivitybyrole'] = 'Toda la actividad (vistas y mensajes)';
$string['statsreportforuser'] = 'para';
$string['statsreportlogins'] = 'Ingresos';
$string['statsreportreads'] = 'Vistas (todos los roles)';
$string['statsreporttype'] = 'Tipo de reporte';
$string['statsreportwrites'] = 'Mensajes (todos los roles)';
$string['statsstudentactivity'] = 'Actividad del estudiante';
$string['statsstudentreads'] = 'Vistas del estudiante';
$string['statsstudentwrites'] = 'Mensajes del estudiante';
$string['statsteacheractivity'] = 'Actividad del profesor';
$string['statsteacherreads'] = 'Vistas del profesor';
$string['statsteacherwrites'] = 'Mensajes del profesor';
$string['statstimeperiod'] = 'Período de tiempo - último:';
$string['statsuniquelogins'] = 'Ingresos únicos';
$string['statsuseractivity'] = 'Toda la actividad';
$string['statsuserlogins'] = 'Ingresos';
$string['statsuserreads'] = 'Vistas';
$string['statsuserwrites'] = 'Mensajes';
$string['statswrites'] = 'Mensajes';
$string['status'] = 'Estatus';
$string['statuschecks'] = 'Estado de comprobaciones';
$string['statuscritical'] = 'Crítico';
$string['statusdone'] = 'Hecho';
$string['statuserror'] = 'Error';
$string['statusinfo'] = 'Información';
$string['statusna'] = 'No Disp.';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Desconocido';
$string['statuswarning'] = 'Advertencia';
$string['stringsnotset'] = 'Las siguientes cadenas no están definidas en {$a}';
$string['studentnotallowed'] = 'Lo sentimos, pero no puede entrar a este curso como \'{$a}\'';
$string['students'] = 'Estudiantes';
$string['studentsandteachers'] = 'Estudiantes y profesores';
$string['subcategories'] = 'Subcategorías';
$string['subcategory'] = 'Subcategoría';
$string['subcategoryof'] = 'Subcategoría de {$a}';
$string['subject'] = 'Asunto';
$string['submit'] = 'Enviar';
$string['subsectionmoveerror'] = 'No se puede mover esta subsección a otra subsección';
$string['success'] = 'Éxito';
$string['successduration'] = 'Éxito ({$a} segundos)';
$string['summary'] = 'Resumen';
$string['suspended'] = 'Suspendido';
$string['suspendedusers'] = 'Usuarios suspendidos';
$string['switchdevicedefault'] = 'Cambiar al tema estándar';
$string['switchdevicerecommended'] = 'Cambiar al tema recomendado para su dispositivo';
$string['switchrolereturn'] = 'Volver a mi rol normal';
$string['switchroleto'] = 'Cambiar rol a...';
$string['switchroleto_help'] = 'Elegir un rol para darse una idea de cómo verá el curso alguien con dicho rol.

Por favor tenga en cuenta que sta vista podría no ser perfecta  (<a href="https://docs.moodle.org/all/es/Capabilities/moodle/role:switchroles">Vea los detalles y alternativas</a>).';
$string['tag'] = 'Marca';
$string['tagalready'] = 'Esta marca ya existe';
$string['tagmanagement'] = 'Agregar/Eliminar marcas ...';
$string['tags'] = 'Marcas';
$string['targetrole'] = 'Rol destino';
$string['teacheronly'] = 'para {$a} solamente';
$string['teacherroles'] = 'roles de {$a}';
$string['teachers'] = 'Profesores';
$string['textcopiedtoclipboard'] = 'Texto copiado al portapapeles';
$string['textediting'] = 'Editor de texto';
$string['textediting_help'] = 'Si se selecciona un editor HTML como Atto o TinyMCE, las áreas para ingreso de texto tendrán una barra de herramientas con botones para añadir contenido con facilidad.

Si se selecciona \'área de texto simple\', puede elegirse un formato para áreas de ingreso de texto como HTML o \'Markdown\'.

La lista de editores de texto disponibles es determinada por el administrador del sitio.';
$string['texteditor'] = 'Use formas estándar de HTML';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Formato de texto simple';
$string['thanks'] = 'Gracias';
$string['theme'] = 'Tema';
$string['themepreviewdescription'] = '{$a} descripción del tema';
$string['themepreviewimage'] = '{$a} previsualizar imagen';
$string['themes'] = 'Temas';
$string['themesaved'] = 'Se guardó el nuevo tema';
$string['therearecourses'] = 'Hay {$a} cursos';
$string['thereareno'] = 'No hay {$a} en este curso';
$string['thiscategory'] = 'Esta categoría';
$string['thiscategorycontains'] = 'Esta categoría contiene';
$string['time'] = 'Hora';
$string['timecreated'] = 'Hora de creado';
$string['timecreatedcourse'] = 'Hora de creación del curso';
$string['timesplitting:deciles'] = 'Último decil';
$string['timesplitting:deciles_help'] = 'El intervalo de análisis divide el curso en décimos (10 partes iguales), y cada predicción está basada en los datos de solamente el décimo anterior más reciente.';
$string['timesplitting:decilesaccum'] = 'Todos los deciles anteriores';
$string['timesplitting:decilesaccum_help'] = 'El intervalo de análisis divide el curso en décimos (10 partes iguales), y cada predicción está basada en los datos de todos los décimos anteriores.';
$string['timesplitting:nosplitting'] = 'Sin límites de tiempo';
$string['timesplitting:nosplitting_help'] = 'No está definido ningún intervalo de análisis para este modelo.';
$string['timesplitting:onemonthafterstart'] = 'Un mes después del inicio';
$string['timesplitting:onemonthafterstart_help'] = 'Este intervalo de análisis generará una predicción 1 mes después de que inicie el analizable.';
$string['timesplitting:oneweekafterstart'] = 'Una semana después del inicio';
$string['timesplitting:oneweekafterstart_help'] = 'Este intervalo de análisis generará una predicción 1 semana después de que inicie el analizable.';
$string['timesplitting:past3days'] = 'Los últimos 3 días';
$string['timesplitting:past3days_help'] = 'Este intervalo de análisis genera predicciones cada 3 días. Los cálculos de los indicadores estarán basados en los 3 días anteriores.';
$string['timesplitting:pastmonth'] = 'Mes pasado';
$string['timesplitting:pastmonth_help'] = 'Este intervalo de análisis genera predicciones cada mes. Los cálculos de los indicadores estarán basados en el mes pasado.';
$string['timesplitting:pastweek'] = 'Semana pasada';
$string['timesplitting:pastweek_help'] = 'Este intervalo de análisis genera predicciones cada semana. Los cálculos de los indicadores estarán basados en la semana pasada.';
$string['timesplitting:quarters'] = 'Último cuartil';
$string['timesplitting:quarters_help'] = 'El intervalo de análisis divide el curso en cuartos (4 partes iguales), donde cada predicción está basada solamente en los datos de del cuarto anterior más reciente.';
$string['timesplitting:quartersaccum'] = 'Todos los cuartiles anteriores';
$string['timesplitting:quartersaccum_help'] = 'El intervalo de análisis divide el curso en cuartos (4 partes iguales), donde cada predicción está basada en los datos de todos los cuartos anteriores.';
$string['timesplitting:singlerange'] = 'De principio a fin';
$string['timesplitting:singlerange_help'] = 'Este intervalo de análisis considera a todo el curso como un solo período.';
$string['timesplitting:tenpercentafterstart'] = '10% después del inicio';
$string['timesplitting:tenpercentafterstart_help'] = 'Este intervalo de análisis genera una predicción después de que sea completado el 10% del curso.';
$string['timesplitting:upcoming3days'] = 'Próximos 3 días';
$string['timesplitting:upcoming3days_help'] = 'El intervalo de análisis genera predicciones cada 3 días. Los cálculos de los indicadores estarán basados en los próximos 3 días.';
$string['timesplitting:upcomingfortnight'] = 'Quincena siguiente';
$string['timesplitting:upcomingfortnight_help'] = 'El intervalo de análisis genera predicciones cada quincena. Los cálculos de los indicadores estarán basados en la próxima quincena.';
$string['timesplitting:upcomingweek'] = 'Semana próxima';
$string['timesplitting:upcomingweek_help'] = 'Este intervalo de análisis genera predicciones cada semana. Los cálculos de los indicadores estarán basados en la semana próxima.';
$string['timezone'] = 'Zona horaria';
$string['tocontent'] = 'Hacia elemento "{$a}"';
$string['tocreatenewaccount'] = 'Saltar a crear una nueva cuenta';
$string['todate'] = 'Hasta';
$string['today'] = 'Hoy';
$string['todaylogs'] = 'Bitácoras de hoy';
$string['toeveryone'] = 'a todos';
$string['toggleemojipicker'] = 'Alternar selector emoji';
$string['togglesearch'] = 'Alternar entrada de búsqueda';
$string['toomanybounces'] = 'Esta dirección de correo ha tenido muchas devoluciones. <b>Debe</b> cambiarla para continuar.';
$string['toomanytags'] = 'Esta búsqueda incluye demasiadas marcas; algunas serán ignoradas.';
$string['toomanytoshow'] = 'Hay demasiados usuarios para mostrarlos aquí';
$string['toomanyusersmatchsearch'] = 'Demasiados usuarios ({$a->count}) coinciden con \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Demasiados usuarios ({$a}) para mostrar';
$string['toonly'] = 'sólo a {$a}';
$string['top'] = 'Superior';
$string['topic'] = 'Tópico/Tema';
$string['toplevelcategory'] = 'Categoría Superior';
$string['torecipient'] = 'Hasta';
$string['total'] = 'Total';
$string['totopofsection'] = 'A la parte superior de la sección "{$a}"';
$string['trackforums'] = 'Seguimiento del foro';
$string['trackforumsno'] = 'No: no hacer seguimiento de los mensajes que he visto';
$string['trackforumsyes'] = 'Sí: resaltarme los mensajes nuevos';
$string['trysearching'] = 'Intente buscar en lugar de esto.';
$string['turneditingoff'] = 'Desactivar edición';
$string['turneditingon'] = 'Activar edición';
$string['unabletocopytoclipboard'] = 'No se pudo copiar texto al portapapeles';
$string['unauthorisedlogin'] = 'La cuenta del usuario "{$a}" no está disponible en este sitio';
$string['undecided'] = 'No decidido';
$string['unexistingcmid'] = 'ID de módulo de curso no encontrada';
$string['unexistingsectionid'] = 'ID de sección de curso no encontrada';
$string['unfinished'] = 'Sin terminar';
$string['unknowncategory'] = 'Categoría desconocida';
$string['unknownerror'] = 'Error desconocido';
$string['unknownuser'] = 'Usuario desconocido';
$string['unlimited'] = 'Sin límite';
$string['unpacking'] = 'Desempaquetando {$a}';
$string['unsafepassword'] = 'Esta contraseña no es segura, intente otra';
$string['untilcomplete'] = 'Hasta que se complete';
$string['unusedaccounts'] = 'Las personas que no entren al curso durante {$a} días se des-inscribirán (darán de baja) automáticamente. Su cuenta seguirá existiendo y podrán re-inscribirse en cualquier momento.';
$string['unzip'] = 'Descomprimir ZIP';
$string['unzippingbackup'] = 'Descomprimiendo (unzip) respaldo';
$string['up'] = 'Arriba';
$string['update'] = 'Actualizar';
$string['updated'] = 'Actualizado: {$a}';
$string['updatemymoodleoff'] = 'Dejar de personalizar esta página';
$string['updatemymoodleon'] = 'Personalizar esta página';
$string['updatemyprofile'] = 'Actualizar información personal';
$string['updatesevery'] = 'Actualizado cada {$a} segundos';
$string['updatethis'] = 'Actualizar este {$a}';
$string['updatethiscourse'] = 'Actualizar este curso';
$string['upload'] = 'Subir';
$string['uploadafile'] = 'Subir un archivo';
$string['uploadcantwrite'] = 'No se pudo escribir el archivo en el disco';
$string['uploadedfile'] = 'Archivo subido con éxito';
$string['uploadedfileto'] = 'El archivo {$a->file} ha sido subido al directorio {$a->directory}';
$string['uploadedfiletoobig'] = 'Lo sentimos, el archivo es demasiado grande (el límite es de {$a} bytes)';
$string['uploadextension'] = 'Subida del archivo detenida por una extensión PHP';
$string['uploadfailednotrecovering'] = 'La subida del archivo ha fallado debido a un problema con uno de los archivos, {$a->name}.<br /> Éste es el registro de los problemas:<br />{$a->problem}<br />Sin recuperar.';
$string['uploadfilelog'] = 'Registro de subida para el archivo {$a}';
$string['uploadformlimit'] = 'El archivo subido {$a} sobrepasa el límite de tamaño máximo establecido por el formato';
$string['uploadlabel'] = 'Título:';
$string['uploadlimitwithsize'] = 'Límite del {$a->contextname}  para subida ({$a->displaysize})';
$string['uploadnewfile'] = 'Subir un nuevo archivo';
$string['uploadnofilefound'] = 'No se encontró el archivo. ¿Está seguro de que seleccionó uno?';
$string['uploadnotallowed'] = 'No se permite subir archivos';
$string['uploadnotempdir'] = 'Falta un directorio temporal';
$string['uploadoldfilesdeleted'] = 'El(los) archivo(s) viejos de su área de subida ha(n) sido eliminado(s)';
$string['uploadpartialfile'] = 'El archivo ha sido parcialmente subido';
$string['uploadproblem'] = 'Ha ocurrido un problema inesperado al subir el archivo \'{$a}\' (tal vez es demasiado grande).';
$string['uploadrenamedchars'] = 'El nombre del archivo se ha cambiado de {$a->oldname} a {$a->newname} debido a la existencia de caracteres no válidos.';
$string['uploadrenamedcollision'] = 'El nombre del archivo se ha cambiado de {$a->oldname} a {$a->newname} debido a la existencia de un conflicto con el nombre del archivo.';
$string['uploadserverlimit'] = 'El archivo subido sobrepasa el límite de tamaño máximo establecido por el servidor';
$string['uploadthisfile'] = 'Subir este archivo';
$string['url'] = 'URL';
$string['used'] = 'Usado';
$string['usedinnplaces'] = 'Usado en {$a} lugares';
$string['user'] = 'Usuario';
$string['useraccount'] = 'Cuenta del usuario';
$string['useractivity'] = 'Actividad';
$string['userconfirmed'] = 'Confirmado {$a}';
$string['userdata'] = 'Datos de usuario';
$string['userdeleted'] = 'Esta cuenta se ha cancelado';
$string['userdescription'] = 'Descripción';
$string['userdescription_help'] = 'Esta caja le permite escribir un texto sobre Usted mismo. Luego se mostrará en la página de su perfil para que otras personas puedan verlo.

Por favor cuide sus datos personales y considere IMPORTANTE tener la precaución de  no escribir "datos personales sensibles" (estado de salud, información genética, creencias religiosas, filosóficas y morales, afiliación sindical, opiniones políticas, orígen racial o étnico, preferencia sexual, ...) que pudieran causarle responsabilidades o riesgos innecesarios a Usted y a la Institución.

Por favor si está en México le recomendamos que consulte la página del <a href="http://www.ifai.gob.mx">Instituto Federal de Acceso a la Información y Protección de Datos</a>';
$string['userdetails'] = 'Detalles de usuario';
$string['userfiles'] = 'Archivos del usuario';
$string['userlist'] = 'Lista de usuarios';
$string['usermatchedon'] = 'Este usuario coincide con la búsqueda vía el campo siguiente';
$string['usermenu'] = 'Menú del usuario';
$string['usermenugoback'] = 'Regresar al menú del usuario';
$string['username'] = 'Usuario';
$string['usernameemail'] = 'Usuario o Email';
$string['usernameemailmatch'] = 'El nombre de usuario y la dirección de correo electrónico no se refieren al mismo usuario';
$string['usernameexists'] = 'Este usuario ya existe. Por favor, seleccione otro.';
$string['usernamelowercase'] = 'Sólo se permiten minúsculas';
$string['usernamenotfound'] = 'No se ha encontrado el usuario en la base de datos';
$string['usernameoremail'] = 'Escribir usuario o dirección email';
$string['usernotconfirmed'] = 'No se pudo confirmar {$a}';
$string['userpic'] = 'Imagen del usuario';
$string['userpreferences'] = 'Preferencias del usuario';
$string['users'] = 'Usuarios';
$string['userselectorautoselectunique'] = 'Si sólo un usuario coincide con la búsqueda, seleccionarlo automáticamente';
$string['userselectorpreserveselected'] = 'Mantener los usuarios seleccionados, incluso si no coinciden más con la búsqueda';
$string['userselectorsearchanywhere'] = 'en cualquier parte';
$string['userselectorsearchexactmatchonly'] = 'solamente coincidencias exactas';
$string['userselectorsearchfromstart'] = 'desde inicio';
$string['userselectorsearchmatching'] = 'Coincidiendo:';
$string['usersnew'] = 'Usuarios nuevos';
$string['usersnoaccesssince'] = 'Mostrar usuarios que han estado inactivos durante más de';
$string['userswithfiles'] = 'Usuarios con archivos';
$string['useruploadtype'] = 'Tipo de subida de usuario: {$a}';
$string['userzones'] = 'Zonas de usuarios';
$string['usetheme'] = 'Usar tema';
$string['usingexistingcourse'] = 'Usando un curso existente';
$string['validatehtml'] = 'Validar HTML';
$string['valuealreadyused'] = 'Este valor ya ha sido usado.';
$string['version'] = 'Versión';
$string['view'] = 'Ver';
$string['viewallcourses'] = 'Ver todos los cursos';
$string['viewallcoursescategories'] = 'Ver todos los cursos y categorías';
$string['viewallresults'] = 'Ver todos los resultados ({$a})';
$string['viewallsubcategories'] = 'Ver todas las subcategorías';
$string['viewfileinpopup'] = 'Ver archivo en ventana desplegable';
$string['viewing'] = 'Viendo:';
$string['viewmore'] = 'Ver más';
$string['viewprofile'] = 'Ver perfil';
$string['views'] = 'Vistas';
$string['viewsolution'] = 'ver solución';
$string['visible'] = 'Visible';
$string['visible_help'] = 'Esta opción determina si el curso aparece en la lista de cursos. Excepto los profesores y administradores, los usuarios (estudiantes) no pueden entrar a un curso que no está disponible.';
$string['visibletostudents'] = 'Visible a {$a}';
$string['warning'] = 'Advertencia';
$string['warningdeleteresource'] = 'Advertencia: Un recurso hace referencia a {$a}. ¿Desea actualizar el recurso?';
$string['wcagcheck'] = 'Revisión de Guías de Accesibilidad de Contenido Web (WCAG)';
$string['webpage'] = 'Página web';
$string['week'] = 'Semana';
$string['weeks'] = 'semanas';
$string['welcomeback'] = '¡Hola, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Bienvenido a {$a}';
$string['welcometocoursetext'] = '¡Bienvenido a {$a->coursename}!

Si no lo ha hecho aún, debería  actualizar la página de su perfil, para que podamos saber más sobre usted:

<a href="{$a->profileurl}">{$a->profileurl}</a>';
$string['welcometosite'] = 'Bienvenido, {$a->firstname}! 👋';
$string['whatforlink'] = '¿Qué quiere hacer con el enlace?';
$string['whatforpage'] = '¿Qué quiere hacer con el texto?';
$string['whatisyourage'] = '¿Qué edad tiene?';
$string['whattocallzip'] = '¿Cómo quiere que se llame el archivo zip?';
$string['whattodo'] = 'Qué hacer';
$string['wheredoyoulive'] = '¿En qué país vive?';
$string['whyisthisrequired'] = '¿Por qué es necesario esto?';
$string['windowclosing'] = 'Esta ventana debería cerrarse automáticamente. De no ser así, ciérrela ahora, por favor.';
$string['withchosenfiles'] = 'Con los archivos escogidos';
$string['withdisablednote'] = '{$a} (deshabilitada)';
$string['withoutuserdata'] = 'sin datos de usuario';
$string['withselectedusers'] = 'Con los usuarios seleccionados...';
$string['withuserdata'] = 'con datos de usuario';
$string['wontrunfuturescheduledtask'] = 'No ejecutará una prueba que no haya fallado y esté agendada para ejecutarse en el futuro.';
$string['wordforstudent'] = 'Su palabra para Estudiante';
$string['wordforstudenteg'] = 'por ejemplo: Estudiante, Alumno, Participante, etc.';
$string['wordforstudents'] = 'Su palabra para Estudiantes';
$string['wordforstudentseg'] = 'por ejemplo: Estudiantes, Alumnos, Participantes, etc.';
$string['wordforteacher'] = 'Su palabra para Profesor';
$string['wordforteachereg'] = 'por ejemplo: Profesor, Tutor, Asesor, etc.';
$string['wordforteachers'] = 'Su palabra para Profesores';
$string['wordforteacherseg'] = 'por ejemplo: Profesores, Tutores, Asesores, etc.';
$string['writingblogsinfo'] = 'Escribiendo información de blogs';
$string['writingcategoriesandquestions'] = 'Escribiendo categorías y preguntas';
$string['writingcoursedata'] = 'Escribiendo información del curso';
$string['writingeventsinfo'] = 'Escribiendo información del evento';
$string['writinggeneralinfo'] = 'Escribiendo información general';
$string['writinggradebookinfo'] = 'Escribiendo información del libro de calificaciones';
$string['writinggroupingsgroupsinfo'] = 'Escribiendo información de agrupamientos/grupos';
$string['writinggroupingsinfo'] = 'Escribiendo información de agrupamientos';
$string['writinggroupsinfo'] = 'Escribiendo información de grupos';
$string['writingheader'] = 'Escribiendo el encabezado';
$string['writingloginfo'] = 'Escribiendo información de bitácoras';
$string['writingmessagesinfo'] = 'Escribiendo información de mensajes';
$string['writingmoduleinfo'] = 'Escribiendo información del módulo';
$string['writingscalesinfo'] = 'Escribiendo información de escalas';
$string['writinguserinfo'] = 'Escribiendo información del usuario';
$string['wrongpassword'] = 'Contraseña incorrecta para este usuario';
$string['year'] = 'año';
$string['years'] = 'años';
$string['yes'] = 'Sí';
$string['youareabouttocreatezip'] = 'Está a punto de crear un archivo \'zip\' que contiene';
$string['youaregoingtorestorefrom'] = 'Está a punto de comenzar el proceso de restauración de';
$string['youhaveupcomingactivitiesdue'] = 'Usted tiene actividades pendientes próximas';
$string['youhaveupcomingactivitiesdueinfo'] = 'Hola {$a},

<br/><br/>Usted tiene actividades próximas pendientes:';
$string['youneedtoenrol'] = 'Para llevar a cabo esta acción necesita inscribirse en este curso.';
$string['yourlastlogin'] = 'Su último ingreso fue el';
$string['yourself'] = 'usted';
$string['yourteacher'] = 'su {$a}';
$string['yourwordforx'] = 'Su palabra para \'{$a}\'';
$string['zippingbackup'] = 'Comprimiendo (zip) respaldo';
