<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_ai_manager', language 'es_mx', version '5.0'.
 *
 * @package     local_ai_manager
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinstance'] = 'Añadir herramienta de IA';
$string['addnavigationentry'] = 'Añadir entrada de navegación';
$string['addnavigationentrydesc'] = 'Habilite esta opción si la configuración del administrador de IA debe ser accesible mediante la navegación principal';
$string['ai_info_table_row_highlighted'] = 'Las herramientas de IA resaltadas son las que utiliza el plugin que estaba utilizando al hacer clic en el enlace a esta página.';
$string['ai_manager:manage'] = 'Configurar los ajustes del administrador de IA para un inquilino';
$string['ai_manager:managetenants'] = 'Configurar los ajustes del administrador de IA para todos los inquilinos';
$string['ai_manager:managevertexcache'] = 'Obtener y cambiar la configuración del estado de almacenamiento en caché de Google Vertex AI';
$string['ai_manager:use'] = 'Usar el administrador de IA. Es obligatorio si el usuario desea usar el administrador de IA y cualquiera de sus servicios.';
$string['ai_manager:viewprompts'] = 'Ver prompts de usuarios';
$string['ai_manager:viewpromptsdates'] = 'Ver sello de tiempo de los prompts de usuarios';
$string['ai_manager:viewstatistics'] = 'Ver estadísticas';
$string['ai_manager:viewtenantprompts'] = 'Ver prompts de usuarios que han sido usados en el contexto de inquilino (cursos externos)';
$string['ai_manager:viewusage'] = 'Ver información de uso';
$string['ai_manager:viewusernames'] = 'Ver nombres de usuario no anónimos en las estadísticas';
$string['ai_manager:viewuserstatistics'] = 'Ver estadísticas de usuarios individuales';
$string['aiadministrationlink'] = 'Administración de herramientas de IA';
$string['aicourseeditheader'] = 'Funcionalidades de IA';
$string['aiinfotitle'] = 'Herramientas de IA en su inquilino';
$string['aiisbeingused'] = 'Está utilizando una herramienta de IA. Los datos introducidos se enviarán a un sistema de IA externo.';
$string['aipurposeplugins'] = 'Plugins proósito IA';
$string['airesponse'] = 'Respuesta de IA';
$string['aitool'] = 'Herramienta de IA';
$string['aitooldeleted'] = 'Herramienta de IA eliminada';
$string['aitoolplugins'] = 'Plugins herramienta IA';
$string['aitoolsaved'] = 'Datos de herramienta de IA guardados';
$string['aiwarning'] = 'El contenido generado por IA SIEMPRE debería de ser VALIDADO.';
$string['aiwarningurl'] = 'Enlace para advertencia acerca del contenido generado por IA';
$string['aiwarningurldesc'] = 'Puede especificar una URL que contenga información adicional sobre el problema del contenido generado por IA.';
$string['allowedtenants'] = 'Inquilinos permitidos';
$string['allowedtenantsdesc'] = 'Especifique una lista de inquilinos permitidos: un identificador por línea.';
$string['alltime'] = 'Prompts de IA';
$string['anonymized'] = 'Anonimizado';
$string['apikey'] = 'Clave API';
$string['applyfilter'] = 'Aplicar filtro';
$string['assignpurposes'] = 'Asignar propósitos';
$string['assignrole'] = 'Asignar rol';
$string['backtodashboard'] = 'Regresar al tablero';
$string['basicsettings'] = 'Configuraciones básicas';
$string['basicsettingsdesc'] = 'Ajustar configuraciones básicas para el plugin gestor de IA';
$string['cachedef_googleauth'] = 'Caché para el token de acceso de Google OAuth2';
$string['changeconfirmstate'] = 'Cambiar confirmación de términos de uso';
$string['changelockstate'] = 'Cambiar estado de bloqueo';
$string['changescope'] = 'Cambiar el ámbito de uso';
$string['choosecontext'] = 'Elegir contexto para mostrar usuarios';
$string['cleanuprequestlogtask'] = 'Limpiar bitácora de solicitudes de gestor de IA';
$string['configure_instance'] = 'Configurar instancias de herramientas de IA';
$string['configureaitool'] = 'Configurar herramienta de IA';
$string['configurepurposes'] = 'Configurar el propósito';
$string['confirm'] = 'Confirmar';
$string['confirmaitoolsusage_heading'] = 'Uso de funcionalidades de IA';
$string['confirmationnotrequired'] = 'No se requiere confirmación para usar las herramientas de IA';
$string['confirmationstatuschanged'] = 'El estado de su confirmación ha sido guardado';
$string['confirmed'] = 'Aceptado';
$string['confirmtermsofuse'] = 'Yo acepto los términos de uso y los comprendo';
$string['context'] = 'Curso/Actividad';
$string['contextdeleted'] = 'Ya eliminado';
$string['currentlyusedaitools'] = 'Herramientas de IA actualmente configuradas';
$string['datawiperanonymizedate'] = 'Fecha para anonimizar datos del usuario';
$string['datawiperanonymizedatedesc'] = 'Los datos de usuario anteriores a esta fecha se anonimizarán. Esto solo tiene efecto si la opción "enablecleanuprequestlogtask" está habilitada.';
$string['datawiperdeletedate'] = 'Fecha para eliminar datos de usuarios';
$string['datawiperdeletedatedesc'] = 'Los datos de usuario anteriores a esta fecha se eliminarán por completo. Solo tiene efecto si la opción "enablecleanuprequestlogtask" está habilitada.';
$string['defaultrole'] = 'rol predeterminado';
$string['defaulttenantname'] = 'Inquilino predeterminado';
$string['empty_api_key'] = 'Clave API Vacía';
$string['enable_ai_integration'] = 'Habilitar Integración con IA';
$string['enablecleanuprequestlogtask'] = 'Habilitar la tarea de limpieza del registro (bitácora) de solicitudes';
$string['enablecleanuprequestlogtaskdesc'] = 'Si está habilitada, una tarea en segundo plano del plugin del administrador de IA eliminará y anonimizará las entradas del registro (bitácora) de solicitudes que sean más antiguas que las marcas de tiempo configuradas.';
$string['endpoint'] = 'punto final de API';
$string['error_confirmtermsofuse'] = 'Usted debe confirmar los términos de uso';
$string['error_http400'] = 'Error al sanear las opciones pasadas';
$string['error_http400contextmissing'] = 'Falta el contexto';
$string['error_http403blocked'] = 'Su administrador de inquilinos ha bloqueado el acceso a las herramientas de IA para usted';
$string['error_http403coursesonly'] = 'No tienes permiso para utilizar la herramienta de IA fuera de los cursos.';
$string['error_http403disabled'] = 'Su administrador de inquilinos no ha habilitado la función de herramientas de IA';
$string['error_http403nocapability'] = 'Usted no tiene la capacidad de utilizar el administrador de IA ("local/ai_manager:use")';
$string['error_http403notconfirmed'] = 'Aún no has confirmado los términos de uso';
$string['error_http403usertype'] = 'Su administrador de inquilinos ha deshabilitado este propósito para su tipo de usuario';
$string['error_http404endpointempty'] = 'No se ha especificado ningún punto final al que enviar la solicitud';
$string['error_http409'] = 'El itemid {$a} ya está tomado';
$string['error_http429'] = 'Ha alcanzado la cantidad máxima de solicitudes. Solo puede enviar {$a->count} solicitudes en un período de {$a->period}';
$string['error_limitreached'] = 'Ha alcanzado la cantidad máxima de solicitudes para este fin. Espere hasta que se restablezca el contador.';
$string['error_noaitoolassignedforpurpose'] = 'No hay ninguna herramienta de IA asignada para el propósito "{$a}"';
$string['error_pleaseconfirm'] = 'Por favor, acéptelos antes de usarlos.';
$string['error_purposedisabled'] = 'El propósito {$a} está deshabilitado por el administrador de su sitio.';
$string['error_purposenotconfigured'] = 'No hay ninguna herramienta de IA configurada para este fin. Comuníquese con su administrador de inquilinos.';
$string['error_sendingrequestfailed'] = 'Error al enviar la solicitud a la herramienta de IA.';
$string['error_tenantdisabled'] = 'Las herramientas de IA no están habilitadas para su inquilino. Comuníquese con su administrador de inquilinos.';
$string['error_unavailable_noselection'] = 'Esta herramienta solo está disponible si se ha seleccionado texto.';
$string['error_unavailable_selection'] = 'Esta herramienta solo está disponible si no se ha seleccionado ningún texto.';
$string['error_userlocked'] = 'Su usuario ha sido bloqueado por su administrador de inquilinos.';
$string['error_usernotconfirmed'] = 'Aún no ha aceptado los términos de uso.';
$string['error_vertexai_serviceaccountjsonempty'] = 'Debe pegar el contenido del archivo JSON que descargó al crear la cuenta de servicio en su Google Cloud Console.';
$string['error_vertexai_serviceaccountjsoninvalid'] = 'Formato no válido. Debe ser JSON válido.';
$string['error_vertexai_serviceaccountjsoninvalidmissing'] = 'Formato no válido. Falta la entrada "{$a}".';
$string['exception_badmessageformat'] = 'Los mensajes se han enviado en un formato no válido.';
$string['exception_changestatusnotallowed'] = 'No debe cambiar el estado de este usuario';
$string['exception_curl'] = 'Se ha producido un error de conexión con el punto final de la API externa';
$string['exception_curl28'] = 'La API tardó demasiado en procesar su solicitud o no se pudo acceder a ella en un tiempo razonable';
$string['exception_default'] = 'Se produjo un error general al intentar enviar la solicitud a la herramienta de IA';
$string['exception_editinstancedenied'] = 'Usted NO debe editar esta herramienta de IA (instancia).';
$string['exception_http401'] = 'Se ha denegado el acceso a la API debido a credenciales no válidas';
$string['exception_http429'] = 'Se han enviado demasiadas solicitudes o solicitudes demasiado grandes a la herramienta de IA en un período de tiempo determinado. Inténtelo de nuevo más tarde.';
$string['exception_http500'] = 'Se produjo un error interno del servidor de la herramienta de IA';
$string['exception_instanceidmissing'] = 'Debe especificar el ID de la herramienta de IA (instancia)';
$string['exception_instancenotexists'] = 'La herramienta de IA (instancia) con ID {$a} no existe';
$string['exception_instanceunavailable'] = 'Esta herramienta de IA no está disponible';
$string['exception_invalidpurpose'] = 'Propósito no válido';
$string['exception_notenantmanagerrights'] = 'No tiene los derechos para administrar las herramientas de IA';
$string['exception_novalidconnector'] = 'No se especificó ningún tipo válido de herramienta de IA';
$string['exception_retrievingaccesstoken'] = 'Se produjo un error al intentar recuperar el token de acceso';
$string['exception_retrievingcachestatus'] = 'Se produjo un error al intentar recuperar el estado de la caché';
$string['exception_tenantaccessdenied'] = 'No debe acceder a este inquilino ({$ a}).';
$string['exception_tenantnotallowed'] = 'El inquilino no está permitido por el administrador.';
$string['exception_usernotexists'] = 'El usuario no existe';
$string['executeaction'] = 'Ejecutar acción';
$string['executebulkuseractions'] = 'Ejecutar acción para usuarios seleccionados';
$string['female'] = 'Femenina';
$string['filterroles'] = 'Filtrar roles';
$string['formvalidation_editinstance_azureapiversion'] = 'Debe proporcionar la versión de API de su recurso de Azure';
$string['formvalidation_editinstance_azuredeploymentid'] = 'Debe proporcionar el identificador de implementación de su recurso de Azure';
$string['formvalidation_editinstance_azureresourcename'] = 'Debe proporcionar el nombre del recurso de su recurso de Azure';
$string['formvalidation_editinstance_endpointnossl'] = 'Por razones de seguridad y privacidad de datos, solo se permiten puntos finales HTTPS';
$string['formvalidation_editinstance_name'] = 'Por favor, inserte un nombre para la herramienta de IA';
$string['formvalidation_editinstance_temperaturerange'] = 'El valor de temperatura debe estar entre 0 y 1';
$string['general_information_heading'] = 'Información general';
$string['general_information_text'] = 'En la actualidad, su instancia de Moodle no ofrece ninguna herramienta de IA. Sin embargo, la instancia de Moodle ofrece interfaces a través de las cuales se pueden utilizar herramientas de IA dentro de la instancia de Moodle. Para que esto sea posible para todos los usuarios de su inquilino, el inquilino debe adquirir o proporcionar dicha herramienta. El administrador del inquilino puede entonces almacenar los datos de acceso a través de una página de configuración y, de esta manera, habilitar las funciones de IA ofrecidas en la instancia de Moodle.';
$string['general_user_settings'] = 'Configuración general del usuario';
$string['get_ai_response_failed'] = 'Error al recuperar la respuesta de IA';
$string['get_ai_response_failed_desc'] = 'Al intentar obtener un resultado del punto final de una herramienta de IA externa, se produjo un error';
$string['get_ai_response_succeeded'] = 'Se recibió con éxito la respuesta de IA';
$string['get_ai_response_succeeded_desc'] = 'El intento de recuperar una respuesta de un punto final de una herramienta de IA externa fue exitoso';
$string['heading_home'] = 'Herramientas de IA';
$string['heading_purposes'] = 'Propósitos';
$string['heading_statistics'] = 'Estadísticas';
$string['infolink'] = 'Enlace para más información';
$string['instanceaddmodal_heading'] = '¿Qué herramienta de IA quiere agregar?';
$string['instanceavailable'] = 'usable';
$string['instancedeleteconfirm'] = '¿Está seguro de que deseas eliminar esta herramienta de IA?';
$string['instancedisabled'] = 'Herramienta de IA actualmente está deshabilitada';
$string['instanceenabled'] = 'Herramienta de IA actualmente está habilitada';
$string['instancename'] = 'Identificador interno';
$string['landscape'] = 'apaisado';
$string['large'] = 'grande';
$string['lastday'] = 'Últimas 24 horas';
$string['lastmonth'] = 'Últimos 30 días';
$string['lastweek'] = 'Últimos 7 días';
$string['lock'] = 'Bloquear';
$string['locked'] = 'Bloqueado';
$string['male'] = 'Masculino';
$string['max_request_time_window'] = 'Ventana de tiempo para el número máximo de solicitudes';
$string['max_requests_purpose'] = 'Número máximo de solicitudes por ventana de tiempo ({$a})';
$string['max_requests_purpose_heading'] = 'Purpose {$a}';
$string['medium'] = 'medio';
$string['model'] = 'Modelo';
$string['namepattern'] = 'Nombre';
$string['nodata'] = 'Sin datos para mostrar';
$string['noprompts'] = 'No hay prompts para mostrar';
$string['notconfirmed'] = 'No aceptado';
$string['notselected'] = 'Deshabilitado';
$string['per'] = 'por';
$string['pluginname'] = 'Administrador de IA';
$string['portrait'] = 'retrato';
$string['preconfiguredmodel'] = 'Modelo pre-configurado';
$string['privacy:metadata:local_ai_manager_request_log'] = 'Solicitar bitácoras';
$string['privacy:metadata:local_ai_manager_request_log:contextid'] = 'El ID del contexto en el que se realizó la solicitud de IA';
$string['privacy:metadata:local_ai_manager_request_log:promptcompletion'] = 'La  finalización del prompt  recibida por el sistema de IA externo';
$string['privacy:metadata:local_ai_manager_request_log:prompttext'] = 'El prompt enviado al sistema externo de IA';
$string['privacy:metadata:local_ai_manager_request_log:requestoptions'] = 'Opciones de solicitud codificadas en JSON que se han transmitido junto con el mensaje';
$string['privacy:metadata:local_ai_manager_request_log:timecreated'] = 'La marca de tiempo en la que se realizó la solicitud';
$string['privacy:metadata:local_ai_manager_request_log:userid'] = 'La ID del usuario';
$string['privacy:metadata:local_ai_manager_userinfo'] = 'Información específica del usuario';
$string['privacy:metadata:local_ai_manager_userinfo:confirmed'] = 'Si el usuario ha confirmado los términos de uso';
$string['privacy:metadata:local_ai_manager_userinfo:locked'] = 'Si el usuario ha sido bloqueado por el administrador de inquilinos';
$string['privacy:metadata:local_ai_manager_userinfo:role'] = 'El rol interno del administrador de IA, codificado como números enteros';
$string['privacy:metadata:local_ai_manager_userinfo:scope'] = 'El alcance en el que el usuario puede utilizar herramientas de IA, codificado como números enteros';
$string['privacy:metadata:local_ai_manager_userinfo:timemodified'] = 'La marca de tiempo del último cambio del registro de información del usuario';
$string['privacy:metadata:local_ai_manager_userinfo:userid'] = 'La ID del usuario';
$string['privacy:metadata:local_ai_manager_userusage'] = 'Datos de uso del usuario';
$string['privacy:metadata:local_ai_manager_userusage:currentusage'] = 'LA cantidad de solicitudes que un usuario ha usado desde el último reinicio';
$string['privacy:metadata:local_ai_manager_userusage:purpose'] = 'El propósito por el cual la cantidad de solicitudes está siendo contada';
$string['privacy:metadata:local_ai_manager_userusage:timemodified'] = 'El sello de tiempo del último cambio al registro de uso del usuario';
$string['privacy:metadata:local_ai_manager_userusage:userid'] = 'La ID del usuario';
$string['privacy_table_description'] = 'En la siguiente tabla, puede ver una descripción general de las herramientas de IA configuradas por su escuela. Es posible que su administrador de inquilinos haya proporcionado notas adicionales sobre los términos de uso y los avisos de privacidad de las respectivas herramientas de IA en la columna "Enlace de información".';
$string['privacy_terms_description'] = 'A continuación se muestran las notas sobre la privacidad de los datos y los términos de uso exactamente en la misma forma en que usted los confirmó o aún debe confirmar para utilizar las funcionalidades de IA.';
$string['privacy_terms_heading'] = 'Privacy and Terms of Use';
$string['privacy_terms_missing'] = 'No se han especificado condiciones de uso.';
$string['privacy_terms_missing_enable_anyway'] = 'No hay términos de uso adicionales que aceptar. Confirme que desea habilitar las herramientas de IA para su cuenta.';
$string['privilegedroles'] = 'Roles privilegiados';
$string['privilegedrolesdesc'] = 'Los avisos de los usuarios que tienen estos roles en el contexto del sistema no pueden ser vistos por otros usuarios, incluidos los administradores de inquilinos. Además de eso, los nombres de los usuarios con estos roles se anonimizan en las estadísticas de usuarios.';
$string['prompt'] = 'Prompt';
$string['promptcompletitionfilesnotavailable'] = 'Los archivos generados no están disponibles en la vista de prompts';
$string['promptsmodalheading'] = 'Prompts y finalizaciones para el usuario {$a->userDisplayName} en el contexto {$a->contextDisplayName}';
$string['purpose'] = 'Propósito';
$string['purposedescription'] = '¿Qué es el propósito "{$a}"?';
$string['purposesdescription'] = '¿Cuál de sus herramientas de IA configuradas se debe utilizar para qué propósito?';
$string['purposesheading'] = 'Propósitos para {$a->role} ({$a->currentcount}/{$a->maxcount} asignados)';
$string['purposeusageinfoheading'] = 'Uso del propósito "{$a}"';
$string['quotaconfig'] = 'Configuración de límites';
$string['quotadescription'] = 'Establezca aquí el intervalo de tiempo y la cantidad máxima de solicitudes por estudiante y profesor. Una vez que expire el intervalo de tiempo, la cantidad de solicitudes se restablecerá automáticamente.';
$string['request_count'] = 'Número de solicitud';
$string['requesttimeout'] = 'Tiempo de espera para la solicitud a los puntos finales de IA';
$string['requesttimeoutdesc'] = 'Cantidad máxima de tiempo en segundos para las solicitudes a los puntos finales de IA externos';
$string['requireconfirmtou'] = 'Requqerir confirmación de términos de uso';
$string['requireconfirmtoudesc'] = 'Habilitar si usted quiere que los usuarios tengan que confirmar los términos de uso antes de poder usar las herramientas de IA proporcionadas por el IA manager.';
$string['resetfilter'] = 'Reiniciar filtro';
$string['resetuserusagetask'] = 'Restablecer los datos de uso del usuario del administrador de IA';
$string['restricttenants'] = 'Bloquear el acceso para ciertos inquilinos';
$string['restricttenantsdesc'] = 'Habilite esta opción para limitar las herramientas de IA a inquilinos específicos que se pueden definir mediante la opción de configuración "allowedtenants".';
$string['revokeconfirmation'] = 'Revocar confirmación';
$string['rightsconfig'] = 'Configuración de derechos';
$string['role'] = 'Rol';
$string['role_basic'] = 'rol base';
$string['role_extended'] = 'rol extendido';
$string['role_unlimited'] = 'rol ilimitado';
$string['scope'] = 'ámbito de uso';
$string['scope_courses'] = 'Solo en cursos';
$string['scope_everywhere'] = 'En todas partes';
$string['select_tool_for_purpose'] = 'Propósito {$a}';
$string['selecteduserscount'] = '{$a} seleccionado';
$string['serviceaccountjson'] = 'Contenido del archivo JSON de la cuenta de servicio de Google';
$string['small'] = 'pequeño';
$string['squared'] = 'cuadrado';
$string['statistics_for'] = 'Estadísticas para {$a}';
$string['statisticsoverview'] = 'Resumen global';
$string['subpluginspageheading'] = 'Subplugins de AI Manager';
$string['subplugintype_aipurpose'] = 'Propósito de IA';
$string['subplugintype_aipurpose_plural'] = 'Propósitos de IA';
$string['subplugintype_aitool'] = 'Herramienta de IA';
$string['subplugintype_aitool_plural'] = 'Herramientas de IA';
$string['table_heading_infolink'] = 'Enlace de Información';
$string['table_heading_instance_name'] = 'Nombre de herramienta de IA';
$string['table_heading_model'] = 'Modelo';
$string['table_heading_purpose'] = 'Propósito';
$string['technical_function_heading'] = 'Funcionalidad Técnica';
$string['technical_function_step1'] = 'El administrador de inquilinos almacena una configuración para un propósito específico, por ejemplo, configurar la opción de generación de imágenes, porque su inquilino tiene un contrato con OpenAI, por lo que el inquilino puede usar la herramienta Dall-E.';
$string['technical_function_step2'] = 'Un usuario de este inquilino encuentra entonces la función de IA correspondiente en la instancia de Moodle, por ejemplo, la capacidad de generar una imagen a través de un mensaje directamente en el editor e insertarla en el editor.';
$string['technical_function_step3'] = 'Si un usuario utiliza ahora esta función, el mensaje se envía a los servidores de la instancia de Moodle y ellos lo evalúan.';
$string['technical_function_step4'] = 'Los servidores de la instancia de Moodle utilizan los datos de acceso almacenados para la herramienta de IA del inquilino y envían la solicitud en nombre del usuario a los servidores de la herramienta de IA externa.';
$string['technical_function_step4_emphasized'] = 'En este proceso, la instancia de Moodle actúa como el usuario final de la herramienta externa, lo que significa que la herramienta externa no puede rastrear qué usuario individual realizó la solicitud correspondiente a la herramienta de IA. Solo el inquilino al que pertenece el usuario es identificable para la herramienta de IA.';
$string['technical_function_step5'] = 'La respuesta de la herramienta de IA se envía de vuelta al usuario a través de la instancia de Moodle o el resultado, como una imagen generada, se integra directamente en la actividad respectiva.';
$string['technical_function_text'] = 'Al utilizar las funciones de IA dentro de esta instancia de Moodle, el proceso técnico es el siguiente:';
$string['temperature_creative_balanced'] = 'Equilibrada';
$string['temperature_custom_value'] = 'Valor personalizado (entre 0 y 1)';
$string['temperature_defaultsetting'] = 'Temperatura predeterminada';
$string['temperature_desc'] = 'Esto describe la "aleatoriedad" o la "creatividad". Una temperatura baja generará un texto más coherente pero predecible. Los números altos significan más creatividad pero no precisión. El rango va de 0 a 1.';
$string['temperature_more_creative'] = 'Bastante creativa';
$string['temperature_more_precise'] = 'Bastante precisa';
$string['temperature_use_custom_value'] = 'Usar valor personalizado de temperatura';
$string['tenant'] = 'Inquilino';
$string['tenantcolumn'] = 'Comuna del inquilino';
$string['tenantcolumndesc'] = 'La columna de la tabla de usuarios que contiene el identificador del inquilino con el que debe asociarse un usuario.';
$string['tenantconfig_heading'] = 'IA en su inquilino';
$string['tenantdisabled'] = 'deshabilitado';
$string['tenantenabled'] = 'habilitado';
$string['tenantenabledescription'] = 'Para que los usuarios de su inquilino tengan acceso a todas las funciones de IA de la instancia de Moodle, debe habilitar y configurar las funciones aquí.';
$string['tenantenablednextsteps'] = 'Las funciones de IA de la instancia de Moodle ya están habilitadas para su inquilino. Tenga en cuenta que ahora usted debe definir las herramientas y los propósitos para que las funciones sean realmente utilizables.<br/>Todos los usuarios tendrán acceso a las funciones de IA. Sin embargo, al ir a {$a} puede deshabilitar usuarios.';
$string['tenantenableheading'] = 'Herramientas de inteligencia artificial en su inquilino';
$string['tenantnotallowed'] = 'La función está deshabilitada globalmente para su inquilino y, por lo tanto, no se puede utilizar.';
$string['termsofusesetting'] = 'Términos de uso';
$string['termsofusesettingdesc'] = 'Aquí puede agregar sus términos de uso específicos para el administrador de IA. El usuario deberá aceptarlos antes de poder usar las herramientas de IA.';
$string['toinfopage'] = 'A la página de información de IA';
$string['unconfirmed'] = 'no confirmado';
$string['unit_count'] = 'solicitud(es)';
$string['unit_token'] = 'token';
$string['unlock'] = 'Desbloquear';
$string['unlockaitools'] = 'Quiero desbloquear las herramientas de IA para mi cuenta';
$string['updatelist'] = 'Actualizar lista';
$string['usage'] = 'Uso';
$string['use_openai_by_azure_apiversion'] = 'Versión API del recurso Azure';
$string['use_openai_by_azure_deploymentid'] = 'Identificador de implementación del recurso de Azure';
$string['use_openai_by_azure_heading'] = 'Utilice OpenAI a través de Azure';
$string['use_openai_by_azure_name'] = 'Nombre del recurso de Azure';
$string['useconfirmlink'] = 'Por favor confirmar aquí: {$a}.';
$string['userconfig'] = 'Configuración del usuario';
$string['userconfirmation_headline'] = 'Confirmación para el uso de herramientas de IA';
$string['userstatistics'] = 'Descripción general del usuario';
$string['userstatusupdated'] = 'Se ha actualizado el estado del/los usuario/s';
$string['userwithusageonlyshown'] = 'En esta tabla sólo se muestran los usuarios que ya han utilizado este propósito.';
$string['verifyssl'] = 'Verificar certificados SSL';
$string['verifyssldesc'] = 'Si está habilitada, las conexiones con las herramientas de IA solo se establecerán si los certificados se pueden verificar correctamente. ¡Se recomienda deshabilitarla solo para uso en desarrollo!';
$string['vertex_cachingdisabled'] = 'Almacenamiento en caché deshabilitado';
$string['vertex_cachingenabled'] = 'Almacenamiento en caché habilitado';
$string['vertex_disablecaching'] = 'Deshabilitar Almacenamiento en caché';
$string['vertex_enablecaching'] = 'Habilitar Almacenamiento en caché';
$string['vertex_error_cachestatus'] = 'Error al consultar/actualizar la configuración de almacenamiento en caché de Vertex AI';
$string['vertex_nocachestatus'] = 'Haga clic en el botón Actualizar para consultar el estado actual de la memoria caché de Vertex AI.';
$string['vertexcachestatus'] = 'Consultar y cambiar el estado de caché de Vertex AI';
$string['viewprompts'] = 'Ver prompts';
$string['within'] = 'en';
