<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tracker', language 'el', version '5.0'.
 *
 * @package     tracker
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['AND'] = 'ΚΑΙ';
$string['IN'] = 'ΣΤΟ';
$string['abandonned'] = 'Εγκαταλείφθηκε';
$string['action'] = 'Ενέργεια';
$string['active'] = 'Ενεργό στη φόρμα';
$string['activeplural'] = 'Ενεργά';
$string['addacomment'] = 'Προσθήκη ενός σχολίου';
$string['addanoption'] = 'Προσθήκη μιας επιλογής';
$string['addawatcher'] = 'Προσθήκη ενός παρακολουθητή';
$string['addtothetracker'] = 'Προσθήκη αυτού στον ιχνηλάτη';
$string['administration'] = 'Διαχείριση';
$string['administrators'] = 'Διαχειριστές';
$string['allownotifications_help'] = 'Εάν ενεργοποιηθεί, ορισμένες αλλαγές κατάστασης ενδέχεται να έχουν ως αποτέλεσμα την αποστολή ειδοποιήσεων στους χρήστες όταν ο χρήστης παρακολουθεί ένα ζήτημα. Οι χρήστες μπορούν να ρυθμίσουν το ποιο συμβάν θα τους ειδοποιήσει.';
$string['alltracks'] = 'Παρακολούθηση της εργασίας μου σε όλους τους ιχνηλάτες';
$string['any'] = 'Όλα';
$string['askraise'] = 'Ζητήστε από τους διορθωτές να αυξήσουν την προτεραιότητα';
$string['assignedto'] = 'Ανατέθηκε στον/στην';
$string['assignee'] = 'Εντολοδόχος';
$string['attributes'] = 'Ιδιοχαρακτηριστικά';
$string['autourl'] = 'Αυτόματη ανάμνηση διεύθυνσης URL';
$string['backtocourse'] = 'Επιστροφή στο μάθημα';
$string['browse'] = 'Περιήγηση';
$string['browser'] = 'Περιηγητής';
$string['build'] = 'Έκδοση';
$string['by'] = '<i>ανατέθηκε από τον/την</i>';
$string['cascade'] = 'Αποστολή ανώτερου επιπέδου';
$string['cascadedticket'] = 'Μεταφέρθηκε από:';
$string['cced'] = 'Κοιν.';
$string['ccs'] = 'Κοινοπ.';
$string['checkbox'] = 'Πλαίσιο επιλογής';
$string['checkboxhoriz'] = 'Οριζόντιο πλαίσιο επιλογής';
$string['chooselocal'] = 'Επιλογή ενός τοπικού ιχνηλάτη ως γονικού';
$string['chooseremote'] = 'Επιλέξτε έναν απομακρυσμένο κεντρικό Η/Υ';
$string['chooseremoteparent'] = 'Επιλέξτε ένα απομακρυσμένο στιγμιότυπο';
$string['choosetarget'] = 'Επιλογή στόχου';
$string['clearsearch'] = 'Καθαρισμός κριτηρίων αναζήτησης';
$string['comment'] = 'Σχόλιο';
$string['commentedby'] = 'Σχολιασμός από';
$string['comments'] = 'Σχόλια';
$string['component'] = 'Στοιχείο λογισμικού';
$string['constant'] = 'Σταθερό';
$string['constantcurrentcoursefullname'] = 'Πλήρες όνομα τρέχοντος μαθήματος';
$string['constantcurrentcourseidnumber'] = 'Αναγνωριστικός αριθμός τρέχοντος μαθήματος';
$string['constantcurrentcourseshortname'] = 'Σύντομο όνομα τρέχοντος μαθήματος';
$string['constantcurrentidnumber'] = 'Αναγνωριστικός αριθμός τρέχοντα χρήστη';
$string['constantinfosource'] = 'Σταθερή πηγή πληροφοριών';
$string['constantsitefullname'] = 'Πλήρες όνομα ιστοτόπου';
$string['constantsiteshortname'] = 'Σύντομο όνομα ιστοτόπου';
$string['count'] = 'Πλήθος';
$string['countbyassignee'] = 'Ανά εντολοδόχο';
$string['countbymonth'] = 'Ανά μηνιαία αναφορά δημιουργιών';
$string['countbyreporter'] = 'Ανά αναφέροντα';
$string['countbystate'] = 'Αναφορά ανά κατάσταση';
$string['createdinmonth'] = 'Δημιουργήθηκαν τον τελευταίο μήνα';
$string['createnewelement'] = 'Δημιουργία ενός νέου στοιχείου';
$string['currentbinding'] = 'Τρέχουσα αλληλοδιαδοχή';
$string['customconstant'] = 'Τρέχουσα τιμή';
$string['database'] = 'Βάση δεδομένων';
$string['datereported'] = 'Ημερομηνία που αναφέρθηκε';
$string['defaultassignee'] = 'Προεπιλεγμένος εντολοδόχος';
$string['defaultassignee_help'] = 'Μπορείτε να απαιτήσετε τα εισερχόμενα δελτία να έχουν προ-ανατεθεί σε έναν από τους διαθέσιμους διορθωτές.';
$string['deleteattachedfile'] = 'Διαγραφή συνημμένου';
$string['dependancies'] = 'Εξαρτήσεις';
$string['dependson'] = 'Εξαρτάται από';
$string['descriptionisempty'] = 'Η περιγραφή είναι κενή';
$string['distribute'] = 'Μετακινήστε το δελτίο σε έναν άλλο ιχνηλάτη';
$string['doaddelementautourl'] = 'Προσθήκη ενός συλλέκτη διευθύνσεων URL';
$string['doaddelementcheckbox'] = 'Προσθήκη ενός στοιχείου πλαισίου επιλογής';
$string['doaddelementcheckboxhoriz'] = 'Προσθήκη ενός στοιχείου πλαισίου επιλογής';
$string['doaddelementdropdown'] = 'Προσθήκη ενός πτυσσόμενου στοιχείου';
$string['doaddelementfile'] = 'Προσθήκη ενός στοιχείου συνημμένου αρχείου';
$string['doaddelementradio'] = 'Προσθήκη ενός στοιχείου κουμπιού μοναδικής επιλογής';
$string['doaddelementradiohoriz'] = 'Προσθήκη ενός στοιχείου κουμπιού μοναδικής επιλογής';
$string['doaddelementtext'] = 'Προσθήκη ενός πεδίου κειμένου';
$string['doaddelementtextarea'] = 'Προσθήκη μιας περιοχής κειμένου';
$string['doupdateelementautourl'] = 'Ενημέρωση μιας αυτόματης διεύθυνσης URL';
$string['doupdateelementcheckbox'] = 'Ενημέρωση ενός στοιχείου πλαισίου επιλογής';
$string['doupdateelementcheckboxhoriz'] = 'Ενημέρωση ενός στοιχείου πλαισίου επιλογής';
$string['doupdateelementdropdown'] = 'Ενημέρωση ενός στοιχείου πτυσσόμενης λίστας';
$string['doupdateelementfile'] = 'Ενημέρωση ενός στοιχείου συνημμένου αρχείου';
$string['doupdateelementradio'] = 'Ενημέρωση ενός στοιχείου κουμπιού μοναδικής επιλογής';
$string['doupdateelementradiohoriz'] = 'Ενημέρωση ενός στοιχείου κουμπιού μοναδικής επιλογής';
$string['doupdateelementtext'] = 'Ενημέρωση ενός πεδίου κειμένου';
$string['doupdateelementtextarea'] = 'Ενημέρωση μιας περιοχής κειμένου';
$string['dropdown'] = 'Πτυσσόμενο';
$string['editelement'] = 'Ενημέρωση στοιχείου φόρμας';
$string['editoptions'] = 'Ενημέρωση επιλογών';
$string['editproperties'] = 'Ενημέρωση ιδιοτήτων';
$string['editwatch'] = 'Αλλαγή μιας καταχώρησης cc';
$string['elements'] = 'Διαθέσιμα στοιχεία';
$string['elements_help'] = 'Η φόρμα υποβολής ζητήματος μπορεί να προσαρμοστεί προσθέτοντας στοιχεία φόρμας. Τα πεδία «περίληψη», «περιγραφή», και «Αναφορά από» είναι προεπιλεγμένα, αλλά οποιοδήποτε πρόσθετο προσδιοριστικό μπορεί να προστεθεί στην περιγραφή του ζητήματος.

Τα στοιχεία που μπορούν να προστεθούν είναι τα «στοιχεία φόρμας», δηλαδή τυπικά γραφικά στοιχεία φόρμας που μπορούν να αντιπροσωπεύσουν οποιοδήποτε προσδιοριστικό ή ανοιχτή περιγραφή, όπως κουμπιά μοναδικής επιλογής, πλαίσια επιλογής, πτυσσόμενο μενού, πεδία κειμένου ή περιοχές κειμένου.

Τα στοιχεία ρυθμίζονται χρησιμοποιώντας τις ακόλουθες ιδιότητες:

### Ένα όνομα

Αυτό το όνομα είναι το αναγνωριστικό του στοιχείου, από τεχνική άποψη. Πρέπει να είναι ένα τεκμήριο που χρησιμοποιεί αλφαριθμητικούς χαρακτήρες και τον χαρακτήρα _, χωρίς κενά ή μη εκτυπώσιμους χαρακτήρες. Το όνομα δεν θα εμφανίζεται στη διεπαφή χρήστη.

### Περιγραφή

Η περιγραφή χρησιμοποιείται όταν το στοιχείο πρέπει να αναγνωριστεί στη διεπαφή χρήστη.

### Επιλογές

Ορισμένα στοιχεία έχουν μια πεπερασμένη λίστα τιμών επιλογών.

Οι επιλογές προστίθενται μετά τη δημιουργία του στοιχείου.

Τα πεδία κειμένου και οι περιοχές κειμένου δεν έχουν καμία επιλογή.';
$string['elementsused'] = 'Χρησιμοποιημένα στοιχεία';
$string['elucidationratio'] = 'Αναλογία αποσαφήνισης';
$string['emailoptions'] = 'Επιλογές ηλε.ταχυδρομείου';
$string['emergency'] = 'Επείγον ερώτημα';
$string['emptydefinition'] = 'Ο ιχνηλάτης στόχος δεν έχει ορισμό.';
$string['enablecomemnts_help'] = 'Όταν ενεργοποιηθεί, ορισμένοι ρόλοι θα μπορούν να σχολιάσουν ζητήματα.';
$string['enablecomments'] = 'Επιτρέπονται σχόλια';
$string['enablecomments_help'] = 'Όταν είναι ενεργοποιημένη αυτή η επιλογή, οι αναγνώστες των εγγραφών ζητημάτων μπορούν να προσθέσουν σχόλια στον ιχνηλάτη.';
$string['erroraddissueattribute'] = 'Αδυναμία υποβολής ιδιοχαρακτηριστικού/-ών ζητήματος/-άτων. Περίπτωση {$a}';
$string['erroralreadyinuse'] = 'Στοιχείο ήδη σε χρήση';
$string['errorannotdeletecarboncopies'] = 'Δεν είναι δυνατή η διαγραφή κρυφών αντιγράφων για τον χρήστη: {$a}';
$string['errorbadlistformat'] = 'Μόνο αριθμοί (ή μια λίστα αριθμών που διαχωρίζονται με κόμμα («,») επιτρέπονται στο πεδίο αριθμού ζητήματος';
$string['errorcannotaddelementtouse'] = 'Αδυναμία προσθήκης στοιχείου στη λίστα στοιχείων προς χρήση για αυτόν τον ιχνηλάτη';
$string['errorcannotclearelementsforissue'] = 'Αδυναμία εκκαθάρισης στοιχείων για το ζήτημα {$a}';
$string['errorcannotcreateelementoption'] = 'Αδυναμία δημιουργίας επιλογής στοιχείου';
$string['errorcannotdeletearboncopyforuser'] = 'Αδυναμία διαγραφής κρυφού αντιγράφου {$a->issues} για το χρήστη : {$a->userid}';
$string['errorcannotdeletecc'] = 'Αδυναμία διαγραφής κρυφού αντιγράφου';
$string['errorcannotdeleteelement'] = 'Αδυναμία διαγραφής στοιχείου από τη λίστα στοιχείων προς χρήση για αυτόν τον ιχνηλάτη';
$string['errorcannotdeleteelementtouse'] = 'Αδυναμία διαγραφής στοιχείου από τη λίστα στοιχείων προς χρήση για αυτόν τον ιχνηλάτη';
$string['errorcannotdeleteolddependancy'] = 'Αδυναμία διαγραφής παλαιών εξαρτήσεων';
$string['errorcannotdeleteoption'] = 'Σφάλμα κατά την προσπάθεια διαγραφής επιλογής στοιχείου';
$string['errorcannoteditwatch'] = 'Αδυναμία τροποποίησης αυτής της παρακολούθησης';
$string['errorcannothideelement'] = 'Αδυναμία απόκρυψης στοιχείου από την φόρμα για αυτόν τον ιχνηλάτη';
$string['errorcannotlogoldownership'] = 'Αδυναμία καταγραφής παλαιάς ιδιοκτησίας';
$string['errorcannotsaveprefs'] = 'Αδυναμία εισαγωγής εγγραφής προτιμήσεων';
$string['errorcannotsetparent'] = 'Αδυναμία ορισμού γονικού σε αυτόν τον ιχνηλάτη';
$string['errorcannotshowelement'] = 'Αδυναμία εμφάνισης στοιχείου στην φόρμα για αυτόν τον ιχνηλάτη';
$string['errorcannotsubmitticket'] = 'Σφάλμα κατά την καταχώρηση νέου δελτίου';
$string['errorcannotujpdateoptionbecauseused'] = 'Αδυναμία ενημέρωσης της επιλογής στοιχείου, επειδή αυτήν τη στιγμή χρησιμοποιείται ως ιδιοχαρακτηριστικό για ένα ζήτημα';
$string['errorcannotunbindparent'] = 'Αδυναμία κατάργησης του γονικού αυτού του ιχνηλάτη';
$string['errorcannotupdateelement'] = 'Αδυναμία ενημέρωσης του στοιχείου';
$string['errorcannotupdateissuecascade'] = 'Αδυναμία ενημέρωσης του ζητήματος για αλληλοδιαδοχή';
$string['errorcannotupdateprefs'] = 'Αδυναμία ενημέρωσης εγγραφής προτιμήσεων';
$string['errorcannotupdatetrackerissue'] = 'Αδυναμία ενημέρωσης του ζητήματος ιχνηλάτη';
$string['errorcannotupdatewatcher'] = 'Αδυναμία ενημέρωσης παρακολουθητή';
$string['errorcannotviewelementoption'] = 'Αδυναμία εμφάνισης επιλογών στοιχείου';
$string['errorcannotwritecomment'] = 'Σφάλμα κατά την εγγραφή σχολίου';
$string['errorcannotwritedependancy'] = 'Αδυναμία εγγραφής εξάρτησης';
$string['errorcanotaddelementtouse'] = 'Αδυναμία προσθήκης στοιχείου στη λίστα στοιχείων προς χρήση για αυτόν τον ιχνηλάτη';
$string['errorcookie'] = 'Αποτυχία ορισμού cookie: {$a}.';
$string['errorcoursemisconfigured'] = 'Το μάθημα έχει μη έγκυρες ρυθμίσεις';
$string['errorcoursemodid'] = 'Το αναγνωριστικό αρθρώματος μαθήματος ήταν λάθος';
$string['errordbupdate'] = 'Αδυναμία ενημέρωσης στοιχείου';
$string['errorelementdoesnotexist'] = 'Το στοιχείο δεν υπάρχει';
$string['errorelementinuse'] = 'Το στοιχείο βρίσκεται ήδη σε χρήση';
$string['errorfindingaction'] = 'Σφάλμα: Αδυναμία εύρεσης ενέργειας: {$a}';
$string['errorinvalidtrackerelementid'] = 'Μη έγκυρο στοιχείο. Αδυναμία τροποποίησης στοιχείου με αναγνωριστικό';
$string['errormoduleincorrect'] = 'Το άρθρωμα μαθήματος είναι λανθασμένο';
$string['errornoaccessallissues'] = 'Δεν έχετε πρόσβαση για εμφάνιση όλων των ζητημάτων.';
$string['errornoaccessissue'] = 'Δεν έχετε πρόσβαση για εμφάνιση αυτού του ζητήματος.';
$string['errornoeditissue'] = 'Δεν έχετε πρόσβαση για τροποποίηση αυτού του ζητήματος.';
$string['errorrecordissue'] = 'Αδυναμία υποβολής ζητήματος';
$string['errorremote'] = 'Απομακρυσμένο σφάλμα: {$a}';
$string['errorremotesendingcascade'] = 'Σφάλμα κατά την αποστολή αλληλοδιαδοχής:<br/> {$a}';
$string['errorupdateelement'] = 'Αδυναμία ενημέρωσης του στοιχείου';
$string['event_tracker_issue_commented'] = 'Ζήτημα Ιχνηλάτη που σχολιάστηκε';
$string['event_tracker_issue_reported'] = 'Ζήτημα Ιχνηλάτη που αναφέρθηκε';
$string['eventcourse_module_edited'] = 'Ιχνηλάτης που τροποποιήθηκε';
$string['eventcourse_module_list_viewed'] = 'Ιχνηλάτες που αναφέρονται';
$string['eventcourse_module_viewed'] = 'Ιχνηλάτες που εισήχθησαν';
$string['evolution'] = 'Τάσεις';
$string['evolutionbymonth'] = 'Εξέλιξη κατάστασης ζητήματος';
$string['failovertrackerurl'] = 'Αποτυχία λόγω διεύθυνσης URL ιχνηλάτησης';
$string['failovertrackerurl_help'] = 'Η χρήση του ιχνηλάτη μέσα στο Moodle ενδέχεται να μην αντιμετωπίζει καταστάσεις όπου το ίδιο το moodle δεν λειτουργεί ή δεν λειτουργεί σωστά. Όταν δίνετε μια διεύθυνση URL ιχνηλάτη (σε περίπτωση) αποτυχίας,
παρέχετε στους χρήστες πληροφορίες σχετικά με μια εναλλακτική διεύθυνση URL που μπορούν να χρησιμοποιήσουν σε περίπτωση μείζονος νόσου. Οι χρήστες θα κληθούν να προσθέσουν σελιδοδείκτη με τη διεύθυνση URL στα δεδομένα τους για να την λάβουν όταν χρειαστεί.';
$string['failovertrackerurl_tpl'] = 'Σε περίπτωση που αυτός ο ιχνηλάτης δεν είναι προσβάσιμος ή δεν είναι διαθέσιμος, μπορείτε να αναρτήσετε ένα σήμα στον <a href="{$a}">ιχνηλάτη έκτακτης ανάγκης</a>. Πρέπει να δημιουργήσετε έναν σελιδοδείκτη σε αυτήν τη διεύθυνση URL για να αποκτήσετε έναν σύνδεσμο διαθέσιμο ακόμα και αν το Moodle είναι εκτός λειτουργίας ή δεν λειτουργεί σωστά.';
$string['file'] = 'Συνημμένο αρχείο';
$string['follow'] = 'Ακολουθήστε';
$string['generaltrend'] = 'Τάση';
$string['gotooriginal'] = 'Μετάβαση στο αρχικό δελτίο';
$string['gototransfered'] = 'Μετάβαση στο μεταφερθέν δελτίο';
$string['hassolution'] = 'Έχει δημοσιευθεί μια λύση για αυτό το ζήτημα';
$string['hideccs'] = 'Απόκρυψη παρακολουθητών';
$string['hidecomments'] = 'Απόκρυψη σχολίων';
$string['hidedependancies'] = 'Απόκρυψη εξαρτήσεων';
$string['hidehistory'] = 'Απόκρυψη ιστορικού';
$string['history'] = 'Εντολοδόχοι';
$string['iamadeveloper'] = 'Μπορώ να εργαστώ στα δελτία';
$string['iamnotadeveloper'] = 'Δεν μπορώ να εργαστώ στα δελτία';
$string['icanmanage'] = 'Μπορώ να διαχειριστώ περιεχόμενο δελτίου';
$string['icannotmanage'] = 'Δεν μπορώ να διαχειριστώ περιεχόμενο δελτίου';
$string['icannotreport'] = 'Δεν μπορώ να δημιουργήσω αναφορά';
$string['icannotresolve'] = 'Δεν μπορώ να αναθέσω ούτε να κλείσω δελτία';
$string['icanreport'] = 'Μπορώ να δημιουργήσω αναφορά';
$string['icanresolve'] = 'Μπορώ να αναθέσω και να κλείσω δελτία';
$string['id'] = 'Αναγνωριστικό';
$string['intest'] = 'Δοκιμές';
$string['intro'] = 'Περιγραφή';
$string['inworkinmonth'] = 'Ακόμα σε εργασία';
$string['issueid'] = 'Δελτίο';
$string['issuename'] = 'Ταμπέλα δελτίου';
$string['issuenumber'] = 'Δελτίο';
$string['issues'] = 'εγγραφές δελτίου';
$string['issuestoassign'] = 'Δελτία προς εκχώρηση: {$a}';
$string['issuestowatch'] = 'Δελτία προς παρακολούθηση: {$a}';
$string['knownelements'] = 'Γνωστά στοιχεία φόρμας Ιχνηλάτη';
$string['listissues'] = 'Εμφάνιση λίστας';
$string['local'] = 'Τοπικό';
$string['lowerpriority'] = 'Χαμηλότερη προτεραιότητα';
$string['lowertobottom'] = 'Παρακάτω τελείως στη βάση';
$string['manageelements'] = 'Διαχείριση στοιχείων';
$string['managenetwork'] = 'Εγκατάσταση/ρύθμιση αλληλοδιαδοχής και δικτύου';
$string['manager'] = 'Διευθυντής';
$string['mandatory'] = 'Υποχρεωτική απάντηση';
$string['me'] = 'Το προφίλ μου';
$string['message_bugtracker'] = 'Ευχαριστούμε για την συνεισφορά σας και την βοήθειά σας στο να γίνει αυτή η υπηρεσία πιο αξιόπιστη.';
$string['message_taskspread'] = 'Μόλις ορίσατε μια εργασία. Μην ξεχάσετε να την αναθέσετε σε κάποιον παραλήπτη στις επόμενες οθόνες για να την διανείμετε.';
$string['message_ticketting'] = 'Έχουμε καταχωρίσει το ερώτημά σας. Έχει ανατεθεί στον/στην {$a}.';
$string['message_ticketting_preassigned'] = 'Έχουμε καταχωρίσει το ερώτημά σας. Θα εκχωρηθεί και θα το χειριστούμε το συντομότερο δυνατό.';
$string['mode_bugtracker'] = 'Tracker σφαλμάτων ομάδας';
$string['mode_customized'] = 'Προσαρμοσμένος ιχνηλάτης';
$string['mode_taskspread'] = 'Διανομέας εργασιών';
$string['mode_ticketting'] = 'Δελτία υποστήριξης χρηστών';
$string['mods_help'] = 'Αυτό το άρθρωμα παρέχει σε έναν διαχειριστή ή τεχνικό έναν τρόπο συλλογής τοπικών ζητημάτων σε μια υλοποίηση Moodle. Μπορεί να χρησιμοποιηθεί κυρίως ως ένα γενικό εργαλείο συστήματος για τη διαχείριση και υποστήριξη του Moodle σε τελικούς χρήστες, αλλά μπορεί επίσης να χρησιμοποιηθεί ως οποιαδήποτε άλλο άρθρωμα για μαθητικά έργα. Μπορούν να δημιουργηθούν πολλά στιγμιότυπα αυτού του αρθρώματος στο ίδιο μάθημα.
Η φόρμα περιγραφής του ζητήματος είναι πλήρως προσαρμόσιμη. Ο διαχειριστής ιχνηλάτησης μπορεί να προσθέσει όσες περιγραφές χρειάζεται, προσθέτοντας στοιχεία φόρμας. Η ενσωματωμένη μηχανή αναζήτησης ανταποκρίνεται σε αυτήν την προσαρμογή.';
$string['modulename'] = 'Υποστήριξη χρηστών - Ιχνηλάτης';
$string['modulename_help'] = 'Η δραστηριότητα του ιχνηλάτη επιτρέπει την παρακολούθηση δελτίων για βοήθεια, αναφορά σφαλμάτων ή επίσης ανιχνεύσιμες δραστηριότητες σε ένα μάθημα.

Η δραστηριότητα επιτρέπει τη δημιουργία της φόρμας ιχνηλάτησης με στοιχεία ιδιοχαρακτηριστικών από μια λίστα διαμορφώσιμων στοιχείων. Μερικά στοιχεία μπορούν να κοινοποιηθούν σε επίπεδο ιστοτόπου προκειμένου  να επαναχρησιμοποιηθούν σε άλλους ιχνηλάτες.

Το δελτίο (ή η εργασία) μπορεί να ανατεθεί/εκχωρηθεί για εργασία σε άλλο χρήστη.

Το ιχνηλατημένο δελτίο είναι ένα δελτίο κατάστασης που στέλνει ειδοποιήσεις αλλαγής κατάστασης σε οποιονδήποτε ακόλουθο έχει ενεργοποιήσει τις ειδοποιήσεις. Ένας χρήστης μπορεί να επιλέξει ποιες αλλαγές κατάστασης παρακολουθεί συνήθως.

Τα δελτίο μπορούν να οργανωθούν αλληλοδιαδοχικά, ώστε να είναι εύκολο να ακολουθήσετε μια ακολουθία δελτίων αιτίων/συνεπειών.

Το ιστορικό των αλλαγών παρακολουθείται για κάθε δελτίο.

Ο ιχνηλάτης δελτίων μπορεί να οργανωθεί αλληλοδιαδοχικά τοπικά ή μέσω του MNET επιτρέποντας σε έναν διαχειριστή δελτίων να στείλει ένα δελτίο σε έναν απομακρυσμένο (υψηλότερου επιπέδου) παραλήπτη δελτίων.

Οι ιχνηλάτες μπορούν τώρα να οργανωθούν αλληλοδιαδοχικά έτσι ώστε το δελτίο να μπορεί να μετακινηθεί μεταξύ των ιχνηλατών.';
$string['modulenameplural'] = 'Υποστήριξη χρηστών - ιχνηλάτες';
$string['month'] = 'Μήνα';
$string['myassignees'] = 'Διορθωτής στον οποίο ανέθεσα';
$string['myissues'] = 'Δελτία που διόρθωσα ο ίδιος';
$string['mypreferences'] = 'Οι προτιμήσεις μου';
$string['myprofile'] = 'Το προφίλ μου';
$string['mytasks'] = 'Τα δελτία μου';
$string['mytickets'] = 'Τα δελτία μου';
$string['mywatches'] = 'Τα προς παρακολούθησή μου';
$string['mywork'] = 'Η εργασία μου';
$string['name'] = 'Όνομα';
$string['namecannotbeblank'] = 'Το όνομα δεν μπορεί να είναι κενό';
$string['networkable'] = 'Δίκτυο ανοικτό';
$string['networkable_help'] = 'Εάν ενεργοποιηθεί, αυτός ο ιχνηλάτης θα εκτεθεί ανοιχτά σε απομακρυσμένο ιστότοπο. Οι χρήστες από απομακρυσμένο ιστότοπο θα μπορούν να αναρτούν ακόμη και αν δεν έχουν τοπικό λογαριασμό.
Ένας λογαριασμός Mnet θα δημιουργηθεί εν κινήσει. Αυτό θα είναι εφικτό όμως μόνο εάν οι υπηρεσίες ιχνηλάτη Mnet έχουν διαμορφωθεί σωστά σε κάθε πλευρά.';
$string['newissue'] = 'Νέο δελτίο';
$string['noassignedtickets'] = 'Δεν έχουν εκχωρηθεί δελτία';
$string['noassignees'] = 'Χωρίς εκχώρηση';
$string['nochange'] = 'Αφήστε χωρίς αλλαγή';
$string['nocomments'] = 'Χωρίς σχόλια';
$string['nodata'] = 'Δεν υπάρχουν δεδομένα προς εμφάνιση.';
$string['nodevelopers'] = 'Κανένας προγραμματιστής';
$string['noelements'] = 'Κανένα στοιχείο';
$string['noelementscreated'] = 'Δεν δημιουργήθηκε κανένα στοιχείο';
$string['nofile'] = 'Δεν ανέβηκε κανένα αρχείο';
$string['nofileloaded'] = 'Κανένα αρχείο δεν φορτώθηκε εδώ.';
$string['noissuesreported'] = 'Κανένα δελτίο εδώ';
$string['noissuesresolved'] = 'Κανένα επιδιορθωμένο δελτίο';
$string['nolocalcandidate'] = 'Δεν υπάρχει τοπικός υποψήφιος για αλληλοδιαδοχή';
$string['nomnet'] = 'Το δίκτυο Moodle μοιάζει απενεργοποιημένο';
$string['nooptions'] = 'Καμία επιλογή';
$string['noremotehosts'] = 'Κανένας κεντρικός Η/Υ δικτύου διαθέσιμος';
$string['noremotetrackers'] = 'Κανένας διαθέσιμος απομακρυσμένος ιχνηλάτης';
$string['noreporters'] = 'Κανένας αναφέρων. Πιθανόν δεν έχει δηλωθεί κανένα ζήτημα εδώ.';
$string['noresolvers'] = 'Κανένας διορθωτής';
$string['noresolvingissue'] = 'Κανένα δελτίο δεν ανατέθηκε';
$string['notickets'] = 'Κανένα δικό σας δελτίο.';
$string['noticketsorassignation'] = 'Κανένα δελτίο ή ανάθεση';
$string['notifications'] = 'Ειδοποιήσεις';
$string['notifications_help'] = 'Αυτή η παράμετρος ενεργοποιεί ή απενεργοποιεί τις ειδοποιήσεις μέσω ηλε.ταχυδρομείου από τον Ιχνηλάτη. Εάν είναι ενεργοποιημένη, ορισμένα συμβάντα ή αλλαγές κατάστασης στον ιχνηλάτη θα προκαλέσουν μηνύματα ηλε.ταχυδρομείου στους ενδιαφερόμενους χρήστες.';
$string['notrackeradmins'] = 'Χωρίς διαχειριστές';
$string['nowatches'] = 'Χωρίς παρακολουθητές';
$string['numberofissues'] = 'Πλήθος δελτίων';
$string['observers'] = 'Παρατηρητές';
$string['on'] = 'Ναι';
$string['open'] = 'Άνοιγμα';
$string['option'] = 'Επιλογή';
$string['optionisused'] = 'Αυτό το αναγνωριστικό επιλογών χρησιμοποιείται ήδη για αυτό το στοιχείο.';
$string['options'] = 'Επιλογές';
$string['options_help'] = '### Ένα όνομα
Το όνομα προσδιορίζει την τιμή επιλογής. Θα πρέπει να είναι ένα κουπόνι που χρησιμοποιεί αλφαριθμητικούς χαρακτήρες και _ χωρίς κενά ή μη εκτυπώσιμους χαρακτήρες.

### Περιγραφή

Η περιγραφή είναι το ορατό αντίστοιχο του κώδικα επιλογής.

### Τακτοποίηση επιλογών

Μπορείτε να ορίσετε τη σειρά με την οποία εμφανίζονται οι επιλογές στις λίστες.

Τα στοιχεία πεδίου κειμένου και περιοχής κειμένου δεν έχουν καμία επιλογή.';
$string['order'] = 'Σειρά';
$string['originalticketnoaccess'] = 'Αυτό το δελτίο μεταφέρθηκε από άλλο δελτίο στο οποίο δεν έχετε πρόσβαση ανάγνωσης.';
$string['pages'] = 'Σελίδες';
$string['pluginadministration'] = 'Διαχείριση ιχνηλάτη';
$string['pluginname'] = 'Δελτίο υποστήριξης ιχνηλάτη/χρήστη';
$string['posted'] = 'Αναρτήθηκε';
$string['potentialresolvers'] = 'Πιθανοί διορθωτές';
$string['preferences'] = 'Προτιμήσεις';
$string['prefsnote'] = 'Σετ ρυθμίσεων προτιμήσεων με προεπιλεγμένες ειδοποιήσεις που ενδέχεται να λάβετε κατά τη δημιουργία μιας νέας καταχώρησης ή όταν καταχωρείτε μια παρακολούθηση για ένα υπάρχον ζήτημα';
$string['print'] = 'Εκτύπωση';
$string['priority'] = 'Αποδιδόμενη προτεραιότητα';
$string['priorityid'] = 'Προτεραιότητα';
$string['private'] = 'Ιδιωτικές πληροφορίες';
$string['profile'] = 'Ρυθμίσεις χρήστη';
$string['published'] = 'Δημοσιευθέν';
$string['radio'] = 'Κουμπιά μοναδικής επιλογής';
$string['radiohoriz'] = 'Οριζόντια κουμπιά μοναδικής επιλογής';
$string['raisepriority'] = 'Αύξηση προτεραιότητας';
$string['raiserequestcaption'] = 'Αίτημα αύξησης προτεραιότητας για δελτίο';
$string['raiserequesttitle'] = 'Ζητήστε αύξηση προτεραιότητας';
$string['raisetotop'] = 'Αύξηση στο ανώτατο όριο';
$string['reason'] = 'Αιτία';
$string['register'] = 'Παρακολουθήστε αυτό το δελτίο';
$string['reportanissue'] = 'Ανάρτηση ενός δελτίου';
$string['reportedby'] = 'Αναφορά από';
$string['reporter'] = 'Αναφέρων';
$string['reports'] = 'Αναφορές';
$string['resolution'] = 'Επιδιόρθωση';
$string['resolved'] = 'Επιδιορθώθηκε';
$string['resolvedplural'] = 'Επιδιορθώθηκαν';
$string['resolvedplural2'] = 'Επιδιορθώθηκαν';
$string['resolver'] = 'Τα ζητήματά μου';
$string['resolvers'] = 'Επιδιορθωτές';
$string['resolving'] = 'Επιδιορθώσεις';
$string['runninginmonth'] = 'Εκτέλεση στον τρέχοντα μήνα';
$string['search'] = 'Αναζήτηση';
$string['searchbyid'] = 'Αναζήτηση με το αναγνωριστικό';
$string['searchcriteria'] = 'Κριτήρια αναζήτησης';
$string['searchresults'] = 'Αποτελέσματα αναζήτησης';
$string['selectparent'] = 'Γονική επιλογή';
$string['sendrequest'] = 'Αποστολή αιτήματος';
$string['setactive'] = 'Ορισμός ως ενεργού';
$string['setinactive'] = 'Εμφάνιση στην φόρμα';
$string['setmandatory'] = 'Ορισμός δεδομένου ως απαιτούμενου';
$string['setnotmandatory'] = 'Ορισμός δεδομένου ως μη απαιτούμενου';
$string['setoncomment'] = 'Στείλτε μου τα σχόλια';
$string['setprivate'] = 'Ορισμός πληροφοριών ως ιδιωτικών μόνο για προγραμματιστές';
$string['setpublic'] = 'Ορισμός πληροφοριών ως δημόσιων';
$string['setwhenopens'] = 'Μην με συμβουλεύετε όταν ανοίγει';
$string['setwhenpublished'] = 'Μην με συμβουλεύετε όταν δημοσιεύεται η λύση';
$string['setwhenresolves'] = 'Μην με συμβουλεύετε όταν επιλυθεί';
$string['setwhentesting'] = 'Μην με συμβουλεύετε όταν δοκιμάζεται μια λύση';
$string['setwhenthrown'] = 'Μην με συμβουλεύετε όταν εγκαταλειφθεί';
$string['setwhenwaits'] = 'Μην με συμβουλεύετε όταν βρίσκεται σε αναμονή';
$string['setwhenworks'] = 'Μην με συμβουλεύετε όταν βρίσκεται σε εργασία';
$string['sharethiselement'] = 'Ορισμός αυτού του στοιχείου για όλο τον ιστότοπο';
$string['sharing'] = 'Κοινή χρήση';
$string['showccs'] = 'Εμφάνιση παρακολουθητών';
$string['showcomments'] = 'Εμφάνιση σχολίων';
$string['showdependancies'] = 'Εμφάνιση εξαρτήσεων';
$string['showhistory'] = 'Εμφάνιση ιστορικού';
$string['site'] = 'Ιστότοπος';
$string['solution'] = 'Λύση';
$string['sortorder'] = 'Σειρά';
$string['standalone'] = 'Αυτόνομος ιχνηλάτης (υποστήριξη ανώτατου επιπέδου).';
$string['statehistory'] = 'Καταστάσεις';
$string['stateprofile'] = 'Καταστάσεις κουπονιού';
$string['status'] = 'Κατάσταση';
$string['strictworkflow'] = 'Αυστηρή ροή εργασιών';
$string['strictworkflow_help'] = 'Όταν ενεργοποιηθεί, κάθε συγκεκριμένος εσωτερικός ρόλος στον ιχνηλάτη (αναφέρων, προγραμματιστής, επιλύων, διαχειριστής) θα έχει πρόσβαση μόνο στις προσβάσιμες καταστάσεις του σε σχέση με τον ρόλο του.';
$string['submission'] = 'Ένα νέο δελτίο αναφέρεται στον ιχνηλάτη [{$a}]';
$string['subtrackers'] = 'Δευτερεύοντες ιχνηλάτες';
$string['sum_opened'] = 'Ανοικτά';
$string['sum_posted'] = 'Σε αναμονή';
$string['sum_reported'] = 'Αναφερθέντα';
$string['sum_resolved'] = 'Επιλυμένα';
$string['summary'] = 'Περίληψη';
$string['supportmode'] = 'Κατάσταση υποστήριξη';
$string['supportmode_help'] = 'Η λειτουργία υποστήριξης εφαρμόζει ορισμένες προκαθορισμένες ρυθμίσεις και παρακάμψεις ρόλων στον ιχνηλάτη για να επιτύχει μια προκαθορισμένη συμπεριφορά.

* Αναφορά σφαλμάτων: Οι αναφέροντες έχουν πρόσβαση σε ολόκληρη τη λίστα δελτίων για την ανάγνωση των ζητημάτων με συνεργατικό τρόπο. Όλες οι καταστάσεις είναι ενεργοποιημένες για μια πλήρη ροή εργασιών τεχνικής λειτουργίας, συμπεριλαμβανομένων λειτουργιών σε συστήματα δοκιμών προπαρασκευής/προπαραγωγής.

* Υποστήριξη χρηστών / Δελτία: Οι αναφέροντες έχουν συνήθως πρόσβαση μόνο στα δελτία που έχουν δημοσιεύσει και δεν μπορούν να έχουν πρόσβαση στη λειτουργία αναζήτησης δελτίων. Μερικές καταστάσεις
έχουν απενεργοποιηθεί, που χρησιμοποιούνται πιο συχνά για τεχνικές εργασίες.

* Διανομή εργασιών: Οι αναφέροντες μπορούν να έχουν ή όχι πρόσβαση σε ολόκληρη τη λίστα δελτίων που διανέμεται. Οι εργαζόμενοι μπορούν να έχουν πρόσβαση μόνο στα δελτία τα οποία τους έχουν ανατεθεί μέσω της οθόνης «Η δουλειά μου». ΔΕΝ θα έχουν πρόσβαση στη λειτουργία αναζήτησης & κάποιες ενδιάμεσες καταστάσεις έχουν απενεργοποιηθεί για απλούστερη (επι)σήμανση των καταστάσεων εργασιών.

* Προσαρμοσμένο: Όταν προσαρμόζεται, ο επεξεργαστής δραστηριότητας μπορεί να επιλέξει καταστάσεις και παρακάμψεις προς εφαρμογή στον ιχνηλάτη. Αυτό είναι η πιο ευέλικτη ρύθμιση, αλλά χρειάζεται σωστή γνώση των ρόλων του Moodle και της διαχείρισης των ρυθμίσεων.';
$string['testing'] = 'Υπό δοκιμή';
$string['text'] = 'Πεδίο κειμένου';
$string['textarea'] = 'Περιοχή κειμένου';
$string['thanksdefault'] = 'Ευχαριστούμε για τη συνεισφορά στη συνεχή βελτίωση αυτής της υπηρεσίας.';
$string['thanksmessage'] = 'Ευχαριστήριο μήνυμα.';
$string['ticketprefix'] = 'Πρόθεμα δελτίου';
$string['ticketprefix_help'] = 'Αυτή η παράμετρος επιτρέπει τον ορισμό ενός σταθερού προθέματος που θα προστεθεί στο αριθμητικό αναγνωριστικό ζητήματος. Αυτό θα επιτρέψει την καλύτερη αναγνώριση μιας καταχώρησης ζητήματος σε έγγραφα, αναρτήσεις φόρουμ...';
$string['tickets'] = 'Δελτία';
$string['tracker-levelaccess'] = 'Οι δυνατότητές μου σε αυτόν τον ιχνηλάτη';
$string['tracker:addinstance'] = 'Προσθήκη ενός ιχνηλάτη';
$string['tracker:canbecced'] = 'Να επιλεγείτε για cc';
$string['tracker:comment'] = 'Σχολιασμός ζητημάτων';
$string['tracker:configure'] = 'Ρυθμίσεις επιλογών ιχνηλάτη';
$string['tracker:configurenetwork'] = 'Ρυθμίσεις λειτουργιών δικτύου';
$string['tracker:develop'] = 'Να επιλεγείτε για να επιλύσετε δελτία';
$string['tracker:manage'] = 'Διαχείριση ζητημάτων';
$string['tracker:managepriority'] = 'Διαχείριση προτεραιοτήτων των καταχωρήσεων';
$string['tracker:managewatches'] = 'Διαχείριση παρακολουθητών στο δελτίο';
$string['tracker:report'] = 'Αναφορά νέων δελτίων';
$string['tracker:resolve'] = 'Επίλυση δελτίων';
$string['tracker:seeissues'] = 'Εμφάνιση περιεχομένου ζητήματος';
$string['tracker:shareelements'] = 'Κοινή χρήση στοιχείων σε επίπεδο ιστοτόπου';
$string['tracker:viewallissues'] = 'Εμφάνιση όλων των δελτίων';
$string['tracker:viewpriority'] = 'Εμφάνιση προτεραιοτήτων των δικών μου δελτίων';
$string['tracker:viewreports'] = 'Εμφάνιση αναφορών εργασίας σε ζητήματα';
$string['tracker_description'] = '<p>Κατά τη δημοσίευση αυτής της υπηρεσίας, να επιτρέπεται στους ιχνηλάτες από {$a} να οργανώνουν αλληλοδιαδοχή των δελτίων υποστήριξης με έναν τοπικό ιχνηλάτη.</p>
<ul><li><i>Εξαρτάται από</i>: Απαιτείται εγγραφή {$a} σε αυτήν την υπηρεσία.</li></ul>
<p>Η εγγραφή σε αυτήν την υπηρεσία επιτρέπει στους τοπικούς ιχνηλάτες να στέλνουν δελτία υποστήριξης σε κάποιον ιχνηλάτη στο {$a}.</p>
<ul><li><i>Εξαρτάται από </i>: Απαιτείται δημοσίευση αυτής της υπηρεσίας στο {$a}.</li></ul>';
$string['tracker_name'] = 'Υπηρεσίες αρθρώματος ιχνηλάτη';
$string['tracker_service_name'] = 'Υπηρεσίες αρθρώματος ιχνηλάτη';
$string['trackerelements'] = 'Ορισμός ιχνηλάτη';
$string['trackereventchanged'] = 'Αλλαγή κατάστασης ζητήματος στον ιχνηλάτη [{$a]}';
$string['trackerhost'] = 'Γονικός κεντρικός Η/Υ ιχνηλάτη';
$string['trackername'] = 'Όνομα ιχνηλάτη';
$string['transfer'] = 'Μεταφέρθηκε';
$string['transfered'] = 'Μεταφέρθηκε';
$string['transferedticketnoaccess'] = 'Αυτό το δελτίο μεταφέρεται σε άλλο δελτίο στο οποίο δεν έχετε πρόσβαση ανάγνωσης.';
$string['transferservice'] = 'Υποστήριξη αλληλοδιαδοχής δελτίων';
$string['turneditingoff'] = 'Απενεργοποίηση επεξεργασίας';
$string['turneditingon'] = 'Ενεργοποίηση επεξεργασίας';
$string['type'] = 'Τύπος';
$string['unassigned'] = 'Ακύρωση ανάθεσης';
$string['unbind'] = 'Αλληλοδιαδοχή αποδεσμεύσεων';
$string['unmatchingelements'] = 'Και οι δύο ορισμοί ιχνηλάτη δεν ταιριάζουν. Αυτό μπορεί να οδηγήσει σε απροσδόκητη συμπεριφορά κατά την αλληλοδιαδοχή δελτίων υποστήριξης.';
$string['unregisterall'] = 'Κατάργηση καταχώρησης από όλα';
$string['unsetoncomment'] = 'Συμβουλέψτε με όταν αναρτώ σχόλια';
$string['unsetwhenopens'] = 'Συμβουλέψτε με κατά το άνοιγμα';
$string['unsetwhenpublished'] = 'Συμβουλέψτε με κατά τη δημοσίευση λύσης';
$string['unsetwhenresolves'] = 'Συμβουλέψτε με όταν επιλυθεί';
$string['unsetwhentesting'] = 'Συμβουλέψτε με όταν δοκιμάζεται μια λύση';
$string['unsetwhenthrown'] = 'Συμβουλέψτε με όταν ρίπτεται';
$string['unsetwhenwaits'] = 'Συμβουλέψτε με όταν βρίσκεται σε αναμονή';
$string['unsetwhenworks'] = 'Συμβουλέψτε με όταν ξεκινήσει εργασία';
$string['urgentquery_help'] = 'Αν επιλέξετε αυτό το πλαίσιο επιλογής, θα στείλετε ένα μήνυμα στους προγραμματιστές ή στους διαχειριστές δελτίων, ώστε το ζήτημά σας να εξεταστεί πιο γρήγορα.
Παρακαλούμε, λάβετε υπόψη όμως ότι δεν υπάρχει αυτοματοποιημένη διαδικασία που να χρησιμοποιεί απευθείας αυτήν τη μεταβλητή. Η αποδοχή της έκτακτης ανάγκης θα εξαρτηθεί από το πώς οι διαχειριστές επείγουσας υποστήριξης εξέτασαν το αίτημά σας.';
$string['urgentraiserequestcaption'] = 'Ένας χρήστης έχει κάνει αίτημα για απαίτηση επείγουσας προτεραιότητας.';
$string['urgentsignal'] = 'ΕΠΕΙΓΟΝ ΕΡΩΤΗΜΑ';
$string['validated'] = 'Επικυρώθηκε';
$string['view'] = 'Εμφανίσεις';
$string['vieworiginal'] = 'Δείτε το πρωτότυπο';
$string['voter'] = 'Ψήφος';
$string['waiting'] = 'Αναμονή';
$string['watches'] = 'Προς παρακολούθηση';
$string['youneedanaccount'] = 'Χρειάζεστε έναν εξουσιοδοτημένο λογαριασμό εδώ για να αναφέρετε ένα δελτίο';
