<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'af', version '5.0'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.blog.errorloadentries'] = 'Kon nie blog-inskrywings laai nie.';
$string['addon.blog.showonlyyourentries'] = 'Wys slegs jou inskrywings.';
$string['addon.calendar.calendarevent'] = 'Kalendergeleentheid';
$string['addon.calendar.calendarevents'] = 'Kalender gebeure';
$string['addon.calendar.calendarreminders'] = 'Kalenderaanmanings';
$string['addon.calendar.currentmonth'] = 'Huidige maand';
$string['addon.calendar.defaultnotificationtime'] = 'Standaard kennisgewingtydperk';
$string['addon.calendar.errorloadevent'] = '\'n Fout het ontstaan met die laai van die gebeurtenis.';
$string['addon.calendar.errorloadevents'] = '\'n Fout het ontstaan met die laai van die gebeure.';
$string['addon.calendar.noevents'] = 'Daar is geen gebeure';
$string['addon.calendar.reminders'] = 'Aanmanings';
$string['addon.calendar.setnewreminder'] = 'Stel \'n nuwe aanmaning';
$string['addon.competency.errornocompetenciesfound'] = 'Geen bevoegdhede gevind nie';
$string['addon.competency.nocompetencies'] = 'Geen bevoegdhede';
$string['addon.coursecompletion.complete'] = 'Volledig';
$string['addon.coursecompletion.couldnotloadreport'] = 'Kon nie die voltooiing verslag laai nie, probeer asb. weer later.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Stel toestelle op';
$string['addon.messages.contactlistempty'] = 'Die kontak lys is leeg';
$string['addon.messages.contactname'] = 'Kontak naam';
$string['addon.messages.deletemessage'] = 'Verwyder boodskap';
$string['addon.messages.deletemessageconfirmation'] = 'Is jy seker jy wil hierdie boodskap verwyder? Dit sal egter steeds sigbaar wees vir die ander kontak.';
$string['addon.messages.errordeletemessage'] = '\'n Fout het ontstaan tydens die verwydering van die boodskap.';
$string['addon.messages.errorwhileretrievingcontacts'] = '\'n Fout het ontstaan tydens die verkryging van kontakte vanaf die bediener.';
$string['addon.messages.errorwhileretrievingdiscussions'] = '\'n Fout het ontstaan tydens die verkryging van gesprekke vanaf die bediener.';
$string['addon.messages.errorwhileretrievingmessages'] = '\'n Fout is begaan tydens die verkryging van boodskappe vanaf die bediener.';
$string['addon.messages.errorwhileretrievingusers'] = 'Iets het skeef geloop met herwinning van gebruikers vanaf die bediener.';
$string['addon.messages.messagenotsent'] = 'Die boodskap is nie gestuur nie, probeer asseblief later weer.';
$string['addon.messages.newmessages'] = 'Nuwe boodskappe';
$string['addon.messages.nousersfound'] = 'Geen gebruikers gevind nie';
$string['addon.messages.showdeletemessages'] = 'Wys skrap boodskappe';
$string['addon.messages.type_blocked'] = 'Geblok';
$string['addon.messages.type_offline'] = 'Nie beskikbaar nie';
$string['addon.messages.type_online'] = 'Aanlyn';
$string['addon.messages.type_search'] = 'Soek resultate';
$string['addon.messages.type_strangers'] = 'Ander';
$string['addon.messages.useentertosenddescdesktop'] = 'Indien gedeaktiveer kan jy Ctrl+Enter gebruik om die boodskap te stuur.';
$string['addon.messages.useentertosenddescmac'] = 'Indien gedeaktiveer kan jy Cmd+Enter gebruik om die boodskap te stuur.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Kon nie boodskap(pe) na gesprek {{conversation}} versend nie. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Kan nie boodskap(pe) stuur aan {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Aanvaar asseblief die voorlegging verklaring.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Jy kan nie \'n inhandiging byvoeg of aanpas in die App nie.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Party metodes om te merk word nog nie deur die App ondersteun nie.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Jy kan nie \'n inhandiging byvoeg om gemerk te word in die App nie.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Jy kan nie \'n inhandiging byvoeg of aanpas in die App nie.';
$string['addon.mod_assign.errorshowinginformation'] = 'Die inligting kan nie vertoon word nie';
$string['addon.mod_assign.feedbacknotsupported'] = 'Hierdie terugvoer word nie ondersteun deur die App nie en mag dalk nie al die inligting bevat nie.';
$string['addon.mod_assign.gradenotsynced'] = 'Punt nie gesinkroniseer nie';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Deelnemers sonder inhandigings word nie gewys nie';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Daar is {{count}} konsepte.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Daar is {{count}} deelnemers.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Daar is {{count}} inhandigings wat nasien benodig.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Daar is {{count}} ingehandigde opdragte.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Daar is {{count}} spanne.';
$string['addon.mod_assign.submissionnotsupported'] = 'Hierdie inhandiging word nie ondersteun deur die App nie en mag dalk nie al die inligting bevat nie';
$string['addon.mod_assign.syncblockedusercomponent'] = 'gebruiker se punt';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Die inhandiging punt is aangepas op die webwerf.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Die gebruiker se inhandiging is aangepas op die webwerf.';
$string['addon.mod_chat.confirmloss'] = 'Is jy seker? Kletsgeskiedenis kan verlore gaan.';
$string['addon.mod_chat.errorwhileconnecting'] = '\'n Fout het ontstaan tydens die koppeling aan die klets opsie.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = '\'n Fout het ontstaan tydens die aflaai van klets data.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = '\'n Fout het ontstaan tydens die aflaai van klets gebruikers.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = '\'n Fout het ontstaan tydens die aflaai van boodskappe vanaf die bediener.';
$string['addon.mod_chat.errorwhilesendingmessage'] = '\'n Fout het ontstaan met die stuur van die boodskap.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Jy moet aanlyn wees om boodskappe te stuur.';
$string['addon.mod_chat.nosessionsfound'] = 'Geen sessies gevind nie';
$string['addon.mod_chat.showincompletesessions'] = 'Wys onvoltooide sessies';
$string['addon.mod_choice.errorgetchoice'] = '\'n Fout is begaan met die aflaai van die keuse data.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% van die gebruikers het die volgende opsie gekies: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Jou laaste response moet eers gesinkroniseer word voordat dit deel vorm van die resultate.';
$string['addon.mod_data.edittagsnotsupported'] = 'Jammer, redigeringmerkers werk nie met hierdie app nie.';
$string['addon.mod_data.errorapproving'] = 'Kon nie inskrywing goedkeur of afkeur nie.';
$string['addon.mod_data.errordeleting'] = 'Kon nie inskrywing verwyder nie.';
$string['addon.mod_data.gettinglocation'] = 'Verkry ligging';
$string['addon.mod_data.locationnotenabled'] = 'Ligging is nie geaktiveer nie';
$string['addon.mod_data.locationpermissiondenied'] = 'Toestemming om toegang tot jou ligging te verkry, is geweier.';
$string['addon.mod_data.mylocation'] = 'My ligging';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Jammer, soektogte volgens merkers werk nie met hierdie app nie.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Terugvoer met CAPTCHA kan nie voltooi word sonder internettoegang nie, of as dit nie gekonfigureer is nie, of as die bediener af is.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Daar is {{count}} ingediende antwoorde.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Hierdie terugvoer is gestoor om later ingedien te word.';
$string['addon.mod_feedback.questionscountdescription'] = 'Daar is {{count}} vrae.';
$string['addon.mod_folder.emptyfilelist'] = 'Daar is geen lêers om te wys nie.';
$string['addon.mod_forum.errorgetforum'] = '\'n Fout het ontstaan met die aflaai van forum data.';
$string['addon.mod_forum.errorgetgroups'] = '\'n Fout het ontstaan met die aflaai van groep verstellings.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Kon nie \'n nuwe bespreking in alle groepe skep nie.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Daar is nog geen bespreking onderwerpe in hierdie forum nie.';
$string['addon.mod_forum.group'] = 'Groep';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} besprekings';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} antwoorde';
$string['addon.mod_forum.refreshposts'] = 'Herlaai bespreking boodskappe';
$string['addon.mod_glossary.browsemode'] = 'Vertoon inskrywings';
$string['addon.mod_glossary.byalphabet'] = 'Alfabeties';
$string['addon.mod_glossary.byauthor'] = 'Groepeer volgens die skrywer';
$string['addon.mod_glossary.bycategory'] = 'Groepeer volgens kategorie';
$string['addon.mod_glossary.bynewestfirst'] = 'Nuutste eerste';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Onlangs bygewerk';
$string['addon.mod_glossary.bysearch'] = 'Soek';
$string['addon.mod_glossary.cannoteditentry'] = 'Kan nie die inskrywing wysig nie';
$string['addon.mod_glossary.entriestobesynced'] = 'Inskrywings wat gesinkroniseer moet word';
$string['addon.mod_glossary.entrypendingapproval'] = 'Hierdie inskrywing wag vir goedkeuring.';
$string['addon.mod_glossary.errorloadingentries'] = '\'n Fout het ontstaan met die laai van die inskrywings.';
$string['addon.mod_glossary.errorloadingentry'] = '\'n Fout het ontstaan met die laai van die inskrywing.';
$string['addon.mod_glossary.errorloadingglossary'] = '\'n Fout het ontstaan met die laai van die woordelys.';
$string['addon.mod_glossary.noentriesfound'] = 'Geen inskrywings is gevind nie.';
$string['addon.mod_glossary.searchquery'] = 'Soeknavraag';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Laai H5P-lêer af';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Kon nie H5P-aktiwiteitdata bekom nie.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'Die H5P-pakket is nie afgelaai nie. As jy dit wil gebruik, moet jy dit aflaai.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'Die H5P-pakket is sedert die laaste aflaai gewysig. Jy moet dit weer aflaai as jy dit wil gebruik.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Jy moet aanlyn wees om die H5P-pakket te bekyk.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Bekyk poging {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Wys beskrywing';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Hierdie les bevat \'n sprong na \'n willekeurige inhoudsbladsy. Dit kan nie in die app voltooi word voordat dit in \'n webblaaier begin is nie.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Hierdie poging kan nie meer hersien word nie omdat \'n ander poging afgehandel is.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Hierdie poging is afgehandel sonder \'n verbinding met die internet.';
$string['addon.mod_lesson.retakefinishedinsync'] = '\'n Poging wat voltooi is sonder \'n internet verbinding is gesinkroniseer. Wil jy dit hersien?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Die poging is op die blad voltooi.';
$string['addon.mod_lti.errorgetlti'] = '\'n Fout het ontstaan met die aflaai van kursus data.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Die URL is nie geldig nie.';
$string['addon.mod_lti.launchactivity'] = 'Begin die aktiwiteit';
$string['addon.mod_page.errorwhileloadingthepage'] = '\'n Fout het ontstaan tydens die laai van die inhoud van die bladsy.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Jy kan probeer om hierdie toets-jou-kennis-oefening in die app af te handel, maar jy sal steeds om die volgende redes jou poging via die blaaier moet oplaai:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Hierdie toets poging kan vir die volgende redes nie ingedien word nie:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Die poging aangewend is nog nie gesinchroniseer sedert {{$a}} nie. As jy met \'n ander toestel hierdie poging voortgesit het, mag jy dalk data verloor.';
$string['addon.mod_quiz.confirmleavequizonerror'] = '\'n Fout het voorgekom terwyl die antwoorde gestoor is. Is jy seker jy wil die toets verlaat?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Hierdie toets kan nie oopgemaak word in die App nie omdat die gedrag van die vraag nie ondersteun word deur die App nie:';
$string['addon.mod_quiz.errordownloading'] = '\'n Fout het ontstaan met die aflaai van die vereiste data.';
$string['addon.mod_quiz.errorgetattempt'] = '\'n Fout het ontstaan met die aflaai van die poging data.';
$string['addon.mod_quiz.errorgetquestions'] = '\'n Fout het ontstaan met die aflaai van die vrae.';
$string['addon.mod_quiz.errorgetquiz'] = '\'n Fout het ontstaan met die aflaai van die toets data.';
$string['addon.mod_quiz.errorparsequestions'] = '\'n Fout is begaan tydens die lees van die vrae. Voltooi asseblief hierdie toets in \'n webblaaier.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Hierdie toets-jou-kennis-oefening kan nie in die app aangedurf word nie omdat dit slegs vrae bevat wat nie deur die app ondersteun word nie:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Hierdie toets kan nie oopgemaak word in die App nie omdat dit toegang reëls het wat nie ondersteun word deur die App nie:';
$string['addon.mod_quiz.errorsaveattempt'] = '\'n Fout het voorgekom tydens die stoor van die poging data.';
$string['addon.mod_quiz.finishnotsynced'] = 'Voltooi maar nie gesinchroniseer nie';
$string['addon.mod_quiz.opentoc'] = 'Maak navigasie \'popover\' oop.';
$string['addon.mod_quiz.warningattemptfinished'] = 'Aflyn poging weggegooi omdat dit klaar voltooi is in die webwerf of nie gevind is nie.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Sommige aflyn antwoorde is weggegooi omdat die vrae aanlyn verander is.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Poging onvoltooid omdat sommige aflyn antwoorde weggegooi is. Gaan asseblief jou antwoorde na en handig dan die poging in.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Hierdie toets-jou-kennis-oefening bevat vrae wat nie deur die app ondersteun word nie:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = '\'n Fout het ontstaan met die laai van die inhoud.';
$string['addon.mod_resource.openthefile'] = 'Maak oop';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Punt kon nie bereken word nie.';
$string['addon.mod_scorm.dataattemptshown'] = 'Hierdie data behoort aan poging nommer {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = '\'n Fout het ontstaan tydens die skep van \'n nuwe aflyn poging. Probeer asseblief weer.';
$string['addon.mod_scorm.errordownloadscorm'] = '\'n Fout het ontstaan met die aflaai van SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = '\'n Fout het ontstaan met die aflaai van SCORM data.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Jammer, die App ondersteun net SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Die aflaai van SCORM pakkette word nie toegelaat nie. Kontak asb. jou blad se administrateur.';
$string['addon.mod_scorm.errornovalidsco'] = 'Hierdie SCORM het nie \'n sigbare SCO om te laai nie.';
$string['addon.mod_scorm.errorpackagefile'] = 'Jammer, die App ondersteun net zip pakkette.';
$string['addon.mod_scorm.errorsyncscorm'] = '\'n Fout het voorgekom tydens sinkronisasie. Probeer asseblief weer.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Hierdie poging het data wat nie gesinkroniseer is nie.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Hierdie poging kan nie gestuur word nie omdat jy die maksimum aantal pogings oortref.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Hierdie SCORM pakket is nie afgelaai. Dit sal outomaties afgelaai word wanneer jy dit oopmaak.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Hierdie SCORM pakket het al verander sedert die laaste aflaai. Dit sal outomaties afgelaai word wanneer jy dit oopmaak.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Sommige data van poging {{number}} is weggegooi omdat dit nie as \'n nuwe poging getel kon word nie.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Sommige pogings kon nie gesinkroniseer word met die webblad nie, want die laaste aanlyn poging is nog nie klaar nie. Voltooi assbelief eers die aanlyn poging.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Jammer, daar was \'n probleem met die indiening van u opname. Probeer asseblief weer.';
$string['addon.mod_survey.errorgetsurvey'] = 'Kon nie opname data kry nie.';
$string['addon.mod_survey.results'] = 'Resultate';
$string['addon.mod_url.accessurl'] = 'Gaan na die URL';
$string['addon.mod_url.pointingtourl'] = 'URL waarna hierdie hulpbron wys';
$string['addon.mod_wiki.errorloadingpage'] = '\'n Fout het ontstaan tydens die laai van bladsy.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Hierdie wiki het nog nie enige inhoud nie.';
$string['addon.mod_wiki.gowikihome'] = 'Gaan na die wiki tuisblad';
$string['addon.mod_wiki.subwiki'] = 'Sub-wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Titel mag nie leeg wees nie';
$string['addon.mod_wiki.viewpage'] = 'Besigtig bladsy';
$string['addon.mod_wiki.wikipage'] = 'Wiki bladsy';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Assesseringstrategie {{$a}} word nie ondersteun nie';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Jy moet \'n titel spesifiseer.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Die inhandiging is op die webwerf gewysig.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Die assessering is op die webwerf gewysig.';
$string['addon.notes.warningnotenotsent'] = 'Kon nie nota(s) byvoeg tot kursus {{course}} nie. {{error}}';
$string['addon.notifications.errorgetnotifications'] = '\'n Fout het ontstaan met die aflaai van kennisgewings.';
$string['addon.notifications.notifications'] = 'Kennisgewings';
$string['addon.notifications.playsound'] = 'Speel klank';
$string['addon.notifications.therearentnotificationsyet'] = 'Daar is geen kennisgewings nie.';
$string['addon.privatefiles.couldnotloadfiles'] = 'Die lys van lêers kon nie gelaai word nie.';
$string['addon.privatefiles.emptyfilelist'] = 'Daar is geen lêers om te wys nie.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Ongelukkig is dit nie tans moontlik om lêers na jou blad op te laai nie.';
$string['addon.storagemanager.deletecourses'] = 'Laai alle kursusse se data af';
$string['addon.storagemanager.deletedatafrom'] = 'Laai data af vanaf {{name}}';
$string['appstoredescription'] = 'LET WEL: Hierdie amptelike Moodle Mobile app werk SLEGS met Moodle-webtuistes wat opgestel is om dit toe te laat. Praat asseblief met u Moodle-administrateur as u probleme ondervind om te verbind.

As jou Moodle-webtuiste korrek opgestel is, kan jy hierdie program gebruik om:
- Te blaai deur die inhoud van jou kursusse, selfs wanneer jy nie internet toegang het nie
- onmiddellike kennisgewings van boodskappe en ander geleenthede te ontvang
- ander mense in jou kursusse vinnig te vind en te kontak
- Beeld, klank, video\'s en ander lêers af te laai vanaf jou mobiele toestel
- Jou kursusse te bekyk
- en nog baie meer!

Sien asseblief http://docs.moodle.org/en/Mobile_app vir al die nuutste inligting.

Ons sal baie goeie resensies oor die funksionaliteit tot dusver waardeer, en jou voorstelle oor wat jy nog meer wil hê hierdie app moet kan doen!

Die program vereis die volgende toestemmings:
Opneem van klank - Vir opname van klank om op te laai na Moodle.
Lees en verander die inhoud van u SD-kaart. Inhoudsopgawe word na die SD-kaart afgelaai sodat u dit kan sien as daar nie internet verbinding is nie.
Netwerktoegang - Om met jou Moodle-webtuiste te koppel en om te kontroleer of jy gekoppel is of nie.
Begin die program sodra die toestel aangeskakel word - So kry jy plaaslike kennisgewings selfs wanneer die program in die agtergrond hardloop.
Verhoed dat die mobiele toestel aan die slaap raak. Sodoende kan jy kennisgewings enige tyd ontvang';
$string['core.browser'] = 'Blaaier';
$string['core.cannotconnect'] = 'Kan nie verbind nie';
$string['core.cannotdownloadfiles'] = 'Aflaai van lêers is afgeskakel. Kontak asseblief die stelsel adminsitrateur.';
$string['core.cannotopeninapp'] = 'Hierdie lêer gaan dalk nie op hierdie toestel reg werk nie. Wil jy dit nogtans oopmaak?';
$string['core.cannotopeninappdownload'] = 'Hierdie lêer gaan dalk nie op hierdie toestel reg werk nie. Wil jy dit nogtans aflaai?';
$string['core.captureaudio'] = 'Neem klank op';
$string['core.capturedimage'] = 'Geneemde foto.';
$string['core.captureimage'] = 'Neem foto';
$string['core.capturevideo'] = 'Neem video op';
$string['core.clearsearch'] = 'Maak soektog skoon';
$string['core.clearstoreddata'] = 'Maak stoorplek {{$a}} skoon';
$string['core.clicktoseefull'] = 'Klik om volle inhoud te sien.';
$string['core.comments.commentsnotworking'] = 'Kommentaar kan nie herwin word nie';
$string['core.comments.warningcommentsnotsent'] = 'Kon nie kommentaar sinchroniseer nie. {{error}}';
$string['core.confirmcanceledit'] = 'Is jy seker jy wil hierdie bladsy verlaat? Alle veranderinge sal verloor word.';
$string['core.confirmleaveunknownchanges'] = 'Is jy seker jy wil hierdie bladsy verlaat? As jy veranderings aangebring het wat nie gestoor is nie, sal hulle verlore wees.';
$string['core.confirmloss'] = 'Is jy seker? Alle veranderinge sal verlore gaan.';
$string['core.confirmopeninbrowser'] = 'Wil jy dit in \'n webleser oopmaak?';
$string['core.contenteditingsynced'] = 'Die inhoud waarmee jy besig is, is gestoor.';
$string['core.contentlinks.chooseaccount'] = 'Kies profiel';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Kies \'n profiel om die skakel mee oop te maak.';
$string['core.contentlinks.confirmurlothersite'] = 'Hierdie skakel behoort aan \'n ander webwerf. Wil jy dit oopmaak?';
$string['core.contentlinks.errornoactions'] = 'Kon nie \'n aksie vind om met hierdie skakel uit te voer nie.';
$string['core.contentlinks.errornosites'] = 'Kon nie enige webwerf vind om hierdie skakel te hanteer nie.';
$string['core.contentlinks.errorredirectothersite'] = 'Die aanstuur-URL kan nie na \'n ander webwerf wys nie.';
$string['core.copiedtoclipboard'] = 'Teks gekopieer na knipbord';
$string['core.copytoclipboard'] = 'Kopieer na knipbord';
$string['core.course.activitydisabled'] = 'Jou organisasie het hierdie aktiwiteit in die App gedeaktiveer.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Jou organisasie het \'n ingevoegde toepassing geïnstalleer wat nog nie ondersteun word nie.';
$string['core.course.allsections'] = 'Alle afdelings';
$string['core.course.aria:sectionprogress'] = 'Afdeling vordering:';
$string['core.course.availablespace'] = 'Jy het tans ongeveer {{available}} beskikbare spasie.';
$string['core.course.cannotdeletewhiledownloading'] = 'Lêers kan nie geskrap word onderwyl hierdie aktiwiteit afgelaai word nie. Wag asseblief totdat die aflaai afgehandel is.';
$string['core.course.confirmdownload'] = 'Jy staan op die punt om {{size}} af te laai. {{availableSpace}} Is jy seker jy wil voortgaan?';
$string['core.course.confirmdownloadunknownsize'] = 'Ons kon nie die grootte van die aflaai bereken nie. {{availableSpace}} Is jy seker jy wil voortgaan?';
$string['core.course.confirmdownloadzerosize'] = 'Jy staan op die punt om te begin aflaai. {{availableSpace}} Is jy seker jy wil voortgaan?';
$string['core.course.confirmlimiteddownload'] = 'Jy is nie tans met Wi-Fi verbind nie.';
$string['core.course.confirmpartialdownloadsize'] = 'Jy staan op die punt om <strong>ten minste</strong> {{size}} af te laai. {{availableSpace}} Is jy seker jy wil voortgaan?';
$string['core.course.couldnotloadsectioncontent'] = 'Kon nie die afdeling inhoud laai nie, probeer asseblief later weer.';
$string['core.course.couldnotloadsections'] = 'Kon nie die afdelings laai nie, probeer asseblief later weer.';
$string['core.course.downloadcoursesprogressdescription'] = 'Aflaai van kursusse: {{count}} van {{total}} is afgelaai.';
$string['core.course.downloadsectionprogressdescription'] = 'Aflaai afdeling: {{count}} van {{total}} is afgelaai.';
$string['core.course.errordownloadingcourse'] = 'Die kursus kon weens \'n fout nie afgelaai word nie.';
$string['core.course.errordownloadingsection'] = '\'n Fout het ontstaan met die aflaai van die afdeling.';
$string['core.course.errorgetmodule'] = '\'n Fout het ontstaan met die aflaai van die aktiwiteit data.';
$string['core.course.insufficientavailablequota'] = 'Jou toestel kon nie genoeg ruimte toewys om hierdie aflaai te stoor nie. Dalk reserveer dit ruimte vir app- en stelselbywerkings. Stel asseblief eers \'n bietjie stoorruimte vry.';
$string['core.course.insufficientavailablespace'] = 'Jy probeer tans om {{size}} af te laai. Dit sal jou toestel met onvoldoende ruimte laat om normaal te funksioneer. Stel asseblief eers \'n bietjie stoorruimte vry.';
$string['core.course.manualcompletionnotsynced'] = 'Handmatige voltooiing nie gesinchroniseer nie.';
$string['core.course.nocontentavailable'] = 'Geen inhoud beskikbaar op die oomblik nie.';
$string['core.course.refreshcourse'] = 'Herlaai kursus';
$string['core.course.useactivityonbrowser'] = 'Jy kan dit nog steeds gebruik deur jou toestel se webblaaier te gebruik.';
$string['core.course.warningmanualcompletionmodified'] = 'Die handmatige voltooiing van \'n aktiwiteit is gewysig op die webwerf.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Sommige aflyn- handmatige voltooiing van kursus \'{{name}}\' is geskrap. {{error}}';
$string['core.coursenogroups'] = 'Jy is nie \'n lid van enige groep van hierdie kursus nie.';
$string['core.courses.cannotretrievemorecategories'] = 'Kategorieë dieper as vlak ({$a}) kan nie afgelaai word nie.';
$string['core.courses.downloadcourses'] = 'Laai kursusse af';
$string['core.courses.enrolme'] = 'Skryf my in';
$string['core.courses.errorloadcategories'] = '\'n Fout het onstaan tydens die laai van kategorieë.';
$string['core.courses.errorloadcourses'] = '\'n Fout het ontstaan tydens die laai van kursusse.';
$string['core.courses.errorloadplugins'] = 'Kon nie die inproppe wat deur hierdie kursus verlang word korrek laai nie. Herlaai die app en probeer asseblief weer.';
$string['core.courses.errorsearching'] = '\'n Fout het ontstaan tydens die soektog.';
$string['core.courses.filtermycourses'] = 'Filter my kursusse';
$string['core.courses.notenrollable'] = 'Jy kan nie jouself inskryf vir hierdie kursus nie.';
$string['core.courses.password'] = 'Inskrywing sleutel';
$string['core.courses.searchcoursesadvice'] = 'Jy kan die \'Soek deur kursusse\' knoppie gebruik om toegang te verkry as \'n gas of jouself in te skryf in kursusse wat dit toelaat.';
$string['core.courses.totalcoursesearchresults'] = 'Totale kursusse: {{$a}}';
$string['core.currentdevice'] = 'Huidige toestel';
$string['core.datastoredoffline'] = 'Data gestoor in die toestel omdat dit nie gestuur kon word nie. Dit sal later outomaties gestuur word.';
$string['core.deletedoffline'] = 'Uitgevee sonder internet toegang';
$string['core.deleting'] = 'Besig om te verwyder';
$string['core.desktop'] = 'Werkskerm';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Skrap';
$string['core.dismiss'] = 'Ignoreer';
$string['core.downloaded'] = 'Afgelaai';
$string['core.downloading'] = 'Besig om af te laai';
$string['core.editor.hidetoolbar'] = 'Verberg nutsbalk';
$string['core.editor.toggle'] = 'Skakel Editor aan/af';
$string['core.emptysplit'] = 'Hierdie bladsy word leeg vertoon as die linker paneel leeg is of besig is om te laai.';
$string['core.errorchangecompletion'] = '\'n Fout het ontstaan tydens die verandering van die voltooiing status. Probeer asseblief weer.';
$string['core.errordeletefile'] = '\'n Fout het ontstaan tydens die uitvee van die lêer. Probeer asseblief weer.';
$string['core.errordownloading'] = '\'n Fout het ontstaan tydens die aflaai van die lêer.';
$string['core.errordownloadingsomefiles'] = '\'n Fout het ontstaan tydens die aflaai van die lêers. Sommige lêers kan moontlik ontbreek.';
$string['core.errorfileexistssamename'] = 'Daar is reeds \'n lêer met hierdie naam.';
$string['core.errorinvalidform'] = 'Die vorm bevat ongeldige data. Maak asseblief seker dat jy al die vereiste velde ingevul het en dat die data geldig is.';
$string['core.errorinvalidresponse'] = 'Ongeldige antwoord ontvang. Kontak asseblief die stelsel administrateur as die fout aanhou.';
$string['core.errorloadingcontent'] = 'Kon nie inhoud laai nie.';
$string['core.errorofflinedisabled'] = 'Jy moet aan die internet gekoppel wees om die App te kan gebruik, aangesien hierdie opsie afgeskakel is op jou webwerf.';
$string['core.erroropenfiledownloading'] = 'Lêeropening het misluk: jy moet wag tot dat die aflaai voltooi is.';
$string['core.erroropenfilenoapp'] = '\'n Fout het ontstaan tydens die oopmaak van die lêer: geen App gevind om hierdie soort lêer oop te maak.';
$string['core.erroropenfilenoextension'] = '\'n Fout het ontstaan tydens die oop maak van die lêer: die lêer het nie \'n uitbreiding nie.';
$string['core.erroropenpopup'] = 'Hierdie aktiwiteit is besig om \'n pop-up oop te maak. Dit word nie ondersteun in hierdie App nie.';
$string['core.errorrenamefile'] = '\'n Fout het ontstaan tydens die herbenoeming van die lêer. Probeer asseblief weer.';
$string['core.errorsomedatanotdownloaded'] = 'As jy hierdie aktiwiteit afgelaai het, let asseblief daarop dat sommige data nie afgelaai word tydens die aflaaiproses nie weens redes wat betrekking het op werksverrigting en datagebruik.';
$string['core.errorsync'] = '\'n Fout het ontstaan tydens sinkronisasie. Probeer asseblief weer.';
$string['core.errorsyncblocked'] = 'Hierdie {{$a}} kan nie nou gesinkroniseer word nie as gevolg van \'n voortdurende process. Probeer asseblief later weer. As die probleem voortduur, probeer asb om die App toe te maak en dan weer oop te maak.';
$string['core.errorurlschemeinvalidscheme'] = 'Hierdie URL is bestem vir gebruik in \'n ander app: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'Die webwerf-URL kan nie in hierdie app oopgemaak word nie.';
$string['core.filenameexist'] = 'Lêernaam bestaan reeds: {{$a}}';
$string['core.fileuploader.audio'] = 'Klank';
$string['core.fileuploader.camera'] = 'Kamera';
$string['core.fileuploader.confirmuploadfile'] = 'Jy staan op die punt om {{size}} op te laai. Is jy seker jy wil voortgaan?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Ons was nie in staat om die grootte van die oplaai te bereken nie. Is jy seker jy wil voortgaan?';
$string['core.fileuploader.errorcapturingaudio'] = '\'n Fout het ontstaan met die vaslegging van klank.';
$string['core.fileuploader.errorcapturingimage'] = '\'n Fout het ontstaan met die neem van \'n foto.';
$string['core.fileuploader.errorcapturingvideo'] = '\'n Fout het ontstaan met die neem van \'n video.';
$string['core.fileuploader.errorgettingimagealbum'] = '\'n Fout het ontstaan met die kry van \'n beeld vanaf \'n album.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Jy moet aanlyn wees om lêers op te laai.';
$string['core.fileuploader.errornoapp'] = 'Jy het nie \'n App geïnstalleer wat hierdie aksie kan uitvoer nie.';
$string['core.fileuploader.errorreadingfile'] = 'Kon nie lêer lees nie.';
$string['core.fileuploader.errorwhileuploading'] = '\'n Fout het ontstaan tydens die oplaai van die lêer.';
$string['core.fileuploader.file'] = 'Lêer';
$string['core.fileuploader.fileuploaded'] = 'Die lêer is suksesvol gelaai.';
$string['core.fileuploader.maxbytesfile'] = 'Die lêer {{$a.file}} is te groot. Die maksimum grootte wat jy kan oplaai is {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Foto albums';
$string['core.fileuploader.readingfile'] = 'Tans besig om \'n lêer te lees';
$string['core.fileuploader.readingfileperc'] = 'Lees lêer: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'Kies \'n lêer';
$string['core.fileuploader.uploadafile'] = 'Laai \'n lêer op';
$string['core.fileuploader.uploading'] = 'Besig om op te laai';
$string['core.fileuploader.uploadingperc'] = 'Besig om op te laai: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.h5p.errorgetemail'] = 'Kon nie gebruiker se e-pos bekom nie. Gaan jou verbinding na en probeer asseblief weer.';
$string['core.h5p.offlinedisabled'] = 'Die webwerf laat nie toe dat H5P-pakkette afgelaai word nie.';
$string['core.h5p.play'] = 'Speel H5P';
$string['core.hasdatatosync'] = 'Hierdie {{$a}} het data wat sonder internet gestoor is wat gesinkroniseer moet word.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Werk hierdie inhoud nie?';
$string['core.image'] = 'Foto';
$string['core.imageviewer'] = 'Foto kyker';
$string['core.ioscookieshelp'] = 'Ingebedde inhoud kan vereis dat koekies aktiveer moet word. Gaan na die toepassing se iOS instellings, en aktiveer \'Allow Cross-Website Tracking\' en probeer weer.';
$string['core.lastdownloaded'] = 'Laas afgelaai';
$string['core.lastsync'] = 'Laaste sinkronisasie';
$string['core.loadmore'] = 'Laai meer';
$string['core.login.authenticating'] = 'Besig om toestemming te kry';
$string['core.login.changepasswordbutton'] = 'Maak die blad "Verander wagwoord" oop';
$string['core.login.changepasswordhelp'] = 'As jy sukkel om jou wagwoord te verander, kontak jou webwerfadministrateur asseblief. "Webwerfadministrateurs" is die mense wat die Moodle by jou skool/universiteit/maatskappy of leerinstelling bestuur. As jy nie weet hoe om hulle te kontak nie, kontak jou onderwysers/opleiers asseblief.';
$string['core.login.changepasswordreconnectinstructions'] = 'Klik die volgende knoppie om weer met die webwerf te verbind. (Let daarop dat as jou wagwoord nie suksesvol verander is nie, jy teruggestuur sal word na die vorige skerm.)';
$string['core.login.confirmdeletesite'] = 'Is jy seker jy wil die webwerf {{sitename}} verwyder?';
$string['core.login.connect'] = 'Konnekteer!';
$string['core.login.connecttomoodle'] = 'Konnekteer aan Moodle';
$string['core.login.connecttomoodleapp'] = 'Jy probeer tans om met \'n reguliere Moodle-webwerf te verbind. Laai asseblief die amptelike Moodle-app af om toegang tot hierdie webwerf te verkry.';
$string['core.login.connecttoworkplaceapp'] = 'Jy probeer tans om met \'n Moodle Workplace-webwerf te verbind. Laai asseblief die Moodle Workplace-app af om toegang tot hierdie webwerf te verkry.';
$string['core.login.credentialsdescription'] = 'Verskaf asseblief jou gebruikersnaam en wagwoord om in te teken.';
$string['core.login.emailconfirmsentnoemail'] = '<p>Teen hierdie tyd is \'n e-pos na jou adres gestuur.</p><p>Dit bevat eenvoudige instruksies oor hoe om jou registrasie te voltooi.</p><p>As jy steeds probleme ondervind, kontak die webwerfadministrateur asseblief.</p>';
$string['core.login.emailnotmatch'] = 'E-pos stem nie ooreen nie';
$string['core.login.erroraccesscontrolalloworigin'] = 'Die kruis-oorsprong oproep wat jy probeer uitvoer is afgekeur. Gaan kyk asseblief na https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = '\'n Fout het ontstaan tydens die verwydering van hierdie webwerf. Probeer asseblief weer.';
$string['core.login.errorexampleurl'] = 'Die URL https://campus.example.edu is slegs \'n voorbeeld van \'n URL. Dit is nie \'n werklike webwerf nie. <strong>Gebruik asseblief die URL van jou skool of organisasie se webwerf.</strong>';
$string['core.login.errorqrnoscheme'] = 'Hierdie URL is nie \'n geldige aanmeld-URL nie.';
$string['core.login.errorupdatesite'] = '\'n Fout het ontstaan met die verandering van die webwerf se kenteken.';
$string['core.login.faqcannotfindmysiteanswer'] = 'Het jy die naam reg ingetik? Dit is ook moontlik dat jou webwerf nie by ons gids vir openbare webwerwe ingesluit is nie. As jy dit steeds nie kan vind nie, tik asseblief eerder jou webwerfadres in.';
$string['core.login.faqcannotfindmysitequestion'] = 'Ek kan nie my webwerf vind nie.';
$string['core.login.faqsetupsiteanswer'] = 'Besoek {{$link}} om te gaan kyk na die verskillende opsies tot jou beskikking om jou eie Moodle-webwerf te skep.';
$string['core.login.faqsetupsitelinktitle'] = 'Kom aan die gang.';
$string['core.login.faqsetupsitequestion'] = 'Ek wil my eie Moodle-webwerf opstel.';
$string['core.login.faqtestappanswer'] = 'Om die app in \'n Moodle-demonstrasiewebwerf te toets, tik "teacher" of "student" in die "Your site"-veld in en klik die "Connect to your site"-knoppie.';
$string['core.login.faqtestappquestion'] = 'Ek wil bloot die app op die proef stel. Wat staan my te doen?';
$string['core.login.faqwhatisurlanswer'] = '<p>Elke organisasie het sy eie unieke adres of URL vir sy Moodle-webwerf. Om die adres te vind:</p><ol><li>Maak ŉ webblaaier oop en gaan na jou Moodle-webwerf se aanmeldblad.</li><li>Bo-aan die blad, in die adresbalk, sal jy die URL van jou Moodle-webwerf sien, bv. "campus.example.edu".<br>{{$image}}</li><li>Kopieer die adres (moenie die /login en wat daarna kom, kopieer nie), plak dit in die Moodle-app en klik dan "Verbind met jou webwerf "</li><li>. Nou kan jy via jou gebruikernaam en wagwoord by jou webwerf aanmeld.</li></ol>';
$string['core.login.faqwhatisurlquestion'] = 'Wat is my webwerf se adres? Waar vind ek my webwerf se URL?';
$string['core.login.faqwhereisqrcode'] = 'Hoe bekom ek die QR-kode?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>As jou organisasie dit ontsper het, sal jy \'n QR-kode onderaan jou gebruikerprofielblad op die webwerf vind.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Vind jou webwerf';
$string['core.login.invalidaccount'] = 'Gaan asseblief jou inteken besonderhede na of vra jou stelsel administrateur om die webwerf konfigurasie te bevestig.';
$string['core.login.invalidmoodleversion'] = '<p>Ongeldige Moodle-webwerfweergawe: Die Moodle-app werk slegs met Moodle-stelsels {{$a}} en later.</p>
<p>Jy kan jou webwerfadministrateur kontak en vra dat hulle hul Moodle-stelsel bywerk.</p>
<p>"Webwerfadministrateurs" is die mense wat die Moodle by jou skool/universiteit/maatskaapy of onderriginstansie bestuur. As jy nie weet hoe om hulle te kontak nie, kontak asseblief jou onderwysers/opleiers.</p>';
$string['core.login.invalidsite'] = 'Die webblad URL is ongeldig.';
$string['core.login.invalidtime'] = 'Ongeldige tyd';
$string['core.login.invalidvaluemax'] = 'Die maksimum waarde is {{$a}}';
$string['core.login.invalidvaluemin'] = 'Die minimum waarde is {{$a}}';
$string['core.login.loginbutton'] = 'Teken in';
$string['core.login.mobileservicesnotenabled'] = 'Mobiele Dienste is nie aangeskakel in jou webblad nie. Kontak asseblief jou Moodle administrateur.';
$string['core.login.notloggedin'] = 'Jy moet ingeteken wees.';
$string['core.login.onboardingcreatemanagecourses'] = 'Skep en bestuur jou kursusse';
$string['core.login.onboardingenrolmanagestudents'] = 'Bestuur en skryf jou studente in';
$string['core.login.onboardinggetstarted'] = 'Kom aan die gang met Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Ek het reeds \'n Moodle-webwerf';
$string['core.login.onboardingimalearner'] = 'Ek is \'n leerder';
$string['core.login.onboardingimaneducator'] = 'Ek is \'n opvoeder';
$string['core.login.onboardingineedasite'] = 'Ek benodig \'n Moodle-webwerf';
$string['core.login.onboardingprovidefeedback'] = 'Verskaf tydige terugvoer';
$string['core.login.onboardingtoconnect'] = 'Om met die Moodle-app te verbind, moet jy \'n Moodle-webwerf hê.';
$string['core.login.onboardingwelcome'] = 'Welkom by die Moodle-app!';
$string['core.login.or'] = 'OF';
$string['core.login.passwordrequired'] = 'Wagwoord word vereis';
$string['core.login.recaptchachallengeimage'] = 'reCAPTCHA uitdaging beeld';
$string['core.login.recaptchaexpired'] = 'Verifikasie het verval. Beantwoord die sekuriteitsvraag weer.';
$string['core.login.recaptchaincorrect'] = 'Die sekuriteitsvraag is verkeerd.';
$string['core.login.reconnect'] = 'Herkonnekteer';
$string['core.login.searchby'] = 'Soek deur:';
$string['core.login.selectsite'] = 'Kies asseblief jou webblad:';
$string['core.login.signupplugindisabled'] = '{{$a}} is nie aangeskakel nie.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Die intekeningsblad bevat \'n vereiste verpersoonlikte veld wat nie in die app werk nie. Skep asseblief jou rekening via \'n webblaaier.';
$string['core.login.siteaddress'] = 'Jou webwerf';
$string['core.login.sitebadgedescription'] = 'Daar is {{count}} ongelese kennisgewings.';
$string['core.login.sitehasredirect'] = 'Jou webwerf bevat ten minste een HTTP-aanstuurboodskap. Die app kan nie aanstuurboodskappe volg nie, en dit kan dalk die rede wees waarom die app nie met jou webwerf kan verbind nie.';
$string['core.login.siteinmaintenance'] = 'Die webblad ondergaan tans onderhoud.';
$string['core.login.sitepolicynotagreederror'] = 'bladWebwerf beleid word nie aanvaar nie.';
$string['core.login.siteurl'] = 'Webblad URL';
$string['core.login.siteurlrequired'] = 'Webblad URL word vereis, bv. <i>http://www.yourmoodlesite.org</i>';
$string['core.login.stillcantconnect'] = 'Kan jy steeds nie konnekteer nie?';
$string['core.login.usernamerequired'] = 'Gebruikersnaam word vereis';
$string['core.login.visitchangepassword'] = 'Wil jy die webblad besoek om die wagwoord te verander?';
$string['core.login.webservicesnotenabled'] = 'Jou gasheerwebwerf het dalk nie Webdienste geaktiveer nie. Vra jou administrateur asseblief om hulp.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Jy kan steeds met die webwerf verbind deur jou gebruikernaam en wagwoord in te tik.';
$string['core.login.yourenteredsite'] = 'Verbind met jou webwerf';
$string['core.lostconnection'] = 'Jou stawingkoepon is ongeldig of het verval. Jy moet weer aan die webblad koppel.';
$string['core.needhelp'] = 'Hulp benodig?';
$string['core.networkerroriframemsg'] = 'Hierdie inhoud is nie aflyn beskikbaar nie. Verbind asseblief met die Internet en probeer weer.';
$string['core.networkerrormsg'] = 'Netwerk is nie geaktiveer nie of werk nie.';
$string['core.nooptionavailable'] = 'Geen opsies beskikbaar nie';
$string['core.nopasswordchangeforced'] = 'Jy kan nie voortgaan sonder om jou wagwoord te verander nie.';
$string['core.nopermissionerror'] = 'Jammer, jy het tans geen vergunnings om daardie te doen nie';
$string['core.notapplicable'] = 'n.v.t.';
$string['core.notsent'] = 'Nie gestuur nie';
$string['core.nummore'] = 'nog {{$a}}';
$string['core.openfile'] = 'Maak lêer oop';
$string['core.openfullimage'] = 'Klik hier om die beeld op volle grootte te vertoon';
$string['core.openinbrowser'] = 'Maak oop in webleser';
$string['core.openmodinbrowser'] = 'Maak {{$a}} in blaaier oop';
$string['core.opensecurityquestion'] = 'Oop veiligheidsvraag';
$string['core.opensettings'] = 'Maak instellings oop';
$string['core.openwith'] = 'Maak oop met...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Speel';
$string['core.pulltorefresh'] = 'Trek om te verfris';
$string['core.qrscanner'] = '';
$string['core.question.cannotdeterminestatus'] = 'Kan nie status bepaal nie';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Jou webwerf laat nog nie toe dat lêers by vrae aangeheg word nie.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Jou webwerf laat nog nie toe dat ingebedde lêers geredigeer word nie.';
$string['core.question.errorquestionnotsupported'] = 'Hierdie tipe vraag word nie deur die App ondersteun nie: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Tik om te kies en tik dan om te val.';
$string['core.question.questionmessage'] = 'Vraag {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Jy sal herlei word na die webblad.';
$string['core.removefiles'] = 'Verwyder lêers {{$a}}';
$string['core.requireduserdatamissing'] = 'Hierdie gebruiker het nie al die nodige profiel inligting nie. Vul asseblief hierdie data in en probeer weer.<br>{{$a}}';
$string['core.retry'] = 'Probeer weer';
$string['core.scanqr'] = 'Skandeer QR-kode';
$string['core.scrollbackward'] = 'Roll agteruit';
$string['core.scrollforward'] = 'Roll vorentoe';
$string['core.searching'] = 'Besig om te soek';
$string['core.settings.about'] = 'Meer inligting oor';
$string['core.settings.appsettings'] = 'App-instellings';
$string['core.settings.appversion'] = 'App-weergawe';
$string['core.settings.cannotsyncloggedout'] = 'Hierdie webwerf kan nie gesinchroniseer word nie omdat jy afgemeld het. Probeer asseblief weer wanneer jy volgende keer by die webwerf aanmeld.';
$string['core.settings.cannotsyncoffline'] = 'Kan nie aflyn sinkroniseer nie.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Konnekteer asseblief aan \'n Wi-Fi netwerk om te kan sinkroniseer.';
$string['core.settings.colorscheme'] = 'Kleurskema';
$string['core.settings.colorscheme-dark'] = 'Donker';
$string['core.settings.colorscheme-light'] = 'Lig';
$string['core.settings.colorscheme-system'] = 'Stelselverstek';
$string['core.settings.colorscheme-system-notice'] = 'Stelselverstekmodus sal afhang van jou toestelondersteuning.';
$string['core.settings.compilationinfo'] = 'Samestelling inligting';
$string['core.settings.copyinfo'] = 'Kopieer toestel se info na die knipbord';
$string['core.settings.cordovadevicemodel'] = 'Cordova toestel model';
$string['core.settings.cordovadeviceosversion'] = 'Cordova toestel OS weergawe';
$string['core.settings.cordovadeviceplatform'] = 'Cordova toestel platform';
$string['core.settings.cordovadeviceuuid'] = 'Cordova toestel UUID';
$string['core.settings.cordovaversion'] = 'Cordova weergawe';
$string['core.settings.debugdisplaydescription'] = 'Indien geaktiveer, sal foutmodusse meer inligting oor die fout wys indien moontlik.';
$string['core.settings.deviceinfo'] = 'Toestel inligting';
$string['core.settings.deviceos'] = 'Toestel OS';
$string['core.settings.displayformat'] = 'Vertoon formaat';
$string['core.settings.enabledownloadsection'] = 'Aktiveer aflaai afdelings';
$string['core.settings.enablerichtexteditor'] = 'Aktiveer ryk teksredakteur';
$string['core.settings.enablerichtexteditordescription'] = 'Indien geaktiveer, sal \'n ryk teksredakteur op plekke vertoon word wat dit toelaat.';
$string['core.settings.entriesincache'] = '{{$a}} inskrywings in cache';
$string['core.settings.estimatedfreespace'] = 'Geskatte beskikbare spasie';
$string['core.settings.filesystemroot'] = 'Lêerstelsel root';
$string['core.settings.fontsize'] = 'Teksgrootte';
$string['core.settings.forcedsetting'] = 'Hierdie instelling word afgedwing deur jou webwerf se konfigurasie.';
$string['core.settings.helpusimprove'] = 'Help ons om hierdie toep te verbeter';
$string['core.settings.ioscookies'] = 'Kruis-Webblad nasporing';
$string['core.settings.ioscookiesdescription'] = 'Ingeboude inhoud van die webwerf kan koekies oor webwerwe benodig om te werk. Om dit te aktiveer, gaan asseblief na die iOS-instellings van die app en aktiveer \'Laat webwerf-nasporing toe\'.';
$string['core.settings.localnotifavailable'] = 'Plaaslike kennisgewings beskikbaar';
$string['core.settings.locationhref'] = 'Webaansig URL';
$string['core.settings.navigatorlanguage'] = 'Navigeerder taal';
$string['core.settings.navigatoruseragent'] = 'Navigator gebruikerAgent';
$string['core.settings.networkstatus'] = 'Internet verbinding status';
$string['core.settings.opensourcelicenses'] = 'Open Source-lisensies';
$string['core.settings.privacypolicy'] = 'Privaatheidsbeleid';
$string['core.settings.publisher'] = 'Uitgewer';
$string['core.settings.pushid'] = 'ID van afdrukkennisgewings';
$string['core.settings.reportinbackground'] = 'Rapporteer foute outomaties';
$string['core.settings.screen'] = 'Sif inligting';
$string['core.settings.showdownloadoptions'] = 'Wys aflaai-opsies';
$string['core.settings.siteinfo'] = 'Webwerf-info';
$string['core.settings.spaceusage'] = 'Spasie gebruik';
$string['core.settings.synchronization'] = 'Sinkronisasie';
$string['core.settings.synchronizenow'] = 'Sinkroniseer nou';
$string['core.settings.synchronizenowhelp'] = 'Sinchronisering van \'n webwerf kom daarop neer dat alle afwagtende veranderings en alle ongekoppelde aktiwiteite wat op die toestel gestoor is, versend word en dat sommige data soos boodskappe en kennisgewings gesinchroniseer word.';
$string['core.settings.syncsettings'] = 'Sinkronisasie instellings';
$string['core.settings.wificonnection'] = 'WiFi verbinding';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Kies \'n profiel om die lêer in te stoor.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Daar is reeds \'n lêer met hierdie naam. Wil jy die bestaande lêer vervang of dit hernoem na "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Daar is geen webblaaie wat gestoor is nie. Voeg asseblief \'n webblad by voordat jy \'n lêer deel met die App.';
$string['core.sharedfiles.nosharedfiles'] = 'Daar is geen gedeelde lêers gestoor in hierdie webtuiste nie.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Jy het geen lêers om hier op te laai nie. As jy \'n lêer wil oplaai van \'n ander App af, spoor die lêer op en klik op die \'Maak oop in\' knoppie.';
$string['core.sharedfiles.rename'] = 'Herbenoem';
$string['core.sharedfiles.replace'] = 'Vervang';
$string['core.sharedfiles.sharedfiles'] = 'Gedeelde lêers';
$string['core.sharedfiles.successstorefile'] = 'Lêer suksesvol gestoor. Nou kan jy hierdie lêer kies om dit te laai na jou persoonlike lêers of heg dit aan in sommige aktiwiteite.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Jammer...';
$string['core.storingfiles'] = 'Stoor lêers';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Hierdie merkerarea word nie deur die app ondersteun nie.';
$string['core.tag.tagareabadgedescription'] = 'Daar is {{count}} items.';
$string['core.tag.warningareasnotsupported'] = 'Sommige merkerareas word nie gewys nie omdat hulle nie deur die app ondersteun word nie.';
$string['core.thereisdatatosync'] = 'Daar is aflyn {{$a}} wat gesinkroniseer moet word.';
$string['core.toggledelete'] = 'Wissel uitveeknoppie';
$string['core.tryagain'] = 'Probeer weer';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Oeps!';
$string['core.unexpectederror'] = 'Onverwagse fout. Maak asseblief die App toe en weer oop om weer te probeer.';
$string['core.unicodenotsupported'] = 'Sommige emojis word nie op hierdie webblad ondersteun nie. Sodanige karakters sal verwyder word wanneer die boodskap gestuur word.';
$string['core.unicodenotsupportedcleanerror'] = 'Leë teks is gevind tydens die skoonmaak van Unicode-karakters.';
$string['core.unknown'] = 'Onbekend';
$string['core.unzipping'] = 'Ontvou';
$string['core.updaterequired'] = 'App-bywerking verlang';
$string['core.updaterequireddesc'] = 'Jou app moet asseblief bygewerk word tot weergawe {{$a}}';
$string['core.user.contact'] = 'Kontak';
$string['core.user.detailsnotavailable'] = 'Die besonderhede van hierdie gebruiker is nie beskikbaar nie.';
$string['core.user.errorloaduser'] = 'Kon nie gebruiker laai nie.';
$string['core.user.sendemail'] = 'E-pos';
$string['core.user.userwithid'] = 'Gebruiker met ID {{id}}';
$string['core.viewcode'] = 'Bekyk kode';
$string['core.vieweditor'] = 'Bekyk redakteur';
$string['core.viewembeddedcontent'] = 'Bekyk ingebedde inhoud';
$string['core.warningofflinedatadeleted'] = 'Aflyn data van {{component}} \'{{name}}\' is geskrap. {{error}}';
$string['core.whyisthishappening'] = 'Waarom gebeur dit?';
$string['core.wsfunctionnotavailable'] = 'Die webdiens funksie is nie beskikbaar nie.';
$string['core.youreoffline'] = 'Jy is aflyn';
$string['core.youreonline'] = 'Jy is weer aanlyn';
$string['pluginname'] = 'Moodle Mobile taal stringe';
