<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'sr_lt', version '5.0'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutuscontentsetting'] = 'Sadržaj stranice \'O nama\'';
$string['aboutuscontentsetting_desc'] = 'U ovom podešavanju možete dodati sadržaj u formatu obogaćenog teksta koji će biti prikazan na stranici \'O nama\'';
$string['aboutusdisabled'] = 'Stranica\'O nama\' je onemogućena na ovom sajtu. Ovde nema šta da se vidi.';
$string['aboutusheading'] = 'O nama';
$string['aboutuslinkpositionboth'] = 'Dodajte link ka stranici \'O nama\' u fusnotu i na ikonicu u podnožju stranice (znak pitanja)';
$string['aboutuslinkpositionfooter'] = 'Dodajte link ka stranici \'O nama\' na ikonicu u podnožju stranice (znak pitanja)';
$string['aboutuslinkpositionfootnote'] = 'Dodajte link ka stranici \'O nama\' u fusnotu';
$string['aboutuslinkpositionnone'] = 'Nemojte automatski prikazivati link ka stranici \'O nama\'';
$string['aboutuslinkpositionsetting'] = 'Pozicija linka \'O nama\'';
$string['aboutuslinkpositionsetting_desc'] = 'U ovom podešavanju možete da konfigurišete da li će se link ka stranici \'O nama\' automatski dodati na Moodle stranicu. Ako ne želite da automatski prikazujete link, možete ručno dodati link ka {$a->url} sa bilo kog mesta u Moodleu.';
$string['aboutuspagetitledefault'] = 'O nama';
$string['aboutuspagetitlesetting'] = 'Naslov stranice \'O nama\'';
$string['aboutuspagetitlesetting_desc'] = 'U ovom podešavanju možete definisati naslov stranice \'O nama\'. Ovaj tekst će se koristiti i kao tekst linka ka stranici \'O nama\' ako u skladu s tim konfigurišete podešavanje Pozicija linka\'O nama\'.';
$string['accessibilitydeclarationcontentsetting'] = 'Sadržaj stranice sa deklaracijom o pristupačnosti';
$string['accessibilitydeclarationcontentsetting_desc'] = 'U ovom podešavanju možete da dodate obogaćeni tekstualni sadržaj koji će biti prikazan na stranici sa deklaracijom o pristupačnosti.';
$string['accessibilitydeclarationdisabled'] = 'Stranica deklaracije sa informacijama o dostupnosti je onemogućena za ovaj sajt. Ovde nema šta da se vidi.';
$string['accessibilitydeclarationheading'] = 'Deklaracija o pristupačnosti';
$string['accessibilitydeclarationlinkpositionboth'] = 'Dodajte link ka stranici sa deklaracijom o pristupačnosti u fusnotu i na ikonicu u podnožju stranice (znak pitanja)';
$string['accessibilitydeclarationlinkpositionfooter'] = 'Dodajte link ka stranici sa deklaracijom o pristupačnosti na ikonicu u podnožju stranice (znak pitanja)';
$string['accessibilitydeclarationlinkpositionfootnote'] = 'Dodajte link ka stranici sa deklaracijom o pristupačnosti u fusnotu';
$string['accessibilitydeclarationlinkpositionnone'] = 'Nemojte automatski prikazivati link ka stranici sa deklaracijom o pristupačnosti';
$string['accessibilitydeclarationlinkpositionsetting'] = 'Pozicija linka ka stranici sa deklaracijom o pristupačnosti';
$string['accessibilitydeclarationlinkpositionsetting_desc'] = 'U ovom podešavanju možete konfigurisati da li link ka stranici sa dekleracijom o pristupačnosti treba da bude automatski dodat na Moodle stranicu. Ukoliko ne želite da link automatski bude prikazan, možete ručno dodati link ka {$a->url} bilo gde unutar Moodlea.';
$string['accessibilitydeclarationpagetitledefault'] = 'Deklaracija o pristupačnosti';
$string['accessibilitydeclarationpagetitlesetting'] = 'Naslov stranice deklaracije o pristupačnosti';
$string['accessibilitydeclarationpagetitlesetting_desc'] = 'U ovom podešavanju možete definisati naslov stranice sa deklaracijom o pristupačnosti. Ovaj tekst će se takođe koristiti kao tekst linka ka stranici sa deklaracijom o pristupačnosti ako u skladu s tim konfigurišete podešavanje \'Pozicija linka ka stranici sa deklaracijom o pristupačnosti\'.';
$string['accessibilitydeclarationtab'] = 'Deklaracija';
$string['accessibilitysupportanonymouscheckbox'] = 'Radije bih da svoj zahtev za podršku pristupačnosti pošaljem anonimno';
$string['accessibilitysupportanonymousemail'] = 'anonymous@email.invalid';
$string['accessibilitysupportanonymoususer'] = 'Anonimni korisnik';
$string['accessibilitysupportcontentdefault'] = '<p>Ukoliko imate povratne informacije o pristupačnosti ili želite da prijavite prepreku u pristupu, iskoristite obrazac u nastavku.</p> p>Da li koristite neku asistivnu alatku kao što su čitači ekrana, lupe, kontrola glasa ili softver za prepoznavanje govora? Ako je odgovor potvrdan, navedite koju od asistivnih alatki tačno koristite. Da biste nam pomogli da obradimo vaš zahtev, možete dozvoliti da obrazac automatski zajedno sa vašom porukom pošalje sledeće informacije: URL adresa na kojoj ste bili kada ste otvorili ovaj obrazac za podršku (ovo se zove \'referentna stranica\' - \'referrer\'), kao i informacije o vašem veb čitaču.</p>';
$string['accessibilitysupportcontentsetting'] = 'Sadržaj stranice za podršku pristupačnosti';
$string['accessibilitysupportcontentsetting_desc'] = 'U ovom podešavanju možete da dodate obogaćeni tekstualni sadržaj koji će biti prikazan na stranici za podršku pristupačnosti, zajedno sa obrascem za slanje povratnih informacija o pristupačnosti ili za prijavu ograničenja u pristupačnosti.';
$string['accessibilitysupportdefaultsubject'] = 'Povratne informacije o pristupačnosti';
$string['accessibilitysupportdisabled'] = 'Stranica za podršku pristupačnosti je onemogućena za ovaj sajt. Ovde nema šta da se vidi.';
$string['accessibilitysupportheading'] = 'Stranica za podršku pristupačnosti';
$string['accessibilitysupportlinkpositionboth'] = 'Dodajte link ka stranici sa za podršku pristupačnosti u fusnotu i na ikonicu u podnožju stranice (znak pitanja)';
$string['accessibilitysupportlinkpositionfooter'] = 'Dodajte link ka stranici sa za podršku pristupačnosti na ikonicu u podnožju stranice (znak pitanja)';
$string['accessibilitysupportlinkpositionfootnote'] = 'Dodajte link ka stranici sa za podršku pristupačnosti u fusnotu';
$string['accessibilitysupportlinkpositionnone'] = 'Nemojte automatski prikazivati link ka stranici za podršku pristupačnosti';
$string['accessibilitysupportlinkpositionsetting'] = 'Pozicija link ka stranici za podršku pristupačnosti';
$string['accessibilitysupportlinkpositionsetting_desc'] = 'U ovom podešavanju možete konfigurisati da li link ka stranici za podršku pristupačnosti treba da bude automatski dodat na Moodle stranicu. Ukoliko ne želite da link automatski bude prikazan, možete ručno dodati link ka {$a->url} bilo gde unutar Moodlea.';
$string['accessibilitysupportmessagenotsent'] = 'Nažalost, vaš zahtev za podršku pristupačnosti nije mogao biti poslat.';
$string['accessibilitysupportmessagesent'] = 'Vaš zahtev za podršku pristupačnosti je poslat.';
$string['accessibilitysupportmessagetryagain'] = 'Pokušajte ponovo kasnije.';
$string['accessibilitysupportmessagetryalternative'] = 'Pokušajte ponovo kasnije ili pošaljite e-poruku direktno na <a href="mailto:{$a}">{$a}</a>.';
$string['accessibilitysupportpagesrlinktitledefault'] = 'Pošaljite zahtev za podršku pristupačnosti';
$string['accessibilitysupportpagesrlinktitlesetting'] = 'Naslov linka za čitač ekrana stranice za podršku pristupačnosti';
$string['accessibilitysupportpagesrlinktitlesetting_desc'] = 'U ovom podešavanju možete definisati link ka čitaču ekrana stranice za podršku pristupačnosti. Ovaj tekst će se takođe koristiti kao tekst linka koji se prikazuje samo čitačima ekrana.';
$string['accessibilitysupportpagetitledefault'] = 'Podrška za pristupačnost';
$string['accessibilitysupportpagetitlesetting'] = 'Naslov stranice za podršku pristupačnosti';
$string['accessibilitysupportpagetitlesetting_desc'] = 'U ovom podešavanju možete definisati naslov stranice za podršku pristupačnosti. Ovaj tekst će se takođe koristiti kao tekst linka ka stranici sa informacijama o podršci za pristupačnost ako u skladu s tim konfigurišete podešavanje \'Pozicija linka ka stranici za podršku pristupačnosti\'.';
$string['accessibilitysupportrecaptcha'] = 'Dodajte reCAPTCHA upit na stranicu za podršku pristupačnosti';
$string['accessibilitysupportrecaptcha_desc'] = 'Sa ovim podešavanjem kontrolišete da li će reCAPTCHA upit biti dodat na stranicu za podršku pristupačnosti. Svrha ovoga je da se spreči neželjena pošta i zloupotreba obrasca za podršku pristupačnosti, baš kao što se to radi unutar <a href="{$a->support}">Moodle osnovnog obrasca za podršku</a>. Međutim, dodavanje reCAPTCHA upita predstavlja dodatnu prepreku pristupačnosti za korisnike koji koriste čitače ekrana ili druge pomoćne tehnologije, što bi u ovom slučaju moglo da bude kontraproduktivno. Zato vas molimo da budete oprezni ukoliko želite da omogućite ovo podešavanje. Takođe, imajte na umu da, čak i ako je ovo podešavanje omogućeno, reCAPTCHA upit neće biti prikazan dok ne unesete neophodne <a href="{$a->settings}">API ključeve u podešavanjima za proveru identiteta</a>.';
$string['accessibilitysupportsentforanonymoususer'] = 'Korisnik je zatražio da anonimno pošalje ove povratne informacije o pristupačnosti.';
$string['accessibilitysupportsubmit'] = 'Pošalji';
$string['accessibilitysupporttab'] = 'Stranica za podršku';
$string['accessibilitysupporttechinfo'] = 'Tehničke informacije';
$string['accessibilitysupporttechinfocheckbox'] = 'Slažem se da zajedno sa porukom pošaljem i sledeće tehničke informacije';
$string['accessibilitysupporttechinfolabel'] = 'Tehničke informacije koje se šalju sa porukom';
$string['accessibilitysupporttechinforeferrer'] = 'Referentna stranica (\'referrer\')';
$string['accessibilitysupporttechinfosysinfo'] = 'Informacije o sistemu';
$string['accessibilitysupportuserfirstname'] = 'Pristupačnost';
$string['accessibilitysupportuserlastname'] = 'podrška';
$string['accessibilitysupportusermail'] = 'Adresa e-pošte za podršku pristupačnosti';
$string['accessibilitysupportusermail_desc'] = 'Ovde definišete adresu e-pošte na koju treba da se šalju zahtevi za podršku pristupačnosti. Ako ovo polje ostavite prazno, zahtevi će biti poslati na <a href="{$a->url}">konfigurisani kontakt za podršku sajta</a>.';
$string['accessibilitysupportusermailsubject'] = 'Zahtev za podršku pristupačnosti';
$string['activitybrandingtab'] = 'Brendiranje aktivnosti';
$string['activityiconcoloradministrationsetting'] = 'Boja ikonice aktivnosti za ”Administracija”';
$string['activityiconcoloradministrationsetting_desc'] = 'Boja ikonice aktivnosti za ”Administracija”';
$string['activityiconcolorassessmentsetting'] = 'Boja ikonice aktivnosti za ”Procena”';
$string['activityiconcolorassessmentsetting_desc'] = 'Boja ikonice aktivnosti za ”Procena”';
$string['activityiconcolorcollaborationsetting'] = 'Boja ikonice aktivnosti za ”Saradnja”';
$string['activityiconcolorcollaborationsetting_desc'] = 'Boja ikonice aktivnosti za ”Saradnja”';
$string['activityiconcolorcommunicationsetting'] = 'Boja ikonice aktivnosti za ”Komunikacija”';
$string['activityiconcolorcommunicationsetting_desc'] = 'Boja ikonice aktivnosti za ”Komunikacija”';
$string['activityiconcolorcontentsetting'] = 'Boja ikonice aktivnosti za ”Sadržaj”';
$string['activityiconcolorcontentsetting_desc'] = 'Boja ikonice aktivnosti za ”Sadržaj”';
$string['activityiconcolorinteractivecontentsetting'] = 'Boja ikonice aktivnosti za "Interaktivni sadržaj"';
$string['activityiconcolorinteractivecontentsetting_desc'] = 'Boja ikonice aktivnosti za "Interaktivni sadržaj"';
$string['activityiconcolorinterfacesetting'] = 'Boja ikonice aktivnosti za ”Interfejs”';
$string['activityiconcolorinterfacesetting_desc'] = 'Boja ikonice aktivnosti za ”Interfejs”';
$string['activityiconcolorsheading'] = 'Boje ikonica aktivnosti';
$string['activitynavigationsetting'] = 'Elementi navigacije kroz aktivnosti i sekcije';
$string['activitynavigationsetting_desc'] = 'Sa ovim podešavanje elementi za prelazak na prethodnu i sledeću aktivnost/resurs, kao i padajući meni za prelazak na određenu aktivnost/resurs će biti prikazani. Štaviše, u okviru kurseva koji koriste režim prikaza \'jedna sekcija po stranici\', slični elementi za prethodnu i sledeću sekciju biće, takođe, prikazani. Ovakvi elementi korisničkog interfejsa su već postojali u Boost temi u osnovnoj instalaciji Moodlea sve do verzije Moodle 3.11, ali su uklonjeni u verziji 4.0. Sa temom Boost Union, možete vratiti ove elemente.';
$string['activitypurposeadministration'] = 'Administracija';
$string['activitypurposeassessment'] = 'Procena';
$string['activitypurposecollaboration'] = 'Saradnja';
$string['activitypurposecommunication'] = 'Komunikacija';
$string['activitypurposecontent'] = 'Sadržaj';
$string['activitypurposeheading'] = 'Namena ikonica aktivnosti';
$string['activitypurposeheading_desc'] = 'Sa ovim podešavanjima, možete zameniti boju pozadine ikonice aktivnosti koja je definisana njenom namenom (boja je, inače, definisana u samom kôdu svake aktivnosti).';
$string['activitypurposeheadingpleasenote'] = 'Napomena: na stranici za pregled aktivnosti u okviru kursa, svi resursi poput "knjige" su objedinjene u sekciji "resursi". Stoga , svrha ovih pojedinačnih tipova aktivnosti ne može/ne mora biti promenjena na ovoj stranici. Možete samo promeniti boju ikonice "resursi" pomoću gornjeg podešavanja.';
$string['activitypurposeheadingtechnote'] = 'Tehnička napomena: zbog načina na koji osnovna instalacija Moodlea implementira namene aktivnosti i njihove boje, one se mogu izmeniti samo putem CSS-a od strane Boost Union grafičke teme. Trenutno, sve oblasti u Moodle osnovnoj instalaciji koje prikazuju obojene ikonice aktivnosti treba da budu pokrivene. Ako primetite bilo koju oblast ili nestandardni dodatak koji nastavlja da prikazuje nepromenjene boje namene aktivnosti, prijavite na {$a}.';
$string['activitypurposeinteractivecontent'] = 'Interaktivni sadržaj';
$string['activitypurposeinterface'] = 'Interfejs';
$string['activitypurposeother'] = 'Drugo';
$string['additionalresourcesfileurlpersistent'] = 'URL adresa (trajna)';
$string['additionalresourcesfileurlrevisioned'] = 'URL adresa (revidirana)';
$string['additionalresourcesheading'] = 'Dodatni resursi';
$string['additionalresourceslistsetting'] = 'Spisak dodatnih resursa';
$string['additionalresourceslistsetting_desc'] = 'Ovo je spisak datoteka koje ste postavili u prostor za datoteke dodatnih resursa. Navedene URL adrese se mogu koristiti kako biste linkove kao ovim datotekama upotrebili u svom prilagođenom CSS opisu stilova, u fusnoti ili gde god je potrebno da koristite postavljene datoteke, a gde direktno postavljanje datoteka nije moguće.';
$string['additionalresourcessetting'] = 'Dodatni resursi';
$string['additionalresourcessetting_desc'] = 'Sa ovim podešavanjem možete da postavite dodatne resurse u temu. Prednost postavljanje datoteka u ovu polje za datoteka je u tome što se one mogu isporučiti bez provere da li je korisnik prijavljen. To je i razlog zašto treba da dodajete samo datoteke koje nisu kritične. Svima treba da bude dozvoljen pristup koji  ne treba da bude zaštićen validnom prijavom. Čim postavite barem jednu datoteku u ovaj prostor za datoteke i sačuvate podešavanja, u nastavku ove stranice će se pojaviti spisak koji će vam dati URL adresu koju možete koristiti za povezivanje sa odgovarajućom datotekom.';
$string['addpreferredlangsetting'] = 'Dodajte u jezički meni link za preferirani jezik';
$string['addpreferredlangsetting_desc'] = 'Sa ovim podešavanja možete da dodate podešavanje \'Podesi preferirani jezik\' u jezički meni u okviru korisničkog menija. Razumljivo, ovo podešavanje se obrađuje samo ako je podešavanje <a href="{$a->url1}">Prikaži jezički meni</a> omogućeno, i ako je barem <a href="{$a->url2}">instaliran drugi jezički paket</a>, <a href="{$a->url3}">ponuđen za izbor</a>.';
$string['administrationtab'] = 'Administracija';
$string['allowaccessibilitysupportwithoutlogin'] = 'Dozvolite pristup stranici za podršku pristupačnosti bez prijave na sistem';
$string['allowaccessibilitysupportwithoutlogin_desc'] = 'Ako je ovo podešavanje omogućeno, stranica za podršku pristupačnosti će biti prikazana i korisnicima koji nisu prijavljeni. Ako je ovo podešavanje onemogućeno, samo će korisnicima, koji su prijavljeni na sistem, biti dozvoljen pristup stranici za podršku pristupačnosti.';
$string['allowanonymoussubmitssetting'] = 'Omogućite slanje povratnih informacija o pristupačnosti';
$string['allowanonymoussubmitssetting_desc'] = 'Sa ovim podešavanjem možete dozvoliti korisniku da anonimno pošalje povratne informacije o pristupačnosti preko stranice za podršku pristupačnosti. Korisnici tada mogu odlučiti da li žele da pošalju povratne informacije anonimno (bez slanja korisničkog imena i adrese e-pošte) ili ne.';
$string['allowsendtechinfoalongsetting'] = 'Dozvolite slanje tehničkih informacija';
$string['allowsendtechinfoalongsetting_desc'] = 'Sa ovim podešavanjem možete dozvoliti korisniku da šalje tehničke informacije na stranici za podršku pristupačnosti. Korisnici tada mogu odlučiti da li žele da pošalju tehničke informacije ili ne.';
$string['alternativelogolinkurlsetting'] = 'Alternativna URL adresa/link logotipa';
$string['alternativelogolinkurlsetting_desc'] = 'Sa ovim podešavanjem, možete postaviti alternativnu URL adresu koja će se koristiti kao link logotipa u navigacionoj traci. Možete da koristite ovo podešavanje kako biste, na primer, povezali logo sa veb sajtom vaše institucije umesto sa naslovnom stranicom Moodlea. Na taj način biste imali ujednačenu navigaciju na svim sajtovima vaše institucije.';
$string['always'] = 'Uvek';
$string['auto'] = 'Automatski';
$string['backgroundimagepositionsetting'] = 'Pozicija pozadinske slike';
$string['backgroundimagepositionsetting_desc'] = 'Sa ovim podešavanjem kontrolišete pozicioniranje pozadinske slike unutar prozora veb čitača. Prva vrednost je horizontalni, druga vertikalni položaj.';
$string['backgroundimagesetting'] = 'Pozadinska slika';
$string['backgroundimagesetting_desc'] = 'Ovde možete da postavite prilagođenu sliku koja će biti prikazana kao pozadina sajta. Pozadinska slika koju ovde postavite će zameniti pozadinsku sliku u vašim datotekama  sa predefinisanim podešavanjima teme.';
$string['backgroundimagesheading'] = 'Opšte pozadinske slike';
$string['backtotop'] = 'Povratak na vrh';
$string['backtotopbuttonsetting'] = 'Dugme \'Povratak na vrh\'';
$string['backtotopbuttonsetting_desc'] = 'Sa ovim podešavanjem, dugme za povratak na vrh će se pojaviti u donjem desnom uglu stranice čim korisnik skroluje stranicu nadole. Ovakvo dugme je već postojalo u Boost grafičkoj temi u Moodle osnovnoj instalaciji sve do verzije Moodle 3.11, ali je uklonjeno u verziji 4.0. Sa temom Boost Union, možete povratiti ovo dugme.';
$string['blockdrawerwidthsetting'] = 'Širina fioke sa blokovima';
$string['blockdrawerwidthsetting_desc'] = 'Sa ovim podešavanjem, možete izmeniti širinu fioke sa blokovima bez ručnih modifikacija SCSS stilova. Standardno, Moodle koristi srednju maksimalnu širinu od 315 piksela. Možete uneti i druge vrednosti, koje se takođe izražavaju u pikselima, kao što je npr. 400 piksela, ali i vrednosti u drugim jedinicama, kao što su procenti, ili vrednost za viewport-width neće funkcionisati.';
$string['blockregionfooterwidth'] = 'Širina regiona blokova za region \'Podnožje\'.';
$string['blockregionfooterwidth_desc'] = 'Sa ovim podešavanjem možete podesiti širinu regiona blokova \'Podnožje\'. Možete birati između pune širine, širine sadržaja kursa i širine čitavog ekrana.';
$string['blockregionoutsidebottomwidth'] = 'Širina regiona blokova za region \'Spolja (dole)\'.';
$string['blockregionoutsidebottomwidth_desc'] = 'Sa ovim podešavanjem možete podesiti širinu regiona blokova \'Spolja (dole)\' koji se prikazuje ispod glavnog sadržaja. Možete birati između pune širine, širine sadržaja kursa i širine čitavog ekrana.';
$string['blockregionoutsideleftwidth'] = 'Širina regiona blokova za region \'Spolja (levo)\'.';
$string['blockregionoutsideleftwidth_desc'] = 'Sa ovim podešavanjem možete podesiti širinu regiona blokova \'Spolja (levo)\'. koji se prikazaju levo od glavnog sadržaja. Podrazumevano, Boost Union koristi širinu od 300 piksela. Možete da unesete druge vrednosti zasnovane na pikselima kao što je 200 piksela, ali takođe možete da unesete vrednost zasnovanu na procentima kao što je 10% ili vrednost širine okvira za prikaz (viewport) kao što je 10vw.';
$string['blockregionoutsiderightwidth'] = 'Širina regiona blokova za region \'Spolja (desno)\'.';
$string['blockregionoutsiderightwidth_desc'] = 'Sa ovim podešavanjem možete podesiti širinu regiona blokova \'Spolja (desno)\'. koji se prikazaju desno od glavnog sadržaja. Podrazumevano, Boost Union koristi širinu od 300 piksela. Možete da unesete druge vrednosti zasnovane na pikselima kao što je 200 piksela, ali takođe možete da unesete vrednost zasnovanu na procentima kao što je 10% ili vrednost širine okvira za prikaz (viewport) kao što je 10vw.';
$string['blockregionoutsidetopwidth'] = 'Širina regiona blokova za region \'Spolja (gore)\'.';
$string['blockregionoutsidetopwidth_desc'] = 'Sa ovim podešavanjem možete podesiti širinu regiona blokova \'Spolja (gore)\' koji se prikazuje na samom vrhu stranice. Možete birati između pune širine, širine sadržaja kursa i širine čitavog ekrana.';
$string['blockregionsforlayout'] = 'Dodatni regioni blokova za stranicu tipa \'{$a}\'';
$string['blockregionsforlayout_desc'] = 'Sa ovim podešavanjem možete da omogućite dodatne regione blokova za stranicu tipa \'{$a}\'';
$string['blockregionsheading'] = 'Dodatni regioni blokova';
$string['blockregionsheading_desc'] = '<p>Boost Union pruža veliki broj dodatnih regiona za blokove koji se mogu koristiti za dodavanje i prikazivanje blokova na čitavoj Moodle stranici:</p>
<ul><li><em>Spoljni regioni blokova</em> postavljeni su na sve četiri strane Moodle stranice. Mogu se koristiti za prikazivanje blokova koji prate prikazanu Moodle stranicu, ali direktno ne pripadaju glavnom sadržaju.</li>
<li><em>Region blokova zaglavlja</em> se nalazi između regiona Spolja (gore) i glavnog sadržaja stranice. Može se koristiti za prikazivanje bloka kao informacije u zaglavlju kursa.</li>
<li><em>Regioni blokova sadržaja</em> se postavljaju direktno iznad i ispod glavnog sadržaja u regionu glavnog sadržaja. Mogu se koristiti za dodavanje blokova u sam tok sadržaja kursa.</li>
<li><em>Regioni blokova podnožja</em> nalaze se na dnu stranice između regiona Spolja (dole) i fusnote. Imate na raspolaganju tri regiona podnožja za pravljenje stubaca sa blokovima ako je potrebno.</li>
<li>The <em>Region blokova ”Van stranice”</em> je neka vrsta  specijalnog regiona jer se prikazuje preko cele Moodle stranice kao fioka. Fioka se otvara pomoću specijalne ikonice od 9 tačaka (tri reda sa po tri tačkice) smeštene u samom gornjem desnom uglu navigacione trake. Na raspolaganju su vam tri ovakva regiona za kreiranje stubaca sa blokovima ukoliko je to potrebno</li></ul>
<p>Molimo vas da obratite pažnju:</p>
<ul><li>Standardno, svi dodatni regioni blokova su onemogućeni. Omogućite pojedine regione blokova na određenim vrstama stranica u skladu sa svojim potrebama. Pokušajte da budete što je moguće više fokusirani – previše regiona blokova može dovesti do nepotrebne distrakcije krajnjih korisnika.</li>
<li>Čim se omogući dodatni region blokova, on postaje vidljiv svim autorizovanim korisnicima, kao i gostima, a mogu ga uređivati predavači i menadžeri (naravno, u zavisnosti od činjenice da li je određenom korisniku dozvoljeno da uređuje određenu Moodle stranicu). Ali postoje i mogućnosti  theme/learnr:viewregion* i theme/learnr:editregion* koji vam omogućavaju da fino podesite upotrebu svakog regiona sa blokovima zavisno od vaših potreba.</li>
<li>Regioni blokova Spolja (levo), Spolja (desno), Sadržaj (gornji), Sadržaj (donji) i Zaglavlje nisu dostupni za sve vrste stranica.</li></ul>';
$string['blockregionsheading_guestrole'] = '<strong>Pažnja!</strong><br /> Na instalacijama Boost Union teme koje su nadograđene sa verzije koja se pojavila pre Boost Union v5.0, regioni blokova, standardno, još uvek nisu vidljivi gostujućim korisnicima, a ova podrazumevana podešavanja vidljivosti su promenjena u Boost Union v5.0. Možete automatski popraviti podrazumevane vrednosti (i time učiniti regione sa blokovima vidljivim za goste) ili zadržati lokalnu konfiguraciju vidljivosti kakva ona jeste (i tako se izdvojiti od gornjeg objašnjenja).';
$string['blockregionsheading_guestrole_fix'] = 'Ispravite ulogu gosta kako biste koristili nove podrazumevane vrednosti';
$string['blockregionsheading_guestrole_fixed'] = 'Uloga gosta sada koristi nove podrazumevane vrednosti, a obaveštenje na stranici sa podešavanjima će sada biti uklonjeno.';
$string['blockregionsheading_guestrole_keep'] = 'Задржите улогу госта онакву каква већ јесте';
$string['blockregionsheading_guestrole_kept'] = 'Uloga gosta će ostati onakva kakva jeste, a obaveštenje na stranici sa podešavanjima će sada biti uklonjeno.';
$string['blocksgeneralheading'] = 'Opšti blokovi';
$string['blockstab'] = 'Blokovi';
$string['boost_union:configure'] = 'Sposobnost da se tema konfiguriše kao ne-administrator';
$string['boost_union:editregioncontentlower'] = 'Sposobnost da se uređuje region blokova Sadržaj (donji)';
$string['boost_union:editregioncontentupper'] = 'Sposobnost da se uređuje region blokova Sadržaj (gornji)';
$string['boost_union:editregionfootercenter'] = 'Sposobnost da se uredi region blokova Podnožje (centar)';
$string['boost_union:editregionfooterleft'] = 'Sposobnost da se uredi region blokova Podnožje (levo)';
$string['boost_union:editregionfooterright'] = 'Sposobnost da se uredi region blokova Podnožje (desno)';
$string['boost_union:editregionheader'] = 'Sposobnost da se uredi regiona blokova Zaglavlja';
$string['boost_union:editregionoffcanvascenter'] = 'Sposobnost da se uredi region blokova Van-stranice (centar)';
$string['boost_union:editregionoffcanvasleft'] = 'Sposobnost da se uredi region blokova Van-stranice (desno)';
$string['boost_union:editregionoffcanvasright'] = 'Sposobnost da se uredi region blokova Van-stranice (desno)';
$string['boost_union:editregionoutsidebottom'] = 'Sposobnost da se uredi region blokova Spolja (dole)';
$string['boost_union:editregionoutsideleft'] = 'Sposobnost da se uredi region blokova Spolja (levo)';
$string['boost_union:editregionoutsideright'] = 'Sposobnost da se uredi region blokova Spolja (desno)';
$string['boost_union:editregionoutsidetop'] = 'Sposobnost da se uredi region blokova Spolja (gore)';
$string['boost_union:viewhintcourseguestenrol'] = 'Sposobnost da se vidi nagoveštaj (hint) u vidljivim kursevima.';
$string['boost_union:viewhintcourseselfenrol'] = 'Sposobnost da se vidi nagoveštaj (hint) za neograničeni samostalni upis na vidljivim kursevima.';
$string['boost_union:viewhintinhiddencourse'] = 'Sposobnost da se vidi nagoveštaj (hint) u sakrivenim aktivnostima';
$string['boost_union:viewregioncontentlower'] = 'Sposobnost da se vidi region blokova Sadržaj (donji)';
$string['boost_union:viewregioncontentupper'] = 'Sposobnost da se vidi region blokova Sadržaj (gornji)';
$string['boost_union:viewregionfootercenter'] = 'Sposobnost da se vidi region blokova Podnožje (centar)';
$string['boost_union:viewregionfooterleft'] = 'Sposobnost da se vidi region blokova Podnožje (levo)';
$string['boost_union:viewregionfooterright'] = 'Sposobnost da se vidi region blokova Podnožje (desno)';
$string['boost_union:viewregionheader'] = 'Sposobnost da se vidi region blokova Zaglavlje';
$string['boost_union:viewregionoffcanvascenter'] = 'Sposobnost da se vidi region blokova Van-stranice (centar)';
$string['boost_union:viewregionoffcanvasleft'] = 'Sposobnost da se vidi region blokova Van-stranice (levo)';
$string['boost_union:viewregionoffcanvasright'] = 'Sposobnost da se vidi region blokova Van-stranice (desno)';
$string['boost_union:viewregionoutsidebottom'] = 'Sposobnost da se vidi region blokova Spolja (dole)';
$string['boost_union:viewregionoutsideleft'] = 'Sposobnost da se vidi region blokova Spolja (levo)';
$string['boost_union:viewregionoutsideright'] = 'Sposobnost da se vidi region blokova Spolja (desno)';
$string['boost_union:viewregionoutsidetop'] = 'Sposobnost da se vidi region blokova Spolja (gore)';
$string['bootstrapcolordangersetting'] = 'Bootstrap boja za "Opasnost"';
$string['bootstrapcolordangersetting_desc'] = 'Bootstrap boja za "Opasnost"';
$string['bootstrapcolorinfosetting'] = 'Bootstrap boja za "Info"';
$string['bootstrapcolorinfosetting_desc'] = 'Bootstrap boja za "Info"';
$string['bootstrapcolorsheading'] = 'Bootstrap boje';
$string['bootstrapcolorsuccesssetting'] = 'Bootstrap boja za "Uspeh"';
$string['bootstrapcolorsuccesssetting_desc'] = 'Bootstrap boja za "Uspeh"';
$string['bootstrapcolorwarningsetting'] = 'Bootstrap boja za "Upozorenje"';
$string['bootstrapcolorwarningsetting_desc'] = 'Bootstrap boja za "Upozorenje"';
$string['bootstrapdangercolor'] = 'Boja opasnosti';
$string['bootstrapdarkcolor'] = 'Tamna boja';
$string['bootstrapinfocolor'] = 'Info boja';
$string['bootstraplightcolor'] = 'Svetla boja';
$string['bootstrapnone'] = 'Bez Bootstrap boje';
$string['bootstrapprimarycolor'] = 'Primarna boja';
$string['bootstrapsecondarycolor'] = 'Sekundarna boja';
$string['bootstrapsuccesscolor'] = 'Boja uspeha';
$string['bootstrapwarningcolor'] = 'Boja upozorenja';
$string['brandcolorsheading'] = 'Boje brenda';
$string['breadcrumbsheading'] = 'Navigacija sa putanjom';
$string['cachedef_flavours'] = 'Vizuelni identiteti koji se primenjuju na datu ID oznaku kategorije stranice za trenutnog korisnika';
$string['cachedef_fontawesomeicons'] = 'Mapa ikonica FontAwesome';
$string['cachedef_smartmenu_items'] = 'Stavke u pametnom meniju';
$string['cachedef_smartmenus'] = 'Pametni meniji';
$string['cachedef_touchiconsios'] = 'Datoteka ikonica osetljivih na dodir za iOS';
$string['calendarbrandingheading'] = 'Opšte brendiranje kalendara';
$string['calendarbrandingtab'] = 'Brendiranje kalendara';
$string['calendareventcolorbordersetting'] = 'Boja ivice za tipa događaja u kalendaru "{$a}"';
$string['calendareventcolorbordersetting_desc'] = 'Boja za tip događaj u kalendaru "{$a}" koji se koristi za ivice.';
$string['calendareventcolormainsetting'] = 'Glavna boja za tip događaj u kalendaru "{$a}"';
$string['calendareventcolormainsetting_desc'] = 'Glavna boja za tip događaj u kalendaru "{$a}" koja se koristi za ikonice i pozadine.';
$string['calendareventcolorsheading'] = 'Tip događaj u kalendaru: {$a}';
$string['calendareventtypecategory'] = 'Kategorija';
$string['calendareventtypecourse'] = 'Kurs';
$string['calendareventtypegroup'] = 'Grupa';
$string['calendareventtypeother'] = 'Drugo';
$string['calendareventtypesite'] = 'Sajt';
$string['calendareventtypeuser'] = 'Korisnik';
$string['calendariconscolorsetting'] = 'Boje ikonica kalendara';
$string['calendariconscolorsetting_desc'] = 'Boja nekih ikonica koje se koriste u prikazima kalendara. Standardno , boja je plava, ali ovo može biti u neskladu sa bojama brendiranja kalendara koje ste, možda, prethodno podesili.';
$string['categorybreadcrumbs'] = 'Prikažite kategoriju u navigacionoj putanji u zaglavlju kursa';
$string['categorybreadcrumbs_desc'] = 'Standarno, kategorije kurseva se ne prikazuju kao čvorovi u navigacionoj traci u zaglavlju kursa. Sa ovim podešavanjem, možete prikazati kategoriju kursa u navigacionoj traci iznad naziva kursa.';
$string['categoryindextab'] = 'Indeks kategorija / Početna stranica sajta';
$string['categorylistingheading'] = 'Spisak kategorija';
$string['categorylistingpresentation'] = 'Prezentacija spiska kategorija';
$string['categorylistingpresentation_boxlist'] = 'Spisak blokova kategorija';
$string['categorylistingpresentation_desc'] = 'Sa ovim podešavanjem, možete da modifikujete izgled spiska kategorija na indeksnim stranicama kategorija kao i na početnoj stranici sajta. Kao alternativu načinu na koji osnovna instalacija Moodle prikazuje spisak kategorija, možete prikazati osveženi spisak blokova kategorija.';
$string['categorylistingpresentation_nochange'] = 'Noćna mora dizajnera (nepromenjeno kako je predstavljeno u osnovnoj instalaciji Moodlea)';
$string['categorylistingpresentation_note'] = 'Napomena: ako ste omogućili gornje podešavanje \'Prezentacija spiska kurseva\', preporučujemo vam da omogućite i ovo podešavanje. Oba su dizajnirana tako da funkcionišu zajedno.';
$string['choosereadme'] = 'Grafička tema Boost Union predstavlja unapređenu verziju izvorne Boost teme koja ima za cilj, s jedne strane, da učini Boost temu jednostavnijom za podešavanje, a sa druge strane, da pruži administratorima, predavačima i polaznicima korisne dodatne funkcije za svakodnevni rad u Moodleu. Boost Union održava Moodle an Hochschulen e.V., u saradnji sa ssystems GmbH, zajedno sa bdecent GmbH i lern.link GmbH';
$string['closeoffcanvas'] = 'Zatvori fioku ”Van stranice”';
$string['configtitle'] = 'Boost Union';
$string['configtitleaccessibility'] = 'Pristupačnost';
$string['configtitlecontent'] = 'Sadržaj';
$string['configtitlefeel'] = 'Navigacija & Blokovi';
$string['configtitleflavours'] = 'Vizuelni identiteti';
$string['configtitlefunctionality'] = 'Funkcionalnost';
$string['configtitlelook'] = 'Izgled';
$string['configtitlesnippets'] = 'SCSS isečci kôda';
$string['contactcontentsetting'] = 'Sadržaj stranice za kontakt';
$string['contactcontentsetting_desc'] = 'U ovom podešavanju možete dodati sadržaj u formatu obogaćenog teksta koji će biti prikazan na stranici za (što nije isto što i standardna Moodle stranica \'Kontaktirajte podršku sajta\').';
$string['contactdisabled'] = 'Stranica za kontakt je onemogućena na ovom sajtu. Ovde nema šta da se vidi.';
$string['contactheading'] = 'Kontakt';
$string['contactlinkpositionboth'] = 'Dodajte link ka stranici za kontakt u fusnotu i na ikonicu u podnožju stranice (znak pitanja)';
$string['contactlinkpositionfooter'] = 'Dodajte link ka stranici za kontakt na ikonicu u podnožju stranice (znak pitanja)';
$string['contactlinkpositionfootnote'] = 'Dodajte link ka stranici za kontakt u fusnotu';
$string['contactlinkpositionnone'] = 'Nemojte automatski prikazivati link ka stranici za kontakt';
$string['contactlinkpositionsetting'] = 'Pozicija link ka stranici za kontakt';
$string['contactlinkpositionsetting_desc'] = 'U ovom podešavanju možete da konfigurišete da li će se link ka stranici za kontakt automatski dodati na Moodle stranicu. Ako ne želite da automatski prikazujete link, možete ručno dodati link ka {$a->url} sa bilo kog mesta u Moodleu.';
$string['contactpagetitledefault'] = 'Kontakt';
$string['contactpagetitlesetting'] = 'Naslov stranice za kontakt';
$string['contactpagetitlesetting_desc'] = 'U ovom podešavanju možete definisati naslov stranice za kontakt. Ovaj tekst će se takođe koristiti kao tekst linka ka stranici za kontakt ako u skladu s tim konfigurišete podešavanje \'Pozicija linka ka stranici za kontakt\'.';
$string['contentwidthheading'] = 'Širina sadržaja';
$string['coursecardscolumncount'] = 'Broj kolona u reštki sa karticama kurseva';
$string['coursecardscolumncount_desc'] = 'Rešetka sa karticama kurseva biće prikazana na prilagodljiv način (zavisno od veličine ekrana), a njene kolone će se na manjim ekranima prelamati. Sa ovim podešavanjem kontrolišete samo maksimalan broj kolona u rešetki sa karticama kurseva na većim ekranima. Podešavanjem maksimalnog broja kolona na 2 umesto na 3 može učiniti da kartice kurseva izgledaju prostranije i manje pretrpane. Postavljanje maksimalnog broja kolona na 1 je takođe moguće i efikasno će pretvoriti spisak kursa u vertikalni spisak kartica.';
$string['coursecontentmaxwidthsetting'] = 'Maksimalna širina sadržaja kursa';
$string['coursecontentmaxwidthsetting_desc'] = 'Sa ovim podešavanjem, možete izmeniti širinu sadržaja Moodle kursa bez ručnih modifikacija SCSS stilova. Ova širina se koristi kao širina stranice na stranicama kursa i u okviru nekoliko aktivnosti. Standardno, Moodle koristi maksimalnu širinu sadržaja kursa od 830 piksela. Možete da unesete druge vrednosti zasnovane na pikselima kao što je 1200 piksela, ali takođe možete da unesete vrednost zasnovanu na procentima kao što je 100% ili vrednost širine okvira za prikaz (viewport) kao što je 90vw.';
$string['courseheaderheading'] = 'Zaglavlje kursa';
$string['courseheaderimageenabled'] = 'Prikažite sliku kursa u zaglavlju kursa';
$string['courseheaderimageenabled_desc'] = 'Kada je omogućena ova opcija, slika kursa (koja se može postaviti u podešavanjima kursa) je prikazana, kako u zaglavlju kursa, isto tako i na stranici \'Moji kursevi\' gde su uvek slike kurseva i prikazaju.';
$string['courseheaderimagefallback'] = 'Rezervna slika zaglavlja kursa';
$string['courseheaderimagefallback_desc'] = 'Ako postavite sliku u ovom podešavanju, ona će se koristi kao rezervna slika i biće prikazana se u zaglavlju kursa ako slika kursa nije postavljena u podešavanjima nekog kursa. Ako pak ovde ne postavite sliku, slika zaglavlja kursa će biti prikazana samo u određenom kursu ukoliko je slika kursa učitana u podešavanjima ovog konkretnog kursa.';
$string['courseheaderimageheight'] = 'Visina slike zaglavlja kursa';
$string['courseheaderimageheight_desc'] = 'Sa ovim podešavanjem kontrolišete visinu prikazane slike zaglavlja kursa.';
$string['courseheaderimagelayout'] = 'Izgled slike zaglavlja kursa';
$string['courseheaderimagelayout_desc'] = 'Sa ovim podešavanjem kontrolišete izgled slike zaglavlja kursa i naslova kursa.';
$string['courseheaderimagelayoutheadingabove'] = 'Naslov kursa iznad slike kursa';
$string['courseheaderimagelayoutstackeddark'] = 'Naslov kursa preko slike kursa (bela boja fonta za tamne pozadinske slike)';
$string['courseheaderimagelayoutstackedlight'] = 'Naslov kursa preko slike kursa (crna boja fonta za svetle pozadinske slike)';
$string['courseheaderimageposition'] = 'Pozicija slike zaglavlja kursa';
$string['courseheaderimageposition_desc'] = 'Sa ovim podešavanjem kontrolišete pozicioniranje slike unutar kontejnera slike zaglavlja kursa. Prva vrednost je horizontalni a druga vertikalni položaj.';
$string['courseindexcompletioninfoposition'] = 'Pozicija indikatora završetka aktivnosti';
$string['courseindexcompletioninfoposition_desc'] = 'Izaberite poziciju na kojoj će biti prikazan indikator završetka aktivnosti. <em>Kraj reda</em> prikazuje standardni indikator završetka na kraju reda u indeksu kursa (tj. na kraju naziva aktivnosti čiji se završetak prati). <em>Početak reda</em> prikazuje standardni indikator završetka na početku reda u indeksu kursa (tj. pre naziva aktivnosti čiji se završetak prati). <em>Boja ikonice</em> ne prikazuje standardni indikator završetka, ali kodira informacije o završetku kao pozadinu ikonice modula kursa.';
$string['courseindexcompletioninfopositionendofline'] = 'Kraj reda';
$string['courseindexcompletioninfopositioniconcolor'] = 'Boja ikonice';
$string['courseindexcompletioninfopositionstartofline'] = 'Početak reda';
$string['courseindexdrawerwidthsetting'] = 'Širina fioke sa indeksom kursa';
$string['courseindexdrawerwidthsetting_desc'] = 'Sa ovim podešavanjem, možete izmeniti širinu fioke sa indeksom kursa bez ručnih modifikacija SCSS stilova. Standardno, Moodle koristi širinu fioke sa indeksom kursa od 285 piksela. Možete uneti i druge vrednosti, koje se takođe izražavaju u pikselima, kao što je 320 piksela, ali i vrednosti u drugim jedinicama, kao što su procenti, ili vrednost za viewport-width neće funkcionisati.';
$string['courseindexheading'] = 'Indeks kursa';
$string['courseindexmodiconenabled'] = 'Prikažite ikonice tipa aktivnosti u indeksu kursa';
$string['courseindexmodiconenabled_desc'] = 'Kada je ova opcija omogućeno, odgovarajuća ikonica tipa aktivnosti se prikazuje na početku reda u indeksu kursa sa naslovom aktivnosti. Pri tome, tip aktivnosti ili zamenjuje indikator završetka koji se pomera sa početka na kraj reda u indeksu kursa, ili je obojen bojom statusa završetka.';
$string['courseistingprogressstyle'] = 'Stil trake završetka kursa';
$string['courseistingprogressstyle_bar'] = 'Traka napredovanja';
$string['courseistingprogressstyle_desc'] = 'Sa ovim podešavanjem kontrolišete kako se prikazuje napredovanje u završetku kursa. Možete birati između procenta u formi jednostavnog teksta ili trake napredovanja.';
$string['courseistingprogressstyle_percentage'] = 'Procenat u obliku teksta';
$string['courselistingcontacts'] = 'Osoba na kursu zadužena za kontakt';
$string['courselistingfields'] = 'Klasifikacija kurseva';
$string['courselistinggoto'] = 'Idi na kurs';
$string['courselistingheading'] = 'Spisak kurseva';
$string['courselistinghowcategory'] = 'Prikaži kategoriju kursa na spisku kurseva';
$string['courselistinghowcategory_desc'] = 'Sa ovim podešavanjem kontrolišete da li se kategorija kursa prikazuju na spisku kurseva ili ne.';
$string['courselistinghowenrolicons'] = 'Prikaži ikonice za upis na spisku kurseva';
$string['courselistinghowenrolicons_desc'] = 'Sa ovim podešavanjem kontrolišete da li se ikonice za upis na kurs prikazuju na spisku kurseva ili ne.';
$string['courselistinghowgoto'] = 'Prikaži dugme \'Idi na\' na spisku kurseva';
$string['courselistinghowgoto_desc'] = 'Sa ovim podešavanjem kontrolišete da li se dugme \'Idi na kurs\' prikazuju na spisku kurseva ili ne. Ako je ovo podešavanje onemogućeno, korisnik i dalje može da ode na kurs klikom na naslov kursa ili klikom na sliku kursa.';
$string['courselistinghowimage'] = 'Prikaži sliku kursa na spisku kurseva';
$string['courselistinghowimage_desc'] = 'Sa ovim podešavanjem kontrolišete da li se slika kursa prikazuju na spisku kurseva ili ne.';
$string['courselistinghowpopup'] = 'Prikaži iskačući prozor sa detaljnim podacima o kursu na spisku kurseva';
$string['courselistinghowpopup_desc'] = 'Sa ovim podešavanjem kontrolišete da li se dugme \'Detaljni podaci o kursu\' prikazuju na spisku kurseva ili ne. Sa ovim dugmetom, korisnik može da otvori iskačući prozor, sa detaljnim podacima, koji sadrži rezime kursa, osobe zadužene za kontakt, kao i prolagođena polja kursa. Iskačući prozor će sadržati ove informacije bez obzira da li ste ih omogućili na kartici kursa/redu ili ne.';
$string['courselistinghowprogress'] = 'Prikaži napredak u završetku kursa na spisku kurseva';
$string['courselistinghowprogress_desc'] = 'Sa ovim podešavanjem kontrolišete da li se napredak u završetku kursa prikazuju na spisku kurseva ili ne.';
$string['courselistinghowshortname'] = 'Prikaži skraćeni naziv kursa spisku kurseva';
$string['courselistinghowshortname_desc'] = 'Sa ovim podešavanjem kontrolišete da li se skraćeni naziv kursa prikazuju na spisku kurseva ili ne.';
$string['courselistingnosummary'] = 'Ovaj kurs nema rezime';
$string['courselistingpopup'] = 'Detaljnije informacije';
$string['courselistingpresentation'] = 'Prikaz spiska kurseva';
$string['courselistingpresentation_cards'] = 'Kartice kurseva';
$string['courselistingpresentation_desc'] = 'Sa ovim podešavanjem, možete da modifikujete izgled spiska kurseva na indeksnim stranicama kategorija kao i na početnoj stranici sajta. Kao alternativu načinu na koji ga osnovna instalacija Moodle prikazuje, spisak kurseva možete prikazati kao kartice kurseva (slično karticama kurseva na stranici \'Moji kursevi\') ili kao spisak kurseva (slično spisku kurseva na stranici \'Moji kursevi\')';
$string['courselistingpresentation_list'] = 'Spisak kurseva';
$string['courselistingpresentation_nochange'] = 'Noćna mora za dizajnera (nepromenjeno, kako je predstavljeno u osnovnoj Moodle instalaciji)';
$string['courselistingpresentation_note'] = 'Napomena : ako omogućite kartice kurseva ili spisak kurseva. <a href="{$a->url1}">coursesperpage</a> podešavanje se i dalje poštuje i kontrolisaće koliko će kartica/redova biti prikazano. Međutim, podešavanje <a href="{$a->url2}">courseswithsummarieslimit</a> nema više nikakvog efekta - kursevi će biti prikazani sa svim detaljima. Molimo vas da vodite računa da ne podesite opciju <a href="{$a->url1}">coursesperpage</a> na preveliku vrednost kako biste izbegli predugo učitavanje stranica sa mnogo kurseva.';
$string['courselistingselectfields'] = 'Izaberite polja kursa koja će biti prikazana na spisku kurseva';
$string['courselistingselectfields_desc'] = 'Sa ovim podešavanjem možete da izaberete koja prilagođena polja kursa će biti prikazana na spisku kurseva. Ako ništa nije izabrano, neće biti prikazano nijedno polje.';
$string['courselistingselectfields_nofield'] = 'Sa ovim podešavanjem možete da izaberete koja prilagođena polja kursa će biti prikazana na spisku kurseva. Još uvek nije kreirano nijedno prilagođeno polje koje bi moglo da bude upotrebljeno. Molimo vas da prvo odete на <a href="{$a->url}">{$a->linktitle}</a> i kreirate prilagođeno polje.';
$string['courselistingshowcontacts'] = 'Prikažina na spisku kurseva osobe zadužene za kontakt';
$string['courselistingshowcontacts_desc'] = 'Sa ovim podešavanjem kontrolišete da li se slike osoba zaduženih za kontakt prikazuju na spisku kurseva ili ne. Napomena : slike osoba zaduženih za kontakt se prikazuju zajedno sa slikom kursa, tako da prikazivanja slika osoba na kursu, zaduženih za kontakata bez prikazivanja slike kursa nije moguće.';
$string['courselistingshowfields'] = 'Prikaži polja kursa na spisku kursva';
$string['courselistingshowfields_desc'] = 'Sa ovim podešavanjem kontrolišete da li se prilagođena polja kursa prikazuju na spisku kurseva ili ne.';
$string['courselistingstylefields'] = 'Odredite stil polja sa kursevima na spisku kurseva';
$string['courselistingstylefields_desc'] = 'Sa ovim podešavanjem možete da kontrolišete kako se na spisku kurseva prikazuju prilagođena polja kursa. Možete birati između prikazivanja u formi teksta (prikazuju se vrednosti polja zajedno sa nazivom polja kao oznake) ili kao bedž (prikazuju se samo vrednosti polja).';
$string['courselistingummary'] = 'Rezime kursa';
$string['coursemanagementheading'] = 'Upravljanje kursom';
$string['courseoverviewheading'] = 'Blok - Pregled kurseva';
$string['courseoverviewshowcourseimagessetting'] = 'Prikaži slike kursa';
$string['courseoverviewshowcourseimagessetting_desc'] = 'Sa ovim podešavanjem možete da kontrolišete da li je slika kursa vidljiva unutar bloka za pregled kurseva ili nije. Moguće je izabrati drugačije podešavanje za kartični prikaz, prikaz rezimea i prikaz spiska.';
$string['courseoverviewshowprogresssetting'] = 'Prikaži napredak u završetku kursa.';
$string['courseoverviewshowprogresssetting_desc'] = 'Sa ovim podešavanjem možete da kontrolišete da li je napredak u završetku kursa vidljivo unutar bloka ѕa pregled kurseva ili nije';
$string['courserelatedhintsforstudentsheading'] = 'Nagoveštaji (hintovi) za polaznike u vezi sa kursom';
$string['courserelatedhintsforteachersheading'] = 'Nagoveštaji (hintovi) za predavače u vezi sa kursom';
$string['coursestab'] = 'Kursevi';
$string['coursetab'] = 'Kurs';
$string['cssh5pheading'] = 'Neobrađeni CSS za H5P';
$string['cssh5psetting'] = 'Neobrađeni CSS za H5P';
$string['cssh5psetting_desc'] = 'Koristite ovo polje kako biste naveli CSS kôd koji će moduli mod_h5p i mod_hvp primeniti na prikaz H5P sadržaja. Pregledajte H5P tipove sadržaja kako biste pronašli potrebne CSS selektore.';
$string['customfontsfileurlpersistent'] = 'URL adresa (trajna)';
$string['customfontsfileurlrevisioned'] = 'URL adresa (revidirana)';
$string['customfontsheading'] = 'Prilagođeni fontovi';
$string['customfontslistsetting'] = 'Spisak prilagođenih fontova';
$string['customfontslistsetting_desc'] = 'Ovo je spisak fontova koje ste postavili u prostor za datoteke prilagođenih fontova. Dati CSS odlomci kôda se mogu koristiti za dodavanje ovih fontova u vaš prilagođeni SCSS. Imajte na umu da ćete za sada morati sami da vodite računa o vrednosti formata fonta, kao i o CSS svojstvima porodice fontova, stila fonta i težine fonta jer Boost Union još uvek nije u stanju da analizira sintaksu datoteke fontova.';
$string['customfontssetting'] = 'Prilagođeni fontovi';
$string['customfontssetting_desc'] = 'Sa ovim podešavanjem možete da postavite prilagođene fontove u temu. Prednost postavljanja fontova u ovaj prostor za datoteke je u tome što se ti fontovi mogu isporučiti bez provere da li je korisnik prijavljen i mogu se koristiti kao lokalno instalirani fontovi svuda na sajtu. Čim postavite barem jedan font u ovaj prostor za datoteka i sačuvate podešavanja, ispod će se pojaviti spisak koja će vam dati CSS odlomke kôda koje možete koristiti kao šablon za referenciranje određenih fontova u vašem prilagođenom SCSS-u.';
$string['dashboardtab'] = 'Kontrolni panel / Moji kursevi';
$string['dontchange'] = 'Ne menjajte ništa';
$string['drawerwidthheading'] = 'Širina fioke';
$string['emailbrandinghtmldemobody'] = '<p>Telo e-poruke počinje ovde.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>Telo e-poruke se završava ovde.</p>';
$string['emailbrandinghtmlheading'] = 'Pregled e-poruke u HTML formatu';
$string['emailbrandinghtmlintro'] = 'Ovo je pregled e-pošte u HTML formatu zasnovan na prefiksima i sufiksima brendiranja koji su trenutno podešeni u jezičkom paketu.';
$string['emailbrandinghtmlnopreview'] = 'Do sada, e-poruke u HTML formatu nisu bile prilagođavane u okviru ove funkcije. E -poruke će biti sastavljane i slate uobičajeno.';
$string['emailbrandinginstruction'] = 'Kako da';
$string['emailbrandinginstruction0'] = 'Sa ovom Boost Union funkcijom, možete primeniti brendiranje na svu e-poštu koju Moodle šalje.';
$string['emailbrandinginstructionli1'] = 'Idite na <a href="{$a->url}" target="_blank">stranicu za prilagođavanja jezika</a> kako biste otvorili <em>{$a->lang}</em> jezički paket za uređivanje.';
$string['emailbrandinginstructionli2'] = 'Potražite i izmenite ove stringove u <code>theme_boost_union</code> jezičkom paketu:';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code>: Ovaj isečak kôda će biti dodat <em>na početak / pre tela</em> svih <em>e-poruka u HTML formatu</em> koje Moodle šalje.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code>: Ovaj isečak kôda će biti dodat   <em>na kraj / nakon tela</em> svih <em>e-poruka u HTML formatu</em> koje Moodle šalje.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailtextprefix</code>: Ovaj isečak kôda će biti dodat <em>na početak / pre tela</em> svih <em> e-poruka u formatu običnog teksta </em> koje Moodle šalje.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code>: Ovaj isečak kôda će biti dodat <em>na kraj / nakon tela</em> svih <em> e-poruka u formatu običnog teksta</em> koje Moodle šalje.';
$string['emailbrandinginstructionli3'] = 'Sačuvajte promene jezičkog paketa.';
$string['emailbrandinginstructionli4'] = 'Vratite se na ovu stranicu i pogledajte preglede e-pošte u nastavku ove stranice.';
$string['emailbrandingintroheading'] = 'Uvod';
$string['emailbrandingintronote'] = 'Imajte na umu: ovo je napredna funkcionalnost koja koristi neka zaobilazna rešenja kako bi se obezbedile opcija za brendiranje e-pošte. Molimo vas da pažljivo pratite uputstva.';
$string['emailbrandingpitfalls'] = 'Zamke';
$string['emailbrandingpitfalls0'] = 'Koristeći ovu funkciju, postoje neke zamke kojih biste trebali biti svesni:';
$string['emailbrandingpitfallsli1'] = 'Obavezno je da izmenite stringove jezičkog paketa<em>trenutnog podrazumevanog jezika</em> na ovom sajtu. Čak i ako imate instalirano više jezičkih paketa, samo će promene podrazumevanog jezika imati efekta.';
$string['emailbrandingpitfallsli2'] = 'Uvažavanje jezika primaoca nije moguće. Zbog toga, trebalo bi da koristite jezički neutralne termine u okviru isečaka za brendiranja e-pošte.';
$string['emailbrandingpitfallsli3'] = 'Ako ikada promenite podrazumevani jezik sajta u budućnosti, moraćete da migrirate izmenjene stringove jezičkog paketa u novi podrazumevani jezički paket.';
$string['emailbrandingpitfallsli4'] = 'Kod e-poruka u formatu običnog teksta, postoji prelom reda i prazan red koji se automatski dodaje posle prefiksa, kao i prazan red koji se automatski dodaje ispred isečka kôda sufiksa. Ovo je zbog toga da bi se osiguralo da se sufiks i prefiks ne lepe direktno na telo e-pošte.';
$string['emailbrandingpitfallsli5'] = 'U e-porukama u HTML formatu, prefiks i sufiks se direktno dodaju ispred i iznad tela e-poruke. Ovo je zbog toga kako bi se obezbedilo da možete lako da radite sa HTML oznakama. Međutim, moraćete sami da vodite računa o svim razmacima oko tela poruke.';
$string['emailbrandingpitfallsli6'] = 'U e-porukama u HTML formatu, možete otvoriti HTML oznaku u isečku kôda prefiksa, i bez problema zatvorite HTML oznaku u isečku kôda sufiksa. Samo vodite računa da kreirate ispravan HTML.';
$string['emailbrandingtab'] = 'Brendiranje e-pošte';
$string['emailbrandingtextdemobody'] = 'Telo e-poruke počinje ovde.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

Telo e-poruke se završava ovde.';
$string['emailbrandingtextheading'] = 'Pregled e-poruke u formatu običnog teksta';
$string['emailbrandingtextintro'] = 'Ovo je pregled e-poruke u formatu običnog teksta, kreirane na osnovu brendirajućih prefiksa i sufiksa, koja je trenutno podešena u jezičkom paketu.';
$string['emailbrandingtextnopreview'] = 'Do sada, e-poruke u formatu običnog teksta teksta nisu bili prilagođeni u okviru ove funkcije. E -poruke će biti sastavljane i slate normalno.';
$string['enableaboutussetting'] = 'Omogući stranicu \'O nama\'';
$string['enableaccessibilitydeclarationsetting'] = 'Omogućite stranicu sa deklaracijom o pristupačnosti';
$string['enableaccessibilitydeclarationsetting_desc'] = 'Sa ovim podešavanjem možete da omogućite stranicu sa deklaracijom o pristupačnosti. Ponašaće se baš kao <a href="{$a->url}">druge statične stranice</a> u temi Boost Union.';
$string['enableaccessibilitysupportfooterbuttonsetting'] = 'Omogućite dugme u podnožju za pristup stranici za podršku pristupačnosti';
$string['enableaccessibilitysupportfooterbuttonsetting_desc'] = 'Sa ovim podešavanjem možete da dodate link ka stranici za podršku pristupačnosti kao plutajuću ikonicu za pristupačnost iznad ikonice u podnožju stranice (znak pitanja).';
$string['enableaccessibilitysupportsetting'] = 'Omogućite stranicu za podršku pristupačnosti';
$string['enableaccessibilitysupportsetting_desc'] = 'Sa ovim podešavanjem možete da omogućite stranicu za podršku pristupačnosti. Ponašaće se baš kao <a href="{$a->url}">Moodle osnovna stranica za podršku</a> u temi Boost Union.';
$string['enablebuiltinsnippets'] = 'Omogučite ugrađene isečke kôda';
$string['enablebuiltinsnippets_desc'] = 'Sa ovim podešavanjem možete da omogućite ili onemogućite ugrađene SCSS isečke kôda koji se isporučuju sa bazom kôdova Boost Union teme. Ako onemogućite ovo podešavanje, svi ugrađeni SCSS isečci se ignorišu i nikada se ne dodaju u SCSS stek.';
$string['enablecontactsetting'] = 'Omogući stranicu za kontakt';
$string['enablefooterbutton'] = 'Omogući ”podnožje stranice”';
$string['enablefooterbutton_desc'] = 'Pod ”podnožjem stranice” se misli na krug koji sadrži znak pitanja na dnu stranice.<br /> Nakon klika na ovaj znak pitanja korisniku se pojavljuje mali preklapajući prozor. Zavisno od konfiguracije sajta Moodle prikazuje nekoliko linkova (poput ”Dokumentacija za ovu stranicu” ili ”Kratak pregled podataka koji se čuvaju”).<br /> Sa ovim podešavanjem možete da kontrolišete da li ćete prikazati ili sakriti dugme u podnožju na dnu stranice.';
$string['enablefooterbuttonboth'] = 'Omogući na stonom računaru, tabletu i mobilnom telefonu';
$string['enablefooterbuttondesktop'] = 'Omogući samo na stonom računaru i tabletu, sakrij na mobilnom telefonu (nepromenjeno, kao u inicijalnoj Moodle instalacija)';
$string['enablefooterbuttonhidden'] = 'Sakrij na svim uređajima';
$string['enablefooterbuttonmobile'] = 'Omogući samo na mobilnom telefonu, sakrij na stonom računaru i tabletu';
$string['enablehelpsetting'] = 'Omogući stranicu za pomoć';
$string['enableimprintsetting'] = 'Omogući impresum';
$string['enablemaintenancesetting'] = 'Omogući stranicu sa informacijama o održavanju';
$string['enableofferssetting'] = 'Omogući stranicu sa ponudama';
$string['enablepage1setting'] = 'Omogući generičku stranicu 1';
$string['enablepage2setting'] = 'Omogući generičku stranicu 2';
$string['enablepage3setting'] = 'Omogući generičku stranicu 3';
$string['enableuploadedsnippets'] = 'Omogući otpremljene isečke kôda';
$string['enableuploadedsnippets_desc'] = 'Sa ovim podešavanjem možete da omogućite ili onemogućite otpremanje SCSS isečaka kôdova ovde u podešavanjima Boost Union teme. Ako onemogućite ovo podešavanje, otpremanje SCSS isečaka nije moguće i svi prethodno otpremljeni SCSS isečci se ignorišu i nikada se ne dodaju u SCSS stek.';
$string['error:infobannerdismissnonotdismissible'] = 'Dati info baner se ne može odbaciti';
$string['error:infobannerdismissnonotvalid'] = 'Navedeni broj info banera nije ispravan';
$string['error:infobannerdismissnonotvalidnotset'] = 'Ova instanca Boost Union grafičke teme ili nije nadograđena sa izdanja starijeg od Boost Union v5.0 ili su nove podrazumevane vrednosti za ulogu gosta već obrađene. Ovde nema šta da se radi.';
$string['error:smartmenusmenuitemnotfound'] = 'Stavka u pametnom meniju nije pronađena';
$string['error:smartmenusmenunotfound'] = 'Pametni meni nije pronađen';
$string['extscssgithubfilepath_example'] = 'Primer: ako možete da vidite datoteku na svom Github nalogu na https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss, putanja datoteke će biti <em>/extscss.scss</em>.';
$string['extscssgithubpostfilepath'] = 'Putanja eksterne Post SCSS Github datoteke';
$string['extscssgithubpostfilepath_desc'] = 'Putanja unutar privatnog Github repozitorijuma gde se nalazi Post SCSS datoteka.';
$string['extscssgithubprefilepath'] = 'Putanja eksterne Pre SCSS Github datoteke';
$string['extscssgithubprefilepath_desc'] = 'Putanja unutar privatnog Github repozitorijuma gde se nalazi Pre SCSS datoteka.';
$string['extscssgithubrepo'] = 'Eksterni SCSS Github API repozitorijum';
$string['extscssgithubrepo_desc'] = 'Privatni Github repozitorijum gde se naalze SCSS datoteke';
$string['extscssgithubrepo_example'] = 'Primer: ako možete da vidite datoteku na svom Github nalogu na https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss, repozitorijum će biti <em>moodle-theme_boost_union-extscsstest</em>.';
$string['extscssgithubtoken'] = 'Eksterni SCSS Github API token';
$string['extscssgithubtoken_desc'] = 'Github API token koji će se koristiti za preuzimanje SCSS kôda iz datog privatnog Github repozitorijuma.';
$string['extscssgithubtoken_docs'] = 'Idite na <a href="https://github.com/settings/tokens">podešavanja Github tokena</a> kako biste generisali API token i videli zvaničnu dokumentaciju';
$string['extscssgithubuser'] = 'Eksterni korisnik SCSS Github API-ja';
$string['extscssgithubuser_desc'] = 'Korisnik Github API-ja ili organizacija koja poseduje privatni Github repozitorijum.';
$string['extscssgithubuser_example'] = 'Primer: ako možete da vidite datoteku na svom Github nalogu na https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss, korisnik će biti <em>moodle-an-hochschulen</em>.';
$string['extscssheading'] = 'Eksterni SCSS';
$string['extscssheading_desc'] = 'Pored gore navedenih podešavanja neobrađenog SCSS-a, Boost Union može učitati SCSS iz eksternog izvora. Uključen je pre SCSS kôda koji je gore definisan što znači da možete upravljati centralizovanom eksternom SCSS bibliotekom i još uvek je možete menjati lokalnim SCSS dodacima.';
$string['extscssheading_drop'] = 'Ako Boost Union ne može da preuzme eksternu SCSS datoteku iz bilo kog razloga tema će jednostavno ignorisati eksternu SCSS datoteku kako bi se izbegli svi potencijalni problemi.';
$string['extscssheading_instr'] = 'Uputstva:';
$string['extscssheading_prepost'] = 'Baš kao i gornja podešavanja neobrađenog SCSS-a, eksterni SCSS je podeljen na dva dela: Pre i Post SCSS. Pre SCSS može se koristiti za inicijalizaciju SCSS promenljivih, Post SCSS se koristi za vaš trenutni SCSS kôd.';
$string['extscssheading_sources'] = 'Možete da konfigurišete Boost Union da preuzima eksternu SCSS datoteku ili sa javne URL adrese za preuzimanje (kojoj će se pristupiti i preuzeti pomoću cURL zahteva bez autentifikacije) ili iz privatnog Github repozitorijum (kome će se pristupati i datoteka preuzeti pomoću Github API tokena).';
$string['extscssheading_structure'] = 'Eksterni SCSS mora biti u formatu datoteke običnog teksta, bez ikakvih zaglavlja ili podnožja, koja sadrži samo SCSS kôd.';
$string['extscssheading_task'] = 'Постоји <a href="{$a}"> planirani zadatak theme_boost_union\\task\\purge_cache</a> koji je standardno onemogućen, ali koji možete da omogućite ako želite da Boost Union povremeno preuzima i sastavlja spoljni SCSS kôd.';
$string['extscsssource'] = 'Eksterni SCSS izvor';
$string['extscsssource_desc'] = 'Izaberite tip izvora sa kojeg želite da preuzmete spoljni SCSS.';
$string['extscsssourcedownload'] = 'Javna URL adresa za preuzimanje';
$string['extscsssourcegithub'] = 'Privatni Github repozitorijum';
$string['extscsssourcenone'] = 'Nijedan';
$string['extscssurlpost'] = 'URL adresa za preuzimanje eksterne Post SCSS datoteke';
$string['extscssurlpost_desc'] = 'Javna URL adresa za preuzimanje sa koje treba preuzeti eksternu Post SCSS datoteku';
$string['extscssurlpre'] = 'URL adresa za preuzimanje eksterne Pre SCSS datoteke';
$string['extscssurlpre_desc'] = 'Javna URL adresa za preuzimanje sa koje treba preuzeti eksternu Pre SCSS datoteku';
$string['extscssvalidationsetting'] = 'Validacija eksternog SCSS kôda';
$string['extscssvalidationsetting_desc'] = 'Ako je ovo podešavanje omogućeno, proverava se ispravnost eksternog SCSS kôda tj. da li se isti može kompajlirati pre nego što bude dodat u SCSS stek. Eksterni SCSS kôd koji ne može da se kompajlira prećutno će biti ignorisan i neće se koristiti. Ipak , provera ispravnosti se izvodi isključivo na eksternom SCSS kôdu, tj. ispravnost se neće proveravati kada se radi o kombinovanom SCSS steku koji je rezultat integracije eksternog SCSS kôda. Drugim rečima, sve dok koristite SCSS promenljive iz osnovne Moodle instalacije ili Bootstrapa u svom eksternom SCSS kôdu, morate da isključite proveru ispravnosti i da se sami uverite da je SCSS kôd ispravan.';
$string['faviconheading'] = 'Favikonica';
$string['faviconheading_desc'] = 'Imajte na umu: Boost Union ima sopstveno polje za postavljanje favikonice i ne koristi favikonicu iz <a href="{$a}">podešavanja favikonice osnovne instalacije Moodlea</a>.<br />Boost Union vam posebno omogućava da zaobiđete postavljenu favikonicu u okviru njegovih vizuelnih identiteta .';
$string['faviconsetting'] = 'Favikonica';
$string['faviconsetting_desc'] = 'Ovde možete da postavite prilagođenu sliku (u .ico ili .png formatu) koju će veb čitač prikazati kao favikonicu vašeg Moodle sajta. Ako ne postavite svoju prilagođenu favikonicu, koristiće se standardna Moodle favikonica.';
$string['flavoursactivityiconcoloradministration'] = 'Boja ikonice aktivnosti za ”Administracija”';
$string['flavoursactivityiconcoloradministration_help'] = 'Sa ovim podešavanjem, vizuelni identitet će zameniti boju ikonice aktivnosti "Administracija" koja je konfigurisana u podešavanjima izgleda Boost Union teme.';
$string['flavoursactivityiconcolorassessment'] = 'Boja ikonice aktivnosti za ”Procena”';
$string['flavoursactivityiconcolorassessment_help'] = 'Sa ovim podešavanjem, vizuelni identitet će zameniti boju ikonice aktivnosti "Procena" koja je konfigurisana u podešavanjima izgleda Boost Union teme.';
$string['flavoursactivityiconcolorcollaboration'] = 'Boja ikonice aktivnosti za ”Saradnja”';
$string['flavoursactivityiconcolorcollaboration_help'] = 'Sa ovim podešavanjem, vizuelni identitet će zameniti boju ikonice aktivnosti "Saradnja" koja je konfigurisana u podešavanjima izgleda Boost Union teme.';
$string['flavoursactivityiconcolorcommunication'] = 'Boja ikonice aktivnosti za ”Komunikacija”';
$string['flavoursactivityiconcolorcommunication_help'] = 'Sa ovim podešavanjem, vizuelni identitet će zameniti boju ikonice aktivnosti "Komunikacija" koja je konfigurisana u podešavanjima izgleda Boost Union teme.';
$string['flavoursactivityiconcolorcontent'] = 'Boja ikonice aktivnosti za ”Sadržaj”';
$string['flavoursactivityiconcolorcontent_help'] = 'Sa ovim podešavanjem, vizuelni identitet će zameniti boju ikonice aktivnosti "Sadržaj" koja je konfigurisana u podešavanjima izgleda Boost Union teme.';
$string['flavoursactivityiconcolorinteractivecontent'] = 'Boja ikonice aktivnosti za "Interaktivni sadržaj"';
$string['flavoursactivityiconcolorinteractivecontent_help'] = 'Sa ovim podešavanjem, vizuelni identitet će zameniti boju ikonice aktivnosti "Interaktivni sadržaj" koja je konfigurisana u podešavanjima izgleda Boost Union teme.';
$string['flavoursactivityiconcolorinterface'] = 'Boja ikonice aktivnosti za ”Interfejs”';
$string['flavoursactivityiconcolorinterface_help'] = 'Sa ovim podešavanjem, vizuelni identitet će zameniti boju ikonice aktivnosti "Interfejs" koja je konfigurisana u podešavanjima izgleda Boost Union teme.';
$string['flavoursappliesto'] = 'Primenjuje se na';
$string['flavoursapplytocategories'] = 'Primenite na kategorije kurseva';
$string['flavoursapplytocategories_help'] = 'Ovde definišete da li ovaj vizuelni identitet treba primeniti na kategorije kurseva.';
$string['flavoursapplytocategories_ids'] = 'Kategorije kurseva';
$string['flavoursapplytocategories_ids_help'] = 'Ovde definišete jednu ili više zasebnih kategorija kurseva na koje treba primeniti ovaj vizuelni identitet. Čim se prikazana Moodle stranica nalazi unutar jedne od konfigurisanih kategorija kursa, vizuelni identitet će biti primenjen.';
$string['flavoursapplytocohorts'] = 'Primenite na kohorte';
$string['flavoursapplytocohorts_help'] = 'Ovde definišete da li ovaj vizuelni identitet treba primeniti na kohorte.';
$string['flavoursapplytocohorts_ids'] = 'Kohorte';
$string['flavoursapplytocohorts_ids_help'] = 'Ovde definišete jednu ili više zasebnih kohorti na koje treba primeniti ovaj vizuelni identitet. Čim je korisnik član jedne od konfigurisanih kohorti, vizuelni identitet će biti primenjen.<br /><br />Imajte u vidu da, ako definišete više od jedne kohorte, nema potrebe da korisnik bude član svih kohorti u isto vreme.<br /><br />Takođe, imajte na umu da se u trenutnom stanju implementacije kohorte tretiraju kao da su sistemske.';
$string['flavoursbackgroundimage'] = 'Pozadinska slika';
$string['flavoursbackgroundimage_help'] = 'Sa ovim podešavanjem vizuelni identitet će zameniti pozadinsku sliku koja je konfigurisana u podešavanjima izgleda teme Boost Union.';
$string['flavoursbackgroundimageposition'] = 'Položaj pozadinske slike';
$string['flavoursbackgroundimageposition_help'] = 'Sa ovim podešavanjem, vizuelni identitet će zameniti položaj pozadinske slike koji je konfigurisan u podešavanjima izgleda Boost Union teme.';
$string['flavoursbacktooverview'] = 'Nazad na pregled vizuelnih identiteta';
$string['flavoursbootstrapcolordanger'] = 'Bootstrap boja za "Opasnost"';
$string['flavoursbootstrapcolordanger_help'] = 'Sa ovim podešavanjima vizuelni identitet će zameniti Bootstrap boju ”Opasnost” koja je konfigurisana u podešavanjima izgleda Boost Union teme.';
$string['flavoursbootstrapcolorinfo'] = 'Bootstrap boja za "Info"';
$string['flavoursbootstrapcolorinfo_help'] = 'Sa ovim podešavanjima vizuelni identitet će zameniti Bootstrap boju ”Info” koja je konfigurisana u podešavanjima izgleda Boost Union teme.';
$string['flavoursbootstrapcolorsuccess'] = 'Bootstrap boja za "Uspeh"';
$string['flavoursbootstrapcolorsuccess_help'] = 'Sa ovim podešavanjima vizuelni identitet će zameniti Bootstrap boju ”Uspeh” koja je konfigurisana u podešavanjima izgleda Boost Union teme.';
$string['flavoursbootstrapcolorwarning'] = 'Bootstrap boja za "Upozorenje"';
$string['flavoursbootstrapcolorwarning_help'] = 'Sa ovim podešavanjima vizuelni identitet će zameniti Bootstrap boju ”upozorenje” koja je konfigurisana u podešavanjima izgleda Boost Union teme.';
$string['flavoursbrandcolor'] = 'Boja brenda';
$string['flavoursbrandcolor_help'] = 'Sa ovim podešavanjima vizuelni identitet će zameniti boju brenda koja je konfigurisana u podešavanjima izgleda Boost Union teme.';
$string['flavourscreateflavour'] = 'Kreiraj vizuelni identitet';
$string['flavourscustomscss'] = 'Neobrađeni SCSS';
$string['flavourscustomscss_help'] = 'Sa ovim podešavanjem, možete napisati prilagođeni SCSS za vizuelni identitet. On će biti pridodat CSS kôdu koji se šalje pretraživaču čim se vizuelni identitet primeni.';
$string['flavourscustomscsspre'] = 'Neobrađeni početni SCSS';
$string['flavourscustomscsspre_help'] = 'Sa ovim podešavanjem, možete napisati prilagođeni početni SCSS za vizuelni identitet. On će se koristiti prilikom kreiranja CSS kôda koji se šalje pretraživaču čim se vizuelni identitet primeni.';
$string['flavoursdelete'] = 'Obriši';
$string['flavoursdeleteconfirmation'] = 'Da li zaista želite da obrišete vizuelni identitet <em>{$a}</em>?';
$string['flavoursdeleteflavour'] = 'Obriši vizuelni identitet';
$string['flavoursdescription'] = 'Opis';
$string['flavoursdescription_help'] = 'Opis vizuelnog identiteta koristi se interno samo kako bi vam omogućio da identifikujete određeni vizuelni identitet na spisku.';
$string['flavoursedit'] = 'Uredi';
$string['flavourseditflavour'] = 'Uredi vizuelni identitet';
$string['flavoursfavicon'] = 'Favikonica';
$string['flavoursfavicon_help'] = 'Sa ovim podešavanjem, vizuelni identitet će zameniti favikonicu koja je konfigurisana u podešavanjima izgleda Boost Union teme.';
$string['flavoursflavours'] = 'Vizuelni identiteti';
$string['flavoursgeneralsettings'] = 'Opšta podešavanja';
$string['flavoursincludesubcategories'] = 'Uključite potkategorije';
$string['flavoursincludesubcategories_help'] = 'Ako je označeno, vizuelni identitet će biti primenjen i na potkategorije izabranih kategorija.';
$string['flavourslogo'] = 'Logo';
$string['flavourslogo_help'] = 'Sa ovim podešavanjem, vizuelni identitet će zameniti logotip koji je konfigurisan u podešavanjima izgleda teme Boost Union.';
$string['flavourslogocompact'] = 'Kompaktan logo';
$string['flavourslogocompact_help'] = 'Sa ovim podešavanjem, vizuelni identitet će zameniti logotip koji je konfigurisan u podešavanjima izgleda teme Boost Union.';
$string['flavoursnavbarcolor'] = 'Boja navigacione trake';
$string['flavoursnavbarcolor_help'] = 'Sa ovim podešavanjem, vizuelni identitet će zameniti boju navigacione trake koja je konfigurisana u podešavanjima izgleda teme Boost Union.';
$string['flavoursnothingtodisplay'] = 'Još uvek nije kreiran nijedan vizuelni identitet. Molimo vas da napravite svoj prvi vizuelni identitet kako biste pokrenuli stvari.';
$string['flavoursnotificationcreated'] = 'Vizuelni identitet je uspešno kreiran';
$string['flavoursnotificationdeleted'] = 'Vizuelni identitet je uspešno obrisan';
$string['flavoursnotificationedited'] = 'Vizuelni identitet je uspešno editovan';
$string['flavoursoverview_desc'] = '<p>Vizuelni identiteti Boost Union tema nude mogućnost da izmenite  pojedina podešavanja izgleda Moodlea u određenim kontekstima. Na ovoj stranici možete kreirati vizuelne identitete i upravljati njima.</p><p>Unutar svakog identiteta definišete da li ga treba primeniti na određene kategorije kurseva ili određene kohorte. Nakon toga, tokom svakog prikazivanja Moodle stranice, Boost Union proverava da li je vizuelni identitet primenljiv. Imajte na umu da se za svako prikazivanje Moodle stranice primenjuje samo prvi odgovarajući vizuelni identitet sa spiska, a preostali se zanemaruju. Stoga je redosled vizuelnih identiteta na ovoj stranici ključan.</p><p>Takođe imajte na umu da se nakon svake promene koju napravite u skupu vizuelnih
 identiteta, keš teme čisti. Ovo je neophodno kako biste bili sigurni da su veb čitaču sva podešavanja isporučena propisno i ažurno.</p>';
$string['flavourspreview'] = 'Pregled';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Pregled vizuelnog identiteta';
$string['flavourstitle'] = 'Naslov';
$string['flavourstitle_help'] = 'Naziv vizuelnog identiteta se koristi samo interno, kako bi vam omogućio da ga dokumentujete na spisku vizuelnih identiteta.';
$string['footerheading'] = 'Podnožje';
$string['footerregionsheading'] = 'Regioni u podnožju';
$string['footerregionsheading_desc'] = 'Regioni u podnožju mogu ne samo da budu omogućeni pomoću gore navedenih podešavanja rasporeda, već se njihov izgled može i prilagoditi.';
$string['footersuppresschatsetting'] = 'Potisnite link \'Razgovarajte sa učesnicima kursa\'';
$string['footersuppresschatsetting_desc'] = 'Sa ovim podešavanjem, možete u potpunosti da sprečite da se link \'Razgovarajte sa učesnicima kursa\' pojavljuje u podnožju stranice. U suprotnom, on će se pojaviti u okviru kurseva čim se u podešavanjima kursa doda soba za komunikaciju (pričaonica).';
$string['footersuppresscontactsetting'] = 'Potisnite link \'Kontaktirajte podršku sajta\'';
$string['footersuppresscontactsetting_desc'] = 'Sa ovim podešavanjem, možete u potpunosti da sprečite da se link \'Kontaktirajte podršku sajta\' pojavljuje u podnožju stranice. U suprotnom, on će se pojaviti ako je podešen <a href ="{$ a->url}">link \'Kontaktirajte podršku sajta\'</a>.';
$string['footersuppresshelpsetting'] = 'Potisnite link \'Dokumentacija za ovu stranicu\'';
$string['footersuppresshelpsetting_desc'] = 'Sa ovim podešavanjem, možete u potpunosti da sprečite da se link \'Dokumentacija za ovu stranicu\' pojavljuje u podnožju stranice. U suprotnom, on će se pojaviti ako je podešena <a href ="{$ a->url}">link ka Moodle dokumentaciji</a>.';
$string['footersuppressiconssetting'] = 'Sprečite pojavu ikonica ispred linkova u podnožju stranice';
$string['footersuppressiconssetting_desc'] = 'Sa ovim podešavanje možete potpuno sprečiti da se u podnožju stranice pojavljuju ikonice ispred linkova. Link \'Dokumentacija za ovu stranicu\' ima ikonicuu knjige, dok link \'Servisi i podrška\' ima ikonicu pojasa za spasavanje itd.';
$string['footersuppresslogininfosetting'] = 'Potisnite informacije o prijavljenom korisniku';
$string['footersuppresslogininfosetting_desc'] = 'Sa ovim podešavanjem, možete u potpunosti da sprečite da se informacije o prijavljenom korisniku pojavljuje u podnožju stranice. U suprotnom, ove informacije će prikazati link ka korisnikovom profilu i ka stranici za odjavu.';
$string['footersuppresspoweredsetting'] = 'Potisnite link \'Pokreće Moodle\'';
$string['footersuppresspoweredsetting_desc'] = 'Sa ovim podešavanjem, možete u potpunosti da sprečite da se link \'Pokreće Moodle\' pojavljuje u podnožju stranice. U suprotnom, on će prikazati informaciju da ovaj sajt pokreće Moodle, kao i link ka Moodle HQ.';
$string['footersuppressservicessetting'] = 'Potisnite link \'Servisi i podrška\'';
$string['footersuppressservicessetting_desc'] = 'Sa ovim podešavanjem, možete u potpunosti da sprečite da se link \'Servisi i podrška\' pojavljuje u podnožju stranice. U suprotnom, administratorima će biti prikazan <a href ="{$ a->url}">link \'Servisi i podrška\'</a>.';
$string['footersuppressstandardfooter'] = 'Potisnite ispis u podnožju od strane dodatka \'{$a}\'';
$string['footersuppressstandardfooter_desc'] = 'Sa ovim podešavanjem, možete u potpunosti da sprečite da se u podnožju stranice pojavljuje ispis dodatka \'{$a}\'. Dodaci (čak i oni koji su deo osnovne Moodle instalaciji) mogu prikazati dodatni sadržaj u podnožju primenom posebne funkcije. Ovaj dodatak je implementirao ovu funkciju i može dodati sadržaj u podnožje stranice u određenim okolnostima.<br />Imajte na umu: zbog načina na koji je implementirana ova funkcija sprečavanja, sama promena podešavanje možda neće odmah biti vidljiva, pre nego što se učita druga stranica, a nakon što se promene sačuva.';
$string['footersuppressstandardfootercore'] = 'Potisnite ispis u podnožju od strane komponente osnovne Moodle instalacije \'{$a}\'';
$string['footersuppressstandardfootercore_desc'] = 'Sa ovim podešavanjem, možete u potpunosti da sprečite da se u podnožju stranice pojavljuje ispis od strane osnovne komponente \'{$a}\'. Osnovne komponente mogu dodati sadržaj u podnožje stranice primenom posebne funkcije. Ova osnovna komponenta je implementirala ovu funkciju i može dodati sadržaj u podnožje u određenim okolnostima.';
$string['footersuppressthemeswitchsetting'] = 'Potisnite linkove za promenu grafičke teme';
$string['footersuppressthemeswitchsetting_desc'] = 'Sa ovim podešavanjem, možete u potpunosti da sprečite da se u podnožju stranice pojavljuje linkovi za promenu grafičke teme. Osnovni sistem za grafičke teme koje su namenjene određenim uređajima, uklonjen je u Moodle verziji 4.3, ali kako su izlazne rutine su još uvek tu, budite pažljivi.';
$string['footersuppressusertoursetting'] = 'Potisnite link \'Resetujte korisnički vodič na ovoj stranici\'';
$string['footersuppressusertoursetting_desc'] = 'Sa ovim podešavanjem, možete u potpunosti da sprečite da se link \'Resetujte korisnički vodič na ovoj stranici\' pojavljuje u podnožju stranice. U suprotnom link će dati mogućnost da se resetuje korisinički vodič na određenoj stranici.';
$string['footertab'] = 'Podnožje';
$string['footnoteheading'] = 'Fusnota';
$string['footnotesetting'] = 'Fusnota';
$string['footnotesetting_desc'] = 'Šta god da dodate u ovo tekstualno polje, sadržaj će biti prikazan na kraju stranice, u podnožju (ne u plutajućem podnožju) na svakoj stranici koja koristi rasporede "drawers", "columns2" ili "login". Sadržaj u ovom polje mogu biti, na primer autorska prava, uslovi korišćenja ili naziv vaše organizacije.<br/> Ako želite ponovo da uklonite fusnotu, samo obrišite sadržaj tekstualnog polja.';
$string['forguestsonly'] = 'Samo za goste i neprijavljene korisnike';
$string['githubissueslink'] = '<a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github issues</a>';
$string['h5pcontentmaxwidthsetting'] = 'Maksimalna širina H5P banke sadržaja';
$string['h5pcontentmaxwidthsetting_desc'] = 'Sa ovim podešavanjem, možete izmeniti širinu Moodle H5P banke sadržaja kursa bez ručnih modifikacija SCSS stilova. Ova širina se koristi za H5P editor unutar banke sadržaja. Ona se <em>ne</em> koristi za širinu H5P aktivnosti. Standardno, Moodle koristi maksimalnu širinu H5P banke sadržaja od 960 piksela. Možete da unesete druge vrednosti zasnovane na pikselima kao što je 1200 piksela, ali takođe možete da unesete vrednost zasnovanu na procentima kao što je 100% ili vrednost širine okvira za prikaz (viewport) kao što je 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Sadržaj stranice za pomoć';
$string['helpcontentsetting_desc'] = 'U ovom podešavanju možete dodati sadržaj u formatu obogaćenog teksta koji će biti prikazan na stranici za pomoć.';
$string['helpdisabled'] = 'Stranica za pomoć je onemogućena na ovom sajtu. Ovde nema šta da se vidi.';
$string['helpheading'] = 'Pomoć';
$string['helplinkpositionboth'] = 'Dodajte link ka stranici za pomoć u fusnotu i na ikonicu u podnožju stranice (znak pitanja)';
$string['helplinkpositionfooter'] = 'Dodajte link ka stranici za pomoć na ikonicu u podnožju stranice (znak pitanja)';
$string['helplinkpositionfootnote'] = 'Dodajte link ka stranici za pomoć u fusnotu';
$string['helplinkpositionnone'] = 'Nemojte automatski prikazivati link ka stranici za pomoć';
$string['helplinkpositionsetting'] = 'Pozicija linka ka stranici za pomoć';
$string['helplinkpositionsetting_desc'] = 'U ovom podešavanju možete da konfigurišete da li će se link ka stranici za pomoć automatski dodati na Moodle stranicu. Ako ne želite da automatski prikazujete link, možete ručno dodati link ka {$a->url} sa bilo kog mesta u Moodleu.';
$string['helppagetitledefault'] = 'Pomoć';
$string['helppagetitlesetting'] = 'Naslov stranice za pomoć';
$string['helppagetitlesetting_desc'] = 'U ovom podešavanju možete definisati naslov stranice za pomoć. Ovaj tekst će se koristiti i kao tekst linka ka stranici za pomoći ako u skladu sa tim konfigurišete podešavanje \'Pozicija linka ka stranici za pomoć\'.';
$string['hidenodesprimarynavigationsetting'] = 'Sakrij čvorove u primarnoj navigaciji';
$string['hidenodesprimarynavigationsetting_desc'] = 'Sa ovim podešavanjem možete da sakrijete jedan ili više čvorova iz primarne navigacije.<br /><br />
Imajte na umu: ovde možete jednostavno ukloniti navigacione čvorove. Ali ako želite da dodate prilagođene navigacione čvorove, razmislite o tome da upotrebite <a href ="{$ a->url}">Boost Union\'s smart menu functionality</a>.';
$string['imageposition_center_bottom'] = 'U sredini horizontalno, vertikalno dole';
$string['imageposition_center_center'] = 'U sredini i horizontalno i vertikalno';
$string['imageposition_center_top'] = 'U sredini horizontalno, vertikalno gore';
$string['imageposition_left_bottom'] = 'Levo horizontalno, vertikalno dole';
$string['imageposition_left_center'] = 'Levo horizontalno, vertikalno u sredini';
$string['imageposition_left_top'] = 'Levo horizontalno, vertikalno dole';
$string['imageposition_right_bottom'] = 'Desno horizontalno, vertikalno dole';
$string['imageposition_right_center'] = 'Levo horizontalno, vertikalno u sredini';
$string['imageposition_right_top'] = 'Desno horizontalno, vertikalno gore';
$string['imprintcontentsetting'] = 'Sadržaj impresuma';
$string['imprintcontentsetting_desc'] = 'U ovom podešavanju možete dodati sadržaj u formatu obogaćenog teksta koji će biti prikazan na stranici sa impresumom.';
$string['imprintdisabled'] = 'Stranica sa impresumom je onemogućena na ovom sajtu. Ovde nema šta da se vidi.';
$string['imprintheading'] = 'Impresum';
$string['imprintlinkpositionboth'] = 'Dodajte link ka stranici sa impresumom u fusnotu i na ikonicu u podnožju stranice (znak pitanja)';
$string['imprintlinkpositionfooter'] = 'Dodajte link ka stranici sa impresumom na ikonicu u podnožju stranice (znak pitanja)';
$string['imprintlinkpositionfootnote'] = 'Dodajte link ka stranici sa impresumom u fusnotu';
$string['imprintlinkpositionnone'] = 'Nemojte automatski prikazivati link ka stranici sa impresumom';
$string['imprintlinkpositionsetting'] = 'Pozicija linka ka stranici sa impresumom';
$string['imprintlinkpositionsetting_desc'] = 'U ovom podešavanju možete da konfigurišete da li će se link ka stranici sa impresumom automatski dodati na Moodle stranicu. Ako ne želite da automatski prikazujete link, možete ručno dodati link ka {$a->url} sa bilo kog mesta u Moodleu.';
$string['imprintpagetitledefault'] = 'Impresum';
$string['imprintpagetitlesetting'] = 'Naslov stranice sa impresumom';
$string['imprintpagetitlesetting_desc'] = 'U ovom podešavanju možete definisati naslov stranice sa impresumom. Ovaj tekst će se koristiti i kao tekst linka ka stranici sa impresumom ako u skladu s tim konfigurišete podešavanje \'Pozicija linka ka stranici sa impresumom\'.';
$string['infobannerbsclasssetting'] = 'Bootstrap klasa info banera {$a->no}';
$string['infobannerbsclasssetting_desc'] = 'Sa ovim podešavanjem, možete da izaberete Bootstrap stil sa kojim će info baner {$a->no} biti prikazan. Ako izaberete opciju \'Bez Bootstrap boje\', info baner će biti prikazan bez bilo kakve Bootstrap boje, što vam daje slobodu da sami stilizujete baner u editoru teksta.';
$string['infobannerclose'] = 'Zatvori';
$string['infobannercontentsetting'] = 'Sadržaj info banera {$a->no}';
$string['infobannercontentsetting_desc'] = 'Ovde unosite informacije koje treba da budu prikazane u info baneru {$a->no}.';
$string['infobannerdismissconfirm'] = 'Da li zaista želite da resetujete vidljivost info banera {$a->no} i da ga ponovo prikažete svim korisnicima koji su ga prethodno odbacili?';
$string['infobannerdismissfail'] = 'Resetovanje vidljivosti info banera {$a->no} nije uspelo za najmanje jednog korisnika';
$string['infobannerdismissiblesetting'] = 'Info baner {$a->no} se može odbaciti';
$string['infobannerdismissiblesetting_desc'] = 'Sa ovim podešavanjem možete učiniti da info baner {$a->no} može da se odbaci. Ako korisnik klikne na dugme  X u info baneru, baner će za ovog korisnika biti trajno sakriven. Vidljivost se nikako ne resetuje automatski, čak i ako promenite sadržaj info banera. Ako želite da resetujete vidljivost info banera, kliknite na dugme \'Resetuj vidljivost\'.';
$string['infobannerdismissreset'] = 'Resetuj vidljivost odbačenog info banera';
$string['infobannerdismissresetbutton'] = 'Resetuj vidljivost info banera {$a->no}';
$string['infobannerdismisssuccess'] = 'Vidljivost info banera {$a->no} je resetovana';
$string['infobannerenabledsetting'] = 'Omogući info baner {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Sa ovim podešavanjem možete omogućiti info baner {$a->no}.';
$string['infobannerendsetting'] = 'Vreme završetka prikazivanja info banera {$a->no}';
$string['infobannerendsetting_desc'] = 'Sa ovim podešavanjem možete da definišete do kada treba da bude prikazan info baner {$a->no}. Konfigurisano vreme se tretira kao vreme servera, a ne kao vreme korisnika.';
$string['infobannerheading'] = 'Info baner {$a->no}';
$string['infobannermodeperpetual'] = 'Trajno';
$string['infobannermodesetting'] = 'Režim prikaza info banera {$a->no}';
$string['infobannermodesetting_desc'] = 'Sa ovim podešavanjem možete da definišete da li info baner {$a->no} treba da bude trajni (koji se uvek prikazuje) ili vremenski ograničeni baner (koji se prikazuje samo u konfigurisanom vremenskom intervalu)';
$string['infobannermodetimebased'] = 'Vremenski kontrolisano';
$string['infobannerordersetting'] = 'Pozicija info banera {$a->no}';
$string['infobannerordersetting_desc'] = 'Sa ovim podešavanjem definišete poziciju info banera {$a->no}. Standardno, info baneri su poređani odozgo prema dole, kao što ih vidite na ovoj stranici sa podešavanjima. Međutim, sa ovim podešavanjem možete info baneru da dodelite drugu poziciju. Ako dodelite istu poziciju za dva ili više info banera, oni će biti ponovo poređani prema redosledu na ovoj stranici sa podešavanjima.';
$string['infobannerpageloginpage'] = 'Stranica za prijavu';
$string['infobannerpagessetting'] = 'Vrste stranica za prikaz banera sa informacijama {$a->no}';
$string['infobannerpagessetting_desc'] = 'Sa ovim podešavanjem, možete da izaberete vrste stranica na kojima info baner {$a->no} treba da bude prikazan.';
$string['infobannerstartsetting'] = 'Vreme početka prikazivanja info banera {$a->no}';
$string['infobannerstartsetting_desc'] = 'Sa ovim podešavanjem, možete da definišete od kada treba da bude prikazan info baner {$a->no}. Konfigurisano vreme se tretira kao vreme servera, a ne kao vreme korisnika.';
$string['infobannertab'] = 'Info baner';
$string['invalidurl'] = 'Data URL adresa je neispravna';
$string['javascriptdisabledhint'] = 'Nagoveštaj (hint) ako je JavaScript onemogućen';
$string['javascriptdisabledhint_desc'] = 'Sa ovim podešavanjem na vrhu Moodle stranice će se pojaviti nagoveštaj (hint) ako JavaScript nije omogućen. Ovo je posebno korisno jer nekoliko Moodle funkcija ne radi bez JavaScripta.';
$string['javascriptdisabledhinttext'] = 'JavaScript je onemogućen u vašem veb čitaču.<br />Mnoge funkcije Moodlea neće biti upotrebljive ili će izgledati kao da nisu ispravne.<br />Molimo vas da omogućite JavaScript da biste koristili sve funkcije Moodlea.';
$string['javascriptheading'] = 'JavaScript';
$string['linkstab'] = 'Linkovi';
$string['loginbackgroundimage'] = 'Pozadinske slike stranice za prijavu';
$string['loginbackgroundimage_desc'] = 'Slike koja će biti prikazana kao pozadina stranice za prijavu. Jedna od ovih slika će biti nasumično izabrana i prikazana kada korisnik pristupi stranici za prijavu. Proverite da se u nazivu datoteke ne koriste znakovi koji nisu ASCII, ukoliko želite da prikažete tekst za pozadinske slike stranice za prijavu.';
$string['loginbackgroundimagepositionsetting'] = 'Pozicija pozadinske slike stranice za prijavu';
$string['loginbackgroundimagepositionsetting_desc'] = 'Sa ovim podešavanjem kontrolišete položaj pozadinske slike stranice za prijavu u prozoru veb čitača. Prva vrednost je horizontalna, a druga vertikalna pozicija.';
$string['loginbackgroundimagesheading'] = 'Pozadinske slike stranice za prijavu';
$string['loginbackgroundimagetextsetting'] = 'Prikaži tekst za pozadinske slike stranice za prijavu';
$string['loginbackgroundimagetextsetting_desc'] = 'Sa ovim opcionim podešavanjem možete dodati tekst, npr. obaveštenje o autorskim pravima na pozadinske slike koje ste postavili. Ovaj tekst će se pojaviti na vrhu podnožja stranice za prijavu. Međutim, zbog veličine ekrana, tekst se prikazuje samo na ekranima većih veličina.<br/>
Svaki red se sastoji od identifikatora datoteke (naziv datoteke), teksta koji treba da se prikaže i boje teksta (elementi u redu su odvojeni vertikalnom crtom |). Svaku pojedinačni stavku u ovom podešavanju treba napisati u novom redu. <br/>
Na primer:<br/>
background-image-1.jpg|Copyright: CC0|dark<br/>
Kao boju teksta možete koristiti vrednosti "tamno" ili "svetlo".<br />
Možete definisati tekstove za proizvoljan broj vaših postavljenih pozadinskih slika stranice za prijavu. Tekstovi će biti dodati samo onim slikama koje odgovaraju njihovom nazivu datoteke sa identifikatorom navedenim u ovom podešavanju.';
$string['loginformheading'] = 'Obrazac za prijavu';
$string['loginformpositionsetting'] = 'Pozicija obrasca za prijavu';
$string['loginformpositionsetting_center'] = 'U centru';
$string['loginformpositionsetting_desc'] = 'Sa ovim podešavanjem možete optimizovati obrazac za prijavu tako da odgovara većem broju pozadinskih slika. Standardno, obrazac za prijavu se prikazuje u centru stranice za prijavu. Alternativno, možete da ga pomerite levo ili desno na stranici za prijavu kako bi se ostali delovi pozadinske slike jasno videli. Naravno, ovo podešavanje možete promeniti i ako pozadinska slika uopšte nije postavljena.';
$string['loginformpositionsetting_left'] = 'Levo';
$string['loginformpositionsetting_right'] = 'Desno';
$string['loginformtransparencysetting'] = 'Transparentnost obrasca za prijavu';
$string['loginformtransparencysetting_desc'] = 'Sa ovim podešavanjem, možete učiniti da obrazac za prijavu bude malo providan kako bi se pozadinska slika jasnije videla.';
$string['loginidpshowintrosetting'] = 'Uvodna informacija za prijavu putem IDP (provajdera identiteta)';
$string['loginidpshowintrosetting_desc'] = 'Sa ovim podešavanjem kontrolišete da li se uvodna informacija <em>\'{$a}\'</em> prikazuje iznad IDP dugmadi za prijavu ili ne. Standardno, uvodna informacija se prikazuje i korisnici će biti brzo obavešteni o tome čemu IDP dugmad služe. Ako onemogućite ovo podešavanje, IDP uvodna informacija je sakrivena. Ovo vam omogućava da obezbedite jednostavan interfejs za prijavu korisnika ako koristite samo spoljne provajdere identiteta kao što su OAuth2 ili OIDC.';
$string['loginlinkbuttonenabled'] = 'Prikaži link "Prijavi se" kao dugme';
$string['loginlinkbuttonenabled_desc'] = 'Sa ovim podešavanjem možete imati link "Prijava" na vrhu stranice prikazan kao dugme. Ovo može pomoći vašim korisnicima da prepoznaju činjenicu da već nisu prijavljeni.';
$string['loginlocalintro'] = 'Prijavite se sa svojim Moodle nalogom';
$string['loginlocalloginenablesetting'] = 'Lokalna prijava';
$string['loginlocalloginenablesetting_desc'] = 'Sa ovim podešavanjem kontrolišete da li se obrazac za lokalnu prijavu prikazuje na stranici za prijavu ili ne. Standardno, obrazac za lokalnu prijavu se prikazuje i korisnici se prijavljuju na sajt kao i obično. Ako onemogućite ovo podešavanje, obrazac za lokalnu prijavu je sakriven. Ovo vam omogućava da obezbedite samo dugmad za prijavu korisnika za spoljne provajdere identiteta kao što su OAuth2 ili OIDC.';
$string['loginlocalloginenablesetting_note'] = 'Imajte na umu - čim sakrijete lokalni obrazac za prijavu, rizikujete da se administratori više ne mogu prijaviti sa lokalnim nalogom ako postoji problem sa spoljnim provajderom identiteta. Isto važi i ako nisu omogućene nikakve druge metode provere identiteta osim ručne.<br />Da biste ipak dozvolili lokalnu prijavu u takvim slučajevima, automatski je obezbeđena <a href="{$a->url}">pomoćna stranica za lokalnu prijavu</a> (za više informacije pogledajte u nastavku). Molimo vas da obeležite ovu URL adresu kao svoju bezbednosnu mrežu.';
$string['loginlocalloginformhead'] = 'Lokalna prijava';
$string['loginlocalloginlocalnotdisabled'] = 'Nema potrebe da se prijavljujete na sistem ovde na ovoj pomoćnoj stranici za prijavu. Za prijavu koristite <a href="{$a->url}">standardnu stranicu za prijavu</a>.';
$string['loginlocalshowintrosetting'] = 'Uvodna informacija za lokalnu prijavu';
$string['loginlocalshowintrosetting_desc'] = 'Sa ovim podešavanjem kontrolišete da li se uvodna informacija za <em>\'{$a}\'</em> prikazuje iznad obrasca za lokalnu prijavu ili ne. Standardno, uvodna informacija se ne prikazuje. Ali, ako omogućite ovo podešavanje, uvodna informacija može pomoći korisnicima da shvate koje kredencijale (korisničko ime i lozinku) treba da koriste u obrascu za lokalnu prijavu, posebno ako im omogućite da se prijave na više načina ili ako promenite redosled metoda prijavljivanja.';
$string['loginorderfirsttimesignupsetting'] = 'Informacije za posetioce koji prvi put pristupaju sajtu i samoregistraciju';
$string['loginorderguestsetting'] = 'Prijava gostiju';
$string['loginorderheading'] = 'Redosled metoda prijavljivanja';
$string['loginorderheading_desc'] = 'Sa ovim podešavanjima možete da kontrolišete redosled metoda prijavljivanja u obrascu za prijavu. Prikazani redosled biće definisan od najnižeg do najvišeg rednog broja, preskačući sve metode prijavljivanja i elemente obrasca za prijavu koji su onemogućeni u Moodleu.';
$string['loginorderheading_note'] = 'Tehnička napomena: predstavljeni redosled metoda prijavljivanja biće realizovan pomoću CSS flexbox redosleda, a ne preuređivanjem vidžeta za prijavu u HTML DOM. Ovo bi trebalo da bude u redu na svim modernim, ali možda neće raditi na zaista starim veb čitačima.';
$string['loginorderidpsetting'] = 'IDP prijava';
$string['loginorderlocalsetting'] = 'Lokalna prijava';
$string['loginpagetab'] = 'Stranica za prijavu';
$string['loginprovidersheading'] = 'Provajderi za prijavu';
$string['loginprovidersheading_desc'] = 'Imajte na umu: tema Boost Union ima sopstvena podešavanja provajdera za prijavu na sajt i ne koristi podešavanje \'{$a->settingname}\' u okviru <a href="{$a->url}">podešavanja za proveru identiteta unutar osnovne Moodle instalacije/a>.';
$string['logocompactsetting'] = 'Kompaktan logo';
$string['logocompactsetting_desc'] = 'Ovde možete da postavite kompaktnu verziju istog logotipa kao što je gornji, kao što je amblem, štit ili ikonica. Ova slika se posebno koristi u traci za navigaciju na vrhu svake Moodle stranice. Slika treba da bude jasna čak i pri malim veličinama.';
$string['logosetting'] = 'Logo';
$string['logosetting_desc'] = 'Ovde možete da postavite logo koji će se koristiti kao dekoracija. Ova slika se posebno koristi na stranici za prijavu i može biti prilično visoke rezolucije jer će biti smanjena za upotrebu.';
$string['logosheading'] = 'Logotipi';
$string['logosheading_desc'] = 'Imajte na umu: Boost Union ima sopstveno polje za postavljanje logotipa i ne koristi logo iz <a href="{$a}">podešavanja logotipa osnovne instalacije Moodlea</a>.<br />Boost Union vam posebno omogućava da postavite više formata slika nego što nudi osnovna instalacija Moodlea. Takođe vam daje mogućnost da izmenite postavljene logotipe u okviru njegovih vizuelnih identiteta.';
$string['maintenancecontentsetting'] = 'Sadržaj stranice sa informacijama o održavanju';
$string['maintenancecontentsetting_desc'] = 'U ovom podešavanju možete dodati sadržaj u formatu obogaćenog teksta koji će biti prikazan na stranici sa informacijama o održavanju (što nije isto što i standardna Moodle stranica sa režimom održavanja).';
$string['maintenancedisabled'] = 'Stranica sa informacijama o održavanju je onemogućena na ovom sajtu. Ovde nema šta da se vidi.';
$string['maintenanceheading'] = 'Održavanje';
$string['maintenancelinkpositionboth'] = 'Dodajte link ka stranici sa informacijama o održavanju u fusnotu i na ikonicu u podnožju stranice (znak pitanja)';
$string['maintenancelinkpositionfooter'] = 'Dodajte link ka stranici sa informacijama o održavanju na ikonicu u podnožju stranice (znak pitanja)';
$string['maintenancelinkpositionfootnote'] = 'Dodajte link ka stranici sa informacijama o održavanju u fusnotu';
$string['maintenancelinkpositionnone'] = 'Nemojte automatski prikazivati link ka stranici sa sa informacijama o održavanju';
$string['maintenancelinkpositionsetting'] = 'Pozicija linka ka stranici sa informacijama o održavanju';
$string['maintenancelinkpositionsetting_desc'] = 'U ovom podešavanju možete da konfigurišete da li će se link ka stranici sa informacijama o održavanju automatski dodati na Moodle stranicu. Ako ne želite da automatski prikazujete link, možete ručno dodati link ka {$a->url} sa bilo kog mesta u Moodleu.';
$string['maintenancepagetitledefault'] = 'Održavanje';
$string['maintenancepagetitlesetting'] = 'Naslov stranice sa informacijama o održavanju';
$string['maintenancepagetitlesetting_desc'] = 'U ovom podešavanju možete definisati naslov stranice sa informacijama o održavanju. Ovaj tekst će se koristiti i kao tekst linka ka stranici sa sa informacijama o održavanju ako u skladu s tim konfigurišete podešavanje \'Pozicija linka ka stranici sa informacijama o održavanju\'.';
$string['markbrokenlinkssetting'] = 'Označite neispravne linkove';
$string['markbrokenlinkssetting_desc'] = 'Dodaje ikonicu ”prekinutog lanca“ pored neispravnih linkova (koji vode do postavljenih draft verzija datoteka koje nisu pravilno obrađene) i označava link bootstrap bojom za ”opasnost“. Za razliku od podešavanja ”Označite eksterne linkove“ i „Označite mailto linkove“, ne postoji mogućnost da se ograniči obim ovog podešavanja jer označavanje neispravnih linkova je pokazatelj da je nešto ne funkcioniše i da se mora ručno popraviti.';
$string['markexternallinksscopesetting'] = 'Opseg obeležavanja eksternih linkova';
$string['markexternallinksscopesetting_desc'] = 'Sa ovim podešavanjem kontrolišete opseg u kome Boost Union treba da označi eksterne linkove. Boost Union standardno obeležava eksterne linkove na celoj Moodle stranici i daje sve od sebe da pokrije i neke ekstremne slučajeve gde dodavanje ikonice za eksterni link nema baš mnogo smisla. Međutim, možete, takođe, da ograničite opseg kako biste izbegli te ekstremne slučajeve.';
$string['markexternallinkssetting'] = 'Označite eksterne linkove';
$string['markexternallinkssetting_desc'] = 'Dodaje ikonicu ”eksterni link“ posle eksternih linkova (koji vode korisnika do odredišta izvan Moodlea).';
$string['marklinksscopesetting_coursemain'] = 'Isključivo na glavnim stranica kursa i to unutar polja sa glavnim sadržajem';
$string['marklinksscopesetting_wholepage'] = 'Na celoj stranici';
$string['markmailtolinksscopesetting'] = 'Opseg obeležavanja mailto linkova';
$string['markmailtolinksscopesetting_desc'] = 'Sa ovim podešavanjem kontrolišete opseg u kome Boost Union treba da označi <em>mailto</em> linkove. Boost Union standardno obeležava <em>mailto<em> linkove na celoj Moodle stranici. Međutim, možete, takođe, da ograničite opseg kako biste izbegli te ekstremne slučajeve.';
$string['markmailtolinkssetting'] = 'Opseg obeležavanja mailto linkova';
$string['markmailtolinkssetting_desc'] = 'Dodaje ikonicu ”koverte“ pored mailto linkova.';
$string['maxlogowidth'] = 'Maksimalna širina logotipa u navigacionoj traci';
$string['maxlogowidth_desc'] = 'U navigacionoj traci, postavljeni kompaktni logo se obično prikazuje sa 100% visine i proporcionalnom širinom. Međutim , ako je logo preširok ili ima neki drugi poseban odnos širine i visine, ovde možete podesiti maksimalnu širinu logotipa u navigacionoj traci. Možete uneti vrednosti zasnovane na pikselima, kao što je 120px, ali možete uneti i procentualnu vrednost, kao što je 10% ili vrednost širine prikaznog dela, kao što je 5vw. Ako ne unesete nikakvu vrednost, logo će biti prikazan sa podrazumevanom prezentacijom.';
$string['misctab'] = 'Razno';
$string['mobileappearanceheading'] = 'Izgled na mobilnim uređajima';
$string['mobileappheading'] = 'Aplikacija za mobilne uređaje';
$string['mobilecss'] = 'Dodatni CSS za mobilnu aplikaciju';
$string['mobilecss_desc'] = 'Sa ovim podešavanjem možete uneti prilagođeni CSS kôd kako biste prilagodili interfejs svoje mobilne aplikacije. CSS kôd će biti dodat samo u prikaz mobilne aplikacije ove Moodle instance, i neće biti prikazan u verziji za veb čitač. Pročitajte više o ovoj funkciji na href="https://moodledev.io/general/app/customisation/remote-themes#how-do-remote-themes-work">Moodle razvojni dokumenti</a>';
$string['mobilecss_donotchange'] = 'Ovaj korak je neophodan kako bi se poslao CSS kôd u aplikaciju za mobilne uređaje. Ne menjajte URL adresu tamo osim ako zaista ne želite da ponovo uklonite CSS kôd iz aplikacije za mobilne uređaje.';
$string['mobilecss_overwrite'] = 'Čim dodate bilo koji CSS kôd u ovo podešavanje i sačuvate ga, <a href="{$a->url}">Moodle osnovno podešavanje <em>mobilecssurl</em></a> će automatski biti zamenjeno URL adresom Boost Union  theme. Trenutno je ovo podešavanje postavljeno na  <a href="{$a->value}">{$a->value}</a>.';
$string['mobilecss_set'] = 'Čim dodate bilo koji CSS kôd u ovo podešavanje i sačuvate ga, <a href="{$a->url}">Moodle osnovno podešavanje <em>mobilecssurl</em></a> će automatski biti postavljeno na URL adresu Boost Union teme.';
$string['mobiletab'] = 'Mobilni';
$string['modiconactivity'] = 'Aktivnost';
$string['modiconactivityunknown'] = 'Nepoznato';
$string['modicongtmoodle4'] = 'Moodle 4 ikonica';
$string['modiconlistsetting'] = 'Spisak datoteka sa prilagođenim ikonama';
$string['modiconlistsetting_desc'] = 'Ovo je spisak prilagođenih datoteka ikonica koje ste postavili u gornji prostor za prilagođene datoteka ikonica. Ovde su navedene sve validne datoteke ikonica. Pored toga, prikazane su i druge datoteke (koje ste možda postavili, ali koje nisu validne datoteke ikonica). One su prikazane kao neispravne datoteke.';
$string['modiconltmoodle311'] = 'Moodle 3 nasleđena ikonica';
$string['modiconnamefail'] = 'Ova datoteka je postavljena u odgovarajući direktorijum za aktivnost <em>{$a}</em> ali naziv datoteke nije ispravan. Molimo vas da promenite naziv datoteke u <em>monologo.svg</em>/ <em>monologo.png</em> (za Moodle 4 ikonice) ili <em>icon.svg</em>/ <em>icon.png</em> (za Moodle 3 nasleđene ikonice).';
$string['modiconnotexist'] = 'Ova datoteka je postavljena na neodgovarajuće mesto, jer iz putanje datoteke <em>{$a}</em> nije bilo moguće zaključiti o kojoj se konkretnoj aktivnosti radi.';
$string['modiconsenablesetting'] = 'Omogući prilagođene ikonice za aktivnosti i resurse';
$string['modiconsenablesetting_desc'] = 'Sa ovim podešavanjem, možete da menjate ikonice za aktivnosti i resurse koje koristi Moodle na stranicama kursa i u biraču aktivnosti.';
$string['modiconserrorcreatingpath'] = 'Poddirektorijum pix_plugins/mod nije mogao da bude kreiran u vašem Moodledata direktorijumu.<br />Poruka o grešci glasila je:{$a}.';
$string['modiconsfiles'] = 'Datoteke prilagođenih ikonica';
$string['modiconsfiles_desc'] = 'Ovde možete da postavite prilagođene ikonice za sve ili samo neke module aktivnosti instalirane u ovoj instanci Moodlea.';
$string['modiconsfileshowto'] = 'Da biste postavili određenu prilagođenu ikonicu aktivnosti, prvo kreirajte direktorijuma sa internim nazivom aktivnosti, npr. <em>assign </em> za aktivnost Zadatak (assigment). U ovaj direktorijum postavljate ikonicu kao SVG datoteku (monologo.svg) i, ako je moguće, kao rezervnu PNG datoteku (monologo.png). Ako želite da prilagodite ikonice u boji koje su bile u upotrebi do Moodle 3 verzije i koje još uvek mogu da koriste stariji dodaci, takođe ih možete postaviti kao icon.svg i icon.png datoteke. Međutim, ako je moguće, ipak se držite monohromatskih SVG ikonica. Na kraju, sačuvajte stranicu sa podešavanjima. Čim sačuvate podešavanje sa najmanje jednom datotekom, ispod će se pojaviti spisak datoteka koja vam pomaže da proverite da li su prilagođene ikonice ispravno postavljene.';
$string['modiconsfilestech'] = 'Tehnička napomena: nakon što sačuvate podešavanje, struktura postavljenog direktorijuma i datoteke ikonica biće kopirane u direktorijum pix_plugins/mod, unutar vašeg Moodledata direktorijuma. Ovo je mesto gde Moodle pretražuje prilagođene ikonice aktivnosti. Sve datoteke ikonica koje možda već postoje u ovom direktorijumu biće zamenjene (tj. obrisane), kada sačuvate ovo podešavanje.';
$string['modiconsheading'] = 'Ikonice aktivnosti';
$string['modiconsuccess3x'] = 'Ova ikonica će se koristiti za aktivnost <em>{$a}</em> kao Moodle 3 nasleđena ikonica.';
$string['modiconsuccess4x'] = 'Ova ikonica će se koristiti za aktivnost <em>{$a}</em> kao Moodle 4 ikonica.';
$string['modiconversion'] = 'Verzija ikonice';
$string['navbarcolorsetting'] = 'Boja navigacione trake';
$string['navbarcolorsetting_dark'] = 'Tamna navigaciona traka sa svetlom bojom fonta';
$string['navbarcolorsetting_desc'] = 'Sa ovim podešavanjem možete promeniti boju navigacione trake iz podrazumevane svetle u tamnu ili obojenu navigacionu traku.';
$string['navbarcolorsetting_light'] = 'Svetla navigaciona traka sa tamnom bojom fonta (neizmenjeno, onako kako je izvorno podešeno u osnovnoj Moodle instalaciji)';
$string['navbarcolorsetting_primarydark'] = 'Primarna boja navigacione traka sa svetlom bojom fonta';
$string['navbarcolorsetting_primarylight'] = 'Primarna boja navigacione trake sa tamnom bojom fonta';
$string['navbarheading'] = 'Navigaciona traka';
$string['navigationheading'] = 'Navigacija';
$string['navigationtab'] = 'Navigacija';
$string['never'] = 'Nikad';
$string['nochange'] = 'Nema promene';
$string['offerscontentsetting'] = 'Sadržaj stranice sa ponudama';
$string['offerscontentsetting_desc'] = 'U ovom podešavanju možete dodati sadržaj u formatu obogaćenog teksta koji će biti prikazan na stranici sa ponudama.';
$string['offersdisabled'] = 'Stranica sa ponudama je onemogućena na ovom sajtu. Ovde nema šta da se vidi.';
$string['offersheading'] = 'Ponude';
$string['offerslinkpositionboth'] = 'Dodajte link ka stranici sa ponudama u fusnotu i na ikonicu u podnožju stranice (znak pitanja)';
$string['offerslinkpositionfooter'] = 'Dodajte link ka stranici sa ponudama na ikonicu u podnožju stranice (znak pitanja)';
$string['offerslinkpositionfootnote'] = 'Dodajte link ka stranici sa ponudama u fusnotu';
$string['offerslinkpositionnone'] = 'Nemojte automatski prikazivati link ka stranici sa ponudama';
$string['offerslinkpositionsetting'] = 'Pozicija linka ka stranici sa ponudama';
$string['offerslinkpositionsetting_desc'] = 'U ovom podešavanju možete da konfigurišete da li će se link ka stranici sa ponudama automatski dodati na Moodle stranicu. Ako ne želite da automatski prikazujete link, možete ručno dodati link ka {$a->url} sa bilo kog mesta u Moodleu.';
$string['offerspagetitledefault'] = 'Ponude';
$string['offerspagetitlesetting'] = 'Naslov stranice sa ponudama';
$string['offerspagetitlesetting_desc'] = 'U ovom podešavanju možete definisati naslov stranice sa ponudama. Ovaj tekst će se koristiti i kao tekst linka ka stranici sa ponudam ako u skladu s tim konfigurišete podešavanje \'Pozicija linka ka stranici sa ponudama\'.';
$string['openoffcanvas'] = 'Otvori fioku ”Van stranice”';
$string['outsideregionsheading'] = 'Spoljni regioni';
$string['outsideregionsheading_desc'] = 'Spoljni regioni, ne samo da se mogu uključiti pomoću gornjih podešavanja, već se njihov izgled takođe može prilagoditi.';
$string['outsideregionsplacement'] = 'Horizontalni položaj spoljnih regiona';
$string['outsideregionsplacement_desc'] = 'Sa ovim podešavanjem možete da kontrolišete da li na većim ekranima, regioni blokova \'Spolja (levo)\' i \'Spolja (desno)\' treba da budu postavljeni blizu glavnog sadržaja stranice ili blizu ivica ekrana.';
$string['outsideregionsplacementnearwindowedges'] = 'Prikažite regione \'Spolja (levo)\' i \'Spolja (desno)\' blizu ivica ekrana';
$string['outsideregionsplacementnextmaincontent'] = 'Prikažite regione \'Spolja (levo)\' i \'Spolja (desno)\' pored glavnog sadržaja stranice';
$string['outsideregionsverticalalignment'] = 'Vertikalno poravnanje spoljašnjih regiona';
$string['outsideregionsverticalalignment_desc'] = 'Sa ovim podešavanjem možete da kontrolišete da li na većim ekranima, regioni blokova \'Spolja (levo)\' i \'Spolja (desno)\' treba da budu vertikalno poravnati sa sadržajem stranice ili ne.';
$string['outsideregionsverticalalignpagecontent'] = 'Poravnajte regione \'Spolja (levo)\' i \'Spolja (desno)\' vertikalno sa sadržajem stranice';
$string['outsideregionswidthcoursecontentwidth'] = 'Širina sadržaja kursa';
$string['outsideregionswidthfullwidth'] = 'Puna širina';
$string['outsideregionswidthherowidth'] = 'Hero širina';
$string['outsideregionswrap'] = 'Prelom spoljašnjih regiona';
$string['outsideregionswrap_abovebelow'] = 'Prelomite spoljašnje regione iznad i ispod glavnog sadržaja';
$string['outsideregionswrap_bothbelow'] = 'Prelomite spoljašnje regione ispod glavnog sadržaja';
$string['outsideregionswrap_desc'] = 'Sa ovim podešavanjem možete da kontrolišete kako na manjim ekranima, regioni blokova \'Spolja (levo)\' i \'Spolja (desno)\' treba da budu prelomljeni u odnosu na glavni sadržaj.';
$string['page1contentsetting'] = 'Sadržaj generičke stranice 1';
$string['page1contentsetting_desc'] = 'U ovom podešavanju možete dodati sadržaj u formatu obogaćenog teksta koji će biti prikazan na generičkoj stranici 1';
$string['page1disabled'] = 'Generička stranica 1 je onemogućena na ovom sajtu. Ovde nema šta da se vidi.';
$string['page1heading'] = 'Generička stranica 1';
$string['page1linkpositionboth'] = 'Dodajte link ka generičkoj stranici 1 u fusnotu i na ikonicu u podnožju stranice (znak pitanja)';
$string['page1linkpositionfooter'] = 'Dodajte link ka generičkoj stranici 1 na ikonicu u podnožju stranice (znak pitanja)';
$string['page1linkpositionfootnote'] = 'Dodajte link ka generičkoj stranici 1 u fusnotu';
$string['page1linkpositionnone'] = 'Nemojte automatski prikazivati link ka generičkoj stranici 1';
$string['page1linkpositionsetting'] = 'Pozicija linka ka generičkoj stranici 1';
$string['page1linkpositionsetting_desc'] = 'U ovom podešavanju možete da konfigurišete da li će se link ka generičkoj stranici 1 automatski dodati na Moodle stranicu. Ako ne želite da automatski prikazujete link, možete ručno dodati link ka {$a->url} sa bilo kog mesta u Moodleu.';
$string['page1pagetitledefault'] = 'Generička stranica 1';
$string['page1pagetitlesetting'] = 'Naslov generičke stranice 1';
$string['page1pagetitlesetting_desc'] = 'U ovom podešavanju možete definisati naslov generičke stranice 1. Ovaj tekst će se koristiti i kao tekst linka ka generičkoj stranici 1 ako u skladu s tim konfigurišete podešavanje \'Pozicija linka ka generičkoj stranici 1\'.';
$string['page2contentsetting'] = 'Sadržaj generičke stranice 2';
$string['page2contentsetting_desc'] = 'U ovom podešavanju možete dodati sadržaj u formatu obogaćenog teksta koji će biti prikazan na generičkoj stranici 2';
$string['page2disabled'] = 'Generička stranica 2 je onemogućena na ovom sajtu. Ovde nema šta da se vidi.';
$string['page2heading'] = 'Generička stranica 2';
$string['page2linkpositionboth'] = 'Dodajte link ka generičkoj stranici 2 u fusnotu i na ikonicu u podnožju stranice (znak pitanja)';
$string['page2linkpositionfooter'] = 'Dodajte link ka generičkoj stranici 2 na ikonicu u podnožju stranice (znak pitanja)';
$string['page2linkpositionfootnote'] = 'Dodajte link ka generičkoj stranici 2 u fusnotu';
$string['page2linkpositionnone'] = 'Nemojte automatski prikazivati link ka generičkoj stranici 2';
$string['page2linkpositionsetting'] = 'Pozicija linka ka generičkoj stranici 2';
$string['page2linkpositionsetting_desc'] = 'U ovom podešavanju možete da konfigurišete da li će se link ka generičkoj stranici 2 automatski dodati na Moodle stranicu. Ako ne želite da automatski prikazujete link, možete ručno dodati link ka {$a->url} sa bilo kog mesta u Moodleu.';
$string['page2pagetitledefault'] = 'Generička stranica 2';
$string['page2pagetitlesetting'] = 'Naslov generičke stranice 2';
$string['page2pagetitlesetting_desc'] = 'U ovom podešavanju možete definisati naslov generičke stranice 2. Ovaj tekst će se koristiti i kao tekst linka ka generičkoj stranici 2 ako u skladu s tim konfigurišete podešavanje \'Pozicija linka ka generičkoj stranici 2\'.';
$string['page3contentsetting'] = 'Sadržaj generičke stranice 3';
$string['page3contentsetting_desc'] = 'U ovom podešavanju možete dodati sadržaj u formatu obogaćenog teksta koji će biti prikazan na generičkoj stranici 3';
$string['page3disabled'] = 'Generička stranica 3 je onemogućena na ovom sajtu. Ovde nema šta da se vidi.';
$string['page3heading'] = 'Generička stranica 3';
$string['page3linkpositionboth'] = 'Dodajte link ka generičkoj stranici 3 u fusnotu i na ikonicu u podnožju stranice (znak pitanja)';
$string['page3linkpositionfooter'] = 'Dodajte link ka generičkoj stranici 3 na ikonicu u podnožju stranice (znak pitanja)';
$string['page3linkpositionfootnote'] = 'Dodajte link ka generičkoj stranici 3 u fusnotu';
$string['page3linkpositionnone'] = 'Nemojte automatski prikazivati link ka generičkoj stranici 3';
$string['page3linkpositionsetting'] = 'Pozicija linka ka generičkoj stranici 3';
$string['page3linkpositionsetting_desc'] = 'U ovom podešavanju možete da konfigurišete da li će se link ka generičkoj stranici 3 automatski dodati na Moodle stranicu. Ako ne želite da automatski prikazujete link, možete ručno dodati link ka {$a->url} sa bilo kog mesta u Moodleu.';
$string['page3pagetitledefault'] = 'Generička stranica 3';
$string['page3pagetitlesetting'] = 'Naslov generičke stranice 3';
$string['page3pagetitlesetting_desc'] = 'U ovom podešavanju možete definisati naslov generičke stranice 3. Ovaj tekst će se koristiti i kao tekst linka ka generičkoj stranici 3 ako u skladu s tim konfigurišete podešavanje \'Pozicija linka ka generičkoj stranici 3\'.';
$string['pagelayoutstab'] = 'Izgledi stranica';
$string['pagetab'] = 'Stranica';
$string['pagewidthheading'] = 'Širina stranice';
$string['pluginname'] = 'Boost Union';
$string['policyheading'] = 'Pravila korišćenja sajta';
$string['policyoverviewnavigationsetting'] = 'Prikaži navigaciju na stranici sa pregledom pravila korišćenja';
$string['policyoverviewnavigationsetting_desc'] = 'Standardno, <a href="{$a->url}">stranica sa pregledom pravila korišćenja sajta (koja obezbeđuje tool_policy)</a> ne prikazuje meni za navigaciju ili podnožje. Pomoću ovog podešavanja možete da prikažete primarnu navigaciju i podnožje na toj stranici.';
$string['presetbutton'] = 'Podesite predefinisana podešavanja teme u grafičkoj temi Boost';
$string['presetheading'] = 'Predefinisana podešavanja grafičke teme';
$string['presetheading_desc'] = 'Predefinisana podešavanja grafičke teme mogu se koristiti za dramatičnu promenu izgleda teme. Boost Union tema ne primenjuje predefinisana podešavanja, ali ih nasleđuje od teme Boost. Dakle, ukoliko želite da koristite predefinisana podešavanja grafičke teme, podesite ih direktno u temi Boost. Boost Union će naslediti i koristiti konfigurisana predefinisana podešavanja grafičke teme.';
$string['primarynavigationheading'] = 'Primarna navigacija';
$string['privacy:metadata'] = 'Tema Boost Union ne čuva nikakve lične podatke o bilo kom korisniku.';
$string['region-content-lower'] = 'Sadržaj (donji)';
$string['region-content-upper'] = 'Sadržaj (gornji)';
$string['region-footer-center'] = 'Podnožje (centar)';
$string['region-footer-left'] = 'Podnožje (levo)';
$string['region-footer-right'] = 'Podnožje (desno)';
$string['region-header'] = 'Zaglavlje';
$string['region-none'] = 'Nijedan';
$string['region-offcanvas-center'] = 'Van stranice (centar)';
$string['region-offcanvas-left'] = 'Van stranice (levo)';
$string['region-offcanvas-right'] = 'Van stranice (desno)';
$string['region-outside-bottom'] = 'Spolja (dole)';
$string['region-outside-left'] = 'Spolja (levo)';
$string['region-outside-right'] = 'Spolja (desno)';
$string['region-outside-top'] = 'Spolja (gore)';
$string['resourcescachecontrolnote'] = 'Imajte na umu da se datoteke šalju veb čitaču sa podešenim zaglavljem \'Cache-Control\' koje veb čitaču govori da kešira datoteku. Ukoliko ste sigurni da datoteku nećete promeniti u bliskoj budućnosti, možete da koristite trajnu URL adresu za povezivanje sa datotekom. Međutim, ako planirate da, s vremena na vreme, izmenite datoteku, i da pritom zadržite njen naziv, bolje bi bilo da koristite revidiranu URL adresu i ponovo povežete datoteku koju ste koristili, svaki put kada je ažurirate, kako biste izbegli da veb čitači prikazuju keširane zastarele verzije datoteke.';
$string['resourcestab'] = 'Resursi';
$string['scrollspysetting'] = 'Čuvar pozicije klizne trake';
$string['scrollspysetting_desc'] = 'Sa ovim podešavanjem, nakon uključivanja/isključivanja prekidača režima uređivanje, pozicija klizne trake u veb čitaču (tj. mesto na kojem je korisnik bio u trenutku kada je uključio režim uređivanje) biće sačuvana.';
$string['scssheading'] = 'Neobrađeni SCSS';
$string['scsstab'] = 'SCSS';
$string['setpreferredlanglink'] = 'Podesite preferirani jezik';
$string['settingsoverview'] = 'Pregled podešavanja';
$string['settingsoverview_accessibility_desc'] = 'Podešavanja za funkcionalnost u vezi sa pristupačnošću vašem Moodle sajtu se nalaze ovde.';
$string['settingsoverview_all'] = 'Sva podešavanja na jednoj stranici';
$string['settingsoverview_all_desc'] = 'Ovde možete da otvorite standardnu stranicu podešavanja Moodle kategorija za Boost Union grafičku temu koja prikazuje sva podešavanja na jednoj stranici. Ali vodite računa, stranica je prepuna brojnih podešavanja.';
$string['settingsoverview_content_desc'] = 'Podešavanja za globalni sadržaj vašeg Moodle sajta se nalaze ovde: podnožje, statične stranice, info baneri, reklamne pločice i slajd prezentacije.';
$string['settingsoverview_feel_desc'] = 'Podešavanja za celokupno ponašanje vašeg Moodle sajta se nalaze ovde: stavke za navigaciju, pomoćnici za navigaciju, blokovi i linkovi.';
$string['settingsoverview_flavours_desc'] = 'Pomoću vizuelnih identiteta možete učiniti različitim izgled vašeg Moodle sajta za kohorte i/ili kategorije kurseva.';
$string['settingsoverview_functionality_desc'] = 'Ovde se nalaze podešavanja za dodatne korisne globalne funkcionalnosti ili one koje odnose na pojedinačne kurseve na vašem Moodle sajtu.';
$string['settingsoverview_look_desc'] = 'Podešavanja za brendiranje vašeg Moodle sajta se nalaze ovde: boje, ikonice, slike, veličine i, naravno, prilagođeni SCSS.';
$string['settingsoverview_smartmenus_desc'] = 'Sa pametnim menijima možete proširiti stavke za navigaciju na svom Moodle sajtu u regionu glavnog i korisničkog menije, kao i da dodate meni na dnu ili vrhu stranice.';
$string['settingsoverview_snippets_desc'] = 'Pomoću SCSS isečaka kôda, možete uključiti dodatne atraktivne elemente i vizuelno unaprediti izgled svog Moodle sajta.';
$string['settingsoverview_title'] = 'Pregled Boost Union podešavanja';
$string['showasbadge'] = 'Prikaži kao bedž';
$string['showastext'] = 'Prikaži kao tekst';
$string['showfullnameinusermenussetting'] = 'Prikaži puno ime u korisničkom meniju';
$string['showfullnameinusermenussetting_desc'] = 'Sa ovim podešavanjem, možete prikazati puno ime prijavljenog korisnika na vrhu korisničkog menija. Ovo može biti posebno korisno u slučaju ispita kada predavači moraju da potvrde da je korisnik prijavljen sa sopstvenim nalogom, ali može biti od pomoći i samom korisniku. Za razliku od Classic grafičke teme koja prikazuje puno ime korisnika u traci za navigaciju pored avatara, ovo podešavanje ne zahteva nikakav dodatni prostor u navigacionoj traci.';
$string['showfullnameinusermenussetting_loggedinas'] = 'Prijavljeni ste kao:';
$string['showhintcourseguestaccessgeneral'] = 'Trenutno posmatrate ovaj kurs kao <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Da biste imali pun pristup kursu, možete <a href="{$a->url}">samostalno da se upišete na ovaj kurs</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'Sa ovim podešavanjem, kada korisnik pristupa kursu u ulozi gosta,  u zaglavlju kursa će se pojaviti nagoveštaj (hint). Ako kurs daje mogućnost za samostalni upis, korisniku će takođe biti prikazan link do stranice za upis.';
$string['showhintcourseguestenrolauthonly'] = 'Svi korisnici prijavljeni na Moodle mogu slobodno da pristupe sadržaju ovog kursa bez upisivanja na sam kurs.';
$string['showhintcourseguestenrolauthonlyalways'] = 'Svi korisnici prijavljeni na Moodle mogu da pristupe sadržaju ovog kursa bez upisivanja na sam kurs, ako znaju lozinku za pristup gostiju.';
$string['showhintcourseguestenrolcallforaction'] = 'Ako ne želite da omogućite besplatan pristup ovom kursu, onemogućite pristup gostima ili postavite lozinku za goste u <a href="{$a->url}">podešavanjima kursa</a>.';
$string['showhintcourseguestenrolcallforactionalways'] = 'Ako ne želite da odobrite gostima pristup ovom kursu, onemogućite to u <a href="{$a->url}">podešavanjima kursa</a>.';
$string['showhintcourseguestenroleveryone'] = 'Svi korisnici Moodle platforme, pa čak i korisnici bez naloga na istoj, mogu slobodno da pristupe sadržaju ovog kursa bez upisivanja na kurs.';
$string['showhintcourseguestenroleveryonealways'] = 'Svi korisnici Moodle platforme, pa čak i korisnici bez naloga na istoj, mogu da pristupe sadržaju ovog kursa bez upisivanja na kurs, ako znaju lozinku za pristup gostiju.';
$string['showhintcourseguestenrolhint'] = 'Ovaj kurs je trenutno vidljiv svima i moguć je <strong>Pristup gostima bez lozinke za goste</strong>.';
$string['showhintcourseguestenrolhintalways'] = 'Ovaj kurs je trenutno vidljiv svima i moguć je pristup gostima sa lozinkom.';
$string['showhintcourseguestenrolsetting'] = 'Prikaži nagoveštaj (hint) za upis gosta';
$string['showhintcourseguestenrolsetting_always'] = 'Da, čak i ako je podešena lozinka za pristup gostiju';
$string['showhintcourseguestenrolsetting_desc'] = 'Sa ovim podešavanjem, u zaglavlju kursa će se pojaviti nagoveštaj (hint) ako je kurs vidljiv i ako je upis gostiju trenutno moguć.';
$string['showhintcourseguestenrolsetting_note'] = 'Napomena: ukoliko želite da unapredite nagoveštaj (hint) linkom ka kursu bilo koje vrste, na raspolaganju vam je rezervisano mesto {&dollar;a->courseid} koje se može koristiti prilikom jezičkog prilagođavanja.';
$string['showhintcourseguestenrolsetting_withoutpassword'] = 'Da, ali samo ako nije podešena lozinka za pristup gostiju';
$string['showhintcoursehiddengeneral'] = 'Ovaj kurs je trenutno <strong>sakriven</strong>. Samo upisani predavači mogu pristupiti ovom kursu kada je sakriven.';
$string['showhintcoursehiddensetting'] = 'Prikaži nagoveštaj (hint) u sakrivenim kursevima';
$string['showhintcoursehiddensetting_desc'] = 'Sa ovim podešavanjem, u zaglavlju kursa će se pojaviti nagoveštaj (hint) sve dok je kurs sakriven. Ovo pomaže da se odmah, na prvi pogled identifikuje status vidljivosti kursa, bez potrebe da se ona proverava u podešavanjima kursa.';
$string['showhintcoursehiddensettingslink'] = 'Vidljivost možete promeniti u <a href="{$a->url}">podešavanjima kurs</a>.';
$string['showhintcourseselfenrolfrom'] = 'Instanca upisa <strong>{$a->name}</strong> dozvoljava neograničeni samostalni upis od {$a->from} pa nadalje.';
$string['showhintcourseselfenrolfromuntil'] = 'Instanca upisa <strong>{$a->name}</strong> dozvoljava neograničeni samostalni upis od {$a->from} do {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Ako ne želite da bilo koji korisnik Moodlea ima slobodan pristup ovom kursu, molimo vas da ograničite podešavanja samostalnog upisa.';
$string['showhintcourseselfenrolsetting'] = 'Prikaži nagoveštaj (hint) za samostalni upis bez lozinke za upis';
$string['showhintcourseselfenrolsetting_desc'] = 'Sa ovim podešavanjem, u zaglavlju kursa će se pojaviti nagoveštaj (hint) ako je kurs vidljiv i ako je, trenutno, moguć upis bez lozinke za upis.';
$string['showhintcourseselfenrolsince'] = 'Instanca upisa <strong>{$a->name}</strong> trenutno dozvoljava neograničeni samostalni upis.';
$string['showhintcourseselfenrolsinceuntil'] = 'Instanca upisa <strong>{$a->name}</strong> dozvoljava neograničeni samostalni upis do {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'Ovaj kurs je trenutno vidljiv svima i moguć je <strong>samostalni upis bez lozinke za upis<strong>.';
$string['showhintcourseselfenrolstartfuture'] = 'Ovaj kurs je trenutno vidljiv svima i planirano je da <strong>samostalni upis bez lozinke za upis<strong> postane moguć.';
$string['showhintcourseselfenrolunlimited'] = 'Instanca upisa <strong>{$a->name}</strong> dozvoljava neograničeni samostalni upis na neodređeno vreme.';
$string['showhintcourseselfenroluntil'] = 'Instanca upisa <strong>{$a->name}</strong> dozvoljava neograničeni samostalni upis do {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Prikaži nagoveštaj (hint) korisnicima koji pristupaju kao gosti';
$string['showhintforumnotifications'] = 'Ovaj kurs je trenutno <strong>sakriven</strong>. To znači da<strong>polaznici neće dobijati obaveštenja</strong> bilo onlajn ili e-poštom o novim porukama koje su objavljene na ovom forumu.';
$string['showhintforumnotificationssetting'] = 'Prikaži nagoveštaj (hint) za obaveštenja foruma u skrivenim kursevima';
$string['showhintforumnotificationssetting_desc'] = 'Sa ovim podešavanjem, nagoveštaj (hint) se će pojaviti ne samo u zaglavlju kursa već i na forumima sve dok je kurs sakriven od polaznika. Da pojasnimo, obaveštenja o novim porukama u okviru foruma na sakrivenom kursu se ne šalju polaznicima, pa ova opcija služi da pomogne predavačima da shvate ovu okolnost, tj. da je polaznici ne mogu da vide kurs.';
$string['shownavbarstarredcourses_config'] = 'Podesite kurseve označene zvezdicom na stranici \'{$a}\'';
$string['shownavbarstarredcourses_label'] = 'Kursevi označeni zvezdicom';
$string['shownavbarstarredcoursessetting'] = 'Prikaži padajući meni sa kursevima označenim zvezdicom na traci za navigaciju';
$string['shownavbarstarredcoursessetting_desc'] = 'Sa ovim podešavanjem možete da prikažete padajući meni sa linkovima ka kursevima označenim zvezdicom pored menija za poruke i obaveštenja.';
$string['showsitehomerighthandblockdraweronfirstloginsetting'] = 'Prikaži fioku sa blokovima sa desne strane početne stranice sajta prilikom prve prijave na sistem';
$string['showsitehomerighthandblockdraweronfirstloginsetting_desc'] = 'Sa ovim podešavanjem, fioka sa blokovima sa desne strane početne stranice sajta standarno će biti prikazana. Ovo se odnosi samo na korisnike koji se prijavljuju po prvi put i ne menja status prikaza (odnosno sakrivenosti) fioke za svakog pojedinačnog korisnika.';
$string['showsitehomerighthandblockdraweronguestloginsetting'] = 'Prikaži fioku sa blokovima sa desne strane početne stranice sajta prilikom prijave gosta';
$string['showsitehomerighthandblockdraweronguestloginsetting_desc'] = 'Sa ovim podešavanjem, fioka sa blokovima sa desne strane početne stranice sajta standardno će biti prikazana (u svom proširenom obliku). Ovo se odnosi samo na korisnike koji se prijavljuju kao gosti.';
$string['showsitehomerighthandblockdraweronvisitsetting'] = 'Prikažite fioku sa blokovima sa desne strane početne stranice prilikom posete';
$string['showsitehomerighthandblockdraweronvisitsetting_desc'] = 'Sa ovim podešavanjem, fioka sa blokovima sa desne strane početne stranice sajta standardno će biti prikazana (u svom proširenom obliku). Ovo se odnosi samo na korisnike koji nisu prijavljeni i ne menja status prikaza (odnosno sakrivenosti) fioke za svakog pojedinačnog korisnika.';
$string['showswitchedroleincoursesetting'] = 'Prikaži nagoveštaj (hint) za izmenjenu ulogu';
$string['showswitchedroleincoursesetting_desc'] = 'Sa ovim podešavanjem, u zaglavlju kursa će se pojaviti nagoveštaj (hint) ukoliko je korisnik promenio ulogu na kursu. Standardno, ove informacije se prikazuju samo u blizini slike korisnika u korisničkom meniju. Ako omogućite ovu opciju, možete takođe da prikažete ove informacije - zajedno sa linkom \'Povratak na moju uobičajenu ulogu\' - i na samoj stranici kursa.';
$string['showviewcourseiconincoursemgntsesetting_desc'] = 'Standardno, na <a href ="{$a}">stranici za upravljanje kursom</a>, Moodle zahteva ili da otvorite detaljne podatke o kursu ili da prođete kroz podešavanja kursa, pre nego što budete mogli da kliknete na dodatni element korisničkog interfejsa kako biste videli kurs. Ako omogućite ovo podešavanje, možete da dodate ikonicu \'Prikaži kurs\' na stranici za upravljanje kursom.';
$string['showviewcourseiconincoursemgntsetting'] = 'Prikaži ikonicu za prikaz kursa';
$string['sideentranceloginenablesetting'] = 'Omogućite pomoćnu stranicu za prijavu na sistem';
$string['sideentranceloginenablesetting_desc'] = 'Sa ovim podešavanjem možete da omogućite <a href="{$a->url}">pomoćnu stranicu za prijavu na sistem</a>. Ovo podešavanje se automatski uključuje ako onemogućite lokalni obrazac za prijavu (videti gore), ali ga možete omogućiti stalno kako biste lokalnim korisnicima omogućili da zaobiđu glavnu stranicu za prijavu i proces prijave, što je posebno korisno kod SSO podešavanja. Na pomoćnoj stranici za lokalnu prijavu na sistem, primenjuju se, naravno, i sve uobičajene mere Moodles za bezbednu prijavu na sistem.';
$string['sideentranceloginheading'] = 'Pomoćna stranica za prijavu na sistem';
$string['sitebrandingtab'] = 'Brendiranje sajta';
$string['sitehomerighthandblockdrawerbehaviour'] = 'Desna fioka sa blokovima na početnoj stranici';
$string['slidebackgroundimagealtsetting'] = 'Atribut alt pozadinske slike slajda {$a->no}';
$string['slidebackgroundimagealtsetting_desc'] = 'Ovde možete podesite atribut alt za sliku slajda {$ a->no}. Ovo je opciono podešavanje, slajd će biti prikazan čak i ako ne postavite atribut alt. Imajte na umu da izostavljanje atributa alt smanjuje pristupačnost sajta.';
$string['slidebackgroundimagesetting'] = 'Pozadinska slika slajda {$ a-> no}';
$string['slidebackgroundimagesetting_desc'] = 'Ovde možete da postavite datoteku slike koja će biti prikazana kao pozadinska slika iza sadržaja slajda {$ a->no}. Molimo vas, proverite da li je sadržaj na pozadinskoj slici i dalje čitljiv. Takođe, pokušajte da se uverite da je odnos širine i visine svih pozadinskih slika na svim slajdovima jednak (pošto odnos širine i visine slike u pozadini kontroliše visinu slajda, pa biste tako izbegli treperenje prilikom promene slajdova). Ovo je obavezno podešavanje - slajd neće biti prikazan ako ne postavite pozadinsku sliku.';
$string['slidecaptionsetting'] = 'Naslov slajda {$a->no}';
$string['slidecaptionsetting_desc'] = 'Ovde unosite naslov koji treba da bude prikazan na slajdu {$ a->no}. Naslov se prikazuje na dnu, u sredini slajda. Ovo je opciono podešavanje, slajd će biti prikazan čak i ako ne postavite naslov.';
$string['slidecontentsetting'] = 'Sadržaj slajda {$a->no}';
$string['slidecontentsetting_desc'] = 'Ovde unosite sadržaj koji treba da bude prikazan na slajdu {$ a->no}. Sadržaj se prikazuje na dnu, u sredini slajda. Ako je natpis postavljen, sadržaj se prikazuje ispod naslova. Imajte na umu da editor tekst standardno poravnava uz levu ivicu, ali ćete možda poželeti da tekst drugačije poravnate. Takođe, suzdržite se od stavljanja previše teksta na slajd, i obavezno testirajte izgled slajda na malim uređajima, jer će sadržaj koji prelazi ivice slajda jednostavno biti sakriven. Ovo je opciono podešavanje, slajd će biti prikazan čak i ako ne postavite nikakav sadržaj.';
$string['slidecontentstylesetting'] = 'Stil sadržaja slajda {$a->no}';
$string['slidecontentstylesetting_dark'] = 'Tamno (crna boja fonta za svetle pozadinske slike)';
$string['slidecontentstylesetting_darkshadow'] = 'Tamno sa senkom (crna boja fonta sa svetlom senkom za svetle pozadinske slike)';
$string['slidecontentstylesetting_desc'] = 'Ovde možete da izmenite stil sadržaja slajda {$a->no}.. Standardno, stil sadržaja je bela boja fonta za tamne pozadinske slike. Međutim, da biste omogućili dosledan i jednostavan stil na svim vrstama pozadinskih slika, ovde ga možete izmeniti. Imajte na umu da će ovo podešavanje u svakom slučaju poništiti boju fonta koju ste postavili u gornjem editoru teksta.';
$string['slidecontentstylesetting_light'] = 'Svetlo (bela boja fonta za tamne pozadinske slike)';
$string['slidecontentstylesetting_lightshadow'] = 'Svetlo sa senkom (bela boja fonta sa tamnom senkom za tamne pozadinske slike)';
$string['slideenabledsetting'] = 'Omogući slajd {$ a-> no}';
$string['slideenabledsetting_desc'] = 'Sa ovim podešavanjem možete omogućiti slajd {$ a->no}.';
$string['slideheading'] = 'Slajd {$a->no}';
$string['slidelinksetting'] = 'URL adresa linka za slajd {$a->no}';
$string['slidelinksetting_desc'] = 'Ovde možete podesiti (Moodle, internu ili eksternu) URL adresu sa kojom će biti povezan sadržaj slajda {$a->no}. Ovo je opciono podešavanje, slajd će biti prikazan čak i ako ne postavite URL link.';
$string['slidelinksourcesetting'] = 'Elementi slajda {$a->no} za linkovanje';
$string['slidelinksourcesetting_both'] = 'Pozadinska slika i elementi teksta';
$string['slidelinksourcesetting_desc'] = 'Ovde možete da kontrolišete koji elementi slajda su povezani sa navedenom URL adresom. Možete birati između povezivanja samo pozadinske slike, povezivanja samo tekstualnih elemenata slajda (naslova i sadržaja) ili povezivanja i pozadinske slike i teksta.';
$string['slidelinksourcesetting_image'] = 'Samo pozadinska slika';
$string['slidelinksourcesetting_text'] = 'Samo tekstualni elementi';
$string['slidelinktargetsetting'] = 'Odredište linka slajda {$a->no}';
$string['slidelinktargetsetting_desc'] = 'Ovde možete da podesite odredište linka, koji je podešen za link slajda čim je podešen URL link na slajdu {$ a->no}.';
$string['slidelinktargetsetting_newtab'] = 'Novi prozor';
$string['slidelinktargetsetting_samewindow'] = 'Isti prozor';
$string['slidelinktitlesetting'] = 'Naslov linka slajda {$a->no}';
$string['slidelinktitlesetting_desc'] = 'Ovde možete podesite naslov linka koji se prikazuje kao kratak opis linka kada korisnik pređe mišem preko slajda {$a->no}. Ovo je opciono podešavanje, slajd će biti povezan čak i ako ne podesite naslov linka. Imajte na umu da nenavođenje naslova veze smanjuje pristupačnost.';
$string['slideordersetting'] = 'Pozicija slajda {$ a-> no}';
$string['slideordersetting_desc'] = 'Sa ovim podešavanjem definišete položaj tj. redosled slajda {$ a->no}. Standardno, slajdovi su poređani onako kako ih vidite na ovoj stranici za podešavanja. Međutim, ukoliko želite možete slajdu da dodelite drugu poziciju pomožu ovog podešavanja. Ako, greškom, dodelite istu poziciju za dva ili više slajdova, oni će na kraju biti poređani prema redosledu na ovoj stranici za podešavanje slajdova.';
$string['slideranimationsetting'] = 'Slajd šou - tip animacije';
$string['slideranimationsetting_desc'] = 'Sa ovim podešavanjem kontrolišete način prikazivanja slajdova. Opcija\'Slajd\' primenjuje kliznu animaciju, a opcija \'Zamračivanje\' primenjuje postepeno pojavljivanje i nestajanje slajdova.';
$string['slideranimationsetting_fade'] = 'Zamračivanje';
$string['slideranimationsetting_slide'] = 'Slajd';
$string['sliderarrownavsetting'] = 'Omogući navigaciju sa strelicama';
$string['sliderarrownavsetting_desc'] = 'Sa ovim podešavanjem možete dodati strelice za navigaciju na obe strane slajd prezentacije.';
$string['sliderfrontpagepositionsetting'] = 'Položaj slajd prezentacije na početnoj stranici sajta.';
$string['sliderfrontpagepositionsetting_afterafter'] = 'Nakon sadržaja naslovne stranice sajta (i nakon reklamnih pločica)';
$string['sliderfrontpagepositionsetting_afterbefore'] = 'Nakon sadržaja naslovne stranice sajta (ali pre reklamnih pločica)';
$string['sliderfrontpagepositionsetting_beforeafter'] = 'Pre sadržaja naslovne stranice sajta (ali nakon reklamnih pločica)';
$string['sliderfrontpagepositionsetting_beforebefore'] = 'Pre sadržaja naslovne stranice sajta (i pre reklamnih pločica)';
$string['sliderfrontpagepositionsetting_desc'] = 'Slajd-šou se prikazaju samo na početnoj stranici sajta. Pomoću ovog podešavanja kontrolišete da li će slajd-šou biti prikazan pre ili posle sadržaja početne stranice sajta. Ako želite da na početnoj stranici sajta prikažete samo slajd-šou i ništa drugo, sav ostali sadržaj početne stranice sajta možete ukloniti promenom <a href="{$a->url}">podešavanja početne stranice sajta</a>.';
$string['slidergeneralheading'] = 'Slajd -šou - opšta podešavanja';
$string['sliderindicatornavsetting'] = 'Omogućite indikator navigacije za slajd-šou';
$string['sliderindicatornavsetting_desc'] = 'Sa ovim podešavanjem možete dodati indikatore navigacije na slajd-šou, pri njegovom dnu.';
$string['sliderintervalsetting'] = 'Vremenski interval prikazivanja slajda';
$string['sliderintervalsetting_desc'] = 'Sa ovim podešavanjem kontrolišete koliko dugo će slajd dugo biti prikazan, u milisekundama. Minimalna vrednost je 1000 (jedna sekunda), a maksimalna vrednost je 10000 (10 sekundi).';
$string['sliderkeyboardsetting'] = 'Dozvoli interakciju tastature sa slajdovima';
$string['sliderkeyboardsetting_desc'] = 'Sa ovim podešavanjem omogućavate da slajd-šou može da se kontroliše putem tastature (tasteri sa strelicama). Imajte na umu da će ukoliko onemogućite ovu opciju, biti smanjena pristupačnost sajtu.';
$string['sliderpausesetting'] = 'Pauzirajte slajd-šou pri prelasku miša preko slajda';
$string['sliderpausesetting_desc'] = 'Sa ovim podešavanjem sprečavate slajd-šou da kruži kroz slajdove kada korisnik pređe mišem preko slajda. Imajte na umu da će ukoliko onemogućite ovu opciju, biti smanjena pristupačnost sajtu.';
$string['sliderridesetting'] = 'Ciklično ponavaljanje slajdova';
$string['sliderridesetting_afterinteraction'] = 'Nakon interakcije';
$string['sliderridesetting_desc'] = 'Sa ovim podešavanjem kontrolišete ciklično ponavljanje slajd-šou prezentacije. \'Pri učitavanju stranice\' - slajd-šou počinje da kruži kroz slajdove nakon što se završi učitavanje stranice, \'Nakon interakcije\' - slajd-šou počinje da kruži kroz slajdove nakon što korisnik stupi u interakciju sa slajdom. \'Nikad \' - ova opcija potpuno onemogućava automatski ciklično ponavljanje slajdova.';
$string['sliderridesetting_never'] = 'Nikad';
$string['sliderridesetting_onpageload'] = 'Pri učitavanju stranice';
$string['slidertab'] = 'Slajd -šou';
$string['sliderwrapsetting'] = 'Neprekidno kruženje kroz sve slajdove';
$string['sliderwrapsetting_desc'] = 'Sa ovim podešavanjem, slajd-šou kruži kroz sve slajdove. Ako ovo onemogućite, slajd-šou će prestati na poslednjem slajdu.';
$string['smartmenus'] = 'Pametni meniji';
$string['smartmenus_desc'] = '<p >Pametni meniji omogućavaju administratorima sajta da kreiraju prilagodljive menije koji se mogu postaviti na različite mesta na sajtu, kao što su glavni meni sajta, pokretni meni na dnu stranice i korisnički meni. Meniji se mogu konfigurisati tako da prikazuju različite tipove sadržaja, uključujući linkove ka drugim stranicama ili resursima, linkove ka kategorijama ili linkove ka korisničkim profilima.</p><p>Administratori sajta mogu da kreiraju novi meni, da odrede stavke u njemu, kao i da podese kako će meni biti prikazan. Administrator takođe može da izabere gde će meni biti prikazan na sajtu i da li treba da bude vidljiv svim korisnicima ili samo određenim korisničkim ulogama.</p>';
$string['smartmenusbyadmin'] = 'Ko vidi pametne menije';
$string['smartmenusbyadmin_admins'] = 'Samo administratori sajta';
$string['smartmenusbyadmin_all'] = 'Svi korisnici';
$string['smartmenusbyadmin_help'] = 'Ograničite vidljivost na osnovu činjenice da li je korisnik administrator sajta ili ne.';
$string['smartmenusbyadmin_nonadmins'] = 'Samo za ne-administratore';
$string['smartmenusbycohort'] = 'Prema kohorti';
$string['smartmenusbycohort_help'] = 'Ograničite vidljivost na osnovu kohorte korisnika.';
$string['smartmenusbydate'] = 'Prema datumu';
$string['smartmenusbydate_help'] = 'Ograničite vidljivost na osnovu datuma';
$string['smartmenusbydatefrom'] = 'Od';
$string['smartmenusbydatefrom_help'] = 'Ograničite vidljivost na period od ovde navedenog datuma';
$string['smartmenusbydateuntil'] = 'Do';
$string['smartmenusbydateuntil_help'] = 'Ograničite vidljivost na period do ovde navedenog datuma';
$string['smartmenusbylanguage'] = 'Prema jeziku';
$string['smartmenusbylanguage_help'] = 'Ograničite vidljivost na osnovu jezika korisnika';
$string['smartmenusbyrole'] = 'Prema ulozi';
$string['smartmenusbyrole_help'] = 'Ograničite vidljivost na osnovu uloga korisnika.';
$string['smartmenusdynamiccoursescompletionstatus'] = 'Status završetka';
$string['smartmenusdynamiccoursescompletionstatus_help'] = 'Spisak stavki u meniju dinamičkih kurseva će sadržati sve kurseve korisnika koji odgovaraju izabranom statusu završetka. Na primer, ako izaberete opciju\'U toku\' kao status završetka, spisak stavki u meniju dinamičkih kurseva će sadržati samo one kurseve na koje korisnik trenutno upisan.';
$string['smartmenusdynamiccoursescompletionstatuscompleted'] = 'Završen';
$string['smartmenusdynamiccoursescompletionstatusenrolled'] = 'Upisan';
$string['smartmenusdynamiccoursescompletionstatusinprogress'] = 'U toku';
$string['smartmenusdynamiccoursescoursecategory'] = 'Kategorija kurseva';
$string['smartmenusdynamiccoursescoursecategory_help'] = 'Dinamički meni sa spiskom kurseva će sadržati sve kurseve iz izabranih kategorije kurseva.';
$string['smartmenusdynamiccoursescoursecategorysubcats'] = 'Uključite potkategorije';
$string['smartmenusdynamiccoursescoursecategorysubcats_help'] = 'Ako je ova opcija označeno, meni dinamičkih kurseva će takođe sadržati sve kurseve iz potkategorija izabranih kategorija kurseva.';
$string['smartmenusdynamiccoursesdaterange'] = 'Vremenski period';
$string['smartmenusdynamiccoursesdaterange_help'] = 'Dinamički meni sa spiskom kurseva će sadržavati sve kurseve koje spadaju u izabrani vremenski period.';
$string['smartmenusdynamiccoursesdaterangefuture'] = 'Budući';
$string['smartmenusdynamiccoursesdaterangepast'] = 'Prošli';
$string['smartmenusdynamiccoursesdaterangepresent'] = 'Tekući';
$string['smartmenusdynamiccoursesenrolmentrole'] = 'Uloga na upisanom kursu';
$string['smartmenusdynamiccoursesenrolmentrole_help'] = 'Dinamički meni sa spiskom kurseva će sadržavati sve kurseve u kojima je korisnik upisan sa izabranom ulogom.';
$string['smartmenusexperimental'] = 'Napomena: funkcija pametnih menija se u potpunosti može koristiti u trenutnom stanju implementacije, ali se mora <em>smatrati kao eksperimentalna</em> zbog velikog broja kombinacija podešavanja, koja i dalje mogu izazvati neočekivane probleme. Imajući ovo u vidu, molimo vas da detaljno i pažljivo testirate svoje pametne menije sa svim njihovim pojedinačnim podešavanjima. Ako naiđete na bilo kakve probleme sa pametnim menijima, molimo vas da ih prijavite na <a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github</a> sa jasno opisanim koracima, kako bi programeri mogli da reprodukuju prijavljeni problem.';
$string['smartmenusgeneralsectionheader'] = 'Opšta podešavanja';
$string['smartmenusmenuaddnewitem'] = 'Dodajte stavku menija';
$string['smartmenusmenucardform'] = 'Oblik kartice';
$string['smartmenusmenucardform_help'] = 'Izaberite oblik kartice za menije u stilu kartice, birajući između kvadrata, portretretne/pejсažne orijentacije ili pune širine.';
$string['smartmenusmenucardformfullwidth'] = 'Puna širina';
$string['smartmenusmenucardformlandscape'] = 'Pejzažna orijentacija';
$string['smartmenusmenucardformportrait'] = 'Portretna orijentacija';
$string['smartmenusmenucardformsquare'] = 'Kvadrat';
$string['smartmenusmenucardoverflowbehavior'] = 'Ponašanje kartice kod predugih stavki';
$string['smartmenusmenucardoverflowbehavior_help'] = 'Izaberite kako da se ponaša meni kada dužina naziva stavki prevazilazi širinu menija, birajući između prikazivanja horizontalne klizne trake ili prelamanja naziva stavki.';
$string['smartmenusmenucardoverflowbehaviornowrap'] = 'Bez prelamanja';
$string['smartmenusmenucardoverflowbehaviorwrap'] = 'Prelamanje naziva stavki';
$string['smartmenusmenucardsize'] = 'Duplirajte meni i njegove stavke';
$string['smartmenusmenucardsize_help'] = 'Izaberite veličinu kartice za menije u stilu kartice, birajući između veoma male (50 piksela), male (100), srednje (150) ili velike kartice (200).';
$string['smartmenusmenucardsizelarge'] = 'Velika';
$string['smartmenusmenucardsizemedium'] = 'Srednja';
$string['smartmenusmenucardsizesmall'] = 'Mala';
$string['smartmenusmenucardsizetiny'] = 'Veoma mala';
$string['smartmenusmenucreate'] = 'Kreirajte meni';
$string['smartmenusmenucreatesuccess'] = 'Pametni meni je uspešno kreiran';
$string['smartmenusmenucssclass'] = 'CSS klasa';
$string['smartmenusmenucssclass_help'] = 'Unesite CSS klasu za meni. Ovo se može koristiti za primenu prilagođenog stila na meni.';
$string['smartmenusmenudeleteconfirm'] = 'Da li ste sigurni da želite da obrišete ovaj meni iz pametnih menija?';
$string['smartmenusmenudeletesuccess'] = 'Pametni meni je uspešno obrisan';
$string['smartmenusmenudescription'] = 'Opis';
$string['smartmenusmenudescription_help'] = 'Opis menija. Ovo će se prvenstveno koristiti kao interna dokumentacija, ali ga možete prikazati i u meniju pomoću opcije \'Prikaži opis\'.';
$string['smartmenusmenuduplicate'] = 'Duplirajte meni i njegove stavke';
$string['smartmenusmenuduplicatesuccess'] = 'Meni i njegove stavke su uspešno duplirane';
$string['smartmenusmenuedit'] = 'Uredi meni';
$string['smartmenusmenueditsuccess'] = 'Pametni meni je uspešno ažuriran';
$string['smartmenusmenuitemcardappearanceheader'] = 'Izgled kartice';
$string['smartmenusmenuitemcardbackgroundcolor'] = 'Pozadinska boja kartice';
$string['smartmenusmenuitemcardbackgroundcolor_help'] = 'Izaberite pozadinsku boju za karticu stavke u meniju';
$string['smartmenusmenuitemcardimage'] = 'Slika kartice';
$string['smartmenusmenuitemcardimage_help'] = 'Izaberite sliku koja će biti prikazana pored naslova stavke u meniju na kartici.';
$string['smartmenusmenuitemcardimagealt'] = 'Alternativni tekst slike kartice';
$string['smartmenusmenuitemcardimagealt_help'] = 'Alternativni tekst za sliku kartice ove stavke u meniju. Možete koristiti rezervisano mesto {menutitle} kako biste umetnuli konfigurisani naslov stavke u meniju u svoj alternativni tekst. Ako ovo polje ostavite potpuno prazno, tekst stavke u meniju će se automatski koristiti kao alternativni tekst.';
$string['smartmenusmenuitemcardtextcolor'] = 'Boja teksta na kartici';
$string['smartmenusmenuitemcardtextcolor_help'] = 'Izaberite boju za karticu stavke u meniju.';
$string['smartmenusmenuitemcreate'] = 'Kreirajte stavku u meniju';
$string['smartmenusmenuitemcreatesuccess'] = 'Stavka u pametnom meniju je uspešno kreirana';
$string['smartmenusmenuitemcssclass'] = 'CSS klasa';
$string['smartmenusmenuitemcssclass_help'] = 'Unesite CSS klasu za stavku u meniju. Ovo se može koristiti za primenu prilagođenog stila na stavku u meniju.';
$string['smartmenusmenuitemdeleteconfirm'] = 'Da li ste sigurni da želite da obrišete ovu stavku menija iz pametnog menija?';
$string['smartmenusmenuitemdeletesuccess'] = 'Stavka u pametnom meniju je uspešno obrisana';
$string['smartmenusmenuitemdisplayallcourses'] = 'Prikaži sakrivene kurseve';
$string['smartmenusmenuitemdisplayfield'] = 'Prikaz naziva kursa';
$string['smartmenusmenuitemdisplayfield_help'] = 'Naziv kursa koji će se koristiti kao naslov stavki u dinamičkom menija kurseva. Izaberite između punog i skraćenog naziva kursa';
$string['smartmenusmenuitemdisplayfieldcoursefullname'] = 'Pun naziv kursa';
$string['smartmenusmenuitemdisplayfieldcourseshortname'] = 'Skraćeni naziv kursa';
$string['smartmenusmenuitemdisplayonlyvisiblecourses'] = 'Prikaz sakrivenih kurseva';
$string['smartmenusmenuitemdisplayonlyvisiblecourses_help'] = 'Ako je ova opcija omogućena, na spisku kurseva neće biti prikazani skriveni kursevi ni u jednom pametnom meniju, čak ni za administratore i korisnike koji imaju mogućnost moodle/course:viewhiddencourses na kursu.';
$string['smartmenusmenuitemdisplayoptions'] = 'Prikaz naslova stavke';
$string['smartmenusmenuitemdisplayoptions_help'] = 'Izaberite kako želite da bude prikazan naslov stavke u meniju.';
$string['smartmenusmenuitemdisplayoptionshidetitle'] = 'Sakrijte tekst naslova i prikažite samo ikonicu (na svim uređajima)';
$string['smartmenusmenuitemdisplayoptionshidetitlemobile'] = 'Sakrijte tekst naslova i prikažite samo ikonicu (mobilni uređaji)';
$string['smartmenusmenuitemdisplayoptionsshowtitleicon'] = 'Prikaži tekst i ikonicu kao naslov';
$string['smartmenusmenuitemduplicate'] = 'Duplirajte stavku u meniju';
$string['smartmenusmenuitemduplicatesuccess'] = 'Stavka u meniju je uspešno duplirana';
$string['smartmenusmenuitemedit'] = 'Uredi stavku u meniju';
$string['smartmenusmenuitemeditsuccess'] = 'Stavka u pametnom meniju je uspešno ažurirana';
$string['smartmenusmenuitememail'] = 'E-adresa primaoca';
$string['smartmenusmenuitememail_help'] = 'Adresa e-pošte primaoca za stavku u meniju. Ovo će se koristiti za kreiranje linka za slanje pošte koji se otvara kada se klikne na stavku u meniju.';
$string['smartmenusmenuitememail_required'] = 'Obavezno – Molimo vas da unesete važeću adresu e-pošte bez prefiksa \'mailto:\'.';
$string['smartmenusmenuitemhiddencoursesortingend'] = 'Prikaži sakrivene kurseve na kraju spiska kurseva';
$string['smartmenusmenuitemhiddencoursesortingtogether'] = 'Sortirajte skrivene i vidljive kurseve zajedno';
$string['smartmenusmenuitemhiddencoursessorting'] = 'Sortiranje skrivenih kurseva';
$string['smartmenusmenuitemhiddencoursessorting_help'] = 'Izaberite kako treba sortirati skrivene kurseve na spisku kurseva u meniju dinamičkih kurseva.';
$string['smartmenusmenuitemhidehiddencourses'] = 'Sakrij skrivene kurseve';
$string['smartmenusmenuitemicon'] = 'Ikonica';
$string['smartmenusmenuitemicon_ajaxtoomanyicons'] = 'Previše ikonica ({$a}) za prikaz. Molimo vas da suzite pretragu.';
$string['smartmenusmenuitemicon_help'] = 'Ikonica koja se prikazuje pored naslova stavke u meniju. <br /><br /> Možete izabrati ikoncu iz osnovne biblioteke ikonica Moodlea ili koristiti FontAwesome ikonicu. Ovo je važna razlika:ul><li> Osnovne Moodle ikonice:<br />Osnovna Moodle instalacija definiše svoje ikonice "pix ikonice" i FontAwesome ikonice mapira na ove "pix ikonice". Nije garantovano da će mapirana FontAwesome ikonica zauvek biti stabilna; ona može biti promenjena u budućim verzijama osnovne Moodle instalacije. Pored toga, u osnovnoj instalaciji Moodlea postoje”pix ikonice” koje dolaze sa dodatnom Bootstrap bojom.</li><li>FontAwesome ikonice:<br />FontAwesome ikonice se koriste takve kakve jesu i njihov prikaz će ostati stabilan u budućim izdanjima Moodlea. Može se desiti da se FontAwesome sličica (glif) promeni ukoliko se osnovna instalacija Moodlea nadogradi na novo izdanje FontAwesomea.</li></ul>Ako ste u nedoumici, i pri tome ne morate da se držite određene "pix ikonice" iz osnovne instalacije Moodlea, onda bi trebalo da ovde upotrebite FontAwesome ikonicu.';
$string['smartmenusmenuitemicon_noicon'] = 'Nije izabrana nijedna ikonica';
$string['smartmenusmenuitemicon_placeholder'] = 'Izaberite ikonicu';
$string['smartmenusmenuitemicon_sourcecore'] = 'Moodle osnovna instalacija';
$string['smartmenusmenuitemicon_sourcefablank'] = 'FontAwesome prazna ikonica';
$string['smartmenusmenuitemicon_sourcefabrand'] = 'FontAwesome brendirane ikonice';
$string['smartmenusmenuitemicon_sourcefasolid'] = 'FontAwesome ikonice punog izgleda';
$string['smartmenusmenuitemlinktarget'] = 'Odredište linka';
$string['smartmenusmenuitemlinktarget_help'] = 'Odredište linka stavke u meniju. Link će se otvoriti u ovom odredištu kada se klikne na njega (tj. u istom ili u novom prozoru).';
$string['smartmenusmenuitemlinktargetnewtab'] = 'Novi prozor';
$string['smartmenusmenuitemlinktargetsamewindow'] = 'Isti prozor';
$string['smartmenusmenuitemlistsort'] = 'Sortiranje spiska kurseva';
$string['smartmenusmenuitemlistsort_help'] = 'Spisak kurseva biće sortiran prema izabranim kriterijumima i redosledu sortiranja. Izaberite između punog naziv, skraćenog naziva, ID oznake kursa i ID broja kursa kao kriterijuma u kombinaciji sa rastućim i opadajućim redosledom sortiranja.';
$string['smartmenusmenuitemlistsortcourseidasc'] = 'ID oznaka kursa rastućim redosledom';
$string['smartmenusmenuitemlistsortcourseiddesc'] = 'ID oznaka kursa opadajućim redosledom';
$string['smartmenusmenuitemlistsortcourseidnumberasc'] = 'ID broj kursa rastućim redosledom';
$string['smartmenusmenuitemlistsortcourseidnumberdesc'] = 'ID broj kursa opadajućim redosledom';
$string['smartmenusmenuitemlistsortfullnameasc'] = 'Pun naziv kursa rastućim redosledom';
$string['smartmenusmenuitemlistsortfullnamedesc'] = 'Pun naziv kursa opadajućim redosledom';
$string['smartmenusmenuitemlistsortshortnameasc'] = 'Skraćeni naziv kursa rastućim redosledom';
$string['smartmenusmenuitemlistsortshortnamedesc'] = 'Skraćeni naziv kursa opadajućim redosledom';
$string['smartmenusmenuitemmode'] = 'Režim prikaza stavke u meniju';
$string['smartmenusmenuitemmode_help'] = '<p>Izaberite način na koji će stavke biti prikazana u okviru samog menija.</p><ul><li>Direktno: Stavka se prikazuje kao obična stavka u okviru menija. Ovo je podrazumevana opcija.<li><li>Podmeni: stavka se prikazuje kao stavka u podmeniju, koja se može proširiti ili skupiti klikom na nadređenu stavku. Ovaj režim je koristan za formiranje trećeg nivoa navigacije, kao i za stavke u meniju dinamičkih kurseva, gde spiskovi kurseva mogu biti prikazani kao stavke u podmeniju ove stavke u (glavnom) meniju. Naslov ove stavke u meniju se koristi kao tekst za stavku u podmeniju.</li></ul>';
$string['smartmenusmenuitemnothingtodisplay'] = 'Još uvek nije dodata nijedna stavka u ovaj pametni meni. Molimo dodajte stavku u ovaj meni.';
$string['smartmenusmenuitemorder'] = 'Redosled';
$string['smartmenusmenuitemorder_help'] = 'Promenite položaj stavke ako je potrebno. Sve stavke u meniju biće poređane na osnovu ove vrednosti za redosled.';
$string['smartmenusmenuitempresentationheader'] = 'Prikaz stavki u meniju';
$string['smartmenusmenuitemresponsive'] = 'Prilagodljivo skrivanje stavki menija';
$string['smartmenusmenuitemresponsive_help'] = 'Ako označite bilo koje od ovih polja za potvrdu, stavka u meniju će biti skrivena na uređajima sa datom veličinom ekrana, odnosno uređajima koje ste ovde označili.';
$string['smartmenusmenuitemresponsivedesktop'] = 'Stoni računar';
$string['smartmenusmenuitemresponsivemobile'] = 'Mobilni telefon';
$string['smartmenusmenuitemresponsivetablet'] = 'Tablet';
$string['smartmenusmenuitemrestriction'] = 'Pravila pristupa';
$string['smartmenusmenuitems'] = 'Stavke u meniju';
$string['smartmenusmenuitemstructureheader'] = 'Struktura menija';
$string['smartmenusmenuitemtextcount'] = 'Broj reči';
$string['smartmenusmenuitemtextcount_help'] = 'Odredite maksimalan broj reči koje će biti prikazan kao naslov u stavkama u meniju dinamičkih kurseva. Ako ostavite ovo polje prazno, naslov će biti prikazan u punoj dužini.';
$string['smartmenusmenuitemtextposition'] = 'Pozicija teksta na kartici';
$string['smartmenusmenuitemtextposition_help'] = '<p>Izaberite poziciju teksta stavke u meniju u odnosu na sliku kartice, birajući između opcija: ispod slike, preklapajući natpis na vrhu odnosno na dnu.</p><ul><li>Preklapajući natpis na vrhu: prikazuje naslov stavke u meniju kao transparentni preklapajući prozor na vrhu kartice.</li><li>Preklapajući natpis na dnu:  prikazuje naslov stavke u meniju kao transparentni preklapajući prozor na dnu kartice.</li><li>Ispod slike: prikazuje naslov stavke u meniju ispod slike kartice.</li></ul>';
$string['smartmenusmenuitemtextpositionbelowimage'] = 'Ispod slike';
$string['smartmenusmenuitemtextpositionoverlaybottom'] = 'Preklapajući natpis na dnu';
$string['smartmenusmenuitemtextpositionoverlaytop'] = 'Preklapajući natpis na vrhu';
$string['smartmenusmenuitemtitle'] = 'Naslov';
$string['smartmenusmenuitemtitle_help'] = 'Naslov menija. Ovo će se koristiti kao natpis ove stavke u meniju.';
$string['smartmenusmenuitemtooltip'] = 'Kratak opis stavke';
$string['smartmenusmenuitemtooltip_help'] = 'Kratak opis stavke koji će biti prikazan kada korisnik pređe mišem preko stavke u meniju.';
$string['smartmenusmenuitemtype'] = 'Tip stavke u meniju';
$string['smartmenusmenuitemtype_help'] = '<p>Izaberite tip stavke u meniju koju želite da kreirate, birajući između statičke stavke, naslova, Moodle dokumentacije, dinamičkih kurseva i razdelnika.</p><ul><li>Statička stavka: ovo je jednostavan link ka fiksnoj URL adresi koja se ne menja.</li><li>Naslov : ovaj tip stavke u meniju se koristi za grupisanje srodnih, povezanih stavki pod zajedničkim naslovom. Ovaj tip nema link i na njega se ne može kliknuti.</li><li>Separator : stavka za razdvajanja prikazuje horizontalnu liniju u meniju kako bi vizuelno razdvojila grupe stavki u meniju.</li><li>Moodle dokumentacija: ova stavka u meniju se povetuje sa odgovrajučim MoodleDocs stranicom (člankom), nešto slično MoodleDocs linku koji se nalazi u podnožju stranice (ikonica sa znakom pitanja).</li><li>Dinamički kursevi: ovaj tip stavke se koristi za prikaz spiska kurseva na osnovu određenih kriterijuma, kao što su kategorija kursa, uloga na upisanom kursu, status završetka kursa ili vremenski period. Sadržaj prikazan u ovom tipu menija će se automatski ažurirati kako se kriterijumi menjaju.</li></ul>';
$string['smartmenusmenuitemtypedivider'] = 'Razdelnik';
$string['smartmenusmenuitemtypedocs'] = 'Moodle dokumentacija';
$string['smartmenusmenuitemtypedynamiccourses'] = 'Dinamički kursevi';
$string['smartmenusmenuitemtypeheading'] = 'Naslov';
$string['smartmenusmenuitemtypestatic'] = 'Statička stavka';
$string['smartmenusmenuitemurl'] = 'URL adresa stavke u meniju';
$string['smartmenusmenuitemurl_help'] = 'Statička URL adresa stavke u meniju. Ovo je link ka stranici koja će se otvoriti kada se klikne na stavku u meniju.';
$string['smartmenusmenulocation'] = 'Pozicija (e) menija';
$string['smartmenusmenulocation_help'] = '<p>Izaberite poziciju(e) na kojoj želite da se meni pojavi na stranici:</p><ul><li>Glavna navigacija je na vrhu stranice gde se već nalaze stavke navigacije \'Početna stranica\', \'Kontrolni panel\', \'Moji kursevi\' i\'Administracija sajta\'.</li><li>Traka menija se nalazi iznad glavne navigacije,  na vrhu stranice.<li><li>Korisničkom meniju se može pristupiti klikom na avatar korisnika na traci za navigaciju.</li><li>Donja traka se nalazi na dnu ekrana i veoma je korisna za navigaciju na mobilnim telefonima jer se pomoću palca može lako pristup važnim poljima na stranici, kao što su kontrolni panel,  stranici\'Moji kursevi\' ili početnoj stranici.</li></ul><p>Imajte na umu da će nakon što omogućite donju traku, ikonica hamburgera biti zamenjena logotipom vašeg sajta, jer korisnici mogu da dođu do glavne navigacije pomoću donje trake.</p>';
$string['smartmenusmenulocationbottom'] = 'Donja traka';
$string['smartmenusmenulocationmain'] = 'Glavna navigacija';
$string['smartmenusmenulocationmenu'] = 'Traka menija';
$string['smartmenusmenulocationuser'] = 'Korisnički meni';
$string['smartmenusmenumode'] = 'Režim menija';
$string['smartmenusmenumode_help'] = '<p>Izaberite način na koji će stavke u meniju biti prikazane.</p><ul><li>Podmeni: stavke u meniju se prikazuju kao podmeni sa naslovom menija kao nadređenim čvorom. Ovo je podrazumevana opcija.</li><li>Direktno: Stavke u meniju se prikazuju direktno u navigaciji, jedna za drugom. Imajte na umu da ova opcija nije podržana za menije tipa kartice.</li></ul>';
$string['smartmenusmenumoremenubehavior'] = 'Ponašanje dodatnih menija';
$string['smartmenusmenumoremenubehavior_help'] = '<p>Izaberite šta bi trebalo da se desi ako ima previše menija koji bi mogli da se uklope u poziciju(e) menija, koju(e) ste izabrali.</p><ul><li>Ne menjajte ništa: Neće se primenjivati nikakvo posebno ponašanje, višak menija će automatski biti premešten u meni \'Više\'.</li><li>Prebacite meni obavezno u meni \'Više\': Ovaj režim premešta meni direktno u meni \'Više\', čak i ako još uvek ima dovoljno mesta.</li><li>Držite meni izvan menija \'Više\': ovaj režim drži meni izvan menija \'Više\' što je duže moguće - drugi naknadni meniji se premeštaju u meni \'Više\' ako je potrebno.</li></ul><p>Imajte na umu da ovo podešavanje utiče samo na menije koji se nalaze u glavnoj navigaciji ili u oblasti trake menija.</p>';
$string['smartmenusmenumoremenubehaviorforceinto'] = 'Prebacite meni obavezno u meni \'Više\'';
$string['smartmenusmenumoremenubehaviorkeepoutside'] = 'Držite meni izvan menija \'Više\'';
$string['smartmenusmenunothingtodisplay'] = 'Još uvek nije kreiran nijedan pametan meni. Kreirajte svoj prvi pametni meni kako biste ga pokrenuli.';
$string['smartmenusmenupresentationheader'] = 'Prikaz menija';
$string['smartmenusmenushowdescription'] = 'Prikaži opis';
$string['smartmenusmenushowdescription_help'] = '<p>Izaberite da li i kako opis treba da bude prikazan u meniju, birajući između sledećih opcija: Nikad, Iznad, Ispod i Pomoć.</p><ul><li>Nikad: ne prikazujte opis u meniju i koristite ga samo za interne svrhe. Ovo je podrazumevana opcija.</li><li>Iznad: prikaži opis na vrhu spiska stavki u meniju.</li><li>Ispod: prikaži opis na kraju spiska stavki u meniju.</li><li>Pomoć: pokaži opis kao ikonicu za pomoć u blizini spiska stavki u meniju.</li></ul>';
$string['smartmenusmenushowdescriptionabove'] = 'Iznad';
$string['smartmenusmenushowdescriptionbelow'] = 'Ispod';
$string['smartmenusmenushowdescriptionhelp'] = 'Pomoć';
$string['smartmenusmenushowdescriptionnever'] = 'Nikada';
$string['smartmenusmenustructureheader'] = 'Struktura menija';
$string['smartmenusmenutitle'] = 'Naslov';
$string['smartmenusmenutitle_help'] = 'Naslov menija. Ovo će se koristiti kao natpis nadređenog čvora ovog menija.';
$string['smartmenusmenutype'] = 'Tip prikaza menija';
$string['smartmenusmenutype_help'] = '<p>Izaberite tip prikaza menija, birajući između spiska i kartice.</p><ul><li>Spisak: meni se sastoji od spiska jednostavnih tekstualnih linkova. Ovo je podrazumevana opcija.</li><li>Kartica: meni se sastoji od kartica.</li></ul>';
$string['smartmenusmenutypecard'] = 'Kartica';
$string['smartmenusmenutypelist'] = 'Spisak';
$string['smartmenusmodeinline'] = 'Direktno';
$string['smartmenusmodesubmenu'] = 'Podmeni';
$string['smartmenusnorestrict'] = 'Nije ograničeno';
$string['smartmenusoperator'] = 'Logički operator';
$string['smartmenusoperator_help'] = 'Izaberite operator za uslov kohorte (bilo koji ili svi)';
$string['smartmenusrestrictbyadminheader'] = 'Ograničite vidljivost prema statusu administratora sajta';
$string['smartmenusrestrictbycohortsheader'] = 'Ograničite vidljivost prema kohortama';
$string['smartmenusrestrictbydateheader'] = 'Ograničite vidljivost prema datumu';
$string['smartmenusrestrictbylanguageheader'] = 'Ograničite vidljivost prema datumu';
$string['smartmenusrestrictbyrolesheader'] = 'Ograničite vidljivost prema ulogama';
$string['smartmenusrolecontext'] = 'Kontekst';
$string['smartmenusrolecontext_help'] = 'Izaberite kontekst za koji treba proveriti ulogu korisnika (bilo koji kontekst ili samo u kontekstu sistema)';
$string['smartmenussavechangesandconfigure'] = 'Sačuvajte i konfigurišite stavke';
$string['smartmenussettings'] = 'Podešavanja pametnog menija';
$string['snippetsbuiltinsnippetsheading'] = 'Уграђени одломци кôда';
$string['snippetscreator'] = 'Kreator';
$string['snippetsdescription'] = 'Opis';
$string['snippetsdetails'] = 'Detaljne informacije';
$string['snippetsdetailspreview'] = 'Pregled';
$string['snippetsdisable'] = 'Onemogući';
$string['snippetsenable'] = 'Онемогући';
$string['snippetsgoal'] = 'Cilje';
$string['snippetsgoalaccessibility'] = 'Pristupačnost';
$string['snippetsgoalbugfix'] = 'Ispravka grešaka';
$string['snippetsgoaldevsonly'] = 'Samo za programere';
$string['snippetsgoaleaseofuse'] = 'Jednostavnost korišćenja';
$string['snippetsgoaleyecandy'] = 'Atraktivno';
$string['snippetsnothingtodisplay'] = 'Ne postoje SCSS isečci kôda koji se mogu upotrebiti. Molimo vas da idete na karticu za podešavanja i omogućite korišćenje ugrađenih SCSS isečaka kôda ili otpremite svoje SCSS isečke kôda.';
$string['snippetsoverview'] = 'Pregled';
$string['snippetsoverview_desc'] = 'SCSS isečci kôda Boost Union teme pružaju mogućnost dodavanja manje ili više SCSS kôdvaa na Moodle sajt. Ovo može biti posebno korisno za ispravljanje manjih vizuelnih grešaka u osnovnoj instalaciji Moodle paketa ili za dodavanje atraktivnih vizuelnog efekta vašem Moodle sajtu.';
$string['snippetsoverview_notes'] = 'Kako biste mogli da koristite SCSS isečke kôda, pročitajte ova osnovna uputstva:';
$string['snippetsoverview_notes1'] = 'SCSS isečci kôda mogu doći iz različith izvora. Svaki izvor omogućavate i konfigurišete na kartici \'Podešavanja\'. Čim omogućite barem jedan izvor, ovde ćete videti spisak isečaka.';
$string['snippetsoverview_notes2'] = 'SCSS isečci kôda se dodaju na SCSS stek jedan za drugim. Stoga je redosled isečaka na ovoj stranici ključan.';
$string['snippetsoverview_notes3'] = 'Nakon svake promene koju učinite na ovoj stranici, keš memorija grafičke teme se briše. Ovo je neophodno kako bi se osiguralo da kompajlirani SCSS kôd koji se šalje veb čitaču bude ažuriran. Samo brisanje keša i kompajliranje može potrajati nekoliko sekundi.';
$string['snippetsscope'] = 'Opseg';
$string['snippetsscopecourse'] = 'Kurs';
$string['snippetsscopedashboard'] = 'Kontrolni panel';
$string['snippetsscopeglobal'] = 'Globalno';
$string['snippetsscopesitehome'] = 'Početna stranica sajta';
$string['snippetssettings'] = 'Podešavanja';
$string['snippetsshowdetails'] = 'Prikaži detaljne podatke';
$string['snippetsshowthecode'] = 'Prikaži SCSS kôd';
$string['snippetssnippets'] = 'SCSS isečci kôda';
$string['snippetssource'] = 'Izvor';
$string['snippetssourcetheme_boost_union'] = 'Ugrađeni u grafičku temu Boost Union';
$string['snippetssourceuploaded'] = 'Otpremi';
$string['snippetstestedon'] = 'Testirano na';
$string['snippetstitle'] = 'Naslov';
$string['snippetstrackerissue'] = 'Praćenje problema';
$string['snippetsuploadedsnippetsheading'] = 'Otpremljeni isečci kôda';
$string['snippetsuploadedsnippetsheading_desc'] = 'Pored ugrađenih SCSS isečaka koje zvanično održava Boost Union tim, postoji i <a href="{$a}" target="_blank">Repozitorijum SCSS isečaka na Github platformi</a> koji predstavlja centralnu zajednicu korisnika za Boost Union SCSS isečke. Uputstva za korišćenje SCSS isečaka zajednice korisnika, kao i šablon za kreiranje sopstvenih lokalnih SCSS isečaka, možete pronaći u tom repozitorijumu.';
$string['snippetsusagenote'] = 'Napomena o upotrebi';
$string['speciallinksmarkupheading'] = 'Označavanje specijalnih linkova';
$string['starredcourseslinktargetsetting'] = 'Odredišni link za ikonicu zupčanika u iskačućem prozoru kurseva označenih zvezdicom.';
$string['starredcourseslinktargetsetting_desc'] = 'Sa ovim podešavanjem možete postaviti odredište linka za ikonicu zupčanika u iskačućem meniju kurseva označenih zvezdicom. Podrazumevano, ikonica zupčanika vodi do stranice \'Moji kursevi\'. Međutim, možete postaviti link i do stranice \'Kontrolni panel\', posebno ako ste onemogućili stranicu \'Moji kursevi\' u primarnoj navigaciji.';
$string['staticpagestab'] = 'Statične stranice';
$string['switchedroleto'] = 'Trenutno posmatrate ovaj kurs sa ulogom: <strong>{$a->role}</strong>';
$string['task_purgecache'] = 'Očistite keš teme';
$string['templateemailhtmlprefix'] = '';
$string['templateemailhtmlsuffix'] = '';
$string['templateemailtextprefix'] = '';
$string['templateemailtextsuffix'] = '';
$string['tertiarysettings'] = 'Spisak stranica sa podešavanjima Boost Uniona';
$string['tilebackgroundimagepositionsetting'] = 'Pozicija pozadinske slike reklamne pločice {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Sa ovim podešavanjem kontrolišete pozicioniranje pozadinske slike unutar kontejnera reklamne pločice  {$a->no}. Prva vrednost je horizontalni, druga vertikalni položaj.';
$string['tilebackgroundimagesetting'] = 'Pozadinska slika reklamne pločice {$a->no}';
$string['tilebackgroundimagesetting_desc'] = 'Ovde možete da postavite datoteku slike koja će biti prikazana kao pozadinska slika iza sadržaja reklamne pločice {$a->no}. Proverite da li je sadržaj i dalje čitljiv na pozadinskoj slici. Ovo je opciono podešavanje, reklamna pločica će biti prikazana čak i ako ne postavite pozadinsku sliku.';
$string['tilecolumnssetting'] = 'Broj kolona reklamnih pločica po redu';
$string['tilecolumnssetting_desc'] = 'Ovde definišete broj kolona po redu u prikazanoj mreži reklamnih pločica. Imajte na umu da se ovaj broj kolona odnosi na desktop/veće ekrane. Na manjim ekranima i mobilnim ekranima, kolone reklamnih pločica se automatski pakuju.';
$string['tilecontentsetting'] = 'Sadržaj reklamne pločice {$a->no}';
$string['tilecontentsetting_desc'] = 'Ovde unosite sadržaj koji treba da bude prikazan u reklamnoj pločici {$a->no}. Sadržaj se prikazuje u sredini pločice. Ovo je opciono podešavanje, reklamna pločica će biti prikazana čak i ako ne postavite nikakav sadržaj.';
$string['tilecontentstylesetting'] = 'Stil sadržaja reklamne pločice {$a->no}';
$string['tilecontentstylesetting_dark'] = 'Tamno (crna boja fonta za svetle pozadinske slike)';
$string['tilecontentstylesetting_darkshadow'] = 'Tamno sa senkom (crna boja fonta sa svetlom senkom za svetle pozadinske slike)';
$string['tilecontentstylesetting_desc'] = 'Ovde možete da izmenite stil sadržaja reklamne pločice {$ a->no}. Standardno, stil sadržaja je pod kontrolom stila koji ste podesili u editoru teksta iznad. Međutim, da biste omogućili dosledan i lak stil, posebno kada koristite tekst na pozadinskim slikama, ovde možete izmeniti stil.';
$string['tilecontentstylesetting_light'] = 'Svetlo (bela boja fonta za tamne pozadinske slike)';
$string['tilecontentstylesetting_lightshadow'] = 'Svetlo sa senkom (bela boja fonta sa tamnom senkom za tamne pozadinske slike)';
$string['tilecontentstylesetting_nochange'] = 'Bez promena (kontrolišite sve stilove u editoru teksta)';
$string['tileenabledsetting'] = 'Omogućite reklamnu pločicu {$a->no}';
$string['tileenabledsetting_desc'] = 'Sa ovim podešavanjem možete omogućiti reklamnu pločicu {$a->no}.';
$string['tilefrontpagepositionsetting'] = 'Pozicija reklamnih pločica na naslovnoj stranici';
$string['tilefrontpagepositionsetting_after'] = 'Nakon sadržaja naslovne stranice';
$string['tilefrontpagepositionsetting_before'] = 'Pre sadržaja naslovne stranice';
$string['tilefrontpagepositionsetting_desc'] = 'Reklamne pločice se prikazuju samo na naslovnoj stranici sajta. Sa ovim podešavanjem kontrolišete da li se reklamne pločice prikazuju pre ili posle sadržaja naslovne stranice. Ako na naslovnoj stranici sajta želite da prikažete samo reklamne pločice  i ništa drugo, sav ostali sadržaj naslovne stranice možete ukloniti promenom <a href="{$a->url}">podešavanja naslovne stranice</a>.';
$string['tileheading'] = 'Reklamna pločica {$a->no}';
$string['tileheightsetting'] = 'Visina reklamnih pločica';
$string['tileheightsetting_desc'] = 'Sa ovim podešavanje kontrolišete visinu reklamnih pločica. Konfigurisana visina je minimalna visina svake pločice. Ako je sadržaj pločice veći od ove visine, ceo red pločica biće automatski uvećan po potrebi.';
$string['tilelinksetting'] = 'URL adresa linka reklamne pločice {$a->no}';
$string['tilelinksetting_desc'] = 'Ovde možete podesiti (Moodle-internu ili eksternu) URL adresu koja će biti ponuđena kao link za dugme za na dnu reklamne pločice {$a->no}. Ovo je opciono podešavanje, reklamne pločice će biti prikazana čak i ako ne podesite URL adresu linka.';
$string['tilelinktargetsetting'] = 'Odredište linka reklamne pločice {$a->no}';
$string['tilelinktargetsetting_desc'] = 'Ovde možete da podesite odredište linka koji je postavljen kao link dugmeta čim postavite URL adresu linka u reklamnoj pločici {$a->no}.';
$string['tilelinktargetsetting_newtab'] = 'Novi prozor';
$string['tilelinktargetsetting_samewindow'] = 'Isti prozor';
$string['tilelinktitlefallback'] = 'Link';
$string['tilelinktitlesetting'] = 'Naslov linka reklamne pločice {$a->no}';
$string['tilelinktitlesetting_desc'] = 'Ovde možete podesiti naslov linka, koji se koristi kao natpis na dugmeta linka čim unesete URL adrese linka u reklamnu pločicu {$a->no}. Imajte na umu da ukoliko unesete URL adresu, ali ne i naslov linka, dugme linka biće označeno natpisom \'Link\'';
$string['tileordersetting'] = 'Pozicija reklamne pločice {$a->no}';
$string['tileordersetting_desc'] = 'Sa ovim podešavanjem definišete poziciju reklamne pločice {$a->no}. Standardno, reklamne pločice su poređane odozgo prema dole i sa leva na desno, kao što ih vidite na ovoj stranici sa podešavanjima. Međutim, sa ovim podešavanjem možete reklamnoj pločici da dodelite drugu poziciju. Ako dodelite istu poziciju za dve ili više reklamnih pločica, one će biti ponovo poređane prema redosledu na ovoj stranici sa podešavanjima.';
$string['tilesgeneralheading'] = 'Opšta podešavanja reklamnih pločica';
$string['tilestab'] = 'Reklamne pločice';
$string['tiletitlesetting'] = 'Naslov reklamne pločice {$a->no}';
$string['tiletitlesetting_desc'] = 'Here, you enter the title which should be displayed in the advertisement tile {$a->no}. This is an optional setting, the advertisement tile will be shown even if you do not set a title.';
$string['timelineheading'] = 'Blok \'Vremenski raspored\'';
$string['timelinetintenabled'] = 'Obojite ikonice aktivnosti u bloku \'Hronologija\'';
$string['timelinetintenabled_desc'] = 'Sa ovim podešavanjem možete da obojite ikonice aktivnosti u bloku \'Hronologija\' na osnovu svrhe aktivnosti. Standardno , Moodle ih prikazuje samo kao crno obojene ikonice.';
$string['touchiconfilesios'] = 'Datoteka ikonica osetljivih na dodir za iOS';
$string['touchiconfilesios_desc'] = 'U okviru ovog podešavanja, možete da postavite datoteke koje se koriste kao ikonice na početnom ekranu čim se Moodle sajt doda na iOS početni ekran.';
$string['touchiconfilesios_example'] = 'Primer naziva datoteke: apple-icon-152x152.png';
$string['touchiconfilesios_note'] = 'Preporučene datoteke imaju odgovarajuću veličinu za prikaz na trenutnim iOS uređajima te bi ih trebalo obezbediti. Opcione datoteke jesu (ili su ranije bile) podržane i na iOS uređajima, ali ih zaista treba smatrati opcionim osim ako nemate određene zastarele uređaje koje treba podržati.';
$string['touchiconfilesios_optional'] = 'Opcione datoteke za iOS:';
$string['touchiconfilesios_recommended'] = 'Preporučene datoteke za iOS:';
$string['touchiconfilesioslist'] = 'Spisak datoteka osetljivih na dodir ikonica za iOS';
$string['touchiconfilesioslist_desc'] = 'Ovo je spisak datoteka koje ste postavili u prostor za datoteke među datoteke ikonica osetljivih na dodir za iOS.';
$string['touchiconlistiosoptionalmissing'] = 'Ovo je opciona datoteka, koja se koristi kao ikonica osetljiva na dodir na iOS uređajima, i koja nije postavljena.';
$string['touchiconlistiosoptionaluploaded'] = 'Ovo je opciona datoteka, koja se koristi kao ikonica osetljiva na dodir na iOS uređajima, i koja je postavljena.';
$string['touchiconlistiosrecommendedmissing'] = 'Ovo je preporučena datoteka, koja se koristi kao ikonica osetljiva na dodir na iOS uređajima, i koja nije pravilno postavljena.';
$string['touchiconlistiosrecommendeduploaded'] = 'Ovo je preporučena datoteka, koja se koristi kao ikonica osetljiva na dodir na iOS uređajima, i koja je postavljena.';
$string['upcomingeventsheading'] = 'Blok \'Predstojeći događaji\'';
$string['upcomingeventstintenabled'] = 'Obojite ikonice aktivnosti u bloku \'Predstojeći događaji\'';
$string['upcomingeventstintenabled_desc'] = 'Sa ovim podešavanjem možete da obojite ikonice aktivnosti u bloku \'Predstojeći događaji\' na osnovu svrhe aktivnosti. Standardno, Moodle ih prikazuje samo kao crno obojene ikonice.';
$string['upgradenotice_2022080922'] = 'Od ove verzije, Boost Union ima sopstveni logo i podešavanja kompaktnog logotipa, i više ne koristi ove datoteke iz osnovnih podešavanja Moodlea.';
$string['upgradenotice_2022080922_copied'] = 'Postojeće podešavanje <strong>{$a}</strong> kopirano je iz osnovnih podešavanja Moodlea u Boost Union podešavanje {$a} tokom ove nadogradnje. Molimo vas da još jednom proverite rezultat.';
$string['upgradenotice_2022080922_logo'] = 'logo';
$string['upgradenotice_2022080922_logocompact'] = 'kompaktan logo';
$string['upgradenotice_2022080922_notcopied'] = 'Podešavanje <strong>{$a}</strong> u okviru teme LearnR je sada prazno. Ako od sada želite da koristite {$a} u okviru teme LearnR, samo ga kasnije postavite u Boost Union podešavanje {$a}.';
$string['upgradenotice_2025041410'] = 'Podešavanje "Prikaži nagoveštaj (hint) korisnicima koji pristupaju kao gosti" je ažurirano kako bi podržalo veći broj opcija. Vaša postojeća konfiguracija (koja je bila podešena na opciju "Da") prebačena je na novu opciju "Da, ali samo ako nije podešena lozinka za pristup u ulozi gosta“.';
$string['upgradenotice_2025041413'] = 'Podešavanje "courselistinghowfields" je preimenovano u "courselistingshowfields" kako bi se ispravila greška u kucanju. Vaša postojeća konfiguracija je prebačena na novi naziv podešavanja.';
$string['upgradenotice_2025041416'] = 'Razdelnici u pametnim menijama su sada dostupni kao poseban tip stavke u meniju. Postojeći razdelnici (kreirani pomoću tipa naslova sa heš znakom) su automatski konvertovani u novi tip razdelnika.';
$string['uploadedsnippets'] = 'Otpremi isečak kôda';
$string['uploadedsnippets_desc'] = 'Možete otpremiti pojedinačne SCSS datoteke sa isečcima ili ZIP arhivu koja sadrži više SCSS datoteka sa isečcima – ZIP datoteka će biti automatski raspakovana i SCSS isečci koji su se nalazili u arhivi biće tada dostupni u ovom prostoru (za datoteke) kao pojedinačne datoteke.';
$string['uploadedsnippets_note'] = 'Strukturu i sintaksu Boost Union SCSS isečaka možete pronaći u našem <a href="{$a->url}" target="_blank">repozitorijumu SCSS isečaka</a>. Tamo , takođe, možete pronaći uputstva kako da koristite postojeće isečke drugih korisnika, kao i kako da sami doprinesete zajednici korisnika sa svojim isečcima.';
$string['usermenuheading'] = 'Korisnički meni';
$string['warningboostunioninactive'] = 'Boost Union grafička tema (kao i one koje su iz nje izvedene) trenutno <em>nije</em> aktivna. Podešavanja na ovim stranicama neće imati nikakav efekat ukoliko niste <a href="{$a->url}">učinili Boost Union temu aktivnom</a> ili ukoliko niste dozvolili da se Boost Union koristi kao grafička tema na nivou kategorije /kursa /korisnika /kohorte.';
$string['warningslashargumentsdisabled'] = 'Upozorenje: <a href="{$a->url}">podešavanje argumenata sa kosom crtom</a> je onemogućeno u vašoj trenutnoj Moodle konfiguraciji. Međutim, ovo podešavanje je potrebno za ispravan rad sledećeg Boost Union podešavanja. Molimo vas da omogućite argumente sa kosom crtom, inače sledeće Boost Union podešavanje neće imati efekta.';
