<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'offlinequiz', language 'sr_lt', version '5.0'.
 *
 * @package     offlinequiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add'] = 'Dodaj';
$string['addarandomquestion'] = 'nasumično pitanje';
$string['addarandomquestion_help'] = 'Moodle dodaje nasumično izabrana pitanja višestrukog izbora (ili pitanja višestrukog izbora sa više tačnih odgovora koja se ocenjuju po principu ”sve-ili-ništa”) u tekuću grupu oflajn testa. Broj pitanja koji se dodaje može se podesiti. Pitanja se biraju iz tekuće kategorije pitanja (i, ako je izabrano, iz njenih potkategorija).';
$string['addarandomselectedquestion'] = 'Dodaj nasumično odabrano pitanje...';
$string['addlist'] = 'Dodaj spisak prisutnih';
$string['addnewpagesafterselected'] = 'Dodaj prelom stranice posle izabranih pitanja';
$string['addnewquestion'] = 'novo pitanje';
$string['addnewquestionsqbank'] = 'Dodaj pitanja u kategoriju {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Dodaj korisničke izmene';
$string['addpagebreak'] = 'Dodaj prelom stranice';
$string['addpagehere'] = 'Dodaj stranicu ovde';
$string['addparts'] = 'Dodaj učesnike';
$string['addquestionfrombankatend'] = 'Dodaj iz banke pitanja  na kraj';
$string['addquestionfrombanktopage'] = 'Dodaj iz banke pitanja na stranicu {$a}';
$string['addrandom'] = 'Nasumično dodaj {$a} pitanje/a višestrukog izbora';
$string['addrandomfromcategory'] = 'pitanja nasumično iz kategorije';
$string['addrandomquestion'] = 'pitanja nasumično';
$string['addrandomquestiontoofflinequiz'] = 'Dodavanje pitanja u oflajn test {$a->name} (grupa {$a->group})';
$string['addrandomquestiontopage'] = 'Dodaj nasumično izabrano pitanje na stranicu {$a}';
$string['addtoofflinequiz'] = 'Dodaj u oflajn test';
$string['addtoqueue'] = 'Dodaj u red za čekanje';
$string['allinone'] = 'Neograničeno';
$string['alllists'] = 'Svi spiskovi';
$string['allornothing'] = 'Sve-ili-ništa';
$string['allresults'] = 'Prikaži sve pokušaje';
$string['allstudents'] = 'Prikaži sve polaznike';
$string['alwaysavailable'] = 'Uvek dostupno';
$string['analysis'] = 'Analiza pitanja';
$string['answerform'] = 'Obrazac za odgovore';
$string['answerformforgroup'] = 'Obrazac za odgovore za grupu {$a}';
$string['answerforms'] = 'Obrasci za odgovore';
$string['answerpdfxy'] = 'Obrazac za odgovore ({$a}->maxquestions pitanja / {$a}->maxanswers odgovora)';
$string['areyousureremoveselected'] = 'Da li ste sigurni da želite da uklonite sva izabrana pitanja?';
$string['attemptexists'] = 'Pokušaj postoji';
$string['attemptsexist'] = 'Više ne možete da dodajete ili uklanjate pitanja.';
$string['attemptsnum'] = 'Ukupan broj pokušaja: {$a}';
$string['attemptsonly'] = 'Prikaži samo polaznike sa pokušajima';
$string['attendanceoverview'] = 'Prisutnost';
$string['attendances'] = 'Prisutnost';
$string['attendancesevaluationheadline'] = '2. Evaluacija';
$string['attendancesheadline'] = 'Prisutnost';
$string['attendancespreparationheadline'] = '1. Priprema';
$string['attendenceoverviewattwithoutresults'] = 'Prisutni bez rezultata:';
$string['attendenceoverviewattwithresults'] = 'Prisutni sa rezultatima:';
$string['attendenceoverviewcorrectionnecessary'] = 'Potrebna ispravka (stranice)';
$string['attendenceoverviewnoattwithoutresults'] = 'Odsutni bez rezultata:';
$string['attendenceoverviewnoattwithresults'] = 'Odsutni sa rezultatima:';
$string['backtopreview'] = 'Prikaži pregled';
$string['basicideasofofflinequiz'] = 'Osnovne ideje o pravljenju oflajn testa';
$string['blackwhitethreshold'] = 'Crno/beli prag.';
$string['bulksavegrades'] = 'Sačuvaj ocene';
$string['calibratescanner'] = 'Kalibriši skener';
$string['cannoteditafterattempts'] = 'Ne možete da dodajete ili uklanjate pitanja jer već postoje kompletirani pokušaji. ({$a})';
$string['category'] = 'Kategorija';
$string['changed'] = 'Rezultat je promenjen.';
$string['changeevaluationmode'] = 'Promenite način na koji se vrši evaluacija. Moguće je samo ukoliko to administrator dozvoli.';
$string['checkparts'] = 'Obeleži izabrane učesnike kao prisutne';
$string['checkuserid'] = 'Obeleži grupu/ID oznaku korisnika';
$string['chooseagroup'] = 'Izaberi grupu...';
$string['closebeforeopen'] = 'Nije moguće ažurirati oflajn test. Naveli ste datum zatvaranja pre datuma otvaranja.';
$string['closestudentview'] = 'Zatvori pregled iz ugla polaznika';
$string['closewindow'] = 'Zatvori prozor';
$string['cmmissing'] = 'Modul kursa za oflajn test sa ID oznakom {$a} nedostaje';
$string['completiondetail:passgrade'] = 'Dobiti prelaznu ocenu';
$string['completionpass'] = 'Dobiju prelaznu ocenu';
$string['completionpass_help'] = 'Polaznici će završiti ovaj oflajn test samo ako postignu ocenu veću ili jednaku prelaznoj oceni, onako kako je to podešeno u okviru opcija za ocenu';
$string['configblackwhitethreshold'] = 'Postavlja prag za crno-belu konverziju 1-99 - Što je prag veći, to više belih piksela mora da bude importovano kako bi se prepoznali kao beli. Bilo koja druga vrednost uopšte ne vodi ka crno-beloj konverziji.';
$string['configdecimalplaces'] = 'Broj cifara koji treba prikazati iza decimalne tačke, kada se se prikazuju ocene za oflajn test.';
$string['configdisableimgnewlines'] = 'Ova opcija onemogućava nove redove pre i posle slika u pdf listovima sa pitanjima. Upozorenje: Ovo može dovesti do problema sa formatiranjem.';
$string['configexperimentalevaluation'] = 'Eksperimentalna evaluacija listova sa odgovorima';
$string['configexperimentalevaluationdesc'] = 'NE KORISTITI NA SAJTOVIMA SA AKTIVNIM KURSEVIMA! Ova opcija se koristi za alfa testove novog evaluacionog algoritma. Ako je ova opcija podešena na\'Da\', možete je uključiti u opcijama instance oflajn testa. Ne preporučujemo korišćenje ove opcije. Uopšte ne postoji nikakva podrška za izgubljene podatke zbog uključivanja ove opcije.';
$string['configintro'] = 'Vrednosti koje ovde podesite koristiće se kao podrazumevane vrednosti za nove oflajn testove.';
$string['configkeepfilesfordays'] = 'Odredite koliko dana će se postavljene datoteke slika čuvati u privremenom skladištu. Tokom ovog perioda datoteke slika biće dostupne u administratorskom izveštaju o oflajn testu.';
$string['configonlylocalcategories'] = 'Nisu dozvoljene deljene kategorije pitanja.';
$string['configpapergray'] = '”vrednost za belo” papira, koji se koristi za evaluaciju listova sa odgovorima';
$string['configshuffleanswers'] = 'Izmešaj odgovore';
$string['configshufflequestions'] = 'Ako omogućite ovu opciju, onda će redosled pitanja u grupama oflajn testa biti nasumično izmešan svaki put kada ponovo kreirate pregled testa na kartici "Kreiraj obrasce".';
$string['configshufflewithin'] = 'Ako omogućite ovu opciju, onda će delovi koji čine pojedinačna pitanja biti nasumično izmešani kada se kreiraju obrasci za pitanja i odgovore.';
$string['configuseridentification'] = 'Formula opisuje identitet korisnika. Ova formula se koristi kako bi se dodelili obrasci za odgovore korisnicima u sistemu. Leva strana jednačine definiše broj cifara (samo ceo broj, do 10 cifara). Desna strana jednačine mora da označava polje u tabeli korisnika u Moodleu (npr. id, idnumber, phone1).
Pored toga, jednačina se može baviti i prefiksom i sufiksom koji se dodaje označenim ciframa (npr. "a [7 ]= username" ili "b[5]cd = username"). Ovi spojevi stringova i brojeva označavaju vrednost korišćenog polja u tabeli korisnika, koja se koristi za identifikaciju korisnika.';
$string['confirmremovequestion'] = 'Da li ste sigurni da želite da uklonite ovo {$a} pitanje?';
$string['copy'] = 'Kopiraj';
$string['copyright'] = '<strong>Upozorenje: Tekstovi na ovoj stranici su samo za vašu ličnu informaciju. Kao i bilo koje drugi tekst ova pitanja su zaštićena autorskim pravima. Nije vam dozvoljeno da ih kopirate ili da ih pokazujete drugim ljudima!</strong>';
$string['copyselectedtogroup'] = 'Dodaj izabrana pitanja grupi: {$a}';
$string['copytogroup'] = 'Dodaj sva pitanja grupi: {$a}';
$string['correct'] = 'tačno';
$string['correcterror'] = 'reši';
$string['correctforgroup'] = 'Tačni odgovori za grupu {$a}';
$string['correctheader'] = 'Potrebna ispravka:';
$string['correctionerrors'] = 'Obrasci sa ispravljenim greškama:';
$string['correctionform'] = 'Ispravka';
$string['correctionforms'] = 'Obrasci sa tačnim odgovorima';
$string['correctionheader'] = 'Ispravka';
$string['correctionheader_help'] = '<p>Obrasci za odgovore koji su ovde prikazani zahtevaju vašu pažnju i moraju se ručno ispraviti. Automatska evaluacija nije moguća.</p>
<u>Mogu se pojaviti sledeće greške...</u>
<ul>
  <li><strong>Netačne oznake:</strong> Neke oznake nisu mogle biti evaluirane.</li>
  <li><strong>Neispravan broj grupe:</strong> Broj grupe nije mogao da bude evaluiran.</li>
  <li><strong>Neispravan broj stranice:</strong> Broj stranice nije mogao da bude evaluiran.</li>
  <li><strong>Neispravna skenirana slika:</strong> Obrazac sa odgovorima je ukrivo skeniran i ne može biti evaluiran.</li>
  <li><strong>Postoji drugačiji rezultat:</strong> Evaluirani rezultat sa drugačijim brojem grupe već postoji.</li>
  <li><strong>Stranice su nepotpune:</strong> Trenutni obrazac sa odgovorima je evaluiran, ali nedostaje najmanje 1 dodatni list kako bi se završila evaluacija za identifikovanog učesnika. (Pojavljuje se samo kod obrazaca sa odgovorima na više stranica.)</li>
  <li><strong>Rezultat postoji:</strong> Evaluirani rezultat već postoji.</li>
  <li><strong>Korisnik nije upisan na kurs:</strong> Identifikovani učesnik trenutno nije upisan na kurs.</li>
  <li><strong>Korisnik ne postoji:</strong> Identifikovani učesnik je nepoznat.</li>
</ul>';
$string['correctionoptionsheading'] = 'Opcije ispravke';
$string['correctupdated'] = 'Ažuriran obrazac sa tačnim odgovorima za grupu {$a}.';
$string['couldnotextractpages'] = 'Greška prilikom izdvajanja stranica iz otpremljenih datoteka.';
$string['couldnotextractpdf'] = 'Greška prilikom konvertovanja PDF dokumenta u pojedinačne slike. Molimo vas da pokušate sa dokumentom manje veličine ili kontaktirajte administratora.';
$string['couldnotextracttiff'] = 'Greška prilikom konvertovanja tiff datoteka u pojedinačne slike. Molimo vas da pokušate sa datotekom manje veličine ili kontaktirajte svog lokalnog administratora.';
$string['couldnotgrab'] = 'Nije moguće dohvatiti sliku {$a}';
$string['couldnotinsertjobs'] = 'Greška sa bazom podataka prilikom izdvajanja stranica';
$string['couldnotregister'] = 'Nije moguće registrovati korisnika {$a}';
$string['createcategoryandaddrandomquestion'] = 'Kreiraj kategoriju i dodaj nasumična pitanja';
$string['createlistfirst'] = 'Prvo dodajte spisak učesnika';
$string['createofflinequiz'] = 'Kreiraj obrasce';
$string['createpartpdferror'] = 'PDF obrazac za spisak korisnika {$a} ne može da se kreira. Spisak je možda prazan.';
$string['createpdf'] = 'Obrazac';
$string['createpdferror'] = 'Obrazac za grupu {$a} ne može da se kreira. Možda ne postoje pitanja za grupu.';
$string['createpdffirst'] = 'Kreiraj prvo PDF spisak';
$string['createpdfforms'] = 'Kreiraj obrasce';
$string['createpdfs'] = 'Obrasci';
$string['createpdfsparticipants'] = 'Obrasci';
$string['createquestionandadd'] = 'Kreiraj novo pitanje i dodaj ga u test.';
$string['createquiz'] = 'Kreiraj obrasce';
$string['csvfile'] = 'CSV datoteka';
$string['csvformat'] = 'Tekstualna datoteka sa vrednostima razdvojenim zarezom (CSV)';
$string['csvplus1format'] = 'Tekstualna datoteka sa neobrađenim podacima (CSV)';
$string['csvpluspointsformat'] = 'Tekstualna datoteka sa tačkama (CSV)';
$string['darkgray'] = 'Tamno siva';
$string['datanotsaved'] = 'Nije moguće sačuvati podešavanja';
$string['decimalplaces'] = 'Decimalna mesta';
$string['decimalplaces_help'] = 'Broj cifara koji treba prikazati iza decimalne tačke, kada se se prikazuju ocene za oflajn test.';
$string['defaultparticipantsusage'] = 'Evidentiraj prisustvo';
$string['defaultparticipantsusagedesc'] = 'Određuje da li bi standardno trebalo prisustvo da se evidentira zajedno sa spiskom prisutnih.';
$string['defaultpdffont'] = 'Podrazumevani font obrasca';
$string['defaultpdffont_help'] = 'Podrazumevani font koji će oflajn test koristiti za obrasce. Možda ćete želeti da ručno preuzmete tcpdf paket i izdvojite njegove fontove/direktorijume u vašu konfiguracionu datoteku $CFG->dataroot/fonts/ za više fontova. Preporučuje se korišćenje Freeserif kao podrazumevani font, jer podržava većinu znakova. Pogledajte na https://www.gnu.org/software/freefont/coverage.html za kompletni spisak kompatibilnosti.';
$string['defaultpdffontsize'] = 'Podrazumevana veličina fonta';
$string['defaultpdffontsize_help'] = 'Podrazumevana veličina fonta koju će koristiti svi obrasci.';
$string['deletelistcheck'] = 'Da li zaista želite da obrišete izabranu listu i sve njene učesnike?';
$string['deletepagecheck'] = 'Da li zaista želite da obrišete izabrane stranice?';
$string['deletepagesafterselected'] = 'Ukloni prelom stranice posle izabranih pitanja';
$string['deletepartcheck'] = 'Da li zaista želite da obrišete izabrane učesnike?';
$string['deleteparticipantslist'] = 'Obriši spisak učesnika';
$string['deletepdfs'] = 'Obriši dokumente';
$string['deleteresultcheck'] = 'Da li zaista želite da obrišete izabrane pokušaje?';
$string['deleteselectedpart'] = 'Obriši izabrane učesnike';
$string['deleteselectedresults'] = 'Obriši izabrane pokušaje';
$string['deletethislist'] = 'Obriši ovaj spisak';
$string['deleteupdatepdf'] = 'Obriši i ažuriraj PDF obrasce';
$string['difficultytitle'] = 'Težina';
$string['difficultytitlea'] = 'Težina A';
$string['difficultytitleb'] = 'Težina B';
$string['difficultytitlediff'] = 'Razlika';
$string['disableimgnewlines'] = 'Onemogućite nove redove pre i posle slika';
$string['disableimgnewlines_help'] = 'Ova opcija onemogućava nove redove pre i posle slika u pdf listovima sa pitanjima. Upozorenje: Ovo može dovesti do problema sa formatiranjem.';
$string['discriminationindex_info'] = 'Pošto indeks diskriminativnosti procenjuje pitanja na osnovu odgovora najboljih i najlošijih rezultata na testu, on neće moći da bude izračunat, ukoliko:
- na ovo pitanje nema različitih odgovora polaznika
- na testu nema različitih ocena';
$string['displayoptions'] = 'Opcije prikaza';
$string['documentschanged'] = 'Jedno ili više pitanja u oflajn testu je promenjeno od kada su kreirani dokumenati.<br>Budući pokušaji će biti automatski promenjeni tokom evaluacije na osnovu trenutne verzije izmenjenih pitanja, ovde izabranih. U dokumentima je i dalje prikazana originalna verzija pitanja.';
$string['documentschangedwithresults'] = 'Jedno ili više pitanja u oflajn testu je promenjeno od kada su kreirani dokumenati.<br>Postojeći pokušaji su bili automatski promenjeni na osnovu trenutne verzije izmenjenih pitanja, ovde izabranih. U dokumentima je i dalje prikazana originalna verzija pitanja.';
$string['done'] = 'gotovo';
$string['downloadallzip'] = 'Preuzmi sve datoteke kao ZIP arhivu';
$string['downloadpartpdf'] = 'Preuzmi PDF datoteku za spisak \'{$a}\'';
$string['downloadpdfs'] = 'Obrasci';
$string['downloadresultsas'] = 'Preuzmi rezultate kao:';
$string['dragtoafter'] = 'Posle {$a}';
$string['dragtostart'] = 'Na početak';
$string['editgroupquestions'] = 'Uredi grupu pitanja';
$string['editgroups'] = 'Uredi oflajn grupe';
$string['editingofflinequiz'] = 'Uređivanje grupe pitanja';
$string['editingofflinequiz_help'] = 'Kada se kreira oflajn test, glavni pojmovi su:
<ul><li> Oflajn test, koji sadrži pitanja na jednoj ili više strana</li>
<li> Banka pitanja, u kojoj se čuvaju kopije svih pitanja, organizovanih u kategorije</li></ul>';
$string['editingofflinequizx'] = 'Pitanja';
$string['editlist'] = 'Uredi spisak';
$string['editlists'] = 'Spiskovi prisutnih';
$string['editmaxmark'] = 'Uredi maksimalnu ocenu';
$string['editofflinequiz'] = 'Uredi oflajn test';
$string['editofflinesettings'] = 'Uredi oflajn podešavanja';
$string['editorder'] = 'Uredi redosled';
$string['editparticipants'] = 'Uredi učesnike';
$string['editquestion'] = 'Uredi pitanje';
$string['editquestionlistitem'] = '{$a}';
$string['editquestions'] = 'Pitanja';
$string['editscannedform'] = 'Uredi skenirani obrazac';
$string['editthislist'] = 'Uredi ovaj spisak';
$string['emptygroups'] = 'Neke grupe pitanja oflajn testova su prazne. Molimo, dodajte nekoliko pitanja.';
$string['enroluser'] = 'Upiši korisnika';
$string['erroraccessingreport'] = 'Nije vam dozvoljeno da vidite ovaj izveštaj.';
$string['errormultiuserinlist'] = 'Korisnik je više puta naveden u spisku prisutnih!';
$string['errorreport'] = 'Izveštaj o greškama prilikom uvoza';
$string['evaluated'] = 'Evaluirano:';
$string['evaluation'] = '2. Evaluacija';
$string['eventattemptdeleted'] = 'Pokušaj rešavanja oflajn testa obrisan';
$string['eventattemptpreviewstarted'] = 'Pregled pokušaja rešavanja oflajn testa započet';
$string['eventattemptreviewed'] = 'Pokušaj rešavanja oflajn testa pregledan';
$string['eventattemptsummaryviewed'] = 'Rezime pokušaja rešavanja oflajn testa prikazan';
$string['eventattemptviewed'] = 'Pokušaj rešavanja oflajn testa prikazan';
$string['eventdocscreated'] = 'Obrasci za pitanja i odgovore oflajn testa kreirani';
$string['eventdocsdeleted'] = 'Obrasci za pitanja i odgovore oflajn testa obrisani';
$string['eventeditpageviewed'] = 'Stranica  za uređivanje oflajn testa prikazana';
$string['eventofflinequizattemptsubmitted'] = 'Pokušaj rešavanja oflajn testa predat';
$string['eventoverridecreated'] = 'Izmena oflajn testa kreirana';
$string['eventoverridedeleted'] = 'Izmena oflajn testa obrisana';
$string['eventoverrideupdated'] = 'Izmena oflajn testa ažurirana';
$string['eventparticipantmarked'] = 'Učesnika oflajn test ručno obeležen';
$string['eventquestionmanuallygraded'] = 'Pitanje ručno ocenjeno';
$string['eventreportviewed'] = 'Izveštaj o oflajn testu prikazan';
$string['eventresultsregraded'] = 'Pokušaji oflajn testa ponovo ocenjeni';
$string['everythingon'] = 'omogućeno';
$string['excelformat'] = 'Excel radna tabela (XLSX)';
$string['experimentalevaluation'] = 'Eksperimentalna evaluacija listova sa odgovorima';
$string['experimentalevaluation_help'] = 'Eksperimentalna evaluacija listova sa odgovorima';
$string['fileformat'] = 'Format za listove sa pitanjima';
$string['fileformat_help'] = 'Izaberite da li želite da vaši listovi sa pitanjima budu u PDF, DOCX ili TEX formatu. Obrasci za odgovore i listovi sa tačnim odgovorima će uvek biti generisan u PDF formatu.';
$string['fileprefixanswer'] = 'answer_form';
$string['fileprefixcorrection'] = 'correction_form';
$string['fileprefixform'] = 'question_form';
$string['fileprefixparticipants'] = 'participants_list';
$string['filesizetolarge'] = 'Neke od vaših datoteka slika su vrlo velike. Dimenzije će biti promenjene tokom interpretacije skeniranih obrazaca. Molimo vas da obrasce skenirate u rezoluciji između 200 i 300 dpi (tačaka po inču) i u crno-belo režimu. Ovo će ubrzati interpretaciju sledeći put.';
$string['filterbytags'] = 'Filtriranje po oznakama...';
$string['fontfamilycourier'] = 'Courier';
$string['fontfamilyfreemono'] = '(Free-)Mono';
$string['fontfamilyfreesans'] = '(Free-)Sans';
$string['fontfamilyfreeserif'] = '(Free-)Serif (preporučeno)';
$string['fontfamilyhelvetica'] = 'Helvetica';
$string['fontfamilyhysmyeongjostdmedium'] = 'MyungJo Medium (Korean)';
$string['fontfamilykozgopromedium'] = 'Kozuka Gothic Pro (Japanese Sans-Serif)';
$string['fontfamilykozminproregular'] = 'Kozuka Mincho Pro (Japanese Serif)';
$string['fontfamilymsungstdlight'] = 'MSung Light (Trad. Chinese)';
$string['fontfamilystsongstdlight'] = 'STSong Light (Simp. Chinese)';
$string['fontfamilysymbol'] = 'Symbol';
$string['fontfamilytimes'] = 'Times';
$string['fontfamilyzapfdingbats'] = 'ZapfDingbats';
$string['fontsize'] = 'Veličina fonta';
$string['forautoanalysis'] = 'Za automatsku analizu';
$string['formforcorrection'] = 'Obrazac sa tačnim odgovorima za grupu {$a}';
$string['formforgroup'] = 'Obrazac sa pitanjima za grupu {$a}';
$string['formforgroupdocx'] = 'Obrazac sa pitanjima za grupu {$a} (DOCX)';
$string['formforgrouplatex'] = 'Obrazac sa pitanjima za grupu {$a} (LATEX)';
$string['forms'] = 'Obrasci';
$string['formsexist'] = 'Obrasci su već kreirani.';
$string['formsexistx'] = 'Obrasci su već kreirani (<a href="{$a}">Preuzmi obrasce</a>)';
$string['formsheetsettings'] = 'Podešavanja obrazaca';
$string['formspreview'] = 'Pregled';
$string['formwarning'] = 'Ne postoji definisan obrazac za odgovore. Molimo kontaktirajte svog administratora.';
$string['fromquestionbank'] = 'iz banke pitanja';
$string['functiondisabledbysecuremode'] = 'Ova funkcionalnost je trenutno onemogućena';
$string['furtheroptionsheading'] = 'Dodatne opcije';
$string['generalfeedback'] = 'Opšte povratne informacije';
$string['generalfeedback_help'] = 'Opšte povratne informacije predstavljaju tekst koji se prikazuje nakon pokušaja da se odgovori na pitanje. Za razliku od povratne informacije za pojedinačno pitanje koje zavisi od datog odgovora, iste opšte povratne informacije se uvek prikazuju.';
$string['generatepdfform'] = 'Generiši PDF obrazac';
$string['grade'] = 'Ocena';
$string['gradedon'] = 'Ocenjeno';
$string['gradedscannedform'] = 'Skenirani obrazac sa ocenama';
$string['gradeiszero'] = 'Napomena: maksimalna ocena za ovaj oflajn test je 0 bodova!';
$string['gradeswarning'] = 'Ocene za pitanja moraju biti brojevi!';
$string['gradewarning'] = 'Ocena za pitanje mora biti broj!';
$string['gradingofflinequiz'] = 'Ocene';
$string['gradingofflinequizx'] = 'Ocene';
$string['gradingoptionsheading'] = 'Opcije ocenjivanja';
$string['greeniscross'] = 'računato kao krstić';
$string['group'] = 'Grupa';
$string['groupoutofrange'] = 'Grupa je van opsega i zamenjena je sa grupom A.';
$string['hasresult'] = 'Postoji rezultat';
$string['hotspotdeletiontask'] = 'Brisanje aktivnih područja';
$string['html'] = 'HTML';
$string['id'] = 'ID oznaka korisnika';
$string['idnumber'] = 'ID broj / Broj dosijea';
$string['imagefile'] = 'Datoteka slike';
$string['imagenotfound'] = 'Datoteka slike: {$a} nije pronađena!';
$string['imagenotjpg'] = 'Slika nije jpg ili png: {$a}';
$string['imagickwarning'] = 'Nedostaje imagemagick biblioteka: Zamolite svog administratora sistema da instalira imagemagick biblioteku i da proveri putanju do datoteke za konverziju u vašim podešavanjima filtera za TeX notaciju. TIF datoteke ne možetete da uvezete bez imagemagick biblioteke!';
$string['import'] = 'Евалуирај';
$string['importedon'] = 'Evaluirano';
$string['importerror11'] = 'Postoji drugi rezultat';
$string['importerror12'] = 'Korisnik nije registrovan';
$string['importerror13'] = 'Nema podatka o grupi';
$string['importerror14'] = 'Nije moguće dohvatiti';
$string['importerror15'] = 'Nejasno obeleženi odgovori';
$string['importerror16'] = 'Greška stranice';
$string['importerror17'] = 'Stranice nepotpune';
$string['importerror21'] = 'Nije moguće dohvatiti';
$string['importerror22'] = 'Nejasno obeleženi odgovori';
$string['importerror23'] = 'Korisnik nije na spisku';
$string['importerror24'] = 'Spisak nije detektovan';
$string['importforms'] = 'Otpremite formulare sa odgovorima';
$string['importfromto'] = 'Ecaluiranje od {$a->from} do {$a->to} od ukupno {$a->total}.';
$string['importisfinished'] = 'Evaluacija za oflajn test {$ a} je završena.';
$string['importlinkresults'] = 'Link za rezultate: {$a}';
$string['importlinkverify'] = 'Link za proveru: {$a}';
$string['importmailsubject'] = 'obaveštenje o uvozu oflajn testa';
$string['importnew'] = 'Evaluiraj';
$string['importnew_help'] = '<p>
Možete da uvezete pojedinačne datoteke skeniranih slika ili veći broj njih, upakovanih u ZIP-arhivu. Modul \'Oflajn test\' će obraditi datoteke slika u pozadini.
Nazivi datoteka nisu bitni ali ne bi trebalo da sadrže posebne znakove kao što su dijakritici, umlauti itd. Slike treba da budu u formatima GIF, PNG ili TIF. Preporučuje se rezolucija između 200 i 300dpi (tačaka po inču).</p>';
$string['importnumberexisting'] = 'Broj duplih obrazaca: {$a}';
$string['importnumberpages'] = 'Broj uspešno uvezenih stranica: {$a}';
$string['importnumberresults'] = 'Broj uvezenih: {$a}';
$string['importnumberverify'] = 'Broj obrazaca za koji je potrebna provera: {$a}';
$string['importtimefinish'] = 'Obrada je završena: {$a}';
$string['importtimestart'] = 'Obrada je započela: {$a}';
$string['inconsistentdata'] = 'Protivrečni podaci: {$a}';
$string['info'] = 'Informacije';
$string['infoshort'] = 'info';
$string['insecuremarkings'] = 'Nejasno obeleženi odgovori traže ručne ispravke';
$string['insecuremarkingsforquestion'] = 'Nejasno obeleženi odgovori traže ručne ispravke za pitanja';
$string['insertnumber'] = 'Molimo vas da ubacite tačan identifikacioni broj obeležen plavim okvirom.';
$string['instruction1'] = 'Ovaj obrazac sa odgovorima biće automatski skeniran. Molimo vas da ga ne savijate ili žvrljate po njemu. Za obeležavanje odgovora koristite crnu ili plavu olovku:';
$string['instruction2'] = 'Samo jasno obeleženi odgovori biće interpretirani kao ispravni. Ako želite da ispravite (poništite) svoj odgovor, kompletno ispunite polje bojom. Tako obeleženo polje, prilikom skeniranja, biće interpretirano kao prazno:';
$string['instruction3'] = 'Polja koja su ispravljena (kompletno ispunjena bojom) ne mogu više da budu ispravno obeležena. Molimo vas da ne ništa ne pišete izvan polja za obeležavanje.';
$string['introduction'] = 'Uvod';
$string['invalidformula'] = 'Neispravna formula za identifikaciju korisnika. Formula mora imati oblik <prefix>[<#digits>]<suffix>=<db-field&>.';
$string['invalidnumberofdigits'] = 'Korišćen je neispravan broj cifara. Dozvoljeno je samo 1 do 9 cifara.';
$string['invaliduserfield'] = 'Korišćeno je neispravno polje korisničke tabele.';
$string['invigilator'] = 'Dežurni na ispitu';
$string['ischecked'] = 'Učešće je provereno';
$string['isnotchecked'] = 'Učešće nije provereno';
$string['itemdata'] = 'Podaci o ajtemu';
$string['keepfilesfordays'] = 'Vremenski period čuvanja datoteka (u danima)';
$string['legend'] = 'Legenda';
$string['legenddone'] = 'Korak je uspešno obavljen (nije potrebna dodatna akcija).';
$string['legendnextitem'] = 'Potrebna akcija u daljem toku rada (moguće zavisnost od prethodnih koraka).';
$string['legendnoaction'] = 'Nikakva akcija nije potrebna';
$string['legendwarning'] = 'Potrebna je hitna akcija.';
$string['letter'] = 'Slovo';
$string['lightgray'] = 'Svetlo siva';
$string['linktoscannedform'] = 'Prikaži skenirani obrazac';
$string['listnotdetected'] = 'Nije moguće detektovati bar kôd za spisak!';
$string['logdeleted'] = 'Zapis {$a} je obrisan.';
$string['logourl'] = 'URL adresa logotipa';
$string['logourldesc'] = 'URL adresa datoteke slike koji se prikazuje u gornjem desnom uglu obrasca sa odgovorima, tj. <b>http://www.yoursite.tld/mylogo.png</b> ili <b>../path/to/your/logo.png</b>. Maksimalna dozvoljena veličina je 520x140 piksela. Obrazac sa odgovorima ne može da se evaluira ako slika prelazi maksimalnu veličinu!';
$string['lowertrigger'] = 'Druga donja granica';
$string['lowertriggerzero'] = 'Druga donja granica je nula';
$string['lowerwarning'] = 'Prva donja granica';
$string['lowerwarningzero'] = 'Prva donja granica je nula';
$string['marginwarning'] = 'Molimo vas da odštampate sledeće PDF dokumente bez dodatnih margina!<br /> Izbegavajte da studentima dajete fotokopije.';
$string['marks'] = 'Ocene';
$string['matrikel'] = 'identifikacioni broj polaznika';
$string['maxgradewarning'] = 'Najveća ocena mora da bude broj!';
$string['maxmark'] = 'Maksimalna ocena';
$string['membersinplist'] = '{$a->count} učesnik/a u<a href="{$a->url}">{$a->name}</a>';
$string['messageprovider:jobs'] = 'Obaveštenja o oflajn testu';
$string['missingimagefile'] = 'Nedostaje datoteka slike';
$string['missingitemdata'] = 'Nedostaje/u odgovor/i za korisnika {$a}';
$string['missinglogdata'] = 'Nedostaju podaci o zapisu za postojeći rezultat.';
$string['missingquestion'] = 'Izgleda da ovo pitanje više ne postoji';
$string['missinguserid'] = 'Nedostaje identifikacioni broj korisnika! Nije moguće pročitati bar kôd!';
$string['modulename'] = 'Oflajn test';
$string['modulename_help'] = 'Ovaj modul omogućava predavačima da dizajniraju oflajn testove koji se sastoje od pitanja višestrukog izbora.
Ova pitanja se čuvaju u banci pitanja i mogu se koristite više puta unutar kurseva, kao i na drugim kursevima.
Oflajn testovi mogu da se preuzmu kao PDF-, DOCX- ili LaTeX datoteke. Polaznici obeležavaju svoje odgovore na listu sa obrascem za odgovore. Listovi sa obrascima se skeniraju nakon čega se odgovori uvoze u sistem.
<p><a href="https://academic-moodle-cooperation.org/anleitungen/offline-test-einstellungen/?lng=en" target="_blank"> Oflajn test: podešavanja </a></p>
<p><a href="https://academic-moodle-cooperation.org/anleitungen/offline-test-fragen-hinzufugen-und-formulare-generieren/?lng=en" target="_blank">Oflajn test: dodavanje pitanja i generisanje obrazaca</a></p>
<p><a href="https://academic-moodle-cooperation.org/anleitungen/offline-test-durchfuhren-und-auswerten/?lng=en" target="_blank">Oflajn test: sproveđenje i evaluacija oflajn testa</a></p>';
$string['modulenameplural'] = 'Oflajn testovi';
$string['moodleprocessing'] = 'Pustite da Moodle obradi podatke';
$string['movecorners'] = 'Promenite prvo poziciju ugaonih markera. Koristite opciju \'prevuci i spusti';
$string['moveselectedonpage'] = 'Premestite izabrana pitanja na stranicu: {$a}';
$string['multianswersforsingle'] = 'Pitanje višestrukog izbora sa jednim odgovorom';
$string['multichoice'] = 'Višestruki izbor';
$string['multipleanswers'] = 'Izaberite bar jedan odgovor.';
$string['name'] = 'Naziv oflajn testa';
$string['neededcorrection'] = '<strong>Pažnja: Za neke od vaših obeleženih odgovara potrebna je ručna ispravka. Pogledajte crveni kvadrat na sledećoj slici.
<br />Ovo podrazumeva ručnu intervencije od strane predavača i odloženo objavljivanje rezultata oflajn testa!</strong>';
$string['newgrade'] = 'Ocenjeno';
$string['newpage'] = 'Nova stranica';
$string['noattemptexists'] = 'Ne postoji nijedan pokušaj';
$string['noattempts'] = 'Nije uvezen nijedan pokušaj!';
$string['noattemptsonly'] = 'Prikaži samo studente bez pokušaja';
$string['nocourse'] = 'Nedostaje kurs sa ID oznakom {$a->course} kojem pripada oflajn test sa ID oznakom {$a->offlinequiz}.';
$string['nogradesseelater'] = 'Ovaj test nije ocenjen još za {$a}. Rezultati će biti ovde objavljeni.';
$string['nogroupdata'] = 'Nema podatka o grupi za korisnika {$a}';
$string['nomcquestions'] = 'Ne postoje pitanja višestrukog izbora u grupi {$a}!';
$string['noofflinequiz'] = 'Ne postoji oflajn test sa ID oznakom {$a}!';
$string['nopages'] = 'Nije uvezena nijedna stranica';
$string['noparticipantsfound'] = 'Nije pronađen nijedan učesnik';
$string['nopdfscreated'] = 'Nije kreiran nijedan dokument!';
$string['noquestions'] = 'Neke grupe oflajn testa su prazne. Dodajte pitanja.';
$string['noquestionselected'] = 'Nije izabrano nijedno pitanje!';
$string['noquestionsfound'] = 'Ne postoje pitanja u grupi {$a}!';
$string['noquestionsonpage'] = 'Prazna stranica';
$string['noresults'] = 'Ne postoje rezultati.';
$string['noreview'] = 'Nije vam dozvoljeno da pregledate ovaj oflajn test';
$string['noscannedpage'] = 'Ne postoji skenirana stranica sa ID oznakom {$a}!';
$string['notagselected'] = 'Nije izabrana nijedna oznaka';
$string['notavailable'] = 'N/A';
$string['nothingtodo'] = 'Ne radi ništa';
$string['notxtfile'] = 'Nema TXT datoteke';
$string['notyetgraded'] = 'Još nije ocenjeno';
$string['nozipfile'] = 'Nema ZIP datoteke';
$string['numattempts'] = 'Broj uvezenih pokušaja: {$a}';
$string['numattemptsqueue'] = 'Broj obrazaca sa odgovorima koji su dodati na čekanje: {$a}. Nakon obrade podataka biće poslata poruka na vašu e-adresu.';
$string['numattemptsverify'] = 'Broj skeniranih obrazaca koji čekaju ispravku: {$a}';
$string['numberformat'] = 'Vrednost mora da bude broj sa {$a} cifre/cifara!';
$string['numbergroups'] = 'Broj grupa';
$string['numpages'] = 'Uvezeno strana: {$a}';
$string['numquestionsx'] = 'Pitanja: {$a}';
$string['numusersadded'] = 'Dodato učesnika: {$a}';
$string['odsformat'] = 'OpenDocument radna tabela (ODS)';
$string['offlineimplementationfor'] = 'Oflajn implementacija za';
$string['offlinequiz:addinstance'] = 'Dodaj oflajn test';
$string['offlinequiz:attempt'] = 'Pokušaj rešavanja testova';
$string['offlinequiz:changeevaluationmode'] = 'Omogućite promenu načina evaluacije. UPOZORENJE : NE KORISTITI NA SAJTOVIMA SA AKTIVNIM KURSEVIMA!';
$string['offlinequiz:createofflinequiz'] = 'Kreiraj obrasce za oflajn test';
$string['offlinequiz:deleteattempts'] = 'Obriši pokušaje rešavanja oflajn testa';
$string['offlinequiz:grade'] = 'Oceni oflajn testove ručno';
$string['offlinequiz:manage'] = 'Upravljanje oflajn testovima';
$string['offlinequiz:preview'] = 'Pregledaj oflajn testove';
$string['offlinequiz:view'] = 'Prikaži informacije o oflajn testu';
$string['offlinequiz:viewreports'] = 'Prikaži izveštaje o oflajn testu';
$string['offlinequizcloses'] = 'Oflajn test se zatvara';
$string['offlinequizcloseson'] = 'Pregled ovog oflajn testa će se zatvoriti {$a}';
$string['offlinequizcontent'] = 'Sadržaj oflajn testa';
$string['offlinequizisclosed'] = 'Oflajn test je zatvoren';
$string['offlinequizisclosedwillopen'] = 'Oflajn test zatvoren (otvara se {$a})';
$string['offlinequizisopen'] = 'Ovaj oflajn test je otvoren';
$string['offlinequizisopenwillclose'] = 'Oflajn test otvoren (zatvara se {$a})';
$string['offlinequizopenedon'] = 'Ovaj oflajn test je otvoren {$a}';
$string['offlinequizopens'] = 'Oflajn test se otvara';
$string['offlinequizsettings'] = 'Podešavanja oflajn testa';
$string['offlinequizwillopen'] = 'Oflajn test se otvara {$a}';
$string['oneclickenrol'] = 'Upis na 1 klik';
$string['oneclickenroldesc'] = 'Ako je aktivirana ova opcija predavači imaju mogućnost da upišu korisnike jednim klikom dok ispravljaju obrasce sa odgovorima (greška "Korisnik nije upisan na kurs").';
$string['oneclickrole'] = 'Uloga za ”Upis na 1 klik”';
$string['oneclickroledesc'] = 'Izaberite ulogu koja se koristi za ”Upis na 1 klik”. Mogu biti izabrane samo uloge sa arhetipom ”student”.';
$string['onlylocalcategories'] = 'Samo lokalne kategorije pitanja';
$string['orderandpaging'] = 'Redosled i paginacija';
$string['orderandpaging_help'] = 'Brojevi 10, 20, 30... pored svakog pitanja ukazuju na redosled pitanja u testu. Brojevi se povećavaju u koracima po 10 kako bi se ostavio prostor za ubacivanje dodatnih pitanja. Da biste promenili redosled pitanja, promenite broj a onda kliknite na dugme "Promeni redosled pitanja".

Da biste dodali prelom stranice nakon određenog pitanja, označite polje za potvrdu odmah pored samog pitanja a zatim kliknite na dugme "Dodaj prelom stranice posle izabranih pitanja"

Da biste organizovali pitanja na više stranica kliknite na dugme "Reorganizuj stranice" i izaberite željeni broj pitanja po stranici.';
$string['orderingofflinequiz'] = 'Redosled i paginacija';
$string['otherresultexists'] = 'Drugačiji rezultat za {$a} već postoji, uvoz je ignorisan! Obrišite rezultat prvo.';
$string['outof'] = '{$a->grade} od maksimalnih {$a->maxgrade}';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Sveobuhvatne povratne informacije';
$string['overview'] = 'Informacije o testu';
$string['overviewdownload_help'] = 'Preuzmite pregled';
$string['page-mod-offlinequiz-edit'] = 'Stranica za uređivanje oflajn testa';
$string['page-mod-offlinequiz-x'] = 'Bilo koja stranica oflajn testa';
$string['pagecorrected'] = 'Ispravljeni list sa spiskom učesnika uvezen';
$string['pageevaluationtask'] = 'Evaluacija listova sa odgovorima za oflajn test';
$string['pageimported'] = 'List sa spiskom učesnika uvezen';
$string['pagenotdetected'] = 'Nije moguće detektovati bar kôd za stranicu!';
$string['pagenumberimported'] = 'List {$a} sa spiskom učesnika uvezen';
$string['pagenumberupdate'] = 'Ažuriranje broja stranice';
$string['pagesinprocessing'] = 'U obradi:';
$string['pagesizeparts'] = 'Broj učesnika prikazanih po stranici:';
$string['papergray'] = 'Vrednost beline papira';
$string['papergray_help'] = 'Ako su beli delovi vaših skeniranih obrazaca za odgovore veoma tamni, to možete da ispravite tako što ćete ovu vrednost podesiti na \'Tamno siva\'.';
$string['partcheckedwithoutresult'] = '<a href="{$a->url}">Potvrđeni učesnici bez rezultata: {$a->count}</a>';
$string['partcheckedwithresult'] = 'Potvrđeni učesnici sa rezultatom: {$a}';
$string['partial'] = 'delimično';
$string['participants'] = 'Učesnici';
$string['participants_help'] = '<p>Spiskovi učesnika su dizajnirani za velike testove sa velikim brojem učesnika. Oni pomažu predavaču da proveri koji polaznici su pristupili testu i da li su svi rezultati ispravno uvezeni.
Možete da dodate korisnike na različite spiskove. Svaki spisak može, na primer, da sadrži učesnike u određenoj prostoriji. Učesnici mogu da budu članovi posebne grupe. Za kreiranje tih grupa može se koristiti alat za registraciju grupe.
Spiskovi učesnika mogu se preuzeti kao PDF dokumenti i odštampati. Prisutni polaznici se mogu obeležiti krstićem, baš kao što se obeležavaju odgovori u obrascu za odgovore oflajn testa. Nakon toga, skenirani spiskovi mogu da budu postavljeni na server, a polaznici obeleženi krstićem biće označeni u bazi podataka kao prisutni.
Izbegavajte mrlje na bar kôdovima jer se oni koriste za identifikaciju polaznika.</p>';
$string['participantsinlists'] = 'Učesnici';
$string['participantslist'] = 'Spisak učesnika';
$string['participantslists'] = 'Učesnici';
$string['participantsusage'] = 'Evidentiraj prisustvo';
$string['participantsusage_help'] = 'Ova opcija određuje da li možete da evidentirate prisustvo polaznika sa spiskom prisutnih. Spiskovi prisutnih su dizajnirane za velike oflajn testove sa mnogo učesnika. Pomoću njih se može proveriti koji su polaznici učestvovali na testu i da li su svi rezultati tačno ocenjeni.';
$string['partimportnew'] = 'Postavljanje spiska učesnika';
$string['partimportnew_help'] = '<p>
У овој картици можете да поставите попуњене спискове учесника. Можете да отпремите појединачне датотеке скенираних слика или већи број њих, упакованих у ZIP-архиву. Модул \'Офлајн тест\' ће обрадити датотеке слика у позадини.
Називи датотека нису битни али не би требало да садрже посебне знакове као што су дијакритици, умлаути итд. Слике треба да буду у форматима GIF, PNG или TIF. Препоручује се резолуција између 200 и 300dpi (тачака по инчу).</p>';
$string['partuncheckedwithoutresult'] = 'Nepotvrđeni učesnici bez rezultata: {$a}';
$string['partuncheckedwithresult'] = '<a href="{$a->url}">Nepotvrđeni učesnici sa rezultatom: {$a->count}</a>';
$string['pdfdeletedforgroup'] = 'Obrazac za grupu {$a} obrisan';
$string['pdffont'] = 'Font obrasca';
$string['pdffont_help'] = 'Ovde možete izabrati font za sve vaše PDF obrasce: za odgovore, za ispravke, za prisustvo, kao i obrasce za pitanja, ukoliko ste za sve obrasce izabrali PDF format. Izbor takođe treba da zavisi od toga koje znakove koristite u svojim obrascima. DOCX i LATEX format ne utiču na listove sa pitanjima.';
$string['pdfintro'] = 'Dodatne informacije';
$string['pdfintro_help'] = 'Ove informacije biće štampane na prvoj stranici lista sa pitanjima. One treba da sadrže uputstvo kako se popunjava obrazac sa odgovorima.';
$string['pdfintrotext'] = '<b>Kako da pravilno obeležim odgovore?</b><br />Ovaj obrazac sa odgovorima biće automatski skeniran. Molimo vas da ga ne savijate ili žvrljate po njemu. Za obeležavanje odgovora koristite crnu ili plavu olovku. Odgovor koji smatrate tačnim obeležite znakom X. Ako želite da ispravite svoj odgovor, kompletno ispunite polje bojom. Tako obeleženo polje, prilikom skeniranja, biće interpretirano kao prazno.<br />';
$string['pdfintrotoolarge'] = 'Uvod je predugačak (maksimalno 2000 znakova).';
$string['pdfscreated'] = 'PDF obrasci su kreirani';
$string['pdfsdeletedforgroup'] = 'Obrasci za grupu {$a} obrisani';
$string['pearlywhite'] = 'Biserno bela';
$string['pluginadministration'] = 'Administracija oflajn testa';
$string['pluginname'] = 'Oflajn test';
$string['point'] = 'poen';
$string['preparation'] = '1 . Priprema';
$string['present'] = 'Prisutan';
$string['preventsamequestion'] = 'Sprečite višestruko korišćenje istog pitanja u različitim grupama';
$string['preview'] = 'Pregled';
$string['previewforgroup'] = 'Grupa {$a}';
$string['previewquestion'] = 'Pregledaj pitanje';
$string['printstudycodefield'] = 'Štampaj polje za šifru studijskog programa na listu sa pitanjima';
$string['printstudycodefield_help'] = 'Ako omogućite ovu opciju, onda će na prvoj stranici obrasca sa pitanjima biti odštampano polje za upisivanje šifre studijskog programa.';
$string['privacy:data_folder_name'] = 'Podaci oflajn testa';
$string['privacy:metadata:core_files'] = 'Oflajn test koristi API za čuvanje generisanih listova sa pitanjima, listova za odgovore i listova za ispravke, kao i listove sa popunjenim odgovorima.';
$string['privacy:metadata:core_question'] = 'Oflajn test koristi API za pitanja za čuvanje pitanja za testove.';
$string['privacy:metadata:mod_quiz'] = 'Oflajn test koristi API testa za čuvanje rezultata testova.';
$string['privacy:metadata:offlinequiz'] = 'Tabela oflajn testa čuva sve informacije vezane za konkretnu instancu oflajn testa.';
$string['privacy:metadata:offlinequiz:course'] = 'Kolona \'course\' u tabeli oflajn testa čuva podatak u kom kursu se ovaj oflajn testa nalazi.';
$string['privacy:metadata:offlinequiz:decimalpoints'] = 'Broj decimalnih poena za izračunavanje ocena.';
$string['privacy:metadata:offlinequiz:disableimgnewlines'] = 'Trebalo bi da onemogući nove redove pre i posle slika.';
$string['privacy:metadata:offlinequiz:docscreated'] = 'Ako su dokumenti kreirani, ovo polje je podešeno na 1, inače je 0.';
$string['privacy:metadata:offlinequiz:fileformat'] = 'Format datoteke koji se koristi za štampanje listova sa pitanjima, 0 za pdf, 1 za docx, 2 za LaTeX.';
$string['privacy:metadata:offlinequiz:fontsize'] = 'Veličina fonta u listovima sa pitanjima.';
$string['privacy:metadata:offlinequiz:grade'] = 'Ocena pokazuje maksimalan broj poena koji možete se dobiti na ovom oflajn testu.';
$string['privacy:metadata:offlinequiz:id_digits'] = 'Čuva broj cifara koju je ID broj imao kada su listovi za odgovore kreirani. Ovo je potrebno zbog povratne kompatibilnosti, ukoliko se broj cifara poveća u periodu između kreiranja (pre testa) i uvoza listova sa odgovorima (nakon testa).';
$string['privacy:metadata:offlinequiz:introformat'] = 'Ovo polje se ne koristi.';
$string['privacy:metadata:offlinequiz:name'] = 'Kolona \'name\' čuva naziv oflajn testa.';
$string['privacy:metadata:offlinequiz:numgroups'] = 'Broj grupa koje ovaj oflajn test ima.';
$string['privacy:metadata:offlinequiz:papergray'] = '”Vrednost za belo” ovog oflajn testa.';
$string['privacy:metadata:offlinequiz:pdfintro'] = 'Dodatne informacije koje se umeću na početak listova sa pitanjima.';
$string['privacy:metadata:offlinequiz:printstudycodefield'] = 'Parametar koji određuje da li treba odštampati šifru studija na obrascu sa pitanjima. 1 da, 0 ne';
$string['privacy:metadata:offlinequiz:review'] = 'Ova kolona čuva informacije o tome kako se pregled vrši.';
$string['privacy:metadata:offlinequiz:showgrades'] = 'Čuva podatke o tome da li treba na listu sa pitanjima odštamapti broj poena koji se dobija za svako pitanje.';
$string['privacy:metadata:offlinequiz:showquestioninfo'] = 'Čuva se ako treba da bude prikazana informacija o pitanjima, 0 za ne, 1 za informacije o tipu pitanja, 2 za informacije o broju tačnih odgovora.';
$string['privacy:metadata:offlinequiz:showtutorial'] = 'Čuva se ukoliko se od učesnika traži da urade tutorijal za oflajn test.';
$string['privacy:metadata:offlinequiz:shufflequestions'] = 'Parametar koji određuje da li prilikom kreiranja oflajn testa pitanja treba da budu izmešana; 1 - da, 0 - ne';
$string['privacy:metadata:offlinequiz:time'] = 'Kolona \'time\' čuva datum oflajn testa.';
$string['privacy:metadata:offlinequiz:timeclose'] = 'Kolona \'timeclose\' čuva vreme kada je oflajn test bio, odnosno, kada će biti zatvoren.';
$string['privacy:metadata:offlinequiz:timecreated'] = 'Kolona \'timecreated\' čuva vreme kada je oflajn test bio kreiran.';
$string['privacy:metadata:offlinequiz:timemodified'] = 'Kolona \'timemodified\' čuva vreme kada je oflajn test bio poslednji put promenjen.';
$string['privacy:metadata:offlinequiz:timeopen'] = 'Kolona \'timeclose\' čuva vreme kada je oflajn test bio, odnosno, kada će biti otvoren.';
$string['privacy:metadata:offlinequiz_choices'] = 'Ova tabela sadrži informacije o svim precrtanim odgovorima (obeleženim znakom X) na svim skeniranim stranicama. Informacije su potrebne za kasnije kreiranje rezultata na osnovu precrtanih odgovora (obeleženih znakom X).';
$string['privacy:metadata:offlinequiz_choices:choicenumber'] = 'Broj ponuđenih odgovora za ovo pitanje.';
$string['privacy:metadata:offlinequiz_choices:scannedpageid'] = 'Skenirana stranica na koju se ovaj izabrani odgovor odnosi.';
$string['privacy:metadata:offlinequiz_choices:slotnumber'] = 'Mesto ovog odgovora u pitanju';
$string['privacy:metadata:offlinequiz_choices:value'] = 'Da li se izabrani odgovor smatra precrtanim (obeleženim znakom X). 0 za ne, 1 za da, -1 za nije sigurno.';
$string['privacy:metadata:offlinequiz_group_questions'] = 'Ova tabela čuva sva pitanja za svaku grupu oflajn testa.';
$string['privacy:metadata:offlinequiz_group_questions:maxmark'] = 'Maksimalni broj poena koji se može postići za ovo pitanje.';
$string['privacy:metadata:offlinequiz_group_questions:offlinegroupid'] = 'Grupa oflajn testa na koju se ovo pitanje odnosi.';
$string['privacy:metadata:offlinequiz_group_questions:offlinequizid'] = 'ID oznaka oflajn testa na koju se ovo pitanje odnosi.';
$string['privacy:metadata:offlinequiz_group_questions:page'] = 'Stranica na kojoj je ovo pitanje odštampano u listovima za odgovore.';
$string['privacy:metadata:offlinequiz_group_questions:position'] = 'Pozicija u ovom oflajn testu.';
$string['privacy:metadata:offlinequiz_group_questions:questionid'] = 'ID oznaka izabranog pitanja.';
$string['privacy:metadata:offlinequiz_group_questions:slot'] = 'Mesto pitanja u testu';
$string['privacy:metadata:offlinequiz_groups'] = 'Tabela za grupe oflajn testova.';
$string['privacy:metadata:offlinequiz_groups:answerfilename'] = 'Naziv datoteke koja je korišćena za čuvanje odgovora.';
$string['privacy:metadata:offlinequiz_groups:correctionfilename'] = 'Datoteka koja je korišćena za čuvanje ispravki';
$string['privacy:metadata:offlinequiz_groups:number'] = 'Broj grupe za ovaj oflajn test, 1 za grupu A, 2 za grupu B, itd.';
$string['privacy:metadata:offlinequiz_groups:numberofpages'] = 'Broj stranica koji je potreban za štampanje listova za odgovore.';
$string['privacy:metadata:offlinequiz_groups:offlinequizid'] = 'ID oznaka oflajn testa kom pripada ovaj oflajn test.';
$string['privacy:metadata:offlinequiz_groups:questionfilename'] = 'Naziv datoteke koje je korišćeno za čuvanje datoteke sa pitanjima';
$string['privacy:metadata:offlinequiz_groups:sumgrades'] = 'Zbir svih ocena za sva pitanja u ovoj grupi.';
$string['privacy:metadata:offlinequiz_groups:templateusageid'] = 'ID oznaka upotrebe šablona API-ja, koji se koristi za kreiranje rezultata u API-ju testa.';
$string['privacy:metadata:offlinequiz_hotspots'] = 'Ova tabela čuva sve pozicije polja za odgovore ukoliko su uspešno ona evaluirana.';
$string['privacy:metadata:offlinequiz_hotspots:blank'] = 'Ako je aktivno područje uspešno analizirano.';
$string['privacy:metadata:offlinequiz_hotspots:name'] = 'Tip aktivnog područja, npr. u %number za aktivno područje korisnika, a-0-0 za pitanje 1 odgovor 1, i tako dalje.';
$string['privacy:metadata:offlinequiz_hotspots:scannedpageid'] = 'Skenirana stranica na kojoj se nalazi aktivno područje.';
$string['privacy:metadata:offlinequiz_hotspots:time'] = 'Vreme kada je poslednji put ažurirano ovo aktivno područje.';
$string['privacy:metadata:offlinequiz_hotspots:x'] = 'X vrednost aktivnog područja';
$string['privacy:metadata:offlinequiz_hotspots:y'] = 'Y vrednost aktivnog područja';
$string['privacy:metadata:offlinequiz_p_choices'] = 'Ova tabela čuva sve precrtane odgovore (obeležene znakom X) na listovima za odgovore polaznika.';
$string['privacy:metadata:offlinequiz_p_choices:scannedpageid'] = 'Skenirana stranica na koju se ovaj izabrani odgovor odnosi.';
$string['privacy:metadata:offlinequiz_p_choices:userid'] = 'ID oznaka korisnika na kog se odnosi ovaj izabrani odgovor.';
$string['privacy:metadata:offlinequiz_p_choices:value'] = 'Da li je kvadrat sa krstićem popunjen ili ne (0 za nepopunjen kvadrat, 1 za popunjen, -1 kada nije moguće utvrditi sa sigurnošću)';
$string['privacy:metadata:offlinequiz_p_lists'] = 'Ova tabela čuva informacije o spiskovima učesnika gde predavači mogu da označe, da li je polaznik bio na testu ili ne.';
$string['privacy:metadata:offlinequiz_p_lists:filename'] = 'Naziv datoteke za spisak.';
$string['privacy:metadata:offlinequiz_p_lists:name'] = 'Naziv spiska učesnika.';
$string['privacy:metadata:offlinequiz_p_lists:number'] = 'Број списка у офлајн тесту.';
$string['privacy:metadata:offlinequiz_p_lists:offlinequizid'] = 'Oflajn test kome ovaj spisak pripada.';
$string['privacy:metadata:offlinequiz_page_corners'] = 'Ova tabela čuva sve uglove svake skenirane stranice kako bi je brže evaluirala prilikom sledeće evaluacije ili ispravke.';
$string['privacy:metadata:offlinequiz_page_corners:position'] = 'Informacija o tome da li je ovaj ugao na vrhu ili na dnu i desno ili levo.';
$string['privacy:metadata:offlinequiz_page_corners:scannedpageid'] = 'Skenirana stranica na kojoj se nalazi ovaj ugao.';
$string['privacy:metadata:offlinequiz_page_corners:x'] = 'X vrednost ugla.';
$string['privacy:metadata:offlinequiz_page_corners:y'] = 'Y vrednost ugla.';
$string['privacy:metadata:offlinequiz_participants'] = 'Tabela učesnika čuva podatke o tome da li je korisnik učestvovao u oflajn testu ili ne.';
$string['privacy:metadata:offlinequiz_participants:checked'] = 'Informacije o tome da li je ovaj korisnik obeležen na spisku učesnika.';
$string['privacy:metadata:offlinequiz_participants:listid'] = 'ID oznaka spiska na kom se ovaj učesnik nalazi.';
$string['privacy:metadata:offlinequiz_participants:userid'] = 'ID oznaka korisnika.';
$string['privacy:metadata:offlinequiz_queue'] = 'Ova tabela čuva podatke o redu za otpremanje oflajn testa. Za svako otpremanje postoji njegov zasebni objekat u ovoj tabeli.';
$string['privacy:metadata:offlinequiz_queue:importuserid'] = 'Korisnička ID oznaka predavača koji je uvezao datoteke.';
$string['privacy:metadata:offlinequiz_queue:offlinequizid'] = 'ID oznaka oflajn testa u redu za čekanje.';
$string['privacy:metadata:offlinequiz_queue:status'] = 'Status reda za čekanje koji je potreban.';
$string['privacy:metadata:offlinequiz_queue:timecreated'] = 'Vreme kada su uvezeni ovi listovi oflajn testa.';
$string['privacy:metadata:offlinequiz_queue:timefinish'] = 'Vreme kada je evaluacija oflajn testa u redu za čekanje završena.';
$string['privacy:metadata:offlinequiz_queue:timestart'] = 'Vreme kada je evaluacija oflajn testa u redu za čekanje započeta.';
$string['privacy:metadata:offlinequiz_queue_data'] = 'Ova tabela čuva podatke za red pošto će svaka datoteka u redu za čekanje dobiti objekat podataka reda.';
$string['privacy:metadata:offlinequiz_queue_data:error'] = 'Ukoliko je status greška, ovde će stajati detaljnija poruka o grešci.';
$string['privacy:metadata:offlinequiz_queue_data:filename'] = 'Naziv datoteke na koju se ovaj red odnosi.';
$string['privacy:metadata:offlinequiz_queue_data:queueid'] = 'Red kojem ovi podaci pripadaju.';
$string['privacy:metadata:offlinequiz_queue_data:status'] = 'Status podataka o redu.';
$string['privacy:metadata:offlinequiz_results'] = 'Ova tabela čuva sve podatke o rezultatima, koji se ne mogu čuvati u API-ju testa.';
$string['privacy:metadata:offlinequiz_results:offlinegroupid'] = 'Grupa oflajn testa kojoj ovaj rezultat pripada.';
$string['privacy:metadata:offlinequiz_results:offlinequizid'] = 'Oflajn test, kojem ovaj rezultat pripada.';
$string['privacy:metadata:offlinequiz_results:status'] = 'Status rezultata (nepotpun ili potpun).';
$string['privacy:metadata:offlinequiz_results:sumgrades'] = 'Zbir svih ocena za ovaj rezultat.';
$string['privacy:metadata:offlinequiz_results:teacherid'] = 'Predavač koji je postavio rezultat.';
$string['privacy:metadata:offlinequiz_results:timefinish'] = 'Vreme završetka kada je rezultat umetnut po prvi put.';
$string['privacy:metadata:offlinequiz_results:timemodified'] = 'Datum izmene rezultata.';
$string['privacy:metadata:offlinequiz_results:timestart'] = 'Vreme početka kada je rezultat umetnut po prvi put.';
$string['privacy:metadata:offlinequiz_results:usageid'] = 'ID oznaka upotrebe šablona API-ja testa gde se ovaj rezultat čuva.';
$string['privacy:metadata:offlinequiz_results:userid'] = 'Korisnik kome ovaj rezultat pripada.';
$string['privacy:metadata:offlinequiz_scanned_p_pages'] = 'Ova tabela čuva stranice učesnika i njihove opšte informacije.';
$string['privacy:metadata:offlinequiz_scanned_p_pages:error'] = 'Greška (ako postoji) koju je ova stranica pokrenula tokom obrade.';
$string['privacy:metadata:offlinequiz_scanned_p_pages:filename'] = 'Naziv datoteke za skeniranu stranicu.';
$string['privacy:metadata:offlinequiz_scanned_p_pages:listnumber'] = 'Broj lista';
$string['privacy:metadata:offlinequiz_scanned_p_pages:offlinequizid'] = 'Oflajn test kojem pripada ova stranica sa učesnicima.';
$string['privacy:metadata:offlinequiz_scanned_p_pages:status'] = 'Status ove skenirane stranice.';
$string['privacy:metadata:offlinequiz_scanned_p_pages:time'] = 'Vreme obrade ove stranice.';
$string['privacy:metadata:offlinequiz_scanned_pages'] = 'Tabela čuva informacije o skeniranoj stranici oflajn testa.';
$string['privacy:metadata:offlinequiz_scanned_pages:error'] = 'Detaljna greška koju ova stranica ima (ako postoji)';
$string['privacy:metadata:offlinequiz_scanned_pages:filename'] = 'Naziv datoteke skenirane stranice.';
$string['privacy:metadata:offlinequiz_scanned_pages:groupnumber'] = 'Broj (groupnumber) grupe kojoj pripada ovaj oflajn test';
$string['privacy:metadata:offlinequiz_scanned_pages:offlinequizid'] = 'Oflajn test skenirane stranice.';
$string['privacy:metadata:offlinequiz_scanned_pages:pagenumber'] = 'Broj (pagenumber) ove stranice.';
$string['privacy:metadata:offlinequiz_scanned_pages:resultid'] = 'Rezultat koji se odnosi na ovu stranicu.';
$string['privacy:metadata:offlinequiz_scanned_pages:status'] = 'Status ove stranice.';
$string['privacy:metadata:offlinequiz_scanned_pages:time'] = 'Vreme obrade stranice.';
$string['privacy:metadata:offlinequiz_scanned_pages:userkey'] = 'userkey (ne userid) precrtanog korisnika na stranici.';
$string['privacy:metadata:offlinequiz_scanned_pages:warningfilename'] = 'Naziv datoteke koja se kreira kada se pogrešno popunjen oflajn test ispravi i korisnik dobije upozorenje o tome.';
$string['privacy:metadata:offlinequizpagesize'] = 'Podešava broj rezultata testa za stranicu sa rezultatima.';
$string['questionanalysis'] = 'Analiza pitanja';
$string['questionanalysistitle'] = 'Tabela sa analizom pitanja';
$string['questionandansweranalysis'] = 'Analiza pitanja i odgovora';
$string['questionbankcontents'] = 'Sadržaj banke pitanja';
$string['questionforms'] = 'Obrasci sa pitanjima';
$string['questioninfoanswers'] = 'Broj tačnih odgovora';
$string['questioninfocorrectanswer'] = 'tačan odgovor';
$string['questioninfocorrectanswers'] = 'tačni odgovori';
$string['questioninfonone'] = 'Ništa';
$string['questioninfoqtype'] = 'Tip pitanja';
$string['questionname'] = 'Naziv pitanja';
$string['questionpage'] = 'Stranica';
$string['questionsheet'] = 'List sa pitanjima';
$string['questionsheetlatextemplate'] = '% !TEX encoding = UTF-8 Unicode
\\documentclass[11pt,a4paper]{article}
\\usepackage[utf8x]{inputenc}
\\usepackage[T1]{fontenc}
\\textwidth 16truecm
\\textheight 23truecm
\\setlength{\\oddsidemargin}{0cm}
\\setlength{\\evensidemargin}{0cm}
\\setlength{\\topmargin}{-1cm}
\\usepackage{amsmath} % for \\implies etc
\\usepackage{amsfonts} % for \\mathbb etc
\\usepackage[colorlinks=true,urlcolor=dunkelrot,linkcolor=black]{hyperref} % For using hyperlinks
\\usepackage{ifthen}
\\usepackage{enumitem}
\\usepackage{xcolor}
\\usepackage{ulem}
\\parindent 0pt % no indent on the beginning of a section
\\renewcommand\\UrlFont{\\sf}
\\usepackage{lastpage}
\\usepackage{fancyhdr}
\\pagestyle{fancy}
\\chead{\\sc \\TestTitle, Group \\Group}
\\cfoot{Seite \\thepage/\\pageref{LastPage}}
\\makeatletter %%% disable pagebreaks between answers
\\@beginparpenalty=10000
\\@itempenalty=10000
\\makeatother
%
\\newcommand{\\answerIs}[1]{} %%%Disable showing the right answer
% \\newcommand{\\answerIs}[1]{[#1]} %%%Enable showing the right answer
%%%


% ===========================================================================================================
%%% Course data:
\\newcommand{\\Group}{{$a->groupname}}
\\newcommand{\\Title}{{$a->activityname}}
%%% Or use {{$a->coursename} as course name instead
\\newcommand{\\Date}

\\newcommand{\\TestTitle}{%
\\begin{center}
{\\bf \\Large Question sheet}\\\\[3mm]
\\fbox{
\\begin{tabular}{rl}
\\rule{0pt}{25pt} Name: & $\\underline{\\hspace*{8cm}}$ \\rule{20pt}{0pt}\\\\[5mm]
ID number: & $\\underline{\\hspace*{8cm}}$\\\\[5mm]
\\ifthenelse{\\equal{true}{{$a->printstudycodefield}}}{\\rule{10pt}{0pt} Study code: & $\\underline{\\hspace*{8cm}}$\\\\[5mm]}{}
\\rule[-20pt]{0pt}{20pt} Signature: & $\\underline{\\hspace*{8cm}}$
\\end{tabular}}
\\end{center}
}

\\InputIfFileExists{offline_test_extras.tex}{}{} % Input extra user definitions

\\begin{document}


% ===========================================================================================================
\\TestTitle

% ===========================================================================================================


\\bigskip
% ===========================================================================================================

{$a->pdfintrotext}

% ===========================================================================================================

\\newpage

% ===========================================================================================================


{$a->latexforquestions}


\\end{document}';
$string['questionsin'] = 'Pitanja u';
$string['questionsingroup'] = 'Grupa';
$string['questionsinthisofflinequiz'] = 'Pitanja u ovom oflajn testu';
$string['questiontextisempty'] = '[Prazan tekst pitanja]';
$string['queueamountofpages'] = 'Broj uključenih datoteka:';
$string['queuedownload'] = 'Preuzmi';
$string['queuefilecorrect'] = 'Tačno';
$string['queuefilecorrectionhovertext'] = 'Ispravka';
$string['queuefiledownloadhovertext'] = 'Preuzimanje';
$string['queuefileerror'] = 'Poruka o grešci:';
$string['queuefilefilename'] = 'Originalna datoteka:';
$string['queuefilegroupnumber'] = 'Broj grupe:';
$string['queuefileheader'] = 'Stranice u ovoj datoteci';
$string['queuefileimportedat'] = 'Uvezena datoteka:';
$string['queuefileimportedby'] = 'Uvezao/la:';
$string['queuefilenotstarted'] = 'Evaluacija još nije počela';
$string['queuefilepagenumber'] = 'Broj stranice:';
$string['queuefileprocessing'] = 'Evaluacija u toku...';
$string['queuefilesactionsheader'] = 'Akcije';
$string['queuefilesdetailsheader'] = 'Detaljnje informacije';
$string['queuefilesfileheader'] = 'Datoteka';
$string['queuefilestatus'] = 'Status datoteke:';
$string['queuefilestatusheader'] = 'Status';
$string['queuefilestatusmessage_error'] = 'Neophodna je korekcija';
$string['queuefilestatusmessage_new'] = 'predato';
$string['queuefilestatusmessage_processed'] = 'OK';
$string['queuefilestatusmessage_processing'] = 'obrada';
$string['queuefilestatusmessage_submitted'] = 'predato';
$string['queuefilestudent'] = 'Ime polaznika:';
$string['queuefinishedtime'] = 'Evaluacija završena u:';
$string['queueheader'] = 'Otpremljene datoteke';
$string['queuenotfinished'] = 'Evaluacija nije završena.';
$string['queuenotstarted'] = 'Evaluacija nije započeta.';
$string['queuestarttime'] = 'Evaluacija je započela u:';
$string['queuestatus'] = 'Status reda za čekanje:';
$string['quizdate'] = 'Datum oflajn testa';
$string['quizopenclose'] = 'Datumi otvaranja i zatvaranja';
$string['quizopenclose_help'] = 'Pregled na mreži može biti ograničen na određeni vremenski period. Kliknite na dugme "Prikaži" da biste promenili postavke datuma i vremena.

**Oprez :** Ukoliko vremenski period za onlajn pregled nije aktiviran, pregled je neograničen sve dok je oflajn test vidljiv učesnicima.

U svim slučajevima, prikazuju se samo opcije označene pod "Pregled uključuje".';
$string['qversioncannotupdate'] = 'Verzija pitanja se ne može ažurirati';
$string['qversionnumbersdiffer'] = 'Број одговора се разликује између старе и нове верзије. То доводи до недоследности.';
$string['qversionupdated'] = 'Verzija pitanja je ažurirana';
$string['qversionupdatedwarning'] = 'Obrasci su već kreirani<br>Ako rezultati postoje, oni će automatski biti promenjeni na osnovu trenutne verzije izmenjenih pitanja, ovde izabranih. U dokumentima je i dalje prikazana originalna verzija pitanja.';
$string['qversionupdateerror'] = 'Došlo je do greške prilikom ažuriranja verzije pitanja.';
$string['randomfromexistingcategory'] = 'Nasumično pitanja iz postojeće kategorije';
$string['randomnumber'] = 'Broj nasumičnih pitanja';
$string['randomquestionusinganewcategory'] = 'Nasumično pitanje koristeći novu kategoriju';
$string['readjust'] = 'Podesi';
$string['reallydeletepdfs'] = 'Da li zaista želite da izbrišete datoteke obrazaca?';
$string['reallydeleteupdatepdf'] = 'Da li da zaboravim da opljačkam i preudam polica za knjige?';
$string['recordupdateanddocscreated'] = 'Pitanja su ažurirana, ali pošto su obrasci već kreirani, prethodna verzija pitanja je i dalje aktivna. Da biste prešli na noviju verziju, obrišite obrasce i promenite.';
$string['recordupdateanddocscreatedversion'] = 'Pitanja su ažurirana, ali su obrasci već kreirani. Proverite da li izmene u pitanjima nisu dovele do promena koje utiču na ocenjivanje.';
$string['recreatepdfs'] = 'Ponovo kreiraj PDF dokumente';
$string['recurse'] = 'Uključi i pitanja iz potkategorija';
$string['rediswrong'] = 'krstić pogrešan ili nedostaje';
$string['refreshpreview'] = 'Osveži pregled';
$string['regrade'] = 'Ponovno ocenjivanje';
$string['regradedisplayexplanation'] = '<b>Pažnja:</b> Ponovno ocenjivanje neće promeniti obeležene odgovore koji su ručno izmenjeni!';
$string['regradinginfo'] = 'Ako promenite ocenu za pitanje, morate ponovo da ocenite oflajn test kako biste ažurirali rezultate učesnika.';
$string['regradingquiz'] = 'Ponovno ocenjivanje';
$string['regradingresult'] = 'Ponovno ocenjivanje rezultata za korisnika {$a}...';
$string['reloadpreview'] = 'Ponovo učitaj pregled';
$string['reloadquestionlist'] = 'Ponovo učitaj spisak pitanja';
$string['remove'] = 'Ukloni';
$string['removeemptypage'] = 'Ukloni praznu stranicu';
$string['removepagebreak'] = 'Ukloni prelom stranice';
$string['removeselected'] = 'Ukloni izabrano';
$string['reordergroupquestions'] = 'Promeni redosled pitanja grupe';
$string['reorderquestions'] = 'Promeni redosled pitanja';
$string['reordertool'] = 'Prikaži alat za reorganizovanje pitanja';
$string['repaginate'] = 'Reorganizuj stranice sa {$a} pitanja po jednoj stranici';
$string['repaginatecommand'] = 'Reorganizuj stranice';
$string['repaginatenow'] = 'Reorganizuj stranice sad';
$string['reportends'] = 'Pregled rezultata se završava';
$string['reportoverview'] = 'Pregled';
$string['reportstarts'] = 'Pregled rezultata počinje';
$string['resetofflinequizzes'] = 'Resetuj podatke oflajn testa';
$string['resultexists'] = 'Isti rezultat za {$a} već postoji, uvoz se ignoriše';
$string['resultimport'] = 'Otpremi';
$string['results'] = 'Rezultati';
$string['resultsavailable'] = 'Broj dostupnih rezultata:';
$string['review'] = 'Pregled';
$string['reviewbefore'] = 'Dozvoli pregled dok je oflajn test otvoren';
$string['reviewclosed'] = 'Nakon što se oflajn test zatvori';
$string['reviewcloses'] = 'Pregled se zatvara';
$string['reviewimmediately'] = 'Odmah nakon pokušaja';
$string['reviewincludes'] = 'Pregled uključuje';
$string['reviewofresult'] = 'Pregled rezultata';
$string['reviewopens'] = 'Pregled se otvara';
$string['reviewoptions'] = 'Polaznici mogu da vide';
$string['reviewoptions_help'] = 'Sa ovim opcijama možete da kontrolišete šta polaznici mogu da vide nakon što se uvezu pokušaji. Takođe možete da definišete vremenski period tokom kojeg će biti dostupan izveštaj sa rezultatima.

Polja za potvrdu imaju sledeća značenja:

**Pokušaj ** - Tekst pitanja i odgovori biće prikazani polaznicima. Oni će videti odgovore koje su izabrali, ali tačni odgovori neće biti naznačeni.

**Da li je odgovor tačan** - Ova opcija može da bude aktivirana samo ako je uključena opcija "Pokušaj". Ako se aktivira, polaznici će moći da vide koji od odgovora koje su izabrali je tačan (zelena pozadina), a koji netačan (crvena pozadina).

**Ocene ** - Biće prikazana grupa testa (npr. B), rezultati (postignuta ocena, ukupna ocena za pitanja, postignuće u procentima, na primer 40/80 (50)) i ocena (npr. 50 od maksimalnih100). Pored toga, ako je uključena opcija "Pokušaj", za svako pitanje biće prikazani postignut, kao i maksimalan rezultat.

**Specifične povratne informacije** - Povratne informacije zavisi od toga kakav je odgovor polaznik dao.

**Opšte povratne informacije** - Opšte povratne informacije se prikazuju polazniku nakon što su rezultati uvezeni. Za razliku od specifičnih povratnih informacija, koje zavise od tipa pitanja i odgovora koji je polaznik dao, isti tekst opšte povratne informacije se prikazuje svim polaznicima. Možete koristiti opšte povratne informacije kako biste polaznicima dali potpun odgovor i možda link ka dodatnim informacijama, koje oni mogu da iskoriste ako nisu razumeli pitanja.

**Tačni odgovori** - Ako je ova opcija aktivirana biće pokazano koji odgovori su tačni, a koji netačni. Ova opcija dostupna je samo ako je uključen "Pokušaj".

**Skenirani obrazac** - Prikazuje su skenirani obrasci sa odgovorima. Obeležena polja (odgovori) su označena zelenim kvadratom.

**Skenirani obrazac sa ocenama** - Prikazuje su skenirani obrasci sa odgovorima. Obeležena polja (odgovori) su označena zelenim kvadratom. Pogrešno obeleženi odgovori, kao i oni koji nisu obeleženi su istaknuti. Pored toga, tabela prikazuje maksimalnu i postignutu ocenu za svako pitanje.';
$string['reviewoptionsheading'] = 'Opcije pregleda';
$string['rimport'] = 'Otpremi';
$string['rotate'] = 'Rotiraj';
$string['rotatingsheet'] = 'List je rotiran...';
$string['save'] = 'Sačuvaj';
$string['saveandshow'] = 'Sačuvaj i pokaži promene polaznicima';
$string['savescannersettings'] = 'Sačuvaj podešavanja skenera';
$string['scannedform'] = 'Skenirani obrazac';
$string['scannerformfortype'] = 'Obrazac za tip {$a}';
$string['scanneroptions'] = 'Podešavanja skenera';
$string['scannerpdfs'] = 'Prazni obrasci';
$string['scannerpdfstext'] = 'Preuzeti sledeća prazne obrasce ako želite da koristite svoj softver za skeniranje.';
$string['scanningoptionsheading'] = 'Opcije za skeniranje';
$string['score'] = 'Skor';
$string['search:activity'] = 'Oflajn test – informacije o aktivnosti';
$string['select'] = 'Izaberi';
$string['selectagroup'] = 'Izaberi grupu';
$string['selectall'] = 'Izaberi sve';
$string['selectcategory'] = 'Izaberi kategoriju';
$string['selectdifferentgroup'] = 'Molimo vas, izaberite drugu grupu!';
$string['selectedattempts'] = 'Izabrani pokušaji...';
$string['selectformat'] = 'Izaberi format...';
$string['selectgroup'] = 'Izaberi grupu';
$string['selectlist'] = 'Izaberite spisak ili pokušajte da podesite list:';
$string['selectmultipletoolbar'] = 'Izaberite višestruku traku sa alatkama';
$string['selectnone'] = 'Poništi izbor svega';
$string['selectpage'] = 'Izaberite broj stranice ili pokušajte da podesite list:';
$string['selectquestion'] = 'Izaberite pitanje {$a}';
$string['selectquestiontype'] = '-- Izaberi tip pitanja --';
$string['showallparts'] = 'Prikaži sve učesnike, njih {$a}';
$string['showcopyright'] = 'Prikaži izjavu o autorskim pravima';
$string['showcopyrightdesc'] = 'Ako omogućite ovu opciju, izjava o autorskim pravima biće prikazana na stranici polaznika za pregled rezultata.';
$string['showgrades'] = 'Štampaj ocene za pitanja';
$string['showgrades_help'] = 'Ova opcija određuje da li na listu sa pitanjima treba da se štampaju maksimalne ocene za pitanja oflajn testa.';
$string['showmissingattemptonly'] = 'Prikaži sve označene učesnike bez pokušaja';
$string['showmissingcheckonly'] = 'Prikaži sve označene učesnike sa rezultatom';
$string['shownumpartsperpage'] = 'Prikaži {$a} učesnika po stranici';
$string['showquestioninfo'] = 'Štampaj informacije o odgovorima';
$string['showquestioninfo_help'] = 'Pomoću ove opcije možete da odredite koje dodatne informacije o pitanju će se štampati na listu sa pitanjima.
Možete da izaberete jednu od sledećih opcija:
<ul>
<li> Ništa
<li> Tip pitanja - zavisno od tipa pitanja biće odštampano ”Višestruki izbor sa jednim tačnim odgovorom”, ”Višestruki izbor sa više tačnih odgovora”, ”Višestruki izbor sa više tačnih odgovora tipa sve-ili-ništa”
<li> Broj tačnih odgovora
</ul>';
$string['showstudentview'] = 'Prikaži pregled iz ugla polaznika';
$string['showtutorial'] = 'Prikaži polaznicima uputstvo za oflajn test.';
$string['showtutorial_help'] = 'Ova opcija određuje da li polaznici mogu da vide uputstvo sa osnovnim informacijama o oflajn testovima.
Uputstvo pruža informacije o tome kako se postupa sa različitim vrstama dokumenata unutar oflajn testova. U interaktivnom delu polaznici uče kako da pravilno unesu svoju ID oznaku.<br />
<b>Imajte u vidu:</b><br />
Ako postavite ovu opciju na "Da", ali pritom sakrijete oflajn test link ka uputstvu neće biti vidljiv. U tom slučaju možete da dodate link ka uputstvu na stranici kursa.';
$string['showtutorialdescription'] = 'Možete dodati link ka uputstvu na stranici kursa koristeći sledeću URL adresu:';
$string['shuffleanswers'] = 'Izmešaj odgovore';
$string['shufflequestions'] = 'Izmešaj pitanja';
$string['shufflequestionsanswers'] = 'Izmešaj pitanja i odgovore';
$string['shufflequestionsselected'] = 'Opcija za mešanje pitanja je uključena, tako da pojedine akcije u vezi sa stranicama nisu dostupne. Da biste promenili opciju za mešanje pitanja idite na stranicu za uređivanje oflajn testa - {$a}.';
$string['shufflewithin'] = 'Izmešaj unutar pitanja';
$string['shufflewithin_help'] = 'Ako je ova opcija omogućena, onda će odgovori unutar svih pitanja biti nasumično izmešani svaki put kada pritisnete dugme za ponovno učitavanje na stranici za pregled obrasca sa pitanjima. NAPOMENA: Ovo podešavanje se primenjuje samo na pitanja kod kojih je opcija za mešanje aktivirana.';
$string['signature'] = 'Potpis';
$string['singlechoice'] = 'Višestruki izbor sa jednim tačnim odgovorom';
$string['standard'] = 'Standardna';
$string['starttutorial'] = 'Startuj uputstvo o oflajn testiranju';
$string['statistics'] = 'Statistika';
$string['statisticsplural'] = 'Statistika';
$string['statisticsviewheader'] = '3. Statistika';
$string['statsoverview'] = 'Pregled statistike';
$string['studycode'] = 'Šifra studijskog programa';
$string['subplugintype_offlinequiz'] = 'Izveštaj o oflajn testu';
$string['subplugintype_offlinequiz_plural'] = 'Izveštaji sa oflajn testova';
$string['tabattendances'] = 'Prisutnost';
$string['tabattendancesoverview'] = 'Prisutnost';
$string['tabdownloadparticipantsforms'] = 'Obrasci';
$string['tabdownloadquizforms'] = 'Obrasci';
$string['tabeditgrades'] = 'Ocene';
$string['tabeditgroupquestions'] = 'Pitanja';
$string['tabeditparticipants'] = 'Učesnici';
$string['tabofflinequizcontent'] = 'Priprema';
$string['tabofflinequizcorrect'] = 'Ispravka';
$string['tabofflinequizupload'] = 'Otpremanje';
$string['tabparticipantlists'] = 'Spisak prisutnih';
$string['tabparticipantscorrect'] = 'Tačno';
$string['tabparticipantsupload'] = 'Otpremanje';
$string['tabpreview'] = 'Obrasci';
$string['tabquestionandanswerstats'] = 'Analiza pitanja i odgovora';
$string['tabquestionstats'] = 'Analiza pitanja';
$string['tabresults'] = 'Rezultati';
$string['tabresultsoverview'] = 'Rezultati';
$string['tabstatistics'] = 'Statistika';
$string['tabstatsoverview'] = 'Informacije o testu';
$string['temporaryfiledeletiontask'] = 'Obrišite privremene datoteke';
$string['theattempt'] = 'Pokušaj';
$string['timesup'] = 'Vreme je isteklo!';
$string['totalmarksx'] = 'Ukupna ocene za sva pitanja: {$a}';
$string['totalpointsx'] = 'Ukupna ocene za sva pitanja: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Ukupan broj pitanja u kategoriji: {$a}.';
$string['trigger'] = 'donja/gornja granica';
$string['tutorial'] = 'Uputstvo za oflajn testove';
$string['tutorial:feedback:1:1'] = 'U obrascu za odgovore nema pitanja. Obrazac za odgovore sadrži samo polja za označavanje vaših odgovora.';
$string['tutorial:feedback:1:2'] = 'Izgled lista sa pitanjima ne mora da bude potpuno isti kao na ekranu. On služi samo da vam pokaže pitanja i neće biti skeniran.';
$string['tutorial:feedback:2:1'] = 'Ovaj krstić (znak X) je previše bled. Moguće je da neće biti ispravno skeniran.';
$string['tutorial:feedback:2:2'] = 'Krstić (oznaka X) normalne debljine biće uvek pravilno interpretiran.';
$string['tutorial:feedback:2:3'] = 'Krstić (oznaka X) debljih linija bi se mogao interpretirati kao ispravljen odgovor.';
$string['tutorial:feedback:2:4'] = 'Prazan kvadrat nikad neće biti interpretiran kao kvadrat sa krstićem.';
$string['tutorial:feedback:2:5'] = 'Potpuno popunjen kvadrat tumači se potpuno isto kao i prazan kvadrat.';
$string['tutorial:feedback:3:1'] = 'Skeniraju se samo krstići u kvadratima. Zato je veoma važno da označite prave kvadratiće ispod svog identifikacionog broja.';
$string['tutorial:feedback:3:2'] = 'Skeniraju se samo krstići u kvadratima. Zato je veoma važno da označite prave kvadratiće ispod svog identifikacionog broja.';
$string['tutorial:feedback:3:3'] = 'Skeniraju se samo krstići u kvadratima. Zato je veoma važno da označite prave kvadratiće ispod svog identifikacionog broja.';
$string['tutorial:feedback:3:4'] = 'Skeniraju se samo krstići u kvadratima. Zato je veoma važno da označite prave kvadratiće ispod svog identifikacionog broja.';
$string['tutorial:feedback:4:0'] = 'Pogrešili ste. Vaš identifikacioni broj je {$a->correctusernumber}, a vi ste označili {$a->selectedusernumber}';
$string['tutorial:feedback:4:1'] = 'Uspešno ste završili ovo uputstvo.';
$string['tutorial:feedback:correct'] = 'Tačno!';
$string['tutorial:feedback:wrong'] = 'Pogrešno!';
$string['tutorial:generatedusernumberwarning'] = 'Ovo je generisani identifikacioni broj pošto ga vaš nalog nema!';
$string['tutorial:header:1'] = '1. Listovi sa pitanjima i obrasci za odgovore';
$string['tutorial:header:2'] = '2 . Krstići (oznake X) i ispravke';
$string['tutorial:header:3'] = '3. Obrazac za odgovore';
$string['tutorial:header:4'] = '4 . Obeležavanje vašeg identifikacionog broja';
$string['tutorial:header:5'] = '5 . Na kraju...';
$string['tutorial:identification_info'] = 'Vaš identifikacioni broj je: {$a}';
$string['tutorial:introduction:1'] = 'Na ispitu ćete dobiti dva lista: jedan sa pitanjima i jedan sa kvadratićima na kojima ćete označiti svoje odgovore. Pitanja su numerisana, kao i polja na obrascu za odgovore. Svaki odgovor je označen slovom. Nakon ispita, obrazac za odgovore se skenira i kompjuterski interpretira.';
$string['tutorial:introduction:2:1'] = 'Kvadrati na listu za odgovore su široki 5 milimetara. Kvadrati koje pripadaju istom pitanju su u istom redu. Broj pitanja je na levoj strani, a slovo koje odgovara stavci odgovora je na vrhu kolone.';
$string['tutorial:introduction:2:2'] = 'Koristite crnu ili plavu olovku da označite kvadrate. Ako želite da ispravite oznaku, popunite polje u potpunosti. Ovo polje će se tada biti onterpretirano kao prazan kvadrat.';
$string['tutorial:introduction:3:1'] = 'Obrazac za odgovore sadrži blok za vaše ime (A), blok za vaš identifikacioni broj (B) i blok za odgovore (C). Prvo popunite polja za svoje ime, potpis i identifikacioni broj. Imajte na umu da mašina neće pokušati da interpretira vaš rukopis nakon pregleda. Ova polja služe samo za potrebe dokumentacije.';
$string['tutorial:introduction:3:2'] = 'Pažljivo označite polja za svoj identifikacioni broj jer će računaru biti potrebne ove oznake da identifikuje vaše rezultate. Greške u bloku sa vašim identifikacionim brojem mogu dovesti do kašnjenja i pogrešnog tumačenja.';
$string['tutorial:introduction:4'] = 'Na kraju ovog uputstva nudimo vam mali test gde možete naučiti kako da pravilno popunite oznake za svoj identifikacioni broj. Ispod polja za vaš identifikacioni broj nalazi se matrica sa kvadratima. Svaka kolona predstavlja jednu cifru vašeg identifikacionog broja. Redovi označavaju brojeve napisane na levoj i desnoj strani. Kliknite na kvadrate kako biste ih označili. Kliknite ponovo da uklonite oznaku. Ako želite da krenete ispočetka, molim vas <a href="javascript: document.location.reload()">ponovo učitajte stranicu</a>.';
$string['tutorial:introduction:5'] = 'Imajte na umu da obrazac sa odgovorima interpretira kompjuter. On ne može da pročita ništa što napišete pored kvadrata. Za kompjuterski program sve što je van kvadrata je samo mesto koje ga sprečava da pravilno protumači obrazac. Ukoliko ne označite odgovore ispravno izgubićete poene.';
$string['tutorial:option:1:1'] = 'Obrazac za odgovore';
$string['tutorial:option:1:2'] = 'List sa pitanjima';
$string['tutorial:option:3:1'] = 'Sistem čita vaše ime koristeći softver za optičko prepoznavanje znakova.';
$string['tutorial:option:3:2'] = 'Vaš potpis se skenira pomoću softvera koji se koristi za otiske prstiju u krivičnim istragama.';
$string['tutorial:option:3:3'] = 'Interpretiraju se samo krstići u kvadratima pod vašim identifikacionim brojem.';
$string['tutorial:option:3:4'] = 'Sistem čita vaš identifikacioni broj koristeći softver za optičko prepoznavanje znakova.';
$string['tutorial:question:1'] = 'Ova slika pokazuje:';
$string['tutorial:question:2'] = 'Koja oznaka će se sigurno tumačiti kao krstić (znak X)?';
$string['tutorial:question:3'] = 'Kako kompjuter dodeljuje obrazac za odgovore pravoj osobi?';
$string['tutorial:question:4'] = 'Identifikacioni broj';
$string['tutorial:question:5'] = 'Srećno!';
$string['tutorial:questionsheet:1'] = '1)&nbsp;&nbsp; Koliko dokumenata oflajn testa će vam biti dato tokom ispita?';
$string['tutorial:questionsheet:1:1'] = 'a)&nbsp;&nbsp;0';
$string['tutorial:questionsheet:1:2'] = 'b)&nbsp;&nbsp;1';
$string['tutorial:questionsheet:1:3'] = 'c)&nbsp;&nbsp;2';
$string['tutorial:questionsheet:1:4'] = 'd)&nbsp;&nbsp;3';
$string['tutorial:questionsheet:1:5'] = 'e)&nbsp;&nbsp;4';
$string['tutorial:questionsheet:1:marks'] = '(Poeni: 1)';
$string['tutorial:questionsheet:2'] = '2)&nbsp;&nbsp; Koji sadržaj je dostupan na upitniku oflajn testa?';
$string['tutorial:questionsheet:2:1'] = 'a)&nbsp;&nbsp;Pitanja';
$string['tutorial:questionsheet:2:2'] = 'b)&nbsp;&nbsp;Opcije odgovora';
$string['tutorial:questionsheet:2:3'] = 'c)&nbsp;&nbsp;Tačni odgovori';
$string['tutorial:questionsheet:2:4'] = 'd)&nbsp;&nbsp;Dodatne informacije';
$string['tutorial:questionsheet:2:5'] = 'e)&nbsp;&nbsp;Ništa od navedenog';
$string['tutorial:start_text'] = 'Ovaj tutorijal bi trebalo da vam pokaže pravilan način popunjavanja obrazaca oflajn testa i obeležavanja odgovora za automatsku procenu. Toplo vam preporučujemo da prođete kroz tutorijal barem jednom, pre nego što pokrenete svoj prvi test ili ispit sa oflajn testom.';
$string['tutorial:starttutorial'] = 'Pokreni tutorijal';
$string['tutorial:title'] = 'Uputstvo';
$string['tutorial:title:navigation'] = 'Navigacija';
$string['type'] = 'Tip';
$string['uncheckparts'] = 'Obeleži izabrane korisnike kao odsutne';
$string['unknownmimetype'] = 'Nepoznati i nepodržani mimetype datoteke {$a->mimetpye}';
$string['updatedsumgrades'] = 'Zbir svih ocena za grupu {$a->letter} je preračunat na {$a->grade}.';
$string['upgradingfilenames'] = 'Ažuriranje naziva datoteka dokumenata: oflajn test {$a->done}/{$a->outof} <br/>(Oflajn test ID {$a->info})';
$string['upgradingilogs'] = 'Resetuj podatke Oflajn testa';
$string['upgradingofflinequizattempts'] = 'Ažuriranje pokušaja rešavanja testa: oflajn test $a->done}/{$a->outof} <br/>(Oflajn test ID {$a->info})';
$string['upload'] = 'Otpremi';
$string['uploadfurtherfiles'] = 'Otpremi dodatne datoteke';
$string['uploadpart'] = 'Otpremi';
$string['uppertrigger'] = 'Druga gornja granica';
$string['uppertriggerzero'] = 'Druga gornja granica je nula';
$string['upperwarning'] = 'Prva gornja granica';
$string['upperwarningzero'] = 'Prva gornja granica je nula';
$string['useradded'] = 'Korisnik {$a} je dodat/a';
$string['userdoesnotexist'] = 'Korisnik {$a} ne postoji u sistemu';
$string['useridentification'] = 'Identifikacija korisnika';
$string['useridviolation'] = 'Pronađeno je više korisnika sa istom ID oznakom';
$string['userimported'] = 'Korisnik {$a} je uvezen/a i ocenjen/a';
$string['usernotincourse'] = 'Korisnik {$a} nije na kursu.';
$string['usernotinlist'] = 'Korisnik nije registrovan na spisku!';
$string['usernotregistered'] = 'Korisnik {$a} nije registrovan na kursu';
$string['userpageimported'] = 'Jedna stranica uvezena za korisnika {$a}';
$string['usetabs'] = 'Koristite navigaciju putem kartica';
$string['usetabsdesc'] = 'Ako je ova opcija omogućena, treći nivo navigacije u okviru oflajn testa biće prikazan putem kartica. Ako je ova opcija onemogućena, umesto kartica za navigaciju će se koristiti padajući meni.';
$string['valuezero'] = 'Vrednost ne bi trebalo da bude nula';
$string['viewresults'] = 'Prikaži rezultate';
$string['white'] = 'Bela';
$string['wirismathenabled'] = 'Omogući WIRIS Math jednačine';
$string['wirismathenabled_help'] = 'Ako je ova opcija omogućena, WIRIS Math jednačine mogu se koristiti u tekstu pitanja, kao i u odgovorima.';
$string['withselected'] = 'Sa izabranim....';
$string['zerogradewarning'] = 'Upozorenje: Vaša ocena za oflajn test je 0.0!';
$string['zipfile'] = 'ZIP datoteka';
$string['zipok'] = 'ZIP datoteka uvezena';
