<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'it', version '5.0'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Hai sessioni BigBlueButton imminenti';
$string['bbbduetimeoverstartingtime'] = 'La data di chiusura della sessione deve essere successiva alla data di inizio della riunione';
$string['bbbdurationwarning'] = 'La durata massima della sessione è %duration% minuti.';
$string['bbbrecordallfromstartwarning'] = 'La sessione sarà registrata dall\'inizio.';
$string['bbbrecordwarning'] = 'La sessione può essere registrata.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Aggiungere una stanza BigBlueButton';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Creare istanze live';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Creare istanze con registrazione';
$string['bigbluebuttonbn:deleterecordings'] = 'Eliminare registrazioni';
$string['bigbluebuttonbn:importrecordings'] = 'Importare registrazioni';
$string['bigbluebuttonbn:join'] = 'Accedere alla stanza BigBlueButton';
$string['bigbluebuttonbn:managerecordings'] = 'Gestire registrazioni';
$string['bigbluebuttonbn:protectrecordings'] = 'Proteggere registrazioni';
$string['bigbluebuttonbn:publishrecordings'] = 'Pubblicare registrazioni';
$string['bigbluebuttonbn:seepresentation'] = 'Visualizzare sempre il file della presentazione nella pagina dell’attività';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Rimuovere la protezione delle registrazioni';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Rimuovere la pubblicazione delle registrazioni';
$string['bigbluebuttonbn:view'] = 'Visualizzare una stanza BigBlueButton';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Visualizzare tutti i forati di registarzione';
$string['cachedef_currentfetch'] = 'Elenchi più recenti delle registrazioni';
$string['cachedef_recordings'] = 'Metadati delle registrazioni';
$string['cachedef_serverinfo'] = 'Informazioni del server remoto';
$string['cachedef_subplugins'] = 'Cache utilizzata dalle routine dei subplugin per accelerare quando necessario il processo di rilevamento dei plugin.';
$string['cachedef_validatedurls'] = 'Verifiche delle URL validate';
$string['calendarstarts'] = '{$a} è programmato il';
$string['cannotperformaction'] = 'Non è possibile effettuare l\'azione {$a} su questa registrazione';
$string['completionattendance'] = 'Lo studente deve presenziare per (minuti):';
$string['completionattendance_desc'] = 'Lo studente dovrà accedere alla stanza e rimanere nella sessione per almeno {$a} minuti.';
$string['completionattendance_event_desc'] = 'Lo studente ha acceduto alla stanza e partecipato alla sessione per almeno {$a} minuti';
$string['completionattendancegroup'] = 'Presenza obbligatoria (minuti)';
$string['completionengagement_desc'] = 'Lo studente deve partecipare attivamente durante la riunione.';
$string['completionengagementchats'] = 'Chat';
$string['completionengagementchats_desc'] = 'Lo studente deve partecipare ad {$a} chat per completare l’attività.';
$string['completionengagementchats_event_desc'] = 'Ha generato {$a} eventi chat';
$string['completionengagementemojis'] = 'Emoticon';
$string['completionengagementemojis_desc'] = 'Modifiche di emoticons: {$a}';
$string['completionengagementemojis_event_desc'] = 'Modifiche di emoticons: {$a}';
$string['completionengagementgroup'] = 'Richiede partecipazione';
$string['completionengagementpollvotes'] = 'Risposte ai sondaggi';
$string['completionengagementpollvotes_desc'] = 'Voti nei sondaggi: {$a}';
$string['completionengagementpollvotes_event_desc'] = 'Risposte ai voti nei sondaggi: {$a}';
$string['completionengagementraisehand'] = 'Richiede alzate di mano';
$string['completionengagementraisehand_desc'] = 'Alzate di mano: {$a}';
$string['completionengagementraisehand_event_desc'] = 'Ha alzato la mano {$a} volte';
$string['completionengagementtalks'] = 'Interventi a voce';
$string['completionengagementtalks_desc'] = 'Interventi a voce: {$a}';
$string['completionengagementtalks_event_desc'] = 'È intervenuto a voce {$a} volte';
$string['completionupdatestate'] = 'Aggiornamento dello stato di completamento';
$string['completionvalidatestate'] = 'Valida completamento';
$string['completionvalidatestatetriggered'] = 'La validazione del completamento è stata attivata.';
$string['completionview_event_desc'] = 'Ha acceduto alla stanza.';
$string['config_checksum_algorithm'] = 'Algoritmo di checksum del server  BigBlueButton';
$string['config_checksum_algorithm_description'] = 'SHA1 è retrocomatibili con server più vecchi. SHA256 e SHA512 sono più sicuri. SHA512 è conforme a FIPS 140-2.';
$string['config_default_messages'] = 'Messaggi di default';
$string['config_default_messages_description'] = 'Consente di impostare i messaggi di default dell\'attività';
$string['config_disablecam_default'] = 'Disabilitazione webcam abilitata di default';
$string['config_disablecam_default_description'] = 'Consente di disabilitare di default le webcam.';
$string['config_disablecam_editable'] = 'Consenti modifica disabilitazione webcam';
$string['config_disablecam_editable_description'] = 'La disabilitazione di default delle webcam potrà essere modificata quando si aggiunge o modifica l\'istanza.';
$string['config_disablemic_default'] = 'Disabilitazione microfoni abilitata di default';
$string['config_disablemic_default_description'] = 'Consente di disabilitare di default i microfoni.';
$string['config_disablemic_editable'] = 'Consenti modifica disabilitazione microfoni';
$string['config_disablemic_editable_description'] = 'La disabilitazione di default dei microfoni potrà essere modificata quando si aggiunge o modifica l\'istanza.';
$string['config_disablenote_default'] = 'Disabilitazione note condivise abilitata di default';
$string['config_disablenote_default_description'] = 'Consente di disabilitare di default le note condivise.';
$string['config_disablenote_editable'] = 'Consenti modifica disabilitazione note condivise';
$string['config_disablenote_editable_description'] = 'La disabilitazione di default delle note condivise potrà essere modificata quando si aggiunge o modifica l\'istanza.';
$string['config_disableprivatechat_default'] = 'Disabilitazione chat private abilitata di default';
$string['config_disableprivatechat_default_description'] = 'Consente di disabilitare di default le chat private.';
$string['config_disableprivatechat_editable'] = 'Consenti modifica disabilitazione chat private';
$string['config_disableprivatechat_editable_description'] = 'La disabilitazione di default delle chat private potrà essere modificata quando si aggiunge o modifica l\'istanza.';
$string['config_disablepublicchat_default'] = 'Disabilitazione chat pubblica abilitata di default';
$string['config_disablepublicchat_default_description'] = 'Consente di disabilitare di default la chat pubblica.';
$string['config_disablepublicchat_editable'] = 'Consenti modifica disabilitazione chat pubblica';
$string['config_disablepublicchat_editable_description'] = 'La disabilitazione di default della chat pubblica potrà essere modificata quando si aggiunge o modifica l\'istanza.';
$string['config_experimental_features'] = 'Configurazione funzionalità sperimentali';
$string['config_experimental_features_description'] = 'La configurazione di funzionalità sperimentali.';
$string['config_extended_capabilities'] = 'Funzionalità estese';
$string['config_extended_capabilities_description'] = 'La configurazione di funzionalità estese nel caso il server BigBlueButton le supporti.';
$string['config_general'] = 'Impostazioni generali';
$string['config_general_description'] = 'Per configurare BigBlueButton, è possibile utilizzare il proprio server e le credenziali BigBlueButton oppure ottenere le credenziali tramite il <a href="https://registration-portal.blindsidenetworks.com/" target="_blank">Portale di registrazione di Blindside Networks ( si apre in una nuova finestra)</a>.';
$string['config_guestaccess_enabled'] = 'Accesso ospiti esterni';
$string['config_guestaccess_enabled_description'] = 'Consente agli utenti privi di account di accedere alla stanza.';
$string['config_hideuserlist_default'] = 'Visibilità elenco utenti disabilitata di default';
$string['config_hideuserlist_default_description'] = 'L\'elenco degli utenti della sessione non sarà visibile.';
$string['config_hideuserlist_editable'] = 'Consenti modifica visibilità elenco utenti';
$string['config_hideuserlist_editable_description'] = 'La visibilità di default dell\'elenco utenti potrà essere modificata quando si aggiunge o modifica l\'istanza.';
$string['config_importrecordings'] = 'Importazione registrazioni';
$string['config_importrecordings_description'] = 'Impostazioni specifiche della funzionalità.';
$string['config_importrecordings_enabled'] = 'Abilita importazione registrazioni';
$string['config_importrecordings_enabled_description'] = 'Quando questa e la funzionalità di registrazione sono abilitate, è possibile importare in un\'attività le registrazioni provenienti da altri corsi.';
$string['config_importrecordings_from_deleted_enabled'] = 'Abilita importazione registrazioni da attività eliminate';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Quando questa e la funzionalità di importazione registrazioni sono abilitate, è possibile importare in un\'attività le registrazioni effettuate da attività che non sono più nel corso.';
$string['config_locksettings'] = 'Configurazione impostazioni di blocco';
$string['config_locksettings_description'] = 'Impostazioni che consentono di abilitare o disabilitare le opzioni di bloccaggio e di impostare i relativi valori di default.';
$string['config_meetingevents_enabled'] = 'Registra sessioni dal vivo';
$string['config_meetingevents_enabled_description'] = 'Se abilitato, le sessioni dal vivo saranno elaborate dopo che la sessione termina. Questa funzionalità è necessaria per il Completamento attività e funzionerà solo se il server BigBlueButton è può eseguire gli script post_events.';
$string['config_muteonstart'] = 'Microfoni spenti all\'accesso';
$string['config_muteonstart_default'] = 'Accesso con i microfoni spenti abilitato di default';
$string['config_muteonstart_default_description'] = 'L\'accesso alla sessione avverrà con i microfoni spenti.';
$string['config_muteonstart_description'] = 'Queste impostazioni abilitano o disabilitano le opzioni dell\'interfaccia e ne definiscono il default per queste opzioni.';
$string['config_muteonstart_editable'] = 'Consenti la modifica dell\'accesso con i microfoni spenti';
$string['config_muteonstart_editable_description'] = 'L\'accesso con i microfoni spenti potrà essere modificato quando si aggiunge o modifica l\'istanza.';
$string['config_participant'] = 'Partecipanti';
$string['config_participant_description'] = 'Queste impostazioni definiscono il ruolo di default dei partecipanti.';
$string['config_participant_moderator_default'] = 'Moderatore';
$string['config_participant_moderator_default_description'] = 'Questo ruolo è utilizzato di default quando si aggiunge una nuova stanza.';
$string['config_poll_interval'] = 'Intervallo di polling (in secondi) per aggiornare lo stato della stanza';
$string['config_poll_interval_description'] = 'L\'intervallo di polling deve essere di almeno 2 secondi. Se necessario, è possibile ridurre il carico sul server remoto aumentando l\'intervallo.';
$string['config_presentation_default'] = 'File della presentazione di default';
$string['config_presentation_default_description'] = 'Può essere selezionato un file da utilizzare in tutte le stanze.';
$string['config_preuploadpresentation'] = 'File della presentazione';
$string['config_preuploadpresentation_description'] = 'Queste impostazioni abilitano o disabilitano le opzioni dell\'interfaccia e ne definiscono il default. Si tratta di funzionalità utili solo se il server Moodle è raggiungibile da BigBlueButton.';
$string['config_preuploadpresentation_editable'] = 'File della presentazione nella pagina dell\'attività';
$string['config_preuploadpresentation_editable_description'] = 'Opzione nelle impostazioni dell\'attività per caricare un file di presentazione da visualizzare nella pagina dell\'attività.';
$string['config_profile_picture_enabled'] = 'Visualizza immagini del profilo';
$string['config_profile_picture_enabled_description'] = 'Visualizza le foto del profilo dei partecipanti nelle sessioni BigBlueButton';
$string['config_recording'] = 'Registrazione';
$string['config_recording_all_from_start_default'] = 'Registrazione dall\'inizio';
$string['config_recording_all_from_start_default_description'] = 'L\'impostazione \'Registrazione dall\'inizio\' deve essere abilitata di default quando si aggiunge una nuova stanza BigBlueButton?';
$string['config_recording_all_from_start_editable'] = 'Registrazione dall\'inizio modificabile';
$string['config_recording_all_from_start_editable_description'] = 'L\'impostazione \'Registrazione dall\'inizio\' deve essere modificabile nelle impostazioni dell\'attività BigBlueButton?';
$string['config_recording_default'] = 'Abilita di default la registrazione';
$string['config_recording_default_description'] = 'L\'impostazione \'Le sessioni possono essere registrate\' è abilitato di default quando aggiungi una nuova stanza BigBlueButton?';
$string['config_recording_description'] = 'Impostazioni specifiche della funzionalità.';
$string['config_recording_editable'] = 'Le sessioni possono essere registrate modificabile';
$string['config_recording_editable_description'] = 'L\'impostazione \'Le sessioni possono essere registrate\' deve essere modificabile nelle impostazioni dell\'attività BigBlueButton?';
$string['config_recording_hide_button_default'] = 'Nascondi pulsante registrazione';
$string['config_recording_hide_button_default_description'] = 'Consente di nascondere il pulsante di registrazione';
$string['config_recording_hide_button_editable'] = 'Consenti modifica della visibilità del pulsante registrazione';
$string['config_recording_hide_button_editable_description'] = 'L\'impostazione \'Nascondi pulsante registrazione\' deve essere modificabile nelle impostazioni dell\'attività BigBlueButton?';
$string['config_recording_protect_editable'] = 'La protezione delle registrazioni può essere modificata';
$string['config_recording_protect_editable_description'] = 'L\'interfaccia visualizzerà un\'impostazione per proteggere o rimuovere la protezione delle registrazioni.';
$string['config_recording_refresh_period'] = 'Intervallo di refresh delle registrazioni (in secondi)';
$string['config_recording_refresh_period_description'] = 'Ogni quanto devono essere richieste al server BigBlueButton le informazioni per una registrazione?';
$string['config_recording_safe_formats'] = 'Formati di registrazione visualizzabili da tutti';
$string['config_recording_safe_formats_description'] = 'Selezionare i formati che saranno visualizzabili da tutti.
Tutti gli altri formati saranno visualizzabili solo da docenti e dagli  utenti con i privilegi mod/bigbluebuttonbn:viewallrecordingformats e
 mod/bigbluebuttonbn:managerecordings capabilities.';
$string['config_recordingready_enabled'] = 'Invia notifica quando la registrazione sarà pronta';
$string['config_recordingready_enabled_description'] = 'Se abilitato, verrà inviata una notifica quando un registrazione è pronta. Può funzionare solo se è abilitato lo script post_publish_recording_ready_callback nel server BigBlueButton.';
$string['config_recordings'] = 'Visualizzazione registrazioni';
$string['config_recordings_asc_sort'] = 'Elenca registrazioni in ordine cronologico.';
$string['config_recordings_asc_sort_description'] = 'Le registrazioni sono ordinate per data, in ordine cronologico o cronologico inverso (prima la registrazione più recente).';
$string['config_recordings_deleted_default'] = 'Abilita di default inclusione delle registrazioni dalle attività eliminate';
$string['config_recordings_deleted_default_description'] = 'Se abilitato, la tabella delle registrazioni conterrà anche le registrazioni fatte con attività eliminate.';
$string['config_recordings_deleted_editable'] = 'Consenti la modifica dell\'inclusione di default delle registrazioni di attività eliminate';
$string['config_recordings_deleted_editable_description'] = 'Sarà possibile modificare l\'inclusione di default delle registrazioni di attività eliminate quando si aggiunge o modifica un\'istanza.';
$string['config_recordings_description'] = 'Impostazioni specifiche della funzionalità.';
$string['config_recordings_general'] = 'Visualizza impostazioni delle registrazioni';
$string['config_recordings_general_description'] = 'Queste impostazioni saranno utilizzate sono durante la visualizzazione delle registrazioni';
$string['config_recordings_imported_default'] = 'Abilita per default la visualizzazione dei soli collegamenti importati';
$string['config_recordings_imported_default_description'] = 'La tabella delle registrazioni includerà solo i collegamenti importati alle registrazioni.';
$string['config_recordings_imported_editable'] = 'La visualizzazione dei soli link importati può essere modificata';
$string['config_recordings_imported_editable_description'] = 'Consente di modificare la visualizzazione di default dei soli link importati.';
$string['config_recordings_preview_default'] = 'Anteprima abilitata di default';
$string['config_recordings_preview_default_description'] = 'La tabella includerà un\'anteprima della presentazione';
$string['config_recordings_preview_editable'] = 'Consenti modifica funzionalità anteprima';
$string['config_recordings_preview_editable_description'] = 'Il default della funzionalità anteprima potrà essere modificata quando si aggiunge o modifica un\'istanza.';
$string['config_scheduled'] = 'Sessioni programmate';
$string['config_scheduled_description'] = 'Queste impostazioni definiscono il comportamento di default per le sessioni programmate.';
$string['config_scheduled_pre_opening'] = 'Accesso contensentito prima dell\'orario di inizio';
$string['config_scheduled_pre_opening_description'] = 'Il tempo in minuti nei quali la stanza sarà già aperta prima dell\'orario di inizio programmmato.';
$string['config_server_url'] = 'URL del server BigBlueButton';
$string['config_server_url_description'] = 'L\'URL del server BigBlueButton';
$string['config_shared_secret'] = 'Shared Secret BigBlueButton';
$string['config_shared_secret_description'] = 'Il security secret del server BigBlueButton';
$string['config_showpresentation_default'] = 'Visualizza file della presentazione nella pagina dell\'attività';
$string['config_showpresentation_default_description'] = 'Consente agli studenti di visualizzare il file della presentazione prima dell\'inizio della sessione. L\'impostazione non ha effetto sugli utenti con il privilegio \'Visualizza sempre il file di presentazione nella pagina dell\'attività\'.';
$string['config_showpresentation_editable'] = 'Opzione \'Visualizza file di presentazione sulla pagina dell\'attività\'';
$string['config_showpresentation_editable_description'] = 'Opzione disponibile nelle impostazioni dell\'attività che consente ai docenti di scegliere se visualizzare il file della presentazione agli studenti.';
$string['config_uidelegation_enabled'] = 'Abilitazione delega dell\'interfaccia utente';
$string['config_uidelegation_enabled_description'] = 'Abilita o disabilita la delega dell\'interfaccia utente al server BigBlueButton.';
$string['config_userlimit'] = 'Limite utenti';
$string['config_userlimit_default'] = 'Limite utenti abilitato di default';
$string['config_userlimit_default_description'] = 'Il numero di utenti consentito di default quando si crea una nuova stanza o conferenza. Impostando a 0, non ci saranno limiti.';
$string['config_userlimit_description'] = 'Queste impostazioni abilitano o disabilitano l\'interfaccia delle opzioni e ne definiscono il default.';
$string['config_userlimit_editable'] = 'Consenti modifica del limite utenti';
$string['config_userlimit_editable_description'] = 'Il default della funzionalità di limitazione utenti potrà essere modificata quando si crea o aggiunge un\'istanza BBB.';
$string['config_voicebridge'] = 'Voice bridge';
$string['config_voicebridge_description'] = 'Queste impostazioni abilitano o disabilitano l\'interfaccia delle opzioni e ne definiscono il default.';
$string['config_voicebridge_editable'] = 'Il voice bridge della conferenza può essere modificato';
$string['config_voicebridge_editable_description'] = 'È possibile assegnare in modo permanente un numero voice bridge a una stanza. Una volta assegnato, il numero non potrà essere utilizzato per nessun\'altra stanza.';
$string['config_waitformoderator'] = 'Attesa del moderatore';
$string['config_waitformoderator_cache_ttl'] = 'Cache TTL (in secondi) dell\'attesa del moderatore';
$string['config_waitformoderator_cache_ttl_description'] = 'Per supportare alti numeri di client il pluign si avvale di una cache. Il parametro definisce la durata della cache prima di chiamare nuovamente il server BigBlueButton.';
$string['config_waitformoderator_default'] = 'Attesa del moderatore abilitata di default';
$string['config_waitformoderator_default_description'] = 'Per default sarà abilitata l\'attesa del moderatore quando si creano attività BBB.';
$string['config_waitformoderator_description'] = 'Impostazioni specifiche della funzionalità.';
$string['config_waitformoderator_editable'] = 'Consenti modifica dell\'attesa del moderatore';
$string['config_waitformoderator_editable_description'] = 'Il default della funzionalità attesa del moderatore potrà essere modificata quando si crea o aggiunge un\'istanza BBB.';
$string['config_waitformoderator_ping_interval'] = 'Ping attesa del moderatore (in secondi)';
$string['config_waitformoderator_ping_interval_description'] = 'Quando è abilitata l\'attesa del moderatore, il client eseguirà un ping dello stato della sessione trascorso il numero di secondi impostato.';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton utilizza una variabile globale deprecata del file config.php. Convertire il file perché non sarà supportata nelle versioni future.';
$string['config_warning_curl_not_installed'] = 'La funzionalità richiede l\'installazione e configurazione dell\'estensione php cURL. Sarà possibile accedere all\'impostazione solo in presenza dell\'estensione.';
$string['config_welcome_default'] = 'Messaggio di benvenuto di default';
$string['config_welcome_default_description'] = 'Il messaggio di benvenuto viene visualizzato quando i partecipanti entrano nella stanza. Se il campo viene lasciato vuoto, viene utilizzata la stringa della lingua \'mod_form_field_welcome_default\'.';
$string['config_welcome_editable'] = 'Il messaggio di benvenuto di default è modificabile dai docenti';
$string['config_welcome_editable_description'] = 'Il messaggio di benvenuto sarà modificabile quando un\'istanza viene aggiunta o modificata';
$string['credentials_warning'] = 'L\'utilizzo delle credenziali del server di default scadrà a breve (vedere la nota sopra per ottenere nuove credenziali).';
$string['end_session_confirm'] = 'Sei sicuro di terminare la sessione?';
$string['end_session_confirm_title'] = 'Sei sicuro di chiudere la sessione?';
$string['end_session_notification'] = 'La sessione è stata terminata.';
$string['ends_at'] = 'Fine';
$string['event_activity_created'] = 'Creazione attività';
$string['event_activity_deleted'] = 'Eliminazione attività';
$string['event_activity_updated'] = 'Aggiornamento attività';
$string['event_live_session'] = 'Evento di sessione dal vivo';
$string['event_meeting_created'] = 'Creazione riunione';
$string['event_meeting_ended'] = 'Termine forzato della riunione';
$string['event_meeting_joined'] = 'Accesso alla riunione';
$string['event_meeting_left'] = 'Abbandono della riunione';
$string['event_recording_deleted'] = 'Eliminazione registrazione';
$string['event_recording_edited'] = 'Modifica registrazione';
$string['event_recording_imported'] = 'Importazione registrazione';
$string['event_recording_protected'] = 'Protezione registrazione';
$string['event_recording_published'] = 'Pubblicazione registrazione';
$string['event_recording_unprotected'] = 'Rimozione protezione registrazione';
$string['event_recording_unpublished'] = 'Rimozione pubblicazione registrazione';
$string['event_recording_viewed'] = 'Visualizzazione registrazione';
$string['event_unknown'] = 'Evento sconosciuto';
$string['general_error_cannot_create_meeting'] = 'Non è possibile creare sessioni.';
$string['general_error_cannot_get_recordings'] = 'Non è possibile recuperare le registrazioni.';
$string['general_error_no_answer'] = 'Risposta vuota. Verificare l\'URL del server BigBlueButton e controllare se il server BigBlueButton è in esecuzione.';
$string['general_error_not_allowed_to_create_instances'] = 'L\'utente non è autorizzato a creare nessun tipo di istanza.';
$string['general_error_not_found'] = 'Non è stato possibile trovate l\'attività BigBlueButton con ID {$a}.';
$string['general_error_unable_connect'] = 'Non è possibile stabilire il collegamento. Verificare l\'URL del server BigBlueButton e controllare se il server BigBlueButton è in esecuzione.
Dettagli: {$a}';
$string['guest_invitation_full_message'] = '<p>Sei stato inviatato alla sessione BigBlueButton <strong>{$a->name}</strong> del corso {$a->course_fullname}.</p>
<p>Link: {$a->guestjoinurl}<br/>
<p>Password: {$a->guestpassword}</p>
<p>Se hai bisogno di aiuto, per favore contatta {$a->sender}.</p>';
$string['guest_invitation_small_message'] = 'Sei stato inviatato alla sessione BigBlueButton {$a->name} del corso {$a->course_fullname}.

Link: {$a->guestjoinurl}
Password: {$a->guestpassword}

Se hai bisogno di aiuto, per favore contatta {$a->sender}.';
$string['guest_invitation_subject'] = 'Invito alla sessione {$a->name} del corso {$a->course_fullname}';
$string['guestaccess_activitynotfound'] = 'L\'attività non è stata trovata.';
$string['guestaccess_add'] = 'Aggiungi ospite';
$string['guestaccess_add_no_id'] = 'Non è stati fornito nessun ID istanza di BigBlueButton.';
$string['guestaccess_copy_link'] = 'Copia collegamento';
$string['guestaccess_copy_password'] = 'Copia password';
$string['guestaccess_emails'] = 'Email degli ospiti';
$string['guestaccess_emails_help'] = 'Un elenco di indirizzi email separate da virgole.';
$string['guestaccess_emails_invalidemail'] = 'Email non valida: {$a}';
$string['guestaccess_feature_disabled'] = 'Accesso ospiti disabilitato';
$string['guestaccess_invite_failure'] = 'Si è verificato l\'errore {$a->errors} durante l\'invio di invita a {$a->emails}.';
$string['guestaccess_invite_success'] = 'Verrà inviato un invito a {$a->emails}.';
$string['guestaccess_join_meeting'] = 'Entra nel meeting';
$string['guestaccess_meeting_invalid_password'] = 'Password errata.';
$string['guestaccess_meeting_link'] = 'Collegamento al meeting';
$string['guestaccess_meeting_not_started'] = 'Il meeting non è ancora iniziato. Per favore ritorna più tardi.';
$string['guestaccess_meeting_password'] = 'Password del meeting';
$string['guestaccess_password'] = 'Password';
$string['guestaccess_title'] = 'Aggiungi ospiti al meeting';
$string['guestaccess_username'] = 'Username dell\'ospite';
$string['index_confirm_end'] = 'Vuoi terminare la sessione?';
$string['index_disabled'] = 'disabilitato';
$string['index_enabled'] = 'abilitato';
$string['index_ending'] = 'Chiusura della sessione in corso ... attendere per favore.';
$string['index_error_bbtn'] = 'L\'ID BigBlueButton {$a} non è corretto';
$string['index_error_checksum'] = 'Si è verificato un errore di checksum. Accertarsi che sia stato inserito il secret corretto.';
$string['index_error_forciblyended'] = 'Non è possibile partecipare alla sessione perché è stata terminata manualmente.';
$string['index_error_noinstances'] = 'Non ci sono istanze BigBlueButton';
$string['index_error_unable_display'] = 'Non è possibile mostrare le sessioni. Verificare l\'URL del server BigBlueButton e controllare se il server BigBlueButton è in esecuzione.';
$string['index_heading'] = 'Stanze BigBlueButton';
$string['index_heading_actions'] = 'Azioni';
$string['index_heading_group'] = 'Gruppo';
$string['index_heading_moderator'] = 'Moderatori';
$string['index_heading_name'] = 'Stanza';
$string['index_heading_recording'] = 'Registrazione';
$string['index_heading_users'] = 'Utenti';
$string['index_heading_viewer'] = 'Visualizzatori';
$string['indicator:cognitivedepth'] = 'BigBlueButton cognitivo';
$string['indicator:cognitivedepth_help'] = 'L\'indicatore è basato sulla profondità cognitiva toccata dallo studente svolgendo attività BigBlueButton .';
$string['indicator:socialbreadth'] = 'BigBlueButton sociale';
$string['indicator:socialbreadth_help'] = 'L\'indicatore è basato sulla dimensione sociale raggiunta dallo studente svolgendo attività BigBlueButton .';
$string['instance_type_default'] = 'Stanza con registrazione';
$string['instance_type_recording_only'] = 'Solo registrazioni';
$string['instance_type_room_only'] = 'Solo stanza';
$string['instanceprofilewithoutrecordings'] = 'La tipologia di questa istanza non permette di mostrare le registrazioni';
$string['managebbbextplugins'] = 'Gestione plugin di estensione BigBlueButton';
$string['messageprovider:instance_updated'] = 'Sessione BigBlueButton aggiornata';
$string['messageprovider:recording_ready'] = 'Registrazione BigBlueButton disponibile';
$string['minute'] = 'minuto';
$string['minutes'] = 'minuti';
$string['mod_form_block_general'] = 'Generale';
$string['mod_form_block_guestaccess'] = 'Accesso ospiti';
$string['mod_form_block_participants'] = 'Ruolo assegnato durante la sessione dal vivo';
$string['mod_form_block_presentation'] = 'Contenuto presentazione';
$string['mod_form_block_presentation_default'] = 'Contenuto della presentazione di default';
$string['mod_form_block_record'] = 'Impostazioni registrazione';
$string['mod_form_block_recordings'] = 'Visualizzazione registrazioni';
$string['mod_form_block_room'] = 'Impostazioni stanza';
$string['mod_form_block_schedule'] = 'Programmazione sessione';
$string['mod_form_field_closingtime'] = 'Chiusura';
$string['mod_form_field_conference_name'] = 'Nome della sessione';
$string['mod_form_field_disablecam'] = 'Disabilita webcam';
$string['mod_form_field_disablemic'] = 'Disabilita microfoni';
$string['mod_form_field_disablenote'] = 'Disabilita note condivise';
$string['mod_form_field_disableprivatechat'] = 'Disabilita chat privata';
$string['mod_form_field_disablepublicchat'] = 'Disabilita chat pubblica';
$string['mod_form_field_duration'] = 'Durata';
$string['mod_form_field_duration_help'] = 'Impostare la durata di una riunione definirà il tempo massimo in cui una riunione rimane attiva prima di concludere la registrazione';
$string['mod_form_field_guestallowed'] = 'Consenti accesso ospiti';
$string['mod_form_field_hideuserlist'] = 'Nascondi elenco utenti';
$string['mod_form_field_instanceprofiles'] = 'Tipo di istanza';
$string['mod_form_field_instanceprofiles_help'] = 'Se la sessione deve essere registrata, seleziona \'Stanza con registrazione\', altrimenti \'Solo stanza\'. Dopo che una sessione è registrata, se non ci devono essere altre sessioni, seleziona \'Solo registrazioni\'.';
$string['mod_form_field_intro'] = 'Descrizione';
$string['mod_form_field_intro_help'] = 'Una breve descrizione della stanza virtuale.';
$string['mod_form_field_mustapproveuser'] = 'Gli ospiti possono partecipare solo se ammessi da un moderatore';
$string['mod_form_field_muteonstart'] = 'Muto all\'accesso';
$string['mod_form_field_name'] = 'Nome della stanza';
$string['mod_form_field_nosettings'] = 'Non ci sono impostazioni modificabili';
$string['mod_form_field_openingtime'] = 'Apertura';
$string['mod_form_field_participant_add'] = 'Aggiungi assegnatario';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderatore';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Visualizzatore';
$string['mod_form_field_participant_list'] = 'Elenco assegnazioni';
$string['mod_form_field_participant_list_action_add'] = 'Aggiungi';
$string['mod_form_field_participant_list_action_remove'] = 'Elimina';
$string['mod_form_field_participant_list_text_as'] = 'Accedi la sessione come';
$string['mod_form_field_participant_list_type_all'] = 'Tutti gli utenti iscritti';
$string['mod_form_field_participant_list_type_owner'] = 'Proprietario';
$string['mod_form_field_participant_list_type_role'] = 'Ruolo';
$string['mod_form_field_participant_list_type_user'] = 'Utente';
$string['mod_form_field_record'] = 'La sessione può essere registrata.';
$string['mod_form_field_recordallfromstart'] = 'Registra dall\'inizio';
$string['mod_form_field_recordhidebutton'] = 'Nascondi pulsante di registrazione';
$string['mod_form_field_recordings_deleted'] = 'Includi registrazioni di attività eliminate';
$string['mod_form_field_recordings_html'] = 'Visualizza tabella in HTML';
$string['mod_form_field_recordings_imported'] = 'Visualizza solo link importati';
$string['mod_form_field_recordings_preview'] = 'Visualizza anteprima della registrazione';
$string['mod_form_field_room_name'] = 'Nome della stanza';
$string['mod_form_field_showpresentation'] = 'Visualizza il file della presentazione sulla pagina dell\'attività';
$string['mod_form_field_userlimit'] = 'Limite utenti';
$string['mod_form_field_userlimit_help'] = 'Il numero massimo di utenti presenti in una sessione. Impostando il limite a 0 non ci saranno limiti.';
$string['mod_form_field_voicebridge'] = 'Voice bridge [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Errore nel formato. Devi inserire un numero tra 1 a 9999.';
$string['mod_form_field_voicebridge_help'] = 'Un numero tra 1 e 9999 che i partecipanti dovranno inserire per collegarsi alla sessione con il telefono. Se il valore è 0, verrà ignorato il numero del voice bridge statico e verrà generato un numero casuale da BigBlueButton. Il numero 7 verrà anteposto alle 4 cifre inserite.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Valore non univoco. Questo numero è utilizzato da un\'altra stanza.';
$string['mod_form_field_wait'] = 'Attesa del moderatore';
$string['mod_form_field_wait_help'] = 'I partecipanti dovranno attendere l\'arrivo di un moderatore prima di entrare nella stanza?';
$string['mod_form_field_welcome'] = 'Messaggio di benvenuto';
$string['mod_form_field_welcome_default'] = 'Benvenuti in %%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'Il messaggio di benvenuto viene visualizzato quando i partecipanti accedono alla stanza. Se il campo è lasciato vuoto verrà mostrato il messaggio di default definito nella configurazione del sito.';
$string['mod_form_locksettings'] = 'Impostazioni di blocco';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton è un sistema di web conference open source progettato per l\'apprendimento online, che comprende la condivisione in tempo reale di audio, video, chat, presentazioni, condivisione dello schermo, una lavagna multi utente, sotto stanze, sondaggi e emoticons.

Utilizzando BigBlueButton potrai creare una stanza per sessioni come lezioni online dal vivo, orario d\'ufficio virtuale o collaborazione di gruppo con studenti a distanza. La sessione può essere registrata per la riproduzione successiva.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'Attività BigBlueButton';
$string['nosuchinstance'] = 'Non è presente un\'istanza {$a->entity} con ID {$a->id}';
$string['notification_instance_created_intro'] = 'La stanza BigBlueButton  <a href="{$a->link}">{$a->name}</a> è stata creata.';
$string['notification_instance_created_small'] = 'È stata creata una nuova attività BigBlueButton: {$a->name}';
$string['notification_instance_created_subject'] = 'È stata creata una nuova stanza BigBlueButton';
$string['notification_instance_description'] = 'Descrizione';
$string['notification_instance_end_date'] = 'Data di fine';
$string['notification_instance_name'] = 'Titolo';
$string['notification_instance_start_date'] = 'Data di inizio';
$string['notification_instance_updated_intro'] = 'L’attività BigBlueButton <a href="{$a->link}">{$a->name}</a> è stata aggiornata.';
$string['notification_instance_updated_small'] = 'L\'attività BigBlueButton {$a->name} è stata aggiornata';
$string['notification_instance_updated_subject'] = 'La tua attività BigBlueButton è stata aggiornata';
$string['notification_recording_ready_html'] = 'È disponibile la registrazione della seguente stanza BigBlueButton <a href="{$a->link}">{$a->name}</a>.';
$string['notification_recording_ready_plain'] = 'È disponibile la registrazione la stanza BigBlueButton {$a->name}. Per visualizzare la registrazione: {$a->link}';
$string['notification_recording_ready_small'] = 'È disponibile una registrazione della stanza BigBlueButton {$a->name}.';
$string['notification_recording_ready_subject'] = 'Registrazione disponibile';
$string['pluginadministration'] = 'Gestione BigBlueButton';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Dati utente scambiati con il server BigBlueButton per creare e accedere alle sessioni.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Nome e cognome dell\'utente che accede al server BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'User ID dell\'utente che accede al server BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Configurazione dell\'attività BigBlueButton';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Elenco di regole che definiscono i ruoli degli utenti che partecipano alla riunione. Può essere memorizzato lo user ID per consentire granularità nell\'assegnazione di tali ruoli.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Eventi generati dall\'uso del plugin';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Tipo di evento generato dall\'utente';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'ID della sessione alla quale ha fatto accesso l\'utente.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Informazioni aggiuntive relative alla sessione o alla registrazione.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Orario di creazione del log.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'User ID dell\'utente che ha generato l\'evento.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Metadati delle registrazioni';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'User ID dell\'utente che ha modificato più recentemente una registrazione.';
$string['progress_createbigbluebuttonbn'] = 'Creazione dell\'attività BigBlueButton ({$a})';
$string['recordingnotfound'] = 'La registrazione non è stata trovata.';
$string['recordings_from_deleted_activities'] = 'Registrazioni di attività eliminate';
$string['recordingurlnotfound'] = 'L\'URL della registrazione non è valido.';
$string['removedevents'] = 'Eventi eliminati';
$string['removedlogs'] = 'Log personalizzati eliminati';
$string['removedrecordings'] = 'Registrazioni eliminate';
$string['removedtags'] = 'Tag eliminati';
$string['report_join_info'] = '{$a} incontro(i)';
$string['report_play_recording_info'] = '{$a} registrazioni riprodotte';
$string['report_room_view'] = 'Visualizzazione';
$string['resetevents'] = 'Elimina eventi';
$string['resetlogs'] = 'Elimina log personalizzati';
$string['resetlogs_help'] = 'L\'eliminazione dei log causerà la perdita dei riferimenti alle registrazioni.';
$string['resetrecordings'] = 'Elimina registrazioni';
$string['resetrecordings_help'] = 'L\'eliminazione renderà inaccessibili le registrazioni. L\'azione non potrà essere annullata!';
$string['resettags'] = 'Elimina tag';
$string['search:activity'] = 'BigBlueButton - Informazioni sull’attività';
$string['search:tags'] = 'BigBlueButton - Informazioni tag';
$string['sendnotification'] = 'Invia notifica';
$string['settings'] = 'Impostazioni BigBlueButton';
$string['settings_credential_warning'] = 'Le credenziali del server BigBlueButton scadranno a breve. Consulta le <a href="{$a->settingslink}" target="_blank">impostazioni generali di BigBlueButton (si apre in una nuova finestra)</a>.';
$string['settings_credential_warning_no_capability'] = 'Le credenziali del server BigBlueButton scadranno a breve. Contattare l\'amministratore del sito.';
$string['started_at'] = 'Iniziata';
$string['starts_at'] = 'Inizia';
$string['subplugintype_bbbext'] = 'Estensione dell\'attività BigBlueButton';
$string['subplugintype_bbbext_plural'] = 'Estensioni delle attività BigBlueButton';
$string['taskname:check_dismissed_recordings'] = 'Controllo registrazioni che non sono state ancora trovate';
$string['taskname:check_pending_recordings'] = 'Recupero registrazioni in attesa';
$string['userlimitreached'] = 'È stato raggiunto il numero massimo di partecipanti alla sessione.';
$string['view_conference_action_end'] = 'Fine sessione';
$string['view_conference_action_join'] = 'Accedi alla sessione';
$string['view_error_action_not_completed'] = 'Non è stato possibile completare l\'azione';
$string['view_error_bigbluebutton'] = 'BigBlueButton ha riportato degli errori. {$a}';
$string['view_error_create'] = 'Il server BigBlueButton ha riportato dei messaggi di errore. Non è stato possibile creare la stanza.';
$string['view_error_current_state_not_found'] = 'Stato corrente non disponibile. La registrazione potrebbe essere stat cancellata o il server BigBlueButton non è compatibile con l\'azione richiesta.';
$string['view_error_import_no_courses'] = 'Non ci sono corsi dove cercare registrazioni.';
$string['view_error_import_no_recordings'] = 'Questo corso non ha registrazioni da importare.';
$string['view_error_invalid_session'] = 'La sessione è conclusa. Tornare alla pagina principale dell\'attività.';
$string['view_error_max_concurrent'] = 'È stato raggiunto il limite massimo di sessioni in contemporanea.';
$string['view_error_meeting_not_running'] = 'Qualcosa non ha funzionato; la sessione non è stata avviata.';
$string['view_error_no_group'] = 'Non ci sono gruppi. È necessario impostare dei gruppi prima di accedere la sessione.';
$string['view_error_no_group_student'] = 'Non fai parte di nessun gruppo. Per favore contattare il docente o l\'amministratore.';
$string['view_error_no_group_teacher'] = 'Non ci sono gruppi. È necessario impostare dei gruppi.';
$string['view_error_unable_join'] = 'Non è stato possibile accedere alla stanza. Verificare l\'URL del server BigBlueButton e controllare se il server BigBlueButton è in esecuzione.';
$string['view_error_unable_join_student'] = 'Non è stato possibile collegarsi al server BigBlueButton.';
$string['view_error_unable_join_teacher'] = 'Non è possibile connettersi al server BigBlueButton server. Per favore contattare un amministratore.';
$string['view_error_url_missing_parameters'] = 'L\'URL ha parametri mancanti';
$string['view_error_userlimit_reached'] = 'È stato raggiunto il limite massimo di utenti che possono partecipare alla sessione.';
$string['view_groups_nogroups_warning'] = 'La stanza è stata configurata per usare i gruppi ma il corso non ha gruppi.';
$string['view_groups_notenrolled_warning'] = 'La stanza è stata configurata per usare i gruppi ma non fai parte di nessun gruppo.';
$string['view_groups_selection'] = 'Seleziona il gruppo al quale vuoi unirti e conferma la scelta';
$string['view_groups_selection_join'] = 'Accedi';
$string['view_groups_selection_warning'] = 'È disponibile una stanza per ogni gruppo e puoi accedere a più una stanza. Accertarsi di sezionare la stanza giusta.';
$string['view_login_moderator'] = 'Accesso come moderatore ...';
$string['view_login_viewer'] = 'Accesso come partecipante ...';
$string['view_message_and'] = 'e';
$string['view_message_conference_has_ended'] = 'La sessione è terminata.';
$string['view_message_conference_in_progress'] = 'La sessione è in svolgimento.';
$string['view_message_conference_not_started'] = 'La sessione non è iniziata.';
$string['view_message_conference_room_ready'] = 'La stanza è pronta, puoi accedere alla sessione.';
$string['view_message_conference_user_limit_reached'] = 'È stato raggiunto il limite del numero di utenti consentiti in una sessione.';
$string['view_message_conference_wait_for_moderator'] = 'In attesa di un moderatore.';
$string['view_message_cron_disabled'] = 'L\'elenco delle registrazioni potrebbe non essere aggiornato. Contatta l\'amministratore del sito con le seguenti informazioni: {$a}';
$string['view_message_finished'] = 'L\'attività è conclusa.';
$string['view_message_has_joined'] = 'ha acceduto';
$string['view_message_have_joined'] = 'hanno acceduto';
$string['view_message_hour'] = 'ora';
$string['view_message_hours'] = 'ore';
$string['view_message_importrecordings_disabled'] = 'L\'importazione di registrazioni è disabilitata sul server.';
$string['view_message_minute'] = 'minuto';
$string['view_message_minutes'] = 'minuti';
$string['view_message_moderator'] = 'Moderatore';
$string['view_message_moderators'] = 'Moderatori';
$string['view_message_norecordings'] = 'Non sono presenti registrazioni disponibili.';
$string['view_message_notavailableyet'] = 'La sessione non è ancora disponibile.';
$string['view_message_recordings_disabled'] = 'Le registrazioni sono disabilitate. Non è possibile utilizzare istanze BigBlueButton \'Solo registrazioni\'.';
$string['view_message_room_closed'] = 'La stanza è chiusa.';
$string['view_message_room_open'] = 'La stanza è aperta.';
$string['view_message_room_ready'] = 'La stanza è pronta.';
$string['view_message_session_for'] = 'la sessione per';
$string['view_message_session_has_user'] = 'È presente';
$string['view_message_session_has_users'] = 'Sono presenti';
$string['view_message_session_no_users'] = 'Non sono presenti utenti';
$string['view_message_session_running_for'] = 'La sessione dura da';
$string['view_message_session_started_at'] = 'La sessione è iniziata alle';
$string['view_message_tab_close'] = 'Questa scheda/finestra deve essere chiusa manualmente';
$string['view_message_times'] = 'volte';
$string['view_message_user'] = 'Utente';
$string['view_message_users'] = 'Utenti';
$string['view_message_viewer'] = 'Partecipante';
$string['view_message_viewers'] = 'Partecipanti';
$string['view_mobile_message_groups_not_supported'] = 'L\'istanza è abilitata per lavorare con i gruppi ma l\'app mobile non supporta ancora questa funzionalità. Si prega di usare la versione per browser.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Sono trascorsi più di 45 secondi. Per favore ricarica la pagina per accedere alla sessione.';
$string['view_noguests'] = 'La stanza BigBlueButton non è aperta dagli ospiti.';
$string['view_nojoin'] = 'Non hai un ruolo che ti consente di accedere alla sessione.';
$string['view_recording'] = 'registrazione';
$string['view_recording_actionbar'] = 'Barra degli strumenti';
$string['view_recording_activity'] = 'Attività';
$string['view_recording_button_import'] = 'Importa link della registrazione';
$string['view_recording_button_return'] = 'Indietro';
$string['view_recording_course'] = 'Corso';
$string['view_recording_date'] = 'Data';
$string['view_recording_delete_confirmation'] = 'Sei sicuro di voler eliminare {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Questa registrazione ha {$a} link associati che sono stati importati in altri corsi o attività. Se la registrazione viene eliminata, saranno eliminati anche i link importati.';
$string['view_recording_delete_confirmation_warning_s'] = 'Questa registrazione ha {$a} link associato che è stato importato in un altro corso o attività. Se la registrazione viene eliminata, sarà eliminato anche il link importato.';
$string['view_recording_description'] = 'Descrizione';
$string['view_recording_description_edithint'] = 'Può essere aggiunta una descrizione per facilitare l\'individuazione della registrazione.';
$string['view_recording_description_editlabel'] = 'Modifica descrizione';
$string['view_recording_duration'] = 'Durata';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'Ll\'URL di questo formato di registrazione non è raggiungibile.';
$string['view_recording_format_notes'] = 'Note';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Presentazione';
$string['view_recording_format_screenshare'] = 'Condivisione schermo';
$string['view_recording_format_statistics'] = 'Statistiche';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Sei sicuro di voler importare queta registrazione?';
$string['view_recording_length'] = 'Lunghezza';
$string['view_recording_link'] = 'link importato';
$string['view_recording_link_warning'] = 'Questo link collega ad una registrazione è creata in un corso o attività differente.';
$string['view_recording_list_action_delete'] = 'Eliminazione in corso';
$string['view_recording_list_action_edit'] = 'Aggiornamento in corso';
$string['view_recording_list_action_play'] = 'Riproduci';
$string['view_recording_list_action_process'] = 'Elaborazione in corso';
$string['view_recording_list_action_protect'] = 'Protezione in corso';
$string['view_recording_list_action_publish'] = 'Pubblicazione in corso';
$string['view_recording_list_action_unprotect'] = 'Rimozione protezione in corso';
$string['view_recording_list_action_unpublish'] = 'Rimozione pubblicazione in corso';
$string['view_recording_list_action_update'] = 'Aggiornamento in corso';
$string['view_recording_list_actionbar'] = 'Barra degli strumenti';
$string['view_recording_list_actionbar_delete'] = 'Elimina';
$string['view_recording_list_actionbar_edit'] = 'Modifica';
$string['view_recording_list_actionbar_hide'] = 'Nascondi';
$string['view_recording_list_actionbar_import'] = 'Importa';
$string['view_recording_list_actionbar_protect'] = 'Rendi privato';
$string['view_recording_list_actionbar_publish'] = 'Pubblica';
$string['view_recording_list_actionbar_show'] = 'Visualizza';
$string['view_recording_list_actionbar_unprotect'] = 'Rendi pubblico';
$string['view_recording_list_actionbar_unpublish'] = 'Rimuovi pubblicazione';
$string['view_recording_list_activity'] = 'Attività';
$string['view_recording_list_course'] = 'Corso';
$string['view_recording_list_date'] = 'Data';
$string['view_recording_list_description'] = 'Descrizione';
$string['view_recording_list_duration'] = 'Durata';
$string['view_recording_list_recording'] = 'Registrazione';
$string['view_recording_meeting'] = 'Riunione';
$string['view_recording_modal_button'] = 'Applica';
$string['view_recording_modal_title'] = 'Imposta i valori della registrazione';
$string['view_recording_name'] = 'Nome';
$string['view_recording_name_edithint'] = 'Può essere aggiunto un nome per facilitare l\'individuazione della registrazione.';
$string['view_recording_name_editlabel'] = 'Modifica nome';
$string['view_recording_playback'] = 'Riproduzione';
$string['view_recording_preview'] = 'Anteprima';
$string['view_recording_preview_help'] = 'Passare col mouse su un\'immagine per visualizzarla a grandezza reale';
$string['view_recording_protect_confirmation'] = 'Sei sicuro di proteggere {$a}?';
$string['view_recording_protect_confirmation_warning_p'] = 'Questa registrazione ha {$a} link associati che sono stati importati in altri corsi o attività. Se la registrazione viene protetta, saranno coinvolti anche i link importati.';
$string['view_recording_protect_confirmation_warning_s'] = 'Questa registrazione ha {$a} link associato che è stato importato in un altro corso o attività. Se la registrazione viene protetta, sarà coinvolto anche il link importato.';
$string['view_recording_publish_confirmation'] = 'Se sicuro di pubblicare {$a}?';
$string['view_recording_publish_confirmation_warning_p'] = 'Questa registrazione ha {$a} link associati che sono stati importati in altri corsi o attività. Se la registrazione viene pubblicata, saranno pubblicati anche i link importati.';
$string['view_recording_publish_confirmation_warning_s'] = 'Questa registrazione ha {$a} link associato che è stato pubblicato in un altro corso o attività. Se la registrazione viene pubblicata, sarà pubblicato anche il link importato.';
$string['view_recording_publish_link_deleted'] = 'Il link non può essere pubblicato nuovamente poiché la registrazione associata non esiste nel server BigBlueButton. Il link va eliminato.';
$string['view_recording_publish_link_not_published'] = 'Il link non può essere pubblicato nuovamente poiché è stata rimossa la pubblicazione della registrazione associata.';
$string['view_recording_recording'] = 'Registrazione';
$string['view_recording_select_course'] = 'Selezionare un corso dal menu a discesa';
$string['view_recording_tags'] = 'Tag';
$string['view_recording_unprotect_confirmation'] = 'Sei sicuro di rimuovere la protezione di {$a}?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Questa registrazione ha {$a} link associati che sono stati importati in altri corsi o attività. Se viene rimossa la protezione della registrazione, saranno coinvolti anche i link importati.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Questa registrazione ha {$a} link associato che è stato importato in un altro corso o attività. Se viene rimossa la protezione della registrazione, sarà coinvolto anche il link importato.';
$string['view_recording_unprotect_link_deleted'] = 'Non è possibile rimuovere la protezione del link poiché la registrazione associata non esiste nel server BigBlueButton. Il link va eliminato.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Non è possibile rimuovere la protezione del link poiché la registrazione associata è protetta.';
$string['view_recording_unpublish_confirmation'] = 'Sei sicuro di rimuovere la pubblicazione di {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Questa registrazione ha {$a} link associati che sono stati importati in altri corso o attività. Se viene rimossa la pubblicazione della registrazione, saranno anche rimosse le pubblicazioni del link importato.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Questa registrazione ha {$a} link associato che è stato importato in un altro corso o attività. Se viene rimossa la pubblicazione della registrazione, sarà rimossa anche la pubblicazione del link importato.';
$string['view_recording_yui_first'] = 'Prima';
$string['view_recording_yui_go'] = 'Vai';
$string['view_recording_yui_last'] = 'Ultima';
$string['view_recording_yui_next'] = 'Successiva';
$string['view_recording_yui_page'] = 'Pagina';
$string['view_recording_yui_prev'] = 'Precedente';
$string['view_recording_yui_rows'] = 'Righe';
$string['view_recording_yui_show_all'] = 'Visualizza tutto';
$string['view_room'] = 'Visualizza stanza';
$string['view_section_title_presentation'] = 'File della presentazione';
$string['view_section_title_recordings'] = 'Registrazioni';
$string['waitformoderator'] = 'In attesa di un moderatore.';
