<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'it', version '5.0'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'Allegati attività compito';
$string['activitydate:submissionsdue'] = 'Data limite:';
$string['activitydate:submissionsopen'] = 'Apre:';
$string['activitydate:submissionsopened'] = 'Aperto:';
$string['activityeditor'] = 'Istruzioni attività';
$string['activityeditor_help'] = 'Le azioni che lo studente dovrà completare svolgendo il compito. Queste istruzioni verranno visualizzate solamente nella pagina della consegna dove lo studente modificherà e invierà il proprio compito.';
$string['activityoverview'] = 'Ci sono compiti che richiedono la tua attenzione';
$string['addattempt'] = 'Consenti tentativo ulteriore';
$string['addnewattempt'] = 'Aggiungi tentativo';
$string['addnewattempt_help'] = 'Verrà creata una consegna vuota dove potrai svolgere il tuo lavoro,';
$string['addnewattemptfromprevious'] = 'Aggiungi tentativo sulla base della consegna precedente';
$string['addnewattemptfromprevious_help'] = 'Il contenuto della tua consegna precedente verrà copiato in una nuova consegna dove potrai svolgere il tuo lavoro,';
$string['addnewgroupoverride'] = 'Aggiungi personalizzazione di gruppo';
$string['addnewuseroverride'] = 'Aggiungi personalizzazione individuale';
$string['addsubmission'] = 'Aggiungi consegna';
$string['addsubmission_help'] = 'Non hai ancora consegnato.';
$string['allocatedmarker'] = 'Valutatore assegnato';
$string['allocatedmarker_help'] = 'Valutatore assegnato a questa consegna.';
$string['allowsubmissions'] = 'Consenti all\'utente di continuare a consegnare il compito';
$string['allowsubmissionsfromdate'] = 'Inizio consegne';
$string['allowsubmissionsfromdate_help'] = 'Impedisce agli studenti di consegnare il compito prima della data di inizio consegne.';
$string['allowsubmissionsshort'] = 'Consenti di modificare le consegne';
$string['alwaysshowdescription'] = 'Visualizza la descrizione';
$string['alwaysshowdescription_help'] = 'Se disabilitato, la descrizione del compito sarà visibile solo dopo la data di inizio delle consegne.';
$string['applytoteam'] = 'Usa lo stesso feedback e la stessa valutazione per tutto il gruppo';
$string['assign:addinstance'] = 'Aggiungere compiti';
$string['assign:editothersubmission'] = 'Modifica un\'altra consegna';
$string['assign:exportownsubmission'] = 'Esportare la propria consegna';
$string['assign:grade'] = 'Valutare compito';
$string['assign:grantextension'] = 'Concedere proroghe';
$string['assign:manageallocations'] = 'Gestire valutatori assegnati alla consegna';
$string['assign:managegrades'] = 'Rivedere e rilasciare valutazioni';
$string['assign:manageoverrides'] = 'Gestire personalizzazioni del compito';
$string['assign:receivegradernotifications'] = 'Ricevere notifiche dal valutatore';
$string['assign:releasegrades'] = 'Rilasciare valutazioni';
$string['assign:revealidentities'] = 'Rivelare l\'identità degli studenti';
$string['assign:reviewgrades'] = 'Rivedere valutazioni';
$string['assign:showhiddengrader'] = 'Visualizzare identità di un valutatore nascosto';
$string['assign:submit'] = 'Consegnare compito';
$string['assign:view'] = 'Visualizzare compito';
$string['assign:viewblinddetails'] = 'Visualizzare l\'identità dello studente quando le consegne anonime sono abilitate';
$string['assign:viewgrades'] = 'Visualizza valutazioni';
$string['assign:viewownsubmissionsummary'] = 'Visualizzare il riepilogo della propria consegna';
$string['assignfeedback'] = 'Plugin commento';
$string['assignfeedbackpluginname'] = 'Plugin commento';
$string['assignmentduedigesthtml'] = '<p>Gentile {$a->firstname},</p>
<p>I seguenti compiti devono essere consegnati entro <strong>{$a->duedate}</strong>.</p>
{$a->digest}';
$string['assignmentduedigestitem'] = '<strong>{$a->assignmentname}</strong> nel corso {$a->coursename}<br/>
<strong>Scadenza: {$a->duetime}</strong><br/>
<a href="{$a->url}" aria-label="Vai a {$a->assignmentname}">Vai all\'attività</a>';
$string['assignmentduedigestsms'] = 'Uno o più compiti devono essere consegnati entro 7 giorni. Accedere per visualizzare i compiti in arrivo.';
$string['assignmentduedigestsubject'] = 'Hai dei compiti in scadenza tra 7 giorni';
$string['assignmentduesoonhtml'] = '<p>Gentile {$a->firstname},</p>
<p>Il compito <strong>{$a->assignmentname}</strong> nel corso {$a->coursename} scadrà a breve.</p>
<p><strong>Scadenza: {$a->duedate}</strong></p>
<p><a href="{$a->url}">Vai all\'attività</a></p>';
$string['assignmentduesoonsms'] = 'Il compito {$a->assignmentname} scade il {$a->duedate}: {$a->url}';
$string['assignmentduesoonsubject'] = 'Scadenza il {$a->duedate}: {$a->assignmentname}';
$string['assignmentisdue'] = 'Consegna compito';
$string['assignmentmail'] = '{$a->grader} ha inserito un commento sulla tua consegna del compito \'{$a->assignment}\' .

Puoi visualizzare il commento di seguito alla tua consegna:

{$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader} ha inserito un commento sulla tua consegna del compito  \'{$a->assignment}\'.</p>
<p>Puoi visualizzare il commento <a href="{$a->url}">di seguito alla tua consegna</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader} ha inserito un commento sulla tua consegna del compito \'{$a->assignment}\' . Puoi visualizzare il commento di seguito alla tua consegna.';
$string['assignmentname'] = 'Titolo del compito';
$string['assignmentoverduehtml'] = '<p>Gentile {$a->firstname},</p>
<p><strong>{$a->assignmentname}</strong> nel corso {$a->coursename} doveva essere consegnato il <strong>{$a->duedate}</strong>.</p>
<p>Potresti comunque riuscire a inviare il tuo compito {$a->cutoffsnippet}, ma la consegna verrà contrassegnata come in ritardo.</p>
<p><a href="{$a->url}">Vai all\'attività</a></p>';
$string['assignmentoverduehtmlcutoffsnippet'] = '<strong>entro {$a->cutoffdate}</strong>';
$string['assignmentoverduesms'] = 'Il tuo compito {$a->assignmentname} è in ritardo dal {$a->duedate}: {$a->url}';
$string['assignmentoverduesubject'] = 'In ritardo: {$a->assignmentname}';
$string['assignmentplugins'] = 'Plugin compito';
$string['assignmentsperpage'] = 'Compiti per pagina';
$string['assignsubmission'] = 'Plugin consegna';
$string['assignsubmissionpluginname'] = 'Plugin consegna';
$string['assigntimeleft'] = 'Tempo rimanente';
$string['attemptheading'] = 'Tentativo {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Tentativo precedente';
$string['attemptnumber'] = 'Numero tentativo';
$string['attemptreopenmethod'] = 'Tentativi aggiuntivi';
$string['attemptreopenmethod_automatic'] = 'Automaticamente';
$string['attemptreopenmethod_automatic_help'] = 'Dopo ogni tentativo, il successivo viene concesso automaticamente dopo la valutazione.';
$string['attemptreopenmethod_help'] = 'Questa impostazione controlla il modo in cui agli studenti vengono concessi i tentativi. Per ogni tentativo, la valutazione e il feedback vengono salvati e possono essere visualizzati dal docente e dallo studente. Le opzioni disponibili sono:

* Manualmente: dopo ogni tentativo, è possibile concedere quello successivo tramite la pagina Consegne o la pagina Valutazione.
* Automaticamente: dopo ogni tentativo, viene concesso automaticamente il successivo.
* Automaticamente fino al superamento - Dopo ogni tentativo, il successivo verrà concesso automaticamente, finché lo studente non raggiungerà la sufficienza.';
$string['attemptreopenmethod_manual'] = 'Manualmente';
$string['attemptreopenmethod_manual_help'] = 'Dopo ogni tentativo, puoi concedere quello successivo attraverso la pagina Consegne o la pagina Valutazione.';
$string['attemptreopenmethod_none'] = 'Mai';
$string['attemptreopenmethod_untilpass'] = 'Automaticamente fino al superamento';
$string['attemptreopenmethod_untilpass_help'] = 'Dopo ogni tentativo, verrà concesso automaticamente il successivo, fino al raggiungimento della sufficienza.';
$string['attemptsettings'] = 'Impostazioni tentativo';
$string['availability'] = 'Disponibilità';
$string['back'] = 'Indietro';
$string['backtoassignment'] = 'Torna al compito';
$string['batchoperationaddattempt'] = 'Concedi tentativo';
$string['batchoperationconfirmaddattempt'] = 'Confermi il nuovo tentativo per le consegne selezionate?';
$string['batchoperationconfirmdownloadselected'] = 'Vuoi scaricare le consegne selezionate?';
$string['batchoperationconfirmgrantextension'] = 'Vuoi concedere la proroga a tutte le consegne selezionate ?';
$string['batchoperationconfirmlock'] = 'Vuoi bloccare tutte le consegne selezionate?';
$string['batchoperationconfirmremovesubmission'] = 'Vuoi eliminare le consegne selezionate?';
$string['batchoperationconfirmreverttodraft'] = 'Vuoi riportare le consegne selezionate a bozza?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Vuoi impostare l\'assegnazione dei valutatori per tutte le consegne selezionate?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Vuoi impostare lo stato del flusso di lavoro della valutazione per tutte le consegne selezionate?';
$string['batchoperationconfirmunlock'] = 'Vuoi sbloccare tutte le consegne selezionate ?';
$string['batchoperationdownloadselected'] = 'Download';
$string['batchoperationgrantextension'] = 'Estendi';
$string['batchoperationlock'] = 'Blocca';
$string['batchoperationremovesubmission'] = 'Elimina';
$string['batchoperationreverttodraft'] = 'Riporta in bozza';
$string['batchoperationsdescription'] = 'Per gli utenti selezionati...';
$string['batchoperationsetmarkingallocation'] = 'Assegna valutatore';
$string['batchoperationsetmarkingworkflowstate'] = 'Modifica stato della valutazione';
$string['batchoperationunlock'] = 'Sblocca';
$string['batchsetallocatedmarker'] = 'Valutatori assegnati per {$a} utenti selezionati.';
$string['batchsetmarkingworkflowstateforusers'] = 'Stato del flusso di lavoro della valutazione impostato per {$a} utenti selezionati.';
$string['beginassignment'] = 'Inizia il compito';
$string['blindmarking'] = 'Consegne anonime';
$string['blindmarking_help'] = 'La consegna anonima nasconde l\'identità degli studenti ai valutatori. L\'impostazione di consegna anonima sarà bloccata non appena sarà presente una consegna o una valutazione del compito.';
$string['blindmarkingenabledwarning'] = 'In questa attività è abilitata la consegna anonima.';
$string['blindmarkingnogradewarning'] = 'Per questa attività è possibile consegnare compiti in forma anonima. Le valutazioni non verranno inserire nel registro finché non verranno rivelate le identità degli studenti tramite il menu "Azioni".';
$string['bulkactionsselection'] = 'Nuovo feedback su \'{$an->assignment}\' in \'{$a->coursefull name}\'. Accedere per visualizzare';
$string['cachedef_overrides'] = 'Informazioni sulle personalizzazioni individuali e di gruppo';
$string['calendardue'] = '{$a} è in scadenza';
$string['calendarextension'] = '{$a} è in scadenza (estensione)';
$string['calendargradingdue'] = '{$a} deve essere valutato';
$string['caneditsubmission'] = 'È possibile modificare la propria consegna e inviarla dopo la scadenza del limite di tempo, ma verrà segnato come in ritardo.';
$string['changefilters'] = 'Modifica filtri';
$string['changeuser'] = 'Modifica utente';
$string['choosegradingaction'] = 'Azioni per la valutazione';
$string['choosemarker'] = 'Scegli...';
$string['chooseoperation'] = 'Scegli operazione';
$string['clickexpandreviewpanel'] = 'Click per ingrandire il pannello di revisione';
$string['collapsegradepanel'] = 'Click per ridurre il pannello di revisione';
$string['collapsereviewpanel'] = 'Riduci il pannello di revisione';
$string['comment'] = 'Commento';
$string['completiondetail:submit'] = 'Consegnare';
$string['completionsubmit'] = 'Lo studente deve consegnare';
$string['configshowrecentsubmissions'] = 'Consente a tutti di visualizzare la notifica delle consegne nei report dell\'attività recente.';
$string['confirmbatchgradingoperation'] = 'Sei sicuro di eseguire {$a->operation} per {$a->count} studenti?';
$string['confirmstart'] = 'Hai {$a} per completare il compito. Quando inizierai, partirà il conteggio alla rovescia del tempo che non potrà essere messo in pausa.';
$string['confirmsubmission'] = 'Sei sicuro di voler consegnare il tuo lavoro per farlo valutare? La consegna non potrà più essere modificata.';
$string['confirmsubmissionheading'] = 'Conferma consegna';
$string['conversionexception'] = 'Non è stato possibile convertire il compito. Eccezione verificatasi:{$a}.';
$string['couldnotconvertgrade'] = 'Non è stato possibile convertire la valutazione del compito per l\'utente {$a}.';
$string['couldnotconvertsubmission'] = 'Non è stato possibile convertire la consegna del compito per l\'utente {$a}.';
$string['couldnotcreatecoursemodule'] = 'Non è stato possibile creare il modulo del corso';
$string['couldnotcreatenewassignmentinstance'] = 'Non è stato possibile creare una nuova istanza di compito';
$string['couldnotfindassignmenttoupgrade'] = 'Non è stato possibile trovare precedenti istanze di compito da aggiornare';
$string['crontask'] = 'Elaborazione in background: modulo compito';
$string['currentassigngrade'] = 'Valutazione corrente del compito';
$string['currentattempt'] = 'Tentativo {$a}.';
$string['currentattemptof'] = 'Tentativo {$a->attemptnumber} (Tentativi consentiti: {$a->maxattempts}).';
$string['currentgrade'] = 'Voto nel Registro valutatore';
$string['cutoffdate'] = 'Data limite';
$string['cutoffdate_help'] = 'Le consegne oltre la data limite saranno impedite, a meno che non si conceda una proroga. Se non impostato le consegne saranno accettate sempre.';
$string['cutoffdatecolon'] = 'Data limite: {$a}';
$string['cutoffdatefromdatevalidation'] = 'La data limite deve essere successiva alla data di inizio consegne';
$string['cutoffdatevalidation'] = 'La data limite non può essere antecedente alla data di fine consegne.';
$string['defaultgradescale'] = 'Scala di valutazione';
$string['defaultgradescale_help'] = 'La scala di valutazione di default da utilizzare durante la creazione di nuovi compiti. È possibile utilizzare solo scale standard.';
$string['defaultgradetype'] = 'Tipo di valutazione';
$string['defaultgradetype_help'] = 'Il tipo di valutazione di default da utilizzare durante la creazione di nuovi compiti';
$string['defaultlayout'] = 'Ripristina impaginazione di default';
$string['defaultsettings'] = 'Impostazioni compito di default';
$string['defaultsettings_help'] = 'Queste impostazioni definiscono i default per tutte le nuove istanze di compito';
$string['defaultteam'] = 'Gruppo di default';
$string['deleteallsubmissions'] = 'Ttutte le consegne';
$string['description'] = 'Descrizione';
$string['disabled'] = 'Disabilitato';
$string['downloadall'] = 'Scarica tutte le consegne';
$string['downloadasfolders'] = 'Scarica consegne in cartelle';
$string['downloadasfolders_help'] = 'Se le consegne sono formate da più di un file, sarà possibile scaricarle suddivise in cartelle. Ogni consegna sarà contenuta in una cartella separata mantenendo inalterati i nomi dei file la struttura delle eventuali sottocartelle.';
$string['downloadselectedsubmissions'] = 'Scarica le consegne selezionate';
$string['duedate'] = 'Termine consegne';
$string['duedate_help'] = 'La data di consegna del compito. Eventuali consegne successive alla data di fine consegne saranno considerate in ritardo. Per impedire consegne in ritardo è necessario impostare la data limite.';
$string['duedateaftersubmissionvalidation'] = 'La data limite deve essere successiva alla data di inizio consegne.';
$string['duedatecolon'] = 'Termine consegne: {$a}';
$string['duedatereached'] = 'La data di scadenza del compito è già trascorsa';
$string['duedatevalidation'] = 'La data di scadenza non può essere antecedente alla data di inizio consegne';
$string['duplicateoverride'] = 'Duplica personalizzazione';
$string['editaction'] = 'Azioni...';
$string['editattemptfeedback'] = 'Modifica della valutazione e del feedback per il tentativo {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Stai modificando il feedback di un tentativo precedente. Questo è il tentativo {$a->attemptnumber} di {$a->totalattempts}.';
$string['editingstatus'] = 'Possibilità di modifica';
$string['editonline'] = 'Modifica online';
$string['editoverride'] = 'Modifica personalizzazione';
$string['editsubmission'] = 'Modifica consegna';
$string['editsubmission_help'] = 'Puoi ancora modificare la tua consegna';
$string['editsubmissionother'] = 'Modifica consegna di {$a}';
$string['enabled'] = 'Abilitato';
$string['enabletimelimit'] = 'Abilita compiti a tempo';
$string['enabletimelimit_help'] = 'Consente di impostare un limite di tempo nelle impostazioni del compito.';
$string['errorgradechangessaveddetail'] = 'Le modifiche al voto e al feedback non sono state salvate.';
$string['errornosubmissions'] = 'Non ci sono consegne da scaricare';
$string['errorquickgradingvsadvancedgrading'] = 'La valutazione non è stata salvata poiché il compito sta usando la valutazione avanzata.';
$string['errorrecordmodified'] = 'La valutazione non è stata salvata poiché uno o più record sono stati modificati da qualcuno più recentemente del tuo caricamento della pagina.';
$string['eventallsubmissionsdownloaded'] = 'Scaricamento di tutte le consegne';
$string['eventassessablesubmitted'] = 'Consegna compito';
$string['eventbatchsetmarkerallocationviewed'] = 'Visualizzazione assegnazione valutatori';
$string['eventbatchsetworkflowstateviewed'] = 'Visualizzazione stati del flusso di lavoro';
$string['eventextensiongranted'] = 'Concessione proroga';
$string['eventfeedbackupdated'] = 'Aggiornamento commento';
$string['eventfeedbackviewed'] = 'Visualizzazione commento';
$string['eventgradingformviewed'] = 'Visualizzazione schema di valutazione';
$string['eventgradingtableviewed'] = 'Visualizzazione tabella delle valutazioni';
$string['eventidentitiesrevealed'] = 'Rivelazione identità';
$string['eventmarkerupdated'] = 'Aggiornamento valutatore assegnato';
$string['eventoverridecreated'] = 'Creazione personalizzazione del compito';
$string['eventoverridedeleted'] = 'Eliminazione personalizzazione del compito';
$string['eventoverrideupdated'] = 'Aggiornamento personalizzazione del compito';
$string['eventremovesubmissionformviewed'] = 'Visualizzazione conferma rimozione consegna.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Visualizzazione pagina conferma rivelazione identità';
$string['eventstatementaccepted'] = 'Accettazione utente dellla dichiarazione sulla consegna';
$string['eventsubmissionconfirmationformviewed'] = 'Visualizzazione scheda di conferma consegna';
$string['eventsubmissioncreated'] = 'Creazione consegna';
$string['eventsubmissionduplicated'] = 'Duplicazione consegna da parte di un utente';
$string['eventsubmissionformviewed'] = 'Visualizzazione scheda di consegna';
$string['eventsubmissiongraded'] = 'Valutazione consegna';
$string['eventsubmissionlocked'] = 'Blocco consegna di un utente';
$string['eventsubmissionremoved'] = 'Consegna rimossa.';
$string['eventsubmissionstatusupdated'] = 'Aggiornamento stato della consegna';
$string['eventsubmissionstatusviewed'] = 'Visualizzazione stato consegna';
$string['eventsubmissionunlocked'] = 'Sblocco consegna di un utente';
$string['eventsubmissionupdated'] = 'Salvataggio consegna di un utente';
$string['eventsubmissionviewed'] = 'Visualizzazione consegna';
$string['eventworkflowstateupdated'] = 'Aggiornamento stato del flusso di lavoro.';
$string['expandreviewpanel'] = 'Ingrandisci il pannello di revisione';
$string['extensionduedate'] = 'Data scadenza proroga';
$string['extensionduedatecurrent'] = 'Data di scadenza dell\'estensione';
$string['extensionduedatenone'] = 'Nessuna';
$string['extensionduedaterange'] = 'Variabile tra {$a->earliest} e {$a->latest}';
$string['extensionduedatewithout'] = 'Utenti senza estensione : {$a}';
$string['extensionnotafterduedate'] = 'La data di fine proroga deve essere successiva alla data di fine consegne';
$string['extensionnotafterfromdate'] = 'La data di fine proroga deve essere successiva alla data di inizio consegne';
$string['feedback'] = 'Commento';
$string['feedbackavailableanonhtml'] = 'Hai un nuovo feedback sulla consegna del compito \'{$a->assignment}\'. È possibile visualizzarlo <a href="{$a->url}>al seguente URL, di seguito alla consegna</a>.';
$string['feedbackavailableanonsmall'] = 'Nuovo feedback sulla consegna {$a->assignment}';
$string['feedbackavailableanonsms'] = 'Hai un nuovo feedback su {$a->assignment} in \'{$a->coursefullname}\'. Autenticati per visualizzare';
$string['feedbackavailableanontext'] = 'Hai un nuovo feedback sulla consegna del compito \'{$a->assignment}\'

È possibile visualizzarlo al seguente URL, di seguito alla consegna:

{$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} ha inserito un commento sulla tua consegna del compito  \'{$a->assignment}.
Puoi visualizzare il commento di seguito <a href="{$a->url}">alla tua consegna</a>.';
$string['feedbackavailablesmall'] = '{$a->username} ha inserito un commento sul compito {$a->assignment}';
$string['feedbackavailablesms'] = '{$a->username} ha fornito un feedback su {$a->assignment}: {$a->url}';
$string['feedbackavailabletext'] = '{$a->username} ha inserito un commento sulla tua consegna del compito \'{$a->assignment}\' .

Puoi visualizzare il commento di seguito alla tua consegna:

{$a->url}';
$string['feedbackplugin'] = 'Plugin commento';
$string['feedbackpluginforgradebook'] = 'Il plugin commento che invierà i commenti al registro valutatore';
$string['feedbackpluginforgradebook_help'] = 'Solo un plugin commento può inserire commenti nel registro valutatore';
$string['feedbackplugins'] = 'Plugin commento';
$string['feedbacksettings'] = 'Impostazioni commento';
$string['feedbacktypes'] = 'Tipi di feedback';
$string['filesubmissions'] = 'File consegnati';
$string['filter'] = 'Filtro';
$string['filterall'] = 'Tutto';
$string['filterdraft'] = 'Bozza';
$string['filtergraded'] = 'Valutata';
$string['filtergrantedextension'] = 'Proroghe concesse';
$string['filternone'] = 'Senza filtro';
$string['filternotsubmitted'] = 'Non consegnato';
$string['filterrequiregrading'] = 'In attesa di valutazione';
$string['filtersubmitted'] = 'Consegnato';
$string['fixrescalednullgrades'] = 'Il compito contiene alcune valutazioni errate. È possibile <a href="{$a->link}">sistemare automaticamente tali valutazioni</a>. Da notare che i totali del corso potranno cambiare.';
$string['fixrescalednullgradesconfirm'] = 'Sei sicuro di sistemare le valutazioni errate? Tutte le valutazioni interessate saranno rimosse. Da notare che i totali del corso potranno cambiare.';
$string['fixrescalednullgradesdone'] = 'Valutazioni sistemate.';
$string['gradeabovemaximum'] = 'La valutazione deve essere minore o uguale a {$a}.';
$string['gradeactions'] = 'Azioni sulle valutazioni';
$string['gradebelowzero'] = 'La valutazione deve essere maggiore o uguale a zero';
$string['gradebreakdown'] = 'Suddivisione delle valutazioni';
$string['gradecanbechanged'] = 'La valutazione può essere cambiata';
$string['gradechangessaveddetail'] = 'Le modifiche alla valutazione e al feedback sono state salvate';
$string['graded'] = 'Valutata';
$string['gradedby'] = 'Valutatore';
$string['gradedfollowupsubmit'] = 'Valutata - Consegnata di nuovo';
$string['gradedon'] = 'Data di valutazione';
$string['gradeitem:submissions'] = 'Consegne';
$string['gradelocked'] = 'Questa valutazione è bloccata oppure modificata nel registro valutatore.';
$string['gradeoutof'] = 'Punteggio (su {$a})';
$string['gradeoutofhelp'] = 'Valutazione';
$string['gradeoutofhelp_help'] = 'Inserisci la valutazione da assegnare al compito dello studente. Puoi anche usare cifre decimali.';
$string['gradepenalty'] = 'Penalità sulla valutazione';
$string['gradepenalty_help'] = 'Consente di applicare delle penalità ali compiti consegnati dopo la data limite.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} ha modificato la propria consegna di \'{$a->assignment} il {$a->timeupdated}\'. Il compito è disponibile a <a href="{$a->url}">questo link</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} ha aggiornato la propria consegna del compito {$a->assignment}.';
$string['gradersubmissionupdatedsms'] = '{$a->username} ha aggiornato la sua richiesta per il compito \'{$a->assignment}\' in \'{$a->coursefullname}\'. Accedere per visualizzare';
$string['gradersubmissionupdatedtext'] = '{$a->username} ha modificato la propria consegna di \'{$a->assignment}\' il {$a->timeupdated}

Il compito è disponibile al link:

{$a->url}';
$string['gradestudent'] = 'Valutazione studente: (id={$a->id}, Nome={$a->fullname}).';
$string['gradeuser'] = 'Valutazione {$a}';
$string['grading'] = 'Valutazione';
$string['gradingchangessaved'] = 'Le modifiche alle valutazioni sono state salvate';
$string['gradingduedate'] = 'Ricordami di valutare entro';
$string['gradingduedate_help'] = 'La data entro la quale completare la valutazione delle consegne. La data viene utilizzata nella dashboard per dare priorità alle notifiche ai docenti.';
$string['gradingdueduedatevalidation'] = 'Ricordami che la data entro la quale valutare non può precedere la data di consegna.';
$string['gradingduefromdatevalidation'] = 'Ricordami che la data entro la quale valutare non può precedere la data di inizio consegne.';
$string['gradingmethodpreview'] = 'Criterio di valutazione';
$string['gradingoptions'] = 'Opzioni';
$string['gradingstatus'] = 'Stato valutazione';
$string['gradingstudent'] = 'Valutazione studente';
$string['gradingsummary'] = 'Riepilogo delle valutazioni';
$string['grantextension'] = 'Concedi proroga';
$string['grantextensionforusers'] = 'Concedi proroga a {$a} studenti';
$string['groupoverrides'] = 'Personalizzazione di gruppo';
$string['groupoverridesdeleted'] = 'Eliminata personalizzazione di gruppo';
$string['groupsnone'] = 'Non ci sono gruppi dove puoi accedere.';
$string['groupsubmissionsettings'] = 'Impostazioni consegna di gruppo';
$string['hiddenuser'] = 'Partecipante';
$string['hidegrader'] = 'Nascondi agli studenti l\'identità del valutatore';
$string['hidegrader_help'] = 'Gli studenti non potranno visualizzare chi ha valutato la loro consegna.

Da notare che l\'impostazione non si applica al riquadro commenti nella pagina di valutazione.';
$string['hideshow'] = 'Nascondi/Visualizza';
$string['inactiveoverridehelp'] = '* La personalizzazione non è attiva poiché gli studenti non possono accedervi. Può avvenire in funzione di assegnazioni a gruppi o a ruoli, condizioni di accesso, oppure perché l\'attività è nascosta.';
$string['includesuspendedparticipants'] = 'Includi partecipanti sospesi';
$string['indicator:cognitivedepth'] = 'Compito cognitivo';
$string['indicator:cognitivedepth_help'] = 'L\'indicatore è basato sulla profondità cognitiva toccata dallo studente svolgendo attività Compito.';
$string['indicator:cognitivedepthdef'] = 'Compito cognitivo';
$string['indicator:cognitivedepthdef_help'] = 'Durante l\'intervallo di analisi, il partecipante ha raggiunto questa percentuale di coinvolgimento cognitivo offerto dalle attività Compito (Livelli: Nessuna visualizzazione, Visualizzazione, Invio, Visualizzazione feedback, Commento al feedback, Nuovo invio dopo il feedback)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Compito sociale';
$string['indicator:socialbreadth_help'] = 'L\'indicatore è basato sulla dimensione sociale raggiunta dallo studente svolgendo attività Compito.';
$string['indicator:socialbreadthdef'] = 'Compito sociale';
$string['indicator:socialbreadthdef_help'] = 'Durante l\'intervallo di analisi, il partecipante ha raggiunto questa percentuale di coinvolgimento sociale offerto dall\'attività Compito (Livelli: Nessuna partecipazione, Partecipazione da solo, Partecipazione con altri)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['instructionfiles'] = 'File delle istruzioni';
$string['introattachments'] = 'File aggiuntivi';
$string['introattachments_help'] = 'Nei compiti è possibile utilizzare file aggiuntivi, come ad esempio modelli di risposte.';
$string['invalidfloatforgrade'] = 'Non è stato possibile capire la valutazione data: {$a}';
$string['invalidgradeforscale'] = 'La valutazione data non coincide con nessuno dei valori presenti nella scala di valutazione utilizzata.';
$string['invalidoverrideid'] = 'Id personalizzazione non valida';
$string['lastmodifiedgrade'] = 'Ultima modifica (valutazione)';
$string['lastmodifiedsubmission'] = 'Ultima modifica (consegna)';
$string['latesubmissions'] = 'Consegne in ritardo';
$string['latesubmissionsaccepted'] = 'Consentito fino al {$a}';
$string['loading'] = 'Caricamento in corso...';
$string['locksubmissionforstudent'] = 'Blocca le consegne dello studente (id={$a->id}, fullname={$a->fullname})';
$string['locksubmissions'] = 'Blocca consegne';
$string['manageassignfeedbackplugins'] = 'Gestione plugin commento compito';
$string['manageassignsubmissionplugins'] = 'Gestione plugin consegna compito';
$string['marker'] = 'Valutatore';
$string['markerfilter'] = 'Filtro valutatore';
$string['markerfilternomarker'] = 'Nessun valutatore';
$string['markingallocation'] = 'Utilizza assegnazione valutatori';
$string['markingallocation_help'] = 'Consente di assegnare valutatori a singoli studenti. Richiede l\'attivazione del flusso di lavoro della valutazione.';
$string['markinganonymous'] = 'Consenti il rilascio parziale dei voti durante la valutazione anonima';
$string['markinganonymous_help'] = 'Se abilitato insieme alle consegne anonime e al flusso di lavoro della valutazione, consente il rilascio parziale dei voti durante la valutazione anonima.';
$string['markingstate'] = 'Stato della valutazione';
$string['markingworkflow'] = 'Utilizza flusso di lavoro della valutazione';
$string['markingworkflow_help'] = 'Le valutazioni seguiranno un flusso di lavoro prima di essere rilasciate agli studenti, consentendo di valutare in diversi cicli e rilasciare le valutazioni a tutti gli studenti in una sola volta.';
$string['markingworkflowstate'] = 'Stato del flusso di lavoro della valutazione';
$string['markingworkflowstate_help'] = 'I possibili stati del flusso di lavoro, in funzione dei privilegi posseduti, possono essere i seguenti:

* Non valutata - la valutazione non è iniziata
* In valutazione - la valutazione è iniziata ma non è ancora terminata
* Valutazione completata - la valutazione è stata terminata ma il valutatore potrebbe volerla rivedere
* In revisione - la valutazione è in carico al docente responsabile per il controllo di qualità
* Pronta per il rilascio - il docente responsabile ha validato la valutazione ma non le ha ancora rese disponibili
* Rilasciata - lo studente può visualizzare la valutazione/feedback.';
$string['markingworkflowstateinmarking'] = 'In valutazione';
$string['markingworkflowstateinreview'] = 'In revisione';
$string['markingworkflowstatenotmarked'] = 'Non valutata';
$string['markingworkflowstatereadyforrelease'] = 'Pronta per il rilascio';
$string['markingworkflowstatereadyforreview'] = 'Valutazione completata';
$string['markingworkflowstatereleased'] = 'Rilasciata';
$string['maxattempts'] = 'Numero di tentativi';
$string['maxattempts_help'] = 'Il numero massimo di tentativi di consegna di uno studente. Raggiunto il numero massimo impostato non sarà più possibile riaprire le consegne.';
$string['maxgrade'] = 'Valutazione massima';
$string['maxperpage'] = 'Numero massimo di consegne per pagina';
$string['maxperpage_help'] = 'Il numero massimo di consegne visualizzabili dal valutatore nella stessa pagina. L\'impostazione è particolarmente utile nei corsi con molte iscrizioni.';
$string['messageprovider:assign_due_digest'] = 'Notifica compiti in scadenza tra 7 giorni';
$string['messageprovider:assign_due_soon'] = 'Notifica di compito con scadenza a breve';
$string['messageprovider:assign_notification'] = 'Notifiche compito';
$string['messageprovider:assign_overdue'] = 'Notifica di consegna in ritardo';
$string['modulename'] = 'Compito';
$string['modulename_help'] = 'Il modulo di attività compito consente al docente di valutare l\'apprendimento degli studenti assegnando loro un lavoro che potrà poi valutare e commentare.

Gli studenti possono consegnare qualsiasi tipo di contenuto digitale, come ad esempio documenti di testo, immagini, clip audio e clip video. Il compito può anche prevedere la compilazione online di un testo sia in alternativa sia in aggiunta al caricamento di file. È anche possibile usare il compito per attività da svolgere al di fuori di Moodle, dove non sono richiesti contenuti digitali. Gli studenti possono consegnare i lavori individualmente oppure come membri di un gruppo.

I docenti possono commentare le consegne degli studenti e caricare file a loro volta, ad esempio i compiti corretti e valutati o file audio di commento. I compiti possono essere valutati utilizzando sia voti numerici, sia metodi di valutazione avanzata tipo rubric. Le valutazioni vengono memorizzate nel registro valutatore';
$string['modulename_link'] = 'mod/assignment/view';
$string['modulenameplural'] = 'Compiti';
$string['moreusers'] = '{$a} ulteriori...';
$string['multipleteams'] = 'Appartieni a più gruppi';
$string['multipleteams_desc'] = 'Il compito prevede la consegna di gruppo ma tu sei membro di più di un gruppo. Per poter consegnare, devi essere membro di un solo gruppo. Per favore contatta il docente per modificare la tua appartenenza ai gruppi.';
$string['multipleteamsgrader'] = 'Appartieni a più gruppi, non puoi effettuare consegne';
$string['newsubmissions'] = 'Compiti consegnati';
$string['nextuser'] = 'Utente successivo';
$string['noattempt'] = 'Nessun tentativo';
$string['noclose'] = 'Senza chiusura';
$string['nofiles'] = 'Nessun file.';
$string['nofilters'] = 'Nessun filtro';
$string['nograde'] = 'Nessuna valutazione.';
$string['nogroupoverrides'] = 'Al momento non sono presenti personalizzazioni di gruppo.';
$string['nomoresubmissionsaccepted'] = 'Consentito solamente ai partecipanti ai quali è stata concessa una proroga';
$string['none'] = 'Nessuno';
$string['noonlinesubmissions'] = 'Questo compito non richiede consegne online';
$string['noopen'] = 'Senza data di apertura';
$string['nooverridedata'] = 'Devi personalizzare almeno una impostazione del compito.';
$string['nosavebutnext'] = 'Successivo';
$string['nosubmission'] = 'Non sono presenti consegne da valutare';
$string['nosubmissionyet'] = 'Non sono presenti consegne.';
$string['noteam'] = 'Non appartieni a nessun gruppo';
$string['noteam_desc'] = 'Il compito prevede la consegna di gruppo ma tu non sei membro di nessun gruppo e non puoi effettuare consegne. Per favore contatta il docente affinché ti inserisca in un gruppo.';
$string['noteamgrader'] = 'Non appartieni a nessun gruppo, non puoi effettuare consegne';
$string['notgraded'] = 'Non valutata';
$string['notgradedyet'] = 'Non ancora valutata';
$string['notifications'] = 'Notifiche';
$string['notifystudents'] = 'Notifica gli studenti';
$string['nouseroverrides'] = 'Al momento non sono presenti personalizzazioni individuali.';
$string['nousers'] = 'Nessun utente';
$string['nousersselected'] = 'Non sono stati selezionati utenti';
$string['numberofdraftsubmissions'] = 'Bozze';
$string['numberofparticipants'] = 'Partecipanti';
$string['numberofsubmissionsneedgrading'] = 'In attesa di valutazione';
$string['numberofsubmissionsneedgradinglabel'] = 'Da valutare: {$a}';
$string['numberofsubmittedassignments'] = 'Consegne';
$string['numberofteams'] = 'Gruppi';
$string['offline'] = 'Questo compito non richiede consegne online';
$string['open'] = 'Aperto';
$string['opensubmissionexists'] = 'Una consegna aperta esiste già.';
$string['outlinegrade'] = 'Valutazione: {$a}';
$string['outof'] = '{$a->current} su {$a->total}';
$string['overdue'] = 'Consegna in ritardo da: {$a}';
$string['override'] = 'Personalizza';
$string['overridedeletegroupsure'] = 'Sei sicuro di eliminare la personalizzazione del gruppo {$a}?';
$string['overridedeleteusersure'] = 'Sei sicuro di eliminare la personalizzazione individuale {$a}?';
$string['overridegroup'] = 'Personalizzazione di gruppo';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overriderecalculatepenalty'] = 'Ricalcola la penalità per l\'utente/gli utenti nell\'override';
$string['overrides'] = 'Personalizzazioni';
$string['overrideuser'] = 'Personalizzazione individuale';
$string['overrideusereventname'] = '{$a->assign} - Personalizzazione';
$string['page-mod-assign-view'] = 'Pagina principale del modulo compito';
$string['page-mod-assign-x'] = 'Qualsiasi pagina principale del modulo compito';
$string['paramtimeremaining'] = 'Rimanenti: {$a}';
$string['participant'] = 'Partecipante';
$string['penaltyduedatechangemessage'] = 'Alcuni voti sono già stati assegnati. Per modificare la data di scadenza, disabilitare/abilitare la penalità, scegliendo prima se se ricalcolare o meno i voti esistenti.';
$string['pluginadministration'] = 'Gestione compito';
$string['pluginname'] = 'Compito';
$string['preventsubmissionnotingroup'] = 'Consegna di gruppo obbligatoria';
$string['preventsubmissionnotingroup_help'] = 'Abilitando l\'impostazione, gli utenti che non fanno parte di un gruppo non potranno effettuare consegne';
$string['preventsubmissions'] = 'Impedisce qualsiasi ulteriore modifica da parte dell\'utente della consegna effettuata';
$string['preventsubmissionsshort'] = 'Blocca modifiche della consegna';
$string['previous'] = 'Precedente';
$string['previoususer'] = 'Utente precedente';
$string['privacy:attemptpath'] = 'tentativo {$a}';
$string['privacy:blindmarkingidentifier'] = 'Identificativo utilizzato nella consegna anonima';
$string['privacy:gradepath'] = 'valutazione';
$string['privacy:metadata:assigndownloadasfolders'] = 'Preferenza utente per lo scaricamento suddiviso in cartelle delle consegne contenenti più file';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Feedback sui compiti.';
$string['privacy:metadata:assignfilter'] = 'Filtri \'Consegnato\', \'Non consegnato\', \'In attesa di valutazione\' e \'Proroga concessa\'.';
$string['privacy:metadata:assigngrades'] = 'Valutazione ricevuta dall\'utente';
$string['privacy:metadata:assignmarkerfilter'] = 'Filtraggio del riepilogo compiti tramite i valutatori assegnati.';
$string['privacy:metadata:assignmentid'] = 'ID del compito';
$string['privacy:metadata:assignmessageexplanation'] = 'Messaggi inviati agli studenti attraverso il sistema di messaggistica.';
$string['privacy:metadata:assignoverrides'] = 'Personalizzazioni del compito.';
$string['privacy:metadata:assignperpage'] = 'Numero di compiti visualizzati sulla pagina.';
$string['privacy:metadata:assignquickgrading'] = 'Preferenza di utilizzo della valutazione rapida.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Informazioni sulla consegna dell\'utente';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Dati della consegna del compito.';
$string['privacy:metadata:assignuserflags'] = 'Meta dati dell\'utente, ad esempio le proroghe.';
$string['privacy:metadata:assignusermapping'] = 'Mappatura della consegna anonima';
$string['privacy:metadata:assignworkflowfilter'] = 'Filtro basato sulla fase del flusso di lavoro.';
$string['privacy:metadata:grade'] = 'Valutazione numerico della consegna. Può dipendere da scale/metodi di valutazione avanzata, ecc. ma viene sempre convertito in un numero in virgola mobile.';
$string['privacy:metadata:grader'] = 'ID utente del valutatore';
$string['privacy:metadata:groupid'] = 'ID del gruppo al quale l\'utente appartiene.';
$string['privacy:metadata:latest'] = 'Semplificazione della ricerca delle informazioni sull\'ultimo tentativo.';
$string['privacy:metadata:mailed'] = 'Indicatore di invio email all\'utente';
$string['privacy:metadata:timecreated'] = 'Data di creazione';
$string['privacy:metadata:timestarted'] = 'Ora d\'inizio';
$string['privacy:metadata:userid'] = 'Identificativo dell\'utente.';
$string['privacy:studentpath'] = 'Consegne degli studenti';
$string['privacy:submissionpath'] = 'consegna';
$string['quickgrading'] = 'Valutazione rapida';
$string['quickgrading_help'] = 'La valutazione rapida consente di valutare i compiti direttamente nella tabella delle consegne. La valutazione rapida non è compatibile con la valutazione avanzata ed è sconsigliata in presenza di più valutatori.';
$string['quickgradingchangessaved'] = 'Le modiche alle valutazioni sono state salvate';
$string['quickgradingresult'] = 'Valutazione rapida';
$string['recordid'] = 'Identificativo';
$string['relativedatessubmissiontimeleft'] = 'Calcolato individualmente';
$string['removeallgroupoverrides'] = 'Tutte le personalizzazioni di gruppo';
$string['removealluseroverrides'] = 'Tutte le personalizzazioni individuali';
$string['removesubmission'] = 'Elimina consegna';
$string['removesubmissionconfirm'] = 'Sei sicuro di eliminare la consegna?';
$string['removesubmissionconfirmforstudent'] = 'Sei sicuro di eliminare la consegna di {$a}?';
$string['removesubmissionconfirmforstudentwithtimelimit'] = 'Sei sicuro di rimuovere la consegna di {$a}? Da notare che il limite di tempo dello studente non sarà reimpostato. È possibile assegnare più tempo tramite una personalizzazione individuale.';
$string['removesubmissionconfirmwithtimelimit'] = 'Sei sicuro di eliminare la tua consegna? L\'azione non resetterà il limite di tempo.';
$string['removesubmissionforstudent'] = 'Eliminazione consegna dello studente (id={$a->id}, nome e cognome={$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'L\'opzione \'Automaticamente fino al superamento\' non è compatibile con la valutazione cieca poiché le valutazioni non verranno trasferite nel registro valutatore finché non sarà stata rivelata l\'identità degli studenti.';
$string['requireallteammemberssubmit'] = 'Tutti i gli appartenenti al gruppo devono premere il pulsante consegna';
$string['requireallteammemberssubmit_help'] = 'Questa impostazione deve essere utilizzata insieme a \'Richiedi agli studenti di fare clic sul pulsante di invio\' nelle Impostazioni di invio.

Se abilitato, tutti i membri del gruppo dovranno fare clic sul pulsante di invio affinché la consegna di gruppo venga considerata come consgenata. Se disabilitato, qualsiasi membro del gruppo può fare clic sul pulsante di invio.';
$string['requiresubmissionstatement'] = 'Obbliga gli studenti ad accettare la dichiarazione sulla consegna';
$string['requiresubmissionstatement_help'] = 'Gli studenti saranno obbligati ad accettare la dichiarazione sulla consegna per tutte le consegne del compito.';
$string['revealidentities'] = 'Rivela l\'identità degli studenti';
$string['revealidentitiesconfirm'] = 'Sei sicuro di rivelare l\'identità degli studenti? L\'operazione non può essere annullata. Dopo aver rivelato l\'identità degli studenti, le valutazioni saranno trasferite nel registro valutatore.';
$string['reverttodefaults'] = 'Riporta tutti i valori del compito al loro default';
$string['reverttodraft'] = 'Riporta la consegna allo stato di bozza.';
$string['reverttodraftforgroup'] = 'Riporta la consegna del gruppo {$a} in stato di bozza.';
$string['reverttodraftforstudent'] = 'Riporta le consegne allo stato di bozza per lo student: (id={$a->id}, nome={$a->fullname}).';
$string['reverttodraftshort'] = 'Riporta a bozze le consegne';
$string['reviewed'] = 'Rivisto';
$string['save'] = 'Salva';
$string['saveallquickgradingchanges'] = 'Salva tutte le valutazioni rapide effettuate';
$string['saveandcontinue'] = 'Salva e continua';
$string['savechanges'] = 'Salva modifiche';
$string['savegradingresult'] = 'Valutazione';
$string['savenext'] = 'Salva e visualizza il successivo';
$string['saveoverrideandstay'] = 'Salva ed aggiungi un\'altra personalizzazione';
$string['savingchanges'] = 'Salvataggio in corso...';
$string['scale'] = 'Scala';
$string['search:activity'] = 'Compito - Informazioni sull\'attività';
$string['selectedusers'] = 'Utenti selezionati';
$string['selectlink'] = 'Seleziona...';
$string['selectuser'] = 'Seleziona {$a}';
$string['sendlatenotifications'] = 'Notifica le consegne in ritardo ai valutatori';
$string['sendlatenotifications_help'] = 'I valutatori (di solito i docenti) riceveranno una notifica tutte le volte che uno studente avrà consegnato un compito in ritardo. I metodi di notifica sono configurabili.';
$string['sendnotificationduedatesoon'] = 'Avvisa l\'utente dell\'avvicinarsi della data di scadenza del compito';
$string['sendnotificationduedigest'] = 'Notifica gli utenti di compiti in scadenza tra 7 giorni';
$string['sendnotificationoverdue'] = 'Notifica gli utenti riguardo le consegne in ritardo';
$string['sendnotifications'] = 'Notifica le consegne ai valutatori';
$string['sendnotifications_help'] = 'I valutatori (di solito i docenti) riceveranno una notifica tutte le volte che uno studente avrà consegnato un compito, sia che la consegna avvenga in anticipo, sia nelle date previste, sia in ritardo. I metodi di notifica sono configurabili.';
$string['sendstudentnotifications'] = 'Notifica agli studenti';
$string['sendstudentnotifications_help'] = 'Gli studenti riceveranno notifiche delle modifiche alle valutazioni o dei feedback. Se il compito fa uso di un flusso di lavoro, le notifiche non saranno inviate fino a quando la valutazione risulterà \'Rilasciata\'.';
$string['sendstudentnotificationsdefault'] = 'Impostazione di default per \'Notifica agli studenti\'';
$string['sendstudentnotificationsdefault_help'] = 'Imposta il valore di default per la casella di spunta \'Notifica agli studenti\'';
$string['sendsubmissionreceipts'] = 'Invia ricevuta di consegna agli studenti';
$string['sendsubmissionreceipts_help'] = 'Consente di inviare agli studenti una ricevuta di consegna. La ricevuta sarà invita ad ogni consegna avvenuta correttamente.';
$string['setmarkerallocationforlog'] = 'Assegnazione valutatori : (id={$a->id}, nome={$a->fullname}, valutatore={$a->marker}).';
$string['setmarkingallocation'] = 'Assegnazione valutatori';
$string['setmarkingworkflowstate'] = 'Impostazione stato del flusso di lavoro della valutazione';
$string['setmarkingworkflowstateforlog'] = 'Impostazione stato del flusso di lavoro della valutazione:  (id={$a->id}, nome={$a->fullname}, stato={$a->state}).';
$string['settings'] = 'Impostazioni compito';
$string['showrecentsubmissions'] = 'Visualizza consegne recenti';
$string['status'] = 'Stato';
$string['studentnotificationworkflowstateerror'] = 'Il flusso di lavoro deve avere la valutazione con lo stato di \'Rilasciata\' affinché siano inviate le notifiche agli studenti.';
$string['submission'] = 'Consegna';
$string['submissionactions'] = 'Azioni sulle consegne';
$string['submissionattachments'] = 'Visualizza file solo durante la consegna';
$string['submissionattachments_help'] = 'Consente di visualizzare i file solo nella pagina della consegna. Diversamente i file saranno visualizzati sia nella pagina della consegna sia nella pagina del compito.';
$string['submissioncontains'] = 'La tua consegna contiene:';
$string['submissioncopiedhtml'] = '<p>Hai copiato la tua precedente consegna del compito \'{$a->assignment}\'</p>
<p><a href="{$a->url}">Visualizza lo stato della tua consegna</a>.</p>';
$string['submissioncopiedsmall'] = 'Hai copiato la tua consegna precedente del compito {$a->assignment}';
$string['submissioncopiedsms'] = 'Hai creato una copia della consegna precedente di \'{$a->assignment}\' in \'{$a->coursefullname}\'. Accedere per visualizzare';
$string['submissioncopiedtext'] = 'Hai copiato la tua consegna precedente del compito \'{$a->assignment}\'

Per visualizzare lo stato della tua consegna:

{$a->url}';
$string['submissiondrafts'] = 'Gli studenti devono premere il pulsante di consegna';
$string['submissiondrafts_help'] = 'L\'impostazione obbliga gli studenti a premere il pulsante di consegna per confermare che la consegna del  proprio compito è definitiva.';
$string['submissioneditable'] = 'Lo studente può modificare la consegna';
$string['submissionempty'] = 'Non sono presenti consegne';
$string['submissionlog'] = 'Studente: {$a->fullname}, Stato: {$a->status}';
$string['submissionmodified'] = 'Sono già presenti consegne. Per favore abbandona la pagina e riprova.';
$string['submissionmodifiedgroup'] = 'La consegna è stata modificata da altri. Per favore abbandona la pagina e riprova.';
$string['submissionnotcopiedinvalidstatus'] = 'La consegna non è stata copiata poiché è stata modificata da quando è stato riaperto il tentativo.';
$string['submissionnoteditable'] = 'Gli studenti non possono modificare la consegna';
$string['submissionnotopen'] = 'Il compito non è aperto per le consegne';
$string['submissionnotready'] = 'Questo compito non è pronto per la consegna:';
$string['submissionplugins'] = 'Plugin consegna';
$string['submissionreceiptcontains'] = 'Contenuto consegnato ({$a->totale} elementi):';
$string['submissionreceipthtml'] = '<p>Hai effettuato una consegna per il compito \'{$a->assignment}\'.</p>
<p>Per visualizzare lo stato della consegna:
<a>{$a->url}</a>.</p>
{$a->submissionsummaryhtml}';
$string['submissionreceiptotherhtml'] = 'Hai effettuato una consegna per il compito \'{$a->assignment}\'. Per visualizzare lo stato della consegna: <a>{$a->url}</a>.';
$string['submissionreceiptothersmall'] = 'Hai effettuato una consegna per il compito {$a->assignment}.';
$string['submissionreceiptothersms'] = 'Consegna effettuata per \'{$a->assignment}\' in \'{$a->coursefullname}\'. Accedere per visualizzare lo stato dell\'invio.';
$string['submissionreceiptothertext'] = 'Hai effettuato una consegna per il compito {$a->assignment}.

Per visualizzare lo stato della consegna:

{$a->url}';
$string['submissionreceipts'] = 'Invia ricevuta di consegna';
$string['submissionreceiptsmall'] = 'Conferma della consegna del compito - {$a->assignment}';
$string['submissionreceiptsms'] = 'Hai consegnato \'{$a->assignment}\' in \'{$a->coursefullname}\'. Accedere per visualizzare lo stato dell\'invio.';
$string['submissionreceipttext'] = 'Hai consegnato il compito \'{$a->assignment}\'

Per vedere lo stato della tua consegna:

{$a->url}

{$a->submissionsummarytext}';
$string['submissions'] = 'Consegne';
$string['submissionsclosed'] = 'Consegne chiuse';
$string['submissionsettings'] = 'Impostazioni consegna';
$string['submissionslocked'] = 'Il compito non accetta consegne';
$string['submissionslockedshort'] = 'Non sono consentite modifiche della consegna';
$string['submissionstatement'] = 'Dichiarazione sulla consegna';
$string['submissionstatement_help'] = 'Il testo della dichiarazione sulla consegna che dovrà essere accettato dallo studente prima di consegnare il compito.';
$string['submissionstatementacceptedlog'] = 'Dichiarazione sulla consegna accettata dall\'utente {$a}';
$string['submissionstatementdefault'] = 'Il compito è un mio lavoro originale, ad eccezione delle parti dove ho riconosciuto l\'utilizzo di lavori altrui.';
$string['submissionstatementrequired'] = 'È necessario accettare questa dichiarazione prima di consegnare.';
$string['submissionstatementteamsubmission'] = 'Dichiarazione sulla consegna di gruppo';
$string['submissionstatementteamsubmission_help'] = 'Il testo della dichiarazione sulla consegna che dovrà essere accettato dallo studente prima di consegnare il compito del proprio gruppo.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Dichiarazione sulla consegna di gruppo dove tutti i membri consegneranno';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Il testo della dichiarazione sulla consegna che dovrà essere accettato dallo studente prima di consegnare il compito come membro di un gruppo.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'La consegna è un mio lavoro originale realizzato con altri membri del gruppo, ad eccezione delle parti dove ho riconosciuto l\'utilizzo di lavori altrui.';
$string['submissionstatementteamsubmissiondefault'] = 'La consegna è un lavoro originale del mio gruppo, ad eccezione delle parti dove è stato riconosciuto l\'utilizzo di lavori altrui.';
$string['submissionstatus'] = 'Stato consegna';
$string['submissionstatus_'] = 'Nessuna consegna';
$string['submissionstatus_draft'] = 'Bozza (non consegnato)';
$string['submissionstatus_marked'] = 'Valutato';
$string['submissionstatus_new'] = 'Nessuna consegna';
$string['submissionstatus_reopened'] = 'Riaperto';
$string['submissionstatus_submitted'] = 'Consegnato per la valutazione';
$string['submissionstatusheading'] = 'Stato consegna';
$string['submissionsummary'] = '{$a->status}. Ultima modifica {$a->timemodified}';
$string['submissionteam'] = 'Gruppo';
$string['submissiontypes'] = 'Tipi di consegne';
$string['submitaction'] = 'Consegna';
$string['submitassignment'] = 'Consegna compito';
$string['submitassignment_help'] = 'Dopo aver consegnato il compito non potrai più modificarlo';
$string['submitforgrading'] = 'Consegna per la valutazione';
$string['submitted'] = 'Consegnato';
$string['submittedearly'] = 'Il compito è stato consegnato {$a} in anticipo';
$string['submittedlate'] = 'Il compito è stato consegnato {$a} in ritardo';
$string['submittedlateshort'] = '{$a} in ritardo';
$string['submittedovertime'] = 'Il compito è stato consegnato {$a} oltre il limite di tempo';
$string['submittedundertime'] = 'Il compito è stato consegnato {$a} entro il limite di tempo';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Plugin commento';
$string['subplugintype_assignfeedback_plural'] = 'Plugin commento';
$string['subplugintype_assignsubmission'] = 'Plugin consegna';
$string['subplugintype_assignsubmission_plural'] = 'Plugin consegna';
$string['teamname'] = 'Gruppo: {$a}';
$string['teamsubmission'] = 'Consegna di gruppo';
$string['teamsubmission_help'] = 'Consente la suddivisione degli studenti in gruppi in base al set di default di gruppi o a un raggruppamento personalizzato. Una consegna di gruppo verrà condivisa tra i membri del gruppo e tutti i membri del gruppo vedranno le modifiche apportate dagli altri. Nota: non è possibile modificare questa impostazione se sono già presenti consegne.';
$string['teamsubmissiongroupingid'] = 'Raggruppamento';
$string['teamsubmissiongroupingid_help'] = 'Il raggruppamento da utilizzare per circoscrivere i gruppi di studenti. Se non impostato, verranno utilizzati i gruppi disponibili.';
$string['textinstructions'] = 'Istruzioni del compito';
$string['timelimit'] = 'Limite di tempo';
$string['timelimit_help'] = 'Durante lo svolgimento del compito sarà visualizzato un timer con un conteggio alla rovescia del tempo rimanente.';
$string['timelimitnotenabled'] = 'Il compito non ha limite di tempo';
$string['timelimitpassed'] = 'Il limite di tempo è stato raggiunto';
$string['timemodified'] = 'Ultima modifica';
$string['timeremaining'] = 'Tempo rimasto';
$string['timeremainingcolon'] = 'Tempo rimasto: {$a}';
$string['togglezoom'] = 'Ingrandimento/riduzione della regione';
$string['ungroupedusers'] = 'L\'impostazione \'Consegna di gruppo obbligatoria\' è abilitata ma alcuni utenti non fanno parte di gruppi o fanno parte di più gruppi e pertanto non potranno effettuare consegne.';
$string['ungroupedusersoptional'] = 'L\'impostazione \'Consegna di gruppo\' è abilitata ma alcuni utenti non sono membri di nessun gruppo, o sono membri di più gruppi. Questi studenti consegnano come membri del \'Gruppo di default\'.';
$string['unlimitedattempts'] = 'Illimitati';
$string['unlimitedattemptsallowed'] = 'Consentiti tentativi illimitati.';
$string['unlimitedpages'] = 'Senza limite';
$string['unlocksubmissionforstudent'] = 'Consenti consegna dello studente (id={$a->id}, fullname={$a->fullname}).';
$string['unlocksubmissions'] = 'Sblocca consegne';
$string['unsavedchanges'] = 'Ci sono modifiche non salvate';
$string['unsavedchangesquestion'] = 'Ci sono modifiche ai feedback alle valutazioni che non sono stati salvati. Vuoi salvare prima di continuare?';
$string['updategrade'] = 'Aggiorna valutazione';
$string['updatetable'] = 'Salva ed aggiorna tabella';
$string['upgradenotimplemented'] = 'L\'aggiornamento non è implementato per il plugin ({$a->type} {$a->subtype})';
$string['userassignmentdefaults'] = 'Impostazioni predefinite del compito';
$string['userextensiondate'] = 'Proroga concessa fino a: {$a}';
$string['usergrade'] = 'Valutazione utente';
$string['useridlistnotcached'] = 'Le modifiche alle valutazioni NON sono state salvate poiché non è stato possibile determinare la consegna alla quale si riferivano.';
$string['useroverrides'] = 'Personalizzazioni individuali';
$string['useroverridesdeleted'] = 'Personalizzazioni individuali eliminate';
$string['usersnone'] = 'Nessuno studente può accedere al compito.';
$string['usersubmissioncannotberemoved'] = 'Non è possibile rimuovere la consegna di "{$a}"';
$string['userswhoneedtosubmit'] = 'Utenti che non hanno consegnato: {$a}';
$string['validmarkingworkflowstates'] = 'Stati validi per il flusso di lavoro della valutazione';
$string['viewadifferentattempt'] = 'Visualizza un tentativo differente';
$string['viewbatchmarkingallocation'] = 'Visualizza pagina assegnazione valutatori';
$string['viewbatchsetmarkingworkflowstate'] = 'Visualizza stati del flusso di lavoro della valutazione';
$string['viewfeedback'] = 'Visualizza feedback';
$string['viewfeedbackforuser'] = 'Visualizza feedback per l\'utente: {$a}';
$string['viewfull'] = 'Visualizza tutto';
$string['viewfullgradingpage'] = 'Apri la pagina della valutazione per rilasciare commenti';
$string['viewgradebook'] = 'Visualizza registro valutatore';
$string['viewgrader'] = 'Visualizza valutatore';
$string['viewgrading'] = 'Visualizza tutte le consegne';
$string['viewgradingformforstudent'] = 'Visualizza pagina di valutazione dello studente (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Visualizza la propria pagina di consegna';
$string['viewownsubmissionstatus'] = 'Visualizza la propria pagina di stato della consegna';
$string['viewrevealidentitiesconfirm'] = 'Visualizza pagina di conferma per rivelare l\'identità degli studenti';
$string['viewsubmission'] = 'Visualizza consegne';
$string['viewsubmissionforuser'] = 'Visualizza consegne dell\'utente {$a}';
$string['viewsubmissiongradingtable'] = 'Visualizza la tabella delle valutazioni delle consegne';
$string['viewsummary'] = 'Visualizza riepilogo';
$string['workflowfilter'] = 'Filtro flusso di lavoro';
$string['xofy'] = '{$a->x} su {$a->y}';
