<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_ldap', language 'lo', version '5.0'.
 *
 * @package     enrol_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['assignrole'] = 'ການມອບໝາຍໜ້າທີ່ \'{$a->role_shortname}\' ໃຫ້ກັບຜູ້ໃຊ້ \'{$a->user_username}\' ໃນລາຍວິຊາ \'{$a->course_shortname}\' (id {$a->course_id})';
$string['assignrolefailed'] = 'ລົ້ມເຫຼວໃນການມອບໝາຍບົດບາດ \'{$a->role_shortname}\' ໃຫ້ກັບຜູ້ໃຊ້ \'{$a->user_username}\' ໃນຫຼັກສູດ \'{$a->course_shortname}\' (id {$a->course_id})';
$string['autocreate'] = '<p>ລາຍວິຊາສາມາດສ້າງໄດ້ໂດຍອັດຕະໂນມັດ ຖ້າມີການລົງທະບຽນຮຽນລາຍວິຊາທີ່ຍັງບໍ່ທັນມີຢູ່ໃນ Moodle</p><p>ຖ້າທ່ານໃຊ້ການສ້າງຫຼັກສູດອັດຕະໂນມັດ, ຂໍແນະນຳໃຫ້ທ່ານຖອດຄວາມສາມາດຕໍ່ໄປນີ້ອອກ: moodle/ course:changeidnumber, moodle/course:changeshortname, moodle/course:changefullname ແລະ moodle/course:changesummary, ຈາກໜ້າທີ່ກ່ຽວຂ້ອງ ເພື່ອປ້ອງກັນການດັດແປງສີ່ລາຍວິຊາທີ່ລະບຸໄວ້ຂ້າງເທິງ (ໝາຍເລກປະຈຳຕົວ, ຊື່ຫຍໍ້, ຊື່ເຕັມ ແລະ ບົດສະຫຼຸບ).</p >';
$string['autocreate_key'] = 'ສ້າງອັດຕະໂນມັດ';
$string['autocreation_settings'] = 'ການຕັ້ງຄ່າການສ້າງລາຍວິຊາອັດຕະໂນມັດ';
$string['autoupdate_settings'] = 'ການຕັ້ງຄ່າການປັບປຸງລາຍວິຊາອັດຕະໂນມັດ';
$string['autoupdate_settings_desc'] = '<p>ເລືອກຊ່ອງຂໍ້ມູນເພື່ອປັບປຸງເມື່ອໜ້າວຽກທີ່ກຳນົດເວລາ \'Synchronise LDAP\' ແລ່ນຢູ່.</p><p>ເມື່ອເລືອກຢ່າງໜ້ອຍໜຶ່ງຊ່ອງຂໍ້ມູນການປັບປຸງຈະເກີດຂຶ້ນ.</p>';
$string['bind_dn'] = 'ຖ້າທ່ານຕ້ອງການໃຊ້ຜູ້ໃຊ້ທີ່ຜູກມັດເພື່ອຄົ້ນຫາຜູ້ໃຊ້, ໃຫ້ລະບຸມັນຢູ່ທີ່ນີ້. ບາງສິ່ງບາງຢ່າງເຊັ່ນ: \'cn=ldapuser,ou=public,o=org\'';
$string['bind_dn_key'] = 'ຜູກມັດຊື່ຈໍາແນກຜູ້ໃຊ້';
$string['bind_pw'] = 'ລະຫັດຜ່ານສໍາລັບຜູ້ໃຊ້ຜູກມັດ';
$string['bind_pw_key'] = 'ລະຫັດຜ່ານ';
$string['bind_settings'] = 'ການຕັ້ງຄ່າຜູກມັດ';
$string['cannotcreatecourse'] = 'ບໍ່ສາມາດສ້າງລາຍວິຊາ: ບໍ່ມີຂໍ້ມູນທີ່ຕ້ອງການຈາກບັນທຶກ LDAP!';
$string['cannotupdatecourse'] = 'ບໍ່ສາມາດປັບປຸງລາຍວິຊາ: ບໍ່ມີຂໍ້ມູນທີ່ຕ້ອງການຈາກບັນທຶກ LDAP! ໝາຍເລກປະຈຳຕົວລາຍວິຊາ: \'{$a->idnumber}\'';
$string['cannotupdatecourse_duplicateshortname'] = 'ບໍ່ສາມາດປັບປຸງລາຍວິຊາໄດ້: ຊື່ຫຍໍ້ຊໍ້າກັນ. ຂ້າມລາຍວິຊາດ້ວຍໝາຍເລກປະຈຳຕົວ \'{$a->idnumber}\'...';
$string['category'] = 'ປະເພດສຳລັບລາຍວິຊາທີ່ສ້າງໂດຍອັດຕະໂນມັດ';
$string['category_key'] = 'ປະເພດ';
$string['contexts'] = 'ບໍລິບົດ LDAP';
$string['couldnotfinduser'] = 'ບໍ່ສາມາດຊອກຫາຜູ້ໃຊ້ \'{$a}\', ຂ້າມໄປ';
$string['course_fullname'] = 'ທາງເລືອກ: ຄຸນສົມບັດ LDAP ເພື່ອເອົາຊື່ເຕັມຈາກ';
$string['course_fullname_key'] = 'ຊື່ເຕັມ';
$string['course_fullname_updateonsync'] = 'ປັບປຸງຊື່ເຕັມໃນລະຫວ່າງການເຊື່ອມປະສານສະຄຣິບ';
$string['course_fullname_updateonsync_key'] = 'ປັບປຸງຊື່ເຕັມ';
$string['course_idnumber'] = 'ຄຸນລັກສະນະ LDAP ເພື່ອເອົາເລກລະຫັດປະຈຳຕົວຂອງລາຍວິຊາຈາກ. ປົກກະຕິແລ້ວ \'cn\' ຫຼື \'uid\'.';
$string['course_idnumber_key'] = 'ໝາຍເລກລະຫັດປະຈຳຕົວ';
$string['course_search_sub'] = 'ຊອກຫາສະມາຊິກກຸ່ມຈາກບໍລິບົດຍ່ອຍ';
$string['course_search_sub_key'] = 'ຊອກຫາບໍລິບົດຍ່ອຍ';
$string['course_settings'] = 'ການຕັ້ງຄ່າການລົງທະບຽນຮຽນລາຍວິຊາ';
$string['course_shortname'] = 'ທາງເລືອກ: ຄຸນສົມບັດ LDAP ເພື່ອເອົາຊື່ຫຍໍ້ມາຈາກ';
$string['course_shortname_key'] = 'ຊື່ຫຍໍ້';
$string['course_shortname_updateonsync'] = 'ປັບປຸງຊື່ຫຍໍ້ໃນລະຫວ່າງການເຊື່ອມປະສານສະຄຣິບ';
$string['course_shortname_updateonsync_key'] = 'ປັບປຸງຊື່ຫຍໍ້';
$string['course_summary'] = 'ທາງເລືອກ: ຄຸນສົມບັດ LDAP ເພື່ອເອົາບົດສະຫຼຸບຈາກ';
$string['course_summary_key'] = 'ບົດສະຫຼຸບ';
$string['course_summary_updateonsync'] = 'ປັບປຸງບົດສະຫຼຸບໃນລະຫວ່າງການການເຊື່ອມປະສານສະຄຣິບ';
$string['course_summary_updateonsync_key'] = 'ປັບປຸງບົດສະຫຼຸບ';
$string['coursenotexistskip'] = 'ລາຍວິຊາ \'{$a}\' ບໍ່ມີຢູ່ ແລະ ການສ້າງອັດຕະໂນມັດຖືກປິດໃຊ້ງານ, ຂ້າມໄປ';
$string['courseupdated'] = 'ລາຍວິຊາທີ່ມີ idnumber \'{$a->idnumber}\' ໄດ້ຖືກປັບປຸງສຳເລັດແລ້ວ.';
$string['courseupdateskipped'] = 'ລາຍວິຊາທີ່ມີ idnumber \'{$a->idnumber}\' ບໍ່ຈໍາເປັນຕ້ອງມີການປັບປຸງ. ຂ້າມໄປ...';
$string['createcourseextid'] = 'ສ້າງຜູ້ໃຊ້ທີ່ລົງທະບຽນເຂົ້າລາຍວິຊາທີ່ບໍ່ມີຢູ່ແລ້ວ \'{$a->courseextid}\'';
$string['createnotcourseextid'] = 'ຜູ້ໃຊ້ລົງທະບຽນເຂົ້າຫຼັກສູດທີ່ບໍ່ມີຢູ່ແລ້ວ \'{$a->courseextid}\'';
$string['creatingcourse'] = 'ກຳລັງສ້າງລາຍວິຊາ \'{$a}\'...';
$string['duplicateshortname'] = 'ການສ້າງລາຍວິຊາລົ້ມເຫຼວ. ຊື່ຫຍໍ້ຊໍ້າກັນ. ຂ້າມລາຍວິຊາດ້ວຍໝາຍເລກປະຈຳຕົວ \'{$a->idnumber}\'...';
$string['editlock'] = 'ຄ່າລັອກ';
$string['emptyenrolment'] = 'ການລົງທະບຽນຫວ່າງເປົ່າສຳລັບໜ້າທີ່ \'{$a->role_shortname}\' ໃນລາຍວິຊາ \'{$a->course_shortname}\'';
$string['enrolname'] = 'LDAP';
$string['enroluser'] = 'ລົງທະບຽນຜູ້ໃຊ້ \'{$a->user_username}\' ເຂົ້າຫຼັກສູດ \'{$a->course_shortname}\' (id {$a->course_id})';
$string['enroluserenable'] = 'ເປີດໃຊ້ການລົງທະບຽນສຳລັບຜູ້ໃຊ້ \'{$a->user_username}\' ໃນລາຍວິຊາ \'{$a->course_shortname}\' (id {$a->course_id})';
$string['explodegroupusertypenotsupported'] = 'ldap_explode_group() ບໍ່ຮອງຮັບປະເພດຜູ້ໃຊ້ທີ່ເລືອກ: {$a}';
$string['extcourseidinvalid'] = 'ID ພາຍນອກລາຍວິຊາບໍ່ຖືກຕ້ອງ!';
$string['extremovedsuspend'] = 'ປິດການລົງທະບຽນຮຽນສຳລັບຜູ້ໃຊ້ \'{$a->user_username}\' ໃນຫຼັກສູດ \'{$a->course_shortname}\' (id {$a->course_id})';
$string['extremovedsuspendnoroles'] = 'ປິດການລົງທະບຽນຮຽນ ແລະ ລຶບບົດບາດສຳລັບຜູ້ໃຊ້ \'{$a->user_username}\' ໃນຫຼັກສູດ \'{$a->course_shortname}\' (id {$a->course_id})';
$string['extremovedunenrol'] = 'ຍົກເລີກການລົງທະບຽນຮຽນຜູ້ໃຊ້ \'{$a->user_username}\' ຈາກຫຼັກສູດ \'{$a->course_shortname}\' (id {$a->course_id})';
$string['failed'] = 'ລົ້ມເຫຼວ!';
$string['general_options'] = 'ທາງເລືອກທົ່ວໄປ';
$string['group_memberofattribute'] = 'ຊື່ຂອງຄຸນສົມບັດທີ່ລະບຸວ່າກຸ່ມຜູ້ໃຊ້ ຫຼື ກຸ່ມໃດເປັນຂອງ (ເຊັ່ນ: memberOf, groupMembership, ແລະອື່ນໆ)';
$string['group_memberofattribute_key'] = 'ຄຸນສົມບັດ \'ສະມາຊິກ\'';
$string['host_url'] = 'ລະບຸເຈົ້າພາບ LDAP ໃນຮູບແບບ URL ເຊັ່ນ \'ldap://ldap.myorg.com/\' ຫຼື \'ldaps://ldap.myorg.com/\'';
$string['host_url_key'] = 'URL ເຈົ້າພາບ';
$string['idnumber_attribute'] = 'ຖ້າການເປັນສະມາຊິກກຸ່ມມີຊື່ທີ່ໂດດເດັ່ນ, ໃຫ້ລະບຸຄຸນສົມບັດດຽວກັນກັບທີ່ທ່ານເຄີຍໃຊ້ສຳລັບການສ້າງແຜນທີ່ຜູ້ໃຊ້ \'ໝາຍເລກລະຫັດປະຈຳຕົວ\' ໃນການຕັ້ງຄ່າການພິສູດຢືນຢັນຂອງ LDAP.';
$string['idnumber_attribute_key'] = 'ໝາຍເລກລະຫັດປະຈຳຕົວຄຸນສົມບັດ';
$string['ignorehiddencourses'] = 'ບໍ່ສົນໃຈລາຍວິຊາທີ່ເຊື່ອງໄວ້';
$string['ignorehiddencourses_desc'] = 'ຖ້າຜູ້ໃຊ້ເປີດໃຊ້ງານ ຈະບໍ່ຖືກລົງທະບຽນໃນລາຍວິຊາທີ່ຕັ້ງໃຫ້ນັກຮຽນບໍ່ມີໃຫ້.';
$string['ldap:manage'] = 'ຈັດການຕົວຢ່າງການລົງທະບຽນຮຽນ LDAP';
$string['ldap_encoding'] = 'ລະບຸການເຂົ້າລະຫັດທີ່ໃຊ້ໂດຍເຊີບເວີ LDAP. ສ່ວນຫຼາຍອາດຈະເປັນ utf-8, MS AD v2 ໃຊ້ການເຂົ້າລະຫັດຖານເລີ່ມຕົ້ນເຊັ່ນ cp1252, cp1250, ແລະອື່ນໆ.';
$string['ldap_encoding_key'] = 'ການເຂົ້າລະຫັດ LDAP';
$string['memberattribute'] = 'ຄຸນລັກສະນະສະມາຊິກ LDAP';
$string['memberattribute_isdn'] = 'ຖ້າສະມາຊິກກຸ່ມມີຊື່ທີ່ໂດດເດັ່ນ, ທ່ານຈໍາເປັນຕ້ອງລະບຸພວກມັນຢູ່ທີ່ນີ້. ຖ້າເປັນດັ່ງນັ້ນ, ທ່ານຍັງຈໍາເປັນຕ້ອງໄດ້ກໍານົດການຕັ້ງຄ່າທີ່ຍັງເຫຼືອຢູ່ໃນພາກນີ້.';
$string['memberattribute_isdn_key'] = 'ຄຸນສົມບັດສະມາຊິກໃຊ້ dn';
$string['nested_groups'] = 'ທ່ານຕ້ອງການນໍາໃຊ້ກຸ່ມທັບຊ້ອນ (ກຸ່ມຂອງກຸ່ມ) ສໍາລັບການລົງທະບຽນບໍ?';
$string['nested_groups_key'] = 'ກຸ່ມທັບຊ້ອນ';
$string['nested_groups_settings'] = 'ການຕັ້ງຄ່າກຸ່ມທັບຊ້ອນ';
$string['nosuchrole'] = 'ບໍ່ມີໜ້າທີ່ດັ່ງກ່າວ: \'{$a}\'';
$string['objectclass'] = 'objectClass ໃຊ້ເພື່ອຄົ້ນຫາວິຊາຕ່າງໆ. ປົກກະຕິແລ້ວ \'ກຸ່ມ\' ຫຼື \'posixGroup\'';
$string['objectclass_key'] = 'ປະເພດວັດຖຸ';
$string['ok'] = 'ຕົກລົງ!';
$string['opt_deref'] = 'ຖ້າສະມາຊິກກຸ່ມມີຊື່ທີ່ໂດດເດັ່ນ, ໃຫ້ລະບຸວິທີການຈັດການກັບນາມແຝງໃນລະຫວ່າງການຄົ້ນຫາ. ເລືອກໜຶ່ງໃນຄ່າຕໍ່ໄປນີ້: \'ບໍ່\' (LDAP_DEREF_NEVER) ຫຼື \'ແມ່ນ\' (LDAP_DEREF_ALWAYS).';
$string['opt_deref_key'] = 'ການອ້າງອິງນາມແຜງ';
$string['phpldap_noextension'] = 'ໂມດູນ PHP LDAP ເບິ່ງຄືວ່າບໍ່ມີຢູ່. ກະລຸນາກວດສອບວ່າມັນຖືກຕິດຕັ້ງ ແລະ ເປີດໃຊ້ງານຫາກທ່ານຕ້ອງການໃຊ້ປລັກອິນການລົງທະບຽນນີ້.';
$string['pluginname'] = 'ການລົງທະບຽນຮຽນ LDAP';
$string['pluginname_desc'] = '<p>ທ່ານສາມາດໃຊ້ເຊີບເວີ LDAP ເພື່ອຄວບຄຸມການລົງທະບຽນຮຽນຂອງທ່ານ. ມັນສົມມຸດວ່າຕົ້ນໄມ້ LDAP ຂອງທ່ານ ມີກຸ່ມທີ່ສ້າງແຜນທີ່ກັບລາຍວິຊາ, ແລະແຕ່ລະກຸ່ມ/ຫຼັກສູດເຫຼົ່ານັ້ນ ຈະມີລາຍການສະມາຊິກເພື່ອເຮັດແຜນທີ່ໃຫ້ກັບນັກຮຽນ.</p><p>ສົມມຸດວ່າລາຍວິຊາ ແມ່ນຖືກກໍານົດເປັນກຸ່ມໃນ LDAP, ໂດຍແຕ່ລະກຸ່ມທີ່ມີຫຼາຍຊ່ອງໃສ່ການສະມາຊິກ (<em>ສະມາຊິກ</em> ຫຼື <em>memberUid</em>) ທີ່ມີການລະບຸຕົວຕົນຂອງຜູ້ໃຊ້ເປັນເອກະລັກ.</p><p>ເພື່ອນໍາໃຊ້ການລົງທະບຽນ LDAP, ຜູ້ໃຊ້ຂອງທ່ານ <strong >ຕ້ອງ</strong> ມີຊ່ອງໃສ່ລະຫັດທີ່ຖືກຕ້ອງ. ກຸ່ມ LDAP ຕ້ອງມີໝາຍເລກນັ້ນຢູ່ໃນຊ່ອງສະມາຊິກເພື່ອໃຫ້ຜູ້ໃຊ້ລົງທະບຽນໃນລາຍວິຊາ. ໂດຍປົກກະຕິແລ້ວ ອັນນີ້ຈະເຮັດວຽກໄດ້ດີຫາກທ່ານກຳລັງໃຊ້ LDAP Authentication ຢູ່ກ່ອນແລ້ວ.</p><p>ການລົງທະບຽນຈະຖືກປັບປຸງເມື່ອຜູ້ໃຊ້ເຂົ້າສູ່ລະບົບ. ນອກຈາກນັ້ນ, ທ່ານຍັງສາມາດເອີ້ນໃຊ້ສະຄຣິບເພື່ອສືບຕໍ່ການລົງທະບຽນໄດ້. ເບິ່ງໃນ <em>enrol/ldap/cli/sync.php</em>.</p><p>ປລັກອິນນີ້ສາມາດຖືກຕັ້ງໃຫ້ສ້າງຫຼັກສູດໃໝ່ໂດຍອັດຕະໂນມັດເມື່ອກຸ່ມໃໝ່ປາກົດຢູ່ໃນ LDAP.</p>';
$string['pluginnotenabled'] = 'ປລັກອິນບໍ່ໄດ້ເປີດໃຊ້!';
$string['privacy:metadata'] = 'ປລັກອິນການລົງທະບຽນ LDAP ບໍ່ໄດ້ເກັບຮັກສາຂໍ້ມູນສ່ວນຕົວໃດໆ.';
$string['role_mapping'] = '<p>ສຳລັບແຕ່ລະບົດບາດ, ເຈົ້າຕ້ອງລະບຸບໍລິບົດ LDAP ທັງໝົດທີ່ກຸ່ມທີ່ເປັນຕົວແທນຂອງຫຼັກສູດຢູ່. ແຍກບໍລິບົດຕ່າງໆດ້ວຍເຄື່ອງໝາຍຈຸດ (;).</p><p>ທ່ານຍັງຕ້ອງລະບຸຄຸນສົມບັດທີ່ເຊີບເວີ LDAP ຂອງທ່ານໃຊ້ເພື່ອຖືສະມາຊິກຂອງກຸ່ມ. ນີ້ປົກກະຕິແລ້ວແມ່ນ \'ສະມາຊິກ\' ຫຼື \'memberUid\'.</p>';
$string['role_mapping_attribute'] = 'ຄຸນສົມບັດສະມາຊິກ LDAP ສໍາລັບ {$a}';
$string['role_mapping_context'] = 'ບໍລິບົດ LDAP ສໍາລັບ {$a}';
$string['role_mapping_key'] = 'ໜ້າທີ່ແຜນທີ່ຈາກ LDAP';
$string['roles'] = 'ການສ້າງແຜນທີ່ໜ້າທີ່';
$string['server_settings'] = 'ການຕັ້ງຄ່າເຊີເວີ LDAP';
$string['synccourserole'] = '== ການຊິ້ງຂໍ້ມູນລາຍວິຊາ \'{$a->idnumber}\' ສຳລັບໜ້າທີ່ \'{$a->role_shortname}\'';
$string['syncenrolmentstask'] = 'ການຊິ້ງຂໍ້ມູນໜ້າວຽກການລົງທະບຽນຮຽນ LDAP';
$string['template'] = 'ທາງເລືອກ: ຫຼັກສູດທີ່ສ້າງໂດຍອັດຕະໂນມັດສາມາດສຳເນົາການຕັ້ງຄ່າຂອງພວກເຂົາຈາກລາຍວິຊາແມ່ແບບ';
$string['template_key'] = 'ແມ່ແບບ';
$string['unassignrole'] = 'ການຍົກເລີກການມອບໝາຍບົດບາດ \'{$a->role_shortname}\' ໃຫ້ກັບຜູ້ໃຊ້ \'{$a->user_username}\' ຈາກຫຼັກສູດ \'{$a->course_shortname}\' (id {$a->course_id})';
$string['unassignrolefailed'] = 'ລົ້ມເຫຼວໃນການຍົກເລີກການມອບໝາຍບົດບາດ \'{$a->role_shortname}\' ໃຫ້ກັບຜູ້ໃຊ້ \'{$a->user_username}\' ຈາກຫຼັກສູດ \'{$a->course_shortname}\' (id {$a->course_id})';
$string['unassignroleid'] = 'ການຍົກເລີກການມອບໝາຍລະຫັດປະຈຳຕົວບົດບາດ \'{$a->role_id}\' ຫາລະຫັດປະຈຳຕົວຜູ້ໃຊ້ \'{$a->user_id}\'';
$string['updatelocal'] = 'ປັບປຸງຂໍ້ມູນໃນເຄື່ອງ';
$string['user_attribute'] = 'ຖ້າສະມາຊິກກຸ່ມມີຊື່ທີ່ໂດດເດັ່ນ, ໃຫ້ລະບຸຄຸນສົມບັດທີ່ໃຊ້ເພື່ອຕັ້ງຊື່/ຊອກຫາຜູ້ໃຊ້. ຖ້າທ່ານກໍາລັງໃຊ້ການພິສູດຢືນຢັນ LDAP, ຄ່ານີ້ຄວນຈະກົງກັບຄຸນລັກສະນະທີ່ລະບຸໄວ້ໃນແຜນທີ່ \'ໝາຍເລກລະຫັດປະຈຳຕົວ\' ໃນປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງ LDAP.';
$string['user_attribute_key'] = 'ຄຸນສົມບັດໝາຍເລກລະຫັດປະຈຳຕົວ';
$string['user_contexts'] = 'ຖ້າສະມາຊິກກຸ່ມມີຊື່ທີ່ໂດດເດັ່ນ, ໃຫ້ລະບຸລາຍຊື່ຂອງບໍລິບົດທີ່ຜູ້ໃຊ້ຕັ້ງຢູ່. ແຍກບໍລິບົດທີ່ແຕກຕ່າງກັນດ້ວຍໝາຍຈໍ້າຈຸດ (;). ຕົວຢ່າງ: \'ou=users, o=org; ou=others,o=org\'.';
$string['user_contexts_key'] = 'ບໍລິບົດ';
$string['user_search_sub'] = 'ຖ້າສະມາຊິກຂອງກຸ່ມມີຊື່ທີ່ໂດດເດັ່ນ, ໃຫ້ລະບຸວ່າການຄົ້ນຫາຜູ້ໃຊ້ຖືກເຮັດຢູ່ໃນບໍລິບົດຍ່ອຍຄືກັນ.';
$string['user_search_sub_key'] = 'ຄົ້ນຫາບໍລິບົດຍ່ອຍ';
$string['user_settings'] = 'ການຕັ້ງຄ່າການຊອກຫາຜູ້ໃຊ້';
$string['user_type'] = 'ຖ້າສະມາຊິກກຸ່ມມີຊື່ທີ່ໂດດເດັ່ນ, ໃຫ້ລະບຸວິທີການເກັບຮັກສາຜູ້ໃຊ້ຢູ່ໃນ LDAP';
$string['user_type_key'] = 'ປະເພດຜູ້ໃຊ້';
$string['version'] = 'ສະບັບຂອງລະບຽບການ LDAP ເຊີເວີຂອງທ່ານກໍາລັງໃຊ້';
$string['version_key'] = 'ສະບັບ';
