<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'lo', version '5.0'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'ການປະຕິບັດ';
$string['add'] = 'ເພີ່ມລາຍການ';
$string['addcomment'] = 'ເພີ່ມຄຳເຫັນ';
$string['addtemplate'] = 'ເພີ່ມແມ່ແບບຂາເຂົ້າ';
$string['advancedsearch'] = 'ຄົນຫາຂັ້ນສູງ';
$string['allowcomments'] = 'ອະນຸຍາດຄຳເຫັນໃນລາຍການ';
$string['alttext'] = 'ຂໍ້ຄວາມທາງເລືອກ';
$string['approvalstatus'] = 'ການອະນຸມັດສະຖານະ';
$string['approve'] = 'ອະນຸມັດ';
$string['approved'] = 'ອະນຸມັດແລ້ວ';
$string['areacontent'] = 'ຊ່ອງຂໍ້ມູນ';
$string['ascending'] = 'ນ້ອຍຫາໃຫຍ່';
$string['asearchtemplate'] = 'ແມ່ແບບການຄົ້ນຫາຂັ້ນສູງ';
$string['atmaxentry'] = 'ທ່ານໄດ້ປ້ອນເຂົ້າຈຳນວນສູງສຸດຂອງລາຍການທີ່ອະນຸຍາດ!';
$string['authorfirstname'] = 'ຊື່ຜູ້ຂຽນ';
$string['authorlastname'] = 'ນາມສະກຸນຜູ້ຂຽນ';
$string['autogenallforms'] = 'ສ້າງແມ່ແບບເລີ່ມຕົ້ນທັງໝົດ';
$string['autolinkurl'] = 'URL ເຊື່ອມຕໍ່ອັດຕະໂນມັດ';
$string['availablefromdate'] = 'ມີໃຫ້ຈາກ';
$string['availabletags'] = 'ແທັກທີ່ມີໃຫ້';
$string['availabletags_help'] = 'ແທັກເປັນຕົວຍຶດບ່ອນຢູ່ໃນແມ່ແບບ, ເຊິ່ງຈະຖືກແທນທີ່ດ້ວຍຂໍ້ມູນ ຫຼື ລາຍການອື່ນ, ເຊັ່ນ: ສັນຍາລັກແກ້ໄຂ, ເມື່ອລາຍການຖືກແກ້ໄຂ ຫຼື ເບິ່ງແລ້ວ.

ຊ່ອງຂໍ້ມູນມີຮູບແບບ [[fieldname]]. ແທັກອື່ນທັງໝົດມີຮູບແບບ ##sometag##.

ພຽງແຕ່ແທັກທີ່ຢູ່ໃນລາຍການ "ແທັກທີ່ມີໃຫ້" ອາດຈະຖືກໃຊ້ສໍາລັບແມ່ແບບປັດຈຸບັນ.';
$string['availabletodate'] = 'ມີໃຫ້ທີ່';
$string['availabletodatevalidation'] = 'ມີໃຫ້ໃນປະຈຸບັນບໍ່ສາມາດເປັນກ່ອນທີ່ມີໃຫ້ຈາກວັນທີ.';
$string['bynameondate'] = 'ໂດຍ {$a->name} - {$a->date}';
$string['calendarend'] = '{$a} ປິດ';
$string['calendarstart'] = '{$a} ເປີດ';
$string['cancel'] = 'ຍົກເລີກ';
$string['cannotaccesspresentsother'] = 'ທ່ານບໍ່ອະນຸຍາດໃຫ້ເຂົ້າຫາການຕັ້ງຄ່າລ່ວງໜ້າຈາກຜູ້ໃຊ້ຜູ້ອື່ນ';
$string['cannotadd'] = 'ບໍ່ສາມາດເພີ່ມລາຍການ!';
$string['cannotdeletepreset'] = 'ການລຶບການຕັ້ງຄ່າລ່ວງໜ້າຜິດພາດ!';
$string['cannotoverwritepreset'] = 'ການຂຽນທັບຊ້ອນການຕັ້ງຄ່າລ່ວງໜ້າຜິດພາດ!';
$string['cannotunziptopreset'] = 'ບໍ່ສາມາດແຍກໄຟລ໌ໄປຫາລາຍການຕັ້ງຄ່າລ່ວງໜ້າ';
$string['checkbox'] = 'ກ່ອງໝາຍຖືກ';
$string['chooseexportfields'] = 'ເລື່ອກຊ່ອງຂໍ້ມູນທີ່ທ່ານຕ້ອງການສົ່ງອອກ';
$string['chooseexportformat'] = 'ເລືອກຮູບແບບທີ່ທ່ານຕ້ອງການສົ່ງອອກໄປ';
$string['chooseorupload'] = 'ເລືອກໄຟລ໌';
$string['closebeforeopen'] = 'ທ່ານໄດ້ລະບຸວັນທີສິ້ນສຸດກ່ອນວັນທີເລີ່ມຕົ້ນ';
$string['columns'] = 'ຖັນ';
$string['comment'] = 'ຄຳເຫັນ';
$string['commentdeleted'] = 'ລຶບຄຳເຫັນ';
$string['commentempty'] = 'ຄຳເຫັນຫວ່າງເປົ່າ';
$string['comments'] = 'ຄຳເຫັນ';
$string['commentsaved'] = 'ບັນທຶກຄຳເຫັນແລ້ວ';
$string['commentsn'] = '{$a} ຄຳເຫັນ';
$string['commentsoff'] = 'ຄຸນສົມບັດຄຳເຫັນບໍ່ຖືກເປີດໃຊ້ງານ';
$string['completiondetail:entries'] = 'ສ້າງລາຍການ: {$a}';
$string['completionentriescount'] = 'ຈຳນວນລາຍການ';
$string['completionentriesdesc'] = 'ຈຳນວນຕ່ຳສຸດຂອງລາຍການທີ່ຕ້ອງການ: {$a}';
$string['configenablerssfeeds'] = 'ສະຫຼັບນີ້ຈະເປີດໃຊ້ຄວາມເປັນໄປໄດ້ຂອງຟີດ RSS ສໍາລັບຖານຂໍ້ມູນທັງໝົດ. ທ່ານຍັງຈະຕ້ອງໄດ້ເປີດຟີດດ້ວຍຕົນເອງຢູ່ໃນການຕັ້ງຄ່າສໍາລັບແຕ່ລະຖານຂໍ້ມູນ.';
$string['confirmdeletefield'] = 'ທ່ານແນ່ໃຈບໍ ທ່ານກຳລັງຈະລຶບຊ່ອງຂໍ້ມູນນີ້?';
$string['confirmdeleterecord'] = 'ທ່ານແນ່ໃຈບໍວ່າທ່ານກຳລັງຈະລຶບລາຍການນີ້?';
$string['confirmdeleterecords'] = 'ທ່ານແນ່ໃຈບໍວ່າທ່ານກຳລັງຈະລຶບລາຍການເຫຼົ່ານີ້?';
$string['csstemplate'] = 'ແມ່ແບບ CSS';
$string['csvfailed'] = 'ບໍ່ສາມາດອ່ານຂໍ້ມູນດິບຈາກໄຟລ໌ CSV';
$string['csvfile'] = 'ໄຟລ໌ CSV';
$string['csvimport'] = 'ນຳເຂົ້າໄຟລ໌ CSV';
$string['csvimport_help'] = 'ລາຍການອາດຈະຖືກນໍາເຂົ້າຜ່ານໄຟລ໌ຂໍ້ຄວາມທໍາມະດາທີ່ມີລາຍການຊື່ຂອງຊ່ອງຂໍ້ມູນເປັນແຖວທໍາອິດ, ຈາກນັ້ນເປັນຂໍ້ມູນ, ມີການບັນທຶກຕໍ່ແຖວ.';
$string['csvwithselecteddelimiter'] = '<abbr title="ມູນຄ່າແຍກດ້ວຍໝາຍຈຸດ">CSV</abbr>';
$string['data:addinstance'] = 'ເພີ່ມຖານຂໍ້ມູນໃໝ່';
$string['data:approve'] = 'ອະນຸຍາດ ແລະ ຍົກເລີກອະນຸມັດລາຍການ';
$string['data:comment'] = 'ຂຽນຄຳເຫັນ';
$string['data:exportallentries'] = 'ສົ່ງອອກລາຍການຖານຂໍ້ມູນທັງໝົດ';
$string['data:exportentry'] = 'ສົ່ງອອກລາຍການຖານຂໍ້ມູນ';
$string['data:exportownentry'] = 'ສົ່ງອອກລາຍການຖານຂໍ້ມູນຂອງຕົວເອງ';
$string['data:exportuserinfo'] = 'ສົ່ງຂໍ້ມູນຜູ້ໃຊ້';
$string['data:managecomments'] = 'ຈັດການຄຳເຫັນ';
$string['data:manageentries'] = 'ຈັດການລາຍການ';
$string['data:managetemplates'] = 'ຈັດການແມ່ແບບ';
$string['data:manageuserpresets'] = 'ຈັດການການຕັ້ງຄ່າາລ່ວງໜ້າຂອງແມ່ແບບທັງໝົດ';
$string['data:rate'] = 'ໃຫ້ຄະແນນລາຍການ';
$string['data:readentry'] = 'ອ່ານລາຍການ';
$string['data:view'] = 'ເບິ່ງກິດຈະກຳຖານຂໍ້ມູນ';
$string['data:viewallratings'] = 'ເບິ່ງການໃຫ້ຄະແນນດິບທັງໝົດທີ່ໃຫ້ໂດຍບຸກຄົນ';
$string['data:viewalluserpresets'] = 'ເບິ່ງການຕັ້ງຄ່າລ່ວງໜ້າຈາກຜູ້ໃຊ້ທັງໝົດ';
$string['data:viewanyrating'] = 'ເບິ່ງການໃຫ້ຄະແນນລວມທີ່ທຸກຄົນໄດ້ຮັບ';
$string['data:viewentry'] = 'ເບິ່ງລາຍການ';
$string['data:viewrating'] = 'ເບິ່ງການໃຫ້ຄະແນນລວມທີ່ທ່ານໄດ້ຮັບ';
$string['data:writeentry'] = 'ຂຽນລາຍການ';
$string['date'] = 'ວັນທີ';
$string['dateentered'] = 'ວັນທີປ້ອນເຂົ້າ';
$string['defaultfielddelimiter'] = '(ຄ່າເລີ່ມຕົ້ນແມ່ນຕົວອັກສອນໝາຍຈຸດ)';
$string['defaultfieldenclosure'] = '(ບໍ່ມີຄ່າເລີ່ມຕົ້ນ)';
$string['defaultsortfield'] = 'ຊ່ອງຂໍ້ມູນຈັດລຽງເປັນຄ່າເລີ່ມຕົ້ນ';
$string['delcheck'] = 'ກ່ອງໝາຍຖືກລຶບຈຳນວນຫຼາຍ';
$string['delete'] = 'ລຶບ';
$string['deleteallentries'] = 'ລຶບລາຍການທັງໝົດ';
$string['deletecomment'] = 'ທ່ານແນ່ໃຈບໍວ່າທ່ານຕ້ອງການລຶບຄຳເຫັນນີ້?';
$string['deleted'] = 'ລຶບແລ້ວ';
$string['deleteentry'] = 'ລຶບຂາເຂົ້າ';
$string['deletefield'] = 'ລຶບຊ່ອງຂໍ້ມູນ';
$string['deletenotenrolled'] = 'ລຶບລາຍການໂດຍຜູ້ໃຊ້ທີ່ບໍ່ໄດ້ລົງທະບຽນ';
$string['deletewarning'] = 'ທ່ານແນ່ໃຈບໍວ່າທ່ານຕ້ອງການລຶບການຕັ້ງຄ່າລ່ວງໜ້ານີ້?';
$string['descending'] = 'ນ້ອຍຫາໃຫຍ່';
$string['directorynotapreset'] = '{$a->directory} ບໍ່ແມ່ນການຕັ້ງຄ່າລ່ວງໜ້າ: ໄຟລ໌ຂາດຫາຍໄປ: {$a->missing_files}';
$string['disapprove'] = 'ຍົກເລີກການອະນຸມັດ';
$string['download'] = 'ດາວໂຫຼດ';
$string['edit'] = 'ແກ້ໄຂ';
$string['editcomment'] = 'ແກ້ໄຂຄຳເຫັນ';
$string['editentry'] = 'ແກ້ໄຂລາຍການ';
$string['editfield'] = 'ແກ້ໄຂຊ່ອງຂໍ້ມູນ';
$string['editordisable'] = 'ປິດໃຊ້ງານຕົວແກ້ໄຂ';
$string['editorenable'] = 'ເປີດໃຊ້ງານຕົວແກ້ໄຂ';
$string['emptyadd'] = 'ແມ່ແບບທີ່ເພີ່ມແມ່ນຫວ່າງເປົ່າ, ກຳລັງສ້າງແບບຟອມຄ່າເລີ່ມຕົ້ນ...';
$string['emptyaddform'] = 'ທ່ານບໍ່ໄດ້ຕື່ມຊ່ອງຂໍ້ມູນໃດໆ!';
$string['enabletemplateeditorcheck'] = 'ທ່ານແນ່ໃຈບໍວ່າທ່ານຕ້ອງການເປີດໃຊ້ງານຕົວແກ້ໄຂ? ສິ່ງນີ້ອາດຈະສົ່ງຜົນໃຫ້ເນື້ອໃນຖືກປ່ຽນແປງເມື່ອແມ່ແບບຖືກບັນທຶກໄວ້.';
$string['entries'] = 'ລາຍການ';
$string['entrieslefttoadd'] = 'ທ່ານຕ້ອງເພີ່ມລາຍການ {$a->entriesleft} ຕື່ມອີກເພື່ອຈະສຳເລັດກິດຈະກຳນີ້';
$string['entrieslefttoaddtoview'] = 'ທ່ານຕ້ອງເພີ່ມລາຍການ {$a->entrieslefttoview} ຕື່ມອີກກ່ອນທີ່ທ່ານຈະສາມາດເບິ່ງລາຍການຜູ້ເຂົ້າຮ່ວມອື່ນ.';
$string['entry'] = 'ລາຍການ';
$string['entrysaved'] = 'ລາຍການຂອງທ່ານໄດ້ບັນທຶກແລ້ວ';
$string['errormustbeteacher'] = 'ທ່ານຕ້ອງເປັນຄູສອນເພື່ອເບິ່ງໜ້ານີ້!';
$string['errormustsupplyvalue'] = 'ທ່ານຕ້ອງສະໜອງຄ່າຢູ່ທີ່ນີ້.';
$string['errorpresetexists'] = 'ມີການຕັ້ງຄ່າລ່ວງໜ້າຢູ່ແລ້ວກັບຊື່ທີ່ໄດ້ເລືອກ';
$string['eventfieldcreated'] = 'ສ້າງຊ່ອງຂໍ້ມູນແລ້ວ';
$string['eventfielddeleted'] = 'ລຶບຊ່ອງຂໍ້ມູນແລ້ວ';
$string['eventfieldupdated'] = 'ປັບປຸງຊ່ອງຂໍ້ມູນແລ້ວ';
$string['eventrecordcreated'] = 'ສ້າງບັນທຶກແລ້ວ';
$string['eventrecorddeleted'] = 'ລຶບບັນທຶກແລ້ວ';
$string['eventrecordupdated'] = 'ປັບປຸງບັນທຶກແລ້ວ';
$string['eventtemplateupdated'] = 'ປັບປຸງແມ່ແບບແລ້ວ';
$string['eventtemplateviewed'] = 'ເບິ່ງແມ່ແບບແລ້ວ';
$string['example'] = 'ຕົວຢ່າງຊຸກຖານຂໍ້ມູນ';
$string['excel'] = 'Excel';
$string['expired'] = 'ຂໍອະໄພ, ກິດຈະກຳນີ້ໄດ້ປິດໃນ {$a} ແລະ ບໍ່ມີໃຫ້ອີກຕໍ່ໄປ';
$string['export'] = 'ສົ່ງອອກ';
$string['exportaszip'] = 'ສົ່ງອອກເປັນໄຟລ໌ zip';
$string['exportaszip_help'] = 'ຄຸນສົມບັດການສົ່ງອອກເປັນໄຟລ໌ zip ຊ່ວຍໃຫ້ເຈົ້າສາມາດບັນທຶກແມ່ແບບ ແລະ ຊ່ອງຂໍ້ມູນເປັນ zip ທີ່ຕັ້ງໄວ້ລ່ວງໜ້າເພື່ອດາວໂຫຼດ. ຈາກນັ້ນໄຟລ໌ zip ອາດຈະຖືກນຳເຂົ້າໄປຫາຫຼັກສູດອື່ນ.';
$string['exportedtozip'] = 'ສົ່ອອກເປັນໄຟລ໌ zip ຊົ່ວຄາວແລ້ວ...';
$string['exportentries'] = 'ສົ່ງອອກລາຍການ';
$string['exportformat'] = 'ສົ່ງອອກຮູບແບບ';
$string['exportoptions'] = 'ສົ່ງອອກທາງເລືອກ';
$string['exportownentries'] = 'ສົ່ງອອກລາຍການຂອງທ່ານເອງເທົ່ານັ້ນ? ({$a->mine}/{$a->all})';
$string['exportpreset'] = 'ສົ່ງອອກການຕັ້ງຕ່າລ່ວງໜ້າ';
$string['failedpresetdelete'] = 'ການລຶບການຕັ້ງຕ່າລ່ວງໜ້າຜິດພາດ!';
$string['fieldadded'] = 'ເພີ່ມຊ່ອງຂໍ້ມູນແລ້ວ';
$string['fieldallowautolink'] = 'ອະນຸຍາດການເຊື່ອມຕໍ່ອັດຕະໂນມັດ';
$string['fielddeleted'] = 'ລຶບຊ່ອງຂໍ້ມູນແລ້ວ';
$string['fielddelimiter'] = 'ຕົວຂັ້ນຊ່ອງຂໍ້ມູນ';
$string['fielddescription'] = 'ລາຍລະອຽດຊ່ອງຂໍ້ມູນ';
$string['fieldenclosure'] = 'ການປິດຊ່ອງຂໍ້ມູນ';
$string['fieldheight'] = 'ຄວາມສູງ';
$string['fieldheightlistview'] = 'ຄວາມສູງໃນມຸມມອງລາຍການ';
$string['fieldheightsingleview'] = 'ຄວາມສູງໃນມຸມມອງດ່ຽວ';
$string['fieldmappings'] = 'ການສ້າງແຜນທີ່ຊ່ອງຂໍ້ມູນ';
$string['fieldmappings_help'] = 'ເມນູນີ້ອະນຸຍາດໃຫ້ທ່ານເກັບຂໍ້ມູນຈາກຖານຂໍ້ມູນທີ່ມີຢູ່. ເພື່ອປົກປັກຮັກສາຂໍ້ມູນຢູ່ໃນຊ່ອງຂໍ້ມູນ, ທ່ານຕ້ອງໄດ້ເຮັດແຜນທີ່ມັນກັບຊ່ອງຂໍ້ມູນໃຫມ່, ບ່ອນທີ່ຂໍ້ມູນຈະປາກົດຂຶ້ນ. ຊ່ອງຂໍ້ມູນໃດໜຶ່ງກໍ່ສາມາດປະຫວ່າງໄວ້ໄດ້, ໂດຍບໍ່ມີການສຳເນົາຂໍ້ມູນໃສ່ໃນມັນ. ຊ່ອງຂໍ້ມູນເກົ່າໃດໆທີ່ບໍ່ໄດ້ເຮັດແຜນທີ່ໃສ່ບ່ອນໃໝ່ຈະສູນຫາຍໄປ ແລະ ຂໍ້ມູນທັງໝົດຂອງມັນຈະຖືກລຶບອອກ.
ທ່ານສາມາດເຮັດແຜນທີ່ຊ່ອງຂໍ້ມູນທີ່ມີປະເພດດຽວກັນໄດ້, ດັ່ງນັ້ນແຕ່ລະເມນູແບບເລື່ອນລົງຈະມີຊ່ອງຂໍ້ມູນຕ່າງໆຢູ່ໃນນັ້ນ. ນອກຈາກນັ້ນ, ທ່ານຕ້ອງລະມັດລະວັງບໍ່ໃຫ້ພະຍາຍາມ ແລະ ສ້າງແຜນທີ່ຊ່ອງຂໍ້ມູນເກົ່າໃສ່ຫຼາຍຊ່ອງໃໝ່.';
$string['fieldname'] = 'ຊື່ຊ່ອງຂໍ້ມູນ';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'ຊ່ອງຂໍ້ມູນຕໍ່ໄປນີ້ໃນໄຟລ໌ຂອງທ່ານແມ່ນບໍ່ຮູ້ຈັກໃນຖານຂໍ້ມູນນີ້: {$a}';
$string['fieldoptions'] = 'ທາງເລືອກ (ໜຶ່ງຕໍ່ແຖວ)';
$string['fields'] = 'ຊ່ອງຂໍ້ມູນ';
$string['fieldsnavigation'] = 'ຊ່ອງຂໍ້ມູນການນໍາທາງຂັ້ນສູງສາມ';
$string['fieldupdated'] = 'ປັບປຸງຊ່ອງຂໍ້ມູນແລ້ວ';
$string['fieldwidth'] = 'ຄວາມກວ້າງ';
$string['fieldwidthlistview'] = 'ຄວາມກວ້າງໃນມຸມມອງລາຍການ';
$string['fieldwidthsingleview'] = 'ຄວາມກວ້າງໃນມຸມມອງດ່ຽວ';
$string['file'] = 'ໄຟລ໌';
$string['fileencoding'] = 'ການເຂົ້າລະຫັດ';
$string['filesnotgenerated'] = 'ບໍ່ໄດ້ສ້າງໄຟລ໌ທັງໝົດ: {$a}';
$string['filtername'] = 'ການເຊື່ອມຕໍ່ອັດຕະໂນມັດຂອງຖານຂໍ້ມູນ';
$string['footer'] = 'ສ່ວນທ້າຍສຸດ';
$string['forcelinkname'] = 'ຊື່ບັງຄັບສຳລັບລິ້ງ';
$string['foundnorecords'] = 'ບໍ່ພົບບັນທຶກ (<a href="{$a->reseturl}">ຕັ້ງຄ່າຕົວກັ່ນຕອງຄືນໃໝ່</a>)';
$string['foundrecords'] = 'ພົບບັນທຶກ: {$a->num}/{$a->max} (<a href="{$a->reseturl}">ຕັ້ງຄ່າຕົວກັ່ນຕອງຄືນໃໝ່</a>)';
$string['fromfile'] = 'ນຳເຂົ້າຈາກໄຟລ໌ zip';
$string['fromfile_help'] = 'ຄຸນນະສົມບັດການນໍາເຂົ້າຈາກໄຟລ໌ zip ຊ່ວຍໃຫ້ທ່ານສາມາດຊອກຫາ ແລະ ອັບໂຫຼດ zip ທີ່ຕັ້ງຄ່າລ່ວງໜ້າ ຂອງແມ່ແບບ ແລະ ຊ່ອງຂໍ້ມູນ.';
$string['generateerror'] = 'ບໍ່ໄດ້ສ້າງໄຟລ໌ທັງໝົດ!';
$string['header'] = 'ສ່ວນຫົວ';
$string['headeraddtemplate'] = 'ກຳນົດສ່ວນຕິດຕໍ່ສຳລັບການເພີ່ມ ຫຼື ການແກ້ໄຂລາຍການ';
$string['headerasearchtemplate'] = 'ກຳນົດສ່ວນຕິດຕໍ່ສຳລັບການຄົ້ນຫາຂັ້ນສູງ';
$string['headercsstemplate'] = 'ກຳນົດຮູບແບບ CSS ທ້ອງຖີ່ນສຳລັບແມ່ແບບອື່ນ';
$string['headerjstemplate'] = 'ກຳນົດ Javascript ແບບກຳນົດເອງສຳລັບການໝູນໃຊ້ວິທີການສະແດງອົງປະກອບໃນລາຍການ, ແບບດ່ຽວ ຫຼື ເພີ່ມແມ່ແບບ';
$string['headerlisttemplate'] = 'ກຳນົດການໂຕ້ຕອບຜົນການຊອກຫາສຳລັບຫຼາຍລາຍການ';
$string['headerrsstemplate'] = 'ກໍານົດລັກສະນະຂອງລາຍການໃນຟີດ RSS';
$string['headersingletemplate'] = 'ກໍານົດການໂຕ້ຕອບຜົນການຊອກຫາສໍາລັບການເຂົ້າລາຍການດຽວ';
$string['importentries'] = 'ນຳເຂົ້າລາຍການ';
$string['importpreset'] = 'ນຳເຂົ້າການຕັ້ງຄ່າລ່ວງໜ້າ';
$string['importsuccess'] = 'ໃຊ້ການຕັ້ງຄ່າລ່ວງໜ້າຢ່າງສຳເລັດ.';
$string['includeapproval'] = 'ລວມທັງສະຖານະການອະນຸມັດ';
$string['includetags'] = 'ລວມທັງແທັກ';
$string['includetime'] = 'ລວມທັງເວລາໄດ້ເພີ່ມ/ດັດແກ້';
$string['includeuserdetails'] = 'ລວມທັງລາຍລະອຽດຜູ້ໃຊ້';
$string['indicator:cognitivedepth'] = 'ຄວາມຮູ້ດ້ານຖານຂໍ້ມູນ';
$string['indicator:cognitivedepth_help'] = 'ຕົວຊີ້ວັດນີ້ ແມ່ນອີງໃສ່ຄວາມເຂົ້າໃຈເລິກເຊິ່ງຂອງນັກຮຽນໃນກິດຈະກໍາຖານຂໍ້ມູນ.';
$string['indicator:cognitivedepthdef'] = 'ຄວາມຮູ້ດ້ານຖານຂໍ້ມູນ';
$string['indicator:cognitivedepthdef_help'] = 'ຜູ້ເຂົ້າຮ່ວມໄດ້ບັນລຸອັດຕາສ່ວນຂອງການມີສ່ວນຮ່ວມທາງດ້ານຄວາມຮູ້ທີ່ສະເໜີໂດຍກິດຈະກໍາຖານຂໍ້ມູນໃນລະຫວ່າງໄລຍະການວິເຄາະນີ້ (ລະດັບ = ບໍ່ມີມຸມມອງ, ເບິ່ງ, ສົ່ງ)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'ສັງຄົມຖານຂໍ້ມູນ';
$string['indicator:socialbreadth_help'] = 'ຕົວຊີ້ວັດນີ້ ແມ່ນອີງໃສ່ຄວາມກວ້າງທາງສັງຄົມທີ່ນັກຮຽນເຂົ້າໃຈໃນກິດຈະກໍາຖານຂໍ້ມູນ.';
$string['indicator:socialbreadthdef'] = 'ສັງຄົມຖານຂໍ້ມູນ';
$string['indicator:socialbreadthdef_help'] = 'ຜູ້ເຂົ້າຮ່ວມໄດ້ບັນລຸອັດຕາສ່ວນຂອງການມີສ່ວນຮ່ວມທາງສັງຄົມທີ່ສະເໜີໂດຍກິດຈະກໍາຖານຂໍ້ມູນໃນລະຫວ່າງໄລຍະເວລາການວິເຄາະນີ້ (ລະດັບ = ບໍ່ມີການເຂົ້າຮ່ວມ, ຜູ້ເຂົ້າຮ່ວມເທົ່ານັ້ນ)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'ລາຍການເພີ່ມເຕີມທີ່ຕ້ອງການເພື່ອເບິ່ງຖານຂໍ້ມູນນີ້';
$string['intro'] = 'ຄຳອະທິບາຍ';
$string['invalidaccess'] = 'ໜ້ານີ້ບໍ່ໄດ້ເຂົ້າຫາຢ່າງຖືກຕ້ອງ';
$string['invalidfieldid'] = 'ລະຫັດປະຈຳຕົວຊ່ອງຂໍ້ມູນບໍ່ຖືກຕ້ອງ';
$string['invalidfieldname'] = 'ກະລຸນາເລືອກຊື່ອື່ນສຳລັບຊ່ອງຂໍ້ມູນນີ້';
$string['invalidfieldtype'] = 'ປະເພດຊ່ອງຂໍ້ມູນບໍ່ຖືກຕ້ອງ';
$string['invalidid'] = 'ລະຫັດປະຈຳຕົວຂໍ້ມູນບໍ່ຖືກຕ້ອງ';
$string['invalidpreset'] = '{$a} ບໍ່ແມ່ນການຕັ້ງຄ່າລ່ວງໜ້າ';
$string['invalidrecord'] = 'ບັນທຶກບໍ່ຖືກຕ້ອງ';
$string['invalidurl'] = 'URL ທີ່ທ່ານຫາກໍ່ປ້ອນເຂົ້າແມ່ນບໍ່ຖືກຕ້ອງ';
$string['jstemplate'] = 'ແມ່ແບບ Javascript';
$string['latitude'] = 'ເສັ້ນຂະໜານ';
$string['latlong'] = 'ເສັ້ນຂະໜານ/ເສັ້ນແວງ';
$string['latlongboth'] = 'ທັງເສັ້ນຂະໜານ ແລະ ເສັ້ນແວງແມ່ນຈຳເປັນ.';
$string['latlongdownloadallhint'] = 'ດາວໂຫຼດລິ້ງສຳລັບລາຍການທັງໝົດເປັນ KML';
$string['latlongkmllabelling'] = 'ວິທີໃສ່ປ້າຍລາຍການໃນໄຟລ໌ KML (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'ບໍລິການເຊື່ອມຕໍ່ອອກເພື່ອສະແດງ';
$string['latlongotherfields'] = 'ຊ່ອງຂໍ້ມູນອື່ນ';
$string['list'] = 'ລາຍການເບິ່ງ';
$string['listtemplate'] = 'ແມ່ແບບລາຍການ';
$string['listview'] = 'ເບິ່ງລາຍການ';
$string['longitude'] = 'ເສັ້ນແວງ';
$string['manageapproved'] = 'ອະນຸຍາດລາຍການທີ່ໄດ້ອະນຸຍາດ';
$string['manageapproved_help'] = 'ຖ້າປິດໃຊ້ງານ, ລາຍການທີ່ອະນຸມັດແລ້ວຈະບໍ່ສາມາດແກ້ໄຂ ຫຼື ລຶບໄດ້ໂດຍຜູ້ໃຊ້ທີ່ເພີ່ມພວກມັນເຂົ້າໄປ. ການຕັ້ງຄ່ານີ້ບໍ່ມີຜົນຖ້າວ່າ \'ການອະນຸມັດທີ່ຈຳເປັນ\' ເປີດໃຊ້ງານ.';
$string['managefields'] = 'ຈັດການຊ່ອງຂໍ້ມູນ';
$string['mapexistingfield'] = 'ແຜນທີ່ຫາ {$a}';
$string['mapnewfield'] = 'ສ້າງຊ່ອງຂໍ້ມູນໃໝ່';
$string['mappingwarning'] = 'ຊ່ອງຂໍ້ມູນເກົ່າທັງໝົດທີ່ບໍ່ໄດ້ສ້າງແຜນທີ່ໃສ່ຊ່ອງຂໍ້ມູນໃໝ່ຈະສູນເສຍໄປ ແລະ ຂໍ້ມູນທັງໝົດໃນຊ່ອງຂໍ້ມູນນັ້ນຈະຖືກລຶບອອກ.';
$string['maxentries'] = 'ຈຳນວນສູງສຸດຂອງລາຍການ';
$string['maxentries_help'] = 'ຈຳນວນລາຍການສູງສຸດທີ່ນັກຮຽນໄດ້ຮັບອະນຸຍາດໃຫ້ສົ່ງເຂົ້າຮ່ວມກິດຈະກຳນີ້.';
$string['maxsize'] = 'ຂະໜາດສູງສຸດ';
$string['menu'] = 'ເມນູ';
$string['menuchoose'] = 'ເລືອກ...';
$string['missingdata'] = 'ລະຫັດປະຈຳຕົວຂໍ້ມູນ ຫຼື ວັດຖຸຕ້ອງຖືກສະໜອງຫາປະເພດຊ່ອງຂໍ້ມູນ';
$string['missingfield'] = 'ຂໍ້ຜິດພາດຂອງໂປຼແກຼມເມີ: ທ່ານຕ້ອງລະບຸຊ່ອງຂໍ້ມູນ ແລະ/ຫຼື ຂໍ້ມູນເມື່ອກໍານົດປະເພດຊ່ອງຂໍ້ມູນ.';
$string['modulename'] = 'ຖານຂ້ມູນ';
$string['modulename_help'] = 'ຊຸດກິດຈະກໍາຖານຂໍ້ມູນ ຊ່ວຍໃຫ້ຜູ້ເຂົ້າຮ່ວມສາມາດສ້າງ, ຮັກສາ ແລະ ຄົ້ນຫາການເກັບກໍາຂໍ້ມູນ (ເຊັ່ນ: ບັນທຶກ). ໂຄງສ້າງຂອງລາຍການແມ່ນໄດ້ກໍານົດໂດຍຄູສອນເປັນຈໍານວນຊ່ອງຂໍ້ມູນ. ປະເພດຊ່ອງຂໍ້ມູນປະກອບມີກ່ອງເຄື່ອງໝາຍຖືກ, ປຸ່ມວິທະຍຸ, ເມນູເລື່ອນລົງ, ພື້ນທີ່ຂໍ້ຄວາມ, URL, ຮູບພາບ ແລະ ໄຟລ໌ທີ່ອັບໂຫຼດ.

ຮູບແບບການເບິ່ງເຫັນຂອງຂໍ້ມູນເມື່ອເຮັດລາຍການ, ການເບິ່ງ ຫຼື ການແກ້ໄຂລາຍການຖານຂໍ້ມູນອາດຈະຖືກຄວບຄຸມໂດຍແມ່ແບບຖານຂໍ້ມູນ. ກິດຈະກໍາຖານຂໍ້ມູນອາດຈະຖືກແບ່ງປັນລະຫວ່າງຫຼັກສູດຕາມທີ່ຕັ້ງໄວ້ລ່ວງໜ້າ ແລະ ຄູສອນຈະນໍາເຂົ້າ ແລະ ສົ່ງອອກລາຍການຖານຂໍ້ມູນ.

ຖ້າຕົວກັ່ນຕອງການເຊື່ອມຕໍ່ອັດຕະໂນມັດຂອງຖານຂໍ້ມູນຖືກເປີດໃຊ້ງານ, ລາຍການໃດໜຶ່ງຢູ່ໃນຖານຂໍ້ມູນຈະຖືກເຊື່ອມຕໍ່ໂດຍອັດຕະໂນມັດບ່ອນທີ່ຄໍາສັບ ຫຼື ປະໂຫຍກປາກົດຢູ່ພາຍໃນລາຍວິຊາ.

ຄູສອນສາມາດອະນຸຍາດໃຫ້ມີຄຳເຫັນຕໍ່ລາຍການ. ລາຍການຍັງສາມາດຖືກໃຫ້ຄະແນນໂດຍຄູສອນ ຫຼື ນັກຮຽນ (ການປະເມີນໂດຍເພື່ອນຮ່ວມຫ້ອງ). ການໃຫ້ຄະແນນສາມາດລວມເຂົ້າກັນເພື່ອເປັນຄະແນນສຸດທ້າຍເຊິ່ງຖືກບັນທຶກໄວ້ໃນປຶ້ມຄະແນນ.

ກິດຈະກໍາຖານຂໍ້ມູນມີການນໍາໃຊ້ຫຼາຍ, ເຊັ່ນ:

* ການເກັບກໍາການຮ່ວມມືຂອງລິ້ງເວັບໄຊທ໌, ປຶ້ມ, ການທົບທວນຄືນໜັງສື, ເອກະສານອ້າງອີງວາລະສານ ແລະ ອື່ນ
* ສໍາລັບການສະແດງຮູບພາບ, ໂປສເຕີ, ເວັບໄຊທ໌ ຫຼື ບົດກະວີທີ່ສ້າງໂດຍນັກຮຽນ, ເພື່ອໃຫ້ຄໍາເຫັນ ແລະ ທົບທວນຄືນແບບເພື່ອນ.';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'ຖານຂໍ້ມູນ';
$string['more'] = 'ເພີ່ມເຕີມ';
$string['moreurl'] = 'URL ເພີ່ມເຕີມ';
$string['movezipfailed'] = 'ບໍ່ສາມາດຍ້າຍໄຟລ໌ zip';
$string['multientry'] = 'ລາຍການຊ້ຳກັນ';
$string['multimenu'] = 'ເມນູ (ເລືອກຫຼາຍອັນ)';
$string['multipletags'] = 'ພົບແທກຫຼາຍອັນ! ບໍ່ໄດ້ບັນທຶກແມ່ແບບ';
$string['newentry'] = 'ລາຍການໃໝ່';
$string['newfield'] = 'ສ້າງຊ່ອງຂໍ້ມູນໃໝ່';
$string['newfield_help'] = 'ຊ່ອງຂໍ້ມູນອະນຸຍາດໃຫ້ປ້ອນຂໍ້ມູນເຂົ້າໄດ້. ແຕ່ລະລາຍການເຂົ້າໃນກິດຈະກໍາຖານຂໍ້ມູນສາມາດມີຊ່ອງຂໍ້ມູນຫຼາຍປະເພດໄດ້ເຊັ່ນ: ຊ່ອງຂໍ້ມູນວັນທີ, ເຊິ່ງອະນຸຍາດໃຫ້ຜູ້ເຂົ້າຮ່ວມສາມາດເລືອກວັນ, ເດືອນ ແລະ ປີຈາກເມນູແບບເລື່ອນລົງ, ຊ່ອງໃສ່ຮູບ, ເຊິ່ງອະນຸຍາດໃຫ້ຜູ້ເຂົ້າຮ່ວມອັບໂຫຼດໄຟລ໌ຮູບ ຫຼື ກ່ອງໝາຍຖືກ, ເຊິ່ງອະນຸຍາດໃຫ້ຜູ້ເຂົ້າຮ່ວມເລືອກໜຶ່ງ ຫຼື ຫຼາຍທາງເລືອກ.

ແຕ່ລະຊ່ອງຂໍ້ມູນຈະຕ້ອງມີຊື່ສະເພາະ. ຄໍາອະທິບາຍຊ່ອງຂໍ້ມູນແມ່ນທາງເລືອກ.';
$string['noaccess'] = 'ທ່ານບໍ່ໄດ້ເຂົ້າຫາໜ້ານີ້';
$string['nodefinedfields'] = 'ການຕັ້ງຄ່າລ່ວງໜ້າໃໝ່ບໍ່ມີຊ່ອງຂໍ້ມູນທີ່ຖືກກຳນົດ!';
$string['nofieldcontent'] = 'ບໍ່ພົບເນື້ອຫາຊ່ອງຂໍ້ມູນ';
$string['nofieldindatabase'] = 'ບໍ່ມີຊ່ອງຂໍ້ມູນຖືກກຳນົດສຳລັບຖານຂໍ້ມູນນີ້.';
$string['nolisttemplate'] = 'ແມ່ແບບລາຍການຍັງບໍ່ໄດ້ກຳນົດເທື່ອ';
$string['nomatch'] = 'ບໍ່ພົບລາຍການທີ່ກົງກັນ!';
$string['nomaximum'] = 'ບໍ່ມີສູງສຸດ';
$string['norecords'] = 'ບໍ່ມີລາຍການໃນຖານຂໍ້ມູນ';
$string['notapproved'] = 'ລາຍການຍັງບໍ່ໄດ້ບັນທຶກເທື່ອ.';
$string['notinjectivemap'] = 'ບໍ່ແມ່ນແຜນທີ່ແບບສີດ';
$string['notopenyet'] = 'ຂໍອະໄພ, ກິດຈະກຳນີ້ບໍ່ມີໃຫ້ຈົນກວ່າ {$a}';
$string['number'] = 'ໝາຍເລກ';
$string['numberrssarticles'] = 'ລາຍການເຂົ້າໃນຟີດ RSS';
$string['numnotapproved'] = 'ລໍຖ້າ';
$string['numrecords'] = '{$a} ລາຍການ';
$string['ods'] = '<abbr title="ສະເປຣດຊີດ OpenDocument">ODS</abbr>&nbsp;(OpenOffice)';
$string['openafterclose'] = 'ເຈົ້າໄດ້ລະບຸວັນທີເປີດຫຼັງຈາກວັນທີປິດ';
$string['optionaldescription'] = 'ລາຍລະອຽດຫຍໍ້ (ທາງເລືອກ)';
$string['optionalfilename'] = 'ຊື່ໄຟລ໌ (ທາງເລືອກ)';
$string['other'] = 'ອື່ນໆ';
$string['overrwritedesc'] = 'ຂຽນທັບການຕັ້ງຄ່າລ່ວງໜ້າຖ້າມັນມີຢູ່ແລ້ວ';
$string['overwrite'] = 'ຂຽນທັບ';
$string['overwritesettings'] = 'ຂຽນທັບການຕັ້ງຄ່າປະຈຸບັນ';
$string['page-mod-data-x'] = 'ໜ້າຊຸດກິດຈະກຳຖານຂໍ້ມູນໃດໜຶ່ງ';
$string['pagesize'] = 'ລາຍການຕໍ່ໜ້າ';
$string['participants'] = 'ຜູ້ເຂົ້າຮ່ວມ';
$string['picture'] = 'ຮູບພາບ';
$string['pluginadministration'] = 'ການບໍລິຫານກິດຈະກຳຖານຂໍ້ມູນ';
$string['pluginname'] = 'ຖານຂໍ້ມູນ';
$string['portfolionotfile'] = 'ສົ່ງອອກຜົນງານແທນທີ່ຈະເປັນໄຟລ໌ (csv ແລະ leap2a ເທົ່ານັ້ນ)';
$string['presetinfo'] = 'ການບັນທຶກເປັນການຕັ້ງຄ່າລ່ວງໜ້າຈະເຜີຍແຜ່ແມ່ແບບນີ້. ຜູ້ໃຊ້ຄົນອື່ນອາດຈະສາມາດໃຊ້ມັນຢູ່ໃນຖານຂໍ້ມູນຂອງເຂົາເຈົ້າ.';
$string['presetnotselected'] = 'ບໍ່ມີການຕັ້ງຄ່າລ່ວງໜ້າໄດ້ຖືກເລືອກ.';
$string['presets'] = 'ການຕັ້ງຄ່າລ່ວງໜ້າ';
$string['privacy:metadata:commentpurpose'] = 'ຄຳເຫັນເທິງບັນທຶກຖານຂໍ້ມູນ';
$string['privacy:metadata:data_content'] = 'ຕົວແທນໜຶ່ງຄຳຕອບຫາໜຶ່ງຊ່ອງຂໍ້ມູນໃນຖານຂໍ້ມູນໃນຊຸດກິດຈະກຳຖານຂໍ້ມູນ';
$string['privacy:metadata:data_content:content'] = 'ເນື້ອໃນ';
$string['privacy:metadata:data_content:content1'] = 'ເນື້ອໃນເພີ່ມເຕີມ 1';
$string['privacy:metadata:data_content:content2'] = 'ເນື້ອໃນເພີ່ມເຕີມ 2';
$string['privacy:metadata:data_content:content3'] = 'ເນື້ອໃນເພີ່ມເຕີມ 3';
$string['privacy:metadata:data_content:content4'] = 'ເນື້ອໃນເພີ່ມເຕີມ 4';
$string['privacy:metadata:data_content:fieldid'] = 'ລະຫັດປະຈຳຕົວຄວາມໝາຍຊ່ອງຂໍ້ມູນ';
$string['privacy:metadata:data_records'] = 'ເປັນຕົວແທນບັນທຶກໃນຊຸດກິດຈະກຳຖານຂໍ້ມູນ';
$string['privacy:metadata:data_records:approved'] = 'ສະຖານະການອະນຸມັດ';
$string['privacy:metadata:data_records:groupid'] = 'ກຸ່ມ';
$string['privacy:metadata:data_records:timecreated'] = 'ເວລາເມື່ອບັນທຶກຖືກສ້າງ';
$string['privacy:metadata:data_records:timemodified'] = 'ເວລາເມື່ອບັນທຶກຖືກດັດແກ້';
$string['privacy:metadata:data_records:userid'] = 'ຜູ້ໃຊ້ທີ່ໄດ້ສ້າງບັນທຶກ';
$string['privacy:metadata:datafieldnpluginsummary'] = 'ຊ່ອງຂໍ້ມູນສຳລັບຊຸດກິດຈະກຳຖານຂໍ້ມູນ';
$string['privacy:metadata:filepurpose'] = 'ໄຟລ໌ທີ່ຄັດຕິດຫາບັນທຶກຖານຂໍ້ມູນ';
$string['privacy:metadata:ratingpurpose'] = 'ການໃຫ້ຄະແນນເທິງບັນທຶກຖານຂໍ້ມູນ';
$string['privacy:metadata:tagpurpose'] = 'ແທັກເທິງບັນທຶກຖານຂໍ້ມູນ';
$string['radiobutton'] = 'ປຸ່ມວິທະຍຸ';
$string['recordapproved'] = 'ອະນຸຍາດລາຍການແລ້ວ';
$string['recorddeleted'] = 'ລຶບລາຍການແລ້ວ';
$string['recorddisapproved'] = 'ບໍ່ອະນຸຍາດລາຍການ';
$string['recordsnotsaved'] = 'ບໍ່ໄດ້ບັນທຶກລາຍການ. ກະລຸນາກວດສອບຮູບແບບການດາວໂຫຼດ.';
$string['recordssaved'] = 'ບັນທຶກລາຍການແລ້ວ';
$string['removealldatatags'] = 'ຍົກຍ້າຍແທັກຖານຂໍ້ມູນທັງໝົດ';
$string['requireapproval'] = 'ການອະນຸມັດທີ່ຈຳເປັນ';
$string['requireapproval_help'] = 'ຖ້າເປີດໃຊ້ງານ, ລາຍການທີ່ຕ້ອງການອະນຸມັດໂດຍຄູສອນກ່ອນເຂົາເຈົ້າສາມາດເບິ່ງໄດ້ໂດຍທຸກຄົນ.';
$string['required'] = 'ຈຳເປັນ';
$string['requiredentries'] = 'ລາຍການທີ່ຈຳເປັນສຳລັບການສຳເລັດ (ເກົ່າ)';
$string['requiredentries_help'] = 'ຖ້າຕັ້ງໄວ້, ຂໍ້ຄວາມຈະຖືກສະແດງໂດຍລະບຸຈໍານວນລາຍການທີ່ຕ້ອງການໃຫ້ສໍາເລັດ. ຈື່ໄວ້ວ່າການຕັ້ງຄ່ານີ້ບໍ່ໄດ້ເຊື່ອມຕໍ່ກັບການສໍາເລັດກິດຈະກໍາ.

ສໍາລັບລາຍການທີ່ຕ້ອງການສໍາລັບການສໍາເລັດກິດຈະກໍາ, ການຕັ້ງຄ່າການສໍາເລັດກິດຈະກໍາໃໝ່ \'ລາຍການຕ້ອງການ\' ຄວນຖືກນໍາໃຊ້. ເພື່ອເອົາການຕັ້ງຄ່ານີ້ອອກໄປໝົດ, ຕັ້ງເປັນບໍ່ມີ, ຈາກນັ້ນບັນທຶກການປ່ຽນແປງ.
ກະລຸນາໃຊ້ຊ່ອງຂໍ້ມູນທີ່ຕ້ອງການຢູ່ໃນພາກສ່ວນການສໍາເລັດກິດຈະກໍາແທນ.';
$string['requiredentriestoview'] = 'ລາຍການທີ່ຈຳເປັນກ່ອນການເບິ່ງ';
$string['requiredentriestoview_help'] = 'ຈຳນວນລາຍການທີ່ນັກຮຽນຕ້ອງການສົ່ງກ່ອນທີ່ເຂົາເຈົ້າຈະສາມາດເບິ່ງລາຍການຈາກນັກຮຽນຄົນອື່ນ.

ໝາຍເຫດ: ຖ້າຕ້ອງການລາຍການກ່ອນການເບິ່ງ, ຕົວກັ່ນຕອງການເຊື່ອມຕໍ່ອັດຕະໂນມັດຂອງຖານຂໍ້ມູນຄວນຖືກປິດໃຊ້ງານ. ສິ່ງນີ້ເພາະວ່າ ຕົວກັ່ນຕອງການເຊື່ອມຕໍ່ອັດຕະໂນມັດຂອງຖານຂໍ້ມູນບໍ່ສາມາດກໍານົດໄດ້ວ່າ ຜູ້ໃຊ້ໄດ້ສົ່ງຈໍານວນລາຍການທີ່ຕ້ອງການແລ້ວຫຼືບໍ່.';
$string['requiredentrieswarning'] = 'ການຕັ້ງຄ່ານີ້ໄດ້ຖືກແທນທີ່ດ້ວຍການຕັ້ງຄ່າການສໍາເລັດກິດຈະກໍາ "ລາຍການຕ້ອງການ"';
$string['requiredfield'] = 'ຊ່ອງຂໍ້ມູນທີ່ຈຳເປັນ';
$string['resetsettings'] = 'ຕັ້ງຄ່າຕົວກັ່ນຕອງຄືນໃໝ່';
$string['resettemplate'] = 'ຕັ້ງຄ່າແມ່ແບບຄືນໃໝ່';
$string['resizingimages'] = 'ກຳລັງປ່ຽນຂະໜາດຮູບຕົວຢ່າງ...';
$string['rows'] = 'ແຖວ';
$string['rssglobaldisabled'] = 'ປິດໃຊ້ງານ. ເບິ່ງຕົວແປການຕັ້ງຄ່າເວັບໄຊທ໌.';
$string['rsstemplate'] = 'ແມ່ແບບ RSS';
$string['rsstitletemplate'] = 'ແມ່ແບບຫົວຂໍ້ RSS';
$string['rsstype'] = 'ຟີດ RSS ສຳລັບກິດຈະກຳນີ້';
$string['save'] = 'ບັນທຶກ';
$string['saveandadd'] = 'ບັນທຶກ ແລະ ເພີ່ມອັນອື່ນ';
$string['saveandview'] = 'ບັນທຶກ ແລະ ເບິ່ງ';
$string['saveaspreset'] = 'ບັນທຶກເປັນການຕັ້ງຄ່າລ່ວງໜ້າ';
$string['saveaspreset_help'] = 'ບັນທຶກເປັນຄຸນສົມບັດການຕັ້ງຄ່າລ່ວງໜ້າເຜີຍແຜ່ແມ່ແບບ ແລະ ຊ່ອງຂໍ້ມູນເປັນການຕັ້ງຄ່າລ່ວງໜ້າ ເຊິ່ງຄົນອື່ນຢູ່ໃນເວັບໄຊທ໌ສາມາດໃຊ້ໄດ້. (ທ່ານສາມາດລຶບມັນອອກຈາກລາຍຊື່ການຕັ້ງຄ່າລ່ວງໜ້າໄດ້ທຸກເວລາ.)';
$string['saveaspresetmissingcapability'] = 'ຜູ້ໃຊ້ບໍ່ມີການອະນຸຍາດໃຫ້ບັນທຶກຖານຂໍ້ມູນເປັນການຕັ້ງຄ່າລ່ວງໜ້າ.';
$string['savedataaspreset'] = 'ບັນທຶກຊ່ອງຂໍ້ມູນ ແລະ ແມ່ແບບທັງໝົດເປັນການຕັ້ງຄ່າລ່ວງໜ້າ';
$string['savesettings'] = 'ບັນທຶກການຕັ້ງຄ່າ';
$string['savesuccess'] = 'ບັນທຶກສຳເລັດແລ້ວ. ການຕັ້ງຄ່າລ່ວງໜ້າຂອງທ່ານຕອນນີ້ຈະມີໃຫ້ໃນທົ່ວເວັບໄຊທ໌.';
$string['search'] = 'ຄົ້ນຫາ';
$string['search:activity'] = 'ຖານຂໍ້ມູນ - ຂໍ້ມູນກິດຈະກຳ';
$string['search:entry'] = 'ຖານຂໍ້ມູນ - ລາຍການ';
$string['selectedrequired'] = 'ເລືອກທີ່ຈຳເປັນທັງມົດ';
$string['selectexportoptions'] = 'ເລືອກທາງເລືອກການສົ່ງອອກ';
$string['selectfields'] = 'ຊ່ອງຂໍ້ມູນທີ່ເລືອກ';
$string['showall'] = 'ສະແດງລາຍການທັງໝົດ';
$string['single'] = 'ເບິ່ງດ່ຽວ';
$string['singletemplate'] = 'ແມ່ແບບດ່ຽວ';
$string['singleview'] = 'ມຸມມອງດຽວ';
$string['subplugintype_datafield'] = 'ປະເພດຊ່ອງຂໍ້ມູນຖານຂໍ້ມູນ';
$string['subplugintype_datafield_plural'] = 'ປະເພດຊ່ອງຂໍ້ມູນຖານຂໍ້ມູນ';
$string['subplugintype_datapreset'] = 'ການຕັ້ງຄ່າລ່ວງໜ້າ';
$string['subplugintype_datapreset_plural'] = 'ການຕັ້ງຄ່າລ່ວງໜ້າ';
$string['tagarea_data_records'] = 'ບັນທຶກຂໍ້ມູນ';
$string['tags'] = 'ແທັກ';
$string['tagsdeleted'] = 'ແທັກຖານຂໍ້ມູນຖືກລຶບແລ້ວ';
$string['teachersandstudents'] = '{$a->teachers} ແລະ {$a->students}';
$string['templates'] = 'ແມ່ແບບ';
$string['templatesaved'] = 'ບັນທຶກແມ່ແບບ';
$string['templatesnavigation'] = 'ແມ່ແບບການນໍາທາງຂັ້ນສາມ';
$string['text'] = 'ຂໍ້ຄວາມ';
$string['textarea'] = 'ເຂດຂໍ້ມູນ';
$string['timeadded'] = 'ເພີ່ມເວລາແລ້ວ';
$string['timemodified'] = 'ດັດແກ້ເວລາແລ້ວ';
$string['type'] = 'ປະເພດຊ່ອງຂໍ້ມູນ';
$string['undefinedprocessactionmethod'] = 'ບໍ່ມີວິທີການປະຕິບັດທີ່ກໍານົດໄວ້ໃນ Data_Preset ເພື່ອຈັດການຄໍາສັ່ງ "{$a}".';
$string['unsupportedfields'] = 'ຊ່ອງຂໍ້ມູນບໍ່ຮອງຮັບ';
$string['unsupportedfieldslist'] = 'ຊ່ອງຂໍ້ມູນຕໍ່ໄປນີ້ບໍ່ສາມາດສົ່ງອອກ:';
$string['updatefield'] = 'ປັບປຸງຊ່ອງຂໍ້ມູນທີ່ມີຢູ່';
$string['uploadfile'] = 'ອັບໂຫຼດໄຟລ໌';
$string['uploadrecords'] = 'ອັບໂຫຼດລາຍການຈາກໄຟລ໌';
$string['uploadrecords_help'] = 'ລາຍການອາດຈະຖືກອັບໂຫຼດຜ່ານໄຟລ໌ຂໍ້ຄວາມ. ຮູບແບບຂອງໄຟລ໌ຄວນຈະເປັນດັ່ງຕໍ່ໄປນີ້:

* ແຕ່ລະແຖວຂອງໄຟລ໌ມີໜຶ່ງບັນທຶກ
* ແຕ່ລະບັນທຶກແມ່ນຊຸດຂໍ້ມູນຂັ້ນດ້ວຍຕົວຂັ້ນທີ່ເລືອກ
* ບັນທຶກທຳອິດມີບັນຊີລາຍຊື່ຂອງ fieldnames ກຳນົດຮູບແບບຂອງໄຟລ໌ທີ່ເຫຼືອ

ການປິດຊ່ອງຂໍ້ມູນເປັນລັກສະນະທີ່ຢູ່ອ້ອມຮອບແຕ່ລະຊ່ອງຂໍ້ມູນ ໃນແຕ່ລະບັນທຶກ. ໂດຍປົກກະຕິແລ້ວມັນສາມາດປະໄວ້ໂດຍບໍ່ໄດ້ຕັ້ງຄ່າ.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'URL';
$string['usedate'] = 'ລວມໃນການຄົ້ນຫາ';
$string['usepredefinedset'] = 'ນໍາໃຊ້ຊຸດທີ່ກໍານົດໄວ້ລ່ວງໜ້າ';
$string['usepreset'] = 'ນໍາໃຊ້ການຕັ້ງຄ່າລ່ວງໜ້າ';
$string['usestandard'] = 'ນໍາໃຊ້ການຕັ້ງຄ່າລ່ວງໜ້າ';
$string['usestandard_help'] = 'ເພື່ອໃຊ້ການຕັ້ງຄ່າລ່ວງໜ້າທີ່ມີໃຫ້ທັງເວັບໄຊທ໌, ເລືອກມັນຈາກລາຍການ. (ຖ້າທ່ານໄດ້ເພີ່ມຄ່າທີ່ຕັ້ງໄວ້ລ່ວງໜ້າເຂົ້າໃນບັນຊີໂດຍໃຊ້ຄຸນສົມບັດບັນທຶກເປັນຕັ້ງໄວ້ແລ້ວທ່ານມີທາງເລືອກທີ່ຈະລຶບມັນໄດ້.)';
$string['viewfromdate'] = 'ອ່ານເທົ່ານັ້ນຈາກ';
$string['viewnavigation'] = 'ເບິ່ງໂໝດການນຳທາງຂັ້ນສາມ';
$string['viewtodate'] = 'ອ່ານເທົ່ານັ້ນຫາ';
$string['viewtodatevalidation'] = 'ເພື່ອອ່ານເທົ່ານັ້ນໃນປະຈຸບັນບໍ່ສາມາດເປັນກ່ອນການອ່ານເທົ່ານັ້ນຈາກວັນທີ.';
$string['wrongdataid'] = 'ໃຫ້ລະຫັດປະຈຳຕົວຂໍ້ມູນຜິດ';
