<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_formulas', language 'cs', version '5.0'.
 *
 * @package     qtype_formulas
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abserror'] = 'Absolutní chyba';
$string['addmorepartsblanks'] = 'Prázdné místo pro {počet} dalších částí';
$string['algebraic_formula'] = 'Algebraická formule';
$string['allfieldsempty'] = 'Všechna vstupní pole jsou prázdná.';
$string['answer'] = 'Odpověď*';
$string['answer_help'] = '**Požadováno**
Musí se jednat o číslo / seznam čísel nebo řetězec / seznam řetězců v závislosti na zvoleném typu odpovědi. Upozorňujeme, že počet prvků v seznamu definuje počet polí pro odpověď v této části.

<pre class="prettyprint">123<br>[1, 0, 0, 1]<br>a<br>[1, a, b]<br>"exp(-a t)"<br>["vx t","vy t - 0.5 a t^2"]</pre>';
$string['answercombinedunitmulti'] = 'Odpověď a jednotka pro část {$a->part}';
$string['answercombinedunitsingle'] = 'Odpověď a jednotka';
$string['answercoordinatemulti'] = 'Odpovědi pro část {$a->part} a souřadnice {$a->numanswer}';
$string['answercoordinatesingle'] = 'Odpověď na souřadnici {$a->numanswer}';
$string['answermark'] = 'Známka za část*';
$string['answermark_help'] = '**Požadováno**
Známka za tuto část by měla být vyšší než 0.
Výchozí nastavení známky pro celou otázku je součet všech známek z jednotlivých částí.

Poznámka: Pokud zůstane pole pro známku nevyplněné a nebude k dispozici žádná odpověď, bude část po uložení otázky smazána.';
$string['answermulti'] = 'Odpověď pro část {$a->part}';
$string['answerno'] = 'Část {$a}';
$string['answernotacceptable'] = 'Tato odpověď není platná pro daný typ odpovědi: {$a}.';
$string['answernotunique'] = 'Existují další správné odpovědi.';
$string['answernotunique_help'] = 'Pokud je tato možnost zaškrtnuta, student při kontrole svého pokusu uvidí "Jedna správná odpověď je: ..." místo "Správná odpověď je: ...".';
$string['answersingle'] = 'Odpověď';
$string['answertype'] = 'Typ odpovědi';
$string['answertype_help'] = 'Jsou zde čtyři typy odpovědí.

Na číselné a numerické úlohy je jako odpověď vyžadováno číslo nebo seznam čísel.

Algebraické úlohy vyžadují jako odpověď řetězec nebo seznam řetězců.

Různé typy odpovědí budou mít při zadávání různá omezení, takže studenti budou muset vědět, jak je zadávat. Kontrola formátu v kódu otázky jim také při psaní řekne, pokud je něco špatně. Podrobnosti naleznete v dokumentaci.';
$string['answertype_link'] = 'https://dynamiccourseware.org/';
$string['answerunitmulti'] = 'Jednotka pro část {$a->part}';
$string['answerunitsingle'] = 'Jednotka';
$string['caretwarning'] = 'Všimněte si, že ^ v odpovědích modelů znamená XOR, s výjimkou algebraických vzorců. Pro umocňování použijte místo toho **.';
$string['checkvarshdr'] = 'Zkontrolujte instanci proměnných';
$string['choiceno'] = 'Ne';
$string['choiceyes'] = 'Ano';
$string['commonsiunit'] = 'Běžné SI jednotky';
$string['correctansweris'] = 'Jediná správná odpověď na otázku je: {$a}';
$string['correctfeedback'] = 'Za každou správnou odpověď';
$string['correctfeedback_help'] = 'Tato zpětná vazba bude zobrazena studentům, kteří získají za část nejvyšší známku. Zpětná vazba může obsahovat globální a lokální proměnné nahrazené jejich hodnotami.';
$string['correctness'] = 'Kritéria hodnocení*';
$string['correctness_help'] = '**Požadováno**
Můžete si vybrat buď relativní chybu, nebo absolutní chybu s rozsahem chyby. Relativní chybu nelze použít pro algebraický typ odpovědi.

Pro přesnou definici relativní chyby a absolutní chyby, v případě existence více odpovědních polí najdete v dokumentaci.';
$string['correctness_link'] = 'https://dynamiccourseware.org/';
$string['correctnessexpert'] = 'Expert';
$string['correctnesssimple'] = 'Jednoduché';
$string['defaultanswermark'] = 'Výchozí známka části';
$string['defaultanswermark_desc'] = 'Výchozí známka části pro novou část otázky';
$string['defaultanswertype'] = 'Výchozí typ odpovědi';
$string['defaultanswertype_desc'] = 'Výchozí odpověď pro novou část otázky';
$string['defaultcorrectness'] = 'Výchozí kritéria hodnocení';
$string['defaultcorrectness_desc'] = 'Výchozí kritéria hodnocení pro novou část otázky';
$string['defaultunitpenalty'] = 'Výchozí penalizace za špatnou jednotku';
$string['defaultunitpenalty_desc'] = 'Výchozí penalizace za špatnou jednotku (0-1)';
$string['defaultwidth_algebraic_formula'] = 'Typ odpovědi „Algebraický vzorec“';
$string['defaultwidth_algebraic_formula_desc'] = 'Výchozí šířka vstupního pole pro typ odpovědi „Algebraický vzorec“';
$string['defaultwidth_number'] = 'Typ odpovědi „Číslo“';
$string['defaultwidth_number_desc'] = 'Výchozí šířka vstupního pole pro typ odpovědi „Číslo“';
$string['defaultwidth_number_unit'] = 'Kombinované pole „Číslo“';
$string['defaultwidth_number_unit_desc'] = 'Výchozí šířka kombinovaného vstupního pole pro typ odpovědi „Číslo“';
$string['defaultwidth_numeric'] = 'Typ odpovědi „Číslo“';
$string['defaultwidth_numeric_desc'] = 'Výchozí šířka vstupního pole pro typ odpovědi „Číslo“';
$string['defaultwidth_numeric_unit'] = 'Kombinované pole „Číslo“';
$string['defaultwidth_numeric_unit_desc'] = 'Výchozí šířka kombinovaného vstupního pole pro typ odpovědi „Číslo“';
$string['defaultwidth_numerical_formula'] = 'Typ odpovědi „Číselný vzorec“';
$string['defaultwidth_numerical_formula_desc'] = 'Výchozí šířka vstupního pole pro typ odpovědi „Číselný vzorec“';
$string['defaultwidth_numerical_formula_unit'] = 'Kombinované pole „Číselný vzorec“';
$string['defaultwidth_numerical_formula_unit_desc'] = 'Výchozí šířka kombinovaného vstupního pole pro typ odpovědi „Číselný vzorec“';
$string['defaultwidth_unit'] = 'Pole samostatné jednotky';
$string['defaultwidth_unit_desc'] = 'Výchozí šířka pole samostatné jednotky';
$string['defaultwidthunit'] = 'Jednotka délky';
$string['defaultwidthunit_desc'] = 'Jednotka délky použitá pro níže uvedená výchozí nastavení šířky. Jednotky „em“ nebo „rem“ odpovídají přibližně šířce jedné číslice.';
$string['error_algebraic_relerr'] = 'Relativní chybu (_relerr) nelze použít s algebraickým vzorcem typu odpovědi.';
$string['error_algebraic_var'] = 'Syntaktická chyba definování algebraické proměnné.';
$string['error_algvar_numbers'] = 'Algebraické proměnné lze inicializovat pouze seznamem čísel.';
$string['error_answer_missing'] = 'Nebyla definována žádná odpověď.';
$string['error_answer_missing_in_part'] = 'Pro část {$a} nebyla definována žádná odpověď.';
$string['error_answerbox_duplicate'] = 'Zástupné symboly v poli pro odpovědi musí být jedinečné, nalezena druhá instance {$a}.';
$string['error_answertype_mistmatch'] = 'Nesoulad s typem odpovědi: Číselná odpověď vyžaduje číslo a algebraická odpověď vyžaduje řetězec.';
$string['error_bitshift_integer'] = 'Operátor bitového posunu by se měl používat pouze s celými čísly.';
$string['error_bitshift_negative'] = 'Posun bitu o záporné číslo {$a} není povolen.';
$string['error_bitwand_integer'] = 'Bitový operátor AND by se měl používat pouze s celými čísly.';
$string['error_bitwor_integer'] = 'Bitový operátor OR by se měl používat pouze s celými čísly.';
$string['error_bitwxor_integer'] = 'Bitový XOR by se měl používat pouze s celými čísly.';
$string['error_cannotusealgebraic'] = 'Algebraickou proměnnou "{$a}" nelze v tomto kontextu použít.';
$string['error_criterion'] = 'Kritérium hodnocení musí být vyhodnoceno jako jedno číslo.';
$string['error_criterion_empty'] = 'Kritérium hodnocení nesmí být prázdné.';
$string['error_damaged_question'] = 'Neplatná data. Otázka Vzorce mohla být poškozena, např. během neúspěšného importu nebo obnovy.';
$string['error_db_delete'] = 'Nelze smazat záznam z databáze, tabulka {$a}.';
$string['error_db_missing_options'] = 'Otázka s ID vzorců {$a} postrádala záznam možností. Používá se výchozí nastavení.';
$string['error_db_read'] = 'Nelze číst z databáze, tabulka {$a}.';
$string['error_db_write'] = 'Nelze zapisovat do databáze, tabulka {$a}.';
$string['error_diff_binary_function_needslist'] = 'Při použití map() s binární funkcí "{$a}" musí být alespoň jeden argument seznam.';
$string['error_diff_binary_function_two'] = 'Při použití map() s binární funkcí "{$a}" se očekávají dva argumenty.';
$string['error_diff_binary_operator_needslist'] = 'Při použití map() s binárním operátorem "{$a}" musí být alespoň jeden argument seznam.';
$string['error_diff_binary_operator_two'] = 'Při použití map() s binárním operátorem "{$a}" se očekávají dva argumenty.';
$string['error_diff_binary_samesize'] = 'Při použití map() se dvěma seznamy musí mít oba stejnou velikost.';
$string['error_diff_first'] = 'První argument funkce diff() musí být seznam.';
$string['error_diff_first_invalid'] = '"{$a}" není platný první argument pro funkci map().';
$string['error_diff_firstlist_content'] = 'Při použití funkce diff() musí první seznam obsahovat pouze čísla nebo pouze řetězce.';
$string['error_diff_firstlist_mismatch'] = 'diff(): neshoda typů pro prvek #{$a} (s nulovým indexem) prvního seznamu.';
$string['error_diff_function_more_args'] = 'Funkci "{$a}" nelze použít s map(), protože očekává více než dva argumenty.';
$string['error_diff_function_no_args'] = 'Funkci "{$a}" nelze použít s map(), protože nepřijímá žádné argumenty.';
$string['error_diff_samesize'] = 'Funkce diff() očekává dva seznamy stejné velikosti.';
$string['error_diff_second'] = 'Druhý argument funkce diff() musí být seznam.';
$string['error_diff_secondlist_mismatch'] = 'diff(): neshoda typů pro prvek #{$a} (s nulovým indexem) druhého seznamu.';
$string['error_diff_third'] = 'Třetí argument funkce diff() lze použít pouze při práci se seznamy řetězců.';
$string['error_diff_unary_function'] = 'Při použití map() s unární funkcí "{$a}" je akceptován pouze jeden seznam.';
$string['error_diff_unary_needslist'] = 'Při použití map() s "{$a}" musí být argumentem seznam.';
$string['error_diff_unary_operator'] = 'Při použití map() s unárním operátorem "{$a}" je akceptován pouze jeden seznam.';
$string['error_distribution_outcomes'] = '{$a} očekává, že počet úspěšných výsledků bude nezáporné celé číslo.';
$string['error_distribution_tries'] = 'Funkce {$a} očekává, že počet pokusů bude nezáporné celé číslo.';
$string['error_divzero'] = 'Dělení nulou není definováno.';
$string['error_emptyrange'] = 'Chyba vyhodnocení: rozsah od {$a->start} do {$a->end} s krokem {$a->step} bude prázdný.';
$string['error_emptystack'] = 'Chyba vyhodnocení: prázdný zásobník - předali jste funkci nebo operátoru dostatek argumentů?';
$string['error_eval_numerical'] = 'Některá výrazy nelze vyhodnotit číselně.';
$string['error_evaluate_invocation'] = 'Chybné vyvolání {$a}.';
$string['error_evaluation_unknown_nan_inf'] = 'Neznámá chyba při použití operátoru {$a}, výsledek byl (kladný nebo záporný) nekonečno nebo nečíslo (NAN).';
$string['error_expectbraceorstatement'] = 'Syntaktická chyba: { nebo očekáván příkaz.';
$string['error_expectbracketorvarname'] = 'Syntaktická chyba: [ nebo očekávaný název proměnné.';
$string['error_expectclosingparen'] = 'Očekávala se syntaktická chyba: ).';
$string['error_expected_intindex'] = 'Chyba vyhodnocení: index by měl být celé číslo, nalezeno "{$a}".';
$string['error_expected_number'] = 'Očekávaný počet.';
$string['error_expected_number_found'] = 'Očekávané číslo, nalezeno {$a->found}.';
$string['error_expected_number_found_algebraicvar'] = 'Očekávané číslo, nalezená algebraická proměnná.';
$string['error_expected_number_found_list'] = 'Očekávané číslo, nalezen seznam.';
$string['error_expected_scalar'] = 'Očekávaná skalární hodnota.';
$string['error_expected_scalar_found'] = 'Očekávaná skalární hodnota, nalezeno {$a->found}.';
$string['error_expected_scalar_found_algebraicvar'] = 'Očekávaná skalární hodnota, nalezená algebraická proměnná.';
$string['error_expected_scalar_found_list'] = 'Očekávaná skalární hodnota, nalezený seznam.';
$string['error_expects_number'] = '{$a->who} očekává číslo.';
$string['error_expects_number_found'] = '{$a->who} očekává číslo, nalezeno {$a->found}.';
$string['error_expects_scalar'] = '{$a->who} očekává skalární hodnotu.';
$string['error_expects_scalar_found'] = 'Funkce {$a->who} očekává skalární hodnotu, nalezeno {$a->found}.';
$string['error_fact_toolarge'] = 'Na této platformě nelze vypočítat {$a}!, výsledek je větší než PHP_MAX_INT.';
$string['error_fixed_range'] = 'Chyba syntaxe pevného rozsahu.';
$string['error_for_expectcolon'] = 'Syntaktická chyba: : očekávaná.';
$string['error_for_expectidentifier'] = 'Syntaktická chyba: očekávaný identifikátor.';
$string['error_for_expectparen'] = 'Syntaktická chyba: ( očekávané po for.';
$string['error_forbid_char'] = 'Vzorec nebo výraz obsahuje zakázané znaky nebo operátory.';
$string['error_forgotoperator'] = 'Syntaktická chyba: zapomněli jste vložit operátor?';
$string['error_forloop'] = 'Syntaktická chyba for cyklu.';
$string['error_forloop_expression'] = 'Výraz ve for cyklu musí být řetězec.';
$string['error_forloop_var'] = 'Proměnná for cyklu obsahuje chyby.';
$string['error_func_all_lists'] = '{$a} očekává, že jejími argumenty budou seznamy.';
$string['error_func_argcount'] = 'Invalid number of arguments for function "{$a->function}": {$a->count} given.';
$string['error_func_first_int'] = '{$a} očekává, že jeho prvním argumentem bude celé číslo.';
$string['error_func_first_list'] = 'Funkce {$a} očekává, že jejím prvním argumentem bude seznam.';
$string['error_func_first_nnegint'] = 'Funkce {$a} očekává, že jejím prvním argumentem bude nezáporné celé číslo.';
$string['error_func_first_number'] = 'Funkce {$a} očekává, že jejím prvním argumentem bude číslo.';
$string['error_func_first_nzeroint'] = '{$a} očekává, že jeho prvním argumentem bude nenulové celé číslo.';
$string['error_func_first_posint'] = '{$a} očekává, že jeho prvním argumentem bude kladné celé číslo.';
$string['error_func_nan'] = 'Výsledek funkce "{$a}" nebyl číslo.';
$string['error_func_nnegint'] = 'Funkce {$a} očekává, že jejím argumentem bude nezáporné celé číslo.';
$string['error_func_param'] = 'Špatný počet nebo typ parametrů pro funkci {$a}()';
$string['error_func_paren'] = 'Syntaktická chyba: za funkcí musí následovat otevírací závorka.';
$string['error_func_positive'] = '{$a} očekává, že jejím argumentem bude kladné číslo.';
$string['error_func_second_int'] = '{$a} očekává, že jeho druhý argument bude celé číslo.';
$string['error_func_second_nnegint'] = '{$a} očekává, že jejím druhým argumentem bude nezáporné celé číslo.';
$string['error_func_second_nzeronum'] = '{$a} očekává, že jejím druhým argumentem bude nenulové číslo.';
$string['error_func_second_posint'] = '{$a} očekává, že jeho druhý argument bude kladné celé číslo.';
$string['error_func_third_posint'] = '{$a} očekává, že jeho třetí argument bude kladné celé číslo.';
$string['error_grading_error'] = 'Chyba hodnocení. Pravděpodobně důsledkem nesprávného importovaného souboru nebo poškození databáze.';
$string['error_grading_not_one'] = 'Kritérium hodnocení by mělo být vyhodnoceno jako 1 pro správné odpovědi. Místo toho nalezeno {$a}.';
$string['error_grading_single_expression'] = 'Kritérium hodnocení by měl být jeden jediný výraz. Místo toho byly nalezeny příkazy {$a}.';
$string['error_import_missing_field'] = 'Chybí pole: {$a}';
$string['error_import_missing_parts'] = 'Otázka „{$a}“ neobsahuje žádné části.';
$string['error_in_answer'] = 'Chyba v odpovědi #{$a->answerno}: {$a->message}';
$string['error_indexoutofrange'] = 'Chyba vyhodnocení: index {$a} je mimo rozsah.';
$string['error_inv_consec'] = 'Při použití funkce inv() musí být čísla v seznamu po sobě jdoucí.';
$string['error_inv_integers'] = 'Funkce inv() očekává, že všechny prvky seznamu budou celá čísla; čísla s desetinnou čárkou budou oříznuta.';
$string['error_inv_list'] = 'inv() očekává seznam.';
$string['error_inv_nodup'] = 'Při použití funkce inv() nesmí seznam obsahovat stejné číslo vícekrát.';
$string['error_inv_smallest'] = 'Při použití funkce inv() musí být nejmenší číslo v seznamu 0 nebo 1.';
$string['error_invalidalgebraic'] = '"{$a}" není platný algebraický výraz.';
$string['error_invalidargsep'] = 'Syntaktická chyba: neplatné použití oddělovacího tokenu ",`".';
$string['error_invalidcodepoint'] = 'Neplatná řídicí sekvence kódu UTF-8.';
$string['error_invalidcodepoint_toolarge'] = 'Neplatná escape sekvence kódu UTF-8: Kód větší než 0x10FFFF.';
$string['error_invalidcontext'] = 'Zadán neplatný kontext proměnné, import se ruší.';
$string['error_invalidrandvardef'] = 'Neplatná definice náhodné proměnné – musíte poskytnout seznam možných hodnot.';
$string['error_invalidrangesep'] = 'Syntaktická chyba: neplatné použití oddělovače rozsahu \':\'.';
$string['error_invalidunary'] = 'Neplatné použití unárního operátoru: {$a}.';
$string['error_invalidvarname'] = 'Neplatný název proměnné: {$a}.';
$string['error_len_argument'] = 'len() očekává seznam nebo řetězec.';
$string['error_list_too_large'] = 'Seznam nesmí obsahovat více než {$a} prvků.';
$string['error_map_unknown'] = 'Chyba vyhodnocení v map(): {$a}';
$string['error_mark'] = 'Známka za odpověď musí být hodnota vyšší než 0.';
$string['error_model_answer_no_content'] = 'Neplatná odpověď: modelová odpověď neobsahuje žádné vyhodnotitelné symboly.';
$string['error_model_answer_prefix'] = 'Neplatná odpověď: Prosím, nepoužívejte prefix operátor \\ v modelových odpovědích s tímto typem odpovědi.';
$string['error_no_answer'] = 'Je požadována nejméně jedna odpověď.';
$string['error_notindexable'] = 'Chyba při vyhodnocení: indexování je možné pouze u seznamů a řetězců.';
$string['error_number_for_numeric_answertypes'] = 'Neplatný formát odpovědi: tento typ odpovědi očekává jedno číslo nebo seznam čísel.';
$string['error_onlyoneindex'] = 'Chyba vyhodnocení: při přístupu k prvkům pole je podporován pouze jeden index.';
$string['error_parenmismatch'] = 'Neshodující se závorky, \'{$a->closer}\' uzavírá \'{$a->opener}\' z řádku {$a->row} a sloupce {$a->column}.';
$string['error_parennotclosed'] = 'Nevyvážená závorka "{$a}" se nikdy neuzavře.';
$string['error_pick_two'] = 'Při volání se dvěma argumenty očekává pick() jako druhý parametr seznam.';
$string['error_placeholder_format'] = 'Špatný formát zástupného znaku nebo zakázané znaky.';
$string['error_placeholder_main_duplicate'] = 'Duplikovaný Tento zástupný znak v hlavním textu otázky.';
$string['error_placeholder_missing'] = 'Tento zástupný znak chybí v hlavním textu.';
$string['error_placeholder_sub_duplicate'] = 'Tento zástupný znak již byl definován v jiné části.';
$string['error_placeholder_too_long'] = 'Délka zástupného pole je omezena na 40 znaků.';
$string['error_poly_one'] = 'Při volání poly() s jedním argumentem musí být jedním číslo nebo seznam čísel.';
$string['error_poly_string'] = 'Při volání poly() s řetězcem musí být druhým argumentem číslo nebo seznam čísel.';
$string['error_poly_stringlist'] = 'Při volání poly() se seznamem řetězců musí být druhým argumentem seznam čísel.';
$string['error_poly_two'] = 'Při volání poly() se dvěma argumenty musí být první řetězec nebo seznam řetězců.';
$string['error_power_negbase_expfrac'] = 'Základ nemůže být záporný s zlomkovým exponentem.';
$string['error_power_negbase_expzero'] = 'Dělení nulou není definováno, takže základ nemůže být nula pro záporné exponenty.';
$string['error_power_zerozero'] = 'Mocnina 0^0 není definována.';
$string['error_prefix'] = 'Syntaktická chyba: neplatné použití předpony \\.';
$string['error_probability'] = '{$a} očekává pravděpodobnost alespoň 0 a ne větší než 1.';
$string['error_question_damaged'] = 'Chyba: otázka je poškozená, počet fragmentů textu a počet částí otázky nejsou stejné.';
$string['error_randvars_set_size'] = 'Počet generovatelných prvků v sadě musí být vyšší než 1.';
$string['error_randvars_type'] = 'Všechny prvnky množiny musí být stejného typu a mít stejnou velikost.';
$string['error_rangesyntax'] = 'Syntaktická chyba v definici rozsahu.';
$string['error_rangeusage'] = 'Syntaktická chyba: rozsahy lze použít pouze v {} nebo [].';
$string['error_rule'] = 'Chyba převodního pravidla.';
$string['error_ruleid'] = 'Žádné takové pravidlo s id/name v souboru neexistuje.';
$string['error_samestartend'] = 'Syntaktická chyba: začátek a konec rozsahu se nesmí shodovat.';
$string['error_setindividual_algebraicvar'] = 'Nastavení jednotlivých prvků není pro algebraické proměnné podporováno.';
$string['error_setindividual_randvar'] = 'Nastavení jednotlivých prvků seznamu není pro náhodné proměnné podporováno.';
$string['error_setindividual_string'] = 'Jednotlivé znaky řetězce nelze upravovat.';
$string['error_setinlist'] = 'Syntaktická chyba: množiny nelze použít uvnitř seznamu.';
$string['error_setnested'] = 'Syntaktická chyba: množiny nelze vnořovat.';
$string['error_sort_samesize'] = 'Při volání sort() se dvěma seznamy musí mít obě stejnou velikost.';
$string['error_sort_twolists'] = 'Při volání sort() se dvěma argumenty musí být oba seznamy.';
$string['error_stacksize'] = 'Zásobník by měl po vyhodnocení obsahovat přesně jeden prvek - nezapomněli jste někde středník?';
$string['error_stepzero'] = 'Syntaktická chyba: krok rozsahu nemůže být nulový.';
$string['error_str_argument'] = 'str() očekává skalární argument, např. číslo.';
$string['error_strayparen'] = 'Nevyvážená závorka, nalezen zbloudilý "{$a}".';
$string['error_string_for_algebraic_formula'] = 'Neplatný formát odpovědi: typ odpovědi „algebraický vzorec“ očekává jeden řetězec uzavřený v uvozovkách nebo seznam řetězců, každý uzavřený v uvozovkách.';
$string['error_subexpression_empty'] = 'Podvýraz je prázdný.';
$string['error_sublist_indices'] = 'Funkce sublist() očekává, že indexy budou celá čísla, nalezeno "{$a}".';
$string['error_sublist_lists'] = 'sublist() očekává, že jejími argumenty budou seznamy.';
$string['error_sublist_outofrange'] = 'Index {$a} mimo rozsah v podseznamu()';
$string['error_sum_argument'] = 'sum() očekává seznam čísel.';
$string['error_syntax'] = 'Syntaktická chyba.';
$string['error_ternary_incomplete'] = 'Syntaktická chyba: neúplný ternární operátor nebo špatně umístěný znak \'?\'.';
$string['error_ternary_missmiddle'] = 'Syntaktická chyba: ternárnímu operátoru chybí střední část.';
$string['error_ternary_notenough'] = 'Chyba vyhodnocení: nedostatek argumentů pro ternární operátor.';
$string['error_tokenconversion'] = 'Daná hodnota "{$a}" má neplatný datový typ a nelze ji převést na token.';
$string['error_undefinedconstant'] = 'Nedefinovaná konstanta: "{$a}"';
$string['error_unexpectedend'] = 'Syntaktická chyba: neočekávaný konec výrazu za "{$a}".';
$string['error_unexpectedinput'] = 'Neočekávaný vstup: "{$a}"';
$string['error_unexpectedtoken'] = 'Neočekávaný token: {$a}';
$string['error_unit'] = 'Chyba převodu jednotky';
$string['error_unitpenalty'] = 'Penalizace musí být číslo mezi 0 a 1.';
$string['error_unknownfunction'] = 'Neznámá funkce: "{$a}"';
$string['error_unknownvarname'] = 'Neznámá proměnná: {$a}';
$string['error_unterminatedstring'] = 'Neukončený řetězec, začínající na řádku {$a->row}, sloupci {$a->column}.';
$string['error_validation_eval'] = 'Chyba pokusu o vyhodnocení.';
$string['error_variablelhs'] = 'Levá strana přiřazení musí být proměnná.';
$string['error_vars_array_index_nonnumeric'] = 'Nečíslná hodnota nemůže být použit jako seznamový index.';
$string['error_vars_array_index_out_of_range'] = 'Seznamový index ukazuje mimo rozsah.';
$string['error_vars_array_size'] = 'Velikost seznamu musí být od 1 do 1000.';
$string['error_vars_array_type'] = 'Prvek ve stejném seznamu musí být stejného typu (číslo nebo řetězec).';
$string['error_vars_array_unsubscriptable'] = 'Proměnná je nezapsatelná.';
$string['error_vars_bracket_mismatch'] = 'Neodpovídá počet závorek.';
$string['error_vars_end_separator'] = 'Chybějící přeřazovací operátor na konci.';
$string['error_vars_name'] = 'Syntaxe názvu proměnné je špatně.';
$string['error_vars_reserved'] = 'Funkce {$a}() je obsazená a nemůže být použita jako proměnná.';
$string['error_vars_string'] = 'Chyba. Buď použití řetězce bez dvojitých uvozovek nebo použití neakceptovatelného znaku jako \'.';
$string['error_vars_undefined'] = 'Proměnná "{$a}" nebyla definována.';
$string['error_wrapnumber'] = 'Nelze zabalit nečíselnou hodnotu do tokenu typu NUMBER.';
$string['error_wrapstring'] = 'Danou hodnotu nelze zabalit do tokenu typu STRING.';
$string['feedback'] = 'Část obecná zpětná vazba';
$string['feedback_help'] = 'Tato část zpětné vazby bude zobrazena všem studentům. Může obsahovat globální a lokální proměnné, které budou nahrazeny jejich hodnotami.';
$string['functiontakesatleasttwo'] = 'Funkce {$a} musí mít nejméně dva argumenty.';
$string['functiontakesnoargs'] = 'Funkce {$a} nepřijímá žádné argumenty';
$string['functiontakesonearg'] = 'Funkce {$a} musí mít přesně jeden argument';
$string['functiontakesoneortwoargs'] = 'Funkce {$a} musí mít buď jeden nebo dva argumenty.';
$string['functiontakesthreeargs'] = 'Funkce {$a} musí mít přesně tři argumenty';
$string['functiontakestwoargs'] = 'Funkce {$a} musí mít přesně dva argumenty.';
$string['globalvarshdr'] = 'Proměnné';
$string['illegalformulasyntax'] = 'Ilegální syntaxe vzorce začínající \'{$a}\'';
$string['incorrectfeedback'] = 'Za jakoukoli nesprávnou odpověď';
$string['incorrectfeedback_help'] = 'Tato zpětná vazba bude zobrazena studentům, kteří z této části nezískali žádnou známku. Může obsahovat globální a lokální proměnné, které budou nahrazeny jejich hodnotami.';
$string['instantiate'] = 'Okamžitě';
$string['mainq'] = 'Hlavní otázka';
$string['modelanswer'] = 'Modelová otázka';
$string['none'] = 'žádný';
$string['number'] = 'Číslo';
$string['number_unit'] = 'Číslo a jednotka';
$string['numdataset'] = 'Počet datových sad';
$string['numeric'] = 'Číselná hodnota';
$string['numeric_unit'] = 'Číselná hodnota a jednotka';
$string['numerical_formula'] = 'Číselný vzorec';
$string['numerical_formula_unit'] = 'Číselný vzorec a jednotka';
$string['otherrule'] = 'Ostatní pravidla';
$string['otherrule_help'] = 'Zde může autor otázky definovat další pravidla převodu pro další akceptované základní jednotky. Pokročilé použití naleznete v dokumentaci.';
$string['partiallycorrectfeedback'] = 'Za jakoukoli částečně správnou odpověď';
$string['partiallycorrectfeedback_help'] = 'Tento feedback bude zobrazen studentům, kteří v této části nezískali nejvyšší známku. Může obsahovat globální a lokální proměnné, které budou nahrazeny jejich hodnotami.';
$string['placeholder'] = 'Zástupný název';
$string['placeholder_help'] = 'Zástupný symbol se používá k identifikaci místa v textu hlavní otázky, které bude nahrazeno obsahem části. Jedná se o řetězec alfanumerických znaků s prefixem \'**#**\', jako #1, #2a, #2b a #A.

Pokud necháte pole prázdné, tak bude část připojena na konec hlavní otázky.';
$string['pleaseputananswer'] = 'Prosím vyplňte odpověď do všech vstupních polí.';
$string['pluginname'] = 'Vzorce';
$string['pluginname_help'] = 'K využití této otázky jděte na <a href="https://dynamiccourseware.org/">dynamiccourseware.org</a>.

Pro možné odpovědi jděte na <a href="https://dynamiccourseware.org/">dynamiccourseware.org</a>.

Pro možnosti v upravování formuláře níže jděte na <a href="https://dynamiccourseware.org/">dynamiccourseware.org</a>

Pro kompletní dokumentaci jděte na <a href="https://dynamiccourseware.org/">dynamiccourseware.org</a>';
$string['pluginname_link'] = 'question/type/formulas';
$string['pluginnameadding'] = 'Přidání úlohy typu Vzorce';
$string['pluginnameediting'] = 'Úpravy úlohy typu Vzorce';
$string['pluginnamesummary'] = 'Typ otázky s náhodnými hodnotami a více odpověďmi.
Odpovědní pole mohou být umístěná kamkoli, takže můžeme vytvořit různé otázky zahrnující různorodé struktury jako jsou vektory, polynomy a matice.
Dále jsou ke snadnému použití dostupné funkce jako kontrola jednotky a vícedílné otázky.';
$string['postunit'] = 'Jednotka';
$string['postunit_help'] = 'Zde můžete zadat jednotku. Tento typ otázky je speciálně navržen pro jednotky SI, takže prázdné místo představuje součin různých základních jednotek a <tt>^</tt> se používá pro exponenty. <tt>/</tt> lze také použít pro inverzní exponent. Jakákoli permutace základních jednotek se zachází stejně.

Po studentech je požadováno používat stejní vstupní formát.
Například:
<pre class="prettyprint">1 m<br>0.1 m^2<br>20 m s^(-1)<br>400 kg m/s<br>100 kW</pre>';
$string['previewerror'] = 'Náhled není k dispozici. Zkontrolujte svou definici náhodných proměnných, globálních proměnných, lokálních proměnných částí a odpovědí. Původní chybová zpráva: {$a}';
$string['privacy:metadata'] = 'Tento plugin neskladuje žádná osobní data.';
$string['qtextpreview'] = 'Náhled';
$string['questiontext'] = 'Text otázky';
$string['questiontext_help'] = 'Kromě normálního typu otázky, zde můžete využít i globální proměnné a zástupná pole.

Globální proměnné budou nahrazeny jejich hodnotami a zástupná pole budou nahrazeny částmi.

Příklad:
<tt> A, B, C </tt> a zástupné symboly <tt> #1, #2, #3 </tt> jsou:

<pre class="prettyprint">Jaký je výsledek {A} + {B}?<br>{#1}<br>Jaký je výsledek {A} - {B}?<br>{#2}<br>Jaký je výsledek {C} / {B}?<br>{#3}</pre>';
$string['relerror'] = 'Relativní chyba';
$string['renew'] = 'Změna';
$string['response_right'] = 'Správné';
$string['response_wrong'] = 'Chybné';
$string['response_wrong_unit'] = 'Správná hodnota, špatná jednotka';
$string['response_wrong_value'] = 'Špatná hodnota, správná jednotka';
$string['ruleid'] = 'Základní převodní pravidla';
$string['ruleid_help'] = 'Tento typ otázky má vestavěný systém pro konverzi jednotek a obsahuje základní převodní pravidla.

Základním z pravidel je "Běžné SI jednotky", které převedou základní jednotky jako například jednotky délky, například km, m, cm a mm. Toto nastavení nemá žádný vliv, pokud jednotky nejsou použity.';
$string['settingallowdecimalcomma'] = 'Lokalizovaný oddělovač desetinných míst';
$string['settingallowdecimalcomma_desc'] = 'Povolit všem studentům používat v odpovědích čárku jako oddělovač desetinných míst.<br>Pokud je tato možnost aktivována, čísla se zobrazí podle nastavení jazyka.';
$string['settingdebouncedelay'] = 'Zpoždění před ověřením za běhu';
$string['settingdebouncedelay_desc'] = 'Časový úsek mezi poslední úpravou pole odpovědi a ověřením za běhu.';
$string['settinglenientimport'] = 'Zmírněná kontrola importu';
$string['settinglenientimport_desc'] = 'Při importu otázky nekontrolujte, zda by poskytnuté vzorové odpovědi získaly plný počet bodů. <br>Poznámka: Toto nastavení byste měli aktivovat pouze dočasně.';
$string['settings_heading_general'] = 'Obecné preference';
$string['settings_heading_width'] = 'Výchozí šířky';
$string['settings_heading_width_desc'] = 'Výchozí šířka vstupních polí pro různé typy odpovědí. Pro pole, která zůstanou prázdná, se použije nastavení ze souboru stylů pluginu. Používejte toto nastavení opatrně. Příliš malá pole mohou studentům ztížit psaní odpovědí. Upozorňujeme, že ikona vykřičníku zobrazená u neplatných odpovědí zabírá přibližně 12 pixelů.';
$string['settingshownumbertooltip'] = 'Zobrazit popisek „Číslo“';
$string['settingshownumbertooltip_desc'] = 'Zda se má pro daný typ odpovědi zobrazit popisek s textem „Číslo“. Může být rozumné tento popisek nezobrazovat, např. při práci s dětmi na základních školách. Toto nastavení neovlivňuje popisky pro jiné typy odpovědí ani pro kombinovaná pole.';
$string['settingusepopup'] = 'Použijte popisky';
$string['settingusepopup_desc'] = 'Zobrazte správnou odpověď a zpětnou vazbu v popisku.';
$string['subqoptions'] = 'Nastavení jednotky';
$string['subqtext'] = 'Text část';
$string['subqtext_help'] = 'Zde lze zadat text části a umístění polí odpovědí. Zástupné symboly, které lze použít k určení umístění polí odpovědí, jsou:

<pre class="prettyprint">{_0}<br>{_1}<br>{_2}<br>...<br>{_u}</pre>

<tt> {_0}, {_1}, {_2} </tt> jsou vstupní pole pro souřadnice a  <tt> {_u} </tt> je vstupní pole pro jednotku.

Všechny chybějící pole jsou automaticky spojeny na konci části textu. Speciální případ je pokud <tt> {_0}, {_u} </tt> jsou zadány postupně a je zde pouze jedna souřadnice a jednotka tj. <tt> {_0}{_u} </tt>, ty budou spojeny do jednoho dlouhého vstupního pole pro obojí (hodnotu i veličinu).';
$string['uniquecorrectansweris'] = 'Správná odpověď je: {$a}';
$string['unit'] = 'Jednotka';
$string['unitpenalty'] = 'Srážka za špatnou jednotku (0-1)*';
$string['unitpenalty_help'] = 'Toto nastavení určuje známku, kterou chcete udělit studentovi jako penalizaci za uvedení špatné jednotky.

Přijímány jsou hodnoty mezi 0 a 1. Pokud je hodnota 1, tak pro získání známky je potřeba mít správně jednotku i odpověď. Odpověď a jednotka jsou při odpovědi považovány za jednu entitu. Na druhou stranu, pokud je nastavena hodnota 0, studenti mohou dostat plný počet bodů pouze za správnou odpověď. Všechny náhodné řetězce na konci otázky nebudou mít vliv.

Je doporučeno nastavit hodnotu 1 všude, kde není požadovaná žádná přidružená jednotka.';
$string['unsupportedformulafunction'] = 'Funkce {$a} není podporována';
$string['vars1'] = 'Lokální proměnné';
$string['vars1_help'] = 'Zde můžete definovat proměnné stejným způsobem jako je tomu u globálních proměnných v úrovni otázek. Proměnné definované zde mohou být použity v části odpovědi nebo zpětné vazbě. Jejich viditelnost je omezená pro danou část.';
$string['vars2'] = 'Klasifikační proměnné';
$string['vars2_help'] = 'Zde je možné využít všechny lokální proměnné a studentské ospovědi. Pro pokročilé využití najdete více informací v dokumentaci.';
$string['vars2_link'] = 'https://dynamiccourseware.org/';
$string['varsdata'] = 'Instantní datové sady';
$string['varsglobal'] = 'Globální proměnné';
$string['varsglobal_help'] = 'Zde lze zadat vzorce pro manipulaci s instancemi náhodných proměnných (všechny náhodné proměnné jsou k dispozici zde). Úplný seznam matematických funkcí a operátorů je uveden v dokumentaci.

příklad:
<pre class="prettyprint">a = 1.11111;<br>b = exp(3);<br>c = A + a + b;<br>d = sin(1.5*pi()) + c;<br>e = round(a, 0);<br>f = [0,1,2,3][A];<br>g = ["zero","one","two","three"][A];<br>distance = sqrt(a*a + b*b);</pre>';
$string['varsglobal_link'] = 'https://dynamiccourseware.org/';
$string['varsrandom'] = 'Náhodné proměnné';
$string['varsrandom_help'] = 'Nové náhodné hodnoty jsou pro tyto proměnné vygenerovány na začátku každého pokusu. Toto lze provézt definováním sady prvků, ze kterých si můžete vybrat.

<pre class="prettyprint">A = {1,2,3};<br>C = {[1,-1], [2,-2], [3,-3]};<br>E = {10:100:10, 100, 1000};</pre>

Prvky mohou být čísla, řetězce nebo jejich seznamy. Na začátku nového pokusu bude jeden z prvků vylosován a přiřazen. Také je zde možnost pro čísla využít notaci pro definování rozsahu jako 10:100:100 (ukázáno výše u E).';
$string['varsrandom_link'] = 'https://dynamiccourseware.org/';
$string['varsstatistics'] = 'Statistika';
$string['yougotnright'] = 'Správně jste odpověděli na {$a} částí této otázky.';
$string['yougotoneright'] = 'Správně jste odpověděli na 1 část této otázky.';
