<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'customcert', language 'cs', version '5.0'.
 *
 * @package     customcert
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activity'] = 'Aktivita';
$string['addcertpage'] = 'Přidat stránku';
$string['addelement'] = 'Přidat prvek';
$string['aligncenter'] = 'Na střed';
$string['alignleft'] = 'Zarovnání vlevo';
$string['alignment'] = 'Zarovnání';
$string['alignment_help'] = 'Tato vlastnost nastavuje vodorovné zarovnání prvku. Některé prvky to nemusí podporovat, zatímco chování jiných se může lišit.';
$string['alignright'] = 'Zarovnání vpravo';
$string['awardedto'] = 'Uděluje';
$string['cannotverifyallcertificates'] = 'Nemáte oprávnění k ověření všech certifikátů na webu.';
$string['certificate'] = 'Certifikát';
$string['certificateexecutionperiod'] = 'Lhůta provedení certifikátu';
$string['certificateexecutionperiod_desc'] = 'Pokud není 0, úloha nezpracuje certifikáty, jejichž kurz byl neaktivní nebo poslední udělení je starší než nakonfigurovaný čas. To může pomoci zlepšit výkon naplánované úlohy.';
$string['certificatesperrun'] = 'Certifikáty ke zpracování';
$string['certificatesperrun_desc'] = 'Zadejte počet certifikátů ke zpracování na naplánované spuštění úlohy, kde 0 znamená, že budou zpracovány všechny certifikáty.';
$string['code'] = 'Kód';
$string['codegenerationmethod'] = 'Metoda generování kódu';
$string['codegenerationmethod_desc'] = 'Vyberte si jednu ze dvou metod generování kódů certifikátů.';
$string['codegenerationmethod_digitshyphens'] = '0123-4567-8901 (Číslice s pomlčkami)';
$string['codegenerationmethod_upperlowerdigits'] = '6aOdbLEuoC (náhodný řetězec malá/velká/číslice)';
$string['copy'] = 'Kopírovat';
$string['coursetimereq'] = 'Požadované minuty v kurzu';
$string['coursetimereq_help'] = 'Zadejte zde minimální čas, v minutách, že student musí být přihlášen do kurzu dříve, než bude moci získat certifikát.';
$string['createtemplate'] = 'Vytvořit šablonu';
$string['customcert:addinstance'] = 'Přidat instanci volitelného certifikátu';
$string['customcert:manage'] = 'Správa volitelného certifikátu';
$string['customcert:manageemailothers'] = 'Spravovat ostatní nastavení emailu';
$string['customcert:manageemailstudents'] = 'Spravovat nastavení emailu studentů';
$string['customcert:manageemailteachers'] = 'Spravovat nastavení emailu učitelů';
$string['customcert:managelanguages'] = 'Spravovat jazyk na editaci formuláři';
$string['customcert:manageprotection'] = 'Spravovat nastavení ochrany';
$string['customcert:managerequiredtime'] = 'Spravovat povinné nastavení času';
$string['customcert:manageverifyany'] = 'Spravovat nastavení verifikace';
$string['customcert:receiveissue'] = 'Obdržet certifikát';
$string['customcert:verifyallcertificates'] = 'Verifikuj všechny certifikáty na stránce';
$string['customcert:verifycertificate'] = 'Verifikuj certifikát';
$string['customcert:view'] = 'Zobraz volitelný certifikát';
$string['customcert:viewallcertificates'] = 'Zobraz všechny certifikáty';
$string['customcert:viewreport'] = 'Zobrazit zprávu o kurzu';
$string['customcertsettings'] = 'Nastavení vlastního certifikátu';
$string['deletecertpage'] = 'Smazat stránku';
$string['deleteconfirm'] = 'Potvrzení smazání';
$string['deleteelement'] = 'Smazat prvek';
$string['deleteelementconfirm'] = 'Opravdu chcete tento prvek smazat?';
$string['deleteissueconfirm'] = 'Opravdu chcete smazat tento vystavený certifikát?';
$string['deleteissuedcertificates'] = 'Smazat vystavené certifikáty';
$string['deletepageconfirm'] = 'Opravdu chcete tuto stránku certifikátu smazat?';
$string['deletetemplateconfirm'] = 'Opravdu chcete tuto šablonu certifikátu smazat?';
$string['deliveryoptiondownload'] = 'Odeslat do prohlížeče a vynutit stažení souboru';
$string['deliveryoptioninline'] = 'Odeslat soubor přímo do prohlížeče';
$string['deliveryoptions'] = 'Možnosti doručení';
$string['description'] = 'Popis';
$string['downloadallissuedcertificates'] = 'Stáhnout všechny vydané certifikáty';
$string['downloadallsitecertificates'] = 'Stáhnout všechny certifikáty webu';
$string['downloadallsitecertificatesdesc'] = 'Tím se stáhnou všechny certifikáty na webu v souboru zip.';
$string['duplicate'] = 'Duplikovat';
$string['duplicateconfirm'] = 'Potvrzení o duplikaci';
$string['duplicatetemplateconfirm'] = 'Opravdu chcete duplikovat tuto šablonu certifikátu?';
$string['editcustomcert'] = 'Upravit certifikát';
$string['editelement'] = 'Upravit prvek';
$string['edittemplate'] = 'Upravit šablonu';
$string['elementheight'] = 'Výška';
$string['elementheight_help'] = 'Určete výšku prvku. Pokud je povolena "0", vypočítá se automaticky.';
$string['elementname'] = 'Jméno prvku';
$string['elementname_help'] = 'Toto bude jméno použito k identifikaci tohoto elementu pokud editujete certifikát. Poznámka: nebude se zobrazovat na výsledném pdf';
$string['elementplugins'] = 'doplňky prvků';
$string['elements'] = 'Prvky';
$string['elements_help'] = 'Toto je seznam prvků, které bude zobrazeny na certifikátu.

Poznámka: Prvku jsou vykresleny v tomto pořadí. Pořadí lze změnit pomocí šipek vedle každého prvku.';
$string['elementwidth'] = 'Šířka';
$string['elementwidth_help'] = 'Určete šířku prvku. Pokud je povolena "0", vypočítá se automaticky.';
$string['emailnonstudentbody'] = 'Připojen je certifikát "{$a->certificatename}" pro "{$a->userfullname}" pro kurz "{$a->coursefullname}".';
$string['emailnonstudentbodyplaintext'] = 'Připojen je certifikát "{$a->certificatename}" pro "{$a->userfullname}" pro kurz "{$a->coursefullname}".';
$string['emailnonstudentcertificatelinktext'] = 'Zobrazení zprávy o certifikátu';
$string['emailnonstudentgreeting'] = 'Ahoj';
$string['emailnonstudentsubject'] = '{$a->coursefullname}: {$a->certificatename}';
$string['emailothers'] = 'Odeslat e-mailem';
$string['emailothers_help'] = 'Je-li nastaveno, odešle e-mail na zde uvedené e-mailové adresy (oddělené čárkou) s kopií certifikátu, jakmile bude k dispozici. <strong>Upozornění:</strong> Nastavením tohoto pole před dokončením vytváření certifikátu odešlete na adresy e-mailem neúplný certifikát.';
$string['emailstudentbody'] = 'Připojen je Váš certifikát "{$a->certificatename}" pro kurz "{$a->coursefullname}".';
$string['emailstudentbodyplaintext'] = 'Připojen je certifikát "{$a->certificatename}" pro "{$a->userfullname}" pro kurz "{$a->coursefullname}".';
$string['emailstudentcertificatelinktext'] = 'Zobrazit certifikát';
$string['emailstudentgreeting'] = 'Milý {$a}';
$string['emailstudents'] = 'E-mail studentů';
$string['emailstudents_help'] = 'Je-li nastaveno, odešle studentům e-mailem kopii certifikátu, jakmile bude k dispozici. <strong>Upozornění:</strong> Nastavení na „Ano“ před dokončením vytváření certifikátu odešle studentovi e-mailem neúplný certifikát.';
$string['emailstudentsubject'] = '{$a->coursefullname}: {$a->certificatename}';
$string['emailteachers'] = 'E-mail učitelů';
$string['emailteachers_help'] = 'Je-li nastaveno, odešle učitelům e-mailem kopii certifikátu, jakmile bude k dispozici. <strong>Upozornění:</strong> Nastavení na „Ano“ před dokončením vytváření certifikátu odešle učiteli e-mailem neúplný certifikát.';
$string['eventelementcreated'] = 'Prvek vlastního certifikátu byl vytvořen';
$string['eventelementdeleted'] = 'Prvek vlastního certifikátu byl odstraněn';
$string['eventelementupdated'] = 'Prvek vlastního certifikátu byl upraven';
$string['eventissuecreated'] = 'Vytvořeno vystavení vlastního certifikátu';
$string['eventissuedeleted'] = 'Odstraněno vystavení vlastního certifikátu';
$string['eventpagecreated'] = 'Stránka vlastního certifikátu byla vytvořena';
$string['eventpagedeleted'] = 'Stránka vlastního certifikátu byla odstraněna';
$string['eventpageupdated'] = 'Stránka vlastního certifikátu byla upravena';
$string['eventtemplatecreated'] = 'Šablona vlastního certifikátu byla vytvořena';
$string['eventtemplatedeleted'] = 'Šablona vlastního certifikátu byla odstraněna';
$string['eventtemplateupdated'] = 'Šablona vlastního certifikátu byla upravena';
$string['exampledatawarning'] = 'Některé z těchto hodnot mohou být jen příkladem pro zajištění polohy prvků.';
$string['font'] = 'Písmo';
$string['font_help'] = 'Písmo použité při generování tohoto elementu.';
$string['fontcolour'] = 'Barva';
$string['fontcolour_help'] = 'Barva písma.';
$string['fontsize'] = 'Velikost';
$string['fontsize_help'] = 'Velikost písma v bodech.';
$string['getcustomcert'] = 'Zobrazit certifikát';
$string['gradeoutcome'] = 'Výsledek';
$string['height'] = 'Výška';
$string['height_help'] = 'Jedná se o výšku certifikátu PDF v mm. Pro referenční kus papíru A4 je výška 297 mm a písmeno je 279 mm vysoké.';
$string['includeinnotvisiblecourses'] = 'Zahrnout certifikáty ve skrytých kurzech';
$string['includeinnotvisiblecourses_desc'] = 'Certifikáty ze skrytých kurzů se ve výchozím nastavení nezpracovávají. Pokud je chcete zahrnout, povolte toto nastavení.';
$string['invalidcode'] = 'Uvedený kód je neplatný';
$string['invalidcolour'] = 'Byla vybrána neplatná barva, zadejte prosím platný název barvy HTML nebo šestimístnou nebo třímístnou hexadecimální barvu.';
$string['invalidelementwidthorheightnotnumber'] = 'Prosím zadejte platné číslo.';
$string['invalidelementwidthorheightzeroallowed'] = 'Zadejte číslo větší nebo rovné 0.';
$string['invalidelementwidthorheightzeronotallowed'] = 'Zadejte číslo větší než 0.';
$string['invalidheight'] = 'Výška musí být platné číslo větší než 0.';
$string['invalidmargin'] = 'Okraj musí mít platné číslo větší než 0.';
$string['invalidposition'] = 'Zvolte prosím kladné číslo pro pozici {$a}.';
$string['invalidwidth'] = 'Šířka musí být platné číslo větší než 0.';
$string['landscape'] = 'Na šířku';
$string['leftmargin'] = 'Levý okraj';
$string['leftmargin_help'] = 'Toto je levý okraj certifikátu PDF v mm.';
$string['listofissues'] = 'Příjemci: {$a}';
$string['load'] = 'Načíst';
$string['loadtemplate'] = 'Načíst šablonu';
$string['loadtemplatemsg'] = 'Opravdu chcete tuto šablonu načíst? Tímto odstraníte všechny existující stránky a elementy tohoto certifikátu.';
$string['managetemplates'] = 'Správa šablon';
$string['managetemplatesdesc'] = 'Tento odkaz vás přenese na novou obrazovku, kde budete moci v spravovat šablony, použité na volitelné certifikáty.';
$string['modify'] = 'Modifikovat';
$string['modulename'] = 'Volitelný certifikát';
$string['modulename_help'] = 'Tento modul umožňuje dynamické generování certifikátů v PDF.';
$string['modulename_link'] = 'Custom_certificate_module';
$string['modulenameplural'] = 'Volitelné certifikáty';
$string['mycertificates'] = 'Moje certifikáty';
$string['mycertificatesdescription'] = 'Jedná se o certifikáty, které jste obdrželi buď e-mailem nebo ručně stahnul.';
$string['name'] = 'Jméno';
$string['nametoolong'] = 'Překročili jste maximální délku povolenou pro název';
$string['nocustomcerts'] = 'K tomuto kurzu nejsou k dispozici žádné certifikáty';
$string['noimage'] = 'Bez obrázku';
$string['norecipients'] = 'Žádní příjemci';
$string['notemplates'] = 'Žádné šablony';
$string['notissued'] = 'Nevystaven';
$string['notverified'] = 'Neověřeno';
$string['numbersuffix_nd_as_in_second'] = 'druhý';
$string['numbersuffix_rd_as_in_third'] = 'třetí';
$string['numbersuffix_st_as_in_first'] = 'první';
$string['options'] = 'Volby';
$string['page'] = 'Strana {$a}';
$string['pluginadministration'] = 'Správa volitelných certifikátů';
$string['pluginname'] = 'Volitelný certifikát';
$string['portrait'] = 'Portrét';
$string['posx'] = 'Poloha v ose X';
$string['posx_help'] = 'Toto je umístění v mm od levého horního rohu, kam chcete, aby byl referenční bod prvku umístěn na ose x.';
$string['posy'] = 'Poloha v ose Y';
$string['posy_help'] = 'Toto je umístění v mm od levého horního rohu, kam chcete, aby byl referenční bod prvku umístěn na ose y.';
$string['preventcopy'] = 'Bránit kopírování';
$string['preventcopy_desc'] = 'Zapnout ochranu proti kopírování';
$string['preventmodify'] = 'Bránit modifikacím';
$string['preventmodify_desc'] = 'Zapnout ochranu proti modifikacím';
$string['preventprint'] = 'Bránit tisknutí';
$string['preventprint_desc'] = 'Zapnout ochranu proti tisknutí';
$string['print'] = 'Tisknout';
$string['privacy:metadata:customcert_issues'] = 'Seznam vydaných certifikátů';
$string['privacy:metadata:customcert_issues:code'] = 'Kód certifikátu';
$string['privacy:metadata:customcert_issues:customcertid'] = 'ID certifikátu';
$string['privacy:metadata:customcert_issues:emailed'] = 'Zda certifikát byl nebo nebyl odeslán e-mailem';
$string['privacy:metadata:customcert_issues:timecreated'] = 'Čas vydání certifikátu';
$string['privacy:metadata:customcert_issues:userid'] = 'ID uživatele, kterému byl certifikát vystaven';
$string['rearrangeelements'] = 'Přeskupit prvky';
$string['rearrangeelementsheading'] = 'Pro změnu pozice prvků na certifikátu je chytněte a přetáhněte.';
$string['receiveddate'] = 'Datum udělení';
$string['refpoint'] = 'Pozice referenčního bodu';
$string['refpoint_help'] = 'Referenční bod je pozice prvku, ze kterého jsou odvozeny jeho souřadnice X a Y. Je znázorněn znaménkem \'+\', které se objeví buď na středu nebo v rozích prvku.';
$string['replacetemplate'] = 'Nahradit';
$string['requiredtimenotmet'] = 'Pro přístup k certifikátu je potřeba strávit v kurzu alespoň {$a->requiredtime} minut.';
$string['rightmargin'] = 'Pravý okraj';
$string['rightmargin_help'] = 'Toto je velikost pravého okraje certifikátu v mm.';
$string['save'] = 'Uložit';
$string['saveandclose'] = 'Uložit a zavřít';
$string['saveandcontinue'] = 'Uložit a pokračovat';
$string['savechanges'] = 'Uložit změny';
$string['savechangespreview'] = 'Uložit změny a prohlédnout';
$string['savetemplate'] = 'Uložit šablonu';
$string['scheduledtaskconfigdesc'] = 'Nakonfigurujte nastavení pro naplánovanou úlohu, která zpracovává certifikáty.';
$string['scheduledtaskconfigheading'] = 'Konfigurace naplánované úlohy';
$string['search:activity'] = 'Volitelný certifikát - informace o aktivitě';
$string['setprotection'] = 'Nastavit ochranu';
$string['setprotection_help'] = 'Vyberte akce, které chcete uživateli zakázat s tímto certifikátem.';
$string['showposxy'] = 'Zobraz pozici X a Y';
$string['showposxy_desc'] = 'Zobrazí pozici X a Y daného prvku při jeho editaci. To umožní uživateli přesně specifikovat polohu prvku.

Toto není vyžadováno, pokud se rozhodnete použít čistě "přetahování prvků" myší.';
$string['subplugintype_customcertelement'] = 'Prvek';
$string['subplugintype_customcertelement_plural'] = 'Prvky';
$string['taskemailcertificate'] = 'Stará se o poslání certifikátu emailem.';
$string['taskissuecertificate'] = 'Úloha vydávání certifikátů';
$string['templatename'] = 'Jméno šablony';
$string['templatenameexists'] = 'Jméno šablony je již používáno, prosím, zvolte jiné.';
$string['topcenter'] = 'Střed';
$string['topleft'] = 'Vlevo nahoře';
$string['topright'] = 'Vpravo nahoře';
$string['type'] = 'Typ';
$string['uploadimage'] = 'Nahrát obrázek';
$string['uploadimagedesc'] = 'Tento odkaz vás přenese na stránku, kde budete schopni nahrát obrázek. Takto nahrané obrázky budou k dispozici všem uživatelům, kteří mohou vytvářet certifikáty.';
$string['useadhoc'] = 'Použít e-mailový certifikát Ad-hoc úkol';
$string['useadhoc_desc'] = 'Pokud je tato možnost povolena, e-maily související s certifikáty budou okamžitě zpracovány prostřednictvím ad-hoc úlohy vytvořené pro každý problém. Když je tato možnost zakázána, e-maily budou spravovány běžnou naplánovanou úlohou.

Povolení této možnosti může zlepšit výkon naplánované úlohy přesunutím zpracování e-mailů na úkoly ad-hoc.';
$string['verified'] = 'Ověřeno';
$string['verify'] = 'Ověřit';
$string['verifyallcertificates'] = 'U všech certifikátů povolit ověření';
$string['verifyallcertificates_desc'] = 'Pokud je nastavení povoleno tak každý uživatel (včetně nepřihlášených) může otevřít odkaz "{$a}" aby zkontroloval jakýkoliv certifikát vydaný touto stránkou, místo toho aby musel přejít na odkaz pro jednotlivé certifikáty.

Poznámka - to platí pouze pro certifikáty, kde "Každý může ověřit certifikát" je nastaveno na "Ano" v nastavení příslušného certifikátu.';
$string['verifycertificate'] = 'Ověřit certifikát';
$string['verifycertificateanyone'] = 'Každý může ověřit certifikát';
$string['verifycertificateanyone_help'] = 'Toto nastavení umožňuje každému (i nepřihlášenému) uživateli, který má odkaz na ověření certifikátu, ověřit certifikát.';
$string['verifycertificatedesc'] = 'Tento odkaz vás přenese na novou obrazovku, kde budete moci ověřit certifikáty na webu';
$string['width'] = 'Šířka';
$string['width_help'] = 'Toto je šířka PDF certifikátu v milimetrech. Pro představu má list papíru A4 210mm na šířku, typ letter má 216mm.';
