<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_certificate', language 'de', version '5.0'.
 *
 * @package     tool_certificate
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcertpage'] = 'Neue Seite';
$string['addelement'] = 'Element hinzufügen';
$string['addelementwithname'] = '\'{$a}\' Element hinzufügen';
$string['after'] = 'Nach';
$string['aissueswerecreated'] = '{$a} Zertifikate sind ausgestellt';
$string['aligncentre'] = 'Zentriert';
$string['alignleft'] = 'Linksbündig';
$string['alignment'] = 'Textausrichtung';
$string['alignment_help'] = 'Die rechtsbündige Ausrichtung des Textes bedeutet, dass sich die Koordinaten eines Elements (Position X und Position Y) auf die obere rechte Ecke des Textfeldes beziehen. Bei zentrierter Ausrichtung beziehen sie sich auf die obere Mitte und bei linksbündiger Ausrichtung auf die obere linke Ecke';
$string['alignright'] = 'Rechtsbündig';
$string['allowfilters'] = 'Erlaubte Filter für den PDF-Inhalt';
$string['allowfilters_desc'] = 'Nur die ausgewählten Filter (falls aktiviert) werden auf die Texte in den Zertifikat-PDFs angewendet';
$string['archived'] = 'Archiviert';
$string['availableincourses'] = 'Verfügbar in darunterliegenden Kursbereichen und Kursen';
$string['availableincourses_help'] = 'Wenn Sie diese Option aktivieren, können Nutzer/innen (mit Austellungsberechtigung) diese Vorlage in allen Kursen des ausgewählten Kursbereiches und in den Kursen der darunter liegenden Kursbereichen verwenden. Wenn diese Option deaktiviert ist, steht diese Vorlage im ausgewählten Kursbereich  ausschließlich Benutzern mit Austellungsberechtigung zur Verfügung.';
$string['certificate'] = 'Zertifikat';
$string['certificate:image'] = 'Zertifikatsbilder verwalten';
$string['certificate:issue'] = 'Zertifikat für Nutzer/innen ausstellen';
$string['certificate:manage'] = 'Zertifikate verwalten';
$string['certificate:verify'] = 'Jedes Zertifikat überprüfen';
$string['certificate:viewallcertificates'] = 'Alle ausgestellten Zertifikate und Vorlagen anzeigen';
$string['certificate_customfield'] = 'Nutzerdefinierte Felder für Zertifikate';
$string['certificatecopy'] = '{$a} (Kopie)';
$string['certificateelement'] = 'Zertifikatselement';
$string['certificateimages'] = 'Zertifikatsbilder';
$string['certificates'] = 'Zertifikate';
$string['certificatesettings'] = 'Zertifikatseinstellungen';
$string['certificatesissues'] = 'Ausgestellte Zertifikate';
$string['certificatetemplate'] = 'Zertifikatsvorlage';
$string['certificatetemplatename'] = 'Name der Zertifikatsvorlage';
$string['certificatetemplates'] = 'Zertifikatsvorlage';
$string['changeelementsequence'] = 'Nach vorn oder hinten setzen';
$string['code'] = 'Code';
$string['codewithlink'] = 'Code mit Link';
$string['coursecategorywithlink'] = 'Kursbereich mit Link';
$string['createtemplate'] = 'Neue Zertifikatsvorlage';
$string['customfield_previewvalue'] = 'Vorschauwert';
$string['customfield_previewvalue_help'] = 'Wert, der bei der Vorschau der Zertifikatsvorlage angezeigt wird';
$string['customfield_visible'] = 'Sichtbar';
$string['customfield_visible_help'] = 'Erlaubt die Auswahl dieses Feldes auf der Zertifikatsvorlage';
$string['customfieldsettings'] = 'Gemeinsame Einstellungen für nutzerdefinierte Felder des Zertifikats';
$string['deleteelement'] = 'Element löschen';
$string['deleteelementconfirm'] = 'Möchten Sie wirklich das Element \'{$a}\' löschen?';
$string['deletepage'] = 'Seite löschen';
$string['deletepageconfirm'] = 'Möchten Sie diese Zertifikatsseite wirklich löschen?';
$string['deletetemplateconfirm'] = 'Möchten Sie wirklich die Zertifikatsvorlage \'{$a}\' und alle zugehörigen Daten löschen? Dieser Vorgang kann nicht rückgängig gemacht werden.';
$string['demotmpl'] = 'Zertifikat-Demovorlage';
$string['demotmplawardedon'] = 'Verliehen am';
$string['demotmplawardedto'] = 'Dieses Zertifikat wurde verliehen an';
$string['demotmplbackground'] = 'Hintergrundbild';
$string['demotmplcoursefullname'] = 'Vollständiger Name des Kurses';
$string['demotmpldirector'] = 'Leiter/in';
$string['demotmplforcompleting'] = 'Für das Abschließen des Kurses';
$string['demotmplissueddate'] = 'Ausstellungsdatum';
$string['demotmplqrcode'] = 'QR-Code';
$string['demotmplsignature'] = 'Unterschrift';
$string['demotmplusername'] = 'Nutzername';
$string['duplicate'] = 'Duplizieren';
$string['duplicatetemplateconfirm'] = 'Möchten Sie die Vorlage \'{$a}\' wirklich duplizieren?';
$string['editcertificate'] = 'Zertifikatsvorlage \'{$a}\' bearbeiten';
$string['editelement'] = '\'{$a}\' bearbeiten';
$string['editelementname'] = 'Name des Elements bearbeiten';
$string['editpage'] = 'Seite {$a} bearbeiten';
$string['edittemplatename'] = 'Namen der Vorlage bearbeiten';
$string['elementname'] = 'Name des Elements';
$string['elementname_help'] = 'Der Name wird verwendet, um dieses Element bei der Bearbeitung eines Zertifikats zu identifizieren. Dieser Name wird nicht im PDF angezeigt.';
$string['elementwidth'] = 'Breite';
$string['elementwidth_help'] = 'Geben Sie die Breite des Elements an. Null (0) bedeutet, dass es keine Beschränkung des Randes gibt.';
$string['entitycertificate'] = 'Zertifikat';
$string['entitycertificateissue'] = 'Zertifikat ausgestellt';
$string['eventcertificateissued'] = 'Zertifikat wurde ausgestellt';
$string['eventcertificaterevoked'] = 'Zertifikat wurde widerrufen';
$string['eventcertificateverified'] = 'Zertifikat wurde überprüft';
$string['eventtemplatecreated'] = 'Vorlage wurde erstellt';
$string['eventtemplatedeleted'] = 'Vorlage wurde gelöscht';
$string['eventtemplateupdated'] = 'Vorlage wurde aktualisiert';
$string['expired'] = 'Abgelaufen';
$string['expiredcertificate'] = 'Dieses Zertifikat ist abgelaufen';
$string['expirydate'] = 'Ablaufdatum';
$string['expirydatetype'] = 'Ablaufdatumstyp';
$string['font'] = 'Schriftart';
$string['font_help'] = 'Die Schriftart, die für die Erstellung dieses Elements verwendet wird.';
$string['fontcolour'] = 'Farbe';
$string['fontcolour_help'] = 'Schriftfarbe';
$string['fontsize'] = 'Schriftgröße';
$string['fontsize_help'] = 'Die Schriftgröße in Punkt.';
$string['hideshow'] = 'Anzeigen/Verbergen';
$string['invalidcolour'] = 'Ungültige Farbe ausgewählt. Tragen Sie bitte einen gültigen HTML-Farbnamen oder einen hexadezimalen Farbcode mit sechs oder mit drei Ziffern ein.';
$string['invalidelementwidth'] = 'Geben Sie bitte eine positive Zahl ein.';
$string['invalidheight'] = 'Die Höhe muss eine gültige Zahl größer als 0 sein.';
$string['invalidmargin'] = 'Der Rand muss eine gültige Zahl größer als 0 sein.';
$string['invalidposition'] = 'Wählen Sie bitte eine positive Zahl für die Position {$a}.';
$string['invalidwidth'] = 'Die Breite muss eine gültige Zahl größer als 0 sein.';
$string['issuecertificates'] = 'Zertifikate ausstellen';
$string['issuedcertificates'] = 'Ausgestellte Zertifikate';
$string['issueddate'] = 'Ausstellungsdatum';
$string['issuelang'] = 'Zertifikate in der Nutzersprache ausstellen';
$string['issuelangdesc'] = 'Auf mehrsprachigen Websites werden die Zertifikate in der Nutzersprache generiert, wenn sich die Nutzersprache von der Website-Sprache unterscheidet. Andernfalls werden alle Zertifikate in der Standardsprache der Website generiert.';
$string['issuenewcertificate'] = 'Zertifikate aus dieser Vorlage ausstellen';
$string['issuenotallowed'] = 'Sie sind nicht berechtigt, neue Zertifikate aus dieser Vorlage auszustellen.';
$string['issueormangenotallowed'] = 'Sie sind nicht berechtigt, neue Zertifikate aus dieser Vorlage auszustellen oder diese Vorlage zu bearbeiten.';
$string['leftmargin'] = 'Linker Rand';
$string['leftmargin_help'] = 'Dies ist der linke Rand des PDF-Zertifikats in Millimetern.';
$string['linkedinorganizationid'] = 'LinkedIn-Organisations-ID';
$string['linkedinorganizationid_desc'] = 'Die ID der LinkedIn-Organisation, die Zertifikate ausstellt.

Wo finde ich meine LinkedIn-Organisations-ID?

1. Melden Sie sich bei LinkedIn als Administrator/in für die Organisationsseite Ihres Unternehmens an
2. Überprüfen Sie die verwendete URL, wenn Sie als Administrator/in angemeldet sind. (Die URL sollte "https://linkedin.com/company/xxxxxxx/admin" ähneln.)
3. Ihre LinkedIn-Organisations-ID ist die siebenstellige Zahl in der URL (im obigen Schritt als „xxxxxxx“ angezeigt)';
$string['manageelementplugins'] = 'Plugins für Zertifikats-Elemente verwalten';
$string['managetemplates'] = 'Zertifikatsvorlagen verwalten';
$string['messageprovider:certificateissued'] = 'Zertifikat erhalten';
$string['milimeter'] = 'mm';
$string['mycertificates'] = 'Meine Zertifikate';
$string['mycertificatesdescription'] = 'Dies sind die Zertifikate, die Sie entweder per E-Mail oder durch manuelles Herunterladen erhalten haben.';
$string['name'] = 'Name';
$string['nametoolong'] = 'Verwenden Sie bitte eine kürzere Bezeichnung.';
$string['never'] = 'Nie';
$string['noimage'] = 'Kein Bild';
$string['noissueswerecreated'] = 'Es wurden keine Zertifikate ausgestellt';
$string['nopermissionform'] = 'Sie haben keine Berechtigung, auf dieses Formular zuzugreifen.';
$string['notificationmsgcertificateissued'] = 'Guten Tag {$a->fullname},<br /><br />Ihr Zertifikat ist verfügbar! Sie finden es hier:
<a href="{$a->url}">Meine Zertifikate</a>';
$string['notificationsubjectcertificateissued'] = 'Ihr Zertifikat ist verfügbar!';
$string['notverified'] = 'Nicht überprüft';
$string['numberofpages'] = 'Seitenanzahl';
$string['oneissuewascreated'] = 'Ein Zertifikat wurde ausgestellt';
$string['page'] = 'Seite {$a}';
$string['pageheight'] = 'Seitenhöhe';
$string['pageheight_help'] = 'Dies ist die Höhe des PDF-Zertifikats in Millimetern. Zur Orientierung: Ein Blatt Papier im DIN-A4-Hochformat ist 297 mm hoch und 210 mm breit.';
$string['pagewidth'] = 'Seitenbreite';
$string['pagewidth_help'] = 'Dies ist die Breite eines PDF Zertifikats im Millimetern. Zur Orientierung: Ein Blatt Papier im DIN-A4-Hochformat ist 210 mm breit und 297 mm hoch.';
$string['pluginname'] = 'Zertifikatsverwaltung';
$string['posx'] = 'Position X';
$string['posx_help'] = 'Dies ist die Position für das Element in mm von der oberen linken Ecke auf der X-Achse';
$string['posy'] = 'Position Y';
$string['posy_help'] = 'Dies ist die Position in mm von der Ecke oben links, an dem die Elemente entlang der Y-Achse ausgerichtet werden sollen.';
$string['privacy:metadata:tool_certificate:issues'] = 'Liste der ausgestellten Zertifikate';
$string['privacy:metadata:tool_certificate_issues:code'] = 'Code für das Zertifikat';
$string['privacy:metadata:tool_certificate_issues:expires'] = 'Datum, an dem das Zertifikat abläuft. 0 wenn es nie ablaufen soll.';
$string['privacy:metadata:tool_certificate_issues:templateid'] = 'Die ID des Zertifikats';
$string['privacy:metadata:tool_certificate_issues:timecreated'] = 'Zeitpunkt, an dem das Zertifikat ausgestellt wurde';
$string['privacy:metadata:tool_certificate_issues:userid'] = 'ID der Person, für die das Zertifikat ausgestellt wurde';
$string['reg_wpcertificates'] = 'Anzahl der Zertifikate ({$a})';
$string['reg_wpcertificatesissues'] = 'Anzahl ausgestellter Zertifikate ({$a})';
$string['regenerate'] = 'Neu ausstellen';
$string['regeneratefileconfirm'] = 'Möchten Sie wirklich das für diese Person ausgestellte Zertifikat neu ausstellen?';
$string['regenerateissuefile'] = 'Zertifikat neu ausstellen';
$string['revoke'] = 'Widerrufen';
$string['revokecertificateconfirm'] = 'Möchten Sie wirklich die Zertifikatsausstellung für diese Person widerrufen?';
$string['rightmargin'] = 'Rechter Rand';
$string['rightmargin_help'] = 'Dies ist der rechte Rand des PDF Zertifikats in mm.';
$string['selectdate'] = 'Datum auswählen';
$string['selectuserstoissuecertificatefor'] = 'Nutzer/innen auswählen, für die ein Zertifikat ausgestellt werden soll';
$string['shared'] = 'Freigegeben';
$string['shareonlinkedin'] = 'Share auf LinkedIn';
$string['show_shareonlinkedin'] = 'Share auf LinkedIn anzeigen';
$string['show_shareonlinkedin_desc'] = 'Wenn der Button "Share auf LinkedIn" auf der Seite "Meine Zertifikate" gezeigt werden soll';
$string['status'] = 'Status';
$string['subplugintype_certificateelement_plural'] = 'Plugins für Zertifikatselemente';
$string['template'] = 'Vorlage';
$string['timecreated'] = 'Austellungszeitpunkt';
$string['uploadimage'] = 'Bild hochladen';
$string['valid'] = 'Gültig';
$string['validcertificate'] = 'Dieses Zertifikat ist gültig';
$string['verified'] = 'Überprüft';
$string['verify'] = 'Überprüfen';
$string['verifycertificates'] = 'Zertifikate überprüfen';
$string['verifynotallowed'] = 'Sie sind nicht berechtigt, Zertifikate zu überprüfen.';
$string['viewcertificate'] = 'Zertifikat anzeigen';
